      PROGRAM  MXDVAC
C---------------------------------------------------------------I
C               Velocity Autocorrelation Function               |
C            using FILE09PV.dat by 'VELOCITY' option            |
C                                                               |
C         First version        by KATS        1990-07-31        |
C         6000 STEPS           by KATS        1991-03-03        |
C         ENHANCED             by Kats        1992-01-28        |
C         Improved             by Kats        1995-07-12        |
C         Further              by Kats        1998-08-20        |
C         Fourier transform    by Kats        1999-08-12        |
C         7 components         by Sakuma      2000-03-11        |
C         Data interval                       2002-05-30        |
C         file09pv.dat format                 2009-10-19        |
C---------------------------------------------------------------I
      PARAMETER  (LNI=06278,LTB=2004, LEL=8, LEM=10,     LCT=500000,
     *                      LSR=1254, LEE=LEL*(LEL+1)/2, L50=LCT/50+1,
     *            LAA= 172, LNV= 971, LEF=LEM*(LEM+1)/2, LST=32,
     *            LAT=LAA*4,LVA=24+LEM*2,                LRG=LNI*3   )
      PARAMETER  (LPO=50002)
C
      COMMON /CHARAC/ TITLE(15),RUNOPT(29),ATOM(LEM),ATMNET(2),
     *                ATMXTL(LAA),FLNAME(19)
        CHARACTER *4  TITLE,ATOM,ATMNET,ATMXTL
        CHARACTER *10 RUNOPT
        CHARACTER *14 FLNAME
C
                    FLNAME(1)  = '02-05-30-00   '
                    FLNAME(2)  = 'V. A. C.      '
C
                    FLNAME(3)  = 'F90           '
C                   FLNAME(3)  = 'Dummy         '
C
                    FLNAME(4)  = '              '
                    FLNAME(5)  = 'file05.dat    '
                    FLNAME(6)  = 'file06.dat    '
                    FLNAME(7)  = 'file07.dat    '
                    FLNAME(8)  = 'file08.dat    '
                    FLNAME(9)  = 'file09p.dat   '
                    FLNAME(10) = 'file10.dat    '
                    FLNAME(11) = 'file09v.dat   '
                    FLNAME(12) = 'file09pv.dat  '
                    FLNAME(13) = '              '
                    FLNAME(14) = 'vac.dat       '
                    FLNAME(15) = '              '
                    FLNAME(19) = 'temp.dat      '
C
      CALL  VCMAIN
      END
C
C
C                                                               ========
C================================================================ VCMAIN
      SUBROUTINE  VCMAIN
      PARAMETER  (LNI=06278,LTB=2004, LEL=8, LEM=10,     LCT=500000,
     *                      LSR=1254, LEE=LEL*(LEL+1)/2, L50=LCT/50+1,
     *            LAA= 172, LNV= 971, LEF=LEM*(LEM+1)/2, LST=32,
     *            LAT=LAA*4,LVA=24+LEM*2,                LRG=LNI*3   )
      PARAMETER  (LPO=50002, lfp=17751)
C
      COMMON /CHARAC/ TITLE(15),RUNOPT(29),ATOM(LEM),ATMNET(2),
     *                ATMXTL(LAA),FLNAME(19)
        CHARACTER *4  TITLE,ATOM,ATMNET,ATMXTL
        CHARACTER *10 RUNOPT
        CHARACTER *14 FLNAME
      COMMON  NJOB(2),NSTEP,NREC,NPOS,NTION,NION(LEL),IONS(2,LEL),
     *        NCOMPO,NRECRD(9),
     *        BOX(6),VO,DENSTY,TEMP,DELTMP,TMPGET,DTIME,SPRES(3)
      COMMON /VAC/ VSS(LPO,LEL), VSSP(3,LPO,LEL),
     *             vss0(lel),    vss0p(3,lel)
      common /ftm/ FK(lfp,lel), F2K(lfp, lel), akayser(lfp)
C
      CALL  F05F07  (dtime, nintv)
                     dtn =dtime*real(nintv)
C
      WRITE (*,1177)  TITLE,NTION,(ATOM(I),NION(I),IONS(1,I),IONS(2,I),
     *                                            I=1,ncompo)
      write (6,1178)  NRECRD(9),nintv,TEMP,DENSTY
 1177 FORMAT (5X,'***  ',15A4,'  ***' /
     *        5X,'Number of ions is',i6,3X,A2,':',I4,I7,'-',I4/
     *        5X,'                 ',   9X,A2,':',I4,I7,'-',I4/
     *        5X,'                 ',   9X,A2,':',I4,I7,'-',I4/
     *        5X,'                 ',   9X,A2,':',I4,I7,'-',I4/
     *        5X,'                 ',   9X,A2,':',I4,I7,'-',I4/
     *        5X,'                 ',   9X,A2,':',I4,I7,'-',I4/
     *        5X,'                 ',   9X,A2,':',I4,I7,'-',I4)
 1178 format(5X,'Number of positions recorded (FILE09PV.DAT) is ',I6,
     *                    '/', i4
     *       /5X,'T=',F7.1,'K    Density=',F7.4,'g/cm3')
c
      nrecrd(9) = nrecrd(9)/nintv
      nlimit    = nrecrd(9)*0.8
      if (nrecrd(9).gt.lpo)  then
            nrecrd(9) = lpo
            nlimit    = lpo * 0.8
      end if
      write (6,1180)  nrecrd(9), nlimit
 1180 format (5x,'Number of positions to be read is      ',i6 /
     *        5x,'Number of positions to be calculated is',i6)
C
C     ------------------------------------------------ Open FILE09PV.DAT
      OPEN  (28, FILE=FLNAME(12),     STATUS='OLD',
     *           ACCESS='SEQUENTIAL', FORM='FORMATTED')
C
C     ------------------------------- Calculate velocity autocorrelation
C
      CALL  VACALC  (NDATA, Nlimit, dtn)
C
      CLOSE (28)
C
C     --------------------------------------- Fourie transform of V.A.C.
C
C      CALL  FOURIER  (NDATA, NLIMIT, IRWLIM, nintv)
C
C     -------------------------------------- Write results on VAC.DAT
      OPEN  (30, FILE=FLNAME(14),     STATUS='UNKNOWN',
     *           ACCESS='SEQUENTIAL', FORM='FORMATTED')
            write (30,'("# Time[ps] vac(atom1) vac(atom2) ... ")')
            DO 400 I = 1, Nlimit
               WRITE (30,1060)  dtn*(real(I-1))*1.e12, 
     *                          (VSS(I,IO),IO=1,ncompo)
  400       CONTINUE
            ENDFILE (30)
            REWIND 30
      CLOSE (30)
 1060 FORMAT(F15.5,8(F15.8,1x))
C
      STOP
      END
C
C
C                                                               ========
C================================================================ VACALC
      SUBROUTINE  VACALC  (NDATA, Nlimit, dtn)
      PARAMETER  (LNI=06278,LTB=2004, LEL=8, LEM=10,     LCT=500000,
     *                      LSR=1254, LEE=LEL*(LEL+1)/2, L50=LCT/50+1,
     *            LAA= 172, LNV= 971, LEF=LEM*(LEM+1)/2, LST=32,
     *            LAT=LAA*4,LVA=24+LEM*2,                LRG=LNI*3   )
      PARAMETER  (LPO=50002, LNJ=200)
C
      COMMON /CHARAC/ TITLE(15),RUNOPT(29),ATOM(LEM),ATMNET(2),
     *                ATMXTL(LAA),FLNAME(19)
        CHARACTER *4  TITLE,ATOM,ATMNET,ATMXTL
        CHARACTER *10 RUNOPT
        CHARACTER *14 FLNAME
      COMMON  NJOB(2),NSTEP,NREC,NPOS,NTION,NION(LEL),IONS(2,LEL),
     *        NCOMPO,NRECRD(9),
     *        BOX(6),VO,DENSTY,TEMP,DELTMP,TMPGET,DTIME,SPRES(3)
      COMMON /VAC/ VSS(LPO,LEL), VSSP(3,LPO,LEL),
     *             vss0(lel),    vss0p(3,lel)
C
      common /work01/ VSIOX(LPO),  VSIOY(LPO),  VSIOZ(LPO),
     *                vxi(lpo),    vyi(lpo),    vzi(lpo)
           real    *8 VSIOX, VSIOY, VSIOZ
      common /work02/ IVX(LPO,LNJ),IVY(LPO,LNJ),IVZ(LPO,LNJ)
           integer *4 ivx,ivy,ivz
C
      REAL      *8  aCOUNT(lpo)
      integer   *4  JVX(LNI), JVY(LNI), JVZ(LNI)
      integer   *4  IYEAR, IMONTH, IDAY,
     *              IHOUR, IMINUT, ISECND, I100TH
C
      write (6,*)  'Enter VACALC'
      A100K  = 1.0 / 50000.0 / 10.0
      A100K2 = A100K * A100K
C     ------------------------------------------------------- Start loop
      DO 700  ION = 1, ncompo
          IF (NION(ION).LE.0)  GO TO 700
              DO 110  IT = 1, LPO
                  VSIOX(IT)  = 0.0
                  VSIOY(IT)  = 0.0
                  VSIOZ(IT)  = 0.0
                  aCOUNT(IT) = 0.0D0
  110         CONTINUE
              CALL  KCLOCK  (IYEAR,IMONTH,IDAY,
     *                       IHOUR,IMINUT,ISECND)
              WRITE (*,1001)  ION,ATOM(ION),NION(ION),IONS(1,ION),
     *                                               IONS(2,ION),
     *                        IHOUR,IMINUT,ISECND
 1001         FORMAT (1X,I5,3X,A2,5X,I5,5X,I5,'-',I4,26X,
     *                   I2,':',I2,':',I2)
C              ---------------------------------------------------------
                                          NIO1 = IONS(1,ION)
C                                         ------------------------------
  200           IF (NIO1.GT.IONS(2,ION))  GO TO 600
                                          NIO2 = NIO1 + LNJ - 1
                IF (NIO2.GT.IONS(2,ION))  NIO2 = IONS(2,ION)
                                          NIO  = NIO2 - NIO1 + 1
                REWIND 28
                NDATA = 0
C               ------------------------ Read velocity data of N-th step
  400           READ (28,8001,END=500)  Nnn
                IF (Nnn.LT.-9990)  GO TO 500
                READ (28,8002,END=500)  (JVX(I),JVY(I),JVZ(I),
     *                                       I=1,NTION)
 8001               FORMAT (I10,i5,A8)
 8002               FORMAT (18I5)
C
                         if (NDATA.ge.LPO)  goto 500
                         NDATA = NDATA + 1
                         II = 0
                         DO 430  I = NIO1, NIO2
                             II = II + 1
                             IVX(NDATA,II) = JVX(I) - 50000
                             IVY(NDATA,II) = JVY(I) - 50000
                             IVZ(NDATA,II) = JVZ(I) - 50000
  430                    CONTINUE
                GO TO 400
C               -------------------------------------------------
  500           NDATA1 = NDATA
                CALL  KCLOCK  (IYEAR,IMONTH,IDAY,
     *                         IHOUR,IMINUT,ISECND)
                WRITE (*,1002)  NIO1,NIO2, NIO, NDATA,
     *                          IHOUR,IMINUT,ISECND
 1002           FORMAT (1X,25X,I5,'-',I4,'   (',I3,')  [',I5,']',9X,
     *                                        I2,':',I2,':',I2)
                DO 590  II = 1, NIO
                    DO 520  N = 1, NDATA
                        VXI(N) = IVX(N,II)
                        VYI(N) = IVY(N,II)
                        VZI(N) = IVZ(N,II)
  520               CONTINUE
                    DO 570  N1 = 1, NDATA
                        VX1 = VXI(N1)
                        VY1 = VYI(N1)
                        VZ1 = VZI(N1)
                        ndata1 = ndata
                        if (ndata1-n1+1.gt.Nlimit) ndata1 = n1+Nlimit-1
                        DO 550  N2 = N1, NDATA1
                            IT  = N2 - N1 + 1
                            VSIOX(IT)  = VSIOX(IT) + VX1 * VXI(N2)
                            VSIOY(IT)  = VSIOY(IT) + VY1 * VYI(N2)
                            VSIOZ(IT)  = VSIOZ(IT) + VZ1 * VZI(N2)
                            aCOUNT(IT) = aCOUNT(IT) + 1.0D0
  550                   CONTINUE
  570               CONTINUE
                    IF (MOD(II,25).EQ.0) THEN
                          CALL  KCLOCK  (IYEAR,IMONTH,IDAY,
     *                                   IHOUR,IMINUT,ISECND)
                          nnnn = nio1 + ii - 1
                          WRITE (*,1006) nnnn, IHOUR,IMINUT,ISECND
 1006                     FORMAT (1X,31X,I4,' (done) ',18X,I2,':',I2,
     *                                                        ':',I2)
                    END IF
  590           CONTINUE
                NIO1 = NIO1 + LNJ
                GO TO 200
C          -------------------------------------------------------------
  600      DO 620  IT = 1, Nlimit
               FACT = A100K2 / aCOUNT(IT)
               VSSP(1,IT,ION) = VSIOX(IT) * FACT
               VSSP(2,IT,ION) = VSIOY(IT) * FACT
               VSSP(3,IT,ION) = VSIOZ(IT) * FACT
               VSS(IT,ION)    = (VSIOX(IT)+VSIOY(IT)+VSIOZ(IT)) * FACT
  620      CONTINUE
c                                                  A^2/step^2 -> cm2/s^2
                        fvac = (1e-8)**2 / (1e-15)**2
                        vss0(ion)   =vss(1,ion) *fvac
                        vss0p(1,ion)=vssp(1,1,ion) *fvac
                        vss0p(2,ion)=vssp(2,1,ion) *fvac
                        vss0p(3,ion)=vssp(3,1,ion) *fvac
                                        aVSS0  = 1.0 / VSS(1,ION)
                                        aVSS0X = 1.0 / VSSP(1,1,ION)
                                        aVSS0Y = 1.0 / VSSP(2,1,ION)
                                        aVSS0Z = 0.0
              IF (VSSP(3,1,ION).NE.0.0) aVSS0Z = 1.0 / VSSP(3,1,ION)
          DO 650  IT = 1, Nlimit
              VSS(IT,ION)    = VSS(IT,ION)    * aVSS0
              VSSP(1,IT,ION) = VSSP(1,IT,ION) * aVSS0X
              VSSP(2,IT,ION) = VSSP(2,IT,ION) * aVSS0Y
              VSSP(3,IT,ION) = VSSP(3,IT,ION) * aVSS0Z
  650     CONTINUE
c          if (ion.eq.1) write (6,*) (vss(i,1),i=1,100)
  700 CONTINUE
C     ------------------------------------------------------ End of loop
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND)
      WRITE (*,1004)  IHOUR,IMINUT,ISECND
 1004 FORMAT (62X,I2,':',I2,':',I2)
C     DO 800  IT = 1, Nlimit
C         WRITE (*,1020) IT-1,(VSS(IT,ION),ION=1,LEL)
C1020     FORMAT (3X,I5,2X,5F12.5)
C 800 CONTINUE
      RETURN
      END
C
C
C                                                               ========
C================================================================ F05F07
      SUBROUTINE  F05F07  (dtime, nintv)
      PARAMETER  (LNI=06278,LTB=2004, LEL=8, LEM=10,     LCT=500000,
     *                      LSR=1254, LEE=LEL*(LEL+1)/2, L50=LCT/50+1,
     *            LAA= 172, LNV= 971, LEF=LEM*(LEM+1)/2, LST=32,
     *            LAT=LAA*4,LVA=24+LEM*2,                LRG=LNI*3   )
C
      COMMON /CHARAC/ TITLE(15),RUNOPT(29),ATOM(LEM),ATMNET(2),
     *                ATMXTL(LAA),FLNAME(19)
        CHARACTER *4  TITLE,ATOM,ATMNET,ATMXTL
        CHARACTER *10 RUNOPT
        CHARACTER *14 FLNAME
      COMMON  NJOB(2),NSTEP,NREC,NPOS,NTION,NION(LEL),IONS(2,LEL),
     *        NCOMPO,NRECRD(9),
     *        BOX(6),VO,DENSTY,TEMP,DELTMP,TMPGET,SPRES(3)
C
C     --------------------------------------------- READ FROM FILE05.DAT
      OPEN ( 5, FILE=FLNAME(5), STATUS='OLD',
     *          ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      READ (5,1001)  RUNOPT(1)
      READ (5,1001)  RUNOPT(2), TITLE
      READ (5,1000)  RUNOPT(3), ALCNT, ANRDF,  ANREC, AINTPV, ADUMMY
      READ (5,1000)  RUNOPT(4), DDT,   FORMUL, RCUT
      READ (5,1000)  RUNOPT(5), TARGT, DELT, SPRES
      READ (5,1000)  RUNOPT(6)
      READ (5,1000)  RUNOPT(7), ALL
      READ (5,1000)  RUNOPT(8)
   20 READ (5,1000,END=9999)  RUNOPT(9), a1,a2,a3,a4
           IF (RUNOPT(9).EQ.'MD......'.OR.
     *         RUNOPT(9).EQ.'XD......')     STOP 9999
           IF (RUNOPT(9).EQ.'VELOCITY') then
                 nintv= a1
                 if (nintv.eq.0)  nintv=1
                 GO TO 30
           end if
      GO TO 20
 1000 FORMAT (A8,2X,6F10.5)
 1001 FORMAT (A8,2X,15A4)
 1002 FORMAT (A8,2X,A8,2X,A8,2X,A8)
C
 9999 STOP 9988
C
C     --------------------------------------------- READ FROM FILE07.DAT
C     ------------------- SYSTEM DESCRIPTION, COORDINATES AND VELOCITIES
   30 OPEN (17, FILE=FLNAME(7), STATUS='OLD',
     *          ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      READ (17,7007) TITLE, NJOB,
     *               NTION, NCOMPO, (NRECRD(I),I=1,9)
      READ (17,7017) (ATOM(I),  I=1,NCOMPO)
      READ (17,7018) (NION(I),  I=1,NCOMPO)
      READ (17,7018) (IONS(1,I),I=1,NCOMPO)
      READ (17,7018) (IONS(2,I),I=1,NCOMPO)
      READ (17,7070) TEMP, DELTMP,TMPGET, SPRES,
     *               DTIME,    BOX,
     *               DENSTY,  VBOX
C                    IF (BOX(4)**2+BOX(5)**2+BOX(6)**2.GT.1.E-6)
C    *                                                        STOP 2222
          NTIOND = 0
C          DO 110  I = 1, NTION
C              IOND(I) = 1
C              READ (17,7700) (P(J,I),J=1,3),DEFECT,(V10(J,I),J=1,3),
C     *                       (P0(J,I),J=1,3)
C              IF (DEFECT.NE.' ') THEN
C                     IOND(I) = 0
C                     NTIOND  = NTIOND + 1
C                     V10(1,I) = 0.0
C                     V10(2,I) = 0.0
C                     V10(3,I) = 0.0
C              END IF
C              DO 105 J = 1, 3
C                  V(J,I) = (V10(J,I)-5.0) * 0.1
C  105         CONTINUE
C  110     CONTINUE
C          IF (NTIOND.GT.0) WRITE (*,7979) NTIOND
C 7979          FORMAT (1X,I6,' DEFECTS WERE DETECTED ')
C          READ (17,7800,END=180,ERR=180)  ((IHISTR(J,I),J=1,4),
C     *                                           I=1,NRECRD(6))
      CLOSE  (17)
C     --------------------------------------- Check number of components
      ncompo = 0
      do 50  io = 1, lel
         if (nion(io).gt.0)  ncompo = io
   50 continue
C
      RETURN
C
 7007 FORMAT (15A4,2I5 / I7,I3, 9I10 )
 7017 FORMAT (10(2X,A4) )
 7018 FORMAT (10I6 )
 7070 FORMAT (F10.2,F10.4,F10.2, 3F10.5 /
     *        E10.3, 10X, 6F10.6 /
     *        F10.6, 10X, 6F10.6 )
 7700 FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.7)
 7800 FORMAT (3(I10,I5,I4,1X,I6))
C
      STOP
      END
C
C
C
C
C                                                               ========
C================================================================ KCLOCK
      SUBROUTINE  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND)
      PARAMETER  (LNI=06278,LTB=2004, LEL=4, LEM=10,     LCT=500000,
     *                      LSR=1254, LEE=LEL*(LEL+1)/2, L50=LCT/50+1,
     *            LAA= 172, LNV= 971, LEF=LEM*(LEM+1)/2, LST=32,
     *            LAT=LAA*4,LVA=24+LEM*2,                LRG=LNI*3   )
C
      COMMON /CHARAC/ TITLE(15),RUNOPT(29),ATOM(LEM),ATMNET(2),
     *                ATMXTL(LAA),FLNAME(19)
        CHARACTER *4  TITLE,ATOM,ATMNET,ATMXTL
        CHARACTER *10 RUNOPT
        CHARACTER *14 FLNAME
C
      INTEGER   *4    IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND
C
  100 IF (FLNAME(3).EQ.'F90           ')  CALL  F90   
     *                                    (IYEAR,IMONTH,IDAY,
     *                                     IHOUR,IMINUT,ISECND)
      IF (FLNAME(3).EQ.'Dummy         ')  THEN
               IYEAR  = 0
               IMONTH = 0
               IDAY   = 0
               IHOUR  = 0
               IMINUT = 0
               ISECND = 0
      END IF
      RETURN
      END
C
C
C                                                             ==========
C==================================================================! F90
       SUBROUTINE  F90  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND)
C      --- Fortran 90 ---
       implicit none
       character date * 8, time * 10, zone *5
       integer*4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND
       integer*4  ia(1:8)
C
       call date_and_time(date, time, zone, ia)
C
       isecnd = ia(7)
       iminut = ia(6)
       ihour  = ia(5)
       iday   = ia(3)
       IMONTH = ia(2)
       iyear  = ia(1)
       RETURN
       End
