#!/bin/sh

# Conversion of file09p.dat to axsf format 

# Usage: ./pos-conv.sh dstep
# dstep: interval of output steps

# Update 2018/Aug/07

awk -v dstep=$1 '
BEGIN {
	pvmult=90000.0
} 
{
	if(FILENAME=="file07.dat") f07[FNR]=$0
	if(FILENAME=="file09p.dat") f09[FNR]=$0
#	if(FNR==1) print FILENAME,FNR,NR,$0
	
}
END {
	ntion=int(substr(f07[2],1,7))
	ncompo=int(substr(f07[2],8,3))
	for(i=1;i<=9;i++){
		ist=11+10*(i-1)
		nrecrd[i]=int(substr(f07[2],ist,10))
	}
#	print ntion,ncompo,nrecrd[1],nrecrd[4]
	for(i=1;i<=ncompo;i++){
		ist=3+6*(i-1)
		atom[i]=substr(f07[3],ist,2)
		#print atom[i]
	}
	for(i=1;i<=ncompo;i++){
		ist=1+6*(i-1)
		ions1[i]=int(substr(f07[5],ist,6))
		ions2[i]=int(substr(f07[6],ist,6))
		#print ions1[i],ions2[i]
	}
	for(io=1;io<=ncompo;io++){
		for(i=ions1[io];i<=ions2[io];i++){
			natom[i]=atom[io]
		}
	}
	nline=ntion/6
	if(ntion%6>0.0) nline=int(nline)+1
	#print nline

	istep=0	
	if(dstep==0) dstep=1
	for(k=1;k<=nrecrd[4];k++){
		if(k==1 || k%dstep<0.00001){
		nn=1+(nline+1)*(k-1)
		nstep=int(substr(f09[nn],1,7))
		h11=substr(f09[nn],11,7)
		h21=substr(f09[nn],18,7)
		h31=substr(f09[nn],25,7)
		h12=substr(f09[nn],32,7)
		h22=substr(f09[nn],39,7)
		h32=substr(f09[nn],46,7)
		h13=substr(f09[nn],53,7)
		h23=substr(f09[nn],60,7)
		h33=substr(f09[nn],67,7)
#print h11,h21,h31,h12,h22,h32,h13,h23,h33,h11*h22*h33
		i=0
		for(mm=1;mm<=nline;mm++){
			nnn=nn+mm
			i=i+1
			pv1[i]=int(substr(f09[nnn],1,5))/pvmult
			pv2[i]=int(substr(f09[nnn],6,5))/pvmult
			pv3[i]=int(substr(f09[nnn],11,5))/pvmult
			if(pv1[i]>1.0)pv1[i]=pv1[i]-1.0
			if(pv1[i]<0.0)pv1[i]=pv1[i]+1.0
			if(pv2[i]>1.0)pv2[i]=pv2[i]-1.0
			if(pv2[i]<0.0)pv2[i]=pv2[i]+1.0
			if(pv3[i]>1.0)pv3[i]=pv3[i]-1.0
			if(pv3[i]<0.0)pv3[i]=pv3[i]+1.0
			q1[i]=h11*pv1[i]+h12*pv2[i]+h13*pv3[i]
			q2[i]=h21*pv1[i]+h22*pv2[i]+h23*pv3[i]
			q3[i]=h31*pv1[i]+h32*pv2[i]+h33*pv3[i]
#
			i=i+1
			pv1[i]=int(substr(f09[nnn],16,5))/pvmult
			pv2[i]=int(substr(f09[nnn],21,5))/pvmult
			pv3[i]=int(substr(f09[nnn],26,5))/pvmult
			if(pv1[i]>1.0)pv1[i]=pv1[i]-1.0
			if(pv1[i]<0.0)pv1[i]=pv1[i]+1.0
			if(pv2[i]>1.0)pv2[i]=pv2[i]-1.0
			if(pv2[i]<0.0)pv2[i]=pv2[i]+1.0
			if(pv3[i]>1.0)pv3[i]=pv3[i]-1.0
			if(pv3[i]<0.0)pv3[i]=pv3[i]+1.0
			q1[i]=h11*pv1[i]+h12*pv2[i]+h13*pv3[i]
			q2[i]=h21*pv1[i]+h22*pv2[i]+h23*pv3[i]
			q3[i]=h31*pv1[i]+h32*pv2[i]+h33*pv3[i]
#
			i=i+1
			pv1[i]=int(substr(f09[nnn],31,5))/pvmult
			pv2[i]=int(substr(f09[nnn],36,5))/pvmult
			pv3[i]=int(substr(f09[nnn],41,5))/pvmult
			if(pv1[i]>1.0)pv1[i]=pv1[i]-1.0
			if(pv1[i]<0.0)pv1[i]=pv1[i]+1.0
			if(pv2[i]>1.0)pv2[i]=pv2[i]-1.0
			if(pv2[i]<0.0)pv2[i]=pv2[i]+1.0
			if(pv3[i]>1.0)pv3[i]=pv3[i]-1.0
			if(pv3[i]<0.0)pv3[i]=pv3[i]+1.0
			q1[i]=h11*pv1[i]+h12*pv2[i]+h13*pv3[i]
			q2[i]=h21*pv1[i]+h22*pv2[i]+h23*pv3[i]
			q3[i]=h31*pv1[i]+h32*pv2[i]+h33*pv3[i]
#
			i=i+1
			pv1[i]=int(substr(f09[nnn],46,5))/pvmult
			pv2[i]=int(substr(f09[nnn],51,5))/pvmult
			pv3[i]=int(substr(f09[nnn],56,5))/pvmult
			if(pv1[i]>1.0)pv1[i]=pv1[i]-1.0
			if(pv1[i]<0.0)pv1[i]=pv1[i]+1.0
			if(pv2[i]>1.0)pv2[i]=pv2[i]-1.0
			if(pv2[i]<0.0)pv2[i]=pv2[i]+1.0
			if(pv3[i]>1.0)pv3[i]=pv3[i]-1.0
			if(pv3[i]<0.0)pv3[i]=pv3[i]+1.0
			q1[i]=h11*pv1[i]+h12*pv2[i]+h13*pv3[i]
			q2[i]=h21*pv1[i]+h22*pv2[i]+h23*pv3[i]
			q3[i]=h31*pv1[i]+h32*pv2[i]+h33*pv3[i]
#
			i=i+1
			pv1[i]=int(substr(f09[nnn],61,5))/pvmult
			pv2[i]=int(substr(f09[nnn],66,5))/pvmult
			pv3[i]=int(substr(f09[nnn],71,5))/pvmult
			if(pv1[i]>1.0)pv1[i]=pv1[i]-1.0
			if(pv1[i]<0.0)pv1[i]=pv1[i]+1.0
			if(pv2[i]>1.0)pv2[i]=pv2[i]-1.0
			if(pv2[i]<0.0)pv2[i]=pv2[i]+1.0
			if(pv3[i]>1.0)pv3[i]=pv3[i]-1.0
			if(pv3[i]<0.0)pv3[i]=pv3[i]+1.0
			q1[i]=h11*pv1[i]+h12*pv2[i]+h13*pv3[i]
			q2[i]=h21*pv1[i]+h22*pv2[i]+h23*pv3[i]
			q3[i]=h31*pv1[i]+h32*pv2[i]+h33*pv3[i]
#
			i=i+1
			pv1[i]=int(substr(f09[nnn],76,5))/pvmult
			pv2[i]=int(substr(f09[nnn],81,5))/pvmult
			pv3[i]=int(substr(f09[nnn],86,5))/pvmult
			if(pv1[i]>1.0)pv1[i]=pv1[i]-1.0
			if(pv1[i]<0.0)pv1[i]=pv1[i]+1.0
			if(pv2[i]>1.0)pv2[i]=pv2[i]-1.0
			if(pv2[i]<0.0)pv2[i]=pv2[i]+1.0
			if(pv3[i]>1.0)pv3[i]=pv3[i]-1.0
			if(pv3[i]<0.0)pv3[i]=pv3[i]+1.0
			q1[i]=h11*pv1[i]+h12*pv2[i]+h13*pv3[i]
			q2[i]=h21*pv1[i]+h22*pv2[i]+h23*pv3[i]
			q3[i]=h31*pv1[i]+h32*pv2[i]+h33*pv3[i]
		}
		istep=istep+1
		printf("%7s %5i\n","PRIMVEC",istep)
		printf("%12.7f   %12.7f   %12.7f\n",h11,h21,h31)
		printf("%12.7f   %12.7f   %12.7f\n",h12,h22,h32)
		printf("%12.7f   %12.7f   %12.7f\n",h13,h23,h33)
		printf("%7s %5i\n","CONVVEC",istep)
		printf("%12.7f   %12.7f   %12.7f\n",h11,h21,h31)
		printf("%12.7f   %12.7f   %12.7f\n",h12,h22,h32)
		printf("%12.7f   %12.7f   %12.7f\n",h13,h23,h33)
		printf("%9s %5i\n","PRIMCOORD",istep)
		printf("%5i %1s\n",ntion,"1")
		for(i=1;i<=ntion;i++){
			printf("%3s   %12.7f %12.7f %12.7f\n",natom[i],q1[i],q2[i],q3[i])
		}
		#print dstep,k%dstep
		}
	}

}
' file07.dat file09p.dat >pos.axsf 
