program posconv
      !
      ! Conversion of file09p.dat to axsf format
      ! Update Feb 5 2020: Change axis
      !
      implicit none
      character*4 TITLE(15),BIN
      character*2 ATOM(20)
      character*10 RUNOPT(51)
      character*1 caxis
      real*4 VAL(64),TEMP,DELTMP,TMPGET,SPRES(3),DTIME,BOX(6),H(3,3)
      real*4 step,dstep,PVMULT,P(3,50000),Q(3,50000)
      real*4 PH(3,3),PP(3,50000)
      integer*4 i,NJOB(2),NRECRD(9),NTION,NCOMPO,IO,istep,idummy,nstep
      integer*4 NION(20),IONS(2,20),NATOM(20),J,K,IPV(3,50000)
      integer*4 nrot
      character*2, parameter::ins(1:56)=(/'H ','He','Li','Be','B ','C ','N ','O ','F ','Ne',&
          'Na','Mg','Al','Si','P ','S ','Cl','Ar',&
          'K ','Ca','Sc','Ti','V ','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr',&
          'Rb','Sr','Y ','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I ','Xe',&
          'Cs','Ba'/)
      character*2, parameter::insup(1:56)=(/'H ','HE','LI','BE','B ','C ','N ','O ','F ','NE',&
          'NA','MG','AL','SI','P ','S ','CL','AR',&
          'K ','CA','SC','TI','V ','CR','MN','FE','CO','NI','CU','ZN','GA','GE','AS','SE','BR','KR',&
          'RB','SR','Y ','ZR','NB','MO','TC','RU','RH','PD','AG','CD','IN','SN','SB','TE','I ','XE',&
          'CS','BA'/)
      !
    nrot=0
300 write(*,'("Change axis? (y,n) >>> ")',advance='no')
    read(*,*)caxis
    if(caxis /= "y" .and. caxis /= "n") goto 300
    if(caxis == "y") then
110    write(*,'("Choose number of rotation")')
       write(*,'("1: a->b, b->c, c->a")')
       write(*,'("2: a->c, b->a, c->b")')
       write(*,'(">>> ")',advance='no')
       read(*,*) nrot
       if(nrot /= 1 .and. nrot /= 2) goto 110
    endif
open (17, file='file07.dat', status='old')
    read(17,'(15A4,2I5)')TITLE,NJOB
    read(17,'(I7,I3,9I10,A4)') NTION,NCOMPO,(NRECRD(i),i=1,9),BIN
    READ (17,'(20(2X,A2,2X))') (ATOM(I),I=1,NCOMPO)
    READ (17,'(20I6)') (NION(I),I=1,NCOMPO)
    READ (17,'(20I6)') (IONS(1,I),I=1,NCOMPO)
    READ (17,'(20I6)') (IONS(2,I),I=1,NCOMPO)
    READ (17,'(F10.2,F10.4,F10.2,3F10.5)') TEMP, DELTMP,TMPGET,(SPRES(I),I=1,3)
    read (17,'(E10.3,A10,6F10.6)') DTIME,  RUNOPT(51), BOX
close(17)
    do I=1,NCOMPO
      NATOM(I) = 0
      do IO=1,56
        if (ATOM(I) == ins(IO)) then
               NATOM(I) = IO
        endif
        if (ATOM(I) == insup(IO)) then
               NATOM(I) = IO
        endif
      enddo
    enddo

    dstep = REAL(NRECRD(1))*DTIME/REAL(NRECRD(4))*1.e12  !ps
    write(*,*) 'time step =',dstep
    step = dstep
    istep = 1
!
    PVMULT = 90000.0
open (19, file='file09p.dat', status='old')
      open (54, file='pos.axsf')
          write(54,'("ANIMSTEPS",1x,I5)')NRECRD(4)
          write(54,'("CRYSTAL")')
          do K = 1, NRECRD(4)
            read(19,'(I7,I3,9F7.3)')nstep, idummy, ((H(J,I),J=1,3),I=1,3)
            read(19,'(18I5)')((IPV(J,I),J=1,3),I=1,NTION) 
            do I = 1, NTION
              do J =1,3
                P(J,I) = REAL(IPV(J,I))/PVMULT
                if (P(J,I) > 1.0) P(J,I) = P(J,I) - 1.0
                if (P(J,I) < 0.0) P(J,I) = P(J,I) + 1.0
              enddo
            enddo
            if(nrot==1) then
              PH(:,:)=H(:,:)
              PP(:,:)=P(:,:)
              H(:,2)=PH(:,1)
              H(:,3)=PH(:,2)
              H(:,1)=PH(:,3)
              P(2,:)=PP(1,:)
              P(3,:)=PP(2,:)
              P(1,:)=PP(3,:)
            endif
            if(nrot==2) then
              PH(:,:)=H(:,:)
              PP(:,:)=P(:,:)
              H(:,3)=PH(:,1)
              H(:,1)=PH(:,2)
              H(:,2)=PH(:,3)
              P(3,:)=PP(1,:)
              P(1,:)=PP(2,:)
              P(2,:)=PP(3,:)
            endif
            do I = 1, NTION
                Q(1,I) = H(1,1)*P(1,I)+H(1,2)*P(2,I)+H(1,3)*P(3,I)
                Q(2,I) = H(2,1)*P(1,I)+H(2,2)*P(2,I)+H(2,3)*P(3,I)
                Q(3,I) = H(3,1)*P(1,I)+H(3,2)*P(2,I)+H(3,3)*P(3,I)
            enddo
            write(54,'("PRIMVEC",i5)')istep
            write(54,'(3(F12.7,3x))') H(1,1),H(2,1),H(3,1)
            write(54,'(3(F12.7,3x))') H(1,2),H(2,2),H(3,2)
            write(54,'(3(F12.7,3x))') H(1,3),H(2,3),H(3,3)
            write(54,'("CONVVEC",i5)')istep
            write(54,'(3(F12.7,3x))') H(1,1),H(2,1),H(3,1)
            write(54,'(3(F12.7,3x))') H(1,2),H(2,2),H(3,2)
            write(54,'(3(F12.7,3x))') H(1,3),H(2,3),H(3,3)
            write(54,'("PRIMCOORD",i5)')istep
            write(54,'(i5,1x,"1")')NTION
            do IO =1, NCOMPO
              do I = IONS(1,IO),IONS(2,IO)
                write(54,'(i3,3x,3(F12.7,1x))')NATOM(IO),Q(1,I),Q(2,I),Q(3,I)
              enddo
            enddo
            istep = istep + 1
          enddo
    continue
close (19)
close (54)

end program

