!     Last update is  Nov. 20 2018
!***********************************************************************
!**   Program  pcfrcn.f90                                             **
!**                                                                   **
!**            Calculate pcf and rcn of atoms                         **
!**            MXDORTO and MXDTRICL                                   **
!**                                                                   **
!**            using  file05.dat                                      **
!**                   file07.dat                                      **
!**                   file09p.dat                                     **
!**                                                                   **
!**                                       Hiroshi SAKUMA              **
!**                                           Aug 01 2017             **
!**                                                                   **
!**      First version                                  Aug.   01 2017**
!**      Triclinic                                      Nov.   19 2018**
!**      Average for elements                           Nov.   20 2018**
!***********************************************************************
      module param
        implicit none
        integer(KIND=4),parameter :: LNI=80000,LEM=20,LEL=20
        integer(KIND=4), parameter :: LNF=20
        double precision, parameter :: PI = 3.141592d0
      end module
      module f05da1
        use param, only : LEM,LNI
        implicit none
        integer(KIND=4)  nfile
        double precision IRECRD(9),ZI(LEM),WI(LEM),DTIME5,PVMULT,ZII(LNI)
        real  RUN(12)
        character(LEN=10):: RUNOPT(52),RUNRUN
        character*100 pfile(10)
      end module
      module tdipo
        use param, only : LNI,LEM
        implicit none
        integer(KIND=4) IONS(2,LEM),NION(LEM),ih2o(5,LNI),nd,idismax
        integer(KIND=4):: ndis(LEM,0:10000)
        integer*4 icenter,ielem,imode
        double precision  BOX(6),P(3,LNI),QR(3,LNI),RD,rdiv
        double precision, allocatable :: timps(:)
      end module
      module conf
        implicit none
      end module
      module f07da1
        use param, only : LEM, LNF
        implicit none
        integer(KIND=4)  NTION,NCOMPO,ifomerr,NJOB(2),NRECRD(9),ICD,nstep,icstep
        integer(KIND=4) fNRECRD(LNF,9)
        double precision DELTMP,TMPGET,SPRES(3),DTIME,DENSTY,VBOX(6)
        double precision TEMP,Msq,MeanV
        character(LEN=4):: TITLE(15),ATOM(LEM)
      end module
      module cartes
        use param, only : LNI
        implicit none
        double precision H(3,3),HINV(3,3),RBOX(6),G(3,3),GINV(3,3)
        double precision TRANSX(8),TRANSY(8),TRANSZ(8),Q(3,LNI),Q0(3,LNI)
      end module
      module cry
        implicit none
        double precision sina(3),cosa(3),vol
        character(LEN=7):: cryst
      end module
!
      PROGRAM PCFRCN
        use param
        use f05da1
        use f07da1
        use tdipo
        use conf
        implicit none
        integer(KIND=4)  k,jf,i,j,io,iio
        character*1 ans
        character*50 fnamepcf,fnamercn
        character*5 ccen
        double precision div,dist,pcf(LEM),rcn(LEM)
!
!     -------------------------------------------------------------------
!     -------Calculate pcf and rcn of selected atom                      
!     -------------------------------------------------------------------
!
      nfile = 1
      pfile(1) = './'
      write(*,'("Only use of files in this directry?(y,n)")',advance='no')
      read(*,*) ans
      if (ans == 'n' .or. ans == 'N') then              
        write(*,'("Reading input.txt")')
        open (90, file ='input.txt', status='old', &
              access='sequential', form='formatted')
          read(90,*) nfile
          do i = 1, nfile
            read(90,'(a100)') pfile(i)
            write(*,'(i3, "-th file path: ", a100)') i,pfile(i)
          enddo
        close(90)
      endif
!
!     ----------------------------------------------------------------
      do jf = 1,nfile
        CALL F07(jf)
        CALL F05(jf)
        if (jf == 1) CALL CONFIR
      enddo
      write(*,'("Main Program started")')
      CALL MAIN 
!     -------------------End of calculations------------------------
      div = 4.0*pi*rdiv
      iio=1
      rcn(:) = 0.0d0
      if (imode == 1) then
        fnamepcf = 'pcf-'//trim(atom(ielem))//'ave.dat'
        fnamercn = 'rcn-'//trim(atom(ielem))//'ave.dat'
      endif
      if (imode == 2) then
        do io = 1, ncompo
          if (icenter > ions(2,io)) iio = io+1
        enddo
        write(ccen,'(i5.5)')icenter
        fnamepcf = 'pcf-'//trim(atom(iio))//ccen//'.dat'
        fnamercn = 'rcn-'//trim(atom(iio))//ccen//'.dat'
      endif
      OPEN (36, FILE=trim(fnamepcf),STATUS='unknown')
      OPEN (37, FILE=trim(fnamercn),STATUS='unknown')
         if(imode == 1) then
            write(36,'("# r [Ang.]",6x,A2,"-",A2, 9(1x,6x," -",A2))')atom(ielem),((atom(io)),io=1,ncompo) 
            write(37,'("# r [Ang.]",6x,A2,"-",A2, 9(1x,6x," -",A2))')atom(ielem),((atom(io)),io=1,ncompo) 
            do j = 1, idismax+1
               dist = rdiv*(dble(j)-0.5d0)
               do io = 1,ncompo
                 pcf(io) = (ndis(io,j-1)/(div*dist**2))/dble(NRECRD(4)*NION(ielem))
                 rcn(io) = rcn(io) + (ndis(io,j-1))/dble(NRECRD(4)*NION(ielem))
               enddo
               write(36,'(f10.4,1x,10(f10.4,1x))')dist,((pcf(io)),io=1,ncompo)
               write(37,'(f10.4,1x,10(f10.4,1x))')dist,((rcn(io)),io=1,ncompo)
!               write(*,*)dist,((rcn(io)),io=1,ncompo)
            enddo
         endif
         if(imode == 2) then
            write(36,'("# r [Ang.]",3x,i5,"-",A2, 9(1x,6x," -",A2))')icenter,((atom(io)),io=1,ncompo) 
            write(37,'("# r [Ang.]",3x,i5,"-",A2, 9(1x,6x," -",A2))')icenter,((atom(io)),io=1,ncompo) 
            if (idismax > 10000) idismax = 10000
            do j = 1, idismax+1
               dist = rdiv*(dble(j)-0.5d0)
               do io = 1,ncompo
                 pcf(io) = (ndis(io,j-1)/(div*dist**2))/dble(NRECRD(4))
                 rcn(io) = rcn(io) + (ndis(io,j-1))/dble(NRECRD(4))
               enddo
               write(36,'(f10.4,1x,10(f10.4,1x))')dist,((pcf(io)),io=1,ncompo)
               write(37,'(f10.4,1x,10(f10.4,1x))')dist,((rcn(io)),io=1,ncompo)
!               write(*,*)dist,((rcn(io)),io=1,ncompo)
            enddo
         endif
      close(36)
      close(37)
! 
      STOP
      END
!
!===================================================================
!==================================================subroutine F07
      subroutine f07(jf)
!                                                   Read from FILE07.DAT
!                         system description, coordinates and velocities
      use param
      use f05da1
      use tdipo
      use conf
      use f07da1
      use cartes
      implicit none
!
      integer(KIND=4) iform7,jf
      integer(KIND=4) i,j,io,ntiond,nnn,ndmole
      integer(KIND=4) fNTION(LNF),fNCOMPO(LNF),fNION(LNF,LEM),fIONS(LNF,2,LEM)
      character*1   FOMERR,defect,ans
      character*4  bin,fATOM(LNF,LEM)
      double precision    V10(3,LNI),P0(3,LNI),STEMP,VSTEMP
      integer(KIND=4) IHISTR(4,111),IOND(LNI),in(LNI)
!
      if (jf == 1) then
         do i = 1,9
           NRECRD(i) = 0
         enddo
      endif
!
      iform7 = 0
        OPEN (17, FILE=trim(pfile(jf))//'file07.dat', STATUS='OLD', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
        READ (17,7007) TITLE, NJOB, BIN, ICD, ndmole, RD, &
                     fNTION(jf), fNCOMPO(jf), (fNRECRD(jf,I),I=1,9)
!
        IF (fNRECRD(jf,4) == 0) THEN
   10     WRITE(*,*)'NRECRD(4) read error! Read from file05.dat ? (y,n)'
          READ (*,*)FOMERR
          if (FOMERR == 'y' .OR. FOMERR == 'Y') then 
            ifomerr = 1
          elseif (fomerr == 'n' .or. fomerr == 'N') then
            stop
          else 
            goto 10
          endif
        ENDIF
                            RUNOPT(18) = '          '
        IF (BIN == 'BIN ')  RUNOPT(18) = 'BINARY    '
!
      READ (17,'(20(2X,A4))') (fATOM(jf,I),I=1,fNCOMPO(jf))
      READ (17,'(20I6)') (fNION(jf,I),I=1,fNCOMPO(jf))
      READ (17,'(20I6)') (fIONS(jf,1,I),I=1,fNCOMPO(jf))
      READ (17,'(20I6)') (fIONS(jf,2,I),I=1,fNCOMPO(jf))
      READ (17,7070) TEMP, DELTMP,TMPGET, SPRES, &
                     DTIME,  RUNOPT(51),  BOX, &
                     DENSTY, RUNOPT(52), VBOX 
      IF (RUNOPT(51) == 'THERMOSTAT')  READ (17,'(10X,3F20.10)') STEMP, VSTEMP
      IF (RUNOPT(52) == 'H-TENSOR  ')  THEN
                  DO I = 1, 3
                      READ (17,'(10X,3F20.10)')  (H(I,J),J=1,3)
                  enddo
      END IF
      if (jf > 1) then
        if (fNTION(jf) /= fNTION(jf-1)) stop "Error, inconsistent NTION among files"
        if (fNCOMPO(jf) /= fNCOMPO(jf-1)) stop "Error, inconsistent NCOMPO among files"
        do i = 1, fncompo(1)
          if (fATOM(jf,i) /= fATOM(jf-1,i)) stop "Error, inconsistent ATOM among files"
          if (fNION(jf,i) /= fNION(jf-1,i)) stop "Error, inconsistent NION among files"
          if (fIONS(jf,1,i) /= fIONS(jf-1,1,i)) stop "Error, inconsistent IONS1 among files"
          if (fIONS(jf,2,i) /= fIONS(jf-1,2,i)) stop "Error, inconsistent IONS2 among files"
        enddo
      endif
      do i = 1, 9
        NRECRD(i) = NRECRD(i) + fNRECRD(jf,i)
      enddo
      if (jf == 1) then
        NTION = fNTION(1)
        NCOMPO = fNCOMPO(1)
        do i = 1,ncompo
          ATOM(i) = fATOM(1,I)
          NION(i) = fNION(1,I)
          IONS(1,i) = fions(1,1,i)
          IONS(2,i) = fions(1,2,i)
        enddo
      endif
! -----------------------------------------------------------------------------
      if (jf == nfile) then
        NNN = NRECRD(4)
        allocate(timps(NNN))
      endif
! -----------------------------------------------------------------------------
 7007 FORMAT (15A4,2I5, 1X,A4,1X,I4,1X,I9,1x,f9.6/ I7,I3, 9I10)
! 7007 FORMAT (15A4,2I5 / I7,I3, 3I10,5I5,I10,A4)
 7070 FORMAT (D10.2,D10.4,D10.2, 3D10.5 / &
              E10.3, A10, 6D10.6 /  &
              D10.6, A10, 6D10.6 ) 
      RETURN
!  261   stop 'error to read charge.dat'
      END
!===================================================================
!==================================================subroutine F05
      subroutine F05(jf)
      use param
      use f05da1
      use f07da1
      implicit none
!
      INTEGER(KIND=4)  ij,n,i,jf
      integer(KIND=4)  ip,jp,kp,ijkl,fIRECRD(LNF,9)
      double precision    param1,param2,param3,param4,param5,param6
      double precision    dm3ij(LEM),be3ij(LEM),r03ij(LEM),fDTIME5(LNF),fPVMULT(LNF)
      CHARACTER(LEN=1):: ATY,Ins1
      CHARACTER(LEN=2):: ATOM5(LEM),insIP,insJP,insKP
!  --------------------------------------------- READ FROM FILE05.DAT
      OPEN (15, FILE=trim(pfile(jf))//'file05.dat',    STATUS='OLD', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
          READ (15,'(A8,2X,15A4)')  RUN(1)
          READ (15,'(A8,2X,15A4)')  RUN(2),TITLE
          READ (15,'(A8,2X,5F10.2)')  RUN(3),IRECRD(1),IRECRD(2),IRECRD(3), &
                          IRECRD(4),IRECRD(5)
          IF (ifomerr == 1) THEN 
            NRECRD(4) = INT(IRECRD(1)/IRECRD(4))
            WRITE(*,*)'NRECRD(4) from file05 = ',NRECRD(4)
          ENDIF
          READ (15,'(A10,F10.5)')  RUN(4),fDTIME5(jf)
          if (jf > 1) then
            if (fDTIME5(jf) /= fDTIME5(jf-1)) stop "Error, inconsistent DTIME"
          endif         
          READ (15,'(A8,2X,6F10.5)')  RUN(5)
          READ (15,'(A8,2X,6F10.5)')  RUN(6)
          READ (15,'(A8,2X,6F10.5)')  RUN(7)
          READ (15,'(A10, 6F10.5)')  RUNOPT(8)
          DO n=1,LEM
             READ (15,'(A1,A1,A2,6X,F10.3,F10.3)')  Ins1,ATY,atom5(n),ZI(n),WI(n)
             IF (atom5(n)  ==  '   ') EXIT     
!             WRITE(*,'(A1,A1,A2,6X,F10.3,F10.3)')Ins1,ATY,atom5(n),ZI(n),WI(n) 
          ENDDO   
!
        if(jf == 1) then
           IRECRD(9) = fIRECRD(1,9)
           PVMULT = fPVMULT(1)
           DTIME5 = fDTIME5(1)
        endif
!
      CLOSE (15)
      RETURN
      END
!===================================================================
!==================================================subroutine CONFIR
      subroutine confir
!     -------Confirmation of MD conditions--------------------------
      use param
      use f05da1
      use tdipo
      use conf
      use f07da1
      implicit none
!
      double precision   rmin
      integer io
!
!     -------------------------------------------------------------
1710  write(*,'("Select definition of central atom: 1:element or 2: specified atom >>> ")',advance='no')
      read(*,*) imode
      if (imode /= 1 .and. imode /= 2) goto 1710
      if (imode == 1) then
        do io = 1,ncompo
          write(*,'(i3, ":", a4)')io,atom(io)
        enddo
1713    write(*,'("Type the index of element for the center >>> ")', advance ='no')
        read (*,*) ielem
        if(ielem < 1 .or. ielem > ncompo) goto 1713
      endif
      if (imode == 2) then
1711    do io = 1,ncompo
          write(*,'(a4, ", index = ",i5,"-",i5)')atom(io),ions(1,io),ions(2,io)
        enddo
        write(*,'("Type the index of atom for the center >>> ")', advance ='no')
        read (*,*) icenter
        if (icenter < 1 .or. icenter > ntion) goto 1711
      endif
!
      RMIN = dble(IRECRD(4))*DTIME5/1000.D0      
      WRITE(*,'("Time increment : ",e9.4, " ps")') RMIN
!
      RETURN
      END
!===================================================================
!==================================================subroutine MAIN
      subroutine MAIN
      use param
      use f05da1
      use tdipo
      use conf
      use f07da1
      use cartes
      implicit none
!
      INTEGER (KIND=4)   IP(3,LNI),L,nax
      INTEGER(KIND=4)  NNN
      integer(KIND=4)  jr,lpos,i,j,jf,NSTEPAL
      double precision   A9000
      CHARACTER(LEN=7):: CHAR
!     --------------------------------------------------------------
      jr=0
      NSTEPAL = 0
      NNN=NRECRD(4)
!
!     -----------------------------read File09p.dat 
      A9000 = 1.0D0 / 90000.0D0
     do jf = 1, nfile
      open (19, file=trim(pfile(jf))//'file09p.dat', status='old', &
                access='sequential', form='formatted' )
!
      write(*,*) 'NRECRD(4)=',NRECRD(4)
      LPOS = 0 
      do 500 L=1, fNRECRD(jf,4)
        NSTEPAL = NSTEPAL + 1
        IF (LPOS == 99999) read(19,'(A7,3X,9F7.3)') CHAR,((H(J,I),J=1,3),I=1,3)
        IF (LPOS < 99999) read(19,'(I7,3X,9F7.3)') LPOS,((H(J,I),J=1,3),I=1,3)
!        CALL TMATRX(1)
        read  (19,'(18I5)',err=499) ((IP(J,I),J=1,3),I=1,NTION)
        do I = 1, NTION
          do J = 1, 3
            P(J,I) = FLOAT(IP(J,I))*A9000
          enddo
        enddo
!
        timps(NSTEPAL) = DTIME5*dble(IRECRD(4))*dble(NSTEPAL-1)*0.001D0
        jr=jr+1
!         ----------------------------------------------------------
        call pcf 
  500 enddo
      close(19)
    enddo
    close(36)
!
      RETURN
 499  write(*,*)"Error reading in file09p.dat, step = ",L
      write(*,*)"Step = ", L
      write(*,*)"Nion = ", I
      write(*,*)"J = ",J
      write(*,*)IP(J-1,I-1)
      write(*,*)IP(J,I)
      stop 
      END
!===================================================================
!==================================================subroutine pcf   
      subroutine  pcf 
!     -------Caluculate pair correlation function                    
      use param
      use f05da1
      use f07da1
      use tdipo
      use conf
      use cartes
      implicit none
!
      double precision dx,dy,dz,dis 
      integer(KIND=4)  idis,io,c,j
!
      rdiv = 0.01 !Angstrom
!
      if (imode == 1) then
!     ielem : center is element
        do c = ions(1,ielem), ions(2,ielem)
          do io = 1, ncompo  
            do j =ions(1,io) , ions(2,io)
              if (c == j) cycle
              dx = P(1,c) - P(1,j)
              dy = P(2,c) - P(2,j)
              dz = P(3,c) - P(3,j)
              if (dx > 0.5)  dx = dx - 1.0D0
              if (dx < -0.5) dx = dx + 1.0D0
              if (dy > 0.5)  dy = dy - 1.0D0
              if (dy < -0.5) dy = dy + 1.0D0
              if (dz > 0.5)  dz = dz - 1.0D0
              if (dz < -0.5) dz = dz + 1.0D0
!              dis = sqrt((dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2)
              Q(1,c)=dx
              Q(2,c)=dy
              Q(3,c)=dz
              call PTOXYZ(c)
              dis= sqrt(Q(1,c)**2+Q(2,c)**2+Q(3,c)**2)
              idis = INT(dis/rdiv)
              if (idis > idismax) idismax = idis
              if (idis < 10000) then
                ndis(io,idis) = ndis(io,idis) + 1
              endif
            enddo
          enddo
        enddo
      endif
      if (imode == 2) then
!     icenter : center is an atom
        do io = 1, ncompo  
          do j =ions(1,io) , ions(2,io)
            if ( j == icenter ) cycle
            c = icenter
            dx = P(1,c) - P(1,j)
            dy = P(2,c) - P(2,j)
            dz = P(3,c) - P(3,j)
            if (dx > 0.5)  dx = dx - 1.0D0
            if (dx < -0.5) dx = dx + 1.0D0
            if (dy > 0.5)  dy = dy - 1.0D0
            if (dy < -0.5) dy = dy + 1.0D0
            if (dz > 0.5)  dz = dz - 1.0D0
            if (dz < -0.5) dz = dz + 1.0D0
!            dis = sqrt((dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2)
            Q(1,c)=dx
            Q(2,c)=dy
            Q(3,c)=dz
            call PTOXYZ(c)
            dis= sqrt(Q(1,c)**2+Q(2,c)**2+Q(3,c)**2)
            idis = INT(dis/rdiv)
            if (idis > idismax) idismax = idis
            if (idis < 10000) then
              ndis(io,idis) = ndis(io,idis) + 1
            endif
          enddo
        enddo
      endif
      return
      end
!                                                               ========
!================================================================ TMATRX
      SUBROUTINE  TMATRX (IDX)
      use param
      use tdipo
      use cartes
      use cry
      implicit none
!
      integer(4)   idx,n,i,j,k,K1,K2
      double precision   DET, GG, BOXIJ
!
!
!     -- (0,0,0),(1,0,0),(0,1,0),(0,0,1),(1,1,0),(1,0,1),(0,1,1),(1,1,1)
!
      N = 0
      DO 12 I = 0, 1
        DO 11 J = 0, 1
          DO 10 K = 0, 1
                 N = N + 1
                 TRANSX(N) = DBLE(I)
                 TRANSY(N) = DBLE(J)
                 TRANSZ(N) = DBLE(K)
   10     CONTINUE
   11   continue
   12 continue
!
      IF (IDX /= 0)  THEN
             DO 50  I = 1, 3
                 BOX(I) = SQRT(H(1,I)**2 + H(2,I)**2 + H(3,I)**2)
   50        CONTINUE
             DO 68  I = 1, 3
                 K1 = 2
                 K2 = 3
                 IF (I == 2)  THEN
                       K1 = 1
                       K2 = 3
                 ELSE IF (I == 3)  THEN
                       K1 = 1
                       K2 = 2
                 END IF
                 BOXIJ= H(1,K1)*H(1,K2)+H(2,K1)*H(2,K2)+H(3,K1)*H(3,K2)
                 COSA(I) = BOXIJ / (BOX(K1)*BOX(K2))
                 BOX(I+3) = COSA(I)
                 SINA(I) = SQRT(1.0D0 - COSA(I)**2)
   68        CONTINUE
             VOL = H(3,1)*(H(1,2)*H(2,3) - H(2,2)*H(1,3)) - &
                   H(2,1)*(H(1,2)*H(3,3) - H(3,2)*H(1,3)) + &
                   H(1,1)*(H(2,2)*H(3,3) - H(3,2)*H(2,3))
             IF (VOL <= 0.0D0)  THEN
                   H(1,1) = - H(1,1)
                   H(2,1) = - H(2,1)
                   H(3,1) = - H(3,1)
                   VOL    = - VOL
             END IF
             GO TO 150
      END IF
!
!     ---------------------------- cos and sin of alpha, beta, and gamma
      DO 120  I = 1, 3
          COSA(I) = BOX(I+3)
          IF (BOX(I+3) > 1.0)  THEN
               COSA(I) = COS(BOX(I+3)*PI/180.0D0)
               BOX(I+3) = COSA(I)
          END IF
          SINA(I) = SQRT(1.0D0 - COSA(I)**2)
  120 CONTINUE
      CRYST = 'ORTHO  '
      IF (COSA(2)  /=  0.0 )  CRYST = 'MONOCLI'
!
!     ------------------ Transformation matrix from crystal to Cartesian
!
      H(1,3) =  0.0D0
      H(2,3) =  0.0D0
      H(3,3) =  BOX(3)
      H(1,2) =  0.0D0
      H(2,2) =  BOX(2)*SINA(1)
      H(3,2) =  BOX(2)*COSA(1)
      H(3,1) =  BOX(1)*COSA(2)
!c    H(2,1) =  BOX(1)*COSA(3)*SINA(1)
!c    H(1,1) =  BOX(1)*SQRT(1.0D0-COSA(2)**2-(COSA(3)*SINA(1))**2)
      H(2,1) = -BOX(1)*(COSA(1)*COSA(2)-COSA(3))/SINA(1)
      H(1,1) = BOX(1)*SQRT(1-COSA(1)**2-COSA(2)**2-COSA(3)**2+ &
                                 2*COSA(1)*COSA(2)*COSA(3))/SINA(1)
              VOL = H(3,1)*(H(1,2)*H(2,3) - H(2,2)*H(1,3)) - &
                    H(2,1)*(H(1,2)*H(3,3) - H(3,2)*H(1,3)) + &
                    H(1,1)*(H(2,2)*H(3,3) - H(3,2)*H(2,3))
              IF (VOL <= 0.0D0)  THEN
                      H(1,1) = - H(1,1)
                      H(2,1) = - H(2,1)
                      H(3,1) = - H(3,1)
                      VOL    = - VOL
              END IF
!
!             WRITE (*,*)  H(1,1), H(2,1), H(3,1)
!             WRITE (*,*)  H(1,2), H(2,2), H(3,2)
!             WRITE (*,*)  H(1,3), H(2,3), H(3,3)
!             WRITE (*,*)  VOL
!
!     ------------------ Transformation matrix from Cartesian to crystal
!
  150 CALL  INVERS  (H, DET, HINV)
!
      RETURN
      END
!
!
!                                                               ========
!================================================================ PTOXYZ
!
      SUBROUTINE  PTOXYZ (J)
      use tdipo
      use cartes
      implicit none
!
      integer(4)   j
      double precision   PX,PY,PZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CRYSTAL TO CARTESIAN (X,Y,Z)
!
                  PX = Q(1,J)
                  PY = Q(2,J)
                  PZ = Q(3,J)
          Q(1,J)  = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
          Q(2,J)  = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
          Q(3,J)  = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
      RETURN
      END
!                                                               ========
!================================================================ XYZTOP
!
      SUBROUTINE  XYZTOP (J)
      use cartes
      implicit none
!
      integer(4) J
      double precision QX,QY,QZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CARTESIAN (X,Y,Z) TO CRYSTAL
!
               QX = Q(1,J)
               QY = Q(2,J)
               QZ = Q(3,J)
          Q(1,J)  = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
          Q(2,J)  = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
          Q(3,J)  = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
!
               QX = Q0(1,J)
               QY = Q0(2,J)
               QZ = Q0(3,J)
          Q0(1,J) = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
          Q0(2,J) = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
          Q0(3,J) = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
      RETURN
      END
!                                                               ========
!================================================================ INVERS
      SUBROUTINE  INVERS  (X, DET, XINV)
!     -------------------------------------------- Given 3 by 3 matrix X
!                             Store determinant at D and inverse at Xinv
!
      implicit none
      double precision  DET, X(3,3), XINV(3,3)
!
      DET = X(1,1)*X(2,2)*X(3,3) + X(1,2)*X(2,3)*X(3,1) + &
            X(1,3)*X(2,1)*X(3,2) - X(1,3)*X(2,2)*X(3,1) - &
            X(1,2)*X(2,1)*X(3,3) - X(1,1)*X(2,3)*X(3,2)
      IF (DET == 0.0D0)  GO TO 10
         XINV(1,1) = (X(2,2)*X(3,3) - X(3,2)*X(2,3)) / DET
         XINV(1,2) = (X(3,2)*X(1,3) - X(1,2)*X(3,3)) / DET
         XINV(1,3) = (X(1,2)*X(2,3) - X(2,2)*X(1,3)) / DET
         XINV(2,1) = (X(2,3)*X(3,1) - X(3,3)*X(2,1)) / DET
         XINV(2,2) = (X(3,3)*X(1,1) - X(1,3)*X(3,1)) / DET
         XINV(2,3) = (X(1,3)*X(2,1) - X(2,3)*X(1,1)) / DET
         XINV(3,1) = (X(2,1)*X(3,2) - X(3,1)*X(2,2)) / DET
         XINV(3,2) = (X(3,1)*X(1,2) - X(1,1)*X(3,2)) / DET
         XINV(3,3) = (X(1,1)*X(2,2) - X(2,1)*X(1,2)) / DET
      RETURN
!     --------------------------------------------- TEST FOR SINGULARITY
  10         IF (DET == 0)  WRITE  (*,6180)
6180         FORMAT(5X,'*** The matrix is singular ***')
      RETURN
      END
