#!/bin/sh

# mxd-hist 

# Update 2017/Apr/11 
# Update 2017/Nov/8 Eint <-> Etot
# Updata 2018/May/28 Pxy <-> Pyz
# Update 2020/Apr/10 Z
# Update 2021/Jun/22 averaged values on gnuplot and bug fixed

if [ $# -gt 1 ]; then
	echo "Number of argument should be less than 1." 1>&2
	echo "Usage: mxd-hist.sh val" 1>&2
	exit 1
fi
if [ $1 -gt 7 ]; then
	echo "Usage: mxd-hist.sh val" 1>&2
	echo "val=1: T,P,Etot,Dens,a,b,c" 1>&2
	echo "val=2: P,Pxx,Pyy,Pzz,Pyz,Pxz,Pxy" 1>&2
	echo "val=3: Dens,a,b,c,alpha,beta,gamma" 1>&2
	echo "val=4: H,Etot,Ecoulomb,Eshort,Ethree,Ekin,Eint" 1>&2
	echo "val=5: P,T,T1,T2,T3,T4,T5" 1>&2
	echo "val=6: P,T,T6,T7,T8,T9,T10" 1>&2
	echo "val=7: z,a,b,c,alpha,beta,gamma" 1>&2
	exit 1
fi

if [ $# -eq 0 ]; then
	val=1
fi
if [ $# -ne 0 ]; then
	val=$1
fi

echo $val


# val=1, default
# T [K], P [GPa], Etot [kJ/mol], Dens [g/cm3], a [Ang], b [Ang], c [Ang]
# val=2
# P [GPa], Pxx [GPa], Pyy [GPa], Pzz [GPa], Pyz [GPa], Pxz [GPa], Pxy[GPa]
# val=3
# Density[g/cm3], a [Ang], b [Ang], c[Ang], alpha [degree], beta [degree], gamma [degree]
# val=4
# H [kJ/mol], Etot, Ecoulomb, Eshort, Ethree, Ekin, Eint

rm -f file09v.out


# read from file07.dat
dt09vps=`awk  '
{
	a[FNR] = $1
        b[FNR] = $3 
        c[FNR] = $7
}
END {
        nstep=b[2]
	nstep09v=c[2]
	dt=a[8]
	dt09vps=nstep/nstep09v*dt*1.0e12
        print dt09vps
	}
' ./file07.dat` 

echo $dt09vps

# read from file09v.dat
awk -F, '
{
	a[FNR] = $1
}
END {
        nstep5=FNR
        nstep=nstep5/5
	i = 1
	j = 1
	while (i <= nstep5){
#		1991           format (f10.3,7f10.5)
		Temp=substr(a[i],1,10)
		Pres=substr(a[i],11,10)
		Pxx=substr(a[i],21,10)
		Pyy=substr(a[i],31,10)
		Pzz=substr(a[i],41,10)
		Pyz=substr(a[i],51,10)
		Pxz=substr(a[i],61,10)
		Pxy=substr(a[i],71,10)
#
# 		1992           format (8F10.3)
                Ecoulmb=substr(a[i+1],1,10)
                Eshort=substr(a[i+1],11,10)
		Ethree=substr(a[i+1],21,10)
		Eint=substr(a[i+1],31,10)
		Ekin=substr(a[i+1],41,10)
		Etot=substr(a[i+1],51,10)
		PV=substr(a[i+1],61,10)
		H=substr(a[i+1],71,10)
#
#		1993           format (F10.6, F10.4, 3F10.6,3F10.7)
                Dens=substr(a[i+2],1,10)
                Volmol=substr(a[i+2],11,10)
		Alat=substr(a[i+2],21,10)
		Blat=substr(a[i+2],31,10)
		Clat=substr(a[i+2],41,10)
		Alpha=substr(a[i+2],51,10)
		Beta=substr(a[i+2],61,10)
		Gamma=substr(a[i+2],71,10)
#
		if(Alpha+0 < 1.1){
			cosa=Alpha
			cosb=Beta
			cosg=Gamma
			sing=sqrt(1-cosg^2)
		}
		if(Alpha+0 >= 1.1){	
 			sing=sin(Gamma/180*3.14159)
 			cosa=cos(Alpha/180*3.14159)
 			cosb=cos(Beta/180*3.14159)
 			cosg=cos(Gamma/180*3.14159)
		}
 		Z=Clat/sing*sqrt(1-cosa^2-cosb^2-cosg^2+2*cosa*cosb*cosg)
#
#		1994           format (10F9.3)
                T1=substr(a[i+3],1,9)
                T2=substr(a[i+3],10,9)
		T3=substr(a[i+3],19,9)
		T4=substr(a[i+3],28,9)
		T5=substr(a[i+3],37,9)
		T6=substr(a[i+3],46,9)
		T7=substr(a[i+3],55,9)
		T8=substr(a[i+3],64,9)
		T9=substr(a[i+3],73,9)
		T10=substr(a[i+3],82,9)
#
#		1995           format (10F9.3 )
                MSD1=substr(a[i+4],1,9)
                MSD2=substr(a[i+4],10,9)
		MSD3=substr(a[i+4],19,9)
		MSD4=substr(a[i+4],28,9)
		MSD5=substr(a[i+4],37,9)
		MSD6=substr(a[i+4],46,9)
		MSD7=substr(a[i+4],55,9)
		MSD8=substr(a[i+4],64,9)
		MSD9=substr(a[i+4],73,9)
		MSD10=substr(a[i+4],82,9)
#
                i=i+5
		time='${dt09vps}'*j
#               val=1
		if ('${val}'==1){
#	 		Time [ps], T [K], P [GPa], Etot [kJ/mol], Dens [g/cm3], a [Ang], b [Ang], c [Ang]
			printf("%11.5f\t%10.3f\t%10.5f\t%10.3f\t%10.6f\t%10.6f\t%10.6f\t%10.6f\n",time,Temp,Pres,Etot,Dens,Alat,Blat,Clat)
		} else if ('${val}'==2){
			printf("%11.5f\t%10.5f\t%10.5f\t%10.5f\t%10.5f\t%10.5f\t%10.5f\t%10.5f\n",time,Pres,Pxx,Pyy,Pzz,Pyz,Pxz,Pxy)
		} else if ('${val}'==3){
			printf("%11.5f\t%10.6f\t%10.4f\t%10.6f\t%10.6f\t%10.7f\t%10.7f\t%10.7f\n",time,Volmol,Alat,Blat,Clat,Alpha,Beta,Gamma)
		} else if ('${val}'==4){
			printf("%11.5f\t%10.3f\t%10.3f\t%10.3f\t%10.3f\t%10.3f\t%10.3f\t%10.3f\n",time,H,Etot,Ecoulmb,Eshort,Ethree,Ekin,Eint)
		} else if ('${val}'==5){
			printf("%11.5f\t%10.5f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t\n",time,Pres,Temp,T1,T2,T3,T4,T5)
		} else if ('${val}'==6){
			printf("%11.5f\t%10.5f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t\n",time,Pres,Temp,T6,T7,T8,T9,T10)
		} else if ('${val}'==7){
			printf("%11.5f\t%10.6f\t%10.6f\t%10.6f\t%10.6f\t%10.7f\t%10.7f\t%10.7f\n",time,Z,Alat,Blat,Clat,Alpha,Beta,Gamma)
		}

		j=j+1
#
		}
	}
' ./file09v.dat > file09v.out 

rm -f ave-file09v

T_LIST="2 3 4 5 6 7 8"

awk '
	BEGIN{
		printf("%7s %20s %20s %20s\n","#Column","Ave.","Stdev.","SDOM")
	}
' ./file09v.out >> ./ave-file09v
		
for tval in $T_LIST ; do
		awk -v x=$tval '
		{
			p[FNR]=$x
			a+=$x
		}
		END {
			ave=a/NR
			sum=0.0
			for (i=1;i<=FNR;i++){
				sum=sum+(p[i]-ave)^2
			}
			sum=sum/NR
			stdev=sqrt(sum)
			sdom=stdev/sqrt(NR)
       			 printf("%7i %20.6f %20.6f %20.6f\n",x,ave,stdev,sdom)
		}
		' ./file09v.out >> ./ave-file09v
done


if [ $val -eq 1 ]; then
	label1="T (K)"
	label2="P (GPa)"
	label3="Etot (kJ/mol)"
	label4="Density (g/cm3)"
	label5="a (ang.)"
	label6="b (ang.)"
	label7="c (ang.)"
	layout="8,1"
fi
if [ $val -eq 2 ]; then
	label1="P (GPa)"
	label2="Pxx (GPa)"
	label3="Pyy (GPa)"
	label4="Pzz (GPa)"
	label5="Pyz (GPa)"
	label6="Pxz (GPa)"
	label7="Pxy (GPa)"
	layout="8,1"
fi
if [ $val -eq 3 ]; then
	label1="Molar V (cm3/mol)"
	label2="a (ang.)"
	label3="b (ang.)"
	label4="c (ang.)"
	label5="{/=8 alpha (deg or cos)}"
	label6="{/=8 beta (deg or cos)}"
	label7="{/=8 gamma (deg or cos)}"
	layout="8,1"
fi
if [ $val -eq 4 ]; then
	label1="Enthalpy (kJ/mol)"
	label2="Etot (kJ/mol)"
	label3="Ecoulomb (kJ/mol)"
	label4="Eshort (kJ/mol)"
	label5="Ethree (kJ/mol)"
	label6="Ekin (kJ/mol)"
	label7="Eint (kJ/mol)"
	layout="8,1"
fi
if [ $val -eq 5 ]; then
	label1="P (GPa)"
	label2="T (K)"
	label3="T-atom1 (K)"
	label4="T-atom2 (K)"
	label5="T-atom3 (K)"
	label6="T-atom4 (K)"
	label7="T-atom5 (K)"
	layout="8,1"
fi
if [ $val -eq 6 ]; then
	label1="P (GPa)"
	label2="T (K)"
	label3="T-atom6 (K)"
	label4="T-atom7 (K)"
	label5="T-atom8 (K)"
	label6="T-atom9 (K)"
	label7="T-atom10 (K)"
	layout="8,1"
fi
if [ $val -eq 7 ]; then
	label1="z (ang.)"
	label2="a (ang.)"
	label3="b (ang.)"
	label4="c (ang.)"
	label5="alpha (deg.)"
	label6="beta (deg.)"
	label7="gamma (deg.)"
	layout="8,1"
fi

ave1=`awk '{ave[FNR]=$2} END{print ave[2]}' ./ave-file09v`
ave2=`awk '{ave[FNR]=$2} END{print ave[3]}' ./ave-file09v`
ave3=`awk '{ave[FNR]=$2} END{print ave[4]}' ./ave-file09v`
ave4=`awk '{ave[FNR]=$2} END{print ave[5]}' ./ave-file09v`
ave5=`awk '{ave[FNR]=$2} END{print ave[6]}' ./ave-file09v`
ave6=`awk '{ave[FNR]=$2} END{print ave[7]}' ./ave-file09v`
ave7=`awk '{ave[FNR]=$2} END{print ave[8]}' ./ave-file09v`

cat << EOF > gnu.plt
set term x11 size 600,800
set size 1.0,0.3
set multiplot layout $layout
set lmargin 15
set tmargin 0.5 
set bmargin 0.5
set dashtype 11 (5,5)
f1(x)=$ave1
f2(x)=$ave2
f3(x)=$ave3 
f4(x)=$ave4 
f5(x)=$ave5 
f6(x)=$ave6 
f7(x)=$ave7 
unset xlabel
set format x ""
set ylabel "$label1"
set label 1at graph 0.8,0.8 "$ave1" textcolor lt 1
p 'file09v.out' u 1:2 w l lt 1 noti, f1(x) dt 11 lc rgb "black" noti
unset label 1
set ylabel "$label2"
set label 1at graph 0.8,0.8 "$ave2" textcolor lt 2
p 'file09v.out' u 1:3 w l lt 2 noti, f2(x) dt 11 lc rgb "black" noti
unset label 1
set ylabel "$label3"
set label 1at graph 0.8,0.8 "$ave3" textcolor lt 3
p 'file09v.out' u 1:4 w l lt 3 noti, f3(x) dt 11 lc rgb "black" noti
unset label 1
set ylabel "$label4"
set label 1at graph 0.8,0.8 "$ave4" textcolor lt 4
p 'file09v.out' u 1:5 w l lt 4 noti, f4(x) dt 11 lc rgb "black" noti
unset label 1
set ylabel "$label5"
set label 1at graph 0.8,0.8 "$ave5" textcolor lt 5
p 'file09v.out' u 1:6 w l lt 5 noti, f5(x) dt 11 lc rgb "black" noti
unset label 1
set ylabel "$label6"
set label 1at graph 0.8,0.8 "$ave6" textcolor lt 6
p 'file09v.out' u 1:7 w l lt 6 noti, f6(x) dt 11 lc rgb "black" noti
unset label 1
set format x 
set xlabel "Time (ps)"
set ylabel "$label7" 
set label 1at graph 0.8,0.8 "$ave7" textcolor lt 7
p 'file09v.out' u 1:8 w l lt 7 noti, f7(x) dt 11 lc rgb "black" noti
unset multiplot
pause -1
EOF

gnuplot-x11 gnu.plt 

