     module param
       implicit none
       integer(4),parameter:: lel=8, lem=10, LNF=20
       integer(4),parameter:: LPO=40001,LPQ=LPO-1
     end module
     module chara
       use param
       implicit none
       character(len=4):: title(15),atom(lem)
       character(len=8):: run(11)
       character(len=15):: flname(19)
     end module
     module file07
       use param
       implicit none
       integer(4) NJOB(2),NRECRD(9),INTPV,NTION,NION(LEM),NCOMPO,IONS(2,LEM)
       integer(4) fNRECRD(LNF,9)
       integer(4) jf,nfile,IF09PV,INT9PV
       character*100 pfile(10)
       real(4) BOX(6),VBOX(6),VO,DENSTY,TEMP,DELTMP,TMPGET,DTIME,spres(3)
     end module
     module msddd
       use param
       implicit none
       real(8) DFS(LEM,LPQ)
       integer(4) NP(LPQ)
       real(4) FAL(3),AF(LEM),DMAX, DMAXI(LEM)
     end module
!
      PROGRAM  MDMSD
!******************************************************
!***   Plot mean square displacement against time   ***
!***                     by Kats      1989-Fev-14   ***
!***                                  1991-Aug-16   ***
!***               for MXDONEW        1992-May-20   ***
!***              for 500,000 steps   2000-Apr-23   ***
!***                     by Saku                    ***
!***     New file09p.dat format       2011-Apr-03   ***
!***     Bug fixed of IPN-IPN1        2011-Sep-07   ***
!***     read from many files         2014-Aug-04   ***
!******************************************************
!
      use param
      use chara
      use file07
      implicit none
      character*1 ans
      integer i
!
                   FLNAME(1)  = '2000-04-23-00  '
!
                   FLNAME(2)  = 'NDP-FORTRAN386 '
!                  FLNAME(2)  = 'LUNA-88K       '
!
                   FLNAME(3)  = 'M. s. d.       '
                   FLNAME(4)  = '               '
                   FLNAME(5)  = 'file05.dat     '
                   FLNAME(6)  = 'file06.dat     '
                   FLNAME(7)  = 'file07.dat     '
                   FLNAME(8)  = 'file08.dat     '
                   FLNAME(9)  = 'file09p.dat    '
                   FLNAME(10) = 'file10.dat     '
                   FLNAME(11) = 'file09v.dat    '
                   FLNAME(12) = 'file09pv.dat   '
                   FLNAME(13) = '               '
                   FLNAME(14) = 'f06msd.dat     '
                   FLNAME(15) = '               '
                   FLNAME(19) = 'temp.dat       '
!
        nfile = 1
        pfile(1) = './'
        write(*,'("Only use of files in this directry?(y,n)")',advance='no')
        read(*,*) ans
        if (ans == 'n' .or. ans == 'N') then              
          write(*,'("Reading input.txt")')
          open (90, file ='input.txt', status='old', &
                access='sequential', form='formatted')
            read(90,*) nfile
            write(*,'("Number of files : ", i2)')nfile
            do i = 1, nfile
              read(90,'(a100)') pfile(i)
              write(*,'(i3, "-th file path: ", a100)') i,pfile(i)
            enddo
          close(90)
        endif
!
        do jf = 1,nfile
          call  f05f07
        enddo
! 
        CALL  MSMAIN
      END
!
!                                                             ==========
!=============================================================== F05F07 
      SUBROUTINE  F05F07
        use param
        use chara
        use file07
        use msddd
!
        implicit none
!
        integer(4) NTIOND,NOPT
        integer(4) fNTION(LNF),fNCOMPO(LNF),fNION(LNF,LEM),fIONS(LNF,2,LEM),fDTIME5(LNF)
        integer(4) i,IO,JO,j
        character*4 fATOM(LNF,LEM)
        real(4) ANUM,DELT,TARGT,RCUT,FORMUL,ADUMMY,AINTPV,ANREC,ANRDF,ALCNT
!
!     --------------------------------------------- READ FROM FILE05.DAT
      OPEN (15, FILE  =trim(pfile(jf))//'file05.dat',    STATUS='OLD', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
              READ (15,'(A8,2X,15A4)')  RUN(1)
              IF (RUN(1) /= 'MD......' .AND. RUN(1) /= 'MDX.....' )  STOP 1111
              READ (15,'(A8,2X,15A4)')  RUN(2),TITLE
              WRITE (*,'(1X,"**** ",15A4," ****")')  TITLE
              READ (15,'(A8,2X,6F10.5)')  RUN(3), ALCNT, ANRDF, ANREC, AINTPV, ADUMMY
                                                      INTPV = 50
                                   IF (AINTPV > 0.5) INTPV = INT(AINTPV)
              READ (15,'(A8,2X,6F10.5)')  RUN(4), fDTIME5(jf), FORMUL, RCUT
              if (jf > 1) then
                if (fDTIME5(jf) /= fDTIME5(jf-1)) stop "Error, inconsistent DTIME"
              endif
              READ (15,'(A8,2X,6F10.5)')  RUN(5), TARGT, DELT, SPRES
              READ (15,'(A8,2X,6F10.5)')  RUN(6)
              READ (15,'(A8,2X,6F10.5)')  RUN(7)
              READ (15,'(A8,2X,6F10.5)')  RUN(8)
   10         READ (15,'(I1)')  IO
              IF (IO /= 0)  THEN
!                   WRITE (*,*) IO
                    GO TO 10
              END IF
              IF (RUN(8) == 'MORSE') THEN
   15               READ (15,'(I2,I2)')  IO,jO
!                   WRITE (*,*) IO,JO
                    IF (IO /= 0)  GO TO 15
              END IF
              IF09PV = 0
              NOPT = 8
   20         READ (15,'(A8,2X,6F10.5)',END=999)  RUN(NOPT+1), ANUM
                   IF (RUN(NOPT+1) /= '        ')  THEN
                         IF (RUN(NOPT+1) == 'POSITION') THEN
                             IF09PV = 1
                             INT9PV = INT(ANUM)
                         END IF
                         NOPT = NOPT + 1
                         GO TO 20
                   END IF
 999  CLOSE (15)
!
      if (jf == 1) then
        do i = 1,9
          NRECRD(i) = 0
        enddo
      endif
!     -------------------------------- FILE07 : system and particle data
!                                description, coordinates and velocities
      OPEN (17, FILE=trim(pfile(jf))//'file07.dat', STATUS='OLD',  &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      READ (17,'(15A4,2I5)') TITLE, NJOB
      read (17,'(I7,I3, 9I10)') fNTION(jf), fNCOMPO(jf), (fNRECRD(jf,I),I=1,9) 
      READ (17,'(10(2X,A4))') (fATOM(jf,I),  I=1,fNCOMPO(jf))
      READ (17,'(10I6)') (fNION(jf,I),  I=1,fNCOMPO(jf))
      READ (17,'(10I6)') (fIONS(jf,1,I),I=1,fNCOMPO(jf))
      READ (17,'(10I6)') (fIONS(jf,2,I),I=1,fNCOMPO(jf))
      READ (17,'(F10.2,F10.4,F10.2, 3F10.5)') TEMP, DELTMP,TMPGET, SPRES
      read (17,'(E10.3, 10X, 6F10.6)') DTIME,    BOX
      read (17,'(F10.6, 10X, 6F10.6)') DENSTY,  VBOX 
      write (6,'(1x,"Ntion=",i5,5x,"A=",f7.3,"   B=",f7.3,"   C=",f7.3)') fNTION(jf), (box(j),j=1,3)
      IF (box(4)**2+BOX(5)**2+BOX(6)**2 > 1.E-6) then
        write (6,*) box
        STOP 2222
      END IF
      NTIOND = 0
      if (jf > 1) then
        if (fNTION(jf) /= fNTION(jf-1)) stop "Error,inconsistent NTION among files"
        if (fNCOMPO(jf) /= fNCOMPO(jf-1)) stop "Error, inconsistent NCOMPO among files"
        do i = 1, fncompo(1)
          if (fATOM(jf,i) /= fATOM(jf-1,i)) stop "Error, inconsistent ATOM among files"
          if (fNION(jf,i) /= fNION(jf-1,i)) stop "Error, inconsistent NION among files"
          if (fIONS(jf,1,i) /= fIONS(jf-1,1,i)) stop "Error, inconsistent IONS1 among files"
          if (fIONS(jf,2,i) /= fIONS(jf-1,2,i)) stop "Error, inconsistent IONS2 among files"
        enddo
      endif
      do i = 1, 9
        NRECRD(i) = NRECRD(i) + fNRECRD(jf,i)
      enddo
      if (jf == 1) then
        NTION = fNTION(1)
        NCOMPO = fNCOMPO(1)
        do i = 1,ncompo
          ATOM(i) = fATOM(1,I)
          NION(i) = fNION(1,I)
          IONS(1,i) = fions(1,1,i)
          IONS(2,i) = fions(1,2,i)
        enddo
      endif
      CLOSE  (17)
    RETURN
    STOP
    END
!                                                             ==========
!=============================================================== MSDMAIN
      SUBROUTINE  MSMAIN
        use param
        use chara
        use file07
        use msddd
!
        implicit none
!
        integer(4) npoint,isdn,id,msdmin,msdmax
        integer(4) i,io,NS
        real(4) TM
        CHARACTER(len=1)::   GRAPH(132)
        CHARACTER(len=32)::  FORM1, FORM2
!
!     -------------------------------------- Write title, etc. on f06msd
!     ------------------- F06MSD : so called sysout file (write (6, )
      OPEN (16,FILE  =FLNAME(14),   STATUS='UNKNOWN',  &
               ACCESS='SEQUENTIAL', FORM='FORMATTED')
!
      WRITE ( *,1181) TITLE,         NTION,(ATOM(I),NION(I),I=1,NCOMPO)
      WRITE ( *,1182) TEMP, DENSTY,  NRECRD(4),INTPV
      WRITE (16,1181) TITLE,         NTION,(ATOM(I),NION(I),I=1,NCOMPO)
      WRITE (16,1182) TEMP, DENSTY,  NRECRD(4),INTPV
      IF (IF09PV /= 0)  THEN
             WRITE ( *,1185) NRECRD(9), INT9PV
             WRITE (16,1185) NRECRD(9), INT9PV
      END IF
!
 1181 FORMAT (1X,'*** ',15A4,' ***' / &
              5X,'Number of ions is ',I5, &
                                  ' (',3(A2,':',I4,3X),A2,':',I4,')' )
 1182 FORMAT (5X,'T=',F7.1,'K    Density=',F7.4,'g/cm3'/ &
              5X,'Number of positions recorded (FILE09P.DAT) is ',I5 / &
              5X,'(Interval:',I3,'step(s))' )
 1185 FORMAT (5X,'Number of positions recorded (FILE09PV.DAT) is ',I5 / &
              5X,'(Interval:',I3,'step(s))' )
      IF (NRECRD(4) > LPO)  NRECRD(4) = LPO
!
      ISDN = 1
      IF (IF09PV /= 0)  THEN
            WRITE (*,1207) 
 1207       FORMAT (/' Position date from  1:file09p.dat  or  ','2:file09pv.dat  ? ' )
            READ (5,'(i1)') isdn
      END IF
      flname(18) = flname(9)
      if ( isdn  ==  2 ) then
             flname(18) = flname(12)
             NRECRD(4) = 0
             do jf = 1 ,nfile
               fNRECRD(jf,4)  = fNRECRD(jf,9)
               NRECRD(4) = NRECRD(4) + fNRECRD(jf,4)
               if (jf > 1) NRECRD(4) = NRECRD(4) -1
             enddo
             INTPV = INT9PV
      end if
      write(*,'("Total number of the steps  = ", i10)') NRECRD(4)
!
!     ====================================== READ FILE09P  AND  CALC MSD
        CALL  MSDSUB
        WRITE (*,*) DMAXI(1), DMAXI(2)
!
!     ========================================== Output m.s.d. on f06msd
                        FORM1 = '( 1X, F8.3,  F8.3, 1X, 116A1 )  '
      IF (NCOMPO == 2)  FORM1 = '( 1X, F8.3, 2F8.3, 1X, 108A1 )  '
      IF (NCOMPO == 3)  FORM1 = '( 1X, F8.3, 3F8.3, 1X, 100A1 )  '
      IF (NCOMPO == 4)  FORM1 = '( 1X, F8.3, 4F8.3, 1X,  92A1 )  '
      IF (NCOMPO == 5)  FORM1 = '( 1X, F8.3, 5F8.3, 1X,  84A1 )  '
      IF (NCOMPO == 6)  FORM1 = '( 1X, F8.3, 6F8.3, 1X,  76A1 )  '
      IF (NCOMPO == 7)  FORM1 = '( 1X, F8.3, 7F8.3, 1X,  68A1 )  '
      if (ncompo == 8)  form1 = '( 1x, f8.3, 8f8.3, 1x,  60a1 )  '
      if (ncompo == 9)  form1 = '( 1x, f8.3, 9f8.3, 1x,  52a1 )  '
      if (ncompo == 10) form1 = '( 1x, f8.3,10f8.3, 1x,  44a1 )  '
!     ------------------------------------------------------------
                        FORM2 = '( 1X, 17X, 1HI, 114(1H-), 1HI ) '
      IF (NCOMPO == 2)  FORM2 = '( 1X, 25X, 1HI, 106(1H-), 1HI ) '
      IF (NCOMPO == 3)  FORM2 = '( 1X, 33X, 1HI,  98(1H-), 1HI ) '
      IF (NCOMPO == 4)  FORM2 = '( 1X, 41X, 1HI,  90(1H-), 1HI ) '
      IF (NCOMPO == 5)  FORM2 = '( 1X, 49X, 1HI,  82(1H-), 1HI ) '
      IF (NCOMPO == 6)  FORM2 = '( 1X, 57X, 1HI,  74(1H-), 1HI ) '
      IF (NCOMPO == 7)  FORM2 = '( 1X, 65X, 1HI,  66(1H-), 1HI ) '
      if (ncompo == 8)  form2 = '( 1x, 73x, 1HI,  58(1H-), 1HI ) '
      if (ncompo == 9)  form2 = '( 1x, 81x, 1HI,  50(1H-), 1HI ) '
      if (ncompo == 10) form2 = '( 1x, 89x, 1HI,  42(1H-), 1HI ) '
!     ------------------------------------------------------------
      NPOINT = 133 - 9 - 8*NCOMPO
!     ---------------------------
      MSDMAX = INT(DMAX + .9999)
      MSDMIN = 2
      DO IO = 1, NCOMPO
          AF(IO) = FLOAT(NPOINT-1) / MSDMAX
          IF (DMAXI(IO) < 1.0) AF(IO) = (NPOINT-1)
      enddo
!     ----------------------------------------------------- Print m.s.d.
      IF (NCOMPO == 1)  THEN
            WRITE (16,1121)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1121       FORMAT (/ 2X, 'Time/ps',  (4X,A2,2X), ' 0', 41X, &
                          'MEAN SQUARED DISPLACEMENT', 41X, I5, 'A^2' )
      ELSE IF (NCOMPO == 2)  THEN
            WRITE (16,1122)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1122       FORMAT (/ 2X, 'Time/ps', 2(4X,A2,2X), ' 0', 37X, &
                          'MEAN SQUARED DISPLACEMENT', 37X, I5, 'A^2' )
      ELSE IF (NCOMPO == 3)  THEN
            WRITE (16,1123)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1123       FORMAT (/ 2X, 'Time/ps', 3(4X,A2,2X), ' 0', 33X, &
                          'MEAN SQUARED DISPLACEMENT', 33X, I5, 'A^2' )
      ELSE IF (NCOMPO == 4)  THEN
            WRITE (16,1124)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1124       FORMAT (/ 2X, 'Time/ps', 4(4X,A2,2X), ' 0', 29X, &
                          'MEAN SQUARED DISPLACEMENT', 29X, I5, 'A^2' )
      ELSE IF (NCOMPO == 5)  THEN
            WRITE (16,1125)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1125       FORMAT (/ 2X, 'Time/ps', 5(4X,A2,2X), ' 0', 25X, &
                          'MEAN SQUARED DISPLACEMENT', 25X, I5, 'A^2' )
      ELSE IF (NCOMPO == 6)  THEN
            WRITE (16,1126)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1126       FORMAT (/ 2X, 'Time/ps', 6(4X,A2,2X), ' 0', 21X,  &
                          'MEAN SQUARED DISPLACEMENT', 21X, I5, 'A^2' )
      ELSE IF (NCOMPO == 7)  THEN
            WRITE (16,1127)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1127       FORMAT (/ 2X, 'Time/ps', 7(4X,A2,2X), ' 0', 17X, &
                          'MEAN SQUARED DISPLACEMENT', 17X, I5, 'A^2' )
      ELSE IF (NCOMPO == 8)  THEN
            WRITE (16,1128)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1128       FORMAT (/ 2X, 'TIME/PS', 8(4X,A2,2X), ' 0', 13X, &
                          'MEAN SQUARED DISPLACEMENT', 13X, I5, 'A^2' )
      ELSE IF (NCOMPO == 9)  THEN
            WRITE (16,1129)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1129       FORMAT (/ 2X, 'TIME/PS', 9(4X,A2,2X), ' 0',  9X, &
                          'MEAN SQUARED DISPLACEMENT',  9X, I5, 'A^2' )
      ELSE IF (NCOMPO == 10)  THEN
            WRITE (16,1130)  (ATOM(I),I=1,NCOMPO),MSDMAX
 1130       FORMAT (/ 2X, 'TIME/PS', 10(4X,A2,2X), ' 0',  5X, &
                          'MEAN SQUARED DISPLACEMENT',  5X, I5, 'A^2' )
      END IF
      WRITE (16,FORM2)
!
      DO NS = 1, NRECRD(4)-1
          DO I = 2, NPOINT
              GRAPH(I)  = ' '
          enddo
              GRAPH(1)  = 'I'
              GRAPH(NPOINT) = 'I'
          DO IO = 1, NCOMPO
              IF (NION(IO) > 0)  THEN
                    ID = INT(DFS(IO,NS) * AF(IO) +1.5)
                    GRAPH(ID) = ATOM(IO)
              END IF
          enddo
          TM = real(NS) * DTIME * real(INTPV) * 1.E12
          WRITE (16,FORM1) TM,(DFS(IO,NS),IO=1,NCOMPO), &
                              (GRAPH(I),I=1,NPOINT)
          WRITE ( *,'(1X,F8.3,7F8.3)')  TM,(DFS(IO,NS),IO=1,NCOMPO)
      enddo
      WRITE (16,FORM2)
!
      ENDFILE (16)
      CLOSE   (16)
  999 STOP
      END
!
!
!                                                              =========
!================================================================ MSDSUB
      SUBROUTINE  MSDSUB
        use param
        use chara
        use file07
        use msddd
!
        implicit none
!
        real(8)        dr
        real(4) rmsdio
        real(8) dfsion
        integer(4) io,ns,i,ns2,ns1,ipn,ipn1,j,nj,ii,maxio,fNS
        INTEGER*4, allocatable::   IP(:,:,:),jp(:,:)
!
      FAL(1) = BOX(1) / 90000.0
      FAL(2) = BOX(2) / 90000.0
      FAL(3) = BOX(3) / 90000.0
      DMAX = 0.0
      maxio = 1
      do io = 1,ncompo
        if (nion(io) > maxio) maxio = nion(io)
      enddo
      allocate(ip(3,maxio,nrecrd(4)), jp(3,ntion))
      write(*,'("Allocation is completed!!")')
!
!     ------------------------------- FILE09P : Coordinates of each step
      DO IO = 1, NCOMPO
        RMSDIO    = 0.0
        DMAXI(IO) = 0.0
        IF (NION(IO) <= 0)  cycle
        NS = 0
        do jf = 1, nfile
          OPEN (19, FILE  =trim(pfile(jf))//FLNAME(18),    STATUS='OLD', &
                    ACCESS='SEQUENTIAL', FORM='FORMATTED')
            REWIND 19
            DO fNS = 1, fNRECRD(jf,4)
              READ (19,'(I7)')  II
              READ (19,'(18I5)',err=41)  ((JP(J,I),J=1,3),I=1,NTION)
              if (jf > 1 .AND. fNS == 1) cycle
              NJ = 0
              NS = NS + 1
              DO I = IONS(1,IO), IONS(2,IO)
                NJ = NJ + 1
                IP(1,NJ,NS) = JP(1,I)
                IP(2,NJ,NS) = JP(2,I)
                IP(3,NJ,NS) = JP(3,I)
              enddo
              IF (NS == 1)  cycle
!
              DO I = 1, NION(IO)
                DO J = 1, 3
                  IPN  = IP(J,I,NS)
                  IPN1 = IP(J,I,NS-1)
   40             IF (IPN-IPN1 >=  45000) then
                    IPN = IPN - 90000
                    go to 40
                  end if
   50             IF (IPN-IPN1 <= -45000) then
                    IPN = IPN + 90000
                    go to 50
                  end if
                  IP(J,I,NS) = IPN
                  RMSDIO = RMSDIO +((IPN-IP(J,I,1))*FAL(J))**2
                enddo
              enddo
              IF (MOD(NS,100) == 0) THEN
                RMSDIO = RMSDIO / NION(IO)
                WRITE (*,'(1X,I6,F12.4,"  (Nion(",i2,")=",i5,")")') NS, RMSDIO, io, NION(IO)
              END IF
   41       enddo
            REWIND 19
          CLOSE (19)
        enddo
!
        DO NS = 1, NRECRD(4)-1
          NP(NS)  = 0
          DFS(IO,NS) = 0.0
        enddo
!       -------------------------------------- Calculate m.s.d.
        DO NS1 = 1, NRECRD(4)-1
          DO NS2 = NS1+1, NRECRD(4)
            NS = NS2 - NS1
            DR = 0.0
            DO I = 1, NION(IO)
              DR = DR + &
                        ((IP(1,I,NS2)-IP(1,I,NS1))*FAL(1))**2 &
                      + ((IP(2,I,NS2)-IP(2,I,NS1))*FAL(2))**2 &
                      + ((IP(3,I,NS2)-IP(3,I,NS1))*FAL(3))**2
            enddo
            DFS(IO,NS) = DFS(IO,NS) + DR / NION(IO)
            NP(NS)     = NP(NS) + 1
          enddo
          if (mod(Ns1,100) == 0) then
            write (6,'(" NS1=",i5,"   DFS(",i1,",10)=",F12.3," (",i5,")")')  ns1, IO, dfs(io,10), ns
          end if
        enddo
!
        DO NS = 1, NRECRD(4)-1
          DFSION = DFS(IO,NS) / NP(NS)
          IF (DMAX      < DFSION)  DMAX      = DFSION
          IF (DMAXI(IO) < DFSION)  DMAXI(IO) = DFSION
          DFS(IO,NS) = DFSION
        enddo
!
        WRITE (6,*)  IO, 'Dmax', DMAXI(IO)
      enddo
      RETURN
      END
