!      PROGRAM  F7CONVDS
!      Last Updated Nov  06, 2023 
!----------------------------------------------------------------------I
! Conversion of file07.dat                                             I
!  1: from old format to new format(92-08-01)                          I
!  2: extend basic cell muliplied by (2,2,2)     (N(atom):8 times)     I
!  3: extend basic cell muliplied by (Nx,Ny,Nz)  (N(atom):NxNyNz times)I
!  4: transform coordinates: example,z -> z/2  c -> 2c  (2D surface)   I
!  5: transform x,y,z: x -> x/2, a,b,c: a -> 2a  (3D surface)          I
!  6: generating dislocation (suface and bulk)                         I
!  7: centering (z=0.5)                                                I
!  8: shift by (x,y,z)                                                 I
!  9: Two in one  (file07.dat + file07.add)  (composite plane = x-y)   I
! 10: For solid solution of NaCl (randomize Na sites)                  I
! 11: Add and replace some atoms (+hydration) or H3O+ or H2O           I
! 12: Make all velocities zero                                         I
! 13: Randomize particle velocities                                    I
! 14: Change axes                                                      I
! 15: Shorten basic cell (Subtract vacuum layer)                       I
! 16: Conversion (hk0) -> (00c)                                        I
! 17: Make ICE-Ih from I-ICE structure (Xtaldata.dat)                  I
! 18: Add H to an edge                                                 I
! 19: Shorten cell (for initial edge/water interface)                  I
! 20: Remove atoms                                                     I
! 21: Shorten cell length                                              I
! 22: Ion substitution                                                 I
! 23: Combine elements                                                 I
! 24: Make edges                                                       I
! 25: Exchange atoms                                                   I
! 26: Ripplication                                                     I
!                                                                      I
! 99: Option                                                           I
!----------------------------------------------------------------------I
!
!
      module param
        implicit none
        integer(KIND=4),parameter :: LNI=100000, LEM=20
      end module
      module chara
        use param
        implicit none
        character(len=14):: flname(19)
        character(len=10):: runopt(29)
        character(len=4)::  title(15),atom(lem)
      end module
      module data1
        use param
        implicit none
        integer(KIND=4) njob(2),nrecrd(9),ihistr(4,111)
        integer(KIND=4) ncompo, ntion,ioxy,ih
        integer(KIND=4) nion(lem),ions(2,lem),iond(lni)
        integer(KIND=4) select
      end module
      module data2
        use param
        implicit none
        integer(KIND=4) itra2
        double precision dtime, temp, deltmp, tmpget,densty
        double precision spres(3),ppxyz(7),box(6),vbox(6)
        double precision p(3,lni), p0(3,lni), v10(3,lni),pp(3,lni)
        double precision cr(3,lni)
      end module
      module randm3
        implicit none
        double precision r1, r2, r3
        integer(KIND=4) ir, jr, kr, lr, mr, nr
      end module
      module cartes
        use param
        implicit none
        double precision q(3,lni)
        double precision hinv(3,3),h(3,3),det
      end module
!
      PROGRAM  F7CONVD
      use param
      use chara
      use data1
      use data2
      use randm3
      use cartes
      implicit none
!
      integer(KIND=4)   nion2(lem), ions2(2,lem)
      double precision      dtime2, temp2,deltm2,tmpge2, spres2(3)
      double precision      box2(6), vbox2(6), dnsty2, q0(3,lni)
      double precision        vq10(3,lni), shift(3),ubox(3)
      character(len=4)::   title2(15), atom2(lem), aatom, patom
      character(len=1)::   defect,ax,lc,ans,aok,ah,answer,aj
      character(len=2)::   asub
!
      integer(KIND=4) choose,choice, idela(lni), nzatom(11)
      integer(KIND=4) surfac,num(lem,lni)
      integer(KIND=4) i,nx,ny,nz,nnn,io,k1,k2,k3,j,nelm,iax,n,iz,itx
      integer(KIND=4) ipx,ntion0,ndela,n1,n2,ntion2,ncompo2,ntiond
      integer(KIND=4) ni1,jO,kkk,ia,hh,k,l,jn,natom
      integer(KIND=4) nh(lni),nd(lni),ih2o(8,lni)
      integer(KIND=4) nio2,mh3o,nratom,nrcom,nih2
      integer(KIND=4) nhnum,nonum,nsion,iwater,nh2o,hmode,noxy,nhy
      integer(KIND=4) imode,nc(lni),ic(8,lni),nhh,ioah(20),kk,irm(lni),nnion(lem),ii,istr
      integer(KIND=4) iea,id,iele,im,icheck,dcheck,jcheck,subio,ix,eind(lni),nscompo,jj
      integer(KIND=4):: nnnn,imoh,noi,idd,neib=0,ineib(10),ntiono,c1,c2,tmpc
      integer(KIND=4) istart,KNK,iatom,irmod,nsubio,msub,kran
      integer*4 ndistc,ndistcri,idist,nstep,iter
      integer*4 ncoo,ncoord,numcoj,numco(lni)
      double precision, parameter :: pi = acos(-1.0d0)
      double precision zbase,amult,dp,z0,box3,ppp,vvv,px,py,pz
      double precision dx,dy,dz,bbb,amin,amax,cosz,sinz,coszz,sinzz
      double precision pia,cosy,siny
      double precision aaa1(3),aaa2(3)
      double precision bbb1,bbb2,bbb3,bbb4,bbb5,bbb6
      double precision ppp1,ppp2,ppp3
      double precision x,y,z,roh,rdoh,doh
      double precision px1,py1,pz1,px2,py2,pz2,px3,py3,pz3,px4,py4,pz4,vv
      double precision dintra,srd,pxx1,pyy1,pzz1
      double precision dintra0,dintra1,vspace,po(3,12),dx0,dy0,dz0
      double precision  dsq,dsqd,alength,dsqo,ddd
      double precision pl,ph,rpx(2,3),ppx(lem,lni),ppy(lem,lni),ppz(lem,lni)
      double precision tion,dist,dlimit,distc
      double precision aax,aay,aaz,bx,by,bz,cx,cy,cz,sintheta,costheta,theta
      double precision abinp,aint,bint,dnvydnvx,nvx,nvy
      double precision tempp(3),tempp0(3),tempv10(3)
      double precision height,gcenter,gsigma,maxvec
      double precision shiftx0,gbase,deriv
      double precision gdx(0:10000),RX,DRX,dd
!
                    flname(1)  = 'F07-CONVERSION'
                    flname(2)  = '2015-06-13-00 '
                    flname(5)  = 'file05.dat    '
                    flname(7)  = 'file07.dat    '
                    flname(10) = 'file10.dat    '
!
      call  RNDMIZ
!
   10 write (6,*)
      write (6,*)  ' Conversion of file07.dat format or coordinates  '
      write (6,*)
      write (6,*)  '  1: from old format to new format(92-08-01)     '
      write (6,*)  '  2: extend basic cell muliplied by (2,2,2)     ', &
                                                 '(N(atom):8 times) ' 
      write (6,*)  '  3: extend basic cell muliplied by (Nx,Ny,Nz)  ', &
                                            '(N(atom):NxNyNz times) ' 
      write (6,*)  '  4: transform coordinates:example,z -> z/2  c ->', &
                      '2c  (2D surface)' 
      write (6,*)  '  5: transform x,y,z: x -> x/2, a,b,c: a -> 2a  ', &
                                                      '(3D surface) ' 
      write (6,*)  '  6: generating dislocation                      '
      write (6,*)  '  7: centering (z=0.5)                           '
      write (6,*)  '  8: shift by (x,y,z)                            '
      write (6,*)  '  9: Two in one (file07.dat + file07.add)        '
      write (6,*)  ' 10: For random solid solution of Na site of NaCl' &
                                                         ,' structure'
      write (6,*)  ' 11: Add some atoms (+hydration) or H3O+ or H2O  '
      write (6,*)  ' 12: All atom velocities zero                    '
      write (6,*)  ' 13: Randomize particle velocities               '
      write (6,*)  ' 14: Change axes                                 '
      write (6,*)  ' 15: Shorten Cell length (subtract vacuum layer) '
      write (6,*)  ' 16: Conversion (hkl) -> (00c)                   '
      write (6,*)  ' 17: Make ICE-Ih from I-ICE structure            '
      write (*,*)  ' 18: Add H                                       '
      write (*,*)  ' 19: Shorten cell length (for edge/water relax)  '
      write (*,*)  ' 20: Remove atoms (element, index option)        '
      write (*,*)  ' 21: Shorten cell length                         '
      write (*,*)  ' 22: Ion substitution                            '
      write (*,*)  ' 23: Combine elements                            '
      write (*,*)  ' 24: Make edges                                  '
      write (*,*)  ' 25: Exchange atoms                              '
      write (*,*)  ' 26: Ripplocation                                '
      write (*,*)  ' End of options                                  '
      WRITE (6,*)
      read  (5,*)  select
!                                                 ======================
!     ============================================== [1: INPUT SECTION ]
!                                                 ======================
      if (select == 1)  then
!     ----------------------------------------------------------- Case 1
!                                              Read and write file07.dat
!                                                        with old format
      CALL  FILE07  (-1)
!     ---------------------------------------------------- End of case 1
!
      else if (select >= 2 .and. select <= 26)  then
!     ------------------------------------------------------ Case 2 - 18
!                                         Read and write from FILE07.DAT
!                         system description, coordinates and velocities
      CALL  FILE07  ( 1)
!     ------------------------------------------------------------------
      else
            if (select == 99)  then
                  call  file07  (1)
                  goto 20
            end if
            go to 10
      end if
!                                           ============================
!     ======================================== [2: CONFIRMAION SECTION ]
!                                           ============================
   20 WRITE (*,'(1X,"Title: ",15A4)')  TITLE
      WRITE (*,9003)  NTION,TEMP,(BOX(I),I=1,3),DENSTY
 9003 FORMAT (6X,'Total number of atoms in a basic cell : ',i6 / &
              6X,'Temperature:',F7.1, ' K' / &
              6X,'Basic cell :',3F9.4,' A', &
              6X,'Density :',F7.4, ' g/cm3' )
!
!                                             ==========================
!     ========================================== [3:PROCESSING SECTION ]
!                                             ==========================
!
!     ------------------------------------------------------- Conversion
      if (select == 2 .or. select == 3)  then
!           ------------------------------------------------- Case 2 & 3
            Nx = 2
            Ny = 2
            Nz = 2
            if (select == 3)  then
  300             write (6,*) 'Please type numbers (Nx, Ny, Nz) of ', &
                              'cells to be stacked up'
                  read (5,*) Nx,Ny,Nz
                  if (Nx <= 0 .or. Ny <= 0 .or. Nz <= 0)  go to 300
            end if
            NNN = 0
            DO IO = 1, NCOMPO
                DO I = IONS(1,IO), IONS(2,IO)
                    DO K1 = 0, Nx-1
                      DO K2 = 0, Ny-1
                        DO K3 = 0, Nz-1
                          NNN = NNN + 1
                          Q(1,NNN)   = (P(1,I) + K1) / Nx
                          Q(2,NNN)   = (P(2,I) + K2) / Ny
                          Q(3,NNN)   = (P(3,I) + K3) / Nz
                          call  RANDOM
                          VQ10(1,NNN) = V10(1,I) + (r1-0.5)*0.001
                          VQ10(2,NNN) = V10(2,I) + (r2-0.5)*0.001
                          VQ10(3,NNN) = V10(3,I) + (r3-0.5)*0.001
                          DO J = 1, 3
                              Q0(J,NNN)  = Q(J,NNN)
                          ENDDO   
                        ENDDO
                      ENDDO
                    ENDDO
                ENDDO   
            ENDDO   
            NTION = NNN
            DO I = 1, NTION
                DO J = 1, 3
                    P(J,I)   = Q(J,I)
                    V10(J,I) = VQ10(J,I)
                    P0(J,I)  = Q0(J,I)
                ENDDO 
            ENDDO   
            NELM = 0
            DO 360  IO = 1, NCOMPO
                NION(IO) = NION(IO) * Nx * Ny * Nz
                IONS(1,IO) = NELM + 1
                NELM       = NELM + NION(IO)
                IONS(2,IO) = NELM
  360       CONTINUE
            box(1) = box(1) * Nx
            box(2) = box(2) * Ny
            box(3) = box(3) * Nz
            WRITE (*,9005)  (BOX(I),I=1,3),DENSTY
 9005       FORMAT (6X,'Basic cell :',3F9.4,' A',  &
                    6X,'Density :',F7.4, ' g/cm3' // &
                    6X,'<<<< Please change file05.dat by editor >>>>'/)
!           ------------------------------------------ End of Case 2 & 3
      end if
!
      if (select == 4)  then
!           ----------------------------------------------------- Case 4
            write (6,*)  'What axis ? 1:x, 2:y, 3:z'
            read  (5,*)  iax
            if (iax  ==  1) ax = 'x'
            if (iax  ==  1) lc = 'A'
            if (iax  ==  2) ax = 'y'
            if (iax  ==  2) lc = 'B'
            if (iax  ==  3) ax = 'z'
            if (iax  ==  3) lc = 'C'
            write (6,*)  'The slab is at 1:ceter of basic cell, or ', &
                                        '2:',ax,' =0 coordinate'
            read  (5,*)  choose
                              zbase = 0.0d0
            if (choose == 1)  zbase = 0.25d0
            write (6,*)  lc,'-length is multiplied by 1:2  or  2:1.25'
            read  (5,*)  choice
                              amult = 2.0d0
            if (choice == 2)  then
                        amult = 1.25d0
                        if (choose == 1) zbase = 0.1
            end if
            DO 410  I = 1, NTION
                IF (P0(iax,I) > 1.0d0)  P0(iax,I) = P0(iax,I) - 1.0d0
                IF (P0(iax,I) < 0.0d0)  P0(iax,I) = P0(iax,I) + 1.0d0
                IF (P(iax,I) > 1.0d0)  P(iax,I) = P(iax,I) - 1.0d0
                IF (P(iax,I) < 0.0d0)  P(iax,I) = P(iax,I) + 1.0d0
!                    dp =  p(iax,i) - p0(iax,i)
!                if (dp >  0.5d0)  dp = dp - 1.0d0
!                if (dp < -0.5d0)  dp = dp + 1.0d0
                P0(iax,I) = P0(iax,I) / amult      + zbase
!                 p(iax,I) = p0(iax,I) + dp / amult
                p(iax,I) = p(iax,I) / amult + zbase
  410       CONTINUE
            box(iax) = box(iax) * amult
            DENSTY = DENSTY / amult
            WRITE (*,9006)  (BOX(I),I=1,3),DENSTY
 9006       FORMAT (6X,'Basic cell :',3F9.4,' A',6X,'Density :',F7.4, ' g/cm3' )
!           ---------------------------------------------- End of Case 4
      end if
!
      if (select == 5)  then
!           ----------------------------------------------------- Case 5
            DO I = 1, NTION
               do j = 1, 3
                     dp =  p(j,i) - p0(j,i)
                  if (dp >  0.5)  dp = dp - 1.0
                  if (dp < -0.5)  dp = dp + 1.0
                  IF (P0(j,I) > 1.0)  P0(j,I) = P0(j,I) - 1.0
                  IF (P0(j,I) < 0.0)  P0(j,I) = P0(j,I) + 1.0
                P0(j,I) = P0(j,I) / 2.0 + 0.25
                 p(j,I) = p0(j,I) + dp / 2.0
               enddo
            enddo   
            box(1) = box(1) * 2.0
            box(2) = box(2) * 2.0
            box(3) = box(3) * 2.0
            DENSTY = DENSTY / 8.0
            WRITE (*,9006)  (BOX(I),I=1,3),DENSTY
!           ---------------------------------------------- End of Case 5
      end if
!
      if (select == 6)  then
!           ----------------------------------------------------- Case 6
            do 610  n = 1, 11
                nzatom(n) = 0
  610       continue
            do 620  i = 1, ntion
               iz = int(p0(3,i)*10) + 1
               nzatom(iz) = nzatom(iz) + 1
  620       continue
            write (6,*) nzatom
            surfac = 0
            do 630  n = 1, 10
               if (nzatom(n) == 0)  surfac = 1
  630       continue
            if (surfac == 0)  write (6,*) 'The system has no sufaces.'
            if (surfac == 1)  write (6,*) 'The system has sufaces.'
            write (6,*) 'Trench along with  1:a-axis  or  2:b-axis  ? '
            read (5,*)  itx
            ipx = 2
            if (itx == 2)  ipx = 1
            ntion0=ntion
            ndela = 0
            DO 640  I = 1, NTION
               idela(i) = 1
!              if (abs(p0(ipx,i)-0.5) < 0.0001) then
               if (abs(p0(ipx,i)-0.5) < 0.0301) then
                     if (surfac == 1)  then
                           if (p0(3,i) > 0.49999)  then
                                 idela(i) = 0
                                 ndela    = ndela + 1
                           end if
                     else
                           if (p0(3,i) > 0.24999 .and. p0(3,i) < 0.75000)  then
                                 idela(i) = 0
                                 ndela    = ndela + 1
                           end if
                     end if
               end if
  640       CONTINUE
            ntion = 0
            DO IO = 1, NCOMPO
                DO I = IONS(1,IO), IONS(2,IO)
                   if (idela(i) == 0) then
                         write (6,9008) i,p0(1,i),p0(2,i),p0(3,i)
 9008                    format (11x,i6, 3f10.6)
                         nion(io) = nion(io) - 1
                   end if
                   if (idela(i) /= 0) then
                         ntion = ntion +1
                         DO J = 1, 3
                            P(J,ntion)   = p(J,I)
                            V10(J,ntion) = V10(J,I)
                            P0(J,ntion)  = p0(J,I)
                         enddo  
                   end if
                enddo
            enddo   
            NELM = 0
            DO 670  IO = 1, NCOMPO
                IONS(1,IO) = NELM + 1
                NELM       = NELM + NION(IO)
                IONS(2,IO) = NELM
  670       CONTINUE
            WRITE (*,9007)  ntion0, ndela, ntion
 9007       format ( 6x,'Original number of atoms in cell is ', i6 &
                    /6x,'The number of atoms deleted is      ', i6 &
                    /6x,'Resultant number of atoms is        ', i6 )
!           ---------------------------------------------- End of Case 6
      end if
!
      if (select == 7)  then
!           ----------------------------------------------------- Case 7
            z0 = 0.0
            DO 710  I = 1, NTION
                 z0 = z0 + p(3,I)
  710       CONTINUE
            Z0 = Z0 / NTION - 0.5
            DO 720  I = 1, NTION
                P(3,I)  = P(3,I)  - Z0
                P0(3,I) = P0(3,I) - Z0
  720       CONTINUE
            DO 730  I = 1, NTION
                P(3,I)   = 0.5 + (P(3,I)  - 0.5) * 0.9
                P0(3,I)  = 0.5 + (P0(3,I) - 0.5) * 0.9
                V10(3,i) = 5.0 - (0.5 - P(3,I)) * 0.1
  730       CONTINUE
!           ---------------------------------------------- End of Case 7
      end if
      if (select == 8)  then
!           ----------------------------------------------------- Case 8
            write (*,*) 'Please type amounts of shift (x, y, z) ', &
                        'in fractional coordinates'
            read (*,*) shift(1), shift(2), shift(3)
            DO I = 1, NTION
                do j = 1, 3
                    P(j,I)  = P(j,I)  + shift(j)
                    P0(j,I) = P0(j,I) + shift(j)
                enddo
            enddo
!           ---------------------------------------------- End of Case 8
      end if
      if (select == 9)  then
!           ----------------------------------------------------- Case 9
            write (6,*) 'Direction 1:x, 2:y, 3:z'
            read (5,*) iax
            DO 910  I = 1, NTION
                DO 905  K = 1, 3
                    Q(K,I)    = P(K,I)  
                    Q0(K,I)   = P0(K,I) 
                    VQ10(K,I) = V10(K,I)
  905           CONTINUE
  910       CONTINUE
!
            WRITE (6,*) 'Second data from file07.add'
            OPEN (17, FILE='file07.add', STATUS='OLD', &
                     ACCESS='SEQUENTIAL', FORM='FORMATTED' )
            READ (17,2701) TITLE2, N1,N2,NTION2, NCOMPO2, (NNN,I=1,9) 
            READ (17,2702) (ATOM2(I),I=1,NCOMPO2)
            READ (17,2703) (NION2(I),I=1,NCOMPO2)
            READ (17,2703) (IONS2(1,I),I=1,NCOMPO2)
            READ (17,2703) (IONS2(2,I),I=1,NCOMPO2)
            READ (17,2704) TEMP2, DELTM2,TMPGE2, SPRES2, &
                           DTIME2,  BOX2, &
                           DNSTY2,  VBOX2 
                NTIOND = 0
                DO 920  I = NTION+1, NTION+NTION2
                    IOND(I) = 1
                    READ (17,2705) (Q(J,I),J=1,3),DEFECT, &
                                   (VQ10(J,I),J=1,3),(Q0(J,I),J=1,3)
                    IF (DEFECT /= ' ') THEN
                           IOND(I) = 0
                           NTIOND  = NTIOND + 1
                           VQ10(1,I) = 0.0d0
                           VQ10(2,I) = 0.0d0
                           VQ10(3,I) = 0.0d0
                    END IF
  920           CONTINUE
                DO 930  I = NTION+1, NTION+NTION2
                    DO 925  K = 1, 3
                        Q(K,I)  = Q(K,I) 
                        Q0(K,I) = Q0(K,I)
  925               CONTINUE
  930           CONTINUE
                IF (NTIOND > 0) WRITE (*,7979) NTIOND
 7979                  FORMAT (1X,I6,' DEFECTS WERE DETECTED ')
 2701           FORMAT (15A4,2I5 / I7,I3, 3I10,7I5 )
 2702           FORMAT (11(2X,A4) )
 2703           FORMAT (11I6 )
 2704           FORMAT (F10.2,F10.4,F10.2, 3F10.5 / &
                        E10.3, 10X, 6F10.6 /  &
                        F10.6, 10X, 6F10.6 ) 
 2705           FORMAT (3F10.8, A1, 3F9.7, 1X, 3F10.7,1x,i2)
            CLOSE  (17)
!
            box3 = box(iax) + box2(iax)
            N = 0
            DO 970  IO = 1, NCOMPO
                NI1 = N + 1
                DO  940  I = IONS(1,IO), IONS(2,IO)
                    N = N + 1
                    DO 935  K = 1, 3
                        P(K,N)   = Q(K,I) 
                        P0(K,N)  = Q0(K,I)
                        V10(K,N) = VQ10(K,I)
  935               CONTINUE
                        P(iax,N)   = Q(iax,I)  * box(iax)/box3
                        P0(iax,N)  = Q0(iax,I) * box(iax)/box3
  940           CONTINUE
                DO  960  JO = 1, NCOMPO2
                    IF (ATOM(IO) == ATOM2(JO) .AND. NION2(JO) > 0)  THEN
                          DO 950  J = IONS2(1,JO), IONS2(2,JO)
                              JN = J + NTION
                              N = N + 1
                              DO 945  K = 1, 3
                                  P(K,N)   = Q(K,JN) 
                                  P0(K,N)  = Q0(K,JN)
                                  V10(K,N) = VQ10(K,JN)
  945                         CONTINUE
                          P(iax,N) =(box(iax)+Q(iax,JN) *box2(iax))/box3
                          P0(iax,N)=(box(iax)+Q0(iax,JN)*box2(iax))/box3
  950                     CONTINUE
                          NION(IO)   = NION(IO) + NION2(JO)
                          NION2(JO) = 0
                    END IF
  960           CONTINUE
                IONS(1,IO) = NI1
                IONS(2,IO) = N
  970       CONTINUE
            DO 980  JO = 1, NCOMPO2
                NI1 = N + 1
                IF (NION2(JO) <= 0)  GO TO 980
                DO 965  I = IONS2(1,JO), IONS2(2,JO)
                    N = N + 1
                    DO 963  K = 1, 3
                        P(K,N)   = Q(K,I+NTION) 
                        P0(K,N)  = Q0(K,I+NTION)
                        V10(K,N) = VQ10(K,I+NTION)
  963               CONTINUE
                  P(iax,N) = (box(iax)+ Q(iax,I+NTION) *box2(iax)) /box3
                  P0(iax,N)= (box(iax)+ Q0(iax,I+NTION)*box2(iax)) /box3
  965           CONTINUE
                NCOMPO = NCOMPO + 1
                ATOM(NCOMPO) = ATOM2(JO)
                NION(NCOMPO) = NION2(JO)
                IONS(1,NCOMPO) = NI1
                IONS(2,NCOMPO) = N
  980       CONTINUE
            NJOB(1) = 0
            NJOB(2) = 0
            ntion = N
            NRECRD(6) = 0
            BOX(iax) = BOX(iax) + BOX2(iax)
!           ---------------------------------------------- End of Case 9
      END IF
      if (select == 10)  then
!           ---------------------------------------------------- Case 10
            write (6,*) 'Please type an integer to randomize'
            read (5,*) kkk
            do 1001  i = 1, kkk
                call  random
 1001       continue
            do i = nion(1)+1, ntion
                call  random
                j = nion(1) + 1 + int(r1 * nion(2))
                if (j > nion(1)+nion(2))  j = nion(1) + nion(2)
                if (i /= j)  then
                      do k = 1, 3
                          ppp    = P(k,I)
                          p(k,i) = p(k,j)
                          p(k,j) = ppp
                          vvv      = v10(k,I)
                          v10(k,i) = v10(k,j)
                          v10(k,j) = vvv
                          ppp     = P0(k,I)
                          p0(k,i) = p0(k,j)
                          p0(k,j) = ppp
                      enddo   
                end if
            enddo   
!           --------------------------------------------- End of Case 10
      end if
      if (select == 11)  then
!           ---------------------------------------------------- Case 11
            do i= 1,3
              rpx(1,i) = 0.0
              rpx(2,i) = 1.0
            enddo
 1155       write(*,*) 'Structure: 1:Bulk, 2:Sheet?'
            read(*,*) istr
            if (istr /= 1 .and. istr /= 2) goto 1155 
            if (istr == 2) then
 1151         write(*,*) 'Sheet perpendicular to 1:x, 2:y, 3:z ?'
              read(*,*) ipx
              if (ipx < 1 .or. ipx > 3) goto 1151
              rpx(1,ipx) = 0.20d0
              rpx(2,ipx) = 0.80d0
              write(*,*) 'Range of sheet ', rpx(1,ipx),rpx(2,ipx), 'OK (y,n)?'
              read(*,*) answer
              if (answer == 'N' .or. answer == 'n') then
 1154            write(*,*) 'Input range from 0 to 1 (eg. 0.5,0.6)'
                 read(*,*)rpx(1,ipx),rpx(2,ipx)
                  if (rpx(1,ipx) > rpx(2,ipx)) goto 1154
                  if (rpx(1,ipx) < 0.0) goto 1154
                  if (rpx(2,ipx) > 1.0) goto 1154
              endif
            endif
            write (6,*) 'Type element in capital or H3Op or H2O'
            read (5,3001)  aatom
 3001       format (A4)
            if (aatom  ==  'H3Op' .or. aatom == 'H2O') then 
 1131         write(*,*)'Select mode'
              write(*,*)'1: Add H3Op or H2O'
              write(*,*)'2: Replace ions to H3Op or H2O'
              read(*,*)mh3o
              if (mh3o  /=  1 .and. mh3o  /=  2) goto 1131
              write(6,*) 'Type number of the H3O+ or H2O  in integer'
              read (5,*)  natom
              if (mh3o  ==  2) then
                write(*,*) 'Type the component number of replaced ions'
                read(*,*) nrcom
                write(*,*) atom(nrcom), 'is selected.'
                write(*,*) 'Type the starting number of replaced ions.'
                read(*,*) nratom
              endif
            endif
            if (aatom  /=  'H3Op' .and. aatom /= 'H2O') then 
 1132         write(*,*)'Select mode'
              write(*,*)'1: Add ions'
              write(*,*)'2: Replace ions'
              read(*,*)mh3o
              if (mh3o  /=  1 .and. mh3o  /=  2) goto 1132
              if (mh3o  ==  2) then
                do io = 1, ncompo
                  do j = ions(1,io),ions(2,io)
                    eind(j) = io
                  enddo
                enddo
                nscompo = ncompo
                natom = 1
 1113           write(*,'("Input the index of atoms >>> ")',advance = 'no')
                read(*,*) id
                if (id < 1 .or. id > ntion) goto 1113
                write(*,'("Substituted atom: ")')
                do io = 1,ncompo
                  if (id >= ions(1,io)) then
                    iele = io
                  endif
                enddo
                write(*,'(a4,1x,3(f8.5,1x))')ATOM(iele),p(1,id),p(2,id),p(3,id)
 1102           write(*,'("Choose elements")')
                do io = 1,nscompo
                  write(*,'(i2,":",1x, a4)')io,ATOM(io)
                enddo
                write(*,'(" 0:",1x,"Manual input")')
                read(*,*) subio
                if (subio > nscompo .or. subio < 0) goto 1102
                if (subio > 0) patom = ATOM(subio)
                if (subio == 0) then
                  write(*,'("Enter the elements name (e.g. Na) >>> ")',advance ='no')
                  read(*,*) asub
                  if (len_trim(asub) == 1) patom = trim(asub)//"   "
                  if (len_trim(asub) == 2) patom = trim(asub)//"  "
                  subio = nscompo + 1
                  nscompo = nscompo + 1
                  ATOM(nscompo) = patom
                  do io = 1, nscompo-1
                    if (ATOM(io) == patom) then
                      write(*,'("This element is the same as the ",a4,", index = ",1x,i2)') ATOM(io),io
                      subio = io
                      nscompo = nscompo -1
                    endif
                  enddo
                endif
                write(*,'("Replaced from ", a4,1x, "to ", a4,".")')ATOM(iele),patom
                irm(1) = id 
                eind(irm(1)) = subio
                nion(iele) = nion(iele) -1
                nion(subio) = nion(subio) + 1
              endif
              if (mh3o == 1) then 
                write (*,*) 'Type number of the atoms in integer'
                read (*,*)  natom
              endif
 1103         write (*,'("Hydrated ions? (y,n) >>> ")',advance='no') 
              read(*,*) ah
              if (ah /= 'y' .and. ah /= 'n' .and. ah /= 'Y' .and. ah /= 'N') goto 1103
              hmode = 0
              if (ah == 'y' .or. ah == 'Y') then
                hmode = 1
 1110           write(*,'("Input the hydration number >>>")',advance='no')
                read(*,*) nh2o
                if (nh2o <= 0) goto 1110
 1156           write(*,'("1:h2o or 2:oh >>> ")',advance='no')
                read(*,*) imoh
                if (imoh /= 1 .and. imoh /= 2) goto 1156
!                nh2o  = 6
              endif
            endif
!
            if (aatom  /=  'H3Op' .and. aatom /= 'H2O') then
              vspace = 2.8
              if (hmode == 1) vspace = 4.0
              if (hmode == 0) then
                if (mh3o == 1) then   !Add ions
                write(*,'("Xrange : ",F8.4,1x,F8.4)')rpx(1,1),rpx(2,1)
                write(*,'("Yrange : ",F8.4,1x,F8.4)')rpx(1,2),rpx(2,2)
                write(*,'("Zrange : ",F8.4,1x,F8.4)')rpx(1,3),rpx(2,3)
1167              write(*,'("Input an integer for randomize >>> ")',advance='no')
                  read(*,*) kran
                  if (kran < 0) goto 1167
                  do k = 1, kran
                    call random
                  enddo
                  do 1109  n = 1, natom
 1101               call random
                    px = r1
                    py = r2
                    pz = r3
                    if (px < rpx(1,1) .or. px > rpx(2,1)) goto 1101
                    if (py < rpx(1,2) .or. py > rpx(2,2)) goto 1101
                    if (pz < rpx(1,3) .or. pz > rpx(2,3)) goto 1101
                    do i = 1, ntion+n-1
                      dx = abs(px - p(1,i))
                      dy = abs(py - p(2,i))
                      dz = abs(pz - p(3,i))
                      if  (dx > 0.5)  dx = 1.0 - dx
                      if  (dy > 0.5)  dy = 1.0 - dy
                      if  (dz > 0.5)  dz = 1.0 - dz
                      r2 = (dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2
                      if (r2 < vspace**2)  goto 1101
                    enddo   
                    p(1,ntion+n) = px
                    p(2,ntion+n) = py
                    p(3,ntion+n) = pz
                    p0(1,ntion+n) = px
                    p0(2,ntion+n) = py
                    p0(3,ntion+n) = pz
                    v10(1,ntion+n) = 5.0
                    v10(2,ntion+n) = 5.0
                    v10(3,ntion+n) = 5.0
 1109             continue
                  ncompo = ncompo + 1
                  nion(ncompo) = natom
                  atom(ncompo) = aatom
                  ions(1,ncompo) = ions(2,ncompo-1) + 1
                  ions(2,ncompo) = ions(1,ncompo) +natom -1
                  ntion = ntion + natom
                elseif (mh3o == 2) then   !Replace ions
                  ncompo = nscompo
                  k = 0
                  do io = 1, ncompo
                    if (nion(io) == 0) then
                      do jj = io, ncompo-1
                        ATOM(jj) = ATOM(jj+1)
                      enddo
                      do ii = 1,ntion
                        if (eind(ii) > io) eind(ii) = eind(ii)-1
                      enddo
                    elseif (nion(io) /= 0) then
                      k = k + 1
                      nnion(k) = nion(io)
                    endif
                  enddo
                  ncompo = k
                  do io = 1,ncompo
                    nion(io) = nnion(io)
                  enddo
                  ions(1,1) = 1
                  ions(2,1) = nion(1)
                  do io = 2, ncompo
                    ions(1,io) = ions(2,io-1) + 1
                    ions(2,io) = ions(2,io-1) + nion(io)
                  enddo
!
                  do io = 1, ncompo
                    ix = 0
                    do i = 1,ntion
                      if (io == eind(i)) then
                        ix = ix + 1
                        ppx(io,ix) = p(1,i)
                        ppy(io,ix) = p(2,i)
                        ppz(io,ix) = p(3,i)
                      endif
                    enddo
                  enddo
!
                  ii = 1
                  do io = 1, ncompo
                    do ix = 1,nion(io)
                      p(1,ii) = ppx(io,ix)
                      p(2,ii) = ppy(io,ix)
                      p(3,ii) = ppz(io,ix)
                      ii = ii + 1
                    enddo
                  enddo
                endif
!
              elseif (hmode == 1) then
                dintra0 = 1.900d0  !distance from ion to oxygen of water
                dintra1 = 0.977d0
                nio2 = natom
                nih2 = natom+natom*nh2o
                if (mh3o == 2) then
                  nio2 = 0
                  nih2 = nh2o
                endif
                do 1199  n = 1, natom
                  if (mh3o == 1) then  ! Add ions  
 1191               call random
                    px = r1
                    py = r2
                    pz = r3
                    if (px < rpx(1,1) .or. px > rpx(2,1)) goto 1191
                    if (py < rpx(1,2) .or. py > rpx(2,2)) goto 1191
                    if (pz < rpx(1,3) .or. pz > rpx(2,3)) goto 1191
                    do i = 1, ntion+n-1
                      dx = abs(px - p(1,i))
                      dy = abs(py - p(2,i))
                      dz = abs(pz - p(3,i))
                      if  (dx > 0.5)  dx = 1.0 - dx
                      if  (dy > 0.5)  dy = 1.0 - dy
                      if  (dz > 0.5)  dz = 1.0 - dz
                      r2 = (dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2
                      if (r2 < vspace**2)  goto 1191
                    enddo
                    p(1,ntion+n) = px
                    p(2,ntion+n) = py
                    p(3,ntion+n) = pz
                    p0(1,ntion+n) = px
                    p0(2,ntion+n) = py
                    p0(3,ntion+n) = pz
                    v10(1,ntion+n) = 5.0
                    v10(2,ntion+n) = 5.0
                    v10(3,ntion+n) = 5.0
                    px = px*box(1)
                    py = py*box(2)
                    pz = pz*box(3)
                  elseif (mh3o == 2) then ! Replace ions
                    ncompo = nscompo
                    k = 0
                    do io = 1, ncompo
                      if (nion(io) == 0) then
                        do jj = io, ncompo-1
                          ATOM(jj) = ATOM(jj+1)
                        enddo
                        do ii = 1,ntion
                          if (eind(ii) > io) eind(ii) = eind(ii)-1
                        enddo
                      elseif (nion(io) /= 0) then
                        k = k + 1
                        nnion(k) = nion(io)
                      endif
                    enddo
                    ncompo = k
                    do io = 1,ncompo
                      nion(io) = nnion(io)
                    enddo
                    ions(1,1) = 1
                    ions(2,1) = nion(1)
                    do io = 2, ncompo
                      ions(1,io) = ions(2,io-1) + 1
                      ions(2,io) = ions(2,io-1) + nion(io)
                    enddo
!
                    do io = 1, ncompo
                      ix = 0
                      do i = 1,ntion
                        if (io == eind(i)) then
                          ix = ix + 1
                          ppx(io,ix) = p(1,i)
                          ppy(io,ix) = p(2,i)
                          ppz(io,ix) = p(3,i)
                        endif
                      enddo
                    enddo
!
                    px = p(1,id)*box(1)
                    py = p(2,id)*box(2)
                    pz = p(3,id)*box(3)
                    write(*,*) px/box(1),py/box(2),pz/box(3)
                    ii = 1
                    do io = 1, ncompo
                      do ix = 1,nion(io)
                        p(1,ii) = ppx(io,ix)
                        p(2,ii) = ppy(io,ix)
                        p(3,ii) = ppz(io,ix)
                        ii = ii + 1
                      enddo
                    enddo
!
!                   -----------------------Search for neiboring ions around the replaced ions
                    neib = 0
                    do i = 1, ntion
                      if (i == id) cycle
                      dx = abs(px/box(1) - p(1,i))
                      dy = abs(py/box(2) - p(2,i))
                      dz = abs(pz/box(3) - p(3,i))
                      if  (dx > 0.5)  dx = 1.0 - dx
                      if  (dy > 0.5)  dy = 1.0 - dy
                      if  (dz > 0.5)  dz = 1.0 - dz
                      r2 = (dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2
                      if (r2 < 2.2d0**2) then
                        neib = neib + 1
                        ineib(neib) = i
                      endif
                    enddo
                  endif
                  if (neib > 0) then
                    do i = 1, neib
                      write (*,*) 'Neiboring atoms: ', ineib(i)
                    enddo
                  endif
                  do i = 1, nh2o
 1193               CALL  RANDOM                       !  O atom
                    !   -1.0  < 2*r1-1.0 < 1.0
                    !srd:magnitude of vector((2*r1-1.0)*box(1),(2*r2-1.0)*box(2),(2*r3-1.0)*box(3))
                    srd=sqrt(((2*r1-1.0)*box(1))**2 +((2*r2-1.0)*box(2))**2+((2*r3-1.0)*box(3))**2)
                    PX1 = px + (2*r1-1.0) * box(1) * dintra0 / srd
                    PY1 = py + (2*r2-1.0) * box(2) * dintra0 / srd
                    PZ1 = pz + (2*r3-1.0) * box(3) * dintra0 / srd
                    po(1,i) = px1
                    po(2,i) = py1
                    po(3,i) = pz1
                    if (neib > 0) then
                      do idd = 1, neib
                        dx = (p(1,ineib(idd))*box(1) -px1)/box(1)
                        dy = (p(2,ineib(idd))*box(2) -py1)/box(2)
                        dz = (p(3,ineib(idd))*box(3) -pz1)/box(3)
                        if  (dx >  0.5)  dx = dx - 1.0
                        if  (dx < -0.5)  dx = dx + 1.0
                        if  (dy >  0.5)  dy = dy - 1.0
                        if  (dy < -0.5)  dy = dy + 1.0
                        if  (dz >  0.5)  dz = dz - 1.0
                        if  (dz < -0.5)  dz = dz + 1.0
                        ddd = (dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2
                        write(*,*) idd,ddd
                        if (ddd < 3.5d0) goto 1193
                      enddo
                    endif
                    if (i > 1) then
                      dx0 = (px1-px)/box(1)
                      dy0 = (py1-py)/box(2)
                      dz0 = (pz1-pz)/box(3)
                      if  (dx0 >  0.5)  dx0 = dx0 - 1.0
                      if  (dx0 < -0.5)  dx0 = dx0 + 1.0
                      if  (dy0 >  0.5)  dy0 = dy0 - 1.0
                      if  (dy0 < -0.5)  dy0 = dy0 + 1.0
                      if  (dz0 >  0.5)  dz0 = dz0 - 1.0
                      if  (dz0 < -0.5)  dz0 = dz0 + 1.0
                      do j = 1,i-1
                        dx = (po(1,j)-px)/box(1)
                        dy = (po(2,j)-py)/box(2)
                        dz = (po(3,j)-pz)/box(3)
                        if  (dx >  0.5)  dx = dx - 1.0
                        if  (dx < -0.5)  dx = dx + 1.0
                        if  (dy >  0.5)  dy = dy - 1.0
                        if  (dy < -0.5)  dy = dy + 1.0
                        if  (dz >  0.5)  dz = dz - 1.0
                        if  (dz < -0.5)  dz = dz + 1.0
                        vv=(dx*dx0*box(1)**2+dy*dy0*box(2)**2+dz*dz0*box(3)**2)/dintra0**2
                        if (vv >= 0.30)  go to 1193
                        if (vv < -0.174 .and. vv > -0.939) goto 1193
                      enddo
                    endif
                    write(*,*)'h2o=',i
                    CALL  RANDOM                       !  1st H atom
                    srd=sqrt(((2*r1-1.0)*box(1))**2 +((2*r2-1.0)*box(2))**2+((2*r3-1.0)*box(3))**2)
                    PX2 = px1 + (2*r1-1.0) * box(1) * dintra1 / srd
                    PY2 = py1 + (2*r2-1.0) * box(2) * dintra1 / srd
                    PZ2 = pz1 + (2*r3-1.0) * box(3) * dintra1 / srd
                    if (imoh == 1) then 
 1195                 call  random                       !  2nd H atom
                      srd=sqrt(((2*r1-1.0)*box(1))**2 +((2*r2-1.0)*box(2))**2+((2*r3-1.0)*box(3))**2)
                      PX3 = px1 + (2*r1-1.0) * box(1) * dintra1 / srd
                      PY3 = py1 + (2*r2-1.0) * box(2) * dintra1 / srd
                      PZ3 = pz1 + (2*r3-1.0) * box(3) * dintra1 / srd
                      vv =((px2-px1)*(px3-px1) +(py2-py1)*(py3-py1) +(pz2-pz1)*(pz3-pz1))/dintra1**2
!                      write (6,*)  vv
                      if (vv >= 0.0 .or. vv <= -0.5)  go to 1195
                    endif
!
write(*,*) 'nio2 = ', nio2
                    nio2 = nio2 +1
                    p(1,ntion+nio2) = px1/box(1)
                    p(2,ntion+nio2) = py1/box(2)
                    p(3,ntion+nio2) = pz1/box(3)
                    p0(1,ntion+nio2) = px1/box(1)
                    p0(2,ntion+nio2) = py1/box(2)
                    p0(3,ntion+nio2) = pz1/box(3)
                    v10(1,ntion+nio2) = 5.0
                    v10(2,ntion+nio2) = 5.0
                    v10(3,ntion+nio2) = 5.0
                    nih2 = nih2 + 1
                    p(1,ntion+nih2) = px2/box(1)
                    p(2,ntion+nih2) = py2/box(2)
                    p(3,ntion+nih2) = pz2/box(3)
                    p0(1,ntion+nih2) = px2/box(1)
                    p0(2,ntion+nih2) = py2/box(2)
                    p0(3,ntion+nih2) = pz2/box(3)
                    v10(1,ntion+nih2) = 5.0
                    v10(2,ntion+nih2) = 5.0
                    v10(3,ntion+nih2) = 5.0
                    if (imoh == 1) then
                      nih2 = nih2 + 1
                      p(1,ntion+nih2) = px3/box(1)
                      p(2,ntion+nih2) = py3/box(2)
                      p(3,ntion+nih2) = pz3/box(3)
                      p0(1,ntion+nih2) = px3/box(1)
                      p0(2,ntion+nih2) = py3/box(2)
                      p0(3,ntion+nih2) = pz3/box(3)
                      v10(1,ntion+nih2) = 5.0
                      v10(2,ntion+nih2) = 5.0
                      v10(3,ntion+nih2) = 5.0
                    endif
                  enddo
                    IF (MOD(n, 1) == 0)  WRITE (6,1121) n
 1121               FORMAT (1X,I5,$)
 1199           continue
!
!
write(*,*) 'ntion = ',ntion
                if (imoh == 1) nnnn = 3
                if (imoh == 2) nnnn = 2
                noi = ntion + natom + nnnn*natom*nh2o
                if (mh3o == 2) noi = noi -natom
                do i = 1, noi 
                  do j= 1,3
                    pp(j,i) = p(j,i)
                    q0(j,i) = p0(j,i)
                    vq10(j,i) = v10(j,i)
                  enddo
                enddo
!
               
               iwater = 0
               if(ioxy /= 0 .and. imoh == 1) iwater = 1  !water exists and add water
!              write(*,*) 'ioxy = ',ioxy, 'iwater =', iwater
!
!
!               -- renumber the original atoms ------------------
                if (iwater == 1) then
                  n = natom*nh2o   ! Total number of oxygen by added h2o
                  do io = 1, ncompo
                    if (io <= ioxy) cycle
!                    write(*,*) 'io = ', io
                    if (io > ih) n = natom*nh2o*nnnn
                    do i = ions(1,io),ions(2,io)
                      do j = 1, 3
                        p  (j,i+n) = pp(j,i)
                        p0 (j,i+n) = q0(j,i)
                        v10(j,i+n) = vq10(j,i)
                      enddo
!                      write(*,*)p(1,i+n),p(2,i+n),p(3,i+n)
                    enddo
                  enddo
                endif
!               -------------------------------------------------

                if(iwater == 1) then
                  if (mh3o == 1) then
                    ncompo = ncompo + 1
                    nion(ncompo) = natom
                    atom(ncompo) = aatom
                    if (ioxy /= 1) ions(1,ioxy) = ions(2,ioxy-1) + 1
                    noxy = nion(ioxy)
                    nhy  = nion(ih)
                  endif
                else  ! iwater = 0
                  ncompo = ncompo + 3
                  if (mh3o == 2) then
                    ncompo = ncompo -1
                    ioxy = ncompo -1
                    ih = ncompo
                  endif
                  if (mh3o == 1) then
                    nion(ncompo) = natom
                    atom(ncompo) = aatom
                    ioxy = ncompo-2
                    ih = ioxy+1
                  endif
                  atom(ioxy) = 'O   '
                  atom(ih) = 'H   '
                  ions(1,ioxy) = ions(2,ioxy-1) + 1
                  noxy = 0   ! Number of oxygen of oh before adding oh
                  nhy = 0
                endif
!
                ions(2,ioxy) = ions(1,ioxy) + natom*nh2o + noxy - 1
                nion(ioxy) = noxy + natom*nh2o
                ions(1,ih) = ions(2,ih-1) + 1
                ions(2,ih) = ions(1,ih) + natom*nh2o*(nnnn-1) + nhy -1
                nion(ih) = nhy + natom*nh2o*(nnnn-1)
                if (ih+1 /= ncompo) then
                  do io = ih+1, ncompo-1
                    ions(1,io) = ions(2,io-1)+1
                    ions(2,io) = ions(2,io-1)+nion(io)
                  enddo
                endif
                if (mh3o == 1) then
                  ions(1,ncompo) = ions(2,ncompo-1) + 1
                  ions(2,ncompo) = ions(1,ncompo) +natom -1
                  ntion = ntion + natom + nnnn*natom*nh2o
                elseif (mh3o == 2) then
                  ntion = ntion + nnnn*natom*nh2o
                endif
!
!
                nsion = ntion - natom*nh2o*nnnn-natom
                nonum = ntion - natom*nh2o*nnnn
                nhnum = ntion - natom*nh2o*(nnnn-1)
!
!               --input the added H2O molecules------------------
                 k = 0
                  do i = ions(2,ioxy)-natom*nh2o+1, ions(2,ioxy)
                    k = k+1
                    do j= 1,3
                      p(j,i) = pp(j,nonum+k)
                      p0(j,i) = q0(j,nonum+k)
                      v10(j,i) = vq10(j,nonum+k)
                    enddo
                  enddo
                  k = 0
                  do i = ions(2,ih)-natom*nh2o*(nnnn-1)+1, ions(2,ih)
                    k = k+1
                    do j= 1,3
                      p(j,i) = pp(j,nhnum+k)
                      p0(j,i) = q0(j,nhnum+k)
                      v10(j,i) = vq10(j,nhnum+k)
                    enddo
                  enddo
!               -------------------------------------------------
                if (mh3o == 1) then
!                 -- input the added ions--------------------------
                  k = 0
                  do i = ions(1,ncompo), ions(2,ncompo)
                    k = k+1
                    do j = 1,3
                      p(j,i) = pp(j,nsion+k)
                      p0(j,i) = q0(j,nsion+k)
                      v10(j,i) = vq10(j,nsion+k)
                    enddo
                  enddo
                endif
!               -------------------------------------------------
!               -- input the original H2O------------------------
!                if(iwater == 0) then
!                  k = 0
!                  do i = ions(1,ioxy),ions(2,ih)
!                    k = k+1
!                    do j= 1,3
!                      p(j,i) = pp(j,nonum+k)
!                      p0(j,i) = q0(j,nonum+k)
!                      v10(j,i) = vq10(j,nonum+k)
!                    enddo
!                  enddo
!                elseif (iwater == 1) then
!                  k = 0
!                  do io = ioxy,ih
!                    if (io == ioxy) n = ions(2,ioxy) - natom*nh2o
!                    if (io == ih) n = ions(2,ih) -natom*nh2o*2
!                    do i = n+1, ions(2,io)
!                      k = k+1
!                      do j = 1,3
!                        p(j,i) = pp(j,k+nonum)
!                        p0(j,i) = q0(j,k+nonum)
!                        v10(j,i) = vq10(j,k+nonum)
!                      enddo
!                    enddo
!                  enddo
!                endif
              endif
            endif
!
            if (aatom  ==  'H3Op' .or. aatom == 'H2O') then
write(*,*) 'Check 1'
              if (mh3o  ==  1) nio2 = natom
              if (mh3o  ==  2) nio2 = 0
              dintra = 0.977d0
1166          write(*,'("Input an integer for randomize >>> ")',advance='no')
              read(*,*) kran
              if (kran < 0) goto 1166
              do k = 1, kran
                call random
              enddo
write(*,*) rpx(1,1),rpx(2,1)
write(*,*) rpx(1,2),rpx(2,2)
write(*,*) rpx(1,3),rpx(2,3)

              do 1119  n = 1, natom
               if (mh3o  ==  1) then
 1111           call random                       ! oxygen atom
                px1 = r1
                py1 = r2
                pz1 = r3
                  if (px1 < rpx(1,1) .or. px1 > rpx(2,1)) goto 1111
                  if (py1 < rpx(1,2) .or. py1 > rpx(2,2)) goto 1111
                  if (pz1 < rpx(1,3) .or. pz1 > rpx(2,3)) goto 1111
                do 1112 i = 1, ntion+n-1
                  dx = abs(px1 - p(1,i))
                  dy = abs(py1 - p(2,i))
                  dz = abs(pz1 - p(3,i))
                  if  (dx > 0.5)  dx = 1.0 - dx
                  if  (dy > 0.5)  dy = 1.0 - dy
                  if  (dz > 0.5)  dz = 1.0 - dz
                  r2 = (dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2
                  if (r2 < 2.8**2)  goto 1111
 1112           continue
                p(1,ntion+n) = px1
                p(2,ntion+n) = py1
                p(3,ntion+n) = pz1
                p0(1,ntion+n) = px1
                p0(2,ntion+n) = py1
                p0(3,ntion+n) = pz1
                v10(1,ntion+n) = 5.0
                v10(2,ntion+n) = 5.0
                v10(3,ntion+n) = 5.0
                px1 = px1*box(1)
                py1 = py1*box(2)
                pz1 = pz1*box(3)
               endif
               if (mh3o  ==  2) then
                 pxx1 = p(1,nratom)
                 pyy1 = p(2,nratom)
                 pzz1 = p(3,nratom)
                 do i = nratom, ntion-1
                   p(1,i) = p(1,i+1)
                   p(2,i) = p(2,i+1)
                   p(3,i) = p(3,i+1)
                   p0(1,i) = p0(1,i+1)
                   p0(2,i) = p0(2,i+1)
                   p0(3,i) = p0(3,i+1)
                   v10(1,i) = v10(1,i+1)
                   v10(2,i) = v10(2,i+1)
                   v10(3,i) = v10(3,i+1)
                 enddo
                 p(1,ntion) = pxx1
                 p(2,ntion) = pyy1
                 p(3,ntion) = pzz1
                 p0(1,ntion) = pxx1
                 p0(2,ntion) = pyy1
                 p0(3,ntion) = pzz1
                 v10(1,ntion) = 5.0
                 v10(2,ntion) = 5.0
                 v10(3,ntion) = 5.0
                 px1 = pxx1*box(1)
                 py1 = pyy1*box(2)
                 pz1 = pzz1*box(3)
               endif
!
                CALL  RANDOM                       !  1st H atom
                srd = sqrt(((2*r1-1.0)*box(1))**2 +((2*r2-1.0)*box(2))**2+((2*r3-1.0)*box(3))**2)
                PX2 = px1 + (2*r1-1.0) * box(1) * dintra / srd
                PY2 = py1 + (2*r2-1.0) * box(2) * dintra / srd
                PZ2 = pz1 + (2*r3-1.0) * box(3) * dintra / srd
 1150           call  random                       !  2nd H atom
                srd = sqrt(((2*r1-1.0)*box(1))**2 +((2*r2-1.0)*box(2))**2+((2*r3-1.0)*box(3))**2)
                PX3 = px1 + (2*r1-1.0) * box(1) * dintra / srd
                PY3 = py1 + (2*r2-1.0) * box(2) * dintra / srd
                PZ3 = pz1 + (2*r3-1.0) * box(3) * dintra / srd
                vv = ( (px2-px1)*(px3-px1) +(py2-py1)*(py3-py1) +(pz2-pz1)*(pz3-pz1) ) / dintra**2
!                write (6,*)  vv
                if (vv >= 0.0 .or. vv <= -0.5)  go to 1150
                if (aatom == 'H3Op') then
 1160             call  random                       !  3rd H atom
                  srd = sqrt(((2*r1-1.0)*box(1))**2 +((2*r2-1.0)*box(2))**2 +((2*r3-1.0)*box(3))**2)
                  PX4 = px1 + (2*r1-1.0) * box(1) * dintra / srd
                  PY4 = py1 + (2*r2-1.0) * box(2) * dintra / srd
                  PZ4 = pz1 + (2*r3-1.0) * box(3) * dintra / srd
                  vv = ( (px4-px1)*(px3-px1) +(py4-py1)*(py3-py1) +(pz4-pz1)*(pz3-pz1) ) / dintra**2
!                 write (6,*)  vv
                  if (vv >= 0.0 .or. vv <= -0.5)  go to 1160
                  vv = ( (px4-px1)*(px2-px1) +(py4-py1)*(py2-py1) +(pz4-pz1)*(pz2-pz1) ) / dintra**2
!                  write (6,*)  vv
                  if (vv >= 0.0 .or. vv <= -0.5)  go to 1160
                endif
!
                nio2 = nio2 + 1
                p(1,ntion+nio2) = px2/box(1)
                p(2,ntion+nio2) = py2/box(2)
                p(3,ntion+nio2) = pz2/box(3)
                p0(1,ntion+nio2) = px2/box(1)
                p0(2,ntion+nio2) = py2/box(2)
                p0(3,ntion+nio2) = pz2/box(3)
                v10(1,ntion+nio2) = 5.0
                v10(2,ntion+nio2) = 5.0
                v10(3,ntion+nio2) = 5.0
                nio2 = nio2 +1
                p(1,ntion+nio2) = px3/box(1)
                p(2,ntion+nio2) = py3/box(2)
                p(3,ntion+nio2) = pz3/box(3)
                p0(1,ntion+nio2) = px3/box(1)
                p0(2,ntion+nio2) = py3/box(2)
                p0(3,ntion+nio2) = pz3/box(3)
                v10(1,ntion+nio2) = 5.0
                v10(2,ntion+nio2) = 5.0
                v10(3,ntion+nio2) = 5.0
                if (aatom == 'H3Op') then
                  nio2 = nio2 + 1
                  p(1,ntion+nio2) = px4/box(1)
                  p(2,ntion+nio2) = py4/box(2)
                  p(3,ntion+nio2) = pz4/box(3)
                  p0(1,ntion+nio2) = px4/box(1)
                  p0(2,ntion+nio2) = py4/box(2)
                  p0(3,ntion+nio2) = pz4/box(3)
                  v10(1,ntion+nio2) = 5.0
                  v10(2,ntion+nio2) = 5.0
                  v10(3,ntion+nio2) = 5.0
                endif
                IF (MOD(n, 10) == 0)  WRITE (6,1121) n
 1119         continue
              if (mh3o  ==  1) then
                ncompo = ncompo + 2
              elseif (mh3o  ==  2) then
                if (natom  ==  nion(nrcom)) then
                  do j = nrcom, ncompo-1
                    atom(j) = atom(j+1)
                    nion(j) = nion(j+1)
                    ions(1,j) = ions(2,j-1) + 1
                    ions(2,j) = ions(2,j-1) + nion(j)
                    write(*,*)j, atom(j)
                  enddo
                  ncompo = ncompo + 1
                else if (natom  <  nion(nrcom)) then
                  nion(nrcom) = nion(nrcom) - natom
                  ions(2,nrcom) = ions(1,nrcom) + nion(nrcom) -1
                  do j = nrcom + 1, ncompo
                    ions(1,j) = ions(2,j-1) + 1
                    ions(2,j) = ions(2,j-1) + nion(j)
                  enddo
                  ncompo = ncompo + 2
                endif
              endif
              nion(ncompo-1) = natom
              if (aatom == 'H3Op') nion(ncompo) = natom*3
              if (aatom == 'H2O')  nion(ncompo) = natom*2
              atom(ncompo-1) = 'O   '
              atom(ncompo)   = 'H   '
              if (mh3o  ==  1) then
                ions(1,ncompo-1) = ions(2,ncompo-2) + 1
              elseif (mh3o  ==  2) then
                ions(1,ncompo-1) = ions(2,ncompo-2) + 1
              endif
              ions(2,ncompo-1) = ions(1,ncompo-1) +natom -1
              ions(1,ncompo)   = ions(2,ncompo-1) + 1
              if (aatom == 'H3Op') then
                ions(2,ncompo)   = ions(1,ncompo) + 3*natom -1
              elseif (aatom == 'H2O') then
                ions(2,ncompo)   = ions(1,ncompo) + 2*natom -1
              endif
              if (aatom == 'H3Op') then
                if (mh3o  ==  1) ntion = ntion + 4*natom
                if (mh3o  ==  2) ntion = ntion + 3*natom
              elseif (aatom == 'H2O') then
                if (mh3o  ==  1) ntion = ntion + 3*natom
                if (mh3o  ==  2) ntion = ntion + 2*natom
              endif
            endif
!           --------------------------------------------- End of Case 11
      end if
      if (select == 12)  then
!           ---------------------------------------------------- Case 12
            DO I = 1, NTION
                do j = 1, 3
                   V10(j,i) = 5.0
                enddo
            enddo
!           --------------------------------------------- End of Case 12
      end if
      if (select == 13)  then
!           ---------------------------------------------------- Case 13
            DO 1301  I = 1, NTION
                call  random
                V10(1,i) = 5.0 + (r1-0.5)*0.01
                V10(2,i) = 5.0 + (r2-0.5)*0.01
                V10(3,i) = 5.0 + (r3-0.5)*0.01
 1301       CONTINUE
!           --------------------------------------------- End of Case 13
      end if
      if (select == 14)  then
!           ---------------------------------------------------- Case 14
            write (6,*) ' 1: a <-> b    2: b <-> c    3: c <-> a'
            write (6,*) ' 4: a -> b ,b -> c, c -> a'
            Read (5,*)  choose
                if (choose == 1) then
                     bbb = box(1)
                     box(1) = box(2)
                     box(2) = bbb
                end if
                if (choose == 2) then
                     bbb = box(2)
                     box(2) = box(3)
                     box(3) = bbb
                end if
                if (choose == 3) then
                     bbb = box(3)
                     box(3) = box(1)
                     box(1) = bbb
                end if
                if (choose == 4) then
                     bbb1 = box(1)
                     bbb2 = box(2)
                     bbb3 = box(3)
                     bbb4 = box(4)
                     bbb5 = box(5)
                     bbb6 = box(6)
                     box(1) = bbb3
                     box(2) = bbb1
                     box(3) = bbb2
                     box(4) = bbb6
                     box(5) = bbb4
                     box(6) = bbb5
                endif
            DO 1401  I = 1, NTION
                if (choose == 1) then
                     ppp = p(1,i)
                     p(1,i) = p(2,i)
                     p(2,i) = ppp
                     ppp = p0(1,i)
                     p0(1,i) = p0(2,i)
                     p0(2,i) = ppp
                end if
                if (choose == 2) then
                     ppp = p(2,i)
                     p(2,i) = p(3,i)
                     p(3,i) = ppp
                     ppp = p0(2,i)
                     p0(2,i) = p0(3,i)
                     p0(3,i) = ppp
                end if
                if (choose == 3) then
                     ppp = p(3,i)
                     p(3,i) = p(1,i)
                     p(1,i) = ppp
                     ppp = p0(3,i)
                     p0(3,i) = p0(1,i)
                     p0(1,i) = ppp
                end if
                if (choose == 4) then
                     ppp1 = p(1,i)
                     ppp2 = p(2,i)
                     ppp3 = p(3,i)
                     p(1,i) = ppp3
                     p(2,i) = ppp1
                     p(3,i) = ppp2
                endif
 1401       CONTINUE
      end if
!           --------------------------------------------- End of Case 14
      if (select == 15)  then
!           ---------------------------------------------------- Case 15
            write (6,*)  'The shorten cell length   1:a  2:b  3:c'
            read  (5,*)  ia
            write (6,*)  'Range of subtraction (0 - 1)'
            read  (5,*)  amin, amax
            DO  I = 1, NTION
                pia = p(ia,i)
                IF (Pia > 1.0)  Pia = Pia - 1.0
                IF (Pia < 0.0)  Pia = Pia + 1.0
                if (Pia < amin) then
                      Pia = Pia / (1.0-(amax-amin))
                else if (pia > amax) then
                      pia = (pia-(amax-amin)) / (1.0-(amax-amin))
                end if
                P(ia,i) = pia
            end do
            box(ia) = box(ia) * (1.0-(amax-amin))
            DENSTY  = DENSTY / (1.0-(amax-amin))
            WRITE (*,9006)  (BOX(I),I=1,3),DENSTY
!           --------------------------------------------- End of Case 15
      end if
!
      if (select == 16)  then
!           ---------------------------------------------------- Case 16
 1601       write (*,*) 'Input Miller index: h,k,l'
            read (*,*) hh,k,l
            write (*,'("Miller index = (",3i1,"), ok (y,n)?")') hh,k,l
            read (*,*) ans
            if (ans  /=  'y' .and. ans  /=  'Y') go to 1601
            if (hh == 0 .and. k == 0 .and. l == 0) stop 'No meaning!!'
!
            itra2 = 0
!           ----------------------------------(h,k,l) -> (x,y,z)
            write(*,*)'lattice constants of input cell'
            write(*,'(f11.8,1x,f11.8,1x,f11.8)') box(1),box(2),box(3)
            write(*,'(f11.8,1x,f11.8,1x,f11.8)') box(4),box(5),box(6)
!
            call tmatrx
!
!           ------------ Calcuation of the plane as vector in xyz
            ntion = ntion + 1010
            do i = 1,ntion
              pp(1,i) = 0.0D0 !-0.5D0
              pp(2,i) = 0.0D0 !-0.5D0
              pp(3,i) = 0.0D0 !-0.5D0
            enddo
!
              if (hh == 0) pp(1,1) = 1.0d0
              if (hh /= 0) pp(1,1) = 1.0D0/dble(hh)
              if (k == 0)  pp(2,2) = 1.0d0
              if (k /= 0)  pp(2,2) = 1.0d0/dble(k)
              if (l == 0)  pp(3,3) = 1.0d0
              if (l /= 0)  pp(3,3) = 1.0d0/dble(l)
!
            call ptoxyz
!
!
            if (hh /= 0 .and. k /= 0 .and. l == 0) then
              write(*,*) '(hk0) mode' 
              aaa1(1) = q(1,2)-q(1,1)
              aaa1(2) = q(2,2)-q(2,1)
              aaa1(3) = q(3,2)-q(3,1)
              aaa2(1) = q(1,3)
              aaa2(2) = q(2,3)
              aaa2(3) = q(3,3)
              alength = dble(hh)*dble(k)
            elseif (hh == 0 .and. k /= 0 .and. l /= 0) then
              write(*,*) '(0kl) mode' 
              aaa1(1) = q(1,3)-q(1,2)
              aaa1(2) = q(2,3)-q(2,2)
              aaa1(3) = q(3,3)-q(3,2)
              aaa2(1) = q(1,1)
              aaa2(2) = q(2,1)
              aaa2(3) = q(3,1)
              alength = dble(k)*dble(l)
            elseif (hh /= 0 .and. k == 0 .and. l /= 0) then
              write(*,*) '(h0l) mode' 
              aaa1(1) = q(1,1)-q(1,3)
              aaa1(2) = q(2,1)-q(2,3)
              aaa1(3) = q(3,1)-q(3,3)
              aaa2(1) = q(1,2)
              aaa2(2) = q(2,2)
              aaa2(3) = q(3,2)
              alength = dble(hh)*dble(l)
            endif
!           --------------------- normal vector of (hkl) plane
            q(1,4) = aaa1(2)*aaa2(3)-aaa1(3)*aaa2(2)
            q(2,4) = aaa1(3)*aaa2(1)-aaa1(1)*aaa2(3)
            q(3,4) = aaa1(1)*aaa2(2)-aaa1(2)*aaa2(1)
!           --------------------------------------------------
!
!           --------------------- Calculation of rotational matrix
!             -- rotation around z axis
              cosz = q(1,4)/sqrt(q(1,4)**2+q(2,4)**2)
              sinz = sqrt(1.0d0-cosz**2)
              if (q(2,4) < 0.0d0) sinz = -sinz
!
!             -- rotation around y axis
              cosy = q(3,4)/sqrt(q(1,4)**2+q(2,4)**2+q(3,4)**2)
              siny =  sqrt(1.0d0-cosy**2)
              if ((cosz*q(1,4)+sinz*q(2,4)) < 0.0d0) siny = -siny
!
              coszz = (cosy*cosz*aaa1(1)+cosy*sinz*aaa1(2)+siny*aaa1(3))/ &
                      (sqrt(aaa1(1)**2+aaa1(2)**2+aaa1(3)**2))
              sinzz = sqrt(1.0d0-coszz**2)
              if ((-sinz*aaa1(1)+cosz*aaa1(2)) < 0.0d0) sinzz = -sinzz
!
           write(*,*)'cosz, sinz',cosz, sinz
           write(*,*)'cosy, siny',cosy, siny
           write(*,*)'coszz, sinzz', coszz, sinzz
!          ------------- Calcuation of maximum and minimum in xyz 
!          ------------- after rotation
!
!
!
!          ----------------- rotaion of large unit cell
            Nx = 12
            Ny = 12
            Nz =  8
            NNN = 0
            DO IO = 1, NCOMPO
              DO I = IONS(1,IO), IONS(2,IO)
                DO K1 = 0, Nx-1
                  DO K2 = 0, Ny-1
                    DO K3 = 0, Nz-1
                      NNN = NNN + 1
                      Q(1,NNN)   = (P(1,I) + dble(K1)) / dble(Nx)
                      Q(2,NNN)   = (P(2,I) + dble(K2)) / dble(Ny)
                      Q(3,NNN)   = (P(3,I) + dble(K3)) / dble(Nz)
                      call  RANDOM
                      VQ10(1,NNN) = V10(1,I) + (r1-0.5d0)*0.001d0
                      VQ10(2,NNN) = V10(2,I) + (r2-0.5d0)*0.001d0
                      VQ10(3,NNN) = V10(3,I) + (r3-0.5d0)*0.001d0
                      DO J = 1, 3
                        Q0(J,NNN)  = Q(J,NNN)
                      enddo
                    enddo
                  enddo
                enddo
              enddo
            enddo
            NTION = NNN
            if (NTION > LNI) stop 'Increase LNI'
            DO I = 1, NTION
              DO J = 1, 3
                P(J,I)   = Q(J,I)
                V10(J,I) = VQ10(J,I)
                P0(J,I)  = Q0(J,I)
              enddo
            enddo
            NELM = 0
            DO IO = 1, NCOMPO
              NION(IO) = NION(IO) * Nx * Ny * Nz
              IONS(1,IO) = NELM + 1
              NELM       = NELM + NION(IO)
              IONS(2,IO) = NELM
            enddo
            ubox(1) = box(1)
            ubox(2) = box(2)
            ubox(3) = box(3)
            box(1) = box(1) * dble(Nx)
            box(2) = box(2) * dble(Ny)
            box(3) = box(3) * dble(Nz)
            WRITE (*,9605)  (BOX(I),I=1,3),DENSTY
            write (*,9606)  (BOX(i+3),i=1,3)
 9605       FORMAT (6X,'Basic cell :',3F9.4,' A', 6X,'Density :',F7.4, ' g/cm3')
 9606       format (6x,'Angle (cos):',3f9.4)
!
            call tmatrx
!
            do i = 1, ntion
              pp(1,i) = p(1,i) -0.5D0
              pp(2,i) = p(2,i) -0.5D0
              pp(3,i) = p(3,i) -0.5D0
            enddo
!
            call ptoxyz
!
            do i = 1, ntion
              cr(1,i) =  (coszz*cosy*cosz-sinzz*sinz)*q(1,i)     &
                       + (coszz*cosy*sinz+sinzz*cosz)*q(2,i)     &
                       + (coszz*siny)*q(3,i)
              cr(2,i) =  (-sinzz*cosy*cosz-coszz*sinz)*q(1,i)      &
                       + (-sinzz*cosy*sinz+coszz*cosz)*q(2,i)      &
                       + (-sinzz*siny)*q(3,i)  
              cr(3,i) =  (-siny*cosz)*q(1,i)    &
                       + (-siny*sinz)*q(2,i)    &
                       +  cosy*q(3,i)
            enddo
!
           box(1) = sqrt(aaa1(1)**2+aaa1(2)**2+aaa1(3)**2)*alength
           box(2) = sqrt(aaa2(1)**2+aaa2(2)**2+aaa2(3)**2)
           box(3) = 50.0d0
           box(4) = 0.0d0   ! 90 degree
           box(5) = 0.0d0   ! 90 degree
           box(6) = alength*(aaa1(1)*aaa2(1)+aaa1(2)*aaa2(2)+aaa1(3)*aaa2(3))/(box(1)*box(2))
           write(*,*)'Lattice constants'
           write(*,*)box(1),box(2),box(3)
           write(*,*)box(4),box(5),box(6)
!
           itra2 = 1
           call tmatrx
!
           call xyztop
!
!          -------- Selection of atoms in primitive cell
           nnn = 0
           do io = 1,ncompo
             do i = ions(1,io),ions(2,io)
               p(1,i) = q(1,i)
               p(2,i) = q(2,i)
               p(3,i) = q(3,i)
               if(p(1,i)  <=  1.0D0 .and. p(1,i)  >  0.0D0) then
               if(p(2,i)  <=  1.0D0 .and. p(2,i)  >  0.0D0) then
               if(p(3,i)  <=  1.0D0 .and. p(3,i)  >  0.0D0) then
                 nnn = nnn + 1
                 num(io,nnn) = i
!                 write(*,*)i
               endif
               endif
               endif
             enddo
             ions(1,1) = 1
             ions(2,io) = nnn
             nion(1) = ions(2,1)
             if (io  >=  2) then 
               ions(1,io) = ions(2,io-1)+1
               nion(io) = ions(2,io)-ions(2,io-1)
             endif
           enddo
!
          ntion = ions(2,ncompo)
          do io = 1, ncompo
            do i = ions(1,io),ions(2,io)
!              write(*,*)num(io,i)
              p(1,i) = p(1,num(io,i))
              p(2,i) = p(2,num(io,i))
              p(3,i) = p(3,num(io,i))
            enddo
          enddo
!
      end if
!           --------------------------------------------- End of Case 16
      if (select == 17) then
!           ---------------------------------------------------- Case 17
          ioxy = 1
          ih = 2
          call tmatrx
!
 3705     do 3700  i = ions(1,ioxy), ions(2,ioxy)
            write(*,*) 'i=', i
            x = p(1,i)
            y = p(2,i)
            z = p(3,i)
            nh(i) = 0
            nd(i) = 0
            do 3701  j = ions(1,ih), ions(2,ih)
              dx = p(1,j) - x
              if (dx >  0.5)  dx = dx - 1.0
              if (dx < -0.5)  dx = dx + 1.0
              dy = p(2,j) - y
              if (dy >  0.5)  dy = dy - 1.0
              if (dy < -0.5)  dy = dy + 1.0
              dz = p(3,j) - z
              if (dz >  0.5)  dz = dz - 1.0
              if (dz < -0.5)  dz = dz + 1.0
              pp(1,J) = dx
              pp(2,J) = dy
              pp(3,J) = dz
              CALL PTOXYZ
              r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
              if (r2  <=  2.44) then
                    write(*,*)'r2=',r2
                    nh(i) = nh(i) + 1
                    ih2o(nh(i),i) = j
              end if
              if (r2  <=  1.44) then
                    nd(i) = nd(i) + 1
              endif
 3701       enddo
            if (nh(i) /= 2)  then 
              write (*,*) i,'-th ox : No.OH possible bonds=',nh(i)
            endif
            if (nd(i) == 2) then
              write (*,*) i,'-th ox : No.OH bonds=',nd(i)
            endif
 3700     continue
!
          do 3702 i = ions(1,ioxy),ions(2,ioxy)
            x = p(1,i)
            y = p(2,i)
            z = p(3,i)
            if (nh(i)  /=  2 .and. nd(i)  /=  2) then
              do 3703 k = 1, 2
                j = ih2o(k,i)
                dx = p(1,j) - x
                if (dx >  0.5)  dx = dx - 1.0
                if (dx < -0.5)  dx = dx + 1.0
                dy = p(2,j) - y
                if (dy >  0.5)  dy = dy - 1.0
                if (dy < -0.5)  dy = dy + 1.0
                dz = p(3,j) - z
                if (dz >  0.5)  dz = dz - 1.0
                if (dz < -0.5)  dz = dz + 1.0
                pp(1,J) = dx
                pp(2,J) = dy
                pp(3,J) = dz
                CALL PTOXYZ
                roh = sqrt(Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2)
                rdoh = 1.015
                write(*,*)'roh=',roh
                doh = (roh-rdoh)/roh
                write(*,*)'doh=',doh
                p(1,j) = p(1,j)-dx*doh
                p(2,j) = p(2,j)-dy*doh
                p(3,j) = p(3,j)-dz*doh
 3703         enddo
              write(*,*)'ok'
              read(*,*)aok
              goto 3705
            endif
 3702     enddo
      endif
      if (select == 18) then
!           ---------------------------------------------------- Case 18
 1800   write(*,'("Select Mode")')
        write(*,'("1: Search Ions")')
        write(*,'("2: Select Ions")')
        write(*,'(" >>> ", $)')
        read(*,*) imode
        if (imode /= 1 .and. imode /= 2) goto 1800
 1801   write (*,'(" Select the number of H added: 1 or 2 >>> ", $)')
        read (*,*) nhh
        if (nhh > 2 .or. nhh < 1) goto 1801
!
        call tmatrx
        dsq = 2.6d0**2    !dsq : square of distance defining the area of surrounding atoms
        dintra = 0.977d0
 1805   write (*,'("Type the OH distance in angstrom (e.g. 0.977) >>> ")', advance='no')
        read (*,*) dintra
        if (dintra < 0.0d0) goto 1805
!        dsqd = 1.5d0**2
        write (*,'(" Input minimum distance between other atoms (Angstrom) >>> ", $)')
        read (*,*) dsqo
        dsqd = dsqo**2

!
        if (imode == 1) then
          write (*,'("=== 1: Search Mode ===")')
          if (ntion > 1) then
            do io = ions(1,ioxy), ions(2,ioxy)
              nc(io) = 0
              x = p(1,io)
              y = p(2,io)
              z = p(3,io)
              do j = 1, ntion
                if (io == j) cycle
                dx = p(1,j) - x
                if (dx >  0.5)  dx = dx - 1.0
                if (dx < -0.5)  dx = dx + 1.0
                dy = p(2,j) - y
                if (dy >  0.5)  dy = dy - 1.0
                if (dy < -0.5)  dy = dy + 1.0
                dz = p(3,j) - z
                if (dz >  0.5)  dz = dz - 1.0
                if (dz < -0.5)  dz = dz + 1.0
                pp(1,j) = dx
                pp(2,j) = dy
                pp(3,j) = dz
                CALL PTOXYZ
                r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
                if (r2  <=  dsq) then
                  nc(io) = nc(io) + 1
                  ic(nc(io),io) = j
                end if
              enddo
            enddo
          endif
          do io = ions(1,ioxy), ions(2,ioxy)
            if (nc(io) < 2) then
              write (*,'("index number of O : ", i5)') io
              px1 = p(1,io)
              py1 = p(2,io)
              pz1 = p(3,io)
 1840         pp(1,1) = px1
              pp(2,1) = py1
              pp(3,1) = pz1
              ntiono = ntion
              if (ntion == 1) ntion = 2
              CALL  RANDOM                       !  1st H atom
              pp(1,2) = 2.0d0*r1-1.0d0    ! random number from -1 to 1
              pp(2,2) = 2.0d0*r2-1.0d0    ! random number from -1 to 1
              pp(3,2) = 2.0d0*r3-1.0d0    ! random number from -1 to 1
              call PTOXYZ
              srd= sqrt(Q(1,2)**2 + Q(2,2)**2 + Q(3,2)**2)
              cr(1,2) = Q(1,1) + Q(1,2) * dintra / srd
              cr(2,2) = Q(2,1) + Q(2,2) * dintra / srd
              cr(3,2) = Q(3,1) + Q(3,2) * dintra / srd
              call xyztop
              px2 = Q(1,2)
              py2 = Q(2,2)
              pz2 = Q(3,2)
              if (nc(io) > 0) then
                do j = 1, nc(io)
                  k = ic(j,io)
                  dx = p(1,k) - px2
                  if (dx >  0.5)  dx = dx - 1.0
                  if (dx < -0.5)  dx = dx + 1.0
                  dy = p(2,k) - py2
                  if (dy >  0.5)  dy = dy - 1.0
                  if (dy < -0.5)  dy = dy + 1.0
                  dz = p(3,k) - pz2
                  if (dz >  0.5)  dz = dz - 1.0
                  if (dz < -0.5)  dz = dz + 1.0
                  pp(1,j) = dx
                  pp(2,j) = dy
                  pp(3,j) = dz
                  CALL PTOXYZ
                  r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
                  if (r2  <  dsqd) goto 1840
                enddo
              endif
              ntion = ntiono
!
              if (nhh > 1) then
 1850           pp(1,1) = px1
                pp(2,1) = py1
                pp(3,1) = pz1
                call  random                       !  2nd H atom
                pp(1,3) = 2.0d0*r1-1.0d0
                pp(2,3) = 2.0d0*r2-1.0d0
                pp(3,3) = 2.0d0*r3-1.0d0
                ntiono = ntion
                if (ntion < 3) ntion = 3
                call PTOXYZ
                srd= sqrt(Q(1,3)**2 + Q(2,3)**2 + Q(3,3)**2)
                cr(1,3) = Q(1,1) + Q(1,3) * dintra / srd
                cr(2,3) = Q(2,1) + Q(2,3) * dintra / srd
                cr(3,3) = Q(3,1) + Q(3,3) * dintra / srd
                call xyztop
                PX3 = Q(1,3)
                PY3 = Q(2,3)
                PZ3 = Q(3,3)
                if (nc(io) > 0) then
                 do j = 1, nc(io)
                   k = ic(j,io)
                   dx = p(1,k) - px3
                   if (dx >  0.5)  dx = dx - 1.0
                   if (dx < -0.5)  dx = dx + 1.0
                   dy = p(2,k) - py3
                   if (dy >  0.5)  dy = dy - 1.0
                   if (dy < -0.5)  dy = dy + 1.0
                   dz = p(3,k) - pz3
                   if (dz >  0.5)  dz = dz - 1.0
                   if (dz < -0.5)  dz = dz + 1.0
                   pp(1,j) = dx
                   pp(2,j) = dy
                   pp(3,j) = dz
                   CALL PTOXYZ
                   r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
                   if (r2  <  dsqd) goto 1850
                 enddo
                endif
                pp(1,1) = px2-px1
                pp(2,1) = py2-py1
                pp(3,1) = pz2-pz1
                pp(1,2) = px3-px1
                pp(2,2) = py3-py1
                pp(3,2) = pz3-pz1
                call PTOXYZ
                vv = ( q(1,1)*q(1,2) +q(2,1)*q(2,2) +q(3,1)*q(3,2) ) / dintra**2
!               write (6,*)  vv
                if (vv >= 0.0 .or. vv <= -0.5)  go to 1850
                ntion = ntiono
              endif
!
              nio2 = nio2 + 1
              p(1,ntion+nio2) = px2
              p(2,ntion+nio2) = py2
              p(3,ntion+nio2) = pz2
              p0(1,ntion+nio2) = px2
              p0(2,ntion+nio2) = py2
              p0(3,ntion+nio2) = pz2
              v10(1,ntion+nio2) = 5.0
              v10(2,ntion+nio2) = 5.0
              v10(3,ntion+nio2) = 5.0
              if (nhh > 1) then
                nio2 = nio2 +1
                p(1,ntion+nio2) = px3
                p(2,ntion+nio2) = py3
                p(3,ntion+nio2) = pz3
                p0(1,ntion+nio2) = px3
                p0(2,ntion+nio2) = py3
                p0(3,ntion+nio2) = pz3
                v10(1,ntion+nio2) = 5.0
                v10(2,ntion+nio2) = 5.0
                v10(3,ntion+nio2) = 5.0
              endif
            endif
          enddo
        elseif (imode == 2) then
          write (*,'("=== 2: Select Mode ===")')
          j = 1
 1802     write(*,'("Input the index number to bond with H >>> ",$)')
          read(*,*)ioah(j)
          if (ioah(j) > ntion) then
            write(*,'("No such atom")')
            goto 1802
          endif
 1803     write(*,'("Need More ? (y,n) >>> ", $)')
          read(*,*) ans
          if (ans /= 'y' .and. ans /= 'n') goto 1803
          if (ans == 'y') then
            j = j + 1
            goto 1802
          endif
          natom = j
            do k = 1, natom
              nc(k) = 0
              x = p(1,ioah(k))
              y = p(2,ioah(k))
              z = p(3,ioah(k))
              if (ntion > 1) then
                do j = 1, ntion
                  if (ioah(k) == j) cycle
                  dx = p(1,j) - x
                  if (dx >  0.5)  dx = dx - 1.0
                  if (dx < -0.5)  dx = dx + 1.0
                  dy = p(2,j) - y
                  if (dy >  0.5)  dy = dy - 1.0
                  if (dy < -0.5)  dy = dy + 1.0
                  dz = p(3,j) - z
                  if (dz >  0.5)  dz = dz - 1.0
                  if (dz < -0.5)  dz = dz + 1.0
                  pp(1,j) = dx
                  pp(2,j) = dy
                  pp(3,j) = dz
                  CALL PTOXYZ
                  r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
                  if (r2  <=  dsq) then
                    nc(k) = nc(k) + 1
                    ic(nc(k),k) = j
                  end if
                enddo
              endif
            enddo
          nio2 = 0
          do k = 1, natom
            write (*,'("index number of ion : ", i5)') ioah(k)
            px1 = p(1,ioah(k))
            py1 = p(2,ioah(k))
            pz1 = p(3,ioah(k))
 1841       pp(1,1) = px1
            pp(2,1) = py1
            pp(3,1) = pz1
            CALL  RANDOM                       !  1st H atom
            pp(1,2) = 2.0d0*r1-1.0d0    ! random number from -1 to 1
            pp(2,2) = 2.0d0*r2-1.0d0    ! random number from -1 to 1
            pp(3,2) = 2.0d0*r3-1.0d0    ! random number from -1 to 1
            ntiono = ntion
            if (ntion == 1) ntion = 2 
            call PTOXYZ
            srd= sqrt(Q(1,2)**2 + Q(2,2)**2 + Q(3,2)**2)
            cr(1,2) = Q(1,1) + Q(1,2) * dintra / srd
            cr(2,2) = Q(2,1) + Q(2,2) * dintra / srd
            cr(3,2) = Q(3,1) + Q(3,2) * dintra / srd
            call xyztop
            px2 = Q(1,2)
            py2 = Q(2,2)
            pz2 = Q(3,2)
            if (nc(k) > 0) then
              do j = 1, nc(k)
                kk = ic(j,k)
                dx = p(1,kk) - px2
                if (dx >  0.5)  dx = dx - 1.0
                if (dx < -0.5)  dx = dx + 1.0
                dy = p(2,kk) - py2
                if (dy >  0.5)  dy = dy - 1.0
                if (dy < -0.5)  dy = dy + 1.0
                dz = p(3,kk) - pz2
                if (dz >  0.5)  dz = dz - 1.0
                if (dz < -0.5)  dz = dz + 1.0
                pp(1,j) = dx
                pp(2,j) = dy
                pp(3,j) = dz
                CALL PTOXYZ
                r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
                if (r2  <  dsqd) then
!                  write(*,*) sqrt(r2), ic(j,k)
                  goto 1841
                endif
              enddo
            endif
            ntion = ntiono
            write(*,'("1H was added")')
!
            if (nhh > 1) then
 1851         pp(1,1) = px1
              pp(2,1) = py1
              pp(3,1) = pz1
              call  random                       !  2nd H atom
              pp(1,3) = 2.0d0*r1-1.0d0
              pp(2,3) = 2.0d0*r2-1.0d0
              pp(3,3) = 2.0d0*r3-1.0d0
              ntiono = ntion
              if (ntion < 3) ntion = 3
              call PTOXYZ
              srd= sqrt(Q(1,3)**2 + Q(2,3)**2 + Q(3,3)**2)
              cr(1,3) = Q(1,1) + Q(1,3) * dintra / srd
              cr(2,3) = Q(2,1) + Q(2,3) * dintra / srd
              cr(3,3) = Q(3,1) + Q(3,3) * dintra / srd
              call xyztop
              PX3 = Q(1,3)
              PY3 = Q(2,3)
              PZ3 = Q(3,3)
              if (nc(k) > 0) then
                do j = 1, nc(k)
                  kk = ic(j,k)
                  dx = p(1,kk) - px3
                  if (dx >  0.5)  dx = dx - 1.0
                  if (dx < -0.5)  dx = dx + 1.0
                  dy = p(2,kk) - py3
                  if (dy >  0.5)  dy = dy - 1.0
                  if (dy < -0.5)  dy = dy + 1.0
                  dz = p(3,kk) - pz3
                  if (dz >  0.5)  dz = dz - 1.0
                  if (dz < -0.5)  dz = dz + 1.0
                  pp(1,j) = dx
                  pp(2,j) = dy
                  pp(3,j) = dz
                  CALL PTOXYZ
                  r2 = Q(1,J)**2 + Q(2,J)**2 + Q(3,J)**2
                  if (r2  <  dsqd) goto 1851
                enddo
              endif
              pp(1,1) = px2-px1
              pp(2,1) = py2-py1
              pp(3,1) = pz2-pz1
              pp(1,2) = px3-px1
              pp(2,2) = py3-py1
              pp(3,2) = pz3-pz1
              call PTOXYZ
              vv = ( q(1,1)*q(1,2) +q(2,1)*q(2,2) +q(3,1)*q(3,2) ) / dintra**2
!             write (6,*)  vv,px1,px2,px3
              if (vv >= 0.0 .or. vv <= -0.5)  go to 1851
              ntion = ntiono
              write(*,'("2H were added")')
            endif
!
            nio2 = nio2 + 1
            p(1,ntion+nio2) = px2
            p(2,ntion+nio2) = py2
            p(3,ntion+nio2) = pz2
            p0(1,ntion+nio2) = px2
            p0(2,ntion+nio2) = py2
            p0(3,ntion+nio2) = pz2
            v10(1,ntion+nio2) = 5.0
            v10(2,ntion+nio2) = 5.0
            v10(3,ntion+nio2) = 5.0
            if (nhh > 1) then
              nio2 = nio2 +1
              p(1,ntion+nio2) = px3
              p(2,ntion+nio2) = py3
              p(3,ntion+nio2) = pz3
              p0(1,ntion+nio2) = px3
              p0(2,ntion+nio2) = py3
              p0(3,ntion+nio2) = pz3
              v10(1,ntion+nio2) = 5.0
              v10(2,ntion+nio2) = 5.0
              v10(3,ntion+nio2) = 5.0
            endif
          enddo
        endif
!
        if (nio2 > 0) then
          ncompo = ncompo + 1
          ntion = ntion + nio2
          atom(ncompo)   = 'H   '
          nion(ncompo) = nio2
          ions(1,ncompo) = ions(2,ncompo-1) + 1
          ions(2,ncompo) = ntion
        endif
        write(*,'("===Finish to add H atoms===")')
      endif
!     --------------------------------------------------- End of Case 18
      if (select == 19)  then
!           ---------------------------------------------------- Case 19
            write (*,'("Input the index of water oxygen   >>> ")',advance = 'no')
            read (*,*) ioxy
            write (*,'("Input the index of water hydrogen >>> ")',advance = 'no')
            read (*,*) ih
            write (*,'("The shorten cell length   1:a  2:b  3:c >>> ")',advance ='no')
            read  (5,*)  ia
            write (*,'("Length ratio of subtraction (0 to 1) >>> ")',advance='no')
            read  (5,*)  alength
            do io = 1, ncompo
              if (io == ioxy .or. io == ih) cycle
              do i = ions(1,io), ions(2,io)
                pia = p(ia,i)
                IF (Pia > 1.0d0)  Pia = Pia - 1.0d0
                IF (Pia < 0.0d0)  Pia = Pia + 1.0d0
                Pia = (Pia-0.5d0)/(1.0d0-alength)+0.5D0
                P(ia,i) = pia
              end do
            enddo
            box(ia) = box(ia) * (1.0D0-alength)
            DENSTY  = DENSTY / (1.0D0-alength)
            WRITE (*,9006)  (BOX(I),I=1,3),DENSTY
!           --------------------------------------------- End of Case 19
      end if
      if (select == 20)  then
!           ---------------------------------------------------- Case 20
 2012       write (*,'("Choose mode: 1: Range, 2: Index or random >>> ")',advance = 'no')
            read (*,*) im
            if ( im /= 1 .and. im /= 2) goto 2012
            if (im == 1) then
              write (*,'("Input the direction 1:a, 2:b, 3:c   >>> ")',advance = 'no')
              read (*,*) ia
              write (*,'("Input the range to remove atoms from 0 to 1 (e.g. 0.5,0.7) >>> ")',advance = 'no')
              read (*,*) pl,ph
              write(*,'("Element list")')
              do io = 1, ncompo
                write (*,'(i2,": ", a4)')io, ATOM(io)
              enddo
 2011         write (*,'("0:All atoms, or input element index >>> ")',advance = 'no')
              read (*,*) iea
              if (iea < 0 .or. iea > lem) goto 2011 
              j = 0
              do io = 1, ncompo
                if (iea == 0 .or. io == iea) then
                  do i = ions(1,io), ions(2,io)
                    pia = p(ia,i)
                    if (Pia > pl .and. Pia < ph)  then
                      j = j + 1
                      irm(j) = i
                      nion(io) = nion(io) - 1
                    endif
                  end do
                endif
              enddo
            elseif (im == 2) then
 2016         write (*,'("1:random, 2:choice >>> ")',advance = 'no')
              read (*,*)irmod
              if (irmod /= 1 .and. irmod /= 2) goto 2016
              if (irmod == 2) then
                j = 0
 2013           write (*,'("Input the index of atoms >>> ")',advance = 'no')
                read (*,*) id
                if (id < 1 .or. id > ntion) goto 2015
                dcheck = 0
                if (j > 0) then
                  do icheck= 1,j
                    if (irm(icheck) == id) then
                      write (*,'("Duplicated selection")')
                      dcheck = 1
                      write(*,'("OK? (y,n) >>> ")',advance = 'no')
                      read (*,*) aj
                    endif
                  enddo
                endif
                if (dcheck == 1) goto 2015
                write(*,'("This atom will be removed.")')
                do io = 1,ncompo
                  if (id >= ions(1,io)) then
                    iele = io
                  endif
                enddo
                write(*,'(a4,1x,3(f8.5,1x))') ATOM(iele),p(1,id),p(2,id),p(3,id)
 2014           write(*,'("OK? (y,n) >>> ")',advance = 'no')
                read (*,*) aj
                if (aj /= 'y' .and. aj /= 'n') goto 2014
                if (aj == 'y') then
                  j = j + 1
                  irm(j) = id
                  nion(iele) = nion(iele) - 1
                endif
 2015           write (*,'("Need more? (y,n) >>> ")',advance ='no')
                read (*,*) aj
                if (aj /= 'y' .and. aj /= 'n') goto 2015
                if (aj == 'y') goto 2013
              elseif (irmod == 1) then
 2017           write(*,'("Input the number of removed atoms >>> ")',advance ='no')
                read(*,*) j
                if (j < 0 .or. j > ntion) goto 2017
 2022           write(*,'("Constrain the atoms by the distance from other ions? (y,n) >>> ")',advance='no')
                read(*,*)aj
                if (aj /= 'y' .and. aj /= 'n') goto 2022
                if (aj == 'y') then
                  write(*,'("Element list")')
                  do io = 1, ncompo
                    write (*,'(i2,": ", a4)')io, ATOM(io)
                  enddo
 2023             write (*,'("Type the index of element to constrain the distance from >>> ")',advance='no')
                  read(*,*)idist
                  if (idist < 0 .or. idist > lem) goto 2023
 2024             write (*,'("Type the distance in angstrom >>> ")',advance='no')
                  read(*,*) distc
                  if (distc < 0.0d0) goto 2024
                  ndistcri = 0
                endif
!
                write (*,'("Choose the direction 1:a, 2:b, 3:c   >>> ")',advance = 'no')
                read (*,*) ia
                write (*,'("Type the range to remove atoms from 0 to 1 (e.g. 0.5,0.7) >>> ")',advance = 'no')
                read (*,*) pl,ph
                write(*,'("Element list")')
                do io = 1, ncompo
                  write (*,'(i2,": ", a4)')io, ATOM(io)
                enddo
                iea = 0
 2018           write (*,'("0:All atoms, or input element index >>> ")',advance = 'no')
                read (*,*) iea
                if (iea < 0 .or. iea > lem) goto 2018
                if (iea == 0) then
                  istart = 1
                  tion = ntion
                elseif (iea /= 0) then 
                  istart = ions(1,iea)
                  tion = nion(iea)
                endif
                write(*,'("Type an integer for randomize >>> ")',advance ='no')
                read(*,*) KNK
                iatom = 1
                nstep = 0
                iter = 0
                do io = 1, ncompo
                  if (iea == 0 .or. io == iea) then
                    do while (iatom < j+1)
                      nstep = nstep + 1
!          write(*,*)ndistcri
                      if (iea == 0) then
                        if(nstep > ntion) then
                          if (iter > 50) then
                             ndistcri = ndistcri +1 
                             iter = 0
                          endif
                           KNK = KNK + 10
                           nstep = 1
                           iter = iter + 1
                        endif
                      elseif (iea == io) then
                        if(nstep > nion(iea)) then
                           if (iter > 50) then
                             ndistcri = ndistcri +1 
                             iter = 0
                           endif
                           nstep = 1
                           KNK =  KNK + 10
                           iter = iter + 1
                        endif
                      endif
                      do k = 1, KNK
                        call random
                      enddo
                      i = INT(r1*real(tion)) + istart
!                      write(*,*) i
!                      read(*,*)
                      pia = p(ia,i)
                      if (Pia > pl .and. Pia < ph)  then
                              ndistc = 0
                              do kkk = ions(1,idist),ions(2,idist)
                                dx = p(1,i) - p(1,kkk)
                                if (dx < -0.5) dx = dx + 1.0
                                if (dx > 0.5) dx = dx - 1.0
                                dy = p(2,i) - p(2,kkk)
                                if (dy < -0.5) dy = dy + 1.0
                                if (dy > 0.5) dy = dy - 1.0
                                dz = p(3,i) - p(3,kkk)
                                if (dz < -0.5) dz = dz + 1.0
                                if (dz > 0.5) dz = dz - 1.0
                                ddd = sqrt((dx*box(1))**2 + (dy*box(2))**2 + (dz*box(3))**2)
                                if ( ddd <= distc ) then
                                        ndistc = ndistc + 1
                                endif
                              enddo
                        if (ndistc > ndistcri) goto 2019
                        if (iatom > 1) then
                          do k = 1, iatom
                            if (i == irm(k) ) then
!                              write(*,'("Duplication")')
                              goto 2019
                            endif
                          enddo
                        endif
                        irm(iatom) = i
                        nion(io) = nion(io) - 1
                        iatom = iatom + 1
                      endif
 2019               end do
                  endif
                enddo
              endif
            endif
            write(*,'("Number of removed atoms: ", i5)')j
!           Change of the turn
            if (j > 1) then
              do icheck = 1,j-1
                do jcheck = icheck, j
                  if (irm(icheck) > irm(jcheck)) then
                    k = irm(icheck)
                    irm(icheck) = irm(jcheck)
                    irm(jcheck) = k
                  endif
                enddo
              enddo
            endif
!              
            do icheck = 1,j
!              write(*,*) irm(icheck)
            enddo
!
            k = 0
            do io = 1, ncompo
              if (nion(io) == 0) then
                do jj = io, ncompo-1
                  ATOM(jj) = ATOM(jj+1)
                enddo
              elseif (nion(io) /= 0) then
                k = k + 1
                nnion(k) = nion(io)
              endif
            enddo
            ncompo = k
            do io = 1,ncompo
              nion(io) = nnion(io)
            enddo
            ions(1,1) = 1
            ions(2,1) = nion(1)
            do io = 2, ncompo
              ions(1,io) = ions(2,io-1) + 1
              ions(2,io) = ions(2,io-1) + nion(io)
            enddo
            do i = 1, ntion
              do k = 1,3
                pp(k,i) = p(k,i)
              enddo
            enddo
            j = 1
            ii = 1
            do i = 1, ntion
              do k = 1,3
                if (i == irm(j)) then
                  write(*,*) j, irm(j)
                  j = j + 1
                  goto 2010
                endif
                p(k,ii) = pp(k,i)
              enddo
              ii = ii + 1
  2010      enddo
            ntion = 0
            do io = 1,ncompo
              ntion = ntion + nion(io)
            enddo
!           --------------------------------------------- End of Case 20
      end if
      if (select == 21)  then
!           ---------------------------------------------------- Case 21
            write (*,'("The shorten cell axis is  1:a  2:b  3:c >>> ")',advance ='no')
            read  (5,*)  ia
            write (*,'("Input the start range x (remove the range from x to 1) >>> ")',advance='no')
            read  (5,*)  pl
            alength = 1.0d0 - pl
!           ------------------------remove atoms in the removed range
            j = 0
            do io = 1, ncompo
              do i = ions(1,io), ions(2,io)
                pia = p(ia,i)
                IF (Pia > 1.0d0)  Pia = Pia - 1.0d0
                IF (Pia < 0.0d0)  Pia = Pia + 1.0d0
                if (Pia > pl .and. Pia < 1.0d0)  then
                  j = j + 1
                  irm(j) = i
                  nion(io) = nion(io) - 1
                endif
              end do
            enddo
            k = 0
            do io = 1, ncompo
              if (nion(io) /= 0) then
                k = k + 1
                nnion(k) = nion(io)
              endif
            enddo
            ncompo = k
            do io = 1,ncompo
              nion(io) = nnion(io)
            enddo
            ions(1,1) = 1
            ions(2,1) = nion(1)
            do io = 2, ncompo
              ions(1,io) = ions(2,io-1) + 1
              ions(2,io) = ions(2,io-1) + nion(io)
            enddo
            do i = 1, ntion
              do k = 1,3
                pp(k,i) = p(k,i)
              enddo
            enddo
            j = 1
            ii = 1
            do i = 1, ntion
              do k = 1,3
                if (i == irm(j)) then
                  j = j + 1
                  goto 2110
                endif
                p(k,ii) = pp(k,i)
              enddo
              ii = ii + 1
  2110      enddo
            ntion = 0
            do io = 1,ncompo
              ntion = ntion + nion(io)
            enddo
!
            do io = 1, ncompo
              do i = ions(1,io), ions(2,io)
                pia = p(ia,i)
                IF (Pia > 1.0d0)  Pia = Pia - 1.0d0
                IF (Pia < 0.0d0)  Pia = Pia + 1.0d0
                Pia = (Pia-0.5d0)/(1.0d0-alength)+0.5D0
                P(ia,i) = pia
              end do
            enddo
            box(ia) = box(ia) * (1.0D0-alength)
            WRITE (*,*)  (BOX(I),I=1,3)
      endif
!           --------------------------------------------- End of Case 21
!           ---------------------------------------------------- Case 22
      if(select == 22) then
              do io = 1, ncompo
                do j = ions(1,io), ions(2,io)
                  eind(j) = io
                enddo
              enddo
!
 2212       write (*,'("Choose mode: 1: Range, 2: Index >>> ")',advance = 'no')
            read (*,*) im
            if ( im /= 1 .and. im /= 2) goto 2212
!
            if (im == 1) then   ! Range mode
              nscompo = ncompo
              write (*,'("Choose the direction 1:a, 2:b, 3:c   >>> ")',advance = 'no')
              read (*,*) ia
              write (*,'("Type the range to substituted atoms from 0 to 1 (e.g. 0.5,0.7) >>> ")',advance = 'no')
              read (*,*) pl,ph
              write(*,'("Element list")')
              do io = 1, ncompo
                write (*,'(i2,": ", a4)')io, ATOM(io)
              enddo
 2211         write (*,'(" 0:All atoms, choose index >>> ")',advance = 'no')
              read (*,*) iea
              if (iea < 0 .or. iea > lem) goto 2211 
 2214         write(*,'("Choose adding elements")')
              do io = 1,ncompo
               write(*,'(i2,":",1x, a4)')io,ATOM(io)
              enddo
              write(*,'(" 0:",1x,"Manual input")')
              read(*,*) subio
              if (subio > nscompo .or. subio < 0) goto 2214
              if (subio > 0) patom = ATOM(subio)
              if (subio == 0) then
                write(*,'("Enter the elements name (e.g. Na) >>> ")',advance = 'no')
                read(*,*) asub
                if (len_trim(asub) == 1) patom = trim(asub)//"   "
                if (len_trim(asub) == 2) patom = trim(asub)//"  "
                subio = nscompo + 1
                nscompo = nscompo + 1
                ATOM(nscompo) = patom
                do io = 1, nscompo-1
                  if (ATOM(io) == patom) then
                    write(*,'("This element is same as the ",a4,", index= ",1x,i2)') ATOM(io),io
                    subio = io
                    nscompo = nscompo -1
                  endif
                enddo
              endif
!
2217          write(*,'("Choose mode")')
              write(*,'("1: All substitution")')
              write(*,'("2: Partly substitution")')
              write(*,'(">>> ")',advance='no')
              read(*,*) msub
              if (msub > 2 .or. msub < 0) goto 2217
              if (msub == 1) then
                j = 0
                do io = 1, ncompo
                  if (iea == 0 .or. io == iea) then
                    do i = ions(1,io), ions(2,io)
                      pia = p(ia,i)
                      if (Pia > pl .and. Pia < ph)  then
                        j = j + 1
                        irm(j) = i
                        eind(irm(j))=subio
                        nion(io) = nion(io) - 1
                        nion(subio) = nion(subio) + 1
                      endif
                    end do
                  endif
                enddo
              elseif (msub == 2) then
                call tmatrx
2218            write(*,'("Type the number of substitution >>> ")',advance='no')
                read(*,*) nsubio
                if (iea == 0) then
                  if (nsubio < 0 .or. nsubio >= ntion) goto 2218
                else
                  if (nsubio < 0 .or. nsubio >= nion(iea)) goto 2218
                endif
2219            write(*,'("Type integer for randomize >>> ")',advance='no')
                read (*,*) KNK
                if (KNK < 0) goto 2219
                do i = 1, KNK
                  call random
                enddo
                write(*,'("tetrahedral : 3.5 Ang, octahedral: 3.5 Ang")')
2220            write(*,'("Type the shortest distance (ang) among substituted ions >>> ")',advance='no')  
                read(*,*) dlimit
                if (dlimit < 0.0d0) goto 2220
2224            write(*,'("Type the maximum coordination number in the distace", F7.2," >>> ")',advance='no') dlimit
                read(*,*) ncoord 
                if (ncoord < 0) goto 2224
                j = 0
                kkk = 1
                numco(:)=0
2223            do io = 1, ncompo
                  if (iea == 0 .or. io == iea) then
                    do i = ions(1,io), ions(2,io)
                      pia = p(ia,i)
                      if (Pia > pl .and. Pia < ph)  then
                        call random
!                        write(*,*) r1, INT(100.0*r1+0.5)  ! probability
                        ncoo=0
                        if (INT(100.0*r1+0.5) < 5) then
                          if (j > 0) then
                            do ii =  1, j
                              if (irm(ii) == i) goto 2221
                              pp(1,1) = p(1,irm(ii))-p(1,i)
                              if (pp(1,1) > 0.5d0) pp(1,1) = 1.0d0 - pp(1,1)
                              if (pp(1,1) < -0.5d0) pp(1,1) = 1.0d0 + pp(1,1)
                              pp(2,1) = p(2,irm(ii))-p(2,i)
                              if (pp(2,1) > 0.5d0) pp(2,1) = 1.0d0 - pp(2,1)
                              if (pp(2,1) < -0.5d0) pp(2,1) = 1.0d0 + pp(2,1)
                              pp(3,1) = p(3,irm(ii))-p(3,i)
                              if (pp(3,1) > 0.5d0) pp(3,1) = 1.0d0 - pp(3,1)
                              if (pp(3,1) < -0.5d0) pp(3,1) = 1.0d0 + pp(3,1)
                              call ptoxyz
                              dist=sqrt(Q(1,1)**2+Q(2,1)**2+Q(3,1)**2)
!                              write(*,*) dist
!                              read(*,*)
                              if (dist < dlimit) then
                                ncoo=ncoo+1
                                if(ncoo>ncoord) goto 2221
                                numcoj=numco(ii)+1
                                if(numcoj>ncoord) goto 2221
                                numco(ii)=numco(ii)+1                                
                              endif
                            enddo
                          endif 
                          j = j + 1
                          kkk=1
                          irm(j) = i
                          eind(i)=subio
                          numco(j)=ncoo
                          nion(io) = nion(io) - 1
                          nion(subio) = nion(subio) + 1
                          write(*,'("Nsub = ", i5, " Replace ion: ",i5,"element: ",i5)')j,i,eind(i)
                          if (j == nsubio) goto 2222 
2221                    endif
                      endif
                    end do
                  endif
                enddo
                if (j < nsubio) then
                  if (kkk == 100000) stop 'error: cannot find the site in 100000 loop '
                  kkk = kkk + 1 
                  goto 2223
                endif 
2222          endif
!
            elseif (im == 2) then
              j = 0
              nscompo = ncompo
 2213         write (*,'("Input the index of atoms >>> ")',advance = 'no')
              read (*,*) id
              if (id < 1 .or. id > ntion) goto 2213
              write(*,'("This atom will be substituted.")')
              do io = 1,ncompo
                if (id >= ions(1,io)) then
                  iele = io
                endif
              enddo
              write(*,'(a4,1x,3(f8.5,1x))') ATOM(iele),p(1,id),p(2,id),p(3,id)
 2216         write(*,'("Choose substituted elements")')
              do io = 1,nscompo
               write(*,'(i2,":",1x, a4)')io,ATOM(io)
              enddo
              write(*,'(" 0:",1x,"Manual input")')
              read(*,*) subio
              if (subio > nscompo .or. subio < 0) goto 2216
              if (subio > 0) patom = ATOM(subio)
              if (subio == 0) then
                write(*,'("Enter the elements name (e.g. Na) >>> ")',advance = 'no')
                read(*,*) asub
                if (len_trim(asub) == 1) patom = trim(asub)//"   "
                if (len_trim(asub) == 2) patom = trim(asub)//"  "
                subio = nscompo + 1
                nscompo = nscompo + 1
                ATOM(nscompo) = patom
                do io = 1, nscompo-1
                  if (ATOM(io) == patom) then
                    write(*,'("This element is same as the ",a4,", index= ",1x,i2)') ATOM(io),io
                    subio = io
                    nscompo = nscompo -1
                  endif
                enddo
              endif
              write(*,'("Substitution from ",a4,1x, "to ",a4,".")')ATOM(iele), patom
              j = j + 1
              irm(j) = id
              eind(irm(j)) = subio
              nion(iele) = nion(iele) - 1
              nion(subio) = nion(subio) + 1
!
 2215         write (*,'("Need more? (y,n) >>> ")',advance ='no')
              read (*,*) aj
              if (aj /= 'y' .and. aj /= 'n') goto 2215
              if (aj == 'y') goto 2213
              write(*,'("Number of substituted atoms: ", i5)')j
!
          endif
!
            ncompo = nscompo
!
!           Change of the turn
            if (j > 1) then
              do icheck = 1,j-1
                do jcheck = icheck, j
                  if (irm(icheck) > irm(jcheck)) then
                    k = irm(icheck)
                    irm(icheck) = irm(jcheck)
                    irm(jcheck) = k
                  endif
                enddo
              enddo
            endif
!              
            k = 0
            do io = 1, ncompo
              if (nion(io) == 0) then
                do jj = io, ncompo-1
                  ATOM(jj) = ATOM(jj+1)
                enddo
                do ii = 1,ntion
                  if (eind(ii) > io) eind(ii) = eind(ii)-1
                enddo
              elseif (nion(io) /= 0) then
                k = k + 1
                nnion(k) = nion(io)
              endif
            enddo
            ncompo = k
            do io = 1,ncompo
              nion(io) = nnion(io)
            enddo
            ions(1,1) = 1
            ions(2,1) = nion(1)
            do io = 2, ncompo
              ions(1,io) = ions(2,io-1) + 1
              ions(2,io) = ions(2,io-1) + nion(io)
            enddo
!
            do io = 1, ncompo
              ix = 0
              do i = 1,ntion
                if (io == eind(i)) then
                  ix = ix + 1
                  ppx(io,ix) = p(1,i)
                  ppy(io,ix) = p(2,i)
                  ppz(io,ix) = p(3,i)
!write(*,'(i5,1x,i5,F7.3,1x,F7.3,1x,F7.3)') i,io,ppx(io,ix),ppy(io,ix),ppz(io,ix)
                endif
              enddo
            enddo
!
            ii = 1
            do io = 1, ncompo
              do ix = 1,nion(io)
                p(1,ii) = ppx(io,ix)
                p(2,ii) = ppy(io,ix)
                p(3,ii) = ppz(io,ix)
                ii = ii + 1
              enddo
            enddo
      endif
!           --------------------------------------------- End of Case 22
      if (select == 23)  then
!           ---------------------------------------------------- Case 23
            write (*,'("Index  Ions  Nion ")')
            do io = 1, ncompo
              write (*,'(i2,5x,a4,2x,i6)')io,atom(io),nion(io)
            enddo
            write (*,'("Type index to be combined (eg. 1,2) >>> ")',advance ='no')
            read (*,*) c1,c2
            write(*,'("selected ions: ",i2," and ",i2)')c1,c2
            if (c1 > c2) then
              tmpc = c2
              c2 = c1
              c1 = tmpc
            endif
            do io = c1+1, ncompo
              do i = ions(1,io),ions(2,io)
                pp(:,i) = p(:,i)
                q0(:,i) = p0(:,i)
                vq10(:,i) = v10(:,i)
              enddo
            enddo
            ii = ions(2,c1)+1
            do i = ions(1,c2),ions(2,c2)
              p(:,ii) = pp(:,i)
              p0(:,ii) = q0(:,i)
              v10(:,ii) = vq10(:,i)
              ii = ii + 1
            enddo
            do io = c1+1,ncompo
              if (io == c2) cycle
              do i = ions(1,io),ions(2,io)
                p(:,ii) = pp(:,i)
                p0(:,ii) = q0(:,i)
                v10(:,ii) = vq10(:,i)
                ii = ii + 1
              enddo
            enddo
            NION(c1) = NION(c1) + NION(c2)
            NION(c2) = 0
            ii = c1 + 1
            do io = c1+1, ncompo
              if (io == c2) cycle
              nion(ii) = nion(io)
              atom(ii) = atom(io)
              ii = ii + 1
            enddo
            ncompo = ncompo -1
            write (*,'("Index  Ions  Nion ")')
            do io = 1, ncompo
              write (*,'(i2,5x,a4,2x,i6)')io,atom(io),nion(io)
            enddo
            ions(1,1) = 1
            ions(2,1) = nion(1)
            do io = 2, ncompo
              ions(1,io) = ions(2,io-1) + 1
              ions(2,io) = ions(2,io-1) + nion(io)
            enddo
      endif
!           --------------------------------------------- End of Case 23
      if (select == 24)  then
!           ---------------------------------------------------- Case 24
 2401       write (*,*) 'Input Miller index: h,k'
            read (*,*) hh,k
            l = 0
            write (*,'("Miller index = (",2i3,"), ok (y,n)?")') hh,k
            read (*,*) ans
            if (ans  /=  'y' .and. ans  /=  'Y') go to 2401
            if (hh == 0 .and. k == 0 .and. l == 0) stop 'No meaning!!'
!
            itra2 = 1  !definition of tmatrx
!           ----------------------------------(h,k,l) -> (x,y,z)
            write(*,*)'lattice constants of input cell'
            write(*,'(f11.8,1x,f11.8,1x,f11.8)') box(1),box(2),box(3)
            write(*,'(f11.8,1x,f11.8,1x,f11.8)') box(4),box(5),box(6)
!
            call tmatrx
!
!           ------------ Calcuation of the plane as vector in xyz
            ntion = ntion + 1010
            do i = 1,ntion
              pp(1,i) = 0.0D0 !-0.5D0
              pp(2,i) = 0.0D0 !-0.5D0
              pp(3,i) = 0.0D0 !-0.5D0
            enddo
!
              if (hh == 0) pp(1,1) = 1.0d0
              if (hh /= 0) pp(1,1) = 1.0D0/dble(hh)
              if (k == 0)  pp(2,2) = 1.0d0
              if (k /= 0)  pp(2,2) = 1.0d0/dble(k)
              if (l == 0)  pp(3,3) = 1.0d0
!              if (l /= 0)  pp(3,3) = 1.0d0/dble(l)
!
            call ptoxyz
!
!
            aax = q(1,1)
            aay = q(2,1)
            aaz = q(3,1)
            bx = q(1,2)
            by = q(2,2)
            bz = q(3,2)
            cx = q(1,3)
            cy = q(2,3)
            cz = q(3,3)
!            write(*,*) "lattice vector in cartesian"
!            write(*,*) aax,aay,aaz
!            write(*,*) bx,by,bz
!            write(*,*) cx,cy,cz
            if (hh /= 0) then
                    aax = aax * hh
                    aay = aay * hh
                    aaz = aaz * hh
            endif
            if (k /= 0) then
                    bx = bx * k
                    by = by * k
                    bz = bz * k
            endif
!            if (l /= 0) then
!                    cx = cx * l
!                    cy = cy * l
!                    cz = cz * l
!            endif
!
              write(*,*) '(hk) mode' 
              aaa1(1) = q(1,2)-q(1,1)
              aaa1(2) = q(2,2)-q(2,1)
              aaa1(3) = q(3,2)-q(3,1)
              aaa2(1) = 0.0d0 
              aaa2(2) = 0.0d0
              aaa2(3) = 1.0d0
!           --------------------- normal vector of (hkl) plane
            q(1,4) = aaa1(2)*aaa2(3)-aaa1(3)*aaa2(2)
            q(2,4) = aaa1(3)*aaa2(1)-aaa1(1)*aaa2(3)
            q(3,4) = aaa1(1)*aaa2(2)-aaa1(2)*aaa2(1)
!           --------------------------------------------------
!
!            write(*,*) 'normal vector to hk'
!            write(*,*) q(1,4)
!            write(*,*) q(2,4)
!            write(*,*) q(3,4)
!
            abinp = aax*bx + aay*by + aaz*bz
            aint = aax**2 + aay**2 + aaz**2
            bint = bx**2 + by**2 + bz**2
            dnvydnvx = (abinp/k-aint/hh)/(abinp/hh-bint/k)
            write(*,*) 'nvy/nvx = ', dnvydnvx 
            write(*,'("Input nvx in integer >>> ")',advance='no')  
            read (*,*) nvx
            write(*,'("Input nvy in integer >>> ")',advance='no')  
            read (*,*) nvy
            write(*,*) '(nvx,nvy)= ', nvx, nvy
!           --------------------- Calculation of rotational matrix
            theta = atan(q(2,4)/q(1,4))
            if (theta < 0.0d0) theta = theta + pi
            if (q(1,4)*cos(theta)+q(2,4)*sin(theta) < 0.0d0)  theta = theta + pi
            write(*,'("theta= ",f10.2)') theta*180.0d0/pi
            costheta = cos(theta)
            sintheta = sin(theta)
!
!          ------------- after rotation
!
!
!
!          ----------------- rotaion of large unit cell
            Nx = 15
            Ny = 15
            Nz =  8
            NNN = 0
            DO IO = 1, NCOMPO
              DO I = IONS(1,IO), IONS(2,IO)
                DO K1 = 0, Nx-1
                  DO K2 = 0, Ny-1
                    DO K3 = 0, Nz-1
                      NNN = NNN + 1
                      Q(1,NNN)   = (P(1,I) + dble(K1)) / dble(Nx)
                      Q(2,NNN)   = (P(2,I) + dble(K2)) / dble(Ny)
                      Q(3,NNN)   = (P(3,I) + dble(K3)) / dble(Nz)
                      call  RANDOM
                      VQ10(1,NNN) = V10(1,I) + (r1-0.5d0)*0.001d0
                      VQ10(2,NNN) = V10(2,I) + (r2-0.5d0)*0.001d0
                      VQ10(3,NNN) = V10(3,I) + (r3-0.5d0)*0.001d0
                      DO J = 1, 3
                        Q0(J,NNN)  = Q(J,NNN)
                      enddo
                    enddo
                  enddo
                enddo
              enddo
            enddo
            NTION = NNN
            if (NTION > LNI) stop 'Increase LNI'
            DO I = 1, NTION
              DO J = 1, 3
                P(J,I)   = Q(J,I)
                V10(J,I) = VQ10(J,I)
                P0(J,I)  = Q0(J,I)
              enddo
            enddo
            NELM = 0
            DO IO = 1, NCOMPO
              NION(IO) = NION(IO) * Nx * Ny * Nz
              IONS(1,IO) = NELM + 1
              NELM       = NELM + NION(IO)
              IONS(2,IO) = NELM
            enddo
            ubox(1) = box(1)
            ubox(2) = box(2)
            ubox(3) = box(3)
            box(1) = box(1) * dble(Nx)
            box(2) = box(2) * dble(Ny)
            box(3) = box(3) * dble(Nz)
            WRITE (*,2405)  (BOX(I),I=1,3),DENSTY
            write (*,2406)  (BOX(i+3),i=1,3)
 2405       FORMAT (6X,'Basic cell :',3F9.4,' A', 6X,'Density :',F7.4, ' g/cm3')
 2406       format (6x,'Angle (cos):',3f9.4)
!
            call tmatrx
!
            do i = 1, ntion
              pp(1,i) = p(1,i) -0.5D0
              pp(2,i) = p(2,i) -0.5D0
              pp(3,i) = p(3,i) -0.5D0
            enddo
!
            call ptoxyz
!
            do i = 1, ntion
              cr(1,i) =  costheta*q(1,i)+sintheta*q(2,i) 
              cr(2,i) =  -1.0d0*sintheta*q(1,i)+costheta*q(2,i)
              cr(3,i) =  q(3,i) 
            enddo
!
!          Cell parameters of output
!           box(1) = sqrt(bx**2 + by**2)
!           write(*,*) aax,aay,aaz
!           write(*,*) bx,by,bz
!           write(*,*) nvx,nvy
           box(1) = sqrt((nvx*aax+nvy*bx)**2 + (nvx*aay+nvy*by)**2 + (nvx*aaz+nvy*bz)**2)
           box(2) = sqrt((-k*aax+hh*bx)**2 + (-k*aay+hh*by)**2 + (-k*aaz+hh*bz)**2)
           box(3) = sqrt(cx**2 + cy**2 + cz**2)
           box(4) = (-1.0d0*cx*sintheta + cy*costheta)/box(3)  
           box(5) = (cx*costheta + cy*sintheta)/box(3)
!           box(5) = ((cx*costheta+cy*sintheta)*(bx*costheta+by*sintheta)+ &
!                     (-1.0d0*cx*sintheta+cy*costheta)*(-1.0d0*bx*sintheta+by*costheta)) &
!                     /box(1)/box(3)
           box(6) = 0.0d0
!           box(6) = (k*(aax*bx+aay*by)-hh*(bx**2+by**2))/ &
!                    (box(1)*box(2))
!
!           write(*,*)'Lattice constants'
!           write(*,*)box(1),box(2),box(3)
!           write(*,*)box(4),box(5),box(6)
!
           itra2 = 1
           call tmatrx
!
           call xyztop
!
!          -------- Selection of atoms in primitive cell
           nnn = 0
           do io = 1,ncompo
             do i = ions(1,io),ions(2,io)
               p(1,i) = q(1,i)
               p(2,i) = q(2,i)
               p(3,i) = q(3,i)
               if(p(1,i)  <=  1.0D0 .and. p(1,i)  >  0.0D0) then
               if(p(2,i)  <=  1.0D0 .and. p(2,i)  >  0.0D0) then
               if(p(3,i)  <=  1.0D0 .and. p(3,i)  >  0.0D0) then
                 nnn = nnn + 1
                 num(io,nnn) = i
!                 write(*,*)i
               endif
               endif
               endif
             enddo
             ions(1,1) = 1
             ions(2,io) = nnn
             nion(1) = ions(2,1)
             if (io  >=  2) then 
               ions(1,io) = ions(2,io-1)+1
               nion(io) = ions(2,io)-ions(2,io-1)
             endif
           enddo
!
          ntion = ions(2,ncompo)
          do io = 1, ncompo
            do i = ions(1,io),ions(2,io)
!              write(*,*)num(io,i)
              p(1,i) = p(1,num(io,i))
              p(2,i) = p(2,num(io,i))
              p(3,i) = p(3,num(io,i))
            enddo
          enddo
!
      end if
!     -------------------------------------------------- End of Case 24
      if (select == 25)  then
!           ---------------------------------------------------- Case 25
            write (*,'("Type index to be exchanged (eg. 1,2) >>> ")',advance ='no')
            read (*,*) c1,c2
            write(*,'("selected ions: ",i5," and ",i5)')c1,c2
            tempp(:)=p(:,c1)
            tempp0(:)=p0(:,c1)
            tempv10(:)=v10(:,c1)
            p(:,c1)=p(:,c2)
            p0(:,c1)=p0(:,c2)
            v10(:,c1)=v10(:,c2)
            p(:,c2)=tempp(:)
            p0(:,c2)=tempp0(:)
            v10(:,c2)=tempv10(:)
      endif
!           --------------------------------------------- End of Case 25
      if (select == 26)  then
!           ---------------------------------------------------- Case 26
 2604       write (*,*) 'Vertical Axis 1:x, 2:y, 3:z'
            read(*,*) ia
            if (ia > 4 .or. ia < 1) goto 2604
 2605       write (*,*) 'Horizontal Axis 1:x, 2:y, 3:z'
            read(*,*) ih
            if (ih > 4 .or. ih < 1) goto 2605
            if (ih == ia) then
               write(*,*) 'Error: Same axis'
               goto 2604
            endif
!            
            write (*,*) 'Type Gaussian parameters '
 2601       write (*,*) 'Height (angstrom) '
            read (*,*) height
!            if (height<=0.0) goto 2601
 2602       write (*,*) 'center (angstrom) '
            read (*,*) gcenter 
            if (gcenter<=0.0) goto 2602
!            gcenter=0.5
 2603       write (*,*) 'sigma (angstrom) '
            read (*,*) gsigma 
            if (gsigma<=0.0) goto 2603
 2606       write (*,*) 'base line (angstrom) '
            read (*,*) gbase 
            if (gbase<=0.0) goto 2606
            write(*,*)height,gcenter,gsigma,gbase
!
            call tmatrx
!
!            Q(1,1)  = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
!            Q(2,1)  = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
!            Q(3,1)  = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!           Lattice vector a in orthorhombic cell
            Q(1,1) = H(1,1)
            Q(2,1) = H(2,1)
            Q(3,1) = H(3,1)
!           Lattice vector b
            Q(1,2) = H(1,2)
            Q(2,2) = H(2,2)
            Q(3,2) = H(3,2)
!           Lattice vector c
            Q(1,3) = H(1,3)
            Q(2,3) = H(2,3)
            Q(3,3) = H(3,3)
!
            write(*,*) H(1,1),H(2,1),H(3,1)
            write(*,*) H(1,2),H(2,2),H(3,2)
            write(*,*) H(1,3),H(2,3),H(3,3)
!
!
!           List between dx and dl
            gdx(0)=0.0d0
            DRX=0.1d0
            do J = 1, 10000
              RX=DBLE(J)*DRX
              deriv=-2.0d0*height*(RX)/gsigma**2*exp(-1.0d0*(RX)**2/gsigma**2)
              gdx(J)=gdx(J-1)+DRX/sqrt(deriv**2+1.0d0)
            enddo
!
            if (ih==1) then
              maxvec=Q(1,1)
              J=INT((maxvec-gcenter)/DRX)
              shiftx0=maxvec-gcenter-gdx(J)
              Q(1,1)=Q(1,1)-2.0d0*shiftx0
              Q(2,1)=Q(2,1)
              Q(3,1)=Q(3,1)
            elseif (ih==2) then
              maxvec=Q(2,2)
              J=INT((maxvec-gcenter)/DRX)
              shiftx0=maxvec-gcenter-gdx(J)
              Q(1,2)=Q(1,2)
              Q(2,2)=Q(2,2)-2.0d0*shiftx0
              Q(3,2)=Q(3,2)
            elseif (ih==3) then
              maxvec=Q(3,3)
              J=INT((maxvec-gcenter)/DRX)
              shiftx0=maxvec-gcenter-gdx(J)
              Q(1,3)=Q(1,3)
              Q(2,3)=Q(2,3)
              Q(3,3)=Q(3,3)-2.0d0*shiftx0
            endif
!
!           New lattice parameters
            BOX(1)= sqrt(Q(1,1)**2+Q(2,1)**2+Q(3,1)**2)
            BOX(2)= sqrt(Q(1,2)**2+Q(2,2)**2+Q(3,2)**2)
            BOX(3)= sqrt(Q(1,3)**2+Q(2,3)**2+Q(3,3)**2)
            BOX(4)=(Q(1,2)*Q(1,3)+Q(2,2)*Q(2,3)+Q(3,2)*Q(3,3))/BOX(2)/BOX(3)
            BOX(5)=(Q(1,1)*Q(1,3)+Q(2,1)*Q(2,3)+Q(3,1)*Q(3,3))/BOX(1)/BOX(3)
            BOX(6)=(Q(1,2)*Q(1,1)+Q(2,2)*Q(2,1)+Q(3,2)*Q(3,1))/BOX(2)/BOX(1)
!
!
            do I = 1, NTION
              px1 = p(1,I)
              py1 = p(2,I)
              pz1 = p(3,I)
              pp(1,I) = px1
              pp(2,I) = py1
              pp(3,I) = pz1
            enddo
!
            call PTOXYZ
!
!
            do I = 1, NTION
!
              cr(:,I)=Q(:,I)
              shift(:)=0.0d0
!
              J=INT((Q(ih,I)-gcenter)/DRX)
              if(J < 0) then
                J = -1*J
                shift(ih)=-1.0d0*gdx(J)+gcenter
              else  
                shift(ih)=gdx(J)+gcenter
              endif
!
              dy=Q(ia,I)-gbase
              dd=shift(ih)-gcenter
              if(dd**2>1.0d-12)then
                deriv=1.0d0/(2.0d0*height*(dd)/gsigma**2*exp(-1.0d0*(dd)**2/gsigma**2))
                if(dy*deriv<0.0d0) dx=-1.0d0*abs(dy/(sqrt(1+deriv**2)))
                if(dy*deriv>=0.0d0) dx=abs(dy/sqrt(1+deriv**2))
                dz=deriv*dx
              else
                dz=dy
                dx=0.0d0
              endif
!
                shift(ia)=height*exp(-1.0*(dd)**2/gsigma**2)+dz
                shift(ih)=shift(ih)+dx
                
!
              cr(ia,I) = gbase+shift(ia)
              cr(ih,I) = shift(ih)-shiftx0
            enddo
!
            call tmatrx
!
            call xyztop
!
            do I = 1, NTION
              px2 = Q(1,I)
              py2 = Q(2,I)
              pz2 = Q(3,I)
!
              P(1,I)=px2
              P(2,I)=py2
              P(3,I)=pz2
!
              P0(1,I)=px2
              P0(2,I)=py2
              P0(3,I)=pz2
            enddo
!           --------------------------------------------- End of Case 26
      end if
      if (select == 99)  then
!           ---------------------------------------------------- Case 99
            DO 9901  I = 1, NTION
                call  random
                p(1,i) = p(1,i) + (r1-0.5)*0.00001
                p(2,i) = p(2,i) + (r2-0.5)*0.00001
                p(3,i) = p(3,i) + (r3-0.5)*0.00001
 9901       CONTINUE
!           --------------------------------------------- End of Case 99
      end if
!                                                =======================
!     ============================================= [4: OUTPUT SECTION ]
!                                                =======================
!     -------------------------------- Write on file07.dat with new form
      CALL  FILE07  (0)
!     ------------------------------------------------------------------
!
      STOP
      END
!
!
!                                                          =============
!============================================================ [ RANDOM ]
!                                                          =============
      SUBROUTINE  RANDOM
      use randm3
!
      implicit none
!
!      double precision :: rnd
!      double precision rr(0:3)
!      integer :: i, seedsize
!      integer II, JJ, KK, IR, JR, KR
      integer II,JJ,KK,LL,MM,NN
!      integer, allocatable :: seed(:)
!
!      call random_seed(size=seedsize)
!      allocate(seed(seedsize))
!      do i=1,seedsize
!        call system_clock(count=seed(i))
!      enddo
!      call random_seed(put=seed)
!      do i=1,4
!        call random_number(rnd)
!        rr(i-1)=rnd
!      enddo
!      R1=rr(1)
!      R2=rr(2)
!      R3=rr(3)
          II = ((JR/3) * (KR/3) + LR) / 2
          JJ = ((IR/3) * (KR/3) + MR) / 2
          KK = ((IR/3) * (JR/3) + NR) / 2
              IR = MOD(II,100000)
              JR = MOD(JJ,100000)
              KR = MOD(KK,100000)
                  R1 = FLOAT(IR) * 0.00001
                  R2 = FLOAT(JR) * 0.00001
                  R3 = FLOAT(KR) * 0.00001
              LL = ((MR/3) * (NR/3) + IR) / 2
              MM = ((LR/3) * (NR/3) + JR) / 2
              NN = ((LR/3) * (MR/3) + KR) / 2
          LR = MOD(LL,100000)
          MR = MOD(MM,100000)
          NR = MOD(NN,100000)
      RETURN
!
      ENTRY  RNDMIZ
         IR = 32723
            JR = 23557
               KR = 47979
               LR = 54893
            MR = 16617
         NR = 79423
      RETURN
      END
!
!
!                                                          =============
!============================================================ [ INPF07 ]
!                                                          =============
      SUBROUTINE  FILE07  (NEWOLD)
!
      use param
      use chara
      use data1
      use data2
!
      implicit none
!
      double precision  v16(3,LNI), h(3,3)
      double precision stemp,vstemp,pfd
      character(len=1)::  DEFECT,an
      integer(KIND=4) newold,i,j,iform7,ntiond,io
      integer(KIND=4) nrec1,nrec4,nrec5,nhist
!
      IF (NEWOLD < 0)  GO TO 10
      IF (NEWOLD == 0)  THEN
        OPEN (17, FILE='file07.dat', STATUS='UNKNOWN', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
          go to 300
      END IF
!
      iform7=0
            OPEN (17, FILE=FLNAME(7), STATUS='OLD', &
                     ACCESS='SEQUENTIAL', FORM='FORMATTED' )
            READ (17,'(15A4,2I5)') TITLE, NJOB
            read (17,'(I7,I3, 10I10)') NTION, NCOMPO, (NRECRD(I),I=1,9) 
            READ (17,'(20(2X,A4))') (ATOM(I),I=1,NCOMPO)
            READ (17,'(20I6)') (NION(I),I=1,NCOMPO)
            READ (17,'(20I6)') (IONS(1,I),I=1,NCOMPO)
            READ (17,'(20I6)') (IONS(2,I),I=1,NCOMPO)
            READ (17,'(F10.2,F10.4,F10.2, 3F10.5)') TEMP, DELTMP,TMPGET, SPRES
            read (17,'(E10.3, A10, 6F10.6)') DTIME,  RUNOPT(28), BOX
            read (17,'(F10.6, A10, 6F10.6)') DENSTY, RUNOPT(29), VBOX
            write (*,*) runopt(29)
            IF (RUNOPT(28) == 'THERMOSTAT') READ (17,'(10X,3F20.10)') STEMP,VSTEMP
            IF (RUNOPT(29) == 'H-TENSOR  ') THEN
              DO I = 1, 3
                READ (17,'(10X,3F20.10)')  (H(I,J),J=1,3)
              enddo
            END IF
            write(*,'("Success to read parameters.")')
            if (iform7 == 0 ) then
              if (select == 11 .or. select == 18) then
!                ------------------------------index number of O of H2O
                ioxy = 6
                if (ATOM(ioxy) /= 'O   ') ioxy = 7
                if (ATOM(ioxy) /= 'O   ') ioxy = 8
                if (ATOM(ioxy) /= 'O   ') ioxy = 5
                if (ATOM(ioxy) /= 'O   ') ioxy=4
                if (ATOM(ioxy) /= 'O   ') ioxy=3
                if (ATOM(ioxy) /= 'O   ') ioxy=2
                if (ATOM(ioxy) /= 'O   ') ioxy=1
                if (ATOM(ioxy) /= 'O   ') ioxy=0
                if (ioxy == 0) goto 9
                ih = ioxy + 1
                write(*,'("==========================================")')
  5             if (select == 11) then
                  write(*,'( "The natom of O for H2O is ",i2)') ioxy
                  write(*,'( "The natom of H for H2O is ", i2)') ih
                elseif (select == 18) then
                  write(*,'( "The index of O is ",i2)') ioxy
                endif
                write(*,'("ok? (y,n)  >>> ",$)')
                    read(*,*) an
                    if (an /= 'y') then
                          if (an =='n') then
                    if (select == 11) then
                      write(*,'("Input the index of O of H2O >>>", $)')
                      read (*,*)ioxy
                      write(*,'("Input the index of H of H2O >>>", $)')
                      read (*,*)ih
                    elseif (select == 18) then
                      write(*,'("Input the index of O >>>", $)')
                      read (*,*)ioxy
                    endif
                    goto 5
                  else 
                    goto 5
                  endif
                endif
              endif
              if (select == 11) write(*,'("Success to check water.")')
              write(*,'("iform7 = ", i2)') iform7
            endif
!
   9        NTIOND = 0
            DO I = 1, NTION
              IOND(I) = 1
              if (iform7 == 0) then
                READ (17,'(3F10.8, A1, 3F9.7, 1X, 3F10.7, 1x,i2)') (P(J,I),J=1,3),DEFECT, &
                        (V10(J,I),J=1,3),(P0(J,I),J=1,3)
              else
                READ (17,'(3F9.7, A1, 3F8.6, 1X, 3F9.7, 1x,i2)') (P(J,I),J=1,3),DEFECT, &
                        (V10(J,I),J=1,3),(P0(J,I),J=1,3)
              end if
! Remove this criterion 2016 Aug 1
!              if ((V10(1,i)-5)**2+(V10(2,i)-5)**2+(V10(3,i)-5)**2> 5.0) then
!                close (17)
!                write (6,*) 'File07.dat is old format,'
!                write (6,*) ' so is converted into new.'
!                iform7 = 1
!                go to 7
!              end if
              IF (DEFECT /= ' ') THEN
                IOND(I) = 0
                NTIOND  = NTIOND + 1
                V10(1,I) = 0.0d0
                V10(2,I) = 0.0d0
                V10(3,I) = 0.0d0
              END IF
            enddo
!
            IF (NTIOND > 0) WRITE (*,7979) NTIOND
 7979                FORMAT (1X,I6,' DEFECTS WERE DETECTED ')
               IF (NRECRD(6) > 0) THEN
               READ (17,2706,END=220,ERR=220)  ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
               GO TO 230
  220          NRECRD(6) = 0
  230       END IF
            CLOSE  (17)
!           -------------------------- Write on file07.dat with new form
            OPEN (17, FILE='file07.old', STATUS='UNKNOWN', &
                      ACCESS='SEQUENTIAL', FORM='FORMATTED' )
  300       WRITE (17,2701) TITLE, NJOB, &
                            NTION, NCOMPO, (NRECRD(I),I=1,9) 
            WRITE (17,2702) (ATOM(I),I=1,NCOMPO)
            WRITE (17,2703) (NION(I),I=1,NCOMPO)
            WRITE (17,2703) (IONS(1,I),I=1,NCOMPO)
            WRITE (17,2703) (IONS(2,I),I=1,NCOMPO)
            WRITE (17,2704) TEMP, DELTMP,TMPGET, SPRES, &
                            DTIME,   runopt(28),  BOX, &
                            DENSTY,  runopt(29),  VBOX 
            IF (RUNOPT(28) == 'THERMOSTAT') write(17,7080) STEMP,VSTEMP
            runopt(29) = '         '
!            IF (RUNOPT(29) == 'H-TENSOR  ') THEN
!                  DO 101  I = 1, 3
!                      WRITE (17,7080)  (H(I,J),J=1,3)
!  101             CONTINUE
!            END IF
            DO Io = 1, Ncompo
               do i = ions(1,io), ions(2,io)
                  do j=1, 3
                     if (p(j,I) < 0.0) then
                           p(j,i) = p(j,i)  + 1.0
                           p0(j,i)= p0(j,i) + 1.0
                     end if
                     if (p(j,I) >= 1.0) then
                           p(j,i) = p(j,i)  - 1.0
                           p0(j,i)= p0(j,i) - 1.0
                     end if
                  enddo   
                  WRITE (17,2715) (P(J,I),J=1,3),' ',(V10(J,I),J=1,3),(P0(J,I),J=1,3), io
               enddo
            enddo 
            IF (NRECRD(6) > 0)  THEN
                  WRITE (17,2706) ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
            END IF
            ENDFILE (17)
            CLOSE   (17)
            RETURN
!
!
!     ---------------------------------- Read file07.dat with old format
   10       OPEN (17, FILE=FLNAME(7), STATUS='OLD',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
              READ (17,'(15A4)') TITLE
              read (17,'(2I5,5(I5,A4,1X),I5)') NTION,NREC1,(NION(I),ATOM(I),I=1,5),NHIST
              read (17,'(14I5)') NJOB,(IONS(1,I),IONS(2,I),I=1,5),NREC4,NREC5
              READ (17,'(F10.2,E10.3,6F10.6)') TEMP,DTIME,BOX
              read (17,'(2F10.3,F10.6,3F10.4,F10.6)')DELTMP,TMPGET,DENSTY,SPRES,PFD
              DO I = 1, NTION
                READ (17,'(3F9.6, A1, 3F8.5, 1X, 3F9.6)') (P(J,I),J=1,3),DEFECT, &
                                                  (V16(J,I),J=1,3),(P0(J,I),J=1,3)
              enddo
              IF (NHIST > 0) THEN
                READ (17,'(3(I10,I5,I4,1X,I6))',END=60,ERR=60) & 
                     ((IHISTR(J,I),J=1,4),I=1,NHIST)
                GO TO 70
   60           NHIST = 0
   70         END IF
            CLOSE   (17)
!
!           ---------------------------------------- Write on file07.old
            OPEN (27, FILE='file07.old', STATUS='UNKNOWN', &
                      ACCESS='SEQUENTIAL', FORM='FORMATTED' )
              write (17,'(15A4)') TITLE
              write (17,'(2I5,5(I5,A4,1X),I5)') NTION,NREC1,(NION(I),ATOM(I),I=1,5),NHIST
              write (17,'(14I5)') NJOB,(IONS(1,I),IONS(2,I),I=1,5),NREC4,NREC5
              write (17,'(F10.2,E10.3,6F10.6)') TEMP,DTIME,BOX
              write (17,'(2F10.3,F10.6,3F10.4,F10.6)')DELTMP,TMPGET,DENSTY,SPRES,PFD
              DO I = 1, NTION
                write (17,'(3F9.6, A1, 3F8.5, 1X, 3F9.6)') (P(J,I),J=1,3),DEFECT, &
                                                  (V16(J,I),J=1,3),(P0(J,I),J=1,3)
              enddo
              IF (NHIST > 0) THEN
                WRITE (27,'(3(I10,I5,I4,1X,I6))')  ((IHISTR(J,I),J=1,4),I=1,NHIST)
              END IF
            CLOSE   (27)
!
            NRECRD(1) = NREC1
            NRECRD(2) = 0.0
            NRECRD(3) = 0.0
            NRECRD(4) = NREC4
            NRECRD(5) = NREC5
            NRECRD(6) = NHIST
            NRECRD(7) = 0.0
            NRECRD(8) = 0.0
            NRECRD(9) = 0.0
            DO IO = 1, 5
              IF (NION(IO) > 0)  NCOMPO = IO
            enddo
            DO I = 1, 6
              VBOX(I) = 0.0
            enddo
            VBOX(1) = PFD
            DO I = 1, NTION
               DO J = 1, 3
                   V10(J,I) = V16(J,I) * (10.0/16.0) + 5.0
               enddo
            enddo
      RETURN
!
! 1701  FORMAT (15A4 / 2I5,5(I5,A4,1X),I5 / 14I5)
! 1702  FORMAT (F10.2,E10.3,6F10.6 / 2F10.3,F10.6,3F10.4,F10.6)
! 1703  FORMAT (3F9.6, A1, 3F8.5, 1X, 3F9.6)
! 1704  FORMAT (3(I10,I5,I4,1X,I6))
! 2701  FORMAT (15A4,2I5 / I7,I3, 3I10, 7I5 )
  2701  FORMAT (15A4,2I5 / I7,I3, 10I10)
 2702  FORMAT (20(2X,A4) )
 2703  FORMAT (20I6 )
 2704  FORMAT (F10.2,F10.4,F10.2, 3F10.5 / &
               E10.3, A10, 6F10.6 /  &
               F10.6, A10, 6F10.6 ) 
! 2705  FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.7, 1x,i2)
 2715  FORMAT (3F10.8, A1, 3F9.7, 1X, 3F10.7, 1x,i2)
 2706  FORMAT (3(I10,I5,I4,1X,I6))
 7080  FORMAT  (10X,3F20.10)
      END
!================================================================ tmatrx
      subroutine  tmatrx
      use param
      use cartes
      use data2
      implicit none
!
      integer(KIND=4) i
      double precision vol,cosa(3),sina(3)
!
!
!     -- (0,0,0),(1,0,0),(0,1,0),(0,0,1),(1,1,0),(1,0,1),(0,1,1),(1,1,1)
!
!
!     ---------------------------- cos and sin of alpha, beta, and gamma
      do 120  i = 1, 3
          cosa(i) = box(i+3)
          sina(i) = sqrt(1.0D0 - cosa(i)**2)
  120 enddo
!
!     ------------------ Transformation matrix from crystal to Cartesian
!      write(*,*)'In tmatrx, lattice constants'
!      write(*,*)box(1),box(2),box(3)
!      write(*,*)box(4),box(5),box(6)
!
      h(1,3) =  0.0D0
      h(2,3) =  0.0D0
      h(3,3) =  box(3)
      h(1,2) =  0.0D0
      h(2,2) =  box(2)*sina(1)
      h(3,2) =  box(2)*cosa(1)
      h(3,1) =  box(1)*cosa(2)
      h(2,1) = -box(1)*(cosa(1)*cosa(2)-cosa(3))/sina(1)
      h(1,1) = box(1)*sqrt(1-cosa(1)**2-cosa(2)**2-cosa(3)**2+ &
                                 2*cosa(1)*cosa(2)*cosa(3))/sina(1)
              vol = h(3,1)*(h(1,2)*h(2,3) - h(2,2)*h(1,3)) - &
                    h(2,1)*(h(1,2)*h(3,3) - h(3,2)*h(1,3)) + &
                    h(1,1)*(h(2,2)*h(3,3) - h(3,2)*h(2,3))
              if (vol <= 0.0D0)  then
                      h(1,1) = - h(1,1)
                      h(2,1) = - h(2,1)
                      h(3,1) = - h(3,1)
                      vol    = - vol
              END IF
!
             write (*,'("Lattice matrix")')
             WRITE (*,'(3(F8.3,1x))')  H(1,1), H(2,1), H(3,1)
             WRITE (*,'(3(F8.3,1x))')  H(1,2), H(2,2), H(3,2)
             WRITE (*,'(3(F8.3,1x))')  H(1,3), H(2,3), H(3,3)
!             WRITE (*,*)  VOL
!
      if (itra2  ==  1) then
      h(1,1) =  box(1)
      h(1,2) =  box(2)*cosa(3)
      h(1,3) =  box(3)*cosa(2)
      h(2,1) =  0.0D0
      h(2,2) =  box(2)*sina(3)
      h(2,3) =  box(3)*(cosa(1)-cosa(2)*cosa(3))/sina(3)
      h(3,1) =  0.0D0
      h(3,2) =  0.0D0
      h(3,3) = box(3)*sqrt(1-cosa(1)**2-cosa(2)**2-cosa(3)**2+ &
                                 2*cosa(1)*cosa(2)*cosa(3))/sina(3)
              vol = h(3,1)*(h(1,2)*h(2,3) - h(2,2)*h(1,3)) - &
                    h(2,1)*(h(1,2)*h(3,3) - h(3,2)*h(1,3)) + &
                    h(1,1)*(h(2,2)*h(3,3) - h(3,2)*h(2,3))
              if (vol <= 0.0D0)  then
                      h(1,1) = - h(1,1)
                      h(2,1) = - h(2,1)
                      h(3,1) = - h(3,1)
                      vol    = - vol
              END IF
!             WRITE (*,*)  H(1,1), H(1,2), H(1,3)
!             WRITE (*,*)  H(2,1), H(2,2), H(2,3)
!             WRITE (*,*)  H(3,1), H(3,2), H(3,3)
!             WRITE (*,*)  VOL
      endif
!
!     ------------------ Transformation matrix from Cartesian to crystal
!
      call  invers
!
      RETURN
      END
!
!
!                                                               ========
!================================================================ PTOXYZ
!
      SUBROUTINE  PTOXYZ
      use data1
      use data2
      use cartes
      implicit none
!
      integer(KIND=4)  j, kkk
      REAL(8)  PX,PY,PZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CRYSTAL TO CARTESIAN (X,Y,Z)
!
      kkk = ntion
      if ( select == 22) kkk = 1
      do j=1,kkk
                  PX = pp(1,J)
                  PY = pp(2,J)
                  PZ = pp(3,J)
          Q(1,J)  = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
          Q(2,J)  = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
          Q(3,J)  = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!             WRITE (*,'(3(F8.3,1x))')  H(1,1), H(2,1), H(3,1)
!             WRITE (*,'(3(F8.3,1x))')  H(1,2), H(2,2), H(3,2)
!             WRITE (*,'(3(F8.3,1x))')  H(1,3), H(2,3), H(3,3)
!          write(*,*)Q(1,J),Q(2,J),Q(3,J)
      enddo
      RETURN
      END
!                                                               ========
!================================================================ XYZTOP
!
      SUBROUTINE  XYZTOP
      use data1
      use data2
      use cartes
      implicit none
!
      integer(KIND=4):: j
      REAL(8):: PX,PY,PZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CARTESIAN (X,Y,Z) TO CRYSTAL
!
      do 401 j=1,ntion
        PX = cr(1,j)
        PY = cr(2,j)
        PZ = cr(3,j)
        Q(1,J)  = HINV(1,1)*PX + HINV(1,2)*PY + HINV(1,3)*PZ
        Q(2,J)  = HINV(2,1)*PX + HINV(2,2)*PY + HINV(2,3)*PZ
        Q(3,J)  = HINV(3,1)*PX + HINV(3,2)*PY + HINV(3,3)*PZ
  401 enddo
!
      RETURN
      END
!                                                               ========
!================================================================ INVERS
      subroutine  invers
      use cartes
!     -------------------------------------------- Given 3 by 3 matrix X
!                             Store determinant at D and inverse at Xinv
!
      implicit none
!
      DET = h(1,1)*h(2,2)*h(3,3) + h(1,2)*h(2,3)*h(3,1) + &
            h(1,3)*h(2,1)*h(3,2) - h(1,3)*h(2,2)*h(3,1) - &
            h(1,2)*h(2,1)*h(3,3) - h(1,1)*h(2,3)*h(3,2)
      IF (DET == 0.0D0)  GO TO 10
         hINV(1,1) = (h(2,2)*h(3,3) - h(3,2)*h(2,3)) / DET
         hINV(1,2) = (h(3,2)*h(1,3) - h(1,2)*h(3,3)) / DET
         hINV(1,3) = (h(1,2)*h(2,3) - h(2,2)*h(1,3)) / DET
         hINV(2,1) = (h(2,3)*h(3,1) - h(3,3)*h(2,1)) / DET
         hINV(2,2) = (h(3,3)*h(1,1) - h(1,3)*h(3,1)) / DET
         hINV(2,3) = (h(1,3)*h(2,1) - h(2,3)*h(1,1)) / DET
         hINV(3,1) = (h(2,1)*h(3,2) - h(3,1)*h(2,2)) / DET
         hINV(3,2) = (h(3,1)*h(1,2) - h(1,1)*h(3,2)) / DET
         hINV(3,3) = (h(1,1)*h(2,2) - h(2,1)*h(1,2)) / DET
!      write(*,*)'In INVERS'
!      write(*,*)hinv(1,1),h(1,2),h(1,3)
!      write(*,*)hinv(2,1),h(2,2),h(2,3)
!      write(*,*)hinv(3,1),h(3,2),h(3,3)
      RETURN
!     --------------------------------------------- TEST FOR SINGULARITY
  10         IF (DET == 0)  WRITE  (*,6180)
6180         FORMAT(5X,'*** The matrix is singular ***')
      RETURN
      END
