PROGRAM F05CONV
!
! Update: Maximum number of elements: 20
!
  implicit none
  integer(4),parameter:: LEM=20,lel=20
  character(LEN=1):: ATY
  character(LEN=2):: AAX
  character(LEN=4):: ATOM(LEM)
  character(LEN=10):: RUNOPT(53)
  integer(4)   NCOMPO,NION(LEM),IION(LEM)
  real(8)   AIO(LEM),BIO(LEM),CIO(LEM),DIO(LEM),ZIO(LEM),WIO(LEM)
  real(8)   RSWTCH(LEM,LEM),dmij(LEM,LEM),beij(LEM,LEM)
  real(8)   rsij(LEM,LEM),dm1ij(LEM,LEM),be1ij(LEM,LEM)
  real(8)   dm2ij(LEM,LEM),be2ij(LEM,LEM),dm3ij(LEM,LEM)
  real(8)   be3ij(LEM,LEM),r03ij(LEM,LEM)
  real(8)   ANG3BP(LEM,LEM),R3BLIM(LEM,LEM)
  real(8)   FK3BP(LEM,LEM),R3BGRD(LEM,LEM)
  real(4)   AREC1,AREC2,AREC3,AREC4,AREC5
  real(4)   DDT,FORMUL,RCUT(2)
  real(4)   TARGT,DELT,STEMP0,TDUMP
  real(4)   SPRES,VIRM(3),BOXA,AMODE,ALPHA
  real(8)   CAL
  real(8)   ANJ,ZJ,WJ,AJ,BJ,CJ,DJ
  real(8)   DIJP,BEIJP,RSIJP,R3BG,GGG,D1,BE1,D2,BE2
  integer(4)   MODE,I,J,IO1,IO,IP,JP,KP,ijkl,IJ,k
  integer*4 ::IP1=0,JP1=0,KP1=0,IP2=0,JP2=0,KP2=0
  character *1 Ins1
  character *1 insIP1,insJP1,insKP1,insIP2,insJP2,insKP2
  character *1, parameter:: ins(1:20) = (/ '1','2','3','4','5','6','7','8','9',&
                                           'A','B','C','D','E','F','G','H','I','J','K' /)
!
  CAL=4.18605D0
  open(15, FILE='file05.dat',status = 'old', &
           access='sequential',form='formatted')
  open (35, file='parameter.dat', status='unknown', &
            access='sequential', form='formatted')
!     --------------------------------------- Data input from FILE05.DAT
    READ (15,'(A10, 15A4)')  RUNOPT(1)
    READ (15,'(A10, 15A4)')  RUNOPT(2)
    READ (15,'(A10, 6F10.0)')  RUNOPT(3), AREC1, AREC2, AREC3, AREC4, AREC5
    READ (15,'(A10, 6F10.0)')  RUNOPT(4), DDT, FORMUL, RCUT(1), RCUT(2)
    READ (15,'(A10, 6F10.0)')  RUNOPT(5), TARGT, DELT, STEMP0, TDUMP
    READ (15,'(A10, 6F10.0)')  RUNOPT(6), SPRES, VIRM(1), VIRM(2), VIRM(3)
    READ (15,'(A10, 6F10.0)')  RUNOPT(7), BOXA
!   -------------------------------------------------- Potential model
    READ (15,'(A10, 6F10.0)')  RUNOPT(8), AMODE, ALPHA
      MODE = INT(AMODE)
      IF (RUNOPT(8) /= 'MORSE     ' .AND. &
          RUNOPT(8) /= 'BMH-EXP   ' .AND. &
          RUNOPT(8) /= 'BUSING    ')  THEN
            WRITE (*,*) 'Interatomic potential model ', &
              runopt(8),' is not recognized yet.'
            STOP
      END IF
    write(35,'(A10)')RUNOPT(8)
!
    DO I = 1, LEM
      ATOM(I) = '    '
      ZIO(I)  = 0.0
      WIO(I)  = 0.0
      AIO(I)  = 0.0
      BIO(I)  = 0.0
      CIO(I)  = 0.0
      DIO(I)  = 0.0
      NION(I) = 0
      IION(I) = 0
    enddo
    NCOMPO = 0
!   --------------------------------------------- Read atom parameters
    DO J = 1, LEL+1
      READ (15,'(A1,A1,A2,F6.0,6F10.0)',END=230)  Ins1,ATY,AAX,ANJ,ZJ,WJ,AJ,BJ,CJ,DJ
!      IF (I <= 0.OR.AAX == '    ')  exit
      IF (Ins1 == ' ' .or. AAX == '  ') GO TO 230
      I = 0
      do k=1, lel
        if (Ins1 == ins(k)) then
                I = k
                exit
        endif
      enddo
      if (I == 0) then
              write(*,*) '!!! Error [file05.dat] at atom ', j,Ins1,I,k, '!!!'
              write(*,'(" ---- atom =",A2,"  Ni=",F5.0," ----")')AAX,ANJ
              stop
      endif
!
        ATOM(I) = AAX
        ZIO(I)  = ZJ
        WIO(I)  = WJ
        AIO(I)  = AJ
        BIO(I)  = BJ
        CIO(I)  = CJ
        DIO(I)  = DJ
        NION(I) = INT(ANJ)
        IION(I) = 0
        NCOMPO = NCOMPO + 1
      enddo
  230 IO1 = NCOMPO + 1
      DO IO = IO1, LEL
        IF (NION(IO) > 0)  NCOMPO = IO
      enddo
      write(35,'(A49)')'Coulomb, short-range, repulsion and van der Waals'
!     -------------------------------conversion from kcal/mol to kJ/mol
!     -------------------------------conversion from Angstrom to nm
      do i=1,ncompo
        aio(i) = aio(i)*0.1D0
        bio(i) = bio(i)*0.1D0
        cio(i) = cio(i)*sqrt(4.18605D0)*1.0D-3
      enddo
      write(35,'(A3,1x,A4,1x,A10,1x,A10,1x,A10,1x,A10,1x,A20)') &
        'No.','atom','q','w(g/mol)','a(nm)','b(nm)','c(kJ/mol)^0.5 (nm)^3' 
      do i = 1, ncompo
        write(35,'(I3,1x,A4,1x,F10.7,1x,F10.6,1x,F10.7,1x,F10.7,1x,F10.7)') & 
          i,atom(i),zio(i),wio(i),aio(i),bio(i),cio(i)
      enddo
!
      k=0
!     ------------------------------------------------------------------
      IF (RUNOPT(8) == 'MORSE     ')  THEN
!  120   READ   (15,'(3I2,i2,2x,4F10.0,10x,F10.0)')  &
!            IP,JP, KP, ijkl,DIJP, BEIJP, RSIJP, R3BG,GGG
!        IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
!        IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
!        IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
120  READ   (15,'(6(A1),i2, 2X,4F10.0,10x,F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, DIJP, BEIJP, RSIJP, R3BG, GGG
     IP = 0
     JP = 0
     KP = 0
     IP1 = 0
     IP2 = 0
     JP1 = 0
     JP2 = 0
     KP1 = 0
     KP2 = 0
     do k=1,LEL
        if (insIP1 == ins(k)) IP1=k
        if (insJP1 == ins(k)) JP1=k
        if (insKP1 == ins(k)) KP1=k
        if (insIP2 == ins(k)) IP2=k
        if (insJP2 == ins(k)) JP2=k
        if (insKP2 == ins(k)) KP2=k
     enddo
     if (IP1 > 0) IP = IP1
     if (JP1 > 0) JP = JP1
     if (KP1 > 0) KP = KP1
     if (IP2 > 0) IP = IP2
     if (JP2 > 0) JP = JP2
     if (KP2 > 0) KP = KP2
        IF (IP.GE.1.AND.IP <= NCOMPO .AND.  &
            JP.GE.1.AND.JP <= NCOMPO )  THEN
          IF (KP == 0)  THEN
            IF (JP > IP)  THEN
              IJ = IP
              IP = JP
              JP = IJ
            END IF
            DMIJ(IP,JP) = DIJP*CAL
            BEIJ(IP,JP) = BEIJP*10.0D0
            RSIJ(IP,JP) = RSIJP*0.10D0
            RSWTCH(IP,JP) = R3BG*0.10D0
            if (ggg > 0.0)  then
              read (15,'(10x, 3f10.0)') dm3ij(IP,JP),be3ij(IP,JP),r03ij(IP,JP)
            end if
            dm3ij(IP,JP) = dm3ij(IP,JP)*CAL
            be3ij(IP,JP) = be3ij(IP,JP)*1.0D2
            r03ij(IP,JP) = r03ij(IP,JP)*0.10D0
            write(35,'(I2,A1,I2)') IP,'-',JP
            write(35,'(A11,1x,A10,1x,A10,1x,A10,1x,A12,1x,A10,1x,A10)') &
              'Dij(kJ/mol)','bij(nm-1)', &
              'Rsij(nm)','Rswtch(nm)', &
              'D3ij(kJ/mol)','b3ij(nm-2)','r3ij(nm)'
            write(35,'(F10.2,2x,F10.2,1x,F10.4,1x,F10.4,1x,F10.2,3x,F10.2,1x,F10.4)') &
              dmij(IP,JP),beij(IP,JP), &
              rsij(IP,JP),rswtch(IP,JP),dm3ij(IP,JP), &
              be3ij(IP,JP),r03ij(IP,JP)
          ELSE IF (IP == KP) THEN
!           -------------------------------------- F:kJ/mol
            FK3BP(IP,JP)    = DIJP*1.0D-18
            ANG3BP(IP,JP)   = BEIJP
            R3BLIM(IP,JP) = RSIJP*0.1D0
            R3BGRD(IP,JP) = R3BG*10.0D0
            IF (ANG3BP(IP,JP) <= 0.01)   ANG3BP(IP,JP)=  90.0
            IF (R3BLIM(IP,JP) <= 0.01) R3BLIM(IP,JP)= 1.2*0.1D0
            IF (R3BGRD(IP,JP) <= 0.01) R3BGRD(IP,JP)=20.0*10.0D0
            write(35,'(I2,A1,I2,A1,I2)') IP,'-',JP,'-',KP
            write(35,'(A10,1x,A11,1x,A10,1x,A10)') & 
               'f(kJ)','theta(deg.)','rm(nm)','gr(nm-1)'
            write(35,'(E10.3,1x,F10.3,2x,F10.4,1x,F10.2)') &
                FK3BP(IP,JP),ANG3BP(IP,JP),R3BLIM(IP,JP),R3BGRD(IP,JP)
          ELSE
            STOP 'Something wrong in potetial param.'
          END IF
          GO TO 120
        END IF
      else if (RUNOPT(8) == 'BMH-EXP   ') then
!  121   READ   (15,'(3I2,i2,2X,6F10.0)') &
!          IP,JP, KP, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
!             write (6,*)  IP,JP, KP, ijkl,
!     *                    D1, BE1, D2, BE2, RSIJP, GGG
!
121  READ   (15,'(6(A1),i2, 2X,6F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
     IP = 0
     JP = 0
     KP = 0
     IP1 = 0
     IP2 = 0
     JP1 = 0
     JP2 = 0
     KP1 = 0
     KP2 = 0
     do k=1,LEL
        if (insIP1 == ins(k)) IP1=k
        if (insJP1 == ins(k)) JP1=k
        if (insKP1 == ins(k)) KP1=k
        if (insIP2 == ins(k)) IP2=k
        if (insJP2 == ins(k)) JP2=k
        if (insKP2 == ins(k)) KP2=k
     enddo
     if (IP1 > 0) IP = IP1
     if (JP1 > 0) JP = JP1
     if (KP1 > 0) KP = KP1
     if (IP2 > 0) IP = IP2
     if (JP2 > 0) JP = JP2
     if (KP2 > 0) KP = KP2
!        IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
!        IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
!        IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
        IF (IP.GE.1.AND.IP <= NCOMPO .AND.  &
            JP.GE.1.AND.JP <= NCOMPO )  THEN
          IF (KP == 0)  THEN
            IF (JP > IP)  THEN
              IJ = IP
              IP = JP
              JP = IJ
            END IF
            DM1IJ(IP,JP) = D1*CAL
            BE1IJ(IP,JP) = BE1*10.0D0
            DM2IJ(IP,JP) = D2*CAL
            BE2IJ(IP,JP) = BE2*10.0D0
            RSWTCH(IP,JP) = RSIJP*0.10D0
            if (ggg > 0.0)  then
              read (15,'(10x, 3f10.0)') dm3ij(IP,JP),be3ij(IP,JP),r03ij(IP,JP)
            end if
            dm3ij(IP,JP) = dm3ij(IP,JP)*CAL
            be3ij(IP,JP) = be3ij(IP,JP)*1.0D2
            r03ij(IP,JP) = r03ij(IP,JP)*0.10D0
!
            write(35,'(I2,A1,I2)') IP,'-',JP
            write(35,'(A12,1x,A10,1x,A12,1x,A10,1x,A10,1x,A12,1x,A10,1x,A10)') & 
              'D1ij(kJ/mol)','b1ij(nm-1)', &
              'D2ij(kJ/mol)','b2ij(nm-1)','Rsij(nm)', &
              'D3ij(kJ/mol)','b3ij(nm-2)','r3ij(nm)'
            write(35,'(F10.2,3x,F10.2,1x,F10.2,3x,F10.2,1x,F10.4,1x,F10.2,3x,F10.2,1x,F10.4)') &
              dm1ij(IP,JP),be1ij(IP,JP),dm2ij(IP,JP), &
              be2ij(IP,JP),rswtch(IP,JP),dm3ij(IP,JP), &
              be3ij(IP,JP),r03ij(IP,JP)
          ELSE IF (IP == KP) THEN     !------------------ j-i-j
!           -------------------------------------- F:kJ/mol
            FK3BP(IP,JP)  = D1*1.0D-18
            ANG3BP(IP,JP) = BE1
            R3BLIM(IP,JP) = D2*0.1D0
            R3BGRD(IP,JP) = BE2*10.0D0
            IF (ANG3BP(IP,JP) <= 0.01)   ANG3BP(IP,JP)=90.0
            IF (R3BLIM(IP,JP) <= 0.01) R3BLIM(IP,JP)= 1.2*0.1D0
            IF (R3BGRD(IP,JP) <= 0.01) R3BGRD(IP,JP)=20.0*10.0D0
            write(35,'(I2,A1,I2,A1,I2)') IP,'-',JP,'-',KP
            write(35,'(A10,1x,A11,1x,A10,1x,A10)') & 
              'f(kJ)','theta(deg.)','rm(nm)','gr(nm-1)'
            write(35,'(E10.3,1x,F10.3,2x,F10.4,1x,F10.2)') & 
              FK3BP(IP,JP),ANG3BP(IP,JP),R3BLIM(IP,JP),R3BGRD(IP,JP)
          ELSE
            STOP 'Something wrong in potetial param.'
          END IF
          GO TO 121
        END IF
      endif
    close(15)
    close(35)
  stop
end
