subroutine timer( ct, et, indx )
  implicit none
  real(8),intent(inout) :: ct,et
  character(*),intent(in) :: indx
  real(8) :: ct_now, et_now
  integer :: ierr, myrank
  include 'mpif.h'
  call MPI_Comm_rank( MPI_COMM_WORLD, myrank, ierr )
  call cpu_time( ct_now )
  et_now = MPI_Wtime()
  if ( indx /= "" .and. myrank == 0 ) then
     write(*,'(1x,"ctime,etime=",2g15.5,3x,a)') ct_now-ct, et_now-et,indx
  end if
  ct = ct_now
  et = et_now
end subroutine timer

subroutine write_border( indx )
  implicit none
  character(*),intent(IN) :: indx
  character(80) :: fmt
  write(fmt,'(i2)') 80-len(indx)
  fmt=adjustl(fmt)
  fmt="(a"//fmt(1:len_trim(fmt))//",a)"
  write(*,fmt) repeat("-",80),indx
end subroutine write_border

subroutine stop_program
  implicit none
  integer :: ierr
  call MPI_Finalize( ierr )
  stop "stop_program"
end subroutine stop_program

subroutine parallel_data_utility( local_data_size, local_data_offset, ctrl )
  implicit none
  integer,intent(inout) :: local_data_size, local_data_offset
  character(*),intent(in) :: ctrl
  integer,save :: size=0, offset=0
  select case( ctrl )
  case( "push", "PUSH" )
     size = local_data_size
     offset = local_data_offset
  case( "get", "GET", "pop", "POP" )
     local_data_size = size
     local_data_offset = offset
  end select
end subroutine parallel_data_utility
