!PROGRAM  MXDTRICLP
!===========================================================
!##                                                       ##
!##              Program  :  MXDTRICLP                    ##
!##                                                       ##
!##      by  Hiroshi Sakuma (NIMS)                        ##
!##                                                       ##
!##      MXDTRICL: Katsuyuki Kawamura                     ##
!##                   (Tokyo Institute of Technology)     ##
!##                                                       ##
!##    Configuration and Energy for Non-Cubic Systems     ##
!##               (Oblique parallelepiped)                ##
!##    with Pressure Control by stress tensor,            ##
!##    and Quantum Correction for energy and pressure     ##
!##                                                       ##
!##      2nd order interpolation from U and F tables      ##
!##                                                       ##
!##   First cubic version on Hitac 8800/8700    80        ##
!##   First orthogonal (crystal) version        83-10     ##
!##        on CDC7600 at Manchester Univ.                 ##
!##   HITAC M-280/IAP version                   85-09-12  ##
!##   (Px, Py, Pz) pressure control version     87-02-07  ##
!##   Pressure tensor and                                 ##
!##        fractional coordinates               87-10-29  ##
!##   Five element  and                                   ##
!##        input data format and history        87-11-05  ##
!##   PC9800RA+NDP-FORTRAN-386  version         89-01-26  ##
!##   Reviced for JCPE                          90-04-14  ##
!##   (XDORTO : DEFECT)                         90-04-21  ##
!##   3-body interaction (H2O, Kumagai & Kats)  91-02-02  ##
!##   Integrated version of MD and XD (MXD)     91-05-22  ##
!##   Rearranged                                91-10-23  ##
!##   Seven comonents, rearranged               92-01-23  ##
!##   Quatum corrections     (Nakao & Kats)     92-03-04  ##
!##   Ten comonents, rearranged                 92-03-31  ##
!##   Extended Andersen's pressure control      92-04-07  ##
!##                        (Katsuta & Kats)               ##
!##   Metal (main group) potential              92-04-18  ##
!##   Revised for JCPE version                  92-08-01  ##
!##   2nd order interpolation from tables       92-09-05  ##
!##   2nd order interpolation of velocity       92-12-12  ##
!##   Nose's thermostat                         92-12-14  ##
!##   Correction for trancation of VW-term      93-12-10  ##
!##   Reviced 3-body term by Kuma               94-01-30  ##
!##   L-J potential                             94-06-28  ##
!##   Nose's thermostat + quantum               94-09-01  ##
!##   Charge - Dipole Interaction               94-09-10  ##
!##   Improvement of Semi-classical MD          95-06-15  ##
!##   FILE09.DAT format changed                 96-07-18  ##
!##   Model by Belonoshko & Dubrovinsky         96-09-05  ##
!##   Shear                                     97-02-18  ##
!##   Electric (N.SAWAGUCHI) & Gravity Field    97-06-30  ##
!##   Apply constant strain rate                97-06-30  ##
!##   Diatomic 3 chrge model                    97-10-10  ##
!##   3-body j-i-k with j<>k                    99-11-16  ##
!##   3-body   sqrt(k1xk2) -> k1xk2             00-05-01  ##
!##   POSISION-VELOCITY-ENERGY option           00-12-16  ##
!##   Modify EWALD direct term                  01-03-24  ##
!##   3-body j-i-k : modified                   01-09-11  ##
!##   File07.dat : format                       01-12-02  ## 
!##   Polyatomic molecule                       02-02-23  ##
!##   5 digit of file09p and file09pv           11-06-09  ##
!##   Separate File081.dat from file08.dat      11-06-09  ##
!##   Format change of file09v                  11-06-09  ##
!##   Remove iform7                             11-06-10  ##
!##   T SCALE-A                                 14-09-11  ##
!##  Number of component to 10                  15-06-15  ##
!##  First version of mxdtricl_p                15-06-18  ##
!##  Number of component to 20 for BMHEXP       17-01-11  ##
!##  Bug fixed for format of file07 comp20      17-01-16  ##
!##  Improved BMHEXP for file05 format          17-04-20  ##
!##  Bug fixed for MOLECULE option              19-02-06  ##
!##  Thermodynamic Integration for H2O          19-05-10  ##
!##  Bug fixed and redefined CONSTSHEAR         20-02-05  ##
!##  file09v.dat format 1991                    20-04-21  ##
!##  Bug fixed for average in file06.dat        21-01-15  ##
!##  Vashishta potential                        23-11-08  ##
!##  Bug fixed for CSHEAR dvz/dry               23-11-10  ##
!##  Bug fixed for Three-body potential pxz,pxy 23-12-01  ##
!##  Bug fixed NRECRD(9)                        25-10-27  ##
!======================================================================I
!              Format  and  parameters  of  'FILE05.DAT'  file         :
!----------------------------------------------------------------------I
! 1  MD.......I....:....I....:....I....:....I....:....I....:....I....:.:
!    XD.......I...                                                     :
! 2  START    :TITLE(60 CHARACTERS)                                    :
!    CONTINUE :                                  (CONT.)               :
!    RESTART  :                                                        :
!    STOP     :                                                        :
! 3  ECONOMY  :IRECRD(1):IRECRD(2):IRECRD(3):IRECRD(4):IRECRD(5):      :
!    NORMAL   :         :         :   (50)  : (M50,X5):   (5)   :      :
!    DETAIL   :         :         :         :         :         :      :
! 4  NOACCUM  :DTIME    :FORMULA  :(RCUTL)  :(RCUTS)  :         :      :
!    ACCUM    :         :         :         :         :         :      :
! 5  T NO-CNTL:         :         :         :         :         :      :
!    T [BLANK]:         :         :         [No control on temperature]:
!    T SCALING:TMPGET   :DELTMP   :NTSTEP   :(TDUMP)  :         :      :
!    T SCALE-A: TMPGET  : DELTMP  : NTSTEP  :(TDUMP)  :         :      :
!    T NOSE   :TMPGET   :DELTMP   :STEMP    :         :         :      :
! 6  P NO-CNTL:         :         :         :         :         :      :
!    P [BLANK]:         :         :         :  [No control on pressure]:
!    P SCALING: SPRES(1):SPRES(2) :SPRES(3) :         :         :      :
!    P ANDERSEN SPRES(1):SPRES(2) :SPRES(3) :VIRM(1)  :VIRM(2)  :VIRM(3:
!    P SHEAR  : SPRES(1):SPRES(2) :SPRES(3) :VIRM(1)  :VIRM(2)  :VIRM(3:
!             : SPRES(4):SPRES(5) :SPRES(6) :VIRM(4)  :VIRM(5)  :VIRM(6:
! 7  V [BLANK]:         :         :  [Volume is changed with P-control]:
!    V CONST. :         :         :         : [Volume is kept constant]:
!    V CELL   :BOX(1)   :BOX(2)   :BOX(3)   :BOX(4)   :BOX(5)   :BOX(6):
!    V DENSITY:DENSTY   :         :         :         :         :      :
!    D CONST. :DENSTY   :         :         :         :         :      :
! 8  BUSING   :MODE,MXN2:(ALPHA)  :         :         :         :      :
!    MORSE    :         :         :(Busing+Morse)     :         :      :
!    MORSE-PL :         :         :(charge-dipole)    :         :      :
!    MORSE-AT :         :         :         :         :         :      :
!    BMH-EXP  :         :   3-body    sqrt(k1xk2)     :         :      :
!    BMH-EXP* :         :   3-body    k1xk2           :         :      :
!    BELONO   :         :         :(Belonoshko & Dubrovinsky)   :      :
!    TOSIFUMI :         :         :         :         :         :      :
!    WOODCOCK :         :         :         :         :         :      :
!    PAULING  :         :         :(Woodcock+Pauling f.)        :      :
!    METAL    :         :         :         :         :         :      :
!    STSUNE   :         :         :(Tsuneyuki et al.) :         :      :
!    L-J      :         :         :         :         :         :      :
!    VASHISHTA:         :         :         :         :         :      :
! 81 N A  NO. :ZI       :WI       :AI       :BI       :CI(VW)   :DI()  :
!     -       :         :         :         :         :   not moved    :
!     *       :         :         :         :         :   dummy atoms  :
!     =       :         :         :         :         :   Morse only   :
! 81e[BLANK]  :         :         :         :         :         :      :
! 82  I J     :DMIJ     :BEIJ     :RSIJ     :         :      [Morse]   :
!     J I J   :FK3BP    :ANG3BP   :R3BLIM   :R3BGD    :      [3-body]  :
!     J I K   :FK3BP(1) :ANG3BP(1):R3BLIM(1):R3BGD(1) :  [3-body(J<>K)]:
!             :         :         :R3BLIM(2):R3BGD(2) :        :       :
! 82e[BLANK]  :         :         :         :         :         :      :
!             :         :         :         :         :         :      :
! 91 STRUCTURE:         :         :       9 [Detail of final structure]:
! 92 NETWORK  :NFCION(1):NFCION(2):      10 [Network structure analys.]:
! 93 VELOCITY :NS09PV   :PVMULT   :      11 :[Record particle velocity]:
!    POSITION :NS09PV   :PVMULT   :      11 :        [... ... position]:
!    ENERGY   :NS09PV   :PVMULT   :      11 :        [....... energy  ]:
!    POSVELENE:NS09PV   :         :      11 :     [..... pos,velo,ener] :
! 94 QUANTUM  :         :         :      12 :      [Quantum correction]:
! 95 PCF, RDF : ISTEP   : Rend(A) :      13 :    [Table of PCF and RCN]:
!*96 DIPOLE   :         :         :      14 :        [E(dipole moment)]:
! 97 CENTER   :         :         :      15 :[Centring of atom cluster]:
! 98 NO(MV=0) :         :         :      16 [No correction for morment]:
! 99 CRYSTAL  :         :         :      17   [MD of crystal structure]:
! 9A BINARY   :         :         :      18  [Binary data for file09x.]:
! 9B PRESSURE : NPRESS  :         :      19 [Pressure tensor on file11]:
! 9C ELEC.FIELD   EFD1  :   EFD2  :   EFD3  : EFFEQ 20:[Electric field]:
! 9D GRAV.FIELD   GFD1  :   GFD2  :   GFD3  :       21: [Gravity field]:
! 9E CONSTSHEAR  VZ-RX  :  VZ-RY  :         :(ps)-1 22:[Const.shear rat]
! 9F DIATOMIC :  DINTRA :iatom2(1):iatom2(2):       23:[Diatomic molec]:
! 9I MOLECULE :  Dintra : Mstart  :  Mend   :       26:[Define molecule]
! 9L POLYATOM :  Dintra :MOLstart : MOLend  :   29:[Polyatomic molecule]:
! 9T THERM-INT:  lambd  : kval    : IATOMO  : IATOMH  : Dintra  :
! : kwkt
!                                           [Thermodynamic integration]
! 9n ........ :         :         :         :         :         :      :
! 9e [BLANK]  :         :         :         :         :         :      :
!             :         :         :         :         :         :      :
!    MD.......I....:....I....:....I....:....I....:....I....:....I....:.:
!    REPEAT  1 TO 9                                                    :
!======================================================================I
!      IRECRD                           NRECRD                         :
!      -----------------------------    -----------------------------  :
! 1    Total number of steps            Current step No. from 'START'  :
! 2    Interval of print PCF etc.       Accumulation No. of PCF etc.   :
!                                              (I2=N2 when 'ACCUM')    :
! 3    Interval of FILE07 recording     Current step number            :
!           (default: 50)                          in the current job  :
! 4    Interval of FILE09P recording    Number of records in FILE09P   :
!           (default: 50:MD. 5:XD)                                     :
! 5    Interval of FILE09V recording    Number of records in FILE09V   :
!           (default: 5)                                               :
! 6    Number of steps of current HIST  Number OF HISTRY informations  :
! 7-8  Not used                         Not used                       :
! 9    Interval of FILE09PV recording   Number of steps in FILE09PV    :
!======================================================================I
!    I/O number        FLNAME         Filename                         :
!        5                -           input from keyboad               :
!       15              ( 5)          FILE05.DAT        in             :
!        6, *             -           screen output     out            :
!       16              ( 6)          FILE06.DAT        out            :
!       17              ( 7)          FILE07.DAT        in/out         :
!       18              ( 8)          FILE08.DAT        in/out         :
!       19              ( 9)          FILE09P.DAT       in/out         :
!       10              (10)          FILE10.DAT        in             :
!       29              (11)          FILE09V.DAT       in/out         :
!       28              (12)          FILE09PV.DAT      out            :
!       27              (13)          FILE11.DAT        out            :
!       22              (19)          TEMPO.DAT         in/out(work)   :
!======================================================================I
!  Variables in PARAMERER statement                                    :
!   LNI : Maximum number of particles (ion or atom) in a basic cell    :
!   LTB : Maximum table length of Coulomb energy and force             :
!   LSR : Table length of short range interactions                     :
!   LEL : Maximum number of particle species                           :
!   LEE : Number of pairs of particle species                          :
!   LCT : Maximum number of steps                                      :
!   LNV : Maxinum number of reciprocal lattice points in EWALD sum.    :
!   LAA : Maximum number of atoms in a asymmetric unit (XD)            :
!   LAT : Maximum number of atoms in a crystal unit cell (XD)          :
!======================================================================I
!  P(3,LNI) : Fractional coordinates of atoms, 0=<p<1                  :
!  V(3,LNI) : Displacements (in A) of atoms for priod of dtime(delta-t):
!  VP(3,LNI): Displacements (in A) of atoms at one step before         :
!======================================================================I
!  RUNOPT(1) = 'MD........'  'XD........'  'MDX.......'                :
!        (2) = '          '  'START     '  'CONT.     '  'STOP      '  :
!              'END       '  'RESTART   '  'CONTINUE  '                :
!        (3) = 'DETAIL    '  'NORMAL    '  'ECONOMY   '                :
!        (4) = 'ACCUM     '  'NOACCUM   '                              :
!        (5) = 'T NO-CNTL '  'T SCALING '  'T NOSE    '  'T SCALE-A '  :
!        (6) = 'P NO-CNTL '  'P SCALING '  'P ANDERSEN'                :
!        (7) = 'V CONST.  '  'V FREE    '  'D CONST.  '  'V CELL    '  :
!              'V DENSITY '                                            :
!        (8) = '          '  'BUSING    '  'MORSE     '  'MORSE-AT  '  :
!              'TOSIFUMI  '  'WOODCOCK  '  'PAULING   '  'STSUNE    '  :
!              'L-J       '  'METAL     '  'PAIR-P    '                :
!              'BMH-EXP   '  'BMH-EXP*  '  'VASHISHTA '                :
!        (9) = 'STRUCTURE '  '          '                              :
!       (10) = 'NETWORK   '  '          '                              :
!       (11) = 'VELOCITY  '  'POSITION  '  'ENERGY    '  'POSVELENE '  :
!       (12) = 'QUANTUM   '  '          '                              :
!       (13) = 'PCF       '  'RDF       '  '          '                :
!       (14) = 'DIPOLE    '  '          '                              :
!       (15) = 'CENTER    '  'CENTRE    '  '          '                :
!       (16) = 'NO(MV)=0  '  '          '                              :
!       (17) = 'CRYSTAL   '  'AMORPHOUS '                              :
!       (18) = 'BINARY    '  '          '                              :
!       (19) = 'PRESSURE  '                                            :
!       (20) = 'ELEC.FIELD'                                            :
!       (21) = 'GRAVITY   '                                            :
!       (22) = 'CONSTSHEAR'                                            :
!       (23) = 'DIATOMIC  '                                            :
!       (26) = 'MOLECULE  '                                            :
!           ...                                                        :
!       (30) = 'STOPT     '  'POTSURF   '                              :        
!       (37) = 'THERM-INT '                                            :kwkt
!       (51) = 'THERMOSTAT'  '          '                              :
!       (52) = 'H-TENSOR  '  '          '                              :
!======================================================================I
!               Contents of VAL(1) - VAL(LVA=54) variables             :
!  No.   : Meanings                                                    :
!  1     : Temperature                                             / K :
!  2     : Pressure                                              / GPa :
!  3-8   : Components of pressure tensor(xx,yy,zz,xy,xz,yz)      / GPa :
!  9     : Coulomb energy                                   / kJ.mol-1 :
!  10    : Short range energy                               / kJ.mol-1 :
!        :             (repulsion,van der Waals,Morse,etc.)            :
!  11    : Three body potential energy                      / kJ.mol-1 :
!  12    : Total potential energy (9+10+11)                 / kJ.mol-1 :
!  13    : Kinetic energy                                   / kJ.mol-1 :
!  14    : Total internal energy (9+10+11+13)               / kJ.mol-1 :
!  15    : PV (pressure x volume)                           / kJ.mol-1 :
!  16    : Enthalpy (14+15)                                 / kJ.mol-1 :
!  17    : Density                                            / g.cm-3 :
!  18    : Molar volume                                    / cm3.mol-1 :
!  19-21 : Basic cell parameters: A, B, C                           /A :
!        :               (Crystal unit cell (a,b,c) in XD)             :
!  22-24 : Cell angles  cos(alpha), cos(beta), cos(gamma)              :
!  25-44 : Temperatures of ion species (20 components)             / K :
!  45-54 : Mean square displacement (20 components)              / A^2 :
!======================================================================I
!
module param
  implicit none
    integer(KIND=4),parameter:: LNI=32109, LTB=10004, LEL=20, LEM=20
    integer(KIND=4),parameter:: LCT=10000000, LSR=1254, LEE=LEL*(LEL+1)/2
    integer(KIND=4),parameter:: L50=LCT/50+1,LAA=172, LNV=9876, LST=32
    integer(KIND=4),parameter:: LEF=LEM*(LEM+1)/2, LAT=LAA*4, LVA=24+LEM*2
    integer(KIND=4),parameter:: L3P=20, LRG=LNI*5, L3R=300
!
    double precision,parameter:: PI  = 3.14159265357D0
    double precision,parameter:: PI180 = 180.0D0/PI
    double precision,parameter:: ANA = 6.0221367D23    !Avogadro const. / mol-1
!    double precision,parameter:: AKB = 1.380658D-23    !Boltzmann const. /J K-1
    double precision,parameter:: AKB = 1.380658D-16    !Boltzmann const. /erg K-1
    double precision,parameter:: AHP = 6.6260755D-27   !Plank const. /erg s
    double precision,parameter:: EP0 = 8.854187817D-12 !Permittivity of vacuum /F m-1
    double precision,parameter:: CVL = 2.99792458D10   !velocity of light in vacuum /cm s-1
    double precision, parameter:: ELCC = 1.602176462D-19 ! elementary charge C
    double precision,parameter:: ELC = ELCC*CVL*0.1D0 !elementary charge /C esu 
!                                                        CVL usually 3D8 then ELC = e*CVL*10.0D0
    double precision,parameter:: CAL = 4.18605D0       !Converstion from calory to joule
    double precision,parameter:: PI2 = 2.0D0*PI
    character *1, parameter:: ins(1:20) = (/'1','2','3','4','5','6','7','8','9',&
                                            'A','B','C','D','E','F','G','H','I','J','K'/)

end module
module charac
  use param
  implicit none
    character(len=4):: TITLE(15),ATMNET(2),ATMXTL(LAA)
    character(len=2):: ATOM(LEM)
    character(len=10):: RUNOPT(53)
    character(len=16):: FLNAME(19)
    character(LEN=4):: ATOM07(LEM)
end module
module timdat
  implicit none
    integer(KIND=4) KKTIME(7,2)
end module
module atomsi
  use param
  implicit none
    double precision VP(3,LNI)
!    double precision, allocatable :: P(:,:),V(:,:),P0(:,:)
    double precision P(3,LNI),V(3,LNI),P0(3,LNI)
    double precision UI(LNI),AU(LNI),AV3BP(2,L3P),UIC(LNI),PP0(3,LNI) ! Nose-Hoover
    double precision :: UICP1(LNI) = 0.0D0, UICP2(LNI) = 0.0D0, UICP3(LNI) =0.0D0, UICP4(LNI) = 0.0D0
    integer(KIND=4) NTION,NION(LEM),IONS(2,LEM),NCOMPO,Iam,ICD,Namv
    integer(KIND=4) NTIOND, NIOND(LEM),NPAIR,IION(LEM)
!    integer(KIND=4), allocatable :: IOND(:)
    integer(KIND=4) IOND(LNI)
end module
module temprs
  implicit none
    double precision DTIME,TEMP,DELTMP,TMPGET,TINT,TPRE
    double precision     STEMP,VSTEMP
!    double precision STEMP(4),VSTEMP(4)  !Nose-Hoover
!    double precision STEMP2,STEMP3,STEMP4,KBT  !Nose-Hoover
    double precision TDUMP,SPRES(6),PPXYZ(7),FJMOL,PXYZ(7),DTMO,PDUMP
    double precision PREST(3,3)
    integer(KIND=4) NTSTEP
!    integer(KIND=4) nfnose !Nose-Hoover
end module
module aboxof
  implicit none
    double precision BOX(6),VBOX(6),VOL,DENSTY,VIRM(6),RCUT(2)
    integer(KIND=4) NRCUT(2),MXCUT,NFORML,IAXCEN
end module
module values
  use param
  implicit none
    double precision TVAL(LVA),SVAL(LVA),TVALL(LVA),SVALL(LVA),VALMAX(LVA)
    double precision VALMIN(LVA),VAL0(LVA),VAL(LVA),AVA(LVA,L50)
    integer(KIND=4) NAV,NAVT
end module
module paramt
  use param
  implicit none
    double precision AIO(LEM),BIO(LEM),CIO(LEM),DIO(LEM),ZIO(LEM)
    double precision AIJ(LEF),BIJ(LEF),CIJ(LEF),DIJ(LEF),D4IJ(LEF)
    double precision PLIJ(LEF),RSWTCH(LEF),ZIJ(LEF),D7IJ(LEF)
    double precision ECORR,VCORR,WIO(LEM),TWEGHT,AKFI(LEM)
    double precision ANG3BP(L3P),R3BLIM(2,L3P)
    double precision FK3BP(L3P),R3BGRD(2,L3P),R3lim(2,l3p),r3limax
    integer(KIND=4) I3BP(3,L3P),N3BP
end module
module geomet
  use param
  implicit none
    double precision DTO(2),AVTHT(12),RTO(2),SVTHT(12),ANGL(3,12),TTAB(LST)
    integer(KIND=4) MBR(8,8,2),NRG(9,2),ITBR(121,12),NBR(8,8,2),MEB(9,2)
    integer(KIND=4) NTT(121,12),NTO(2),NVTHT(12),NTBL
end module
module tables
  use param
  implicit none
    double precision F1(LSR,LEE),E1(LSR,LEE),F0(LTB),E0(LTB)
end module
module counts
  implicit none
    integer(KIND=4) NJOB(2),IRECRD(9),NRECRD(9),IHISTR(4,111)
    double precision PVMULT
    integer(KIND=4)  nallo
end module
module vector
  use param
  implicit none
    double precision FNV(LNV),UNV(LNV),PNV(3,3,LNV),VEC(3,LNV),ZIA(LEM),UCSELF,ZIIA(LNI)
    double precision ALPHA,UCSLFI(15),ZIIC(LNI)
    integer(KIND=4) MODE,NVN,NVEC(3,LNV)
end module
module acoord
  use param
  implicit none
    double precision BOXO(6),P0C(3,LAT),PPC(3,LAT),RS(3,3,96),PPS(3,LAT)
    integer(KIND=4) NPT,NIU(LAA),NSYM,ISYM(LNI),NPTP,NBOX(3),JON(LAT)
    integer(KIND=4) MATM,IHEX
end module
module radial
  use param
  implicit none
    integer(KIND=4) NRDF(LTB,LEE),IPRDF(2)
end module
MODULE FORCES
  use param
  IMPLICIT NONE
!  double precision, allocatable::  FX(:),FY(:),FZ(:)
  double precision  FX(LNI),FY(LNI),FZ(LNI)
END MODULE
module cartes
  use param
  implicit none
    double precision H(3,3),HINV(3,3),FTOQ(3,3),RBOX(6),G(3,3),GINV(3,3)
    double precision TRANSX(8),TRANSY(8),TRANSZ(8)
!    double precision,allocatable:: Q(:,:),Q0(:,:)
    double precision Q(3,LNI),Q0(3,LNI)
end module
module molecu
  use param
  implicit none
    double precision ZMOLE(2),DMOLE(4,LNI),DINTRA
    integer(KIND=4) :: NDMOLE = 0,IDMOLE(3,LNI),IATOM2(2),MOLstart(2)
    integer(KIND=4) NMOLE,IMOLE(11,LNI),MOLend(2)
!    integer(KIND=4), allocatable :: MMOLE(:)
    integer(KIND=4) MMOLE(LNI)
    integer(KIND=4) IATOMO,IATOMH,ITER,ITERSH,NIONO
    integer(KIND=4):: istart = 0
    double precision, allocatable, save ::  HHX(:),HHY(:),HHZ(:),HHV(:)
    double precision, allocatable, save ::  OPX(:),OPY(:),OPZ(:),OPV(:)
    double precision, allocatable, save ::  LOP1X(:),LOP1Y(:),LOP1Z(:)
    double precision, allocatable, save ::  roh1(:),roh2(:),A1(:),A2(:)
    double precision, allocatable, save ::  DPV(:),DPX(:),DPY(:),DPZ(:)
    double precision, allocatable, save ::  DPX1(:),DPX2(:),DPY1(:),DPY2(:),DPZ1(:),DPZ2(:)
    double precision, allocatable, save ::  UDPX1(:),UDPX2(:),UDPY1(:),UDPY2(:),UDPZ1(:),UDPZ2(:)
    double precision, allocatable, save ::  QLP1(:),QLP2(:),QLP1z(:),QLP2z(:),QLPx(:)
    double precision, allocatable, save ::  QHHk(:),QHHm(:)
    double precision, allocatable, save ::  E34(:),idipX(:,:),idipY(:,:),idipZ(:,:)
    double precision, allocatable, save ::  pdipX(:),pdipY(:),pdipZ(:),Edp1(:),Edp2(:)
    double precision, allocatable, save ::  idp2(:),watpol(:,:)
    integer(KIND=4), allocatable, save ::ih2o(:,:)
    integer(KIND=4), allocatable, save ::intr(:)   !kwkt
    double precision, save ::  upol,THRESHD,maxedip,sumedip,dampp
    double precision,parameter:: DIP = 4.803204D0      !used for dipole moment
    double precision, parameter:: DEBYE = 1.0D-19/CVL ! 1*DEBYE Cm = 1 D = 1e-18 esu cm
    double precision,parameter:: POL = 4.0D0*PI*EP0*1.D-17/ELCC**2       !used for polarizability
    double precision,parameter:: EPOL  = 4.0D0*PI*EP0*1.0D-27/ELCC  ! used for UPOL
    double precision,parameter:: EPOLL = 4.0D0*PI*EP0*1.0D-30
!    double precision,parameter:: WATPOLHH = 1.47D0, WATPOLLP = 1.47D0, WATPOLDP = 1.47D0   ![Angstrom^3]
    double precision, parameter:: WATPOLLP =1.44D0, WATPOLDP = 1.90D0
    double precision, parameter:: EPOLLL = ELCC**2/(4.0D0*PI*EP0*1.0D-25) !for dyn
    double precision RD,DLP
    double precision,parameter ::GEb = 3.13885D-10, Emb=7.57695D9 !C/N and N/C
    double precision,parameter ::GEb_pol = GEb/(ELCC*1.0D-3), Emb_pol = Emb*ELCC*1.0D-3
    double precision,parameter ::Ediv = 1.00D10*ELCC*1.0D-3, DMAX = 2.8D0-1.87D0
    double precision,parameter ::ECOFF = DEBYE/EPOL
end module
!module charge  ! WATER-POL
!  use param
!  implicit none
!  double precision ZII(LNI),ZICOS(LNI),ZISIN(LNI)
!  double precision ZIIP(LNI)
!end module
module pmorse
  use param
  implicit none
    double precision DMIJ(LEF),BEIJ(LEF),RSIJ(LEF),DM1IJ(LEF),BE1IJ(LEF)
    double precision DM2IJ(LEF),BE2IJ(LEF)
    double precision CIJK(LEF) !Vashishta
end module
module quanco
  use param
  implicit none
  double precision Q1U1(LSR,LEE),Q2U1(LSR,LEE)
  double precision TQCE, QCEE,QCIT,QCEF,TEMPQH,TEMPQQ
end module
module ewal
  use param
  implicit none
  double precision PRSTC2(6),VIRLSR
  double precision :: VIRLSRP= 0.0D0
  integer(KIND=4) iaxis,JJJ,KRDF
end module
module outerf
  implicit none
  double precision EFD(3),EFREQ,GFD(3),fconvc,STRT(3)
  double precision:: SHRZX=0.0d0,SHRZY=0.0d0  !CONSTSHEAR
  double precision:: dispzx=0.0d0,dispzy=0.0d0 !CONSTSHEAR
  integer(KIND=4) MEFD,NATOM
end module
module datoms
  use param
  implicit none
  double precision D1ATOM,D1AXYZ(3),D2ATOM,D2AXYZ(3)
  double precision ddatom(100,lni)
  integer(KIND=4) idatom(101,lni)
  integer(KIND=4) idatom101(lni)
end module
!MODULE DATOMS
!  implicit none
!  double precision D1ATOM(500),D1AXYZ(3,500),D2ATOM(500),D2AXYZ(3,500)
!  integer(KIND=4) N1ATOM,I1ATOM(500), N2ATOM,I2ATOM(500)
!END MODULE
module struct
  use param
  implicit none
  integer(KIND=4) lentab
end module
MODULE ANIPAR
  double precision  FCUT,FFAC
  integer(KIND=4) icons,idirec
END MODULE
MODULE PSURF
  IMPLICIT NONE
  double precision     DISTM
  integer(KIND=4)  iato1, iato2, iarea
END MODULE
MODULE WORK01
  use param
  IMPLICIT NONE
!  double precision,allocatable:: PX(:),PY(:),PZ(:),V10(:,:)
  double precision PX(LNI),PY(LNI),PZ(LNI),V10(3,LNI)
!  double precision,allocatable:: DDDD(:,:),VV(:,:),PPK(:,:)
  double precision DDDD(6,LNI),VV(3,LNI),PPK(3,LNI)
!  double precision,allocatable:: PCC(:,:),PSS(:,:),DONB(:,:)
  double precision PCC(3,LNI),PSS(3,LNI),DONB(6,LNI)
!  double precision,allocatable:: DUM(:,:)
  double precision DUM(3,LNI)
END MODULE
MODULE WORK02
  use param
  IMPLICIT NONE
!  integer(KIND=4), allocatable::IIII(:,:),IP(:,:),IPV(:,:)
!  integer(KIND=4), allocatable::IDUMMY(:,:),IONB(:,:)
!  integer(KIND=4), allocatable::JPS(:,:)
!  double precision, allocatable::ZII(:),P00(:,:),XYZ0(:,:),PP(:,:)
!  double precision, allocatable::UUII(:),ZIIP(:)
!  double precision, allocatable::ZICOS(:),ZISIN(:)
  integer(KIND=4) IIII(6,LNI),IP(3,LNI),IPV(3,LNI)
  integer(KIND=4) IDUMMY(3,LNI),IONB(6,LNI)
  integer(KIND=4) JPS(3,LNI)
  double precision ZII(LNI),P00(3,LNI),XYZ0(3,LNI),PP(3,LNI)
  double precision UUII(LNI),ZIIP(LNI)
  double precision ZICOS(LNI),ZISIN(LNI)
END MODULE
!     FUNCTION STD(X,Y,I)
!     implicit none
!     double precision  STD
!     double precision  X,Y
!     integer(KIND=4)  I
!     STD = SQRT( ABS(X - Y**2/DBLE(I)) / DBLE(I)) 
!     END
module thrmint !kwkt
  implicit none
  integer *4 kval
  real *8 lambd, flambd, dflambd, ULAM, flam, ULAMT, EIJTHS,EIJKTI
end module
!
PROGRAM MXDTRICLP
      USE CHARAC
      USE TIMDAT
!      IMPLICIT NONE
!
!
      integer(KIND=4) iii(3)
      integer(KIND=4) I,ierr,myrank,mpsize
      integer(KIND=4) IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
      include 'mpif.h'
!
!                   FLNAME(1)  = 'MXD-ORTHO      '
                    FLNAME(1)  = 'MXD-TRICL-P    '
                    FLNAME(2)  = '2025-11-19-00  '
!                   ----------------------------------------- Select one
!                    FLNAME(3)  = 'Lehey LF90     '
!                   FLNAME(3)  = 'Ms-Fortran     '
!                   FLNAME(3)  = 'NDP-FORTRAN386 '
!                    FLNAME(3)  = 'DEC Fortran    '
!                   FLNAME(3)  = 'LUNA88K        '
!                   FLNAME(3)  = 'PARALLEL-F77   '
!                   FLNAME(3)  = 'HP-9000        '
!                   FLNAME(3)  = 'DN10000        '
!                   FLNAME(3)  = 'S820-80        '
!                   FLNAME(3)  = 'NEWS-F77       '
!                   FLNAME(3)  = 'CRAY-F77       '
!                   FLNAME(3)  = 'IBM-AIX-FORT   '
!                   FLNAME(3)  = 'LINUX-g77      '
                    FLNAME(3)  = 'F90            '
!                   FLNAME(3)  = 'Dummy          '
!                   ----------------------------------------------------
                    FLNAME(4)  = '               '
                    FLNAME(5)  = 'file05.dat     '
                    FLNAME(6)  = 'file06.dat     '
                    FLNAME(7)  = 'file07.dat     '
                    FLNAME(8)  = 'file08.dat     '
                    FLNAME(18) = 'file081.dat    '
                    FLNAME(9)  = 'file09p.dat    '
                    FLNAME(10) = 'file10.dat     '
                    FLNAME(11) = 'file09v.dat    '
                    FLNAME(12) = 'file09pv.dat   '
                    FLNAME(13) = 'file11.dat     '
                    FLNAME(14) = '               '
                    FLNAME(15) = '               '
                    FLNAME(17) = 'potensurf.dat  '
                    FLNAME(19) = 'tempo.dat      '
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
                     KKTIME(1,1) = IYEAR
                     KKTIME(2,1) = IMONTH
                     KKTIME(3,1) = IDAY
                     KKTIME(4,1) = IHOUR
                     KKTIME(5,1) = IMINUT
                     KKTIME(6,1) = ISECND
                     KKTIME(7,1) = I100TH
                     DO I = 1, 7
                        KKTIME(I,2) = KKTIME(I,1)
                     ENDDO
!
!
!
!     ---------------------------------------------------------- MPI
      call MPI_init (ierr)
      call MPI_Comm_Rank  (MPI_COMM_WORLD, myrank, ierr)
      call MPI_Comm_Size  (MPI_COMM_WORLD, mpsize, ierr)
!             ------------------------------------------ MPI slave process
      if (myrank /= 0) call EWALDP2 (myrank, mpsize)
      write(*,*) 'Number of CPU''s =', mpsize
!
!     --------------------------------------------------- MD start
      WRITE  (*,1000)  FLNAME(1), FLNAME(2)
 1000 FORMAT (' Welcome to MOLECULAR DYNAMICS SIMULATION WORLD: ',A9,'&
                Version ',A11) 
!
!
      CALL  MDMAIN (myrank, mpsize)
!     ----------------------------------------------- Terminate MPI
      iii(1) = -9999
      iii(2) = -9999
      iii(3) = -9999
      call MPI_Bcast (iii(1), 3, MPI_INTEGER4, 0, MPI_COMM_WORLD, ierr)
      call MPI_Finalize (ierr)
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
      WRITE (*,9898) 
      write (*,9899) INT(KKTIME(4,1)),INT(KKTIME(5,1)),INT(KKTIME(6,1)),&
                     INT(KKTIME(2,1)),INT(KKTIME(3,1)),IHOUR,IMINUT,ISECND,IMONTH,IDAY
      write (*,9898)
 9898 FORMAT (4X,73('='))
 9899 format (5X, &
               '===== Started at ',I2,':',I2,':',I2,' on ',I2,'/',I2, &
                  ', finished at ',I2,':',I2,':',i2,' on ',I2,'/',I2, &
               ' =====')
      stop
      END
!
!
!                                                               ========
!================================================================ MDMAIN
      SUBROUTINE  MDMAIN (myrank, mpsize)
      USE PARAM
      USE CHARAC
      USE TIMDAT
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE GEOMET
      USE FORCES
      USE WORK01
      USE WORK02
      USE VECTOR
      USE VALUES
      USE ACOORD
      USE THRMINT   !kwkt
      USE OUTERF    !CONSTSHEAR
!
      implicit none
!
      integer(KIND=4)        IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer(KIND=4)        INOEND,I,NN,MM,J
      integer(KIND=4)        myrank,mpsize
      CHARACTER(LEN=3):: ORDNL1, ORDNL2, ORDNLS(4)
      DATA            ORDNLS / '-st', '-nd', '-rd', '-th' /
      real(8) :: ct(0:1), et(0:1)
!
!     ----------------------------------- Open file05.dat and file06.dat
!     OPEN   (*, FILE='CON:')
!
! ***           file05.dat : INPUT FILE FOR RUN SPECIFICATION
      OPEN (15, FILE=FLNAME(5), STATUS='OLD', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
! ***           file06.dat : SO CALLED SYSOUT FILE (WRITE (16,... ONLY)
      OPEN (16, FILE=FLNAME(6), STATUS='UNKNOWN', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
!
      nallo = 0
      INOEND = 0
!     ----------------------------- Enter subroutine for initial setting
 1111 CALL  INITIA  (INOEND)
                     IF (INOEND    < 0)  GO TO 9999
                     IF (IRECRD(2).LE.0)  GO TO 8888
                     IF (IRECRD(1).LE.0)  GO TO 8888
      NRECRD(3) = 0
!
      WRITE  (*,4002)  (I,RUNOPT(I),I=1,6)
      WRITE  (*,4003)  (I,RUNOPT(I),I=7,12)
      WRITE  (*,4003)  (I,RUNOPT(I),I=13,18)
      WRITE  (*,4003)  (I,RUNOPT(I),I=19,24)
      WRITE  (*,4003)  (I,RUNOPT(I),I=25,30)
 4002 FORMAT (' Option[',I2,':',A8,5(I3,':',A8),']')
 4003 format (7X,'[',I2,':',A8,5(I3,':',A8),']')
                      ORDNL1 = ORDNLS(4)
                      IF (MOD(NRECRD(1)+1,10) == 1)  ORDNL1 = ORDNLS(1)
                      IF (MOD(NRECRD(1)+1,10) == 2)  ORDNL1 = ORDNLS(2)
                      IF (MOD(NRECRD(1)+1,10) == 3)  ORDNL1 = ORDNLS(3)
                      ORDNL2 = ORDNLS(4)
                      IF (MOD(IRECRD(1),10) == 1)  ORDNL2 = ORDNLS(1)
                      IF (MOD(IRECRD(1),10) == 2)  ORDNL2 = ORDNLS(2)
                      IF (MOD(IRECRD(1),10) == 3)  ORDNL2 = ORDNLS(3)
!
      IF (RUNOPT(30)  ==  'POTSURF   ')THEN
        CALL POSURF (myrank,mpsize)
        GO TO 9999
      ENDIF
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      WRITE  (*,4001)  IHOUR,IMINUT,ISECND, IYEAR,IMONTH,IDAY, &
                       NRECRD(1)+1,ORDNL1,IRECRD(1),ORDNL2
 4001 FORMAT (' Started at ',I2,':',I2,':',I2,' on ',I4,'/',I2,'/',I2, &
               3X,'from ',I6,A3,' step, until ',I8,A3,' step')
!
      open (40,file='ulam.dat', STATUS='UNKNOWN', &            !kwkt
             ACCESS = 'SEQUENTIAL', FORM = 'FORMATTED')
      write (40,*) "#N+1 atom's potential by interaction with N-systems."
      write (40,'("#( f = ",F5.2,1x,"**",I3," ) , ",E10.2," s/steps")') lambd,kval,DTIME
      write (40,*) "#steps      V(n+1) (erg)    <V(n+1)> (erg) f'<V(n+1)> (erg)"
      ULAMT = 0.0D0
!
!
!              ===============================================
!     ============== Start of a series of MD calculation ==============
!     ======                                                     ======
 5555                     NRECRD(3) = NRECRD(3) + 1
                          NRECRD(1) = NRECRD(1) + 1
                          IRECRD(6) = IRECRD(6) + 1
!call timer( ct(0), et(0), "" )
!if ( myrank == 0 ) call write_border( "start" )
              IF (NRECRD(3) == 1.OR. &
                  MOD(NRECRD(1),IRECRD(3)) == 1 .OR. &
                  IRECRD(3) == 1)  CALL CLEARS
!
!call timer( ct(1), et(1), "" )
              CALL  NEWTON (myrank, mpsize)
!call timer( ct(1), et(1), "(NEWTON)" )
!
              CALL  RECORD9
!call timer( ct(1), et(1), "(RECORD09)" )
              IF (IRECRD(1) == 1)                 GO TO 8888
!call timer( ct(0), et(0), "(end)" )
!if ( myrank == 0 ) call write_border( "end" )
              IF (MOD(NRECRD(1),IRECRD(3)) /= 0)  GO TO 7777
!call timer( ct(1), et(1), "" )
                     CALL  INTVAL          
                     CALL  STRCTR  (0)     
                             NN = IRECRD(2)/IRECRD(3)
                             MM = MOD(NRECRD(1)/IRECRD(3), NN)
                     IF (MOD(MM,2) == 0 .AND. &
                         MOD(NRECRD(1),IRECRD(2)) == 0)  THEN
                            IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
                                   CALL  COORDN
                            END IF
                                   CALL  PCFRCN
                                   CALL  POTPLT
                     END IF
                     CALL  F07F08  (1)
!call timer( ct(1), et(1), "(7777)" )
!call timer( ct(1), et(1), "" )
 7777         IF (NRECRD(1) < IRECRD(1))  GO TO 5555
!call timer( ct(1), et(1), "(5555)" )
!     ======                                                     ======
!     ============== End of the series of MD calculation ==============
!              ===============================================
!
      CALL  TITLET  (1, 0)
      CALL  SUMMRY
 8888 CALL  STRCTR  (1)
      CALL  TITLET  (0, 0)
!
      IF (RUNOPT(11) /= '          ') THEN
        IF (RUNOPT(18) == 'BINARY    ') THEN
          WRITE (28)  -999, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
        ELSE
          WRITE (28,9002) -999, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
 9002         FORMAT (I5, 5X, 9F7.3)
        END IF
        ENDFILE 28
        CLOSE (28)
      END IF
      IF (RUNOPT(19) == 'PRESSURE  ') THEN
             WRITE (27,2013)  (999.9999,J=2,8)
 2013        FORMAT (7F9.4)
             CLOSE (27) 
      END IF
!
      if(runopt(22) == 'CONSTSHEAR') then
        write(*,*) "Option :",runopt(22)
        write(*,'("dispzx: ", F10.4, " dispzy: ", F10.4)')dispzx,dispzy
      endif

!
      GO TO 1111
!
!     --------------------------------------------------------- Finish !
 9999        ENDFILE  16
             REWIND   16
             CLOSE   (16)
             CLOSE   (40)  !for ULAM.dat kwkt
!
             IF (TITLE(1) /= 'BENC' .OR. TITLE(2) /= 'HMAR')  THEN
                     ENDFILE  29
                     ENDFILE  19
                     REWIND   29
                     REWIND   19
                     CLOSE   (29)
                     CLOSE   (19)
             END IF
      return
      END
!
!
!                                                               ========
!================================================================ CONSTA
!      SUBROUTINE  CONSTA
!      USE CONSTS
!      implicit none
!!     ----------------------------------------------- Physical constants
!      PI  = 3.14159265357D0
!!                                   Avogadro constant            / mol-1
!      ANA = 6.0221367D23
!!                                   Boltzmann constant           / J.K-1
!      AKB = 1.380658D-23
!!                                   Boltzmann constant         / erg.K-1
!      AKB = 1.380658D-16
!!                                   Plank constant               / erg.s
!      AHP = 6.6260755D-27
!!                                   Permittivity of vacuum       / F.M-1
!      EP0 = 8.854187817D-12
!!                                   Verocity of light in vacuum / cm.s-1
!      CVL = 2.99792458D10
!!                                   Elementary charge          / C / esu
!      ELC = 1.60217733D-19 * CVL * 0.1D0
!!                                   Conversion from calory to joule
!      CAL = 4.18605D0
!!
!      RETURN
!      END
!
!
!                                                               ========
!=============================================================== TITLET
      SUBROUTINE  TITLET  (ID,JD)
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
!
      IMPLICIT NONE
!
      integer(KIND=4)    IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH
      integer(KIND=4)    ID,JD,I,J,N,L,K
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!
!                                OUTPUT HISTRY OF THE SYSTEM
      IF (ID == 0)  THEN
             IF (JD == 0)  WRITE (16,1001)
             WRITE (16,2002)
             WRITE (16,2001)
             DO I = 1, NRECRD(6), 5
                     J = I + 4
                 IF (J > NRECRD(6))  J = NRECRD(6)
                 N = J - I + 1
                 IF (N == 1) WRITE (16,2221)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 2) WRITE (16,2222)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 3) WRITE (16,2223)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 4) WRITE (16,2224)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 5) WRITE (16,2225)((IHISTR(K,L),K=1,4),L=I,J)
             ENDDO
      ELSE
             IF (ID == 1)                WRITE (16,1001)
             IF (ID == 0.AND.JD.NE.1)    WRITE (16,1001)
      END IF
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      WRITE (16,1111) 
      write (16,1112)SPRES(1),IHOUR,IMINUT,ISECND
      write (16,1113)NJOB,TITLE,TEMP,SPRES(2)
      write (16,1114)SPRES(3),IYEAR,IMONTH,IDAY
      write (16,1115)
      RETURN
!
 1001 FORMAT (1X)
 1111 FORMAT (' I',130('='),'I')
 1112 format (' I',10X,       '  :   ',60X, '   :', 12X,      F12.4, &
                             7X,':   at  ',I2,':',I2,':',I2,'   I')
 1113 format (' I',I5,' -',I3,'  :   ',15A4,'   :',F10.1,' K',F12.4, &
                                            ' GPa   :',18('-'),'I')
 1114 format (' I',10X,       '  :   ',60X, '   :', 12X,      F12.4, &
                             7X,':   on  ',I4,'/',I2,'/',I2,' I')
 1115 format (' I',130('='),'I' )
 2001 FORMAT (' I',6X, '<<<<< History of this system >>>>>', 5X, &
               '< No. of steps >---< Temperature / K >---< Pressure ',&
                '/ GPa >---< Date (yymmdd) >',6X,'I')
 2002 FORMAT (' I',130('='),'I')
 2221 FORMAT (' I  ',I6,I5,I3,I7,5X, 99X, '   I')
 2222 FORMAT (' I  ',I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, 73X, '   I')
 2223 FORMAT (' I  ',I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, &
                     47X, '   I')
 2224 FORMAT (' I  ',I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, &
                    I6,I5,I3,I7, 26X, '   I')
 2225 FORMAT (' I  ',I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, I6,I5,I3,I7,5X, &
                    I6,I5,I3,I7,5X, I6,I5,I3,I7,'   I')
      END
!
!
!                                                               ========
!================================================================ F07F08
      SUBROUTINE  F07F08  (INOEND)
      USE PARAM
      USE CHARAC
      USE TIMDAT
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE GEOMET
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE VALUES
      USE ACOORD
!
      implicit none
!

      CHARACTER(LEN=10)::  RUNO18,RUNO19
      CHARACTER(LEN=4)::   TITLE0(15), BIN
      CHARACTER(LEN=1)::   DEFECT
      integer(KIND=4)    iform7,INOEND,NCUT0,KHIST
      integer(KIND=4)    IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH
      integer(KIND=4)    I,N,J,K,io
!
      IF (INOEND == 1)  GO TO 501
!     --------------------------------------------- Read from FILE07.DAT
!                         system description, coordinates and velocities
      iform7 = 0
      OPEN (17, FILE=FLNAME(7), STATUS='OLD', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    7 READ (17,7007) TITLE0, NJOB
      read (17,7008) NTION, NCOMPO, (NRECRD(I),I=1,9), BIN 
!
      IF (NTION > LNI) THEN
         WRITE (*,*) 'Error: No. of ions (', NTION, ') is too large',&
                       ' (LNI=', LNI, ') !!!'
         STOP
      END IF
      IF (NCOMPO > LEL) THEN
        WRITE (*,*) 'Error: No. of ion species (',NCOMPO,') is ', &
                    'too large (LEL=',LEL,') !!!'
        STOP
      END IF
                          RUNOPT(18) = '          '
      IF (BIN == 'BIN ')  RUNOPT(18) = 'BINARY    '
!
      READ (17,7017) (ATOM07(I),I=1,NCOMPO)
      READ (17,7018) (NION(I),I=1,NCOMPO)
      READ (17,7018) (IONS(1,I),I=1,NCOMPO)
      READ (17,7018) (IONS(2,I),I=1,NCOMPO)
      READ (17,7070) TEMP, DELTMP,TMPGET, (SPRES(I),I=1,3)
      read (17,7071) DTIME,  RUNOPT(51), BOX
      read (17,7072) DENSTY, RUNOPT(52), VBOX 
      IF (RUNOPT(51) == 'THERMOSTAT')  READ (17,7080) STEMP, VSTEMP
      IF (RUNOPT(52) == 'H-TENSOR  ')  THEN
                  DO I = 1, 3
                      READ (17,7080)  (H(I,J),J=1,3)
                  ENDDO
      END IF
!
      if (iform7 == 0) then
        write (*,1176)
        WRITE (*,1177) TITLE0
        write (*,1189) TITLE
 1176   FORMAT (6X,14('='),' Titles in FILE07.DAT and FILE05.DAT are ',14('='))
 1177   format ('  =====[F7]: ',15A4,' ===== ') 
 1189   format ('  =====[F5]: ',15A4,' ===== ')
!          if (nallo  ==  0) THEN
!          N = NTION
!          ALLOCATE (IOND(N),P(3,N),P0(3,N),V(3,N),FX(N),FY(N),FZ(N))
!          ALLOCATE (Q(3,N),Q0(3,N))
!          ALLOCATE (PX(N),PY(N),PZ(N),V10(3,N),DDDD(6,N),VV(3,N))
!          ALLOCATE (PPK(3,N),PCC(3,N),PSS(3,N),DONB(6,N),DUM(3,N))
!          ALLOCATE (IIII(6,N),IP(3,N),PP(3,N),IPV(3,N),IDUMMY(3,N))
!          ALLOCATE (UUII(N),ZIIP(N),ZII(N),ZICOS(N),ZISIN(N),JPS(3,N))
!          ALLOCATE (P00(3,N),XYZ0(3,N),IONB(6,N))
!          nallo = 1
!          end if
      end if
!      write(*,'("Allocation completed")')
!
      IF (NTION > LNI)  WRITE (*,*) 'The number of atoms :',NTION,' is &
                                     greater than LNI:',LNI
          NTIOND = 0
          DO I = 1, NTION
              IOND(I) = 1
!              if (iform7 == 0 ) then
!                     READ (17,7700,err=7878) (P(J,I),J=1,3),
!     *                       DEFECT, (V10(J,I),J=1,3), (P0(J,I),J=1,3)
!              else
                     READ (17,7702,err=7878) (P(J,I),J=1,3),&
                            DEFECT, (V10(J,I),J=1,3), (P0(J,I),J=1,3)
!              end if
!                     if (abs(V10(1,i)-5.0)+abs(V10(2,i)-5.0)+
!     *                   abs(V10(3,i)-5.0) .gt. 3.0 ) then
!                           iform7 = 1
!                           rewind 17
!                           go to 7
!                     end if
                 IF (DEFECT /= ' ') THEN
                        write (6,*)  i,defect
                        IOND(I) = 0
                        NTIOND  = NTIOND + 1
                        V10(1,I) = 0.0D0
                        V10(2,I) = 0.0D0
                        V10(3,I) = 0.0D0
                 END IF
              DO J = 1, 3
                  V(J,I) = (V10(J,I)-5.0D0) * 0.1D0
              ENDDO
          ENDDO
          IF (NTIOND > 0) WRITE (*,7979) NTIOND
 7979          FORMAT (1X,I6,' DEFECTS WERE DETECTED ')
      IF (NRECRD(6) > 0) THEN
        READ (17,7800,END=180,ERR=180)  ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
             GO TO 190
  180        NRECRD(6) = 0
  190 END IF
      IRECRD(6) = 0
      CLOSE  (17)
!      if (iform7 == 0) write (6,*) 'Format of file07.dat will be ',
!     *                             'converted.'
      go to 201
!
 7878 write (6,*) 'File07.dat : error at the line ',i+9
      stop      
!
  201 IF (RUNOPT(2) == 'RESTART   ')  THEN
        RUNOPT(2) = 'START     '
        NRECRD(6) = 0
        DO  I = 1,NTION
           DO  J = 1, 3
              P(J,I) = P0(J,I)
           ENDDO   
        ENDDO
      END IF
!
      NBOX(1) = 1
      NBOX(2) = 1
      NBOX(3) = 1
      IF (RUNOPT(17) == 'CRYSTAL   ')  CALL  FILE10
!
      IF (TITLE(1).NE.'BENC' .OR. TITLE(2).NE. 'HMAR' )  THEN
!                               file09p.dat : COORDINATES AT EACH 5 STEP
            OPEN (19, FILE=FLNAME(9), STATUS='UNKNOWN', &
                      ACCESS='SEQUENTIAL', FORM='FORMATTED' )
!                                    file09v.dat : VALUES AT EACH 5 STEP
            OPEN (29, FILE=FLNAME(11), STATUS='UNKNOWN', &
                      ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      END IF
!
      IF (RUNOPT(2) == 'CONTINUE  '.OR.RUNOPT(2) == 'CONTINUE  ')  THEN
        NJOB(2) = NJOB(2) + 1
!       ----------------------------------- Read from FILE08.DAT
!                                          PCF, properties, etc.
        OPEN (18, FILE=FLNAME(8), STATUS='OLD', &
                  ACCESS='SEQUENTIAL', FORM='FORMATTED' )
        REWIND  18
        READ (18,8001) NCUT0,NRCUT(1),NRECRD(2),NAV,NAVT,NTBL, &
                       MXCUT,NPAIR
        DO  J = 1, LEE
           DO  N = 1, LTB
              NRDF(N,J) = 0
           ENDDO   
        ENDDO   
        DO  I = NCUT0, NRCUT(1)
           READ (18,8001) (NRDF(I,J),J=1,NPAIR)
        ENDDO   
        DO I = 1, LVA
           READ (18,8003) TVAL(I),SVAL(I),SVALL(I),VAL0(I)
        ENDDO
!        DO I = 1, NAV
!           READ (18,8003) (AVA(J,I),J=1,LVA)
!        ENDDO
        READ (18,8003) (AU(I),I=1,NTION)
        DO  I = 1, 12
           READ (18,8003) (ANGL(J,I),J=1,3)
        ENDDO
        DO  K = 1, 2
           DO  J = 1, 6
              READ (18,8001) (MBR(I,J,K),I=1,6)
           ENDDO   
        ENDDO
        DO  J = 1, 2
           READ (18,8001) (NRG(I,J),I=1,9)
        ENDDO
        DO  I = 1, 121
           READ (18,8005) (ITBR(I,J),J=1,12)
        ENDDO
        IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
          READ (18,8004) ((PPC(J,N),J=1,3),(PPS(J,N),J=1,3),N=1,NPT)
        END IF
        CLOSE  (18)
!
        OPEN (38, FILE=FLNAME(18), STATUS='OLD',&
                  ACCESS='SEQUENTIAL', FORM='FORMATTED' )
          REWIND  38
          DO I = 1, NAV
            READ (38,8003) (AVA(J,I),J=1,LVA)
          enddo
        close  (38)
!
        CALL  FILE09
      ELSE
              NJOB(1) = NJOB(1) + 1
              NJOB(2) = 1
              NRECRD(4) = 0
              NRECRD(5) = 0
              IF (TITLE(1) /= 'BENC'.OR.TITLE(2) /=  'HMAR' )  THEN
                    REWIND  29
                    REWIND  19
              END IF
      END IF
      RETURN
!
!     ========================================= Output file07 and file08
  501 NRECRD(6) = NRECRD(6) + 1
           CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
             IHISTR(1,NRECRD(6)) = IRECRD(6)
             IHISTR(2,NRECRD(6)) = INT(TMPGET)
             IHISTR(3,NRECRD(6)) = INT((SPRES(1)+SPRES(2)+SPRES(3))/3.0)
             IHISTR(4,NRECRD(6)) = IYEAR*10000 + IMONTH*100 + IDAY
             IRECRD(6) = 0
         IF (NRECRD(6) > 1)  THEN
                KHIST = NRECRD(6) - 1
                IF (IHISTR(2,NRECRD(6)) == IHISTR(2,KHIST).AND. &
                    IHISTR(3,NRECRD(6)) == IHISTR(3,KHIST))  THEN
                    IHISTR(1,KHIST)=IHISTR(1,NRECRD(6))+IHISTR(1,KHIST)
                    IHISTR(4,KHIST)=IHISTR(4,NRECRD(6))
                    NRECRD(6) = KHIST
                 END IF
         END IF
         IF (TITLE(1) == 'BENC' .AND. TITLE(2) == 'HMAR')  GO TO 699
!
         RUNO18 = '          '
         RUNO19 = 'H-TENSOR  '
         IF (RUNOPT(5) == 'T NOSE    ')  RUNO18 = 'THERMOSTAT'
!
!     ---------------------------------------------- Write on FILE07.DAT
!                         system description, coordinates and velocities
!
      OPEN (17, FILE=FLNAME(7), STATUS='UNKNOWN', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      REWIND 17
                                       BIN = '    '
      IF (RUNOPT(18) == 'BINARY    ')  BIN = 'BIN '
      WRITE (17,7007) TITLE, NJOB
      write (17,7008) NTION, NCOMPO, (NRECRD(I),I=1,9),BIN 
      WRITE (17,7017) (ATOM07(I),I=1,NCOMPO)
      WRITE (17,7018) (NION(I),I=1,NCOMPO)
      WRITE (17,7018) (IONS(1,I),I=1,NCOMPO)
      WRITE (17,7018) (IONS(2,I),I=1,NCOMPO)
      WRITE (17,7070) TEMP, DELTMP,TMPGET, (SPRES(I),I=1,3)
      write (17,7071) DTIME,  RUNO18,  BOX
      write (17,7072) DENSTY, RUNO19, VBOX 
      IF (RUNO18 == 'THERMOSTAT')  WRITE (17,7080)  STEMP,VSTEMP
            DO I = 1, 3
                WRITE (17,7080)  (H(I,J),J=1,3)
            ENDDO
      do io = 1, ncompo
         DO I = ions(1,io), ions(2,io)
            DO  J = 1, 3
               V10(J,I) = V(J,I) * 10.0D0 + 5.0D0
            ENDDO
            DEFECT = ' '
            IF (IOND(I) == 0)  DEFECT = '*'
            WRITE (17,7702) (P(J,I),J=1,3),DEFECT,(V10(J,I),J=1,3), &
                            (P0(J,I),J=1,3), io
         ENDDO
      ENDDO   
      WRITE (17,7800) ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
      ENDFILE  (17)
      REWIND    17
      CLOSE    (17)
!
!       -------------------------------------------- Write on FILE08.DAT
!                                                  PCF, properties, etc.
                    DO N = 1, NRCUT(1)
                       DO J = 1, LEE
                          IF (NRDF(N,J) > 0)  GO TO 513
                       ENDDO
                    ENDDO
  513               NCUT0 = N - 1
        NPAIR = NCOMPO * (NCOMPO+1) / 2
        OPEN (18, FILE=FLNAME(8), STATUS='UNKNOWN', &
                  ACCESS='SEQUENTIAL', FORM='FORMATTED' )
        REWIND  18
!        write(*,*)'NRDF(NCUT0+1,7)=',NRDF(NCUT0+1,7)
        WRITE (18,8001) NCUT0,NRCUT(1),NRECRD(2),NAV,NAVT,NTBL,MXCUT, &
                        NPAIR
        DO I = NCUT0, NRCUT(1)
            WRITE (18,8001) (NRDF(I,J),J=1,NPAIR)
        ENDDO
        DO  I = 1, LVA
            WRITE (18,8003) TVAL(I),SVAL(I),SVALL(I),VAL0(I)
        ENDDO
!        DO 631  I = 1, NAV
!            WRITE (18,8003) (AVA(J,I),J=1,LVA)
!  631   ENDDO
        WRITE (18,8003) (AU(I),I=1,NTION)
        DO I = 1, 12
            WRITE (18,8003) (ANGL(J,I),J=1,3)
        ENDDO
        DO  K = 1, 2
            DO  J = 1, 6
               WRITE (18,8001) (MBR(I,J,K),I=1,6)
            ENDDO   
        ENDDO
        DO J = 1, 2
            WRITE (18,8001) (NRG(I,J),I=1,9)
        ENDDO
        DO J = 1, 121
            WRITE (18,8005) (ITBR(J,I),I=1,12)
        ENDDO
        IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
          WRITE (18,8004) ((PPC(J,N),J=1,3),(PPS(J,N),J=1,3),N=1,NPT)
        END IF
!
        ENDFILE  (18)
        REWIND    18
        CLOSE    (18)
!
        OPEN (38, FILE=FLNAME(18), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', &
                  FORM='FORMATTED' )
          REWIND  38
          DO I = 1, NAV
              WRITE (38,8003) (AVA(J,I),J=1,LVA)
          enddo
          ENDFILE  (38)
          REWIND    38
        CLOSE    (38)
!
  699     WRITE (*,4001)  IRECRD(1)
 4001     FORMAT (1X,15('='),'  Files were updated  ',13('='), &
                             '  End=',I8,2X,13('='))
          WRITE (*,1178)  TITLE
 1178     FORMAT (' <<<=====  ',15A4,'  ====>>>')
      RETURN
!
!     -------------------------------------------- Formats of file07.dat
 7007 FORMAT (15A4,2I5)
 7008 format (I7,I3, 9I10,A4)
 7017 FORMAT (20(2X,A4) )
 7018 FORMAT (20I6 )
 7070 FORMAT (F10.2,F10.4,F10.2, 3F10.5)
 7071 format (E10.3, A10, 6F10.6)
 7072 format (F10.6, A10, 6F10.6) 
 7080 FORMAT  (10X,3F20.10)
 7700 FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.6)
 7701 FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.6, 1x,i2)
 7702 FORMAT (3F10.8, A1, 3F9.7, 1X, 3F10.6, 1x,i2)
 7800 FORMAT (3(I10,I5,I4,1X,I6))
!     -------------------------------------------- Formats of file08.dat
 8001 FORMAT (10I10)
 8003 FORMAT (1P5E16.9)
 8004 FORMAT (0P3F12.6,4X,3F12.6)
 8005 FORMAT (12I6)
      END
!
!
!                                                               ========
!================================================================ FILE09
      SUBROUTINE  FILE09
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE ATOMSI
      USE CARTES
      USE WORK02
      USE VALUES
      USE ACOORD
!
      implicit none
!
      double precision  HH(3,3), VALVAL(LVA)
      integer(KIND=4)  K,I,MMMMM,L,J
!
      IF (TITLE(1) == 'BENC' .AND. TITLE(2) ==  'HMAR')  RETURN
!     --------------------------------------- Work file for continuation
      OPEN (22, FILE   = FLNAME(19),   STATUS = 'UNKNOWN', &
                ACCESS = 'SEQUENTIAL', FORM   = 'FORMATTED' )
!
!               -------------------------------------------- FILE09V.DAT
! 1991    FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.7 / 20F9.3 / 20F9.3 )
 1991    FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.4 / 20F9.3 / 20F9.3 )

                REWIND  29
                REWIND  22
                DO K = 1, NRECRD(5)
                    READ  (29,1991)  (VALVAL(I),I=1,LVA)
                    WRITE (22,1991)  (VALVAL(I),I=1,LVA)
                ENDDO
                ENDFILE  22
                REWIND   29
                REWIND   22
                DO K = 1, NRECRD(5)
                    READ  (22,1991)  (VALVAL(I),I=1,LVA)
                    WRITE (29,1991)  (VALVAL(I),I=1,LVA)
                ENDDO
!
!         -------------------------------------------------- FILE09P.DAT
      IF (RUNOPT(18) == 'BINARY    ')  THEN
          CLOSE (22)
          OPEN (22, FILE   = FLNAME(19),   STATUS = 'UNKNOWN', &
                    ACCESS = 'SEQUENTIAL', FORM   = 'UNFORMATTED' )
      END IF
                                           MMMMM = NTION
          IF (RUNOPT(17) == 'CRYSTAL   ')  MMMMM = NPTP
          REWIND  19
          REWIND  22
      IF (RUNOPT(18) == 'BINARY    ')  THEN
          DO  K = 1, NRECRD(4)
              READ  (19)  L,  HH
              READ  (19)  ((PP(J,I),J=1,3),I=1,MMMMM)
              WRITE (22)  L,  HH
              WRITE (22)  ((PP(J,I),J=1,3),I=1,MMMMM)
          ENDDO
                REWIND   19
                REWIND   22
                DO K = 1, NRECRD(4)
                    READ  (22)  L,  HH
                    READ  (22)  ((PP(J,I),J=1,3),I=1,MMMMM)
                    WRITE (19)  L,  HH
                    WRITE (19)  ((PP(J,I),J=1,3),I=1,MMMMM)
                ENDDO
      ELSE
          DO  K = 1, NRECRD(4)
              READ  (19,9002)  L,  HH
              READ  (19,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
              WRITE (22,9002)  L,  HH
              WRITE (22,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
          ENDDO
                REWIND   19
                REWIND   22
                DO  K = 1, NRECRD(4)
                    READ  (22,9002)  L,  HH
                    READ  (22,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
                    WRITE (19,9002)  L,  HH
                    WRITE (19,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
                ENDDO
      END IF
!
      CLOSE  (22)
      RETURN
!     ----------------------------------------- Formats of file09a.dat's
 9001 FORMAT (18I5)
 9002 FORMAT (I7,3X, 9F7.3)
      END
!
!
!                                                               ========
!================================================================ FILE10
      SUBROUTINE  FILE10
      USE PARAM
      USE CHARAC
      USE ABOXOF
      USE ATOMSI
      USE ACOORD
!
      implicit none
!
      CHARACTER(LEN=4)::   HEX
      integer(KIND=4)   J,N,I
!
!             ------------------------------ Input file of xtal geometry
              OPEN (10,FILE=FLNAME(10),STATUS='OLD', &
                    ACCESS='SEQUENTIAL',FORM='FORMATTED')
              REWIND  10
                  READ (10,5010)  (BOXO(I),I=1,6)
                  read (10,5011)  (NBOX(I),I=1,3),NPT,NPTP,NSYM,HEX,MATM
                  READ (10,5012)  (ATMXTL(J),J=1,MATM)
                  READ (10,5014)  (NIU(J),J=1,MATM)
                  READ (10,5020)  (JON(N),(P0C(J,N),J=1,3),N=1,NPTP)
                  READ (10,5030)  (((RS(J,I,N),J=1,3),I=1,3),N=1,NSYM)
                  READ (10,5040)  (ISYM(N),N=1,NTION)
              REWIND  10
              CLOSE  (10)
              IHEX = 0
              IF (HEX == 'HEX ')  IHEX = 1
      RETURN
 5010         FORMAT (3F10.7,3F10.8)
 5011         FORMAT (6I5,5X,A4,I6 )
 5012         FORMAT ( 18A4 )
 5014         FORMAT ( 18I4 )
 5020         FORMAT (I5,3F10.7)
 5030         FORMAT (9F6.1)
 5040         FORMAT (12I6)
      END
!
!
!                                                               ========
!================================================================ INITIA
      SUBROUTINE  INITIA  (INOEND)
!     -------------------------------------------- Initial reading, etc.
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE PARAMT
      USE GEOMET
      USE CARTES
      USE WORK01
      USE PSURF
      USE WORK02
      USE ANIPAR
      USE VECTOR
      USE VALUES
      USE TABLES
      USE struct 
      USE OUTERF
      USE MOLECU
      use thrmint !kwkt
!
      implicit none
!
      double precision  BOXA(6),FA(3),param1,param2,param3,param4,param5,param6
      CHARACTER(LEN=4):: ATY, AAX, THS1,THS2,RUNOP1
      CHARACTER(LEN=10)::RUNRUN, DUMMY
      double precision     AREC1,AREC2,AREC3,AREC4,AREC5
      double precision     DDT,AMODE,ZSUM
      double precision     FORMUL,TARGT,DELT,STEMP0
      double precision     ANJ,ZJ,WJ,AJ,BJ,CJ,DJ,ZI1
      integer(KIND=4)  INOEND,IP0,NREM,NSTEP1,NATX
      integer(KIND=4)  I,J,IO1,IO,LL,k
      character *1 Ins1
!
      ATMNET(1) = '    '
      ATMNET(2) = '    '
      DO I = 1, 53
         RUNOPT(I) = '          '
      ENDDO
      NRECRD(9) = 0
!
!     --------------------------------------- Data input from FILE05.DAT
!
         IP0 = 0
      INOEND = 0
   30 READ (15,1001,END=888)  RUNOPT(1)
          RUNOP1='    '
                         IF (RUNOPT(1) == 'MDX......I')  THEN
                              RUNOPT(1) = 'MD........'
                              RUNOP1    = 'MD..'
                                     IP0 = 1
                         END IF
                         IF (RUNOPT(1) == 'MD.......I')  THEN
                                 RUNOPT(1) = 'MD........'
                                 RUNOPT(17) = 'AMORPHOUS '
                                 RUNOP1 = 'MD..'
                         END IF
                         IF (RUNOPT(1) == 'XD.......I')  THEN
                                 RUNOPT(1) = 'XD........'
                                 RUNOPT(17) = 'CRYSTAL   '
                                 RUNOP1 = 'XD..'
                         END IF
                         IF (RUNOP1 /= 'MD..' .AND. &
                             RUNOP1 /= 'XD..' )  GO TO 30
      READ (15,1001,END=888)  RUNOPT(2),TITLE
                         IF (RUNOPT(2) == '          ' .OR. &
                             RUNOPT(2) == 'STOP      ' .OR. &
                             RUNOPT(2) == 'END       ' )  GO TO 888
                         IF (RUNOPT(2) == 'CONT.     ') &
                             RUNOPT(2) = 'CONTINUE  '
      GO TO 50
!
  888   INOEND = -1
        RETURN
!
!     -------------------------------- Read file07.dat, file08.dat, etc.
   50 CALL  F07F08  (INOEND)
!     -------------------------------------- Input file of xtal geometry
      CALL  TITLET  (1,0)
!     ------------------------------------------- Economy, normal detail
      READ (15,1000)  RUNOPT(3), AREC1, AREC2, AREC3, AREC4, AREC5
                                IRECRD(1) = INT(AREC1)
                                IRECRD(2) = INT(AREC2)
                                IRECRD(3) = INT(AREC3)
                                IRECRD(4) = INT(AREC4)
                                IRECRD(5) = INT(AREC5)
               IF (IRECRD(1) > LCT) THEN
                      WRITE (6,*) 'The number of steps:',IRECRD(1), &
                                 'is too large (LCT=',LCT,')'
                      WRITE (6,*) 'Please chage all the LCT parameters'
                      STOP
               END IF
               IF (IRECRD(1) < IRECRD(2))         IRECRD(2) = IRECRD(1)
               IF (MOD(IRECRD(1),IRECRD(2)).NE.0)  IRECRD(2) = IRECRD(1)
               IF (IRECRD(3).LE.0)                 IRECRD(3) = 50
               IF (IRECRD(2) < IRECRD(3))         IRECRD(3) = IRECRD(2)
               IF (IRECRD(4).LE.0)  THEN
                      IF (RUNOP1 == 'MD..') IRECRD(4) = IRECRD(3)
                      IF (RUNOP1 == 'XD..') IRECRD(4) = 5
               END IF
               IF (IRECRD(5).LE.0)                 IRECRD(5) = 5
!     ------------------------------------------------- Accume, noaccume
      READ (15,1000)  RUNOPT(4), DDT, FORMUL, RCUT(1), RCUT(2)
!     ------------------------------------------------------ Temperatute
      READ (15,1000)  RUNRUN, TARGT, DELT, STEMP0, TDUMP
                IF (RUNRUN == 'T         ')  RUNOPT(5) = 'T NO-CNTL '
                IF (RUNRUN == 'T NO      ')  RUNOPT(5) = 'T NO-CNTL '
                IF (RUNRUN == 'T NO-CNTL ')  RUNOPT(5) = 'T NO-CNTL '
                IF (RUNRUN == 'T SCALING ')  THEN
                                             RUNOPT(5) = 'T SCALING '
                                             NTSTEP = STEMP0
                END IF
                IF (RUNRUN == 'T SCALE-A ')  THEN
                  RUNOPT(5) = 'T SCALE-A '
                  NTSTEP = STEMP0
                  IF (NTSTEP <= 0) NTSTEP = 10
                ENDIF
                IF (RUNRUN == 'T NOSE    ')  RUNOPT(5) = 'T NOSE    '
!               --------------------------------------
                IF (RUNOPT(5)  /= 'T NOSE    ' .OR. &
                    RUNOPT(2)  /= 'CONTINUE  ' .OR. &
                    RUNOPT(51) /= 'THERMOSTAT' )  THEN
                       STEMP  = STEMP0
                       VSTEMP = 0.0
                END IF
                IF (NTSTEP <= 0)  NTSTEP = 1
                DELTMP = DELT
                TMPGET = TARGT
                IF (TDUMP < 0.001)  TDUMP = 0.5
!     --------------------------------------------------------- Pressure
      READ (15,1000)  RUNRUN, (SPRES(I),I=1,3), VIRM(1),VIRM(2),VIRM(3)
                IF (RUNRUN == 'P         ')  RUNOPT(6) = 'P NO-CNTL '
                IF (RUNRUN == 'P NO      ')  RUNOPT(6) = 'P NO-CNTL '
                IF (RUNRUN == 'P NO-CNTL ')  RUNOPT(6) = 'P NO-CNTL '
                IF (RUNRUN == 'P SCALING ')  THEN
                            RUNOPT(6) = 'P SCALING '
                            SPRES(4) = 0.0D0
                            SPRES(5) = 0.0D0
                            SPRES(6) = 0.0D0
                END IF
                IF (RUNRUN == 'P ANDERSEN')  THEN
                                             RUNOPT(6) = 'P ANDERSEN'
                                       IF (ABS(VBOX(2)) < 1.0E-9.AND. &
                                           ABS(VBOX(3)) < 1.0E-9 ) THEN
                                               VBOX(1) = 0.0
                                               VBOX(2) = 0.0
                                               VBOX(3) = 0.0
                                       END IF
                END IF
!               --------------------------------------------
                IF (RUNOPT(6).NE.'P ANDERSEN'.AND. &
                         ABS(VBOX(2)) > 1.0E-9.AND. &
                         ABS(VBOX(3)) > 1.0E-9 ) THEN
                           VBOX(1) = 0.0
                           VBOX(2) = 0.0
                           VBOX(3) = 0.0
                END IF
                IF (RUNRUN == 'P SHEAR   ')  THEN
                       RUNOPT(6) = 'P SHEAR   ' 
                       READ (15,1000) DUMMY, (SPRES(I),I=4,6),(VIRM(I),I=4,6)
                END IF
!     ----------------------------------------------------------- Volume
      READ (15,1000)  RUNRUN, BOXA
                IF (RUNRUN == '          ')  RUNOPT(7) = 'V FREE    '
                IF (RUNRUN == 'V CONST.  ')  RUNOPT(7) = 'V CONST.  '
                IF (RUNRUN == 'V CONTROL ')  RUNOPT(7) = 'V CONST.  '
                IF (RUNRUN == 'D CONST.  ')  RUNOPT(7) = 'D CONST.  '
                IF (RUNRUN == 'D CONTROL ')  RUNOPT(7) = 'D CONST.  '
!               --------------------------------------- Change cell size
                IF (RUNOPT(7) == 'V CELL    ')  THEN
                                           RUNOPT(7) = 'V CELL    '
                                           DO 400  J = 1, 3
                                              FA(J)  = BOXA(J) / BOX(J)
                                              BOX(J) = BOXA(J)
  400                                      ENDDO
!               ----------------------------------------- Change density
                ELSE IF (RUNOPT(7) == 'V DENSITY ')  THEN
                                    RUNOPT(7) = 'V DENSITY '
                                    FA(1) = (DENSTY/BOXA(1))**(1.0/3.0)
                                    FA(2) = FA(1)
                                    FA(3) = FA(1)
                                    DO 440 I = 1, 3
                                        BOX(I) = BOX(I) * FA(I)
  440                               ENDDO
                END IF
!
!     -------------------------------------------------- Potential model
      READ (15,1000)  RUNOPT(8), AMODE, ALPHA
                                MODE = INT(AMODE)
               IF (RUNOPT(8).NE.'          ' .AND. & 
                   RUNOPT(8).NE.'BUSING    ' .AND. &
                   RUNOPT(8).NE.'MORSE     ' .AND. &
                   RUNOPT(8).NE.'MORSE-PL  ' .AND. &
                   RUNOPT(8).NE.'MORSE-AT  ' .AND. &
                   RUNOPT(8).NE.'BMH-EXP   ' .AND. &
                   RUNOPT(8).NE.'BMH-EXP*  ' .AND. &
                   RUNOPT(8).NE.'BELONO    ' .AND. &
                   RUNOPT(8).NE.'TOSIFUMI  ' .AND. &
                   RUNOPT(8).NE.'WOODCOCK  ' .AND. &
                   RUNOPT(8).NE.'PAULING   ' .AND. &
                   RUNOPT(8).NE.'STSUNE    ' .AND. &
                   RUNOPT(8).NE.'VASHISHTA ' .AND. &
                   RUNOPT(8).NE.'L-J       ' .AND. &
                   RUNOPT(8).NE.'METAL     ' )  THEN
                      WRITE (*,*) 'Interatomic potential model ', &
                                   RUNOPT(8),' is not recognized'
                      STOP
               END IF
!
               ZSUM = 0.0
               DO I = 1, LEM
                   ATOM(I) = '  '
                   ZIO(I)  = 0.0D0
                   WIO(I)  = 0.0D0
                   AIO(I)  = 0.0D0
                   BIO(I)  = 0.0D0
                   CIO(I)  = 0.0D0
                   DIO(I)  = 0.0D0
                   NION(I) = 0
                   IION(I) = 0
               ENDDO
!     --------------------------------------------- Read atom parameters
      NCOMPO = 0
      DO J = 1, LEL+1
        READ (15,'(A1,A1,A2,F6.0,6F10.0)',END=230)  Ins1,ATY,AAX,ANJ,ZJ,WJ,AJ,BJ,CJ,DJ
!        IF (I < 0 .or. AAX == '    ') GOTO 230
        IF (Ins1 == ' ' .or. AAX == '   ') GO TO 230
          I = 0
          do k=1,lel
            if (Ins1 == ins(k)) then
                    I = k
                    exit
            endif
          enddo
          if (I == 0) then
                  write(*,*) '!!! Error [file05.dat] at atom ', j,Ins1,I,k,'!!!'
                  write(*,'(" ---- atom =",A2,"   Ni=",F5.0," ----")')AAX,ANJ
                  stop
          endif
               ATOM(I) = AAX
               ZIO(I)  = ZJ
               WIO(I)  = WJ
               AIO(I)  = AJ
               BIO(I)  = BJ
               CIO(I)  = CJ
               DIO(I)  = DJ
               NION(I) = INT(ANJ)
               IION(I) = 0
           IF (I /= 1)  ZSUM = ZSUM + ZJ * ANJ
           IF (ATY == '-')  IION(I) = -1
           IF (ATY == '*')  IION(I) = -999
           IF (ATY == '=')  IION(I) =  1
           NCOMPO = NCOMPO + 1
      ENDDO 
230   ZI1 = - ZSUM / DBLE(NION(1))
      IF (ABS(ZI1-ZIO(1)) > 0.00001) THEN
            WRITE (*,*) 'Warnning on total charge neutralization! ',ZIO(1),ZI1
!           ZIO(1) = ZI1
      END IF
!     -------------------------------- Charge calculation after WATER-POL
      do io = 1, ncompo
        do i = ions(1,io),ions(2,io)
          ZIIP(i) = ZIO(io)
        enddo
      enddo
!     if (ICD == 0) then
      do i = 1,ntion
        ZII(i) = ZIIP(i)
      enddo
!     endif
!
      IO1 = NCOMPO + 1
!      DO 240  IO = IO1, LEL
!         IF (NION(IO) > 0)  NCOMPO = IO
!  240 ENDDO
!      write (6,*)  'Number of components is ',NCOMPO
!     ------------------------------------------------------------------
      DTMO = DTIME
      IF (RUNOPT(2) == 'START     ')  THEN
                 IF (DDT > 0.0001)     DTIME = DDT * 1.0E-15
                 IF (DTIME < 1.0E-18)  DTIME = 2.0E-15
                 IF (RUNOPT(17) == 'AMORPHOUS '.AND.IP0 == 0)  THEN
                                 DO 330  I = 1,NTION
                                    DO 331  J = 1, 3
                                        P0(J,I) = P(J,I)
  331                               continue
  330                            ENDDO
                 END IF
                 NAVT = 0 
                 NAV  = 0 
                 DO 350  I = 1, LVA
                     TVAL(I)  = 0.0D0
                     SVAL(I)  = 0.0D0
                     VAL0(I) = 0.0D0
  350            ENDDO
                 MXCUT     = 99999
                 NRECRD(1) = 0
                 NRECRD(2) = 0
!                VBOX(1)   = 1.0
      END IF
!
      CALL  PREPAR  (FORMUL)
!
!     ---------------------------------------- Configuration and heading
!
                        NREM = IRECRD(1) - NRECRD(1)
                        NSTEP1 = NRECRD(1) + 1
                        THS1 = 'th'
                        IF (MOD(NSTEP1,10) == 1)  THS1 = 'st'
                        IF (MOD(NSTEP1,10) == 2)  THS1 = 'nd'
                        IF (MOD(NSTEP1,10) == 3)  THS1 = 'rd'
                        THS2 = 'th'
                        IF (MOD(IRECRD(1),10) == 1)  THS2 = 'st'
                        IF (MOD(IRECRD(1),10) == 2)  THS2 = 'nd'
                        IF (MOD(IRECRD(1),10) == 3)  THS2 = 'rd'
      WRITE (16, 2000) RUNOPT(2),NREM,NSTEP1,THS1,IRECRD(1),THS2,DTIME,IRECRD(2)
      write (16, 2001) RUNOPT(5),TEMP,DELTMP,NTSTEP,TMPGET,RUNOPT(4), &
                                            NRECRD(2),NRECRD(4)
      IF (RUNOPT(5) == 'T NOSE    ') WRITE (16,2010)  STEMP
!
      IF (RUNOPT(6) == 'P SCALING ')  THEN 
         WRITE (16,2020)  RUNOPT(6),(SPRES(I),I=1,3)
      ELSE IF (RUNOPT(6) == 'P ANDERSEN')  THEN 
         WRITE (16,2027)  RUNOPT(6), (SPRES(I),I=1,3),(VIRM(LL),LL=1,3)
      ELSE IF (RUNOPT(6) == 'P SHEAR   ')  THEN 
                  WRITE (16,2028)  RUNOPT(6), (SPRES(I),I=1,3)
                  write (16,2029)  (SPRES(I),I=4,6)
      ELSE
                  WRITE (16,2022)  RUNOPT(6)
      END IF
!
      CALL  TABLER  (1)
!
!     ------------------------------------------ Read RUNOPT(9),...,(22)
                      lentab = lst
                      IPRDF(1) = 2
                      IPRDF(2) = 9999
  520 READ (15,1000)  RUNRUN,PARAM1,PARAM2,PARAM3,PARAM4,PARAM5,PARAM6
      IF (RUNRUN.NE.'          ') THEN
             IF (RUNRUN == 'STRUCTURE ')  then           ! STRUCTURE [9]
                   RUNOPT(9)  = 'STRUCTURE '
                   lentab = param1
                   if (lentab.lt.1)    lentab = lst
                   if (lentab.gt.LST)  lentab = lst
             end if
             IF (RUNRUN == 'NETWORK   ')  THEN            ! NETWORK [10]
                   RUNOPT(10) = 'NETWORK   '
                   NATX = 0
                   IO = PARAM1
                   IF (IO > 0.AND.IO.LE.LEE)  THEN
                         NATX = NATX + 1
                         ATMNET(NATX) = ATOM(IO)
                   END IF
                   IO = PARAM2
                   IF (IO > 0.AND.IO.LE.LEE)  THEN
                         NATX = NATX + 1
                         ATMNET(NATX) = ATOM(IO)
                   END IF
                   write (6,*) 'Network forming cation(s) is(are)', &
                               (i,atmnet(i),i=1,natx)
             END IF
!
             IF (RUNRUN == 'VELOCITY  ')  THEN           ! VELOCITY [11]
                   RUNOPT(11) = 'VELOCITY  '
                   IRECRD(9)  = INT(PARAM1)
                   PVMULT     = 50000.0D0
                   IF (PARAM2 > 0.0)   PVMULT = PARAM2
                   IF (IRECRD(9).LE.0)  IRECRD(9) = 1
             END IF
             IF (RUNRUN == 'POSITION  ')  THEN           ! POSITION [11]
                   RUNOPT(11) = 'POSITION  '
                   IRECRD(9)  = PARAM1
                   PVMULT     = 90000.D0
                   IF (PARAM2 > 0.0)   PVMULT = PARAM2
                   IF (IRECRD(9).LE.1)  IRECRD(9) = 1
             END IF
             IF (RUNRUN == 'ENERGY    ')  THEN
                   RUNOPT(11) = 'ENERGY    '
                   IRECRD(9)  = PARAM1
                   PVMULT = 1.0E12
                   IF (PARAM2 > 0)     PVMULT = PARAM2
                   IF (IRECRD(9).LE.1)  IRECRD(9) = 1
             END IF
             IF (RUNRUN == 'POSVELENE ')  THEN
                   RUNOPT(11) = 'POSVELENE '
                   IRECRD(9)  = PARAM1
                   PVMULT = 1.0E12
!                  IF (PARAM2 > 0)     PVMULT = PARAM2
                   IF (IRECRD(9).LE.1)  IRECRD(9) = 1
             END IF
             IF (RUNRUN == 'QUANTUM   ')  THEN            ! QUANTUM [12]
                   RUNOPT(12) = 'QUANTUM   '
                   CALL  QCTABL
             END IF
             IF (RUNRUN == 'PCF       '.OR. &          ! PCF or RDF.[13]
                 RUNRUN == 'RDF       ')  THEN
                   RUNOPT(13) = 'PCF       '
                   IF (PARAM1 > 0.999)  IPRDF(1) = PARAM1
                   IF (PARAM2 > 0.5 .AND. PARAM2 < 20.0)  &
                             IPRDF(2) = PARAM2*100
             END IF
             IF (RUNRUN == 'DIPOLE    ')  THEN             ! DIPOLE [14]
                   RUNOPT(14) = 'DIPOLE    '
             END IF
             IF (RUNRUN == 'CENTER    ')  THEN             ! CENTER [15]
                   RUNOPT(15) = 'CENTER  '
             END IF
             IF (RUNRUN == 'NO(MV=0)  ')  THEN           ! NO(MV=0) [16]
                   RUNOPT(16) = 'NO(MV=0)  '
             END IF
             IF (RUNRUN == 'CRYSTAL   ')  THEN            ! CRYSTAL [17]
                   RUNOPT(17) = 'CRYSTAL   '
             END IF
             IF (RUNRUN == 'BINARY    ')  THEN             ! BINARY [18]
                   RUNOPT(18) = 'BINARY    '
                   IF (RUNOPT(2) == 'START     ') THEN
                       CLOSE (19)
                       OPEN (19, FILE=FLNAME(9), STATUS='UNKNOWN', &
                             ACCESS='SEQUENTIAL', FORM='UNFORMATTED' )
                   END IF
             END IF
             IF (RUNRUN == 'PRESSURE  ')  THEN           ! PRESSURE [19]
                   RUNOPT(19) = 'PRESSURE  '
                   OPEN (27, FILE=FLNAME(13), STATUS='UNKNOWN', &
                       ACCESS='SEQUENTIAL', FORM='FORMATTED' )
                   REWIND 27
             END IF
             IF (RUNRUN == 'ELEC.FIELD')  THEN         ! ELEC.FIELD [20]
                   RUNOPT(20) = 'ELEC.FIELD'
                   MEFD   =  INT(PARAM1)          ! Mode of elec.field
                   EFD(1) = DBLE(PARAM2) *1.00D5  ! [EFD]==[V/m]
                   EFD(2) = DBLE(PARAM3) *1.00D5  ! 1 CV/m = 1 J/m
                   EFD(3) = DBLE(PARAM4) *1.00D5  !        = 10^5 erg/cm
                   EFREQ  = DBLE(PARAM5)          ! Hz
!                  write(6,*) MEFD, EFREQ
!                  write(6,*) EFD(1),EFD(2),EFD(3)
             END IF
             if (runrun == 'GRAV.FIELD')  then         ! GRAV.FIELD [21]
                   runopt(21) = 'GRAV.FIELD'
                   gfd(1)     = param1
                   gfd(2)     = param2
                   gfd(3)     = param3
             end if
             if (runrun == 'CONSTSHEAR')  then         ! CONSTSHEAR [22]
                   runopt(22) = 'CONSTSHEAR'
!                  ----- Shear rate / ps   ( dvz/drx )
!                                          ( dvz/dry )
                   STRT(1)    = param1
                   STRT(2)    = param2
                   dispzx     = param3
                   dispzy     = param4
                   IF (RUNOPT(6) == 'P SCALING '.OR. & 
                       RUNOPT(6) == 'P ANDERSEN'.OR. &
                       RUNOPT(6) == 'P SHEAR   '    )then 
                         write (6,*) 'Error ',runopt(6),runopt(22)
                         stop
                   end if
             end if
             if (runrun == 'DIATOMIC  ')  then           ! DIATOMIC [23]
                   runopt(23)  = 'DIATOMIC  '
                   DINTRA      = param1
                   IATOM2(1)   = param2
                   IATOM2(2)   = param3
                   MOLstart(1) = param2
                   MOLend(1)   = param2
                   MOLstart(2) = param3
                   MOLend(2)   = param3
                                        ZMOLE(1) = - ZIO(IATOM2(1))*2.0
                   if (iatom2(2).gt.0)  zmole(2) = - ZIO(IATOM2(2))*2.0
                   CALL  DIATOM
             end if
             if (runrun == 'MOLECULE  ')  then
                   runopt(26)  = 'MOLECULE  '
                   DINTRA      = param1
                   MOLstart(1) = param2
                   MOLend(1)   = param3
                   call  MOLECULE
             end if
             if (runrun == 'POLYATOMS ')  then
                   runopt(29)  = 'POLYATOMS '
                   DINTRA      = param1
                   MOLstart(1) = param2
                   MOLend(1)   = param3
                   call  MOLECULE
            end if
             if (runrun == 'STOPT     ')  then
                   runopt(30)  = 'STOPT     '
                   FCUT        = param1
                   FFAC        = param2
                   icons       = int(param3)
                   idirec      = int(param4)
             end if
             if (runrun  ==  'POTSURF   ') then
                   runopt(30) = 'POTSURF   '
                   DISTM  = param1
                   iato1  = param2
                   iato2  = param3
                   iarea  = param4 !iarea = 1 -> x only
                                   !iarea = 2 -> y only
                                   !iarea = 3 -> z only
                                   !iarea = 4 -> x + y
                                   !iarea = 5 -> y + z
                                   !iarea = 6 -> z + x
             end if
             if (runrun == 'THERM-INT ') then !kwkt
                   runopt(37) = 'THERM-INT '
                   lambd  = param1
                   kval   = INT(param2)
                   IATOMO = INT(param3)
                   IATOMH = INT(param4)
                   dintra = dble(param5)
                   NIONO = NION(IATOMO)
                   CALL THERMINT
                   i = 0
                   do io = 1, ncompo 
                     flam = 1.0d0
                     do i = ions(1,io),ions(2,io)
                       if (io == IATOMO .or. io == IATOMH) flam = flambd 
                       ZII(i) = flam * ZIO(io)
                     enddo 
                   enddo 
                   call COULMB
                   call VWCORR
             endif

            GOTO 520
      END IF
      WRITE (16,2030)  
      write (16,2031)(I,RUNOPT(I),I=1,8)
      write (16,2032)(I,RUNOPT(I),I=9,16)
      write (16,2032)(I,RUNOPT(I),I=17,24)
      write (16,2032)(I,RUNOPT(I),I=25,32)  !kwkt
      write (16,2032)(I,RUNOPT(I),I=33,40)  !kwkt
!     ---------------------------------------------------- Check P and V
      CALL  CHECKP
!     ------------------------------------------------------ file09p.dat
      IF (RUNOPT(2) == 'START     ')  THEN
          IF (TITLE(1).NE.'BENC' .OR.TITLE(2).NE.'HMAR' )  THEN
              IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
                  NRECRD(4) = 1
                  IF (RUNOPT(18) == 'BINARY    ') THEN
                      WRITE (19) NRECRD(4), 0, ((H(J,I),J=1,3),I=1,3)
                      WRITE (19) ((P(J,I),J=1,3),I=1,NTION)
                  ELSE
                      DO 450  I = 1, NTION
                         DO 451  J = 1, 3
                            IPV(J,I) = P(J,I) * 90000.D0
  451                    continue
  450                 ENDDO
                      DUMMY = '          '
                      WRITE (19,9002)  NRECRD(4), 0, &
                                       ((H(J,I),J=1,3),I=1,3)
                      WRITE (19,9001)  ((IPV(J,I),J=1,3),I=1,NTION)
                  END IF
              END IF
          END IF
      END IF
!     ------------------------------------------------------------- 09PV
      IF (RUNOPT(11).NE.'          ') THEN
             IF (RUNOPT(18) == 'BINARY    ') THEN
                 OPEN (28, FILE=FLNAME(12), STATUS='UNKNOWN', &
                           ACCESS='SEQUENTIAL', FORM='UNFORMATTED' )
             ELSE
                 OPEN (28, FILE=FLNAME(12), STATUS='UNKNOWN', &
                           ACCESS='SEQUENTIAL', FORM='FORMATTED' )
             END IF
             REWIND 28
             NRECRD(9) = 1
             IF (RUNOPT(11) == 'VELOCITY  ') THEN
                   IF (RUNOPT(18) == 'BINARY    ')  THEN
                        DO 550  I = 1, NTION
                           DO 551  J = 1, 3
                              VV(J,I) = V(J,I) / DTIME
  551                      continue
  550                   ENDDO
                        WRITE (28)  NRECRD(1),IRECRD(9)
                        WRITE (28)  ((VV(J,I),J=1,3),I=1,NTION)
                   ELSE
                        DO 560  I = 1, NTION
                           DO 561  J = 1, 3
                           IPV(J,I)= V(J,I)*PVMULT*1E-15/DTIME +50000.D0
  561                      continue
  560                   ENDDO
                        WRITE (28,'(I7,3X,9F7.3)')  NRECRD(1),IRECRD(9)
                        WRITE (28,9001)  ((IPV(J,I),J=1,3),I=1,NTION)
                   END IF
             END IF
             IF (RUNOPT(11) == 'POSITION  ') THEN
                   IF (RUNOPT(18) == 'BINARY    ') THEN
                       WRITE (28)  NRECRD(1),IRECRD(9), H
                       WRITE (28)  ((P(J,I),J=1,3),I=1,NTION)
                   ELSE
                       DO 580  I = 1, NTION
                          DO 581  J = 1, 3
                             IPV(J,I) = P(J,I) * PVMULT
  581                     continue
  580                  ENDDO
                       WRITE (28,9002)  NRECRD(1),IRECRD(9), H
                       WRITE (28,9001)  ((IPV(J,I),J=1,3),I=1,NTION)
                   END IF
             END IF
 9001        FORMAT (18I5)
 9002        FORMAT (I7,i3, 9F7.3)
      END IF
!     ------------------------------------------------------------------
      IF (NREM.LE.0)  GO TO 2222
      CALL  TITLET  (0, 1)
      RETURN
!
      write (*,2232)
 2222 WRITE (*,2233)  RUNOPT(2)
 2232 FORMAT (' >>>>>  The number of steps to be calculated is less', &
              ' than one  >>>>>')
 2233 format (' >>>>>  Mode=', A9,  '   Please increase the number ', &
              'of steps   >>>>>' )
      STOP
!
 1000 FORMAT (A10,6F10.5)
 1001 FORMAT (A10,15A4)
 2000 FORMAT (' I  [ ',A10,' ]',I7,' steps run from',I6,'-',A2,' step ',&
                   'to ',I7,'-',A2,' step with time step of',1PE9.2, &
                   ' sec. RDF''s at every', I6,' step I')
 2001 FORMAT (' I  [ ',A10,' ]  Temperature=',0PF7.1,' K  changed ', &
                   'with a rate of',F6.1,' K  per ',I3,' steps until', &
                   F7.1,' K   (',A8,' : ',I5,' : ',I4,') I' )
 2010 FORMAT (' I',18X,'"Mass" of Nose''s thermostat is ',E12.4, &
                             ' g.cm2',63X,'I' )
 2022 FORMAT (' I  [ ',A10,' ]  MD basic cell is fixed at the present ', &
                   'size and shape.  ', 57X, 'I')
 2020 FORMAT (' I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
                           ' GPa  using forced scaling of cell ', &
                           'dimensions.',13X,'I')
 2027 FORMAT (' I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
                           ' GPa  by Andersen''s mass ',3(1X,G10.2E3), &
                           ' g  I')
 2028 FORMAT (' I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
                           ' GPa  using forced scaling of cell ', &
                           'dimensions.',13X,'I')
 2029 FORMAT (' I    ',10X,31X,3F9.4,' GPa',45X,13X, 'I' )
 2030 format (' I',130('-'),'I')
 2031 format (' I  [Options]  ',8(I3,':',A10),'     I')
 2032 format (' I             ',8(I3,':',A10),'     I')
      END
!
!
!                                                             ==========
!============================================================== MOLECULE
      SUBROUTINE  MOLECULE
      USE PARAM
      USE CHARAC
      USE ABOXOF
      USE ATOMSI
      USE CARTES
      USE MOLECU
!
      implicit none
!     ======================================recognize diatomic molecules
!
      double precision  rx,ry,rz, dx,dy,dz
      double precision  rij2
      double precision  cut2
      integer(KIND=4)   mi(lni), ndistr(11)
      integer(KIND=4)  I,n,io,ii,nnn,jo,j1,j2,J,mmm,mmmm,m
!
      cut2 = dintra**2
      do I = 1, ntion
         mi(i) = 0
      enddo   
      do n = 1, 11
         ndistr(n) = 0
      enddo   
      nnn = 0
!------------------------------------------- calc distance between atoms
      do io = MOLstart(1), MOLend(1)
        do ii = ions(1,io), ions(2,io)
          if (mi(ii)>0) cycle 
          nnn = nnn + 1
          imole(1,nnn) = ii
          mi(ii) = 1
          mmm = 1
          do jo = io, MOLend(1)
            if (jo<0 .or. jo>ncompo) cycle 
            j1 = ions(1,jo) 
            j2 = ions(2,jo)
!            if (io == jo)  j1 = i+1
            do J = j1, j2
               if (mi(j)>0) cycle 
               mmmm = mmm
               do m = 1, mmmm
                  i = imole(m,nnn)
                  if (i == j) cycle 
                  RX = P(1,i) - P(1,j)
                  RY = P(2,i) - P(2,j)
                  RZ = P(3,i) - P(3,j)
                  if (RX<-0.5)  RX = RX + 1.0
                  if (RX> 0.5)  RX = RX - 1.0
                  if (RY<-0.5)  RY = RY + 1.0
                  if (RY> 0.5)  RY = RY - 1.0
                  if (RZ<-0.5)  RZ = RZ + 1.0
                  if (RZ> 0.5)  RZ = RZ - 1.0
!                 --------- delete these if-statements for triclinic
!                 IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                 IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                 IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                  DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                  DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                  DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!                 DX = RX * BOX(1)
!                 DY = RY * BOX(2)
!                 DZ = RZ * BOX(3)
                  RIJ2 = DX*DX + DY*DY + DZ*DZ
                  IF (RIJ2>CUT2) cycle 
                  mmm = mmm +1
                  IMOLE(mmm,nnn) = j
                  mi(j) = 1
                  exit 
               enddo   
            ENDDO
          enddo   
          mmole(nnn) = mmm
          ndistr(mmm) = ndistr(mmm) + 1
        ENDDO
      enddo   
!
      nmole = nnn
      write (6,1001)  nmole, MOLstart(1), MOLend(1)
 1001 format (' Total number of molecules is',I6, '  (',I2,'-',i2,')')
      write  (6,1002) (n,n=1,11), (ndistr(n),n=1,11)
 1002 format (' No.atoms',11I6 / ' No.moles',11I6)
      RETURN
      END
!
!
!                                                               ========
!================================================================ DIATOM
      SUBROUTINE  DIATOM
      USE PARAM
      USE CHARAC
      USE ABOXOF
      USE ATOMSI
      USE CARTES
      USE MOLECU
!
      implicit none
!     ======================================recognize diatomic molecules
!
       double precision   pix,piy,piz, pjx,pjy,pjz, rx,ry,rz, dx,dy,dz
       double precision   pjx0,pjy0,pjz0, rij2
       double precision   cut2
       integer(KIND=4)  nnn,iii,io,i1,i2,I,J,K
!
!---------------------------------------------calc distance of atoms
        cut2 = dintra**2
        nnn = 0
        do 900  iii = 1, 2
             io = iatom2(iii)
             if (io.lt.0 .or. io.gt.ncompo)  go to 900
             i1 = ions(1,io)
             i2 = ions(2,io)
            DO 810 I=i1, i2-1
                 pix = p(1,i)
                 piy = p(2,i)
                 piz = p(3,i)
                 do 800 J=i+1,i2
                 pjx0 = p(1,j)
                 pjy0 = p(2,j)
                 pjz0 = p(3,j)
                 if (pjx0.lt.pix)  pjx0 = pjx0 + 1.0
                 if (pjy0.lt.piy)  pjy0 = pjy0 + 1.0
                 if (pjz0.lt.piz)  pjz0 = pjz0 + 1.0
                 DO 250  K = 1, 8
                       pjx = pjx0 - transx(k)
                       pjy = pjy0 - transy(k)
                       pjz = pjz0 - transz(k)
                        RX = PIX - PjX
                        RY = PIY - PjY
                        RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                           DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                           DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                           DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!                        DX = RX * BOX(1)
!                        DY = RY * BOX(2)
!                        DZ = RZ * BOX(3)
                        RIJ2 = DX*DX + DY*DY + DZ*DZ
                        IF (RIJ2.LE.CUT2)  GO TO 255
  250               ENDDO
                    go to 800
!                  ----------------------------------Kumiawase of diatomic
  255                nnn = nnn +1
                     IDMOLE(1,nnn) = I
                     IDMOLE(2,nnn) = J
                     idmole(3,nnn) = iii
                     DMOLE(1,nnn) = DX
                     DMOLE(2,nnn) = Dy
                     DMOLE(3,nnn) = DZ
                     DMOLE(4,nnn) = SQRT(RIJ2)
!                  -----------------------------------P of center of mass
                    Pix=(Pix+Pjx)/2.
                    Piy=(Piy+Pjy)/2.
                    Piz=(Piz+Pjz)/2.
                    if (pix.lt.0.0)   pix = pix + 1.0
                    if (pix.gt.1.0)   pix = pix - 1.0
                    if (piy.lt.0.0)   piy = piy + 1.0
                    if (piy.gt.1.0)   piy = piy - 1.0
                    if (piz.lt.0.0)   piz = piz + 1.0
                    if (piz.gt.1.0)   piz = piz - 1.0
                    p(1,ntion+nnn) = pix
                    p(2,ntion+nnn) = piy
                    p(3,ntion+nnn) = piz
!
!                   WRITE(*,*) nnn,IDMOLE(1,nnn),IDMOLE(2,nnn),pix,piy,piz
!
  800         ENDDO
  810     continue
  900 ENDDO
      ndmole = nnn
      RETURN
      END
!
!
!                                                               ========
!================================================================ PREPAR
      SUBROUTINE  PREPAR  (FORMUL)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE PARAMT
      USE GEOMET
      USE VALUES
!
      implicit none
      double precision     FORMUL
      integer(KIND=4)  NELM
      integer(KIND=4)  IO,J,I
!     ----------------------------------- Preparing some variables, etc.
         NELM   = 0
         TWEGHT = 0.0D0
!
         DO 260  IO = 1, NCOMPO
             IONS(1,IO) = NELM + 1
             NELM       = NELM + NION(IO)
             IONS(2,IO) = NELM
             NIOND(IO)  = 0
             DO 250  J = IONS(1,IO), IONS(2,IO)
                 IF (IOND(J).NE.0)  NIOND(IO) = NIOND(IO) + 1
  250        ENDDO
             TWEGHT = TWEGHT + WIO(IO) * DBLE(NIOND(IO))
  260    ENDDO
                                             NFORML = NION(2)
                           IF (NFORML == 0)  NFORML = NION(3)
                        IF (FORMUL > 0.0)   NFORML = NION(1) / FORMUL
         FJMOL = ANA / 1.0D10 / DBLE(NFORML)
                         IF (NELM > NTION)  GO TO 4444
         IF (NELM < NTION)  WRITE (*,1004)  NELM,NTION
         NTION = NELM
!
         DO 500  I = 1, LVA
            VALMAX (I) = -9.9D19
            VALMIN (I) =  9.9D19
  500    ENDDO
!
      TPRE = TEMP
      RETURN
!
 4444 WRITE (*,4455)
 4455 FORMAT (' *****  THE NUMBER OF PARTICLES IN FILE05 IS MORE THAN ',&
              'THAT IN FILE07  *****')
      STOP
!
 1004 FORMAT (1X,'******* Warnning *****  NTION(new)=',I5,'  (old)=', &
                 I5,7('*'))
! 1111 FORMAT (15A4)
      END
!
!
!                                                               ========
!================================================================ CHECKP
      SUBROUTINE  CHECKP 
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      use molecu !kwkt
!
      IMPLICIT NONE
!
      double precision  DL,FV,TT,RL,CENTER
      integer(KIND=4)  J,IO,I,I1,I2
      integer*4       jo,no   !kwkt
!
!     ----------------------------------- Preparing some variables, etc.
!        ----------------------- Check and correct velocity and momentum
                        FV = 1.0D0
                        TT = TEMP
                        IF (TT < 0.001)  TT = 0.001
                     IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
                        FV = SQRT(TEMP/TT) * (DTIME/DTMO)
         DO 370  J = 1, 3
               DL     = 0.0D0
               DO IO = 1, NCOMPO
                  RL = 0.0D0
                  IF (NION(IO) > 0)  THEN
                           I1 = IONS(1,IO)
                           I2 = IONS(2,IO)
                           DO I = I1, I2
                              IF (IOND(I).NE.0)  RL = RL + V(J,I)
                           ENDDO
                  END IF
                  DL = DL + RL * WIO(IO)
               ENDDO
               DL     = DL / TWEGHT
               IF (RUNOPT(16) == 'NO(MV=0)  ')  THEN
                      DL = 0.0D0
               END IF
               DO I = 1, NTION
                   IF (P(J,I) < 0.0D0)  P(J,I) = P(J,I) + 1.0D0
                   IF (P(J,I).GE.1.0D0)  P(J,I) = P(J,I) - 1.0D0
                   IF (IOND(I).NE.0)     V(J,I) = (V(J,I) - DL) * FV
                   IF (IOND(I) == 0)     V(J,I) = 0.0
                   IF (P(J,I)-P0(J,I) >  0.5)  P0(J,I) = P0(J,I) + 1.0
                   IF (P(J,I)-P0(J,I) < -0.5)  P0(J,I) = P0(J,I) - 1.0
               ENDDO
               IF (RUNOPT(15) == 'CENTER    ')  THEN
                     CENTER = 0.0D0
                     DO I = 1, NTION
                         CENTER = CENTER + P(J,I)
                     ENDDO
                     CENTER = CENTER / NTION - 0.5D0
                     DO I = 1, NTION
                         P(J,I)  = P(J,I)  - CENTER
                         P0(J,I) = P0(J,I) - CENTER
                     ENDDO
               END IF
  370    ENDDO
!
         if (runopt(37) == 'THERM-INT ' .and. dintra > 0.0D0) call FIND_H2O(0) !kwkt
         if (runopt(37) == 'THERM-INT ' .and. dintra <= 0.0D0) then
           no = 0
           allocate(intr(NION(IATOMO)+NION(IATOMH)))
           do io = ions(1,IATOMO), ions(2,IATOMO)
             no = no + 1
             intr(no) = 0
             intr(no) = io
           enddo
           do jo = ions(1,IATOMH), ions(2,IATOMH)
             no = no + 1
             intr(no) = 0
             intr(no) = jo
           enddo
         endif
!
      RETURN
      END
!
!
!                                                               ========
!================================================================ TABLER
      SUBROUTINE  TABLER  (IPR)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE VECTOR
      USE TABLES
!
      implicit none
!     --------------------------------------------- Heading of MD output
!                     Preparing tables for force and energy calculations
!
      integer(KIND=4)  IPR
      integer(KIND=4)  I,IDX,J
      double precision     RIJ
      CHARACTER(LEN=63)::   LOGO1(18), LOGO2(18), LOGO3(13)
      DATA  LOGO1 / &
     '     *******               **************************          ',&
     '       ****                 ***********          ********      ',&
     '       *****                 *********              ********   ',&
     '       ******               **********               ********* ',&
     '       *******             ***********                *********',&
     '       **** ***           ************                *********',&
     '       ***   ***         *** *********                *********',&
     '       ***    ***       ***  *********    Oblique     *********',&
     '       ***     ***     ***   *********                *********',&
     '      ***       ***   ***    *********                ******** ',&
     '      ***        *******     *********                *******  ',&
     '     ****         *****      *********               *******   ',&
     '    *****          ***       *********              *******    ',&
     '    *****           *        *********             *******     ',&
     '   *******                   *********            ******       ',&
     '  ********                  ***********         ******         ',&
     '***********               ************************            R',&
     '                                                               '/
      DATA  LOGO2 / &
     '************                *************************          ',&
     '     *********                ************       *******       ',&
     '       ********               ***********           *******    ',&
     '         *******            ***  ********            ********  ',&
     '           ******         ***    ********             ******** ',&
     '            ******      ***      ********              ********',&
     '             ******   ***        ********              ********',&
     '              ********           ********   Oblique    ********',&
     '               ******            ********              ********',&
     '              ********           ********              ******* ',&
     '            ***  ******          ********             *******  ',&
     '          ***     ******         ********            *******   ',&
     '        ***        ******        ********           *******    ',&
     '      ***           ******       ********          ******      ',&
     '    ****             ******      ********        ******        ',&
     '  ******              *******   **********     ******          ',&
     '**********              ***************************           R',&
     '                                                               '/
      DATA  LOGO3 / &
     'Ms-Fortran-PowerStation Ver.4.0             Version            ',&
     '386DX+FPU/486DX/Pentium + NDP-FORTRAN/xxx   Version            ',&
     'LUNA-88K (88100+88200) + f77                Version            ',&
     'Transputer (T805) + Parallel fortran (3L)   Version            ',&
     'HP 9000 Series (PA-RISC) + f77              Version            ',&
     'IBM-AIX-FORT                                Version            ',&
     'F77 on Sony NEWS-WS                         Version            ',&
     'FTN compilar on DN10000                     Version            ',&
     'Hitachi Super Computer (S820-80)            Version            ',&
     'F77 on CRAY Super Computer                  Version            ',&
     'DEC Fortran for Windows NT                  Version            ',&
     'Fortran90 for all platform                  Version            ',&
     '                                            Version            '/
!     if (FLNAME(3) == 'Ms-Fortran    ')  logo3(1) = logo3(1)
      if (FLNAME(3) == 'NDP-FORTRAN386')  logo3(1) = logo3(2)
      IF (FLNAME(3) == 'LUNA88K       ')  LOGO3(1) = LOGO3(3)
      IF (FLNAME(3) == 'PARALLEL-F77  ')  LOGO3(1) = LOGO3(4)
      IF (FLNAME(3) == 'HP-9000       ')  LOGO3(1) = LOGO3(5)
      if (FLNAME(3) == 'IBM-AIX-FORT  ')  logo3(1) = logo3(6)
      if (FLNAME(3) == 'NEWS-F77      ')  logo3(1) = logo3(7)
      if (FLNAME(3) == 'DN10000       ')  logo3(1) = logo3(8)
      if (FLNAME(3) == 'S820-80       ')  logo3(1) = logo3(9)
      if (FLNAME(3) == 'CRAY-F77      ')  logo3(1) = logo3(10)
      if (FLNAME(3) == 'DEC Fortran   ')  logo3(1) = logo3(11)
      if (FLNAME(3) == 'F90           ')  logo3(1) = logo3(12)
      if (FLNAME(3) == 'Dummy         ')  logo3(1) = logo3(13)
!
      IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
              DO 10  I = 1, 18
                 LOGO1(I) = LOGO2(I)
   10         ENDDO
      END IF
!
      IDX = 0
      IF (RUNOPT(52) == 'H-TENSOR  ')  IDX =1
      CALL  TMATRX  (IDX)
!
      IF (RUNOPT(8).NE.'METAL     ' .and. &
          RUNOPT(8).NE.'VASHISHTA ')  CALL  COULMB
!
!     -------------------------------------------------------- LOGO mark
      IF (IPR == 1) THEN
        WRITE (16,5000)
        write (16,4999)(DBLE(NION(I))/DBLE(NFORML),ATOM(I),I=1,10)
        write (16,4997)(DBLE(NION(I))/DBLE(NFORML),ATOM(I),I=11,20)
        write (16,4998)
           WRITE (16,5001) BOX(1),BOX(4)
           write (16,5011) BOX(2),BOX(5),      LOGO1(1)
           write (16,5012) BOX(3),BOX(6),      LOGO1(2)
           write (16,5013) LOGO1(3)
           write (16,5014) DENSTY, VOL,        LOGO1(4)
           write (16,5015) LOGO1(5)
           WRITE (16,5002)           MODE,NVN, RCUT(2), LOGO1(6)
           write (16,5023) RUNOPT(8),ALPHA,    RCUT(1), LOGO1(7)
           write (16,5024) LOGO1(8)
           write (16,5025) LOGO1(9)
 5000      FORMAT(' I--', 128('-'), 'I')
 4999      FORMAT(' I  Formula = ',10(F6.3,A2,1X), 26X,'  I')
 4997      FORMAT(' I            ',10(F6.3,A2,1X), 26X,'  I')
 4998      FORMAT(' I--', 126('-'), '--I' )
 5001      FORMAT(' I  Basic cell : A=',F10.5,' A   cos(alpha)=',F9.5, &
                                                  10X,'I  ',63X, '  I')
 5011      FORMAT(' I               B=',F10.5,' A   cos(beta )=',F9.5, &
                                                  10X,'I  ',A63, '  I')
 5012      FORMAT(' I               C=',F10.5,' A   cos(gamma)=',F9.5, &
                                                  10X,'I  ',A63, '  I')
 5013      FORMAT(' I--',60('-'),'I  ', A63, '  I')
 5014      FORMAT(' I  Density   : ',F12.7,' g/cm3     Cell.Vol :', &
                                          F12.5, 3X,'I  ',A63, '  I' )
 5015      FORMAT(' I--',60('-'),'I  ',A63, '  I' )
 5002      FORMAT(' I  P-model   :   Mode=',I3,' (N(Nv)=',I4,')     ', &
                              'Rcut(S)=',F7.3,' A   I  ',A63,'  I' )
 5023      FORMAT(' I  ',A8,'  :   Alpha(EWALD)=',F6.3,' A-1   ', &
                              'Rcut(L)=',F7.3,' A   I  ',A63,'  I')
 5024      FORMAT(' I--',60('-'),'I  ', A63,'  I')
 5025      FORMAT(' I     Atom    No    Z      W      A       B', &
                          7X,'C       D    I  ',A63,'  I' )
!
           DO 110  I = 1, 8
               WRITE (16,5005) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                                    AIO(I), BIO(I), CIO(I), DIO(I), &
                                    LOGO1(I+9)
 5005          FORMAT(' I', I3, 2X, A3, I6, F8.3, F7.2, F8.4, 3F8.3, &
                                              ' I  ',A63,'  I' ) 
  110      ENDDO
               I = 9
               WRITE (16,5006) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                                    AIO(I), BIO(I), CIO(I), DIO(I), &
                                                 LOGO3(1),FLNAME(2)
               do I = 10,LEM 
               WRITE (16,5006) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                                    AIO(I), BIO(I), CIO(I), DIO(I), &
                                                   '     ', '     '
               enddo 
 5006          FORMAT(' I', I3, 2X, A3, I6, F8.3, F7.2, F8.4, 3F8.3, &
                                            ' I  ',A52,A11,'  I' ) 
      END IF
!
!     ------------------------------------------------------ Short range
            IF (RUNOPT(8) == 'METAL     ')  CALL  METALP  (IPR)
      IF (IPR == 1)  THEN
            IF (RUNOPT(8) == '          ')  CALL  BUSING
            IF (RUNOPT(8) == 'BUSING    ')  CALL  BUSING
            IF (RUNOPT(8) == 'STSUNE    ')  CALL  BUSING
            IF (RUNOPT(8) == 'MORSE     ')  CALL  MORSEP
            IF (RUNOPT(8) == 'MORSE-PL  ')  CALL  MORSEP
            IF (RUNOPT(8) == 'MORSE-AT  ')  CALL  MORSEP
            IF (RUNOPT(8) == 'BMH-EXP   ')  CALL  BMHEXP(0)
            IF (RUNOPT(8) == 'BMH-EXP*  ')  CALL  BMHEXP(0)
            IF (RUNOPT(8) == 'BELONO    ')  CALL  MORSEP
            IF (RUNOPT(8) == 'TOSIFUMI  ')  CALL  TOSIFU
            IF (RUNOPT(8) == 'WOODCOCK  ')  CALL  ANGELP
            IF (RUNOPT(8) == 'PAULING   ')  CALL  ANGELP
            IF (RUNOPT(8) == 'VASHISHTA ')  CALL  VASHIS
            IF (RUNOPT(8) == 'L-J       ')  CALL  LJMODL
!
            IF (RUNOPT(3) == 'DETAIL    ') THEN
                  DO 200 I = 70, 300, 10
                      RIJ = I * 0.01
                      WRITE (16,6666)  RIJ, E0(I)*1E8, &
                                       (E1(I,J)*1E8,J=1,NPAIR)
  200             ENDDO
                  WRITE (16,6666)
                  DO 210 I = 70, 300, 10
                      RIJ = I * 0.01
                      WRITE (16,6666) RIJ,F0(I),(F1(I,J),J=1,NPAIR)
  210             ENDDO
 6666             FORMAT (2X,F5.2,1X,F10.6,1X,10F11.7)
            END IF
      END IF
!
      ECORR = 0.0
      VCORR = 0.0
      IF (RUNOPT(8) == '          ' .OR. RUNOPT(8) == 'BUSING    ' .OR.& 
          RUNOPT(8) == 'STSUNE    ' .OR. RUNOPT(8) == 'MORSE     ' .OR.&
          RUNOPT(8) == 'MORSE-PL  ' .OR. RUNOPT(8) == 'MORSE-AT  ' .OR.&
          RUNOPT(8) == 'BMH-EXP   ' .OR. RUNOPT(8) == 'BELONO    ' .OR.& 
          RUNOPT(8) == 'BMH-EXP*  ' .OR. & 
          RUNOPT(8) == 'TOSIFUMI  ' .OR. RUNOPT(8) == 'WOODCOCK  ' .OR.&
          RUNOPT(8) == 'PAULING   ' .OR. RUNOPT(8) == 'L-J       ') THEN
            CALL  VWCORR
      END IF
      RETURN
      END
!
!
!                                                               ========
!================================================================ TMATRX
      SUBROUTINE  TMATRX  (IDX)
      USE PARAM , only : LSR
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE CARTES
!
      IMPLICIT NONE
      integer(KIND=4)  IDX
!
      double precision      SINA(3), COSA(3), DET, GG, BOXIJ
      integer(KIND=4)   I,N,J,K,K1,K2
!
!
!     -- (0,0,0),(1,0,0),(0,1,0),(0,0,1),(1,1,0),(1,0,1),(0,1,1),(1,1,1)
!
      N = 0
      DO  I = 0, 1
         DO  J = 0, 1
            DO  K = 0, 1
               N = N + 1
               TRANSX(N) = DBLE(I)
               TRANSY(N) = DBLE(J)
               TRANSZ(N) = DBLE(K)
            ENDDO   
         ENDDO   
      ENDDO
!
      IF (IDX /= 0)  THEN
             DO I = 1, 3
                 BOX(I) = SQRT(H(1,I)**2 + H(2,I)**2 + H(3,I)**2)
             ENDDO
             DO 68  I = 1, 3
                 K1 = 2
                 K2 = 3
                 IF (I == 2)  THEN
                       K1 = 1
                       K2 = 3
                 ELSE IF (I == 3)  THEN
                       K1 = 1
                       K2 = 2
                 END IF
                 BOXIJ= H(1,K1)*H(1,K2)+H(2,K1)*H(2,K2)+H(3,K1)*H(3,K2)
                 COSA(I) = BOXIJ / (BOX(K1)*BOX(K2))
                 BOX(I+3) = COSA(I)
                 SINA(I) = SQRT(1.0D0 - COSA(I)**2)
   68        ENDDO
             GO TO 150
      END IF
!
!     ---------------------------- cos and sin of alpha, beta, and gamma
      DO I = 1, 3
          COSA(I) = BOX(I+3)
          IF (BOX(I+3) > 1.0)  THEN
               COSA(I) = COS(BOX(I+3)*PI/180.0D0)
               BOX(I+3) = COSA(I)
          END IF
          SINA(I) = SQRT(1.0D0 - COSA(I)**2)
      ENDDO
!
!     ------------------ Transformation matrix from crystal to Cartesian
!
      H(1,3) =  0.0D0
      H(2,3) =  0.0D0
      H(3,3) =  BOX(3)
      H(1,2) =  0.0D0
      H(2,2) =  BOX(2)*SINA(1)
      H(3,2) =  BOX(2)*COSA(1)
      H(3,1) =  BOX(1)*COSA(2)
!c    H(2,1) =  BOX(1)*COSA(3)*SINA(1)
!c    H(1,1) =  BOX(1)*SQRT(1.0D0-COSA(2)**2-(COSA(3)*SINA(1))**2)
      H(2,1) = -BOX(1)*(COSA(1)*COSA(2)-COSA(3))/SINA(1)
      H(1,1) = BOX(1)*SQRT(1-COSA(1)**2-COSA(2)**2-COSA(3)**2+ &
                                 2*COSA(1)*COSA(2)*COSA(3))/SINA(1)
              VOL = H(3,1)*(H(1,2)*H(2,3) - H(2,2)*H(1,3)) - &
                    H(2,1)*(H(1,2)*H(3,3) - H(3,2)*H(1,3)) + &
                    H(1,1)*(H(2,2)*H(3,3) - H(3,2)*H(2,3))
              IF (VOL.LE.0.0D0)  THEN
                      H(1,1) = - H(1,1)
                      H(2,1) = - H(2,1)
                      H(3,1) = - H(3,1)
                      VOL    = - VOL
              END IF
!
!             WRITE (*,*)  H(1,1), H(2,1), H(3,1)
!             WRITE (*,*)  H(1,2), H(2,2), H(3,2)
!             WRITE (*,*)  H(1,3), H(2,3), H(3,3)
!             WRITE (*,*)  VOL
!
!     ------------------ Transformation matrix from Cartesian to crystal
!
  150     CALL  INVERS  (H, DET, HINV)
!
!             WRITE (*,*)  HINV(1,1), HINV(2,1), HINV(3,1)
!             WRITE (*,*)  HINV(1,2), HINV(2,2), HINV(3,2)
!             WRITE (*,*)  HINV(1,3), HINV(2,3), HINV(3,3)
!
              VOL    = DET
              DENSTY = TWEGHT / (ANA * VOL * 1.0D-24)
!
!     ---------------------------------------------------- Metric tensor
              DO 180  I = 1, 3
                  DO 181  J = 1, 3
                      GG = 0.0D0
                      DO 170  K = 1, 3
                          GG = GG + H(K,J) * H(K,I)
  170                 ENDDO
                      G(J,I) = GG
  181             continue
  180         ENDDO
              CALL  INVERS  (G, DET, GINV)
!
!     --------------------------------------- Reciprocal cell parameters
      RBOX(1) =  BOX(2)*BOX(3)*SINA(1) / VOL
      RBOX(2) =  BOX(1)*BOX(3)*SINA(2) / VOL
      RBOX(3) =  BOX(1)*BOX(2)*SINA(3) / VOL
      RBOX(4) = (COSA(2)*COSA(3)-COSA(1)) / (SINA(2)*SINA(3))
      RBOX(5) = (COSA(1)*COSA(3)-COSA(2)) / (SINA(1)*SINA(3))
      RBOX(6) = (COSA(1)*COSA(2)-COSA(3)) / (SINA(1)*SINA(2))
!     ---------------------------------------
      IF (RCUT(1) < 0.01)          RCUT(1)  = 15.0d0
      IF (RCUT(1) > 1.0/RBOX(1)/2) RCUT(1)  = 1.0D0/RBOX(1)/2.0D0
      IF (RCUT(1) > 1.0/RBOX(2)/2) RCUT(1)  = 1.0D0/RBOX(2)/2.0D0
      IF (RCUT(1) > 1.0/RBOX(3)/2) RCUT(1)  = 1.0D0/RBOX(3)/2.0D0
                                    NRCUT(1) = INT(RCUT(1)*100.0 + 2.5)
!     IF (NRCUT(1) < LSR)          NRCUT(1) = LSR
      IF (MXCUT > NRCUT(1))        MXCUT    = NRCUT(1)
      IF (RCUT(2) < 0.01)          RCUT(2)  = 7.5D0
      IF (RCUT(2) > RCUT(1))       RCUT(2)  = RCUT(1)
      IF (RCUT(2) > (LSR-1)*0.01)  RCUT(2)  = (LSR-1)*0.01D0
                                    NRCUT(2) = INT(RCUT(2)*100.0 +3.01)
      RETURN
      END
!
!
!                                                               ========
!================================================================ INVERS
      SUBROUTINE  INVERS  (X, DET, XINV)
!     -------------------------------------------- Given 3 by 3 matrix X
!                             Store determinant at D and inverse at Xinv
      IMPLICIT NONE
!
      double precision   DET, X(3,3), XINV(3,3)
!
      DET = X(1,1)*X(2,2)*X(3,3) + X(1,2)*X(2,3)*X(3,1) + &
            X(1,3)*X(2,1)*X(3,2) - X(1,3)*X(2,2)*X(3,1) - &
            X(1,2)*X(2,1)*X(3,3) - X(1,1)*X(2,3)*X(3,2)
      IF (DET == 0.0D0)  GO TO 10
         XINV(1,1) = (X(2,2)*X(3,3) - X(3,2)*X(2,3)) / DET
         XINV(1,2) = (X(3,2)*X(1,3) - X(1,2)*X(3,3)) / DET
         XINV(1,3) = (X(1,2)*X(2,3) - X(2,2)*X(1,3)) / DET
         XINV(2,1) = (X(2,3)*X(3,1) - X(3,3)*X(2,1)) / DET
         XINV(2,2) = (X(3,3)*X(1,1) - X(1,3)*X(3,1)) / DET
         XINV(2,3) = (X(1,3)*X(2,1) - X(2,3)*X(1,1)) / DET
         XINV(3,1) = (X(2,1)*X(3,2) - X(3,1)*X(2,2)) / DET
         XINV(3,2) = (X(3,1)*X(1,2) - X(1,1)*X(3,2)) / DET
         XINV(3,3) = (X(1,1)*X(2,2) - X(2,1)*X(1,2)) / DET
      RETURN
!     --------------------------------------------- TEST FOR SINGULARITY
  10         IF (DET == 0)  WRITE  (*,6180)
6180         FORMAT(5X,'*** The matrix is singular ***')
      RETURN
      END
!
!
!                                                               ========
!================================================================ PTOXYZ
!
      SUBROUTINE  PTOXYZ  (I)
      USE ATOMSI
      USE CARTES
      IMPLICIT NONE
!
      integer(KIND=4)  I
      double precision     PX,PY,PZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CRYSTAL TO CARTESIAN (X,Y,Z)
!
                PX = P(1,I)
                PY = P(2,I)
                PZ = P(3,I)
        Q(1,I)  = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
        Q(2,I)  = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
        Q(3,I)  = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!
                PX = P0(1,I)
                PY = P0(2,I)
                PZ = P0(3,I)
        Q0(1,I) = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
        Q0(2,I) = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
        Q0(3,I) = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
      RETURN
      END
!
!
!                                                               ========
!================================================================ XYZTOP
!
      SUBROUTINE  XYZTOP
      USE ATOMSI
      USE CARTES
      IMPLICIT NONE
!
      double precision     QX,QY,QZ
      integer(KIND=4)  I
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CARTESIAN (X,Y,Z) TO CRYSTAL
!
      DO 100  I = 1, NTION
               QX = Q(1,I)
               QY = Q(2,I)
               QZ = Q(3,I)
          P(1,I)  = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
          P(2,I)  = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
          P(3,I)  = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
!
               QX = Q0(1,I)
               QY = Q0(2,I)
               QZ = Q0(3,I)
          P0(1,I) = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
          P0(2,I) = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
          P0(3,I) = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
  100 ENDDO
      RETURN
      END
!
!
!                                                               ========
!================================================================ COULMB
      SUBROUTINE  COULMB
      USE PARAM
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE CARTES
      USE VECTOR
      USE TABLES
      use thrmint !kwkt
      use molecu  !kwkt
      use charac  !kwkt
      use WORK02  !kwkt
!
      implicit none
!     ------------------------------------ Table for Coulomb interaction
!
      double precision        XN,FCT, AL2PI,RIJ,ARIJ,PIAL2,VN2,EXPVN
      double precision        YN,UCT, ELC2,ASP,ERFC,PAAV2,alphal
      double precision        ZN,PCT, Z, X0,X1,X2,X3,Y0,Y1,Y2,Y3,Y4
      double precision        XNN,YNN,ZNN,PCTEXV
      double precision        AZ,AMAXNV2,ABC2,AB
      integer(KIND=4)     MXNV(6)
      integer(KIND=4)     MAXNV2
      integer(KIND=4)     I,IO,IL,JL,KL,IL2,JL2,KL2,II,KX,JJ,KY
      integer(KIND=4)     KK,KZ
!              MODE       1     2     3     4     5     6         
!     MAXIMUM of NV**2    7          15    23    28    31   39    
      DATA  MXNV   /      7,   11,   15,   23,   28,   31        /
!     No. of NVs         40    85   125   230   309   369   510   
!
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
      DATA  X0,X1,X2,X3   / 10.00464D0, 8.426553D0, 3.460259D0, .5623536D0     /
      DATA  Y0,Y1,Y2,Y3,Y4/ 10.00464D0, 19.71558D0, 15.70229D0, 6.090749D0, 1.0D0/
!
      ELC2   = ELC**2
      DO I = 10, NRCUT(1)+1
          E0(I) = 0.0D0
          F0(I) = 0.0D0
      ENDDO
      NVN    = 0
      UCSELF = 0.0D0
!
      do i = 1, ntion+ndmole  !WATER-POL !kwkt
        ZIIA(i) = 0.0D0
      enddo
!
      DO IO = 1, LEL
          ZIA(IO) = 0.0D0
      ENDDO
      az = 0.0D0
      do io = 1, ncompo
         az = az + abs(zio(io))
      enddo   
      IF (MODE <= -998 .or. az <  0.00001d0)  RETURN
!     --------------------------------------- Gaussian (alpha) parameter
                       MAXNV2 = ABS(MODE)
                      AMAXNV2 = DBLE(MAXNV2)
      IF (MAXNV2 <= 6)  THEN
             IF (MAXNV2 <= 0)  MAXNV2 = 1
             AMAXNV2 = DBLE(MXNV(MAXNV2))
      END IF
      ABC2  = AMAXNV2 /(RCUT(1)*2.0D0)**2 * 1.0001D0
      AB    = SQRT(ABC2)
      IF (ALPHA < 0.001D0) THEN
             ALPHAL  = AMAXNV2 * 0.064D0 + 3.714D0 + &
                       RCUT(1) * 2.0D0 * 0.027D0
             ALPHA   = ALPHAL / (RCUT(1)*2.0D0)
      END IF
!     ------------------------------------------------------ Coulomb [1]
      AL2PI = 2.0D0 * ALPHA / SQRT(PI)
      DO I = 10, NRCUT(1)+3
          RIJ  = DBLE(I) * 0.01D0
          ARIJ = 1.0D0 / RIJ
!                                --- FUNCTION ERFC(X) : VERSION 5662
!                                ---    in "COMPUTER APPROXIMATIONS"
                                 Z = ABS(ALPHA * RIJ)
                                 ERFC = EXP(-Z*Z) * &
                                        (X0+Z*(X1+Z*(X2+Z*X3))) / &
                                        (Y0+Z*(Y1+Z*(Y2+Z*(Y3+Z*Y4))))
                                 ERFC = SIGN(ERFC,Z)
                                 IF (Z < 0.0D0)  ERFC = 2.0D0 + ERFC
          E0(I) = ERFC * (ARIJ*1.0D8) * ELC2
          F0(I) = ( AL2PI * EXP(-(ALPHA*RIJ)**2) * RIJ + ERFC ) * &
                                        (ARIJ*1.0D8)**2 * ELC2 * ARIJ
      ENDDO
!     ------------------------------------------------------ Coulomb [2]
!                        Generate reciprocal vectors for EWALD summation
!                                                  Semi-sphere part only
      FCT   = 4.0D0 * ELC2 *  1.0D-8  / (VOL*1.0D-24)
      UCT   = 2.0D0 * ELC2 *  1.0D-16 / (PI * VOL*1.0D-24)
      PCT   = 2.0D0 * ELC2 *  1.0D-16 / (2.0D0 * PI * VOL*1.0D-24)
      PIAL2 = PI**2 / ALPHA**2
            IL  = INT(BOX(1) * AB + 1.5d0)
            JL  = INT(BOX(2) * AB + 1.5d0)
            KL  = INT(BOX(3) * AB + 1.5d0)
            IL2 = IL * 2 + 1
            JL2 = JL * 2 + 1
            KL2 = KL + 1
!
      DO 270  II = 1, IL2
              KX = IL + 1 - II
          DO 260  JJ = 1, JL2
                  KY = JL + 1 - JJ
              DO 250  KK =  1, KL2
                      KZ = KK - 1
                  IF (KZ > 0) GO TO 230
                  IF (KY < 0) GO TO 250
                  IF (KY == 0 .AND. KX.LE.0) GO TO 250
  230             XN = HINV(1,1)*KX + HINV(2,1)*KY + HINV(3,1)*KZ
                  YN = HINV(1,2)*KX + HINV(2,2)*KY + HINV(3,2)*KZ
                  ZN = HINV(1,3)*KX + HINV(2,3)*KY + HINV(3,3)*KZ
                  VN2 = XN**2 + YN**2 + ZN**2
                  IF (VN2 > ABC2)  GO TO 250
                  NVN = NVN + 1
                  IF (NVN > LNV)  THEN
                        WRITE  (*,9901)  ABS(MODE)
 9901                   FORMAT (' *****  SET [MODE] LESS THAN ',I2, &
                                '  *****')
                        STOP
                  END IF
                  NVEC(1,NVN) = KX
                  NVEC(2,NVN) = KY
                  NVEC(3,NVN) = KZ
                  VEC(1,NVN)  = XN
                  VEC(2,NVN)  = YN
                  VEC(3,NVN)  = ZN
                  XNN = HINV(1,1)*XN + HINV(1,2)*YN + HINV(1,3)*ZN
                  YNN = HINV(2,1)*XN + HINV(2,2)*YN + HINV(2,3)*ZN
                  ZNN = HINV(3,1)*XN + HINV(3,2)*YN + HINV(3,3)*ZN
                                   EXPVN = EXP(- VN2 * PIAL2) / VN2
                  FNV(NVN) = FCT * EXPVN
                  UNV(NVN) = UCT * EXPVN
                                   PAAV2  = 2.0D0 * (PIAL2 + 1.0D0/VN2)
                                   PCTEXV = PCT * EXPVN
                  PNV(1,1,NVN)= PCTEXV* H(1,1)*(HINV(1,1)-PAAV2*XNN*XN)
                  PNV(2,1,NVN)= PCTEXV* H(1,2)*(HINV(1,2)-PAAV2*XNN*YN)
                  PNV(3,1,NVN)= PCTEXV* H(1,3)*(HINV(1,3)-PAAV2*XNN*ZN)
                  PNV(1,2,NVN)= PCTEXV* H(2,1)*(HINV(2,1)-PAAV2*YNN*XN)
                  PNV(2,2,NVN)= PCTEXV* H(2,2)*(HINV(2,2)-PAAV2*YNN*YN)
                  PNV(3,2,NVN)= PCTEXV* H(2,3)*(HINV(2,3)-PAAV2*YNN*ZN)
                  PNV(1,3,NVN)= PCTEXV* H(3,1)*(HINV(3,1)-PAAV2*ZNN*XN)
                  PNV(2,3,NVN)= PCTEXV* H(3,2)*(HINV(3,2)-PAAV2*ZNN*YN)
                  PNV(3,3,NVN)= PCTEXV* H(3,3)*(HINV(3,3)-PAAV2*ZNN*ZN)
  250         ENDDO
  260     ENDDO
  270 ENDDO
!     ------------------------------------------------------ Coulomb [3]
      ASP = - (ALPHA*1.0D8) * ELC2 / SQRT(PI)
      DO IO = 1, NCOMPO
          flam = 1.0D0  !kwkt
          if (RUNOPT(37) == 'THERM-INT ') then
             if (IO == IATOMO .or. IO == IATOMH) then
               flam = flambd
             endif
          endif
          UCSELF     = UCSELF + DBLE(NION(IO))*ZIO(IO)**2*ASP*flam**2
          UCSLFI(IO) =          DBLE(NION(IO))*ZIO(IO)**2*ASP*flam**2 
          ZIA(IO)    =                 2.0D0  *ZIO(IO)**2*ASP/flam**2
      ENDDO
      do I = 1, NTION+ndmole                   !WATER-POL
        ZIIA(I) = ZII(I)*ZII(I)*ASP*2.0D0
        ZIIC(I) = ZIIA(I) !/2.0D0
      enddo
      RETURN
      END
!
!
!                                                               ========
!================================================================ VWCORR
      SUBROUTINE  VWCORR
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE VECTOR
      use thrmint !kwkt
      use molecu  !kwkt
!
!     --------- Correction of energy and pressur for Van der Waals terms
!
      implicit none
!
      double precision   pi4, SATOMS
      integer(KIND=4)  N,I,J
!
      PI4 = 4.0D0 * PI
!     BETA  = CAL * 1.0D10 / ANA
!     IF (RUNOPT(8) == 'TOSIFUMI  ')  BETA = 1.0D-19 * 1.0D7
      ECORR = 0.0D0
      VCORR = 0.0D0
          N = 0
      DO 230  I = 1, NCOMPO
          DO 220  J = 1, I
!
              flam = 1.0D0 !kwk   !kwkt
              if (runopt(37) == 'THERM-INT ') then
                if (I == IATOMO .or. I == IATOMH .or. J == IATOMO .or. J == IATOMH)  then
                  flam=flambd
                endif
                if (I == IATOMO .and. J == IATOMO) flam=1.0d0
                if (I == IATOMO .and. J == IATOMH) flam=1.0d0
                if (I == IATOMH .and. J == IATOMO) flam=1.0d0
                if (I == IATOMH .and. J == IATOMH) flam=1.0d0
              endif
!
              N = N + 1
              SATOMS = NION(I) * NION(J) / VOL * PI4
              IF (I == J)  SATOMS = SATOMS / 2.0D0
              ECORR = ECORR -       SATOMS*CIJ(N) / 3.0D0 / RCUT(1)**3 *flam & !kwkt
                            -       SATOMS*DIJ(N) / 5.0D0 /  RCUT(1)**5 *flam !kwkt
              VCORR = VCORR - 6.0D0*SATOMS*CIJ(N) / 3.0D0 / RCUT(1)**3 *flam & !kwkt
                            - 8.0D0*SATOMS*DIJ(N) / 5.0D0 / RCUT(1)**5 *flam !kwkt
              IF (RUNOPT(8) == 'MORSE-PL  ')  THEN
                    ECORR = ECORR -     SATOMS*D4IJ(N) / RCUT(1) *flam & !kwkt
                                  -   SATOMS*D7IJ(N) / 4.0 / RCUT(1)**4 *flam !kwkt
                    VCORR = VCORR - 4.0*SATOMS*D4IJ(N) / RCUT(1) *flam & !kwkt
                                - 7.0*SATOMS*D7IJ(N) / 4.0 / RCUT(1)**4 *flam !kwkt
              END IF
  220     ENDDO
  230 ENDDO
!     WRITE (*,1000) ECORR*FJMOL,
!    *               VCORR / (3.0D0*VOL*1.0D-24)*1.0D-10
!1000 FORMAT (11X, 'Ecorr=',F7.3,'kJ/mol       Pcorr=',F6.3,'GPa')
      RETURN
      END
!
!
!                                                               ========
!================================================================ BUSING
      SUBROUTINE  BUSING
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE TABLES
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!
      implicit none
!
      double precision   BETA,EX,RIJ,ARIJ,ARB
      integer(KIND=4)  I,II,J,N
!
      BETA = CAL * 1.0D10 / ANA
!
      N = 0
      DO 110  I = 1, NCOMPO
              II = I
          DO 100 J = 1, II
!             N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
              N = N + 1
              ZIJ(N) = ZIO(II)*ZIO(J)
              AIJ(N) = ABS(AIO(II) + AIO(J))
              BIJ(N) = ABS(BIO(II) + BIO(J))
              CIJ(N) = CIO(II) * CIO(J) * BETA
              DIJ(N) = DIO(II) * DIO(J) * BETA
              D4IJ(N) = 0.0D0
              D7IJ(N) = 0.0D0
              IF (RUNOPT(8) == 'STSUNE    ')  THEN
                    IF (I == J .AND. ATOM(I) == 'SI  ')  CIJ(N) = 0.0D0
              END IF
  100     ENDDO
  110 ENDDO
!
      DO 150  I = 10, NRCUT(2)
          RIJ  = DBLE(I) * 0.01D0
          ARIJ = 1.0D0 / RIJ
          DO 140  J = 1, LEE
              E1(I,J) = 0.0D0
              F1(I,J) = 0.0D0
              IF (ABS(AIJ(J)) < 1.0E-5)  GO TO 140
                  EX = 0.0D0
                  IF (BIJ(J) > 0.0001)  THEN
                         ARB = (AIJ(J) - RIJ) / BIJ(J)
                         IF (ARB > -128.0)  EX = EXP(ARB)
                  END IF
                  E1(I,J) = BETA * BIJ(J)*EX 
!    *                        - CIJ(J)*ARIJ**6
                  F1(I,J) = BETA * EX * 1.0D8 * ARIJ
!                 F1(I,J) = (BETA * EX - 6.0D0*CIJ(J)*ARIJ**7) * 
!    *                             1.0D8 * ARIJ
  140     ENDDO
  150 ENDDO
!
      RETURN
      END
!
!
!                                                                =======
!================================================================ MORSEP
SUBROUTINE  MORSEP
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use pmorse
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!                                                    plus MORSE function
!                                                    plus three body
!
!
  double precision    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  double precision    EX, ARB, ZFORML(LEM), epsij(lef), sepij(lef)
  double precision    DIJP,BEIJP,RSIJP,R3BG,R3BLIM2,R3BGRD2,ELC2
  CHARACTER *40   FMT1, FMT2
  integer*4  I,N,II,J,IP,JP,KP,IJ,LCOMPO,LPAIR
!
  ELC2 = ELC * ELC
  BETA = CAL * 1.0D10 / ANA
!
  N3BP = 0
  DO I = 1, l3p
    I3BP(1,I) = 0
    i3BP(2,I) = 0
    i3bp(3,i) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO  J = 1, II
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0 * ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J) * ELC2 * 1.0D8
      DMIJ(N) = 0.0
      BEIJ(N) = 0.0
      RSIJ(N) = 0.0
      RSWTCH(N) = 0.0
      epsij(n)  = 1.0
      sepij(n)  = 1.0
    enddo
  enddo
!
  IF (RUNOPT(8) == 'MORSE     '.OR.RUNOPT(8) == 'MORSE-AT  '.OR.  &
      RUNOPT(8) == 'BELONO    ' )  THEN
120        READ   (15,5555)  IP,JP, KP, DIJP, BEIJP, RSIJP, R3BG
5555        FORMAT (3I2,4X,5F10.0)
    IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
    IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
    IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
    IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
      IF (KP == 0)  THEN
        IF (JP > IP)  THEN
          IJ = IP
          IP = JP
          JP = IJ
        END IF
        N = (IP - 1) * IP / 2 + JP
        DMIJ(N) = DIJP
        BEIJ(N) = BEIJP
        RSIJ(N) = RSIJP
        RSWTCH(N) = R3BG
      ELSE IF (IP == KP) THEN
        N3BP = N3BP +1
        I3BP(1,N3BP) = iP
        i3BP(2,N3BP) = jP
        i3BP(3,N3BP) = KP
!       -------------------------------------- F:kJ/mol
        FK3BP(N3BP)  = DIJP
        ANG3BP(N3BP) = BEIJP
        R3BLIM(1,N3BP) = RSIJP
        R3BGRD(1,N3BP) = R3BG
        IF (ANG3BP(N3BP) <= 0.01)   ANG3BP(N3BP)  =90.0
        IF (R3BLIM(1,N3BP) <= 0.01) R3BLIM(1,N3BP)= 1.2
        IF (R3BGRD(1,N3BP) <= 0.01) R3BGRD(1,N3BP)=20.0
        R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
        R3BGRD(2,N3BP) = R3BGRD(1,N3BP)
      ELSE IF (IP /= KP) THEN
        N3BP = N3BP +1
        I3BP(1,N3BP) = iP
        i3BP(2,N3BP) = jP
        i3BP(3,N3BP) = KP
!       ------------------------------------ F:kJ/mol
        FK3BP(N3BP)    = DIJP
        ANG3BP(N3BP)   = BEIJP
        R3BLIM(1,N3BP) = RSIJP
        R3BGRD(1,N3BP) = R3BG
        IF (ANG3BP(N3BP) <= 0.01)   ANG3BP(N3BP)  =90.0
        IF (R3BLIM(1,N3BP) <= 0.01) R3BLIM(1,N3BP)= 1.2
        IF (R3BGRD(1,N3BP) <= 0.01) R3BGRD(1,N3BP)=20.0
        READ (15,5566)  R3BLIM2, R3BGRD2
 5566   FORMAT (30X,2F10.0)
        IF (R3BLIM2 <= 0.01) R3BLIM2 = R3BLIM(1,N3BP)
        IF (R3BGRD2 <= 0.01) R3BGRD2 = R3BGRD(1,N3BP)
        R3BLIM(2,N3BP) = R3BLIM2
        R3BGRD(2,N3BP) = R3BGRD2
      ELSE
        STOP 'Something wrong in potetial param.'
      END IF
      GO TO 120
    END IF
    if (runopt(8) == 'BELONO    ') then
      read (15,5577)  zforml
 5577               format (10f5.0)
      N = 0
      DO I = 1, NCOMPO
        II = I
        DO J = 1, II
          N = N + 1
          epsij(N)  = ABS(zio(II)/zforml(II))*abs(zio(J) /zforml(J))
          sepij(N)  = SQRT(1.0 - epsij(N))
        enddo
      enddo
    end if
    LCOMPO = NCOMPO
    IF (LCOMPO > 7)  LCOMPO = 7
    LPAIR  = LCOMPO*(LCOMPO+1)/2
    FMT1 = '( 3H I ,9X,    3(5X,A2,1H-,A2),90X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,   3F10.3,    90X,1HI )'
    IF (NCOMPO == 3) THEN
      FMT1 = '( 3H I ,9X,    6(5X,A2,1H-,A2),60X,1HI )'
      FMT2 = '( 3H I ,4X,A4,1X,   6F10.3,    60X,1HI )'
    ELSE IF (NCOMPO == 4) THEN
      FMT1 = '( 3H I ,9X,  10(5X,A2,1H-,A2), 20X,1HI )'
      FMT2 = '( 3H I ,4X,A4,1X,  10F10.3,    20X,1HI )'
    ELSE IF (NCOMPO == 5) THEN
      FMT1 = '( 3H I ,7X,   15(3X,A2,1H-,A2), 2X,1HI )'
      FMT2 = '( 3H I ,2X,A4,1X,   15F8.2,     2X,1HI )'
    ELSE IF (NCOMPO == 6) THEN
      FMT1 = '( 3H I ,3X,   21(1X,A2,1H-,A2),    1HI )'
      FMT2 = '( 3H I ,A3,         21F6.2,        1HI )'
    ELSE IF (NCOMPO == 7) THEN
      FMT1 = '( 3H I ,5X,   28(1X,A1,1H-,A1),12X,1HI )'
      FMT2 = '( 3H I ,1X,A4,1X,  28F4.1,     12X,1HI )'
    END IF
    WRITE (16, 6661)
 6661        FORMAT ('I  ', 60(' '), 'I--', 63('-'), '--I' )
    WRITE (16,FMT1)  ((ATOM(I),ATOM(J),J=1,I),I=1,LCOMPO)
    WRITE (16,FMT2)  'Dij ', (DMIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'BEij', (BEIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'RSij', (RSIJ(J),J=1,LPAIR)
    if (RUNOPT(8) == 'BELONO    ')  then
      write (16,fmt2)  'EPij', (EPSij(J),J=1,LPAIR)
      write (16,fmt2)  'SEij', (SEPij(J),J=1,LPAIR)
    end if
    if (N3BP > 0)  THEN
      WRITE (16,6666)
 6666           FORMAT ('I  ',60(' '),'   ', 63(' '),'  I' / &
                        'I',5X,'3-body potential   ATOM(J)--ATOM(I)', &
                        '--ATOM(J)      FK3BP       ANG3BP           ', &
                        '  R3BLIM ', &
                        '   R3BGRD      R3LIM  ',15X, 'I')
      DO N = 1, N3BP
        IF (I3BP(2,N)*i3BP(1,N) > 0) THEN
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-6)/R3BGRD(1,N) + R3BLIM(1,N)
        IF (runopt(34) == 'WATER-POL ') then
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,N) + R3BLIM(1,N)
        endif
          r3lim(2,n) = r3lim(1,n)
          if (r3limax < r3lim(1,n))  r3limax=r3lim(1,n)
          WRITE (16,6667)  ATOM(i3BP(1,N)), i3BP(1,N),  &
                                        ATOM(I3BP(2,N)), I3BP(2,N),  &
                                        ATOM(i3BP(3,N)), i3BP(3,N),  &
                               FK3BP(N),ANG3BP(N),i3bp(2,n),i3bp(1,n),  &
                               R3BLIM(1,N), R3BGRD(1,N), R3LIM(1,n)
 6667                  FORMAT ('I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
                                I2,')--',A2,'(',I2,')', F15.8, F11.3,  &
                                i6,'-',i2, 2F10.3, F12.4,16X, 'I')
          if (i3BP(1,N) /= i3BP(3,N)) then
            R3LIM(2,n) = DLOG(0.999999D0/1.0D-6) / R3BGRD(2,N) + R3BLIM(2,N)
        IF (runopt(34) == 'WATER-POL ') then
            R3LIM(2,n) = DLOG(0.999999D0/1.0D-8) / R3BGRD(2,N) + R3BLIM(2,N)
        endif
            if (r3limax < r3lim(2,n)) r3limax=r3lim(2,n)
            WRITE (16,6668)  i3bp(2,n),i3bp(3,n),R3BLIM(2,N),R3BGRD(2,N), R3LIM(2,n)
 6668       FORMAT ('I',73X, i6,'-',i2, 2F10.3, F12.4,16X, 'I')
          end if
        END IF
      enddo
    END IF
  END IF
!
  DO I = 10, NRCUT(2)
    RIJ  = dble(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      E1M     = 0.0
      F1M     = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5)  GO TO 220
      EX = 0.0
      IF (BIJ(J) > 0.00001)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43)*1.6022E-12
      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!    *                              - CIJ(J)*ARIJ**6 )
!    *                      + EALPHA
      F1(I,J) = BETA * EX*EPSIJ(J)
!    *                               - 6.0*CIJ(J)*ARIJ**7)
!    *                      + 4.0*EALPHA*ARIJ + EALPHA/4.43
220   IF (DMIJ(J) < 0.01)  GO TO 230
      IF (RUNOPT(8) == 'MORSE     '.OR.  &
          RUNOPT(8) == 'MORSE-PL  '.OR.  &
          RUNOPT(8) == 'BELONO    ' )  THEN
        AM1 = EXP(-2.0*BEIJ(J)*(RIJ-RSIJ(J)))
        AM2 = EXP(-1.0*BEIJ(J)*(RIJ-RSIJ(J)))
        E1M= BETA*DMIJ(J) *(AM1 - 2.0*AM2) * SEPij(J)
        F1M= BETA*BEIJ(J) *DMIJ(J) * (2.0*AM1 - 2.0*AM2) * SEPij(J)
      END IF
      IF (RUNOPT(8) == 'MORSE-AT  ')  THEN
        AM2 = DMIJ(J)*EXP(-BEIJ(J)*RIJ)
        E1M = - BETA * AM2
        F1M = - BETA * BEIJ(J) * AM2
      END IF
      IF (RSWTCH(J) < 1.0E-6)  THEN
        E1(I,J) = E1(I,J) + E1M
        F1(I,J) = F1(I,J) + F1M
      ELSE IF (RIJ <= RSWTCH(J)) THEN
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
230   F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
  RETURN
END
!
!
!                                                                =======
!================================================================ BMHEXP
      SUBROUTINE  BMHEXP(IPOL)   !WATER-POL: IPOL
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use pmorse
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                BORN-MAYER-HUGGINS type plus Expornential type function
!                                               plus gauss type function
!                                                        plus three body
!
!
  double precision    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  double precision    E1M12,E1M3, F1M12, F1M3
  double precision    EX, ARB,  epsij(lef), sepij(lef)
  double precision    am3
  double precision, save ::    dm3ij(lef), be3ij(lef), r03ij(lef),RSWTCHCO(lef)  !WATER-POL
  double precision    ELC2,D1,BE1,D2,BE2,RSIJP,GGG,r3blim2,r3bgrd2
  integer(KIND=4)    ipara(2,10), npara
  integer *4 I,N,II,J,IP,JP,KP,ijkl,IJ,IPOL,k,IP1,IP2,JP1,JP2,KP1,KP2
  double precision    apara(9,10)
  character*1 insIP1,insJP1,insKP1,insIP2,insJP2,insKP2
!
  ELC2 = ELC * ELC
  BETA = CAL * 1.0D10 / ANA
!
  if (IPOL == 1) goto 250   !WATER-POL
  N3BP = 0
  DO I = 1, l3p
    I3BP(1,I) = 0
    i3BP(2,I) = 0
    i3bp(3,i) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) *BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0 * ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J)  * ELC2 * 1.0D8
      ZIJ(N)  = ZIO(II)*ZIO(J)
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      DM3IJ(N) = 0.0D0
      BE3IJ(N) = 0.0D0
      r03ij(n) = 0.0D0
      RSWTCH(N) = 0.0D0
      RSWTCHCO(N) = 0.0D0
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
    enddo
  enddo
!
  npara = 0
120  READ   (15,'(6(A1),i2, 2X,6F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
! 5555        FORMAT (3I2,i2, 2X,6F10.0)
! 5556        format (10x, 3f10.0)
!  IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
!  IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
!  IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
  IP = 0
  JP = 0
  KP = 0
  IP1 = 0
  IP2 = 0
  JP1 = 0
  JP2 = 0
  KP1 = 0
  KP2 = 0
  do k=1,LEL
    if (insIP1 == ins(k)) IP1=k
    if (insJP1 == ins(k)) JP1=k
    if (insKP1 == ins(k)) KP1=k
    if (insIP2 == ins(k)) IP2=k
    if (insJP2 == ins(k)) JP2=k
    if (insKP2 == ins(k)) KP2=k
  enddo
  if (IP1 > 0) IP = IP1
  if (IP2 > 0) IP = IP2
  if (JP1 > 0) JP = JP1
  if (JP2 > 0) JP = JP2
  if (KP1 > 0) KP = KP1
  if (KP2 > 0) KP = KP2
  IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP
      if (ijkl == 1)  then
        AIJ(N)  = 0.0D0
        BIJ(N)  = 0.0D0
        CIJ(N)  = 0.0D0
        DIJ(N)  = 0.0D0
        D4IJ(N) = 0.0D0
        D7IJ(N) = 0.0D0
      end if
      DM1IJ(N) = D1
      BE1IJ(N) = BE1
      DM2IJ(N) = D2
      BE2IJ(N) = BE2
      RSWTCH(N) = RSIJP
      if (ggg > 0.0)  then
        read (15,'(10x, 4f10.0)') dm3ij(n),be3ij(n),r03ij(n), RSWTCHCO(n)
      end if
      npara = npara + 1
      ipara(1,npara) = ip
      ipara(2,npara) = jp
      apara(1,npara) = d1
      apara(2,npara) = be1
      apara(3,npara) = d2
      apara(4,npara) = be2
      apara(5,npara) = dm3ij(n)
      apara(6,npara) = be3ij(n)
      apara(7,npara) = r03ij(n)
      apara(8,npara) = rsijp
      apara(9,npara) = RSWTCHCO(n)
    ELSE IF (IP == KP) THEN
      N3BP = N3BP +1
      I3BP(1,N3BP) = iP
      i3BP(2,N3BP) = jP
      i3BP(3,N3BP) = KP
!     -------------------------------------- F:kJ/mol
      FK3BP(N3BP)  = D1
      ANG3BP(N3BP) = BE1
      R3BLIM(1,N3BP) = D2
      R3BGRD(1,N3BP) = BE2
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 1.2D0
      IF (R3BGRD(1,N3BP) <= 0.01D0) R3BGRD(1,N3BP)=20.0D0
      R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
      R3BGRD(2,N3BP) = R3BGRD(1,N3BP)
    ELSE IF (IP /= KP) THEN
      N3BP = N3BP +1
      I3BP(1,N3BP) = iP
      i3BP(2,N3BP) = jP
      i3BP(3,N3BP) = KP
!     -------------------------------------- F:kJ/mol
      FK3BP(N3BP)    = D1
      ANG3BP(N3BP)   = BE1
      R3BLIM(1,N3BP) = D2
      R3BGRD(1,N3BP) = BE2
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 1.2D0
      IF (R3BGRD(1,N3BP) <= 0.01D0) R3BGRD(1,N3BP)=20.0D0
      READ (15,'(30X,2F10.0)')  R3BLIM2, R3BGRD2
! 5566                    FORMAT (30X,2F10.0)
      IF (R3BLIM2 <= 0.01D0) R3BLIM2 = R3BLIM(1,N3BP)
      IF (R3BGRD2 <= 0.01D0) R3BGRD2 = R3BGRD(1,N3BP)
      R3BLIM(2,N3BP) = R3BLIM2
      R3BGRD(2,N3BP) = R3BGRD2
    ELSE
      STOP 'Something wrong in potetial param.'
    END IF
    GO TO 120
  END IF
!
  write (16,6661)
  if (npara > 0) then
    do  i = 1, npara
      WRITE (16, 6663)  ATOM(Ipara(1,i)),ipara(1,i), &
                        ATOM(ipara(2,i)),ipara(2,i), (apara(j,i),j=1,8)
    enddo
  end if
!
250 continue  
  if (N3BP > 0)  THEN
    if (ipol == 1) write(16,'("!!!3-body potential was reloaded for water-pol!!!")')
    WRITE (16,6666)
    DO N = 1, N3BP
      IF (I3BP(2,N)*i3BP(1,N) > 0) THEN
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-6)/R3BGRD(1,N) + R3BLIM(1,N)  
          IF (runopt(34) == 'WATER-POL ') then
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,N) + R3BLIM(1,N)  !WATER-POL
        endif
!        if (ipol == 1) STOP
        if (runopt(8) == 'BMH-EXP*  ') then
          R3LIM(1,n) = DLOG(0.9999D0/0.0001D0) / R3BGRD(1,N) + R3BLIM(1,N)
        end if
        r3lim(2,n) = r3lim(1,n)
        if (r3limax < r3lim(1,n))  r3limax=r3lim(1,n)
        WRITE (16,6667)  ATOM(i3BP(1,N)), i3BP(1,N),  &
                         ATOM(I3BP(2,N)), I3BP(2,N),  &
                         ATOM(i3BP(3,N)), i3BP(3,N),  &
                         FK3BP(N),ANG3BP(N),i3bp(2,n),i3bp(1,n),  &
                         R3BLIM(1,N), R3BGRD(1,N), R3LIM(1,n)
        if (i3BP(1,N) /= i3BP(3,N)) then
          R3LIM(2,n) = DLOG(0.999999D0/1.0D-6) /  R3BGRD(2,N) + R3BLIM(2,N)
         IF (runopt(34) == 'WATER-POL ') then      
          R3LIM(2,n) = DLOG(0.999999D0/1.0D-8) /  R3BGRD(2,N) + R3BLIM(2,N)
         endif
          if (runopt(8) == 'BMH-EXP*  ') then
            R3LIM(2,n) = DLOG(0.9999D0/1.0D-8) /  R3BGRD(2,N) + R3BLIM(2,N)
          end if
          if (r3limax < r3lim(2,n)) r3limax=r3lim(2,n)
          WRITE (16,6668)  i3bp(2,n),i3bp(3,n),R3BLIM(2,N),R3BGRD(2,N), R3LIM(2,n)
        end if
      END IF
    enddo
  END IF
!
!250 CONTINUE   !WATER-POL
  IF (IPOL == 1) then
    N = (NCOMPO) * (NCOMPO+1) / 2
    NPAIR = (NCOMPO+1) * (NCOMPO+2) / 2
!   N(I,J)
!   1(1,1) 2(2,1) 3(2,2) 4(3,1) 5(3,2) 6(3,3) ....
! 
    II = NCOMPO+1
    DO J = 1, NCOMPO+1
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0* ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J)* ELC2 * 1.0D8
      ZIJ(N)  = ZIO(II)*ZIO(J) !Correct bug ZIO(I) -> ZIO(II) This is though not used in WATER-POL actually.
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      DM3IJ(N) = 0.0D0
      BE3IJ(N) = 0.0D0
      r03ij(n) = 0.0D0
      RSWTCH(N) = 0.0D0
      RSWTCHCO(N) = 0.0D0
    enddo
  ENDIF
!
!
  DO I = 1, NRCUT(2)
    RIJ  = DBLE(I) * 0.01D0
    ARIJ = 1.0D0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0D0
      F1(I,J) = 0.0D0
      E1M     = 0.0D0
      F1M     = 0.0D0
      IF (ABS(AIJ(J)) < 1.0D-5)  GO TO 220
      EX = 0.0D0
      IF (BIJ(J) > 1.0D-5)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0D0)  EX = EXP(ARB)
      END IF
      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43D0)*1.6022D-12
      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!    *                      - CIJ(J)*ARIJ**6
!    *                      - D4IJ(J)*ARIJ**4 - D7IJ(J)*ARIJ**7
      F1(I,J) = BETA * EX*EPSIJ(J)
!    *                      - 6.0*CIJ(J)*ARIJ**7
!    *                      - 4.0*D4IJ(J)*ARIJ**5 - 7.0*D7IJ(J)*ARIJ**8
!    *                      - 4.0*D4IJ(J)*ARIJ**5 - D4IJ(J)*ARIJ**4/4.43
!
220   CONTINUE
      AM1 = DM1IJ(J)*EXP(-BE1IJ(J)*RIJ)
      AM2 = DM2IJ(J)*EXP(-BE2IJ(J)*RIJ)
      am3 = dm3ij(j)*exp(-be3ij(j)*(rij-r03ij(j))**2)
      E1M =  BETA * (AM1 + AM2 + am3)
      F1M =  BETA * (BE1IJ(J)*AM1 + BE2IJ(J)*AM2 +2.0*be3ij(j)*(rij-r03ij(j))*am3)
      E1M12 = BETA * (AM1 + AM2)
      E1M3  = BETA * AM3
      F1M12 = BETA * (BE1IJ(J)*AM1 + BE2IJ(J)*AM2)
      F1M3  = BETA * 2.0*be3ij(j)*(rij-r03ij(j))*am3
      IF (RSWTCH(J) < 1.0D-6)  THEN
        E1(I,J) = E1(I,J) + E1M
        F1(I,J) = F1(I,J) + F1M
      ELSE IF (RIJ <= RSWTCH(J)) THEN
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
      IF (IPOL == 1) then
        IF (RIJ > RSWTCHCO(J)) THEN
          E1(I,J) = E1(I,J) - E1M12
          F1(I,J) = F1(I,J) - F1M12
        END IF
      ENDIF
230   F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
6661        format (' I  ', 60(' '), 'I--', 63('-'), '--I' /  &
                     ' I  ',24x,'DM1ij      BE1ij      DM2ij    ',  &
                           ' BE2ij      DM3ij     BE3ij     R03ij    ', &
                           ' Rswch',26x, 'I')
6663             format (' I   ',A2,'(',i2,') -- ',A2,'(',i2,')  ',  &
                            3(F11.2, F10.3),F10.3,F10.3, 26X,'I')
6666           FORMAT (' I  ',60(' '),'   ', 63(' '),'  I' /  &
                       ' I',5X,'3-body potential   ATOM(J)--ATOM(I)',  &
                       '--ATOM(J)      FK3BP      ANG3BP     R3BLIM ',  &
                       '   R3BGRD      R3LIM   ',23X, 'I')
6667                  FORMAT (' I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
                               I2,')--',A2,'(',I2,')', F15.8, F11.3,  &
                               i6,'-',i2, 2F10.3, F12.4,16X, 'I')
6668                       FORMAT (' I',73X, i6,'-',i2,2F10.3, F12.4,16X, 'I')
  RETURN
END
!
!                                                                =======
!================================================================ VASHIS
SUBROUTINE  VASHIS
  use param
  use charac
  use counts
!  use consts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use pmorse
!
  implicit none
!
!     --------------- Vashishta (Vashishta et al., 1990) type potential function
!
!
  REAL      *8    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  real      *8    E1M12,E1M3, F1M12, F1M3
  real      *8    EX, ARB, epsij(lef), sepij(lef)
  real      *8    am3
  real      *8    ELC2,D1,BE1,D2,BE2,RSIJP,GGG,r3blim2,r3bgrd2
  DOUBLE PRECISION HIJ(LEF),OMEGA(LEF),VD4IJ(LEF),VASUNIT
  DOUBLE PRECISION EXPD4, FD4, LAMBDA1(LEF),LAMBDA4(LEF)
  Double precision EXPD4RC,FD4RC,AM1RC,F1MRC
  Double precision EXPD1, FD1, EXPD1RC, FD1RC, COUCOF
!  DOUBLE PRECISION PI180
  integer   *4    ipara(2,10), npara
  integer   *4    I,N,II,J,IP,JP,KP,ijkl,IJL,IJ,IP1,IP2,JP1,JP2,KP1,KP2
  integer*4       k
  integer   *4    ETAIJ(LEF)
  real      *8    apara(9,10)
  character*1     insIP1,insJP1,insKP1,insIP2,insJP2,insKP2
!
!  PI180=180.0D0/PI
  ELC2 = ELC * ELC
!  BETA = CAL * 1.0D10 / ANA ! kcal/mol -> erg
  COUCOF = ELCC/(4.0D0*PI*EP0*1.D-10) !eV
  BETA = ELCC * 1.0D7   ! eV -> erg
  VASUNIT = 14.39D0
  N3BP = 0
  DO I = 1,l3p
    I3BP(1,I) = 0
    i3BP(2,I) = 0
    i3bp(3,i) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO + 1) / 2
  N = 0
! N(I,J)
! 1(1,1) 2(2,1) 3(2,2) 4(3,1) 5(3,2) 6(3,3) ....
! 
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = 0.0D0 
      BIJ(N)  = 0.0D0 
      CIJ(N)  = 0.0D0
      DIJ(N)  = 0.0D0
      D4IJ(N) = 0.0D0 
      VD4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0* VASUNIT ! eV angstrom^4
      D7IJ(N) = 0.0D0 
      ZIJ(N)  = ZIO(I)*ZIO(J)
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      RSWTCH(N) = 0.0D0
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
    enddo
  enddo
!
  npara = 0
  120 READ   (15,'(6(A1),i2,2X,6F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
!             write (6,'(3(i2,1x),i2,2x, 6F10.0)')  IP,JP, KP, ijkl, &
!                    D1, BE1, D2, BE2, RSIJP, GGG
!  IF (IP /= 0 .AND. MOD(IP,10) == 0)  IP = IP / 10
!  IF (JP /= 0 .AND. MOD(JP,10) == 0)  JP = JP / 10
!  IF (KP /= 0 .AND. MOD(KP,10) == 0)  KP = KP / 10
  IP = 0
  JP = 0
  KP = 0
  IP1 = 0
  IP2 = 0
  JP1 = 0
  JP2 = 0
  KP1 = 0
  KP2 = 0
  do k=1,LEL
    if (insIP1 == ins(k)) IP1=k
    if (insJP1 == ins(k)) JP1=k
    if (insKP1 == ins(k)) KP1=k
    if (insIP2 == ins(k)) IP2=k
    if (insJP2 == ins(k)) JP2=k
    if (insKP2 == ins(k)) KP2=k
  enddo
  if (IP1 > 0) IP = IP1
  if (IP2 > 0) IP = IP2
  if (JP1 > 0) JP = JP1
  if (JP2 > 0) JP = JP2
  if (KP1 > 0) KP = KP1
  if (KP2 > 0) KP = KP2
  IF (IP >= 1 .AND. IP <= NCOMPO .AND. JP >= 1 .AND. JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN   !---------------------i-j
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP 
      if (ijkl == 1)  then
        AIJ(N)  = 0.0D0
        BIJ(N)  = 0.0D0
        CIJ(N)  = 0.0D0
        DIJ(N)  = 0.0D0
        D4IJ(N) = 0.0D0
        D7IJ(N) = 0.0D0
      end if
      HIJ(N) = D1   ! Hij [eV angstrom^eta]
      ETAIJ(N) = INT(BE1) ! Eta [-]
      LAMBDA1(N) = D2 ! Lambda_1 [Angstrom]
      IF(LAMBDA1(N) > 0.0d0) then
           ZIO(:)=0.0D0
      ENDIF
      LAMBDA4(N) = BE2 ! Lambda_4 [Angstrom]
      RSWTCH(N) = RSIJP   !rc [ANgstrom]
      OMEGA(N) = GGG  ! Omega [eV Angstrom^6]
!      if (ggg > 0.0D0) read (15,'(10x, 4f10.0)') dm3ij(n),be3ij(n),r03ij(n),RSWTCHCO(n)
      npara = npara + 1
      ipara(1,npara) = ip
      ipara(2,npara) = jp
      apara(1,npara) = d1   !H
      apara(2,npara) = be1  !Eta
      apara(3,npara) = d2   !Lambda_1
      apara(4,npara) = be2  !Lambda_4
      apara(5,npara) = rsijp !rc
      apara(6,npara) = ggg   !Omega
!      apara(7,npara) = r03ij(n)
!      apara(8,npara) = rsijp 
!      apara(9,npara) = RSWTCHCO(n)
    ELSE IF (IP == KP) THEN     !------------------ j-i-j
      N3BP = N3BP +1
      I3BP(1,N3BP) = iP
      i3BP(2,N3BP) = jP
      i3BP(3,N3BP) = KP
!     -------------------------------------- 
      FK3BP(N3BP)  = D1  !B [eV]
      ANG3BP(N3BP) = BE1  !theta0 [Degree]
      R3BLIM(1,N3BP) = D2   !r0 [Angstrom]
      R3BGRD(1,N3BP) = BE2 ! Gamma_ij [Angstrom] 
!      R3BLIM(2,N3BP) = RSIJP !r0_ik [Angstrom]
      CIJK(N3BP) = GGG ! C[-]
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 2.6D0
!      IF (R3BLIM(2,N3BP) <= 0.01D0) R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
!      R3BGRD(2,N3BP) = R3BGRD(1,N3BP) ! Gamma_ik [Angstrom]
      ANG3BP(N3BP)=DCOS(ANG3BP(N3BP)/PI180)  !cos theta0
    ELSE IF (IP /= KP) THEN    !------------------- J-i-k
      N3BP = N3BP +1
!      write (6,*)  ip,jp,kp
      I3BP(1,N3BP) = iP     ! iP:OK?
      i3BP(2,N3BP) = jP
      i3BP(3,N3BP) = KP
!     -------------------------------------- 
      FK3BP(N3BP)    = D1 !B [eV]
      ANG3BP(N3BP)   = BE1 ! theta0 [Degree]
      R3BLIM(1,N3BP) = D2  !r0 [Angstrom]
      R3BGRD(1,N3BP) = BE2 ! Gamma_ij [Angstrom] 
!      R3BLIM(2,N3BP) = RSIJP !r0_ik [Angstrom]
      CIJK(N3BP) = GGG ! C[-]
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 2.6D0
!      IF (R3BLIM(2,N3BP) <= 0.01D0) R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
!      R3BGRD(2,N3BP) = R3BGRD(1,N3BP) ! Gamma_ik [Angstrom]
      ANG3BP(N3BP)=DCOS(ANG3BP(N3BP)/PI180)  !cos theta0
    ELSE
      STOP 'Something wrong in potetial param.'
    END IF
    GO TO 120
  END IF
!
  write (16,6671)
  if (npara > 0) then
    do i = 1, npara
      WRITE (16, 6673)  ATOM(Ipara(1,i)),ipara(1,i), &
                        ATOM(ipara(2,i)),ipara(2,i), (apara(j,i),j=1,6)
    enddo
  end if
!
250 continue
  r3limax=0.0d0
  if (N3BP > 0)  THEN
    WRITE (16,6676)
    DO N = 1, N3BP
      IF (I3BP(2,N)*i3BP(1,N) > 0) THEN
        if (r3limax < R3BLIM(1,N)) r3limax=R3BLIM(1,N)      
        WRITE (16,6677)  ATOM(i3BP(1,N)), i3BP(1,N), &
                         ATOM(i3BP(2,N)), I3BP(2,N), &
                         ATOM(i3BP(3,N)), i3BP(3,N), &
             FK3BP(N),ANG3BP(N),i3bp(2,n),i3bp(1,n), &
                 R3BLIM(1,N), R3BGRD(1,N), CIJK(N)
!               B    , theta0   
!               r0   , gamma,  C
        if (i3BP(1,N) /= i3BP(3,N)) then
          WRITE (16,6678)  i3bp(2,n),i3bp(3,n),R3BLIM(2,N),R3BGRD(2,N),CIJK(N)
        end if
      END IF
    enddo
  END IF
!
!250 CONTINUE  !WATER-POL
!
  DO J = 1, NPAIR
      !  For Shifted Potential
      RIJ=RSWTCH(J)  ! rc
      ARIJ = 1.0D0/RIJ
      EXPD1RC = 0.0D0
      FD1RC = 0.0D0
      IF(LAMBDA1(J)> 0.0D0) then  
         EXPD1RC=exp(-1.0d0*RIJ/LAMBDA1(J))
         FD1RC =  (ZIJ(J)*ARIJ*EXPD1RC + ZIJ(J)/LAMBDA1(J)*EXPD1RC)*ARIJ*COUCOF
      ENDIF
      EXPD4RC=exp(-1.0d0*RIJ/LAMBDA4(J))
      FD4RC =  (4.0D0*VD4IJ(J)*ARIJ*EXPD4RC + VD4IJ(J)/LAMBDA4(J)*EXPD4RC)*ARIJ**4 
      AM1RC = HIJ(J)*ARIJ**ETAIJ(J) +COUCOF*ZIJ(J)*ARIJ*EXPD1RC - VD4IJ(J)*ARIJ**4*EXPD4RC - OMEGA(J)*ARIJ**6 
      F1MRC = HIJ(J)*ETAIJ(J)*ARIJ**(ETAIJ(J)+1) +FD1RC - FD4RC - 6.0D0*OMEGA(J)*ARIJ**7
    DO I = 1, NRCUT(2)
      RIJ  = DBLE(I) * 0.01D0
      ARIJ = 1.0D0 / RIJ
      E1(I,J) = 0.0D0
      F1(I,J) = 0.0D0
      E1M     = 0.0D0
      F1M     = 0.0D0
!      IF (ABS(AIJ(J)) < 1.0D-5)  GO TO 220
!      EX = 0.0D0
!      IF (BIJ(J) > 1.0D-5)  THEN
!        ARB = (AIJ(J) - RIJ) / BIJ(J)
!        IF (ARB > -128.0D0)  EX = EXP(ARB)
!      END IF
!      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43D0)*1.6022D-12
!      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!!    *                      - CIJ(J)*ARIJ**6
!!    *                      - D4IJ(J)*ARIJ**4 - D7IJ(J)*ARIJ**7
!      F1(I,J) = BETA * EX*EPSIJ(J)
!!    *                      - 6.0D0*CIJ(J)*ARIJ**7
!!    *                      - 4.0D0*D4IJ(J)*ARIJ**5 - 7.0D0*D7IJ(J)*ARIJ**8
!!    *                      - 4.0D0*D4IJ(J)*ARIJ**5 - D4IJ(J)*ARIJ**4/4.43D0
!
  220 CONTINUE
      EXPD1 = 0.0D0
      FD1 = 0.0D0
      IF(LAMBDA1(J)> 0.0D0) then  
         EXPD1=exp(-1.0d0*RIJ/LAMBDA1(J))
         FD1 =  (ZIJ(J)*ARIJ*EXPD1 + ZIJ(J)/LAMBDA1(J)*EXPD1)*ARIJ*COUCOF
      ENDIF
      EXPD4=exp(-1.0d0*RIJ/LAMBDA4(J))
      FD4 =  (4.0D0*VD4IJ(J)*ARIJ*EXPD4 + VD4IJ(J)/LAMBDA4(J)*EXPD4)*ARIJ**4 
      AM1 = HIJ(J)*ARIJ**ETAIJ(J) +COUCOF*ZIJ(J)*ARIJ*EXPD1 - VD4IJ(J)*ARIJ**4*EXPD4 - OMEGA(J)*ARIJ**6 
      E1M =  BETA * (AM1-AM1RC+(RIJ-RSWTCH(J))*F1MRC)   !Beta eV -> erg
      F1M =  BETA * (HIJ(J)*ETAIJ(J)*ARIJ**(ETAIJ(J)+1) +FD1 - FD4 - 6.0D0*OMEGA(J)*ARIJ**7 -F1MRC)
      IF (RIJ <= RSWTCH(J)) THEN !RSWTCH: rc
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
      F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
 6671 format (' I  ', 60(' '), 'I--', 63('-'), '--I' / &
              ' I  ',24x,'Hij        ETAij    LAMBDA1   ', &
              'LAMBDA4      rc          w                ', &
              '      ',26x, 'I')
 6673 format (' I   ',A2,'(',i2,') -- ',A2,'(',i2,')  ', &
              (F11.5,F10.3),2(F11.2, F10.3), 46X,'I')
 6676 FORMAT (' I  ',60(' '),'   ', 63(' '),'  I' / &
              ' I',5X,'3-body potential   ATOM(J)--ATOM(I)', &
              '--ATOM(J)      BIJK      Costheta           ', &
              '   r0    ', &
              '    gamma','      C      ',15X, 'I')
 6677 FORMAT (' I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
               I2,')--',A2,'(',I2,')', F15.5, F11.7, &
               i6,'-',i2, 2F10.3, F12.4,16X, 'I')
 6678 FORMAT (' I',73X, i6,'-',i2,2F10.3, F12.4,16X, 'I')
RETURN
END
!
!
!
!                                                               ========
!================================================================ TOSIFU
      SUBROUTINE  TOSIFU
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE TABLES
!
!     -------------------- TOSI & FUMI (BORN-MAYER) type rigid ion model
!                                             (including Pauling factor)
!
      implicit none
!
      double precision  BETA, ARIJ,DENI,DENJ,RIJ,EXPA,ARB
      integer(KIND=4)  N,I,II,J
!
      BETA = 1.0D-19 * 1.0D7
!
      NPAIR = NCOMPO * (NCOMPO+1) / 2
      N = 0
      DO 220 I = 1, NCOMPO
             II = I
          DO 210 J = 1, II
                 N = N + 1
!                N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
              ZIJ(N)  = ZIO(II) * ZIO(J)
              AIJ(N)  = AIO(II) + AIO(J) 
              BIJ(N)  = BIO(II) + BIO(J) 
              CIJ(N)  = CIO(II) * CIO(J) * BETA
              DIJ(N)  = DIO(II) * DIO(J) * BETA
              D4IJ(N) = 0.0D0
              D7IJ(N) = 0.0D0
              PLIJ(N) = 1.0D0
!             ------------------------------------------- Pauling factor
              DENI = 8.0D0
              IF (WIO(I).LE.11.5)  DENI = 2.0D0
              DENJ = 8.0D0
              IF (WIO(J).LE.11.5)  DENJ = 2.0D0
              PLIJ(N) = 1.0D0 + ZIO(I)/DENI + ZIO(J)/DENJ
  210     ENDDO
  220 ENDDO
!
!     RHO  = 0.29D0
      DO 250  I = 10, NRCUT(2)
          RIJ  = DBLE(I) * 0.01D0
          ARIJ = 1.0D0 / RIJ
          DO 240  J = 1, NPAIR
              IF (ABS(AIJ(J)) > 1.0E-5) THEN
                   EXPA = 0.0D0
                   ARB  = (AIJ(J) - RIJ) / BIJ(J)
                   IF (ARB > -128.0) EXPA=PLIJ(J)*0.338D0*EXP(ARB)
                   E1(I,J) = EXPA * BETA
!    *                       - CIJ(J)*ARIJ**6 - DIJ(J)*ARIJ**8
                   F1(I,J) = EXPA/BIJ(J)*BETA * 1.0D8 * ARIJ
!                  F1(I,J) =(EXPA/BIJ(J)*BETA-6.0D0*CIJ(J)*ARIJ**7 
!    *                                       -8.0D0*DIJ(J)*ARIJ**9)
!    *                                             * 1.0D8 * ARIJ
              END IF
  240     ENDDO
  250 ENDDO
      RETURN
      END
!
!
!                                                               ========
!================================================================ ANGELP
      SUBROUTINE  ANGELP
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE TABLES
!
!     -------------------------- BORN-MAYER-HUGGINS type rigid ion model
!               WOODCOK, ANGELL type potential function (Pauling factor)
!
      implicit none
      integer(KIND=4)  I,N,II,J
      double precision  DENI,DENJ,RHO,RIJ,ARIJ,EX,ARB
!
!     BETA = CAL * 1.0E10 / ANA
!
      N = 0
      DO 220 I = 1, NCOMPO
             II = I
          DO 210 J = 1, II
                 N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
              ZIJ(N)  = ZIO(II) * ZIO(J)
              AIJ(N)  = ABS(AIO(II) + AIO(J))
              BIJ(N)  = (BIO(II) +BIO(J)) * 1.0D-13
              CIJ(N)  = CIO(II) * CIO(J) * 1.0D-13
              DIJ(N)  = 0.0D0
              PLIJ(N) = 1.0D0
              IF (RUNOPT(8) == 'PAULING  ')  THEN
                    DENI = 8.0D0
                    IF (WIO(I).LE.11.5)  DENI = 2.0D0
                    DENJ = 8.0D0
                    IF (WIO(J).LE.11.5)  DENJ = 2.0D0
                    PLIJ(N) = 1.0D0 + ZIO(I)/DENI + ZIO(J)/DENJ
             END IF
  210     ENDDO
  220 ENDDO
!
      RHO   = 0.29D0
      DO 250  I = 10, NRCUT(2)
          RIJ  = DBLE(I) * 0.01D0
          ARIJ = 1.0D0 / RIJ
          DO 240  J = 1, LEE
              IF (ABS(AIJ(J)) > 1.0E-5) THEN
                    EX = 0.0D0
                    ARB = (AIJ(J) - RIJ) / RHO
                    IF (ARB > -128.0)  EX = PLIJ(J) * BIJ(J) * EXP(ARB)
                    E1(I,J) = EX
!    *                        - CIJ(J)*ARIJ**6
                    F1(I,J) =  EX/RHO * 1.0D8 * ARIJ
!                   F1(I,J) = (EX/RHO-6.0D0*CIJ(J)*ARIJ**7)*1.0D8 * ARIJ
              END IF
  240     ENDDO
  250 ENDDO
      RETURN
      END
!
!
!                                                            ===========
!============================================================= L-J MODEL
      SUBROUTINE  LJMODL
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE TABLES
!
!     ------------------------------- Lennard-Jones type potential model
!                           uij(rij) = eij[(sij/rij)**12 - (sij/rij)**6]
!                                 Lorentz-Berthelot type pair parameters
!                                   sij=(si+sj)/2  :  eij=(eixej)**(1/2)
!
      implicit none
      integer(KIND=4)  N,I,II,J
      double precision  RIJ,ARIJ,EX,EX2
!
      N = 0
      DO 220 I = 1, NCOMPO
          AIO(I) = SQRT(AIO(I)*1.0E-16)
          BIO(I) = BIO(I) / 2
             II = I
          DO 210 J = 1, II
                 N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
              ZIJ(N)  = ZIO(II) * ZIO(J)
              AIJ(N)  = AIO(II) * AIO(J) * 4.0D0
              BIJ(N)  = BIO(II) + BIO(J)
              CIJ(N)  = AIJ(N) * BIJ(N)**6 
              DIJ(N)  = 0.0D0
              if (IION(I) < 0 .AND. IION(J) < 0) THEN
                    AIJ(N) = 0.0D0
                    BIJ(N) = 0.0D0
                    CIJ(N) = 0.0D0
              END IF
  210     ENDDO
  220 ENDDO
!
      DO 250  I = 10, NRCUT(2)
          RIJ  = DBLE(I) * 0.01D0
          ARIJ = 1.0D0 / RIJ
          DO 240  J = 1, LEE
              EX = (BIJ(J) * ARIJ)**6
              EX2 = EX * EX
              E1(I,J) = AIJ(J)* (EX2)
!             E1(I,J) = AIJ(J)* (EX2 - EX)
              F1(I,J) = AIJ(J)*(12.0D0*EX2) *ARIJ *ARIJ *1.0D8
!             F1(I,J) = AIJ(J)*(12.0D0*EX2-6.0D0*EX)*ARIJ*ARIJ*1.0D8
  240     ENDDO
  250 ENDDO
      RETURN
      END
!
!
!                                                                =======
!================================================================ METALP
      SUBROUTINE  METALP  (IPR)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE VECTOR
      USE TABLES
!
      implicit none
!
      integer(KIND=4)   INP(51)
      double precision      ANM,DRVN2,AKF2,RI,F,VRN
      double precision      R,ARN,PHI,EFG,FF1,FF2,EE0,EE
      integer(KIND=4) I,J,IPR,ICUT,NP,ANP,JNP,IIR,IIIR
!
      ANM = 3.0
      IF (ABS(MODE).GE.3 .AND. ABS(MODE).LE.9)  ANM = DBLE(MODE)
!
      IF (ALPHA > 0.9 .OR. ALPHA < 14.9)  THEN
            ICUT    = INT(ALPHA)
            RCUT(2) = (LSR-1.0)/100.0
      ELSE
            ICUT = 0
            IF (RCUT(2) < 0.01 .OR. RCUT(2) > (LSR-1.0)/100.0) THEN
                   RCUT(2)  = (LSR-1.0)/100.0
            END IF
      END IF
            NRCUT(2) = INT(RCUT(2) * 100.0 + 1.01)
            RCUT(1)  = RCUT(2)
!
! *** LRO-II
!
      NPAIR = NCOMPO * (NCOMPO+1) / 2
      DO 110  I = 1, NCOMPO
          AKFI(I) = 0.0
  110 ENDDO
!     ------------------------------------------------ Fermi wave number
      AKFI(1) = (3.0 * PI**2 * NION(1) / VOL)**(1.0/3.0)
!
!     U = KB * [ (A/r)**n * cos(2*kf*r - B)  +  exp(C - D*r) ]
!
      DO 350  I = 50, LSR
          E0(I) = 0.0
          F0(I) = 0.0
          R = DBLE(I) * 0.01
          DO 340  J = 1, NPAIR
              E1(I,J) = 0.0
              F1(I,J) = 0.0
              IF (ABS(AIO(J)) > 1.0E-10)  THEN
                     ARN = (AIO(J) / R)**ANM
                     PHI = 2.0D0 * AKFI(J) * R - BIO(J)
                     EFG = EXP(CIO(J) - DIO(J) * R)
! 
!                    E0(I,J) = AKB * ARN * COS(PHI)
                     E1(I,J) = AKB * ARN * COS(PHI) + AKB * EFG
!
                     FF1 = (- ANM * COS(PHI) / R  &
                            - 2.0D0 * AKFI(J) * SIN(PHI)) * ARN
                     FF2 =  - DIO(J) * EFG 
                     F1(I,J) = - (FF1 + FF2) * AKB * 1.0E8 / R
              END IF
  340     ENDDO
  350 ENDDO
!     ------------------------------ CORRECTION FOR TERMINATION AT RCUTL
      ECORR = 0.0
      VCORR = 0.0
      IF (ICUT == 0) THEN
            DRVN2 = NION(1) / VOL * 4.0 * PI * 0.02
            AKF2  = 2.0 * AKFI(1)
            IIIR= INT((1999.0-RCUT(2))/0.02+0.00001) + 1
            do 400  IIR = 1, IIIR
                    RI = RCUT(2) + 0.02*(IIR-1)
                    R  = RI + 0.01
                    F  = (1999.0 - R) / (1999.0 - RCUT(2))
                   IF (ANM > 3.1)  F = 1.0
                   VRN = R**2 * DRVN2
                   ARN = (AIO(1) / R)**ANM
                   PHI   = AKF2*R - BIO(1)
                   ECORR = ECORR + COS(PHI) * ARN * VRN
!
                   VCORR = VCORR - &
                           (- ANM*COS(PHI)/R &
                            - AKF2*SIN(PHI)*F ) * R * ARN * VRN
  400       ENDDO
            ECORR = ECORR * NION(1) * AKB * FJMOL / 2.0
            VCORR = VCORR * NION(1) / 2.0 * AKB * 1.0D-10 &
                                    / (VOL*1.0D-24) / 3.0
      ELSE
            DO 450  J = 1, NCOMPO
                IF (ABS(AIO(J)) > 1.0E-10)  THEN
                      NP = 0
                      EE0 = E1(200,J)
                      DO 440  I = 201, NRCUT(2)
                          EE = E1(I,J)
                          IF (EE0*EE.LE.0.0) THEN
                                 NP = NP + 1
                                 INP(NP) = I
                                 IF (NP.GE.50)  GO TO 490
                          END IF
                          EE0 = EE
  440                 ENDDO
  490                 IF (ICUT > NP)  ICUT = NP
                      NRCUT(2) = INP(ICUT)
                      RCUT(2)  = NRCUT(2) * 0.01
                      NRCUT(1) = NRCUT(2)
                      RCUT(1)  = RCUT(2)
                      ANP   = INP(ICUT) - INP(ICUT-1) + 1
                      DO 460  I = INP(ICUT-1), INP(ICUT)
                          E1(I,J)=E1(I,J)*DBLE((I-INP(ICUT-1))/ANP)
                          F1(I,J)=F1(I,J)*DBLE((I-INP(ICUT-1))/ANP)
  460                 ENDDO
                      IF (IPR == 1) THEN
                            DO 470  I = 1, NP
                                JNP = INP(I)
                                WRITE (16,*)  I,INP(I), &
                                          E1(JNP-1,J),E1(JNP,J)
  470                       ENDDO
                      END IF
                END IF
  450       ENDDO
      END IF
!
      IF (IPR == 1) THEN
            WRITE (*,1001) RCUT(1),AKFI(1),ECORR,VCORR,N3BP
 1001       FORMAT (10X,'RCUT=',F8.4,'   KF=',F6.4,'   Ecorr=',F6.3, &
                                    '  Pcorr=',F6.3)
      END IF
!
!     DO 160  I = 100, NCUT, 10
!         WRITE (16,*) I,E0(I,1)+E1(I,1),F1(I,1)
! 160 ENDDO
!     WRITE (*,*) 375,E1(375,1),F1(375,1)
      RETURN
      END
!
!
!                                                                =======
!================================================================ CLEARS
      SUBROUTINE  CLEARS
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE GEOMET
      USE VECTOR
      USE VALUES
      USE ACOORD
!
!     --------------------------------- Clear variables for accumulation
!
      implicit none
!
      integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT, ISECND, I100TH
      integer(KIND=4)   NN,MM,JM,IM,I,J,K
!
          CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
                        NN = IRECRD(2)/IRECRD(3)
                        MM = MOD(NRECRD(1)/IRECRD(3), NN)
                        JM = 2
                        IF (RUNOPT(3) == 'ECONOMY  ')  JM = 10
                        IM = 1
                        IF (RUNOPT(3) == 'ECONOMY  ')  IM = 0
         IF (NRECRD(3) == 1)  GOTO 10
         IF (NRECRD(3) == IM.OR.MOD(MM,JM) == 0)  GO TO 10
         IF (RUNOPT(3).NE.'ECONOMY  ')  GO TO 11
         IF (NRECRD(3).NE.IM.AND.MOD(MM,JM).NE.0)  GO TO 12
   10      WRITE (16,2450)
           write (16,2449)NJOB,TITLE,TEMP, IHOUR,IMINUT,ISECND, &
                                             IYEAR,IMONTH,IDAY
   11      write (16,2450)
           WRITE (16,2452)  (ATOM(I),I=1,4)
!
 2450 FORMAT (1X)
 2449 FORMAT ('1<<<<<<',I4,'-',I2,'  <<<<  ',15A4,' >>>>  T=',F7.1, &
                    '  (at ',I2,':',I2,':',I2, &
                     '  on ',I4,'/',I2,'/',I2,') >>>>')
 2452 FORMAT('  Step ',4('T:',A2,1X),'Temp   P/GPa  (Pxx,  Pyy,  ', &
                 'Pzz,  Pyz,  Pxz,  Pxy)  U:Coulomb   Short  ', &
                 '3-body   Kin.    Total   Density')
!
   12 IF(MOD(NRECRD(1),IRECRD(3)) == 1 .or. IRECRD(2) == 1 .or. IRECRD(3) ==1) then
!
         TVALL(:) = 0.0D0
         SVALL(:) = 0.0D0
!
         IF (MOD(NRECRD(1),IRECRD(2)) == 1 .or. IRECRD(2) == 1) then 
            AU(:) = 0.0
!
            IF (NRECRD(2) > 0.AND.RUNOPT(4) == 'ACCUM     ')  RETURN
            NRECRD(2) = 0
            NTBL = 0
            NRDF(:,:) = 0
            ANGL(:,:)  = 0.0
            ITBR(:,:) = 0
            MBR(:,:,:) = 0
            NRG(:,:) = 0
            PPC(:,:) = 0.0
            PPS(:,:) = 0.0
         ENDIF
      ENDIF
      RETURN
      END
!
!
!                                                               ========
!================================================================ NEWTON
      SUBROUTINE  NEWTON (myrank, mpsize)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE PARAMT
      USE GEOMET
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE VECTOR
      USE VALUES
      USE ACOORD
      USE TABLES
      USE MOLECU
      USE QUANCO
      use OUTERF   !CONSTSHEAR
      use ewal
!
!     ----------------------------------------- Heart of MD calculations
!
      implicit none
!
      double precision   ABOX1, V1I, PXI, VAVB(6),PJI,PCT(6)
      double precision   AMV2,   ABOX2, V2I, PYI, CENTRE, WGIO
      double precision   TMV2,   ABOX3, V3I, PZI, CENTRP, FV,FVI,V2
      double precision   DIPOLE(3),THETA,COSTH,SINTH, VC(3,LNI)
      double precision   QXI,QYI,QZI,DIPM2,A3NKBT,VALIO2,ASPRES
      double precision   DPRES,PRESXX,PRESYY,PRESZZ,VOLS
      double precision   X0,X1,X2
      integer(KIND=4)  N,IO,I,J,IS1,IS2
      integer(KIND=4)  myrank,mpsize
!
      DO N = 1, N3BP
          AV3BP(1,N) = 0.0D0
          AV3BP(2,N) = 0.0D0
      ENDDO
!
      DO 80  IO = 1, NCOMPO
          IF (NION(IO) <= 0)  GO TO 80
          DO 60  I = IONS(1,IO), IONS(2,IO)
              UI(I) = 0.0D0
              FX(I) = 0.0D0
              FY(I) = 0.0D0
              FZ(I) = 0.0D0
              DO J = 1, 3
                  IF (P(J,I) < 0.0.OR.P(J,I) >= 1.0)  THEN
                         PJI     = - SIGN(1.0D0,P(J,I))
                         P0(J,I) = P0(J,I) + PJI
                         P(J,I)  = P(J,I)  + PJI
                  END IF
              ENDDO
              PX(I)  = P(1,I)
              PY(I)  = P(2,I)
              PZ(I)  = P(3,I)
!              ZII(I) = ZIO(IO)   !WATER-POL
              IF (IOND(I) == 0)  ZII(I) = 0.0D0
   60     ENDDO
!
      if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
!
   80 ENDDO
      DO I = 1, LVA
          VAL(I) = 0.0D0
      ENDDO   
      NRECRD(2) = NRECRD(2) + 1
      IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
             TINT = 0.0D0
             QCEE = 0.0D0
             QCEF = 0.0D0
      END IF
!     --------------------------------- Coulomb and Short range (2-body)
!                                               and 3-body term
      CALL  EWALDP1  (myrank ,mpsize)
!     --------------------------------------------------  Electric field
      IF (RUNOPT(20) == 'ELEC.FIELD')  CALL  ELECFD
!     ---------------------------------------------------  Gravity field
      IF (RUNOPT(21) == 'GRAV.FIELD')  CALL  GRAVFD
!     -------------------------------------- Dipole moment of basic cell
!                                           (2*Pi/3L**3)* [Sum of qi*ri]
      IF (RUNOPT(14) == 'DIPOLE    ')  THEN
            DIPOLE(1) = 0.0D0
            DIPOLE(2) = 0.0D0
            DIPOLE(3) = 0.0D0
            DO 220  IO = 1, NCOMPO
                IF (NION(IO).LE.0)  GO TO 220
                DO 210  I = IONS(1,IO), IONS(2,IO)
                    PXI = PX(I)
                    PYI = PY(I)
                    PZI = PZ(I)
                    IF (P0(1,I) > 0.999999)  PXI = PXI - 1.0
                    IF (P0(2,I) > 0.999999)  PYI = PYI - 1.0
                    IF (P0(3,I) > 0.999999)  PZI = PZI - 1.0
                    QXI = H(1,1)*PXI + H(1,2)*PYI + H(1,3)*PZI
                    QYI = H(2,1)*PXI + H(2,2)*PYI + H(2,3)*PZI
                    QZI = H(3,1)*PXI + H(3,2)*PYI + H(3,3)*PZI
                    DIPOLE(1) = DIPOLE(1) + ZIO(IO)*QXI
                    DIPOLE(2) = DIPOLE(2) + ZIO(IO)*QYI
                    DIPOLE(3) = DIPOLE(3) + ZIO(IO)*QZI
  210           ENDDO
  220       ENDDO
            DO 250  IO = 1, NCOMPO
                IF (NION(IO).LE.0)  GO TO 250
                DO 240  I = IONS(1,IO), IONS(2,IO)
                    FX(I) = FX(I) - ZIO(IO) * DIPOLE(1) * 4.0D0 * PI &
                                             / VOL * ELC**2 * 1.0D16
                    FY(I) = FY(I) - ZIO(IO) * DIPOLE(2) * 4.0D0 * PI &
                                             / VOL * ELC**2 * 1.0D16
                    FZ(I) = FZ(I) - ZIO(IO) * DIPOLE(3) * 4.0D0 * PI &
                                             / VOL * ELC**2 * 1.0D16
  240           ENDDO
  250       ENDDO
            DIPM2 = (DIPOLE(1)**2 + DIPOLE(2)**2 + DIPOLE(3)**2) *  &
                     2.0D0 * PI / (3.0D0 * VOL)  * ELC**2 *  &
                     1.0D8 * FJMOL
!           WRITE (*,*) DIPM2
      END IF
!     =============================== Integration of equations of motion
           ABOX1  = 1.0D0 / BOX(1)
           ABOX2  = 1.0D0 / BOX(2)
           ABOX3  = 1.0D0 / BOX(3)
           X0 = (0.5D0-0.0D0)*(0.5D0-1.0D0)/(((-1.0D0)-0.0D0)*((-1.0D0)-1.0D0))
           X1 = (0.5D0-(-1.0D0))*(0.5D0-1.0D0)/((0.0D0-(-1.0D0))*(0.0D0-1.0D0))
           X2 = (0.5D0-(-1.0D0))*(0.5D0-0.0D0)/((1.0D0-(-1.0D0))*(1.0D0-0.0D0))
!
      IF (RUNOPT(5) == 'T NOSE    ')  GO TO 400
!
      DO 330  IO = 1, NCOMPO
          IF (NION(IO) <= 0)       GO TO 330
          IF (WIO(IO) < 0.00001)  GO TO 330
                  IS1 = IONS(1,IO)
                  IS2 = IONS(2,IO)
               WGIO = DBLE(DTIME)**2 / (WIO(IO)/ANA) * 1.0D8
               DO 310  I = IS1, IS2
                   CALL  PTOXYZ  (I)
                   IF (IOND(I) == 0)  THEN
                         V(1,I) = 0.0D0
                         V(2,I) = 0.0D0
                         V(3,I) = 0.0D0
                         GO TO 310
                   END IF
                   IF (RUNOPT(6) == 'P ANDERSEN') THEN
!                         ------------------------- Andersen's algorithm
                          V1I = V(1,I) + FX(I)*WGIO - VBOX(1) * V(1,I)
                          V2I = V(2,I) + FY(I)*WGIO - VBOX(2) * V(2,I)
                          V3I = V(3,I) + FZ(I)*WGIO - VBOX(3) * V(3,I)
                   ELSE
!                         ----------------------------- Verlet algorithm
                          V1I = V(1,I) + FX(I)*WGIO
                          V2I = V(2,I) + FY(I)*WGIO
                          V3I = V(3,I) + FZ(I)*WGIO
                   END IF
                   IF  (IION(IO).GE.0)  THEN
!                         P(1,I) = P(1,I) + V1I * ABOX1
!                         P(2,I) = P(2,I) + V2I * ABOX2
!                         P(3,I) = P(3,I) + V3I * ABOX3
                          Q(1,I) = Q(1,I) + V1I
                          Q(2,I) = Q(2,I) + V2I
                          Q(3,I) = Q(3,I) + V3I
                   ELSE
                          V1I = 0.0D0
                          V2I = 0.0D0
                          V3I = 0.0D0
                   END IF
!                  ------------------ Interpolation for present velocity
                   IF (NRECRD(3) == 1)  THEN
                         VC(1,I) = (V(1,I) + V1I) / 2.0D0
                         VC(2,I) = (V(2,I) + V2I) / 2.0D0
                         VC(3,I) = (V(3,I) + V3I) / 2.0D0
                   ELSE
                         VC(1,I) = VP(1,I)*X0 + V(1,I)*X1 + V1I*X2
                         VC(2,I) = VP(2,I)*X0 + V(2,I)*X1 + V2I*X2
                         VC(3,I) = VP(3,I)*X0 + V(3,I)*X1 + V3I*X2
                   END IF
                   VP(1,I) = V(1,I)
                   VP(2,I) = V(2,I)
                   VP(3,I) = V(3,I)
                   V(1,I) = V1I
                   V(2,I) = V2I
                   V(3,I) = V3I
  310         ENDDO
  330 ENDDO
      GO TO 500
!     ------------------------------------------------ Nose's thermostat
  400 A3NKBT = 3.0D0*NTION*AKB*TEMP
      TMV2 = 0.0D0
      DO 460  IO = 1, NCOMPO
          IF (NION(IO).LE.0)       GO TO 460
          IF (WIO(IO) < 0.00001)  GO TO 460
                IS1 = IONS(1,IO)
                IS2 = IONS(2,IO)
               AMV2 = 0.0D0
               DO 450  I = IS1, IS2
                   AMV2 = AMV2 + V(1,I)**2 + V(2,I)**2 + V(3,I)**2
  450          ENDDO
               TMV2 = TMV2 + AMV2 *1.0D-16*(WIO(IO)/ANA)/(DTIME**2)
  460 ENDDO
!                                         STEMP : g.cm**2, erg.s**2
      VSTEMP = VSTEMP + (TMV2 - A3NKBT) / STEMP * 1.0D16 * DTIME
      DO 490  IO = 1, NCOMPO
          IF (NION(IO).LE.0)       GO TO 490
          IF (WIO(IO) < 0.00001)  GO TO 490
               WGIO = DBLE(DTIME)**2 / (WIO(IO)/ANA) * 1.0D8
                     IS1 = IONS(1,IO)
                     IS2 = IONS(2,IO)
               DO 480  I = IS1, IS2
                   CALL  PTOXYZ  (I)
                   V1I = V(1,I) + FX(I)*WGIO - VSTEMP*V(1,I)
                   V2I = V(2,I) + FY(I)*WGIO - VSTEMP*V(2,I)
                   V3I = V(3,I) + FZ(I)*WGIO - VSTEMP*V(3,I)
                   IF  (IION(IO).GE.0)  THEN
                          Q(1,I) = Q(1,I) + V1I
                          Q(2,I) = Q(2,I) + V2I
                          Q(3,I) = Q(3,I) + V3I
                   ELSE
                          V1I = 0.0D0
                          V2I = 0.0D0
                          V3I = 0.0D0
                   END IF
!                  ------------------ Interpolation for present velocity
                   IF (NRECRD(3) == 1)  THEN
                         VC(1,I) = (V(1,I) + V1I) / 2.0D0
                         VC(2,I) = (V(2,I) + V2I) / 2.0D0
                         VC(3,I) = (V(3,I) + V3I) / 2.0D0
                   ELSE
                         VC(1,I) = VP(1,I)*X0 + V(1,I)*X1 + V1I*X2
                         VC(2,I) = VP(2,I)*X0 + V(2,I)*X1 + V2I*X2
                         VC(3,I) = VP(3,I)*X0 + V(3,I)*X1 + V3I*X2
                   END IF
                   VP(1,I) = V(1,I)
                   VP(2,I) = V(2,I)
                   VP(3,I) = V(3,I)
                   V(1,I) = V1I
                   V(2,I) = V2I
                   V(3,I) = V3I
  480          ENDDO
  490 ENDDO
!     WRITE (*,*)  TMV2, A3NKBT, VSTEMP
!
!     --------------------------------- Cartesian to crystal coordinates
  500 CALL  XYZTOP
!     ------------------------------------------------------- Basic cell
      DO 640  IO = 1, NCOMPO
          IF (NION(IO) <= 0)  GO TO 640
          DO 630  I = IONS(1,IO), IONS(2,IO)
              DO 620  J = 1, 3
                  IF (P(J,I) < 0.0.OR.P(J,I).GE.1.0)  THEN
                         PJI     = -SIGN(1.0D0,P(J,I))
                         P0(J,I) = P0(J,I) + PJI
                         P(J,I)  = P(J,I)  + PJI
                  END IF
  620         ENDDO
  630     ENDDO
  640 ENDDO
!     ==================================================================
      DO I = 1, 6
          PCT(I) = 0.0D0
      ENDDO
      DO 580  IO = 1, NCOMPO
          DO J = 1, 6
              VAVB(J) = 0.0D0
          ENDDO
          IF (NION(IO) <= 0)       GO TO 580
          IF (WIO(IO) < 0.00001)  GO TO 580
                  IS1 = IONS(1,IO)
                  IS2 = IONS(2,IO)
               VALIO2 = 0.0D0
               DO 550  I = IS1, IS2
                   IF (IOND(I) == 0) THEN
                          UI(I) = 0.0D0
                          GO TO 550
                   END IF
!                   UI(I)  = UI(I) + ZIA(IO)
                   UI(I) = UI(I) + ZIIA(I)    !kwkt
                   AU(I)  = AU(I) + UI(I)
!                  --------------------- Thermal part of pressure tensor
                   VAVB(1) = VAVB(1) + VC(1,I)**2
                   VAVB(2) = VAVB(2) + VC(2,I)**2
                   VAVB(3) = VAVB(3) + VC(3,I)**2
                   VAVB(4) = VAVB(4) + VC(2,I) * VC(3,I)
                   VAVB(5) = VAVB(5) + VC(1,I) * VC(3,I)
                   VAVB(6) = VAVB(6) + VC(1,I) * VC(2,I)
!                  ------------------------------------------ For m.s.d.
!                  VALIO2  = VALIO2 + ((P(1,I)-P0(1,I))*BOX(1))**2
!    *                              + ((P(2,I)-P0(2,I))*BOX(2))**2
!    *                              + ((P(3,I)-P0(3,I))*BOX(3))**2
                   VALIO2  = VALIO2 + (Q(1,I)-Q0(1,I))**2 &
                                    + (Q(2,I)-Q0(2,I))**2 &
                                    + (Q(3,I)-Q0(3,I))**2
  550          ENDDO
!              --------------------- Sum of (1/2)mv2 of i-th ion species
               AMV2       = (VAVB(1)+VAVB(2)+VAVB(3))*1.0D-16 * &
                               (WIO(IO)/ANA) / (2.0D0 * DTIME**2)
               if (iion(io) == -1)  AMV2 = (1.5D0 * DBLE(NIOND(IO))*AKB)* temp
               VAL(13)    = VAL(13) + AMV2
               VAL(24+IO) = AMV2 / (1.5D0 * DBLE(NIOND(IO)) *AKB)
               DO 570  J = 1, 6
                   PCT(J) = PCT(J) + (VAVB(J)*1.0D-16)*(WIO(IO)/ANA)/ (DTIME**2)
  570          ENDDO
!              -------------------------------------------------- M.s.d.
               VAL(34+IO) = VALIO2  / DBLE(NIOND(IO))
  580 ENDDO
!
!     ------------------------------------------------------ Temperature
      VAL(1) = VAL(13) / (1.5D0 * DBLE(NTION-NTIOND) * AKB)
      TINT   = TINT + VAL(1)
!     ----------------------------------------------- Quantum correction
      IF (RUNOPT(12) == 'QUANTUM   ')  THEN
                   CALL  QUANTM
      END IF
!     --------------------------------------------------- Coulomb energy
      VAL(9) = UCSELF + VAL(9)
      VIRLSR  = VIRLSR * 1.0D-8 + VCORR
!     --------------------------------------------------------- Pressure
      VAL(2) = ( VAL(13)*2.0D0 + VIRLSR + VAL(9) ) &
                                         / (3.0D0*VOL*1.0D-24)*1.0D-10
      VAL(3) = VAL(3) + VCORR/3.0D0
      VAL(4) = VAL(4) + VCORR/3.0D0
      VAL(5) = VAL(5) + VCORR/3.0D0
      PXYZ(1) = VAL(2)
      DO J = 1, 6
          VAL(J+2)  = (PCT(J) + VAL(J+2)) &
                                / (VOL*1.0D-24) * 1.0D-10
          PXYZ(J+1) = VAL(J+2)
          PRSTC2(J) = PRSTC2(J) / (VOL*1.0D-24) * 1.0D-10
      ENDDO
!     --------------------------------------------------------- Energies
      VAL(10) = VAL(10) + ECORR
      VAL(12) = VAL(9) + VAL(10) + VAL(11)
      DO 680   I = 9, 13
          VAL(I)  = VAL(I) * FJMOL
  680 ENDDO
      VAL(14) = VAL(12) + VAL(13)
      ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
      VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
      VAL(16) = VAL(14) + VAL(15)
!     ------------------------------------------------- Pressure control
!           -------------------------------- Pressure control by scaling
      IF (RUNOPT(6) == 'P SCALING ')  CALL  SCCELL  
!           ------------------------------------- Stress control (shear)
      IF (RUNOPT(6) == 'P SHEAR   ')  CALL  SCCELL  
!           ------------------------------- Pressure control by Andersen
      IF (RUNOPT(6) == 'P ANDERSEN')  THEN
            DPRES = VAL(2) - (VAL(3) + VAL(4) + VAL(5))/3.0
            PRESXX = VAL(3) + DPRES
            PRESYY = VAL(4) + DPRES
            PRESZZ = VAL(5) + DPRES
            VOLS  = 1.0D-1*1.0D3*VOL*DTIME**2
!           WRITE(*,*) 'VOLS=',VOLS
            VBOX(1) = VBOX(1) + VOLS*(PRESXX-SPRES(1))*ABOX1/VIRM(1)
            VBOX(2) = VBOX(2) + VOLS*(PRESYY-SPRES(2))*ABOX2/VIRM(2)
            VBOX(3) = VBOX(3) + VOLS*(PRESZZ-SPRES(3))*ABOX3/VIRM(3)
!           WRITE(*,*) CELLV
            BOX(1) = BOX(1) + VBOX(1)
            BOX(2) = BOX(2) + VBOX(2)
            BOX(3) = BOX(3) + VBOX(3)
            DO J = 1, 3
                H(J,1) = H(J,1) * BOX(1) * ABOX1
                H(J,2) = H(J,2) * BOX(2) * ABOX2
                H(J,3) = H(J,3) * BOX(3) * ABOX3
            ENDDO
            CALL  TABLER  (0)
      END IF
!     --------------------------------------- Constant shear rate (NEMD)
      IF (RUNOPT(22) == 'CONSTSHEAR')  CALL  CSHEAR
!
!     ------------------------------------- Basic (unit) cell parameters
      VAL(17) = DENSTY
      DO I = 1, 6
          VAL(I+18) = BOX(I)
      ENDDO
      VAL(18) = VOL * ANA * 1.0D-24 / DBLE(NFORML)
      IF (RUNOPT(17) == 'CRYSTAL   ') THEN
             DO I = 1, 3
                 VAL(I+18) = BOX(I) / NBOX(I)
             ENDDO
      END IF
!     ------------------------- cos(x) -> degree
             DO I = 1, 3
                 COSTH = BOX(I+3)
                 SINTH = SQRT(DABS(1.0D0 - COSTH*COSTH))
                 IF (COSTH.NE.0.0) THEN
                       THETA = ATAN(SINTH/COSTH) * 180.0D0/PI
                 ELSE 
                       THETA = 90.0D0
                 END IF
                 IF (THETA < 0.0D0)  THETA = THETA + 180.0D0
                 VAL(I+21) = THETA
             ENDDO
!
!     ---------------------------------------------------- Print results
      CALL  PRINTS  (DIPM2)
!
!     ------------------------------------- Correction for sum of mv = 0
!                                                    (Center of gravity)
      IF (RUNOPT(16) /= 'NO(MV=0)  ')  THEN
      IF (MOD(NRECRD(1),10) == 0)  THEN
               DO I = 1, NTION
                   CALL  PTOXYZ  (I)
               ENDDO
               DO 860  J = 1, 3
                   CENTRE = 0.0D0
                   DO IO = 1, NCOMPO
                       IF (NION(IO) > 0)  THEN
                              DO  I = IONS(1,IO), IONS(2,IO)
                                  CENTRE = CENTRE + V(J,I)*WIO(IO)
                              ENDDO
                       END IF
                   ENDDO
                   CENTRE = CENTRE / TWEGHT
                   CENTRP = CENTRE / BOX(J)
                   DO I = 1, NTION
                       IF (IOND(I) > 0)  THEN
                             V(J,I) = V(J,I) - CENTRE
!                            P(J,I) = P(J,I) - CENTRP
                             Q(J,I) = Q(J,I) - CENTRE
                       END IF
                   ENDDO
  860          ENDDO
            CALL  XYZTOP
      END IF
      END IF
      IF (RUNOPT(21) == 'GRAV.FIELD')  then
               DO I = 1, NTION
                   CALL  PTOXYZ  (I)
               ENDDO
               DO 851  J = 1, 3
                   CENTRE = 0.0D0
                   DO 831  IO = 1, NCOMPO
                       IF (NION(IO) > 0)  THEN
                              DO 821  I = IONS(1,IO), IONS(2,IO)
                                  CENTRE = CENTRE + V(J,I)*WIO(IO)
  821                         ENDDO
                       END IF
  831              ENDDO
                   CENTRE = CENTRE / TWEGHT
                   CENTRP = CENTRE / BOX(J)
                   DO 841  I = 1, NTION
                       IF (IOND(I) > 0)  THEN
                             V(J,I) = V(J,I) - CENTRE
!                            P(J,I) = P(J,I) - CENTRP
                             Q(J,I) = Q(J,I) - CENTRE
                       END IF
  841              ENDDO
  851          ENDDO
            CALL  XYZTOP
      end if
!     ----------------------------------- Temperature control by scaling
      IF (RUNOPT(5) == 'T SCALING ')  THEN
             FV = 1.0D0
             IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
                    TEMP = TEMP + DELTMP
                    IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
                    FV = SQRT(TEMP/(TINT/DBLE(NTSTEP)))
             END IF
             IF (RUNOPT(12) == 'QUANTUM   ') THEN
                    QCEE = QCEE + QCIT * VAL(1) + TQCE / VAL(1)
                    QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
                    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
                           FV = SQRT(QCEF*1.0D0/QCEE)
                    END IF
             END IF
             IF (MODE < 0)                  FV = SQRT(TEMP/TPRE)
             IF (RUNOPT(5) == 'T NO-CNTL.')  FV = 1.0D0
!            IF (DABS(DELTMP).LE.0.00001)    FV = 1.0D0
             IF (VAL(1)/TEMP < 0.3333D0)    FV = SQRT(TEMP/VAL(1))
             IF (VAL(1)/TEMP > 1.6667D0)    FV = SQRT(TEMP/VAL(1))
             FV = 1.0D0 + (FV - 1.0D0) * TDUMP
             IF (ABS(FV-1.0D0) > 1.0D-7)  THEN
                    DO 880  I = 1, NTION
                        DO 881  J = 1, 3
                            V(J,I) = V(J,I) * FV
  881                   continue
  880               ENDDO
             END IF
      END IF
      IF (RUNOPT(5) == 'T SCALE-A ')  THEN
        IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
          TEMP = TEMP + DELTMP
          IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
          IF (DELTMP < 1.0d-6) TEMP = TMPGET
        END IF
        do io = 1, ncompo
          FV = 1.0D0
          IF (MOD(NRECRD(1),NTSTEP) == 0) FV=DSQRT(TEMP/VAL(24+IO))
          IF (RUNOPT(12) == 'QUANTUM   ') THEN
            QCEE = QCEE + QCIT * VAL(24+IO) + TQCE/VAL(24+IO)
            QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
            IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
              FV = DSQRT(QCEF*1.0D0/QCEE)
            END IF
          END IF
          IF (VAL(24+IO)/TEMP < 0.333D0) FV=DSQRT(TEMP/VAL(24+IO))
          IF (VAL(24+IO)/TEMP > 1.667D0) FV=DSQRT(TEMP/VAL(24+IO))
          FV = 1.0D0 + (FV - 1.0D0) * TDUMP
          IF (ABS(FV-1.0D0) > 1.0D-7)  THEN
            if (iion(io) /= 2) then
              DO I = ions(1,io), ions(2,io)
                DO J = 1, 3
                  V(J,I) = V(J,I) * FV
                enddo
              enddo
            end if
          END IF
        enddo
      END IF
      IF (RUNOPT(5) == 'T NOSE    ')  THEN
             IF (RUNOPT(12) == 'QUANTUM   ') THEN
                    QCEE = QCEE + QCIT * VAL(1) + TQCE / VAL(1)
                    QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
                    FV   = SQRT(QCEF*1.0D0/QCEE)
                    DO 890  I = 1, NTION
                        DO 891  J = 1, 3
                            V(J,I) = V(J,I) * FV
  891                   continue
  890               ENDDO
             END IF
      END IF
!     --------------------------- Reduce velocities to prevent explosion
      IF (RUNOPT(22) /= 'CONSTSHEAR') then
      IF (VAL(1) > TEMP*2.0D0)  THEN
            IF (VAL(1)-TPRE > 1.0D6)  GO TO 999
            FV = SQRT(TEMP/VAL(1))
            DO 950  I = 1, NTION
                CALL  PTOXYZ  (I)
                FVI = FV
                V2 = V(1,I)**2 + V(2,I)**2 + V(3,I)**2
                IF (V2 > 0.2D0)  FVI = FV * 0.2D0/V2
                DO 940  J = 1, 3
!                   P(J,I) = P(J,I) - (1.0D0 - FVI)*V(J,I) / BOX(J)
                    Q(J,I) = Q(J,I) - (1.0D0 - FVI)*V(J,I)
                    V(J,I) = V(J,I) * FVI
  940           ENDDO
  950       ENDDO
            CALL  XYZTOP
      END IF
      ENDIF   !CONSTSHEAR
      TPRE = VAL(1)
!
      RETURN
!
  999 WRITE  (*,9988)  VAL(1)
 9988 FORMAT (' ???????? TEMPERATURE TOO HIGH ',F10.0,'K ????????')
      STOP
      END
!
!
!                                                               ========
!=================================================================STOPT 
      SUBROUTINE STOPT (AJDG)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE ANIPAR
      USE VECTOR
      USE VALUES
      USE TABLES
      USE PMORSE
!
      implicit none
      double precision   PJI,PCT(6)
      double precision   MAGF,Tenergy,QCEE,QCEF,ASPRES,TF,PO(3,LNI)
      double precision   UMAG,UX,UY,UZ,QINP
      integer(KIND=4)  N,IO,I,J,IS1,IS2,AJDG
      integer(KIND=4)  myrank,mpsize
!
      DO 20  N = 1, N3BP
          AV3BP(1,N) = 0.0
          AV3BP(2,N) = 0.0
   20 ENDDO
!
      DO 80  IO = 1, NCOMPO
           IF (NION(IO).LE.0)  GO TO 80
          DO 60  I = IONS(1,IO), IONS(2,IO)
              UI(I) = 0.0
              FX(I) = 0.0D0
              FY(I) = 0.0D0
              FZ(I) = 0.0D0
              DO 50  J = 1, 3
                  IF (P(J,I) < 0.0D0.OR.P(J,I).GE.1.0D0)  THEN
                         PJI     = -SIGN(1.0D0,P(J,I))
                         P0(J,I) = P0(J,I) + PJI
                         P(J,I)  = P(J,I)  + PJI
                  END IF
   50         ENDDO
              PX(I)  = P(1,I)
              PY(I)  = P(2,I)
              PZ(I)  = P(3,I)
              PO(1,I)= P(1,I)
              PO(2,I)= P(2,I)
              PO(3,I)= P(3,I)
!              ZII(I) = ZIO(IO)
              IF (IOND(I) == 0)  ZII(I) = 0.0
   60     ENDDO
   80 ENDDO
!
      if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
!
      DO 90  I = 1, LVA
          VAL(I) = 0.0D0
   90 ENDDO
      NRECRD(2) = NRECRD(2) + 1
      IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
             TINT = 0.0
             QCEE = 0.0D0
             QCEF = 0.0D0
      END IF
!     --------------------------------- Coulomb and Short range (2-body)
!                                               and 3-body term
      CALL  EWALDP1  (myrank, mpsize)
!
      DO 510  I = 1, 6
          PCT(I) = 0.0D0
  510 ENDDO
      DO 580  IO = 1, NCOMPO
          IF (NION(IO).LE.0)       GO TO 580
          IF (WIO(IO) < 0.00001)  GO TO 580
                  IS1 = IONS(1,IO)
                  IS2 = IONS(2,IO)
               DO 550  I = IS1, IS2
                   IF (IOND(I) == 0) THEN
                          UI(I) = 0.0
                          GO TO 550
                   END IF
                   UI(I)  = UI(I) + ZIA(IO)
                   AU(I)  = AU(I) + UI(I)
  550          ENDDO
  580 ENDDO
!
      VAL(9) = VAL(9) + Ucself
!
!     --------------------------------------------------------- Energies
      VAL(10) = VAL(10) + ECORR
      VAL(12) = VAL(9) + VAL(10) + VAL(11)
      Tenergy=  (VAL(12) + VAL(13))*1.0D12/1.602176462D0
      DO 730   I = 9, 13
          VAL(I)  = VAL(I) * FJMOL
  730 ENDDO
      VAL(14) = VAL(12) + VAL(13)
      ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
      VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
      VAL(16) = VAL(14) + VAL(15)
!
      AJDG = 0
      TF=0.0D0
      if (nrecrd(3)  ==  1) then
        write(*,*)'axis=',idirec
        CALL TMATRX (0)
!       -------------------------------normal vector of surface   
        DO 110 J = 1,2
            P(1,J) = 0.0D0
            P(2,J) = 0.0D0
            P(3,J) = 0.0D0
            IF (Idirec  ==  1) P(J+1,J) = 1.0D0
            IF (Idirec  ==  2) P(5-2*J,J) = 1.0D0
            IF (Idirec  ==  3) P(J,J) =1.0D0
            CALL PTOXYZ(J)
            P(1,J) = PO(1,J)
            P(2,J) = PO(2,J)
            P(3,J) = PO(3,J)
  110   ENDDO
        UX = Q(2,1)*Q(3,2)-Q(3,1)*Q(2,2)
        UY = Q(3,1)*Q(1,2)-Q(1,1)*Q(3,2)
        UZ = Q(1,1)*Q(2,2)-Q(2,1)*Q(1,2)
        UMAG = SQRT(UX**2+UY**2+UZ**2)
      endif
      DO 200 IO = 1, NCOMPO
        IF(IION(IO)  ==  -1) GO TO 200
      DO 201 I = IONS(1,IO), IONS(2,IO)
        P(1,I) = PO(1,I)
        P(2,I) = PO(2,I)
        P(3,I) = PO(3,I)
       if(i .ne. icons) then
         MAGF= SQRT(FX(I)**2+FY(I)**2+FZ(I)**2)
         IF(ABS(FX(I))  >  FCUT) P(1,I)=P(1,I) + FFAC*FX(I)/MAGF/BOX(1)
         IF(ABS(FY(I))  >  FCUT) P(2,I)=P(2,I) + FFAC*FY(I)/MAGF/BOX(2)
         IF(ABS(FZ(I))  >  FCUT) P(3,I)=P(3,I) + FFAC*FZ(I)/MAGF/BOX(3)
              PO(1,I)= P(1,I)
              PO(2,I)= P(2,I)
              PO(3,I)= P(3,I)
         IF(ABS(FX(I))  >  FCUT .AND. ABS(FY(I))  >  FCUT .AND. &
            ABS(FZ(I))  >  FCUT)  AJDG = 1
       else if (i  ==  icons) then
         P(1,1) = FX(I)
         P(2,1) = FY(I)
         P(3,1) = FZ(I)
         call ptoxyz(1)
!      normal component of f for surface
         QINP = (Q(1,1)*UX+Q(2,1)*UY+Q(3,1)*UZ)/UMAG
         Q(1,1) = QINP*UX/UMAG
         Q(2,1) = QINP*UY/UMAG
         Q(3,1) = QINP*UZ/UMAG
         CALL XYZTOP
         FX(I) = P(1,1)
         FY(I) = P(2,1)
         FZ(I) = P(3,1)
         P(1,I) = PO(1,I)
         P(2,I) = PO(2,I)
         P(3,I) = PO(3,I)
         MAGF= SQRT(FX(I)**2+FY(I)**2+FZ(I)**2)
         if(MAGF  >  FCUT) then
           P(1,i)=P(1,i)+FFAC*FX(I)/MAGF/BOX(1)
           P(2,i)=P(2,i)+FFAC*FY(I)/MAGF/BOX(2)
           P(3,i)=P(3,i)+FFAC*FZ(I)/MAGF/BOX(3)
              PO(1,I)= P(1,I)
              PO(2,I)= P(2,I)
              PO(3,I)= P(3,I)
           AJDG = 1
         endif
       endif
        TF = TF + MAGF ! Total force for moving atoms
  201 CONTINUE
  200 CONTINUE
      do 301 i = 1, ntion
        P(1,I) = PO(1,I)
        P(2,I) = PO(2,I)
        P(3,I) = PO(3,I)
  301 continue	   
!     ------------------------------------------------------- Basic cell
      DO 640  IO = 1, NCOMPO
          IF (NION(IO).LE.0)  GO TO 640
          DO 630  I = IONS(1,IO), IONS(2,IO)
              DO 620  J = 1, 3
                  IF (P(J,I) < 0.0.OR.P(J,I).GE.1.0)  THEN
                         PJI     = -SIGN(1.0D0,P(J,I))
                         P0(J,I) = P0(J,I) + PJI
                         P(J,I)  = P(J,I)  + PJI
                  END IF
  620         CONTINUE
  630     CONTINUE
  640 CONTINUE
!      do 302 i = 1,ntion
!           write(*,*)P(1,i),P(2,i),P(3,i)
!  302 continue
!     ==================================================================
      WRITE(*,1001)NRECRD(1),Tenergy,TF
 1001 format('step=',i6,1x,'energy(ev)=',f20.8,1x,'force=',e20.12)
      RETURN
      END
!
!                                                               ========
!================================================================ POSURF
      SUBROUTINE  POSURF(myrank,mpsize)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE PSURF
      USE VECTOR
      USE VALUES
      USE TABLES
      USE PMORSE
!
      implicit none
      double precision   PJI
      double precision   Tenergy,QCEE,QCEF,UX,UY,UZ,UMAG,ASPRES
      double precision   PO(3,LNI)
      double precision   SNEAR,SFAR,ARMIN,ARMAX,DX1,DX2,DY1,DY2,DZ1,DZ2
      double precision   DISTX,DISTY,DISTZ
      CHARACTER(LEN=1) SPO
      integer(KIND=4)  N,IO,J,I,IDX,L,M,II,JJ,iii,myrank,mpsize
!
      DO 20  N = 1, N3BP
          AV3BP(1,N) = 0.0
          AV3BP(2,N) = 0.0
   20 CONTINUE
!
      WRITE(*,*)'Starting number of moving atom=', iato1
      WRITE(*,*)'Last number of moving atom=',iato2
      IF (iarea  ==  1 .OR. iarea  ==  2 .OR. iarea  ==  3) THEN
  201   WRITE(*,*)'Surface postion is larger than 0.5? (y,n)'
        READ (*,*)SPO
        IF (SPO .NE. 'y' .AND. SPO .NE. 'n') GO TO 201
        SNEAR = 0.5
        SFAR  = 2.0
        IF (SPO  ==  'y') THEN
        SNEAR = 2.0
        SFAR  = 0.5
        ENDIF
      ENDIF
      IF (iarea  ==  4 .OR. iarea  ==  5 .OR. iarea  ==  6) THEN
        ARMIN =   5.0
        ARMAX =   5.0
      ENDIF 
      DO 80  IO = 1, NCOMPO
           IF (NION(IO).LE.0)  GO TO 80
          DO 60  I = IONS(1,IO), IONS(2,IO)
              UI(I) = 0.0
              FX(I) = 0.0D0
              FY(I) = 0.0D0
              FZ(I) = 0.0D0
              DO 50  J = 1, 3
                  IF (P(J,I) < 0.0D0.OR.P(J,I).GE.1.0D0)  THEN
                         PJI     = -SIGN(1.0D0,P(J,I))
                         P0(J,I) = P0(J,I) + PJI
                         P(J,I)  = P(J,I)  + PJI
                  END IF
   50         CONTINUE
              PX(I)  = P(1,I)
              PY(I)  = P(2,I)
              PZ(I)  = P(3,I)
              ZII(I) = ZIO(IO)
              IF (IOND(I) == 0)  ZII(I) = 0.0
   60     CONTINUE
   80 CONTINUE
!
      if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
!
      DO 90  I = 1, LVA
          VAL(I) = 0.0D0
   90 CONTINUE
      NRECRD(2) = NRECRD(2) + 1
      IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
             TINT = 0.0
             QCEE = 0.0D0
             QCEF = 0.0D0
      END IF
      DO 100 I = 1,3
        DO 109 J = iato1,iato2
          PO(I,J) = P(I,J)
  109   CONTINUE
  100 CONTINUE
      OPEN ( 37, FILE=FLNAME(17), STATUS = 'UNKNOWN', &
                 ACCESS='sequential',FORM='FORMATTED')
      WRITE(37,1002) 'dx','dy','dz','ENERGY(eV)','ENERGY(kJ/mol)', &
                     'val(9)','val(10)','val(11)'
      DX1 = 0.0
      DX2 = 0.0
      DY1 = 0.0
      DY2 = 0.0
      DZ1 = 0.0
      DZ2 = 0.0
!     IF (iarea  ==  4) THEN
!       DX1 = ARMIN
!       DX2 = ARMAX
!       DY1 = ARMIN
!       DY2 = ARMAX
!     ELSE IF (iarea  ==  5) THEN
!       DY1 = ARMIN
!       DY2 = ARMAX
!       DZ1 = ARMIN
!       DZ2 = ARMAX
!     ELSE IF (iarea  ==  6) THEN
!       DX1 = ARMIN
!       DX2 = ARMAX
!       DZ1 = ARMIN
!       DZ2 = ARMAX
!      ENDIF
      CALL TMATRX (IDX)
!     ---------------------------------normal vector of surface   
      DO 110 J = 1,2
          P(1,J) = 0.0D0
          P(2,J) = 0.0D0
          P(3,J) = 0.0D0
          IF (Iarea  ==  1) P(J+1,J) = 1.0D0
          IF (Iarea  ==  2) P(5-2*J,J) = 1.0D0
          IF (Iarea  ==  3) P(J,J) =1.0D0
          CALL PTOXYZ(J)
  110 CONTINUE
      UX = Q(2,1)*Q(3,2)-Q(3,1)*Q(2,2)
      UY = Q(3,1)*Q(1,2)-Q(1,1)*Q(3,2)
      UZ = Q(1,1)*Q(2,2)-Q(2,1)*Q(1,2)
      UMAG = SQRT(UX**2+UY**2+UZ**2)
      DISTX = 0.0
      DISTY = 0.0
      DISTZ = 0.0
      iii = 1     
      DO 101 I = -INT(SNEAR/DISTM+0.0001),INT(SFAR/DISTM+0.0001)
        WRITE(*,*)'I=',I
            DO 108 L = iato1,iato2
              P(1,L) = PO(1,L)
              P(2,L) = PO(2,L)
              P(3,L) = PO(3,L)
              Q(1,L) = 0.0D0
              Q(2,L) = 0.0D0
              Q(3,L) = 0.0D0
              CALL PTOXYZ (L)
              Q(1,L) = Q(1,L) + I*DISTM*UX/UMAG !orthogonal system
              Q(2,L) = Q(2,L) + I*DISTM*UY/UMAG
              Q(3,L) = Q(3,L) + I*DISTM*UZ/UMAG
              CALL XYZTOP
              PX(L) = P(1,L)
              PY(L) = P(2,L)
              PZ(L) = P(3,L)
              if (PX(L) .gt. 1.0D0) PX(L) = PX(L) -1.0D0
              if (PX(L) .lt. 0.0D0) PX(L) = PX(L) +1.0D0
              if (PY(L) .gt. 1.0D0) PY(L) = PY(L) -1.0D0
              if (PY(L) .lt. 0.0D0) PY(L) = PY(L) +1.0D0
              if (PZ(L) .gt. 1.0D0) PZ(L) = PZ(L) -1.0D0
              if (PZ(L) .lt. 0.0D0) PZ(L) = PZ(L) +1.0D0
  108       CONTINUE
!     --------------------------------------------write on file09p.dat
                      iii = iii+1
                      DO 450  II = 1, NTION
                            IPV(1,II) = PX(II) * 90000.D0
                            IPV(2,II) = PY(II) * 90000.D0
                            IPV(3,II) = PZ(II) * 90000.D0
  450                 CONTINUE
                      WRITE (19,9002)  iii, 0, &
                                       ((H(JJ,II),JJ=1,3),II=1,3)
                      WRITE (19,9001) ((IPV(JJ,II),JJ=1,3),II=1,NTION)
 9001        FORMAT (18I4)
 9002        FORMAT (2I5, 9F7.3)
!
            DO 104 M=9,16
              VAL(M)  = 0.0D0
              Tenergy = 0.0D0
  104       CONTINUE
!           -------------------------------------------------- Energies
            CALL  EWALDP1  (myrank, mpsize)
!
            VAL(9) = VAL(9) + Ucself
!
            VAL(10) = VAL(10) + ECORR
            VAL(12) = VAL(9) + VAL(10) + VAL(11)
            Tenergy=  (VAL(12) + VAL(13))*1.0D12/1.602176462D0  !eV
            DO 730   L = 9, 13
              VAL(L)  = VAL(L) * FJMOL
  730       CONTINUE
            VAL(14) = VAL(12) + VAL(13)
            ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
            VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
            VAL(16) = VAL(14) + VAL(15)
!
 1991           FORMAT (F10.3,7F10.5)
 1992           format (8F10.3)
! 1993           format (F10.6, F10.4, 3F10.6,3F10.6)
 1993           format (F10.6, F10.4, 3F10.6,3F10.4)
 1994           format (10F9.3)
 1995           format (10F9.3 )
!           ---------------------------------------write on file09v.dat
                   write  (29,1991)  (VAL(II),II=1,8)
                   write  (29,1992)  (VAL(II),II=9,16)
                   write  (29,1993)  (VAL(II),II=17,24)
                   write  (29,1994)  (VAL(II),II=25,34)
                   write  (29,1995)  (VAL(II),II=35,44)
!
            IF (iarea  ==  1 .AND. SPO  ==  'y') DISTX = -I*DISTM
            IF (iarea  ==  1 .AND. SPO  ==  'n') DISTX =  I*DISTM
            IF (iarea  ==  2 .AND. SPO  ==  'y') DISTY = -I*DISTM
            IF (iarea  ==  2 .AND. SPO  ==  'n') DISTY =  I*DISTM
            IF (iarea  ==  3 .AND. SPO  ==  'y') DISTZ = -I*DISTM
            IF (iarea  ==  3 .AND. SPO  ==  'n') DISTZ =  I*DISTM
            WRITE(37,1001)DISTX,DISTY,DISTZ,Tenergy,VAL(14),val(9), &
                          val(10),val(11)
  101 CONTINUE
 1001 FORMAT(F7.3,1X,F7.3,1X,F7.3,1X,E25.12,1X,E25.12,1X,E25.12, &
             1x,e25.12,1x,e25.12)
 1002 FORMAT(A7,1X,A7,1X,A7,1X,A25,1X,A25,1X,A25,1X,A25,1X,A25)
      RETURN
      END
!                                                               ========
!================================================================ PRINTS
      SUBROUTINE  PRINTS  (DIPM2)
      USE PARAM
      USE CHARAC
      USE TIMDAT
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE VALUES
!
      implicit none
!
      integer(KIND=4)     IVAL(LEM)
      integer(KIND=4)     IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer(KIND=4)     N,I,J,ITEMP
      CHARACTER(LEN=40)::FMT1(3), FMT11,FMT12
      double precision        DIPM2,VAL2
      EQUIVALENCE     (FMT1(1),FMT11), (FMT1(2),FMT12)
!
      IF (N3BP > 0) THEN
            DO  N = 1, N3BP
               IF (AV3BP(2,N) > 0.1) AV3BP(1,N)= AV3BP(1,N)/AV3BP(2,N)
!              WRITE (*,1001)  AV3BP(1,N), AV3BP(2,N)
!1001          FORMAT (21X,'Average J-I-J angle is ',F6.2,' (',I4,')')
            ENDDO   
      END IF
!     ---------------------------------------------------- Print results
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      IF (MOD(NRECRD(1),20) == 1) then 
        WRITE  (*,2909)  TITLE,IRECRD(1)
        write (*,2908) NRECRD(1)/10000, IHOUR
        write  (*,2907)
      ENDIF
 2909      FORMAT (' == ',15A4,' (END=',I8,') ')
 2908      FORMAT (' +',I4,'0K ', 63('-'), ' HOUR=',I2)
 2907      format (' STEP Temp  Prss.(  Px   Py   Pz ) ', &
                   'U(Coul.) U(srt)  U(3p) E(total) Density mn:sc')
!
!      IF ((KKTIME(5,2).NE.IMINUT .OR. KKTIME(6,2).NE.ISECND) .OR. &
!           IYEAR+IMONTH+IDAY == 0)  THEN
              VAL2 = ABS(VAL(2))
                     FMT11 = '(1X,I4,I5,F7.4,1H(,3F5.2,1H),           '
              IF (VAL2 > 9.5 .AND. VAL2 < 95.0)  THEN
                     FMT11 = '(1X,I4,I5,F7.3,1H(,3F5.1,1H),           '
              ELSE IF (VAL2.GE.95.0) THEN
                     FMT11 = '(1X,I4,I5,F7.2,1H(,3F5.0,1H),           '
              END IF
                     FMT12 = 'F9.1,F8.1,F6.1,F9.1,F8.5,1H ,I2,1H:,I2)'
              IF (ABS(VAL(9)) < 1.0D4.AND.ABS(VAL(14)) < 1.0D4)  THEN
                     FMT12 = 'F9.2,F8.2,F6.2,F9.2,F8.5,1H ,I2,1H:,I2)'
              END IF
              ITEMP = VAL(1)
              WRITE (*,FMT1) MOD(NRECRD(1),10000),ITEMP,VAL(2),VAL(3), &
                             VAL(4),VAL(5),VAL(9),VAL(10),VAL(11), &
                             VAL(14),VAL(17),IMINUT,ISECND
                    KKTIME(1,2) = IYEAR
                    KKTIME(2,2) = IMONTH
                    KKTIME(3,2) = IDAY
                    KKTIME(4,2) = IHOUR
                    KKTIME(5,2) = IMINUT
                    KKTIME(6,2) = ISECND
                    KKTIME(7,2) = I100TH
!      END IF
      IF (RUNOPT(14) == 'DIPOLE    ')  THEN
            WRITE (*,9917)  DIPM2,VAL(14)+DIPM2
 9917       FORMAT (10X,7X,15X,'Dipole:',4X,F8.3,5X,F9.2)
      END IF
!
!                     VAL345 = (PRSTC2(1)+PRSTC2(2)+PRSTC2(3))/3
!     WRITE (*,9285)  (PRSTC2(I),I=1,3),VAL345
!
!     ----------------------------------------------------- M.s.d., etc.
      IF (MOD(NRECRD(1),5) == 0)  THEN
            IF (ABS(ECORR*FJMOL) > 1.0E-10)  THEN
!                WRITE (*,2880)  VCORR / (3.0D0*VOL*1.0D-24)*1.0D-10,
!    *                           ECORR*FJMOL
!2880            FORMAT (9X, F8.4,' GPa(Pcorr)',9X,
!    *                       'Ecorr=',F8.3,' kJ/mol')
            END IF
            IF (RUNOPT(17) == 'AMORPHOUS ') THEN
                  IF (AV3BP(2,1) < 0.1)  WRITE (*,2901) (VAL(J+34), &
                                             ATOM(J),J=1,5),VAL(19), &
                                                    VAL(20),VAL(21)
                  IF (AV3BP(2,1) > 0.1)  WRITE (*,2901) (VAL(J+34), &
                                             ATOM(J),J=1,5),VAL(19), &
                                                    VAL(20),VAL(21), &
                                          AV3BP(1,1),INT(AV3BP(2,1))
 2901             FORMAT (1X,'Msd:',5(F6.2,':',A1),1X,3F7.3, &
                                                F6.1,':',I5)
                  WRITE (*,2904) (VAL(J+34),ATOM(J),J=6,8), VAL(22), &
                                                    VAL(23),VAL(24)
 2904             FORMAT (5X,3(F6.2,':',A1),17X,3F7.3)
            END IF
            IF (RUNOPT(17) == 'CRYSTAL   ') THEN
                  IF (AV3BP(2,1) < 0.1) WRITE (*,2902) &
                     (VAL(J+34),ATOM(J),J=1,5), VAL(19),VAL(20),VAL(21)
                  IF (AV3BP(2,1) > 0.1) WRITE (*,2902) &
                     (VAL(J+34),ATOM(J),J=1,5), VAL(19),VAL(20),VAL(21), &
                                           AV3BP(1,1),INT(AV3BP(2,1))
 2902             FORMAT (1X,'Msd:',5(F6.3,':',A1),1X,3F7.3, &
                                            F6.1,':',I5)
                  WRITE (*,2903)  (VAL(J+34),ATOM(J),J=6,7), VAL(22), &
                                                     VAL(23),VAL(24)
 2903             FORMAT (5X,2(F6.3,':',A1),25X,3F7.3)
            END IF
      END IF
      IF (RUNOPT(3) == 'DETAIL    ')                 GO TO 670
      IF (RUNOPT(3) == 'ECONOMY   ')                 GO TO 690
      IF (MOD(NRECRD(1),5).NE.0.AND.NRECRD(3).NE.1)  GO TO 690
  670                        DO 680  I = 1, LEM
                                 IVAL(I) = INT(VAL(I+24))
  680                        CONTINUE
            VAL2 = ABS(VAL(2))
                          FMT11 = '(1X,I5,5I5,F8.4,1H(,6F6.3,1H),     '
                          FMT12 = ' F10.2,F9.2,2F7.2,F10.3,    F9.5 ) '
            IF (VAL2 > 9.0 .AND. VAL2 < 95.0) THEN
                          FMT11 = '(1X,I5,5I5,F8.3,1H(,6F6.3,1H),     '
            ELSE IF (VAL2.GE.95.0) THEN
                          FMT11 = '(1X,I5,5I5,F8.2,1H(,6F6.2,1H),     '
            END IF
            IF (ABS(VAL(9)) < 1.0D4.AND.ABS(VAL(14)) < 1.0D4) THEN
                          FMT12 = ' F10.3,F9.3,2F7.3,F10.4,   F9.5 )  '
            END IF
            WRITE (16,FMT1)  mod(NRECRD(1),100000), (IVAL(I),I=1,4), &
                             INT(VAL(1)), (VAL(J),J= 2,11), VAL(13), &
                             VAL(14),VAL(17)
!
  690 IF (MOD(NRECRD(1),25) == 0)  THEN
             IF (RUNOPT(3) /= 'ECONOMY  ') then
                    WRITE (16,2900) (VAL(J),J=25+LEM,LVA)
             endif
 2900        FORMAT (7X,5F8.3 / 7x, 5F8.3 )
      END IF
      RETURN
      END
!
!
!                                                       ================
!=======================================================Center_of_DIATOM
      SUBROUTINE  Center_of_Diatomic_Molecule
      USE PARAM
      USE CHARAC
      USE ABOXOF
      USE ATOMSI
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE MOLECU
!     =======================================recognize diatomic molecule
      implicit none
!
       double precision   pix,piy,piz, pjx,pjy,pjz, rx,ry,rz, dx,dy,dz
       double precision   pjx0,pjy0,pjz0, rij2,cut2
       integer(KIND=4)  im,i,j,K,nnn
!
!---------------------------------------------calc distance of atoms
        cut2 = dintra**2
        do 900  im = 1, ndmole
                i=idmole(1,im)
                j=idmole(2,im)
                 pix = p(1,i)
                 piy = p(2,i)
                 piz = p(3,i)
                 pjx0 = p(1,j)
                 pjy0 = p(2,j)
                 pjz0 = p(3,j)
                 if (pjx0.lt.pix)  pjx0 = pjx0 + 1.0
                 if (pjy0.lt.piy)  pjy0 = pjy0 + 1.0
                 if (pjz0.lt.piz)  pjz0 = pjz0 + 1.0
                 DO 250  K = 1, 8
                       pjx = pjx0 - transx(k)
                       pjy = pjy0 - transy(k)
                       pjz = pjz0 - transz(k)
                       RX = PIX - PjX
                       RY = PIY - PjY
                       RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                        IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                        IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                        IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                           DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                           DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                           DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!                      DX = RX * BOX(1)
!                      DY = RY * BOX(2)
!                      DZ = RZ * BOX(3)
                      RIJ2 = DX*DX + DY*DY + DZ*DZ
                      if (rij2.lt.cut2)  go to 255
  250             CONTINUE
                  go to 900

!                   -----------------------------------P of center of mass
  255               Pix=(Pix+Pjx)/2.
                    Piy=(Piy+Pjy)/2.
                    Piz=(Piz+Pjz)/2.
                    if (pix.lt.0.0)   pix = pix + 1.0
                    if (pix.gt.1.0)   pix = pix - 1.0
                    if (piy.lt.0.0)   piy = piy + 1.0
                    if (piy.gt.1.0)   piy = piy - 1.0
                    if (piz.lt.0.0)   piz = piz + 1.0
                    if (piz.gt.1.0)   piz = piz - 1.0
                    nnn = ntion+im
                    p(1,nnn) = pix
                    p(2,nnn) = piy
                    p(3,nnn) = piz
                    UI(nnn) = 0.0
                    FX(nnn) = 0.0D0
                    FY(nnn) = 0.0D0
                    FZ(nnn) = 0.0D0
                    PX(nnn)  = P(1,nnn)
                    PY(nnn)  = P(2,nnn)
                    PZ(nnn)  = P(3,nnn)
                    ZII(nnn) = Zmole(idmole(3,im))
                    DMOLE(1,IM) = DX
                    DMOLE(2,IM) = Dy
                    DMOLE(3,IM) = DZ
                    DMOLE(4,IM) = SQRT(RIJ2)
!               write(*,*) nnn,DMOLE(1,IM),DMOLE(2,IM),DMOLE(3,IM)
!     *                   ,DMOLE(4,IM)
  900 CONTINUE
      RETURN
      END
!
!
!                                                             ==========
!=============================================================== EWALDP1
SUBROUTINE  EWALDP1  (myrank, mpsize)
!
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use radial
  use forces
  use cartes
  use molecu
  use vector
  use pmorse
  use quanco
  use ewal
!  use charge
  use datoms
  use WORK01
  use WORK02
  use thrmint !kwkt
!
!  implicit none
!
!
!     ==== This is a routine to distribute and correct data to and from
!     ==== EWALD routines of MASTER and SLAVE processes.
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
  integer(KIND=4)  IRDF(LTB),  MRDF(LTB,LEE),   iii(3), icp
  double precision  PIX,DX,RX,DFX,FIX,R00,X0
  double precision  PIY,DY,RY,DFY,FIY,R01,X1,FIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,R02,X2,UII,EIJ
  double precision  PJX,PJY,PJZ
  double precision  VAL09P
  double precision  VALnn(11), VALnnC(3,3)
  double precision  RIJ, RIJ2, RCUT2, zizj
  double precision  pjx0,pjy0,pjz0,RIJ3
  double precision  wal0Nc(3,3), wal0N(11),        rrr(7,2)
  double precision  uip(lni), fxp(lni), fyp(lni), fzp(lni)
  double precision  ddd
  double precision dtmp, dtmpxyz(3)
  double precision EIJTHSUM,EIJTI,UIIC !kwkt
  integer(KIND=4)  iddatom(101,lni)
  double precision  dddatom(100,lni)
  integer(KIND=4)  ierr,idiatom,iquantum,ibmhexp,i,j,myrank,mpsize
  integer*4        ithrm,ithrmint !kwkt
  integer(KIND=4)  io,l,i1,i2,j1,j2,k,ip0,ip1,ip2,kk,m,mm,NNCOMPO,JO,IN
  integer(KIND=4)  ijk,n,kkk,jj,ko,kkkk,no
!

  include  'mpif.h'
  integer*4  status(MPI_STATUS_SIZE)
  call EWALDP1_NEW( myrank, mpsize ); return
!  
!     ----------------------- Put the central atom of 3-body interaction
!                              at the last of atom species, to calculate
!                                                  3-body terms properly
!
  rcut2 = rcut(1) * rcut(1)
!
    VALnn(:) = 0.0D0
    VALnnC(:,:) = 0.0D0
!
!write(*,*)'VALnn'
!do i=1,11
!  write(*,*) VALnn(i)
!enddo
!write(*,*)'VALnnC'
!do i = 1,3
!  do j = 1,3
!    write(*,*) VALnnC(i,j)
!  enddo
!enddo
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
!  write(*,*) 'EWALDP1'
  idiatom  = 0
  if (runopt(23) == 'DIATOMIC  ')  idiatom  = 1
  iquantum = 0
  IF (RUNOPT(12) == 'QUANTUM   ')  iquantum = 1
  ibmhexp  = 0
  if (RUNOPT( 8) == 'BMHEXP*   ')  ibmhexp  = 1
  ithrmint = 0
  if (runopt(37) == 'THERM-INT ')  ithrmint = 1  !kwkt
!
  if (NRECRD(3) == 1) then  
    call MPI_Bcast (irecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (idiatom,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (iquantum,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ibmhexp,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ithrmint,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)  !kwkt
    call MPI_Bcast (NTION,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NION(1),               lem,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IION(1),               lem,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IONS(1,1),           lem*2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NCOMPO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NPAIR,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (WIO(1),                lem,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZIO(1),                lem,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NDMOLE,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (RSWTCH(1),             lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (CIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D4IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D7IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (N3BP,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (I3BP(1,1),           L3P*3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ANG3BP(1),             L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FK3BP(1),              L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BGRD(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BLIM(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3LIM(1,1),          L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (E1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (F1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q1U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q2U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZMOLE(1),                2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DMOLE(1,1),        4*NTION,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DINTRA,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IDMOLE(1,1),3*NTION+NDMOLE,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IATOM2(1),               2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IATOMO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !kwkt
    call MPI_Bcast (IATOMH,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !kwkt
    call MPI_Bcast (flambd,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)  !kwkt
    call MPI_Bcast (TRANSX(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
    call MPI_Bcast (TRANSY(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
    call MPI_Bcast (TRANSZ(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
!     write (*,*) '          MPI_Bcast sent NTION, E1, ZII, etc. '
  end if
!
  iii(1) = nrcut(1)
  iii(2) = nrcut(2)
  iii(3) = nvn
  call MPI_Bcast (iii(1),                  3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
!
  NNCOMPO=NCOMPO
!
  call MPI_Bcast (H(1,1),                  9,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
  call MPI_Bcast (ZII(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (nrecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NVEC(1,1),           3*NVN,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (VEC(1,1),            3*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (FNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (UNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PNV(1,1,1),        3*3*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  do i=1, 6
    rrr(i,1) = box(i)
    rrr(i,2) = rbox(i)
  end do
  rrr(7,1) = rcut(1)
  rrr(7,2) = rcut(2)
  call MPI_Bcast (rrr(1,1),              7*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (E0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  call MPI_Bcast (PX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (r3limax,                 1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!  write (*,8801)
8801 format (11x,'MPI_Bcast sent NVN, BOX, E0, F0, Px-Pz, etc.')
!
!     ------------------------------------------ Coulomb reciprocal term
!     ------------------------------------ Coulmb direct and short range
!
!kwkt
  call  EWALDP3  (idiatom, iquantum, ibmhexp, ithrmint, valnn, VALnnC, myrank, mpsize)
!
!write(*,*)'EWALDP3'
!
!     ------------------ Calculation of Coulomb of three point charges
  if (runopt(23) == 'DIATOMIC  ')  then
    do  L = 1, 2
      i1 = ntion + 1
      i2 = ntion + ndmole
      if (L  ==  2)  i1 = ntion + 2
      DO I = i1, i2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        j1 = 1
        j2 = ntion
        IF (L == 2)  THEN
          J1 = NTION + 1
          j2 = I-1
        END IF
        DO J = j1, j2
          ZIZJ  = ZII(I) * ZII(J)
!P              ZIJE2 = ZIO(IO) * ZIO(JO) * ELC**2
          pjx0 = p(1,j)
          pjy0 = p(2,j)
          pjz0 = p(3,j)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0
          DO K = 1, 8
            pjx = pjx0 - transx(k)
            pjy = pjy0 - transy(k)
            pjz = pjz0 - transz(k)
            RX = PIX - PjX
            RY = PIY - PjY
            RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!            DX = RX * BOX(1)
!            DY = RY * BOX(2)
!            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  GO TO 257
          enddo
          GO TO 262
!
257       RIJ = SQRT(RIJ2)
          IP0 = INT(RIJ*100.0)
!         ---------------------------------- Interpolation
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = IP0 * 0.01D0
          R01 = IP1 * 0.01D0
          R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
          FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
          VALnn(9) = VALnn(9) + EIJ
          UII   = UII   + EIJ
          UI(J) = UI(J) + EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VALnn(3) = VALnn(3) + DFX * DX
          VALnn(4) = VALnn(4) + DFY * DY
          VALnn(5) = VALnn(5) + DFZ * DZ
          VALnn(6) = VALnn(6) + DFY * DZ
          VALnn(7) = VALnn(7) + DFX * DZ
          VALnn(8) = VALnn(8) + DFX * DY
262       CONTINUE
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
      enddo
    enddo
  end if
!
!write(*,*) 'VIRLSR=', VIRLSR
!
  EIJTHSUM = EIJTHS !kwkt
!     --------------------------------------- receive results from CPU's
  if (mpsize > 1)  then
    do  icp = 1, mpsize-1
      call MPI_Ssend (icp,                     1,         MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,ierr)
      call MPI_Recv  (wal0N(1),               11,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      do i = 3, 11
        valnn(i) = valnn(i) + wal0N(i)
      enddo
      VIRLSR = VIRLSR + wal0n( 2)
!write(*,*) 'VIRLSR=', VIRLSR
      call MPI_Recv (wal0NC(1,1),            3*3,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      tqcep = wal0NC(7)
      valnnc(1,1) = valnnc(1,1) + wal0Nc(1,1)
      valnnc(2,1) = valnnc(2,1) + wal0Nc(2,1)
      valnnc(3,1) = valnnc(3,1) + wal0Nc(3,1)
      valnnc(1,2) = valnnc(1,2) + wal0Nc(1,2)
      valnnc(2,2) = valnnc(2,2) + wal0Nc(2,2)
      valnnc(3,2) = valnnc(3,2) + wal0Nc(3,2)
      valnnc(1,3) = valnnc(1,3) + wal0Nc(1,3)
      valnnc(2,3) = valnnc(2,3) + wal0Nc(2,3)
      valnnc(3,3) = valnnc(3,3) + wal0Nc(3,3)
!      TQCE   = TQCE   + TQCEP
!
      call MPI_Recv(EIJTHS,1,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr) !kwkt
      EIJTHSUM = EIJTHSUM + EIJTHS   !kwkt
!
      call MPI_Recv (uip(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (FXp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (FYp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (FZp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (MRDF(1,1),        ltb*npair,        MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)
      do j = 1, npair
        do i = 1, nrcut(1)
          NRDF(i,j) = NRDF(i,j) + MRDF(i,j)
!          if (j==1) write(*,*)'nrdf = ',NRDF(i,1)
        enddo
      enddo
      call MPI_Recv (iddatom(1,1),101*(ntion+ndmole),    MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)  !WATER-POL
      call MPI_Recv (dddatom(1,1),100*(ntion+ndmole),MPI_DOUBLE_PRECISION,icp,icp,MPI_COMM_WORLD,status,ierr) !WATER-POL
!
      do i = 1, ntion
        ui(i) = ui(i) + uip(i)
        fx(i) = fx(i) + fxp(i)
        fy(i) = fy(i) + fyp(i)
        fz(i) = fz(i) + fzp(i)
        if (iddatom(101,i) > 0) then
          do  j = 1, iddatom(101,i)
            idatom(101,i) = idatom(101,i) + 1
            idatom(idatom(101,i),i) = iddatom(j,i)
            ddatom(idatom(101,i),i) = dddatom(j,i)
          enddo
        endif
      enddo
    enddo
!    write (*,8901)  1,mpsize-1
8901 format (11x,'MPI_Recv received results from ',i2,' to ',I3)
  end if
!
!kwkt
   if (RUNOPT(37) == 'THERM-INT ') then
    VAL09P = VALnn(9)
    if (dintra > 0.0D0) then
      no = 0
      EIJTI = 0.0d0
      do io = IONS(1,IATOMO), IONS(2,IATOMO)
        no = no + 1
        do k = 1,2
          kk = ih2o(k,no)
          PIX = PX(kk)
          PIY = PY(kk)
          PIZ = PZ(kk)
          FIX = 0.0D0
          FIY = 0.0D0
          FIZ = 0.0D0
          UII = 0.0D0
          UIIC = 0.0d0
          DO m = k+1, 3
            mm = ih2o(m,no)
            pjx0 = PX(mm)
            pjy0 = PY(mm)
            pjz0 = PZ(mm)
            if (pjx0 < pix)  pjx0 = pjx0 + 1.0
            if (pjy0 < piy)  pjy0 = pjy0 + 1.0
            if (pjz0 < piz)  pjz0 = pjz0 + 1.0
            DO  kkkk = 1, 8
              pjx = pjx0 - transx(kkkk)
              pjy = pjy0 - transy(kkkk)
              pjz = pjz0 - transz(kkkk)
              RX = PIX - PjX
              RY = PIY - PjY
              RZ = PIZ - PjZ
              DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
              DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
              DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
 !            DX = RX * BOX(1)
 !            DY = RY * BOX(2)
 !            DZ = RZ * BOX(3)
              RIJ2 = DX*DX + DY*DY + DZ*DZ
              IF (RIJ2 <= RCUT2)  EXIT     
            ENDDO 
            RIJ  = sqrt(RIJ2)  !angstrom
            if (RIJ < 0.1D0) stop 'Too short distance !!!'
            if (RIJ > 3.0D0) stop 'Too long distance!!!'
            RIJ3 = RIJ**3  !angstrom
            ZIZJ  = ZII(mm)*ZII(kk)
!            EIJ  = ELC**2*ZIZJ/RIJ*1.0D8     !erg cgs-esu
            EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
            EIJTI = EIJTI + EIJ/flambd**2
!write(*,*)'EIJ',EIJ,EIJ/flambd**2
            EIJ   = EIJ * (1.0D0 - 1.0D0/flambd**2)
            VALnn(9) = VALnn(9) - EIJ
            UII   = UII   + EIJ
            UIIC  = UIIC  + EIJ
            UI(mm) = UI(mm) - EIJ
            UIC(mm) = UIC(mm) - EIJ
!!            FIJ   = ELC**2*ZIZJ/RIJ3*1.0D16
            FIJ   = EPOLLL*ZIZJ/RIJ3 ! dyn
            FIJ   = FIJ * (1.0D0 - 1.0D0/flambd**2)
            DFX  = FIJ*DX
            DFY  = FIJ*DY
            DFZ  = FIJ*DZ
            FIX  = FIX + DFX
            FIY  = FIY + DFY
            FIZ  = FIZ + DFZ
            FX(mm) = FX(mm) + DFX  ! cgs-esu
            FY(mm) = FY(mm) + DFY  ! cgs-esu
            FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
            VALnn(3) = VALnn(3) - DFX * DX
            VALnn(4) = VALnn(4) - DFY * DY
            VALnn(5) = VALnn(5) - DFZ * DZ
            VALnn(6) = VALnn(6) - DFY * DZ
            VALnn(7) = VALnn(7) - DFX * DZ
            VALnn(8) = VALnn(8) - DFX * DY
          enddo
          FX(kk) = FX(kk) - FIX
          FY(kk) = FY(kk) - FIY
          FZ(kk) = FZ(kk) - FIZ
          UI(kk) = UI(kk) - UII
          UIC(kk) = UIC(kk) - UIIC
        enddo
      enddo
    elseif (dintra <= 0.0D0) then
      EIJTI = 0.0d0
      do io =1,NION(IATOMO) + NION(IATOMH)
        kk=intr(io)
        PIX = PX(kk)
        PIY = PY(kk)
        PIZ = PZ(kk)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0d0
        do jo = io+1, NION(IATOMO) +NION(IATOMH)
          mm = intr(jo)
          pjx0 = PX(mm)
          pjy0 = PY(mm)
          pjz0 = PZ(mm)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0
          DO  kkkk = 1, 8
            pjx = pjx0 - transx(kkkk)
            pjy = pjy0 - transy(kkkk)
            pjz = pjz0 - transz(kkkk)
            RX = PIX - PjX
            RY = PIY - PjY
            RZ = PIZ - PjZ
            DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
            DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
            DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  EXIT
          ENDDO
          RIJ  = sqrt(RIJ2)  !angstrom
!          write(97,*) RIJ, "!" 
          RIJ3 = RIJ**3  !angstrom
          ZIZJ  = ZII(mm)*ZII(kk)
          EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
          EIJTI = EIJTI + EIJ/flambd**2
          EIJ = EIJ * (1.0D0-1.0D0/flambd**2)
          VALnn(9) = VALnn(9) - EIJ
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJ
          UI(mm) = UI(mm) - EIJ
          UIC(mm) = UIC(mm) - EIJ
          FIJ = EPOLLL*ZIZJ/RIJ3   !dyn
          FIJ = FIJ * (1.0D0-1.0D0/flambd**2) !kwkt
          DFX = FIJ*DX
          DFY = FIJ*DY
          DFZ = FIJ*DZ
          FIX = FIX + DFX
          FIY = FIY + DFY
          FIZ = FIZ + DFZ
          FX(mm) = FX(mm) + DFX  ! cgs-esu
          FY(mm) = FY(mm) + DFY  ! cgs-esu
          FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
          VALnn(3) = VALnn(3) - DFX * DX
          VALnn(4) = VALnn(4) - DFY * DY
          VALnn(5) = VALnn(5) - DFZ * DZ
          VALnn(6) = VALnn(6) - DFY * DZ
          VALnn(7) = VALnn(7) - DFX * DZ
          VALnn(8) = VALnn(8) - DFX * DY
        enddo
        FX(kk) = FX(kk) - FIX
        FY(kk) = FY(kk) - FIY
        FZ(kk) = FZ(kk) - FIZ
        UI(kk) = UI(kk) - UII
        UIC(kk) = UIC(kk) - UIIC
      enddo
    endif
   endif  !THERM-INT
  EIJKTI = 0.0d0 !kwkt
!     -------------------------------------------- Calculate 3-body term          
write(*,*) "n3bp", n3bp
  if (n3bp > 0)  then                                                        
    do io = 1, ncompo                                                     
      ijk = 0                                                                  
      do  n = 1, n3bp                                                          
        if (io == i3bp(2,n))  ijk = n    ! searching center atoms
      end do                                                                   
      if (ijk == 0)  cycle               ! if io /= a center atom  then cycle
!                                                                                                                                      
      do i=ions(1,io), ions(2,io)                                          
        mm = idatom(101,i)                ! idatom(101,i) : number of atoms near the center atom
        if (mm <= 1)  cycle                                               
!           ------------------------------------- sorting with distrance          
        do j = 1, mm-1                                                   
          do k = j+1, mm                                                 
            if (ddatom(j,i) > ddatom(k,i)) then !ddatom (j,i) : distance between i and j
              ddd         = ddatom(j,i)                                 
              ddatom(j,i) = ddatom(k,i)                                 
              ddatom(k,i) = ddd                                         
              kkk         = idatom(j,i)                                 
              idatom(j,i) = idatom(k,i)                                 
              idatom(k,i) = kkk                                         
            end if                                                          
          enddo
        enddo                                                             
!                                                                                 
420     pix = px(i)                                    
        piy = py(i)                                    
        piz = pz(i)                                    
        if (pix >= 0.5d0) pix = pix -1.0d0
        if (piy >= 0.5d0) piy = piy -1.0d0
        if (piz >= 0.5d0) piz = piz -1.0d0
        do jj = 1, mm-1                                                  
          jo = idatom(jj,i) / 1000000                                        
          j  = mod(idatom(jj,i),1000000)                                     
          do KKK = 1, 8
            PJX = PX(J) - TRANSX(KKK)
            PJY = PY(J) - TRANSY(KKK)
            PJZ = PZ(J) - TRANSZ(KKK)
            RX = PIX - PJX                                               
            RY = PIY - PJY                                                 
            RZ = PIZ - PJZ                                                 
!            IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
!            IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
!            IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
!            D1AXYZ(1) = RX * BOX(1)                                        
!            D1AXYZ(2) = RY * BOX(2)                                        
!            D1AXYZ(3) = RZ * BOX(3)                                        
            D1AXYZ(1) = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
            D1AXYZ(2) = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
            D1AXYZ(3) = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            D1ATOM    = sqrt(d1axyz(1)**2 + d1axyz(2)**2 + d1axyz(3)**2)                  
            do kk = jj+1, mm                                                 
              ko = idatom(kk,i) / 1000000                                        
              k  = mod(idatom(kk,i),1000000)                                     
              do KKKK = 1, 8
                PJX = PX(k) - TRANSX(KKKK)
                PJY = PY(k) - TRANSY(KKKK)
                PJZ = PZ(k) - TRANSZ(KKKK)
                RX = PIX - PJX                                               
                RY = PIY - PJY                                                 
                RZ = PIZ - PJZ                                                 
!                IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
!                IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
!                IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
!                D2AXYZ(1) = RX * BOX(1)                                        
!                D2AXYZ(2) = RY * BOX(2)                                        
!                D2AXYZ(3) = RZ * BOX(3)                                        
                D2AXYZ(1) = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                D2AXYZ(2) = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                D2AXYZ(3) = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
                D2ATOM    = sqrt(d2axyz(1)**2 + d2axyz(2)**2  + d2axyz(3)**2)                  
!                                                                                     
                DO N = 1, N3BP                                                 
                  ithrm = 0 !kwkt
                  IF (io == I3BP(2,N) .AND. jo == i3BP(1,N) .and. &                
                      jo == ko        .and. ko == i3BP(3,N)) then                 
                    if (RUNOPT( 8) == 'VASHISHTA ') then
                      CALL THREER3 (I,j,k,n)
                    else 
                      if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(1,n) )  then                           
!                          -------------------------- 3-body potential B-A-B          
!                                                                                     
                        if(ithrmint == 1) then  !kwkt
                           if (io == IATOMO .and. jo == IATOMH) ithrm = 1
                        endif
!
                        CALL  THREEP  (I,j,k, n,ithrm) !kwkt                           
!                                                                                     
                      end if        
                    endif                                             
                  END IF                                                          
!                                                                                     
                  IF (IO == I3BP(2,N)       .AND. JO == i3BP(1,n) .and. &           
                          i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(3,n)) then           
!                          ------------------------------------ 3-body B-A-C          
!                                                                                     
                    if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(2,n) )  then  
                      call  threeq  (I,j,k, N)                
                    end if                                                     
                  end if                                                          
!                                                                                     
                  IF (IO == I3BP(2,N)       .AND. JO == i3BP(3,n) .and.  &
                      i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(1,n)) then           
!                          ------------------------------------ 3-body C-A-B          
!                                                                                     
                    if (d1atom <= r3lim(2,n) .and. d2atom <= r3lim(1,n) )  then
                       dtmp = d1atom
                       d1atom = d2atom
                       d2atom = dtmp
                       dtmpxyz(:) = d1axyz(:)
                       d1axyz(:) = d2axyz(:)
                       d2axyz(:) = dtmpxyz(:)
                      call  threeq  (I,k,j, N)                
                       dtmp = d1atom
                       d1atom = d2atom
                       d2atom = dtmp
                       dtmpxyz(:) = d1axyz(:)
                       d1axyz(:) = d2axyz(:)
                       d2axyz(:) = dtmpxyz(:)
                    end if                                                     
                  end if                                                          
                enddo                                                           
              enddo
            enddo
          enddo            
        enddo                                                              
      enddo                                                                 
    enddo                                                                    
  end if                                                                      
!
   if (RUNOPT(37) == 'THERM-INT ') then  !kwkt
    ULAM = 0.0D0
    ULAM = 2.0d0*(UCSLFI(IATOMO) + UCSLFI(IATOMH)) -2.0d0*EIJTI -2.0d0*EIJTHSUM -EIJKTI
      do j = ions(1,IATOMO), ions(2,IATOMO)
        ULAM = ULAM + UI(j)
      end do
      do i = ions(1,IATOMH), ions(2,IATOMH)
        ULAM = ULAM + UI(i)
      end do
    ULAMT = ULAMT + ULAM  
   endif


!     ------------------------------------------------------------------
  PRSTC2(1) = VALnnC(1,1)
  PRSTC2(2) = VALnnC(2,2)
  PRSTC2(3) = VALnnC(3,3)
  PRSTC2(4) = (VALnnC(2,3) + VALnnC(3,2)) /2.0d0
  PRSTC2(5) = (VALnnC(1,3) + VALnnC(3,1)) /2.0d0
  PRSTC2(6) = (VALnnC(1,2) + VALnnC(2,1)) /2.0d0
!  write(*,*) 'PRSTC2'
!  do i = 1,6
!    write(*,*) PRSTC2(i)
!  enddo
!
  VAL(3)  = VAL(3)  + VALnn( 3)*1.0D-8 + PRSTC2(1)
  VAL(4)  = VAL(4)  + VALnn( 4)*1.0D-8 + PRSTC2(2)
  VAL(5)  = VAL(5)  + VALnn( 5)*1.0D-8 + PRSTC2(3)
  VAL(6)  = VAL(6)  + VALnn( 6)*1.0D-8 + PRSTC2(4)
  VAL(7)  = VAL(7)  + VALnn( 7)*1.0D-8 + PRSTC2(5)
  VAL(8)  = VAL(8)  + VALnn( 8)*1.0D-8 + PRSTC2(6)
  VAL(9)  = VAL(9)  + VALnn( 9)
  VAL(10) = VAL(10) + VALnn(10)
  VAL(11) = VAL(11) + VALnn(11)
  PREST(1,1) = VALnn(3)*1.0D-8 + VALnnC(1,1)
  PREST(2,1) = VALnn(8)*1.0D-8 + VALnnC(2,1)
  PREST(3,1) = VALnn(7)*1.0D-8 + VALnnC(3,1)
  PREST(1,2) = VALnn(8)*1.0D-8 + VALnnC(1,2)
  PREST(2,2) = VALnn(4)*1.0D-8 + VALnnC(2,2)
  PREST(3,2) = VALnn(6)*1.0D-8 + VALnnC(3,2)
  PREST(1,3) = VALnn(7)*1.0D-8 + VALnnC(1,3)
  PREST(2,3) = VALnn(6)*1.0D-8 + VALnnC(2,3)
  PREST(3,3) = VALnn(5)*1.0D-8 + VALnnC(3,3)
!
!  write(*,*)'VAL3-10'
!  do i = 3,10
!    write(*,*) VAL(i),VALnn(i)
!  enddo
!  write(*,*)'VIRLSR=',VIRLSR
!    write(*,*)'fx,fy,fz', fx(1),fy(1),fz(1)
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(23) == 'DIATOMIC  ')  CALL  EWALD_of_DiAtoms 
!
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(29) == 'POLYATOMS ')  CALL  EWALD_of_PolyAtoms
!
!     ---------------------------------------------- RDF for dummy atoms
  IN = 0
  DO IO = 1, NNCOMPO
    DO JO = 1, IO
      IN = IN + 1
      IF (IION(IO) > -998 .AND. NION(JO) > -998) cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)  cycle
      IF (IO == JO         .AND. NION(IO) <= 1)  cycle
      DO K = 1, NRCUT(1)+1
        IRDF(K) = 0
      enddo
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
      DO I = I1, I2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        IF (PIX >= 0.5d0) PIX =PIX -1.0d0
        IF (PIY >= 0.5d0) PIY =PIY -1.0d0
        IF (PIZ >= 0.5d0) PIZ =PIZ -1.0d0
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
                 DO 740  K = 1, 8
                     RX = ABS(PIX - PX(J) + TRANSX(K))
                     RY = ABS(PIY - PY(J) + TRANSY(K))
                     RZ = ABS(PIZ - PZ(J) + TRANSZ(K))
                     DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                     DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                     DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!          DX = ABS(PIX - PX(J))
!          DY = ABS(PIY - PY(J))
!          DZ = ABS(PIZ - PZ(J))
!T                     - - - - - delete these if-statements for triclinic
!          IF (ABS(DX) > 0.5)  DX = 1.0 - DX
!          IF (ABS(DY) > 0.5)  DY = 1.0 - DY
!          IF (ABS(DZ) > 0.5)  DZ = 1.0 - DZ
!          RIJ2 = (DX * BOX(1))**2 + (DY * BOX(2))**2  + (DZ * BOX(3))**2
          RIJ2 = DX**2 + DY**2 + DZ**2
          IF (RIJ2 <= RCUT2)  GO TO 755
  740             CONTINUE
          GO TO 750
  755     CONTINUE
          IP0 = INT( DSQRT(RIJ2) * 100.0D0 )
          IF (IP0 < 1)  IP0 = 1
          IRDF(IP0) = IRDF(IP0) + 1
  750   enddo
      enddo
      IF (MOD(NRECRD(1),IRECRD(5)) == 0 ) THEN
        DO L = 1, NRCUT(1)
          NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
        enddo
      ENDIF
    enddo
  enddo
  RETURN
END
!
!
!                                                             ==========
!=============================================================== EWALDP2
SUBROUTINE  EWALDP2  (myrank, mpsize)
!
!     ===== This subroutine is for CPU's with myrank of greater than 0.
!     =====                          (SLAVE process)
!
  use param
  use atomsi
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use vector
  use radial
  use forces
  use cartes
  use molecu
  use quanco
  use ewal
!  use charge
  use datoms
  use WORK01
  use WORK02
  use thrmint !kwkt
!
!  implicit none
!
!
!
  integer*4    iii(3), jjjj
  double precision   VAL0N(11), VAL0NC(3,3)
  double precision   rrr(7,2)
  integer*4  ierr,idiatom,iquantum,ibmhexp,i,j,myrank,mpsize,ithrmint !kwkt
!
  include  'mpif.h'
  integer*4  status(MPI_STATUS_SIZE)
!
call EWALDP2_NEW( myrank, mpsize ); return
1111 CONTINUE
  call MPI_Bcast (irecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (idiatom,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (iquantum,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ibmhexp,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ithrmint,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)  !kwkt
  call MPI_Bcast (NTION,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NION(1),               lem,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IION(1),               lem,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IONS(1,1),           lem*2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NCOMPO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NPAIR,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (WIO(1),                lem,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ZIO(1),                lem,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NDMOLE,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (RSWTCH(1),             lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (CIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (DIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (D4IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (D7IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (N3BP,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (I3BP(1,1),           L3P*3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ANG3BP(1),             L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (FK3BP(1),              L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (R3BGRD(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (R3BLIM(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (R3LIM(1,1),          L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (E1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (Q1U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (Q2U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ZMOLE(1),                2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (DMOLE(1,1),        4*NTION,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (DINTRA,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IDMOLE(1,1),3*NTION+NDMOLE,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IATOM2(1),               2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IATOMO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !kwkt
  call MPI_Bcast (IATOMH,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !kwkt
  call MPI_Bcast (flambd,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)  !kwkt
  call MPI_Bcast (TRANSX(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
  call MPI_Bcast (TRANSY(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
  call MPI_Bcast (TRANSZ(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
!
2222 continue
  call MPI_Bcast (iii(1),                  3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  nrcut(1) = iii(1)
  nrcut(2) = iii(2)
  nvn      = iii(3)
  if (NVN < -9000)  go to 9999
!
  call MPI_Bcast (H(1,1),                  9,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
!
  call MPI_Bcast (ZII(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (nrecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NVEC(1,1),           3*NVN,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (VEC(1,1),            3*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (FNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (UNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PNV(1,1,1),        3*3*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (rrr(1,1),              7*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  do i=1, 6
    box(i)  = rrr(i,1)
    rbox(i) = rrr(i,2)
  end do
  rcut(1) = rrr(7,1)
  rcut(2) = rrr(7,2)
  call MPI_Bcast (E0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  call MPI_Bcast (PX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (r3limax,                 1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  do I=1, 11
    VAL0N(i) = 0.0D0
  enddo
!
    VAL0NC(:,:) = 0.0D0
!
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
  do j = 1, lee
    do i=1, LTB
      NRDF(i,j) = 0
    enddo
  enddo
!
  do i = 1, 4
    av3bp(1,i) = 0.0D0
    av3bp(2,i) = 0.0D0
  enddo
!
!  PI2   = PI * 2.0D0
!
  do i = 1, ntion + ndmole   !water-pol
    UI(i) = 0.0D0
    FX(i) = 0.0D0
    FY(i) = 0.0D0
    FZ(i) = 0.0D0
  enddo
!
!     ------------------------------------------ Coulomb reciprocal term
!     ------------------------------------ Coulmb direct and short range
!
  call  EWALDP3  (idiatom, iquantum, ibmhexp, ithrmint, val0n, val0NC,myrank, mpsize) !kwkt
!
  val0n(2) = VIRLSR
!
!  call MPI_Recv  (iii, 1, MPI_INTEGER, 0, myrank, MPI_COMM_WORLD,status,ierr)
  call MPI_Recv  (jjjj,                    1,         MPI_INTEGER4,0,myrank,MPI_COMM_WORLD,status,ierr)
  call MPI_Ssend (val0N(1),               11,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
!  val0NC(7) = tqce
  call MPI_Ssend (val0NC(1,1),           3*3,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (EIJTHS,                  1,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr) !kwkt

  call MPI_Ssend (ui(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (FX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (FY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (FZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (NRDF(1,1),       ltb*NPAIR,        MPI_INTEGER4,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (idatom(1,1),101*(ntion+ndmole),    MPI_INTEGER4,0,myrank,MPI_COMM_WORLD,ierr)  !WATER-POL
  call MPI_Ssend (ddatom(1,1),100*(ntion+ndmole),MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr) !WATER-POL
!
!
1112 CONTINUE
!
!
  goto 2222
!
9999 call  MPI_Finalize  (ierr)
  STOP
END
!
!
!                                                             ==========
!=============================================================== EWALDP3
SUBROUTINE  EWALDP3  (idiatom, iquantum, ibmhexp, ithrmint, valnn, VAL0NC,myrank, mpsize) !kwkt
!
!     ===== This subrotine is for both the CPU's with myrank 0 and <>0.
!     =====                              (MASTER and slave processes)
!
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use vector
  use radial
  use forces
  use cartes
  use molecu
  use quanco
  use ewal
!  use charge
  use datoms
  use WORK01
  use WORK02
  use thrmint !kwkt
!
  implicit none
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
  integer(KIND=4)  IRDF(LTB)
  double precision  VALnn(11),VAL0NC(3,3)
  double precision  PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  double precision  PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ,FSIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,UII,EIJ,ESIJ
  double precision  PJX,PJY,PJZ
  double precision  RIJ, RIJ2, RCUT2, SCCSS, zizj
  double precision  E2(LSR),F2(LSR)
  double precision  Q1U2(LSR),Q2U2(LSR),QCEIJ,ANWIO,ANWJO,QS1,QS2
  double precision  ECDD, FCDD
  double precision  arij, arij2, arij3, arij4
  double precision  sdx(lni),sdy(lni),sdz(lni), srij2(lni),srij(lni)
  integer(KIND=4)  isj(lni)
  integer(KIND=4)  i, NNCOMPO,idiatom,iquantum,ibmhexp,in, myrank, io, i1, i2
  integer(KIND=4)  max_nsatom,jo,k,mpsize,j1,j2,nsatom,j,jj,ip0,ip1,ip2,L,idd
  integer*4 ithrmint, ishort !kwkt
!
  include 'mpif.h'
  call EWALDP3_NEW( idiatom, iquantum, ibmhexp, ithrmint, valnn, VAL0NC,myrank, mpsize ); return
! 
!
!                                PI2   = PI * 2.0D0
idd = 0
!
      ddatom(:,:) = 0.0d0
      idatom(:,:) = 0
!
  NNCOMPO = NCOMPO
!
!
  IF (NVN <= 0)   GO TO 200
!
!  PI2 = PI*2.0d0
  DO I = 1, NTION + ndmole
    ZICOS(I) = 0.0D0
    ZISIN(I) = 0.0D0
  enddo
!
  do in = myrank+1, NVN, mpsize
    SICOS = 0.0D0
    SISIN = 0.0D0
    DX = dble(NVEC(1,IN)) * PI2  !OK
    DY = dble(NVEC(2,IN)) * PI2
    DZ = dble(NVEC(3,IN)) * PI2
    DO IO = 1, NNCOMPO
      IF (IION(IO) < -998)  cycle
      IF (NION(IO) > 0 ) THEN           !WATER-POL
        I1 = IONS(1,IO)
        I2 = IONS(2,IO)
!!        ZJ = ZIO(IO)
        DO I = I1, I2
          PHI     = DX*PX(I) + DY*PY(I) + DZ*PZ(I) ! OK
          ZICOS(I) = COS(PHI) * ZII(I)               !WATER-POL
          SICOS    = SICOS + ZICOS(I)
          ZISIN(I) = SIN(PHI) * ZII(I)               !WATER-POL
          SISIN    = SISIN + ZISIN(I)   !OK
        enddo
      END IF
    enddo
    if (idiatom == 1)  then
      I1 = ntion+1
      I2 = ntion + ndmole
      DO I = I1, I2
        PHI      = DX*PX(I) + DY*PY(I) + DZ*PZ(I)
        ZICOS(I) = COS(PHI) * Zii(i)
        SICOS    = SICOS + ZICOS(I)
        ZISIN(I) = SIN(PHI) * Zii(i)
        SISIN    = SISIN + ZISIN(I)
      enddo
    end if
!
    FSICOS = FNV(IN) * SICOS
    FSISIN = FNV(IN) * SISIN
    USICOS = UNV(IN) * SICOS
    USISIN = UNV(IN) * SISIN
    SCCSS  = SICOS**2 + SISIN**2
!          if (myrank == 1) write(*,*)SICOS,SISIN,FSICOS,FSISIN,USICOS,USISIN 
!          if (myrank == 1) write(*,*) FNV(IN),IN
!
    VALnn(9)  = VALnn(9)  + UNV(IN)   * SCCSS         !OK
     VAL0NC(1,1) = VAL0NC(1,1) + PNV(1,1,IN) * SCCSS !OK  
     VAL0NC(2,1) = VAL0NC(2,1) + PNV(2,1,IN) * SCCSS !OK
     VAL0NC(3,1) = VAL0NC(3,1) + PNV(3,1,IN) * SCCSS !OK
     VAL0NC(1,2) = VAL0NC(1,2) + PNV(1,2,IN) * SCCSS !OK
     VAL0NC(2,2) = VAL0NC(2,2) + PNV(2,2,IN) * SCCSS !OK
     VAL0NC(3,2) = VAL0NC(3,2) + PNV(3,2,IN) * SCCSS !OK
     VAL0NC(1,3) = VAL0NC(1,3) + PNV(1,3,IN) * SCCSS !OK
     VAL0NC(2,3) = VAL0NC(2,3) + PNV(2,3,IN) * SCCSS !OK
     VAL0NC(3,3) = VAL0NC(3,3) + PNV(3,3,IN) * SCCSS !OK
     FIX = VEC(1,IN)
     FIY = VEC(2,IN)
     FIZ = VEC(3,IN)
!    VAL0NC(1) = VAL0NC(1) + PNV(1,IN) * SCCSS
!    VAL0NC(2) = VAL0NC(2) + PNV(2,IN) * SCCSS
!    VAL0NC(3) = VAL0NC(3) + PNV(3,IN) * SCCSS
!    VAL0NC(4) = VAL0NC(4) + PNV(4,IN) * SCCSS
!    VAL0NC(5) = VAL0NC(5) + PNV(5,IN) * SCCSS
!    VAL0NC(6) = VAL0NC(6) + PNV(6,IN) * SCCSS
!    FIX    = dble(NVEC(1,IN)) * RBOX(1)
!    FIY    = dble(NVEC(2,IN)) * RBOX(2)
!    FIZ    = dble(NVEC(3,IN)) * RBOX(3)
    DO I = 1, NTION + ndmole
      UI(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UI(I)
      FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
      FX(I) = FX(I) + FIJ * FIX
      FY(I) = FY(I) + FIJ * FIY
      FZ(I) = FZ(I) + FIJ * FIZ
    enddo
  enddo
!
!write(*,*)'fx,fy,fz',fx(1),fy(1),fz(1),myrank
  valnn(9) = valnn(9) * 0.5D0
!
!
!     --------------- Coulomb direct lattice space and short range terms
!
200 RCUT2 = RCUT(1) * RCUT(1)
  max_nsatom = 0
  EIJTHS = 0.0d0 !kwkt
  IN = 0
  DO IO = 1, NNCOMPO
    DO JO = 1, IO
!     ------------------------------------------------------------------------
      flam = 1.0D0 !kwkt
      ishort=0
      if (ithrmint == 1 ) then
        if (IO == IATOMO .or. IO == IATOMH .or. JO == IATOMO .or. JO == IATOMH) then
          flam = flambd
        endif
        if (IO == IATOMO .and. JO == IATOMO) flam = 1.0D0
        if (IO == IATOMO .and. JO == IATOMH) flam = 1.0D0
        if (IO == IATOMH .and. JO == IATOMO) flam = 1.0D0
        if (IO == IATOMH .and. JO == IATOMH) flam = 1.0D0
        if (IO == IATOMO .and. JO == IATOMO) ishort = 1
        if (IO == IATOMO .and. JO == IATOMH) ishort = 1
        if (IO == IATOMH .and. JO == IATOMO) ishort = 1
        if (IO == IATOMH .and. JO == IATOMH) ishort = 1
      endif
!     -----------------------------------------------------------------------
      IN = IO*(IO-1)/2 + JO
      IF (IO < JO)  IN = JO*(JO-1)/2 + IO
      IF (IION(IO) <= -998 .OR.  IION(JO) <= -998)  cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)     cycle
      IF (IO == JO         .AND. NION(IO) <= 1)     cycle
!
!      ZIZJ = ZIO(IO) * ZIO(JO)
      DO K = 1, NRCUT(2)
        E2(K) = E1(K,IN)
        F2(K) = F1(K,IN)
      enddo
      IF (iQUANTUM == 1)  THEN
        DO K = 1, NRCUT(2)
          Q1U2(K) = Q1U1(K,IN)
          Q2U2(K) = Q2U1(K,IN)
        enddo
        QCEIJ = 0.0D0
      END IF
      DO K = 1, NRCUT(1)+1
        IRDF(K) = 0
      enddo
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
!
!         write (6,*)  io,jo
!
      if (i1+myrank > i2)  go to 322
      DO I = I1+myrank, I2, mpsize


! Under construction 20150615
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        IF (PIX >= 0.5d0) PIX = PIX -1.0d0
        IF (PIY >= 0.5d0) PIY = PIY -1.0d0
        IF (PIZ >= 0.5d0) PIZ = PIZ -1.0d0
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        nsatom = 0
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
          do K = 1, 8
            PJX = PX(J) - TRANSX(K)
            PJY = PY(J) - TRANSY(K)
            PJZ = PZ(J) - TRANSZ(K)
            RX = PIX - PJX
            RY = PIY - PJY
            RZ = PIZ - PJZ
!            IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)
!            IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)
!            IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)
            DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
            DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
            DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!            DX = RX * BOX(1)
!            DY = RY * BOX(2)
!            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
!            write(*,*)'RIJ2,myrank=',RIJ2,myrank
            IF (RIJ2 <= RCUT2)  then
              nsatom = nsatom + 1
              isj(nsatom)   = j
              sDX(nsatom)   = dx
              sDY(nsatom)   = dy
              sDZ(nsatom)   = dz
              sRIJ2(nsatom) = rij2
            end if
          enddo
        enddo
!
        if (max_nsatom < nsatom)  max_nsatom = nsatom
!
!             write (6,*)  'nsatom=',nsatom
!
        do jj = 1, nsatom
          j    = isj(jj)
          dx   = sDX(jj)
          dy   = sDY(jj)
          dz   = sDZ(jj)
!write(*,*)'dx,dy,dz,myrank',dx,dy,dz,myrank
          rij2 = srij2(jj)
          rij  = DSQRT(RIJ2)
          ARIJ = 1.0D0 / RIJ
          srij(jj) = rij
!write(*,*)'srij=',srij(jj)
          ZIZJ = ZII(i)*ZII(j)                                !WATER-POL
! write(*,*)'ZII(i),ZII(j)',ZII(i),ZII(j),myrank
!         ------------------------------------ Interpolation
          IP0 = INT(RIJ*100.0D0)
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = dble(IP0) * 0.01D0
          R01 = dble(IP1) * 0.01D0
          R02 = dble(IP2) * 0.01D0
!                     X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                     X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                     X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0D0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0D0
          FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
          VALnn(9) = VALnn(9) + EIJ  !OK
!         ---------- Charge-dipole and dipole-induced dipole
          IF (RIJ > RSWTCH(IN) .and. &
              abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0) then
            ARIJ2 = ARIJ * ARIJ
            ARIJ3 = ARIJ2 * ARIJ
            ARIJ4 = ARIJ3 * ARIJ
            ECDD = (- CIJ(IN)*ARIJ2 - DIJ(IN)*ARIJ4  &
                    - D4IJ(IN) - D7IJ(IN)*ARIJ3)*ARIJ4
            FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +  &
                      8.0D0*DIJ(IN) *ARIJ2*ARIJ3 + &
                      4.0D0*D4IJ(IN)*ARIJ + &
                      7.0D0*D7IJ(IN)*ARIJ4 )*ARIJ4 &
                      * ARIJ*1.0D8
            EIJ   = EIJ + ECDD *flam !kwkt
            if(ishort == 1) EIJTHS = EIJTHS + ECDD*flam !kwkt
            FIJ   = FIJ + FCDD *flam !kwkt
            VALnn(10) = VALnn(10) + ECDD *flam !kwkt
            VIRLSR    = VIRLSR + FCDD*RIJ2 *flam !kwkt
          END IF
!         ------------------------- Short range interactions
          ESIJ = 0.0D0
          FSIJ = 0.0D0
          IF (RIJ <= RCUT(2))  THEN
!           ---------------------------- Interpolation
            FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
            ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!           ------------------------------------------
            FIJ  = FIJ + FSIJ *flam !kwkt
            EIJ  = EIJ + ESIJ *flam !kwkt
            if(ishort == 1) EIJTHS = EIJTHS + ESIJ*flam !kwkt
            VALnn(10) = VALnn(10)  + ESIJ *flam !kwkt
            VIRLSR = VIRLSR + FSIJ*RIJ2 *flam !kwkt
          END IF
          UII   = UII   + EIJ
          UI(J) = UI(J) + EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
!          write(*,*)'DFX,DFY,DFZ,DX,DY,DZ'
!          write(*,*)DFX,DFY,DFZ,DX,DY,DZ
          VALnn(3) = VALnn(3) + DFX * DX
          VALnn(4) = VALnn(4) + DFY * DY
          VALnn(5) = VALnn(5) + DFZ * DZ
          VALnn(6) = VALnn(6) + DFY * DZ
          VALnn(7) = VALnn(7) + DFX * DZ
          VALnn(8) = VALnn(8) + DFX * DY
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
        do jj = 1, nsatom
          IP0 = INT(sRIJ(jj)*100.0d0)
          IRDF(IP0) = IRDF(IP0) + 1
           if (srij(jj) <= r3limax)  then
!                   write(*,*)'r3limax=',r3limax
!                   write(*,*)'srij',srij(jj),jj
             idatom(101,i)= idatom(101,i) + 1  
             ddatom(idatom(101,i),i) = srij(jj)
             idatom(idatom(101,i),i) = isj(jj) + jo*1000000
             j=isj(jj)
             idatom(101,j)= idatom(101,j) + 1
             ddatom(idatom(101,j),j) = srij(jj)
             idatom(idatom(101,j),j) = i + io*1000000
!write(*,*) idatom(101,i)
           end if
        enddo
!             ---------------------------------- Quantum correction term
        IF (iquantum == 1)  THEN
          DO J = 1, NsATOM
            RIJ = srij(J)
            IF (RIJ <= RCUT(2))  THEN
              IP0 = INT(RIJ*100.0)
              IP1 = IP0 + 1
              IP2 = IP0 + 2
              R00 = IP0 * 0.01
              R01 = IP1 * 0.01
              R02 = IP2 * 0.01
!                        X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                        X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                        X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
              X0  = (RIJ-R01)*(RIJ-R02) *    5000.0
              X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0)
              X2  = (RIJ-R00)*(RIJ-R01) *    5000.0
              QS1 = Q1U2(IP0)*X0 +Q1U2(IP1)*X1 +Q1U2(IP2)*X2
              QS2 = Q2U2(IP0)*X0 +Q2U2(IP1)*X1 +Q2U2(IP2)*X2
!
!Q                       ARIJ = 1.0D0 / RIJ
!                        ------------ Short range rep. and van der Waals
!Q                       QS1 = -EXP((AIJ(IN) - RIJ) / BIJ(IN)) * 1.0E8
!Q                       QS2 = -QS1 / BIJ(IN) * 1.0E8
!                        --------------------------------- Van der Waals
!Q                       QVW =       6.0 * CIJ(IN) * ARIJ**7 * 1.0E8
!Q                       QS1 = QS1 + QVW
!Q                       QS2 = QS2 - 7.0 * QVW     * ARIJ    * 1.0E8
!                        ------------------------------------ Morse term
!Q                       QMS1 = 0.0
!Q                       QMS2 = 0.0
!Q                       IF (DMIJ(IN) > 0.001) THEN
!Q                             D2  = DMIJ(IN) * 2.0D0
!Q                             AM1 = EXP(-2.0D0*BEIJN*(RIJ-RSIJ(IN)))
!Q                             AM2 = EXP(-1.0D0*BEIJN*(RIJ-RSIJ(IN)))
!Q                             QMS1= D2*BEIJN    * (   -AM1+AM2) *1.0E8
!Q                             QMS2= D2*BEIJN**2 * (2.0*AM1-AM2) *1.0E16
!Q                       END IF
!Q                       QS1 = (QS1 + QMS1) *BETA *ARIJ*1.0E8
!Q                       QS2 = (QS2 + QMS2) *BETA
!
              QCEIJ = QCEIJ + ( 2.0*QS1 + QS2 )
            end if
          enddo
        END IF
      enddo
!
!
322   IF (IQUANTUM == 1)  THEN
        ANWIO = ANA / WIO(IO)
        ANWJO = ANA / WIO(JO)
!                ------------------------------------ QCEij : nabla(Uij)
!                                            TQCE : sum of nabla(Uij)/mi
        TQCE   = TQCE   + QCEIJ*ANWIO + QCEIJ*ANWJO
      END IF
        IF (MOD(NRECRD(1),IRECRD(5)) == 0 ) THEN
          DO  L = 1, NRCUT(1)
            NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
!            if (IN == 1) write(*,*)'NRDF=',NRDF(L,1)
          end do
        end if
    enddo
  enddo
!
  RETURN
END
!
!
!                                                    ===================
!====================================================== EWALD_of_DiAtoms
      SUBROUTINE  EWALD_of_DiAtoms 
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE VECTOR
      USE VALUES
      USE TABLES
      USE MOLECU
      USE PMORSE
      USE DATOMS
      use ewal
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
      implicit none
!
      double precision   PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0
      double precision   PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ
      double precision   PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,EIJ
      double precision   PJX,PJY,PJZ
      double precision   PRESXX,PRESYY,PRESZZ,PRESYZ,PRESXZ,PRESXY,VAL09
      double precision   RIJ2, RCUT2, SCCSS, PRESTM(3,3),VAL09C
      double precision   RIJ,  PHI
      double precision   pjx0,pjy0,pjz0, ZIZJ
      double precision   pm(3,lni),zm(LNI),FM(3,LNI),um(3)
      integer(KIND=4)  I,J,ijkl,N,IN,K,IP0,IP1,IP2,II
!
!P    REAL  *8  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    REAL  *8  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3    /10.00464,8.426553,3.460259,0.5623536   /
!P    DATA EY0,EY1,EY2,EY3,EY4/10.00464,19.71558,15.70229,6.090749,1.0/
!
           PRESXX = 0.0D0
           PRESYY = 0.0D0
           PRESZZ = 0.0D0
           PRESYZ = 0.0D0
           PRESXZ = 0.0D0
           PRESXY = 0.0D0
           VAL09  = 0.0D0
           VAL09C = 0.0D0
           DO 50  I = 1, 3
               DO 51  J = 1, 3
                   PRESTM(J,I) = 0.0D0
   51          continue
   50      CONTINUE
!
!     ------------------------------------------ Coulomb reciprocal term
!
      do 999  ijkl = 1, ndmole
          do 977  N=1, 2
             I = IDMOLE(N,IJKL)
             ZM(N) = ZII(I)
             do 978 K = 1, 3
                PM(K,N) = P(K,I)
  978        continue
  977     CONTINUE
          ZM(3) = ZMOLE(IDMOLE(3,IJKL))
          PM(1,3) = P(1,NTION+IJKL)
          PM(2,3) = P(2,NTION+IJKL)
          PM(3,3) = P(3,NTION+IJKL)
          DO 988  I = 1, 3
             UM(I) = 0.0
             DO 989 K = 1, 3
                FM(K,I) = 0.0
  989        continue
  988     CONTINUE
          IF (NVN == 0)  GO TO 200
!                                PI2   = PI * 2.0D0
                                DO 110  I = 1, NTION
                                    ZICOS(I) = 0.0D0
                                    ZISIN(I) = 0.0D0
  110                           CONTINUE
!
                                VAL09C = 0.0D0
      DO 170  IN = 1, NVN
          SICOS = 0.0D0
          SISIN = 0.0D0
          DX = NVEC(1,IN) * PI2
          DY = NVEC(2,IN) * PI2
          DZ = NVEC(3,IN) * PI2
          DO 122  I = 1, 3
             PHI      = DX*PM(1,I) + DY*PM(2,I) + DZ*PM(3,I)
             ZICOS(I) = COS(PHI) * ZM(i)
             SICOS    = SICOS + ZICOS(I)
             ZISIN(I) = SIN(PHI) * ZM(i)
             SISIN    = SISIN + ZISIN(I)
  122     CONTINUE
!
          FSICOS = FNV(IN) * SICOS
          FSISIN = FNV(IN) * SISIN
          USICOS = UNV(IN) * SICOS
          USISIN = UNV(IN) * SISIN
          SCCSS  = SICOS**2 + SISIN**2
          VAL09C = VAL09C + UNV(IN) * SCCSS
          PRESTM(1,1) = PRESTM(1,1) + PNV(1,1,IN) * SCCSS
          PRESTM(2,1) = PRESTM(2,1) + PNV(2,1,IN) * SCCSS
          PRESTM(3,1) = PRESTM(3,1) + PNV(3,1,IN) * SCCSS
          PRESTM(1,2) = PRESTM(1,2) + PNV(1,2,IN) * SCCSS
          PRESTM(2,2) = PRESTM(2,2) + PNV(2,2,IN) * SCCSS
          PRESTM(3,2) = PRESTM(3,2) + PNV(3,2,IN) * SCCSS
          PRESTM(1,3) = PRESTM(1,3) + PNV(1,3,IN) * SCCSS
          PRESTM(2,3) = PRESTM(2,3) + PNV(2,3,IN) * SCCSS
          PRESTM(3,3) = PRESTM(3,3) + PNV(3,3,IN) * SCCSS
                FIX = VEC(1,IN)
                FIY = VEC(2,IN)
                FIZ = VEC(3,IN)
          DO 152  I = 1, 3
             UM(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UM(I)
             FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
             FM(1,I) = FM(1,I) + FIJ * FIX
             FM(2,I) = FM(2,I) + FIJ * FIY
             FM(3,I) = FM(3,I) + FIJ * FIZ
  152     CONTINUE
  170 CONTINUE
      VAL09 = VAL09 + VAL09C * 0.5D0
!
!     ----------------------------------- Coulomb direct lattice space
!
  200       RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!     ------------------ Calculation of Coulomb of three point charges
          DO 392  I = 1, 2
             PIX = PM(1,I)
             PIY = PM(2,I)
             PIZ = PM(3,I)
             DO 382  J = I+1, 3
                ZIZJ = ZM(I) * ZM(J)
                 pjx0 = pM(1,j)
                 pjy0 = pM(2,j)
                 pjz0 = pM(3,j)
                 if (pjx0.lt.pix)  pjx0 = pjx0 + 1.0
                 if (pjy0.lt.piy)  pjy0 = pjy0 + 1.0
                 if (pjz0.lt.piz)  pjz0 = pjz0 + 1.0
                 DO 252  K = 1, 8
                       pjx = pjx0 - transx(k)
                       pjy = pjy0 - transy(k)
                       pjz = pjz0 - transz(k)
                        RX = PIX - PjX
                        RY = PIY - PjY
                        RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                           DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                           DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                           DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!                       DX = RX * BOX(1)
!                       DY = RY * BOX(2)
!                       DZ = RZ * BOX(3)
                      RIJ2 = DX*DX + DY*DY + DZ*DZ
                      IF (RIJ2.LE.RCUT2)  GO TO 257
  252          CONTINUE
               GO TO 262
!
  257                   RIJ = SQRT(RIJ2)
                        IP0 = INT(RIJ*100.0)
!                       ---------------------------------- Interpolation
                        IP1 = IP0 + 1
                        IP2 = IP0 + 2
                        R00 = IP0 * 0.01D0
                        R01 = IP1 * 0.01D0
                        R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
                        X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
                        X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
                        X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
                        FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
                        EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) * 
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
                        VAL09 = VAL09 + EIJ
                        UM(I) = UM(I) + EIJ
                        UM(J) = UM(J) + EIJ
                        DFX = FIJ * DX
                        DFY = FIJ * DY
                        DFZ = FIJ * DZ
                      FM(1,I) = FM(1,I) + DFX
                      FM(2,I) = FM(2,I) + DFY
                      FM(3,I) = FM(3,I) + DFZ
                      FM(1,J) = FM(1,J) - DFX
                      FM(2,J) = FM(2,J) - DFY
                      FM(3,J) = FM(3,J) - DFZ
                   PRESXX = PRESXX + DFX * DX
                   PRESYY = PRESYY + DFY * DY
                   PRESZZ = PRESZZ + DFZ * DZ
                   PRESYZ = PRESYZ + DFY * DZ
                   PRESXZ = PRESXZ + DFX * DZ
                   PRESXY = PRESXY + DFX * DY
  262         CONTINUE
  382    CONTINUE
  392    CONTINUE
         UI(NTION+IJKL) = UI(NTION+IJKL) - UM(3)
         FX(NTION+IJKL) = FX(NTION+IJKL) - FM(1,3)
         FY(NTION+IJKL) = FY(NTION+IJKL) - FM(2,3)
         FZ(NTION+IJKL) = FZ(NTION+IJKL) - FM(3,3)
         DO 955 II = 1, 2
            I = IDMOLE(II,IJKL)
            UI(I) = UI(I) - UM(II)
            FX(I) = FX(I) - FM(1,II)
            FY(I) = FY(I) - FM(2,II)
            FZ(I) = FZ(I) - FM(3,II)
            fx(i) = fx(i) + fx(ntion+ijKL) / 2.0
            fy(i) = fy(i) + fy(ntion+ijKL) / 2.0
            fz(i) = fz(i) + fz(ntion+ijKL) / 2.0
            ui(i) = ui(i) + ui(ntion+ijKL) / 2.0
  955    CONTINUE
  999 continue
!
            PRSTC2(1) = PRSTC2(1) - PRESTM(1,1)
            PRSTC2(2) = PRSTC2(2) - PRESTM(2,2)
            PRSTC2(3) = PRSTC2(3) - PRESTM(3,3)
            PRSTC2(4) = PRSTC2(4) - (PRESTM(2,3)+PRESTM(3,2)) / 2.0
            PRSTC2(5) = PRSTC2(5) - (PRESTM(1,3)+PRESTM(3,1)) / 2.0
            PRSTC2(6) = PRSTC2(6) - (PRESTM(1,2)+PRESTM(2,1)) / 2.0
        VAL(3) = VAL(3) - PRESXX*1.0D-8 - PRESTM(1,1)
        VAL(4) = VAL(4) - PRESYY*1.0D-8 - PRESTM(2,2)
        VAL(5) = VAL(5) - PRESZZ*1.0D-8 - PRESTM(3,3)
        VAL(6) = VAL(6) - PRESYZ*1.0D-8 - (PRESTM(2,3)+PRESTM(3,2))/2.0
        VAL(7) = VAL(7) - PRESXZ*1.0D-8 - (PRESTM(1,3)+PRESTM(3,1))/2.0
        VAL(8) = VAL(8) - PRESXY*1.0D-8 - (PRESTM(1,2)+PRESTM(2,1))/2.0
        VAL(9) = VAL(9) - VAL09
              II = IATOM2(1)
              IF (II.NE.0)  VAL(9) = VAL(9) - UCSLFI(II)
              II = IATOM2(2)
              IF (II.NE.0)  VAL(9) = VAL(9) - UCSLFI(II)
!       ------------------------------------------------ Pressure tensor
          PREST(1,1) = PREST(1,1) - (PRESXX*1.0D-8 + PRESTM(1,1))
          PREST(2,1) = PREST(2,1) - (PRESXY*1.0D-8 + PRESTM(2,1))
          PREST(3,1) = PREST(3,1) - (PRESXZ*1.0D-8 + PRESTM(3,1))
          PREST(1,2) = PREST(1,2) - (PRESXY*1.0D-8 + PRESTM(1,2))
          PREST(2,2) = PREST(2,2) - (PRESYY*1.0D-8 + PRESTM(2,2))
          PREST(3,2) = PREST(3,2) - (PRESYZ*1.0D-8 + PRESTM(3,2))
          PREST(1,3) = PREST(1,3) - (PRESXZ*1.0D-8 + PRESTM(1,3))
          PREST(2,3) = PREST(2,3) - (PRESYZ*1.0D-8 + PRESTM(2,3))
          PREST(3,3) = PREST(3,3) - (PRESZZ*1.0D-8 + PRESTM(3,3))
      RETURN
      END
!
!
!                                                  =====================
!==================================================== EWALD_of_PolyAtoms
      SUBROUTINE  EWALD_of_PolyAtoms 
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE FORCES
      USE CARTES
      USE WORK01
      USE WORK02
      USE VECTOR
      USE VALUES
      USE TABLES
      USE MOLECU
      USE PMORSE
      USE DATOMS
      use ewal
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
      implicit none
!
      double precision    PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0
      double precision    PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ
      double precision    PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,EIJ
      double precision    PRESXX,PRESYY,PRESZZ,PRESYZ,PRESXZ,PRESXY,VAL09
      double precision    RIJ2, RCUT2, SCCSS, PRESTM(3,3),VAL09C
      double precision    RIJ,  PHI,ZIZJ
      double precision    pjx0,pjy0,pjz0, PJX,PJY,PJZ
      double precision    pm(3,lni),zm(LNI),FM(3,LNI),um(3)
      integer(KIND=4)  I,J,ijkl,N,K,IN,II,IP0,IP1,IP2
!
!P    REAL  *8  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    REAL  *8  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3    /10.00464,8.426553,3.460259,0.5623536   /
!P    DATA EY0,EY1,EY2,EY3,EY4/10.00464,19.71558,15.70229,6.090749,1.0/
!
           PRESXX = 0.0D0
           PRESYY = 0.0D0
           PRESZZ = 0.0D0
           PRESYZ = 0.0D0
           PRESXZ = 0.0D0
           PRESXY = 0.0D0
           VAL09  = 0.0D0
           VAL09C = 0.0D0
           DO 50  I = 1, 3
               DO 51  J = 1, 3
                   PRESTM(J,I) = 0.0D0
   51          continue
   50      CONTINUE
!
!     ------------------------------------------ Coulomb reciprocal term
!
      do 999  ijkl = 1, nmole
          do 977  N=1, mmole(ijkl)
             I = IMOLE(N,IJKL)
             ZM(N) = ZII(I)
             do 978 K = 1, 3
                PM(K,N) = P(K,I)
  978        continue
  977     CONTINUE
          DO 988  I = 1, mmole(ijkl)
             UM(I) = 0.0
             DO 989 K = 1, 3
                FM(K,I) = 0.0
  989        CONTINUE
  988     CONTINUE
          IF (NVN == 0)  GO TO 200
!                                PI2   = PI * 2.0D0
                                DO 110  I = 1, NTION
                                    ZICOS(I) = 0.0D0
                                    ZISIN(I) = 0.0D0
  110                           CONTINUE
!
                                VAL09C = 0.0D0
      DO 170  IN = 1, NVN
          SICOS = 0.0D0
          SISIN = 0.0D0
          DX = NVEC(1,IN) * PI2
          DY = NVEC(2,IN) * PI2
          DZ = NVEC(3,IN) * PI2
          DO 122  I = 1, mmole(ijkl)
             PHI      = DX*PM(1,I) + DY*PM(2,I) + DZ*PM(3,I)
             ZICOS(I) = COS(PHI) * ZM(i)
             SICOS    = SICOS + ZICOS(I)
             ZISIN(I) = SIN(PHI) * ZM(i)
             SISIN    = SISIN + ZISIN(I)
  122     CONTINUE
!
          FSICOS = FNV(IN) * SICOS
          FSISIN = FNV(IN) * SISIN
          USICOS = UNV(IN) * SICOS
          USISIN = UNV(IN) * SISIN
          SCCSS  = SICOS**2 + SISIN**2
          VAL09C = VAL09C + UNV(IN) * SCCSS
          PRESTM(1,1) = PRESTM(1,1) + PNV(1,1,IN) * SCCSS
          PRESTM(2,1) = PRESTM(2,1) + PNV(2,1,IN) * SCCSS
          PRESTM(3,1) = PRESTM(3,1) + PNV(3,1,IN) * SCCSS
          PRESTM(1,2) = PRESTM(1,2) + PNV(1,2,IN) * SCCSS
          PRESTM(2,2) = PRESTM(2,2) + PNV(2,2,IN) * SCCSS
          PRESTM(3,2) = PRESTM(3,2) + PNV(3,2,IN) * SCCSS
          PRESTM(1,3) = PRESTM(1,3) + PNV(1,3,IN) * SCCSS
          PRESTM(2,3) = PRESTM(2,3) + PNV(2,3,IN) * SCCSS
          PRESTM(3,3) = PRESTM(3,3) + PNV(3,3,IN) * SCCSS
                FIX = VEC(1,IN)
                FIY = VEC(2,IN)
                FIZ = VEC(3,IN)
          DO 152  I = 1, mmole(ijkl)
             UM(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UM(I)
             FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
             FM(1,I) = FM(1,I) + FIJ * FIX
             FM(2,I) = FM(2,I) + FIJ * FIY
             FM(3,I) = FM(3,I) + FIJ * FIZ
  152     CONTINUE
  170 CONTINUE
      VAL09 = VAL09 + VAL09C * 0.5D0
!
!     ------------------------------------- Coulomb direct lattice space
!
  200       RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!     ------------------ Calculation of Coulomb in a polyatomic molecule
          DO 392  I = 1, mmole(ijkl)-1
             PIX = PM(1,I)
             PIY = PM(2,I)
             PIZ = PM(3,I)
             DO 382  J = I+1, mmole(ijkl)
                ZIZJ = ZM(I) * ZM(J)
                 pjx0 = pM(1,j)
                 pjy0 = pM(2,j)
                 pjz0 = pM(3,j)
                 if (pjx0.lt.pix)  pjx0 = pjx0 + 1.0
                 if (pjy0.lt.piy)  pjy0 = pjy0 + 1.0
                 if (pjz0.lt.piz)  pjz0 = pjz0 + 1.0
                 DO 252  K = 1, 8
                       pjx = pjx0 - transx(k)
                       pjy = pjy0 - transy(k)
                       pjz = pjz0 - transz(k)
                        RX = PIX - PjX
                        RY = PIY - PjY
                        RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                           DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                           DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                           DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!                       DX = RX * BOX(1)
!                       DY = RY * BOX(2)
!                       DZ = RZ * BOX(3)
                      RIJ2 = DX*DX + DY*DY + DZ*DZ
                      IF (RIJ2.LE.RCUT2)  GO TO 257
  252          CONTINUE
               GO TO 262
!
  257                   RIJ = SQRT(RIJ2)
                        IP0 = INT(RIJ*100.0)
!                       ---------------------------------- Interpolation
                        IP1 = IP0 + 1
                        IP2 = IP0 + 2
                        R00 = IP0 * 0.01D0
                        R01 = IP1 * 0.01D0
                        R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
                        X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
                        X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
                        X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
                        FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
                        EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) * 
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
                        VAL09 = VAL09 + EIJ
                        UM(I) = UM(I) + EIJ
                        UM(J) = UM(J) + EIJ
                        DFX = FIJ * DX
                        DFY = FIJ * DY
                        DFZ = FIJ * DZ
                      FM(1,I) = FM(1,I) + DFX
                      FM(2,I) = FM(2,I) + DFY
                      FM(3,I) = FM(3,I) + DFZ
                      FM(1,J) = FM(1,J) - DFX
                      FM(2,J) = FM(2,J) - DFY
                      FM(3,J) = FM(3,J) - DFZ
                   PRESXX = PRESXX + DFX * DX
                   PRESYY = PRESYY + DFY * DY
                   PRESZZ = PRESZZ + DFZ * DZ
                   PRESYZ = PRESYZ + DFY * DZ
                   PRESXZ = PRESXZ + DFX * DZ
                   PRESXY = PRESXY + DFX * DY
  262         CONTINUE
  382    CONTINUE
  392    CONTINUE
         UI(NTION+IJKL) = UI(NTION+IJKL) - UM(3)
         FX(NTION+IJKL) = FX(NTION+IJKL) - FM(1,3)
         FY(NTION+IJKL) = FY(NTION+IJKL) - FM(2,3)
         FZ(NTION+IJKL) = FZ(NTION+IJKL) - FM(3,3)
         DO 955 II = 1, mmole(ijkl)
            I = IDMOLE(II,IJKL)
            UI(I) = UI(I) - UM(II)
            FX(I) = FX(I) - FM(1,II)
            FY(I) = FY(I) - FM(2,II)
            FZ(I) = FZ(I) - FM(3,II)
            fx(i) = fx(i) + fx(ntion+ijKL) / 2.0
            fy(i) = fy(i) + fy(ntion+ijKL) / 2.0
            fz(i) = fz(i) + fz(ntion+ijKL) / 2.0
            ui(i) = ui(i) + ui(ntion+ijKL) / 2.0
  955    CONTINUE
  999 continue
!
            PRSTC2(1) = PRSTC2(1) - PRESTM(1,1)
            PRSTC2(2) = PRSTC2(2) - PRESTM(2,2)
            PRSTC2(3) = PRSTC2(3) - PRESTM(3,3)
            PRSTC2(4) = PRSTC2(4) - (PRESTM(2,3)+PRESTM(3,2)) / 2.0
            PRSTC2(5) = PRSTC2(5) - (PRESTM(1,3)+PRESTM(3,1)) / 2.0
            PRSTC2(6) = PRSTC2(6) - (PRESTM(1,2)+PRESTM(2,1)) / 2.0
        VAL(3) = VAL(3) - PRESXX*1.0D-8 - PRESTM(1,1)
        VAL(4) = VAL(4) - PRESYY*1.0D-8 - PRESTM(2,2)
        VAL(5) = VAL(5) - PRESZZ*1.0D-8 - PRESTM(3,3)
        VAL(6) = VAL(6) - PRESYZ*1.0D-8 - (PRESTM(2,3)+PRESTM(3,2))/2.0
        VAL(7) = VAL(7) - PRESXZ*1.0D-8 - (PRESTM(1,3)+PRESTM(3,1))/2.0
        VAL(8) = VAL(8) - PRESXY*1.0D-8 - (PRESTM(1,2)+PRESTM(2,1))/2.0
        VAL(9) = VAL(9) - VAL09
              do ii = MOLstart(1), MOLend(1)
                  VAL(9) = VAL(9) - UCSLFI(II)
              end do
!       ------------------------------------------------ Pressure tensor
          PREST(1,1) = PREST(1,1) - (PRESXX*1.0D-8 + PRESTM(1,1))
          PREST(2,1) = PREST(2,1) - (PRESXY*1.0D-8 + PRESTM(2,1))
          PREST(3,1) = PREST(3,1) - (PRESXZ*1.0D-8 + PRESTM(3,1))
          PREST(1,2) = PREST(1,2) - (PRESXY*1.0D-8 + PRESTM(1,2))
          PREST(2,2) = PREST(2,2) - (PRESYY*1.0D-8 + PRESTM(2,2))
          PREST(3,2) = PREST(3,2) - (PRESYZ*1.0D-8 + PRESTM(3,2))
          PREST(1,3) = PREST(1,3) - (PRESXZ*1.0D-8 + PRESTM(1,3))
          PREST(2,3) = PREST(2,3) - (PRESYZ*1.0D-8 + PRESTM(2,3))
          PREST(3,3) = PREST(3,3) - (PRESZZ*1.0D-8 + PRESTM(3,3))
      RETURN
      END
!
!
!                                                                =======
!================================================================ THREEP
SUBROUTINE  THREEP  (I,j,k, KK3BP,ithrm) !kwkt
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use forces
  use ewal
  use datoms
  use thrmint
!
  implicit none
!     ------------------------------------------- 3-body potential model
!
!
!
  integer(KIND=4)  I,j,k,kk3bp,ithrm !kwkt
  double precision  RIJX1,rijx2,DRDX1I,drdx2i,DRDX1J,drdx2j,DCDX   
  double precision  RIJY1,rijy2,DRDY1I,drdy2i,DRDY1J,drdy2j,DCDY     
  double precision  RIJZ1,rijz2,DRDZ1I,drdz2i,DRDZ1J,drdz2j,DCDZ      
  double precision  AK1,rij1,ARIJ1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05         
  double precision  AK2,rij2,ARIJ2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08          
  double precision  ffx1, ffx2, ASINJ                           
  double precision  ffy1, ffy2, RM, GR, FACT, RDJIJ, RD0                       
  double precision  ffz1, ffz2, FK, UJIJ, PHAI2  
  double precision  TJIJ                          
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
!  PI180 = 180.0D0 / PI
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM  = DBLE(R3BLIM(1,KK3BP))    !r_m
  GR  = DBLE(R3BGRD(1,KK3BP))    !g_r
  RD0 = DBLE(ANG3BP(KK3BP)) / PI180      !theta/(180/pi) radian unit
  FK  = DBLE(FK3BP(KK3BP)) * 1.0D-8      !f [erg]
!
  RIJ1   = D1ATOM                                                     
  ARIJ1  = 1.0D0 / rij1                                               
  RIJX1  = -1.0D0 * D1AXYZ(1)                                                
  RIJY1  = -1.0D0 * D1AXYZ(2)                                                
  RIJZ1  = -1.0D0 * D1AXYZ(3)                                                
  DRDX1I = -1.0D0 * RIJX1 * ARij1                                            
  DRDY1I = -1.0D0 * RIJY1 * ARij1                                            
  DRDZ1I = -1.0D0 * RIJZ1 * ARij1                                            
  DRDX1J = RIJX1 * ARij1                                              
  DRDY1J = RIJY1 * ARij1                                              
  DRDZ1J = RIJZ1 * ARij1                                              
!          DO 710  L2 = L1+1, NIJ                                              
  rij2   = d2atom                                                  
  ARIJ2  = 1.0D0 / rij2                                            
  RIJX2  = -1.0D0 * D2AXYZ(1)                                             
  RIJY2  = -1.0D0 * D2AXYZ(2)                                             
  RIJZ2  = -1.0D0 * D2AXYZ(3)                                             
  DRDX2I = -1.0D0 * RIJX2 * ARij2                                         
  DRDY2I = -1.0D0 * RIJY2 * ARij2                                         
  DRDZ2I = -1.0D0 * RIJZ2 * ARij2                                         
  DRDX2J = RIJX2 * ARij2                                           
  DRDY2J = RIJY2 * ARij2                                           
  DRDZ2J = RIJZ2 * ARij2                                           
!                                                                              
  COSJIJ = ( d1axyz(1) * d2axyz(1) +  &                             
             d1axyz(2) * d2axyz(2) +  &                             
             d1axyz(3) * d2axyz(3) ) * ARIJ1 * ARIJ2               
  IF (ABS(COSJIJ) < 1.0D-11) THEN
    COSJIJ = DSIGN(1.0D-11,COSJIJ)
  END IF
  SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
  ASINJ  = DSIGN(1.0D-11,SINJIJ)
  IF (ABS(SINJIJ) > 1.D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : J-I-J angle
  RDJIJ  = DATAN(SINJIJ / COSJIJ)
  IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
  TJIJ   = RDJIJ * PI180
  IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
! --------------------- Decriment of force with I-J distance
  EX1  = DEXP((d1atom - RM) * GR)                                  
  EX2  = DEXP((d2atom - RM) * GR)                                  
  AK1  = 1.0D0 / (EX1 + 1.0D0)
  AK2  = 1.0D0 / (EX2 + 1.0D0)
  fact = Dsqrt (ak1*ak2)                                           
  if (runopt(8) == 'BMH-EXP*  ')  FACT = AK1 * AK2
! ----------------------------- FJIJ : Force for J-I-J angle
!                               UJIJ : Potential for J-I-J angle
  PHAI2 = 2.0D0 * (RDJIJ - RD0)
  UJIJ = -1.0D0 *FK *(DCOS(PHAI2) -1.0D0) * FACT
  VAL(11) = VAL(11) + UJIJ
  if(ithrm == 1) EIJKTI = EIJKTI + UJIJ   !kwkt
!
  DCDX = (drdx2j - Drdx1j*COSJIJ) * ARIJ1                        
  DCDY = (drdy2j - Drdy1j*COSJIJ) * ARIJ1                        
  DCDZ = (drdz2j - Drdz1j*COSJIJ) * ARIJ1                        
  CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
  CDR = 0.5D0 *AK1 *GR *EX1 *(DCOS(PHAI2)-1.0D0)                 
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK1 *GR *EX1*(COS(PHAI2)-1.0D0)
  FFX1 = -1.0D8 *FK *FACT *(CDR *Drdx1j + CDS *DCDX)             
  FFY1 = -1.0D8 *FK *FACT *(CDR *Drdy1j + CDS *DCDY)             
  FFZ1 = -1.0D8 *FK *FACT *(CDR *Drdz1j + CDS *DCDZ)             
!               J1 = KIJ(L1)                                                 
  FX(J) = FX(J) + FFX1                                          
  FY(J) = FY(J) + FFY1                                          
  FZ(J) = FZ(J) + FFZ1                                          
  VIRLSR = VIRLSR + FFX1*RIJX1 + FFY1*RIJY1 + FFZ1*RIJZ1                  
  VAL03 = VAL03 + FFX1 *RIJX1                                    
  VAL04 = VAL04 + FFY1 *RIJY1                                    
  VAL05 = VAL05 + FFZ1 *RIJZ1                                    
  VAL06 = VAL06 + FFY1 *RIJZ1                                    
  VAL07 = VAL07 + FFX1 *RIJZ1                                    
  VAL08 = VAL08 + FFX1 *RIJY1                                    
!
  DCDX = (DRDX1J - DRDX2J*COSJIJ) * ARIJ2                        
  DCDY = (DRDY1J - DRDY2J*COSJIJ) * ARIJ2                        
  DCDZ = (DRDZ1J - DRDZ2J*COSJIJ) * ARIJ2                        
  CDR = 0.5D0 *AK2 *GR *EX2 *(DCOS(PHAI2)-1.0D0)
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK2 *GR *EX2 *(COS(PHAI2)-1.0D0)
!              CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
  FFX2 = -1.0D8 *FK *FACT *(CDR *DRDX2J + CDS *DCDX)             
  FFY2 = -1.0D8 *FK *FACT *(CDR *DRDY2J + CDS *DCDY)             
  FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZ2J + CDS *DCDZ)             
!               J2 = KIJ(L2)
  FX(k) = FX(k) + FFX2
  FY(k) = FY(k) + FFY2
  FZ(k) = FZ(k) + FFZ2
  VIRLSR = VIRLSR + FFX2*RIJX2 + FFY2*RIJY2 + FFZ2*RIJZ2                  
  VAL03 = VAL03 + FFX2 *RIJX2                                    
  VAL04 = VAL04 + FFY2 *RIJY2                                    
  VAL05 = VAL05 + FFZ2 *RIJZ2                                    
  VAL06 = VAL06 + FFY2 *RIJZ2                                    
  VAL07 = VAL07 + FFX2 *RIJZ2                                    
  VAL08 = VAL08 + FFX2 *RIJY2                                    
!
!   DCDX = (DRDX1I - DRDX2I*COSJIJ) * ARIJ2 +  (DRDX2I - DRDX1I*COSJIJ) * ARIJ1                        
!   DCDY = (DRDY1I - DRDY2I*COSJIJ) * ARIJ2 +  (DRDY2I - DRDY1I*COSJIJ) * ARIJ1                        
!   DCDZ = (DRDZ1I - DRDZ2I*COSJIJ) * ARIJ2 +  (DRDZ2I - DRDZ1I*COSJIJ) * ARIJ1                        
!   CDR0 = 0.5D0 * GR * (COS(PHAI2)-1.0D0)                        
!   if  (runopt(8) == 'BMH-EXP*  ')   CDR0 = GR *(COS(PHAI2)-1.0D0)                      
!   CDR1 = AK1 * EX1 * CDR0
!   CDR2 = AK2 * EX2 * CDR0
!   FFX = FK *FACT *(CDR1*DRDX1I + CDR2*DRDX2I +CDS*DCDX)          
!   FFY = FK *FACT *(CDR1*DRDY1I + CDR2*DRDY2I +CDS*DCDY)          
!   FFZ = FK *FACT *(CDR1*DRDZ1I + CDR2*DRDZ2I +CDS*DCDZ)          
!   FFX = FFX * (-1.0D8)
!   FFY = FFY * (-1.0D8)
!   FFZ = FFZ * (-1.0D8)
!   ffx = ffx - (ffx + ffx1 + ffx2)
!   ffy = ffy - (ffy + ffy1 + ffy2)
!   ffz = ffz - (ffz + ffz1 + ffz2)
!   FX(I) = FX(I) + FFX
!   FY(I) = FY(I) + FFY
!   FZ(I) = FZ(I) + FFZ
!
   FX(I) = FX(I) - (FFX1 + FFX2)
   FY(I) = FY(I) - (FFY1 + FFY2)
   FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
  AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
  AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
  RETURN
END
!
!
!                                                                =======
!================================================================THREER3
SUBROUTINE  THREER3  (I,j,k,KK3BP)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use ewal
  use pmorse
!  use consts
!
  implicit none
!
!     ------------------------------------------- Vashishta VASHISHTA
!     ------------------------------------------- 3-body potential model
!
!
  REAL     *8  RIJX1,RIJX2,DRDX1I,DRDX2I,DRDX1J,DRDX2J,DCDX
  REAL     *8  RIJY1,RIJY2,DRDY1I,DRDY2I,DRDY1J,DRDY2J,DCDY
  REAL     *8  RIJZ1,RIJZ2,DRDZ1I,DRDZ2I,DRDZ1J,DRDZ2J,DCDZ
  REAL     *8  RIJ1,ARIJ1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  RIJ2,ARIJ2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  real     *8  ffx1, ffy1, ffz1, ffx2, ffy2, ffz2
  REAL     *8  UJIJ
  REAL     *8  ASINJ,AR,RDJIJ
  real     *8  TJIJ
  DOUBLE PRECISION BETA,R0ij,GAMMAij,COSRD0,BK,CK
  DOUBLE PRECISION COSM,CCOF,BCOF
  integer  *4  I,KK3BP,k,J,L1,L2,J1,J2
!
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
!  PI180 = 180.0D0/PI
  BETA = ELCC * 1.0D7  ! eV -> erg
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  R0ij  = R3BLIM(1,KK3BP)   !r0 [Angstrom]
!  R0ik  = R3BLIM(2,KK3BP)   !r0_ik [Angstrom]
  GAMMAij  = R3BGRD(1,KK3BP)   ! Gamma_ij [Angstrom]
!  GAMMAik  = R3BGRD(2,KK3BP)   ! Gamma_ik [Angstrom]
  COSRD0 = ANG3BP(KK3BP)    ! COS theta_0
  BK  = FK3BP(KK3BP) * BETA   !B [erg]
  CK  = CIJK(N3BP)  ! C [-]
!
  RIJ1   = D1ATOM                                                     
  ARIJ1  = 1.0D0 / rij1                                               
  RIJX1  = -1.0D0 * D1AXYZ(1)                                                
  RIJY1  = -1.0D0 * D1AXYZ(2)                                                
  RIJZ1  = -1.0D0 * D1AXYZ(3)                                                
  DRDX1I = -1.0D0 * RIJX1 * ARij1                                            
  DRDY1I = -1.0D0 * RIJY1 * ARij1                                            
  DRDZ1I = -1.0D0 * RIJZ1 * ARij1                                            
  DRDX1J = RIJX1 * ARij1                                              
  DRDY1J = RIJY1 * ARij1                                              
  DRDZ1J = RIJZ1 * ARij1
!
  RIJ2   = d2atom                                                  
  ARIJ2  = 1.0D0 / RIJ2                                            
  RIJX2  = -1.0D0 * D2AXYZ(1)                                             
  RIJY2  = -1.0D0 * D2AXYZ(2)                                             
  RIJZ2  = -1.0D0 * D2AXYZ(3)                                             
  DRDX2I = -1.0D0 * RIJX2 * ARij2                                         
  DRDY2I = -1.0D0 * RIJY2 * ARij2                                         
  DRDZ2I = -1.0D0 * RIJZ2 * ARij2                                         
  DRDX2J = RIJX2 * ARij2                                           
  DRDY2J = RIJY2 * ARij2                                           
  DRDZ2J = RIJZ2 * ARij2 
!
  COSJIJ = ( d1axyz(1) * d2axyz(1) +  &                             
             d1axyz(2) * d2axyz(2) +  &                             
             d1axyz(3) * d2axyz(3) ) * ARIJ1 * ARIJ2               
  IF (ABS(COSJIJ) < 1.0D-11) THEN
    COSJIJ = DSIGN(1.0D-11,COSJIJ)
  END IF
  SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
  ASINJ  = DSIGN(1.0D-11,SINJIJ)
  IF (ABS(SINJIJ) > 1.D-11)  ASINJ  = 1.0D0 / SINJIJ
!
!             --------------------------------------- TJIJ : J-I-J angle
  RDJIJ  = DATAN(SINJIJ / COSJIJ)
  IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
  TJIJ   = RDJIJ * PI180
  IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
!                              
!     --------------------- exp 
!
      EX1 = DEXP(GAMMAij/(RIJ1 - R0ij))
      EX2 = DEXP(GAMMAij/(RIJ2 - R0ij))
!
!     ----------------------------- FJIJ : Forces
!                                   UJIJ : Potential
      COSM = COSJIJ - COSRD0  ! cos(theta)-cos(theta_0)
      CCOF = COSM/(1.0d0+CK*COSM**2)
      UJIJ = BK*COSM*CCOF*EX1*EX2
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (-DRDX2J + DRDX1J*COSJIJ)*ASINJ  !omega_x
      DCDY = (-DRDY2J + DRDY1J*COSJIJ)*ASINJ  !omega_y
      DCDZ = (-DRDZ2J + DRDZ1J*COSJIJ)*ASINJ  !omega_z
!
      CDS  = 2.0D0*ARIJ1*SINJIJ/(1.0d0+CK*COSM**2)              ! Bending
      CDR  = COSM*GAMMAij/(RIJ1-R0ij)**2  ! Stretching
!
      BCOF = BK*EX1*EX2*CCOF
      FFX1 = BCOF*1.0D8* (CDS*DCDX + CDR*DRDX1J)
      FFY1 = BCOF*1.0D8* (CDS*DCDY + CDR*DRDY1J)
      FFZ1 = BCOF*1.0D8* (CDS*DCDZ + CDR*DRDZ1J)
!
!      J1 = KIJ(L1)
      FX(J) = FX(J) + FFX1
      FY(J) = FY(J) + FFY1
      FZ(J) = FZ(J) + FFZ1
      VIRLSR = VIRLSR + FFX1*RIJX1 + FFY1*RIJY1 + FFZ1*RIJZ1
      VAL03 = VAL03 + FFX1 *RIJX1
      VAL04 = VAL04 + FFY1 *RIJY1
      VAL05 = VAL05 + FFZ1 *RIJZ1
      VAL06 = VAL06 + FFY1 *RIJZ1
      VAL07 = VAL07 + FFX1 *RIJZ1
      VAL08 = VAL08 + FFX1 *RIJY1
!
      DCDX = (-DRDX1J + DRDX2J*COSJIJ)*ASINJ  !omega_x
      DCDY = (-DRDY1J + DRDY2J*COSJIJ)*ASINJ  !omega_y
      DCDZ = (-DRDZ1J + DRDZ2J*COSJIJ)*ASINJ  !omega_z
!
      CDS  = 2.0D0*ARIJ2*SINJIJ/(1.0d0+CK*COSM**2)              ! Bending
      CDR  = COSM*GAMMAij/(RIJ2-R0ij)**2  ! Stretching
!
      FFX2 = BCOF*1.0D8* (CDS*DCDX + CDR*DRDX2J)
      FFY2 = BCOF*1.0D8* (CDS*DCDY + CDR*DRDY2J)
      FFZ2 = BCOF*1.0D8* (CDS*DCDZ + CDR*DRDZ2J)
!
!      J2 = KIJ(L2)
      FX(k) = FX(k) + FFX2
      FY(k) = FY(k) + FFY2
      FZ(k) = FZ(k) + FFZ2
      VIRLSR = VIRLSR + FFX2*RIJX2 + FFY2*RIJY2 + FFZ2*RIJZ2
      VAL03 = VAL03 + FFX2 *RIJX2
      VAL04 = VAL04 + FFY2 *RIJY2
      VAL05 = VAL05 + FFZ2 *RIJZ2
      VAL06 = VAL06 + FFY2 *RIJZ2
      VAL07 = VAL07 + FFX2 *RIJZ2
      VAL08 = VAL08 + FFX2 *RIJY2
!
!
       FX(I) = FX(I) - (FFX1 + FFX2)
       FY(I) = FY(I) - (FFY1 + FFY2)
       FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
!      write (6,*) ffx1, ffy1, ffz1
!      write (6,*) ffx2, ffy2, ffz2
!      write (6,*) ffx,  ffy,  ffz
!      write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                                =======
!================================================================ THREEQ
SUBROUTINE  THREEQ  (I,j,k, KK3BP)
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use forces
  use ewal
  use datoms
!
!     -------------------------------- 3-body potential model j-i-k j<k
!
!
!
  double precision  R1IJX, DRDX1I, DRDX1J, DCDX                   
  double precision  R1IJY, DRDY1I, DRDY1J, DCDY                   
  double precision  R1IJZ, DRDZ1I, DRDZ1J, DCDZ                    
  double precision  R2IJX, DRDX2I, DRDX2J, ffx1, ffx2, val03, val06              
  double precision  R2IJY, DRDY2I, DRDY2J, ffy1, ffy2, val04, val07              
  double precision  R2IJZ, DRDZ2I, DRDZ2J, ffz1, ffz2, val05, val08               
  double precision  AK1,r1ij,ARIJ1,CDR,EX1,rm1,gr1,SINJIJ                        
  double precision  AK2,r2ij,ARIJ2,CDS,EX2,rm2,gr2,COSJIJ                         
  double precision  FACT, RDJIJ, RD0                                              
  double precision  FK, UJIJ, PHAI2, ASINJ, TJIJ
  integer*4 KK3BP,J,K,I
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0E-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
!  PI180 = 180.0D0 / PI
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM1 = DBLE(R3BLIM(1,KK3BP))
  GR1 = DBLE(R3BGRD(1,KK3BP))
  RM2 = DBLE(R3BLIM(2,KK3BP))
  GR2 = DBLE(R3BGRD(2,KK3BP))
  RD0 = DBLE(ANG3BP(KK3BP)) / PI180
  FK  = DBLE(FK3BP(KK3BP)) * 1.0D-8
!
  r1ij   = d1atom                                                     
  ARIJ1  = 1.0D0 / R1IJ                                               
  R1IJX  = - D1AXYZ(1)                                                
  R1IJY  = - D1AXYZ(2)                                                
  R1IJZ  = - D1AXYZ(3)                                                
  DRDX1I = - R1IJX * ARij1                                              
  DRDY1I = - R1IJY * ARij1                                              
  DRDZ1I = - R1IJZ * ARij1                                              
  DRDX1J = R1IJX * ARij1                                                
  DRDY1J = R1IJY * ARij1                                                
  DRDZ1J = R1IJZ * ARij1                                                
!         DO 710  L2 =1, N2IJ                                                     
  r2ij   = d2atom                                                     
  ARIJ2  = 1.0D0 / R2IJ                                               
  R2IJX  = - D2AXYZ(1)                                                
  R2IJY  = - D2AXYZ(2)                                                
  R2IJZ  = - D2AXYZ(3)                                                
  DRDX2I = - R2IJX * ARij2                                           
  DRDY2I = - R2IJY * ARij2                                           
  DRDZ2I = - R2IJZ * ARij2                                           
  DRDX2J = R2IJX * ARij2                                             
  DRDY2J = R2IJY * ARij2                                             
  DRDZ2J = R2IJZ * ARij2                                             
!             write (6,*) l1,l2,r1ij,r2ij                                         
  COSJIJ = ( R1IJX * R2IJX + R1IJY * R2IJY +  &                         
             R1IJZ * R2IJZ ) * ARIJ1 * ARIJ2                         
  IF (ABS(COSJIJ) < 1.0D-11) THEN
    COSJIJ = SIGN(1.0D-11,COSJIJ)
  END IF
  SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
  ASINJ  = SIGN(1.0D-11,SINJIJ)
  IF (ABS(SINJIJ) > 1D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : j-i-k angle          
  RDJIJ  = ATAN(SINJIJ / COSJIJ)
  IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
  TJIJ   = RDJIJ * PI180
  IF (TJIJ < 0.0)  TJIJ = TJIJ + 180.0
!             ------------ Decriment of force with I-J and i-k distances          
  EX1 = EXP((R1IJ - RM1) * GR1)                                       
  EX2 = EXP((R2IJ - RM2) * GR2)                                       
  AK1  = 1.0D0 / (EX1 + 1.0D0)
  AK2  = 1.0D0 / (EX2 + 1.0D0)
  FACT = SQRT( AK1 * AK2 )
  if (runopt(8) == 'BMH-EXP*  ')  FACT = AK1 * AK2
!             ----------------------------- Fjik : Force for j-i-k angle          
!                                       Ujik : Potential for j-i-k angle          
  PHAI2 = 2.0D0 * (RDJIJ - RD0)
  UJIJ = -1.0D0 *FK *(COS(PHAI2) -1.0D0) * FACT
  VAL(11) = VAL(11) + UJIJ
!
  DCDX = (DRDX2J - DRDX1J*COSJIJ) * ARIJ1                             
  DCDY = (DRDY2J - DRDY1J*COSJIJ) * ARIJ1                             
  DCDZ = (DRDZ2J - DRDZ1J*COSJIJ) * ARIJ1                             
  CDR = 0.5D0 *AK1 *GR1 *EX1 *(COS(PHAI2)-1.0D0)
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK1 *GR1 *EX1 *(COS(PHAI2)-1.0D0)
  CDS = -2.0D0 *ASINJ *SIN(PHAI2)
  FFX1 = -1.0D8 *FK *FACT *(CDR *DRDX1J + CDS *DCDX)                   
  FFY1 = -1.0D8 *FK *FACT *(CDR *DRDY1J + CDS *DCDY)                   
  FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZ1J + CDS *DCDZ)                   
!               J1 = K1IJ(L1)                                                      
  FX(J) = FX(J) + FFX1                                                
  FY(J) = FY(J) + FFY1                                                
  FZ(J) = FZ(J) + FFZ1                                                
  VIRLSR = VIRLSR + FFX1*R1IJX + FFY1*R1IJY + FFZ1*R1IJZ               
  VAL03 = VAL03 + FFX1 *R1IJX                                          
  VAL04 = VAL04 + FFY1 *R1IJY                                          
  VAL05 = VAL05 + FFZ1 *R1IJZ                                          
  VAL06 = VAL06 + FFY1 *R1IJZ                                          
  VAL07 = VAL07 + FFX1 *R1IJZ                                          
  VAL08 = VAL08 + FFX1 *R1IJY                                          
!
  DCDX = (DRDX1J - DRDX2J*COSJIJ) * ARIJ2                              
  DCDY = (DRDY1J - DRDY2J*COSJIJ) * ARIJ2                              
  DCDZ = (DRDZ1J - DRDZ2J*COSJIJ) * ARIJ2                              
  CDR = 0.5D0 *AK2 *GR2 *EX2 *(COS(PHAI2)-1.0D0)
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK2 *GR2 *EX2 *(COS(PHAI2)-1.0D0)
!              CDS = -2.0D0 *ASINJ *SIN(PHAI2)
  FFX2 = -1.0D8 *FK *FACT *(CDR *DRDX2J + CDS *DCDX)                    
  FFY2 = -1.0D8 *FK *FACT *(CDR *DRDY2J + CDS *DCDY)                    
  FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZ2J + CDS *DCDZ)                    
!               J2 = K2IJ(L2)                                                       
  FX(k) = FX(k) + FFX2                                                 
  FY(k) = FY(k) + FFY2                                                 
  FZ(k) = FZ(k) + FFZ2                                                 
  VIRLSR = VIRLSR + FFX2*R2IJX + FFY2*R2IJY + FFZ2*R2IJZ                
  VAL03 = VAL03 + FFX2 *R2IJX                                           
  VAL04 = VAL04 + FFY2 *R2IJY                                           
  VAL05 = VAL05 + FFZ2 *R2IJZ                                           
  VAL06 = VAL06 + FFY2 *R2IJZ                                           
  VAL07 = VAL07 + FFX2 *R2IJZ                                           
  VAL08 = VAL08 + FFX2 *R2IJY                                           
!
!  DCDX = (DRDX1I - DRDX2I*COSJIJ) * ARIJ2 +  (DRDX2I - DRDX1I*COSJIJ) * ARIJ1                               
!  DCDY = (DRDY1I - DRDY2I*COSJIJ) * ARIJ2 +  (DRDY2I - DRDY1I*COSJIJ) * ARIJ1                               
!  DCDZ = (DRDZ1I - DRDZ2I*COSJIJ) * ARIJ2 +  (DRDZ2I - DRDZ1I*COSJIJ) * ARIJ1                               
!  CDR1 = AK1 *EX1 * 0.5D0 *GR1 *(COS(PHAI2)-1.0D0)
!  CDR2 = AK2 *EX2 * 0.5D0 *GR2 *(COS(PHAI2)-1.0D0)
!  if (runopt(8) == 'BMH-EXP*  ')  then
!    CDR1 = AK1 *EX1 * *GR1 *(COS(PHAI2)-1.0D0)
!    CDR2 = AK2 *EX2 * *GR2 *(COS(PHAI2)-1.0D0)
!  end if
!  FFX=-1.0D8* FK*FACT *(CDR1*DRDX1I +CDR2*DRDX2I +CDS*DCDX)             
!  FFY=-1.0D8* FK*FACT *(CDR1*DRDY1I +CDR2*DRDY2I +CDS*DCDY)             
!  FFZ=-1.0D8* FK*FACT *(CDR1*DRDZ1I +CDR2*DRDZ2I +CDS*DCDZ)             
!  ffx = ffx - (ffx + ffx1 + ffx2)
!  ffy = ffy - (ffy + ffy1 + ffy2)
!  ffz = ffz - (ffz + ffz1 + ffz2)
!  FX(I) = FX(I) + FFX
!  FY(I) = FY(I) + FFY
!  FZ(I) = FZ(I) + FFZ
!
   FX(I) = FX(I) - (FFX1 + FFX2)
   FY(I) = FY(I) - (FFY1 + FFY2)
   FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
  AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
  AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
  RETURN
END
!
!                                                               ========
!================================================================ QUANTM
      SUBROUTINE  QUANTM
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE VALUES
      USE TABLES
      USE QUANCO
!     ----------------------------------------------- Quantum correction
!
      implicit none
!
      double precision     FEK,QKIE,AKINE,DQCE,TEMPQ, QCKET
      integer(KIND=4)  I,II
!
      IF (NRECRD(1) == 1)  TEMPQH = 0.0
!     --------------------------------- Quantum correction for each step
      FEK   = ((AHP/ 2.0/PI)**2) / (24.0D0 * AKB)
!                                            TQCE : sum of nabla(Uij)/mi
      TQCE  = TQCE * FEK
!                               [TQCE]/T : Net Quantum Correction Energy
      QCIT  = 1.50D0 * AKB * DBLE(NTION)
      AKINE = VAL(13)
!                                         1/2 for Harmonic approximation
      QCKET = TQCE * 0.5D0
!                    QCKET : [Quantum Correction for Kinetic energy] * T
!                                  [QCIT]*T**2 + [AKINE]*T + [QCKET] = 0
      DQCE  = AKINE**2 - 4.0D0 * QCIT * QCKET
      IF (DQCE.LE.0.0) THEN
           AKINE = SQRT(4.0D0 * QCIT * QCKET)
           TEMPQ = AKINE / (2.0D0 * QCIT)
           QKIE  = SQRT(AKINE / VAL(13))
           DO 310 I = 1,3
               DO 320 II = 1,NTION
                   V(I,II) = V(I,II) * QKIE
  320          CONTINUE
  310      CONTINUE
      ELSE
           TEMPQ = (AKINE + SQRT(DQCE)) / (2.0D0 * QCIT)
      END IF
      VAL(1) = TEMPQ
      TEMPQQ = AKINE / QCIT
      TEMPQH = TEMPQH + TEMPQQ
!
!     write (6,*) 'Thermodynamic temperature : ',tempq,
!    *            '  Kinetic temperature :', TEMPQQ
      RETURN
      END
!
!
!                                                                =======
!================================================================ QCTABL
      SUBROUTINE  QCTABL
      USE PARAM
      USE CHARAC
      USE ABOXOF
      USE PARAMT
      USE TABLES
      USE PMORSE
      USE QUANCO
!     ------------------------------------------------------------------
      implicit none
!
      double precision        A1,A2,QSR1,QSR2,QVW1,QVW2,D2,QMS1,QMS2
      double precision        BETAU,R,AR,ARB
      integer(KIND=4)     I,J
!
      IF (RUNOPT(8) .NE.'BUSING    '.AND. &
          RUNOPT(8) .NE.'MORSE     ')  RETURN
!     ------------------------------------------- Calculation of tables
      BETAU = CAL * 1.0D10 / ANA
      DO 150  I = 10, NRCUT(2)
          R  = DBLE(I) * 0.01
          AR = 1.0D0 / R
          DO 140  J = 1, LEE
              Q1U1(I,J) = 0.0D0
              Q2U1(I,J) = 0.0D0
                QSR1 = 0.0D0
                QSR2 = 0.0D0
                  QVW1 = 0.0D0
                  QVW2 = 0.0D0
                    QMS1 = 0.0D0
                    QMS2 = 0.0D0
              IF (ABS(AIJ(J)) > 1.0E-5)  THEN
!                   ----------------- Short range rep. and van der Waals
                    QSR1 = 0.0D0
                    IF (BIJ(J) > 0.0001)  THEN
                          ARB = (AIJ(J) - R) / BIJ(J)
                          IF (ARB > -128.0D0)  QSR1 = EXP(ARB)
                    END IF
                    QSR1 = -QSR1          * 1.0D8
                    QSR2 = -QSR1 / BIJ(J) * 1.0D8
!                   -------------------------------------- Van der Waals
                    QVW1 =  6.0D0 * CIJ(J) * AR**7 * 1.0D8
                    QVW2 = -7.0D0 * QVW1   * AR    * 1.0D8
              END IF
              IF (RUNOPT(8) == 'MORSE     ') THEN
!                   ----------------------------------------- Morse term
                      D2 = DMIJ(J) * 2.0D0
                      A1 = EXP(-2.0D0*BEIJ(J)*(R-RSIJ(J)))
                      A2 = EXP(-1.0D0*BEIJ(J)*(R-RSIJ(J)))
                    QMS1 = D2 * BEIJ(J)    * (    -A1 + A2) *1.0D8
                    QMS2 = D2 * BEIJ(J)**2 * ( 2.0D0*A1 - A2) *1.0D16
              END IF
              Q1U1(I,J) = ((QSR1 + QMS1) * BETAU +QVW1) * AR*1.0D8
              Q2U1(I,J) =  (QSR2 + QMS2) * BETAU + QVW2
  140     CONTINUE
  150 CONTINUE
      RETURN
      END
!
!
!                                                               ========
!================================================================ ELECFD
      SUBROUTINE ELECFD
      USE PARAM
      USE COUNTS
      USE TEMPRS
      USE ATOMSI
      USE PARAMT
      USE FORCES
      USE WORK02
      USE OUTERF
!  
!     ------ Electric field  by  Naoya Sawaguchi[Hirao P -> Nirin] -----
      implicit none
! 
            double precision   FCOUNT,REFREQ,CTIME
            double precision   EFDX,EFDY,EFDZ,DEE
            double precision   fefx,fefy,fefz,ZZZ
            integer(KIND=4)  I,MSWTCH
!ccccc
!     --- MEFD = mode of the electric field ---
!           0 ... Static electric field
!           1 ... ( 0 to E) pulse
!           2 ... (-E to E) pulse
!           3 ... saw tooth pulse   incomplete
!           4 ... sine oscillator
!
!         write(6,*) MEFD, EFREQ
!         write(6,*) EFD(1),EFD(2),EFD(3)
         IF (NRECRD(1)  ==  1) THEN
            MSWTCH = 1
            FCOUNT = 1.000000D0
         END IF
         IF (EFREQ .NE. 0.00000D0) REFREQ = 1.000D0 / EFREQ
         CTIME = DTIME*NRECRD(1)
!         PI2 = 2.000D0 * PI
         IF (MEFD  ==  0) THEN
            EFDX = EFD(1)
            EFDY = EFD(2)
            EFDZ = EFD(3)
         ELSEIF (MEFD  ==  1) THEN
            IF (CTIME .GE. REFREQ*FCOUNT) THEN
               MSWTCH = -MSWTCH
               FCOUNT = FCOUNT + 1.000000D0
            END IF
            IF (MSWTCH  >  0) THEN
               EFDX = EFD(1)
               EFDY = EFD(2)
               EFDZ = EFD(3)
            ELSE
               EFDX = 0.000000D0
               EFDY = 0.000000D0
               EFDZ = 0.000000D0
            END IF
         ELSEIF (MEFD  ==  2) THEN
            IF (CTIME .GE. REFREQ*FCOUNT) THEN
               MSWTCH = -MSWTCH
               FCOUNT = FCOUNT + 1.000000D0
            END IF
            EFDX = EFD(1) * DBLE(MSWTCH)
            EFDY = EFD(2) * DBLE(MSWTCH)
            EFDZ = EFD(3) * DBLE(MSWTCH)
!         ELSEIF (MEFD  ==  3) THEN
!            FREQP4 = EFREQ / 4.000000D0
!               ExSLP = EFD(1)/FREQP4
!               EySLP = EFD(2)/FREQP4
!               EySLP = EFD(3)/FREQP4
!            IF (CTIME .GE. FREQP4*FCOUNT) THEN
!               MSWTCH = -MSWTCH
!               FCOUNT = FCOUNT + 1.000000D0
!               ExSLP = -ExSLP
!               EySLP = -EySLP
!               EySLP = -EySLP
!            END IF
!            IF (MSWTCH  >  0) THEN
!               EFDX = EFD(1)
!               EFDY = EFD(2)
!               EFDZ = EFD(3)
!            ELSE
!               EFDX = 0.000000D0
!               EFDY = 0.000000D0
!               EFDZ = 0.000000D0
!            END IF
!
         ELSEIF (MEFD  ==  4) THEN
            DEE  = SIN(PI2*EFREQ*CTIME)
            EFDX = EFD(1)*DEE
            EFDY = EFD(2)*DEE
            EFDZ = EFD(3)*DEE
!            write(6,*) EFDX,EFDY,EFDZ    ! check AC
         END IF
!
         DO I=1,NTION
            fefx = 0.0000D0
            fefy = 0.0000D0
            fefz = 0.0000D0
!           ZIO =0, or EFD =0 then fef = 0 naturally
!           ZZZ  = ZII(I) * ELC              ! esu
            ZZZ  = ZII(I) * 1.60217733D-19   ! Coulomb
            fefx = EFDX * ZZZ
            fefy = EFDY * ZZZ
            fefz = EFDZ * ZZZ
!
            FX(I) = FX(I) + fefx
            FY(I) = FY(I) + fefy
            FZ(I) = FZ(I) + fefz
         END DO
      END
!
!
!                                                               ========
!================================================================ GRAVFD
      SUBROUTINE GRAVFD
      USE PARAM
      USE ATOMSI
      USE PARAMT
      USE FORCES
      USE OUTERF
!  
!     ---------------------------------------------- Gravity field -----
!
      implicit none
! 
            double precision   GFDX,GFDY,GFDZ
            double precision   g,w
            integer(KIND=4)  io,I
!
!           ------ g = 9.8 m/s2 = 980 cm/s2
            g = 980.665 * 1.0D8
!
!         write(6,*) GFD
            GFDX = GFD(1) * g
            GFDY = GFD(2) * g
            GFDZ = GFD(3) * g
!
            write (6,*) fx(1),fy(1),fz(1)
            write (6,*) gfdx*wio(1)
            write (*,*) ana,gfdy*wio(1)
            write (*,*) ana,gfdz*wio(1)
            write (*,*) ana
         do io = 1, ncompo
             w = wio(io) / ANA
             DO  I = ions(1,io), ions(2,io)
               FX(I) = FX(I) + w * gfdx 
               FY(I) = FY(I) + w * gfdy
               FZ(I) = FZ(I) + w * gfdz
            END DO
         end do
      END
!
!
!                                                               ========
!================================================================ CSHEAR
      SUBROUTINE  CSHEAR
      USE PARAM
!      USE CONSTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE FORCES
      USE CARTES
      USE OUTERF
!  
!     ---------------------------------------- Constant shear rate -----
!
      implicit none
      double precision  aa,bb,cc
      double precision PJI
      integer I,IO,J
!           -------- SHEAR RATE = STRT(ps-1)*1E12 -> (s-1)
            SHRZX = STRT(1)*1.0D12
            SHRZY = STRT(2)*1.0D12
!
       aa = sqrt( H(1,1)**2 + H(2,1)**2 + H(3,1)**2 )
       bb = sqrt( H(1,2)**2 + H(2,2)**2 + H(3,2)**2 )
       cc = sqrt( H(1,3)**2 + H(2,3)**2 + H(3,3)**2 )
!     ----------------------------------------------------- dvz/drx
      dispzx=dispzx+SHRZX*(1.0d0/rbox(1))*DTIME
      H(1,1) = H(1,1) + H(1,3)/cc * SHRZX*(1.0d0/rbox(1)) * DTIME
      H(2,1) = H(2,1) + H(2,3)/cc * SHRZX*(1.0d0/rbox(1)) * DTIME
      H(3,1) = H(3,1) + H(3,3)/cc * SHRZX*(1.0d0/rbox(1)) * DTIME
!     ----------------------------------------------------- dvz/dry
      dispzy=dispzy+SHRZY*(1.0d0/rbox(2))*DTIME
      H(1,2) = H(1,2) + H(1,3)/cc * SHRZY*(1.0d0/rbox(2)) * DTIME
      H(2,2) = H(2,2) + H(2,3)/cc * SHRZY*(1.0d0/rbox(2)) * DTIME
      H(3,2) = H(3,2) + H(3,3)/cc * SHRZY*(1.0d0/rbox(2)) * DTIME
!!     ----------------------------------------------------- dvz/drx
!      dispxz=dispxz+SHRXZ*(1.0d0/rbox(1))*DTIME
!      H(1,1) = H(1,1) + H(1,3)/cc * SHRXZ*(1.0d0/rbox(1)) * DTIME
!      H(2,1) = H(2,1) + H(2,3)/cc * SHRXZ*(1.0d0/rbox(1)) * DTIME
!      H(3,1) = H(3,1) + H(3,3)/cc * SHRXZ*(1.0d0/rbox(1)) * DTIME
!
      CALL  TMATRX  (1)  !Calculate BOX(1) to BOX(6), and HINV(1,1) to HINV(3,3)
!
      if(abs(dispzx)>=cc .or. abs(dispzy)>=cc) then
        CALL TMATRX (0)
        do I=1,NTION
          CALL PTOXYZ (I)
        enddo
        if(abs(dispzx)>=cc) then
           if(SHRZX>0.0d0) then
             H(1,1) = H(1,1) - H(1,3)
             H(2,1) = H(2,1) - H(2,3)
             H(3,1) = H(3,1) - H(3,3)
             dispzx=dispzx-cc
           elseif(SHRZX<0.0d0) then
             H(1,1) = H(1,1) + H(1,3)
             H(2,1) = H(2,1) + H(2,3)
             H(3,1) = H(3,1) + H(3,3)
             dispzx=dispzx+cc
           endif
        endif
        if(abs(dispzy)>=cc) then
           if(SHRZY>0.0d0) then
             H(1,2) = H(1,2) - H(1,3)
             H(2,2) = H(2,2) - H(2,3)
             H(3,2) = H(3,2) - H(3,3)
             dispzy=dispzy-cc
           elseif(SHRZY<0.0d0) then
             H(1,2) = H(1,2) + H(1,3)
             H(2,2) = H(2,2) + H(2,3)
             H(3,2) = H(3,2) + H(3,3)
             dispzy=dispzy+cc
           endif
        endif
!        if(abs(dispxz)>=cc) then
!           if(SHRXZ>0.0d0) then
!             H(1,1) = H(1,1) - H(1,3)
!             H(2,1) = H(2,1) - H(2,3)
!             H(3,1) = H(3,1) - H(3,3)
!             dispxz=dispxz-cc
!           elseif(SHRXZ<0.0d0) then
!             H(1,1) = H(1,1) + H(1,3)
!             H(2,1) = H(2,1) + H(2,3)
!             H(3,1) = H(3,1) + H(3,3)
!             dispxz=dispxz+cc
!           endif
!        endif
        CALL TMATRX (1)
!write (*,*) 'CSHEAR in change',H(1,3),H(2,3),H(3,3)
        CALL XYZTOP
!       ------------------------------------------------------- Basic cell
!       This is required for file09p and TABLER
        DO IO = 1, NCOMPO
          IF (NION(IO) <= 0) CYCLE
            DO I = IONS(1,IO), IONS(2,IO)
              DO J = 1, 3
                  IF (P(J,I) < 0.0.OR.P(J,I) >= 1.0)  THEN
500                      PJI     = -SIGN(1.0D0,P(J,I))
                         P0(J,I) = P0(J,I) + PJI
                         P(J,I)  = P(J,I)  + PJI
                         IF (P(J,I) < 0.0.OR.P(J,I) >= 1.0) goto 500
                  END IF
              ENDDO
            ENDDO
        ENDDO
      endif
!do i=1,60
!write(*,*)'P(1,i)',P(1,i),P(3,i)
!enddo
!
      CALL  TABLER  (0)
!               write (6,*) strt
!               write (6,*) 'CSHEAR',H(1,3),H(2,3),H(3,3)
      END
!
!
!                                                                =======
!================================================================ SCCELL
      SUBROUTINE  SCCELL 
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE CARTES
!
!     -------------------------- Basic cell scaling for pressure control
!
      implicit none
!
      double precision        FA(6), FK, DFV, DDD, HK,FLMT
      double precision        APXYZ,ASPRES,VOLOLD, AROOT2,DP,DPP
      integer(KIND=4)     I,J,K1,K2
!
      AROOT2 = 1.0D0 / SQRT(2.0D0)
!
      IF (RUNOPT(6) /= 'P SCALING ' .AND. &
          RUNOPT(6) /= 'P SHEAR   ' .AND. &
          RUNOPT(7) /= 'D CONST.  '     )  RETURN
!
!      write(*,*)'PXYZ'
!      do i = 1,4
!        write(*,*) PXYZ(i)
!      enddo
      APXYZ   = (PXYZ(2) + PXYZ(3) + PXYZ(4)) / 3.0D0
      APXYZ   = PXYZ(1) - APXYZ
      PXYZ(2) = PXYZ(2) + APXYZ
      PXYZ(3) = PXYZ(3) + APXYZ
      PXYZ(4) = PXYZ(4) + APXYZ
!
      ASPRES = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
      FLMT   = 1.0D0 / (1.0D0 + ASPRES/25.0D0)
      IF (VBOX(1) < 1.0D-5)  VBOX(1) = 1.0D0
      DO I = 1, 3
          DP  = PXYZ(I+1) - PPXYZ(I+1)
          DPP = PXYZ(I+1) - SPRES(I)
          IF (DP*DPP > 0.0)  VBOX(1) = VBOX(1) / 1.05D0
          IF (DP*DPP < 0.0)  VBOX(1) = VBOX(1) * 1.05D0
      ENDDO   
      IF (VBOX(1) < 0.2)   VBOX(1) = 0.2D0
      IF (VBOX(1) > FLMT)  VBOX(1) = FLMT
!
      VOLOLD = VOL
      DDD = 0.001D0 * 512.0D0
!     - - - - - - - - - - - - - - Scaling cell edge lengths, A, B, and C
      DO I = 1, 3
          FK = ATAN((PXYZ(I+1) - SPRES(I)) * VBOX(1)*DDD) / 512.0D0
          FA(I)  = 1.0D0 + FK*5.0D0
          DO J = 1, 3
              H(I,J) = H(I,J) * FA(I)
          ENDDO   
      ENDDO    
!     - - - - - - - - - - - - - - Scaling angles, alpha, beta, and gamma
      DO I = 4, 6
          FK = ATAN((PXYZ(I+1) - SPRES(I)) * VBOX(1)*DDD) / 512.0D0
          FA(I)  = FK
          K1 = 2
          K2 = 3
          IF (I == 5) THEN
                 K1 = 1
                 K2 = 3
          ELSE IF (I == 6) THEN
                 K1 = 1
                 K2 = 2
          END IF
          DO J = 1, 3
              HK = (H(K1,J)*AROOT2 + H(K2,J)*AROOT2) * FA(I)
              H(K1,J) = H(K1,J) + HK*AROOT2
              H(K2,J) = H(K2,J) + HK*AROOT2
          ENDDO   
      ENDDO   
      CALL  TMATRX  (1)
!
      DO I = 1, 7
          PPXYZ(I) = PXYZ(I)
      ENDDO    
!     ------------------------------------------------- Constant density
      IF (RUNOPT(7) == 'D CONST.  ')  THEN
             DFV = (VOLOLD / VOL)**(1.0/3.0)
             DO I = 1, 3
                 BOX(I) = BOX(I) * DFV
                 DO J = 1, 3
                     H(J,I) = H(J,I) * DFV
                 ENDDO   
             ENDDO    
             CALL  TMATRX  (1)
      END IF
!
      CALL  TABLER  (0)
      RETURN
      END
!
!
!                                                              =========
!=============================================================== RECORD9
      SUBROUTINE  RECORD9
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE GEOMET
      USE CARTES
      USE WORK01
      USE WORK02
      USE VALUES
      USE ACOORD
      use thrmint !kwkt
!
!     ------------------------------------------------- Out put FILE09's
!
      implicit none
!
      double precision        UIUI(LNI)
      double precision        SSS,PK,DPK
      real*4 Ulam1,Ulam2,Ulam3   !kwkt
      CHARACTER(LEN=10)::   DUMMY
      integer(KIND=4)  I,J,KON
                      DUMMY = '          '
!     ----------------------------------------------------------- Values
         IF (NRECRD(1) == 1)  THEN
            VAL0(:) = VAL(:)
         END IF
         NAVT = NAVT + 1
         DO I = 1, LVA
             SSS       = VAL(I)   - VAL0(I)
             TVALL(I)  = TVALL(I) + SSS
             SVALL(I)  = SVALL(I) + SSS*SSS
             IF (VALMAX(I) < VAL(I))  VALMAX(I) = VAL(I)
             IF (VALMIN(I) > VAL(I))  VALMIN(I) = VAL(I)
         ENDDO   
!     --------------------------------------------------- FILE09P for MD
         IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
             IF (TITLE(1).NE.'BENC'     .OR. &
                 TITLE(2).NE.    'HMAR'     )  THEN
                 IF (MOD(NRECRD(1),IRECRD(4)) == 0) THEN
                     NRECRD(4) = NRECRD(4) + 1
                     IF (RUNOPT(18) == 'BINARY    ') THEN
                         WRITE (19) NRECRD(4), ((H(J,I),J=1,3),I=1,3)
                         WRITE (19) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
                     ELSE
                         DO 810  I = 1, NTION
                           DO 811  J = 1, 3
                             IP(J,I)  = P(J,I) * 90000.D0
  811                      CONTINUE
  810                    CONTINUE
                         WRITE (19,9001)  NRECRD(4), &
                                          ((H(J,I),J=1,3),I=1,3)
                         WRITE (19,9002)  ((IP(J,I),J=1,3),I=1,NTION)
                     END IF
                 END IF
             END IF
         END IF
!        -------------------------------------------- Coordinates for XD
         IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
               DO 840  I = 1, NPTP
                     KON = JON(I)
                   DO 820  J = 1, 3
                       PK = P(J,KON)
                       DPK = PK - P0C(J,I) / NBOX(J)
                       IF (DPK >  0.5)  PK = PK - 1.0
                       IF (DPK < -0.5)  PK = PK + 1.0
                       PPK(J,I) = PK
                       JPS(J,I) = PK*9000
                       if (jps(j,i).le.-1000)  jps(j,i)=jps(j,i)+10000
                       if (jps(j,i).ge.10000)  jps(j,i)=jps(j,i)-10000
                       IF (I.LE.NPT)  THEN
                             PK = PK * NBOX(J)
                             PPC(J,I) = PPC(J,I) + PK
                             PPS(J,I) = PPS(J,I) + PK*PK
                       END IF
  820              CONTINUE
  840          CONTINUE
!              ------------------------------------------ FILE09P for XD
               IF (TITLE(1).NE.'BENC'     .OR. &
                   TITLE(2).NE.    'HMAR'     )  THEN
                   IF (MOD(NRECRD(1),IRECRD(4)) == 0) THEN
                       NRECRD(4) = NRECRD(4) + 1
                       IF (RUNOPT(18) == 'BINARY    ') THEN
                           WRITE (19) NRECRD(4),((H(J,I),J=1,3),I=1,3)
                           WRITE (19) ((PPK(J,I),J=1,3),I=1,NPTP)
                       ELSE
                           WRITE (19,9001)  NRECRD(4), &
                                            ((H(J,I),J=1,3),I=1,3)
                           WRITE (19,9002)  ((JPS(J,I),J=1,3),I=1,NPTP)
                       END IF
                   END IF
               END IF
         END IF
!        ------------------------------------------------------- FILE09V
         IF (MOD(NRECRD(1),IRECRD(5)) == 0) THEN
                NRECRD(5) = NRECRD(5) + 1
                IF (TITLE(1).NE.'BENC'     .OR. &
                    TITLE(2).NE.    'HMAR'     )  THEN
                       WRITE (29,1991)  (VAL(I),I=1,LVA)
! 1991 FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.7 / 20F9.3 / 20F9.3 )
 1991 FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.4 / 20F9.3 / 20F9.3 )
                  if (RUNOPT(37) == 'THERM-INT ')then   !kwkt
                    ULAM1 = ULAM
                    ULAM2 = ULAMT/NRECRD(3)
                    ULAM3 = dflambd * ULAMT / NRECRD(3)
                    WRITE (40, '(i10,1x,E15.8e2,1x,E15.8e2,1x,E15.8e2)') NRECRD(1),ULAM1,ULAM2,ULAM3 
                  end if
                END IF
         END IF
!        ------------------------------------------------------ FILE09PV
         IF (RUNOPT(11).NE.'          ')  THEN
!             NRECRD(9) = NRECRD(9) + 1
             IF (TITLE(1) == 'BENC'     .AND. &
                 TITLE(2) ==     'HMAR'     )  RETURN
             IF (RUNOPT(11) == 'VELOCITY  ')  THEN
                 IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
                     NRECRD(9) = NRECRD(9) + 1    ! 2025/10/27
                     IF (RUNOPT(18) == 'BINARY    ') THEN
                         DO 905  I = 1, NTION
                            DO 906  J = 1, 3
                               VV(J,I) = V(J,I) / DTIME
  906                       CONTINUE
  905                    CONTINUE
                         WRITE(28)  NRECRD(1)
                         WRITE(28) ((VV(J,I),J=1,3),I=1,NTION)
                     ELSE
                         DO 910  I = 1, NTION
                          DO 911  J = 1, 3
                           IP(J,I) = V(J,I)*PVMULT*1E-15 /DTIME  &
                                                       +50000.D0
  911                     CONTINUE
  910                    CONTINUE
                         WRITE (28,9001)  NRECRD(1)
                         WRITE (28,9002)  ((IP(J,I),J=1,3),I=1,NTION)
                     END IF
                 END IF
             END IF
             IF (RUNOPT(11) == 'POSITION  ')  THEN
                 IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
                     NRECRD(9) = NRECRD(9) + 1    ! 2025/10/27
                     IF (RUNOPT(18) == 'BINARY    ')  THEN
                         WRITE (28,9001)  NRECRD(1),  H
                         WRITE (28,9002)((SNGL(P(J,I)),J=1,3),I=1,NTION)
                     ELSE
                         DO 920  I = 1, NTION
                           DO 921  J = 1, 3
                            IP(J,I) = P(J,I) * PVMULT
  921                      CONTINUE
  920                    CONTINUE
                         WRITE (28,9001)  NRECRD(1),  H
                         WRITE (28,9002)  ((IP(J,I),J=1,3),I=1,NTION)
                     END IF
                 END IF
             END IF
               IF (RUNOPT(11) == 'ENERGY    ')  THEN
                   IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
                     NRECRD(9) = NRECRD(9) + 1    ! 2025/10/27
                         DO 930  I = 1, NTION
                             UIUI(I) = UI(I) * PVMULT
  930                    CONTINUE
                         WRITE(28,9001) NRECRD(1), BOX(1), &
                                        0.0,0.0,0.0,BOX(2),0.0, &
                                        0.0, 0.0, BOX(3)
                         WRITE(28,9003)(UIUI(I),I=1,NTION)
                   END IF
               END IF
               IF (RUNOPT(11) == 'POSVELENE ')  THEN
                   IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
                     NRECRD(9) = NRECRD(9) + 1    ! 2025/10/27
                         DO 940  I = 1, NTION
                             vv(1,i) = v(1,i)*1E-15 /DTIME
                             vv(2,i) = v(2,i)*1E-15 /DTIME
                             vv(3,i) = v(3,i)*1E-15 /DTIME
                             UIUI(I) = UI(I) * PVMULT
  940                    CONTINUE
                         WRITE(28,9001) NRECRD(1), BOX(1), &
                                        0.0,0.0,0.0,BOX(2),0.0, &
                                        0.0, 0.0, BOX(3)
                         do 945  i = 1, ntion
                              WRITE (28,9004) (P(j,i),j=1,3), &
                                     (Vv(j,i),j=1,3), UIUI(I)
  945                    continue
                   END IF
               END IF
         END IF
!        ---------------------------------------- Pressure tensor FILE11
         IF (RUNOPT(19) == 'PRESSURE  ') THEN
                WRITE (27,2013)  (VAL(J),J=2,8)
 2013           FORMAT (7F9.4)
         END IF
      RETURN
!
 9001 FORMAT (I7,3X, 9F7.3)
 9002 FORMAT (18I5)
 9003 FORMAT (10F8.2)
 9004 FORMAT (3F7.5,1X,3F8.6,1X,F8.4)
      END
!
!
!                                                               ========
!================================================================ INTVAL
      SUBROUTINE  INTVAL
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE PARAMT
      USE GEOMET
      USE VALUES
      USE ACOORD
      USE QUANCO
!
!     --------------------------------------- Print average values, etc.
!
      implicit none
!
      CHARACTER(LEN=8):: SYMB(2)
      CHARACTER(LEN=21)::STRING
      CHARACTER(LEN=36)::FMT1(2),FMT11,FMT12,FMT21,FMT22,FMT23,FMT2(3)
      EQUIVALENCE     (FMT1(1),FMT11),(FMT1(2),FMT12), &
                      (FMT2(1),FMT21),(FMT2(2),FMT22),(FMT2(3),FMT23)
!
      double precision TVV(LVA),TSS(LVA)
      integer*4 ISDV(LEM+1),IVMIN(LEM+1),ITSS(LEM+1),IAVA(LEM+1),ITVV(LEM+1)
      integer(KIND=4) IVMAX(LEM+1)
!     double precision  X,Y,STD
      integer(KIND=4)  I,J,mmm,NN,MM,MJ,FL,II
      DATA  SYMB / 'MAX.  ', 'MIN.  '/
!
         NAV = NAV + 1
         DO 110  I = 1, LVA
             TVAL(I)  = TVAL(I) + TVALL(I)
             SVAL(I)  = SVAL(I) + SVALL(I)
!     STD = SQRT( ABS(X - Y**2/DBLE(I)) / DBLE(I))
             SVALL(I) = DSQRT(ABS(SVALL(I)-TVALL(I)**2/DBLE(IRECRD(3))) &
                        /DBLE(IRECRD(3)))
             TVALL(I) = TVALL(I) / DBLE(IRECRD(3)) + VAL0(I)
             AVA(I,NAV) = TVALL(I)
  110    CONTINUE
         DO I = 1, LEM
             IAVA(I) = INT(TVALL(24+I))
             ISDV(I) = INT(SVALL(24+I))
         enddo   
             IAVA(LEM+1) = INT(TVALL(1))
             ISDV(LEM+1) = INT(SVALL(1))
!
      IF (RUNOPT(3) /= 'ECONOMY  ')  WRITE (16,2100)
!     ------------------------------------- Each nrecrd() step on screen
      FMT11 = '(1X,A3,I6,F7.4,1H(,3F5.2,1H),'
      FMT12 = ' F9.1,F8.1,F6.1,F9.1,F8.5 )  '
      IF (ABS(TVALL(2)) > 9.5.AND.ABS(TVALL(2)) <= 95.0) THEN
        FMT11 = '(1X,A3,I6,F7.3,1H(,3F5.1,1H),'
      ELSE IF (ABS(TVALL(2)) > 95.0)  THEN
        FMT11 = '(1X,A3,I6,F7.2,1H(,3F5.0,1H),'
      END IF
      IF (ABS(TVALL(9)) < 1.0D4.AND.ABS(TVALL(14)) < 1.0D4) THEN
        FMT12 = ' F9.2,F8.2,F6.2,F9.2,F8.5 )  '
      END IF
      WRITE (*,4001)
      WRITE (*,FMT1) 'Avr',IAVA(LEM+1),(TVALL(J),J=2,5),TVALL(9),TVALL(10),TVALL(11),TVALL(14),TVALL(17)
      WRITE (*,FMT1) 'Std',ISDV(LEM+1),(SVALL(J),J=2,5),SVALL(9),SVALL(10),SVALL(11),SVALL(14),SVALL(17)
      WRITE (*,4001)
      write (*,2400)  (ATOM(j),IAVA(j),j=1,ncompo)
 2400 format (1x,'Temperatures:',8(1X,A2,':',I4))
      write (*,4001)
 4001 FORMAT ( 1X,80('-') )
!     --------------------------------- Each nrecrd() step on file06.dat
      FMT11 = '(1X,I5,    5I5,F8.4,1H(,6F6.3,1H), '
      FMT12 = ' F10.2,F9.2,2F7.2,F10.3, F9.5 )    '
      FMT21 = '(1X,i2,2HK+,5I5,F8.4,1H(,6F6.3,1H),'
      FMT22 = ' F10.2,F9.2,2F7.2,F10.3,    F9.5 ) '
      FMT23 = '                                   '
      IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
         FMT11 = '(1X,I5,     5I5,F8.3,1H(,6F6.2,1H),'
         FMT21 = '(1X,i2,2HK+,5I5,F8.3,1H(,6F6.2,1H),'
      ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
         FMT11 = '(1X,I5,     5I5,F8.2,1H(,6F6.1,1H),'
         FMT21 = '(1x,i2,2HK+,5I5,F8.2,1H(,6F6.1,1H),'
      END IF
      IF (ABS(TVALL(9)) < 1.0D4.AND.ABS(TVALL(14)) < 1.0D4)  THEN
         FMT12 = ' F10.3,F9.3,2F7.3,F10.4,    F9.5 ) '
         FMT22 = ' F10.3,F9.3,2F7.3,F10.4,    F9.5 ) '
      END IF
      mmm = NRECRD(1)/100000
      WRITE (16,FMT1)  mod(NRECRD(1),100000), &
                       (IAVA(I),I=1,4),IAVA(LEM+1),(TVALL(J),J=2,11), &
                                 TVALL(13),TVALL(14),TVALL(17)
      WRITE (16,FMT2)  mmm, (ISDV(I),I=1,4), ISDV(LEM+1), &
                            (SVALL(J),J=2,11), SVALL(13), SVALL(14), &
                                               SVALL(17)
!
                        NN = IRECRD(2)/IRECRD(3)
                        MM = MOD(NRECRD(1)/IRECRD(3), NN)
                        MJ = 2
                        IF (RUNOPT(3) == 'ECONOMY  ') MJ = 10
                        IF (MOD(MM,MJ).NE.0)  RETURN
!
        DO 150  I = 1, LVA
!     STD = SQRT( ABS(X - Y**2/DBLE(I)) / DBLE(I))
        TSS(I) = SQRT(ABS(SVAL(I)-TVAL(I)**2/DBLE(NAVT))/DBLE(NAVT))
        TVV(I) = TVAL(I) / DBLE(NAVT) + VAL0(I)
  150   CONTINUE
        DO 160  I = 1, LEM
            IVMAX(I) = INT(VALMAX(24+I))
            IVMIN(I) = INT(VALMIN(24+I))
            ITSS(I)  = INT(TSS(24+I))
            ITVV(I)  = INT(TVV(24+I))
  160   CONTINUE
            IVMAX(LEM+1) = INT(VALMAX(1))
            IVMIN(LEM+1) = INT(VALMIN(1))
            ITSS(LEM+1)  = INT(TSS(1))
            ITVV(LEM+1)  = INT(TVV(1))
!
!        --------------------------------------------------- Min and max
         WRITE (16,2105)
                        FMT11 = '(1X,A5, 5I5,F8.4,1H(,6F6.3,1H), '
         IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
           FMT11 = '(1X,A5, 5I5,F8.3,1H(,6F6.2,1H), '
         ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
           FMT11 = '(1X,A5, 5I5,F8.2,1H(,6F6.1,1H), '
         END IF
         WRITE (16,FMT1)  SYMB(1), (IVMAX(I),I=1,4),IVMAX(LEM+1),&
                                   (VALMAX(J),J= 2,11),VALMAX(13),&
                                            VALMAX(14),VALMAX(17)
         WRITE (16,FMT1)  SYMB(2), (IVMIN(I),I=1,4),IVMIN(LEM+1), &
                                   (VALMIN(J),J= 2,11),VALMIN(13), &
                                            VALMIN(14),VALMIN(17)
!        ------------------------------ Each nrecrd() step in file06.dat
                        FMT11 = '(1X,I5,5I5,F8.4,1H(,6F6.3,1H),     '
         IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
                        FMT11 = '(1X,I5,5I5,F8.3,1H(,6F6.2,1H),     '
         ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
                        FMT11 = '(1X,I5,5I5,F8.2,1H(,6F6.1,1H),     '
         END IF
         WRITE (16,2105)
         WRITE (16,FMT1)  NAVT, (ITVV(I),I=1,4),ITVV(LEM+1), &
                                (TVV(J),J=2,11),TVV(13),TVV(14),TVV(17)
         WRITE (16,FMT2)  mmm,  (ITSS(I),I=1,4),ITSS(LEM+1), &
                                (TSS(J),J=2,11),TSS(13),TSS(14),TSS(17)
         WRITE (16,2105)
         if (NCOMPO > 4) then
               write (16,2500)  (ATOM(j),TVV(24+j),j=1,ncompo)
 2500          format (2x,'Temperatures:',10(2X,A2,':',F6.1))
               WRITE (16,2105)
         end if
         WRITE (16,2880)  VCORR/(3.0D0*VOL*1.0D-24)*1.0D-10,ECORR*FJMOL
 2880    FORMAT (9X,'Corrections for van der Waals interactions ', &
                 '(approx.) : Pcorr=',F8.4,' GPa',9X,'Ecorr(short)=', &
                 F8.3,' kJ/mol')
         IF (RUNOPT(12) == 'QUANTUM   ')  THEN
               WRITE (16,2990)  TEMPQH/NAVT
 2990          FORMAT (9X,'Effective temperature in quantum correction',&
                          ' is ',F7.2, ' K')
         END IF
         WRITE (16,2105)
!     ------------------------------------------ Basic cell edge lengths
      WRITE (16,4038)
 4038 FORMAT (1X)
                                      STRING = '[ MD basic cell ]    '
      IF (RUNOPT(17) == 'CRYSTAL   ')  STRING = '[ crystal unit cell ]'
      WRITE (16,4039)
 4039 FORMAT (1X,'I',78('-'),'I')
      WRITE (16,4000)  STRING
      write (16,4101)  TVALL(19),SVALL(19),VALMIN(19),VALMAX(19), &
                       TVALL(22),SVALL(22),VALMIN(22),VALMAX(22)
      write (16,4102)  TVALL(20),SVALL(20),VALMIN(20),VALMAX(20), &
                       TVALL(23),SVALL(23),VALMIN(23),VALMAX(23)
      write (16,4103)  TVALL(21),SVALL(21),VALMIN(21),VALMAX(21), &
                       TVALL(24),SVALL(24),VALMIN(24),VALMAX(24)
 4000 FORMAT (' I Cell dimensions (Angstrom, degree) ',10X,A21,11X,'I')
 4101 format (' I  A:',    F9.5,'(',F6.5,')',F8.4,'-',F8.4,2X, &
                  'Alpha:',F8.4,'(',F6.4,')',F7.3,'-',F7.3,' I')
 4102 format (' I  B:',    F9.5,'(',F6.5,')',F8.4,'-',F8.4,2X, &
                  'Beta :',F8.4,'(',F6.4,')',F7.3,'-',F7.3,' I')
 4103 format (' I  C:',    F9.5,'(',F6.5,')',F8.4,'-',F8.4,2X, &
                  'Gamma:',F8.4,'(',F6.4,')',F7.3,'-',F7.3,' I')
!     --------------------------------------------------------- Energies
      WRITE (16,4039)
      WRITE (16,4030)  TVV(12),TSS(12), TVV(14),TSS(14)
      write (16,4031)  TVV(13),TSS(13), TVV(16),TSS(16)
      write (16,4032)TVV(15),TSS(15), TVV(18),TSS(18)
 4030 FORMAT (' I  U =',F11.4, '(',F9.4,')kJ/mol   E = U+K =',F12.4, &
                               '(',F9.4,')kJ/mol    I')
 4031 format (' I  K =',F11.4, '(',F9.4,')kJ/mol   H = E+PV=',F12.4, &
                               '(',F9.4,')kJ/mol    I')
 4032 format (' I  PV=',F11.4,'(',F8.4,')kJ/mol   ',  &
                   'Molar volume=',F10.4,'(',F8.4,')cm3/mol   I')
      WRITE (16,4039)
!     ---------------------------------------- Mean square displacements
         FL = 1
         DO 405  I = 1, 10
            IF (VALMAX(I+24+LEM) >= 10.0)   FL = 10
            IF (VALMAX(I+24+LEM) >= 100.0)  FL = 100
  405    CONTINUE
         FMT21 = '(9H I M.S.D ,                       '
         FMT22 = '2(3X,A2, 1H:, F6.3, 1H(, F5.3,1H),  '
         FMT23 = ' F6.3,1H-, F6.3,2X),1HI )          '
         IF (FL.GE.10) THEN
               FMT22 = '2(3X,A2, 1H:, F6.2, 1H(, F5.2,1H),  '
               FMT23 = ' F6.2,1H-, F6.2,2X),1HI )          '
         END IF
      WRITE (16,FMT2)(ATOM(I),TVALL(I+24+LEM),SVALL(I+24+LEM),VALMIN(I+24+LEM),&
                                                  VALMAX(I+24+LEM),I=1,2)
         FMT21 = '(9H I       ,                       '
       DO 410  II = 1, 4
         IF (NCOMPO > II*2)  WRITE (16,FMT2)  (ATOM(I),TVALL(I+24+LEM), &
                  SVALL(I+24+LEM),VALMIN(I+24+LEM),VALMAX(I+24+LEM),I=II*2+1,II*2+2)
  410 CONTINUE
      WRITE (16,4039)
!     ------------------------------------------------------------------
      DO 190  I = 1, LVA
          VALMIN(I) = 9.9D19
          VALMAX(I) =-9.9D19
  190 CONTINUE
      RETURN
!
! 2001 FORMAT (1X)
 2100 FORMAT (1X,132('-'))
 2105 FORMAT (1X,132('='))
      END
!
!
!                                                               ========
!================================================================ SUMMRY
      SUBROUTINE  SUMMRY
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
      USE GEOMET
      USE VALUES
      USE ACOORD
!
!     --------------------------------------- Print average values, etc.
!
      implicit none
!
      CHARACTER(LEN=8)::    HEAD(2)
      CHARACTER(LEN=21)::   STRING
      CHARACTER(LEN=40)::   FMT1(2),FMT11,FMT12
      EQUIVALENCE     (FMT1(1),FMT11), (FMT1(2),FMT12)
!
      double precision  TBOX(6),TRBOX(6),COSA(3),SINA(3)
      double precision  TVAL2,SINTHT,THT
      double precision  AVA2I
      integer(KIND=4)  I,II,J
      DATA  HEAD / 'AVE' , 'SGM'/
!
      IF (IRECRD(1).LE.0)  RETURN
!
      WRITE (16,2001)
      WRITE (16,2100)
      WRITE (16,2452)
 2452 FORMAT ('  N50  Temp   P/GPa (  Pxx,  Pyy,  Pzz,  Pyz,  ', &
               'Pxz,  Pxy )  U:Coulomb  Short 3-body Kinet.  ', &
               'Total   Density    Cell parameters (A)')
      WRITE (16,2100)
      DO 210  I = 1, NAV
          AVA2I = ABS(AVA(2,I))
                     FMT11 = '(2X,I3, F7.1, F8.4,''('',6F6.3,'')'',   '
                     FMT12 = 'F10.2,F9.2,2F7.2,F9.2, F8.5,1X,3F8.4)   '
          IF (AVA2I > 9.0 .AND. AVA2I < 95.0)  THEN
                     FMT11 = '(2X,I3, F7.1, F8.3,''('',6F6.2,'')'',   '
          ELSE IF (AVA2I.GE.95.0)  THEN
                     FMT11 = '(2X,I3, F7.1, F8.2,''('',6F6.1,'')'',   '
          END IF
          IF (ABS(AVA(9,I)) < 1.0D4.AND.ABS(AVA(14,I)) < 1.0D4)  THEN
                     FMT12 = 'F10.3,F9.3,2F7.3,F9.3, F8.5,1X,3F8.4)   '
          END IF
          WRITE (16,FMT1)  I,(AVA(J,I),J=1,11), AVA(13,I), AVA(14,I), &
                                         AVA(17,I),(AVA(J,I),J=19,21)
  210 CONTINUE
!
      DO I = 1, LVA
!     STD = SQRT( ABS(X - Y**2/DBLE(I)) / DBLE(I))
          SVAL(I) =SQRT(ABS(SVAL(I)-TVAL(I)**2/DBLE(NAVT))/DBLE(NAVT))
          TVAL(I) = TVAL(I) / DBLE(NAVT) + VAL0(I)
      ENDDO 
      WRITE (16,2100)
!
      TVAL2 = ABS(TVAL(2))
                      FMT11 = '(1X,A4, F7.1, F8.4,''('',6F6.3,'')'',   '
                      FMT12 = 'F10.2,F9.2,2F7.2,F9.2, F8.5,1X,3F8.4)   '
      IF (TVAL2 > 9.0 .AND. TVAL2 < 95.0)  THEN
                      FMT11 = '(1X,A4, F7.1, F8.3,''('',6F6.2,'')'',   '
      ELSE IF (TVAL2.GE.95.0)  THEN
                      FMT11 = '(1X,A4, F7.1, F8.2,''('',6F6.1,'')'',   '
      END IF
      IF (ABS(TVAL(9)) < 1.0D4.AND.ABS(TVAL(14)) < 1.0D4)  THEN
                      FMT12 = 'F10.3,F9.3,2F7.3,F9.3, F8.5,1X,3F8.4)   '
      END IF
      WRITE (16,FMT1)  HEAD(1),(TVAL(J),J=1,11),TVAL(13),TVAL(14), &
                                TVAL(17),       (TVAL(J),J=19,21)
      WRITE (16,FMT1)  HEAD(2),(SVAL(J),J=1,11),SVAL(13),SVAL(14), &
                                SVAL(17),       (SVAL(J),J=19,21)
      WRITE (16,2100)
!
      WRITE (16,2001)
      WRITE (16,4039)
 4039 FORMAT (1X,'I',75('-'),'I')
!     ------------------------------------------ Basic cell edge lengths
                                       STRING = '[ MD basic cell ]    '
      IF (RUNOPT(17) == 'CRYSTAL   ')  STRING = '[ crystal unit cell ]'
      write(16,4000) STRING
      write(16,4001) TVAL(19),SVAL(19),TVAL(22),SVAL(22)
      write(16,4002) TVAL(20),SVAL(20),TVAL(23),SVAL(23)
      write(16,4003) TVAL(21),SVAL(21),TVAL(24),SVAL(24)
 4000 FORMAT (' I Cell dimensions (Angstrom, degree)',10X,A21,9X,'I')
 4001 format (' I      A(X):', F9.5,' (+-',F7.5,')',6X, &
                      'Alpha(B-C):',F9.4,' (+-',F6.4,')','      I')
 4002 format (' I      B(Y):', F9.5,' (+-',F7.5,')',6X, &
                      'Beta (A-C):',F9.4,' (+-',F6.4,')','      I')
 4003 format (' I      C(Z):', F9.5,' (+-',F7.5,')',6X, &
                      'Gamma(A-B):',F9.4,' (+-',F6.4,')','      I')
!      WRITE (16,4000)  STRING,
!     *                 (TVAL(I),SVAL(I),TVAL(I+3),SVAL(I+3), I=19,21)
! 4000 FORMAT (' I Cell dimensions (Angstrom, degree)',10X,A21,9X,'I'
!     *       /' I      A(X):', F9.5,' (+-',F7.5,')',6X,
!     *                'Alpha(B-C):',F9.4,' (+-',F6.4,')','      I',
!     *       /' I      B(Y):', F9.5,' (+-',F7.5,')',6X,
!     *                'Beta (A-C):',F9.4,' (+-',F6.4,')','      I',
!     *       /' I      C(Z):', F9.5,' (+-',F7.5,')',6X,
!     *                'Gamma(A-B):',F9.4,' (+-',F6.4,')','      I')
!     -------------------------------------------------------- Energies
      WRITE (16,4039)
      WRITE (16,4030)  TVAL(12),SVAL(12), TVAL(14),SVAL(14)
      write (16,4031)  TVAL(13),SVAL(13), TVAL(16),SVAL(16)
      write (16,4032)  TVAL(15),SVAL(15), TVAL(18),SVAL(18)
 4030 FORMAT (' I  U =',F11.4,'(',F7.4,')kJ/mol   E = U+K =',F12.4, &
                              '(',F7.4,')kJ/mol     I')
 4031 FORMAT (' I  K =',F11.4,'(',F7.4,')kJ/mol   H = E+PV=',F12.4, &
                              '(',F7.4,')kJ/mol     I')
 4032 format (' I  PV=',F11.4,'(',F7.4,')kJ/mol   ',  &
                   'Molar volume=',F10.4,'(',F7.4,')cm3/mol  I')
      WRITE (16,4039)
!     ------------------------------------------------------------ M.s.d
      WRITE (16,4020)  (ATOM(I),TVAL(I+24+LEM),SVAL(I+24+LEM),I=1,2)
 4020 FORMAT (' I  Mean sq.disp. ',2(5X,A2,':',F8.3,' (+-',F6.3,')'), &
                                                             '     I' )
      DO 410  II = 1, 4
         IF (NCOMPO > II*2)  WRITE (16,4022)  (ATOM(I),TVAL(I+24+LEM), &
                                            SVAL(I+24+LEM),I=II*2+1,II*2+2)
 4022    FORMAT (' I',16X,2(5X,A2,':',F8.3,' (+-',F6.3,')'),5X,'I' )
  410 CONTINUE
      WRITE (16,4039)
!     ------------------------------------------------------------------
      WRITE (16,4050)  (TITLE(I),I=1,15)
      write (16,4051)  
      write (16,4052)  
      write (16,4053)
      write (16,4054) TVAL(1), TVAL(2), TVAL(12),TVAL(13),TVAL(14), &
                       TVAL(15),TVAL(16),TVAL(17),TVAL(18)
      write (16,4055) SVAL(1), SVAL(2), SVAL(12),SVAL(13),SVAL(14), &
                       SVAL(15),SVAL(16),SVAL(17),SVAL(18)
      write (16,4051)
      write (16,4056)
      write (16,4053)
      write (16,4057)TVAL(1),TVAL(2),(TVAL(I),I=19,24)
      write (16,4058)SVAL(1),SVAL(2),(SVAL(I),I=19,24)
      write (16,4051)
 4050 FORMAT (6X,15A4)
 4051 format (78('='))
 4052 format ('  T/K    P/GPa   U/kJ/m.  K/kJ/m.  E(U+K) ', &
              '   PV      H(E+PV)  D/g/cm3  V/c3/m ')
 4053 format (78('-'))
 4054 format (1X,F6.1,F8.4, F10.3,F8.3,F10.3,F8.3,F10.3, F8.4,F8.3,1X)
 4055 format (1X,F6.1,F8.4, F10.3,F8.3,F10.3,F8.3,F10.3, F8.4,F8.3,1X)
 4056 format ('  T/K    P/GPa        A         B         C  ', &
                        '    Alpha     Beta      Gamma   ' )
 4057 format (1X,F6.1,F8.4,1X,3F10.5,3F10.4)
 4058 format (1X,F6.1,F8.4,1X,3F10.5,3F10.4)
!     --------------------------------------- Average reciprocal lattice
      DO 510  I = 1, 6
         TBOX(I) = TVAL(I+18)
  510 CONTINUE
      DO 520  I = 1, 3
          COSA(I) = TBOX(I+3)
          IF (TBOX(I+3) > 1.0D0)  THEN
               COSA(I) = COS(TBOX(I+3)*PI/180.0D0)
               TBOX(I+3) = COSA(I)
          END IF    
          SINA(I) = SQRT(1.0D0 - COSA(I)**2)
  520 CONTINUE
      VOL = TBOX(1)*TBOX(2)*TBOX(3) * SQRT(1.0 -COSA(1)**2 -COSA(2)**2 &
                            -COSA(3)**2 + 2.0*COSA(1)*COSA(2)*COSA(3))
      TRBOX(1) =  TBOX(2)*TBOX(3)*SINA(1) / VOL
      TRBOX(2) =  TBOX(1)*TBOX(3)*SINA(2) / VOL
      TRBOX(3) =  TBOX(1)*TBOX(2)*SINA(3) / VOL
      TRBOX(4) = (COSA(2)*COSA(3)-COSA(1)) / (SINA(2)*SINA(3))
      TRBOX(5) = (COSA(1)*COSA(3)-COSA(2)) / (SINA(1)*SINA(3))
      TRBOX(6) = (COSA(1)*COSA(2)-COSA(3)) / (SINA(1)*SINA(2))
      DO 530  I = 1, 3
          SINTHT = SQRT(1.0D0 - TRBOX(I+3)**2)
          THT = ATAN(SQRT(SINTHT) / TRBOX(I+3)) * 180.0/PI
          IF (THT < 0.0)  THT = THT + 180.0
          TRBOX(I+3) = THT
  530 CONTINUE
      WRITE (16,4070)  (TRBOX(I),I=1,6)
      write (16,4071)
 4070 FORMAT (1X, 'A*=',F9.7,' B*=',F9.7,' C*=',F9.7, &
              '  aA*=',F7.3,' aB*=',F7.3,' aC*=',F7.3)
 4071 format (78('='))
!
      RETURN
 2001 FORMAT (1X)
 2100 FORMAT (1X,132('-'))
! 2105 FORMAT (1X,132('='))
      END
!
!
!                                                               ========
!================================================================ PCFRCN
      SUBROUTINE  PCFRCN
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE ABOXOF
      USE ATOMSI
      USE RADIAL
!
!     -------------------------------------- Pair correlation functions,
!                                          Running coordination numbers,
!
      implicit none
!
      CHARACTER(LEN=40)::   FORM1, FORM2, FORM3, FORM4
      double precision     PCF(LEF),RHO(LEF),RCN(LEF),PATOM(LEF)
      double precision     AM,R1,R2,VS,PRN,PRD
      integer(KIND=4)     KRCN(LEF),KPCF(LEF)
      integer(KIND=4)     IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer(KIND=4)     IMULT,L,I,J,IND,IEND,K
      real(4)::       EI,EJ
!
!     --------------------------------------- Print pair-RDF's and RCN's
!         IPRDF(1) : Interval of printing RDF's (0.001*IPRDF(1))
!         IPRDF(2) : End of printing RDF's (IPRDF(2)*0.01 Angstroms)
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      write (16, 1110)
      WRITE (16, 1111)  NJOB,TITLE, NRECRD(2), IHOUR,IMINUT,ISECND, &
                                               IYEAR,IMONTH,IDAY
 1110 format (1x)
 1111 FORMAT (' <<<',I4,'-',I2,'  >>>  ',15A4,' <<< ',I5, &
                ' steps  >>>   at ',I2,':',I2,':',I2, &
                            '  on ',I4,'/',I2,'/',I2 )
!
      NPAIR = NCOMPO * (NCOMPO+1) / 2
      IMULT = 100
      IF (NCOMPO.LE.2)  THEN
                  IMULT = 1
                  FORM1 = '(7X,         3(7X,A2,1H-,A2,2X))        '
                  FORM2 = '(7H R /A  ,  3(14H    pcf  rcn  )     ) '
                  FORM3 = '(1X,F5.3,1X, 3(F8.3,F6.3),F6.2)         '
                  FORM4 = '(1X, 46(1H-)                          ) '
      ELSE IF (NCOMPO == 3) THEN
                  IMULT = 1
                  FORM1 = '(7X,         6(6X,A2,1H-,A2,1X))        '
                  FORM2 = '(7H R /A  ,  6(12H    pcf rcn )       ) '
                  FORM3 = '(1X,F5.3,1X, 6(F7.2,F5.2),F6.2)         '
                  FORM4 = '(1X, 79(1H-)                          ) '
      ELSE IF (NCOMPO == 4) THEN
                  FORM1 = '(7X,        10(5X,A2,1H-,A2))           '
                  FORM2 = '(7H R /A  , 10(10H   pcf rcn)         ) '
                  FORM3 = '(1X,F5.3,1X,10(I6,I4),F6.2)             '
                  FORM4 = '(1X, 107(1H-)                         ) '
      ELSE IF (NCOMPO == 5) THEN
                  FORM1 = '(6X,        15(3X,A2,1H-,A2))           '
                  FORM2 = '(6H R /A ,  15(8H pcf rcn)            ) '
                  FORM3 = '(1X,F5.3,   15(I4,I4),F6.2)             '
                  FORM4 = '(1X, 126(1H-)                         ) '
      ELSE IF (NCOMPO == 6)  THEN
                  IMULT = 10
                  FORM1 = '(6X,        21(1X,A2,1H-,A2))           '
                  FORM2 = '(6H R /A ,  21(6H pc cn)         )      '
                  FORM3 = '(1X,F4.2,1X,21(I3,I3),F6.2)             '
                  FORM4 = '(1X, 132(1H-)                         ) '
      ELSE IF (NCOMPO.GE.7)  THEN
                  IMULT = 10
                  FORM1 = '(6X,        21(1X,A2,1H-,A2))           '
                  FORM2 = '(6H R /A ,  21(6H pc cn)         )      '
                  FORM3 = '(1X,F4.2,1X,28(I3,I3),F6.2)             '
                  FORM4 = '(1X, 132(1H-)                         ) '
      END IF
!
      WRITE (16,2500)
      write (16,2501)
      write (16,2502) IMULT
      write (16,2500)
 2500 format (1x)
 2501 format (' Pair correlation functions (pcf) and running ', &
                'oordination numbers (rcn) ')
 2502 format (' of ion pairs  (multiplied by ',I4,')')
      IF (NCOMPO.LE.6)  THEN
            WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,NCOMPO)
      ELSE
            WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,7)
      END IF
      WRITE (16,FORM2)
      WRITE (16,FORM4)
             L = 0
      DO 20  I = 1, NCOMPO
          DO 10  J = 1, I
                 L = L + 1
              AM = 1.0
              IF (I == J)  AM = 0.5
              EI = REAL(NION(I))
              EJ = REAL(NION(J))
              RCN(L)   = 0.0
              PATOM(L) = AMIN1(EI,EJ) * AM
              RHO(L)   = REAL(EI)*REAL(EJ)*AM/(BOX(1)*BOX(2)*BOX(3))
   10     CONTINUE
   20 CONTINUE
      IND  = 0
      I    = 10
      IEND = IPRDF(2)
!
  280 R1 = DBLE(I)* 0.01D0 + 0.005D0*DBLE(IPRDF(1))
      R2 = R1 + 0.01D0*DBLE(IPRDF(1))
      VS = 4.0*PI/3.0 * ((R2*R2*R2) - (R1*R1*R1))
              PRN = 0.0
              DO 220 L = 1, NPAIR
                  PCF(L) = 0.0
                  IF (PATOM(L) > 1.0E-6) THEN
                        PRD = 0.0
                        DO 210  K = 1, IPRDF(1)
                            PRD = PRD + DBLE(NRDF(I+K,L))
  210                   CONTINUE
                        PRN    = PRN + PRD
                        PRD    = PRD / DBLE(NRECRD(2))
                        RCN(L) = RCN(L) + PRD / PATOM(L)
                        PCF(L) = PRD / (VS * RHO(L))
                  END IF
  220         CONTINUE
              DO 225 L = 1, LEE
                  KRCN(L) = INT(RCN(L) * IMULT + 0.5)
                  KPCF(L) = INT(PCF(L) * IMULT + 0.5)
  225         CONTINUE
              IF (PRN > 0.5.AND.IND == 0)  THEN
                    IND  = 1
                    IF (IEND > 9990)  IEND = I + 250
              END IF
              IF (IND == 1) THEN
                    IF (NCOMPO.LE.3)  THEN
                          WRITE (16,FORM3) R1+0.01, &
                                      (PCF(K),RCN(K),K=1,NPAIR)
                    ELSE IF (NCOMPO.LE.6)  THEN
                          WRITE (16,FORM3) R1+0.01, &
                                      (KPCF(K),KRCN(K),K=1,NPAIR)
                    ELSE 
                          WRITE (16,FORM3) R1+0.01, &
                                      (KPCF(K),KRCN(K),K=1,21)
                    END IF
              END IF
          I = I + IPRDF(1)
      IF (I < IEND)  GO TO 280
      WRITE (16,FORM4)
      WRITE (16,FORM2)
      IF (NCOMPO.LE.6)  THEN
            WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,NCOMPO)
      ELSE
            WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,7)
      END IF
!
      RETURN
      END
!
!
!                                                               ========
!================================================================ POTPLT
      SUBROUTINE  POTPLT
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE ATOMSI
!
!     ------------------------------------ Distribution of ion potential
!
      implicit none
!
      CHARACTER(LEN=1):: IGRAPH(132)
      double precision     BU(LNI),UMAX(LEM),UMIN(LEM),UAV(LEM)
      double precision     RNDF,UOMIN,UOMAX
      double precision     AMAX,AMIN,UR
      integer(KIND=4)     NSTAT(132,LEM)
      integer(KIND=4)  IO,I1,I2,I,J,NNN,IAMIN,IAMAX,MUP,J1,J2,JU,N,NP,K
      integer(KIND=4)  IUOMIN,IUOMAX
!
!     ------------------------------- Ionic potentials and displacements
!
      RNDF = 1.0E12 / DBLE(IRECRD(2))
      AMAX = -9.9E19
      AMIN =  9.9E19
      DO 210  IO = 1, NCOMPO
          UMAX(IO) = 0.0
          UMIN(IO) = 0.0
          UAV(IO)  = 0.0
          IF (IION(IO).LE.-999)  GO TO 210
          IF (NION(IO) > 0) THEN
                UMAX(IO) = -9.9E19
                UMIN(IO) =  9.9E19
                I1 = IONS(1,IO)
                I2 = IONS(2,IO)
                DO 100  I = I1, I2
                    BU(I)   = AU(I) * RNDF
                    UAV(IO) = UAV(IO) + BU(I)
                    IF (UMAX(IO) < BU(I))  UMAX(IO) = BU(I)
                    IF (UMIN(IO) > BU(I))  UMIN(IO) = BU(I)
  100           CONTINUE
                UAV(IO) = UAV(IO) / DBLE(NION(IO))
                IF (AMAX < UMAX(IO))  AMAX = UMAX(IO)
                IF (AMIN > UMIN(IO))  AMIN = UMIN(IO)
                GO TO 160
          ELSE
                UMAX(IO) = 0.0
                UMIN(IO) = 0.0
          END IF
  160     DO 200 J = 1, 132
              NSTAT(J,IO) = 0
  200     CONTINUE
  210 CONTINUE
      WRITE (16,4004)
      WRITE (16,4001)
      NNN = NCOMPO
      if (NNN.gt.6)  NNN = 6
      WRITE (16,4000)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=1,NNN)
      IF (NCOMPO > 6)  THEN
            WRITE (16,4002)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=7,9)
          IF (NCOMPO > 9)  THEN
            WRITE (16,4003)  (ATOM(I), UAV(I), UMIN(I),UMAX(I),  &
                                                          I=10,NCOMPO)
          END IF
      END IF
!     ----------------------------------------------- Plot whole of ions
      IAMIN = INT(AMIN - 0.999999)
      IAMAX = INT(AMAX)
              IF (AMAX > 0.0)  IAMAX = INT(AMAX + 0.999999)
      UR = 131.0 / DBLE(IAMAX - IAMIN)
      MUP = 0
      DO 360  IO = 1, NCOMPO
          IF (IION(IO).LE.-999)  GO TO 360
          IF (NION(IO).LE.0)     GO TO 360
          J1 = IONS(1,IO)
          J2 = IONS(2,IO)
          DO 320  J = J1, J2
              JU = INT((BU(J) - DBLE(IAMIN))*UR+1.5)
              NSTAT(JU,IO) = NSTAT(JU,IO) + 1
  320     CONTINUE
          DO 350  J = 1, 132
              IF (MUP < NSTAT(J,IO))  MUP = NSTAT(J,IO)
  350     CONTINUE
  360 CONTINUE
      IF (MUP > 20)  MUP = 20
      DO 450  N = 1, MUP
!         WRITE (16,4004)
          NP = MUP + 1 - N
!         DO 420  I = 1, NCOMPO
              DO 405  J = 1, 132
                  IGRAPH(J) = ' '
  405         CONTINUE
              IGRAPH(1)   = ':'
              IGRAPH(132) = ':'
              DO 410  J = 1, 132
                  DO 400  IO = 1, NCOMPO
                      IF (IION(IO) > -998)  THEN
                          IF (NSTAT(J,IO).GE.NP)  IGRAPH(J) = ATOM(IO)
                      END IF
  400             CONTINUE
  410         CONTINUE
              WRITE (16, 4010)  (IGRAPH(K), K=1,132)
!  420     CONTINUE
  450 CONTINUE
      WRITE (16, 4020) IAMIN, IAMAX
      IF (NION(1).LE.1)  RETURN
!     ---------------------------------------- Oxygen ion potential only
      DO 510  I = 1, 132
          NSTAT(I,1) = 0
  510 CONTINUE
          UOMIN = UMIN(1)
          UOMAX = UMAX(1)
          IUOMIN = INT(UOMIN - 0.999999)
          IUOMAX = INT(UOMAX)
                  IF (UOMAX > 0.0)  IUOMAX = INT(UOMAX + 0.999999)
          UR = 131.0 / DBLE(IUOMAX - IUOMIN)
          MUP = 0
          J1 = IONS(1,1)
          J2 = IONS(2,1)
          DO 520  J = J1, J2
              JU = INT((BU(J) - DBLE(IUOMIN))*UR + 1.5)
              IF (JU < 1)  JU = 1
              NSTAT(JU,1) = NSTAT(JU,1) + 1
  520     CONTINUE
          DO 550  J = 1, 132
              IF (MUP < NSTAT(J,1))  MUP = NSTAT(J,1)
  550     CONTINUE
          IF (MUP > 20)  MUP = 20
          DO 650  N = 1, MUP
              NP = MUP + 1 - N
              DO 605  J = 1, 132
                  IGRAPH(J) = ' '
  605         CONTINUE
              IGRAPH(1)   = ':'
              IGRAPH(132) = ':'
              DO 610  J = 1, 132
                  IF (NSTAT(J,1).GE.NP)  IGRAPH(J) = ATOM(1)
  610         CONTINUE
              WRITE (16, 4010)  (IGRAPH(K), K=1,132)
  650     CONTINUE
          WRITE (16, 4020) IUOMIN, IUOMAX
!
 4001 FORMAT (' I',130('-'),'I')
 4000 FORMAT (' I Distribution of ion potentials', &
                   3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I' &
              /' I', 17X,'(*1.0E-12 erg)', &
                         3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4002 FORMAT (' I',31X,  3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4003 FORMAT (' I',31X,  3X,1(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4004 FORMAT (1X)
 4010 FORMAT (1X, 132A1)
 4020 FORMAT (' I---<',I5,1X, 110('-'), I5, ' >---I' )
      RETURN
      END
!
!
!                                                               ========
!=============================================================  FIND_H2O
SUBROUTINE  FIND_H2O (IM)  !kwkt
  use param
  use aboxof
  use atomsi
  use molecu
  use counts
  use paramt
  use charac    !kwkt
  use cartes    !kwkt
!
  implicit none
!
!     This option can recognize wate molecules and calculate dipole moment
!
  double precision PIX,PIY,PIZ,PJX0,PJY0,PJZ0,PJX,PJY,PJZ,RX,RY,RZ
  double precision DXH,DYH,DZH,R2
  integer(KIND=4) nh,i,j,IM,k,no
  if (istart == 0 ) then
    allocate(ih2o(5,NIONO))
    istart = 1
  endif

  IF(IM == 1) goto 100
!     --------------------------------------Recognize H2O molecules
  dxh = 0.0D0
  dyh = 0.0D0
  dzh = 0.0D0
  no = 0
  DO i = ions(1,IATOMO),ions(2,IATOMO)
    no = no + 1
    DO nh = 1,5
      ih2o(nh,no) = 0
    enddo
  enddo
  no = 0
  do i = ions(1,IATOMO), ions(2,IATOMO)
    nh = 1
    no = no + 1
    ih2O (1, no) = i   ! index of oxygen
    PIX=p(1,i)
    PIY=p(2,i)
    PIZ=p(3,i)
    do j = ions(1,IATOMH), ions(2,IATOMH)
      pjx0=p(1,j)
      pjy0=p(2,j)
      pjz0=p(3,j)
      if (pjx0 < pix)  pjx0 = pjx0 + 1.0
      if (pjy0 < piy)  pjy0 = pjy0 + 1.0
      if (pjz0 < piz)  pjz0 = pjz0 + 1.0
      DO  K = 1, 8
        pjx = pjx0 - transx(k)
        pjy = pjy0 - transy(k)
        pjz = pjz0 - transz(k)
        RX = PIX - PjX
        RY = PIY - PjY
        RZ = PIZ - PjZ
        DXH = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
        DYH = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
        DZH = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
        R2 = DXH*DXH + DYH*DYH + DZH*DZH
        IF (R2 <= dintra**2) then
          nh = nh + 1
          ih2o(nh,no) = j
          exit
        end if
      ENDDO
    enddo
    if (nh /= 3)  then
      write (*,*) i,'-th ox : No.OH bonds=',nh-1
      stop
    endif
  enddo
!
!write(*,*)"FindH2Oend"
  if (runopt(37) == 'THERM-INT ') GOTO 999 !kwkt

100 CONTINUE

!
999 RETURN
END
!  
!                                                               ========
!================================================================ COORDN
      SUBROUTINE COORDN 
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE WORK01
      USE WORK02
      USE ACOORD
!
!     ---------- Comparison between MD derived atomic coordinartes and
!                                                crystallographic data
!
      implicit none
!
      double precision        XYZ(3,LAT),SXYZ(3,LAT)
      double precision        SSS, DDD
      double precision        RMR,DXX,DYY,DZZ,SX,SY,SZ,PXO,PYO,PZO
      double precision        DHY,DHX,DX,DY,DZ,SXI,SYI,DXI,DYI
      double precision        XO,YO,ZO,P0CJI
!     INTEGER   *4    IPSS(3,LAT)
      CHARACTER(LEN=4):: HEX
      integer(KIND=4)  IN1,I,JD,IND,J,KS1,KS,NT,IUT,IU,IN2,NL,NO,JO,JS,IS
      integer(KIND=4)  IU1,IU2,ICLJ
!
          IND = 0
          HEX = '    '
          IF (IHEX == 1)  HEX = 'HEX'
      IF (RUNOPT(3) == 'DETAIL    '.OR.MOD(IRECRD(2),100) == 0) &
                                           WRITE (16,3003)  NJOB, TITLE
      WRITE (16,3020)  (BOX(I)/NBOX(I),NBOX(I),I=1,3), &
                       NSYM, HEX, (BOX(I),I=4,6)
      IN1 = 1
      RMR = 1.0 / DBLE(NRECRD(2))
      DO 502  I = 1, NPT
!         JO = JON(I)
          JD = INT(P0C(1,I)) +INT(P0C(2,I)) +INT(P0C(3,I))
          IF (JD.GE.1.0)  IND = 1
          DO 500  J = 1, 3
              P00(J,I) = P0C(J,I)
                 SSS = PPS(J,I)
                 DDD = PPC(J,I)
              PSS(J,I) = DSQRT(ABS(SSS-DDD**2*RMR)*RMR)
              PCC(J,I) = PPC(J,I) * RMR
  500     CONTINUE
  502 CONTINUE
!
      DO 700  KS1 = 1, 2
              KS  = KS1 - 1
          WRITE (16,3030)
          NT  = 0
          IUT = 0
          DO 590  IU = 1, MATM
              IF (NIU(IU).LE.0)  GO TO 590
              NT  = NT  + NIU(IU)
              IUT = IUT + 1
              DXX = 0.0
              DYY = 0.0
              DZZ = 0.0
              SX = 0.0
              SY = 0.0
              SZ = 0.0
              NO = 0
              DO 550  I = IN1, NPT
                  IF (JON(I) > NT)  GO TO 570
                  JO = JON(I)
                  JD = INT(P0C(1,I)) +INT(P0C(2,I)) +INT(P0C(3,I))
                  IF (KS == 0.AND.JD.GE.1)  GO TO 550
                  IF (KS == 1.AND.JD < 1)  GO TO 550
                     IN2 = I
                     JS = MOD(ISYM(JO),200)
                     IS = MOD(JS,NSYM)
                     IF (IS.LE.0)  IS = NSYM
                     PXO = P00(1,I)
                     PYO = P00(2,I)
                     PZO = P00(3,I)
                     IF (HEX.NE.'HEX '.AND.HEX.NE.'HEXR')  GO TO 540
                          NL = 1
                         IF (HEX == 'HEXR')  NL = 3
                         IF (JS > NL*NSYM)  THEN
                               PYO = PYO - 0.5
                               IF (PYO < 0.0)  PYO = PYO + 1.0
                               PXO = PXO + 0.5
                               IF (PXO.GE.1.0)  PXO = PXO - 1.0
                               PCC(2,I) = PCC(2,I) - 0.5
                               DHY = PCC(2,I) - PYO
                               IF (DHY < -.5)  PCC(2,I) = PCC(2,I)+1.0
                               PCC(1,I) = PCC(1,I) + 0.5
                               DHX = PCC(1,I) - PXO
                               IF (DHX.GE.0.5)  PCC(1,I) = PCC(1,I)-1.0
                         END IF
                         PYO = PYO * 2.0
                         IF (PYO.GE.1.0)  PYO = PYO - 1.0
                         PXO = PXO + PYO * 0.5
                         IF (PXO.GE.1.0)  PXO = PXO - 1.0
                         PCC(2,I) = PCC(2,I) * 2.0
                         DHY = PCC(2,I) - PYO
                         IF (DHY.GE.0.5)  PCC(2,I) = PCC(2,I) - 1.0
                         PCC(1,I) = PCC(1,I) + PCC(2,I) * 0.5
                         DHX = PCC(1,I) - PXO
                         IF (DHX.GE.0.5)  PCC(1,I) = PCC(1,I) - 1.0
                         DX = PCC(1,I) - PXO
                         DY = PCC(2,I) - PYO
                         DZ = PCC(3,I) - PZO
                         DZZ = DZZ + DZ * RS(3,3,IS)
                         SZ  = SZ + ABS(PSS(3,I))
                         SXI = PSS(1,I)
                         SYI = PSS(2,I)
                         IF (ABS(RS(1,1,IS)*RS(2,1,IS)) > 0.5) GO TO 10
                            IF (ABS(RS(1,1,IS)).GE.0.5)  THEN
                                DXI = DX * RS(1,1,IS)
                                DYI = (DY - DXI*RS(1,2,IS)) * RS(2,2,IS)
                                GO TO 20
                            END IF
                            DYI = DX * RS(2,1,IS)
                            DXI = (DY - DYI * RS(2,2,IS)) * RS(1,2,IS)
                            GO TO 20
   10                    IF (ABS(RS(1,2,IS)).GE.0.5)  THEN
                              DXI = DY * RS(1,2,IS)
                              DYI = (DX - DXI * RS(1,1,IS)) * RS(2,1,IS)
                              GO TO 20
                         END IF
                         DYI = DY * RS(2,2,IS)
                         DXI = (DX - DYI * RS(2,1,IS)) * RS(1,1,IS)
   20                    DXX = DXX + DXI
                         DYY = DYY + DYI
                         SX  = SX  + SXI
                         SY  = SY  + SYI
                         GO TO 545
  540                DX = PCC(1,I) - PXO
                     DY = PCC(2,I) - PYO
                     DZ = PCC(3,I) - PZO
               DXX = DXX + DX*RS(1,1,IS) + DY*RS(2,1,IS) + DZ*RS(3,1,IS)
               DYY = DYY + DX*RS(1,2,IS) + DY*RS(2,2,IS) + DZ*RS(3,2,IS)
               DZZ = DZZ + DX*RS(1,3,IS) + DY*RS(2,3,IS) + DZ*RS(3,3,IS)
             SX= SX+ ABS(PSS(1,I)*RS(1,1,IS)) + ABS(PSS(2,I)*RS(2,1,IS)) &
                   + ABS(PSS(3,I)*RS(3,1,IS))
             SY= SY+ ABS(PSS(1,I)*RS(1,2,IS)) + ABS(PSS(2,I)*RS(2,2,IS)) &
                   + ABS(PSS(3,I)*RS(3,2,IS))
             SZ= SZ+ ABS(PSS(1,I)*RS(1,3,IS)) + ABS(PSS(2,I)*RS(2,3,IS)) &
                   + ABS(PSS(3,I)*RS(3,3,IS))
  545             NO = NO + 1
                  IF (JS.NE.1)  GO TO 550
                      XO = PXO
                      YO = PYO
                      ZO = PZO
  550         CONTINUE
  570         XYZ(1,IU) = XO + DXX / DBLE(NO)
              XYZ(2,IU) = YO + DYY / DBLE(NO)
              XYZ(3,IU) = ZO + DZZ / DBLE(NO)
              SXYZ(1,IU) = SX / DBLE(NO)
              SXYZ(2,IU) = SY / DBLE(NO)
              SXYZ(3,IU) = SZ / DBLE(NO)
              XYZ0(1,IU) = XO
              XYZ0(2,IU) = YO
              XYZ0(3,IU) = ZO
!             WRITE (16,3060)  IU,ATMXTL(IU),(XYZ(J,IU),J=1,3),
!    *                         (SXYZ(J,IU),J=1,3),(XYZ0(J,IU),J=1,3)
           IF (RUNOPT(3).NE.'DETAIL    '.AND.MOD(IRECRD(2),100).NE.0) &
                                                             GO TO 580
!                  DO 575  I = IN1, IN2
!                      DO 575  J = 1, 3
!                          IPSS(J,I) = PSS(J,I) * 1000.0
! 575              CONTINUE
!                  WRITE (16,3030) (JON(I), (PCC(J,I),IPSS(J,I),J=1,3),
!    *                                      I=IN1,IN2)
  580         IN1 = IN2 + 1
  590     CONTINUE
!
          IU1 = 1
          IU2 = 4
  601     IF (IU2 > IUT)  IU2 = IUT
          WRITE (16,3066) (ATMXTL(IU), &
                           XYZ(1,IU),SXYZ(1,IU),XYZ0(1,IU),IU=IU1,IU2)
          WRITE (16,3067) (XYZ(2,IU),SXYZ(2,IU),XYZ0(2,IU),IU=IU1,IU2)
          WRITE (16,3067) (XYZ(3,IU),SXYZ(3,IU),XYZ0(3,IU),IU=IU1,IU2)
          IU1 = IU2 + 1
          IU2 = IU1 + 3
          IF (IU1 > IUT)  GO TO 660
          GO TO 601
!
  660     IF (IND == 0)  RETURN
          IN1 = NPT / 2 + 1
          DO 667  I = IN1, NPT
              JO = JON(I)
              JD = INT(P0C(1,I)) + INT(P0C(2,I)) + INT(P0C(3,I))
              IF (JD < 1)  GO TO 667
              DO 666  J = 1, 3
                  ICLJ = 2
                  IF (NBOX(J) < 2)  ICLJ = 1
                  P0CJI    = P0C(J,I)
                  P00(J,I) = P0CJI - DBLE(ICLJ - 1)
                  PCC(J,I) = PPC(J,I) * RMR - DBLE(ICLJ - 1)
  666         CONTINUE
  667     CONTINUE
  700 CONTINUE
!
 3003 FORMAT (/' ***',I4,'-',I2,'  ***  ',15A4,'  ***')
 3020 FORMAT (/' MD-derived average atomic coordinates in unit cell(s)', &
               ' (standard deviations, A^2), and ',5X, &
                                      3(F8.4,'(X',I2,')') / &
               ' and experimentally determined ones  (number of ', &
               'symmetry operations=',I3,1X,A4,') ',&
                    9X, 3(F9.5,4X) )
 3030 FORMAT (4(2X,I3,F6.3,'(',I2,')',F5.3,'(',I2,')',F5.3,'(',I2,')'))
! 3060 FORMAT (1X,I3,1X,A4,1X,3F7.4,' (',3F6.4,') ',3F7.4)
 3066 FORMAT (4(4X,A4,F7.4,' (',F6.4,') ',F7.4) )
 3067 FORMAT (   4(8X,F7.4,' (',F6.4,') ',F7.4) )
      RETURN
      END
!
!



!                                                               ========
!================================================================ STRCTR
      SUBROUTINE  STRCTR  (IPR)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE GEOMET
      USE WORK01
      USE WORK02
      USE VALUES
      USE TABLES
      USE struct
!
!     ------------------------------------- Bond lengths and angles etc.
!
      implicit none
!
      integer(KIND=4)     NCHAR(5)
      double precision        ANBR(6,2), RVEC(3,10,LST)
      CHARACTER(LEN=4):: CHAR(6),  ATAB(LST)
      CHARACTER(LEN=6):: ACHAR(5)
      double precision  DB1,DB2,DB4,ASTHT,DB,AMEB1,AMEB2,ANTBL
      integer(KIND=4)  I,J,MMM,IO,IT,I1,I2,I0,NTJ,J1,IJ,N,IPR,II,ID1,J2
      integer(KIND=4)  ID2,ITT,NAG,K,IC,IA,JO,KO,NN,MM,MJ,L,M
      DATA ACHAR / 'SIZE  ', 'T     ', 'T1    ', '      ', '      '/
      DATA NCHAR / 0,1,2,3,4/,CHAR/'  0','  1','  2','  3','  4','SUM'/
!
      IF (RUNOPT(9) .NE.'STRUCTURE ' .AND. &
          RUNOPT(10).NE.'NETWORK   ')  RETURN
                                                        MMM = 0
      IF (ATOM(2) == ATMNET(1).OR.ATOM(2) == ATMNET(2)) MMM = IONS(2,2)
      IF (ATOM(3) == ATMNET(1).OR.ATOM(3) == ATMNET(2)) MMM = IONS(2,3)
                            IF (MMM == 0.AND.IPR.LE.0)  RETURN
!     ----------------------------------------- Default Cut-Off is 2.0 A
         RTO(1) = 2.00
         RTO(2) = 2.00
         DO 10  I = 1, 2
              IF (ATMNET(I) == 'H ')  RTO(I) = 1.20
              IF (ATMNET(I) == 'B ')  RTO(I) = 1.90
              IF (ATMNET(I) == 'C ')  RTO(I) = 1.50
              IF (ATMNET(I) == 'AL')  RTO(I) = 2.20
              IF (ATMNET(I) == 'SI')  RTO(I) = 2.00
              IF (ATMNET(I) == 'P ')  RTO(I) = 1.95
              IF (ATMNET(I) == 'ZR')  RTO(I) = 2.30
   10    CONTINUE
          DTO(1) = 0.0
          DTO(2) = 0.0
          NTO(1) = 0
          NTO(2) = 0
      DO 410  J = 1, 12
          AVTHT(J) = 0.0
          SVTHT(J) = 0.0
          NVTHT(J) = 0
          DO 400  I = 1, 121
              NTT(I,J) = 0
  400     CONTINUE
  410 CONTINUE
!
      DO 440  I = 1, NTION
          PX(I) = P(1,I)
          PY(I) = P(2,I)
          PZ(I) = P(3,I)
  440 CONTINUE
!
!     -------------------------------------------------- Cations - anion
!
      DO 220  IO = 1, NCOMPO
          IF (IION(IO).LE.-999)  GO TO 220
          IF (NION(IO).LE.0.OR.ZIO(IO) < 0.0)  GO TO 220
!         WRITE (*,9001)  ATOM(IO)
!9001     FORMAT (11X,'***  ',A2,' - ANION  ***')
          IF (IPR > 0.AND.RUNOPT(9) == 'STRUCTURE ') THEN
                 WRITE (16,2001)  ATOM(IO)
          END IF
                                      IT = 0
          IF (ATOM(IO) == ATMNET(1))  IT = 1
          IF (ATOM(IO) == ATMNET(2))  IT = 2
                 I1 = IONS(1,IO)
                 I2 = IONS(2,IO)
          DO 210  I = I1, I2, LENTAB
                 I0 = I
              CALL  DISTAN  (I0, II, IO, RVEC, IPR)
              IF (IT == 0)  GO TO 210
               NTJ = 0
               DO 250  IJ = I0, II
                   NTJ = NTJ + 1
                   DO 251  J1 = 1, 5
                          ID1 = IONB(J1,IJ)
                          DB1 = DONB(J1,IJ)
                       IF (DB1 > RTO(IT).OR.DB1 < 0.1) GO TO 250
                          DB4 = DONB(4,IJ)
                       IF (DB4 > RTO(IT).OR.DB4 < .1)  GO TO 230
                           IF (J1 > 4)  GO TO 230
                           DTO(IT) = DTO(IT) + DB1
                           NTO(IT) = NTO(IT) + 1
  230                  DO 240  J2 = J1+1, 6
                           ID2 = IONB(J2,IJ)
                           DB2 = DONB(J2,IJ)
                           IF (DB2 > RTO(IT).OR.DB2 < 0.1) GO TO 250
                                                  ITT = IT * 3 - 2
                           IF (ID1 > IONS(2,1))  ITT = ITT + 1
                           IF (ID2 > IONS(2,1))  ITT = ITT + 1
                           CALL  ANGLES  (ASTHT,DB1,DB2,ITT, &
                                          RVEC, NTJ,J1,J2)
  240                  CONTINUE
  251              CONTINUE
  250         CONTINUE
  210    CONTINUE
  220 CONTINUE
!
!     +----------------------------------------------------------------I
!     :  Angles      1 : A1-T1-A1     2 : A1-T1-A2     3 : A2-T1-A2    :
!     :              4 : A1-T2-A1     5 : A1-T2-A2     6 : A2-T2-A2    :
!     :              7 : T1-A1-T1     8 : T1-A1-T2     9 : T2-A1-T2    :
!     :             10 : T1-A2-T1    11 : T1-A2-T2    12 : T2-A2-T2    :
!     +----------------------------------------------------------------I
!
!     ------------- Anion - specified tetrahedron formers, large cations
!
      IT = 0
      DO 480  IO = 1, NCOMPO
          IF (IION(IO).LE.-999)  GO TO 480
          IF (NION(IO).LE.0.OR.ZIO(IO) > 0.0)  GO TO 480
!         WRITE (*,9002)  ATOM(IO)
!9002     FORMAT (11X,'***  ',A2,' - CATION  ***')
          IT = IT + 1
          IF (IPR > 0.AND.RUNOPT(9) == 'STRUCTURE ') THEN
                 WRITE (16, 4001) ATOM(IO)
          END IF
             I1 = IONS(1,IO)
             I2 = IONS(2,IO)
          DO 430 I = I1, I2, LENTAB
                I0 = I
              CALL  DISTAN  (I0, II, IO, RVEC, IPR)
                       N = 0
                     NAG = 0
              DO 425  IJ = I0, II
                       N = N + 1
                  ATAB(N) = '    '
                  TTAB(N) = 0.0001
                  ID1     = IONB(1,IJ)
                  ID2     = IONB(2,IJ)
                  IF (ID1 > MMM.OR.ID2 > MMM)  GO TO 425
                    DB1 = DONB(1,IJ)
                    DB2 = DONB(2,IJ)
                    IF (DB2 > RTO(2) .OR.  DB2 < 0.01)       GO TO 425
                    IF (DB2 > RTO(1) .AND. ID1.LE.IONS(2,2))  GO TO 425
                                           ITT = (IT + 2) * 3 - 2
                    IF (ID1 > IONS(2,2))  ITT = ITT + 1
                    IF (ID2 > IONS(2,2))  ITT = ITT + 1
                                          ATAB(N) = '<S-S'
                    IF (MOD(ITT,3) == 2)  ATAB(N) = '<S-A'
                    IF (MOD(ITT,3) == 0)  ATAB(N) = '<A-A'
                    CALL  ANGLES  (TTAB(N),DB1,DB2,ITT,RVEC,NTJ,1,2)
                    NAG = NAG + 1
  425         CONTINUE
              IF (NAG.LE.0)  GO TO 430
              IF (IPR.NE.0.AND.RUNOPT(9) == 'STRUCTURE ') THEN
                 if (lentab.gt.30)  then
                       WRITE (16,4011)  (ATAB(J),J=1,N)
                       WRITE (16,4021)  (TTAB(J),J=1,N)
                 end if
                 if (lentab.gt.25.and.lentab.le.30)  then
                       WRITE (16,4012)  (ATAB(J),J=1,N)
                       WRITE (16,4022)  (TTAB(J),J=1,N)
                 end if
                 if (lentab.gt.20.and.lentab.LE.25)  then
                       WRITE (16,4013)  (ATAB(J),J=1,N)
                       WRITE (16,4023)  (TTAB(J),J=1,N)
                 end if
                 if (lentab.LE.20)  then
                       WRITE (16,4014)  (ATAB(J),J=1,N)
                       WRITE (16,4024)  (TTAB(J),J=1,N)
                 end if
              END IF
  430     CONTINUE
  480 CONTINUE
!
      IF (NVTHT(1)+NVTHT(2).LE.0.OR.MMM.LE.0)  RETURN
!
                                    CALL  ADISTR  (IPR)
      IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
!           ----------------------------------------------------- Netwrk
            CALL  NETWRK  (MMM, IPR)
!           -------------------------------- Sorting of T1-X4 tetrahedra
            IF (IPR == 0)  THEN
                  DO 500  K = 1, 2
                      DO 501  I = 1, 6
                          DO 502  J = 1, 6
                              NBR(I,J,K) = 0
  502                     CONTINUE
  501                 CONTINUE
  500             CONTINUE
                         I1 = IONS(1,2)
                  DO 520  I = I1, MMM
!                     DB4 = DONB(4,I)
                                           K = 1
                      IF (I > IONS(2,2))  K = 2
!                     IF (DB4 > RTO(K).OR.DB4 < 0.0001)  GO TO 520
                      IC = 1
                      IA = 1
                      DO 510 J = 1, 4
                          JO = IONB(J,I)
                          DB = DONB(2,JO)
                          IF (JO > MMM.OR.JO == 0)  GO TO 510
                          IF (DB < 0.1.OR.DB > RTO(2)) GO TO 510
                                        KO = IONB(1,JO)
                          IF (KO == I)  KO = IONB(2,JO)
                          IF (KO.LE.IONS(2,2))               IC = IC + 1
                          IF (KO.GE.IONS(1,3).AND.KO.LE.MMM) IA = IA + 1
  510                 CONTINUE
                      NBR(IC,IA,K) = NBR(IC,IA,K) + 1
                      NBR(IC, 6,K) = NBR(IC, 6,K) + 1
                      NBR( 6,IA,K) = NBR( 6,IA,K) + 1
                      NBR( 6, 6,K) = NBR( 6, 6,K) + 1
  520             CONTINUE
                  DO 550  K = 1, 2
                      DO 551  I = 1, 6
                          DO 552  J = 1, 6
                              MBR(I,J,K) = MBR(I,J,K) + NBR(I,J,K)
  552                     CONTINUE
  551                 CONTINUE
  550             CONTINUE
                            NN = IRECRD(2)/IRECRD(3)
                            MM = MOD(NRECRD(1)/IRECRD(3), NN)
                            MJ = 2
                            IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
                            IF (MOD(MM,MJ).NE.0)  RETURN
            ELSE
!
                  DO 570  K = 1, 2
                     DO 571  I = 1, 6
                        DO 572  J = 1, 6
                           NBR(I,J,K) = MBR(I,J,K)
  572                   CONTINUE
  571                CONTINUE
  570             CONTINUE
            END IF
!
            WRITE (16, 5001)  ATMNET(1), ATMNET(2), NTBL
            WRITE (16, 5005)  ATMNET(1), (NCHAR(I),I=1,5),CHAR(6), &
                              ATMNET(2), (NCHAR(I),I=1,5),CHAR(6), &
                                         (ACHAR(I),I=1,3)
            ANTBL = DBLE(NTBL)
            IF (IPR == 0)  ANTBL = 1.0
            L = 1
            DO 530  I = 1, 6
               IF  (I == 1.OR.I == 6)  THEN
                    L = L + 1
                    AMEB1 = DBLE(MEB(L,1))*100.0/ (DBLE(NION(2))*ANTBL)
                    AMEB2 = DBLE(MEB(L,2))*100.0/ &
                            (DBLE(NION(2)+NION(3))*ANTBL)
                    WRITE (16,5007)  L, AMEB1, AMEB2
               END IF
               L  = L + 1
                  AMEB1 = DBLE(MEB(L,1))*100.0 / (DBLE(NION(2))*ANTBL)
                  AMEB2 = DBLE(MEB(L,2))*100.0 /  &
                          (DBLE(NION(2)+NION(3))*ANTBL)
               DO 537  M = 1, 6
                  ANBR(M,1) = DBLE(NBR(I,M,1))*100.0 /  &
                              (DBLE(NION(2))*ANTBL)
                  ANBR(M,2) = 0.0
                  IF (NION(3) > 0)  THEN
                        ANBR(M,2) = DBLE(NBR(I,M,2))*100.0 / &
                                    (DBLE(NION(3))*ANTBL)
                  END IF
  537          CONTINUE
               WRITE (16,5003) (CHAR(I),(ANBR(M,K),M=1,6),K=1,2), &
                                L,AMEB1,AMEB2
  530       CONTINUE
      END IF
!
      RETURN
 2001 FORMAT (/' <<<<<   ', A2, ' - anion distances    >>>>>')
 4001 FORMAT (/' <<<<<   ', A2, ' - cation distances   >>>>>')
 4011 FORMAT (4(1X,8A4))
 4012 format (6(1x,5A4))
 4013 format (5(1x,5(a4,1x)))
 4014 format (4(1x,5(a4,2x)))
 4021 FORMAT (4(1X,8F4.0))
 4022 format (6(1x,5F4.0))
 4023 format (5(1x,5F5.1))
 4024 format (4(1x,5(F5.1,1X)))
 5001 FORMAT (/' V: No. of bridging anion to ',A2,' tetrahedra  ', &
                'H: No. of bridging anion to ',A2,' tetrahedra (',I3, &
              ')   << Tet-Ring  >>' / 1X,90('-'),'   <<  Analysis >>')
 5005 FORMAT (1X,A3,' I', I4,4I6,'   I  ', A3, 4X,  &
                 A3,' I', I4,4I6,'   I  ', A3, 5X, 3A6)
 5003 FORMAT (1X,2(A3,' I',   5F6.2, ' I', F6.2,3X), I3,1X,2F6.2)
 5007 FORMAT (1X,2('----+',31('-'),'+------   '),    I3,1X,2F6.2)
      END
!
!
!                                                                =======
!================================================================ DISTAN
      SUBROUTINE  DISTAN  (I1, I2, IO, RVEC, IPR)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE CARTES
      USE WORK01
      USE WORK02
      USE TABLES
      USE struct
!
!     ----------------------------- Calculation of interatomic distances
!
      implicit none
!
      double precision        D(64), RV(3,64), RVEC(3,10,LST)
      double precision        ABOXX,ABOXY,ABOXZ,PIX,PIY,PIZ,RX,RY,RZ
      double precision        DX,DY,DZ,RIJ2,DR
      double precision        dtab(10,lst)
      integer(KIND=4)     ID(64),ITAB(10,LST),IDTAB(10,LST),IU(LST)
      CHARACTER(LEN=2):: TAX(LST)
      integer(KIND=4)   I2,I1,NI,I,NB,J,JO,K,IPR,IO,JD,L,ITA,IB
!
                               ABOXX = BOX(1)
                               ABOXY = BOX(2)
                               ABOXZ = BOX(3)
            I2 = I1 + LENTAB - 1
            IF (I2 > IONS(2,IO))  I2 = IONS(2,IO)
            NI = 0
      DO 290  I = I1, I2
             NI = NI + 1
             NB = 0
                       PIX = PX(I)
                       PIY = PY(I)
                       PIZ = PZ(I)
                       IF (PIX.GE.0.5)  PIX = PIX - 1.0
                       IF (PIY.GE.0.5)  PIY = PIY - 1.0
                       IF (PIZ.GE.0.5)  PIZ = PIZ - 1.0
                       DO 20  J = 1, 64
                           ID(J) = 0
                            D(J) = 0.000001
   20                  CONTINUE
          DO 170  JO = 1, NCOMPO
              IF (IION(JO).LE.-999)  GO TO 170
              IF (NION(JO).LE.0.OR.ZIO(IO)*ZIO(JO) > 0.0)  GO TO 170
              DO 150  J = IONS(1,JO), IONS(2,JO)
                  IF (IOND(J) == 0 .OR. I == J)  GO TO 150
                      DO 130  K = 1, 8
                          RX = PIX - PX(J) + TRANSX(K)
                          RY = PIY - PY(J) + TRANSY(K)
                          RZ = PIZ - PZ(J) + TRANSZ(K)
                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
                          RIJ2 = DX**2 + DY**2 + DZ**2
                          IF (RIJ2.LE.9.0)  GO TO 140
  130                 CONTINUE
                      GO TO 150
!
!C                  RX = ABS(PIX-PX(J))
!C                  RY = ABS(PIY-PY(J))
!C                  RZ = ABS(PIZ-PZ(J))
!C                  IF (RX > 0.5)  RX = 1.0 - DX
!C                  IF (RY > 0.5)  RY = 1.0 - DY
!C                  IF (RZ > 0.5)  RZ = 1.0 - DZ
!C                  RIJ2 = (RX*ABOXX)**2 +(RY*ABOXY)**2 +(RZ*ABOXZ)**2
!
  140             IF (RIJ2.LE.9.0.AND.NB < 64) THEN
                        NB     = NB +1
                        D(NB)  = SQRT(RIJ2)
                        ID(NB) = J
                        RV(1,NB) = RX
                        RV(2,NB) = RY
                        RV(3,NB) = RZ
                  END IF
  150         CONTINUE
  170     CONTINUE
          IF (NB > 1)  THEN
                 DO 220  J=1, NB-1
                     DO 210  K = J+1, NB
                         IF (D(J).GE.D(K))  THEN
                               DR = D(J)
                                    D(J) = D(K)
                                           D(K) = DR
                               JD = ID(J)
                                    ID(J) = ID(K)
                                            ID(K) = JD
                               DO 205  L = 1, 3
                               DR = RV(L,J)
                                    RV(L,J) = RV(L,K)
                                              RV(L,K) = DR
  205                          CONTINUE
                         END IF
  210                CONTINUE
  220            CONTINUE
          END IF
          DO 270  J = 1, 10
              ITAB(J,NI) = ID(J)
              DTAB(J,NI) = D(J)
  270     continue
          do 272  j = 1, 6
                    DONB(J,I) = D(J)
                    IONB(J,I) = ID(J)
                    RVEC(1,J,NI) = RV(1,J)
                    RVEC(2,J,NI) = RV(2,J)
                    RVEC(3,J,NI) = RV(3,J)
  272     CONTINUE
          do 275  j = 1, 10
              idtab(j,ni) = dtab(j,ni) * 100.0 + 0.5
  275     continue
          IU(NI) = AU(I) * 1.E12 / NRECRD(2) + 0.5
  290 CONTINUE
      IF (IPR == 0.OR.RUNOPT(9).NE.'STRUCTURE ')  RETURN
!
      WRITE (16,2001)
      if (lentab.gt.30)  then
            WRITE (16,2011)  (I,I=I1,I2)
            WRITE (16,2021)  (IU(I),I=1,NI)
      end if
      if (lentab.gt.25.and.lentab.le.30)  then
            WRITE (16,2012)  (I,I=I1,I2)
            WRITE (16,2022)  (IU(I),I=1,NI)
      end if
      if (lentab.gt.20.and.lentab.LE.25)  then
            WRITE (16,2013)  (I,I=I1,I2)
            WRITE (16,2023)  (IU(I),I=1,NI)
      end if
      if (lentab.LE.20)  then
            WRITE (16,2014)  (I,I=I1,I2)
            WRITE (16,2024)  (IU(I),I=1,NI)
      end if
      DO 340  I = 1, 10
            ITA = 0
          DO 320  J = 1, NI
              ib=itab(i,j)
              TAX(J) = '*'
              IF (IB.GE.ions(1,1).and.ib.LE.ions(2,1)) TAX(J) = ATOM(1)
              IF (IB.GE.IONS(1,2).and.ib.LE.ions(2,2)) TAX(J) = ATOM(2)
              IF (IB.GE.IONS(1,3).and.ib.LE.ions(2,3)) TAX(J) = ATOM(3)
              IF (IB.GE.IONS(1,4).and.ib.LE.ions(2,4)) TAX(J) = ATOM(4)
              IF (IB.GE.IONS(1,5).and.ib.LE.ions(2,5)) TAX(J) = ATOM(5)
              IF (IB.GE.IONS(1,6).and.ib.LE.ions(2,6)) TAX(J) = ATOM(6)
              IF (IB.GE.IONS(1,7).and.ib.LE.ions(2,7)) TAX(J) = ATOM(7)
              ITA = ITA + ITAB(I,J)
  320     CONTINUE
!         IF (ITA < 1)  RETURN
          IF (ITA < 1)  GO TO 340
               if (lentab.gt.30)  then
                     WRITE (16,2031)  (IDTAB(I,J),TAX(J),J=1,NI)
               end if
               if (lentab.gt.25.and.lentab.le.30)  then
                     WRITE (16,2032)  (IDTAB(I,J),TAX(J),J=1,NI)
               end if
               if (lentab.gt.20.and.lentab.LE.25)  then
                     WRITE (16,2033)  (IDTAB(I,J),TAX(J),J=1,NI)
               end if
               if (lentab.LE.20)  then
                     WRITE (16,2034)  (IDTAB(I,J),TAX(J),J=1,NI)
               end if
  340 CONTINUE
 2001 FORMAT (1X, 132('-'))
 2011 FORMAT (4(1X,8I4))
 2012 FORMAT (6(1X,5I4))
 2013 FORMAT (5(1X,5(I4,1x)))
 2014 FORMAT (4(1X,5(I4,2x)))
 2021 FORMAT (4(1X,8I4))
 2022 FORMAT (6(1X,5I4))
 2023 FORMAT (5(1X,5(1x,I4)))
 2024 FORMAT (4(1X,5(1x,I4,1x)))
 2031 FORMAT (4(1X,8(I3,A1)))
 2032 format (6(1x,5(i3,a1)))
 2033 format (5(1x,5(i3,a2)))
 2034 format (4(1x,5(i3,a2,1x)))
      RETURN
      END
!
!
!                                                                =======
!================================================================ ANGLES
      SUBROUTINE  ANGLES  (THT,DB1,DB2,IT,RVEC, NTJ, J1,J2 )
      USE PARAM
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE GEOMET
      USE WORK01
!
!     -------------------------------- Calculation of interatomic angles
!
      implicit none
!
      double precision   RVEC(3,10,LST),W
      double precision   THT,DB1,DB2
      double precision   COSTHT,SINTHT
      integer(KIND=4)  J1,NTJ,J2,IT,ITHT
!
         W = RVEC(1,J1,NTJ)*RVEC(1,J2,NTJ)*BOX(1)**2 + &
             RVEC(2,J1,NTJ)*RVEC(2,J2,NTJ)*BOX(2)**2 + &
             RVEC(3,J1,NTJ)*RVEC(3,J2,NTJ)*BOX(3)**2 + &
             (RVEC(1,J1,NTJ)*RVEC(2,J2,NTJ) +  &
              RVEC(2,J1,NTJ)*RVEC(1,J2,NTJ)) *BOX(1)*BOX(2)*BOX(6) + &
             (RVEC(2,J1,NTJ)*RVEC(3,J2,NTJ) + &
              RVEC(3,J1,NTJ)*RVEC(2,J2,NTJ)) *BOX(2)*BOX(3)*BOX(4) + &
             (RVEC(3,J1,NTJ)*RVEC(1,J2,NTJ) + &
              RVEC(1,J1,NTJ)*RVEC(3,J2,NTJ)) *BOX(3)*BOX(1)*BOX(5) 
            COSTHT = W / (DB1 * DB2)
            SINTHT = ABS(1. - COSTHT*COSTHT)
            THT = ATAN(SQRT(SINTHT) / COSTHT) * 180.0/PI
                  IF (THT < 0.0)  THT = THT + 180.0
            NVTHT(IT) = NVTHT(IT) + 1
            AVTHT(IT) = AVTHT(IT) + THT
            SVTHT(IT) = SVTHT(IT) + THT * THT
            ITHT = INT(THT - 58.5)
                   IF (ITHT.LE.0)  ITHT = 1
            NTT(ITHT,IT) = NTT(ITHT,IT) + 1
      RETURN
      END
!
!
!                                                               ========
!================================================================ ADISTR
      SUBROUTINE  ADISTR (IPR)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE PARAMT
      USE GEOMET
      USE TABLES
!
!     -------------------------------------- Grafs of interatomic angles
!
      implicit none
!
      double precision        ANGLE(3,12)
      double precision  ANTBL,ANN,AAA,SSS,FACT
      integer(KIND=4)     IANGLE(12)
      CHARACTER(4)::  SNGLE(3,12),ATY(LEL),GRAPH(121)
      integer(KIND=4)  N,IO,I,J,IPR,NN,MJ,MM,K,MTBL,NK,KK,IJ,NMAX,NG,MTT
!
!     WRITE  (*,1111)
!1111 FORMAT (11X,'<<<  Angle distribution  >>>')
      N = 0
      DO 100  IO = 1, NCOMPO
         IF (ZIO(IO) < 0.0)  THEN
                N = N + 1
                ATY(N) = ATOM(IO)
         END IF
 100  CONTINUE
!
      IF (IPR == 1)  THEN
                     DO 151  I = 1, 12
                        AVTHT(I) = ANGL(1,I)
                        SVTHT(I) = ANGL(2,I)
                        NVTHT(I) = ANGL(3,I)
                        DO 150  J = 1, 121
                           NTT(J,I) = ITBR(J,I)
  150                   CONTINUE
  151                CONTINUE
      END IF
!
      IF (IPR == 0)   NTBL = NTBL + 1
                      MTBL = NTBL
      IF (MTBL.LE.0)  MTBL = 1
         IF (NTO(1) > 0)  DTO(1) = DTO(1) / NTO(1)
         IF (NTO(2) > 0)  DTO(2) = DTO(2) / NTO(2)
                           NTO(1) = NTO(1) / 4
                           NTO(2) = NTO(2) / 4
      IF (IPR == 0)  THEN
                    IF (IRECRD(3) > 0)  THEN
                         NN = IRECRD(2)/IRECRD(3)
                         IF (NN > 0) MM = MOD(NRECRD(1)/IRECRD(3),NN)
                    END IF
                    MJ = 2
                    IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
                    IF (MOD(MM,MJ).NE.0)  GO TO 270
      END IF
      IF (IPR == 1)  THEN
             WRITE (16, 4005)  NTBL, ATMNET(1),ATY(1),DTO(1),NTO(1), &
                                ATMNET(2),ATY(1),DTO(2),NTO(2)
 4005        FORMAT(/'  Angle distribution  (', I3, ')',3X, &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')   ', &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')')
             WRITE (16,4011)
      END IF
!
  270 NK = 0
      ANTBL = DBLE(NTBL)
      DO 490  K = 1, 12
         IF (NVTHT(K) == 0)  GO TO 490
            ANN = DBLE(NVTHT(K))
!           IF (ANN.LE.0.0)  ANN = ANN + 65534
            AAA = AVTHT(K)
            SSS = SQRT(ABS(SVTHT(K) - AAA*AAA/ANN) /ANN)
            AAA = AAA / ANN
            NK  = NK + 1
            ANGLE(1,NK) = AAA
            ANGLE(2,NK) = SSS
            IANGLE(NK)  = NVTHT(K)
            IF (K.LE.6)  THEN
                  KK = (K - 1)/ 3 + 1
                  SNGLE(1,NK) = ATY(1)
                  SNGLE(2,NK) = ATMNET(KK)
                  SNGLE(3,NK) = ATY(1)
                  J = MOD(K-1,3)
                  IF (J.GE.1)  SNGLE(3,NK) = ATY(2)
                  IF (J.GE.2)  SNGLE(1,NK) = ATY(2)
                  GO TO 390
            END IF
            I = 1
            IF (MOD(K,3) == 0)  I = 2
            J = 2
            IF (MOD(K,3) == 1)  J = 1
                         IJ = 1
            IF (K > 9)  IJ = 2
            SNGLE(1,NK) = ATMNET(I)
            SNGLE(2,NK) = ATY(IJ)
            SNGLE(3,NK) = ATMNET(J)
  390       IF (IPR == 1)  THEN
                   WRITE (16,4021) (SNGLE(J,NK),J=1,3), AAA, SSS,NVTHT(K)
                   NMAX = 0
                   FACT = 400.0 / (ANTBL * DBLE(NION(1)))
                   DO 450  I = 1, 121
                      NTT(I,K) = NTT(I,K) * FACT + 0.5
                      IF (NMAX < NTT(I,K))  NMAX = NTT(I,K)
  450              CONTINUE
                   IF (NMAX > 17)  NMAX = 17
                   DO 470  I = 1, NMAX
                      NG = NMAX -I + 1
                      DO 460  J = 1, 121
                         GRAPH(J) = ' '
                         IF (J == 1.OR.J == 121)  GRAPH(J)='I'
                         MTT = NTT(J,K)
                         IF (MTT.GE.NG)     GRAPH(J) = '*'
                         IF (MTT-17.GE.NG)  GRAPH(J) = '#'
  460                 CONTINUE
                      WRITE (16,4010)  (GRAPH(J),J=1,121)
! 4410                 FORMAT (80A1)
  470              CONTINUE
                   WRITE (16,4011)
            END IF
  490 CONTINUE
      IF (IPR == 1)  THEN
             WRITE (16,4012)  (I, I=60,180,30)
             RETURN
      END IF
!
                               NN = IRECRD(2)/IRECRD(3)
                               MM = MOD(NRECRD(1)/IRECRD(3), NN)
                               MJ = 2
             IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
             IF (MOD(MM,MJ) == 0)  THEN
               WRITE (16,4006)  NTBL,ATMNET(1),ATY(1),DTO(1),NTO(1), &
                                     ATMNET(2),ATY(1),DTO(2),NTO(2)
 4006          FORMAT (' I Angle distribution (', I3, ')   ', &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')  ', &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ') I')
               IF (NK.LE.2) THEN
               WRITE (16,4020)  ( (SNGLE(J,I),J=1,3), &
                               (ANGLE(J,I),J=1,2),IANGLE(I),I=1,NK )
               ELSE
               WRITE (16,4025)  ( (SNGLE(J,I),J=1,3), &
                               (ANGLE(J,I),J=1,2),IANGLE(I),I=1,NK )
               END IF
               WRITE (16,4039)
 4039          FORMAT (1X,'I',75('-'),'I')
             END IF
             DO 710  I = 1, 12
                ANGL(1,I) = ANGL(1,I) + AVTHT(I)
                ANGL(2,I) = ANGL(2,I) + SVTHT(I)
                ANGL(3,I) = ANGL(3,I) + NVTHT(I)
                DO 700  J = 1, 121
                   ITBR(J,I) = ITBR(J,I) + NTT(J,I)
  700           CONTINUE
  710        CONTINUE
      RETURN
!
 4010 FORMAT (4X, 121A1)
 4011 FORMAT (4X,12('I',9('-')),'I')
 4012 FORMAT (3X,4(I3,27X),I3)
 4020 FORMAT (' I ',2(4X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2, &
                                                   '(N=',I5,')'),'  I')
 4025 FORMAT (' I ',2(4X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2, &
                                               '(N=',I5,')'),'  I'/ &
              ' I ',2(4X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2, &
                                               '(N=',I5,')'),'  I'/ &
              ' I ',1(4X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2, &
                                              '(N=',I5,')'),36X,'  I' )
 4021 FORMAT (4X,'I  <',A2,'-',A2,'-',A2,' =',F7.2,'+-',F6.2,'  (N=', &
                                                        I7,')',78X,'I')
      END
!
!
!                                                               ========
!================================================================ NETWRK
      SUBROUTINE  NETWRK  (NNN, IPR)
      USE PARAM
      USE CHARAC
      USE COUNTS
      USE TEMPRS
      USE ABOXOF
      USE ATOMSI
      USE GEOMET
      USE WORK01
      USE WORK02
!
!     ------------------------------------------------- Network analysis
!
      implicit none
!
      integer(KIND=4)     NTET(19),ITREE(19),MING(9),MEMBER(9)
      integer(KIND=4)     LING(9,LRG),MRING(LRG),ITET(6,19)
      integer(KIND=4)     LMBR,LCOL,I,ISE,NNN,MMM,NR,J,ICOL,KJ,LL
      integer(KIND=4)     II,ISI,L,JJ,ITI,MOR,IDEL,MM,N,IPR,IS
      integer(KIND=4)     IOS,NTCOL,MIG,MI,LI
!
      LMBR = 8
      LCOL = LMBR * 2 + 1
      IF (IPR == 1)  GO TO 901
!     WRITE (*,1111)
!1111 FORMAT (11X,'<<<<<  NETWORK ANALYSIS STARTED  >>>>>')
         DO 580  I = 1, 9
             MEB(I,1) = 0
             MEB(I,2) = 0
  580    CONTINUE
      ISE = 1
      IF (NNN > IONS(2,2))  ISE = 2
!     --------------------------------------------- Ring search starting
      NR   = 0
      DO 888  IS = 1, ISE
                             MMM = NNN
               IF (IS == 1)  MMM = IONS(2,2)
!
               DO 705  I = 1, LMBR
                  MEMBER(I) = 0
  705          CONTINUE
               DO 708  I = 1, LCOL
                  DO 707  J = 1, 6
                     ITET(J,I) = 9999
  707             CONTINUE
  708          CONTINUE
!          ------------------------------------- Search around ion [ISI]
!                                                  ISI : Network former
           DO 790  ISI = IONS(1,2), MMM
                  ICOL = 1
              ITREE(1) = ISI
                    II = ISI
                    JJ = ISI
  710         ICOL = ICOL + 1
                     IF (ICOL > LCOL)  GO TO 725
                                    KJ = 1
              IF (JJ > IONS(2,2))  KJ = 2
                     LL = 0
              DO 715  L = 1, 5
                 ITET(L,ICOL) = 9999
                 IOS = IONB(L,JJ)
                 IF (IOS.LE.0.OR.IOS > MMM)  GO TO 715
                 IF (IOS > IONS(2,2))  KJ = 2
                 IF (DONB(L,JJ) > RTO(KJ).OR.IOS == II)  GO TO 715
                     LL = LL + 1
                     ITET(LL,ICOL) = IOS
  715         CONTINUE
!
              NTET(ICOL) = 0
  720         NTET(ICOL) = NTET(ICOL) + 1
              NTCOL = NTET(ICOL)
              JJ = ITET(NTCOL,ICOL)
              IF (JJ < 9000)  GO TO 730
  725              ICOL = ICOL - 1
                   IF(ICOL.LE.1)  GO TO 790
                   GO TO 720
  730         IF (JJ > IONS(2,1).AND.JJ < ISI)  GO TO 720
              ITREE(ICOL) = JJ
              II = ITREE(ICOL-1)
              IF (JJ.NE.ISI)  GO TO 710
!             -------------------------------------------- Ring detected
!                                                       Unique for ISI ?
              DO 741  I = 2, ICOL-2
                    ITI = ITREE(I)
                 DO 740  J = I+1, ICOL-1
                    IF (ITI == ITREE(J))  GO TO 720
  740            CONTINUE
  741         CONTINUE
!             ---------------------------- Recorded as a ring temporally
              MOR = 0
              DO 745  I = 1, ICOL-1, 2
                 MOR = MOR + 1
                 MING(MOR) = ITREE(I)
  745         CONTINUE
!             -------------------------------------- Sorting in the ring
              DO 750  I = 1, MOR-1
                    MIG = MING(I)
                 DO 748  J = I+1, MOR
                    IF (MI.LE.MING(J))  GO TO 748 !MI???????????????????
                    MM      = MIG
                    MIG     = MING(J)
                    MING(J) = MM
  748            CONTINUE
                 MING(I) = MIG
  750         CONTINUE
              IF (NR < 1)  GO TO 780
!             ------------------------------------- Check for uniqueness
              IDEL = 0
              DO 775  N = 1, NR
                 MM = MRING(N)
                 IF (MM == 0)  GO TO 775
                 IF (MOR < MM)  GO TO 760
                   DO 756  J = 1, MM
                      LI = LING(J,N)
                      DO 755  I = 1, MOR
                         IF (LI == MING(I))  GO TO 756
  755                 CONTINUE
                      GO TO 775
  756              CONTINUE
                GO TO 720
!
  760           DO 765  I = 1, MOR
                       MI = MING(I)
                    DO 762  J = 1, MM
                       IF (MI == LING(J,N))  GO TO 765
  762               CONTINUE
                    GO TO 775
  765           CONTINUE
                IF (IDEL.GE.1)  GO TO 770
                    MRING(N)    = MOR
                    MEMBER(MOR) = MEMBER(MOR) + 1
                    DO 767  J = 1, MOR
                       LING(J,N) = MING(J)
  767               CONTINUE
                    IDEL = 1
                    GO TO 772
  770            MRING(N)   = 0
  772            MEMBER(MM) = MEMBER(MM) - 1
  775         CONTINUE
              IF (IDEL.GE.1)  GO TO 720
  780         MEMBER(MOR) = MEMBER(MOR) + 1
              NR = NR + 1
              IF (NR > LRG)  GO TO 791
              DO 785  I = 1, MOR
                 LING(I,NR) = MING(I)
  785         CONTINUE
              MRING(NR) = MOR
              GO TO 720
  790      CONTINUE
!
  791    DO 792  I = 1,LMBR
            MEB(I,IS) = MEMBER(I)
            NRG(I,IS) = NRG(I,IS) + MEMBER(I)
  792    CONTINUE
  888 CONTINUE
!
      WRITE (*,9999) NR
 9999 FORMAT (11X,'<<<<< NETWORK: No. of total rings is ',I5,' >>>>>')
      RETURN
!
  901 DO 704  IS = 1, 2
         DO 702  I = 1, 9
            MEB(I,IS) = NRG(I,IS)
  702    CONTINUE
  704 CONTINUE
      RETURN
      END
!
!
!                                                               ========
!================================================================ KCLOCK
      SUBROUTINE  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      USE PARAM
      USE CHARAC
!
      implicit none
      integer(KIND=4)     IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
!      IF (FLNAME(3) == 'NDP-FORTRAN386' .OR. &
!          FLNAME(3) == 'NEWS-F77      ')  THEN
!                            CALL  NDP386  (IYEAR,IMONTH,IDAY, &
!                                           IHOUR,IMINUT,ISECND,I100TH)
!      END IF
!      IF (FLNAME(3) == 'Lehey LF90    ' .OR. &
!          FLNAME(3) == 'IBM-AIX-FORT  ')  THEN
!                            CALL  IBMAIX  (IYEAR,IMONTH,IDAY, &
!                                           IHOUR,IMINUT,ISECND,I100TH)
!      END IF
!      IF (FLNAME(3) == 'LUNA88K       ')  CALL  LUNA88(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'PARALLEL-F77  ')  CALL  PARAF7(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'HP-9000       ')  CALL  HP9000(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'DN10000       ')  CALL  DN1000(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'S820-80       ')  CALL  HTS820(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'NEWS-F77      ')  CALL  NDP386(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'CRAY-F77      ')  CALL  CRAY77(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'DEC Fortran   ')  CALL  DECF  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      IF (FLNAME(3) == 'F90           ')  CALL  F90   (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'LINUX-g77     ')  CALL  G77   (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!      IF (FLNAME(3) == 'Ms-Fortran    ')  THEN
!                CALL  GETDAT  (IYEAR,IMONTH,IDAY)
!                CALL  GETTIM  (IHOUR,IMINUT,ISECND,I100TH)
!                IYEAR = MOD(IYEAR,100)
!      END IF
      IF (FLNAME(3) == 'Dummy         ')  THEN
               IYEAR  = 0
               IMONTH = 0
               IDAY   = 0
               IHOUR  = 0
               IMINUT = 0
               ISECND = 0
               I100TH = 0
      END IF
      RETURN
      END
!
!
!!================================================================= DECF
!      SUBROUTINE  DECF  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!     --- Digital Fortran (Unix) & Visual Fortran (Windows) ---
!!     ---               Support Y2000 Problem               ---
!      implicit none
!      integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!      character::   Adtval(3)*12
!      integer(KIND=4)   Idtval(8)
!!
!      Call DATE_AND_TIME(Adtval(1),Adtval(2),Adtval(3),Idtval)
!      IYEAR  = Idtval(1) - 1900  ! now cut the centuries
!      IMONTH = Idtval(2)
!      IDAY   = Idtval(3)
!      IHOUR  = Idtval(5)
!      IMINUT = Idtval(6)
!      ISECND = Idtval(7)
!      I100TH = Idtval(8)
!      RETURN
!      End
!!
!!
!!                                                      =================
!!======================================================= NDP-FORTRAN-386
!!                                                     and SONY RISC-NEWS
!      SUBROUTINE  NDP386  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!      CHARACTER  *8   ATIME
!!      CHARACTER  *9   ADATE
!!      CHARACTER  *3   BDATE(3), B2
!!      EQUIVALENCE     (ADATE,BDATE(1))
!!      CHARACTER  *1   CH
!!      INUM(CH) = ICHAR(CH) - 48
!!
!!            CALL  TIME  (ATIME)
!!            CALL  DATE  (ADATE)
!!
!!            IHOUR  = INUM(ATIME(1:1))*10 + INUM(ATIME(2:2))
!!            IMINUT = INUM(ATIME(4:4))*10 + INUM(ATIME(5:5))
!!            ISECND = INUM(ATIME(7:7))*10 + INUM(ATIME(8:8))
!!            IYEAR  = INUM(ADATE(8:8))*10 + INUM(ADATE(9:9))
!!            IDAY   = INUM(ADATE(1:1))*10 + INUM(ADATE(2:2))
!!            iyear  = mod(iyear,100)
!!            B2 = BDATE(2)
!!            IF (B2 == 'JAN' .OR. B2 == 'Jan')  IMONTH =  1
!!            IF (B2 == 'FEB' .OR. B2 == 'Feb')  IMONTH =  2
!!            IF (B2 == 'MAR' .OR. B2 == 'Mar')  IMONTH =  3
!!            IF (B2 == 'APR' .OR. B2 == 'Apr')  IMONTH =  4
!!            IF (B2 == 'MAY' .OR. B2 == 'May')  IMONTH =  5
!!            IF (B2 == 'JUN' .OR. B2 == 'Jun')  IMONTH =  6
!!            IF (B2 == 'JUL' .OR. B2 == 'Jul')  IMONTH =  7
!!            IF (B2 == 'AUG' .OR. B2 == 'Aug')  IMONTH =  8
!!            IF (B2 == 'SEP' .OR. B2 == 'Sep')  IMONTH =  9
!!            IF (B2 == 'OCT' .OR. B2 == 'Oct')  IMONTH = 10
!!            IF (B2 == 'NOV' .OR. B2 == 'Nov')  IMONTH = 11
!!            IF (B2 == 'DEC' .OR. B2 == 'Dec')  IMONTH = 12
!!            I100TH = 0
!      RETURN
!      END
!!
!!
!!                                                             ==========
!!============================================================== LUNA-88K
!      SUBROUTINE  LUNA88  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!      INTEGER    *4  JTIME(3),JDATE(3)
!!
!!            do 10  i = 1, 3
!!                jtime(i) = 0
!!                jdate(i) = 0
!!   10       continue
!!
!!            CALL  ITIME  (JTIME)
!!            CALL  IDATE  (JDATE)
!!
!!             IYEAR  = MOD(JDATE(3),100)
!!             IMONTH = JDATE(2)
!!             IDAY   = JDATE(1)
!!             IHOUR  = JTIME(1)
!!             IMINUT = JTIME(2)
!!             ISECND = JTIME(3)
!!             I100TH = 0
!      RETURN
!      END
!!
!!
!!                                                           ============
!!============================================================ Parallel-F
!      SUBROUTINE  PARAF7  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!      INTEGER    *4  JTIME,JDATE,NDAYS(12)
!!      DATA  NDAYS / 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /
!!     DATA  NDAYS / 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /
!!
!!       1970.1.1 0:0 - 1992.1.1 0:0 : 365*22+5 daya = 8035 days
!!                                     8035*24*60*60 sec = 694224000 sec
!!                                     GMT > JST : +9 HOURS
!                            jtime = 0
!!            CALL  ICLOCK  (jtime)
!!
!!             jtime  = jtime - 694224000 + 32400
!!             JDATE  = JTIME / (60*60*24) + 1
!!
!!             jtime  = mod(jtime,24*60*60)
!!             IHOUR  = jtime/(60*60)
!!             jtime  = mod(jtime,60*60)
!!             IMINUT = JTIME / 60
!!             ISECND = MOD(jtime,60)
!!             I100TH = 0
!!
!!            NYDAYS = 365
!!             NYDAYS = 366
!!             IYEAR  = JDATE / NYDAYS
!!             NDAY   = JDATE - IYEAR*NYDAYS
!!             DO 10  I = 1, 12
!!                IF (NDAY - NDAYS(I).LE.0)  GO TO 20
!!                NDAY = NDAY - NDAYS(I)
!!   10        CONTINUE
!!   20        IMONTH = I
!!             IDAY   = NDAY
!!             IYEAR  = mod(IYEAR + 92, 100)
!      RETURN
!      END
!!
!!
!!                                                       ================
!!======================================================== HP Apollo9000 
!      SUBROUTINE  HP9000  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!      CHARACTER  *8   ATIME
!!
!!            iyear  = 0
!!            imonth = 0
!!            iday   = 0
!!           CALL  TIME  (ATIME)
!!           CALL  IDATE  ( IMONTH, IDAY, IYEAR)
!!
!!            IHOUR  = ICHAR(ATIME(1:1))*10 + ICHAR(ATIME(2:2)) -528
!!            IMINUT = ICHAR(ATIME(4:4))*10 + ICHAR(ATIME(5:5)) -528
!!            ISECND = ICHAR(ATIME(7:7))*10 + ICHAR(ATIME(8:8)) -528
!!            I100TH = 0
!!            iyear  = mod(iyear,100)
!      RETURN
!      END
!!
!!
!!                                                             ==========
!!============================================================== DN-10000
!!                                ftn in AEGIS operating system
!      SUBROUTINE  DN1000  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!%INCLUDE '//dn10020/sys/ins/base.ins.ftn'
!!%INCLUDE '//dn10020/sys/ins/time.ins.ftn'
!!%INCLUDE '//dn10020/sys/ins/cal.ins.ftn' 
!!       
!!      INTEGER   *4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!     INTEGER   *2  time_clock(3),c_clock(6)
!!     INTEGER   *2  JYEAR,JMONTH,JDAY,JHOUR,JMINUT,JSECND,JMSE
!!     EQUIVALENCE (c_clock(1),JYEAR),
!!    *            (c_clock(2),JMONTH),
!!    *            (c_clock(3),JDAY),
!!    *            (c_clock(4),JHOUR),
!!    *            (c_clock(5),JMINUT),
!!    *            (c_clock(6),JSECND)
!!
!!             JHOUR  = 0
!!             JMINUT = 0
!!             JSECND = 0
!!             JYEAR  = 0
!!             JMONTH = 0
!!             JDAY   = 0
!!
!!            CALL CAL_$GET_LOCAL_TIME(time_clock)
!!            CALL CAL_$DECODE_TIME(time_clock,c_clock)
!!             IHOUR  = JHOUR
!!             IMINUT = JMINUT
!!             ISECND = JSECND
!!             I100th = 0
!!
!!            CALL CAL_$GET_LOCAL_TIME(time_clock)
!!            CALL CAL_$DECODE_TIME(time_clock,c_clock)
!!             IYEAR  = JYEAR - JYEAR/100*100
!!             IMONTH = JMONTH
!!             IDAY   = JDAY
!      RETURN
!      END
!!
!!
!!                                                           ============
!!============================================================ H-S-820-80
!      SUBROUTINE  HTS820  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!     CHARACTER  *12  ATIME
!!     CHARACTER  *8   ADATE
!!     CHARACTER  *1   BTIME(8),BDATE(8)
!!     EQUIVALENCE     (ATIME,BTIME(1)),(ADATE,BDATE(1))
!!
!!             iyear  = 0
!!             imonth = 0
!!             iday   = 0
!!             ihour  = 0
!!             iminut = 0
!!             isecnd = 0
!!
!!            CALL  CLOCK  (ATIME, 1)
!!            CALL  DATE  (ADATE)
!!
!!            IHOUR  = (ICHAR(BTIME(1))-240)*10 + (ICHAR(BTIME(2))-240)
!!            IMINUT = (ICHAR(BTIME(4))-240)*10 + (ICHAR(BTIME(5))-240)
!!            ISECND = (ICHAR(BTIME(7))-240)*10 + (ICHAR(BTIME(8))-240)
!!             I100TH = 0
!!            IYEAR  = (ICHAR(BDATE(1))-240)*10 + (ICHAR(BDATE(2))-240)
!!             iyear  = mod(iyear,100)
!!            IMONTH = (ICHAR(BDATE(4))-240)*10 + (ICHAR(BDATE(5))-240)
!!            IDAY   = (ICHAR(BDATE(7))-240)*10 + (ICHAR(BDATE(8))-240)
!      RETURN
!      END
!!
!!
!!                                                           ============
!!============================================================  CRAY-C90
!      SUBROUTINE  CRAY77  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!     CHARACTER  *8   ATIME
!!     CHARACTER  *8   ADATE
!!     CHARACTER  *1   CH
!!     INUM(CH) = ICHAR(CH) - 48
!!
!!            iyear = 0
!!            imonth = 0
!!            iday   = 0
!!            ihour  = 0
!!            iminut = 0
!!            isecnd = 0
!!
!!           CALL  CLOCK (ATIME)
!!           CALL  DATE  (ADATE)
!!           IHOUR  = INUM(ATIME(1:1))*10 + INUM(ATIME(2:2))
!!           IMINUT = INUM(ATIME(4:4))*10 + INUM(ATIME(5:5))
!!           ISECND = INUM(ATIME(7:7))*10 + INUM(ATIME(8:8))
!!           IYEAR  = INUM(ADATE(7:7))*10 + INUM(ADATE(8:8))
!!            iyear  = mod(iyear,100)
!!           IMONTH = INUM(ADATE(1:1))*10 + INUM(ADATE(2:2))
!!           IDAY   = INUM(ADATE(4:4))*10 + INUM(ADATE(5:5))
!!            I100TH = 0
!!
!      RETURN
!      END
!!
!!
!!                                                      =================
!!======================================================= IBM AIX FORTRAN
!!                                                   and Lehey Fortran 90
!      SUBROUTINE  IBMAIX  (IYEAR, IMONTH, IDAY, &
!                           IHOUR, IMINUT, ISECND, I100TH)
!!
!!      INTEGER    *4   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!      CHARACTER  *1   CH
!!      CHARACTER       DAT*8, TIM*10, ZONE*5
!!      INTEGER         IVV(8)
!!      INUM(CH) = IACHAR(CH) - 48
!!
!!
!!            iyear  = 0
!!            imonth = 0
!!            iday   = 0
!!            ihour  = 0
!!            iminut = 0
!!            isecnd = 0
!!
!!             CALL  DATE_AND_TIME  (DAT,TIM,ZONE,IVV)
!!
!!             IHOUR  = INUM(TIM(1:1))*10 + INUM(TIM(2:2))
!!             IMINUT = INUM(TIM(3:3))*10 + INUM(TIM(4:4))
!!             ISECND = INUM(TIM(5:5))*10 + INUM(TIM(6:6))
!!             IYEAR  = INUM(DAT(3:3))*10 + INUM(DAT(4:4))
!!             iyear  = mod(iyear,100)
!!             IMONTH = INUM(DAT(5:5))*10 + INUM(DAT(6:6))
!!             IDAY   = INUM(DAT(7:7))*10 + INUM(DAT(8:8))
!!             I100TH = 0
!      RETURN
!      END
!!
!!
!!================================================================== G77
!      SUBROUTINE  G77  (IYEAR, IMONTH, IDAY, &
!                        IHOUR, IMINUT, ISECND, I100TH)
!!     --- Linux g77 ---
!!      integer*4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!      integer     jtm(9)
!!      integer *4  stime
!!
!!      stime = Time8()
!!      Call ltime (stime, jtm)
!!      isecnd = jtm(1)
!!      iminut = jtm(2)
!!      ihour  = jtm(3)
!!      iday   = jtm(4)
!!      IMONTH = jtm(5)+1
!!      iyear  = mod(jtm(6),100)
!      RETURN
!      End
!==================================================================! F90
      SUBROUTINE  F90  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND, I100TH)
!     --- Fortran 90 ---
      implicit none
      character date * 8, time * 10, zone *5
      integer*4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer*4  ia(1:8)
!
      call date_and_time(date, time, zone, ia)
!
      i100th = ia(8)
      isecnd = ia(7)
      iminut = ia(6)
      ihour  = ia(5)
      iday   = ia(3)
      IMONTH = ia(2)
      iyear  = ia(1)
      RETURN
      End
!=================================================================! THERMINT
subroutine thermint !kwkt
  use thrmint
!
  implicit none
!
  flambd = 0.0D0
  dflambd = 0.0D0
!  kval = 3
!
  flambd = lambd ** kval
  dflambd = kval * lambd ** ( kval - 1 )
!flambd = lambd
RETURN
END

