SUBROUTINE  EWALDP1_NEW  (myrank, mpsize)
!
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use radial
  use forces
  use cartes
  use molecu
  use vector
  use pmorse
  use quanco
  use ewal
!  use charge
  use datoms
  use WORK01
  use WORK02
  use thrmint !kwkt
!
!  implicit none
!
  integer*4  IRDF(LTB),  MRDF(LTB,LEE),   iii(3), icp
  double precision  PIX,DX,RX,DFX,FIX,R00,X0
  double precision  PIY,DY,RY,DFY,FIY,R01,X1,FIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,R02,X2,UII,EIJ
  double precision  PJX,PJY,PJZ
  double precision  VAL09P
  double precision  VALnn(11), VALnnC(3,3)
  double precision  RIJ, RIJ2, RCUT2, zizj
  double precision  pjx0,pjy0,pjz0,RIJ3
  double precision  wal0Nc(3,3), wal0N(11), rrr(7,2)
  double precision  uip(lni)
  double precision  ddd
  double precision dtmp, dtmpxyz(3)
  double precision EIJTHSUM,EIJTI,UIIC !kwkt
!  integer*4  iddatom(101,lni)
!  double precision  dddatom(100,lni)
  integer*4  ierr,idiatom,iquantum,ibmhexp,i,j,myrank,mpsize
  integer*4        ithrm,ithrmint !kwkt
  integer*4  io,l,i1,i2,j1,j2,k,ip0,ip1,ip2,kk,m,mm,NNCOMPO,JO,IN
  integer*4  ijk,n,kkk,jj,ko,kkkk,no
!
   integer :: tmp_size(2), array_size,local_NVNz,local_NVNz_offset
   integer,allocatable :: idisp(:), ircnt(:),iddatom_pack(:),iddatom_indx(:)
   real(8),allocatable :: dddatom_pack(:)
   complex(8),allocatable :: recvbuf(:,:,:)
!
  include 'mpif.h'
  integer*4 status(MPI_STATUS_SIZE)
!
!     ----------------------- Put the central atom of 3-body interaction
!                              at the last of atom species, to calculate
!                                                  3-body terms properly
!
  rcut2 = rcut(1) * rcut(1)
!
    VALnn(:) = 0.0D0
    VALnnC(:,:) = 0.0D0
!
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
!  write(*,*) 'EWALDP1'
  idiatom  = 0
  if (runopt(23) == 'DIATOMIC  ')  idiatom  = 1
  iquantum = 0
  IF (RUNOPT(12) == 'QUANTUM   ')  iquantum = 1
  ibmhexp  = 0
  if (RUNOPT( 8) == 'BMHEXP*   ')  ibmhexp  = 1
  ithrmint = 0
  if (runopt(37) == 'THERM-INT ')  ithrmint = 1  !kwkt
!
  if (NRECRD(3) == 1) then  
    call MPI_Bcast (irecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (idiatom,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (iquantum,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ibmhexp,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ithrmint,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)  !kwkt
    call MPI_Bcast (NTION,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NION(1),               lem,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IION(1),               lem,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IONS(1,1),           lem*2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NCOMPO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NPAIR,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (WIO(1),                lem,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZIO(1),                lem,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NDMOLE,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (RSWTCH(1),             lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (CIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D4IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D7IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (N3BP,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (I3BP(1,1),           L3P*3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ANG3BP(1),             L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FK3BP(1),              L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BGRD(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BLIM(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3LIM(1,1),          L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (E1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (F1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q1U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q2U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZMOLE(1),                2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DMOLE(1,1),        4*NTION,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DINTRA,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IDMOLE(1,1),3*NTION+NDMOLE,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IATOM2(1),               2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IATOMO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !kwkt
    call MPI_Bcast (IATOMH,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !kwkt
    call MPI_Bcast (flambd,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)  !kwkt
    call MPI_Bcast (TRANSX(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
    call MPI_Bcast (TRANSY(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
    call MPI_Bcast (TRANSZ(1),               8,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
!     write (*,*) '          MPI_Bcast sent NTION, E1, ZII, etc. '
  end if
!
  iii(1) = nrcut(1)
  iii(2) = nrcut(2)
  iii(3) = nvn
  call MPI_Bcast (iii(1),                  3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
!
  NNCOMPO=NCOMPO
!
  call MPI_Bcast (H(1,1),                  9,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !tricl
  call MPI_Bcast (ZII(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (nrecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NVEC(1,1),           3*NVN,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (VEC(1,1),            3*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (FNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (UNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PNV(1,1,1),        3*3*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  do i=1, 6
    rrr(i,1) = box(i)
    rrr(i,2) = rbox(i)
  end do
  rrr(7,1) = rcut(1)
  rrr(7,2) = rcut(2)
  call MPI_Bcast (rrr(1,1),              7*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (E0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  call MPI_Bcast (PX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (r3limax,                 1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!  write (*,8801)
8801 format (11x,'MPI_Bcast sent NVN, BOX, E0, F0, Px-Pz, etc.')
!
!     ------------------------------------------ Coulomb reciprocal term
!     ------------------------------------ Coulmb direct and short range
!
!kwkt
  call  EWALDP3  (idiatom, iquantum, ibmhexp, ithrmint, valnn, VALnnC, myrank, mpsize)
!
!write(*,*)'EWALDP3'
!
!     ------------------ Calculation of Coulomb of three point charges
  if (runopt(23) == 'DIATOMIC  ')  then
    do  L = 1, 2
      i1 = ntion + 1
      i2 = ntion + ndmole
      if (L  ==  2)  i1 = ntion + 2
      DO I = i1, i2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        j1 = 1
        j2 = ntion
        IF (L == 2)  THEN
          J1 = NTION + 1
          j2 = I-1
        END IF
        DO J = j1, j2
          ZIZJ  = ZII(I) * ZII(J)
!P              ZIJE2 = ZIO(IO) * ZIO(JO) * ELC**2
          pjx0 = p(1,j)
          pjy0 = p(2,j)
          pjz0 = p(3,j)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0
          DO K = 1, 8
            pjx = pjx0 - transx(k)
            pjy = pjy0 - transy(k)
            pjz = pjz0 - transz(k)
            RX = PIX - PjX
            RY = PIY - PjY
            RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!            DX = RX * BOX(1)
!            DY = RY * BOX(2)
!            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  GO TO 257
          enddo
          GO TO 262
!
257       RIJ = SQRT(RIJ2)
          IP0 = INT(RIJ*100.0)
!         ---------------------------------- Interpolation
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = IP0 * 0.01D0
          R01 = IP1 * 0.01D0
          R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
          FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
          VALnn(9) = VALnn(9) + EIJ
          UII   = UII   + EIJ
          UI(J) = UI(J) + EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VALnn(3) = VALnn(3) + DFX * DX
          VALnn(4) = VALnn(4) + DFY * DY
          VALnn(5) = VALnn(5) + DFZ * DZ
          VALnn(6) = VALnn(6) + DFX * DY
          VALnn(7) = VALnn(7) + DFX * DZ
          VALnn(8) = VALnn(8) + DFY * DZ
262       CONTINUE
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
      enddo
    enddo
  end if
!
!write(*,*) 'VIRLSR=', VIRLSR
!
  EIJTHSUM = EIJTHS !kwkt
!     --------------------------------------- receive results from CPU's
  if (mpsize > 1)  then

    do  icp = 1, mpsize-1

!      call MPI_Ssend (icp,                     1,         MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,ierr)
      call MPI_Recv(wal0N(1),11,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)

      do i = 3, 11
        valnn(i) = valnn(i) + wal0N(i)
      enddo
      VIRLSR = VIRLSR + wal0n( 2)

      call MPI_Recv (wal0NC(1,1),3*3,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)

!      tqcep = wal0NC(7)
      valnnc(1,1) = valnnc(1,1) + wal0Nc(1,1)
      valnnc(2,1) = valnnc(2,1) + wal0Nc(2,1)
      valnnc(3,1) = valnnc(3,1) + wal0Nc(3,1)
      valnnc(1,2) = valnnc(1,2) + wal0Nc(1,2)
      valnnc(2,2) = valnnc(2,2) + wal0Nc(2,2)
      valnnc(3,2) = valnnc(3,2) + wal0Nc(3,2)
      valnnc(1,3) = valnnc(1,3) + wal0Nc(1,3)
      valnnc(2,3) = valnnc(2,3) + wal0Nc(2,3)
      valnnc(3,3) = valnnc(3,3) + wal0Nc(3,3)
!      TQCE   = TQCE   + TQCEP
!
      call MPI_Recv(EIJTHS,1,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr) !kwkt
      EIJTHSUM = EIJTHSUM + EIJTHS   !kwkt
!
!      call MPI_Recv (uip(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (FXp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (FYp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (FZp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (MRDF(1,1),        ltb*npair,        MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)
!      do j = 1, npair
!        do i = 1, nrcut(1)
!          NRDF(i,j) = NRDF(i,j) + MRDF(i,j)
!          if (j==1) write(*,*)'nrdf = ',NRDF(i,1)
!        enddo
!      enddo
!      call MPI_Recv (iddatom(1,1),101*(ntion+ndmole),    MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)  !WATER-POL
!      call MPI_Recv (dddatom(1,1),100*(ntion+ndmole),MPI_DOUBLE_PRECISION,icp,icp,MPI_COMM_WORLD,status,ierr) !WATER-POL
!
!      do i = 1, ntion
!        ui(i) = ui(i) + uip(i)
!        fx(i) = fx(i) + fxp(i)
!        fy(i) = fy(i) + fyp(i)
!        fz(i) = fz(i) + fzp(i)
!        if (iddatom(101,i) > 0) then
!          do  j = 1, iddatom(101,i)
!            idatom(101,i) = idatom(101,i) + 1
!            idatom(idatom(101,i),i) = iddatom(j,i)
!            ddatom(idatom(101,i),i) = dddatom(j,i)
!          enddo
!        endif
!      enddo
    enddo !icp

    call MPI_Reduce( ui , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    ui(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( fx , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    fx(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( fy , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    fy(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( fz , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    fz(1:ntion+ndmole) = uip(1:ntion+ndmole)

    do icp = 1, mpsize-1
       call MPI_Recv(MRDF(1,1),ltb*npair,MPI_INTEGER4,icp,icp,MPI_COMM_WORLD,status,ierr )
       do j = 1, npair
          do i = 1, nrcut(1)
             nrdf(i,j) = nrdf(i,j) + mrdf(i,j)
          end do
       end do
    end do ! icp

    tmp_size(1)=0
    call MPI_Allreduce( tmp_size(1), array_size, 1, MPI_INTEGER, MPI_MAX, MPI_COMM_WORLD, ierr )
    allocate( iddatom_pack(array_size) ); iddatom_pack=0
    allocate( iddatom_indx(array_size) ); iddatom_indx=0
    allocate( dddatom_pack(array_size) ); dddatom_pack=0.0d0

    do icp = 1, mpsize-1

       call MPI_Recv( iddatom_indx, size(iddatom_indx), MPI_INTEGER, icp, icp, MPI_COMM_WORLD, status, ierr )
       call MPI_Recv( iddatom_pack, size(iddatom_pack), MPI_INTEGER, icp, icp, MPI_COMM_WORLD, status, ierr )
       call MPI_Recv( dddatom_pack, size(dddatom_pack), MPI_REAL8  , icp, icp, MPI_COMM_WORLD, status, ierr )

       do k = 1, count(iddatom_pack/=0)
          j = iddatom_indx(k)
          idatom101(j) = idatom101(j) + 1
          idatom( idatom101(j), j ) = iddatom_pack(k)
          ddatom( idatom101(j), j ) = dddatom_pack(k)
       end do

    end do ! icp

    deallocate( dddatom_pack )
    deallocate( iddatom_indx )
    deallocate( iddatom_pack )


!    write (*,8901)  1,mpsize-1
8901 format (11x,'MPI_Recv received results from ',i2,' to ',I3)
  end if
!
!kwkt
   if (RUNOPT(37) == 'THERM-INT ') then
    VAL09P = VALnn(9)
    if (dintra > 0.0D0) then
      no = 0
      EIJTI = 0.0d0
      do io = IONS(1,IATOMO), IONS(2,IATOMO)
        no = no + 1
        do k = 1,2
          kk = ih2o(k,no)
          PIX = PX(kk)
          PIY = PY(kk)
          PIZ = PZ(kk)
          FIX = 0.0D0
          FIY = 0.0D0
          FIZ = 0.0D0
          UII = 0.0D0
          UIIC = 0.0d0
          DO m = k+1, 3
            mm = ih2o(m,no)
            pjx0 = PX(mm)
            pjy0 = PY(mm)
            pjz0 = PZ(mm)
            if (pjx0 < pix)  pjx0 = pjx0 + 1.0
            if (pjy0 < piy)  pjy0 = pjy0 + 1.0
            if (pjz0 < piz)  pjz0 = pjz0 + 1.0
            DO  kkkk = 1, 8
              pjx = pjx0 - transx(kkkk)
              pjy = pjy0 - transy(kkkk)
              pjz = pjz0 - transz(kkkk)
              RX = PIX - PjX
              RY = PIY - PjY
              RZ = PIZ - PjZ
              DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
              DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
              DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
 !            DX = RX * BOX(1)
 !            DY = RY * BOX(2)
 !            DZ = RZ * BOX(3)
              RIJ2 = DX*DX + DY*DY + DZ*DZ
              IF (RIJ2 <= RCUT2)  EXIT     
            ENDDO 
            RIJ  = sqrt(RIJ2)  !angstrom
            if (RIJ < 0.1D0) stop 'Too short distance !!!'
            if (RIJ > 3.0D0) stop 'Too long distance!!!'
            RIJ3 = RIJ**3  !angstrom
            ZIZJ  = ZII(mm)*ZII(kk)
!            EIJ  = ELC**2*ZIZJ/RIJ*1.0D8     !erg cgs-esu
            EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
            EIJTI = EIJTI + EIJ/flambd**2
!write(*,*)'EIJ',EIJ,EIJ/flambd**2
            EIJ   = EIJ * (1.0D0 - 1.0D0/flambd**2)
            VALnn(9) = VALnn(9) - EIJ
            UII   = UII   + EIJ
            UIIC  = UIIC  + EIJ
            UI(mm) = UI(mm) - EIJ
            UIC(mm) = UIC(mm) - EIJ
!!            FIJ   = ELC**2*ZIZJ/RIJ3*1.0D16
            FIJ   = EPOLLL*ZIZJ/RIJ3 ! dyn
            FIJ   = FIJ * (1.0D0 - 1.0D0/flambd**2)
            DFX  = FIJ*DX
            DFY  = FIJ*DY
            DFZ  = FIJ*DZ
            FIX  = FIX + DFX
            FIY  = FIY + DFY
            FIZ  = FIZ + DFZ
            FX(mm) = FX(mm) + DFX  ! cgs-esu
            FY(mm) = FY(mm) + DFY  ! cgs-esu
            FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
            VALnn(3) = VALnn(3) - DFX * DX
            VALnn(4) = VALnn(4) - DFY * DY
            VALnn(5) = VALnn(5) - DFZ * DZ
            VALnn(6) = VALnn(6) - DFX * DY
            VALnn(7) = VALnn(7) - DFX * DZ
            VALnn(8) = VALnn(8) - DFY * DZ
          enddo
          FX(kk) = FX(kk) - FIX
          FY(kk) = FY(kk) - FIY
          FZ(kk) = FZ(kk) - FIZ
          UI(kk) = UI(kk) - UII
          UIC(kk) = UIC(kk) - UIIC
        enddo
      enddo
    elseif (dintra <= 0.0D0) then
      EIJTI = 0.0d0
      do io =1,NION(IATOMO) + NION(IATOMH)
        kk=intr(io)
        PIX = PX(kk)
        PIY = PY(kk)
        PIZ = PZ(kk)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0d0
        do jo = io+1, NION(IATOMO) +NION(IATOMH)
          mm = intr(jo)
          pjx0 = PX(mm)
          pjy0 = PY(mm)
          pjz0 = PZ(mm)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0
          DO  kkkk = 1, 8
            pjx = pjx0 - transx(kkkk)
            pjy = pjy0 - transy(kkkk)
            pjz = pjz0 - transz(kkkk)
            RX = PIX - PjX
            RY = PIY - PjY
            RZ = PIZ - PjZ
            DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
            DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
            DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  EXIT
          ENDDO
          RIJ  = sqrt(RIJ2)  !angstrom
!          write(97,*) RIJ, "!" 
          RIJ3 = RIJ**3  !angstrom
          ZIZJ  = ZII(mm)*ZII(kk)
          EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
          EIJTI = EIJTI + EIJ/flambd**2
          EIJ = EIJ * (1.0D0-1.0D0/flambd**2)
          VALnn(9) = VALnn(9) - EIJ
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJ
          UI(mm) = UI(mm) - EIJ
          UIC(mm) = UIC(mm) - EIJ
          FIJ = EPOLLL*ZIZJ/RIJ3   !dyn
          FIJ = FIJ * (1.0D0-1.0D0/flambd**2) !kwkt
          DFX = FIJ*DX
          DFY = FIJ*DY
          DFZ = FIJ*DZ
          FIX = FIX + DFX
          FIY = FIY + DFY
          FIZ = FIZ + DFZ
          FX(mm) = FX(mm) + DFX  ! cgs-esu
          FY(mm) = FY(mm) + DFY  ! cgs-esu
          FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
          VALnn(3) = VALnn(3) - DFX * DX
          VALnn(4) = VALnn(4) - DFY * DY
          VALnn(5) = VALnn(5) - DFZ * DZ
          VALnn(6) = VALnn(6) - DFX * DY
          VALnn(7) = VALnn(7) - DFX * DZ
          VALnn(8) = VALnn(8) - DFY * DZ
        enddo
        FX(kk) = FX(kk) - FIX
        FY(kk) = FY(kk) - FIY
        FZ(kk) = FZ(kk) - FIZ
        UI(kk) = UI(kk) - UII
        UIC(kk) = UIC(kk) - UIIC
      enddo
    endif
   endif  !THERM-INT
  EIJKTI = 0.0d0 !kwkt
!     -------------------------------------------- Calculate 3-body term          
  if (n3bp > 0)  then                                                        
    do io = 1, ncompo                                                     
      ijk = 0                                                                  
      do  n = 1, n3bp                                                          
        if (io == i3bp(2,n))  ijk = n    ! searching center atoms
      end do                                                                   
      if (ijk == 0)  cycle               ! if io /= a center atom  then cycle
!                                                                                                                                      
      do i=ions(1,io), ions(2,io)                                          
!        mm = idatom(101,i)                ! idatom(101,i) : number of atoms near the center atom
        mm = idatom101(i)
        if (mm <= 1)  cycle                                               
!           ------------------------------------- sorting with distrance          
        do j = 1, mm-1                                                   
          do k = j+1, mm 
            if (ddatom(j,i) > ddatom(k,i)) then !ddatom (j,i) : distance between i and j
              ddd         = ddatom(j,i)                                 
              ddatom(j,i) = ddatom(k,i)                                 
              ddatom(k,i) = ddd                                         
              kkk         = idatom(j,i)                                 
              idatom(j,i) = idatom(k,i)                                 
              idatom(k,i) = kkk                                         
            end if                                                          
          enddo
        enddo                                                             
!                                                                                 
420     pix = px(i)                                    
        piy = py(i)                                    
        piz = pz(i)                                    
        if (pix >= 0.5d0) pix = pix -1.0d0
        if (piy >= 0.5d0) piy = piy -1.0d0
        if (piz >= 0.5d0) piz = piz -1.0d0
        do jj = 1, mm-1                                                  
          jo = idatom(jj,i) / 1000000                                        
          j  = mod(idatom(jj,i),1000000)                                     
          do KKK = 1, 8
            PJX = PX(J) - TRANSX(KKK)
            PJY = PY(J) - TRANSY(KKK)
            PJZ = PZ(J) - TRANSZ(KKK)
            RX = PIX - PJX                                               
            RY = PIY - PJY                                                 
            RZ = PIZ - PJZ                                                 
!            IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
!            IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
!            IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
!            D1AXYZ(1) = RX * BOX(1)                                        
!            D1AXYZ(2) = RY * BOX(2)                                        
!            D1AXYZ(3) = RZ * BOX(3)                                        
            D1AXYZ(1) = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
            D1AXYZ(2) = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
            D1AXYZ(3) = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            D1ATOM    = sqrt(d1axyz(1)**2 + d1axyz(2)**2 + d1axyz(3)**2)                  
            do kk = jj+1, mm                                                 
              ko = idatom(kk,i) / 1000000                                        
              k  = mod(idatom(kk,i),1000000)                                     
              do KKKK = 1, 8
                PJX = PX(k) - TRANSX(KKKK)
                PJY = PY(k) - TRANSY(KKKK)
                PJZ = PZ(k) - TRANSZ(KKKK)
                RX = PIX - PJX                                               
                RY = PIY - PJY                                                 
                RZ = PIZ - PJZ                                                 
!                IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
!                IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
!                IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
!                D2AXYZ(1) = RX * BOX(1)                                        
!                D2AXYZ(2) = RY * BOX(2)                                        
!                D2AXYZ(3) = RZ * BOX(3)                                        
                D2AXYZ(1) = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                D2AXYZ(2) = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                D2AXYZ(3) = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
                D2ATOM    = sqrt(d2axyz(1)**2 + d2axyz(2)**2  + d2axyz(3)**2)                  
!                                                                                     
                DO N = 1, N3BP                                                 
                  ithrm = 0 !kwkt
!                            -------------------------- 3-body potential B-A-B          
                  IF (io == I3BP(2,N) .AND. jo == i3BP(1,N) .and. &                
                      jo == ko        .and. ko == i3BP(3,N)) then                 
                    if (RUNOPT( 8) == 'VASHISHTA ') then
                        if(d1atom <= R3BLIM(1,N) .and. d2atom <= R3BLIM(1,N)) then
!write(*,*)j,k,d1atom,d2atom
                          CALL THREER3 (I,j,k,N)  
                        endif
                    else 
                      if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(1,n) )  then                           
!                                                                                     
                        if(ithrmint == 1) then  !kwkt
                           if (io == IATOMO .and. jo == IATOMH) ithrm = 1
                        endif
!
                        CALL  THREEP  (I,j,k, n,ithrm) !kwkt                           
!                                                                                     
                      end if     
                    endif                                                
                  END IF                                                          
!                                                                                     
!                          ------------------------------------ 3-body B-A-C          
                  IF (IO == I3BP(2,N)       .AND. JO == i3BP(1,n) .and. &           
                          i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(3,n)) then           
!                                                                                     
                    if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(2,n) )  then  
                      call  threeq  (I,j,k, N)                
                    end if                                                     
                  end if                                                          
!                                                                                     
                  IF (IO == I3BP(2,N)       .AND. JO == i3BP(3,n) .and.  &
                      i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(1,n)) then           
!                          ------------------------------------ 3-body C-A-B          
!                                                                                     
                    if (d1atom <= r3lim(2,n) .and. d2atom <= r3lim(1,n) )  then
                       dtmp = d1atom
                       d1atom = d2atom
                       d2atom = dtmp
                       dtmpxyz(:) = d1axyz(:)
                       d1axyz(:) = d2axyz(:)
                       d2axyz(:) = dtmpxyz(:)
                      call  threeq  (I,k,j, N)                
                       dtmp = d1atom
                       d1atom = d2atom
                       d2atom = dtmp
                       dtmpxyz(:) = d1axyz(:)
                       d1axyz(:) = d2axyz(:)
                       d2axyz(:) = dtmpxyz(:)
                    end if                                                     
                  end if                                                          
                enddo                                                           
              enddo
            enddo
          enddo            
        enddo                                                              
      enddo                                                                 
    enddo                                                                    
  end if                                                                      
!
   if (RUNOPT(37) == 'THERM-INT ') then  !kwkt
    ULAM = 0.0D0
    ULAM = 2.0d0*(UCSLFI(IATOMO) + UCSLFI(IATOMH)) -2.0d0*EIJTI -2.0d0*EIJTHSUM -EIJKTI
      do j = ions(1,IATOMO), ions(2,IATOMO)
        ULAM = ULAM + UI(j)
      end do
      do i = ions(1,IATOMH), ions(2,IATOMH)
        ULAM = ULAM + UI(i)
      end do
    ULAMT = ULAMT + ULAM  
   endif


!     ------------------------------------------------------------------
  PRSTC2(1) = VALnnC(1,1)
  PRSTC2(2) = VALnnC(2,2)
  PRSTC2(3) = VALnnC(3,3)
  PRSTC2(4) = (VALnnC(2,3) + VALnnC(3,2)) /2.0d0
  PRSTC2(5) = (VALnnC(1,3) + VALnnC(3,1)) /2.0d0
  PRSTC2(6) = (VALnnC(1,2) + VALnnC(2,1)) /2.0d0
!  write(*,*) 'PRSTC2'
!  do i = 1,6
!    write(*,*) PRSTC2(i)
!  enddo
!
  VAL(3)  = VAL(3)  + VALnn( 3)*1.0D-8 + PRSTC2(1)
  VAL(4)  = VAL(4)  + VALnn( 4)*1.0D-8 + PRSTC2(2)
  VAL(5)  = VAL(5)  + VALnn( 5)*1.0D-8 + PRSTC2(3)
  VAL(6)  = VAL(6)  + VALnn( 6)*1.0D-8 + PRSTC2(4)
  VAL(7)  = VAL(7)  + VALnn( 7)*1.0D-8 + PRSTC2(5)
  VAL(8)  = VAL(8)  + VALnn( 8)*1.0D-8 + PRSTC2(6)
  VAL(9)  = VAL(9)  + VALnn( 9)
  VAL(10) = VAL(10) + VALnn(10)
  VAL(11) = VAL(11) + VALnn(11)
  PREST(1,1) = VALnn(3)*1.0D-8 + VALnnC(1,1)
  PREST(2,1) = VALnn(8)*1.0D-8 + VALnnC(2,1)
  PREST(3,1) = VALnn(7)*1.0D-8 + VALnnC(3,1)
  PREST(1,2) = VALnn(8)*1.0D-8 + VALnnC(1,2)
  PREST(2,2) = VALnn(4)*1.0D-8 + VALnnC(2,2)
  PREST(3,2) = VALnn(6)*1.0D-8 + VALnnC(3,2)
  PREST(1,3) = VALnn(7)*1.0D-8 + VALnnC(1,3)
  PREST(2,3) = VALnn(6)*1.0D-8 + VALnnC(2,3)
  PREST(3,3) = VALnn(5)*1.0D-8 + VALnnC(3,3)
!
!  write(*,*)'VAL3-10'
!  do i = 3,10
!    write(*,*) VAL(i),VALnn(i)
!  enddo
!  write(*,*)'VIRLSR=',VIRLSR
!    write(*,*)'fx,fy,fz', fx(1),fy(1),fz(1)
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(23) == 'DIATOMIC  ')  CALL  EWALD_of_DiAtoms 
!
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(29) == 'POLYATOMS ')  CALL  EWALD_of_PolyAtoms
!
!     ---------------------------------------------- RDF for dummy atoms
  IN = 0
  DO IO = 1, NNCOMPO
    DO JO = 1, IO
      IN = IN + 1
      IF (IION(IO) > -998 .AND. NION(JO) > -998) cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)  cycle
      IF (IO == JO         .AND. NION(IO) <= 1)  cycle
      DO K = 1, NRCUT(1)+1
        IRDF(K) = 0
      enddo
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
      DO I = I1, I2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        IF (PIX >= 0.5d0) PIX =PIX -1.0d0
        IF (PIY >= 0.5d0) PIY =PIY -1.0d0
        IF (PIZ >= 0.5d0) PIZ =PIZ -1.0d0
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
                 DO 740  K = 1, 8
                     RX = ABS(PIX - PX(J) + TRANSX(K))
                     RY = ABS(PIY - PY(J) + TRANSY(K))
                     RZ = ABS(PIZ - PZ(J) + TRANSZ(K))
                     DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
                     DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
                     DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
!          DX = ABS(PIX - PX(J))
!          DY = ABS(PIY - PY(J))
!          DZ = ABS(PIZ - PZ(J))
!T                     - - - - - delete these if-statements for triclinic
!          IF (ABS(DX) > 0.5)  DX = 1.0 - DX
!          IF (ABS(DY) > 0.5)  DY = 1.0 - DY
!          IF (ABS(DZ) > 0.5)  DZ = 1.0 - DZ
!          RIJ2 = (DX * BOX(1))**2 + (DY * BOX(2))**2  + (DZ * BOX(3))**2
          RIJ2 = DX**2 + DY**2 + DZ**2
          IF (RIJ2 <= RCUT2)  GO TO 755
  740             CONTINUE
          GO TO 750
  755     CONTINUE
          IP0 = INT( DSQRT(RIJ2) * 100.0D0 )
          IF (IP0 < 1)  IP0 = 1
          IRDF(IP0) = IRDF(IP0) + 1
  750   enddo
      enddo
      IF (MOD(NRECRD(1),IRECRD(5)) == 0 ) THEN
        DO L = 1, NRCUT(1)
          NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
        enddo
      ENDIF
    enddo
  enddo
  RETURN
END SUBROUTINE EWALDP1_NEW
!
!
