!===================================================================
!##                                                               ##
!##           Program  :  MXDORTHO                                ##
!##                                                               ##
!##      by  Katsuyuki Kawamura (Hokkaido University)             ##
!##                   (Tokyo Institute of Technology)             ##
!##                                                               ##
!##      by  Hiroshi SAKUMA (Tokyo Institute of Technology)       ##
!##                         (NIMS)                                ##
!##                                                               ##
!##     Configuration and Energy for Non-Cubic Systems            ##
!##              (Rectangular parallelepiped)                     ##
!##     with Pressure Control by stress tensor,                   ##
!##     and Quantum Correction for energy and pressure            ##
!##                                                               ##
!##        2nd order interpolation from tables                    ##
!##                                                               ##
!##   First cubic version on Hitac 8800/8700            80        ##
!##   First orthogonal (crystal) version                83-10     ##
!##       on CDC7600 at Manchester Univ.                          ##
!##   HITAC M-280/IAP version                           85-09-12  ##
!##   PX, PY, PZ pressure control version               87-02-07  ##
!##   Pressure tensor and fractional coordinates        87-10-29  ##
!##   Five element and input data format and history    87-11-05  ##
!##   PC9800RA+NDP-FORTRAN-386   version                89-01-26  ##
!##   Reviced for JCPE                                  90-04-14  ##
!##   (XDORTO : DEFECT)                                 90-04-21  ##
!##   3-body interaction (H2O, Kumagai & Kats)          91-02-02  ##
!##   Integrated version of MD and XD (MXD)             91-05-22  ##
!##   Rearranged                                        91-10-23  ##
!##   Seven comonents, rearranged                       92-01-23  ##
!##   Quatum corrections     (Nakao & Kats)             92-03-04  ##
!##   Ten comonents, rearranged                         92-03-31  ##
!##   Extended Andersen's pressure control              92-04-07  ##
!##                        (Katsuta & Kats)                       ##
!##   Metal (main group) potential                      92-04-18  ##
!##   Revised for JCPE version                          92-08-01  ##
!##   2nd order interpolation from tables               92-09-05  ##
!##   2nd order interpolation of velocity               92-12-12  ##
!##   Nose's thermostat                                 92-12-14  ##
!##   Correction for trancation VW-term                 93-12-10  ##
!##   Reviced 3-body by Kuma                            94-01-30  ##
!##   L-J potential                                     94-06-28  ##
!##   Nose's thermostat + quantum                       94-09-01  ##
!##   Improvement of Semi-classical MD                  95-06-15  ##
!##   FILE09.DAT format changed                         95-07-18  ##
!##   IP model by Belonoshko & Dubrovinsky              96-09-05  ##
!##   Electric Field(N.SAWAGUCHI) & Gravity F.          97-06-30  ##
!##   Diatomic 3 chrge model                            97-10-20  ##
!##   'ENERGY' and 'CUBE' options                       98-08-24  ##
!##   'CONVEC' option                                   99-02-09  ##
!##   'P ANDERS-C' for cubic Andersen                   99-08-23  ##
!##   Pair type potential model (PAIR-P)                99-09-27  ##
!##   3-body j-i-k with j<>k                            99-11-16  ##
!##   'EXCLUSION' : column and so on                    00-04-15  ##
!##   3-body   sqrt(k1xk2) -> k1xk2                     00-05-01  ##
!##   Cell change with time                             00-05-28  ##
!##   POSISION-VELOCITY-ENERGY option                   00-12-16  ##
!##   Soft repulsive wall                               01-03-07  ##
!##   Modify EWALD direct term                          01-03-24  ##
!##   3-body j-i-k : modified                           01-09-11  ##
!##   File07.dat : format                               01-12-02  ##
!##   Polyatomic molecule                               02-02-23  ##
!##   EWALD correction for slab geometry (sakuma)       08-07-08  ##
!##   File07.dat(i10)                                   08-08-06  ##
!##   PCF using IRECRD(5)                               09-12-16  ##
!##   Fortran90                                                   ##
!##   BUG fixed Polyatoms  (sakuma)                     10-06-29  ##
!##   File09v format change (sakuma)                    10-07-06  ##
!##   file09pv (velocity) PVMULT = 50000.0 (sakuma)     10-07-06  ##
!##   file09p and file09pv(pos) -> 5 figures (sakuma)   10-07-06  ##
!##   WATER-POL (sakuma)                                10-07-16  ##
!##   WATER-POL Lone pair   1.0.4                       10-08-10  ##
!##   WATER-POL Lone pair, no charge on oxygen 1.0.5    10-08-24  ##
!##   WATER-POL 1.0.5 + EFD at center of mass  1.0.6    10-10-06  ##
!##   WATER-POL 1.0.6 bug fixed for val(1) to val(9)    10-10-19  ##
!##   WATER-POL 1.0.6_2 replusion for lone pairs        10-10-20  ##
!##   BUG FIXED for IRECRD(3) == 1 (When CALL CLEARS)   10-10-20  ##
!##   Revise forces on oxygen from lone pairs           10-10-27  ##
!##   Direct Coulomb force to remove inner force        10-11-12  ##
!##   BUG FIXED for PBC using FIND_H2O                  10-11-22  ##
!##   START modification of polarization energy         10-12-29  ##
!##   Separate file08.dat (file081.dat)                 11-02-02  ##
!##   BUG fixed (Forces of lone pairs)                  11-02-03  ##
!##   BUG fixed (Upolarization)                         11-02-27  ##
!##   NVE for WATER-POL                                 11-03-05  ##
!##   WATER-POL 1.0.7 Release STRESS CORRECTED but slow 11-03-08  ##
!##   mxdorto_wp.f90 Release                            11-04-02  ##
!##   Bug fixed for Nose-Hoover thermostat              14-04-17  ##
!##   Isolated System                                   14-07-30  ##
!##   Implementation of WATER-POL                       14-07-31  ##
!##   Implementation of Nose-Hoover Chain               14-08-05  ##
!##   Bug fixed for MOLECULE option                     14-09-01  ##
!##   Output force and energy for Ewald optimization    15-03-31  ##
!##   Bug fixed for ISOLATED option (PBC)               17-07-31  ##
!##   Background charge by volume correction            18-03-19  ##
!##   Smooth Particle Mesh Ewald method for NVT         18-04-17  ##
!##   No SPME version                                             ##
!##   Vashishta potential                               23-11-29  ##
!##   20 Elements for BMHEXP                            25-11-20  ##
!###################################################################
!
!=======================================================================I
!              Format  and  parameters  of  'FILE05.DAT'  file          :
!-----------------------------------------------------------------------I
! 1  MD.......I....:....I....:....I....:....I....:....I....:....I....:..:
!    XD.......I...                                                      :
! 2  START    :TITLE(60 CHARACTERS)                                     :
!    CONTINUE :                                  (CONT.)                :
!    RESTART  :                                                         :
!    STOP     :                                                         :
! 3  ECONOMY  :IRECRD(1):IRECRD(2):IRECRD(3):IRECRD(4):IRECRD(5):       :
!    NORMAL   :         :         :   (50)  : (M50,X5):   (5)   :       :
!    DETAIL   :         :         :         :         :         :       :
! 4  NOACCUM  : DTIME   : FORMULA : (RCUTL) : (RCUTS) :         :       :
!    ACCUM    :         :         :         :         :         :       :
! 5  T NO-CNTL:         :         :         :         :         :       :
!    T [BLANK]:         :         :         :[No control on temperature]:
!    T SCALING: TMPGET  : DELTMP  : NTSTEP  : TDUMP   :         :       :
!    T SCALE-A: TMPGET  : DELTMP  : NTSTEP  : TDUMP   :[Scale each atom]:
!    T NOSE   : TMPGET  : 1.e-7   : omega1  :  omega2 :  omega3 : omega4:
! 6  P NO-CNTL:         :         :         :         :         :       :
!    P [BLANK]:         :         :         :   [No control on pressure]:
!    P SCALING: SPRES(1):SPRES(2) :SPRES(3) :         :         :       :
!    P ANDERSEN SPRES(1):SPRES(2) :SPRES(3) :VIRM(1)  :VIRM(2)  :VIRM(3):
!    P ANDERS-C SPRES(1):         :         :VIRM(1)  :         :       :
! 7  V [BLANK]:         :         :   [Volume is changed with P-control]:
!    V CONST. :         :         :         :  [Volume is kept constant]:
!    V CELL   : BOX(1)  : BOX(2)  : BOX(3)  : BOX(4)  : BOX(5)  : BOX(6):
!    V DENSITY: DENSTY  :         :         :         :         :       :
!    D CONST. : DENSTY  :         :         :         :         :       :
!    V CHANGE : ICAXIS  : BTAGET  : BCNGR(A par step) :         :       :
! 8  BUSING   :MODE,MXN2:(ALPHA)  :         :         :         :       :
!    MORSE    :         :         :         :         :         :       :
!    MORSE-AT :         :         :         :         :         :       :
!    BMH-EXP  :     3-body    sqrt(k1xk2)   :         :         :       :
!    BMH-EXP* :     3 body    k1xk2         :         :         :       :
!    BELONO   :         :         :         :         :         :       :
!    TOSIFUMI :         :         :         :         :         :       :
!    WOODCOCK :         :         :         :         :         :       :
!    PAULING  :         :         :         :         :         :       :
!    METAL    :         :         :         :         :         :       :
!    PAIR-P   :         :         :         :         :         :       :
!    STSUNE   :         :         :         :         :         :       :
!    L-J      :         :         :         :         :         :       :
!    VASHISHTA:         :         :         :         :         :       :
! 81 N A  NO. : ZI      : WI      : AI      : BI      : CI(VW)  : DI()  :
!     -       :         :         :         :         :    not moved    :
!     *       :         :         :         :         :    dummy atoms  :
!     =       :         :         :         :         :    Morse only   :
!     /       :         :         :         :         :    no T-control :
! 81e[BLANK]  :         :         :         :         :         :       :
! 82  I J     : DMIJ    : BEIJ    : RSIJ    :         :       [Morse]   :
!     J I J   :FK3BP    :ANG3BP   :R3BLIM   :R3BGD    :       [3-body]  :
!     J I K   :FK3BP(1) :ANG3BP(1):R3BLIM(1):R3BGD(1) :   [3-body(J<>K)]:
!             :         :         :R3BLIM(2):R3BGD(2) :         :       :
! 82  I J     : AIJ     : BIJ     : CIJ     :         :   (eV)  [Pair-U]:
! 82  I J     : AIJ     : BIJ     : CIJ     :         (kJ/mol)  [Pair-P]:
! 82e[BLANK]  :         :         :         :         :         :       :
!             :         :         :         :         :         :       :
! 91 STRUCTURE:         :         :       9 :         :         :       :
! 92 NETWORK  :NFCION(1):NFCION(2):      10 :[Network structure analy.] :
! 93 VELOCITY :NS09PV   :PVMULT   :      11 :[Record particle velocity] :
!    POSITION :NS09PV   :PVMULT   :      11 :        [... ... position] :
!    ENERGY   :NS09PV   :PVMULT   :      11 :        [....... energy  ] :
!    POSVELENE:NS09PV   :         :      11 :     [..... pos,velo,ener] :
! 94 QUANTUM  :         :         :      12 :      [Quantum correction] :
! 95 PCF, RDF : ISTEP   : Rend(A) :      13 :     [Format of PCF table] :
!*96 DIPOLE   :         :         :      14 :        [E(dipole moment)] :
! 97 CENTER   :         :         :      15 :[Centering of atom cluster]:
!    CENTERING:  iaxcen :         :         :                           :
! 98 NO(MV=0) :         :         :      16 :[No correction for morment]:
!    Am(MV=0) :  Iam    :         :         :[Moment correction for Iam]:
! 99 CRYSTAL  :         :         :      17 :[MD of crystal structure]  :
! 9A BINARY   :         :         :      18 :[Binary data for file09x.] :
! 9B PRESSURE : NPRESS  :         :      19 :[Pressure tensor on file11]:
! 9C ELEC.FIELD   EFD1  :   EFD2  :   EFD3  : EFFEQ 20:[Electric field] :
! 9D GRAV.FIELD   GFD1  :   GFD2  :   GFD3  :       21:[Gravity field]  :
! 9E CONSTSHEAR  VX-RY  :  VY-RZ  :  VX-RZ  :(ps)-1 22:[Const.shear rat]:
! 9F DIATOMIC :  DINTRA :iatom2(1):iatom2(2):       23:[Diatomic molec] :
! 9G CUBE     :         :         :         :       24:[to Cubic cell]  :
! 9H CONVEC   :  FCONVC :         :         :       25:[Convection]     :
! 9I MOLECULE :  Dintra :MOLstart : MOLend  :       26:[Define molecule]:
! 9J EXCLUSION:         :         :         :       27:[Exclusion]      :
!    COLUMN   :  iaex   : Rexcl(radius)  F  :         :    R>0 out      :
!    SLUB     :  iaex   : Rexcl(Thickness/2)  F :     :    R<0 in       :
!    CUBE     :  Rexcl(edge/2)    :  Fexcl  :         :         :       :
!    SPHERE   :  Rexcl(radius)    :  Fexcl  :         :         :       :
!    HONEYCOMB:  iaex   : Rexcl(radius) : Fexcl :     :         :       :
! 9K WALL     :   A     :    B    :         :   28:[Soft repulsive wall]:
! 9L POLYATOM :  Dintra :MOLstart : MOLend  :   29:[Polyatomic molecule]:
! 9n ........ :         :         :         :         :         :       :
! 9e [BLANK]  :         :         :         :         :         :       :
! 9           :         :         :         :         :         :       :
!    MD.......I....:....I....:....I....:....I....:....I....:....I....:..:
!    REPEAT  1 TO 9                                                     :
!=======================================================================I
!      IRECRD                            NRECRD                         :
!      -----------------------------     -----------------------------  :
! 1    Total number of steps             Current step No. from 'START'  :
! 2    Interval of print PCF etc.        Accumulation No. of PCF etc.   :
!                                               (I2=N2 when 'ACCUM')    :
! 3    Interval of FILE07 recording      Current step number            :
!           (default: 50)                           in the current job  :
! 4    Interval of FILE09P recording     Number of records in FILE09P   :
!           (default: 50:MD. 5:XD)                                      :
! 5    Interval of FILE09V recording     Number of records in FILE09V   :
!           (default: 5)                                                :
! 6    Number of steps of current HIST   Number OF HISTRY informations  :
! 7-8  Not used                          Not used                       :
! 9    Interval of FILE09PV recording    Number of steps in FILE09PV    :
!=======================================================================I
!    I/O number        FLNAME         Filename                          :
!        5                -           input from keyboad                :
!       15              ( 5)          FILE05.DAT         in             :
!        6, *             -           screen output      out            :
!       16              ( 6)          FILE06.DAT         out            :
!       17              ( 7)          FILE07.DAT         in/out         :
!       18              ( 8)          FILE08.DAT         in/out         :
!       38              (18)          FILE081.DAT        in/out         :
!       19              ( 9)          FILE09P.DAT        in/out         :
!       10              (10)          FILE10.DAT         in             :
!       29              (11)          FILE09V.DAT        in/out         :
!       28              (12)          FILE09PV.DAT       out            :
!       27              (13)          FILE11.DAT         out            :
!       37              (17)          POTENSURF.DAT      out            :
!       22              (19)          TEMPO.DAT          in/out(work)   :
!=======================================================================I
!   LNI : Maximum number of particles (ion or atom) in a basic cell     :
!   LTB : Maximum table length of Coulomb energy and force              :
!   LSR : Table length of short range interactions                      :
!   LEL : Maximum number of particle species                            :
!   LEE : Number of pairs of particle species                           :
!   LCT : Maximum number of steps                                       :
!   LNV : Maxinum number of reciprocal lattice points in EWALD sum.     :
!   LAA : Maximum number of atoms in a asymmetric unit (XD)             :
!   LAT : Maximum number of atoms in a crystal unit cell (XD)           :
!=======================================================================I
!  P(3,LNI) : Fractional coordinates of atoms, 0=<p<1                   :
!  V(3,LNI) : Displacements (in A) of atoms for priod of dtime(delta-t) :
!  VP(3,LNI): Displacements (in A) of atoms at one step before          :
!=======================================================================I
!  RUNOPT(1) = 'MD........'  'XD........'  'MDX.......'                 :
!        (2) = '          '  'START     '  'CONT.     '  'STOP      '   :
!              'END       '  'RESTART   '  'CONTINUE  '                 :
!        (3) = 'DETAIL    '  'NORMAL    '  'ECONOMY   '                 :
!        (4) = 'ACCUM     '  'NOACCUM   '                               :
!        (5) = 'T NO-CNTL '  'T SCALING '  'T NOSE    '  'T SCALE-A '   :
!        (6) = 'P NO-CNTL '  'P SCALING '  'P ANDERSEN'  'P ANDERS-C'   :
!        (7) = 'V CONST.  '  'V FREE    '  'D CONST.  '  'V CELL    '   :
!              'V DENSITY '  'V CHANGE  '                               :
!        (8) = '          '  'BUSING    '  'MORSE     '  'MORSE-AT  '   :
!              'TOSIFUMI  '  'WOODCOCK  '  'PAULING   '  'STSUNE    '   :
!              'L-J       '  'METAL     '  'PAIR-P    '                 :
!              'BMH-EXP   '  'BMH-EXP*  '  'VASHISHTA '                 :
!        (9) = 'STRUCTURE '  '          '                               :
!       (10) = 'NETWORK   '  '          '                               :
!       (11) = 'VELOCITY  '  'POSITION  '  'ENERGY    ' 'POSVELENE '    :
!       (12) = 'QUANTUM   '  '          '                               :
!       (13) = 'PCF       '  'RDF       '  '          '                 :
!       (14) = 'DIPOLE    '  '          '                               :
!       (15) = 'CENTER    '  'CENTRE    '  'CENTERING ' '          '    :
!       (16) = 'NO(MV)=0  '  'Am(MV=0)  '                               :
!       (17) = 'CRYSTAL   '  'AMORPHOUS '                               :
!       (18) = 'BINARY    '  '          '                               :
!       (19) = 'PRESSURE  '                                             :
!       (20) = 'ELEC.FIELD'                                             :
!       (21) = 'GRAVITY   '                                             :
!       (22) = 'CONSTSHEAR'                                             :
!       (23) = 'DIATOMIC  '                                             :
!       (24) = 'CUBE      '                                             :
!       (25) = 'CONVEC    '                                             :
!       (26) = 'MOLECULE  '                                             :
!       (27) = 'EXCLUSION '                                             :
!       (28) = 'WALL      '                                             :
!       (29) = 'POLYATOMS '                                             :
!       (30) = 'STOPT     '  'POTSURF   '                               :
!       (31) = 'MOLPOL    '                                             :
!       (32) = 'GEN.WALL  '                                             :
!       (33) = 'EWALD-C   '                                             :
!       (34) = 'WATER-POL '                                             :
!       (35) = 'ISOLATED  '                                             :
!       (36) = 'EWALD-OPT '                                             :
!           ...                                                         :
!       (51) = 'THERMOSTAT'  '          '                               :
!       (52) = 'H-TENSOR  '  '          '                               :
!=======================================================================I
!               Contents of VAL(1) - VAL(LVA=64) variables              :
!  No.   : Meanings                                                     :
!  1     : Temperature                                              / K :
!  2     : Pressure                                               / GPa :
!  3-8   : Components of pressure tensor(xx,yy,zz,xy,xz,yz)       / GPa :
!  9     : Coulomb energy                                    / kJ.mol-1 :
!  10    : Short range energy                                / kJ.mol-1 :
!        :             (repulsion,van der Waals,Morse,etc.)             :
!  11    : Three body potential energy                       / kJ.mol-1 :
!  12    : Total potential energy (9+10+11)                  / kJ.mol-1 :
!  13    : Kinetic energy                                    / kJ.mol-1 :
!  14    : Total internal energy (9+10+11+13)                / kJ.mol-1 :
!  15    : PV (pressure x volume)                            / kJ.mol-1 :
!  16    : Enthalpy (14+15)                                  / kJ.mol-1 :
!  17    : Density                                             / g.cm-3 :
!  18    : Molar volume                                     / cm3.mol-1 :
!  19-21 : Basic cell parameters: A, B, C                            /A :
!        :               (Crystal unit cell (a,b,c) in XD)              :
!  22-24 : Cell angles  cos(alpha), cos(beta), cos(gamma)               :
!  25-44 : Temperatures of ion species (20 components)              / K :
!  45-64 : Mean square displacement (20 components)               / A^2 :
!=======================================================================I
!
module param
  implicit none
    integer(4),parameter:: LNI=32109, LTB=10004, LEL=10, LEM=20
    integer(4),parameter:: LCT=5000000, LSR=1254, LEE=LEL*(LEL+1)/2
    integer(4),parameter:: L50=LCT/50+1,LAA=172, LNV=500000, LST=32
    integer(4),parameter:: LEF=LEM*(LEM+1)/2, LAT=LAA*4, LVA=24+LEM*2
    integer(4),parameter:: L3P=20, LRG=LNI*5, L3R=300
!
    real(8),parameter:: PI  = 3.14159265357D0
    real(8),parameter:: PI180 = 180.0D0/PI
    real(8),parameter:: ANA = 6.0221367D23    !Avogadro const. / mol-1
!    real(8),parameter:: AKB = 1.380658D-23    !Boltzmann const. /J K-1
    real(8),parameter:: AKB = 1.380658D-16    !Boltzmann const. /erg K-1
    real(8),parameter:: AHP = 6.6260755D-27   !Plank const. /erg s
    real(8),parameter:: EP0 = 8.854187817D-12 !Permittivity of vacuum /F m-1
    real(8),parameter:: CVL = 2.99792458D10   !velocity of light in vacuum /cm s-1
    real*8, parameter:: ELCC = 1.602176462D-19 ! elementary charge C
    real(8),parameter:: ELC = ELCC*CVL*0.1D0 !elementary charge /C esu 
!                                                        CVL usually 3D8 then ELC = e*CVL*10.0D0
    real(8),parameter:: CAL = 4.18605D0       !Converstion from calory to joule
    real(8),parameter:: PI2 = 2.0D0*PI
    character *1, parameter:: ins(1:20) = (/ '1','2','3','4','5','6','7','8','9',&
                                             'A','B','C','D','E','F','G','H','I','J','K' /)
end module
module charac
  use param
  implicit none
    character(len=4):: TITLE(15),ATOM(LEM),ATMNET(2),ATMXTL(LAA)
    character(len=10):: RUNOPT(56)
    character(len=16):: FLNAME(19)
end module
module timdat
  implicit none
    integer(4) KKTIME(7,2)
end module
module counts
  implicit none
    integer*4 NJOB(2),IRECRD(9),NRECRD(9),IHISTR(4,111)
    real*8 PVMULT
end module
module temprs
  implicit none
    real*8 DTIME,TEMP,DELTMP,TMPGET,TINT,TPRE,STEMP(4),VSTEMP(4) !Nose-Hoover
    real*8 STEMP2,STEMP3,STEMP4,KBT  !Nose-Hoover
    real*8 TDUMP,SPRES(3),PPXYZ(7),FJMOL,PXYZ(7),DTMO
    integer*4 NTSTEP,nfnose  !Nose-Hoover
end module
module aboxof
  implicit none
    real*8 BOX(6),VBOX(6),VOL,DENSTY,VIRM(6),RCUT(2)
    integer*4 NRCUT(2),MXCUT,NFORML,IAXCEN
end module
module atomsi
  use param
  implicit none
    real*8 P(3,LNI),V(3,LNI),VP(3,LNI),P0(3,LNI),PPP(3,LNI)
    real*8 UI(LNI),AU(LNI),AV3BP(2,L3P),UIC(LNI),PP0(3,LNI) ! Nose-Hoover
    real*8,save :: UICP1(LNI) = 0.0D0, UICP2(LNI) = 0.0D0, UICP3(LNI) =0.0D0, UICP4(LNI) = 0.0D0
    integer*4 NTION,NION(LEM),IONS(2,LEM),NCOMPO,Iam,ICD
    integer*4 NTIOND, NIOND(LEM),IOND(LNI),NPAIR,IION(LEM)
end module
module paramt
  use param
  implicit none
    real*8 AIO(LEM),BIO(LEM),CIO(LEM),DIO(LEM),ZIO(LEM)
    real*8 AIJ(LEF),BIJ(LEF),CIJ(LEF),DIJ(LEF),D4IJ(LEF)
    real*8 PLIJ(LEF),RSWTCH(LEF),ZIJ(LEF),D7IJ(LEF)
    real*8 ECORR,VCORR,WIO(LEM),TWEGHT,AKFI(LEM)
    real*8 ANG3BP(L3P),R3BLIM(2,L3P)
    real*8 FK3BP(L3P),R3BGRD(2,L3P),r3limax
    integer*4 I3BP(L3P),J3BP(L3P),K3BP(L3P),N3BP,ncharge
end module
module tables
  use param
  implicit none
    real*8 F1(LSR,LEE),E1(LSR,LEE),F0(LTB),E0(LTB)
end module
module geomet
  use param
  implicit none
    real*8 DTO(2),AVTHT(12),RTO(2),SVTHT(12),ANGL(3,12),TTAB(LST)
    integer*4 MBR(6,6,2),NRG(9,2),ITBR(121,12),NBR(6,6,2),MEB(9,2)
    integer*4 NTT(121,12),NTO(2),NVTHT(12),NTBL
end module
module vector
  use param
  implicit none
    real*8 FNV(LNV),UNV(LNV),PNV(6,LNV),ZIA(LEM),UCSELF,ZIIA(LNI),UCCOR
    real*8 ALPHA,UCSLFI(15),ZIIC(LNI)
    integer*4 MODE,NVN,NVEC(3,LNV)
end module
module values
  use param
  implicit none
    real*8 TVAL(LVA),SVAL(LVA),TVALL(LVA),SVALL(LVA),VALMAX(LVA)
    real*8 VALMIN(LVA),VAL0(LVA),VAL(LVA),AVA(LVA,L50)
    integer*4 NAV,NAVT
end module
module forces
  use param
  implicit none
    real*8 FX(LNI),FY(LNI),FZ(LNI)
end module
module radial
  use param
  implicit none
    integer*4 NRDF(LTB,LEE),IPRDF(2)
end module
module acoord
  use param
  implicit none
    real*8 BOXO(6),P0C(3,LAT),PPC(3,LAT),RS(3,3,96),PPS(3,LAT)
    integer*4 NPT,NIU(LAA),NSYM,ISYM(LNI),NPTP,NBOX(3),JON(LAT)
    integer*4 MATM,IHEX
end module
module wallp
  implicit none
    real*8 WALLa, WALLb
end module
module cartes
  use param
  implicit none
    real*8 H(3,3),HINV(3,3),FTOQ(3,3),RBOX(6),G(3,3),GINV(3,3)
    real*8 TRANSX(8),TRANSY(8),TRANSZ(8)
!T    real*8 Q(3,LNI),Q0(3,LNI)
end module
module molecu
  use param
  implicit none
    double precision ZMOLE(2),DMOLE(4,LNI),DINTRA
    integer(KIND=4) :: NDMOLE = 0,IDMOLE(3,LNI),IATOM2(2),MOLstart(2)
    integer(KIND=4) NMOLE,IMOLE(11,LNI),MOLend(2)
    integer(KIND=4) MMOLE(LNI)
    integer(KIND=4) IATOMO,IATOMH,ITER,ITERSH,NIONO
    integer(KIND=4):: istart = 0
    double precision, allocatable, save ::  HHX(:),HHY(:),HHZ(:),HHV(:)
    double precision, allocatable, save ::  OPX(:),OPY(:),OPZ(:),OPV(:)
    double precision, allocatable, save ::  LOP1X(:),LOP1Y(:),LOP1Z(:)
    double precision, allocatable, save ::  roh1(:),roh2(:),A1(:),A2(:)
    double precision, allocatable, save ::  DPV(:),DPX(:),DPY(:),DPZ(:)
    double precision, allocatable, save ::  DPX1(:),DPX2(:),DPY1(:),DPY2(:),DPZ1(:),DPZ2(:)
    double precision, allocatable, save ::  UDPX1(:),UDPX2(:),UDPY1(:),UDPY2(:),UDPZ1(:),UDPZ2(:)
    double precision, allocatable, save ::  QLP1(:),QLP2(:),QLP1z(:),QLP2z(:),QLPx(:)
    double precision, allocatable, save ::  QHHk(:),QHHm(:)
    double precision, allocatable, save ::  E34(:),idipX(:,:),idipY(:,:),idipZ(:,:)
    double precision, allocatable, save ::  pdipX(:),pdipY(:),pdipZ(:),Edp1(:),Edp2(:)
    double precision, allocatable, save ::  idp2(:),watpol(:,:)
    integer(KIND=4), allocatable, save ::ih2o(:,:)
    double precision, save ::  upol,THRESHD,maxedip,sumedip,dampp
    real(8),parameter:: DIP = 4.803204D0      !used for dipole moment
    real*8, parameter:: DEBYE = 1.0D-19/CVL ! 1*DEBYE Cm = 1 D = 1e-18 esu cm
    real(8),parameter:: POL = 4.0D0*PI*EP0*1.D-17/ELCC**2       !used for polarizability
    real(8),parameter:: EPOL  = 4.0D0*PI*EP0*1.0D-27/ELCC  ! used for UPOL
    real(8),parameter:: EPOLL = 4.0D0*PI*EP0*1.0D-30
!    real(8),parameter:: WATPOLHH = 1.47D0, WATPOLLP = 1.47D0, WATPOLDP = 1.47D0   ![Angstrom^3]
    real *8,parameter:: WATPOLLP = 1.44D0, WATPOLDP = 1.90D0
    double precision, parameter:: EPOLLL = ELCC**2/(4.0D0*PI*EP0*1.0D-25) !for dyn
    real *8 RD,DLP
    double precision,parameter ::GEb = 3.13885D-10, Emb=7.57695D9 !C/N and N/C
    double precision,parameter ::GEb_pol = GEb/(ELCC*1.0D-3), Emb_pol = Emb*ELCC*1.0D-3
    double precision,parameter ::Ediv = 1.00D10*ELCC*1.0D-3, DMAX = 2.8D0-1.87D0
    double precision,parameter ::ECOFF = DEBYE/EPOL
end module
module pmorse
  use param
  implicit none
    real*8 DMIJ(LEF),BEIJ(LEF),RSIJ(LEF),DM1IJ(LEF),BE1IJ(LEF)
    real*8 DM2IJ(LEF),BE2IJ(LEF)
    double precision CIJK(L3P)  !Vashishta potential
end module
module boxcng
  implicit none
  real*8 BTAGET,BCNGR
  integer*4 ICAXIS
end module
module quanco
  use param
  implicit none
  real *8 Q1U1(LSR,LEE),Q2U1(LSR,LEE)
  real *8 TQCE, QCEE,QCIT,QCEF,TEMPQH,TEMPQQ
end module
module outerf
  implicit none
  real *8 EFD(3),EFREQ,GFD(3),fconvc
  integer *4 MEFD,NATOM
end module
module exclus
  implicit none
  real *8 rexcl, fexcl
  integer *4 iaex, iextype
end module
module datoms
  implicit none
  real *8 D1ATOM(500),D1AXYZ(3,500),D2ATOM(500),D2AXYZ(3,500)
  integer *4 N1ATOM,I1ATOM(500),N2ATOM,I2ATOM(500)
end module
module charge  ! WATER-POL
  use param
  implicit none
  real *8 ZII(LNI),ZICOS(LNI),ZISIN(LNI),ZIIP(LNI)
end module
module pos
  use param
  implicit none
  real *8 PX(LNI),PY(LNI),PZ(LNI)
end module
module ewal
  use param
  implicit none
  real *8 PRSTC2(6),VIRLSR
  integer *4 iaxis,JJJ,KRDF
end module
module struct
  use param
  implicit none
  real *8 DONB(6,LNI)
  integer *4 IONB(6,LNI),lentab
end module
!
PROGRAM  MXDORTHO
!
  use param
  use charac
  use timdat
!
  implicit none
!
  INTEGER *4      IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  integer *4      i
!
                    FLNAME(1)  = 'MD-XD-ORTHO    '
!                   FLNAME(1)  = 'MD-XD-TRICL    '
                    FLNAME(2)  = '2025-11-20-00  '
!                   ----------------------------------------- Select one
                    FLNAME(3)  = 'F90            '
!                   FLNAME(3)  = 'Dummy          '
!                   ----------------------------------------------------
                    FLNAME(4)  = '               '
                    FLNAME(5)  = 'file05.dat     '
                    FLNAME(6)  = 'file06.dat     '
                    FLNAME(7)  = 'file07.dat     '
                    FLNAME(8)  = 'file08.dat     '
                    FLNAME(18) = 'file081.dat    '
                    FLNAME(9)  = 'file09p.dat    '
                    FLNAME(10) = 'file10.dat     '
                    FLNAME(11) = 'file09v.dat    '
                    FLNAME(12) = 'file09pv.dat   '
                    FLNAME(13) = 'file11.dat     '
                    FLNAME(14) = '               '
                    FLNAME(15) = '               '
                    FLNAME(16) = 'charge.dat     '  !WATER-POL
                    FLNAME(17) = 'potensurf.dat  '
                    FLNAME(19) = 'tempo.dat      '
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
                     KKTIME(1,1) = IYEAR
                     KKTIME(2,1) = IMONTH
                     KKTIME(3,1) = IDAY
                     KKTIME(4,1) = IHOUR
                     KKTIME(5,1) = IMINUT
                     KKTIME(6,1) = ISECND
                     KKTIME(7,1) = I100TH
                     DO I = 1, 7
                        KKTIME(I,2) = KKTIME(I,1)
                     enddo
!
      WRITE(*,'("Welcome to MOLECULAR DYNAMICS SIMULATION WORLD: ", a11," Version ", a11)') &
           FLNAME(1), FLNAME(2)
!
      CALL  MDMAIN
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
      WRITE (*,9898)  INT(KKTIME(4,1)),INT(KKTIME(5,1)),INT(KKTIME(6,1)),&
                      INT(KKTIME(2,1)),INT(KKTIME(3,1)),IHOUR,IMINUT,ISECND,IMONTH,IDAY
 9898 FORMAT (/ 3X,73('=') / 4X, &
                '===== Started at ',I2,':',I2,':',I2,' on ',I2,'/',I2, &
                   ', finished at ',I2,':',I2,':',i2,' on ',I2,'/',I2, &
                ' =====' / 3X,73('=') )
      stop
      END
!
!                                                               ========
!================================================================ MDMAIN
SUBROUTINE  MDMAIN
  use param
  use charac
  use timdat
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use vector
  use values
  use forces
  use radial
  use acoord
  use wallp
!
  implicit none
!
  COMMON /ANIPAR/ FCUT,FFAC, Tmin, NNSYM,mstep
        REAL *8   FCUT,FFAC,Tmin
        integer*4 NNSYM,mstep
!
    INTEGER *4      IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
    integer *4      inoend,i,AJDG,nn,mm,j
    CHARACTER  *3   ORDNL1, ORDNL2, ORDNLS(4)
    DATA            ORDNLS / '-st', '-nd', '-rd', '-th' /
!
!   ----------------------------------- Open file05.dat and file06.dat
!   OPEN   (*, FILE='CON:')
!
    OPEN (15, FILE=FLNAME(5), STATUS='OLD',  &
              ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    OPEN (16, FILE=FLNAME(6), STATUS='UNKNOWN', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
!
!   ----------------------------- Enter subroutine for initial setting
 1111 CALL  INITIA  (INOEND)
        IF (INOEND    < 0)  GO TO 9999
        IF (IRECRD(2) <= 0)  GO TO 8888
        IF (IRECRD(1) <= 0)  GO TO 8888
      NRECRD(3) = 0
!
      WRITE  (*,4002)  (I,RUNOPT(I),I=1,54)
 4002 FORMAT ('Option[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']')
      ORDNL1 = ORDNLS(4)
      IF (MOD(NRECRD(1)+1,10) == 1)  ORDNL1 = ORDNLS(1)
      IF (MOD(NRECRD(1)+1,10) == 2)  ORDNL1 = ORDNLS(2)
      IF (MOD(NRECRD(1)+1,10) == 3)  ORDNL1 = ORDNLS(3)
      ORDNL2 = ORDNLS(4)
      IF (MOD(IRECRD(1),10) == 1)  ORDNL2 = ORDNLS(1)
      IF (MOD(IRECRD(1),10) == 2)  ORDNL2 = ORDNLS(2)
      IF (MOD(IRECRD(1),10) == 3)  ORDNL2 = ORDNLS(3)
!
      IF (RUNOPT(30)  ==  'POTSURF   ')THEN
        CALL POSURF
        GO TO 9999
      ENDIF
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      WRITE  (*,4001)  IHOUR,IMINUT,ISECND, IYEAR,IMONTH,IDAY, &
                       NRECRD(1)+1,ORDNL1,IRECRD(1),ORDNL2
 4001 FORMAT ('Started at ',I2,':',I2,':',I2,' on ',I4,'/',I2,'/',I2, &
               3X,'from ',I5,A3,' step, until ',I6,A3,' step')
      IF (RUNOPT(31)  ==  'MOLPOL    ')THEN
        OPEN (38, FILE = FLNAME(18), STATUS = 'UNKNOWN', &
              ACCESS = 'SEQUENTIAL', FORM = 'FORMATTED')
          WRITE(38,'(a10,1x,a10,1x,a10)') 'Ax(cm^3)','Ay(cm^3)','Az(cm^3)'
      ENDIF
!
      Tmin = 10000.0D0   !STOPT
!              ===============================================
!     ============== Start of a series of MD calculation ==============
!     ======                                                     ======
 5555                     NRECRD(3) = NRECRD(3) + 1
                          NRECRD(1) = NRECRD(1) + 1
                          IRECRD(6) = IRECRD(6) + 1
              IF (NRECRD(3) == 1.OR. &
                  MOD(NRECRD(1),IRECRD(3)) == 1 .or. &
                  IRECRD(3) == 1)  CALL CLEARS
              IF (RUNOPT(30)  /=  'STOPT     ') CALL  NEWTON
              IF (RUNOPT(30)  ==  'STOPT     ') CALL STOPT (AJDG)
              CALL  RECORD9
              IF (IRECRD(1) == 1)                 GO TO 8888
              IF (MOD(NRECRD(1),IRECRD(3)) /= 0)  GO TO 7777
                     CALL  INTVAL
                     CALL  STRCTR  (0)
                             NN = IRECRD(2)/IRECRD(3)
                             MM = MOD(NRECRD(1)/IRECRD(3), NN)
                     IF (MOD(MM,2) == 0 .AND. &
                         MOD(NRECRD(1),IRECRD(2)) == 0)  THEN
                            IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
                                   CALL  COORDN
                            END IF
                                   CALL  PCFRCN
                                   CALL  POTPLT
                     END IF
                     CALL  F07F08  (1)
 7777         IF (RUNOPT(30)  /=  'STOPT     ' .AND.  &
                  NRECRD(1) < IRECRD(1))  GO TO 5555
              IF (RUNOPT(30)  ==  'STOPT     ' .AND.  &
                  AJDG  /=  0 .AND. NRECRD(1)  &
                   <  IRECRD(1)) GO TO 5555 
!     ======                                                     ======
!     ============== End of the series of MD calculation ==============
!              ===============================================
!
      IF (RUNOPT(30) == 'STOPT     ') then 
        write(*,'("Minimum energy = ", E12.5, " step: ", I7)') Tmin, mstep
      ENDIF
      IF (RUNOPT(26) ==  'MOLECULE  ') call MOLECULE
      CALL  TITLET  (1, 0)
      CALL  SUMMRY
 8888 CONTINUE
      CALL  STRCTR  (1)
      CALL  TITLET  (0, 0)
!
      IF (RUNOPT(11) /= '          ') THEN
          IF (RUNOPT(18) == 'BINARY    ') THEN
              WRITE (28)  -9999, 0.0, 0.0, 0.0, 0.0, 0.0, &
                                0.0, 0.0, 0.0, 0.0
          ELSE
              WRITE (28,'(I7,3x,9F7.3)')  -9999, 0.0, 0.0, 0.0, 0.0, 0.0, &
                                     0.0, 0.0, 0.0, 0.0
          ENDIF
          ENDFILE 28
          CLOSE (28)
      END IF
      IF (RUNOPT(19) == 'PRESSURE  ') THEN
             WRITE (27,'(7F9.4)')  (999.9999,J=2,8)
             CLOSE (27)
      END IF
!
      GO TO 1111
!
!     --------------------------------------------------------- Finish !
 9999        ENDFILE  16
             REWIND   16
             CLOSE   (16)
!
             IF (TITLE(1) /= 'BENC'     .OR. &
                 TITLE(2) /=     'HMAR'     )  THEN
                    ENDFILE  29
                    ENDFILE  19
                    REWIND   29
                    REWIND   19
                    CLOSE   (29)
                    CLOSE   (19)
             END IF
             IF (RUNOPT(31) ==  'MOLPOL    ') CLOSE(38)
             IF (RUNOPT(34) ==  'WATER-POL ') CLOSE(26)
      return
      END
!
!
!                                                               ========
!================================================================ TITLET
SUBROUTINE  TITLET  (ID,JD)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use radial
!
  implicit none
!
      INTEGER *4     IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer *4     ID,JD,I,J,N,K,L
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
!
!                                OUTPUT HISTRY OF THE SYSTEM
      IF (ID == 0)  THEN
             IF (JD == 0)  WRITE (16,1001)
             WRITE (16,'("I",130("="),"I")')
             WRITE (16,2001)
             DO I = 1, NRECRD(6), 5
                     J = I + 4
                 IF (J > NRECRD(6))  J = NRECRD(6)
                 N = J - I + 1
                 IF (N == 1) WRITE (16,2221)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 2) WRITE (16,2222)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 3) WRITE (16,2223)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 4) WRITE (16,2224)((IHISTR(K,L),K=1,4),L=I,J)
                 IF (N == 5) WRITE (16,2225)((IHISTR(K,L),K=1,4),L=I,J)
             enddo
      ELSE
             IF (ID == 1)                WRITE (16,1001)
             IF (ID == 0.AND.JD /= 1)    WRITE (16,1001)
      END IF
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      WRITE (16,1111)                 SPRES(1),IHOUR,IMINUT,ISECND, &
                      NJOB,TITLE,TEMP,SPRES(2), &
                                      SPRES(3),IYEAR,IMONTH,IDAY
      RETURN
!
 1001 FORMAT (1X)
 1111 FORMAT ('I',130('='),'I'                                          &
             /'I',10X,       '  :   ',60X, '   :', 12X,      F12.4,     &
                                  7X,':   at  ',I2,':',I2,':',I2,'   I' &
             /'I',I5,' -',I3,'  :   ',15A4,'   :',F10.1,' K',F12.4,     &
                                                 ' GPa   :',18('-'),'I' &
             /'I',10X,       '  :   ',60X, '   :', 12X,      F12.4,     &
                                  7X,':   on  ',I2,'/',I2,'/',I2,'   I' &
             /'I',130('='),'I' )
 2001 FORMAT ('I',6X, '<<<<< History of this system >>>>>', 5X, &
                 '< No. of steps >---< Temperature / K >---< Pressure ', &
                 '/ GPa >---< Date (yymmdd) >',6X,'I')
 2221 FORMAT ('I ',I7,I5,I3,I7,5X, 99X, '   I')
 2222 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,5X, 73X, '   I')
 2223 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,5X, I6,I5,I3,I7,5X,47X, '   I')
 2224 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,4X, I7,I5,I3,I7,4X,I7,I5,I3,I7, 26X, '   I')
 2225 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,4X, I7,I5,I3,I7,4X,I7,I5,I3,I7,4X, &
               I7,I5,I3,I7,'   I')
      END
!
!
!                                                               ========
!================================================================ F07F08
SUBROUTINE  F07F08  (INOEND)
  use param
  use charac
  use timdat
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use values
  use radial
  use acoord
  use charge
  use molecu
!
  implicit none
!
!
      integer    *4   INOEND
      REAL       *8   H(3,3),RRD,V10(3,LNI)
      CHARACTER  *10  RUNO18, RUNO19
      CHARACTER  *4   TITLE0(15), BIN
      CHARACTER  *1   DEFECT, ANS
      integer    *4   iform7
      INTEGER    *4   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer    *4   I,J,NCUT0,N,K,KHIST,IO,icstep,nstep
!
      IF (INOEND == 1)  GO TO 501
!     --------------------------------------------- Read from FILE07.DAT
!                         system description, coordinates and velocities
      iform7 = 0
      ICD = 0   ! no charge.dat file  WATER-POL
!
      OPEN (17, FILE=FLNAME(7), STATUS='OLD',  &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      READ (17,7007) TITLE0, NJOB, BIN, ICD, ndmole, RRD,&  ! WATER-POL
                     NTION, NCOMPO, (NRECRD(I),I=1,9)
!
      IF (NTION > LNI) THEN
        WRITE (*,*) 'Error: No. of ions (', NTION, ') is too large (LNI=', LNI, ') !!!'
        STOP
      END IF
      IF (NCOMPO > LEL) THEN
        WRITE (*,*) 'Error: No. of ion species (',NCOMPO,') is too large (LEL=',LEL,') !!!'
        STOP
      END IF
                          RUNOPT(18) = '          '
      IF (BIN == 'BIN ')  RUNOPT(18) = 'BINARY    '
!
      READ (17,7017) (ATOM(I),I=1,NCOMPO)
      READ (17,7018) (NION(I),I=1,NCOMPO)
      READ (17,7018) (IONS(1,I),I=1,NCOMPO)
      READ (17,7018) (IONS(2,I),I=1,NCOMPO)
      READ (17,7070) TEMP, DELTMP,TMPGET, SPRES, &
                     DTIME,  RUNOPT(51),  BOX,   &
                     DENSTY, RUNOPT(52), VBOX
      IF (RUNOPT(51) == 'THERMOSTAT')  READ (17,7080) STEMP, VSTEMP
      IF (RUNOPT(52) == 'H-TENSOR  ')  THEN
        DO I = 1, 3
          READ (17,7080)  (H(I,J),J=1,3)
        enddo
      END IF
!
      if (iform7 == 0) then
        WRITE (*,1177) TITLE0, TITLE
 1177   FORMAT (6X,14('='),' Titles in FILE07.DAT and FILE05.DAT are ', &
                   14('=') /  '=====[F7]: ',15A4,' =====' / &
                              '=====[F5]: ',15A4,' =====' )
      end if
!
!T    ------------------- delete this block-if in case of oblique system
      IF (BOX(4)**2+BOX(5)**2+BOX(6)**2 > 1.E-6)  THEN
        WRITE (*,*) 'Error: The box shape is not suitable for MXDORTO !!!'
        WRITE  (*,'("   BOX(4 to 6) are ",3F12.7)') BOX(4),BOX(5),BOX(6)
        WRITE (*,*) 'Is it posibble to change BOX(4), BOX(5), and BOX(6) as zero?  (y/n)'
        READ  (*,'(a1)') ANS
        IF (ANS == 'n' .OR. ANS == 'N')  STOP
          BOX(4) = 0.0
          BOX(5) = 0.0
          BOX(6) = 0.0
        END IF
!
      IF (NTION > LNI)  WRITE (*,*) 'The number of atoms :',NTION, 'is greater than LNI:',LNI
!          write (6,*)  'read atoms'  !//////////
      NTIOND = 0
      DO I = 1, NTION
        IOND(I) = 1
!        if (iform7 == 0 ) then
!          READ (17,7700,err=7878) (P(J,I),J=1,3), &
!                DEFECT, (V10(J,I),J=1,3), (P0(J,I),J=1,3)
!        else
          READ (17,7702,err=7878) (P(J,I),J=1,3), &
                 DEFECT, (V10(J,I),J=1,3), (P0(J,I),J=1,3)
!        end if
!         write (6,*)  i,p(1,i),p(2,i),p(3,i) !/////////////
!         write(6,*)i,abs(V10(1,i)-5)+abs(V10(2,i)-5)+abs(V10(3,i)-5)
!        if (abs(V10(1,i)-5.0)+abs(V10(2,i)-5.0)+abs(V10(3,i)-5.0)  >  3.0 ) then
!                write (6,*) i,'-th atom is strange'
!          iform7 = 1
!          rewind 17
!          go to 7
!        end if
        IF (DEFECT /= ' ') THEN
          IOND(I) = 0
          NTIOND  = NTIOND + 1
          V10(1,I) = 0.0D0
          V10(2,I) = 0.0D0
          V10(3,I) = 0.0D0
        END IF
        DO J = 1, 3
          V(J,I) = (V10(J,I)-5.0D0) * 0.1D0
        enddo
      enddo
      IF (NTIOND > 0) WRITE (*,'(1X,I6," DEFECTS WERE DETECTED ")') NTIOND
      IF (NRECRD(6) > 0) THEN
        READ (17,7800,END=180,ERR=180)  ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
        GO TO 190
  180   NRECRD(6) = 0
  190 END IF
      IRECRD(6) = 0
      CLOSE  (17)
!      if (iform7 == 0) write (6,*) 'Format of file07.dat will be converted.'
!
      IF (RUNOPT(2) == 'RESTART   ')  THEN
        RUNOPT(2) = 'START     '
        NRECRD(6) = 0
        DO I = 1,NTION
          DO J = 1, 3
            P(J,I) = P0(J,I)
          enddo
        enddo
      END IF
!     ========================================================= charge.dat !WATER-POL
      IF (ICD == 1) then ! FLNAME(16) = 'charge.dat     '
        nstep = ntion + ndmole
        open (26, FILE=FLNAME(16), status ='old', access='sequential', form='formatted')
260       read (26,'(i10)',end=261,err=261) icstep
          read (26,'(10(F7.4,1x))') (ZII(i),i=1,nstep)
!          write (*,'(i10)') icstep
!          write (*,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
          goto 260
261       if (RUNOPT(2) == 'START     ') then
            rewind(26)
            write (26,'("         0")')
            write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
          endif
      ENDIF
!     ======================================================================
!
      NBOX(1) = 1
      NBOX(2) = 1
      NBOX(3) = 1
      IF (RUNOPT(17) == 'CRYSTAL   ')  CALL  FILE10
!
      IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
!                               'BENC' & 'HMAR' means 'BENCHMARK': file09 no open
!                               file09p.dat : COORDINATES AT EACH 5 STEP
        OPEN (19, FILE=FLNAME(9), STATUS='UNKNOWN', &
                  ACCESS='SEQUENTIAL', FORM='FORMATTED' )
!                                    file09v.dat : VALUES AT EACH 5 STEP
        OPEN (29, FILE=FLNAME(11), STATUS='UNKNOWN', &
                  ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      END IF
!
      IF (RUNOPT(2) == 'CONT.     '.OR.RUNOPT(2) == 'CONTINUE  ')  THEN
        NJOB(2) = NJOB(2) + 1
!       ----------------------------------- Read from FILE08.DAT
!                                           PCF, properties, etc.
        OPEN (18, FILE=FLNAME(8), STATUS='OLD', &
                  ACCESS='SEQUENTIAL', FORM='FORMATTED' )
          REWIND  18
          READ (18,8001) NCUT0,NRCUT(1),NRECRD(2),NAV,NAVT,NTBL,MXCUT,NPAIR
          DO J = 1, LEE
            DO N = 1, LTB
              NRDF(N,J) = 0
            enddo
          enddo
          DO I = NCUT0, NRCUT(1)
            READ (18,8001) (NRDF(I,J),J=1,NPAIR)
          enddo
          DO I = 1, LVA
            READ (18,8003) TVAL(I),SVAL(I),SVALL(I),VAL0(I)
          enddo
!          DO I = 1, NAV
!            READ (18,8003) (AVA(J,I),J=1,LVA)
!          enddo
          READ (18,8003) (AU(I),I=1,NTION)
          DO I = 1, 12
            READ (18,8003) (ANGL(J,I),J=1,3)
          enddo
          DO K = 1, 2
            DO J = 1, 6
              READ (18,8001) (MBR(I,J,K),I=1,6)
            enddo
          enddo
          DO J = 1, 2
            READ (18,8001) (NRG(I,J),I=1,9)
          enddo
          DO I = 1, 121
            READ (18,8005) (ITBR(I,J),J=1,12)
          enddo
          IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
            READ (18,8004) ((PPC(J,N),J=1,3),(PPS(J,N),J=1,3),N=1,NPT)
          END IF
        CLOSE  (18)
!
        OPEN (38, FILE=FLNAME(18), STATUS='OLD',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
          REWIND  38
          DO I = 1, NAV
            READ (38,8003) (AVA(J,I),J=1,LVA)
          enddo
        close  (38)
!
        CALL  FILE09
      ELSE
        NJOB(1) = NJOB(1) + 1
        NJOB(2) = 1
        NRECRD(4) = 0
        NRECRD(5) = 0
        IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
          REWIND  29
          REWIND  19
        END IF
      END IF
      RETURN
!
!     ========================================= Output file07 and file08
  501 NRECRD(6) = NRECRD(6) + 1
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      IHISTR(1,NRECRD(6)) = IRECRD(6)
      IHISTR(2,NRECRD(6)) = INT(TMPGET)
      IHISTR(3,NRECRD(6)) = INT((SPRES(1)+SPRES(2)+SPRES(3))/3.0)
      IHISTR(4,NRECRD(6)) = IYEAR*10000 + IMONTH*100 + IDAY
      IRECRD(6) = 0
      IF (NRECRD(6) > 1)  THEN
        KHIST = NRECRD(6) - 1
        IF (IHISTR(2,NRECRD(6)) == IHISTR(2,KHIST).AND. &
            IHISTR(3,NRECRD(6)) == IHISTR(3,KHIST))  THEN
          IHISTR(1,KHIST)=IHISTR(1,NRECRD(6))+IHISTR(1,KHIST)
          IHISTR(4,KHIST)=IHISTR(4,NRECRD(6))
          NRECRD(6) = KHIST
        END IF
      END IF
      IF (TITLE(1) == 'BENC'     .AND. TITLE(2) ==     'HMAR'     )  GO TO 699
!
      RUNO18 = '          '
      RUNO19 = '          '
!      IF (RUNOPT(5) == 'T NOSE    ')  RUNO18 = 'THERMOSTAT'
      IF (RUNOPT(34) == 'WATER-POL ') ICD = 1
!
!     ---------------------------------------------- Write on FILE07.DAT
!                         system description, coordinates and velocities
!
      OPEN (17, FILE=FLNAME(7), STATUS='UNKNOWN', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      REWIND 17
                                       BIN = '    '
      IF (RUNOPT(18) == 'BINARY    ')  BIN = 'BIN '
      WRITE (17,7007) TITLE, NJOB, BIN, ICD, ndmole, RD, & !WATER-POL
                      NTION, NCOMPO, (NRECRD(I),I=1,9)
      WRITE (17,7017) (ATOM(I),I=1,NCOMPO)
      WRITE (17,7018) (NION(I),I=1,NCOMPO)
      WRITE (17,7018) (IONS(1,I),I=1,NCOMPO)
      WRITE (17,7018) (IONS(2,I),I=1,NCOMPO)
      WRITE (17,7070) TEMP, DELTMP,TMPGET, SPRES, &
                      DTIME,  RUNO18, BOX, &
                      DENSTY, RUNO19, VBOX 
      IF (RUNO18 == 'THERMOSTAT')  WRITE (17,7080)  STEMP,VSTEMP
      do io = 1, ncompo
        DO I = ions(1,io), ions(2,io)
          DO J = 1, 3
            V10(J,I) = V(J,I) * 10.0D0 + 5.0D0
          enddo
          DEFECT = ' '
          IF (IOND(I) == 0)  DEFECT = '*'
          WRITE (17,7702) (P(J,I),J=1,3),DEFECT,(V10(J,I),J=1,3),(P0(J,I),J=1,3), io
        enddo
      enddo
      WRITE (17,7800) ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
      ENDFILE  (17)
      REWIND    17
      CLOSE    (17)
!
!       -------------------------------------------- Write on FILE08.DAT
!                                                  PCF, properties, etc.
      DO N = 1, NRCUT(1)
        DO J = 1, LEE
          IF (NRDF(N,J) > 0)  GO TO 513
        enddo
      enddo
  513 NCUT0 = N - 1
      NPAIR = NCOMPO * (NCOMPO+1) / 2
      OPEN (18, FILE=FLNAME(8), STATUS='UNKNOWN', &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
        REWIND  18
        WRITE (18,8001) NCUT0,NRCUT(1),NRECRD(2),NAV,NAVT,NTBL,MXCUT,NPAIR
        DO I = NCUT0, NRCUT(1)
          WRITE (18,8001) (NRDF(I,J),J=1,NPAIR)
        enddo
        DO I = 1, LVA
          WRITE (18,8003) TVAL(I),SVAL(I),SVALL(I),VAL0(I)
        enddo
!        DO I = 1, NAV
!          WRITE (18,8003) (AVA(J,I),J=1,LVA)
!        enddo
        WRITE (18,8003) (AU(I),I=1,NTION)
        DO I = 1, 12
          WRITE (18,8003) (ANGL(J,I),J=1,3)
        enddo
        DO K = 1, 2
          DO J = 1, 6
            WRITE (18,8001) (MBR(I,J,K),I=1,6)
          enddo
        enddo
        DO J = 1, 2
          WRITE (18,8001) (NRG(I,J),I=1,9)
        enddo
        DO J = 1, 121
          WRITE (18,8005) (ITBR(J,I),I=1,12)
        enddo
        IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
          WRITE (18,8004) ((PPC(J,N),J=1,3),(PPS(J,N),J=1,3),N=1,NPT)
        END IF
!
        ENDFILE  (18)
        REWIND    18
      CLOSE    (18)
!
        OPEN (38, FILE=FLNAME(18), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
          REWIND  38
          DO I = 1, NAV
              WRITE (38,8003) (AVA(J,I),J=1,LVA)
          enddo
          ENDFILE  (38)
          REWIND    38
        CLOSE    (38)
!
  699 WRITE (*,4001)  IRECRD(1)
 4001 FORMAT (15('='),'  Files were updated  ',12('='),'  End=',I7,2X,15('='))
      WRITE (*,'("<<<= ====  ",15A4,"  ====>>>")')  TITLE
      RETURN
!
 7878 write(*,*) 'File07.dat : error at the line ',i+9
      stop
!     -------------------------------------------- Formats of file07.dat
 7007 FORMAT (15A4,2I5, 1X,A4,1X,I4,1X,I9,1x, f9.6/ I7,I3, 9I10)
 7017 FORMAT (20(2X,A4) )
 7018 FORMAT (20I6 )
 7070 FORMAT (F10.2,F10.4,F10.2, 3F10.5 / &
              E10.3, A10, 6F10.6 / &
              F10.6, A10, 6F10.6 )
 7080 FORMAT  (10X,3F20.10)
! 7700 FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.6)
 7702 format (3F10.8, A1, 3F9.7, 1X, 3F10.6, 1x,i2)
 7800 FORMAT (3(I10,I5,I4,1X,I6))
!     -------------------------------------------- Formats of file08.dat
 8001 FORMAT (10I10)
 8003 FORMAT (1P5E16.9)
 8004 FORMAT (0P3F12.6,4X,3F12.6)
 8005 FORMAT (12I6)
      END
!
!
!                                                               ========
!================================================================ FILE09
SUBROUTINE  FILE09
  use param
  use charac
  use counts
  use atomsi
  use values
  use acoord
!
  implicit none
!
    COMMON /WORK02/ IP(3,LNI),  PP(3,LNI)
        integer *4 IP,PP
!
    REAL       *8   H(3,3), VALVAL(LVA)
    integer    *4   K,I,MMMMM,L,J
!
    IF (TITLE(1) == 'BENC' .AND. TITLE(2) == 'HMAR')  RETURN
!     --------------------------------------- Work file for continuation
      OPEN (22, FILE   = FLNAME(19),   STATUS = 'UNKNOWN',  &
                ACCESS = 'SEQUENTIAL', FORM   = 'FORMATTED' )
!
!               -------------------------------------------- FILE09V.DAT
! 1991   FORMAT (F8.2, 7F8.4  / 8F9.2  / F9.5,  F9.3,  3F9.5, 3F9.6  / 10F8.2 / 10F8.3 )
 1991    FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.7 / 20F9.3 / 20F9.3 )
        REWIND  29
        REWIND  22
        DO K = 1, NRECRD(5)
          READ  (29,1991)  (VALVAL(I),I=1,LVA)
          WRITE (22,1991)  (VALVAL(I),I=1,LVA)
        enddo
        ENDFILE  22
        REWIND   29
        REWIND   22
        DO K = 1, NRECRD(5)
          READ  (22,1991)  VALVAL
          WRITE (29,1991)  VALVAL
        enddo
!
!         -------------------------------------------------- FILE09P.DAT
      IF (RUNOPT(18) == 'BINARY    ')  THEN
        CLOSE (22)
        OPEN (22, FILE   = FLNAME(19),   STATUS = 'UNKNOWN', &
                  ACCESS = 'SEQUENTIAL', FORM   = 'UNFORMATTED' )
      END IF
      MMMMM = NTION
      IF (RUNOPT(17) == 'CRYSTAL   ')  MMMMM = NPTP
      REWIND  19
      REWIND  22
      IF (RUNOPT(18) == 'BINARY    ') THEN
        DO K = 1, NRECRD(4)
          READ  (19)  L,  H
          READ  (19)  ((PP(J,I),J=1,3),I=1,MMMMM)
          WRITE (22)  L,  H
          WRITE (22)  ((PP(J,I),J=1,3),I=1,MMMMM)
        enddo
        REWIND   19
        REWIND   22
        DO K = 1, NRECRD(4)
          READ  (22)  L,  H
          READ  (22)  ((PP(J,I),J=1,3),I=1,MMMMM)
          WRITE (19)  L,  H
          WRITE (19)  ((PP(J,I),J=1,3),I=1,MMMMM)
        enddo
      ELSE
        DO K = 1, NRECRD(4)
          READ  (19,'(I7,3X, 9F7.3)')  L,  H
          READ  (19,'(18I5)')  ((IP(J,I),J=1,3),I=1,MMMMM)
          WRITE (22,'(I7,3X, 9F7.3)')  L,  H
          WRITE (22,'(18I5)')  ((IP(J,I),J=1,3),I=1,MMMMM)
        enddo
        REWIND   19
        REWIND   22
        DO K = 1, NRECRD(4)
          READ  (22,'(I7,3X, 9F7.3)')  L,  H
          READ  (22,'(18I5)')  ((IP(J,I),J=1,3),I=1,MMMMM)
          WRITE (19,'(I7,3X, 9F7.3)')  L,  H
          WRITE (19,'(18I5)')  ((IP(J,I),J=1,3),I=1,MMMMM)
        enddo
      END IF
!
      CLOSE (22)
      RETURN
      END
!
!                                                               ========
!================================================================ FILE10
SUBROUTINE  FILE10
  use param
  use charac
  use aboxof
  use atomsi
  use acoord
!
  implicit none
!
  CHARACTER  *4   HEX
  integer    *4   J, N, I
!
! ------------------------------ Input file of xtal geometry
  OPEN (10,FILE=FLNAME(10),STATUS='OLD',ACCESS='SEQUENTIAL',FORM='FORMATTED')
    REWIND  10
    READ (10,5010)  BOXO,NBOX,NPT,NPTP,NSYM,HEX,MATM
    READ (10,'(18A4)')  (ATMXTL(J),J=1,MATM)
    READ (10,'(18I4)')  (NIU(J),J=1,MATM)
    READ (10,'(I5,3F10.7)')  (JON(N),(P0C(J,N),J=1,3),N=1,NPTP)
    READ (10,'(9F6.1)')  (((RS(J,I,N),J=1,3),I=1,3),N=1,NSYM)
    READ (10,'(12I6)')  (ISYM(N),N=1,NTION)
    REWIND  10
  CLOSE  (10)
  IHEX = 0
  IF (HEX == 'HEX ')  IHEX = 1
  RETURN
 5010         FORMAT (3F10.7,3F10.8 / 6I5,5X,A4,I6 )
END
!
!                                                               ========
!================================================================ INITIA
SUBROUTINE  INITIA  (INOEND)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use vector
  use values
  use radial
  use wallp
  use molecu
  use boxcng
  use outerf
  use exclus
  use struct
  use charge
  use ewal
!
  implicit none
!
!     -------------------------------------------- Initial reading, etc.
!
  COMMON /WORK01/ VV(3,LNI),DUM(3,LNI)
        real *8 VV, DUM
  COMMON /WORK02/ IPV(3,LNI),IDUMMY(3,LNI)
        integer*4 IPV,IDUMMY
  COMMON /ANIPAR/ FCUT,FFAC, Tmin, NNSYM, mstep
        REAL *8   FCUT,FFAC,Tmin
        integer*4 NNSYM,mstep
  COMMON /molpo / rcutd, iatoma, iatomb
        REAL  *8  rcutd
     INTEGER  *4  iatoma,iatomb
  COMMON /genwap/ cpara(5),densn,ncon,npwr(5)
        REAL  *8  cpara,densn
     INTEGER  *4  ncon,npwr
  COMMON /PSURF / DISTM, iato1, iato2, iarea
        REAL  *8  DISTM
!
  integer   *4    INOEND
  REAL      *8    BOXA(6), FA(3), ASP, ACOR
  real      *8    AREC1,AREC2,AREC3,AREC4,AREC5,DDT,FORMUL,TARGT,DELT
  real      *8    STEMP0,AMODE,ZSUM,ANJ,ZJ,WJ,AJ,BJ,CJ,DJ,Zi1
  real      *8    param1,param2,param3,param4,param5,param6
  integer   *4    I,IP0,J,io1,IO,nrem,nstep1,LL,natx,k
  integer   *4    iato1,iato2,iarea
  CHARACTER *4    AAX, ATY, THS1,THS2, RUNOP1
  CHARACTER *10   RUNRUN, DUMMY
  character*1     Ins1
  ATMNET(1) = '    '
  ATMNET(2) = '    '
  DO I = 1, 56
    RUNOPT(I) = '          '
  enddo
  NRECRD(9) = 0
!
!     --------------------------------------- Data input from FILE05.DAT
!
   IP0 = 0
   INOEND = 0
30 READ (15,1001,END=888)  RUNOPT(1)
   RUNOP1 = RUNOPT(1)
   IF (RUNOP1 == 'MDX.')  THEN
     RUNOPT(1) = 'MD........'
     RUNOP1    = 'MD..'
     IP0 = 1
   END IF
   IF (RUNOP1 == 'MD..')  THEN
     RUNOPT(1)  = 'MD........'
     RUNOPT(17) = 'AMORPHOUS '
   END IF
   IF (RUNOP1 == 'XD..')  THEN
     RUNOPT(1)  = 'XD........'
     RUNOPT(17) = 'CRYSTAL   '
   END IF
   IF (RUNOP1 /= 'MD..' .AND. RUNOP1 /= 'XD..' )  GO TO 30
   READ (15,1001,END=888)  RUNOPT(2),TITLE
   IF (RUNOPT(2) == '          ' .OR.RUNOPT(2) == 'STOP      ' .OR. &
       RUNOPT(2) == 'END       ' )  GO TO 888
   IF (RUNOPT(2) == 'CONT.     ') RUNOPT(2) = 'CONTINUE  '
   GO TO 50
!
888  INOEND = -1
   RETURN
!
!     -------------------------------- Read file07.dat, file08.dat, etc.
50 CALL  F07F08  (INOEND)
!  -------------------------------------- Input file of xtal geometry
   CALL  TITLET  (1,1)
!  ============================================================== Economy, normal detail
   READ (15,1000)  RUNOPT(3), AREC1, AREC2, AREC3, AREC4, AREC5
   IRECRD(1) = INT(AREC1)
   IRECRD(2) = INT(AREC2)
   IRECRD(3) = INT(AREC3)
   IRECRD(4) = INT(AREC4)
   IRECRD(5) = INT(AREC5)
   IF (IRECRD(1) > LCT) THEN
     WRITE (6,*) 'The number of steps:',IRECRD(1),' is too large (LCT=',LCT,')'
     WRITE (6,*) 'Please chage all the LCT parameters'
     STOP
   END IF
   IF (IRECRD(1) < IRECRD(2))         IRECRD(2) = IRECRD(1)
   IF (MOD(IRECRD(1),IRECRD(2)) /= 0)  IRECRD(2) = IRECRD(1)
   IF (IRECRD(3) <= 0)                 IRECRD(3) = 50
   IF (IRECRD(2) < IRECRD(3))         IRECRD(3) = IRECRD(2)
   IF (IRECRD(4) <= 0)  THEN
     IF (RUNOP1 == 'MD......') IRECRD(4) = IRECRD(3)
     IF (RUNOP1 == 'XD......') IRECRD(4) = 5
   END IF
   IF (IRECRD(5) <= 0)                 IRECRD(5) = 5
!  ================================================================== Accume, noaccume
   READ (15,1000)  RUNOPT(4), DDT, FORMUL, RCUT(1), RCUT(2)
!  ======================================================================= Temperature
   READ (15,1000)  RUNRUN, TARGT, DELT, STEMP0, TDUMP, STEMP3, STEMP4
   IF (RUNRUN == 'T         ')  RUNOPT(5) = 'T NO-CNTL '
   IF (RUNRUN == 'T NO      ')  RUNOPT(5) = 'T NO-CNTL '
   IF (RUNRUN == 'T NO-CNTL ')  RUNOPT(5) = 'T NO-CNTL '
   IF (RUNRUN == 'T SCALING ')  THEN
     RUNOPT(5) = 'T SCALING '
     NTSTEP = INT(STEMP0)
     IF (NTSTEP <= 0)  NTSTEP = 10
   END IF
   IF (RUNRUN == 'T SCALE-A ')  THEN
     RUNOPT(5) = 'T SCALE-A '
     NTSTEP = INT(STEMP0)
     IF (NTSTEP <= 0)  NTSTEP = 10
   END IF
   IF (RUNRUN == 'T NOSE    ')  then
     RUNOPT(5) = 'T NOSE    '
     do i = 1,ntion
       PP0(:,i) = P0(:,i)
     enddo
     KBT = AKB*TARGT
     STEMP(1) = 3.0d0*dble(NTION)*KBT/(CVL*STEMP0*2.0d0*pi)**2    ! Wavenumber cm^-1 -> Q [g cm^2], Q1=3NkT/omega^2
!     STEMP = 0.99d-39
     VSTEMP(1) = 0.0d0  
     nfnose = 1     ! Number of Nose-Hoover Chain
     if (TDUMP > 1.0D-2) then
        nfnose = 2
        STEMP(2) = KBT/(CVL*TDUMP *2.0d0*pi)**2    ! Wavenumber cm^-1 -> Q [g cm^2], Qn=kT/omega^2
        if (STEMP3 > 1.0D-2) then
          nfnose = 3
          STEMP(3) = KBT/(CVL*STEMP3*2.0d0*pi)**2
          if (STEMP4 > 1.0D-2) then
            nfnose = 4
            STEMP(4) = KBT/(CVL*STEMP4*2.0d0*pi)**2
          endif
        endif
     endif
     open(85,file='nose-hamiltonian')
   ENDIF
   IF (NTSTEP <= 0)  NTSTEP = 1
   DELTMP = DELT
   TMPGET = TARGT
   IF (TDUMP <= 0.0001)  TDUMP = 0.5
!   IF (RUNOPT(5)  /= 'T NOSE    ' .OR. RUNOPT(2)  /= 'CONTINUE  ' .OR. &
!       RUNOPT(51) /= 'THERMOSTAT' )  THEN
!     STEMP  = STEMP0
!     VSTEMP = 0.0
!   END IF
!  ========================================================================= Pressure
   READ (15,1000)  RUNRUN, SPRES, VIRM(1), VIRM(2), VIRM(3)
   IF (RUNRUN == 'P         ')  RUNOPT(6) = 'P NO-CNTL '
   IF (RUNRUN == 'P NO      ')  RUNOPT(6) = 'P NO-CNTL '
   IF (RUNRUN == 'P NO-CNTL ')  RUNOPT(6) = 'P NO-CNTL '
   IF (RUNRUN == 'P SCALING ')  RUNOPT(6) = 'P SCALING '
   IF (RUNRUN == 'P ANDERSEN' .OR. RUNRUN == 'P ANDERS-C' )  THEN
     if (RUNRUN == 'P ANDERSEN') RUNOPT(6) = 'P ANDERSEN'
     if (RUNRUN == 'P ANDERS-C') RUNOPT(6) = 'P ANDERS-C'
     IF (ABS(VBOX(2)) < 1.0E-9.AND.ABS(VBOX(3)) < 1.0E-9 ) THEN
       VBOX(1) = 0.0
       VBOX(2) = 0.0
       VBOX(3) = 0.0
     END IF
   END IF
!  --------------------------------------------
   IF (RUNOPT(6) /= 'P ANDERSEN'.AND.ABS(VBOX(2)) > 1.0E-9.AND. &
       ABS(VBOX(3)) > 1.0E-9 ) THEN
     VBOX(1) = 0.0
     VBOX(2) = 0.0
     VBOX(3) = 0.0
   END IF
!  ========================================================================= Volume
   READ (15,1000)  RUNRUN, BOXA
   IF (RUNRUN == '          ')  RUNOPT(7) = 'V FREE    '
   IF (RUNRUN == 'V CONST.  ')  RUNOPT(7) = 'V CONST.  '
   IF (RUNRUN == 'V CONTROL ')  RUNOPT(7) = 'V CONST.  '
   IF (RUNRUN == 'D CONST.  ')  RUNOPT(7) = 'D CONST.  '
   IF (RUNRUN == 'D CONTROL ')  RUNOPT(7) = 'D CONST.  '
!  --------------------------------------- Change cell size
   IF (RUNRUN == 'V CELL    ')  THEN
     RUNOPT(7) = 'V CELL    '
     DO J = 1, 3
       FA(J)  = BOXA(J) / BOX(J)
       BOX(J) = BOXA(J)
     enddo
!  ----------------------------------------- Change density
   ELSE IF (RUNRUN == 'V DENSITY ')  THEN
     RUNOPT(7) = 'V DENSITY '
     FA(1) = (DENSTY/BOXA(1))**(1.0d0/3.0d0)
     FA(2) = FA(1)
     FA(3) = FA(1)
     DO I = 1, 3
       BOX(I) = BOX(I) * FA(I)
     enddo
   ELSE IF (RUNRUN == 'V CHANGE  ') THEN
     RUNOPT(7) = 'V CHANGE  '
     ICAXIS = INT(BOXA(1))
     BTAGET = BOXA(2)
     BCNGR  = BOXA(3)
     if (ABS(BCNGR) <= 1.0E-6) BCNGR = sign(1.0D0,BCNGR)*1.0D-6
   END IF
!
!  ================================================================ Potential model
   READ (15,1000)  RUNOPT(8), AMODE, ALPHA
   MODE = INT(AMODE)
   IF (RUNOPT(8) /= '          ' .AND. &
       RUNOPT(8) /= 'BUSING    ' .AND. &
       RUNOPT(8) /= 'MORSE     ' .AND. &
       RUNOPT(8) /= 'MORSE-AT  ' .AND. &
       RUNOPT(8) /= 'BMH-EXP   ' .AND. &
       RUNOPT(8) /= 'BMH-EXP*  ' .AND. &
       RUNOPT(8) /= 'BELONO    ' .AND. &
       RUNOPT(8) /= 'TOSIFUMI  ' .AND. &
       RUNOPT(8) /= 'WOODCOCK  ' .AND. &
       RUNOPT(8) /= 'PAULING   ' .AND. &
       RUNOPT(8) /= 'STSUNE    ' .AND. &
       RUNOPT(8) /= 'VASHISHTA ' .AND. &
       RUNOPT(8) /= 'L-J       ' .AND. &
       RUNOPT(8) /= 'PAIR-P    ' .AND. &
       RUNOPT(8) /= 'METAL     ' )  THEN
     WRITE (*,*) 'Interatomic potential model ',runopt(8),' is not recognized'
     STOP
   END IF
!
   ZSUM = 0.0
   DO I = 1, LEM
     ATOM(I) = '    '
     ZIO(I)  = 0.0D0
     WIO(I)  = 0.0D0
     AIO(I)  = 0.0D0
     BIO(I)  = 0.0D0
     CIO(I)  = 0.0D0
     DIO(I)  = 0.0D0
     NION(I) = 0
     IION(I) = 0
   enddo
   NCOMPO = 0
!  --------------------------------------------- Read atom parameters
   DO J = 1, LEL+1
     READ (15,'(A1,A1,A2,F6.0,6F10.0)',END=230)  Ins1,ATY,AAX,ANJ,ZJ,WJ,AJ,BJ,CJ,DJ
!     if (I == 0) I = 10
     IF (Ins1 == ' ' .or. AAX == '    ')  GO TO 230
       I = 0
       do k=1, lel
         if (Ins1 == ins(k)) then
                 I = k
                 exit
         endif
       enddo
       if (I == 0) then
               write(*,*) '!!! Error [file05.dat] at atom ', j,Ins1,I,k, '!!!'
               write(*,'(" ---- atom =",A2,"  Ni=",F5.0," ----")')AAX,ANJ
               stop
       endif

     ATOM(I) = AAX
     ZIO(I)  = ZJ
     WIO(I)  = WJ
     AIO(I)  = AJ
     BIO(I)  = BJ
     CIO(I)  = CJ
     DIO(I)  = DJ
     NION(I) = INT(ANJ)
     IION(I) = 0
     IF (I /= 1)  ZSUM = ZSUM + ZJ * ANJ
     IF (ATY == '-')  IION(I) = -1           ! P-fixed
     IF (ATY == '*')  IION(I) = -999         ! dummy atom
     IF (ATY == '=')  IION(I) =  1           ! Morse only
     IF (ATY == '/')  IION(i) =  2           ! no T-control
     NCOMPO = NCOMPO + 1
   enddo
230 ZI1 = - ZSUM / REAL(NION(1))
   ncharge=0
   IF (ABS(ZI1-ZIO(1)) > 0.00001) THEN
     write(*,'("########################### WARNING ##############################")')
     WRITE (*,'("## Warning on total charge neutralization! ", F10.7," ##")') ZIO(1)
     write(*,'("## Homogeneous background charge was imposed in the cell. ##")')
     write(*,'("## Pressure is inaccurate in this simulation. ##")')
     write(*,'("##################################################################")')
     ncharge = -1
!           ZIO(1) = ZI1
   END IF
!  --------------------------------------WATER-POL
   do io = 1, ncompo
     do i = ions(1,io),ions(2,io)
       ZIIP(i) = ZIO(io)
     enddo
   enddo
   if (ICD == 0) then
     do i = 1, ntion
       ZII(i) = ZIIP(i)
     enddo
   endif
!  -----------------------------------------------
!
   IO1 = NCOMPO + 1
   DO IO = IO1, LEL
     IF (NION(IO) > 0)  NCOMPO = IO
   enddo
!     ------------------------------------------------------------------
   DTMO = DTIME
   IF (RUNOPT(2) == 'START     ')  THEN
     do i = 1, ntion
       ZII(i) = ZIIP(i)
     enddo
     IF (DDT > 0.0001D0)     DTIME = DDT * 1.0D-15
     IF (DTIME < 1.0D-18)    DTIME = 2.0D-15
     IF (RUNOP1 == 'MD..'.AND.IP0 == 0)  THEN
       DO I = 1,NTION
         DO J = 1, 3
           P0(J,I) = P(J,I)
         enddo
       enddo
     END IF
     NAVT = 0
     NAV  = 0
     DO I = 1, LVA
       TVAL(I) = 0.0D0
       SVAL(I) = 0.0D0
       VAL0(I) = 0.0D0
     enddo
     MXCUT     = 99999
     NRECRD(1) = 0
     NRECRD(2) = 0
!     VBOX(1)   = 1.0
   END IF
!
   CALL  PREPAR  (FORMUL)
!
!     ---------------------------------------- Configuration and heading
!
   NREM = IRECRD(1) - NRECRD(1)
   NSTEP1 = NRECRD(1) + 1
   THS1 = 'th'
   IF (MOD(NSTEP1,10) == 1)  THS1 = 'st'
   IF (MOD(NSTEP1,10) == 2)  THS1 = 'nd'
   IF (MOD(NSTEP1,10) == 3)  THS1 = 'rd'
   THS2 = 'th'
   IF (MOD(IRECRD(1),10) == 1)  THS2 = 'st'
   IF (MOD(IRECRD(1),10) == 2)  THS2 = 'nd'
   IF (MOD(IRECRD(1),10) == 3)  THS2 = 'rd'
   WRITE (16, 2000) RUNOPT(2),NREM,NSTEP1,THS1,IRECRD(1),THS2,DTIME,IRECRD(2), &
                    RUNOPT(5),TEMP,DELTMP,NTSTEP,TMPGET,RUNOPT(4),NRECRD(2),NRECRD(4)
   IF (RUNOPT(5) == 'T NOSE    ') WRITE (16,2010)  STEMP
   IF (RUNOPT(6) /= 'P NO-CNTL ') THEN
     IF (RUNOPT(6) == 'P SCALING ') WRITE (16,2020) RUNOPT(6),SPRES
     IF (RUNOPT(6) == 'P ANDERSEN') WRITE (16,2027) RUNOPT(6),SPRES,(VIRM(LL),LL=1,3)
     IF (RUNOPT(6) == 'P ANDERS-C') WRITE (16,2027) RUNOPT(6),SPRES,(VIRM(LL),LL=1,3)
   END IF
!
   CALL  TABLER  (1)
!
!  ========================================================== Read RUNOPT(9),...,(27)
   lentab   = lst
   IPRDF(1) = 2
   IPRDF(2) = 9999
520 READ (15,1000)  RUNRUN,PARAM1,PARAM2,PARAM3,PARAM4,PARAM5,PARAM6
   IF (RUNRUN /= '          ') THEN
     IF (RUNRUN == 'STRUCTURE ') then
       RUNOPT(9)  = 'STRUCTURE '
       lentab = param1
       if (lentab < 1)    lentab = LST
       if (lentab > LST)  lentab = LST
     end if
!
     IF (RUNRUN == 'NETWORK   ')  THEN
       RUNOPT(10) = 'NETWORK   '
       NATX = 0
       IO = PARAM1
       IF (IO > 0.AND.IO <= LEE)  THEN
         NATX = NATX + 1
         ATMNET(NATX) = ATOM(IO)
       END IF
       IO = PARAM2
       IF (IO > 0.AND.IO <= LEE)  THEN
         NATX = NATX + 1
         ATMNET(NATX) = ATOM(IO)
       END IF
       WRITE (*,*) 'Network forming cation(s) is(are)',(i,atmnet(i),i=1,natx)
     END IF
!
     IF (RUNRUN == 'VELOCITY  ')  THEN
       RUNOPT(11) = 'VELOCITY  '
       IRECRD(9)  = PARAM1
       PVMULT = 50000.D0
       IF (PARAM2 > 0)     PVMULT = PARAM2
       IF (IRECRD(9) <= 1)  IRECRD(9) = 1
     END IF
!
     IF (RUNRUN == 'POSITION  ')  THEN
       RUNOPT(11) = 'POSITION  '
       IRECRD(9)  = PARAM1
       PVMULT = 90000.D0
       IF (PARAM2 > 0)     PVMULT = PARAM2
       IF (IRECRD(9) <= 1)  IRECRD(9) = 1
     END IF
!
     IF (RUNRUN == 'ENERGY    ')  THEN
       RUNOPT(11) = 'ENERGY    '
       IRECRD(9)  = PARAM1
       PVMULT = 1.0E12
       IF (PARAM2 > 0)     PVMULT = PARAM2
       IF (IRECRD(9) <= 1)  IRECRD(9) = 1
     END IF
!
     IF (RUNRUN == 'POSVELENE ')  THEN
       RUNOPT(11) = 'POSVELENE '
       IRECRD(9)  = PARAM1
       PVMULT = 1.0E12
!       IF (PARAM2 > 0)     PVMULT = PARAM2
       IF (IRECRD(9) <= 1)  IRECRD(9) = 1
     END IF
!
     IF (RUNRUN == 'QUANTUM   ')  THEN
       RUNOPT(12) = 'QUANTUM   '
       CALL  QCTABL
     END IF
!
     IF (RUNRUN == 'PCF       '.OR.RUNRUN == 'RDF       ')  THEN
       RUNOPT(13) = 'PCF       '
       IF (PARAM1 > 0.999)  IPRDF(1) = PARAM1
       IF (PARAM2 > 0.5 .AND. PARAM2 < 20.0) IPRDF(2) = PARAM2*100
     END IF
!
     IF (RUNRUN == 'DIPOLE    ')  THEN
       RUNOPT(14) = 'DIPOLE    '
     END IF
!
     IF (RUNRUN == 'CENTER    '.OR.RUNRUN == 'CENTRE    ')  THEN
       RUNOPT(15) = 'CENTER    '
     END IF
!
     IF (RUNRUN == 'CENTERING ')  THEN
       RUNOPT(15) = 'CENTERING '
       iaxcen     = PARAM1
     END IF
!
     IF (RUNRUN == 'NO(MV=0)  ')  THEN
       RUNOPT(16) = 'NO(MV=0)  '
     END IF
!
     IF (RUNRUN == 'Am(MV=0)  ')  THEN
       RUNOPT(16) = 'Am(MV=0)  '
       Iam = param1
     END IF
!
     IF (RUNRUN == 'CRYSTAL   ')  THEN
       RUNOPT(17) = 'CRYSTAL   '
     END IF
!
     IF (RUNRUN == 'BINARY    ')  THEN
       RUNOPT(18) = 'BINARY    '
       IF (RUNOPT(2) == 'START     ')  THEN
         CLOSE (19)
         OPEN (19,FILE=FLNAME(9),STATUS='UNKNOWN',ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
       END IF
     END IF
!
     IF (RUNRUN == 'PRESSURE  ')  THEN
       RUNOPT(19) = 'PRESSURE  '
       OPEN (27,FILE=FLNAME(13),STATUS='UNKNOWN',ACCESS='SEQUENTIAL',FORM='FORMATTED' )
       REWIND 27
     END IF
!
     IF (RUNRUN == 'ELEC.FIELD')  THEN
       RUNOPT(20) = 'ELEC.FIELD'
       MEFD   =  INT(PARAM1)          ! Mode of elec.field
       EFD(1) = DBLE(PARAM2) *1.00D5  ! [EFD]==[V/m]
       EFD(2) = DBLE(PARAM3) *1.00D5  ! 1 CV/m = 1 J/m
       EFD(3) = DBLE(PARAM4) *1.00D5  !        = 10^5 erg/cm
       EFREQ  = DBLE(PARAM5)          ! Hz
       NATOM  =  INT(PARAM6 + 0.5)    ! starting number of atom given EFD
     END IF
!
     if (runrun == 'GRAV.FIELD')  then
       runopt(21) = 'GRAV.FIELD'
       gfd(1)     = param1
       gfd(2)     = param2
       gfd(3)     = param3
     end if
!
     if (runrun == 'DIATOMIC  ')  then
       runopt(23)  = 'DIATOMIC  '
       DINTRA      = param1
       IATOM2(1)   = param2
       IATOM2(2)   = param3
       MOLstart(1) = param2
       MOLend(1)   = param2
       MOLstart(2) = param3
       MOLend(2)   = param3
       ZMOLE(1) = - ZIO(IATOM2(1))*2.0
       if (iatom2(2) > 0)  zmole(2) = - ZIO(IATOM2(2))*2.0
       CALL  DIATOM
     end if
!
     if (runrun == 'CUBE      ')  then
       runopt(24) = 'CUBE      '
     end if
!
     if (runrun == 'CONVEC    ')  then
       runopt(25) = 'CONVECTION'
       fconvc     = param1
       write (6,*) '[CONVECTION] option is set'
     end if
!
     if (runrun == 'MOLECULE  ')  then
       runopt(26)  = 'MOLECULE  '
       DINTRA      = param1
       MOLstart(1) = param2
       MOLend(1)   = param3
       call  MOLECULE
     end if
!
     if (runrun == 'EXCLUSION ')  then
       runopt(27)  = 'EXCLUSION '
       READ (15,1000)  RUNRUN,PARAM1,PARAM2,PARAM3,PARAM4,PARAM5,PARAM6
       if (RUNRUN == 'COLUMN    '.or. RUNRUN == 'SLUB      ' ) then
         iextype = 1
         if (RUNRUN == 'SLUB      ')  iextype = 2
         iaex   = param1
         REXCL  = param2
         Fexcl  = param3
       end if
       if (RUNRUN == 'CUBE      ') then
         iextype = 3
         rexcl   = param1
         Fexcl   = param2
       end if
       if (RUNRUN == 'SPHERE    ') then
         iextype = 4
       end if
       if (RUNRUN == 'HONEYCOMB ') then
         iextype = 5
         iaex  = param1
         rexcl = param2
         fexcl = param3
       end if
       if (Fexcl < 1.0E-9)  Fexcl = 1.0E-5
     end if
!
     if (runrun == 'WALL      ')  then
       runopt(28) = 'WALL      '
       WALLa = param1
       WALLb = param2
     end if
!
     if (runrun == 'POLYATOMS ')  then
       runopt(29)  = 'POLYATOMS '
       DINTRA      = param1
       MOLstart(1) = param2
       MOLend(1)   = param3
       call  MOLECULE
     end if
!
     if (runrun == 'STOPT     ')  then
       runopt(30)  = 'STOPT     '
       FCUT        = param1
       FFAC        = param2
       NNSYM        = param3
!               NNSYM = 1:   Water dimer Cs symmetry
     end if
!
     if (runrun  ==  'POTSURF   ') then
       runopt(30) = 'POTSURF   '
       DISTM  = param1
       iato1  = param2
       iato2  = param3
       iarea  = param4             !iarea = 1 -> x only
                                   !iarea = 2 -> y only
                                   !iarea = 3 -> z only
                                   !iarea = 4 -> x + y
                                   !iarea = 5 -> y + z
                                   !iarea = 6 -> z + x
     end if
!
     if (runrun == 'MOLPOL    ') then
       runopt(31)  = 'MOLPOL    '
       iatoma      = param1
       iatomb      = param2
       rcutd       = param3
     end if
!
     if (runrun == 'GEN.WALL  ') then
       runopt(32)  = 'GEN.WALL  '
       ncon = 0
       npwr(1)     = param1
       cpara(1)    = param2*1.0D-16      ![erg*nm^n]
       densn       = param3/(1.0D-7**3)  ![number/nm^3] -> [number/cm^3]
       ncon        = param4
       npwr(2)     = param5
       cpara(2)    = param6*1.0D-16*(1.0D-7)**npwr(2)
!               if (ncon  >  1) THEN
!                   DO 451 i = 2, ncon 
!                     READ (15,1002)  npwr(i),cpara(i)
!                     WRITE(*,1002)  npwr(i),cpara(i)
!                     cpara(i)=cpara(i)*1.0D-16
!  451              CONTINUE
!               end if
     end if
!
     if (runrun == 'EWALD-C   ')  then
       runopt(33)  = 'EWALD-C   '
       iaxis    = int(param1)
     endif
!
     if (runrun == 'WATER-POL ') then
       runopt(34)  = 'WATER-POL '
       IATOMO = INT(param1)
       IATOMH = INT(param2)
       DINTRA = param3
       THRESHD = param4
!       ITER   = INT(param4)
!       GE_pol = param5
!       Em_pol = param6
       RD = param6
       if (param6 < 1.0D-3) RD = 0.25D0
       DLP = RD*2.0D0
       ndmole = 2*nion(IATOMO)
       niono = nion(iatomo)
!
       if (ICD == 0) then
         open (26, FILE=FLNAME(16), status ='unknown', access='sequential', form='formatted')
           do i = ntion+1, ntion+ndmole
             ZII(i) = ZIO(IATOMO)/2.0D0
           enddo
           do i = IONS(1,IATOMO),IONS(2,IATOMO)
             ZII(i) = 0.0D0
           enddo
           write (26,'(i10)') nrecrd(1)
           write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
           ICD = 1
       endif
!       AIO(ncompo+1)  = AIO(IATOMH)
!       BIO(ncompo+1)  = BIO(IATOMH)
!       CIO(ncompo+1)  = CIO(IATOMH)
!       DIO(ncompo+1)  = DIO(IATOMH)
       AIO(ncompo+1)  = 0.0D0
       BIO(ncompo+1)  = 0.0D0
       CIO(ncompo+1)  = 0.0D0
       DIO(ncompo+1)  = 0.0D0
       WIO(ncompo+1)  = 0.0D0
       ATOM(ncompo+1) = 'LP  '
       IION(ncompo+1) = 0
       NION(ncompo+1) = ndmole
       IONS(1,ncompo+1) = IONS(2,ncompo) + 1
       IONS(2,ncompo+1) = IONS(2,ncompo) + NION(ncompo+1)
       do i = ntion+1, ntion+ndmole
         ZIIP(i) = ZIO(IATOMO)/2.0D0
!         IOND(i) = 1
       enddo
       do i = IONS(1,IATOMO),IONS(2,IATOMO)
         ZII(i) = 0.0D0
         ZIIP(i) = 0.0D0
       enddo
       call COULMB
       UCSELF = 0.0D0
       UCCOR = 0.0D0
       ASP = - (ALPHA*1.0D8) * ELC**2 / DSQRT(PI)
       ACOR = -1.0D0*PI*ELC**2/2.0D0/(ALPHA*1.0D8)**2/(VOL*1.0D-24)
       do io = 1,ncompo
         UCSLFI(io) = 0.0d0
         DO I = ions(1,io), IONS(2,io)
           UCSLFI(io) = UCSLFI(io) + ZII(I)**2*ASP
           UCCOR = UCCOR + ZII(I)
         enddo
         UCSELF = UCSELF + UCSLFI(io)
       enddo
       UCSLFI(ncompo+1) = 0.0D0
       DO I = ntion+1, ntion+ndmole
         UCSLFI(ncompo+1) = UCSLFI(ncompo+1) + ZII(I)**2*ASP
         UCCOR = UCCOR + ZII(I) 
         IOND(I) = 1 !20120513
       enddo
       UCSELF = UCSELF + UCSLFI(ncompo+1)
       UCCOR = UCCOR**2*ACOR 
!
       call BMHEXP (1)
       call VWCORR (1)
!       call FIND_H2O(0)
     endif
     if (runrun == 'WATER-POL*') then
       runopt(34)  = 'WATER-POL*'
       IATOMO = 1
       ih2o(2,1) = 3
       ih2o(3,1) = 4
       ih2o(4,1) = 7
       ih2o(5,1) = 8
       ih2o(2,2) = 5
       ih2o(3,2) = 6
       ih2o(4,2) = 9
       ih2o(5,2) = 10
     endif
!     
     if (runrun == 'ISOLATED  ') then
       runopt(35) = 'ISOLATED  '
     endif
!
     if (runrun == 'EWALD-OPT ') then
       runopt(30) = 'STOPT     '
       runopt(36) = 'EWALD-OPT '
     endif
!
!
     GOTO 520
!
   END IF
   WRITE (16,2030)  (I,RUNOPT(I),I=1,56)
!  ===================================================================== Check P and V
   CALL  CHECKP
!  ------------------------------------------------------ file09p.dat
   IF (RUNOPT(2) == 'START     ')  THEN
     IF (RUNOP1 == 'MD..')  THEN
       IF (TITLE(1) /= 'BENC' .OR. TITLE(2) /= 'HMAR')  THEN
         NRECRD(4) = 1
         IF (RUNOPT(18) == 'BINARY    ') THEN
           WRITE (19) NRECRD(4),0,BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0,0.0,BOX(3)
           WRITE (19) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
         ELSE
           DO I = 1, NTION
             DO J = 1, 3
               IPV(J,I) = P(J,I) * 90000.D0
             enddo
           enddo
           DUMMY = '          '
           WRITE (19,9001) NRECRD(4),0,BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0,0.0,BOX(3)
           WRITE (19,9002)  ((IPV(J,I),J=1,3),I=1,NTION)
         END IF
       END IF
     END IF
   END IF
!  ----------------------------------------------------- file09PV.dat
   IF (RUNOPT(11) /= '          ') THEN
     IF (RUNOPT(18) == 'BINARY    ') THEN
       OPEN (28,FILE=FLNAME(12),STATUS='UNKNOWN',ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
     ELSE
       OPEN (28,FILE=FLNAME(12),STATUS='UNKNOWN',ACCESS='SEQUENTIAL',FORM='FORMATTED')
     END IF
     REWIND 28
     NRECRD(9) = 1
     IF (RUNOPT(11) == 'VELOCITY  ') THEN
       IF (RUNOPT(18) == 'BINARY    ')  THEN
         DO I = 1, NTION
           DO J = 1, 3
             VV(J,I) = V(J,I) / DTIME
           enddo
         enddo
         WRITE (28)  NRECRD(1),IRECRD(9)
         WRITE (28)  ((VV(J,I),J=1,3),I=1,NTION)
       ELSE
         DO I = 1, NTION
           DO J = 1, 3
             IPV(J,I)=V(J,I)*PVMULT*1D-15/DTIME +50000.D0
           enddo
         enddo
         WRITE (28,9001)  NRECRD(1),IRECRD(9)
         WRITE (28,9002)  ((IPV(J,I),J=1,3),I=1,NTION)
       END IF
     END IF
     IF (RUNOPT(11) == 'POSITION  ') THEN
       IF (RUNOPT(18) == 'BINARY    ') THEN
         WRITE (28) NRECRD(1),IRECRD(9),BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0,0.0,BOX(3)
         WRITE (28)  ((SNGL(P(J,I)),J=1,3),I=1,NTION)
       ELSE
         DO I = 1, NTION
           DO J = 1, 3
             IPV(J,I) = P(J,I) * PVMULT
           enddo
         enddo
         WRITE(28,9001)NRECRD(1),IRECRD(9),BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0,0.0,BOX(3)
         WRITE (28,9002)  ((IPV(J,I),J=1,3),I=1,NTION)
       END IF
     END IF
 9001        FORMAT (I7,i3,9F7.3)
 9002        FORMAT (18I5)
   END IF
!  ------------------------------------------------------------------
   IF (NREM <= 0)  GO TO 2222
   CALL  TITLET  (0, 1)
 RETURN
!
 2222 WRITE (*,2233)  RUNOPT(2)
 2233 FORMAT ('>>>>>  The number of steps to be calculated is less than one  >>>>>' / &
              '>>>>>  Mode=', A9,  '   Please increase the number of steps   >>>>>' )
 STOP
!
 1000 FORMAT (A10, 6F10.5)
 1001 FORMAT (A10, 15A4)
! 1002 FORMAT (2F10.5)
 2000 FORMAT ('I  [ ',A10,' ]',I7,' steps run from',I6,'-',A2, &
                   ' step to ',I7,'-',A2,' step with time step of', &
                   1PE9.2,' sec. RDF''s at every', I6,' step I' / &
              'I  [ ',A10,' ]  Temperature=',0PF7.1,' K  changed ', &
                   'with a rate of',F6.1,' K  per ', I3, ' steps until', &
                   F7.1,' K  (',A8,' : ',I5,' : ',I4,')  I' )
 2010 FORMAT ('I',18X,'"Mass" of Nose''s thermostat is ',E12.4,' g.cm2',63X,'I' )
 2020 FORMAT ('I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
              'GPa  using forced scaling of cell dimensions.',14X,'I')
 2027 FORMAT ('I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
                           ' GPa  by Andersen''s mass ',3(1X,G10.2E3),' g  I')
 2030 format ('I',130('-'),'I' / &
              'I  [Options]  ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' )
      END
!
!
!                                                             ==========
!============================================================== MOLECULE
SUBROUTINE  MOLECULE
  use param
  use charac
  use aboxof
  use atomsi
  use cartes
  use molecu
!
  implicit none
!
! ======================================recognize molecules
!
  real *8  rx,ry,rz,dx,dy,dz,rij2
  real *8  cut2
  integer *4 mi(lni), ndistr(11)
  integer *4 i,n,nnn,io,ii,mmm,jo,j1,j2,j,mmmm,m
!
  cut2 = dintra**2
  do I = 1, ntion
    mi(i) = 0
  enddo
  do n = 1, 11
    ndistr(n) = 0
  enddo
  nnn = 0
! ------------------------------------------- calc distance between atoms
  do io = MOLstart(1), MOLend(1)
    do ii = ions(1,io), ions(2,io)
      if (mi(ii) > 0 )  cycle  ! if ii is already recognized as a component of a molecule, cycle
      nnn = nnn + 1            ! index of molecule
      imole(1,nnn) = ii        ! index of the first atom of molecule nnn
      mi(ii) = 1               ! "1" indicates that this atom (ii) is already checked.
      mmm = 1                  ! number of atoms in the molecule
      do jo = io, MOLend(1)
        if (jo < 0 .or. jo > ncompo) cycle
        j1 = ions(1,jo)
        j2 = ions(2,jo)
!        if (io == jo)  j1 = i+1    ! if the element is same, ?????
        do J = j1, j2
          if (mi(j) > 0) cycle
          mmmm = mmm
          do m = 1, mmmm
            i = imole(m,nnn)    ! search the distance from all atoms composing the molecule
            if (i == j)  cycle
            RX = P(1,i) - P(1,j)
            RY = P(2,i) - P(2,j)
            RZ = P(3,i) - P(3,j)
            if (RUNOPT(35) /= 'ISOLATED  ') then
              if (RX < -0.5)  RX = RX + 1.0
              if (RX >  0.5)  RX = RX - 1.0
              if (RY < -0.5)  RY = RY + 1.0
              if (RY >  0.5)  RY = RY - 1.0
              if (RZ < -0.5)  RZ = RZ + 1.0
              if (RZ >  0.5)  RZ = RZ - 1.0
            endif
!T                    --------- delete these if-statements for triclinic
!T                    IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!T                    IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!T                    IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!T                    DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                    DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                    DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 > CUT2) cycle
            mmm = mmm +1
            IMOLE(mmm,nnn) = j ! index of mmm-th atom of nnn molecule
            mi(j) = 1
            exit
          enddo
        enddo
      enddo
      mmole(nnn)  = mmm               ! The number of atoms composing the nnn molecule
      ndistr(mmm) = ndistr(mmm) + 1   ! The number of molecules composed by the mmm atoms
    enddo
  enddo
!
  nmole = nnn                         ! Total number of molecules
  write (6,1001)  nmole, MOLstart(1), MOLend(1)
 1001 format (' Total number of molecules is',I6, '  (',I2,'-',i2,')')
  write  (6,1002) (n,n=1,11), (ndistr(n),n=1,11)
 1002 format (' No.atoms',11I6 / ' No.moles',11I6)
RETURN
END
!
!
!
!                                                               ========
!================================================================ DIATOM
SUBROUTINE  DIATOM
  use param
  use charac
  use aboxof
  use atomsi
  use cartes
  use molecu
!
  implicit none
!
!     ======================================recognize diatomic molecules
!
  real *8  pix,piy,piz, pjx,pjy,pjz, rx,ry,rz, dx,dy,dz,pjx0,pjy0,pjz0, rij2
  real *8  cut2
  integer *4 nnn,iii,io,i1,i2,i,j,k
!
!---------------------------------------------calc distance of atoms
  cut2 = dintra**2
  nnn = 0
  do iii = 1, 2
    io = iatom2(iii)
    if (io < 0 .or. io > ncompo) cycle
    i1 = ions(1,io)
    i2 = ions(2,io)
    DO I=i1, i2-1
      pix = p(1,i)
      piy = p(2,i)
      piz = p(3,i)
      do J=i+1,i2
        pjx0 = p(1,j)
        pjy0 = p(2,j)
        pjz0 = p(3,j)
        if (pjx0 < pix)  pjx0 = pjx0 + 1.0
        if (pjy0 < piy)  pjy0 = pjy0 + 1.0
        if (pjz0 < piz)  pjz0 = pjz0 + 1.0
        DO K = 1, 8
          pjx = pjx0 - transx(k)
          pjy = pjy0 - transy(k)
          pjz = pjz0 - transz(k)
          RX = PIX - PjX
          RY = PIY - PjY
          RZ = PIZ - PjZ
!T                         - - - - - delete these if-statements for triclinic
!T                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!T                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!T                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!T                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = RX * BOX(1)
          DY = RY * BOX(2)
          DZ = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          IF (RIJ2 <= CUT2)  GO TO 255
        enddo
        cycle
!       ----------------------------------Kumiawase of diatomic
  255   nnn = nnn +1
        IDMOLE(1,nnn) = I
        IDMOLE(2,nnn) = J
        IDmole(3,nnn) = iii
        DMOLE(1,nnn) = DX
        DMOLE(2,nnn) = Dy
        DMOLE(3,nnn) = DZ
        DMOLE(4,nnn) = SQRT(RIJ2)
!       -----------------------------------P of center of mass
        Pix=(Pix+Pjx)/2.
        Piy=(Piy+Pjy)/2.
        Piz=(Piz+Pjz)/2.
        if (pix < 0.0)   pix = pix + 1.0
        if (pix > 1.0)   pix = pix - 1.0
        if (piy < 0.0)   piy = piy + 1.0
        if (piy > 1.0)   piy = piy - 1.0
        if (piz < 0.0)   piz = piz + 1.0
        if (piz > 1.0)   piz = piz - 1.0
        p(1,ntion+nnn) = pix
        p(2,ntion+nnn) = piy
        p(3,ntion+nnn) = piz
!
!                   WRITE(*,*) nnn,IDMOLE(1,nnn),IDMOLE(2,nnn),pix,piy,piz
!
      enddo
    enddo
  enddo
  ndmole = nnn
RETURN
END
!
!
!                                                               ========
!================================================================ PREPAR
SUBROUTINE  PREPAR  (FORMUL)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use values
  use radial
!
  implicit none
!
  real *8 FORMUL
  integer *4 nelm,io,j,i
!
!     ----------------------------------- Preparing some variables, etc.
!
  NELM   = 0
  TWEGHT = 0.0D0
  DO IO = 1, NCOMPO
    IONS(1,IO) = NELM + 1
    NELM       = NELM + NION(IO)
    IONS(2,IO) = NELM
    NIOND(IO)  = 0
    DO J = IONS(1,IO), IONS(2,IO)
      IF (IOND(J) /= 0)  NIOND(IO) = NIOND(IO) + 1
    enddo
    TWEGHT = TWEGHT + WIO(IO) * DBLE(NIOND(IO))
  enddo
  NFORML = NION(2)
  IF (NFORML == 0)  NFORML = NION(3)
  IF (FORMUL > 0.0)   NFORML = NION(1) / FORMUL
  FJMOL = ANA / 1.0D10 / DBLE(NFORML)
  IF (NELM > NTION)  GO TO 4444
  IF (NELM < NTION)  WRITE (*,1004)  NELM,NTION
  NTION = NELM
!
  DO I = 1, LVA
    VALMAX (I) = -9.9D19
    VALMIN (I) =  9.9D19
  enddo
!
  TPRE = TEMP
  RETURN
!
 4444 WRITE (*,4455)
 4455 FORMAT(' *****  THE NUMBER OF PARTICLES IN FILE05 IS MORE THAN THAT IN FILE07  *****')
 STOP
!
 1004 FORMAT (' ******* Warnning *****  NTION(new)=',I5,'  (old)=',I5,7('*'))
END
!
!
!                                                               ========
!================================================================ CHECKP
SUBROUTINE  CHECKP 
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
!
  implicit none
!
!     ----------------------------------- Preparing some variables, etc.
!
!
  REAL  *8        RL ,TT,FV,DL,CENTER
  integer *4      j,io,i1,i2,i
!
! ----------------------- Check and correct velocity and momentum
  FV = 1.0D0
  TT = TEMP
  IF (TT < 0.001D0)  TT = 0.001D0
  IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
  FV = SQRT(TEMP/TT) * (DTIME/DTMO)
  DO J = 1, 3
    DL     = 0.0D0
    DO IO = 1, NCOMPO
      RL = 0.0D0
      IF (NION(IO) > 0)  THEN
        I1 = IONS(1,IO)
        I2 = IONS(2,IO)
        DO I = I1, I2
          IF (IOND(I) /= 0)  RL = RL + V(J,I)
        enddo
      END IF
      DL = DL + RL * WIO(IO)
    enddo
    DL = DL / TWEGHT
    IF (RUNOPT(16) == 'NO(MV=0)  ')  THEN
      DL = 0.0D0
    END IF
    DO I = 1, NTION
      IF (P(J,I) < 0.0D0)  P(J,I) = P(J,I) + 1.0D0
      IF (P(J,I) >= 1.0D0)  P(J,I) = P(J,I) - 1.0D0
      IF (IOND(I) /= 0)     V(J,I) = (V(J,I) - DL) * FV
      IF (IOND(I) == 0)     V(J,I) = 0.0D0
      IF (P(J,I)-P0(J,I) >  0.5D0)  P0(J,I) = P0(J,I) + 1.0D0
      IF (P(J,I)-P0(J,I) < -0.5D0)  P0(J,I) = P0(J,I) - 1.0D0
    enddo
    IF (RUNOPT(15) == 'CENTER    ')  THEN
      CENTER = 0.0D0
      DO I = 1, NTION
        CENTER = CENTER + P(J,I)
      enddo
      CENTER = CENTER / NTION - 0.5D0
      DO I = 1, NTION
        P(J,I)  = P(J,I)  - CENTER
        P0(J,I) = P0(J,I) - CENTER
      enddo
    END IF
    IF (runopt(34)  == 'WATER-POL ') call FIND_H2O(0)
  enddo
!
RETURN
END
!
!
!                                                               ========
!================================================================ TABLER
SUBROUTINE  TABLER  (IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
!
  implicit none
!
  integer *4 IPR,i,j,KKK,KLEM
  real *8  rij
!     --------------------------------------------- Heading of MD output
!                     Preparing tables for force and energy calculations
!
!
  CHARACTER *63   LOGO1(18), LOGO2(18), LOGO3(14)
  DATA  LOGO1 / &
     '     *******               **************************          ', &
     '       ****                 ***********          ********      ', &
     '       *****                 *********              ********   ', &
     '       ******               **********               ********* ', &
     '       *******             ***********                *********', &
     '       **** ***           ************                *********', &
     '       ***   ***         *** *********                *********', &
     '       ***    ***       ***  *********                *********', &
     '       ***     ***     ***   *********                *********', &
     '      ***       ***   ***    *********                ******** ', &
     '      ***        *******     *********                *******  ', &
     '     ****         *****      *********               *******   ', &
     '    *****          ***       *********              *******    ', &
     '    *****           *        *********             *******     ', &
     '   *******                   *********            ******       ', &
     '  ********                  ***********         ******         ', &
     '***********               ************************            R', &
     '                                                               '/
  DATA  LOGO2 / &
     '************                *************************          ', &
     '     *********                ************       *******       ', &
     '       ********               ***********           *******    ', &
     '         *******            ***  ********            ********  ', &
     '           ******         ***    ********             ******** ', &
     '            ******      ***      ********              ********', &
     '             ******   ***        ********              ********', &
     '              ********           ********              ********', &
     '               ******            ********              ********', &
     '              ********           ********              ******* ', &
     '            ***  ******          ********             *******  ', &
     '          ***     ******         ********            *******   ', &
     '        ***        ******        ********           *******    ', &
     '      ***           ******       ********          ******      ', &
     '    ****             ******      ********        ******        ', &
     '  ******              *******   **********     ******          ', &
     '**********              ***************************           R', &
     '                                                               '/
  DATA  LOGO3 / &
     'Ms-Fortran-PowerStation Ver.4.0           Version              ', &
     '386DX+FPU/486DX/Pentium + NDP-FORTRAN/xxx Version              ', &
     'LUNA-88K (88100+88200) + f77              Version              ', &
     'Transputer (T805) + Parallel fortran (3L) Version              ', &
     'HP 9000 Series (PA-RISC) + f77            Version              ', &
     'IBM-AIX-FORT                              Version              ', &
     'F77 on Sony NEWS-WS                       Version              ', &
     'FTN compilar on DN10000                   Version              ', &
     'Hitachi Super Computer (S820-80)          Version              ', &
     'F77 on CRAY Super Computer                Version              ', &
     'DEC Fortran for Windows NT                Version              ', &
     'F90 for all platform                      Version              ', &
     '                                          Version              ', &
     'PGI Fortran for Windows 2010              Version              '/
!
  if (FLNAME(3) == 'F90           ')  logo3(1) = logo3(12)
  if (FLNAME(3) == 'Dummy         ')  logo3(1) = logo3(13)
!
  IF (RUNOPT(17)  == 'CRYSTAL   ')  THEN
    DO I = 1, 18
      LOGO1(I) = LOGO2(I)
    enddo
  END IF
!
  CALL  TMATRX
!
  IF (RUNOPT(8) /= 'METAL     ' .and. &
      RUNOPT(8) /= 'VASHISHTA ')  CALL  COULMB
!
! -------------------------------------------------------- LOGO mark
  IF (IPR == 1) THEN
          write(16,'("I--", 128("-"), "I")')
       KLEM = LEM/10
       DO KKK = 1, KLEM
    WRITE (16,5000) (REAL(NION(I))/REAL(NFORML),ATOM(I),I=1+10*(KKK-1),10*KKK)
       enddo
          write(16,'("I--", 128("-"), "I")')
    WRITE (16,5001) BOX(1),BOX(4), &
                           BOX(2),BOX(5),      LOGO1(1), &
                           BOX(3),BOX(6),      LOGO1(2), LOGO1(3), &
                           DENSTY,             LOGO1(4), LOGO1(5)
    WRITE (16,5002) RUNOPT(8),MODE,NVN, LOGO1(6), &
                          ALPHA,RCUT(1),LOGO1(7), &
                              LOGO1(8), LOGO1(9)
 5000      FORMAT( 'I  Formula = ',10(F6.3,A2,1X), 26X,'  I')
 5001      FORMAT('I  Basic cell : A=',F10.5,' A   cos(alpha)=',F9.5, &
                                                  10X,'I  ',63X, '  I'/ &
                  'I               B=',F10.5,' A   cos(beta )=',F9.5, &
                                                  10X,'I  ',A63, '  I'/ &
                  'I               C=',F10.5,' A   cos(gamma)=',F9.5, &
                                                  10X,'I  ',A63, '  I'/ &
                  'I--',60('-'),'I  ', A63, '  I' / &
                  'I  Density    : ',F12.7,' g/cm3',29X,'I  ',A63, &
                                                                '  I' / &
                  'I--',60('-'),'I  ',A63, '  I' )
 5002      FORMAT('I  ',A8,'  I    Mode =',I3, 13X, 'No.of Nv=',I7, & !Ewald-opt
                                                   7X,'I  ',A63,'  I' / & !Ewald-opt
                  'I  ',8X,'  I    Alpha=',F6.3,' A-1      Rcut(L) =', &
                                      F7.3,' A', 5X,'I  ', A63, '  I' / &
                  'I--',60('-'),'I  ', A63,'  I' / &
                  'I     Atom    No    Z      W      A       B', &
                          7X,'C       D    I  ',A63,'  I' )
!
    DO I = 1, 8
      WRITE (16,5005) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                    AIO(I), BIO(I), CIO(I), DIO(I), LOGO1(I+9)
 5005 FORMAT('I', I3, 2X, A3, I6, F8.3, F7.2, F8.4, 3F8.3,' I  ',A63,'  I' )
    enddo
    I = 9
    WRITE (16,5006) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                  AIO(I), BIO(I), CIO(I), DIO(I),LOGO3(1),FLNAME(2)
    do I = 10,LEM
    WRITE (16,5006) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                  AIO(I), BIO(I), CIO(I), DIO(I),'     ', '     '
    enddo
 5006 FORMAT('I', I3, 2X, A3, I6, F8.3, F7.2, F8.4, 3F8.3,' I  ',A50,A13,'  I' )
  END IF
!
! ------------------------------------------------------ Short range
  IF (RUNOPT(8) == 'METAL     ')  CALL  METALP  (IPR)
  IF (IPR == 1)  THEN
    IF (RUNOPT(8) == '          ')  CALL  BUSING
    IF (RUNOPT(8) == 'BUSING    ')  CALL  BUSING
    IF (RUNOPT(8) == 'STSUNE    ')  CALL  BUSING
    IF (RUNOPT(8) == 'MORSE     ')  CALL  MORSEP
    IF (RUNOPT(8) == 'MORSE-AT  ')  CALL  MORSEP
    IF (RUNOPT(8) == 'BMH-EXP   ')  CALL  BMHEXP(0)  !WATER-POL 
    IF (RUNOPT(8) == 'BMH-EXP*  ')  CALL  BMHEXP(0)  !WATER-POL
    IF (RUNOPT(8) == 'BELONO    ')  CALL  MORSEP
    IF (RUNOPT(8) == 'TOSIFUMI  ')  CALL  TOSIFU
    IF (RUNOPT(8) == 'WOODCOCK  ')  CALL  ANGELP
    IF (RUNOPT(8) == 'PAULING   ')  CALL  ANGELP
    IF (RUNOPT(8) == 'VASHISHTA ')  CALL  VASHIS
    IF (RUNOPT(8) == 'L-J       ')  CALL  LJMODL
    IF (RUNOPT(8) == 'PAIR-P    ')  CALL  PAIRP
!
    IF (RUNOPT(3) == 'DETAIL    ') THEN
      DO I = 10, 300, 10
        RIJ = I * 0.01
        WRITE (16,6666)  RIJ, E0(I)*1E8,(E1(I,J)*1E8,J=1,NPAIR)
      enddo
      WRITE (16,6666)
      DO I = 10, 300, 10
        RIJ = I * 0.01
        WRITE (16,6666) RIJ,F0(I),(F1(I,J),J=1,NPAIR)
      enddo
      WRITE (16,6666)
      DO I = 10, 300, 10
        RIJ = I * 0.01
        WRITE (16,6666) RIJ,F0(I),(F1(I,J)+zij(j)*F0(i),J=1,NPAIR)
      enddo
 6666 FORMAT (2X,F5.2,1X,F10.6,1X,10F11.7)
    END IF
  END IF
!
  ECORR = 0.0D0
  VCORR = 0.0D0
  IF (RUNOPT(8) == '          ' .OR. RUNOPT(8) == 'BUSING    ' .OR. &
      RUNOPT(8) == 'STSUNE    ' .OR. RUNOPT(8) == 'MORSE     ' .OR. &
      RUNOPT(8) == 'MORSE-AT  ' .OR. RUNOPT(8) == 'BMH-EXP   ' .OR. &
                                     RUNOPT(8) == 'BMH-EXP*  ' .OR. &
      RUNOPT(8) == 'BELONO    ' .OR. RUNOPT(8) == 'PAIR-P    ' .OR. &
      RUNOPT(8) == 'TOSIFUMI  ' .OR. RUNOPT(8) == 'WOODCOCK  ' .OR. &
      RUNOPT(8) == 'PAULING   ' .OR. RUNOPT(8) == 'L-J       ') THEN
    CALL  VWCORR(0)  !WATER-POL
  END IF
RETURN
END
!
!
!                                                               ========
!================================================================ TMATRX
SUBROUTINE  TMATRX
  use param
  use aboxof
  use paramt
  use cartes
!
  implicit none
!
  REAL *8         SINA(3), COSA(3), DET, GG
  integer *4      i,j,k,n
! ---------------------------- cos and sin of alpha, beta, and gamma
  DO I = 1, 3
    COSA(I) = BOX(I+3)
    IF (BOX(I+3) > 1.0)  THEN
      COSA(I)  = COS(BOX(I+3)*PI/180.0D0)
      BOX(I+3) = COSA(I)
    END IF
    SINA(I) = SQRT(1.0D0 - COSA(I)**2)
  enddo
!
!     ------------------ Transformation matrix from crystal to Cartesian
!
  H(1,3) =  0.D0
  H(2,3) =  0.D0
  H(3,3) =  BOX(3)
  H(1,2) =  0.0D0
  H(2,2) =  BOX(2)*SINA(1)
  H(3,2) =  BOX(2)*COSA(1)
  H(3,1) =  BOX(1)*COSA(2)
  H(2,1) =  BOX(1)*COSA(3)*SINA(1)
  H(1,1) =  BOX(1)*SQRT(1-COSA(2)**2-(COSA(3)*SINA(1))**2)
  VOL = H(3,1)*(H(1,2)*H(2,3) - H(2,2)*H(1,3)) -   &
        H(2,1)*(H(1,2)*H(3,3) - H(3,2)*H(1,3)) +   &
        H(1,1)*(H(2,2)*H(3,3) - H(3,2)*H(2,3))
  IF (VOL <= 0.0D0)  THEN
    H(1,1) = - H(1,1)
    H(2,1) = - H(2,1)
    H(3,1) = - H(3,1)
    VOL    = - VOL
  END IF
  DENSTY = TWEGHT / (ANA * VOL * 1.0D-24)
!
!             WRITE (*,*)  H(1,1), H(2,1), H(3,1)
!             WRITE (*,*)  H(1,2), H(2,2), H(3,2)
!             WRITE (*,*)  H(1,3), H(2,3), H(3,3)
!             WRITE (*,*)  VOL
!
!     ------------------ Transformation matrix from Cartesian to crystal
!
  CALL  INVERS  (H, DET, HINV)
!
!
!             WRITE (*,*)  HINV(1,1), HINV(2,1), HINV(3,1)
!             WRITE (*,*)  HINV(1,2), HINV(2,2), HINV(3,2)
!             WRITE (*,*)  HINV(1,3), HINV(2,3), HINV(3,3)
!
!     ---------------------------------------------------- Metric tensor
  DO I = 1, 3
    DO J = 1, 3
      GG = 0.0D0
      DO K = 1, 3
        GG = GG + H(K,J) * H(K,I)
      enddo
      G(J,I) = GG
    enddo
  enddo
!
  CALL  INVERS  (G, DET, GINV)
!     -------------------------- Trans. of reciprocal force to cartesian
!
  FTOQ(1,1) = H(1,1) / BOX(1)
  FTOQ(2,1) = H(2,1) / BOX(1)
  FTOQ(3,1) = H(3,1) / BOX(1)
  FTOQ(1,2) = H(1,2) / BOX(2)
  FTOQ(2,2) = H(2,2) / BOX(2)
  FTOQ(2,3) = H(3,2) / BOX(2)
  FTOQ(1,2) = H(1,3) / BOX(3)
  FTOQ(2,2) = H(2,3) / BOX(3)
  FTOQ(2,3) = H(3,3) / BOX(3)
!
!     --------------------------------------- Reciprocal cell parameters
  RBOX(1) =  BOX(2)*BOX(3)*SINA(1) / VOL
  RBOX(2) =  BOX(1)*BOX(3)*SINA(2) / VOL
  RBOX(3) =  BOX(1)*BOX(2)*SINA(3) / VOL
  RBOX(4) = (COSA(2)*COSA(3)-COSA(1)) / (SINA(2)*SINA(3))  !cos alpha*
  RBOX(5) = (COSA(1)*COSA(3)-COSA(2)) / (SINA(1)*SINA(3))  !cos beta*
  RBOX(6) = (COSA(1)*COSA(2)-COSA(3)) / (SINA(1)*SINA(2))  !cos gamma*
!     ---------------------------------------
  IF (RCUT(1) < 0.01D0)           RCUT(1)  = 15.0D0
  IF (RCUT(1) > 1.0D0/RBOX(1)/2.0D0)  RCUT(1)  = 1.0D0/RBOX(1)/2.0D0
  IF (RCUT(1) > 1.0D0/RBOX(2)/2.0D0)  RCUT(1)  = 1.0D0/RBOX(2)/2.0D0
  IF (RCUT(1) > 1.0D0/RBOX(3)/2.0D0)  RCUT(1)  = 1.0D0/RBOX(3)/2.0D0
  NRCUT(1) = INT(RCUT(1)*100.0D0 + 2.5D0)
!     IF (NRCUT(1) < LSR)           NRCUT(1) = LSR
  IF (MXCUT > NRCUT(1))         MXCUT    = NRCUT(1)
  IF (RCUT(2) < 0.01D0)           RCUT(2)  = 7.5D0
  IF (RCUT(2) > RCUT(1))        RCUT(2)  = RCUT(1)
  IF (RCUT(2) > DBLE(LSR-1)*0.01D0)   RCUT(2)  = DBLE(LSR-1)*0.01D0
  NRCUT(2) = INT(RCUT(2)*100.0D0 +3.01D0)
!
!     -- (0,0,0),(1,0,0),(0,1,0),(0,0,1),(1,1,0),(1,0,1),(0,1,1),(1,1,1)
!
  N = 0
  DO I = 0, 1
    DO J = 0, 1
      DO K = 0, 1
        N = N + 1
        TRANSX(N) = I
        TRANSY(N) = J
        TRANSZ(N) = K
      enddo
    enddo
  enddo
RETURN
END
!
!
!                                                               ========
!================================================================ INVERS
SUBROUTINE  INVERS  (X, DET, XINV)
!     -------------------------------------------- Given 3 by 3 matrix X
!                           Store determinant at DET and inverse at Xinv
!
  implicit none
!
  REAL  *8  DET, X(3,3), XINV(3,3)
!
  DET = X(1,1)*X(2,2)*X(3,3) + X(1,2)*X(2,3)*X(3,1) +   &
        X(1,3)*X(2,1)*X(3,2) - X(1,3)*X(2,2)*X(3,1) -   &
        X(1,2)*X(2,1)*X(3,3) - X(1,1)*X(2,3)*X(3,2)
  IF (DET == 0.0D0)  GO TO 10
  XINV(1,1) = (X(2,2)*X(3,3) - X(3,2)*X(2,3)) / DET
  XINV(1,2) = (X(3,2)*X(1,3) - X(1,2)*X(3,3)) / DET
  XINV(1,3) = (X(1,2)*X(2,3) - X(2,2)*X(1,3)) / DET
  XINV(2,1) = (X(2,3)*X(3,1) - X(3,3)*X(2,1)) / DET
  XINV(2,2) = (X(3,3)*X(1,1) - X(1,3)*X(3,1)) / DET
  XINV(2,3) = (X(1,3)*X(2,1) - X(2,3)*X(1,1)) / DET
  XINV(3,1) = (X(2,1)*X(3,2) - X(3,1)*X(2,2)) / DET
  XINV(3,2) = (X(3,1)*X(1,2) - X(1,1)*X(3,2)) / DET
  XINV(3,3) = (X(1,1)*X(2,2) - X(2,1)*X(1,2)) / DET
RETURN
!     --------------------------------------------- TEST FOR SINGULARITY
10    IF (DET == 0)  WRITE  (*,6180)
6180         FORMAT(5X,'*** The matrix is singular ***')
RETURN
END
!
!
!                                                               ========
!================================================================ PTOXYZ
!
!     SUBROUTINE  PTOXYZ  (I)
!     use param
!     use atomsi
!     use cartes
!
!
!T    REAL *8        PX,PY,PZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CRYSTAL TO CARTESIAN (X,Y,Z)
!
!T              PX = P(1,I)
!T              PY = P(2,I)
!T              PZ = P(3,I)
!T      Q(1,I)  = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
!T      Q(2,I)  = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
!T      Q(3,I)  = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!
!T              PX = P0(1,I)
!T              PY = P0(2,I)
!T              PZ = P0(3,I)
!T      Q0(1,I) = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
!T      Q0(2,I) = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
!T      Q0(3,I) = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!     RETURN
!     END
!
!
!                                                               ========
!================================================================ XYZTOP
SUBROUTINE  XYZTOP
  use param
  use atomsi
  use cartes
!
  implicit none
!
!T    REAL *8        QX,QY,QZ
  integer *4 I
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CARTESIAN (X,Y,Z) TO CRYSTAL
!
  DO I = 1, NTION
!              QX = Q(1,I)
!              QY = Q(2,I)
!              QZ = Q(3,I)
!         P(1,I)  = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
!         P(2,I)  = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
!         P(3,I)  = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
!
!              QX = Q0(1,I)
!              QY = Q0(2,I)
!              QZ = Q0(3,I)
!         P0(1,I) = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
!         P0(2,I) = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
!         P0(3,I) = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
  enddo
RETURN
END
!
!
!                                                               ========
!================================================================ COULMB
SUBROUTINE  COULMB
  use param
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use cartes
  use charge
  use molecu
  use charac
  use ewal
!
!
  implicit none
!
!     ------------------------------------ Table for Coulomb interaction
!
!
  REAL     *8     XN,FCT, AL2PI,RIJ,ARIJ,PIAL2,VN2,EXPVN
  real     *8     YN,UCT, PAA2,ELC2,ASP,ACOR,ERFC,alphal
  real     *8     ZN,PCT, Z, X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4
  real     *8     az
  real     *8     ABC2,AB
  INTEGER  *4     MXNV(6)
  integer  *4     I,IO,MAXNV2,IL,JL,KL,IL2,JL2,KL2,II,JJ,J,KK,K
!              MODE       1     2     3     4     5     6
!     MAXIMUM of NV**2    7          15    23    28    31   39
  DATA  MXNV   /      7,   11,   15,   23,   28,   31        /
!     No. of NVs         40    85   125   230   309   369   510
!
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
  DATA  X0,X1,X2,X3   / 10.00464D0, 8.426553D0, 3.460259D0, 0.5623536D0     /
  DATA  Y0,Y1,Y2,Y3,Y4/ 10.00464D0, 19.71558D0, 15.70229D0, 6.090749D0, 1.0D0/
!
  ELC2   = ELC**2
  DO I = 1, NRCUT(1)+1
    E0(I) = 0.0D0
    F0(I) = 0.0D0
  enddo
  NVN    = 0
  UCSELF = 0.0D0
  do i = 1, ntion+ndmole   !WATER-POL
    ZIIA(i) = 0.0D0
  enddo
  DO IO = 1, LEL
    ZIA(IO) = 0.0D0
  enddo
  az = 0.0D0
  do io = 1, ncompo
    az = az + abs(zio(io))
  enddo
  IF (MODE <= -998 .or. az < 0.00001D0)  RETURN
! --------------------------------------- Gaussian (alpha) parameter
  MAXNV2 = ABS(MODE)
  IF (MAXNV2 <= 6)  THEN
    IF (MAXNV2 <= 0)  MAXNV2 = 1
    MAXNV2 = MXNV(MAXNV2)
  END IF
  ABC2  = DBLE(MAXNV2) /(RCUT(1)*2.0D0)**2 * 1.0001D0
  AB    = DSQRT(ABC2)
  IF (ALPHA < 0.001D0) THEN
    ALPHAL  = MAXNV2 * 0.064D0 + 3.714D0 + RCUT(1) * 2.0D0 * 0.027D0
    ALPHA   = ALPHAL / (RCUT(1)*2.0D0)
  END IF
! ------------------------------------------------------ Coulomb [1]
  AL2PI = 2.0D0 * ALPHA / DSQRT(PI)
  DO I = 1, NRCUT(1)+3
    RIJ  = DBLE(I) * 0.01D0
    ARIJ = 1.0D0 / RIJ
!                                --- FUNCTION ERFC(X) : VERSION 5662
!                                ---    in "COMPUTER APPROXIMATIONS"
    Z = ABS(ALPHA * RIJ)
    ERFC = EXP(-Z*Z) * (X0+Z*(X1+Z*(X2+Z*X3))) / (Y0+Z*(Y1+Z*(Y2+Z*(Y3+Z*Y4))))
    ERFC = SIGN(ERFC,Z)
    IF (Z < 0.0D0)  ERFC = 2.0D0 + ERFC
    E0(I) = ERFC * (ARIJ*1.0D8) * ELC2
    F0(I) = ( AL2PI * EXP(-(ALPHA*RIJ)**2) * RIJ + ERFC ) *(ARIJ*1.0D8)**2 * ELC2 * ARIJ
  enddo
!     ------------------------------------------------------ Coulomb [2]
!                        Generate reciprocal vectors for EWALD summation
!                                                  Semi-sphere part only
  FCT   = 4.0D0 * ELC2 *  1.0D-8  / (VOL*1.0D-24)
  UCT   = 2.0D0 * ELC2 *  1.0D-16 / (PI * VOL*1.0D-24)
  PCT   = 2.0D0 * ELC2 *  1.0D-16 / (2.0D0 * PI * VOL*1.0D-24)
  PIAL2 = PI**2 / ALPHA**2
!
  if (runopt(45) /= 'SPME      ') then   !Traditional EWALD
  IL  = INT(BOX(1) * AB + 1.5D0)
  JL  = INT(BOX(2) * AB + 1.5D0)
  KL  = INT(BOX(3) * AB + 1.5D0)
  IL2 = IL * 2 + 1
  JL2 = JL * 2 + 1
  KL2 = KL + 1
!
  DO II = 1, IL2
    I = IL + 1 - II
    XN = dble(I) * RBOX(1)
    DO JJ = 1, JL2
      J = JL + 1 - JJ
      YN = dble(J) * RBOX(2)
      DO KK =  1, KL2
        K = KK - 1
        ZN = dble(K) * RBOX(3)
        IF (K > 0) GO TO 230
        IF (J < 0) cycle
        IF (J == 0 .AND. I <= 0) cycle
  230   VN2 = XN**2+YN**2+ZN**2+2.0D0*(XN*YN*RBOX(6)+YN*ZN*RBOX(4)+XN*ZN*RBOX(5))
        IF (VN2 > ABC2) cycle
        NVN = NVN + 1
        IF (NVN > LNV)  THEN
          WRITE  (*,9901)  ABS(MODE)
 9901     FORMAT (' *****  SET [MODE] LESS THAN ',I2,'  *****')
          STOP
        END IF
        NVEC(1,NVN) = I
        NVEC(2,NVN) = J
        NVEC(3,NVN) = K
        EXPVN = EXP(- VN2 * PIAL2) / VN2
        FNV(NVN) = FCT * EXPVN
        UNV(NVN) = UCT * EXPVN
        PAA2 = 2.0D0 * (PIAL2 + 1.0D0/VN2)
        PNV(1,NVN) = PCT * (1.0D0 - PAA2 * XN**2) * EXPVN
        PNV(2,NVN) = PCT * (1.0D0 - PAA2 * YN**2) * EXPVN
        PNV(3,NVN) = PCT * (1.0D0 - PAA2 * ZN**2) * EXPVN
        PNV(4,NVN) = PCT * (0.0D0 - PAA2 * XN*YN) * EXPVN
        PNV(5,NVN) = PCT * (0.0D0 - PAA2 * XN*ZN) * EXPVN
        PNV(6,NVN) = PCT * (0.0D0 - PAA2 * YN*ZN) * EXPVN
      enddo
    enddo
  enddo
  endif
!     ------------------------------------------------------ Coulomb [3]
  ASP = - (ALPHA*1.0D8) * ELC2 / DSQRT(PI)
  DO IO = 1, NCOMPO
    UCSELF     = UCSELF + DBLE(NION(IO))*ZIO(IO)**2*ASP
    UCSLFI(IO) =          DBLE(NION(IO))*ZIO(IO)**2*ASP
    ZIA(IO)    = ZIO(IO)*ZIO(IO)*ASP*2.0D0
  enddo
  do I = 1, NTION+ndmole                !WATER-POL
    ZIIA(I) = ZII(I)*ZII(I)*ASP*2.0D0
    ZIIC(I) = ZIIA(I) !/2.0D0
  enddo
!
!     ------------------------------------------------------ Coulomb [4]
!     Volume correction term for non-neutral system
! 
  ACOR = -1.0D0*PI*ELC2/2.0D0/(ALPHA*1.0D8)**2/(VOL*1.0D-24)
!write(*,'("Alpha = ",F8.2)')ALPHA
  UCCOR = 0.0D0
  DO IO = 1, NCOMPO
    UCCOR     = UCCOR + DBLE(NION(IO))*ZIO(IO)
  enddo
  UCCOR = UCCOR**2*ACOR
!  write(*,*) 'VOL=',VOL
!  write(*,*) 'UCCOR=',UCCOR
!
RETURN
END
!
!
!                                                               ========
!================================================================ VWCORR
SUBROUTINE  VWCORR(IPOL)  !WATER-POL : IPOL
  use param
  use charac
  use temprs
  use aboxof
  use atomsi
  use paramt
!
  implicit none
!
!     --------- Correction of energy and pressur for Van der Waals terms
!
  real *8  pi4, SATOMS
  integer *4  n,i,j,NNCOMPO,IPOL
!
  PI4 = 4.0D0 * PI
!      BETA  = CAL * 1.0D10 / ANA
!      IF (RUNOPT(8) == 'TOSIFUMI  ')  BETA = 1.0D-19 * 1.0D7
  ECORR = 0.0D0
  VCORR = 0.0D0
  N = 0
  NNCOMPO = NCOMPO    !WATER-POL
  if (IPOL == 1) NNCOMPO = NCOMPO + 1  !WATER-POL
  DO I = 1, NNCOMPO  !WATER-POL
    DO J = 1, I
      N = N + 1
      SATOMS = NION(I) * NION(J) / VOL * PI4
!      SATOMS = NION(I) * NION(J) / VOL * PI4 * BETA
      IF (I == J)  SATOMS = SATOMS / 2.0D0
      ECORR = ECORR - SATOMS*CIJ(N)/3.0D0/RCUT(1)**3-SATOMS*DIJ(N)/5.0D0/RCUT(1)**5
      VCORR = VCORR - 6.0D0*SATOMS*CIJ(N)/3.0D0/RCUT(1)**3 & 
                    - 8.0D0*SATOMS*DIJ(N)/5.0D0/ RCUT(1)**5
      IF (RUNOPT(8) == 'MORSE-PL  ')  THEN
        ECORR = ECORR - SATOMS*D4IJ(N)/RCUT(1)-SATOMS*D7IJ(N)/4.0/RCUT(1)**4
        VCORR = VCORR - 4.0*SATOMS*D4IJ(N)/RCUT(1)-7.0*SATOMS*D7IJ(N)/4.0/RCUT(1)**4
      END IF
    enddo
  enddo
!     WRITE (*,*)  RCUT(2), RCUT(1)
!     WRITE (*,1000) ECORR*FJMOL,
!    *               VCORR / (3.0D0*VOL*1.0D-24)*1.0D-10
!1000 FORMAT (11X, 'Ecorr=',F7.3,'kJ/mol       Pcorr=',F6.3,'GPa')
RETURN
END
!
!
!                                                                =======
!================================================================ MORSEP
SUBROUTINE  MORSEP
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use pmorse
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!                                                    plus MORSE function
!                                                    plus three body
!
  REAL      *8    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  real      *8    EX, ARB, ZFORML(LEM), epsij(lef), sepij(lef)
  real      *8    am3, dm3ij(lef), be3ij(lef), r03ij(lef)
  CHARACTER *40   FMT1, FMT2
  real      *8    ELC2,DIJP,BEIJP,RSIJP,R3BG,GGG,R3BLIM2,R3BGRD2
  integer   *4    I,N,II,J,IP,JP,KP,IJKL,IJ,LCOMPO,LPAIR
!
  ELC2 = ELC * ELC
  BETA = CAL * 1.0D10 / ANA
!
  N3BP = 0
  DO I = 1,4 
    I3BP(I) = 0
    J3BP(I) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0 * ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J) * ELC2 * 1.0D8
      DMIJ(N) = 0.0
      BEIJ(N) = 0.0
      DM3IJ(N) = 0.0
      BE3IJ(N) = 0.0
      r03ij(n) = 0.0
      RSIJ(N) = 0.0
      RSWTCH(N) = 0.0
      epsij(n)  = 1.0
      sepij(n)  = 1.0
    enddo
  enddo
!
  IF (RUNOPT(8) == 'MORSE     '.OR.RUNOPT(8) == 'MORSE-AT  '.OR. &
      RUNOPT(8) == 'BELONO    ' )  THEN
120 READ   (15,'(3I2,i2,2x,4F10.0,10X,F10.0)')IP,JP,KP,ijkl,DIJP,BEIJP,RSIJP,R3BG,GGG
    IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
    IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
    IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
    IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
      IF (KP == 0)  THEN
        IF (JP > IP)  THEN
          IJ = IP
          IP = JP
          JP = IJ
        END IF
        N = (IP - 1) * IP / 2 + JP
        DMIJ(N) = DIJP
        BEIJ(N) = BEIJP
        RSIJ(N) = RSIJP
        RSWTCH(N) = R3BG
        if (ggg > 0.0) read (15,'(10x, 3f10.0)') dm3ij(n),be3ij(n),r03ij(n)
      ELSE IF (IP == KP) THEN
        N3BP = N3BP +1
        I3BP(N3BP) = JP
        J3BP(N3BP) = IP
        K3BP(N3BP) = KP
!       -------------------------------------- F:kJ/mol
        FK3BP(N3BP)    = DIJP
        ANG3BP(N3BP)   = BEIJP
        R3BLIM(1,N3BP) = RSIJP
        R3BGRD(1,N3BP) = R3BG
        IF (ANG3BP(N3BP) <= 0.01)   ANG3BP(N3BP)=  90.0
        IF (R3BLIM(1,N3BP) <= 0.01) R3BLIM(1,N3BP)= 1.2
        IF (R3BGRD(1,N3BP) <= 0.01) R3BGRD(1,N3BP)=20.0
        R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
        R3BGRD(2,N3BP) = R3BGRD(1,N3BP)
      ELSE IF (IP /= KP) THEN
        N3BP = N3BP +1
        I3BP(N3BP) = JP
        J3BP(N3BP) = IP
        K3BP(N3BP) = KP
!       ------------------------------------ F:kJ/mol
        FK3BP(N3BP)    = DIJP
        ANG3BP(N3BP)   = BEIJP
        R3BLIM(1,N3BP) = RSIJP
        R3BGRD(1,N3BP) = R3BG
        IF (ANG3BP(N3BP) <= 0.01)   ANG3BP(N3BP)  =90.0
        IF (R3BLIM(1,N3BP) <= 0.01) R3BLIM(1,N3BP)= 1.2
        IF (R3BGRD(1,N3BP) <= 0.01) R3BGRD(1,N3BP)=20.0
        READ (15,'(30X,2F10.0)')  R3BLIM2, R3BGRD2
        IF (R3BLIM2 <= 0.01) R3BLIM2 = R3BLIM(1,N3BP)
        IF (R3BGRD2 <= 0.01) R3BGRD2 = R3BGRD(1,N3BP)
        R3BLIM(2,N3BP) = R3BLIM2
        R3BGRD(2,N3BP) = R3BGRD2
      ELSE
        STOP 'Something wrong in potetial param.'
      END IF
      GO TO 120
    END IF
    if (runopt(8) == 'BELONO    ') then
      read (15,'(10f5.0)')  zforml
      N = 0
      DO I = 1, NCOMPO
        II = I
        DO J = 1, II
          N = N + 1
          epsij(N)  = ABS(zio(II)/zforml(II))*abs(zio(J) /zforml(J))
          sepij(N)  = DSQRT(1.0D0 - epsij(N))
        enddo
      enddo
    end if
    LCOMPO = NCOMPO
    IF (LCOMPO > 7)  LCOMPO = 7
    LPAIR  = LCOMPO*(LCOMPO+1)/2
    FMT1 = '( 3H I ,9X,    3(5X,A2,1H-,A2),90X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,   3F10.3,    90X,1HI )'
    IF (NCOMPO == 3) THEN
      FMT1 = '( 3H I ,9X,    6(5X,A2,1H-,A2),60X,1HI )'
      FMT2 = '( 3H I ,4X,A4,1X,   6F10.3,    60X,1HI )'
    ELSE IF (NCOMPO == 4) THEN
      FMT1 = '( 3H I ,9X,  10(5X,A2,1H-,A2), 20X,1HI )'
      FMT2 = '( 3H I ,4X,A4,1X,  10F10.3,    20X,1HI )'
    ELSE IF (NCOMPO == 5) THEN
      FMT1 = '( 3H I ,7X,   15(3X,A2,1H-,A2), 2X,1HI )'
      FMT2 = '( 3H I ,2X,A4,1X,   15F8.2,     2X,1HI )'
    ELSE IF (NCOMPO == 6) THEN
      FMT1 = '( 3H I ,3X,   21(1X,A2,1H-,A2),    1HI )'
      FMT2 = '( 3H I ,A3,         21F6.2,        1HI )'
    ELSE IF (NCOMPO == 7) THEN
      FMT1 = '( 3H I ,5X,   28(1X,A1,1H-,A1),12X,1HI )'
      FMT2 = '( 3H I ,1X,A4,1X,  28F4.1,     12X,1HI )'
    END IF
    WRITE (16, '("I  ", 60(" "), "I--", 63("-"), "--I" )')
    WRITE (16,FMT1)  ((ATOM(I),ATOM(J),J=1,I),I=1,LCOMPO)
    WRITE (16,FMT2)  'Dij ', (DMIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'BEij', (BEIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'RSij', (RSIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'D3ij', (DM3IJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'BE3ij',(BE3IJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'R03IJ',(R03IJ(J),J=1,LPAIR)
    if (RUNOPT(8) == 'BELONO    ')  then
      write (16,fmt2)  'EPij', (EPSij(J),J=1,LPAIR)
      write (16,fmt2)  'SEij', (SEPij(J),J=1,LPAIR)
    end if
    DO N = 1, N3BP
      IF (I3BP(N)*J3BP(N) > 0) THEN
        WRITE (16,6667) I3BP(N),J3BP(N),ATOM(J3BP(N)),  &
                          ATOM(I3BP(N)),ATOM(J3BP(N)),  &
                                   FK3BP(N),ANG3BP(N),  &
                              R3BLIM(1,N),R3BGRD(1,N)
 6667           FORMAT ('I  ',60(' '),'   ', 63(' '),'  I' / &
                 ' I',4X,'3-body potential :',2I3,3X,A2,'-', &
                          A2,'-',A2, F13.8, 3F10.3, 48X, 'I')
      END IF
    enddo
  END IF
!
  DO I = 10, NRCUT(2)
    RIJ  = REAL(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      E1M     = 0.0
      F1M     = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5)  GO TO 220
      EX = 0.0
      IF (BIJ(J) > 0.00001)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43)*1.6022E-12
      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!    *                              - CIJ(J)*ARIJ**6 )
!    *                      + EALPHA
      F1(I,J) = BETA * EX*EPSIJ(J)
!    *                               - 6.0*CIJ(J)*ARIJ**7)
!    *                      + 4.0*EALPHA*ARIJ + EALPHA/4.43
  220 IF (DMIJ(J) < 0.01)  GO TO 230
      IF (RUNOPT(8) == 'MORSE     '.OR. RUNOPT(8) == 'MORSE-PL  '.OR. &
          RUNOPT(8) == 'BELONO    ' )  THEN
        AM1 = EXP(-2.0*BEIJ(J)*(RIJ-RSIJ(J)))
        AM2 = EXP(-1.0*BEIJ(J)*(RIJ-RSIJ(J)))
        am3 = dm3ij(j)*exp(-be3ij(j)*(rij-r03ij(j))**2)
        E1M= (BETA*DMIJ(J) *(AM1 - 2.0*AM2) +BETA*am3)* SEPij(J)
        F1M= BETA*BEIJ(J) *DMIJ(J) * (2.0*AM1 -2.0*AM2) * SEPij(J)   &
             +BETA*(2.0*be3ij(j)*(rij-r03ij(j))*am3) *SEPij(J)
      END IF
      IF (RUNOPT(8) == 'MORSE-AT  ')  THEN
        AM2 = DMIJ(J)*EXP(-BEIJ(J)*RIJ)
        E1M = - BETA * AM2
        F1M = - BETA * BEIJ(J) * AM2
      END IF
      IF (RSWTCH(J) < 1.0E-6)  THEN
        E1(I,J) = E1(I,J) + E1M
        F1(I,J) = F1(I,J) + F1M
      ELSE IF (RIJ <= RSWTCH(J)) THEN
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
  230 F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
RETURN
END
!
!
!                                                                =======
!================================================================ BMHEXP
SUBROUTINE  BMHEXP(IPOL)  !WATER-POL:IPOL
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use pmorse
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                BORN-MAYER-HUGGINS type plus Expornential type function
!                                               plus gauss type function
!                                                        plus three body
!
!
  REAL      *8    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  real      *8    E1M12,E1M3, F1M12, F1M3
  real      *8    EX, ARB, epsij(lef), sepij(lef)
  real      *8    am3
  real      *8, save :: dm3ij(lef), be3ij(lef), r03ij(lef), RSWTCHCO(lef) !WATER-POL
  real      *8    ELC2,D1,BE1,D2,BE2,RSIJP,GGG,r3blim2,r3bgrd2,r3lim
  integer   *4    ipara(2,10), npara
  integer   *4    I,N,II,J,IP,JP,KP,ijkl,IJ,IPOL,k
  integer*4 ::IP1=0,JP1=0,KP1=0,IP2=0,JP2=0,KP2=0
  real      *8    apara(9,10)
  character*1 insIP1,insJP1,insKP1,insIP2,insJP2,insKP2
!
  ELC2 = ELC * ELC
  BETA = CAL * 1.0D10 / ANA
!
  if (IPOL == 1) goto 250   !WATER-POL
  N3BP = 0
  DO I = 1, 4
    I3BP(I) = 0
    J3BP(I) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO + 1) / 2
  N = 0
! N(I,J)
! 1(1,1) 2(2,1) 3(2,2) 4(3,1) 5(3,2) 6(3,3) ....
! 
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0* ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J)* ELC2 * 1.0D8
      ZIJ(N)  = ZIO(I)*ZIO(J)
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      DM3IJ(N) = 0.0D0
      BE3IJ(N) = 0.0D0
      r03ij(n) = 0.0D0
      RSWTCH(N) = 0.0D0
      RSWTCHCO(N) = 0.0D0
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
    enddo
  enddo
!
  npara = 0
  120 READ   (15,'(6(A1),i2,2X,6F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
!             write (6,'(3(i2,1x),i2,2x, 6F10.0)')  IP,JP, KP, ijkl, &
!                    D1, BE1, D2, BE2, RSIJP, GGG
     IP = 0
     JP = 0
     KP = 0
     IP1 = 0
     IP2 = 0
     JP1 = 0
     JP2 = 0
     KP1 = 0
     KP2 = 0
     do k=1,LEL
        if (insIP1 == ins(k)) IP1=k
        if (insJP1 == ins(k)) JP1=k
        if (insKP1 == ins(k)) KP1=k
        if (insIP2 == ins(k)) IP2=k
        if (insJP2 == ins(k)) JP2=k
        if (insKP2 == ins(k)) KP2=k
     enddo
!      write(*,*)IP1,IP2,JP1,JP2,KP1,KP2
     if (IP1 > 0) IP = IP1
     if (JP1 > 0) JP = JP1
     if (KP1 > 0) KP = KP1
     if (IP2 > 0) IP = IP2
     if (JP2 > 0) JP = JP2
     if (KP2 > 0) KP = KP2
!
  IF (IP >= 1 .AND. IP <= NCOMPO .AND. JP >= 1 .AND. JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP 
      if (ijkl == 1)  then
        AIJ(N)  = 0.0D0
        BIJ(N)  = 0.0D0
        CIJ(N)  = 0.0D0
        DIJ(N)  = 0.0D0
        D4IJ(N) = 0.0D0
        D7IJ(N) = 0.0D0
      end if
      DM1IJ(N) = D1
      BE1IJ(N) = BE1
      DM2IJ(N) = D2
      BE2IJ(N) = BE2
      RSWTCH(N) = RSIJP
      if (ggg > 0.0D0) read (15,'(10x, 4f10.0)') dm3ij(n),be3ij(n),r03ij(n),RSWTCHCO(n)
      npara = npara + 1
      ipara(1,npara) = ip
      ipara(2,npara) = jp
      apara(1,npara) = d1
      apara(2,npara) = be1
      apara(3,npara) = d2
      apara(4,npara) = be2
      apara(5,npara) = dm3ij(n)
      apara(6,npara) = be3ij(n)
      apara(7,npara) = r03ij(n)
      apara(8,npara) = rsijp
      apara(9,npara) = RSWTCHCO(n)
    ELSE IF (IP == KP) THEN     !------------------ j-i-j
      N3BP = N3BP +1
      I3BP(N3BP) = JP
      J3BP(N3BP) = IP
      K3BP(N3BP) = KP
!     -------------------------------------- F:kJ/mol
      FK3BP(N3BP)  = D1
      ANG3BP(N3BP) = BE1
      R3BLIM(1,N3BP) = D2
      R3BGRD(1,N3BP) = BE2
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 1.2D0
      IF (R3BGRD(1,N3BP) <= 0.01D0) R3BGRD(1,N3BP)=20.0D0
      R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
      R3BGRD(2,N3BP) = R3BGRD(1,N3BP)
    ELSE IF (IP /= KP) THEN    !------------------- J-i-k
      N3BP = N3BP +1
!      write (6,*)  ip,jp,kp
      I3BP(N3BP) = JP
      J3BP(N3BP) = IP
      K3BP(N3BP) = KP
!     -------------------------------------- F:kJ/mol
      FK3BP(N3BP)    = D1
      ANG3BP(N3BP)   = BE1
      R3BLIM(1,N3BP) = D2
      R3BGRD(1,N3BP) = BE2
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 1.2D0
      IF (R3BGRD(1,N3BP) <= 0.01D0) R3BGRD(1,N3BP)=20.0D0
      READ (15,'(30X,2F10.0)')  R3BLIM2, R3BGRD2
      IF (R3BLIM2 <= 0.01D0) R3BLIM2 = R3BLIM(1,N3BP)
      IF (R3BGRD2 <= 0.01D0) R3BGRD2 = R3BGRD(1,N3BP)
      R3BLIM(2,N3BP) = R3BLIM2
      R3BGRD(2,N3BP) = R3BGRD2
    ELSE
      STOP 'Something wrong in potetial param.'
    END IF
    GO TO 120
  END IF
!
  write (16,6661)
  if (npara > 0) then
    do i = 1, npara
      WRITE (16, 6663)  ATOM(Ipara(1,i)),ipara(1,i), &
                        ATOM(ipara(2,i)),ipara(2,i), (apara(j,i),j=1,8)
    enddo
  end if
!
250 continue
  if (N3BP > 0)  THEN
    if (ipol == 1) write(16,'("!!!3-body potential was reloaded for water-pol!!!")')
    WRITE (16,6666)
    DO N = 1, N3BP
      IF (I3BP(N)*J3BP(N) > 0) THEN
        R3LIM = DLOG(0.999999D0/1.0D-6)/R3BGRD(1,N)+ R3BLIM(1,N)
        IF (runopt(34) == 'WATER-POL ') then
          R3LIM = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,N) + R3BLIM(1,N)  !WATER-POL
        endif
        if (runopt(8) == 'BMH-EXP*  ') then
          R3LIM = DLOG(0.9999D0/0.0001D0)/R3BGRD(1,N)+ R3BLIM(1,N)
        end if
!        r3lim(2,n) = r3lim(1,n)
!        if (r3limax < r3lim(1,n))  r3limax=r3lim(1,n)
        WRITE (16,6667)  ATOM(J3BP(N)), J3BP(N), &
                         ATOM(I3BP(N)), I3BP(N), &
                         ATOM(K3BP(N)), K3BP(N), &
             FK3BP(N),ANG3BP(N),i3bp(n),j3bp(n), &
                 R3BLIM(1,N), R3BGRD(1,N), R3LIM
        if (J3BP(N) /= K3BP(N)) then
          R3LIM = DLOG(0.999999D0/1.0D-6)/R3BGRD(2,N)+ R3BLIM(2,N)
          IF (runopt(34) == 'WATER-POL ') then
            R3LIM = DLOG(0.999999D0/1.0D-8)/R3BGRD(2,N)+ R3BLIM(2,N)
          endif
          if (runopt(8) == 'BMH-EXP*  ') then
            R3LIM = DLOG(0.9999D0/0.0001D0)/R3BGRD(2,N)+ R3BLIM(2,N)
          end if
!          if (r3limax < r3lim(2,n)) r3limax=r3lim(2,n)
          WRITE (16,6668)  i3bp(n),k3bp(n),R3BLIM(2,N),R3BGRD(2,N),R3LIM
        end if
      END IF
    enddo
  END IF
!
!250 CONTINUE  !WATER-POL
  IF (IPOL == 1) then
    N = (NCOMPO) * (NCOMPO+1) / 2
    NPAIR = (NCOMPO+1) * (NCOMPO+2) / 2
!   N(I,J)
!   1(1,1) 2(2,1) 3(2,2) 4(3,1) 5(3,2) 6(3,3) ....
! 
    II = NCOMPO+1
    DO J = 1, NCOMPO+1
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0* ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J)* ELC2 * 1.0D8
      ZIJ(N)  = ZIO(II)*ZIO(J) !Correct bug ZIO(I) -> ZIO(II) This is though not used in WATER-POL actually.
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      DM3IJ(N) = 0.0D0
      BE3IJ(N) = 0.0D0
      r03ij(n) = 0.0D0
      RSWTCH(N) = 0.0D0
      RSWTCHCO(N) = 0.0D0
    enddo
  ENDIF
!
  DO I = 1, NRCUT(2)
    RIJ  = DBLE(I) * 0.01D0
    ARIJ = 1.0D0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0D0
      F1(I,J) = 0.0D0
      E1M     = 0.0D0
      F1M     = 0.0D0
      IF (ABS(AIJ(J)) < 1.0D-5)  GO TO 220
      EX = 0.0D0
      IF (BIJ(J) > 1.0D-5)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0D0)  EX = EXP(ARB)
      END IF
      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43D0)*1.6022D-12
      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!    *                      - CIJ(J)*ARIJ**6
!    *                      - D4IJ(J)*ARIJ**4 - D7IJ(J)*ARIJ**7
      F1(I,J) = BETA * EX*EPSIJ(J)
!    *                      - 6.0D0*CIJ(J)*ARIJ**7
!    *                      - 4.0D0*D4IJ(J)*ARIJ**5 - 7.0D0*D7IJ(J)*ARIJ**8
!    *                      - 4.0D0*D4IJ(J)*ARIJ**5 - D4IJ(J)*ARIJ**4/4.43D0
!
  220 CONTINUE
      AM1 = DM1IJ(J)*EXP(-BE1IJ(J)*RIJ)
      AM2 = DM2IJ(J)*EXP(-BE2IJ(J)*RIJ)
      am3 = dm3ij(j)*exp(-be3ij(j)*(rij-r03ij(j))**2)
      E1M =  BETA * (AM1 + AM2 + am3)   !Beta kcal/mol -> erg
      F1M =  BETA * (BE1IJ(J)*AM1 + BE2IJ(J)*AM2 +2.0D0*be3ij(j)*(rij-r03ij(j))*am3)
      E1M12 = BETA * (AM1 + AM2)
      E1M3  = BETA * AM3
      F1M12 = BETA * (BE1IJ(J)*AM1 + BE2IJ(J)*AM2)
      F1M3  = BETA * 2.0d0*be3ij(j)*(rij-r03ij(j))*am3
      IF (RSWTCH(J) < 1.0D-6)  THEN
        E1(I,J) = E1(I,J) + E1M
        F1(I,J) = F1(I,J) + F1M
      ELSE IF (RIJ <= RSWTCH(J)) THEN
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
      IF (IPOL == 1) then
        IF (RIJ > RSWTCHCO(J)) THEN
          E1(I,J) = E1(I,J) - E1M12
          F1(I,J) = F1(I,J) - F1M12
        END IF
      ENDIF
      F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
 6661 format ('I  ', 60(' '), 'I--', 63('-'), '--I' / &
              'I  ',24x,'DM1ij     BE1ij      DM2ij     ', &
              ' BE2ij      DM3ij     BE3ij     R03ij    ', &
              ' Rswch',26x, 'I')
 6663 format ('I   ',A2,'(',i2,') -- ',A2,'(',i2,')  ', &
              3(F11.2, F10.3),F10.3,F10.3, 26X,'I')
 6666 FORMAT ('I  ',60(' '),'   ', 63(' '),'  I' / &
              'I',5X,'3-body potential   ATOM(J)--ATOM(I)', &
              '--ATOM(J)      FK3BP       ANG3BP           ', &
              '  R3BLIM ', &
              '   R3BGRD      R3LIM  ',15X, 'I')
 6667 FORMAT ('I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
               I2,')--',A2,'(',I2,')', F15.8, F11.3, &
               i6,'-',i2, 2F10.3, F12.4,16X, 'I')
 6668 FORMAT ('I',73X, i6,'-',i2,2F10.3, F12.4,16X, 'I')
RETURN
END
!
!
!                                                                =======
!================================================================ VASHIS
SUBROUTINE  VASHIS
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use pmorse
!
  implicit none
!
!     --------------- Vashishta (Vashishta et al., 1990) type potential function
!
!
  REAL      *8    BETA, RIJ,ARIJ, E1M,F1M, AM1
  real      *8    epsij(lef), sepij(lef)
  real      *8    ELC2,D1,BE1,D2,BE2,RSIJP,GGG
  DOUBLE PRECISION HIJ(LEF),OMEGA(LEF),VD4IJ(LEF),VASUNIT
  DOUBLE PRECISION EXPD4, FD4, LAMBDA1(LEF),LAMBDA4(LEF)
  Double precision EXPD4RC,FD4RC,AM1RC,F1MRC
  Double precision EXPD1, FD1, EXPD1RC, FD1RC, COUCOF
  integer   *4    ipara(2,10), npara
  integer   *4    I,N,II,J,IP,JP,KP,ijkl,IJ
  integer   *4    ETAIJ(LEF)
  real      *8    apara(9,10)
!
  ELC2 = ELC * ELC
!  BETA = CAL * 1.0D10 / ANA ! kcal/mol -> erg
  COUCOF = ELCC/(4.0D0*PI*EP0*1.D-10) !eV
  BETA = ELCC * 1.0D7   ! eV -> erg
  VASUNIT = 14.39D0
  N3BP = 0
  DO I = 1, 4
    I3BP(I) = 0
    J3BP(I) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO + 1) / 2
  N = 0
! N(I,J)
! 1(1,1) 2(2,1) 3(2,2) 4(3,1) 5(3,2) 6(3,3) ....
! 
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = 0.0D0 
      BIJ(N)  = 0.0D0 
      CIJ(N)  = 0.0D0
      DIJ(N)  = 0.0D0
      D4IJ(N) = 0.0D0 
      VD4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0* VASUNIT ! eV angstrom^4
      D7IJ(N) = 0.0D0 
      ZIJ(N)  = ZIO(I)*ZIO(J)
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      RSWTCH(N) = 0.0D0
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
    enddo
  enddo
!
  npara = 0
  120 READ   (15,'(3I2,i2,2X,6F10.0)')  IP,JP, KP, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
!             write (6,'(3(i2,1x),i2,2x, 6F10.0)')  IP,JP, KP, ijkl, &
!                    D1, BE1, D2, BE2, RSIJP, GGG
  IF (IP /= 0 .AND. MOD(IP,10) == 0)  IP = IP / 10
  IF (JP /= 0 .AND. MOD(JP,10) == 0)  JP = JP / 10
  IF (KP /= 0 .AND. MOD(KP,10) == 0)  KP = KP / 10
  IF (IP >= 1 .AND. IP <= NCOMPO .AND. JP >= 1 .AND. JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN   !---------------------i-j
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP 
      if (ijkl == 1)  then
        AIJ(N)  = 0.0D0
        BIJ(N)  = 0.0D0
        CIJ(N)  = 0.0D0
        DIJ(N)  = 0.0D0
        D4IJ(N) = 0.0D0
        D7IJ(N) = 0.0D0
      end if
      HIJ(N) = D1   ! Hij [eV angstrom^eta]
      ETAIJ(N) = INT(BE1) ! Eta [-]
      LAMBDA1(N) = D2 ! Lambda_1 [Angstrom]
      IF(LAMBDA1(N) > 0.0d0) then
           ZIO(:)=0.0D0
      ENDIF
      LAMBDA4(N) = BE2 ! Lambda_4 [Angstrom]
      RSWTCH(N) = RSIJP   !rc [ANgstrom]
      OMEGA(N) = GGG  ! Omega [eV Angstrom^6]
!      if (ggg > 0.0D0) read (15,'(10x, 4f10.0)') dm3ij(n),be3ij(n),r03ij(n),RSWTCHCO(n)
      npara = npara + 1
      ipara(1,npara) = ip
      ipara(2,npara) = jp
      apara(1,npara) = d1   !H
      apara(2,npara) = be1  !Eta
      apara(3,npara) = d2   !Lambda_1
      apara(4,npara) = be2  !Lambda_4
      apara(5,npara) = rsijp !rc
      apara(6,npara) = ggg   !Omega
!      apara(7,npara) = r03ij(n)
!      apara(8,npara) = rsijp 
!      apara(9,npara) = RSWTCHCO(n)
    ELSE IF (IP == KP) THEN     !------------------ j-i-j
      N3BP = N3BP +1
      I3BP(N3BP) = JP
      J3BP(N3BP) = IP
      K3BP(N3BP) = KP
!     -------------------------------------- 
      FK3BP(N3BP)  = D1  !B [eV]
      ANG3BP(N3BP) = BE1  !theta0 [Degree]
      R3BLIM(1,N3BP) = D2   !r0 [Angstrom]
      R3BGRD(1,N3BP) = BE2 ! Gamma_ij [Angstrom] 
!      R3BLIM(2,N3BP) = RSIJP !r0_ik [Angstrom]
      CIJK(N3BP) = GGG ! C[-]
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 2.6D0
!      IF (R3BLIM(2,N3BP) <= 0.01D0) R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
!      R3BGRD(2,N3BP) = R3BGRD(1,N3BP) ! Gamma_ik [Angstrom]
      ANG3BP(N3BP)=DCOS(ANG3BP(N3BP)/PI180)  !cos theta0
    ELSE IF (IP /= KP) THEN    !------------------- J-i-k
      N3BP = N3BP +1
!      write (6,*)  ip,jp,kp
      I3BP(N3BP) = JP
      J3BP(N3BP) = IP
      K3BP(N3BP) = KP
!     -------------------------------------- 
      FK3BP(N3BP)    = D1 !B [eV]
      ANG3BP(N3BP)   = BE1 ! theta0 [Degree]
      R3BLIM(1,N3BP) = D2  !r0 [Angstrom]
      R3BGRD(1,N3BP) = BE2 ! Gamma_ij [Angstrom] 
!      R3BLIM(2,N3BP) = RSIJP !r0_ik [Angstrom]
      CIJK(N3BP) = GGG ! C[-]
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 2.6D0
!      IF (R3BLIM(2,N3BP) <= 0.01D0) R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
!      R3BGRD(2,N3BP) = R3BGRD(1,N3BP) ! Gamma_ik [Angstrom]
      ANG3BP(N3BP)=DCOS(ANG3BP(N3BP)/PI180)  !cos theta0
    ELSE
      STOP 'Something wrong in potetial param.'
    END IF
    GO TO 120
  END IF
!
  write (16,6671)
  if (npara > 0) then
    do i = 1, npara
      WRITE (16, 6673)  ATOM(Ipara(1,i)),ipara(1,i), &
                        ATOM(ipara(2,i)),ipara(2,i), (apara(j,i),j=1,6)
    enddo
  end if
!
250 continue
  if (N3BP > 0)  THEN
    WRITE (16,6676)
    DO N = 1, N3BP
      IF (I3BP(N)*J3BP(N) > 0) THEN
        WRITE (16,6677)  ATOM(J3BP(N)), J3BP(N), &
                         ATOM(I3BP(N)), I3BP(N), &
                         ATOM(K3BP(N)), K3BP(N), &
             FK3BP(N),ANG3BP(N),i3bp(n),j3bp(n), &
                 R3BLIM(1,N), R3BGRD(1,N), CIJK(N)
!               B    , theta0   
!               r0   , gamma,  C
        if (J3BP(N) /= K3BP(N)) then
          WRITE (16,6678)  i3bp(n),k3bp(n),R3BLIM(2,N),R3BGRD(2,N),CIJK(N)
        end if
      END IF
    enddo
  END IF
!
!250 CONTINUE  !WATER-POL
!
  DO J = 1, NPAIR
      !  For Shifted Potential
      RIJ=RSWTCH(J)  ! rc
      ARIJ = 1.0D0/RIJ
      EXPD1RC = 0.0D0
      FD1RC = 0.0D0
      IF(LAMBDA1(J)> 0.0D0) then
         EXPD1RC=exp(-1.0d0*RIJ/LAMBDA1(J))
         FD1RC =  (ZIJ(J)*ARIJ*EXPD1RC + ZIJ(J)/LAMBDA1(J)*EXPD1RC)*ARIJ*COUCOF
      ENDIF
      EXPD4RC=exp(-1.0d0*RIJ/LAMBDA4(J))
      FD4RC =  (4.0D0*VD4IJ(J)*ARIJ*EXPD4RC + VD4IJ(J)/LAMBDA4(J)*EXPD4RC)*ARIJ**4
      AM1RC = HIJ(J)*ARIJ**ETAIJ(J) +COUCOF*ZIJ(J)*ARIJ*EXPD1RC - VD4IJ(J)*ARIJ**4*EXPD4RC - OMEGA(J)*ARIJ**6
      F1MRC = HIJ(J)*ETAIJ(J)*ARIJ**(ETAIJ(J)+1) +FD1RC - FD4RC - 6.0D0*OMEGA(J)*ARIJ**7
    DO I = 1, NRCUT(2)
      RIJ  = DBLE(I) * 0.01D0
      ARIJ = 1.0D0 / RIJ
      E1(I,J) = 0.0D0
      F1(I,J) = 0.0D0
      E1M     = 0.0D0
      F1M     = 0.0D0
!      IF (ABS(AIJ(J)) < 1.0D-5)  GO TO 220
!      EX = 0.0D0
!      IF (BIJ(J) > 1.0D-5)  THEN
!        ARB = (AIJ(J) - RIJ) / BIJ(J)
!        IF (ARB > -128.0D0)  EX = EXP(ARB)
!      END IF
!      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43D0)*1.6022D-12
!      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!!    *                      - CIJ(J)*ARIJ**6
!!    *                      - D4IJ(J)*ARIJ**4 - D7IJ(J)*ARIJ**7
!      F1(I,J) = BETA * EX*EPSIJ(J)
!!    *                      - 6.0D0*CIJ(J)*ARIJ**7
!!    *                      - 4.0D0*D4IJ(J)*ARIJ**5 - 7.0D0*D7IJ(J)*ARIJ**8
!!    *                      - 4.0D0*D4IJ(J)*ARIJ**5 - D4IJ(J)*ARIJ**4/4.43D0
!
  220 CONTINUE
      EXPD1 = 0.0D0
      FD1 = 0.0D0
      IF(LAMBDA1(J)> 0.0D0) then
         EXPD1=exp(-1.0d0*RIJ/LAMBDA1(J))
         FD1 =  (ZIJ(J)*ARIJ*EXPD1 + ZIJ(J)/LAMBDA1(J)*EXPD1)*ARIJ*COUCOF
      ENDIF
      EXPD4=exp(-1.0d0*RIJ/LAMBDA4(J))
      FD4 =  (4.0D0*VD4IJ(J)*ARIJ*EXPD4 + VD4IJ(J)/LAMBDA4(J)*EXPD4)*ARIJ**4 
      AM1 = HIJ(J)*ARIJ**ETAIJ(J) +COUCOF*ZIJ(J)*ARIJ*EXPD1 - VD4IJ(J)*ARIJ**4*EXPD4 - OMEGA(J)*ARIJ**6
      E1M =  BETA * (AM1-AM1RC+(RIJ-RSWTCH(J))*F1MRC)   !Beta eV -> erg
      F1M =  BETA * (HIJ(J)*ETAIJ(J)*ARIJ**(ETAIJ(J)+1) +FD1 - FD4 - 6.0D0*OMEGA(J)*ARIJ**7 -F1MRC)
      IF (RIJ <= RSWTCH(J)) THEN !RSWTCH: rc
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
      F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
 6671 format ('I  ', 60(' '), 'I--', 63('-'), '--I' / &
              'I  ',24x,'Hij        ETAij    LAMBDA1   ', &
              'LAMBDA4      rc          w                ', &
              '      ',26x, 'I')
 6673 format ('I   ',A2,'(',i2,') -- ',A2,'(',i2,')  ', &
              (F11.5,F10.3),2(F11.2, F10.3), 46X,'I')
 6676 FORMAT ('I  ',60(' '),'   ', 63(' '),'  I' / &
              'I',5X,'3-body potential   ATOM(J)--ATOM(I)', &
              '--ATOM(J)      BIJK      Costheta           ', &
              '   r0    ', &
              '    gamma','      C      ',15X, 'I')
 6677 FORMAT ('I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
               I2,')--',A2,'(',I2,')', F15.5, F11.7, &
               i6,'-',i2, 2F10.3, F12.4,16X, 'I')
 6678 FORMAT ('I',73X, i6,'-',i2,2F10.3, F12.4,16X, 'I')
RETURN
END
!
!
!                                                               ========
!================================================================ PAIR-P
SUBROUTINE  PAIRP
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use pmorse
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!                                                    plus MORSE function
!                                                    plus three body
!
  REAL      *8    BETA, RIJ,ARIJ
  real      *8    EX, ARB
  integer   *4    N,I,II,J,IP,JP,KP,IJ,LCOMPO,LPAIR
  real      *8    DIJP,BEIJP,RSIJP,R3BG
  CHARACTER *40   FMT1, FMT2
!
!     beta = 1.0d0 / 6.2415064d11        ! eV -> erg
  beta = 1.0d7 * 1000.0 / ANA        ! kJ/mol -> erg
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = 0.0
      BIJ(N)  = 0.0
      CIJ(N)  = 0.0
      DIJ(N)  = 0.0
      ZIJ(N)  = ZIO(I)*ZIO(J)
      DMIJ(N) = 0.0
      BEIJ(N) = 0.0
    enddo
  enddo
!
  120 READ   (15,'(3I2,4X,5F10.0)')  IP,JP, KP, DIJP, BEIJP, RSIJP, R3BG
  IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
  IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
  IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
  IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP
      AIJ(N) = DIJP
      BIJ(N) = BEIJP
      CIJ(N) = RSIJP * BETA
      if (IP == JP)  then
        CIO(IP) = DSQRT(CIJ(N))
      end if
    end if
    GO TO 120
  END IF
  LCOMPO = NCOMPO
  IF (LCOMPO > 7)  LCOMPO = 7
  LPAIR  = LCOMPO*(LCOMPO+1)/2
  FMT1 = '( 3H I ,9X,    3(5X,A2,1H-,A2),90X,1HI )'
  FMT2 = '( 3H I ,4X,A4,1X,   3F10.2,    90X,1HI )'
  IF (NCOMPO == 3) THEN
    FMT1 = '( 3H I ,9X,    6(5X,A2,1H-,A2),60X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,   6F10.2,    60X,1HI )'
  ELSE IF (NCOMPO == 4) THEN
    FMT1 = '( 3H I ,9X,  10(5X,A2,1H-,A2), 20X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,  10F10.2,    20X,1HI )'
  ELSE IF (NCOMPO == 5) THEN
    FMT1 = '( 3H I ,7X,   15(3X,A2,1H-,A2), 2X,1HI )'
    FMT2 = '( 3H I ,2X,A4,1X,   15F8.1,     2X,1HI )'
  ELSE IF (NCOMPO == 6) THEN
    FMT1 = '( 3H I ,3X,   21(1X,A2,1H-,A2),    1HI )'
    FMT2 = '( 3H I ,A3,         21F6.0,        1HI )'
  ELSE IF (NCOMPO == 7) THEN
    FMT1 = '( 3H I ,5X,   28(1X,A1,1H-,A1),12X,1HI )'
    FMT2 = '( 3H I ,1X,A4,1X,  28F4.1,     12X,1HI )'
  END IF
  WRITE (16, '("I  ", 60(" "), "I--", 63("-"), "--I" )')
  WRITE (16,FMT1)  ((ATOM(I),ATOM(J),J=1,I),I=1,LCOMPO)
  WRITE (16,FMT2)  'Aij ', (AIJ(J),J=1,LPAIR)
  WRITE (16,FMT2)  'Bij ', (BIJ(J),J=1,LPAIR)
  WRITE (16,FMT2)  'Cij ', (CIJ(J)/BETA,J=1,LPAIR)
!
  DO I = 10, NRCUT(2)
    RIJ  = REAL(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5) cycle
      EX = 0.0
      IF (BIJ(J) > 0.00001)  THEN
        ARB =  - RIJ / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      E1(I,J) = BETA * AIJ(J)*EX
!    *                         - BETA * CIJ(J)*ARIJ**6
      F1(I,J) = BETA * AIJ(J) *EX / BIJ(J)
!    *                         - BETA * 6.0*CIJ(J)*ARIJ**7
      F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
RETURN
END
!
!
!                                                               ========
!================================================================ BUSING
SUBROUTINE  BUSING
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!
  REAL *8  BETA,EX,RIJ,ARIJ,ARB
  integer *4  N,I,II,J
!
  BETA = CAL * 1.0D10 / ANA
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N) = ABS(AIO(II) + AIO(J))
      BIJ(N) = ABS(BIO(II) + BIO(J))
      CIJ(N) = CIO(II) * CIO(J) * BETA
      DIJ(N) = DIO(II) * DIO(J) * BETA
      D4IJ(N) = 0.0
      D7IJ(N) = 0.0
      ZIJ(N)  = ZIO(I) * ZIO(J)
      IF (RUNOPT(8) == 'STSUNE    ')  THEN
        IF (I == J .AND. ATOM(I) == 'SI  ')  CIJ(N) = 0.0
      END IF
    enddo
  enddo
!
  DO I = 10, NRCUT(2)
    RIJ  = REAL(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, LEE
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5) cycle
      EX = 0.0
      IF (BIJ(J) > 0.0001)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      E1(I,J) = BETA * BIJ(J)*EX
!    *                        - CIJ(J)*ARIJ**6
      F1(I,J) = BETA * EX * 1.0D8 * ARIJ
!                 F1(I,J) = BETA * (EX - 6.0*CIJ(J)*ARIJ**7) *
!    *                                1.0D8 * ARIJ
    enddo
  enddo
!
RETURN
END
!
!
!                                                               ========
!================================================================ TOSIFU
SUBROUTINE  TOSIFU
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
!
  implicit none
!
!     -------------------- TOSI & FUMI (BORN-MAYER) type rigid ion model
!                                             (including Pauling factor)
!
  REAL *8         BETA, ARIJ
  real *4         deni,denj,rij,expa,arb
  integer *4      N,I,II,J
!
  BETA = 1.0D-19 * 1.0D7
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = AIO(II) + AIO(J)
      BIJ(N)  = BIO(II) + BIO(J)
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = DIO(II) * DIO(J) * BETA
      ZIJ(N)  = ZIO(I) * ZIO(J)
      PLIJ(N) = 1.0
!     ------------------------------------------- Pauling factor
      DENI = 8.0
      IF (WIO(I) <= 11.5)  DENI = 2.0
      DENJ = 8.0
      IF (WIO(J) <= 11.5)  DENJ = 2.0
      PLIJ(N) = 1.0 + ZIO(I)/DENI + ZIO(J)/DENJ
    enddo
  enddo
!
!     RHO  = 0.29
  DO I = 10, NRCUT(2)
    RIJ  = REAL(I) * 0.01
    ARIJ = 1.0D0 / RIJ
    DO J = 1, NPAIR
      IF (ABS(AIJ(J)) > 1.0E-5) THEN
        EXPA = 0.0
        ARB  = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0) EXPA = PLIJ(J) * 0.338 * EXP(ARB)
        E1(I,J) = EXPA * BETA
!    *                       - CIJ(J)*ARIJ**6 - DIJ(J)*ARIJ**8)*BETA
        F1(I,J) = EXPA/BIJ(J)*BETA * 1.0D8 * ARIJ
!                  F1(I,J) = (EXPA/BIJ(J) - 6.0*CIJ(J)*ARIJ**7
!    *                                    - 8.0*DIJ(J)*ARIJ**9)
!    *                                         * BETA * 1.0D8 * ARIJ
      END IF
    enddo
  enddo
RETURN
END
!
!
!                                                                =======
!================================================================= ANGEL
SUBROUTINE  ANGELP
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
!
  implicit none
!
  integer *4    N,I,II,J
  real *8       DENI,DENJ,RHO,RIJ,ARIJ,EX,ARB
!
!     -------------------------- BORN-MAYER-HUGGINS type rigid ion model
!               WOODCOK, ANGELL type potential function (Pauling factor)
!
!
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = (BIO(II) +BIO(J)) * 1.0E-13
      CIJ(N)  = CIO(II) * CIO(J) * 1.0E-13
      ZIJ(N)  = ZIO(I) * ZIO(J)
      PLIJ(N) = 1.0
      IF (RUNOPT(8) == 'PAULING  ')  THEN
        DENI = 8.0
        IF (WIO(I) <= 11.5)  DENI = 2.0
        DENJ = 8.0
        IF (WIO(J) <= 11.5)  DENJ = 2.0
        PLIJ(N) = 1.0 + ZIO(I)/DENI + ZIO(J)/DENJ
      END IF
    enddo
  enddo
!
!     BETA = CAL * 1.0E10 / ANA
  RHO   = 0.29
  DO I = 10, NRCUT(2)
    RIJ  = REAL(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, LEE
      IF (ABS(AIJ(J)) > 1.0E-5) THEN
        EX = 0.0
        ARB = (AIJ(J) - RIJ) / RHO
        IF (ARB > -128.0)  EX = PLIJ(J) * BIJ(J) * EXP(ARB)
        E1(I,J) = EX
!    *                        - CIJ(J)*ARIJ**6
        F1(I,J) =  EX/RHO * 1.0D8 * ARIJ
!                   F1(I,J) = (EX/RHO - 6.*CIJ(J)*ARIJ**7)*1.0D8 * ARIJ
      END IF
    enddo
  enddo
RETURN
END
!
!
!                                                            ===========
!============================================================= L-J MODEL
SUBROUTINE  LJMODL
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
!
  implicit none
!
  integer *4  N,I,II,J
  real *4     RIJ,ARIJ,EX,EX2
!     ------------------------------- Lennard-Jones type potential model
!                           uij(rij) = eij[(sij/rij)**12 - (sij/rij)**6]
!                                 Lorentz-Berthelot type pair parameters
!                                   sij=(si+sj)/2  :  eij=(eixej)**(1/2)
!
!
  N = 0
  DO I = 1, NCOMPO
    AIO(I) = SQRT(AIO(I)*1.0E-16)
    BIO(I) = BIO(I) / 2
    II = I
    DO J = 1, II
      N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
      AIJ(N)  = AIO(II) * AIO(J) * 4.0
      BIJ(N)  = BIO(II) + BIO(J)
      CIJ(N)  = AIJ(N) * BIJ(N)**6
      DIJ(N)  = 0.0
      ZIJ(N)  = ZIO(I) * ZIO(J)
      if (IION(i) < 0 .and. iion(j) < 0) then
        aij(n) = 0.0
        bij(n) = 0.0
        cij(n) = 0.0
      end if
    enddo
  enddo
!
  DO I = 10, NRCUT(2)
    RIJ  = REAL(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, LEE
      EX = (BIJ(J) * ARIJ)**6
      EX2 = EX * EX
      E1(I,J) = AIJ(J)* (EX2)
!             E1(I,J) = AIJ(J)* (EX2 - EX)
      F1(I,J) = AIJ(J)* (12.0*EX2) *ARIJ *ARIJ *1.0E8
!             F1(I,J) = AIJ(J)* (12.0*EX2 - 6.0*EX) *ARIJ *ARIJ *1.0E8
    enddo
  enddo
RETURN
END
!
!
!                                                                =======
!================================================================ METALP
SUBROUTINE  METALP  (IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
!
  implicit none
!
  INTEGER        INP(51),IPR
  integer *4     ICUT,I,J,NP,JNP,IIIR,IIR
  real *4        ANM,r,ARN,PHI,EFG,FF1,FF2,DRVN2,AKF2,RI,F,VRN,EE0,EE,ANP
!
  ANM = 3.0
  IF (ABS(MODE) >= 3 .AND. ABS(MODE) <= 9)  ANM = MODE
!
  IF (ALPHA > 0.9 .OR. ALPHA < 14.9)  THEN
    ICUT    = ALPHA
    RCUT(2) = (LSR-1.0)/100.0
  ELSE
    ICUT = 0
    IF (RCUT(2) < 0.01 .OR. RCUT(2) > (LSR-1.0)/100.0) THEN
      RCUT(2) = (LSR-1.0)/100.0
    END IF
  END IF
  NRCUT(2) = INT(RCUT(2) * 100.0 + 1.01)
  RCUT(1)  = RCUT(1)
!
! *** LRO-II
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  DO I = 1, NCOMPO
    AKFI(I) = 0.0
  enddo
!     ------------------------------------------------ Fermi wave number
  AKFI(1) = (3.0 * PI**2 * NION(1) / VOL)**(1.0/3.0)
!
!     U = KB * [ (A/r)**n * cos(2*kf*r - B)  +  exp(C - D*r) ]
!
  DO I = 50, LSR
    E0(I) = 0.0
    F0(I) = 0.0
    R = REAL(I) * 0.01
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      IF (ABS(AIO(J)) > 1.0E-10)  THEN
        ARN = (AIO(J) / R)**ANM
        PHI = 2.0 * AKFI(J) * R - BIO(J)
        EFG = EXP(CIO(J) - DIO(J) * R)
!
!                    E0(I,J) = AKB * ARN * COS(PHI)
        E1(I,J) = AKB * ARN * COS(PHI) + AKB * EFG
!
        FF1 = (- ANM * COS(PHI) / R - 2.0 * AKFI(J) * SIN(PHI)) * ARN
        FF2 =  - DIO(J) * EFG
        F1(I,J) = - (FF1 + FF2) * AKB * 1.0E8 / R
      END IF
    enddo
  enddo
!     ------------------------------ CORRECTION FOR TERMINATION AT RCUTL
  ECORR = 0.0
  VCORR = 0.0
  IF (ICUT == 0) THEN
    DRVN2 = NION(1) / VOL * 4.0 * PI * 0.02
    AKF2  = 2.0 * AKFI(1)
    IIIR = INT((1999.0-RCUT(2))/0.02+0.00001) + 1
    DO IIR = 1, IIIR
      RI = RCUT(2) + 0.02*(IIR-1)
      R  = RI + 0.01
      F  = (1999.0 - R) / (1999.0 - RCUT(2))
      IF (ANM > 3.1)  F = 1.0
      VRN = R**2 * DRVN2
      ARN = (AIO(1) / R)**ANM
      PHI   = AKF2*R - BIO(1)
      ECORR = ECORR + COS(PHI) * ARN * VRN
!
      VCORR = VCORR -(- ANM*COS(PHI)/R- AKF2*SIN(PHI)*F ) * R * ARN * VRN
    enddo
    ECORR = ECORR * NION(1) * AKB * FJMOL / 2.0
    VCORR = VCORR * NION(1) / 2.0 * AKB * 1.0D-10 / (VOL*1.0D-24) / 3.0
  ELSE
    DO J = 1, NCOMPO
      IF (ABS(AIO(J)) > 1.0E-10)  THEN
        NP = 0
        EE0 = E1(200,J)
        DO I = 201, NRCUT(2)
          EE = E1(I,J)
          IF (EE0*EE <= 0.0) THEN
            NP = NP + 1
            INP(NP) = I
            IF (NP >= 50) exit
          END IF
          EE0 = EE
        enddo
        IF (ICUT > NP)  ICUT = NP
        NRCUT(2) = INP(ICUT)
        RCUT(2)  = NRCUT(2) * 0.01
        NRCUT(1) = NRCUT(2)
        RCUT(1)  = RCUT(2)
        ANP   = INP(ICUT) - INP(ICUT-1) + 1
        DO I = INP(ICUT-1), INP(ICUT)
          E1(I,J) = E1(I,J) * (I-INP(ICUT-1))/ANP
          F1(I,J) = F1(I,J) * (I-INP(ICUT-1))/ANP
        enddo
        IF (IPR == 1) THEN
          DO I = 1, NP
            JNP = INP(I)
          enddo
        END IF
      END IF
    enddo
  END IF
!
  IF (IPR == 1) THEN
    WRITE (*,1001) RCUT(1),AKFI(1),ECORR,VCORR
 1001 FORMAT (10X,'RCUT=',F8.4,'   KF=',F6.4,'   Ecorr=',F6.3,'  Pcorr=',F6.3)
  END IF
!
!     DO 160  I = 100, NCUT, 10
!         WRITE (16,*) I,E0(I,1)+E1(I,1),F1(I,1)
! 160 CONTINUE
!     WRITE (*,*) 375,E1(375,1),F1(375,1)
RETURN
END
!
!
!                                                                =======
!================================================================ CLEARS
SUBROUTINE  CLEARS
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use vector
  use values
  use radial
  use acoord
!
  implicit none
!
!     --------------------------------- Clear variables for accumulation
!
  INTEGER   *4    IYEAR,IMONTH,IDAY, IHOUR,IMINUT, ISECND, I100TH
  integer   *4    NN,MM,JM,IM,I,J,K
!
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
  NN = IRECRD(2)/IRECRD(3)
  MM = MOD(NRECRD(1)/IRECRD(3), NN)
  JM = 2
  IF (RUNOPT(3) == 'ECONOMY  ')  JM = 10
  IM = 1
  IF (RUNOPT(3) == 'ECONOMY  ')  IM = 0
  IF (NRECRD(3) == 1)  GOTO 10
  IF (NRECRD(3) == IM.OR.MOD(MM,JM) == 0)  GO TO 10
  IF (RUNOPT(3) /= 'ECONOMY  ')  GO TO 11
  IF (NRECRD(3) /= IM.AND.MOD(MM,JM) /= 0)  GO TO 12
10 WRITE (16,2450)  NJOB,TITLE,TEMP, IHOUR,IMINUT,ISECND,IYEAR,IMONTH,IDAY
11 WRITE (16,2452)  (ATOM(I),I=1,4)
!
 2450 FORMAT (/'<<<<<<',I4,'-',I2,'  <<<<  ',15A4,' >>>>  T=',F7.1, &
                   '  (at ',I2,':',I2,':',I2, &
                    '  on ',I2,'/',I2,'/',I2,') >>>>>>')
 2452 FORMAT(/' Step ',4('T:',A2,1X),'Temp   P/GPa  (Pxx,  Pyy,  ', &
                 'Pzz,  Pxy,  Pxz,  Pyz)  U:Coulomb   Short  ', &
                 '3-body   Kin.    Total   Density')
!
 12 IF(MOD(NRECRD(1),IRECRD(3)) == 1 .or. IRECRD(3) == 1)  then
!
    DO I = 1, LVA
      TVALL(I) = 0.0D0
      SVALL(I) = 0.0D0
    enddo
!
    IF (MOD(NRECRD(1),IRECRD(2)) == 1 .or. IRECRD(2) == 1)  then
      DO I = 1, NTION
        AU(I) = 0.0d0
      enddo
!
      IF (NRECRD(2) > 0.AND.RUNOPT(4) == 'ACCUM     ')  RETURN
      NRECRD(2) = 0
      NTBL = 0
      DO J = 1, LEE
        DO I = 1, LTB
          NRDF(I,J) = 0
        enddo
      enddo
      DO I = 1, 12
        DO J = 1, 3
          ANGL(J,I)  = 0.0d0
        enddo
        DO J = 1, 121
          ITBR(J,I) = 0
        enddo
      enddo
      DO K = 1, 2
        DO I = 1, 6
          DO J = 1, 6
            MBR(J,I,K) = 0
          enddo
        enddo
        DO I = 1, 9
          NRG(I,K) = 0
        enddo
      enddo
      DO I = 1,NPT
        DO J = 1, 3
          PPC(J,I) = 0.0d0
          PPS(J,I) = 0.0d0
        enddo
      enddo
    endif
  endif
RETURN
END
!
!
!                                                               ========
!================================================================ NEWTON
SUBROUTINE  NEWTON
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use vector
  use values
  use forces
  use radial
  use acoord
  use cartes
  use molecu
  use boxcng
  use quanco
  use outerf
  use exclus
  use charge
  use pos
  use ewal
!
  implicit none
!
!     ----------------------------------------- Heart of MD calculations
!
!
  real    *8      pbox(6)
  REAL    *8      ABOX1, V1I, PXI, VAVB(6),PJI,PCT(6)
  real    *8      AMV2,   ABOX2, V2I, PYI, CENTRE, WGIO
  real    *8      TMV2,   ABOX3, V3I, PZI, CENTRP, FV,FVI,V2
  REAL    *8      DIPOLE(3), VC(3,LNI), fex(3)
  real    *8      xx,yy,rr,xxe,yye,dipm2,x0,x1,x2,a3nkbt,valio2,aspres
  real    *8      dpres,presx,presy,presz,vols,vvvv,abox,ffff,twt
  real    *8      xcen,ycen,zcen
  real    *8      FXP(LNI),FYP(LNI),FZP(LNI)
  real    *8      rL1OX,rL1OY,rL1OZ,rL1O
  real    *8      TV1,TV2
  real    *8      rL2OX,rL2OY,rL2OZ,rL2O
  real    *8      CO1,CO2a,CO2b,Nx,Ny,Nz
  real    *8      etha(4),detha(4),H_Nose,dRx,dRy,dRz,PIJX,PIJY,PIJZ  !Nose-Hoover
  double precision, save:: ER0(4)=0.0d0,ER1(5)=0.0d0,ER2(4)=0.0d0,ER3(4)=0.0d0
  double precision, save:: ER4(4)=0.0d0,ER5(4)=0.0d0  !Nose-Hoover Gear's method
  double precision ::      ER0P(4)=0.0d0,ER1P(5)=0.0d0,ER2P(4)=0.0d0,ER3P(4)=0.0d0
  double precision ::      ER4P(4)=0.0d0,ER5P(4)=0.0d0 !Nose-Hoover
  double precision,save::      R0(3,LNI),R1(3,LNI),R2(3,LNI),R3(3,LNI),R4(3,LNI),R5(3,LNI)
  double precision    R0P(3,LNI),R1P(3,LNI),R2P(3,LNI),R3P(3,LNI),R4P(3,LNI),R5P(3,LNI)
  double precision,save::      Deltr2(3,LNI),DeltEr2(5)=0.0d0,VALP(LVA)
  integer *4      N,IO,I,J,IA1,IA2,is1,is2,io1,io2,NNCOMPO,kk,mm,lp1,lp2
  integer *4      no,nnh,jconv
!
!
!
  NNCOMPO = NCOMPO !WATER-POL
  IF (runopt(34) == 'WATER-POL ') NNCOMPO = NCOMPO + 1
  DO N = 1, N3BP
    AV3BP(1,N) = 0.0D0
    AV3BP(2,N) = 0.0D0
  enddo
!
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0)  cycle
    DO I = IONS(1,IO), IONS(2,IO)
      UI(I) = 0.0D0
      UIC(I) = 0.0D0  !WATER-POL
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      if (runopt(35) /= 'ISOLATED  ') then
        DO J = 1, 3
          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
            PJI     = -SIGN(1.0D0,P(J,I))
            P0(J,I) = P0(J,I) + PJI
            P(J,I)  = P(J,I)  + PJI
          END IF
        enddo
      endif
      PX(I)  = P(1,I)
      PY(I)  = P(2,I)
      PZ(I)  = P(3,I)
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
  enddo
!
!
  if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
  if (runopt(34) == 'WATER-POL ')  then
    do i = ntion+1, ntion+ndmole
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      if (runopt(35) /= 'ISOLATED  ') then
        DO J = 1, 3
          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
            PJI     = -SIGN(1.0D0,P(J,I))
            P0(J,I) = P0(J,I) + PJI
            P(J,I)  = P(J,I)  + PJI
          END IF
        enddo
      endif
      PX(I) = P(1,I)
      PY(I) = P(2,I)
      PZ(I) = P(3,I)
!      if (PX(I) < 0.0D0 .or. PX(I) > 1.0D0) stop 'error in P'
!      if (PY(I) < 0.0D0 .or. PY(I) > 1.0D0) stop 'error in P'
!      if (PZ(I) < 0.0D0 .or. PZ(I) > 1.0D0) stop 'error in P'      
      if (IOND(I) == 0) ZII(I) =0.0D0
    enddo
  endif
!
  DO I = 1, LVA   !LVA = 24+LEM*2 = 44
    VAL(I) = 0.0D0
  enddo
!
  NRECRD(2) = NRECRD(2) + 1
  IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
    TINT = 0.0D0
    QCEE = 0.0D0
    QCEF = 0.0D0
  END IF
!     --------------------------------- Coulomb and Short range (2-body)
!                                               and 3-body term
  JJJ = 1
  KRDF = 0
  IF (RUNOPT(34) /= 'WATER-POL ') CALL EWALDS
  IF (RUNOPT(34) == 'WATER-POL ') then
200 do N = 1,N3BP
      AV3BP(1,N) = 0.0d0
      AV3BP(2,N) = 0.0d0
    enddo
    do i = 1, ntion+ndmole
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0) ZII(I) = 0.0D0
    enddo
    DO I = 1, LVA
      VAL(I) = 0.0D0
    enddo
    if(JJJ /= 1 .or. NRECRD(3) <= 4) CALL EWALDS
!    PVAL9 = VAL(9)
    CALL POLH2O
    JJJ = JJJ + 1
!    if (maxedip > THRESHD) goto 200
    if (sumedip > THRESHD) goto 200
!    IF (JJJ <= ITER) goto 200
    do N = 1,N3BP
      AV3BP(1,N) = 0.0d0
      AV3BP(2,N) = 0.0d0
    enddo
    do i = 1, ntion+ndmole
      UICP4(I) = UICP3(I)
      UICP3(I) = UICP2(I)
      UICP2(I) = UICP1(I)
      UICP1(I) = UIC(I)
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0) ZII(I) = 0.0D0
    enddo
    DO I = 1, LVA
      VAL(I) = 0.0D0
    enddo
    IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
      TINT = 0.0D0
      QCEE = 0.0D0
      QCEF = 0.0D0
    END IF
    KRDF = 1    
    CALL EWALDS
!    CALL EWALD_UPOL
  ENDIF
!
! ---------------------------Calculation of molecular polarizability
! -Don't use ELEC.FIELD or GRAVITY options together with this option
! -----------------------------------------U---------  Electric field
  IF (RUNOPT(20) == 'ELEC.FIELD')  CALL  ELECFD
! -----------------------------------General WALL at z = 0 and z = 1
  IF (RUNOPT(32) == 'GEN.WALL  ')  CALL  GENWAL 
! ---------------------------------------------------  Gravity field
  IF (RUNOPT(21) == 'GRAV.FIELD')  CALL  GRAVFD
! -------------------------------------------------- Convection flow
  if (RUNOPT(25) == 'CONVECTION')  then
    do i = 1, ntion
      if (px(i) < 0.05 .or. px(i) > 0.95) then
        fy(i) = fy(i) - abs(fy(i)) * fconvc
      else if (px(i) > 0.45 .and. px(i) < 0.55) then
        fy(i) = fy(i) + abs(fy(i)) * fconvc
      end if
    enddo
  end if
! ----------------------------------------------- Exclusion of atoms
  if (runopt(27) == 'EXCLUSION ') then
!           write (6,*) iextype,iaex,rexcl,fexcl
    ia1 = 1
    ia2 = 2
    if (iaex == 2) then
      ia1 = 1
      ia2 = 3
    end if
    if (iaex == 1) then
      ia1 = 2
      ia2 = 3
    end if
    if (iextype == 1)  then
!                write (6,*) iextype, iaex, rexcl
      do i = 1, ntion
        xx = (p(ia1,i)-0.5)*BOX(ia1)
        yy = (p(ia2,i)-0.5)*box(ia2)
        rr = sqrt(xx**2 + yy**2)
        if (rexcl > 0.0 .and. rr <= rexcl) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          xxe = xx / sqrt(xx**2+yy**2)
          yye = yy / sqrt(xx**2+yy**2)
          fex(ia1) = fex(ia1) + xxe*Fexcl
          fex(ia2) = fex(ia2) + yye*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
        if (rexcl < 0.0 .and. rr > abs(rexcl)) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          xxe = -xx / sqrt(xx**2+yy**2)
          yye = -yy / sqrt(xx**2+yy**2)
          fex(ia1) = fex(ia1) + xxe*Fexcl
          fex(ia2) = fex(ia2) + yye*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
      enddo
    else if (iextype == 2)  then
      do i = 1, ntion
        rr = (p(iaex,i)-0.5)*BOX(ia1)
        if (rr <= rexcl) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          fex(iaex) = fex(iaex) + sign(1.0d0,rr)*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
      enddo
    else if (iextype == 3)  then
    else if (iextype == 5)  then
!                write (6,*) 'HONEYCOMB',iaex,iextype, rexcl,fexcl
      do i = 1, ntion
!                   (0.0, 0.0)
        xx = p(ia1,i)+0.5
        yy = p(ia2,i)+0.5
        if (xx > 1.0)  xx = xx - 1.0
        if (yy > 1.0)  yy = yy - 1.0
        xx = (xx-0.5)*BOX(ia1)
        yy = (yy-0.5)*box(ia2)
        rr = sqrt(xx**2 + yy**2)
        if (rr <= rexcl) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          xxe = xx / rr
          yye = yy / rr
          fex(ia1) = fex(ia1) + xxe*Fexcl
          fex(ia2) = fex(ia2) + yye*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
!                   (0.5, 0.5)
        xx = (p(ia1,i)-0.5)*BOX(ia1)
        yy = (p(ia2,i)-0.5)*box(ia2)
        rr = sqrt(xx**2 + yy**2)
        if (rr <= rexcl) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          xxe = xx / rr
          yye = yy / rr
          fex(ia1) = fex(ia1) + xxe*Fexcl
          fex(ia2) = fex(ia2) + yye*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
      enddo
    end if
  end if
! ----------------------------------------------------- Wall at z= 0
  if (runopt(28) == 'WALL      ')  call  WALL
!
!
! -------------------------------------- Dipole moment of basic cell
!                                       (2*Pi/3L**3)* [Sum of qi*ri]
  IF (RUNOPT(14) == 'DIPOLE    ')  THEN
    DIPOLE(1) = 0.0D0
    DIPOLE(2) = 0.0D0
    DIPOLE(3) = 0.0D0
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      DO I = IONS(1,IO), IONS(2,IO)
        PXI = PX(I)
        PYI = PY(I)
        PZI = PZ(I)
        IF (P0(1,I) > 0.999999)  PXI = PXI - 1.0
        IF (P0(2,I) > 0.999999)  PYI = PYI - 1.0
        IF (P0(3,I) > 0.999999)  PZI = PZI - 1.0
        DIPOLE(1) = DIPOLE(1) + ZIO(IO)*PXI*BOX(1)
        DIPOLE(2) = DIPOLE(2) + ZIO(IO)*PYI*BOX(2)
        DIPOLE(3) = DIPOLE(3) + ZIO(IO)*PZI*BOX(3)
      enddo
    enddo
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0)  cycle
      DO I = IONS(1,IO), IONS(2,IO)
        FX(I) = FX(I) - ZIO(IO) * DIPOLE(1) * 4.0D0 * PI / VOL * ELC**2 * 1.0D16
        FY(I) = FY(I) - ZIO(IO) * DIPOLE(2) * 4.0D0 * PI / VOL * ELC**2 * 1.0D16
        FZ(I) = FZ(I) - ZIO(IO) * DIPOLE(3) * 4.0D0 * PI / VOL * ELC**2 * 1.0D16
      enddo
    enddo
    DIPM2 = (DIPOLE(1)**2+DIPOLE(2)**2+DIPOLE(3)**2)*2.0D0*PI/(3.0D0*VOL)*ELC**2*1.0D8*FJMOL
!           WRITE (*,*)  DIPM2
  END IF
!
! =============================== Integration of equations of motion
  ABOX1  = 1.0D0 / BOX(1)
  ABOX2  = 1.0D0 / BOX(2)
  ABOX3  = 1.0D0 / BOX(3)
! Interpolation - Lagrange Interpolation
  X0 = (0.5D0-0.0D0)*(0.5D0-1.0D0)/(((-1.0D0)-0.0D0)*((-1.0D0)-1.0D0))
  X1 = (0.5D0-(-1.0D0))*(0.5D0-1.0D0)/((0.0D0-(-1.0D0))*(0.0D0-1.0D0))
  X2 = (0.5D0-(-1.0D0))*(0.5D0-0.0D0)/((1.0D0-(-1.0D0))*(1.0D0-0.0D0))
!
  IF (RUNOPT(34) == 'WATER-POL ') then
!   -------------- Temperature of Oxygen
!   Energy of massless lone pairs are distributed to Oxygen
    no = 0
    do io = ions(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      ui(io) = ui(io) + ui(lp1) + ui(lp2)
    enddo
    no = 0
!   -------------------------------constrain included in interatomic forces
    DO io = ions(1,IATOMO), ions(2,IATOMO)
      no = no + 1
      IF (IOND(io) == 0)  THEN
        V(1,io) = 0.0D0
        V(2,io) = 0.0D0
        V(3,io) = 0.0D0
        cycle
      END IF
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      fx(io) = fx(io)  + (fx(lp1) + fx(lp2)) !constrain between O and Lone pairs
      fy(io) = fy(io)  + (fy(lp1) + fy(lp2)) 
      fz(io) = fz(io)  + (fz(lp1) + fz(lp2)) 
    enddo
!
    no = 0
    DO io = ions(1,IATOMO), ions(2,IATOMO)
      no = no + 1
!      ------------------------------------- constrain of angle between LP-O-H
      kk = ih2o(2,no)
      mm = ih2o(3,no)
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
!
!     ------------------------------------- vector O -> LP1
      rL1OX = LOP1X(no)
      rL1OY = LOP1Y(no) 
      rL1OZ = LOP1Z(no) 
      rL1O  = RD 
!     ------------------------------------- vector O -> LP2
      rL2OX = -1.0d0*LOP1X(no) 
      rL2OY = -1.0d0*LOP1Y(no) 
      rL2OZ = -1.0d0*LOP1Z(no) 
      rL2O  = RD 
!
      Nx = rL1OY*FZ(lp1) - rL1OZ*FY(lp1) + rL2OY*FZ(lp2) - rL2OZ*FY(lp2)
      Ny = rL1OZ*FX(lp1) - rL1OX*FZ(lp1) + rL2OZ*FX(lp2) - rL2OX*FZ(lp2)
      Nz = rL1OX*FY(lp1) - rL1OY*FX(lp1) + rL2OX*FY(lp2) - rL2OY*FX(lp2)
!
      TV1 = (Nx*HHX(no) + Ny*HHY(no) + Nz*HHZ(no))/HHV(no)
!
      CO1 = -0.5D0*TV1/DPV(no)/RD
      FXP(kk) = CO1*rL1OX
      FYP(kk) = CO1*rL1OY
      FZP(kk) = CO1*rL1OZ
      FXP(mm) = CO1*rL1OX
      FYP(mm) = CO1*rL1OY
      FZP(mm) = CO1*rL1OZ
!
      TV2 = (Nx*DPX(no) + Ny*DPY(no) + Nz*DPZ(no))/DPV(no)
!
      CO2a = -0.5d0*TV2/A1(no)/RD
      CO2b =  0.5d0*TV2/A2(no)/RD
      FXP(kk) = FXP(kk) + CO2a*rL1OX
      FYP(kk) = FYP(kk) + CO2a*rL1OY
      FZP(kk) = FZP(kk) + CO2a*rL1OZ
      FXP(mm) = FXP(mm) + CO2b*rL1OX
      FYP(mm) = FYP(mm) + CO2b*rL1OY
      FZP(mm) = FZP(mm) + CO2b*rL1OZ
!
!
      FX(io) =  FX(io) - (FXP(kk) + FXP(mm))
      FY(io) =  FY(io) - (FYP(kk) + FYP(mm))
      FZ(io) =  FZ(io) - (FZP(kk) + FZP(mm))
      FX(kk) = FX(kk) + FXP(kk)
      FY(kk) = FY(kk) + FYP(kk)
      FZ(kk) = FZ(kk) + FZP(kk)
      FX(mm) = FX(mm) + FXP(mm)
      FY(mm) = FY(mm) + FYP(mm)
      FZ(mm) = FZ(mm) + FZP(mm)
    enddo
!
  ENDIF
!
  IF (RUNOPT(5) == 'T NOSE    ')  GO TO 400
!
!   ------------------------------------------- Scaling and Andersen's
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001D0)  cycle
    WGIO = DBLE(DTIME)**2 / (WIO(IO)/ANA) * 1.0D8
    DO I = ions(1,io), ions(2,io)
!T                 CALL  PTOXYZ  (I)
      IF (IOND(I) == 0)  THEN
        V(1,I) = 0.0D0
        V(2,I) = 0.0D0
        V(3,I) = 0.0D0
        cycle
      END IF
      IF (RUNOPT(6) == 'P ANDERSEN' .OR. RUNOPT(6) == 'P ANDERS-C')  THEN
!       ------------------------- Andersen's algorithm
        V1I = V(1,I) + FX(I)*WGIO - VBOX(1)*V(1,I)
        V2I = V(2,I) + FY(I)*WGIO - VBOX(2)*V(2,I)
        V3I = V(3,I) + FZ(I)*WGIO - VBOX(3)*V(3,I)
      ELSE
!       ----------------------------- Verlet algorithm
        V1I = V(1,I) + FX(I)*WGIO
        V2I = V(2,I) + FY(I)*WGIO
        V3I = V(3,I) + FZ(I)*WGIO
      END IF
      IF  (IION(IO) >= 0)  THEN
        P(1,I) = P(1,I) + V1I * ABOX1
        P(2,I) = P(2,I) + V2I * ABOX2
        P(3,I) = P(3,I) + V3I * ABOX3
!T                        Q(1,I) = Q(1,I) + V1I
!T                        Q(2,I) = Q(2,I) + V2I
!T                        Q(3,I) = Q(3,I) + V3I
      ELSE
        V1I = 0.0D0
        V2I = 0.0D0
        V3I = 0.0D0
      END IF
!       ------------------ Interpolation for present velocity
!                  V1I:+(1/2)t VC(1,I):0 V(1,I):-(1/2)t VP(1,I):-(3/2)t
      IF (NRECRD(3) == 1)  THEN
        VP(1,I) = V(1,I) - FX(I)*WGIO
        VP(2,I) = V(2,I) - FY(I)*WGIO
        VP(3,I) = V(3,I) - FZ(I)*WGIO
      END IF
      VC(1,I) = VP(1,I)*X0 + V(1,I)*X1 + V1I*X2
      VC(2,I) = VP(2,I)*X0 + V(2,I)*X1 + V2I*X2
      VC(3,I) = VP(3,I)*X0 + V(3,I)*X1 + V3I*X2
      VP(1,I) = V(1,I)
      VP(2,I) = V(2,I)
      VP(3,I) = V(3,I)
      V(1,I)  = V1I
      V(2,I)  = V2I
      V(3,I)  = V3I
    enddo
  enddo
!
!  do i = 1, ntion
!    if (P(1,i) > 1.0D0 .or. P(1,i) < 0.0D0) write(*,*)i, 'x', P(1,i)
!    if (P(2,i) > 1.0D0 .or. P(2,i) < 0.0D0) write(*,*)i, 'y', P(2,i)
!    if (P(3,i) > 1.0D0 .or. P(3,i) < 0.0D0) write(*,*)i, 'z', P(3,i)
!  enddo
!
  GO TO 500
! ------------------------------------------------ Nose-Hoover Chain
400 A3NKBT = 3.0D0*dble(NTION)*AKB*TEMP
  TMV2 = 0.0D0
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001) cycle
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    AMV2 = 0.0D0
    DO I = IS1, IS2
      AMV2 = AMV2 + V(1,I)**2 + V(2,I)**2 + V(3,I)**2
    enddo
    TMV2 = TMV2 + AMV2 *1.0D-16*(WIO(IO)/ANA)/(DTIME**2) !g cm**2/sec**2
  enddo
!                                       Q=STEMP : g.cm**2, erg.s**2  
!  VSTEMP = VSTEMP + (TMV2 - A3NKBT) * (DTIME**2) / STEMP * 1.0D16 
  VSTEMP(1) = (TMV2 - A3NKBT)*DTIME**2  / STEMP(1) -ER1(1)*ER1(2)
  if (nfnose > 1) then
    do nnh = 2, nfnose
      VSTEMP(nnh) = STEMP(nnh-1)*ER1(nnh-1)**2/STEMP(nnh) - KBT*DTIME**2/STEMP(nnh) - ER1(nnh)*ER1(nnh+1)
    enddo
  endif
!  write(*,*) nfnose, STEMP,STEMP2,STEMP3,STEMP4
!  read(*,*)

!
! Under construction of predictor-corrector Gear's method
!
! ------------------ Nose-Hoover thermostat 
  if (NRECRD(3) == 1) then
    do nnh = 1, nfnose
      ER0(nnh) = 0.0d0             ! etha
      ER1(nnh) = 0.0d0             ! time derivative of etha * dt 
      ER2(nnh) = 0.5d0*VSTEMP(nnh)       ! 2nd time derivative *dt^2*0.5
      ER3(nnh) = 0.0d0 
      ER4(nnh) = 0.0d0
      ER5(nnh) = 0.0d0
    enddo
  endif
  do nnh = 1, nfnose
    ER5P(nnh) = ER5(nnh)
    ER4P(nnh) = ER4(nnh) + 5.0d0*ER5(nnh)
    ER3P(nnh) = ER3(nnh) + 4.0d0*ER4(nnh) + 10.0d0*ER5(nnh)
    ER2P(nnh) = ER2(nnh) + 3.0d0*ER3(nnh) +  6.0d0*ER4(nnh) + 10.0d0*ER5(nnh)
    ER1P(nnh) = ER1(nnh) + 2.0d0*ER2(nnh) +  3.0d0*ER3(nnh) +  4.0d0*ER4(nnh) + 5.0d0*ER5(nnh)
    ER0P(nnh) = ER0(nnh) + ER1(nnh) + ER2(nnh) + ER3(nnh) + ER4(nnh) + ER5(nnh) 
  enddo
!
  do nnh = 1, nfnose
    etha(nnh) = ER0(nnh)
    detha(nnh) = ER1(nnh)/DTIME
  enddo
!  
! ------------------Equation of motion for ions  
  IF (NRECRD(3) == 1) then
    R0(1,:) = P(1,:)*BOX(1)  !Angstrom
    R0(2,:) = P(2,:)*BOX(2)
    R0(3,:) = P(3,:)*BOX(3)
    R1(:,:) = V(:,:)  ! =velocity * dt   !Angstrom * sec
    R3(:,:) = 0.0d0   ! Initial values
    R4(:,:) = 0.0d0
    R5(:,:) = 0.0d0
    do io = 1, ncompo
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001D0) cycle
      WGIO = DTIME**2 / (WIO(IO)/ANA) * 1.0D8
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      DO I = IS1, IS2
          R2(1,I)  = 0.5d0*(FX(I)*WGIO -ER1(1)*R1(1,I)) ! Angstrom 
          R2(2,I)  = 0.5d0*(FY(I)*WGIO -ER1(1)*R1(2,I)) ! Angstrom 
          R2(3,I)  = 0.5d0*(FZ(I)*WGIO -ER1(1)*R1(3,I)) ! Angstrom 
      enddo
    enddo
  ENDIF
!
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001D0) cycle
    WGIO = DTIME**2 / (WIO(IO)/ANA) * 1.0D8
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    DO I = IS1, IS2
        R5P(:,I) = R5(:,I)
        R4P(:,I) = R4(:,I) + 5.0d0*R5(:,I)
        R3P(:,I) = R3(:,I) + 4.0d0*R4(:,I) + 10.0d0*R5(:,I)
        R2P(:,I) = R2(:,I) + 3.0d0*R3(:,I) + 6.0d0*R4(:,I) + 10.0d0*R5(:,I)
        R1P(:,I) = R1(:,I) + 2.0d0*R2(:,I) + 3.0d0*R3(:,I) + 4.0d0*R4(:,I) + 5.0d0*R5(:,I)
        R0P(:,I) = R0(:,I) + R1(:,I) + R2(:,I) + R3(:,I) + R4(:,I) + R5(:,I)
!
        VC(:,I) = R1(:,I)  !velocity * dt
    enddo
  enddo
!     ==================================================================
!     ==================================================================
!
500 DO I = 1, 6
      PCT(I) = 0.0D0
    enddo
  DO IO = 1, NCOMPO
    DO J = 1, 6
      VAVB(J) = 0.0D0
    enddo
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001D0)  cycle
    VALIO2 = 0.0D0
    DO I = ions(1,IO), ions(2,IO)
!T     CALL  PTOXYZ  (I)
      IF (IOND(I) == 0) THEN
        UI(I) = 0.0D0
        cycle
      END IF
!      UI(I)  = UI(I) + ZIA(IO)
      if (runopt(35) /= 'ISOLATED  ') then
        UI(I)  = UI(I) + ZIIA(I)    !WATER-POL
      endif
      AU(I)  = AU(I) + UI(I)
!     --------------------- Thermal part of pressure tensor
      VAVB(1) = VAVB(1) + VC(1,I)**2
      VAVB(2) = VAVB(2) + VC(2,I)**2
      VAVB(3) = VAVB(3) + VC(3,I)**2
      VAVB(4) = VAVB(4) + VC(1,I) * VC(2,I)
      VAVB(5) = VAVB(5) + VC(1,I) * VC(3,I)
      VAVB(6) = VAVB(6) + VC(2,I) * VC(3,I)
!     ------------------------------------------ For m.s.d.
      VALIO2  = VALIO2 + ((P(1,I)-P0(1,I))*BOX(1))**2  &
                       + ((P(2,I)-P0(2,I))*BOX(2))**2  &
                       + ((P(3,I)-P0(3,I))*BOX(3))**2
!T                 VALIO2  = VALIO2 + (Q(1,I)-Q0(1,I))**2
!T   *                              + (Q(2,I)-Q0(2,I))**2
!T   *                              + (Q(3,I)-Q0(3,I))**2
    enddo
!   --------------------- Sum of (1/2)mv2 of i-th ion species
    AMV2 = (VAVB(1)+VAVB(2)+VAVB(3))*1.0D-16 * (WIO(IO)/ANA) / (2.0D0 * DTIME**2)
    if (iion(io) == -1)  AMV2 = (1.5D0 * DBLE(NIOND(IO))*AKB) * TEMP
    VAL(13)    = VAL(13) + AMV2
    VAL(24+IO) = AMV2 / (1.5D0 * DBLE(NIOND(IO)) *AKB)
    DO J = 1, 6
      PCT(J) = PCT(J) + (VAVB(J)*1.0D-16)*(WIO(IO)/ANA) / (DTIME**2)
    enddo
!   -------------------------------------------------- M.s.d.
    VAL(24+LEM+IO) = VALIO2  / DBLE(NIOND(IO))
  enddo
!
  DO IO = 1, NNCOMPO          !WATER-POL
    IF (NION(IO) <= 0) cycle
    if (RUNOPT(35) /= 'ISOLATED  ') then
      DO I = IONS(1,IO), IONS(2,IO)
        DO J = 1, 3
          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
            PJI     = -SIGN(1.0D0,P(J,I))
            P0(J,I) = P0(J,I) + PJI
            P(J,I)  = P(J,I)  + PJI
          END IF
        enddo
      enddo
    endif
  enddo
!
! ----------------------------------------- Temperature and pressure
  VAL(1) = VAL(13) / (1.5D0 * (DBLE(NTION)-dble(NTIOND)) * AKB)
! ----------------------------------------------- Quantum correction
  IF (RUNOPT(12) == 'QUANTUM   ')  THEN
    CALL  QUANTM
  END IF
! ------------------------------------------------------------------
  TMV2   = 2.0D0 * VAL(13)
  TINT   = TINT + VAL(1)
  VAL(9) = UCSELF + VAL(9) + UCCOR
  if (runopt(35) == 'ISOLATED  ') VCORR = 0.0D0
  VIRLSR  = VIRLSR * 1.0D-8 + VCORR
  VAL(2) = ( VAL(13)*2.0D0 + VIRLSR + VAL(9) ) / (3.0D0*VOL*1.0D-24)*1.0D-10
  VAL(3) = VAL(3) + VCORR/3.0D0
  VAL(4) = VAL(4) + VCORR/3.0D0
  VAL(5) = VAL(5) + VCORR/3.0D0
  VAL(9) = VAL(9) + UPOL   !WATER-POL
  PXYZ(1) = VAL(2)
  DO J = 1, 6
    VAL(J+2)  = (PCT(J) + VAL(J+2)) / (VOL*1.0D-24) * 1.0D-10
    PXYZ(J+1) = VAL(J+2)
    PRSTC2(J) = PRSTC2(J) / (VOL*1.0D-24) * 1.0D-10
  enddo
! --------------------------------------------------------- Energies
  if (runopt(35) == 'ISOLATED  ') ECORR = 0.0d0
  VAL(10) = VAL(10) + ECORR
  VAL(12) = VAL(9) + VAL(10) + VAL(11)
  DO I = 9, 13
    VAL(I)  = VAL(I) * FJMOL
  enddo
  VAL(14) = VAL(12) + VAL(13)
  IF (RUNOPT(34) == 'WATER-POL ') write(*,'("== Upol ", F8.4, " kJ/mol ==")') (upol)*FJMOL
  IF (ncharge == -1) write(*,'("== Ubg-charge ", F8.4, " kJ/mol ==")') UCCOR*FJMOL
  ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
  VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
  VAL(16) = VAL(14) + VAL(15)
! -----------------------------------------------Nose-Hoover Hamiltonian
  IF (RUNOPT(5) == 'T NOSE    ') then
    H_Nose = VAL(14) + FJMOL*(0.5d0*detha(1)**2*STEMP(1) + etha(1)*A3NKBT)
    if (nfnose > 1) then
      do nnh = 2, nfnose
        H_Nose = H_Nose + FJMOL*(0.5d0*detha(nnh)**2*STEMP(nnh) + etha(nnh)*KBT)
      enddo
    endif
!    write(*,*) "etha, detha", etha, detha
!    write(*,'("== Hamiltonian_Nose ", F8.2, " kJ/mol ==")') H_Nose 
    if (mod(nrecrd(1),IRECRD(4)) == 0)  write(85,'(F8.2,1x,F8.2, 5(1x,E11.4))')VAL(1),H_Nose, &
    DeltEr2(1),DeltEr2(2),DeltEr2(3),DeltEr2(4),DeltEr2(5)
  ENDIF
!   ---------------------------------------------------------------------
!
! ------------------------------------------------- Pressure control
  do i=1, 6
    pbox(i) = box(i)
  enddo                !2014 July
! -------------------------------------- Pressure control by scaling
  IF (RUNOPT(6) == 'P SCALING ')  CALL  SCCELL
! ------------------------------------- Pressure control by Andersen
  IF (RUNOPT(6) == 'P ANDERSEN')  THEN
    DPRES = VAL(2) - (VAL(3) + VAL(4) + VAL(5))/3.0D0
    PRESX = VAL(3) + DPRES
    PRESY = VAL(4) + DPRES
    PRESZ = VAL(5) + DPRES
    VOLS  = 1.0D-1*1.0D3*VOL*DTIME**2
!           WRITE(*,*) 'VOLS=',VOLS
    VBOX(1) = VBOX(1) + VOLS*(PRESX-SPRES(1))*ABOX1/VIRM(1)
    VBOX(2) = VBOX(2) + VOLS*(PRESY-SPRES(2))*ABOX2/VIRM(2)
    VBOX(3) = VBOX(3) + VOLS*(PRESZ-SPRES(3))*ABOX3/VIRM(3)
!           WRITE(*,*) CELLV
    BOX(1) = BOX(1) + VBOX(1)
    BOX(2) = BOX(2) + VBOX(2)
    BOX(3) = BOX(3) + VBOX(3)
    DO J = 1, 3
      H(J,1) = H(J,1) * BOX(1) * ABOX1
      H(J,2) = H(J,2) * BOX(2) * ABOX2
      H(J,3) = H(J,3) * BOX(3) * ABOX3
    enddo
    CALL  TABLER  (0)
  END IF
! --------------------------------------------------- Cubic Andersen
  IF (RUNOPT(6) == 'P ANDERS-C')  THEN
    VOLS  = 1.0D-1*1.0D3*VOL*DTIME**2
!           WRITE(*,*) 'VOLS=',VOLS
    VBOX(1) = VBOX(1) + VOLS*(VAL(2)-SPRES(1))*ABOX1/VIRM(1)
    VBOX(2) = VBOX(1)
    VBOX(3) = VBOX(1)
!           WRITE(*,*) CELLV
    BOX(1) = BOX(1) + VBOX(1)
    BOX(2) = BOX(1)
    BOX(3) = BOX(1)
    DO J = 1, 3
      H(J,1) = H(J,1) * BOX(1) * ABOX1
      H(J,2) = H(J,2) * BOX(2) * ABOX2
      H(J,3) = H(J,3) * BOX(3) * ABOX3
    enddo
    CALL  TABLER  (0)
  END IF
! ------------------------------------------------------- Cubic cell
  if (RUNOPT(24) == 'CUBE      ' .and. RUNOPT(6) /= 'P NO-CNTL ') then
    VVVV   = box(1) * box(2) * box(3)
    abox   = (box(1) + box(2) + box(3)) / 3.0D0
    box(1) = box(1) - (box(1)-abox)*0.0001D0
    box(2) = box(2) - (box(2)-abox)*0.0001D0
    box(3) = box(3) - (box(3)-abox)*0.0001D0
    ffff   = (vvvv / (box(1)*box(2)*box(3)))**(1.0d0/3.0d0)
    box(1) = box(1) * ffff
    box(2) = box(2) * ffff
    box(3) = box(3) * ffff
    call  tabler  (0)
  end if
!     -------------------------------------------Make wall area constant
!      if (RUNOPT(32) == 'GEN.WALL  ') then
!            AAAA   = box(1) * box(2)
!            aarea  = (box(1) + box(2)) /2.0
!            box(1) = box(1) - (box(1)-aarea)*0.0001
!            box(2) = box(2) - (box(2)-aarea)*0.0001
!            ffff   = (AAAA / (box(1)*box(2)))**(1.0D0/2.0D0)
!            box(1) = box(1) * ffff
!            box(2) = box(2) * ffff
!            call tabler (0)
!      end if
! ---------------------------------------------- Chage box with time
  if (RUNOPT(7) == 'V CHANGE  ')  then
    box(icaxis) = box(icaxis) + BCNGR
    if (bcngr > 0.0D0 .and. box(icaxis) > BTAGET) box(icaxis)=Btaget
    if (bcngr < 0.0D0 .and. box(icaxis) < BTAGET) box(icaxis)=Btaget
    CALL  TABLER  (0)
  end if
! ------------------------------------------- Bsic cell or unit cell
  VAL(17) = DENSTY
  DO I = 1, 6
    VAL(I+18) = BOX(I)
  enddo
  VAL(18) = VAL(19)*VAL(20)*VAL(21) * ANA * 1.0D-24 / dble(NFORML)
  IF (RUNOPT(17) == 'CRYSTAL   ') THEN
    DO I = 1, 3
      VAL(I+18) = BOX(I) / NBOX(I)
    enddo
  END IF
!     ---------------------------------------------------- Print results
  CALL  PRINTS  (DIPM2)
!
  IF (runopt(5)  == 'T NOSE    ') then
! --------------------------Recalculation of forces at their new positions
811 do i = 1,LVA
      VALP(i) = VAL(i)
      VAL(i) = 0.0d0
    enddo
    do i = 1,ntion+ndmole
      UI(i) = 0.0d0
      UIC(i) = 0.0d0
      FX(i) = 0.0d0
      FY(i) = 0.0d0
      FZ(i) = 0.0d0
    enddo
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001D0) cycle
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      DO I = IS1, IS2
        IF  (IION(IO) >= 0)  THEN
          dRx = R0P(1,I)
          dRy = R0P(2,I)
          dRz = R0P(3,I)
          PIJX = 0.0d0
          PIJY = 0.0d0
          PIJZ = 0.0d0
 611      if (dRx >= pBOX(1)) then 
            dRx = R0P(1,I) -pBOX(1)
            PIJX = PIJX -1.0d0
            goto 611
          endif
 614      if (dRx < 0.0d0) then 
            dRx = R0P(1,I) +pBOX(1)
            PIJX = PIJX + 1.0d0
            goto 614
          endif
 612      if (dRy >= pBOX(2)) then 
            dRy = R0P(2,I) -pBOX(2)
            PIJY = PIJY -1.0d0
            goto 612
          endif
 615      if (dRy < 0.0d0) then 
            dRy = R0P(2,I) +pBOX(2)
            PIJY = PIJY + 1.0d0
            goto 615
          endif
 613      if (dRz >= pBOX(3)) then 
            dRz = R0P(3,I) -pBOX(3)
            PIJZ = PIJZ -1.0d0
            goto 613
          endif
 616      if (dRz < 0.0d0) then 
            dRz = R0P(3,I) +pBOX(3)
            PIJZ = PIJZ + 1.0d0
            goto 616
          endif
          PX(I) = dRx/pBOX(1) !Predicted positions at t + dt
          PY(I) = dRy/pBOX(2)
          PZ(I) = dRz/pBOX(3)
          P0(1,I) = PP0(1,I) + PIJX
          P0(2,I) = PP0(2,I) + PIJY
          P0(3,I) = PP0(3,I) + PIJZ
        END IF
!       not perfect for msd !!!! 
!        IF (PX(I) < 0.0D0 .OR. PX(I) >= 1.0D0)  THEN
!          PJI     = -SIGN(1.0D0,PX(I))
!          PX(I)  = PX(I)  + PJI
!          P0(1,I) = P0(1,I) + PJI
!        endif
!        IF (PY(I) < 0.0D0 .OR. PY(I) >= 1.0D0)  THEN
!          PJI     = -SIGN(1.0D0,PY(I))
!          PY(I)  = PY(I)  + PJI
!          P0(2,I) = P0(2,I) + PJI
!        endif
!        IF (PZ(I) < 0.0D0 .OR. PZ(I) >= 1.0D0)  THEN
!          PJI     = -SIGN(1.0D0,PZ(I))
!          PZ(I)  = PZ(I)  + PJI
!          P0(3,I) = P0(3,I) + PJI
!        endif
      enddo
    enddo
    KRDF =0
    call EWALDS  !Recalculation of Forces
!   --------------------------Correction of Thermostat
    TMV2 = 0.0D0
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001) cycle
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      AMV2 = 0.0D0
      DO I = IS1, IS2
        AMV2 = AMV2 + R1P(1,I)**2 + R1P(2,I)**2 + R1P(3,I)**2
      enddo
      TMV2 = TMV2 + AMV2 *1.0D-16*(WIO(IO)/ANA)/DTIME**2 !g cm**2/sec**2
    enddo
    VSTEMP(1) = (TMV2 - A3NKBT)*DTIME**2  / STEMP(1) - ER1P(1)*ER1P(2)
    if (nfnose > 1) then
      do nnh = 2, nfnose
        VSTEMP(nnh) = STEMP(nnh-1)*ER1P(nnh-1)**2/STEMP(nnh) - KBT*DTIME**2/STEMP(nnh) - ER1P(nnh)*ER1P(nnh+1)
      enddo
    endif
!
    do nnh = 1, nfnose
      DeltEr2(nnh) = 0.5d0*VSTEMP(nnh) - ER2P(nnh)
      ER5(nnh) = ER5P(nnh) + 1.0d0/60.0d0*DeltEr2(nnh)
      ER4(nnh) = ER4P(nnh) + 1.0d0/6.0d0*DeltEr2(nnh)
      ER3(nnh) = ER3P(nnh) + 11.0d0/18.0d0*DeltEr2(nnh)
      ER2(nnh) = ER2P(nnh) + DeltEr2(nnh)
      ER1(nnh) = ER1P(nnh) + 251.0d0/360.0d0*DeltEr2(nnh)
      ER0(nnh) = ER0P(nnh) + 3.0d0/16.0d0*DeltEr2(nnh)
    enddo
!write(*,*) DeltEr2(1),DeltEr2(2)
!read(*,*)
!
!
!   --------------------------------Correction of ions
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001D0) cycle
      WGIO = DTIME**2 / (WIO(IO)/ANA) * 1.0D8
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      DO I = IS1, IS2
          Deltr2(1,I) = 0.5d0*(FX(I)*WGIO - ER1P(1)*R1P(1,I)) - R2P(1,I)
          Deltr2(2,I) = 0.5d0*(FY(I)*WGIO - ER1P(1)*R1P(2,I)) - R2P(2,I)
          Deltr2(3,I) = 0.5d0*(FZ(I)*WGIO - ER1P(1)*R1P(3,I)) - R2P(3,I)
!
          R5(:,I) = R5P(:,I) + 1.0d0/60.0d0*Deltr2(:,I)
          R4(:,I) = R4P(:,I) + 1.0d0/6.0d0*Deltr2(:,I) 
          R3(:,I) = R3P(:,I) + 11.0d0/18.0d0*Deltr2(:,I) 
          R2(:,I) = R2P(:,I) + Deltr2(:,I) 
          R1(:,I) = R1P(:,I) + 251.0d0/360.0d0*Deltr2(:,I) 
          R0(:,I) = R0P(:,I) + 3.0d0/16.0d0*Deltr2(:,I) 
!
        IF  (IION(IO) >= 0)  THEN
          dRx = R0(1,I)
          dRy = R0(2,I)
          dRz = R0(3,I)
          PIJX = 0.0d0
          PIJY = 0.0d0
          PIJZ = 0.0d0
 511      if (dRx >= pBOX(1)) then 
            dRx = R0(1,I) -pBOX(1)
            PIJX = PIJX -1.0d0
            goto 511
          endif
 514      if (dRx < 0.0d0) then 
            dRx = R0(1,I) +pBOX(1)
            PIJX = PIJX + 1.0d0
            goto 514
          endif
 512      if (dRy >= pBOX(2)) then 
            dRy = R0(2,I) -pBOX(2)
            PIJY = PIJY -1.0d0
            goto 512
          endif
 515      if (dRy < 0.0d0) then 
            dRy = R0(2,I) +pBOX(2)
            PIJY = PIJY + 1.0d0
            goto 515
          endif
 513      if (dRz >= pBOX(3)) then 
            dRz = R0(3,I) -pBOX(3)
            PIJZ = PIJZ -1.0d0
            goto 513
          endif
 516      if (dRz < 0.0d0) then 
            dRz = R0(3,I) +pBOX(3)
            PIJZ = PIJZ + 1.0d0
            goto 516
          endif
!          if (dRx >= BOX(1) .or. dRx < 0.0d0) then
!            write(*,*) 'dRx =',dRx
!            read(*,*)
!          endif
!          if (dRy >= BOX(2) .or. dRy < 0.0d0) then
!            write(*,*) 'dRy =',dRy
!            read(*,*)
!          endif
!          if (dRz >= BOX(3) .or. dRz < 0.0d0) then
!            write(*,*) 'dRz =',dRz
!            read(*,*)
!          endif
          P(1,I) = dRx/pBOX(1)
          P(2,I) = dRy/pBOX(2)
          P(3,I) = dRz/pBOX(3)
          P0(1,I) = PP0(1,I) + PIJX
          P0(2,I) = PP0(2,I) + PIJY
          P0(3,I) = PP0(3,I) + PIJZ
        END IF
        VP(:,I) = V(:,I)
        V(:,I)  = R1(:,I) 
      enddo
    enddo
!
    do i = 1,LVA
      VAL(i) = VALP(i)
    enddo
!
!    DO IO = 1, NNCOMPO
!      IF (NION(IO) <= 0) cycle
!      DO I = IONS(1,IO), IONS(2,IO)
!        DO J = 1, 3
!          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
!            PJI     = -SIGN(1.0D0,P(J,I))
!            P0(J,I) = P0(J,I) + PJI
!            P(J,I)  = P(J,I)  + PJI
!!            R0(J,I) = R0(J,I) + PJI*BOX(J)
!!if (abs(P0(J,I)) > 1.0d0) then
!!        write(*,*)PJI, P0(J,I),P(J,I)
!!        read(*,*)
!!endif
!          END IF
!        enddo
!      enddo
!    enddo
    jconv = 0
    do nnh = 1, nfnose
      if (abs(DeltEr2(nnh)) > 1.0d-6) then 
        jconv = 1
      endif
    enddo
    if (jconv == 1) then
      do nnh = 1,nfnose
          ER0P(nnh) = ER0(nnh)
          ER1P(nnh) = ER1(nnh)
          ER2P(nnh) = ER2(nnh)
          ER3P(nnh) = ER3(nnh)
          ER4P(nnh) = ER4(nnh)
          ER5P(nnh) = ER5(nnh)
      enddo
      DO IO = 1, NCOMPO
        IF (NION(IO) <= 0) cycle
        IF (WIO(IO) < 0.00001D0) cycle
        IS1 = IONS(1,IO)
        IS2 = IONS(2,IO)
        DO I = IS1, IS2
            R5P(:,I) = R5(:,I) 
            R4P(:,I) = R4(:,I) 
            R3P(:,I) = R3(:,I) 
            R2P(:,I) = R2(:,I) 
            R1P(:,I) = R1(:,I) 
            R0P(:,I) = R0(:,I) 
        enddo
      enddo
      goto 811
    endif
  ENDIF
! ====================================Nose-Hoover Thermostat  
!
! ------------------------------------- Correction for sum of mv = 0
!                                                    (Center of gravity)
  IF (RUNOPT(21) /= 'GRAV.FIELD' .AND.  RUNOPT(16) /= 'NO(MV=0)  ' )  then
    io1 = 1
    io2 = ncompo
    TWT = TWEGHT
    if (runopt(16) == 'Am(MV=0)  ') then
      io1 = Iam
      io2 = Iam
      TWT = wio(Iam)*dble(Nion(Iam))
    end if
    DO J = 1, 3
      CENTRE = 0.0D0
      DO IO = Io1, Io2
        IF (NION(IO) > 0)  THEN
          DO I = IONS(1,IO), IONS(2,IO)
            CENTRE = CENTRE + V(J,I)*WIO(IO)
          enddo
        END IF
      enddo
      CENTRE = CENTRE / TWT
      CENTRP = CENTRE / BOX(J)
!                  write (6,*)  j, centrp,' grav'
      DO I = 1, NTION+ndmole    !WATER-POL
        IF (IOND(I) > 0)  THEN
          V(J,I) = V(J,I) - CENTRE
          P(J,I) = P(J,I) - CENTRP
          IF (runopt(5) == 'T NOSE    ') then
            R1(J,I) = V(J,I)
            R0(J,I) = R0(J,I) - CENTRP*BOX(J)
          ENDIF
        END IF
      enddo
    enddo
  end if
! --------------------------------------------- Temperature control
  IF (RUNOPT(5) == 'T SCALING ')  THEN
    FV = 1.0D0
    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
      TEMP = TEMP + DELTMP
      IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
      FV = DSQRT(TEMP/(TINT/DBLE(NTSTEP)))
    END IF
    IF (RUNOPT(12) == 'QUANTUM   ') THEN
      QCEE = QCEE + QCIT * VAL(1) + TQCE / VAL(1)
      QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
      IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
        FV = DSQRT(QCEF*1.0D0/QCEE)
      END IF
    END IF
    IF (MODE < 0)                  FV = DSQRT(TEMP/TPRE)
    IF (RUNOPT(5) == 'T NO-CNTL.')  FV = 1.0D0    ! ???? NO need????
!            IF (ABS(DELTMP) <= 0.000001)    FV = 1.0D0
    IF (VAL(1)/TEMP < 0.3333D0)    FV = DSQRT(TEMP/VAL(1))
    IF (VAL(1)/TEMP > 1.6667D0)    FV = DSQRT(TEMP/VAL(1))
!    write(*,*) 'FV = ', FV
    FV = 1.0D0 + (FV - 1.0D0) * TDUMP
    IF (ABS(FV-1.0D0) > 1.0D-7)  THEN
      do io = 1, ncompo
        if (iion(io) /= 2) then
          DO I = ions(1,io), ions(2,io)
            DO J = 1, 3
              V(J,I) = V(J,I) * FV
            enddo
          enddo
        end if
      enddo
    END IF
  END IF
  IF (RUNOPT(5) == 'T SCALE-A ')  THEN
    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
      TEMP = TEMP + DELTMP
      IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
      IF (DELTMP < 1.0d-6) TEMP = TMPGET
    END IF
    do io = 1, ncompo
      FV = 1.0D0
      IF (MOD(NRECRD(1),NTSTEP) == 0) FV=DSQRT(TEMP/VAL(24+IO))
      IF (RUNOPT(12) == 'QUANTUM   ') THEN
        QCEE = QCEE + QCIT * VAL(24+IO) + TQCE/VAL(24+IO)
        QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
        IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
          FV = DSQRT(QCEF*1.0D0/QCEE)
        END IF
      END IF
      IF (VAL(24+IO)/TEMP < 0.333D0) FV=DSQRT(TEMP/VAL(24+IO))
      IF (VAL(24+IO)/TEMP > 1.667D0) FV=DSQRT(TEMP/VAL(24+IO))
      FV = 1.0D0 + (FV - 1.0D0) * TDUMP
      IF (ABS(FV-1.0D0) > 1.0D-7)  THEN
        if (iion(io) /= 2) then
          DO I = ions(1,io), ions(2,io)
            DO J = 1, 3
              V(J,I) = V(J,I) * FV
            enddo
          enddo
        end if
      END IF
    enddo
  END IF
  IF (RUNOPT(5) == 'T NOSE    ')  THEN
!    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN    !2014/04/14
!      TEMP = TEMP + DELTMP
!      IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
!      IF (DELTMP < 1.0d-6) TEMP = TMPGET
!    END IF
    TEMP = TMPGET
    IF (RUNOPT(12) == 'QUANTUM   ') THEN
      QCEE = QCEE + QCIT * VAL(1) + TQCE / VAL(1)
      QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
      FV   = DSQRT(QCEF*1.0D0/QCEE)
      DO I = 1, NTION
        DO J = 1, 3
          V(J,I) = V(J,I) * FV
        enddo
      enddo       
    END IF
  END IF
! --------------------------- Reduce velocities to prevent explosion
  IF (RUNOPT(5) /= 'T NOSE    ') then
  IF (RUNOPT(5) /= 'T NO-CNTL '.AND. VAL(1) > TEMP*2.0D0)  THEN
    IF (VAL(1)-TPRE > 1.0D6)  GO TO 999
    FV = DSQRT(TEMP/VAL(1))
    DO I = 1, NTION
      FVI = FV
      V2 = V(1,I)**2 + V(2,I)**2 + V(3,I)**2
      IF (V2 > 0.2D0)  FVI = FV * 0.2D0/V2
      DO J = 1, 3
        P(J,I) = P(J,I) - (1.0D0 - FVI)*V(J,I) / BOX(J)
        V(J,I) = V(J,I) * FVI
      enddo
    enddo
  END IF
  END IF
  TPRE = VAL(1)
!
! ---------------------------------------- Centering of Atom Cluster
  if (runopt(15) == 'CENTERING ')  then
    xcen = 0.0d0
    ycen = 0.0d0
    zcen = 0.0d0
    if (iaxcen == 1) xcen = 1.0d0
    if (iaxcen == 2) ycen = 1.0d0
    if (iaxcen == 3) zcen = 1.0d0
    if (iaxcen == 0)  then
      xcen = 1.0d0
      ycen = 1.0d0
      zcen = 1.0d0
    end if
    do i = 1, ntion
      v(1,i) = v(1,i) - (p(1,i)-0.5d0)*0.00002d0*xcen
      v(2,i) = v(2,i) - (p(2,i)-0.5d0)*0.00002d0*ycen
      v(3,i) = v(3,i) - (p(3,i)-0.5d0)*0.00002d0*zcen
    enddo
  end if
!
  if (runopt(34) == 'WATER-POL ') call FIND_H2O(1)
!
!     CALL  XYZTOP
RETURN
!
  999 WRITE  (*,9988)  VAL(1)
 9988 FORMAT (' *****  TEMPERATURE GETS TOO HIGH  ',F10.0,'K  *****')
STOP
END
!
!                                                               ========
!=================================================================STOPT 
SUBROUTINE STOPT (AJDG)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use pmorse
  use charge
  use pos
  use ewal
  use molecu
!
  implicit none
!
  COMMON /ANIPAR/ FCUT,FFAC, Tmin, NNSYM, mstep
            REAL *8   FCUT,FFAC, Tmin
            integer*4 NNSYM,mstep
!
  REAL    *8      PJI
  REAL    *8      MAGF,Tenergy
  real    *8      qcee,qcef,aspres,tf
  real    *8      FXP(LNI),FYP(LNI),FZP(LNI)
  real    *8      rL1OX,rL1OY,rL1OZ,rL1O
  real    *8      TV1,TV2
  real    *8      rL2OX,rL2OY,rL2OZ,rL2O
  real    *8      CO1,CO2a,CO2b,Nx,Ny,Nz
  integer *4      n,io,i,j,is1,is2,ajdg,NNCOMPO,lp1,lp2,kk,mm,no
!
!
upol = 0.0D0
NNCOMPO = NCOMPO
if (runopt(34) == 'WATER-POL ') NNCOMPO = NCOMPO + 1
200  DO N = 1, N3BP
    AV3BP(1,N) = 0.0D0
    AV3BP(2,N) = 0.0D0
  enddo
!
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0)  cycle
    DO I = IONS(1,IO), IONS(2,IO)
      UI(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      UIC(I) = 0.0D0   ! WATER-POL
      If (runopt(35) /= 'ISOLATED  ') then
        DO J = 1, 3
          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
            PJI     = -SIGN(1.0D0,P(J,I))
            P0(J,I) = P0(J,I) + PJI
            P(J,I)  = P(J,I)  + PJI
          END IF
        enddo
      endif 
      PX(I)  = P(1,I)
      PY(I)  = P(2,I)
      PZ(I)  = P(3,I)
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
  enddo
  if (runopt(34) == 'WATER-POL ')  then
    do i = ntion+1, ntion+ndmole
      if (runopt(35) /= 'ISOLATED  ') then
        DO J = 1, 3
          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
            PJI     = -SIGN(1.0D0,P(J,I))
            P0(J,I) = P0(J,I) + PJI
            P(J,I)  = P(J,I)  + PJI
          END IF
        enddo
      endif
      PX(I) = P(1,I)
      PY(I) = P(2,I)
      PZ(I) = P(3,I)
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0) ZII(I) = 0.0D0
    enddo
  endif
!
!
  if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
!
  DO I = 1, LVA
    VAL(I) = 0.0D0
  enddo
!
  NRECRD(2) = NRECRD(2) + 1
  IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
    TINT = 0.0D0
    QCEE = 0.0D0
    QCEF = 0.0D0
  END IF
!     --------------------------------- Coulomb and Short range (2-body)
!                                               and 3-body term
  JJJ = 1
  KRDF = 0
  maxedip = 1.0D0
  sumedip = 1.0D0
  IF (RUNOPT(34) /= 'WATER-POL ') CALL EWALDS
  IF (RUNOPT(34) == 'WATER-POL ' ) then
201 do N = 1, N3BP
      AV3BP(1,N) = 0.0d0
      AV3BP(2,N) = 0.0d0
    enddo
    do i = 1, ntion+ndmole
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0) ZII(I) = 0.0D0
    enddo
    DO I = 1, LVA
      VAL(I) = 0.0D0
    enddo
    if(JJJ /= 1 .or. NRECRD(3) <= 4) CALL EWALDS
    CALL POLH2O
    JJJ = JJJ + 1
!    if (maxedip > THRESHD) goto 201
    if (sumedip > THRESHD) goto 201
!    IF (JJJ <= ITER) goto 201
    do N = 1, N3BP
      AV3BP(1,N) = 0.0d0
      AV3BP(2,N) = 0.0d0
    enddo
    do i = 1, ntion+ndmole
      UICP4(I) = UICP3(I)
      UICP3(I) = UICP2(I)
      UICP2(I) = UICP1(I)
      UICP1(I) = UIC(I)
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0) ZII(I) = 0.0D0
    enddo
    DO I = 1, LVA   !LVA = 24+LEM*2 = 44
      VAL(I) = 0.0D0
    enddo
    IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
      TINT = 0.0D0
      QCEE = 0.0D0
      QCEF = 0.0D0
    END IF
    KRDF = 1
    CALL EWALDS
!    CALL EWALD_UPOL
  ENDIF
!
202 continue
!
  VAL(9) = VAL(9) + UCSELF + upol + UCCOR
! --------------------------------------------------------- Energies
  if (runopt(35) == 'ISOLATED  ') ECORR = 0.0d0
  VAL(10) = VAL(10) + ECORR
  VAL(12) = VAL(9) + VAL(10) + VAL(11)
  Tenergy=  (VAL(12) + VAL(13))*1.0D12/1.602176462D0
write(*,'("Upol [ev] = ", F12.7)') upol*1.0D12/1.602176462D0
!write(*,'("Upol [kJ/mol] = ", F12.7)') upol*FJMOL
  DO I = 9, 13
    VAL(I)  = VAL(I) * FJMOL
  enddo
  VAL(14) = VAL(12) + VAL(13)
  ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
  VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
  VAL(16) = VAL(14) + VAL(15)
!
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001D0)  cycle
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    DO I = IS1, IS2
!T                 CALL  PTOXYZ  (I)
      IF (IOND(I) == 0) THEN
        UI(I) = 0.0D0
        cycle
      END IF
!      UI(I)  = UI(I) + ZIA(IO)
      if (runopt(35) /= 'ISOLATED  ') then
        UI(I)  = UI(I) + ZIIA(I)
      endif
      AU(I)  = AU(I) + UI(I)
    enddo
  enddo
!
  IF (RUNOPT(34) == 'WATER-POL ') then
!   -------------- Temperature of Oxygen
!   Energy of massless lone pairs are distributed to Oxygen
    no = 0
    do io = ions(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      ui(io) = ui(io) + ui(lp1) + ui(lp2)
    enddo
    no = 0
!   -------------------------------constrain included in interatomic forces
    DO io = ions(1,IATOMO), ions(2,IATOMO)
      no = no + 1
      IF (IOND(io) == 0)  THEN
        V(1,io) = 0.0D0
        V(2,io) = 0.0D0
        V(3,io) = 0.0D0
        cycle
      END IF
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      fx(io) = fx(io)  + (fx(lp1) + fx(lp2)) !constrain between O and Lone pairs
      fy(io) = fy(io)  + (fy(lp1) + fy(lp2)) 
      fz(io) = fz(io)  + (fz(lp1) + fz(lp2)) 
    enddo
!
    no = 0
    DO io = ions(1,IATOMO), ions(2,IATOMO)
      no = no + 1
!      ------------------------------------- constrain of angle between LP-O-H
      kk = ih2o(2,no)
      mm = ih2o(3,no)
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
!
!     ------------------------------------- vector O -> LP1
      rL1OX = LOP1X(no)
      rL1OY = LOP1Y(no) 
      rL1OZ = LOP1Z(no) 
      rL1O  = RD 
!     ------------------------------------- vector O -> LP2
      rL2OX = -1.0d0*LOP1X(no) 
      rL2OY = -1.0d0*LOP1Y(no) 
      rL2OZ = -1.0d0*LOP1Z(no) 
      rL2O  = RD 
!
      Nx = rL1OY*FZ(lp1) - rL1OZ*FY(lp1) + rL2OY*FZ(lp2) - rL2OZ*FY(lp2)
      Ny = rL1OZ*FX(lp1) - rL1OX*FZ(lp1) + rL2OZ*FX(lp2) - rL2OX*FZ(lp2)
      Nz = rL1OX*FY(lp1) - rL1OY*FX(lp1) + rL2OX*FY(lp2) - rL2OY*FX(lp2)
!
      TV1 = (Nx*HHX(no) + Ny*HHY(no) + Nz*HHZ(no))/HHV(no)
!
      CO1 = -0.5D0*TV1/DPV(no)/RD
      FXP(kk) = CO1*rL1OX
      FYP(kk) = CO1*rL1OY
      FZP(kk) = CO1*rL1OZ
      FXP(mm) = CO1*rL1OX
      FYP(mm) = CO1*rL1OY
      FZP(mm) = CO1*rL1OZ
!
      TV2 = (Nx*DPX(no) + Ny*DPY(no) + Nz*DPZ(no))/DPV(no)
!
      CO2a = -0.5d0*TV2/A1(no)/RD
      CO2b =  0.5d0*TV2/A2(no)/RD
      FXP(kk) = FXP(kk) + CO2a*rL1OX
      FYP(kk) = FYP(kk) + CO2a*rL1OY
      FZP(kk) = FZP(kk) + CO2a*rL1OZ
      FXP(mm) = FXP(mm) + CO2b*rL1OX
      FYP(mm) = FYP(mm) + CO2b*rL1OY
      FZP(mm) = FZP(mm) + CO2b*rL1OZ
!
!
      FX(io) =  FX(io) - (FXP(kk) + FXP(mm))
      FY(io) =  FY(io) - (FYP(kk) + FYP(mm))
      FZ(io) =  FZ(io) - (FZP(kk) + FZP(mm))
      FX(kk) = FX(kk) + FXP(kk)
      FY(kk) = FY(kk) + FYP(kk)
      FZ(kk) = FZ(kk) + FZP(kk)
      FX(mm) = FX(mm) + FXP(mm)
      FY(mm) = FY(mm) + FYP(mm)
      FZ(mm) = FZ(mm) + FZP(mm)
    enddo
!
  ENDIF
!
  IF(NNSYM == 1) then
    do i = 3,4
      FZ(i) = 0.0D0
    enddo
    FZ(6) = - FZ(5)
    FX(6) = FX(5)
    FY(6) = FY(5)
  ENDIF
  AJDG = 0
  TF=0.0D0
  if (RUNOPT(36) /= 'EWALD-OPT ') then 
    DO IO = 1, NCOMPO
      IF(IION(IO)  ==  -1) cycle
      DO I = IONS(1,IO), IONS(2,IO)
        MAGF= DSQRT(FX(I)**2+FY(I)**2+FZ(I)**2)
        IF(ABS(FX(I))  >  FCUT) P(1,I)=P(1,I) + FFAC*FX(I)/MAGF/BOX(1)/WIO(IO)
        IF(ABS(FY(I))  >  FCUT) P(2,I)=P(2,I) + FFAC*FY(I)/MAGF/BOX(2)/WIO(IO)
        IF(ABS(FZ(I))  >  FCUT) P(3,I)=P(3,I) + FFAC*FZ(I)/MAGF/BOX(3)/WIO(IO)  ! 2014 Aug 1
!        IF(ABS(FX(I))  >  FCUT .OR. ABS(FY(I))  >  FCUT .OR. ABS(FZ(I))  >  FCUT)  AJDG = 1
        IF (MAGF > TF) TF = MAGF
        IF (MAGF > FCUT) AJDG = 1
!        TF = TF + MAGF
      enddo
    enddo
    if (runopt(35) /= 'ISOLATED  ') then
      DO IO = 1, NCOMPO
        IF (NION(IO) <= 0) cycle
        DO I = IONS(1,IO), IONS(2,IO)
          DO J = 1, 3
            IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
              PJI     = -SIGN(1.0D0,P(J,I))
              P0(J,I) = P0(J,I) + PJI
              P(J,I)  = P(J,I)  + PJI
            END IF
          enddo
        enddo
      enddo
    endif
  endif
!
  IF (Tmin > Tenergy) then
    Tmin = Tenergy
    mstep = NRECRD(1)
  ENDIF
!
  IF (MOD(NRECRD(1),1) == 0 .or. NRECRD(1) == 0) then
    WRITE(*,'("STEP= ", i7, "  E(eV)= ", E14.7, "  maxF = ", E12.5)')NRECRD(1),Tenergy,TF
!    WRITE(*,'("STEP= ", i7, "  E(kJ/mol)= ", E14.7, "  maxF = ", E12.5)')NRECRD(1),VAL(14),TF
  endif
  if (runopt(36) == 'EWALD-OPT ') then
    open (49, file='energy-force.dat',status='unknown', &
              form='formatted',access='sequential')
      write(49,'("Rcut(1): ", f10.6)')RCUT(1)
      write(49,'("ALPHA:   ", f10.7,1x, E20.13,1x,i10)')ALPHA,Tenergy,NVN
      write(49,'("NVN:     ", i10)')NVN
      write(49,'("Total energy (eV): ",E20.13)')Tenergy
      do io = 1,ncompo
        do i = ions(1,io),ions(2,io)
          write(49,'(f10.7,1x, 3(E20.12,1x))')ALPHA,FX(i),FY(i),FZ(i)
        enddo
      enddo
    close(49)
   open (48, file='force.dat',status='unknown', &
             form='formatted',access='sequential')
          write(48,'(f10.7,1x, 3(E20.12,1x),i10)')ALPHA,FX(1),FY(1),FZ(1),NVN
   close(48)
   open (47, file='force_all.dat',status='unknown', &
             form='formatted',access='sequential')
      do io = 1,ncompo
        do i = ions(1,io),ions(2,io)
          write(47,'(f10.7,1x, 3(E20.12,1x),i10)')ALPHA,FX(i),FY(i),FZ(i),NVN
        enddo
      enddo
   close(47)
  endif
!
  if (runopt(34) == 'WATER-POL ') call FIND_H2O(1)
!
RETURN
END
!
!                                                               ========
!================================================================ POSURF
SUBROUTINE  POSURF
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use pmorse
  use charge
  use pos
  use ewal
!
  implicit none
!
  COMMON /PSURF / DISTM, iato1, iato2, iarea
            REAL  *8  DISTM 
!
  REAL    *8      Tenergy,QCEE,QCEF,PJI
  REAL    *8      PO(3,LNI)
  real    *8      SNEAR,SFAR,ARMIN,ARMAX,DX1,DX2,DY1,DY2,DZ1,DZ2,ASPRES
  real    *8      DISTA
  INTEGER *4      IPV(3,LNI),LLL,isp,iato1,iato2,iarea
  CHARACTER *1    SPO,sp
  integer *4      N,IO,I,J,III,K,L,II,JJ,M
!
  DO N = 1, N3BP
    AV3BP(1,N) = 0.0
    AV3BP(2,N) = 0.0
  enddo
!
  WRITE(*,*)'Starting number of moving atom=', iato1
  WRITE(*,*)'Last number of moving atom=',iato2
  IF (iarea  ==  1 .OR. iarea  ==  2 .OR. iarea  ==  3) THEN
201 WRITE(*,*)'Surface postion is larger than 0.5? (y,n)'
    READ (*,*)SPO
    IF (SPO  /=  'y' .AND. SPO  /=  'n') GO TO 201
    SNEAR = 0.5
    SFAR  = 2.0
    IF (SPO  ==  'y') THEN
!        SNEAR = 2.0
!        SFAR  = 0.5
      SNEAR = 13.1
      SFAR  = 20.1
    ENDIF
  ENDIF
205 write(*,*)'Single point? (y,n)'
  read(*,*)sp
  if (sp  ==  'y') isp = 1
  if (sp  ==  'n') isp = 0
  if (sp  /=  'y' .and. sp  /=  'n') goto 205
  IF (iarea  ==  4 .OR. iarea  ==  5 .OR. iarea  ==  6) THEN
    ARMIN =   2.0
    ARMAX =   2.0
  ENDIF
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    DO I = IONS(1,IO), IONS(2,IO)
      UI(I) = 0.0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0 
      if (runopt(35) /= 'ISOLATED  ') then
        DO J = 1, 3
          IF (P(J,I) < 0.0D0.OR.P(J,I) >= 1.0D0)  THEN
            PJI     = -SIGN(1.0D0,P(J,I))
            P0(J,I) = P0(J,I) + PJI
            P(J,I)  = P(J,I)  + PJI
          END IF
        enddo
      endif
      PX(I)  = P(1,I)
      PY(I)  = P(2,I)
      PZ(I)  = P(3,I)
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
  enddo
!
  if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
!
  DO I = 1, LVA
    VAL(I) = 0.0D0
  enddo
  NRECRD(2) = NRECRD(2) + 1
  IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
    TINT = 0.0
    QCEE = 0.0D0
    QCEF = 0.0D0
  END IF
  DO I = 1,3
    DO J = iato1,iato2
      PO(I,J) = P(I,J)
    enddo
  enddo
  OPEN ( 37, FILE=FLNAME(17), STATUS = 'UNKNOWN',ACCESS='sequential',FORM='FORMATTED')
    WRITE(37,1002) 'dx','dy','dz','ENERGY(eV)','ENERGY(kJ/mol)', &
                   'val(9)','val(10)','val(11)','FZ(1)'
    DX1 = 0.0
    DX2 = 0.0
    DY1 = 0.0
    DY2 = 0.0
    DZ1 = 0.0
    DZ2 = 0.0
    IF (iarea  ==  1) THEN
      DX1 = SNEAR
      DX2 = SFAR
    ELSE IF (iarea  ==  2) THEN
      DY1 = SNEAR
      DY2 = SFAR
    ELSE IF (iarea  ==  3) THEN
      DZ1 = SNEAR
      DZ2 = SFAR
    ELSE IF (iarea  ==  4) THEN
      DX1 = ARMIN
      DX2 = ARMAX
      DY1 = ARMIN
      DY2 = ARMAX
    ELSE IF (iarea  ==  5) THEN
      DY1 = ARMIN
      DY2 = ARMAX
      DZ1 = ARMIN
      DZ2 = ARMAX
    ELSE IF (iarea  ==  6) THEN
      DX1 = ARMIN
      DX2 = ARMAX
      DZ1 = ARMIN
      DZ2 = ARMAX
    ENDIF
    if (isp  ==  1) then
      dx1 = 0.0
      dx2 = 0.0
      dy1 = 0.0
      dy2 = 0.0
      dz1 = 0.0
      dz2 = 0.0
    endif
    iii = 1
    DO I = -INT(DX1/DISTM+0.0001),INT(DX2/DISTM+0.0001)
      WRITE(*,*)'I=',I
      DO J = -INT(DY1/DISTM+0.0001),INT(DY2/DISTM+0.0001)
        WRITE(*,*)'J=',J
        DO K = -INT(DZ1/DISTM+0.0001),INT(DZ2/DISTM+0.0001)
          DO L = iato1,iato2
            PX(L) = PO(1,L) + I*DISTM/BOX(1)
            PY(L) = PO(2,L) + J*DISTM/BOX(2)
            PZ(L) = PO(3,L) + K*DISTM/BOX(3)
          enddo
!         --------------------------------------------write on file09p.dat
          iii = iii+1
          DO II = 1, NTION
            IPV(1,II) = PX(II) * 90000.D0
            IPV(2,II) = PY(II) * 90000.D0
            IPV(3,II) = PZ(II) * 90000.D0
          enddo
          WRITE (19,9002)  iii, 0,BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0,0.0,BOX(3)
          WRITE (19,9001) ((IPV(JJ,II),JJ=1,3),II=1,NTION)
 9001     FORMAT (18I5)
 9002     FORMAT (2I5, 9F7.3)
!
          DO M=9,16
            VAL(M)  = 0.0D0
          enddo
          do LLL = 1, NTION
            UI(LLL) = 0.0
            FX(LLL) = 0.0D0
            FY(LLL) = 0.0D0
            FZ(LLL) = 0.0D0
          enddo
!
          CALL  EWALDS
!
          if (i  ==  0 .and. j ==  0 .and. k  ==  0) then
            write(*,*)'VAL(3)=',VAL(3) !erg
            write(*,*)'VAL(4)=',VAL(4)
            write(*,*)'VAL(5)=',VAL(5)
            write(*,*)'VAL(6)=',VAL(6)
            write(*,*)'VAL(7)=',VAL(7)
            write(*,*)'VAL(8)=',VAL(8)
            write(*,*)'VAL(9)=',VAL(9)
          endif
          VAL(9) = VAL(9) + Ucself
!            write(*,*)'ucself=',Ucself
!            write(*,*)'VAL(9)=',val(9)
!
!         -------------------------------------------------- Energies
  if (runopt(35) == 'ISOLATED  ') ECORR = 0.0d0
          VAL(10) = VAL(10) + ECORR
          VAL(12) = VAL(9) + VAL(10) + VAL(11)
          Tenergy=  (VAL(12) + VAL(13))*1.0D12/1.602176462D0  !eV
          DO L = 9, 13
            VAL(L)  = VAL(L) * FJMOL   !erg -> kJmol^-1
          enddo
          VAL(14) = VAL(12) + VAL(13)
          ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0
          VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
          VAL(16) = VAL(14) + VAL(15)
!
! 1991           FORMAT (F8.2,7F8.4)
! 1992           format (8F9.2)
! 1993           format (F9.5, F9.3, 3F9.5,3F9.5)
! 1994           format (10F8.2)
! 1995           format (10F8.3 )
!         ---------------------------------------write on file09v.dat
          write  (29,'(F10.3,7F10.5)')  (VAL(II),II=1,8)
          write  (29,'(8F10.3)')  (VAL(II),II=9,16)
          write  (29,'(F10.6,F10.4,3F10.6,3F10.7)')  (VAL(II),II=17,24)
          write  (29,'(10F9.3)')  (VAL(II),II=25,34)
          write  (29,'(10F9.3)')  (VAL(II),II=35,44)
!
          IF (SPO  ==  'y') THEN
            DISTA = -K*DISTM
          ELSEIF (SPO  ==  'n') THEN
            DISTA = K*DISTM
          ENDIF
          WRITE(37,1001)I*DISTM,J*DISTM,DISTA,Tenergy,VAL(14),val(9),val(10),val(11),FZ(1)
        enddo
      enddo
    enddo
  close(37)
 1001 FORMAT(F7.3,1x,F7.3,1x,F7.3,1x,E25.12,1x,E25.12,1X,E25.12,1x,e25.12,1x,e25.12,1x,e25.12)
 1002 FORMAT(A7,1X,A7,1X,A7,1X,A25,1X,A25,1X,A25,1X,A25,1X,A25,1x,A25)
RETURN
END
!                                                               ========
!================================================================ PRINTS
SUBROUTINE  PRINTS  (DIPM2)
  use param
  use charac
  use timdat
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use values
!
  implicit none
!
  INTEGER *4      IVAL(LEM)
  INTEGER *4      IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  CHARACTER *40   FMT1(3), FMT11,FMT12
  EQUIVALENCE     (FMT1(1),FMT11), (FMT1(2),FMT12)
  real   *8       DIPM2
  real   *8       VAL2
  integer *4      N,itemp,J,I
!
  IF (N3BP > 0) THEN
    DO N = 1, N3BP
      IF (AV3BP(2,N) > 0.1) AV3BP(1,N)= AV3BP(1,N)/AV3BP(2,N)
!              WRITE (*,1001)  AV3BP(1,N), AV3BP(2,N)
!              1001  FORMAT (21X,'Average J-I-J angle is ',F6.2,' (',I5,')')
    enddo
  END IF
!     ---------------------------------------------------- Print results
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  IF (MOD(NRECRD(1),20) == 1)  WRITE  (*,2909)  TITLE,IRECRD(1),NRECRD(1)/10000, IHOUR
 2909      FORMAT ('== ',15A4,'(End=',I7,') ==' /  &
                   '+',I3,'0K steps ', 59('-'), ' Hour=',I2 / &
                   ' STEP Temp  Prss.(  Px   Py   Pz ) ', &
                  'U(Coul.) U(srt)  U(3p) E(total) Density mn:sc')
!
!  IF ((KKTIME(5,2) /= IMINUT .OR. KKTIME(6,2) /= ISECND) .OR. IYEAR+IMONTH+IDAY == 0)  THEN
    VAL2 = ABS(VAL(2))
    FMT11 = '(1X,I4,I5,F7.4,1H(,3F5.2,1H),           '
    FMT12 = 'F9.1,F8.1,F6.1,F9.1,F8.5,1H ,I2,1H'',I2)'
    IF (VAL2 > 9.0 .AND. VAL2 < 95.0)  THEN
      FMT11 = '(1X,I4,I5,F7.3,1H(,3F5.1,1H),           '
    ELSE IF (VAL2 >= 95.0) THEN
      FMT11 = '(1X,I4,I5,F7.2,1H(,3F5.0,1H),           '
    END IF
    IF (ABS(VAL(9)) < 1.0D4.AND.ABS(VAL(14)) < 1.0D4)  THEN
      FMT12 = 'F9.2,F8.2,F6.2,F9.2,F8.5,1H ,I2,1H'',I2)'
    END IF
    IF (ABS(VAL(9)) < 1.0D3.AND.ABS(VAL(14)) < 1.0D3)  THEN
      FMT12 = 'F9.3,F8.3,F6.3,F9.3,F8.5,1H ,I2,1H'',I2)'
    END IF
    ITEMP = VAL(1)
    WRITE (*,FMT1) MOD(NRECRD(1),10000),ITEMP,VAL(2),VAL(3),  &
                            VAL(4),VAL(5),VAL(9),VAL(10),VAL(11),  &
                            VAL(14),VAL(17),IMINUT,ISECND
    KKTIME(1,2) = IYEAR
    KKTIME(2,2) = IMONTH
    KKTIME(3,2) = IDAY
    KKTIME(4,2) = IHOUR
    KKTIME(5,2) = IMINUT
    KKTIME(6,2) = ISECND
    KKTIME(7,2) = I100TH
!  END IF
  IF (RUNOPT(14) == 'DIPOLE    ')  WRITE (*,9917)  DIPM2,VAL(14)+DIPM2
 9917       FORMAT (10X,7X,15X,'Dipole:',4X,F8.3,5X,F9.2)
!
! ----------------------------------------------------- M.s.d., etc.
  IF (MOD(NRECRD(1),5) == 0)  THEN
!    IF (ABS(ECORR*FJMOL) > 1.0E-10)  THEN
!                WRITE (*,2880)  VCORR / (3.0D0*VOL*1.0D-24)*1.0D-10,
!    *                           ECORR*FJMOL
!2880            FORMAT (9X, F8.4,' GPa(Pcorr)',9X,
!    *                       'Ecorr=',F8.3,' kJ/mol')
!    END IF
    IF (RUNOPT(17) == 'AMORPHOUS ') THEN
      IF (AV3BP(2,1) < 0.1)  WRITE (*,2901) (VAL(J+24+LEM), ATOM(J),J=1,5)
      IF (AV3BP(2,1) > 0.1)  WRITE (*,2901) (VAL(J+24+LEM), ATOM(J),J=1,5),AV3BP(1,1),INT(AV3BP(2,1))
2901             FORMAT (6X,'Msd:',5(F8.3,'(',A1,')'),F8.1,'(',I8,')')
    END IF
    IF (RUNOPT(17) == 'CRYSTAL   ') THEN
      IF (AV3BP(2,1) < 0.1) WRITE (*,2902) (VAL(J+24+LEM),ATOM(J),J=1,5), VAL(19),VAL(20), VAL(21)
      IF (AV3BP(2,1) > 0.1) WRITE (*,2902) (VAL(J+24+LEM),ATOM(J),J=1,5), VAL(19),VAL(20),VAL(21), &
                                            AV3BP(1,1),INT(AV3BP(2,1))
2902 FORMAT (1X,'Msd:',5(F6.3,':',A1),1X,3F7.3, F6.1,':',I5)
    END IF
  END IF
  IF (RUNOPT(3) == 'DETAIL    ')                 GO TO 670
  IF (RUNOPT(3) == 'ECONOMY   ')                 GO TO 690
  IF (MOD(NRECRD(1),5) /= 0.AND.NRECRD(3) /= 1)  GO TO 690
670  DO I = 1, LEM
    IVAL(I) = INT(VAL(I+24))
  enddo
  VAL2 = ABS(VAL(2))
  FMT11 = '(1X,I5,5I5,F8.4,1H(,6F6.3,1H),     '
  FMT12 = ' F10.2,F9.2,2F7.2,F10.3,    F9.5 ) '
  IF (VAL2 > 9.0 .AND. VAL2 < 95.0) THEN
    FMT11 = '(1X,I5,5I5,F8.3,1H(,6F6.3,1H),     '
  ELSE IF (VAL2 >= 95.0) THEN
    FMT11 = '(1X,I5,5I5,F8.2,1H(,6F6.2,1H),     '
  END IF
  IF (ABS(VAL(9)) < 1.0D4.AND.ABS(VAL(14)) < 1.0D4) THEN
    FMT12 = ' F10.3,F9.3,2F7.3,F10.4,   F9.5 )  '
  END IF
  WRITE (16,FMT1)  mod(NRECRD(1),100000), (IVAL(I),I=1,4),  &
                            INT(VAL(1)), (VAL(J),J= 2,11), VAL(13),  &
                            VAL(14),VAL(17)
!
690 IF (MOD(NRECRD(1),25) == 0)  THEN
      IF (RUNOPT(3) /= 'ECONOMY   ')  WRITE (16,2900) (VAL(J),J=35,LVA)
2900         FORMAT (7X,5F8.3  / 7x,5F8.3 )
    END IF
RETURN
END
!
!
!                                                       ================
!=======================================================Center_of_DIATOM
SUBROUTINE  Center_of_Diatomic_Molecule
  use param
  use charac
  use aboxof
  use atomsi
  use forces
  use cartes
  use molecu
  use charge
  use pos
!
  implicit none
!
!     =======================================recognize diatomic molecule
!
  real *8  pix,piy,piz, pjx,pjy,pjz, rx,ry,rz, dx,dy,dz
  real *8  cut2,pjx0,pjy0,pjz0, rij2
  integer *4 im,i,j,k,nnn
!
! ---------------------------------------------calc distance of atoms
  cut2 = dintra**2
  do im = 1, ndmole
    i=idmole(1,im)
    j=idmole(2,im)
    pix = p(1,i)
    piy = p(2,i)
    piz = p(3,i)
    pjx0 = p(1,j)
    pjy0 = p(2,j)
    pjz0 = p(3,j)
    if (pjx0 < pix)  pjx0 = pjx0 + 1.0
    if (pjy0 < piy)  pjy0 = pjy0 + 1.0
    if (pjz0 < piz)  pjz0 = pjz0 + 1.0
    DO K = 1, 8
      pjx = pjx0 - transx(k)
      pjy = pjy0 - transy(k)
      pjz = pjz0 - transz(k)
      RX = PIX - PjX
      RY = PIY - PjY
      RZ = PIZ - PjZ
!T                         - - - - - delete these if-statements for triclinic
!T                       IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!T                       IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!T                       IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!T                         DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                         DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                         DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
      DX = RX * BOX(1)
      DY = RY * BOX(2)
      DZ = RZ * BOX(3)
      RIJ2 = DX*DX + DY*DY + DZ*DZ
      if (rij2 < cut2)  go to 255
    enddo
    cycle
!   -----------------------------------P of center of mass
255 Pix=(Pix+Pjx)/2.
    Piy=(Piy+Pjy)/2.
    Piz=(Piz+Pjz)/2.
    if (pix < 0.0)   pix = pix + 1.0
    if (pix > 1.0)   pix = pix - 1.0
    if (piy < 0.0)   piy = piy + 1.0
    if (piy > 1.0)   piy = piy - 1.0
    if (piz < 0.0)   piz = piz + 1.0
    if (piz > 1.0)   piz = piz - 1.0
    nnn = ntion+im
    p(1,nnn) = pix
    p(2,nnn) = piy
    p(3,nnn) = piz
    UI(nnn) = 0.0
    FX(nnn) = 0.0D0
    FY(nnn) = 0.0D0
    FZ(nnn) = 0.0D0
    PX(nnn)  = P(1,nnn)
    PY(nnn)  = P(2,nnn)
    PZ(nnn)  = P(3,nnn)
    ZII(nnn) = Zmole(idmole(3,im))
    DMOLE(1,IM) = DX
    DMOLE(2,IM) = Dy
    DMOLE(3,IM) = DZ
    DMOLE(4,IM) = SQRT(RIJ2)
!               write(*,*) nnn,DMOLE(1,IM),DMOLE(2,IM),DMOLE(3,IM),DMOLE(4,IM)
  enddo
RETURN
END
!
!                                                                =======
!================================================================ EWALDS
SUBROUTINE  EWALDS
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use radial
  use cartes
  use molecu
  use pmorse
  use quanco
  use datoms
  use charge
  use pos
  use ewal
!
!  use, intrinsic :: iso_c_binding  ! SPME
!
  implicit none
!
!  include 'fftw3.f03'  !SPME
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
  integer *4, parameter :: maxat= 6000
  INTEGER *4  IRDF(LTB),IOSEQ(LEL)
  REAL    *8  E2(LSR),F2(LSR)
  REAL    *8  PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  REAL    *8  PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ,FSIJ
  REAL    *8  PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,UII,EIJ,ESIJ
  REAL    *8  VAL03, VAL04, VAL05, VAL06, VAL07, VAL08, VAL09
  REAL    *8  VAL03C,VAL04C,VAL05C,VAL06C,VAL07C,VAL08C,VAL10
  REAL    *8  RIJ, RIJ2, RCUT2, SCCSS, R3LIM, R3LIM2, zizj
  REAL    *8  Q1U2(LSR),Q2U2(LSR),QCEIJ,ANWIO,ANWJO,QS1,QS2
  real    *8  pjx0,pjy0,pjz0,RIJ3
  real    *8  sdx(maxat),sdy(maxat),sdz(maxat), srij2(maxat)
  real    *8  UIIC           !WATER-POL
  real    *8  Xmyui, Ymyui, Zmyui, COFWAT  !Water-pol
  real    *8  Mz,Mx,My
  integer *4  isj(maxat),lp1,lp2
  integer *4  io,n,i,in,i1,i2,max_nsatom,k,j1,j2,nsatom,kk3bp
  integer *4  j,jj,ip0,ip1,ip2,L,NNCOMPO,kk,m,mm,IOO,no,jo,JJO,IIO
  real    *8  ASP,ACOR,r3lim11,r3lim21
  real    *8  EIJC, ECDD, FCDD, ARIJ2,ARIJ3,ARIJ4, ARIJ
  integer *4  J3,III
!  real    *8  DFXCU1,DFYCU1,DFZCU1,ZIIUP(LNI)
!  real    *8  UDFX,UDFY,UDFZ,FFIX,FFIY,FFIZ,UZI
!
!P    REAL  *8  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    REAL  *8  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3   /
!P   *                      10.00464, 8.426553, 3.460259, .5623536     /
!P    DATA EY0,EY1,EY2,EY3,EY4/
!P   *                      10.00464, 19.71558, 15.70229, 6.090749, 1.0/
!
!     ----------------------- Put the central atom of 3-body interaction
!                              at the last of atom species, to calculate
!                                                  3-body terms properly
!
  NNCOMPO = NCOMPO
!
  IF(runopt(34) == 'WATER-POL ') then
    NNCOMPO = NCOMPO + 1
!    DO I = 1, ntion+ndmole
!      if (i >= ions(1,iatomo) .and. i <= ions(2,iatomo)) cycle
!      ZIIUP(I) = ZII(I) - ZIIP(I)
!    enddo
!    DFXCU1 = 0.0D0
!    DFYCU1 = 0.0D0
!    DFZCU1 = 0.0D0
  ENDIF
!
  DO IO = 1, NNCOMPO
    IOSEQ(IO) = IO
  enddo
  IF (N3BP > 0)  THEN
    DO N = 1, N3BP
      IOSEQ(NNCOMPO-N+1) = I3BP(N)
    enddo
    N = 0
    DO 30  IO = 1, NNCOMPO
      DO I = 1, N3BP
        IF (IO == I3BP(I))  GO TO 30
      enddo
      N = N + 1
      IOSEQ(N) = IO
30  enddo
  END IF
  N = 0
! For water-pol : IOSEQ(1) = 2, IOSEQ(2) = 3, IOSEQ(3) = 1
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  VAL09 = 0.0D0
  VAL10 = 0.0D0
!
  VAL03C = 0.0D0
  VAL04C = 0.0D0
  VAL05C = 0.0D0
  VAL06C = 0.0D0
  VAL07C = 0.0D0
  VAL08C = 0.0D0
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
  if(runopt(35) /= 'ISOLATED  ') then
! ------------------------------------------ Coulomb reciprocal term
!
!  ----------------------------------------- Standard Ewald method
  if(runopt(45) /= 'SPME      ') then
!
  IF (NVN == 0)  GO TO 200
!
    DO I = 1, NTION + ndmole
      ZICOS(I) = 0.0D0
      ZISIN(I) = 0.0D0
    enddo
!
    DO IN = 1, NVN
      SICOS = 0.0D0
      SISIN = 0.0D0
      DX = DBLE(NVEC(1,IN)) * PI2
      DY = DBLE(NVEC(2,IN)) * PI2
      DZ = DBLE(NVEC(3,IN)) * PI2
      DO IO = 1, NNCOMPO
        IF (IION(IO) < -998) cycle
        IF (NION(IO) > 0) THEN
          DO I = ions(1,IO), ions(2,io)
            PHI     = DX*PX(I) + DY*PY(I) + DZ*PZ(I)
            ZICOS(I) = COS(PHI) * ZII(I)                !WATER-POL
            SICOS    = SICOS + ZICOS(I)
            ZISIN(I) = SIN(PHI) * ZII(I)                !WATER-POL
            SISIN    = SISIN + ZISIN(I)
          enddo
        END IF
      enddo
      if (runopt(23) == 'DIATOMIC  ') then
        DO I = ntion+1, ntion+ndmole
          PHI      = DX*PX(I) + DY*PY(I) + DZ*PZ(I)
          ZICOS(I) = COS(PHI) * Zii(i)
          SICOS    = SICOS + ZICOS(I)
          ZISIN(I) = SIN(PHI) * Zii(i)
          SISIN    = SISIN + ZISIN(I)
        enddo
      end if
!
      FSICOS = FNV(IN) * SICOS
      FSISIN = FNV(IN) * SISIN
      USICOS = UNV(IN) * SICOS
      USISIN = UNV(IN) * SISIN
      SCCSS  = SICOS**2 + SISIN**2
!
      VAL09  = VAL09  + UNV(IN)   * SCCSS
      VAL03C = VAL03C + PNV(1,IN) * SCCSS
      VAL04C = VAL04C + PNV(2,IN) * SCCSS
      VAL05C = VAL05C + PNV(3,IN) * SCCSS
      VAL06C = VAL06C + PNV(4,IN) * SCCSS
      VAL07C = VAL07C + PNV(5,IN) * SCCSS
      VAL08C = VAL08C + PNV(6,IN) * SCCSS
      FIX    = DBLE(NVEC(1,IN)) * RBOX(1)
      FIY    = DBLE(NVEC(2,IN)) * RBOX(2)
      FIZ    = DBLE(NVEC(3,IN)) * RBOX(3)
      DO I = 1, NTION + ndmole
        UI(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UI(I)
        UIC(I) = UI(I)                                       !WATER-POL
        FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
        FX(I) = FX(I) + FIJ * FIX
        FY(I) = FY(I) + FIJ * FIY
        FZ(I) = FZ(I) + FIJ * FIZ
      enddo
    enddo
!
!write(*,*)'VAL03C',VAL03C
!do i=1,ntion
!write(*,*)'FX',FX(I)
!write(*,*)'FY',FY(I)
!write(*,*)'FZ',FZ(I)
!read(*,*)
!enddo
    VAL09 = VAL09 * 0.5D0
!
200 CONTINUE
  endif
!  write(*,*)"VAL09= ",VAL09
!
!write(*,*)'UIC(NTION)',UIC(NTION)
!read(*,*)
!
!
!    =======================================Ewald correction for slab geometry
     IF(RUNOPT(33)  ==  'EWALD-C   ') then
       Mz = 0.0d0
       if (iaxis == 3) then
         do I = 1, NTION + ndmole
           Mz = Mz + PZ(I)*ZII(I)
         enddo
         Mz = Mz * BOX(3)
         val09 = val09 + 2.0d0*PI*(Mz*ELC*1.0d-8)**2/(VOL*1.d-24)
         do I = 1, NTION+ndmole
           FZ(I) = FZ(I) -4.0d0*PI*ZII(I)*Mz*ELC**2*1.0d-8/(VOL*1.d-24)
         enddo
!
       elseif (iaxis == 2) then
         do I = 1, NTION + ndmole
           My = My + PY(I)*ZII(I)
         enddo
         My = My * BOX(2)
         val09 = val09 + 2.0d0*PI*(My*ELC*1.0d-8)**2/(VOL*1.d-24)
         do I = 1, NTION+ndmole
           FY(I) = FY(I) -4.0d0*PI*ZII(I)*My*ELC**2*1.0d-8/(VOL*1.d-24)
         enddo
!
       elseif (iaxis == 1) then
         do I = 1, NTION + ndmole
           Mx = Mx + PX(I)*ZII(I)
         enddo
         Mx = Mx * BOX(1)
         val09 = val09 + 2.0d0*PI*(Mx*ELC*1.0d-8)**2/(VOL*1.d-24)
         do I = 1, NTION + ndmole
           FX(I) = FX(I) -4.0d0*PI*ZII(I)*Mx*ELC**2*1.0d-8/(VOL*1.d-24)
         enddo
       endif
     ENDIF
  endif
! ======================================================================
!
! --------------- Coulomb direct lattice space and short range terms
!
  RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!P          BETA  = CAL * 1.0D10 / ANA
  max_nsatom = 0
  IN = 0
  DO IIO = 1, NNCOMPO
    DO JJO = 1, IIO
      IO = IOSEQ(IIO)
      JO = IOSEQ(JJO)
      IN = IO*(IO-1)/2 + JO
      IF (IO < JO)  IN = JO*(JO-1)/2 + IO
      IF (IION(IO) <= -998 .OR.  IION(JO) <= -998)  cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0) cycle
      IF (IO == JO         .AND. NION(IO) <= 1)  cycle
!      KK3BP = 0
!      IF (N3BP > 0)  THEN
!        DO N = 1, N3BP
!          IF (IO == I3BP(N).AND.JO == J3BP(N).and.JO == K3BP(N)) KK3BP = N
!        enddo
!!       --------------------------------------- For 3-body term
!        IF (KK3BP /= 0)  THEN
!          R3LIM =DLOG(0.999999D0/1.0D-6)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
!          IF (runopt(34) == 'WATER-POL ') then
!            R3LIM = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
!          endif
!          if (runopt(8) == 'BMH-EXP*  ') then
!            R3LIM =DLOG(0.9999D0/0.0001D0)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
!          end if
!          R3LIM2 = R3LIM**2
!!                      write (*,*)  'r3lim=',r3lim,r3lim1
!        END IF
!      END IF
      DO K = 1, NRCUT(2)
        E2(K) = E1(K,IN)
        F2(K) = F1(K,IN)
      enddo
      IF (RUNOPT(12) == 'QUANTUM   ')  THEN
        DO K = 1, NRCUT(2)
          Q1U2(K) = Q1U1(K,IN)
          Q2U2(K) = Q2U1(K,IN)
        enddo
        QCEIJ = 0.0D0
      END IF
      DO K = 1, NRCUT(1)+1
        IRDF(K) = 0
      enddo
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
      DO I = I1, I2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
!T            IF (PIX >= 0.5D0)  PIX = PIX - 1.0D0
!T            IF (PIY >= 0.5D0)  PIY = PIY - 1.0D0
!T            IF (PIZ >= 0.5D0)  PIZ = PIZ - 1.0D0
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0D0   !WATER-POL
        N1ATOM = 0
        nsatom = 0
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
!T                DO 250  K = 1, 8
!T                    RX = PIX - PX(J) + TRANSX(K)
!T                    RY = PIY - PY(J) + TRANSY(K)
!T                    RZ = PIZ - PZ(J) + TRANSZ(K)
          RX = PIX - PX(J)
          RY = PIY - PY(J)
          RZ = PIZ - PZ(J)
!T                    - - - - - delete these if-statements for triclinic
          if (runopt(35) /= 'ISOLATED  ') then
            IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
            IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
            IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
!T                      DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                      DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                      DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          endif
          DX   = RX * BOX(1)
          DY   = RY * BOX(2)
          DZ   = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          if (runopt(35) /= 'ISOLATED  ') then
            IF (RIJ2 <= RCUT2)  then
              nsatom = nsatom + 1
              isj(nsatom)   = j
              sDX(nsatom)   = dx
              sDY(nsatom)   = dy
              sDZ(nsatom)   = dz
              sRIJ2(nsatom) = rij2
            end if
          else if (runopt(35) == 'ISOLATED  ') then
            nsatom = nsatom + 1
            isj(nsatom)   = j
            sDX(nsatom)   = dx
            sDY(nsatom)   = dy
            sDZ(nsatom)   = dz
            sRIJ2(nsatom) = rij2
          endif
!T 250             CONTINUE
        enddo
!
        if (max_nsatom < nsatom)  max_nsatom = nsatom
!
        do jj = 1, nsatom
          j    = isj(jj)
          dx   = sDX(jj)
          dy   = sDY(jj)
          dz   = sDZ(jj)
          rij2 = srij2(jj)
          RIJ  = DSQRT(RIJ2)
          RIJ3 = RIJ**3
          ARIJ = 1.0D0 / RIJ
          ZIZJ = ZII(i)*ZII(j)         !WATER-POL
!         ----------------------------------- Interpolation
          IP0 = INT(RIJ*100.0D0)
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = dble(IP0) * 0.01D0
          R01 = dble(IP1) * 0.01D0
          R02 = dble(IP2) * 0.01D0
!                     X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                     X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                     X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
          X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
          X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
          if (runopt(35) /= 'ISOLATED  ') then
            FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
!            FIJC = FIJ
            EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
            EIJC = EIJ              !WATER-POL
!E                  ------------------------ For precise calculations
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) *
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                    EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                    FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                    -------------------------------------------------
          elseif (runopt(35) == 'ISOLATED  ') then
!            FIJ = ELCC**2*ZIZJ/RIJ**3*1.0D25/(4.0d0*PI*EP0)   !dyn
            FIJ = EPOLLL*ZIZJ/RIJ3   ! dyn
!            FIJC = FIJ
            EIJ = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0d0*PI*EP0)  !erg
            EIJC = EIJ
          endif
          VAL09 = VAL09 + EIJ
!         ========= End of Coulomb interaction==============================================
!
!         --------- Charge-dipole and dipole-induced dipole
          IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
            ARIJ2 = ARIJ  * ARIJ
            ARIJ3 = ARIJ2 * ARIJ
            ARIJ4 = ARIJ3 * ARIJ
            ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
            FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                   7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
            EIJ   = EIJ + ECDD
            FIJ   = FIJ + FCDD
            VAL10 = VAL10 + ECDD
            VIRLSR = VIRLSR + FCDD*RIJ2
          END IF
!
!                   ------------------------------ Short range forces
          esij = 0.0D0
          fsij = 0.0D0
          IF (RIJ <= RCUT(2))  THEN
!             ---------------------------- Interpolation
            FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
            ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!S                           ----------------- For precise calculations
!S                           EX = EXP((AIJ(IN) - RIJ) / BIJ(IN))
!S                           CA = CIJ(IN)*ARIJ**6
!S                           ESIJ = BETA* (BIJ(IN)*EX - CA)
!S                           FSIJ = BETA* (EX - 6.0D0*CA*ARIJ)
!S                           IF (DMIJ(IN) > 0.001)  THEN
!S                                AM1= EXP(-2.0D0*BEIJN*(RIJ-RSIJ(IN)))
!S                                AM2= EXP(-1.0D0*BEIJN*(RIJ-RSIJ(IN)))
!S                                ESIJ= ESIJ+DMIJN*(AM1-2.0D0*AM2)
!S                                FSIJ= FSIJ+BEIJN*DMIJN*2.0D0*(AM1-AM2)
!S                           END IF
!S                           FSIJ  = FSIJ*1.0D8 * ARIJ
!                            ------------------------------------------
            FIJ  = FIJ + FSIJ
            EIJ  = EIJ + ESIJ
            VAL10  = VAL10  + ESIJ
            VIRLSR = VIRLSR + FSIJ*RIJ2
!           ------------------------------------------
            N1ATOM  = N1ATOM  + 1
            I1ATOM(N1ATOM)   = J
            D1ATOM(N1ATOM)   = RIJ
            D1AXYZ(1,N1ATOM) = DX
            D1AXYZ(2,N1ATOM) = DY
            D1AXYZ(3,N1ATOM) = DZ
          END IF
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJC   !WATER-POL
          UI(J) = UI(J) + EIJ
          UIC(J) = UIC(J) + EIJC  !WATER-POL
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VAL03 = VAL03 + DFX * DX
          VAL04 = VAL04 + DFY * DY
          VAL05 = VAL05 + DFZ * DZ
          VAL06 = VAL06 + DFX * DY
          VAL07 = VAL07 + DFX * DZ
          VAL08 = VAL08 + DFY * DZ
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
        UIC(I) = UIC(I) + UIIC   !WATER-POL
        do jj = 1, nsatom
          IP0 = INT(sqrt(sRIJ2(jj))*100.0d0)
          IRDF(IP0) = IRDF(IP0) + 1
        enddo
!       ---------------------------------- Quantum correction term
        IF (RUNOPT(12) == 'QUANTUM   ')  THEN
          DO J = 1, N1ATOM
            RIJ = D1ATOM(J)
            IP0 = INT(RIJ*100.0)
            IP1 = IP0 + 1
            IP2 = IP0 + 2
            R00 = IP0 * 0.01
            R01 = IP1 * 0.01
            R02 = IP2 * 0.01
!                      X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                      X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                      X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
            X0  = (RIJ-R01)*(RIJ-R02) *    5000.0
            X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0)
            X2  = (RIJ-R00)*(RIJ-R01) *    5000.0
            QS1 = Q1U2(IP0)*X0 +Q1U2(IP1)*X1 +Q1U2(IP2)*X2
            QS2 = Q2U2(IP0)*X0 +Q2U2(IP1)*X1 +Q2U2(IP2)*X2
!
!Q                       ARIJ = 1.0D0 / RIJ
!                        ------------ Short range rep. and van der Waals
!Q                       QS1 = -EXP((AIJ(IN) - RIJ) / BIJ(IN)) * 1.0E8
!Q                       QS2 = -QS1 / BIJ(IN) * 1.0E8
!                        --------------------------------- Van der Waals
!Q                       QVW =       6.0 * CIJ(IN) * ARIJ**7 * 1.0E8
!Q                       QS1 = QS1 + QVW
!Q                       QS2 = QS2 - 7.0 * QVW     * ARIJ    * 1.0E8
!                        ------------------------------------ Morse term
!Q                       QMS1 = 0.0
!Q                       QMS2 = 0.0
!Q                       IF (DMIJ(IN) > 0.001) THEN
!Q                             D2  = DMIJ(IN) * 2.0D0
!Q                             AM1 = EXP(-2.0D0*BEIJN*(RIJ-RSIJ(IN)))
!Q                             AM2 = EXP(-1.0D0*BEIJN*(RIJ-RSIJ(IN)))
!Q                             QMS1= D2*BEIJN    * (   -AM1+AM2) *1.0E8
!Q                             QMS2= D2*BEIJN**2 * (2.0*AM1-AM2) *1.0E16
!Q                       END IF
!Q                       QS1 = (QS1 + QMS1) *BETA *ARIJ*1.0E8
!Q                       QS2 = (QS2 + QMS2) *BETA
!
            QCEIJ = QCEIJ + ( 2.0*QS1 + QS2 )
          enddo
        END IF
!
!       --------------------------------------- For 3-body term
        KK3BP = 0
        IF (N3BP > 0)  THEN
          DO N = 1, N3BP
            IF (IO == I3BP(N).AND.JO == J3BP(N).and.JO == K3BP(N)) THEN
!       ----------------------------------- 3-body potential B-A-B
              KK3BP = N
!
              R3LIM =DLOG(0.999999D0/1.0D-6)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
              IF (runopt(34) == 'WATER-POL ') then
                R3LIM = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
              endif
              if (runopt(8) == 'BMH-EXP*  ') then
                R3LIM =DLOG(0.9999D0/0.0001D0)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
              end if
              R3LIM2 = R3LIM**2
!!                      write (*,*)  'r3lim=',r3lim,r3lim1
              IF (RUNOPT(8) == 'BMH-EXP*  ') THEN
                    CALL  THREEP2 (I, KK3BP, R3LIM)
              ELSEIF (RUNOPT(8) == 'VASHISHTA ') THEN 
                    CALL  THREER3 (I, KK3BP)
              ELSE 
                    CALL  THREER  (I, KK3BP, R3LIM)
              ENDIF
            ENDIF
          ENDDO
        ENDIF
        if (n3BP > 0)  then
          DO N = 1, N3BP
            IF (IO == I3BP(N) .AND. JO == J3BP(n) .and. J3BP(N) /= K3BP(N)) then
!             ------------------------------------- B-A-C
              R3LIM11  = DLOG(0.999999D0/1.0D-6) /R3BGRD(1,n) + R3BLIM(1,n)
              R3LIM21  = DLOG(0.999999D0/1.0D-6) /R3BGRD(2,n) + R3BLIM(2,n)
!              IF (RUNOPT(8) /= 'BMH-EXP*  ') CALL  THREER  (I, N, R3LIM11,R3LIM21)
              if (RUNOPT(8) == 'BMH-EXP*  ') then
                      call  threeq2 (I, N, R3LIM11,R3LIM21)
              else
                      call  threeq  (I, N, R3LIM11,R3LIM21)
              endif
            endif
          enddo
        end if
      enddo
!
      IF (RUNOPT(12) == 'QUANTUM   ') THEN
        ANWIO = ANA / WIO(IO)
        ANWJO = ANA / WIO(JO)
!                ------------------------------------ QCEij : nabla(Uij)
!                                            TQCE : sum of nabla(Uij)/mi
          TQCE   = TQCE   + QCEIJ*ANWIO + QCEIJ*ANWJO
      END IF
      IF (RUNOPT(34) ==  'WATER-POL ') then
        IF (MOD(NRECRD(1),IRECRD(5)) == 0 .and. KRDF == 1) THEN
          DO L = 1, NRCUT(1)
            NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
          enddo
        ENDIF
      ENDIF
      IF (RUNOPT(34) /=  'WATER-POL ') then
        IF (MOD(NRECRD(1),IRECRD(5)) == 0 ) THEN
          DO L = 1, NRCUT(1)
            NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
          enddo
        ENDIF
      ENDIF
    enddo
  enddo
!
  IF(N3BP > 0) then
    DO N= 1, N3BP
      DO IIO = 1, NNCOMPO
        DO JJO = 1, IIO
          IO = IOSEQ(IIO)
          JO = IOSEQ(JJO)
          IF (JO == I3BP(N) .AND. IO == J3BP(N) &
               .AND. IO == K3BP(N) .AND. IO>JO) then
!         ----------------------------------------------A-B-A
            KK3BP=N
            DO J3 = IONS(1,JO), IONS(2,JO)
              PIX = PX(J3)
              PIY = PY(J3)
              PIZ = PZ(J3)
!T                  IF (PIX >= 0.5D0)  PIX = PIX - 1.0D0
!T                  IF (PIY >= 0.5D0)  PIY = PIY - 1.0D0
!T                  IF (PIZ >= 0.5D0)  PIZ = PIZ - 1.0D0
              N1ATOM = 0
              nsatom = 0
              DO III = IONS(1,IO),IONS(2,IO)
!T                      DO 250  K = 1, 8
!T                          RX = PIX - PX(J) + TRANSX(K)
!T                          RY = PIY - PY(J) + TRANSY(K)
!T                          RZ = PIZ - PZ(J) + TRANSZ(K)
                RX = PIX - PX(III)
                RY = PIY - PY(III)
                RZ = PIZ - PZ(III)
!T                          - - - - - delete these if-statements for triclinic
                if (runopt(35) /= 'ISOLATED  ') then
                  IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
                  IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
                  IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
!T                            DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                            DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                            DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
                endif
                DX   = RX * BOX(1)
                DY   = RY * BOX(2)
                DZ   = RZ * BOX(3)
                RIJ2 = DX*DX + DY*DY + DZ*DZ
                IF (RIJ2 <= RCUT2)  then
                    nsatom = nsatom + 1
                    isj(nsatom)   = III 
                    sDX(nsatom)   = dx
                    sDY(nsatom)   = dy
                    sDZ(nsatom)   = dz
                    sRIJ2(nsatom) = rij2
                end if
              enddo
!
              if (max_nsatom < nsatom)  max_nsatom = nsatom
!
              do jj = 1, nsatom
                j    = isj(jj)
                dx   = sDX(jj)
                dy   = sDY(jj)
                dz   = sDZ(jj)
                rij2 = srij2(jj)
                RIJ  = DSQRT(RIJ2)
                RIJ3 = RIJ**3
                ARIJ = 1.0D0 / RIJ
                IF (RIJ <= RCUT(2))  THEN
!                 ------------------------------------------
                  N1ATOM  = N1ATOM  + 1
                  I1ATOM(N1ATOM)   = J
                  D1ATOM(N1ATOM)   = RIJ
                  D1AXYZ(1,N1ATOM) = DX
                  D1AXYZ(2,N1ATOM) = DY
                  D1AXYZ(3,N1ATOM) = DZ
                END IF
              enddo
!
              R3LIM =DLOG(0.999999D0/1.0D-6)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
              IF (runopt(34) == 'WATER-POL ') then
                R3LIM = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
              endif
              if (runopt(8) == 'BMH-EXP*  ') then
                R3LIM =DLOG(0.9999D0/0.0001D0)/R3BGRD(1,KK3BP) + R3BLIM(1,KK3BP)
              end if
              R3LIM2 = R3LIM**2
!!                      write (*,*)  'r3lim=',r3lim,r3lim1
              IF (RUNOPT(8) == 'BMH-EXP*  ') THEN
                    CALL  THREEP2 (J3, KK3BP, R3LIM)
              ELSEIF (RUNOPT(8) == 'VASHISHTA ') THEN 
                    CALL  THREER3 (J3, KK3BP)
              ELSE 
                    CALL  THREER  (J3, KK3BP, R3LIM)
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDDO
    ENDDO
  ENDIF
!
  if (max_nsatom > 1000)  write (6,*) 'Max(nsatom)=',max_nsatom
!   ------------------ Calculation of Coulomb of three point charges for 'DIATOMIC'
  if (runopt(23) == 'DIATOMIC  ')  then
    do L = 1, 2    
      i1 = ntion + 1
      i2 = ntion + ndmole
      if (L  ==  2)  i1 = ntion + 2
      DO I = i1, i2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        j1 = 1
        j2 = ntion
        IF (L == 2)  THEN
          J1 = NTION + 1
          j2 = I-1
        END IF
        DO J = j1, j2
          ZIZJ = ZII(I) * ZII(J)
!P              ZIJE2 = ZIO(IO) * ZIO(JO) * ELC**2
          pjx0 = p(1,j)
          pjy0 = p(2,j)
          pjz0 = p(3,j)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0d0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0d0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0d0
          DO K = 1, 8
!            pjx = pjx0 - transx(k)
!            pjy = pjy0 - transy(k)
!            pjz = pjz0 - transz(k)
            RX = PIX - PX(J)
            RY = PIY - PY(J)
            RZ = PIZ - PZ(J)
!T                         - - - - - delete these if-statements for triclinic

            if (runopt(35) /= 'ISOLATED  ') then
              IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)
              IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)
              IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)
            endif
!T                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  GO TO 357
          enddo
          cycle
!
357       RIJ = DSQRT(RIJ2)
          IP0 = INT(RIJ*100.0D0)
!         ---------------------------------- Interpolation
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = dble(IP0) * 0.01D0
          R01 = dble(IP1) * 0.01D0
          R02 = dble(IP2) * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0D0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0D0
          FIJ  = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ  = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) *
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
          VAL09 = VAL09 + EIJ
          UII   = UII   + EIJ
          UI(J) = UI(J) + EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VAL03 = VAL03 + DFX * DX
          VAL04 = VAL04 + DFY * DY
          VAL05 = VAL05 + DFZ * DZ
          VAL06 = VAL06 + DFX * DY
          VAL07 = VAL07 + DFX * DZ
          VAL08 = VAL08 + DFY * DZ
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
      enddo
    enddo
  end if
  if (RUNOPT(34) == 'WATER-POL ' .or. RUNOPT(34) == 'WATER-POL*') then ! Remove intramolecular Coulomb
    no = 0
    do io = IONS(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      do k = 2, 4
        kk = ih2o(k,no)
        PIX = PX(kk)
        PIY = PY(kk)
        PIZ = PZ(kk)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0d0
        DO m = k+1, 5
          mm = ih2o(m,no)
          RX = PIX - PX(mm)
          RY = PIY - PY(mm)
          RZ = PIZ - PZ(mm)
          if (runopt(35) /= 'ISOLATED  ') then
            IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
            IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
            IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
          endif
          DX   = RX * BOX(1)
          DY   = RY * BOX(2)
          DZ   = RZ * BOX(3)
          RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
          if (RIJ < 0.1D0) stop 'Too short distance !!!'
          if (RIJ > 3.0D0) stop 'Too long distance!!!'
          RIJ3 = RIJ**3  !angstrom
          ZIZJ  = ZII(mm)*ZII(kk)
!          EIJ  = ELC**2*ZIZJ/RIJ*1.0D8     !erg cgs-esu
          EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
          VAL09 = VAL09 - EIJ
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJ
          UI(mm) = UI(mm) - EIJ
          UIC(mm) = UIC(mm) - EIJ
!          FIJ   = ELC**2*ZIZJ/RIJ3*1.0D16
!          FIJ   = ELCC**2*ZIZJ/RIJ3*1.0D25/(4.0D0*PI*EP0) ! dyn
          FIJ  = EPOLLL*ZIZJ/RIJ3   !dyn
          DFX  = FIJ*DX
          DFY  = FIJ*DY
          DFZ  = FIJ*DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(mm) = FX(mm) + DFX  ! cgs-esu
          FY(mm) = FY(mm) + DFY  ! cgs-esu
          FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
          VAL03 = VAL03 - DFX * DX
          VAL04 = VAL04 - DFY * DY
          VAL05 = VAL05 - DFZ * DZ
          VAL06 = VAL06 - DFX * DY
          VAL07 = VAL07 - DFX * DZ
          VAL08 = VAL08 - DFY * DZ
        enddo
        FX(kk) = FX(kk) - FIX
        FY(kk) = FY(kk) - FIY
        FZ(kk) = FZ(kk) - FIZ
        UI(kk) = UI(kk) - UII
        UIC(kk) = UIC(kk) - UIIC
      enddo
    enddo

    if (RUNOPT(34) == 'WATER-POL ') then
!   -------------------------------------------------Forces by Upol
      no = 0
      do io = ions(1,IATOMO),ions(2,IATOMO)
        no = no + 1
        k = ih2o(2,no)
        m = ih2o(3,no)
        lp1 = ih2o(4,no)
        lp2 = ih2o(5,no)
        COFWAT = EPOLLL/watpol(1,no)
!       ----------------------------------O-H1 direction
        Xmyui = COFWAT*idipX(2,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(2,no)
        Zmyui = COFWAT*idipZ(2,no)
        DX = DPX1(no)
        DY = DPY1(no)
        DZ = DPZ1(no)
        DFX = -1.0d0 * QHHk(no) * Xmyui
        DFY = -1.0d0 * QHHk(no) * Ymyui
        DFZ = -1.0d0 * QHHk(no) * Zmyui
        FX(k) = FX(k) + DFX
        FY(k) = FY(k) + DFY
        FZ(k) = FZ(k) + DFZ
        FX(lp1) = FX(lp1) - 0.5d0*DFX
        FY(lp1) = FY(lp1) - 0.5d0*DFY
        FZ(lp1) = FZ(lp1) - 0.5d0*DFZ
        FX(lp2) = FX(lp2) - 0.5d0*DFX
        FY(lp2) = FY(lp2) - 0.5d0*DFY
        FZ(lp2) = FZ(lp2) - 0.5d0*DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VAL03 = VAL03 + DFX * DX   !dyn angstrom
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
!       ----------------------------------O-H2 direction
        Xmyui = COFWAT*idipX(3,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(3,no)
        Zmyui = COFWAT*idipZ(3,no)
        DX = DPX2(no)
        DY = DPY2(no)
        DZ = DPZ2(no)
        DFX = -1.0d0 * QHHm(no) * Xmyui
        DFY = -1.0d0 * QHHm(no) * Ymyui
        DFZ = -1.0d0 * QHHm(no) * Zmyui
        FX(m) = FX(m) + DFX
        FY(m) = FY(m) + DFY
        FZ(m) = FZ(m) + DFZ
        FX(lp1) = FX(lp1) - 0.5d0*DFX
        FY(lp1) = FY(lp1) - 0.5d0*DFY
        FZ(lp1) = FZ(lp1) - 0.5d0*DFZ
        FX(lp2) = FX(lp2) - 0.5d0*DFX
        FY(lp2) = FY(lp2) - 0.5d0*DFY
        FZ(lp2) = FZ(lp2) - 0.5d0*DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VAL03 = VAL03 + DFX * DX   !dyn angstrom
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
!       --------------------------------LP2->LP1 direction
        COFWAT = EPOLLL/watpol(2,no)
        Xmyui = COFWAT*idipX(4,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(4,no)
        Zmyui = COFWAT*idipZ(4,no)
        DX = 2.0d0*LOP1X(no)
        DY = 2.0d0*LOP1Y(no)
        DZ = 2.0d0*LOP1Z(no)
        DFX = -1.0d0 * QLP1z(no) * Xmyui
        DFY = -1.0d0 * QLP1z(no) * Ymyui
        DFZ = -1.0d0 * QLP1z(no) * Zmyui
        FX(lp1) = FX(lp1) + DFX
        FY(lp1) = FY(lp1) + DFY
        FZ(lp1) = FZ(lp1) + DFZ
        FX(lp2) = FX(lp2) - DFX
        FY(lp2) = FY(lp2) - DFY
        FZ(lp2) = FZ(lp2) - DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VAL03 = VAL03 + DFX * DX   !dyn angstrom
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
      enddo
    endif
!   -----------------------Remove short range among Lone pairs and inner molecular atoms
    no = 0
    do io = IONS(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      IOO = NNCOMPO
      JO  = NNCOMPO
      EIJ = 0.0D0
      FIJ = 0.0D0
      ECDD = 0.0D0
      FCDD = 0.0D0
      IN = IOO*(IOO-1)/2 + JO
      DO K = 1, NRCUT(2)
        E2(K) = E1(K,IN)
        F2(K) = F1(K,IN)
      enddo
      mm = ih2o(4,no)
      kk = ih2o(5,no)
      RX = PX(kk) - PX(mm)
      RY = PY(kk) - PY(mm)
      RZ = PZ(kk) - PZ(mm)
      if (runopt(35) /= 'ISOLATED  ') then
        IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
        IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
        IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
      endif
      DX   = RX * BOX(1)
      DY   = RY * BOX(2)
      DZ   = RZ * BOX(3)
      RIJ2 = DX*DX + DY*DY + DZ*DZ
      RIJ  = sqrt(RIJ2)  !angstrom
!     ----------------- Charge-dipole and dipole-induced dipole
      IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
        ARIJ2 = ARIJ  * ARIJ
        ARIJ3 = ARIJ2 * ARIJ
        ARIJ4 = ARIJ3 * ARIJ
        ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
        FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                  7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
        EIJ   = EIJ + ECDD
        FIJ   = FIJ + FCDD
        VAL10 = VAL10 - ECDD
        VIRLSR = VIRLSR - FCDD*RIJ2
      END IF
!
!     --------------------------------------- Short range forces
!         ----------------------------------- Interpolation
      IP0 = INT(RIJ*100.0D0)
      IP1 = IP0 + 1
      IP2 = IP0 + 2
      R00 = dble(IP0) * 0.01D0
      R01 = dble(IP1) * 0.01D0
      R02 = dble(IP2) * 0.01D0
!                     X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                     X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                     X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
      X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
      X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
      X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
      FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
      ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!
      FIJ = FIJ + FSIJ
      EIJ = EIJ + ESIJ          
      VAL10  = VAL10  - ESIJ
      VIRLSR = VIRLSR - FSIJ*RIJ2
      UI(mm) = UI(mm) - EIJ
      UI(kk) = UI(kk) - EIJ
      DFX = FIJ * DX
      DFY = FIJ * DY
      DFZ = FIJ * DZ
      FX(mm) = FX(mm) + DFX
      FY(mm) = FY(mm) + DFY
      FZ(mm) = FZ(mm) + DFZ
      FX(kk) = FX(kk) - DFX
      FY(kk) = FY(kk) - DFY
      FZ(kk) = FZ(kk) - DFZ
!
      VAL03 = VAL03 - DFX * DX
      VAL04 = VAL04 - DFY * DY
      VAL05 = VAL05 - DFZ * DZ
      VAL06 = VAL06 - DFX * DY
      VAL07 = VAL07 - DFX * DZ
      VAL08 = VAL08 - DFY * DZ
!
      do m = 1,3
        mm = ih2o(m,no) ! Oxygen, hydrogens
        if (m == 1) JO = IATOMO
        if (m > 1 ) JO = IATOMH
        IOO = NNCOMPO
        IN = IOO*(IOO-1)/2 + JO
        IF (IOO < JO)  IN = JO*(JO-1)/2 + IOO
        DO K = 1, NRCUT(2)
          E2(K) = E1(K,IN)
          F2(K) = F1(K,IN)
        enddo
        do k = 4,5
          FIJ = 0.0D0
          EIJ = 0.0D0
          kk = ih2o(k,no)
          PIX = PX(kk)   ! Lone pair
          PIY = PY(kk)   ! Lone pair
          PIZ = PZ(kk)   ! Lone pair
          RX = PIX - PX(mm)
          RY = PIY - PY(mm)
          RZ = PIZ - PZ(mm)
          if (runopt(35) /= 'ISOLATED  ') then
            IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
            IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
            IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
          endif
          DX   = RX * BOX(1)
          DY   = RY * BOX(2)
          DZ   = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          RIJ  = sqrt(RIJ2)  !angstrom
!         --------- Charge-dipole and dipole-induced dipole
          IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
            ARIJ2 = ARIJ  * ARIJ
            ARIJ3 = ARIJ2 * ARIJ
            ARIJ4 = ARIJ3 * ARIJ
            ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
            FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                   7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
            EIJ   = EIJ + ECDD
            FIJ   = FIJ + FCDD
            VAL10 = VAL10 - ECDD
            VIRLSR = VIRLSR - FCDD*RIJ2
          END IF
!         ----------------------------------- Interpolation
          IP0 = INT(RIJ*100.0D0)
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = dble(IP0) * 0.01D0
          R01 = dble(IP1) * 0.01D0
          R02 = dble(IP2) * 0.01D0
          X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
          X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
          X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
          FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
          ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!
          FIJ = FIJ + FSIJ
          EIJ = EIJ + ESIJ           
          VAL10  = VAL10  - ESIJ
          VIRLSR = VIRLSR - FSIJ*RIJ2
          UI(mm) = UI(mm) - EIJ
          UI(kk) = UI(kk) - EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FX(mm) = FX(mm) + DFX
          FY(mm) = FY(mm) + DFY
          FZ(mm) = FZ(mm) + DFZ
          FX(kk) = FX(kk) - DFX
          FY(kk) = FY(kk) - DFY
          FZ(kk) = FZ(kk) - DFZ
!
          VAL03 = VAL03 - DFX * DX
          VAL04 = VAL04 - DFY * DY
          VAL05 = VAL05 - DFZ * DZ
          VAL06 = VAL06 - DFX * DY
          VAL07 = VAL07 - DFX * DZ
          VAL08 = VAL08 - DFY * DZ
        enddo
      enddo
    enddo
! ------------------------------------------------------------------
! recalculation of UCSELF, UCSLFI
!
    UCSELF = 0.0D0
    UCCOR = 0.0D0
    if (runopt(35) /= 'ISOLATED  ') then
      ASP = - (ALPHA*1.0D8) * ELC**2 / DSQRT(PI)
      ACOR = -1.0D0*PI*ELC**2/2.0D0/(ALPHA*1.0D8)**2/(VOL*1.0D-24)
      do io = 1,ncompo
        UCSLFI(io) = 0.0d0
        DO I = ions(1,io), IONS(2,io)
          UCSLFI(io) = UCSLFI(io) + ZII(I)**2*ASP
          UIC(I) = UIC(I) +2.0d0*ZII(I)**2*ASP
          UCCOR = UCCOR + ZII(I)
        enddo
        UCSELF = UCSELF + UCSLFI(io)
      enddo
      UCSLFI(ncompo+1) = 0.0D0
      do i = ntion+1, ntion+ndmole
        UCSLFI(ncompo+1) = UCSLFI(ncompo+1) + ZII(i)**2*ASP
        UIC(i) = uic(I) + 2.0d0*ZII(I)**2*ASP
        UCCOR = UCCOR + ZII(I)
      enddo
      UCSELF = UCSELF + UCSLFI(ncompo+1)
      UCCOR = UCCOR**2*ACOR
!
      do i = 1, ntion+ndmole
        ZIIA(i) = ZII(i)*ZII(i)*ASP*2.0D0
        ZIIC(i) = ZIIA(i) !/2.0D0
      enddo
    endif
  endif
  if (runopt(35) == 'ISOLATED  ') then
    UCSELF = 0.0d0
    UCCOR = 0.0d0
  endif
! ------------------------------------------------------------------
  VAL(3)  = VAL(3)  + VAL03*1.0D-8 + VAL03C 
  VAL(4)  = VAL(4)  + VAL04*1.0D-8 + VAL04C 
  VAL(5)  = VAL(5)  + VAL05*1.0D-8 + VAL05C 
  VAL(6)  = VAL(6)  + VAL06*1.0D-8 + VAL06C 
  VAL(7)  = VAL(7)  + VAL07*1.0D-8 + VAL07C 
  VAL(8)  = VAL(8)  + VAL08*1.0D-8 + VAL08C 
  VAL(9)  = VAL(9)  + VAL09
  VAL(10) = VAL(10) + VAL10
  PRSTC2(1) = VAL03C
  PRSTC2(2) = VAL04C
  PRSTC2(3) = VAL05C
  PRSTC2(4) = VAL06C
  PRSTC2(5) = VAL07C
  PRSTC2(6) = VAL08C
!
!     -------------- Cancel intra-molecular Coulomb of diatomic molecules
!
  IF (RUNOPT(23) == 'DIATOMIC  ')  CALL  EWALD_of_DiAtoms
!
!     -------------- Cancel intra-molecular Coulomb of polyatomic molecules
  IF (RUNOPT(29) == 'POLYATOMS ')  CALL  EWALD_of_PolyAtoms
!
!     ---------------------------------------------- RDF for dummy atoms
  IF (JJJ == 1) then
  IN = 0
  DO  IO = 1, NCOMPO
    DO JO = 1, IO
      IN = IN + 1
      IF (IION(IO) > -998 .AND. NION(JO) > -998) cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)   cycle
      IF (IO == JO         .AND. NION(IO) <= 1)   cycle
      DO K = 1, NRCUT(1)+1
        IRDF(K) = 0
      enddo
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
      DO I = I1, I2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
!T                 DO 740  K = 1, 8
!T                     RX = ABS(PIX - PX(J) + TRANSX(K))
!T                     RY = ABS(PIY - PY(J) + TRANSY(K))
!T                     RZ = ABS(PIZ - PZ(J) + TRANSZ(K))
!T                     DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                     DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                     DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = ABS(PIX - PX(J))
          DY = ABS(PIY - PY(J))
          DZ = ABS(PIZ - PZ(J))
!T        - - - - - delete these if-statements for triclinic
          IF (ABS(DX) > 0.5D0)  DX = 1.0D0 - DX
          IF (ABS(DY) > 0.5D0)  DY = 1.0D0 - DY
          IF (ABS(DZ) > 0.5D0)  DZ = 1.0D0 - DZ
          RIJ2 = (DX * BOX(1))**2 + (DY * BOX(2))**2 + (DZ * BOX(3))**2
          IF (RIJ2 <= RCUT2)  GO TO 755
!T 740             CONTINUE
          cycle
755       IP0 = INT( DSQRT(RIJ2) * 100.0D0 )
          IF (IP0 < 1)  IP0 = 1
          IRDF(IP0) = IRDF(IP0) + 1
        enddo
      enddo
      DO L = 1, NRCUT(1)
        NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
      enddo
    enddo
  enddo
  ENDIF
RETURN
END
!
!                                                    ===================
!====================================================== EWALD_of_DiAtoms
SUBROUTINE  EWALD_of_DiAtoms
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use cartes
  use molecu
  use charge
  use pos
  use ewal
!
  implicit none
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
  REAL    *8  PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  REAL    *8  PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ
  REAL    *8  PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,EIJ
  REAL    *8  VAL03, VAL04, VAL05, VAL06, VAL07, VAL08, VAL09
  REAL    *8  VAL03C,VAL04C,VAL05C,VAL06C,VAL07C,VAL08C,VAL09C
  REAL    *8  RIJ, RIJ2, RCUT2, SCCSS, zizj
  real    *8  pjx0,pjy0,pjz0
  REAL    *8  pm(3,lni),zm(LNI),FM(3,LNI),um(3)
  integer *4  ijkl,n,i,k,in,j,ip0,ip1,ip2,ii
  real    *4  val91,pjx,pjy,pjz,val92
!
!
!P    REAL  *8  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    REAL  *8  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3    /10.00464,8.426553,3.460259,0.5623536   /
!P    DATA EY0,EY1,EY2,EY3,EY4/10.00464,19.71558,15.70229,6.090749,1.0/
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  VAL09 = 0.0D0
!
  VAL03C = 0.0D0
  VAL04C = 0.0D0
  VAL05C = 0.0D0
  VAL06C = 0.0D0
  VAL07C = 0.0D0
  VAL08C = 0.0D0
  VAL09C = 0.0D0
!
!     ------------------------------------------ Coulomb reciprocal term
!
  do ijkl = 1, ndmole
    do N=1, 2
      I = IDMOLE(N,IJKL)
      ZM(N) = ZII(I)
      do K = 1, 3
        PM(K,N) = P(K,I)
      enddo
    enddo
    ZM(3) = ZMOLE(IDMOLE(3,IJKL))
    PM(1,3) = P(1,NTION+IJKL)
    PM(2,3) = P(2,NTION+IJKL)
    PM(3,3) = P(3,NTION+IJKL)
    DO I = 1, 3
      UM(I) = 0.0
      DO K = 1, 3
        FM(K,I) = 0.0
      enddo
    enddo
    IF (NVN == 0)  GO TO 200
    DO I = 1, NTION
      ZICOS(I) = 0.0D0
      ZISIN(I) = 0.0D0
    enddo
!
    VAL09C = 0.0D0
    DO IN = 1, NVN
      SICOS = 0.0D0
      SISIN = 0.0D0
      DX = DBLE(NVEC(1,IN)) * PI2
      DY = DBLE(NVEC(2,IN)) * PI2
      DZ = DBLE(NVEC(3,IN)) * PI2
      DO I = 1, 3
        PHI      = DX*PM(1,I) + DY*PM(2,I) + DZ*PM(3,I)
        ZICOS(I) = COS(PHI) * ZM(i)
        SICOS    = SICOS + ZICOS(I)
        ZISIN(I) = SIN(PHI) * ZM(i)
        SISIN    = SISIN + ZISIN(I)
      enddo
!
      FSICOS = FNV(IN) * SICOS
      FSISIN = FNV(IN) * SISIN
      USICOS = UNV(IN) * SICOS
      USISIN = UNV(IN) * SISIN
      SCCSS  = SICOS**2 + SISIN**2
      VAL09C = VAL09C + UNV(IN)   * SCCSS
      VAL03C = VAL03C + PNV(1,IN) * SCCSS
      VAL04C = VAL04C + PNV(2,IN) * SCCSS
      VAL05C = VAL05C + PNV(3,IN) * SCCSS
      VAL06C = VAL06C + PNV(4,IN) * SCCSS
      VAL07C = VAL07C + PNV(5,IN) * SCCSS
      VAL08C = VAL08C + PNV(6,IN) * SCCSS
      FIX    = DBLE(NVEC(1,IN)) * RBOX(1)
      FIY    = DBLE(NVEC(2,IN)) * RBOX(2)
      FIZ    = DBLE(NVEC(3,IN)) * RBOX(3)
      DO I = 1, 3
        UM(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UM(I)
        FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
        FM(1,I) = FM(1,I) + FIJ * FIX
        FM(2,I) = FM(2,I) + FIJ * FIY
        FM(3,I) = FM(3,I) + FIJ * FIZ
      enddo
    enddo
    VAL09 = VAL09 + VAL09C * 0.5D0
    VAL91 = VAL91 + VAL09C*0.5D0
!
!     ----------------------------------- Coulomb direct lattice space
!
200 RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!     ------------------ Calculation of Coulomb of three point charges
    DO I = 1, 2
      PIX = PM(1,I)
      PIY = PM(2,I)
      PIZ = PM(3,I)
      DO J = I+1, 3
        ZIZJ = ZM(I) * ZM(J)
        pjx0 = pM(1,j)
        pjy0 = pM(2,j)
        pjz0 = pM(3,j)
        if (pjx0 < pix)  pjx0 = pjx0 + 1.0
        if (pjy0 < piy)  pjy0 = pjy0 + 1.0
        if (pjz0 < piz)  pjz0 = pjz0 + 1.0
        DO K = 1, 8
          pjx = pjx0 - transx(k)
          pjy = pjy0 - transy(k)
          pjz = pjz0 - transz(k)
          RX = PIX - PjX
          RY = PIY - PjY
          RZ = PIZ - PjZ
!                          RX = PIX - PjX
!                          RY = PIY - PjY
!                          RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = RX * BOX(1)
          DY = RY * BOX(2)
          DZ = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          IF (RIJ2 <= RCUT2)  GO TO 257
        enddo
        cycle
!
257     RIJ = SQRT(RIJ2)
        IP0 = INT(RIJ*100.0)
!                       ---------------------------------- Interpolation
        IP1 = IP0 + 1
        IP2 = IP0 + 2
        R00 = IP0 * 0.01D0
        R01 = IP1 * 0.01D0
        R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
        X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
        X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
        X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
        FIJ  = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
        EIJ  = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) *
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
        VAL09 = VAL09 + EIJ
        VAL92 = VAL92 + EIJ
        UM(I) = UM(I) + EIJ
        UM(J) = UM(J) + EIJ
        DFX = FIJ * DX
        DFY = FIJ * DY
        DFZ = FIJ * DZ
        FM(1,I) = FM(1,I) + DFX
        FM(2,I) = FM(2,I) + DFY
        FM(3,I) = FM(3,I) + DFZ
        FM(1,J) = FM(1,J) - DFX
        FM(2,J) = FM(2,J) - DFY
        FM(3,J) = FM(3,J) - DFZ
        VAL03 = VAL03 + DFX * DX
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
      enddo
    enddo
    UI(NTION+IJKL) = UI(NTION+IJKL) - UM(3)
    FX(NTION+IJKL) = FX(NTION+IJKL) - FM(1,3)
    FY(NTION+IJKL) = FY(NTION+IJKL) - FM(2,3)
    FZ(NTION+IJKL) = FZ(NTION+IJKL) - FM(3,3)
    DO II = 1, 2
      I = IDMOLE(II,IJKL)
      UI(I) = UI(I) - UM(II)
      FX(I) = FX(I) - FM(1,II)
      FY(I) = FY(I) - FM(2,II)
      FZ(I) = FZ(I) - FM(3,II)
      fx(i) = fx(i) + fx(ntion+ijKL) / 2.0
      fy(i) = fy(i) + fy(ntion+ijKL) / 2.0
      fz(i) = fz(i) + fz(ntion+ijKL) / 2.0
      ui(i) = ui(i) + ui(ntion+ijKL) / 2.0
    enddo
  enddo
!
  VAL(3)  = VAL(3)  - VAL03*1.0D-8 - VAL03C
  VAL(4)  = VAL(4)  - VAL04*1.0D-8 - VAL04C
  VAL(5)  = VAL(5)  - VAL05*1.0D-8 - VAL05C
  VAL(6)  = VAL(6)  - VAL06*1.0D-8 - VAL06C
  VAL(7)  = VAL(7)  - VAL07*1.0D-8 - VAL07C
  VAL(8)  = VAL(8)  - VAL08*1.0D-8 - VAL08C
  VAL(9)  = VAL(9)  - VAL09
  II = IATOM2(1)
  IF (II /= 0)  VAL(9) = VAL(9) - UCSLFI(II)
  II = IATOM2(2)
  IF (II /= 0)  VAL(9) = VAL(9) - UCSLFI(II)
  PRSTC2(1) = PRSTC2(1) - VAL03C
  PRSTC2(2) = PRSTC2(2) - VAL04C
  PRSTC2(3) = PRSTC2(3) - VAL05C
  PRSTC2(4) = PRSTC2(4) - VAL06C
  PRSTC2(5) = PRSTC2(5) - VAL07C
  PRSTC2(6) = PRSTC2(6) - VAL08C
RETURN
END
!
!
!                                                  =====================
!==================================================== EWALD_of_PolyAtoms
SUBROUTINE  EWALD_of_PolyAtoms
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use cartes
  use molecu
  use charge
  use pos
  use ewal
!
  implicit none
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
  REAL    *8  DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  REAL    *8  DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ
  REAL    *8  DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,EIJ
  REAL    *8  VAL03, VAL04, VAL05, VAL06, VAL07, VAL08, VAL09
  REAL    *8  VAL03C,VAL04C,VAL05C,VAL06C,VAL07C,VAL08C,VAL09C
  REAL    *8  RIJ, RIJ2, RCUT2, SCCSS, zizj
  real    *8  val91
  REAL    *8  pm(3,lni),zm(lni),FM(3,lni),um(lni) !um(3) for tri atoms
  integer *4  ijkl,n,i,k,in,j,ip0,ip1,ip2,ii
!
!P    REAL  *8  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    REAL  *8  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3    /10.00464,8.426553,3.460259,0.5623536   /
!P    DATA EY0,EY1,EY2,EY3,EY4/10.00464,19.71558,15.70229,6.090749,1.0/
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  VAL09 = 0.0D0
!
  VAL03C = 0.0D0
  VAL04C = 0.0D0
  VAL05C = 0.0D0
  VAL06C = 0.0D0
  VAL07C = 0.0D0
  VAL08C = 0.0D0
  VAL09C = 0.0D0
!
!     ------------------------------------------ Coulomb reciprocal term
!
  do ijkl = 1, nmole         ! nmole: number of molecules
    do N = 1, mmole(ijkl)    ! mmole(ijkl): number of atoms composing the ijkl moleculel
      I = IMOLE(N,IJKL)      ! imole(n,ijkl): index of atoms corresponding the N atoms in the ijkl molecule
      ZM(N) = ZII(I)         ! effective charge of the atom
      do K = 1, 3
        PM(K,N) = P(K,I)     ! the coordinate of the atom
      enddo
    enddo
    DO I = 1, mmole(ijkl)
      UM(I) = 0.0D0
      DO K = 1, 3
        FM(K,I) = 0.0D0
      enddo
    enddo
!
    IF (NVN == 0)  GO TO 200  !NVN: the number of reciprocal vectors
!
    DO I = 1, mmole(ijkl)
      ZICOS(I) = 0.0D0
      ZISIN(I) = 0.0D0
    enddo
!
    VAL09C = 0.0D0
    DO IN = 1, NVN
      SICOS = 0.0D0
      SISIN = 0.0D0
      DX = DBLE(NVEC(1,IN)) * PI2
      DY = DBLE(NVEC(2,IN)) * PI2
      DZ = DBLE(NVEC(3,IN)) * PI2
      DO I = 1, mmole(ijkl)
        PHI      = DX*PM(1,I) + DY*PM(2,I) + DZ*PM(3,I)
        ZICOS(I) = COS(PHI) * ZM(i)
        SICOS    = SICOS + ZICOS(I)
        ZISIN(I) = SIN(PHI) * ZM(i)
        SISIN    = SISIN + ZISIN(I)
      enddo
!
      FSICOS = FNV(IN) * SICOS
      FSISIN = FNV(IN) * SISIN
      USICOS = UNV(IN) * SICOS
      USISIN = UNV(IN) * SISIN
      SCCSS  = SICOS**2 + SISIN**2
      VAL09C = VAL09C + UNV(IN)   * SCCSS
      VAL03C = VAL03C + PNV(1,IN) * SCCSS
      VAL04C = VAL04C + PNV(2,IN) * SCCSS
      VAL05C = VAL05C + PNV(3,IN) * SCCSS
      VAL06C = VAL06C + PNV(4,IN) * SCCSS
      VAL07C = VAL07C + PNV(5,IN) * SCCSS
      VAL08C = VAL08C + PNV(6,IN) * SCCSS
      FIX    = DBLE(NVEC(1,IN)) * RBOX(1)
      FIY    = DBLE(NVEC(2,IN)) * RBOX(2)
      FIZ    = DBLE(NVEC(3,IN)) * RBOX(3)
      DO I = 1, mmole(ijkl)
        UM(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UM(I)
        FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
        FM(1,I) = FM(1,I) + FIJ * FIX
        FM(2,I) = FM(2,I) + FIJ * FIY
        FM(3,I) = FM(3,I) + FIJ * FIZ
      enddo
    enddo
    VAL09 = VAL09 + VAL09C * 0.5D0
    VAL91 = VAL91 + VAL09C * 0.5D0
!
!     ------------------------------------- Coulomb direct lattice space
!
200 RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!     ------------------ Calculation of Coulomb in a polyatomic molecule
    DO I = 1, mmole(ijkl)-1
      DO J = I+1, mmole(ijkl)
        ZIZJ = ZM(I) * ZM(J)
        RX = PM(1,I) - PM(1,J)
        RY = PM(2,I) - PM(2,J)
        RZ = PM(3,I) - PM(3,J)
!                         - - - - - delete these if-statements for triclinic

        if (runopt(35) /= 'ISOLATED  ') then
          IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)
          IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)
          IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)
        endif
!T                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
        DX = RX * BOX(1)
        DY = RY * BOX(2)
        DZ = RZ * BOX(3)
        RIJ2 = DX*DX + DY*DY + DZ*DZ
        IF (RIJ2 <= RCUT2)  GO TO 257
        cycle
257     RIJ = DSQRT(RIJ2)
        IP0 = INT(RIJ*100.D0)
!                       ---------------------------------- Interpolation
        IP1 = IP0 + 1
        IP2 = IP0 + 2
        R00 = DBLE(IP0) * 0.01D0
        R01 = DBLE(IP1) * 0.01D0
        R02 = DBLE(IP2) * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
        X0 = (RIJ-R01)*(RIJ-R02) *    5000.0D0
        X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
        X2 = (RIJ-R00)*(RIJ-R01) *    5000.0D0
        FIJ  = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
        EIJ  = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) *
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
        VAL09 = VAL09 + EIJ
        UM(I) = UM(I) + EIJ
        UM(J) = UM(J) + EIJ
        DFX = FIJ * DX
        DFY = FIJ * DY
        DFZ = FIJ * DZ
        FM(1,I) = FM(1,I) + DFX
        FM(2,I) = FM(2,I) + DFY
        FM(3,I) = FM(3,I) + DFZ
        FM(1,J) = FM(1,J) - DFX
        FM(2,J) = FM(2,J) - DFY
        FM(3,J) = FM(3,J) - DFZ
        VAL03 = VAL03 + DFX * DX
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
      enddo
    enddo
!
    DO II = 1, mmole(ijkl)
      I = IMOLE(ii,ijkl)
      UI(I) = UI(I) - UM(II)
      FX(I) = FX(I) - FM(1,II)
      FY(I) = FY(I) - FM(2,II)
      FZ(I) = FZ(I) - FM(3,II)
    enddo
  enddo
!
  VAL(3)  = VAL(3)  - VAL03*1.0D-8 - VAL03C
  VAL(4)  = VAL(4)  - VAL04*1.0D-8 - VAL04C
  VAL(5)  = VAL(5)  - VAL05*1.0D-8 - VAL05C
  VAL(6)  = VAL(6)  - VAL06*1.0D-8 - VAL06C
  VAL(7)  = VAL(7)  - VAL07*1.0D-8 - VAL07C
  VAL(8)  = VAL(8)  - VAL08*1.0D-8 - VAL08C
  VAL(9)  = VAL(9)  - VAL09
  do ii = MOLstart(1), MOLend(1)
    VAL(9) = VAL(9) - UCSLFI(II)
  end do
  PRSTC2(1) = PRSTC2(1) - VAL03C
  PRSTC2(2) = PRSTC2(2) - VAL04C
  PRSTC2(3) = PRSTC2(3) - VAL05C
  PRSTC2(4) = PRSTC2(4) - VAL06C
  PRSTC2(5) = PRSTC2(5) - VAL07C
  PRSTC2(6) = PRSTC2(6) - VAL08C
RETURN
END
!
!                                                  =====================
!==================================================== POLH2O
SUBROUTINE  POLH2O
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use cartes
  use molecu
  use charge
  use pos
  use ewal
  use temprs
!
  implicit none
!
  real*8  upol_dp
  real*8  diperror,dipX,dipY,dipZ,maxd,dipoldp,sumdipol
  real*8  ZIIH1,ZIIH2,ZIIL1,ZIIL2
  real*8  dipole2,UICO,Edp
  integer *4  i,k,m,io,lp1,lp2,no
!
! -------------------------------------------------------------------
! -------------------------------------------------------------------
!
!  Here calculate the dipole and change the charge
!
  upol     = 0.0D0
  upol_dp  = 0.0D0
  maxedip  = 0.0D0
  maxd     = 0.0D0
  sumdipol = 0.0D0
  sumedip  = 0.0d0
!
  if (JJJ /= 1 .or. NRECRD(3) <= 4) then
    do i = 1, ntion+ndmole
      if (i >= ions(1,iatomo) .and. i <= ions(2,iatomo)) cycle
      UIC(I) = 0.5D0*UIC(I)/ZII(I)
    enddo
  endif
!       write(*,'(4(E10.4,1x))')UIC(2),UIC(3),UIC(4),UIC(5)
!
  if (JJJ == 1 .and. NRECRD(3) > 4) then
!   --------------------------------------------------Predict electric fields
    no = 0
    do io = ions(1,IATOMO),ions(2,IATOMO)
      no = no + 1
      k = ih2o(2,no)
      m = ih2o(3,no)
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
!      UIC(k) = 0.0d0
!      UIC(m) = 0.0d0
!      UIC(lp1) = 0.0d0
!      UIC(lp2) = 0.0d0
      UIC(k)   = 4.0D0*UICP1(k)  -6.0D0*UICP2(k)  +4.0D0*UICP3(k)  -UICP4(k)
      UIC(m)   = 4.0D0*UICP1(m)  -6.0D0*UICP2(m)  +4.0D0*UICP3(m)  -UICP4(m)
      UIC(lp1) = 4.0D0*UICP1(lp1)-6.0D0*UICP2(lp1)+4.0D0*UICP3(lp1)-UICP4(lp1)
      UIC(lp2) = 4.0D0*UICP1(lp2)-6.0D0*UICP2(lp2)+4.0D0*UICP3(lp2)-UICP4(lp2)
!
!      write(*,'(4(E10.4,1x))')UIC(k),UIC(m),UIC(lp1),UIC(lp2)
      ZIIH1 = ZII(k) - ZIIP(k)
      ZIIH2 = ZII(m) - ZIIP(m)
      ZIIL1 = ZII(lp1) -ZIIP(lp1)
      ZIIL2 = ZII(lp2) -ZIIP(lp2)
      pdipX(no) = ZIIH1*DPX1(no)+ZIIH2*DPX2(no)+ (ZIIL1 -ZIIL2)*LOP1X(no) 
      pdipY(no) = ZIIH1*DPY1(no)+ZIIH2*DPY2(no)+ (ZIIL1 -ZIIL2)*LOP1Y(no) 
      pdipZ(no) = ZIIH1*DPZ1(no)+ZIIH2*DPZ2(no)+ (ZIIL1 -ZIIL2)*LOP1Z(no)
    enddo
  endif
!
  no = 0
  do io = ions(1,IATOMO), ions(2,IATOMO)
    no = no + 1
    k = ih2o(2,no)
    m = ih2o(3,no)
    lp1 = ih2o(4,no)
    lp2 = ih2o(5,no)
!
    E34(no) = -1.0d0*(UIC(lp1)-UIC(lp2)) / DLP    ! 4 -> 3
    UICO = 0.5d0*(UIC(lp1)+UIC(lp2))
    Edp1(no) = (UICO-UIC(k))/roh1(no)             ! O -> H1
    Edp2(no) = (UICO-UIC(m))/roh2(no)             ! O -> H2
    Edp = sqrt( &
               (Edp1(no)*UDPX1(no)+Edp2(no)*UDPX2(no))**2 + &
               (Edp1(no)*UDPY1(no)+Edp2(no)*UDPY2(no))**2 + &
               (Edp1(no)*UDPZ1(no)+Edp2(no)*UDPZ2(no))**2)
!
!   Damping of polarizability
!
    watpol(1,no) = WATPOLDP
    watpol(2,no) = WATPOLLP    
!
!
    IF (Edp > Ediv) then
      watpol(1,no) = ECOFF*(DMAX-DMAX/(exp(GEb_pol*(Edp-Emb_pol))+1.0d0))/Edp
    endif
!    IF (abs(E34(no)) > Ediv) then
!      watpol(2,no) = ECOFF*(DMAX-DMAX/(exp(GEb_pol*(abs(E34(no))-Emb_pol))+1.0d0))/abs(E34(no))
!    endif
!
!   ---------------------------------------------In plane
    QHHk(no) = watpol(1,no)*Edp1(no)/roh1(no)*POL
    QHHm(no) = watpol(1,no)*Edp2(no)/roh2(no)*POL
    QLPx(no) = -0.5d0*(QHHk(no)+QHHm(no))
!
!   O -> H1
    idipX(2,no) = QHHk(no)*DPX1(no)
    idipy(2,no) = QHHk(no)*DPY1(no)
    idipz(2,no) = QHHk(no)*DPZ1(no)
!   O -> H2
    idipX(3,no) = QHHm(no)*DPX2(no)
    idipy(3,no) = QHHm(no)*DPY2(no)
    idipz(3,no) = QHHm(no)*DPZ2(no)
!
!   ---------------------------------------------LP direction
    QLP1z(no) =  watpol(2,no)*E34(no)/DLP*POL
    QLP2z(no) = -1.0d0*QLP1z(no)
    idipX(4,no) = QLP1z(no)*2.0d0*LOP1X(no)
    idipy(4,no) = QLP1z(no)*2.0d0*LOP1Y(no)
    idipz(4,no) = QLP1z(no)*2.0d0*LOP1Z(no)
!   ------------------------------------------Induced charges of Lone pairs
    QLP1(no) = (QLP1z(no) + QLPx(no))
    QLP2(no) = (QLP2z(no) + QLPx(no))
!   ------------------------------------------RESULTS:Charges 
    ZII(io) = 0.0D0
    ZII(k)  = ZIIP(k)  + QHHk(no)
    ZII(m)  = ZIIP(m)  + QHHm(no)
    ZII(lp1) = ZIIP(lp1) + QLP1(no)
    ZII(lp2) = ZIIP(lp2) + QLP2(no)
!   ----------------------------------------------------------
    if (ZII(lp1) > 0.0D0 .or. ZII(lp2) > 0.0D0 .or. ZII(k) < 0.0D0 .or. ZII(m) < 0.0D0) then
      write(*,*)'Charge is unrealistic !!! upol could be uncorrect !!!'
!      ZII(k) = ZIIP(k)
!      ZII(m) = ZIIP(m)
!      ZII(lp1) = ZIIP(lp1)
!      ZII(lp2) = ZIIP(lp2)
    endif
!
    dipX = ZII(k)*DPX1(no)+ZII(m)*DPX2(no) +(ZII(lp1)-ZII(lp2))*LOP1X(no)
    dipY = ZII(k)*DPY1(no)+ZII(m)*DPY2(no) +(ZII(lp1)-ZII(lp2))*LOP1Y(no)
    dipZ = ZII(k)*DPZ1(no)+ZII(m)*DPZ2(no) +(ZII(lp1)-ZII(lp2))*LOP1Z(no)
    idipX(1,no) = QHHk(no)*DPX1(no) + QHHm(no)*DPX2(no) +(QLP1(no) - QLP2(no))*LOP1X(no)
    idipY(1,no) = QHHk(no)*DPY1(no) + QHHm(no)*DPY2(no) +(QLP1(no) - QLP2(no))*LOP1Y(no)
    idipZ(1,no) = QHHk(no)*DPZ1(no) + QHHm(no)*DPZ2(no) +(QLP1(no) - QLP2(no))*LOP1Z(no)
!
    diperror = &
       sqrt((idipX(1,no)-pdipX(no))**2 + (idipY(1,no)-pdipY(no))**2 + (idipZ(1,no)-pdipZ(no))**2) &
       *ELCC*1.0D-10/DEBYE
    if(diperror > maxedip) maxedip = diperror
    sumedip = sumedip + diperror
!
    dipole2  = ELCC**2*1.0D-20*(dipX**2 + dipY**2 + dipZ**2)
    dipoldp  = sqrt(dipole2)
    sumdipol = sumdipol + dipoldp
!
    if (dipoldp/DEBYE > maxd) maxd = dipoldp/DEBYE
!
!   -----------------------------------------------Upol
    idp2(no) = idipX(1,no)**2 + idipY(1,no)**2 + idipZ(1,no)**2
    upol_dp = upol_dp &
              + (idipX(2,no)**2+idipY(2,no)**2+idipZ(2,no)**2)/watpol(1,no)  &
              + (idipX(3,no)**2+idipY(3,no)**2+idipZ(3,no)**2)/watpol(1,no)  &
              + (idipX(4,no)**2+idipY(4,no)**2+idipZ(4,no)**2)/watpol(2,no)
!
    pdipX(no)  = idipX(1,no)
    pdipY(no)  = idipY(1,no)
    pdipZ(no)  = idipZ(1,no)
!
  enddo
!
  upol = 0.5D0 * upol_dp  /POL   !erg
  sumedip = sumedip / sqrt(dble(NION(IATOMO)))
!
  sumdipol = sumdipol/NION(IATOMO)/DEBYE
!  write(*,'("==Max Dipole Error : ", E10.3, " D", " Dipole : (MAX) ", F8.4, " D", &
!            " (AVE) ", F8.4, " D ==")') maxedip, maxd, sumdipol
  write(*,'("==rms of dipole : ", E10.3, " D", " Dipole : (MAX) ", F8.4, " D", &
            " (AVE) ", F8.4, " D ==")') sumedip, maxd, sumdipol
!
!
!
999 RETURN
END
!
!                                                                =======
!================================================================ THREEP
SUBROUTINE  THREEP  (I, KK3BP, R3LIM)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use ewal
!
  implicit none
!
!     ------------------------------------------- 3-body potential model
!
!
  REAL     *8  RIJX(L3R),DRDXI(L3R),DRDXJ(L3R),FFX,DCDX,CDR0
  REAL     *8  RIJY(L3R),DRDYI(L3R),DRDYJ(L3R),FFY,DCDY,CDR1
  REAL     *8  RIJZ(L3R),DRDZI(L3R),DRDZJ(L3R),FFZ,DCDZ,CDR2
  REAL     *8  AK1,ARIJL1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  AK2,ARIJL2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  real     *8  ffx1, ffy1, ffz1, ffx2, ffy2, ffz2
  REAL     *8  R3LIM, RM, GR, FACT, RDJIJ, RD0
  REAL     *8  FK, AR, UJIJ, PHAI2, RIJ(L3R)
  REAL     *8  ASINJ
  real     *8  TJIJ
  INTEGER  *4  KIJ(L3R)
  integer  *4  I,KK3BP,NIJ,JJ,J,L1,L2,J1,J2
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM  = R3BLIM(1,KK3BP)   !r_m
  GR  = R3BGRD(1,KK3BP)   !g_r
  RD0 = ANG3BP(KK3BP) / PI180   !theta/(180.0/pi) radian unit
  FK  = FK3BP(KK3BP) * 1.0D-8   !f
  NIJ = 0
  DO JJ = 1, N1ATOM
    IF (D1ATOM(JJ) <= R3LIM)  THEN
      J = I1ATOM(JJ)
      NIJ       = NIJ + 1
      KIJ(NIJ)  = J
      RIJ(NIJ)  = D1ATOM(JJ)
      RIJX(NIJ) = -1.0D0 * D1AXYZ(1,JJ)   !D1AXYZ(1, ): X component of RIJ
      RIJY(NIJ) = -1.0D0 * D1AXYZ(2,JJ)   !D1AXYZ(2, ): Y component of RIJ
      RIJZ(NIJ) = -1.0D0 * D1AXYZ(3,JJ)   !D1AXYZ(3, ): Z component of RIJ
!
      AR = 1.0D0 / RIJ(NIJ)
      DRDXI(NIJ) = -1.0D0 * RIJX(NIJ) * AR !unit vector
      DRDYI(NIJ) = -1.0D0 * RIJY(NIJ) * AR
      DRDZI(NIJ) = -1.0D0 * RIJZ(NIJ) * AR
      DRDXJ(NIJ) = RIJX(NIJ) * AR
      DRDYJ(NIJ) = RIJY(NIJ) * AR
      DRDZJ(NIJ) = RIJZ(NIJ) * AR
    END IF
  enddo
!
  IF (NIJ < 2)  RETURN
!
  DO L1 = 1, NIJ-1
    ARIJL1 = 1.0D0 / RIJ(L1)
    DO L2 = L1+1, NIJ
      ARIJL2 = 1.0D0 / RIJ(L2)
      COSJIJ = (RIJX(L1)*RIJX(L2) + &
                RIJY(L1)*RIJY(L2) + &
                RIJZ(L1)*RIJZ(L2)) *ARIJL1*ARIJL2
      IF (ABS(COSJIJ) < 1.0D-11) THEN
        COSJIJ = SIGN(1.0D-11,COSJIJ)
      END IF
      SINJIJ = DSQRT(1.0D0 - COSJIJ*COSJIJ)
      ASINJ  = SIGN(1.0D-11,SINJIJ)
      IF (ABS(SINJIJ) > 1.D-11)  ASINJ  = 1.0D0 / SINJIJ
!     --------------------------------------- TJIJ : J-I-J angle
      RDJIJ  = DATAN(SINJIJ / COSJIJ)   !J-I-J angle in radian
      IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
      TJIJ   = RDJIJ * PI180            !J-I-J angle in degree
      IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
!     --------------------- Decriment of force with I-J distance
      EX1 = DEXP((RIJ(L1) - RM) * GR)
      EX2 = DEXP((RIJ(L2) - RM) * GR)
      AK1  = 1.0D0 / (EX1 + 1.0D0)
      AK2  = 1.0D0 / (EX2 + 1.0D0)
      FACT = DSQRT( AK1 * AK2 )
!     ----------------------------- FJIJ : Force for J-I-J angle
!                                   UJIJ : Potential for J-I-J angle
      PHAI2 = 2.0D0 * (RDJIJ - RD0)
      UJIJ = -1.0D0 *FK *(DCOS(PHAI2) -1.0D0) * FACT
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (DRDXJ(L2) - DRDXJ(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDYJ(L2) - DRDYJ(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZJ(L2) - DRDZJ(L1)*COSJIJ) * ARIJL1
      CDR = 0.5D0 *AK1 *GR *EX1 *(DCOS(PHAI2)-1.0D0)
      CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
      FFX1 = -1.0D8 *FK *FACT *(CDR *DRDXJ(L1) + CDS *DCDX)
      FFY1 = -1.0D8 *FK *FACT *(CDR *DRDYJ(L1) + CDS *DCDY)
      FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZJ(L1) + CDS *DCDZ)
      J1 = KIJ(L1)
      FX(J1) = FX(J1) + FFX1
      FY(J1) = FY(J1) + FFY1
      FZ(J1) = FZ(J1) + FFZ1
      VIRLSR = VIRLSR + FFX1*RIJX(L1) + FFY1*RIJY(L1) + FFZ1*RIJZ(L1)
      VAL03 = VAL03 + FFX1 *RIJX(L1)
      VAL04 = VAL04 + FFY1 *RIJY(L1)
      VAL05 = VAL05 + FFZ1 *RIJZ(L1)
      VAL06 = VAL06 + FFX1 *RIJY(L1)
      VAL07 = VAL07 + FFX1 *RIJZ(L1)
      VAL08 = VAL08 + FFY1 *RIJZ(L1)
!
      DCDX = (DRDXJ(L1) - DRDXJ(L2)*COSJIJ) * ARIJL2
      DCDY = (DRDYJ(L1) - DRDYJ(L2)*COSJIJ) * ARIJL2
      DCDZ = (DRDZJ(L1) - DRDZJ(L2)*COSJIJ) * ARIJL2
      CDR = 0.5D0 *AK2 *GR *EX2 *(DCOS(PHAI2)-1.0D0)
!      CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
      FFX2 = -1.0D8 *FK *FACT *(CDR *DRDXJ(L2) + CDS *DCDX)
      FFY2 = -1.0D8 *FK *FACT *(CDR *DRDYJ(L2) + CDS *DCDY)
      FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZJ(L2) + CDS *DCDZ)
      J2 = KIJ(L2)
      FX(J2) = FX(J2) + FFX2
      FY(J2) = FY(J2) + FFY2
      FZ(J2) = FZ(J2) + FFZ2
      VIRLSR = VIRLSR + FFX2*RIJX(L2) + FFY2*RIJY(L2) + FFZ2*RIJZ(L2)
      VAL03 = VAL03 + FFX2 *RIJX(L2)
      VAL04 = VAL04 + FFY2 *RIJY(L2)
      VAL05 = VAL05 + FFZ2 *RIJZ(L2)
      VAL06 = VAL06 + FFX2 *RIJY(L2)
      VAL07 = VAL07 + FFX2 *RIJZ(L2)
      VAL08 = VAL08 + FFY2 *RIJZ(L2)
!
      DCDX = (DRDXI(L1) - DRDXI(L2)*COSJIJ) * ARIJL2 +(DRDXI(L2) - DRDXI(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDYI(L1) - DRDYI(L2)*COSJIJ) * ARIJL2 +(DRDYI(L2) - DRDYI(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZI(L1) - DRDZI(L2)*COSJIJ) * ARIJL2 +(DRDZI(L2) - DRDZI(L1)*COSJIJ) * ARIJL1
      CDR0 = 0.5D0 *GR *(DCOS(PHAI2)-1.0D0)
      CDR1 = AK1 *EX1 *CDR0
      CDR2 = AK2 *EX2 *CDR0
      FFX = FK *FACT *(CDR1*DRDXI(L1) +CDR2*DRDXI(L2) +CDS*DCDX)
      FFY = FK *FACT *(CDR1*DRDYI(L1) +CDR2*DRDYI(L2) +CDS*DCDY)
      FFZ = FK *FACT *(CDR1*DRDZI(L1) +CDR2*DRDZI(L2) +CDS*DCDZ)
      FFX = FFX * (-1.0D8)
      FFY = FFY * (-1.0D8)
      FFZ = FFZ * (-1.0D8)
      ffx = ffx - (ffx + ffx1 + ffx2)
      ffy = ffy - (ffy + ffy1 + ffy2)
      ffz = ffz - (ffz + ffz1 + ffz2)
      FX(I) = FX(I) + FFX
      FY(I) = FY(I) + FFY
      FZ(I) = FZ(I) + FFZ
!
!      write (6,*) ffx1, ffy1, ffz1
!      write (6,*) ffx2, ffy2, ffz2
!      write (6,*) ffx,  ffy,  ffz
!      write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
    enddo
  enddo
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                                =======
!================================================================ THREER
SUBROUTINE  THREER  (I, KK3BP, R3LIM)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use ewal
!
  implicit none
!
!     ------------------------------------------- 3-body potential model
!
!
  REAL     *8  RIJX(L3R),DRDXI(L3R),DRDXJ(L3R),DCDX
  REAL     *8  RIJY(L3R),DRDYI(L3R),DRDYJ(L3R),DCDY
  REAL     *8  RIJZ(L3R),DRDZI(L3R),DRDZJ(L3R),DCDZ
  REAL     *8  AK1,ARIJL1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  AK2,ARIJL2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  real     *8  ffx1, ffy1, ffz1, ffx2, ffy2, ffz2
  REAL     *8  R3LIM, RM, GR, FACT, RDJIJ, RD0
  REAL     *8  FK, AR, UJIJ, PHAI2, RIJ(L3R)
  REAL     *8  ASINJ
  real     *8  TJIJ
  INTEGER  *4  KIJ(L3R)
  integer  *4  I,KK3BP,NIJ,JJ,J,L1,L2,J1,J2
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM  = R3BLIM(1,KK3BP)   !r_m
  GR  = R3BGRD(1,KK3BP)   !g_r
  RD0 = ANG3BP(KK3BP) / PI180   !theta/(180.0/pi) radian unit
  FK  = FK3BP(KK3BP) * 1.0D-8   !f [erg]
  NIJ = 0
  DO JJ = 1, N1ATOM
    IF (D1ATOM(JJ) <= R3LIM)  THEN
      J = I1ATOM(JJ)
      NIJ       = NIJ + 1
      KIJ(NIJ)  = J
      RIJ(NIJ)  = D1ATOM(JJ)
      RIJX(NIJ) = -1.0D0 * D1AXYZ(1,JJ)   !X component of RIJ, I -> J
      RIJY(NIJ) = -1.0D0 * D1AXYZ(2,JJ)   !Y component of RIJ, I -> J
      RIJZ(NIJ) = -1.0D0 * D1AXYZ(3,JJ)   !Z component of RIJ, I -> J
!
      AR = 1.0D0 / RIJ(NIJ)
      DRDXI(NIJ) = -1.0D0 * RIJX(NIJ) * AR !unit vector  J -> I
      DRDYI(NIJ) = -1.0D0 * RIJY(NIJ) * AR
      DRDZI(NIJ) = -1.0D0 * RIJZ(NIJ) * AR
      DRDXJ(NIJ) = RIJX(NIJ) * AR          !unit vector  I -> J
      DRDYJ(NIJ) = RIJY(NIJ) * AR
      DRDZJ(NIJ) = RIJZ(NIJ) * AR
    END IF
  enddo
!
!
  IF (NIJ < 2)  RETURN
!
  DO L1 = 1, NIJ-1
    ARIJL1 = 1.0D0 / RIJ(L1)
    DO L2 = L1+1, NIJ
!     ------------------------------------------cos(theta) and sin(theta)
      ARIJL2 = 1.0D0 / RIJ(L2)
      COSJIJ = (RIJX(L1)*RIJX(L2) + &
                RIJY(L1)*RIJY(L2) + &
                RIJZ(L1)*RIJZ(L2)) *ARIJL1*ARIJL2
      IF (ABS(COSJIJ) < 1.0D-11) THEN
        COSJIJ = SIGN(1.0D-11,COSJIJ)
      END IF
      SINJIJ = DSQRT(1.0D0 - COSJIJ*COSJIJ)
      ASINJ  = SIGN(1.0D-11,SINJIJ)
      IF (ABS(SINJIJ) > 1.D-11)  ASINJ  = 1.0D0 / SINJIJ
!
!     --------------------------------------- TJIJ : J-I-J angle
      RDJIJ  = DATAN(SINJIJ / COSJIJ)   !J-I-J angle in radian
      IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
      TJIJ   = RDJIJ * PI180            !J-I-J angle in degree
      IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
!
!     --------------------- k1 and k2, FACT = (k1*k2)^0.5
!
      EX1 = DEXP((RIJ(L1) - RM) * GR)
      EX2 = DEXP((RIJ(L2) - RM) * GR)
      AK1  = 1.0D0 / (EX1 + 1.0D0)
      AK2  = 1.0D0 / (EX2 + 1.0D0)
      FACT = DSQRT( AK1 * AK2 )
!
!     ----------------------------- FJIJ : Forces
!                                   UJIJ : Potential
      PHAI2 = 2.0D0 * (RDJIJ - RD0)  !2x(theta_HOH - theta0) in radian
      UJIJ = -1.0D0 *FK *(DCOS(PHAI2) -1.0D0) * FACT
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (-DRDXJ(L2) + DRDXJ(L1)*COSJIJ)*ASINJ  !omega_x
      DCDY = (-DRDYJ(L2) + DRDYJ(L1)*COSJIJ)*ASINJ  !omega_y
      DCDZ = (-DRDZJ(L2) + DRDZJ(L1)*COSJIJ)*ASINJ  !omega_z
!
      CDS  = - 2.0D0*ARIJL1*DSIN(PHAI2)              ! Bending
      CDR  = - 0.5D0*(DCOS(PHAI2)-1.0D0)*EX1*AK1*GR  ! Stretching
!
      FFX1 = FK*FACT*1.0D8* (CDS*DCDX + CDR*DRDXJ(L1))
      FFY1 = FK*FACT*1.0D8* (CDS*DCDY + CDR*DRDYJ(L1))
      FFZ1 = FK*FACT*1.0D8* (CDS*DCDZ + CDR*DRDZJ(L1))
!      DCDX = (DRDXJ(L2) - DRDXJ(L1)*COSJIJ) * ARIJL1
!      DCDY = (DRDYJ(L2) - DRDYJ(L1)*COSJIJ) * ARIJL1
!      DCDZ = (DRDZJ(L2) - DRDZJ(L1)*COSJIJ) * ARIJL1
!      CDR = 0.5D0 *AK1 *GR *EX1 *(DCOS(PHAI2)-1.0D0)
!      CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
!      FFX1 = -1.0D8 *FK *FACT *(CDR *DRDXJ(L1) + CDS *DCDX)
!      FFY1 = -1.0D8 *FK *FACT *(CDR *DRDYJ(L1) + CDS *DCDY)
!      FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZJ(L1) + CDS *DCDZ)
      J1 = KIJ(L1)
      FX(J1) = FX(J1) + FFX1
      FY(J1) = FY(J1) + FFY1
      FZ(J1) = FZ(J1) + FFZ1
      VIRLSR = VIRLSR + FFX1*RIJX(L1) + FFY1*RIJY(L1) + FFZ1*RIJZ(L1)
      VAL03 = VAL03 + FFX1 *RIJX(L1)
      VAL04 = VAL04 + FFY1 *RIJY(L1)
      VAL05 = VAL05 + FFZ1 *RIJZ(L1)
      VAL06 = VAL06 + FFX1 *RIJY(L1)
      VAL07 = VAL07 + FFX1 *RIJZ(L1)
      VAL08 = VAL08 + FFY1 *RIJZ(L1)
!
      DCDX = (-DRDXJ(L1) + DRDXJ(L2)*COSJIJ)*ASINJ  !omega_x
      DCDY = (-DRDYJ(L1) + DRDYJ(L2)*COSJIJ)*ASINJ  !omega_y
      DCDZ = (-DRDZJ(L1) + DRDZJ(L2)*COSJIJ)*ASINJ  !omega_z
!
      CDS  = - 2.0D0*ARIJL2*DSIN(PHAI2)        !Bending ARIJL2[A-1]
      CDR  = - 0.5D0*(DCOS(PHAI2)-1.0D0)*EX2*AK2*GR  !Stretching GR[A-1]
!
      FFX2 = FK*FACT*1.0D8* (CDS*DCDX + CDR*DRDXJ(L2))
      FFY2 = FK*FACT*1.0D8* (CDS*DCDY + CDR*DRDYJ(L2))
      FFZ2 = FK*FACT*1.0D8* (CDS*DCDZ + CDR*DRDZJ(L2))
!
!      DCDX = (DRDXJ(L1) - DRDXJ(L2)*COSJIJ) * ARIJL2
!      DCDY = (DRDYJ(L1) - DRDYJ(L2)*COSJIJ) * ARIJL2
!      DCDZ = (DRDZJ(L1) - DRDZJ(L2)*COSJIJ) * ARIJL2
!      CDR = 0.5D0 *AK2 *GR *EX2 *(DCOS(PHAI2)-1.0D0)
!      CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
!      FFX2 = -1.0D8 *FK *FACT *(CDR *DRDXJ(L2) + CDS *DCDX)
!      FFY2 = -1.0D8 *FK *FACT *(CDR *DRDYJ(L2) + CDS *DCDY)
!      FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZJ(L2) + CDS *DCDZ)
      J2 = KIJ(L2)
      FX(J2) = FX(J2) + FFX2
      FY(J2) = FY(J2) + FFY2
      FZ(J2) = FZ(J2) + FFZ2
      VIRLSR = VIRLSR + FFX2*RIJX(L2) + FFY2*RIJY(L2) + FFZ2*RIJZ(L2)
      VAL03 = VAL03 + FFX2 *RIJX(L2)
      VAL04 = VAL04 + FFY2 *RIJY(L2)
      VAL05 = VAL05 + FFZ2 *RIJZ(L2)
      VAL06 = VAL06 + FFX2 *RIJY(L2)
      VAL07 = VAL07 + FFX2 *RIJZ(L2)
      VAL08 = VAL08 + FFY2 *RIJZ(L2)
!
!      DCDX = (DRDXI(L1) - DRDXI(L2)*COSJIJ) * ARIJL2 +(DRDXI(L2) - DRDXI(L1)*COSJIJ) * ARIJL1
!      DCDY = (DRDYI(L1) - DRDYI(L2)*COSJIJ) * ARIJL2 +(DRDYI(L2) - DRDYI(L1)*COSJIJ) * ARIJL1
!      DCDZ = (DRDZI(L1) - DRDZI(L2)*COSJIJ) * ARIJL2 +(DRDZI(L2) - DRDZI(L1)*COSJIJ) * ARIJL1
!      CDR0 = 0.5D0 *GR *(DCOS(PHAI2)-1.0D0)
!      CDR1 = AK1 *EX1 *CDR0
!      CDR2 = AK2 *EX2 *CDR0
!      FFX = FK *FACT *(CDR1*DRDXI(L1) +CDR2*DRDXI(L2) +CDS*DCDX)
!      FFY = FK *FACT *(CDR1*DRDYI(L1) +CDR2*DRDYI(L2) +CDS*DCDY)
!      FFZ = FK *FACT *(CDR1*DRDZI(L1) +CDR2*DRDZI(L2) +CDS*DCDZ)
!      FFX = FFX * (-1.0D8)
!      FFY = FFY * (-1.0D8)
!      FFZ = FFZ * (-1.0D8)
!      ffx = ffx - (ffx + ffx1 + ffx2)
!      ffy = ffy - (ffy + ffy1 + ffy2)
!      ffz = ffz - (ffz + ffz1 + ffz2)
!      FX(I) = FX(I) + FFX
!      FY(I) = FY(I) + FFY
!      FZ(I) = FZ(I) + FFZ
!
       FX(I) = FX(I) - (FFX1 + FFX2)
       FY(I) = FY(I) - (FFY1 + FFY2)
       FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
!      write (6,*) ffx1, ffy1, ffz1
!      write (6,*) ffx2, ffy2, ffz2
!      write (6,*) ffx,  ffy,  ffz
!      write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
    enddo
  enddo
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                               ========
!=============================================================== THREEP2
SUBROUTINE  THREEP2  (I, KK3BP, R3LIM)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use ewal
!
  implicit none
!
!     ------------------------------------------- 3-body potential model
!
!
  REAL     *8  RIJX(L3R),DRDXI(L3R),DRDXJ(L3R),FFX,DCDX,CDR0
  REAL     *8  RIJY(L3R),DRDYI(L3R),DRDYJ(L3R),FFY,DCDY,CDR1
  REAL     *8  RIJZ(L3R),DRDZI(L3R),DRDZJ(L3R),FFZ,DCDZ,CDR2
  REAL     *8  AK1,ARIJL1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  AK2,ARIJL2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  real     *8  ffx1, ffy1, ffz1, ffx2, ffy2, ffz2
  REAL     *8  R3LIM, RM, GR, FACT, RDJIJ, RD0
  REAL     *8  FK, AR, UJIJ, PHAI2, RIJ(L3R)
  REAL     *8  ASINJ
  real     *8  TJIJ
  INTEGER  *4  KIJ(L3R)
  integer  *4  I,KK3BP,NIJ,JJ,J,L1,L2,J1,J2
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0E-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM  = DBLE(R3BLIM(1,KK3BP))
  GR  = DBLE(R3BGRD(1,KK3BP))
  RD0 = DBLE(ANG3BP(KK3BP)) / PI180
  FK  = DBLE(FK3BP(KK3BP)) * 1.0D-8
  NIJ = 0
  DO JJ = 1, N1ATOM
    IF (D1ATOM(JJ) <= R3LIM)  THEN
      J = I1ATOM(JJ)
      NIJ       = NIJ + 1
      KIJ(NIJ)  = J
      RIJ(NIJ)  = D1ATOM(JJ)
      RIJX(NIJ) = -1.0D0 * D1AXYZ(1,JJ)
      RIJY(NIJ) = -1.0D0 * D1AXYZ(2,JJ)
      RIJZ(NIJ) = -1.0D0 * D1AXYZ(3,JJ)
!
      AR = 1.0D0 / RIJ(NIJ)
      DRDXI(NIJ) = -1.0D0 * RIJX(NIJ) * AR
      DRDYI(NIJ) = -1.0D0 * RIJY(NIJ) * AR
      DRDZI(NIJ) = -1.0D0 * RIJZ(NIJ) * AR
      DRDXJ(NIJ) = RIJX(NIJ) * AR
      DRDYJ(NIJ) = RIJY(NIJ) * AR
      DRDZJ(NIJ) = RIJZ(NIJ) * AR
    END IF
  enddo
!
  IF (NIJ < 2)  RETURN
!
  DO L1 = 1, NIJ-1
    ARIJL1 = 1.0D0 / RIJ(L1)
    DO L2 = L1+1, NIJ
      ARIJL2 = 1.0D0 / RIJ(L2)
      COSJIJ = (RIJX(L1)*RIJX(L2)+RIJY(L1)*RIJY(L2)+RIJZ(L1)*RIJZ(L2))*ARIJL1*ARIJL2
      IF (ABS(COSJIJ) < 1.0D-11) THEN
        COSJIJ = SIGN(1.0D-11,COSJIJ)
      END IF
      SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
      ASINJ  = SIGN(1.0D-11,SINJIJ)
      IF (ABS(SINJIJ) > 1D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : J-I-J angle
      RDJIJ  = ATAN(SINJIJ / COSJIJ)
      IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
      TJIJ   = RDJIJ * PI180
      IF (TJIJ < 0.0)  TJIJ = TJIJ + 180.0
!             --------------------- Decriment of force with I-J distance
      EX1  = EXP((RIJ(L1) - RM) * GR)
      EX2  = EXP((RIJ(L2) - RM) * GR)
      AK1  = 1.0D0 / (EX1 + 1.0D0)
      AK2  = 1.0D0 / (EX2 + 1.0D0)
      FACT = AK1 * AK2
!             ----------------------------- FJIJ : Force for J-I-J angle
!                                           UJIJ : Potential for J-I-J angle
      PHAI2 = 2.0D0 * (RDJIJ - RD0)
      UJIJ = -1.0D0 *FK *(COS(PHAI2) -1.0D0) * FACT
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (DRDXJ(L2) - DRDXJ(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDYJ(L2) - DRDYJ(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZJ(L2) - DRDZJ(L1)*COSJIJ) * ARIJL1
      CDR = AK1 *GR *EX1 *(COS(PHAI2)-1.0D0)
      CDS = -2.0D0 *ASINJ *SIN(PHAI2)
      FFX1 = -1.0D8 *FK *FACT *(CDR *DRDXJ(L1) + CDS *DCDX)
      FFY1 = -1.0D8 *FK *FACT *(CDR *DRDYJ(L1) + CDS *DCDY)
      FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZJ(L1) + CDS *DCDZ)
      J1 = KIJ(L1)
      FX(J1) = FX(J1) + FFX1
      FY(J1) = FY(J1) + FFY1
      FZ(J1) = FZ(J1) + FFZ1
      VIRLSR = VIRLSR + FFX1*RIJX(L1) + FFY1*RIJY(L1) + FFZ1*RIJZ(L1)
      VAL03 = VAL03 + FFX1 *RIJX(L1)
      VAL04 = VAL04 + FFY1 *RIJY(L1)
      VAL05 = VAL05 + FFZ1 *RIJZ(L1)
      VAL06 = VAL06 + FFX1 *RIJY(L1)
      VAL07 = VAL07 + FFX1 *RIJZ(L1)
      VAL08 = VAL08 + FFY1 *RIJZ(L1)
!
      DCDX = (DRDXJ(L1) - DRDXJ(L2)*COSJIJ) * ARIJL2
      DCDY = (DRDYJ(L1) - DRDYJ(L2)*COSJIJ) * ARIJL2
      DCDZ = (DRDZJ(L1) - DRDZJ(L2)*COSJIJ) * ARIJL2
      CDR = AK2 *GR *EX2 *(COS(PHAI2)-1.0D0)
!      CDS = -2.0D0 *ASINJ *SIN(PHAI2)
      FFX2 = -1.0D8 *FK *FACT *(CDR *DRDXJ(L2) + CDS *DCDX)
      FFY2 = -1.0D8 *FK *FACT *(CDR *DRDYJ(L2) + CDS *DCDY)
      FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZJ(L2) + CDS *DCDZ)
      J2 = KIJ(L2)
      FX(J2) = FX(J2) + FFX2
      FY(J2) = FY(J2) + FFY2
      FZ(J2) = FZ(J2) + FFZ2
      VIRLSR = VIRLSR + FFX2*RIJX(L2) + FFY2*RIJY(L2) + FFZ2*RIJZ(L2)
      VAL03 = VAL03 + FFX2 *RIJX(L2)
      VAL04 = VAL04 + FFY2 *RIJY(L2)
      VAL05 = VAL05 + FFZ2 *RIJZ(L2)
      VAL06 = VAL06 + FFX2 *RIJY(L2)
      VAL07 = VAL07 + FFX2 *RIJZ(L2)
      VAL08 = VAL08 + FFY2 *RIJZ(L2)
!
      DCDX = (DRDXI(L1) - DRDXI(L2)*COSJIJ) * ARIJL2 +(DRDXI(L2) - DRDXI(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDYI(L1) - DRDYI(L2)*COSJIJ) * ARIJL2 +(DRDYI(L2) - DRDYI(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZI(L1) - DRDZI(L2)*COSJIJ) * ARIJL2 +(DRDZI(L2) - DRDZI(L1)*COSJIJ) * ARIJL1
      CDR0 = GR *(COS(PHAI2)-1.0D0)
      CDR1 = AK1 *EX1 *CDR0
      CDR2 = AK2 *EX2 *CDR0
      FFX = FK *FACT *(CDR1*DRDXI(L1) +CDR2*DRDXI(L2) +CDS*DCDX)
      FFY = FK *FACT *(CDR1*DRDYI(L1) +CDR2*DRDYI(L2) +CDS*DCDY)
      FFZ = FK *FACT *(CDR1*DRDZI(L1) +CDR2*DRDZI(L2) +CDS*DCDZ)
      FFX = FFX * (-1.0D8)
      FFY = FFY * (-1.0D8)
      FFZ = FFZ * (-1.0D8)
      ffx = ffx - (ffx + ffx1 + ffx2)
      ffy = ffy - (ffy + ffy1 + ffy2)
      ffz = ffz - (ffz + ffz1 + ffz2)
      FX(I) = FX(I) + FFX
      FY(I) = FY(I) + FFY
      FZ(I) = FZ(I) + FFZ
!
!      write (6,*) ffx1, ffy1, ffz1
!      write (6,*) ffx2, ffy2, ffz2
!      write (6,*) ffx,  ffy,  ffz
!      write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0
!
    enddo
  enddo
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                                =======
!================================================================THREER3
SUBROUTINE  THREER3  (I, KK3BP)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use ewal
  use pmorse
!
  implicit none
!
!     ------------------------------------------- Vashishta
!     ------------------------------------------- 3-body potential model
!
!
  REAL     *8  RIJX(L3R),DRDXI(L3R),DRDXJ(L3R),DCDX
  REAL     *8  RIJY(L3R),DRDYI(L3R),DRDYJ(L3R),DCDY
  REAL     *8  RIJZ(L3R),DRDZI(L3R),DRDZJ(L3R),DCDZ
  REAL     *8  ARIJL1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  ARIJL2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  real     *8  ffx1, ffy1, ffz1, ffx2, ffy2, ffz2
  REAL     *8  UJIJ, RIJ(L3R)
  REAL     *8  ASINJ,AR,RDJIJ
  real     *8  TJIJ
  DOUBLE PRECISION BETA,R0ij,GAMMAij,COSRD0,BK,CK
  DOUBLE PRECISION COSM,CCOF,BCOF
  INTEGER  *4  KIJ(L3R)
  integer  *4  I,KK3BP,NIJ,JJ,J,L1,L2,J1,J2
!
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
  BETA = ELCC * 1.0D7  ! eV -> erg
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  R0ij  = R3BLIM(1,KK3BP)   !r0 [Angstrom]
!  R0ik  = R3BLIM(2,KK3BP)   !r0_ik [Angstrom]
  GAMMAij  = R3BGRD(1,KK3BP)   ! Gamma_ij [Angstrom]
!  GAMMAik  = R3BGRD(2,KK3BP)   ! Gamma_ik [Angstrom]
  COSRD0 = ANG3BP(KK3BP)    ! COS theta_0
  BK  = FK3BP(KK3BP) * BETA   !B [erg]
  CK  = CIJK(KK3BP)  ! C [-]
  NIJ = 0
  DO JJ = 1, N1ATOM
    IF (D1ATOM(JJ) <= R0ij)  THEN
      J = I1ATOM(JJ)
      NIJ       = NIJ + 1
      KIJ(NIJ)  = J
      RIJ(NIJ)  = D1ATOM(JJ)
      RIJX(NIJ) = -1.0D0 * D1AXYZ(1,JJ)   !X component of RIJ, I -> J
      RIJY(NIJ) = -1.0D0 * D1AXYZ(2,JJ)   !Y component of RIJ, I -> J
      RIJZ(NIJ) = -1.0D0 * D1AXYZ(3,JJ)   !Z component of RIJ, I -> J
!
      AR = 1.0D0 / RIJ(NIJ)
      DRDXI(NIJ) = -1.0D0 * RIJX(NIJ) * AR !unit vector  J -> I
      DRDYI(NIJ) = -1.0D0 * RIJY(NIJ) * AR
      DRDZI(NIJ) = -1.0D0 * RIJZ(NIJ) * AR
      DRDXJ(NIJ) = RIJX(NIJ) * AR          !unit vector  I -> J
      DRDYJ(NIJ) = RIJY(NIJ) * AR
      DRDZJ(NIJ) = RIJZ(NIJ) * AR
    END IF
  enddo
!
!
  IF (NIJ < 2)  RETURN
!
  DO L1 = 1, NIJ-1
    ARIJL1 = 1.0D0 / RIJ(L1)
    DO L2 = L1+1, NIJ
!     ------------------------------------------cos(theta) and sin(theta)
      ARIJL2 = 1.0D0 / RIJ(L2)
      COSJIJ = (RIJX(L1)*RIJX(L2) + &
                RIJY(L1)*RIJY(L2) + &
                RIJZ(L1)*RIJZ(L2)) *ARIJL1*ARIJL2
      IF (ABS(COSJIJ) < 1.0D-11) THEN
        COSJIJ = SIGN(1.0D-11,COSJIJ)
      END IF
      SINJIJ = DSQRT(1.0D0 - COSJIJ*COSJIJ)
      ASINJ  = SIGN(1.0D-11,SINJIJ)
      IF (ABS(SINJIJ) > 1.D-11)  ASINJ  = 1.0D0 / SINJIJ
!
!     --------------------------------------- TJIJ : J-I-J angle
      RDJIJ  = DATAN(SINJIJ / COSJIJ)   !J-I-J angle in radian
      IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
      TJIJ   = RDJIJ * PI180            !J-I-J angle in degree
      IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
!
!     --------------------- exp 
!
      EX1 = DEXP(GAMMAij/(RIJ(L1) - R0ij))
      EX2 = DEXP(GAMMAij/(RIJ(L2) - R0ij))
!
!     ----------------------------- FJIJ : Forces
!                                   UJIJ : Potential
      COSM = COSJIJ - COSRD0  ! cos(theta)-cos(theta_0)
      CCOF = COSM/(1.0d0+CK*COSM**2)
      UJIJ = BK*COSM*CCOF*EX1*EX2
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (-DRDXJ(L2) + DRDXJ(L1)*COSJIJ)*ASINJ  !omega_x
      DCDY = (-DRDYJ(L2) + DRDYJ(L1)*COSJIJ)*ASINJ  !omega_y
      DCDZ = (-DRDZJ(L2) + DRDZJ(L1)*COSJIJ)*ASINJ  !omega_z
!
      CDS  = 2.0D0*ARIJL1*SINJIJ/(1.0d0+CK*COSM**2)              ! Bending
      CDR  = COSM*GAMMAij/(RIJ(L1)-R0ij)**2  ! Stretching
!
      BCOF = BK*EX1*EX2*CCOF
      FFX1 = BCOF*1.0D8* (CDS*DCDX + CDR*DRDXJ(L1))
      FFY1 = BCOF*1.0D8* (CDS*DCDY + CDR*DRDYJ(L1))
      FFZ1 = BCOF*1.0D8* (CDS*DCDZ + CDR*DRDZJ(L1))
!
      J1 = KIJ(L1)
      FX(J1) = FX(J1) + FFX1
      FY(J1) = FY(J1) + FFY1
      FZ(J1) = FZ(J1) + FFZ1
      VIRLSR = VIRLSR + FFX1*RIJX(L1) + FFY1*RIJY(L1) + FFZ1*RIJZ(L1)
      VAL03 = VAL03 + FFX1 *RIJX(L1)
      VAL04 = VAL04 + FFY1 *RIJY(L1)
      VAL05 = VAL05 + FFZ1 *RIJZ(L1)
      VAL06 = VAL06 + FFX1 *RIJY(L1)
      VAL07 = VAL07 + FFX1 *RIJZ(L1)
      VAL08 = VAL08 + FFY1 *RIJZ(L1)
!
      DCDX = (-DRDXJ(L1) + DRDXJ(L2)*COSJIJ)*ASINJ  !omega_x
      DCDY = (-DRDYJ(L1) + DRDYJ(L2)*COSJIJ)*ASINJ  !omega_y
      DCDZ = (-DRDZJ(L1) + DRDZJ(L2)*COSJIJ)*ASINJ  !omega_z
!
      CDS  = 2.0D0*ARIJL2*SINJIJ/(1.0d0+CK*COSM**2)              ! Bending
      CDR  = COSM*GAMMAij/(RIJ(L2)-R0ij)**2  ! Stretching
!
      FFX2 = BCOF*1.0D8* (CDS*DCDX + CDR*DRDXJ(L2))
      FFY2 = BCOF*1.0D8* (CDS*DCDY + CDR*DRDYJ(L2))
      FFZ2 = BCOF*1.0D8* (CDS*DCDZ + CDR*DRDZJ(L2))
!
      J2 = KIJ(L2)
      FX(J2) = FX(J2) + FFX2
      FY(J2) = FY(J2) + FFY2
      FZ(J2) = FZ(J2) + FFZ2
      VIRLSR = VIRLSR + FFX2*RIJX(L2) + FFY2*RIJY(L2) + FFZ2*RIJZ(L2)
      VAL03 = VAL03 + FFX2 *RIJX(L2)
      VAL04 = VAL04 + FFY2 *RIJY(L2)
      VAL05 = VAL05 + FFZ2 *RIJZ(L2)
      VAL06 = VAL06 + FFX2 *RIJY(L2)
      VAL07 = VAL07 + FFX2 *RIJZ(L2)
      VAL08 = VAL08 + FFY2 *RIJZ(L2)
!
!write(*,*)I,J1,J2
!
       FX(I) = FX(I) - (FFX1 + FFX2)
       FY(I) = FY(I) - (FFY1 + FFY2)
       FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
!      write (6,*) ffx1, ffy1, ffz1
!      write (6,*) ffx2, ffy2, ffz2
!      write (6,*) ffx,  ffy,  ffz
!      write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
    enddo
  enddo
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                                =======
!================================================================ THREEQ
SUBROUTINE  THREEQ  (I, KK3BP, R3LIM1, R3LIM2)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use pos
  use ewal
  use charac
!
  implicit none
!
!     ------------------------------ 3-body potential model j-i-k (j<k)
!
!
!
  REAL     *8  R1IJX(L3R),DRDX1I(L3R),DRDX1J(L3R),FFX,DCDX
  REAL     *8  R1IJY(L3R),DRDY1I(L3R),DRDY1J(L3R),FFY,DCDY,CDR1
  REAL     *8  R1IJZ(L3R),DRDZ1I(L3R),DRDZ1J(L3R),FFZ,DCDZ,CDR2
  REAL     *8  R2IJX(L3R),DRDX2I(L3R),DRDX2J(L3R),ffx1,ffx2
  REAL     *8  R2IJY(L3R),DRDY2I(L3R),DRDY2J(L3R),ffy1,ffy2
  REAL     *8  R2IJZ(L3R),DRDZ2I(L3R),DRDZ2J(L3R),ffz1,ffz2
  REAL     *8  ARIJL1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  AK2,ARIJL2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  REAL     *8  FACT, RDJIJ, RD0
  REAL     *8  FK, AR, UJIJ, PHAI2, R1IJ(L3R), R2IJ(L3R)
  REAL     *8  ASINJ, RX,RY,RZ
  real     *8  R3LIM1,R3LIM2,PIX,PIY,PIZ,R3LIM12,R3LIM22
  real     *8  DX,DY,DZ,RIJ2,RM1,GR1,RM2,GR2,TJIJ,AK1
  INTEGER  *4  K1IJ(L3R), K2IJ(L3R)
  INTEGER  *4  I,KK3BP,jo,J,N1IJ,JJ,N2IJ,L1,L2,J1,J2
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
!     write (6,*)  'KK3BP=',kk3bp,'FK3BP(kk3bp)=',fk3BP(kk3bp),
!    *             r3lim1,r3lim2
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J,k : J-I-K
  pix = px(i)
  piy = py(i)
  piz = pz(i)
  jo  = k3bp(kk3bp)
  n2atom = 0
  r3lim12 = r3lim1*r3lim1
  r3lim22 = r3lim2*r3lim2
  DO J = ions(1,jo), ions(2,jo)
    RX = PIX - PX(J)
    RY = PIY - PY(J)
    RZ = PIZ - PZ(J)
    if (runopt(35) /= 'ISOLATED  ') then
      IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)
      IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)
      IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)
    endif
    DX = RX * BOX(1)
    DY = RY * BOX(2)
    DZ = RZ * BOX(3)
    RIJ2 = DX*DX + DY*DY + DZ*DZ
    IF (RIJ2 > R3lim22)  cycle
    N2ATOM  = N2ATOM  + 1
    I2ATOM(N2ATOM)   = J
    D2ATOM(N2ATOM)   = sqrt(RIJ2)
    D2AXYZ(1,N2ATOM) = DX
    D2AXYZ(2,N2ATOM) = DY
    D2AXYZ(3,N2ATOM) = DZ
  enddo
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM1 = DBLE(R3BLIM(1,KK3BP))
  GR1 = DBLE(R3BGRD(1,KK3BP))
  RM2 = DBLE(R3BLIM(2,KK3BP))
  GR2 = DBLE(R3BGRD(2,KK3BP))
  RD0 = DBLE(ANG3BP(KK3BP)) / PI180
  FK  = DBLE(FK3BP(KK3BP)) * 1.0D-8
  N1IJ = 0
  DO JJ = 1, N1ATOM
    IF (D1ATOM(JJ) <= R3LIM1)  THEN
      J = I1ATOM(JJ)
      N1IJ       = N1IJ + 1
      K1IJ(N1IJ)  = J
      R1IJ(N1IJ)  = D1ATOM(JJ)
      R1IJX(N1IJ) = -1.0D0 * D1AXYZ(1,JJ)
      R1IJY(N1IJ) = -1.0D0 * D1AXYZ(2,JJ)
      R1IJZ(N1IJ) = -1.0D0 * D1AXYZ(3,JJ)
!
      AR = 1.0D0 / R1IJ(N1IJ)
      DRDX1I(N1IJ) = -1.0D0 * R1IJX(N1IJ) * AR
      DRDY1I(N1IJ) = -1.0D0 * R1IJY(N1IJ) * AR
      DRDZ1I(N1IJ) = -1.0D0 * R1IJZ(N1IJ) * AR
      DRDX1J(N1IJ) = R1IJX(N1IJ) * AR
      DRDY1J(N1IJ) = R1IJY(N1IJ) * AR
      DRDZ1J(N1IJ) = R1IJZ(N1IJ) * AR
    END IF
  enddo
  N2IJ = 0
  DO JJ = 1, N2ATOM
    IF (D2ATOM(JJ) <= R3LIM2)  THEN
      J = I2ATOM(JJ)
      N2IJ       = N2IJ + 1
      K2IJ(N2IJ)  = J
      R2IJ(N2IJ)  = D2ATOM(JJ)
      R2IJX(N2IJ) = -1.0D0 * D2AXYZ(1,JJ)
      R2IJY(N2IJ) = -1.0D0 * D2AXYZ(2,JJ)
      R2IJZ(N2IJ) = -1.0D0 * D2AXYZ(3,JJ)
!
      AR = 1.0D0 / R2IJ(N2IJ)
      DRDX2I(N2IJ) = -1.0D0 * R2IJX(N2IJ) * AR
      DRDY2I(N2IJ) = -1.0D0 * R2IJY(N2IJ) * AR
      DRDZ2I(N2IJ) = -1.0D0 * R2IJZ(N2IJ) * AR
      DRDX2J(N2IJ) = R2IJX(N2IJ) * AR
      DRDY2J(N2IJ) = R2IJY(N2IJ) * AR
      DRDZ2J(N2IJ) = R2IJZ(N2IJ) * AR
    END IF
  enddo
!
  IF (N1IJ < 1 .or. N2ij < 1)  RETURN
!
  DO L1 = 1, N1IJ
    ARIJL1 = 1.0D0 / R1IJ(L1)
    DO L2 =1, N2IJ
      ARIJL2 = 1.0D0 / R2IJ(L2)
!             write (6,*) l1,l2,r1ij(l1),r2ij(l2)
      COSJIJ = (R1IJX(L1)*R2IJX(L2)+R1IJY(L1)*R2IJY(L2)+R1IJZ(L1)*R2IJZ(L2))*ARIJL1*ARIJL2
      IF (ABS(COSJIJ) < 1.0D-11) COSJIJ = SIGN(1.0D-11,COSJIJ)
      SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
      ASINJ  = SIGN(1.0D-11,SINJIJ)
      IF (ABS(SINJIJ) > 1D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : J-I-J angle
      RDJIJ  = ATAN(SINJIJ / COSJIJ)
      IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
      TJIJ   = RDJIJ * PI180
      IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
!             --------------------- Decriment of force with I-J distance
      EX1 = EXP((R1IJ(L1) - RM1) * GR1)
      EX2 = EXP((R2IJ(L2) - RM2) * GR2)
      AK1  = 1.0D0 / (EX1 + 1.0D0)
      AK2  = 1.0D0 / (EX2 + 1.0D0)
      FACT = SQRT( AK1 * AK2 )
!             ----------------------------- FJIJ : Force for J-I-J angle
!                                       UJIJ : Potential for J-I-J angle
      PHAI2 = 2.0D0 * (RDJIJ - RD0)
      UJIJ = -1.0D0 *FK *(COS(PHAI2) -1.0D0) * FACT
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (DRDX2J(L2) - DRDX1J(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDY2J(L2) - DRDY1J(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZ2J(L2) - DRDZ1J(L1)*COSJIJ) * ARIJL1
      CDR = 0.5D0 *AK1 *GR1 *EX1 *(COS(PHAI2)-1.0D0)
      CDS = -2.0D0 *ASINJ *SIN(PHAI2)
      FFX1 = -1.0D8 *FK *FACT *(CDR *DRDX1J(L1) + CDS *DCDX)
      FFY1 = -1.0D8 *FK *FACT *(CDR *DRDY1J(L1) + CDS *DCDY)
      FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZ1J(L1) + CDS *DCDZ)
      J1 = K1IJ(L1)
      FX(J1) = FX(J1) + FFX1
      FY(J1) = FY(J1) + FFY1
      FZ(J1) = FZ(J1) + FFZ1
      VIRLSR = VIRLSR + FFX1*R1IJX(L1) + FFY1*R1IJY(L1) + FFZ1*R1IJZ(L1)
      VAL03 = VAL03 + FFX1 *R1IJX(L1)
      VAL04 = VAL04 + FFY1 *R1IJY(L1)
      VAL05 = VAL05 + FFZ1 *R1IJZ(L1)
      VAL06 = VAL06 + FFX1 *R1IJY(L1)
      VAL07 = VAL07 + FFX1 *R1IJZ(L1)
      VAL08 = VAL08 + FFY1 *R1IJZ(L1)
!
      DCDX = (DRDX1J(L1) - DRDX2J(L2)*COSJIJ) * ARIJL2
      DCDY = (DRDY1J(L1) - DRDY2J(L2)*COSJIJ) * ARIJL2
      DCDZ = (DRDZ1J(L1) - DRDZ2J(L2)*COSJIJ) * ARIJL2
      CDR = 0.5D0 *AK2 *GR2 *EX2 *(COS(PHAI2)-1.0D0)
!      CDS = -2.0D0 *ASINJ *SIN(PHAI2)
      FFX2 = -1.0D8 *FK *FACT *(CDR *DRDX2J(L2) + CDS *DCDX)
      FFY2 = -1.0D8 *FK *FACT *(CDR *DRDY2J(L2) + CDS *DCDY)
      FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZ2J(L2) + CDS *DCDZ)
      J2 = K2IJ(L2)
      FX(J2) = FX(J2) + FFX2
      FY(J2) = FY(J2) + FFY2
      FZ(J2) = FZ(J2) + FFZ2
      VIRLSR = VIRLSR + FFX2*R2IJX(L2) + FFY2*R2IJY(L2) + FFZ2*R2IJZ(L2)
      VAL03 = VAL03 + FFX2 *R2IJX(L2)
      VAL04 = VAL04 + FFY2 *R2IJY(L2)
      VAL05 = VAL05 + FFZ2 *R2IJZ(L2)
      VAL06 = VAL06 + FFX2 *R2IJY(L2)
      VAL07 = VAL07 + FFX2 *R2IJZ(L2)
      VAL08 = VAL08 + FFY2 *R2IJZ(L2)
!
      DCDX = (DRDX1I(L1) - DRDX2I(L2)*COSJIJ) * ARIJL2 +(DRDX2I(L2) - DRDX1I(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDY1I(L1) - DRDY2I(L2)*COSJIJ) * ARIJL2 +(DRDY2I(L2) - DRDY1I(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZ1I(L1) - DRDZ2I(L2)*COSJIJ) * ARIJL2 +(DRDZ2I(L2) - DRDZ1I(L1)*COSJIJ) * ARIJL1
      CDR1 = AK1 *EX1 * 0.5D0 *GR1 *(COS(PHAI2)-1.0D0)
      CDR2 = AK2 *EX2 * 0.5D0 *GR2 *(COS(PHAI2)-1.0D0)
      FFX= FK*FACT *(CDR1*DRDX1I(L1) +CDR2*DRDX2I(L2) +CDS*DCDX)
      FFY= FK*FACT *(CDR1*DRDY1I(L1) +CDR2*DRDY2I(L2) +CDS*DCDY)
      FFZ= FK*FACT *(CDR1*DRDZ1I(L1) +CDR2*DRDZ2I(L2) +CDS*DCDZ)
      FFX = FFX * (-1.0D8)
      FFY = FFY * (-1.0D8)
      FFZ = FFZ * (-1.0D8)
      ffx = ffx - (ffx + ffx1 + ffx2)
      ffy = ffy - (ffy + ffy1 + ffy2)
      ffz = ffz - (ffz + ffz1 + ffz2)
      FX(I) = FX(I) + FFX
      FY(I) = FY(I) + FFY
      FZ(I) = FZ(I) + FFZ
!
!              write (6,*) ffx1, ffy1, ffz1
!              write (6,*) ffx2, ffy2, ffz2
!              write (6,*) ffx,  ffy,  ffz
!              write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
    enddo
  enddo
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                               ========
!=============================================================== THREEQ2
SUBROUTINE  THREEQ2  (I, KK3BP, R3LIM1, R3LIM2)
  use param
  use aboxof
  use atomsi
  use paramt
  use values
  use forces
  use datoms
  use pos
  use ewal
  use charac
!
  implicit none
!
!     ------------------------------ 3-body potential model j-i-k (j<k)
!
!
  REAL     *8  R1IJX(L3R),DRDX1I(L3R),DRDX1J(L3R),FFX,DCDX
  REAL     *8  R1IJY(L3R),DRDY1I(L3R),DRDY1J(L3R),FFY,DCDY,CDR1
  REAL     *8  R1IJZ(L3R),DRDZ1I(L3R),DRDZ1J(L3R),FFZ,DCDZ,CDR2
  REAL     *8  R2IJX(L3R),DRDX2I(L3R),DRDX2J(L3R),ffx1,ffx2
  REAL     *8  R2IJY(L3R),DRDY2I(L3R),DRDY2J(L3R),ffy1,ffy2
  REAL     *8  R2IJZ(L3R),DRDZ2I(L3R),DRDZ2J(L3R),ffz1,ffz2
  REAL     *8  ARIJL1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05
  REAL     *8  AK2,ARIJL2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08
  REAL     *8  FACT, RDJIJ, RD0
  REAL     *8  FK, AR, UJIJ, PHAI2, R1IJ(L3R), R2IJ(L3R)
  REAL     *8  ASINJ, RX,RY,RZ
  INTEGER  *4  K1IJ(L3R), K2IJ(L3R)
  INTEGER  *4  I,KK3BP,JO,J,N1IJ,JJ,N2IJ,L1,L2,J1,J2
  real     *8  R3LIM1,R3LIM2,PIX,PIY,PIZ,R3LIM12,R3LIM22,DX,DY,DZ,RIJ2
  real     *8  RM1,GR1,RM2,GR2,TJIJ,AK1
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0E-21)    RETURN
!    -------------------------------------------------- I : Central ion
!                                                        J,k : J-I-K
  pix = px(i)
  piy = py(i)
  piz = pz(i)
  jo  = k3bp(kk3bp)
  n2atom = 0
  r3lim12 = r3lim1*r3lim1
  r3lim22 = r3lim2*r3lim2
  DO J = ions(1,jo), ions(2,jo)
    RX = PIX - PX(J)
    RY = PIY - PY(J)
    RZ = PIZ - PZ(J)
    if (RUNOPT(35) /= 'ISOLATED  ') then
      IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
      IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
      IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
    endif
    DX = RX * BOX(1)
    DY = RY * BOX(2)
    DZ = RZ * BOX(3)
    RIJ2 = DX*DX + DY*DY + DZ*DZ
    IF (RIJ2 > R3lim22)  cycle
    N2ATOM  = N2ATOM  + 1
    I2ATOM(N2ATOM)   = J
    D2ATOM(N2ATOM)   = sqrt(RIJ2)
    D2AXYZ(1,N2ATOM) = DX
    D2AXYZ(2,N2ATOM) = DY
    D2AXYZ(3,N2ATOM) = DZ
  enddo
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM1 = DBLE(R3BLIM(1,KK3BP))
  GR1 = DBLE(R3BGRD(1,KK3BP))
  RM2 = DBLE(R3BLIM(2,KK3BP))
  GR2 = DBLE(R3BGRD(2,KK3BP))
  RD0 = DBLE(ANG3BP(KK3BP)) / PI180
  FK  = DBLE(FK3BP(KK3BP)) * 1.0D-8
  N1IJ = 0
  DO JJ = 1, N1ATOM
    IF (D1ATOM(JJ) <= R3LIM1)  THEN
      J = I1ATOM(JJ)
      N1IJ       = N1IJ + 1
      K1IJ(N1IJ)  = J
      R1IJ(N1IJ)  = D1ATOM(JJ)
      R1IJX(N1IJ) = -1.0D0 * D1AXYZ(1,JJ)
      R1IJY(N1IJ) = -1.0D0 * D1AXYZ(2,JJ)
      R1IJZ(N1IJ) = -1.0D0 * D1AXYZ(3,JJ)
!
      AR = 1.0D0 / R1IJ(N1IJ)
      DRDX1I(N1IJ) = -1.0D0 * R1IJX(N1IJ) * AR
      DRDY1I(N1IJ) = -1.0D0 * R1IJY(N1IJ) * AR
      DRDZ1I(N1IJ) = -1.0D0 * R1IJZ(N1IJ) * AR
      DRDX1J(N1IJ) = R1IJX(N1IJ) * AR
      DRDY1J(N1IJ) = R1IJY(N1IJ) * AR
      DRDZ1J(N1IJ) = R1IJZ(N1IJ) * AR
    END IF
  enddo
  N2IJ = 0
  DO JJ = 1, N2ATOM
    IF (D2ATOM(JJ) <= R3LIM2)  THEN
      J = I2ATOM(JJ)
      N2IJ       = N2IJ + 1
      K2IJ(N2IJ)  = J
      R2IJ(N2IJ)  = D2ATOM(JJ)
      R2IJX(N2IJ) = -1.0D0 * D2AXYZ(1,JJ)
      R2IJY(N2IJ) = -1.0D0 * D2AXYZ(2,JJ)
      R2IJZ(N2IJ) = -1.0D0 * D2AXYZ(3,JJ)
!
      AR = 1.0D0 / R2IJ(N2IJ)
      DRDX2I(N2IJ) = -1.0D0 * R2IJX(N2IJ) * AR
      DRDY2I(N2IJ) = -1.0D0 * R2IJY(N2IJ) * AR
      DRDZ2I(N2IJ) = -1.0D0 * R2IJZ(N2IJ) * AR
      DRDX2J(N2IJ) = R2IJX(N2IJ) * AR
      DRDY2J(N2IJ) = R2IJY(N2IJ) * AR
      DRDZ2J(N2IJ) = R2IJZ(N2IJ) * AR
    END IF
  enddo
!
  IF (N1IJ < 1 .or. N2ij < 1)  RETURN
!
  DO L1 = 1, N1IJ
    ARIJL1 = 1.0D0 / R1IJ(L1)
    DO L2 =1, N2IJ
      ARIJL2 = 1.0D0 / R2IJ(L2)
      COSJIJ = (R1IJX(L1)*R2IJX(L2)+R1IJY(L1)*R2IJY(L2)+R1IJZ(L1)*R2IJZ(L2))*ARIJL1*ARIJL2
      IF (ABS(COSJIJ) < 1.0D-11) COSJIJ = SIGN(1.0D-11,COSJIJ)
      SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
      ASINJ  = SIGN(1.0D-11,SINJIJ)
      IF (ABS(SINJIJ) > 1D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : J-I-J angle
      RDJIJ  = ATAN(SINJIJ / COSJIJ)
      IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
      TJIJ   = RDJIJ * PI180
      IF (TJIJ < 0.0)  TJIJ = TJIJ + 180.0D0
!             --------------------- Decriment of force with I-J distance
      EX1  = EXP((R1IJ(L1) - RM1) * GR1)
      EX2  = EXP((R2IJ(L2) - RM2) * GR2)
      AK1  = 1.0D0 / (EX1 + 1.0D0)
      AK2  = 1.0D0 / (EX2 + 1.0D0)
      FACT = AK1 * AK2
!             ----------------------------- FJIJ : Force for J-I-J angle
!                                       UJIJ : Potential for J-I-J angle
      PHAI2 = 2.0D0 * (RDJIJ - RD0)
      UJIJ = -1.0D0 *FK *(COS(PHAI2) -1.0D0) * FACT
      VAL(11) = VAL(11) + UJIJ
!
      DCDX = (DRDX2J(L2) - DRDX1J(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDY2J(L2) - DRDY1J(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZ2J(L2) - DRDZ1J(L1)*COSJIJ) * ARIJL1
      CDR = AK1 *GR1 *EX1 *(COS(PHAI2)-1.0D0)
      CDS = -2.0D0 *ASINJ *SIN(PHAI2)
      FFX1 = -1.0D8 *FK *FACT *(CDR *DRDX1J(L1) + CDS *DCDX)
      FFY1 = -1.0D8 *FK *FACT *(CDR *DRDY1J(L1) + CDS *DCDY)
      FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZ1J(L1) + CDS *DCDZ)
      J1 = K1IJ(L1)
      FX(J1) = FX(J1) + FFX1
      FY(J1) = FY(J1) + FFY1
      FZ(J1) = FZ(J1) + FFZ1
      VIRLSR = VIRLSR + FFX1*R1IJX(L1) + FFY1*R1IJY(L1) + FFZ1*R1IJZ(L1)
      VAL03 = VAL03 + FFX1 *R1IJX(L1)
      VAL04 = VAL04 + FFY1 *R1IJY(L1)
      VAL05 = VAL05 + FFZ1 *R1IJZ(L1)
      VAL06 = VAL06 + FFX1 *R1IJY(L1)
      VAL07 = VAL07 + FFX1 *R1IJZ(L1)
      VAL08 = VAL08 + FFY1 *R1IJZ(L1)
!
      DCDX = (DRDX1J(L1) - DRDX2J(L2)*COSJIJ) * ARIJL2
      DCDY = (DRDY1J(L1) - DRDY2J(L2)*COSJIJ) * ARIJL2
      DCDZ = (DRDZ1J(L1) - DRDZ2J(L2)*COSJIJ) * ARIJL2
      CDR = AK2 *GR2 *EX2 *(COS(PHAI2)-1.0D0)
!      CDS = -2.0D0 *ASINJ *SIN(PHAI2)
      FFX2 = -1.0D8 *FK *FACT *(CDR *DRDX2J(L2) + CDS *DCDX)
      FFY2 = -1.0D8 *FK *FACT *(CDR *DRDY2J(L2) + CDS *DCDY)
      FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZ2J(L2) + CDS *DCDZ)
      J2 = K2IJ(L2)
      FX(J2) = FX(J2) + FFX2
      FY(J2) = FY(J2) + FFY2
      FZ(J2) = FZ(J2) + FFZ2
      VIRLSR = VIRLSR + FFX2*R2IJX(L2) + FFY2*R2IJY(L2) + FFZ2*R2IJZ(L2)
      VAL03 = VAL03 + FFX2 *R2IJX(L2)
      VAL04 = VAL04 + FFY2 *R2IJY(L2)
      VAL05 = VAL05 + FFZ2 *R2IJZ(L2)
      VAL06 = VAL06 + FFX2 *R2IJY(L2)
      VAL07 = VAL07 + FFX2 *R2IJZ(L2)
      VAL08 = VAL08 + FFY2 *R2IJZ(L2)
!
      DCDX = (DRDX1I(L1) - DRDX2I(L2)*COSJIJ) * ARIJL2 + (DRDX2I(L2) - DRDX1I(L1)*COSJIJ) * ARIJL1
      DCDY = (DRDY1I(L1) - DRDY2I(L2)*COSJIJ) * ARIJL2 + (DRDY2I(L2) - DRDY1I(L1)*COSJIJ) * ARIJL1
      DCDZ = (DRDZ1I(L1) - DRDZ2I(L2)*COSJIJ) * ARIJL2 + (DRDZ2I(L2) - DRDZ1I(L1)*COSJIJ) * ARIJL1
      CDR1 = AK1 *EX1 * GR1 *(COS(PHAI2)-1.0D0)
      CDR2 = AK2 *EX2 * GR2 *(COS(PHAI2)-1.0D0)
      FFX= FK*FACT *(CDR1*DRDX1I(L1) +CDR2*DRDX2I(L2) +CDS*DCDX)
      FFY= FK*FACT *(CDR1*DRDY1I(L1) +CDR2*DRDY2I(L2) +CDS*DCDY)
      FFZ= FK*FACT *(CDR1*DRDZ1I(L1) +CDR2*DRDZ2I(L2) +CDS*DCDZ)
      FFX = FFX * (-1.0D8)
      FFY = FFY * (-1.0D8)
      FFZ = FFZ * (-1.0D8)
      ffx = ffx - (ffx + ffx1 + ffx2)
      ffy = ffy - (ffy + ffy1 + ffy2)
      ffz = ffz - (ffz + ffz1 + ffz2)
      FX(I) = FX(I) + FFX
      FY(I) = FY(I) + FFY
      FZ(I) = FZ(I) + FFZ
!
!              write (6,*) ffx1, ffy1, ffz1
!              write (6,*) ffx2, ffy2, ffz2
!              write (6,*) ffx,  ffy,  ffz
!              write (6,*) ffx+ffx1+ffx2, ffy+ffy1+ffy2, ffz+ffz1+ffz2
!
      AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
      AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0
!
    enddo
  enddo
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
RETURN
END
!
!
!                                                               ========
!================================================================ QUANTM
SUBROUTINE  QUANTM
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use values
  use quanco
!
  implicit none
!     ----------------------------------------------- Quantum correction
!
!  COMMON /QUANAB/ NQC
!
  REAL  *8        FEK,QKIE,DQCE,TEMPQ, QCKET
  integer *4      J,I
  real  *8        AKINE
!
  IF (NRECRD(1) == 1)  TEMPQH = 0.0
!     --------------------------------- Quantum correction for each step
  FEK   = ((AHP/ 2.0/PI)**2) / (24.0D0 * AKB)
!                                            TQCE : sum of nabla(Uij)/mi
  TQCE  = TQCE * FEK
!                               [TQCE]/T : Net Quantum Correction Energy
  QCIT  = 1.50D0 * AKB * REAL(NTION)
  AKINE = VAL(13)
!                                         1/2 for Harmonic approximation
  QCKET = TQCE * 0.5D0
!                    QCKET : [Quantum Correction for Kinetic energy] * T
!                                  [QCIT]*T**2 + [AKINE]*T + [QCKET] = 0
  DQCE  = AKINE**2 - 4.0D0 * QCIT * QCKET
  IF (DQCE <= 0.0) THEN
!    NQC = NQC + 1
    AKINE = SQRT(4.0D0 * QCIT * QCKET)
    TEMPQ = AKINE / (2.0D0 * QCIT)
    QKIE  = SQRT(AKINE / VAL(13))
    DO J = 1, 3
      DO I = 1, NTION
        V(J,I) = V(J,I) * QKIE
      enddo
    enddo
  ELSE
    TEMPQ = (AKINE + SQRT(DQCE)) / (2.0D0 * QCIT)
  END IF
  VAL(1) = TEMPQ
  TEMPQQ = AKINE / QCIT
  TEMPQH = TEMPQH + TEMPQQ
!
!     write (6,*) 'Thermodynamic temperature : ',tempq,
!    *            '  Kinetic temperature :', TEMPQQ
RETURN
END
!
!
!                                                                =======
!================================================================ QCTABL
SUBROUTINE  QCTABL
  use param
  use charac
  use aboxof
  use paramt
  use tables
  use pmorse
  use quanco
!
  implicit none
!     ------------------------------------------------------------------
!
  REAL *8  A1,A2, QSR1,QSR2, QVW1,QVW2,D2,QMS1,QMS2,BETAU
  real *4  R,AR,ARB
  integer *4  i,j
!
  IF (RUNOPT(8)  /= 'BUSING    '.AND. RUNOPT(8)  /= 'MORSE     ')  RETURN
!     ------------------------------------------- Calculation of tables
  BETAU = CAL * 1.0D10 / ANA
  DO I = 10, NRCUT(2)
    R  = REAL(I) * 0.01
    AR = 1.0 / R
    DO J = 1, LEE
      Q1U1(I,J) = 0.0
      Q2U1(I,J) = 0.0
      QSR1 = 0.0
      QSR2 = 0.0
      QVW1 = 0.0
      QVW2 = 0.0
      QMS1 = 0.0
      QMS2 = 0.0
      IF (ABS(AIJ(J)) > 1.0E-5)  THEN
!                   ----------------- Short range rep. and van der Waals
        QSR1 = 0.0
        IF (BIJ(J) > 0.0001)  THEN
          ARB = (AIJ(J) - R) / BIJ(J)
          IF (ARB > -128.0)  QSR1 = EXP(ARB)
        END IF
        QSR1 = -QSR1          * 1.0E8
        QSR2 = -QSR1 / BIJ(J) * 1.0E8
!                   -------------------------------------- Van der Waals
        QVW1 =  6.0 * CIJ(J) * AR**7 * 1.0E8
        QVW2 = -7.0 * QVW1   * AR    * 1.0E8
      END IF
      IF (RUNOPT(8) == 'MORSE     ') THEN
!                   ----------------------------------------- Morse term
        D2 = DMIJ(J) * 2.0D0
        A1 = EXP(-2.0D0*BEIJ(J)*(R-RSIJ(J)))
        A2 = EXP(-1.0D0*BEIJ(J)*(R-RSIJ(J)))
        QMS1 = D2 * BEIJ(J)    * (    -A1 + A2) *1.0E8
        QMS2 = D2 * BEIJ(J)**2 * ( 2.0*A1 - A2) *1.0E16
      END IF
      Q1U1(I,J) = ((QSR1 + QMS1) * BETAU + QVW1) * AR*1.0E8
      Q2U1(I,J) =  (QSR2 + QMS2) * BETAU + QVW2
    enddo
  enddo
RETURN
END
!
!
!                                                               ========
!================================================================ GENWAL
SUBROUTINE GENWAL
!
!     ------ General Wall at z = 0 and z = 1 ---------------------------    
!     Interaction between wall molecule and free molecule 
!                                           W(r) = -C/r**n (note: n > 3)
  use param
  use aboxof
  use atomsi
  use forces
!
  implicit none
!
  COMMON /genwap/ cpara(5),densn,ncon,npwr(5)
    REAL  *8  cpara,densn
    INTEGER  *4  ncon,npwr
!
  REAL    *8 cp(5)
  REAL    *8 Suwi(LNI),Sfwi(LNI), Uwi(LNI),Fwi(LNI)
  INTEGER *4 n2(5),n3(5)
  integer *4 i,j
!
!     --------------------------------------w(r) = C/r**n type fucntion  
  DO i = 1, NTION
    Suwi(i) = 0.0D0
    Sfwi(i) = 0.0D0
  enddo
  DO j = 1,ncon
    n3(j) = npwr(j) -3
    n2(j) = npwr(j) -2
    cp(j) = cpara(j) * (1.0D-7)**npwr(j) !nm->cm 
  enddo
  DO i = 1, NTION
    DO j=1,ncon
      Uwi(i) = -2.0D0*PI*cp(j)*densn/  &
                 (n2(j)*n3(j)*(P(3,i)*BOX(3)*1.0D-8)**n3(j)) &
                 -2.0D0*PI*cp(j)*densn/ &
                 (n2(j)*n3(j)*((P(3,i)-1.0D0)*BOX(3)*1.0D-8)**n3(j))
      Fwi(i) = -2.0D0*PI*cp(j)*densn/  &
                 (n2(j)*(P(3,i)*BOX(3)*1.0D-8)**n2(j))  &
                 -2.0D0*PI*cp(j)*densn/  &
                 (n2(j)*((P(3,i)-1.0D0)*BOX(3)*1.0D-8)**n2(j))
      Suwi(i) = Suwi(i) + Uwi(i)
      Sfwi(i) = sfwi(i) + Fwi(i)
    enddo
    FZ(I) = FZ(I) + Sfwi(i)
  enddo
RETURN
END 
!                                                               ========
!================================================================ ELECFD
SUBROUTINE  ELECFD
!
!     ------ Electric field  by  Naoya Sawaguchi[Hirao P -> Nirin] -----
!
  use param
  use counts
  use temprs
  use atomsi
  use paramt
  use forces
  use outerf
  use charge
!
  implicit none
!
  REAL  *8  FCOUNT,REFREQ,CTIME
  REAL  *8  EFDX,EFDY,EFDZ,DEE
  REAL  *8  fefx,fefy,fefz,ZZZ
  integer *4 i,mswtch
!ccccc
!     --- MEFD = mode of the electric field ---
!           0 ... Static electric field
!           1 ... ( 0 to E) pulse
!           2 ... (-E to E) pulse
!           3 ... saw tooth pulse   incomplete
!           4 ... sine oscillator
!
!         write(6,*) MEFD, EFREQ
!         write(6,*) EFD(1),EFD(2),EFD(3)
  IF (NRECRD(1)  ==  1) THEN
    MSWTCH = 1
    FCOUNT = 1.000000D0
  END IF
  IF (EFREQ  /=  0.00000D0) REFREQ = 1.000D0 / EFREQ
  CTIME = DTIME*NRECRD(1)
  IF (MEFD  ==  0) THEN
    EFDX = EFD(1)
    EFDY = EFD(2)
    EFDZ = EFD(3)
  ELSEIF (MEFD  ==  1) THEN
    IF (CTIME  >=  REFREQ*FCOUNT) THEN
      MSWTCH = -MSWTCH
      FCOUNT = FCOUNT + 1.000000D0
    END IF
    IF (MSWTCH  >  0) THEN
      EFDX = EFD(1)
      EFDY = EFD(2)
      EFDZ = EFD(3)
    ELSE
      EFDX = 0.000000D0
      EFDY = 0.000000D0
      EFDZ = 0.000000D0
    END IF
  ELSEIF (MEFD  ==  2) THEN
    IF (CTIME  >=  REFREQ*FCOUNT) THEN
      MSWTCH = -MSWTCH
      FCOUNT = FCOUNT + 1.000000D0
    END IF
    EFDX = EFD(1) * DBLE(MSWTCH)
    EFDY = EFD(2) * DBLE(MSWTCH)
    EFDZ = EFD(3) * DBLE(MSWTCH)
!         ELSEIF (MEFD  ==  3) THEN
!            FREQP4 = EFREQ / 4.000000D0
!               ExSLP = EFD(1)/FREQP4
!               EySLP = EFD(2)/FREQP4
!               EySLP = EFD(3)/FREQP4
!            IF (CTIME  >=  FREQP4*FCOUNT) THEN
!               MSWTCH = -MSWTCH
!               FCOUNT = FCOUNT + 1.000000D0
!               ExSLP = -ExSLP
!               EySLP = -EySLP
!               EySLP = -EySLP
!            END IF
!            IF (MSWTCH  >  0) THEN
!               EFDX = EFD(1)
!               EFDY = EFD(2)
!               EFDZ = EFD(3)
!            ELSE
!               EFDX = 0.000000D0
!               EFDY = 0.000000D0
!               EFDZ = 0.000000D0
!            END IF
!
  ELSEIF (MEFD  ==  4) THEN
    DEE  = SIN(PI2*EFREQ*CTIME)
    EFDX = EFD(1)*DEE
    EFDY = EFD(2)*DEE
    EFDZ = EFD(3)*DEE
!            write(6,*) EFDX,EFDY,EFDZ    ! check AC
  END IF
!
  DO I=IONS(1,NATOM),NTION
    fefx = 0.0000D0
    fefy = 0.0000D0
    fefz = 0.0000D0
!           ZIO =0, or EFD =0 then fef = 0 naturally
!           ZZZ  = ZII(I) * ELC              ! esu
    ZZZ  = ZII(I) * 1.602176462D-19   ! Coulomb
    fefx = EFDX * ZZZ
    fefy = EFDY * ZZZ
    fefz = EFDZ * ZZZ
!
    FX(I) = FX(I) + fefx
    FY(I) = FY(I) + fefy
    FZ(I) = FZ(I) + fefz
  END DO
END
!
!
!                                                               ========
!================================================================ GRAVFD
SUBROUTINE GRAVFD
!
!     ---------------------------------------------- Gravity field -----
!
  use param
  use counts
  use temprs
  use atomsi
  use paramt
  use forces
  use outerf
!
  implicit none
!
  REAL  *8  GFDX, GFDY, GFDZ
  real  *4  g,w
  integer *4 IO,i
!
!           ------ g = 9.8 m/s2 = 980 cm/s2
  g = 980.665 * 1.0E8
!
!           write(6,*) 'Gravity field ', GFD
  GFDX = GFD(1) * g
  GFDY = GFD(2) * g
  GFDZ = GFD(3) * g
!
!        write (6,*) fx(1),fy(1),fz(1)
!        write (6,*) gfdx*wio(1)/ana,gfdy*wio(1)/ana,gfdz*wio(1)/ana
  do io = 1, ncompo
    w = wio(io) / ANA
    DO  I = ions(1,io), ions(2,io)
      FX(I) = FX(I) - w * gfdx
      FY(I) = FY(I) - w * gfdy
      FZ(I) = FZ(I) - w * gfdz
   END DO
  end do
return
END
!
!
!                                                          =============
!=========================================================== Wall at z=0
SUBROUTINE  WALL
!
!     ---------------------------------------------- Gravity field -----
!
  use param
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use forces
  use wallp
  use outerf
!
  implicit none
!
  real *8 BETA
  real *4 aw, bw,riz
  integer *4 io,i
!
  BETA = CAL * 1.0D10 / ANA
!     write (6,*)  'wall',walla,wallb
!
  do io = 1, ncompo
    aw = walla + aio(io)
    bw = wallb + bio(io)
!        write (6,*) io,aw,bw
    DO  I = ions(1,io), ions(2,io)
      riz = P(3,i)*BOX(3)
      Fz(I) = Fz(I) + beta * exp((aw-riz)/bw) * 1.0E8
      UI(I) = UI(I) + beta * bw * exp((aw-riz)/bw)
    END DO
  end do
return
END
!
!
!                                                                =======
!================================================================ SCCELL
SUBROUTINE  SCCELL
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use cartes
!
  implicit none
!
!     -------------------------- Basic cell scaling for pressure control
!
!
  REAL      *8    FA(3), FK, DVOO, DVO, DFV, DAL(3), DDD
  real      *8    apxyz,aspres,flmt,dp,dpp
  integer   *4    i,j
!
  IF (RUNOPT(6) /= 'P SCALING ' .AND. RUNOPT(7) /= 'D CONST.  '     )  RETURN
!
100 APXYZ   = (PXYZ(2) + PXYZ(3) + PXYZ(4)) / 3.0D0
  APXYZ   = PXYZ(1) - APXYZ
  PXYZ(2) = PXYZ(2) + APXYZ
  PXYZ(3) = PXYZ(3) + APXYZ
  PXYZ(4) = PXYZ(4) + APXYZ
!
  ASPRES = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
  FLMT   = 1.0D0 / (1.0D0 + ASPRES/25.0D0)
  IF (VBOX(1) < 1.0D-5)  VBOX(1) = 1.0D0
  DO I = 1, 3
    DP  = PXYZ(I+1) - PPXYZ(I+1)
    DPP = PXYZ(I+1) - SPRES(I)
    IF (DP*DPP > 0.0D0)  VBOX(1) = VBOX(1) / 1.05D0
    IF (DP*DPP < 0.0D0)  VBOX(1) = VBOX(1) * 1.05D0
  enddo
!  IF (VBOX(1) < 0.2D0)   VBOX(1) = 0.2D0
  IF (VBOX(1) < 0.1D0) VBOX(1) = 0.1D0
  IF (VBOX(1) > FLMT)  VBOX(1) = FLMT
!
50 DVOO = 1.0D0
  DDD = 0.001D0 * 512.0D0
  DO I = 1, 3
    DVOO = DVOO * BOX(I)
    FK = ATAN((PXYZ(I+1) - SPRES(I))*VBOX(1)*DDD) / 512.0D0
    FA(I)  = 1.0D0 +  FK
    BOX(I) = BOX(I) * FA(I)
    DAL(I) = BOX(I)
    DO J = 1, 3
      H(J,I) = H(J,I) * FA(I)
    enddo
  enddo
  DO I = 1, 7
    PPXYZ(I) = PXYZ(I)
  enddo
!
  IF (RUNOPT(7) == 'D CONST.  ')  THEN
    DVO = DAL(1) * DAL(2) * DAL(3)
    DFV = (DVOO / DVO)**(1.0d0/3.0d0)
    DO I = 1, 3
      BOX(I) = DAL(I) * DFV
      DO J = 1, 3
        H(J,I) = H(J,I) * DFV
      enddo
    enddo
  END IF
!
  CALL  TABLER  (0)
RETURN
END
!
!
!                                                               ========
!=============================================================== RECORD9
SUBROUTINE  RECORD9
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use values
  use radial
  use acoord
  use charge
  use molecu
!
  implicit none
!
!     ------------------------------------------------- Out put FILE09's
!
  COMMON /WORK01/ VV(3,LNI), PPK(3,LNI)
  real *8  VV, PPK
  COMMON /WORK02/ IP(3,LNI), JPS(3,LNI)
  integer *4 IP,JPS
!
  REAL      *8    UIUI(LNI)
  REAL      *8    SSS
  real *8 PK,DPK
  CHARACTER *10   DUMMY
  integer *4 I,J,KON
!
  DUMMY = '          '
!     ----------------------------------------------------------- Values
  IF (NRECRD(1) == 1)  THEN
    DO  I = 1, LVA
      VAL0(I) = VAL(I)
    enddo
  END IF
  NAVT = NAVT + 1
  DO I = 1, LVA
    SSS       = VAL(I)   - VAL0(I)
    TVALL(I)  = TVALL(I) + SSS
    SVALL(I)  = SVALL(I) + SSS*SSS
    IF (VALMAX(I) < VAL(I))   VALMAX(I) = VAL(I)
    IF (VALMIN(I) > VAL(I))   VALMIN(I) = VAL(I)
  enddo
!     --------------------------------------------------- FILE09P for MD
  IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
    IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
      IF (MOD(NRECRD(1),IRECRD(4)) == 0) THEN
        NRECRD(4) = NRECRD(4) + 1
        IF (RUNOPT(18) == 'BINARY    ') THEN
          WRITE (19) NRECRD(4), BOX(1), 0.0, 0.0,  0.0, BOX(2), 0.0, 0.0, 0.0, BOX(3)
          WRITE (19) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IP(J,I)  = P(J,I) * 90000.D0
            enddo
          enddo
          WRITE (19,9001)  NRECRD(4),  BOX(1),0.0, 0.0, 0.0, BOX(2),0.0, 0.0, 0.0, BOX(3)
          WRITE (19,9002)  ((IP(J,I),J=1,3),I=1,NTION)
        END IF
!       ================================================Write on charge.dat
        IF (ICD == 1) then ! FLNAME(16) = 'charge.dat     '
!          write(*,*)'ndmole = ',ndmole
          write (26,'(i10)') nrecrd(1)
          write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
        ENDIF
!       ======================================================================
      END IF
    END IF
  END IF
!        -------------------------------------------- Coordinates for XD
  IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
    DO I = 1, NPTP
      KON = JON(I)
      DO J = 1, 3
        PK = P(J,KON)
        DPK = PK - P0C(J,I) / dble(NBOX(J))
        IF (DPK >  0.5d0)  PK = PK - 1.0d0
        IF (DPK < -0.5d0)  PK = PK + 1.0d0
        PPK(J,I) = PK
        JPS(J,I) = PK*9000
        if (jps(j,i) <= -1000)  jps(j,i)=jps(j,i)+10000
        if (jps(j,i) >= 10000)  jps(j,i)=jps(j,i)-10000
        IF (I <= NPT)  THEN
          PK = PK * NBOX(J)
          PPC(J,I) = PPC(J,I) + PK
          PPS(J,I) = PPS(J,I) + PK*PK
        END IF
      enddo
    enddo
!              ------------------------------------------ FILE09P for XD
    IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
      IF (MOD(NRECRD(1),IRECRD(4)) == 0) THEN
        NRECRD(4) = NRECRD(4) + 1
        DUMMY = 'POSITION'
        IF (RUNOPT(18) == 'BINARY    ') THEN
          WRITE (19) NRECRD(4), BOX(1), 0.0, 0.0, 0.0, BOX(2), 0.0, 0.0, 0.0, BOX(3)
          WRITE (19) ((PPK(J,I),J=1,3),I=1,NPTP)
        ELSE
          WRITE (19,9001)  NRECRD(4), BOX(1),0.0, 0.0, 0.0, BOX(2),0.0, 0.0, 0.0, BOX(3)
          WRITE (19,9002)  ((JPS(J,I),J=1,3),I=1,NPTP)
        END IF
      END IF
    END IF
  END IF
!        ------------------------------------------------------- FILE09V
  IF (MOD(NRECRD(1),IRECRD(5)) == 0) THEN
    NRECRD(5) = NRECRD(5) + 1
    IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
      WRITE (29,1991)  (VAL(I),I=1,LVA)
! 1991 FORMAT (F8.2,7F8.4   / 8F9.2  / F9.5,  F9.3,  3F9.5, 3F9.5  / 10F8.2 / 10F8.3 )
 1991 FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.7 / 20F9.3 / 20F9.3 )
    END IF
  END IF
!        ------------------------------------------------------ FILE09PV
  IF (RUNOPT(11) /= '          ')  THEN
!               NRECRD(9) = NRECRD(9) + 1
    IF (TITLE(1) == 'BENC'     .AND. TITLE(2) ==     'HMAR'     )  RETURN
    IF (RUNOPT(11) == 'VELOCITY  ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        NRECRD(9) = NRECRD(9) + 1
        IF (RUNOPT(18) == 'BINARY    ') THEN
          DO I = 1, NTION
            DO J = 1, 3
              VV(J,I) = V(J,I) / DTIME
            enddo
          enddo
          WRITE(28)  NRECRD(1)
          WRITE(28) ((VV(J,I),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IP(J,I)=V(J,I)*PVMULT*1E-15 /DTIME+50000.D0
            enddo
          enddo
          WRITE(28,9001)  NRECRD(1)
          WRITE(28,9002)((IP(J,I),J=1,3),I=1,NTION)
        END IF
      END IF
    END IF
    IF (RUNOPT(11) == 'POSITION  ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        IF (RUNOPT(18) == 'BINARY    ')  THEN
          WRITE (28) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
          WRITE (28) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IP(J,I) = P(J,I) * PVMULT
            enddo
          enddo
          WRITE(28,9001) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
          WRITE(28,9002)((IP(J,I),J=1,3),I=1,NTION)
        END IF
      END IF
    END IF
    IF (RUNOPT(11) == 'ENERGY    ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        DO I = 1, NTION
          UIUI(I) = UI(I) * PVMULT
        enddo
        WRITE(28,9001) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
        WRITE(28,9003)(UIUI(I),I=1,NTION)
      END IF
    END IF
    IF (RUNOPT(11) == 'POSVELENE ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        DO I = 1, NTION
          vv(1,i) = v(1,i)*1E-15 /DTIME
          vv(2,i) = v(2,i)*1E-15 /DTIME
          vv(3,i) = v(3,i)*1E-15 /DTIME
          UIUI(I) = UI(I) * PVMULT
        enddo
        WRITE(28,9001) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
        do i = 1, ntion
          WRITE (28,9004) (P(j,i),j=1,3),(Vv(j,i),j=1,3), UIUI(I)
        enddo
      END IF
    END IF
  END IF
!        ---------------------------------------- Pressure tensor FILE11
  IF (RUNOPT(19) == 'PRESSURE  ') WRITE (27,'(7F9.4)')  (VAL(J),J=2,8)
RETURN
!
 9001 FORMAT (I7,3x,9F7.3)
 9002 FORMAT (18I5)
 9003 FORMAT (10F8.2)
 9004 FORMAT (3F7.5,1X,3F8.6,1X,F8.4)
END
!
!
!                                                               ========
!================================================================ INTVAL
SUBROUTINE  INTVAL
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use geomet
  use values
  use radial
  use acoord
  use quanco
!
  implicit none
!     --------------------------------------- Print average values, etc.
!
!
  CHARACTER *8    SYMB(2)
  CHARACTER *21   STRING
  CHARACTER *40   FMT1(2),FMT11,FMT12, FMT2(3),FMT21,FMT22,FMT23
  EQUIVALENCE  (FMT1(1),FMT11),(FMT1(2),FMT12),(FMT2(1),FMT21),(FMT2(2),FMT22),(FMT2(3),FMT23)
  REAL    *8  TVV(LVA),TSS(LVA)
!  INTEGER *4      ISDV(11),IVMIN(11),ITSS(11),IAVA(11),ITVV(11),IVMAX(11)
  INTEGER *4      ISDV(LEM+1),IVMIN(LEM+1),ITSS(LEM+1),IAVA(LEM+1),ITVV(LEM+1),IVMAX(LEM+1)
  REAL    *8      X, Y
  real    *8      std,fl
  integer *4      i,j,mmm,nn,mm,mj,ii
  DATA  SYMB / 'MAX.  ', 'MIN.  '/
  STD(X,Y,I) = SQRT(ABS(X - Y*(Y/DBLE(I)))  / DBLE(I))
!
  NAV = NAV + 1
  DO I = 1, LVA
    TVAL(I)  = TVAL(I) + TVALL(I)
    SVAL(I)  = SVAL(I) + SVALL(I)
    SVALL(I) = STD(SVALL(I),TVALL(I),IRECRD(3))
    TVALL(I) = TVALL(I) / dble(IRECRD(3)) + VAL0(I)
    AVA(I,NAV) = TVALL(I)
  enddo
  DO I = 1, LEM
    IAVA(I) = INT(TVALL(24+I))
    ISDV(I) = INT(SVALL(24+I))
  enddo
    IAVA(LEM+1) = INT(TVALL(1))
    ISDV(LEM+1) = INT(SVALL(1))
!
  IF (RUNOPT(3) /= 'ECONOMY  ')  WRITE (16,2100)
!     ------------------------------------- Each nrecrd() step on screen
  FMT11 = '(1X,A3,I6,F7.4,1H(,3F5.2,1H),'
  FMT12 = ' F9.1,F8.1,F6.1,F9.1,F8.5 )  '
  IF (ABS(TVALL(2)) > 9.5.AND.ABS(TVALL(2)) <= 95.0) THEN
    FMT11 = '(1X,A3,I6,F7.3,1H(,3F5.1,1H),'
  ELSE IF (ABS(TVALL(2)) > 95.0)  THEN
    FMT11 = '(1X,A3,I6,F7.2,1H(,3F5.0,1H),'
  END IF
  IF (ABS(TVALL(9)) < 1.0D4.AND.ABS(TVALL(14)) < 1.0D4) THEN
    FMT12 = ' F9.2,F8.2,F6.2,F9.2,F8.5 )  '
  END IF
  WRITE (*,4001)
  WRITE (*,FMT1) 'Avr',IAVA(LEM+1),(TVALL(J),J=2,5),TVALL(9),TVALL(10),TVALL(11),TVALL(14),TVALL(17)
  WRITE (*,FMT1) 'Std',ISDV(LEM+1),(SVALL(J),J=2,5),SVALL(9),SVALL(10),SVALL(11),SVALL(14),SVALL(17)
  WRITE (*,4001)
  write (*,2400)  (ATOM(j),IAVA(j),j=1,ncompo)
2400 format (1x,'Temperatures:',8(1X,A2,':',I4)/1x,'Temperatures:',8(1X,A2,':',I4)/1x,'Temperatures:',8(1X,A2,':',I4))
  write (*,4001)
4001 FORMAT ( 80('-') )
!     --------------------------------- Each nrecrd() step on file06.dat
  FMT11 = '(I5,    5I5,F8.4,1H(,6F6.3,1H),     '
  FMT12 = ' F10.2,F9.2,2F7.2,F10.3, F9.5 )     '
  FMT21 = '(i3,3H0K+,I4,4I5,F8.4,1H(,6F6.3,1H),'
  FMT22 = ' F10.2,F9.2,2F7.2,F10.3,    F9.5 )  '
  FMT23 = '                                    '
  IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
    FMT11 = '(I5,     5I5,F8.3,1H(,6F6.2,1H),    '
    FMT21 = '(i3,3H0K+,I4,4I5,F8.3,1H(,6F6.2,1H),'
  ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
    FMT11 = '(I5,     5I5,F8.2,1H(,6F6.1,1H),    '
    FMT21 = '(i3,3H0K+,I4,4I5,F8.2,1H(,6F6.1,1H),'
  END IF
  IF (ABS(TVALL(9)) < 1.0D4.AND.ABS(TVALL(14)) < 1.0D4)  THEN
    FMT12 = ' F10.3,F9.3,2F7.3,F10.4,    F9.5 )  '
    FMT22 = ' F10.3,F9.3,2F7.3,F10.4,    F9.5 )  '
  END IF
  mmm = NRECRD(1)/100000
  WRITE (16,FMT1)  mod(NRECRD(1),100000), &
                       (IAVA(I),I=1,4),IAVA(LEM+1),(TVALL(J),J=2,11), &
                                       TVALL(13),TVALL(14),TVALL(17)
      WRITE (16,FMT2)  mmm, (ISDV(I),I=1,4), ISDV(LEM+1), &
                            (SVALL(J),J=2,11), SVALL(13), SVALL(14), &
                                               SVALL(17)
!
  NN = IRECRD(2)/IRECRD(3)
  MM = MOD(NRECRD(1)/IRECRD(3), NN)
  MJ = 2
  IF (RUNOPT(3) == 'ECONOMY  ') MJ = 10
  IF (MOD(MM,MJ) /= 0)  RETURN
!
  DO I = 1, LVA
    TSS(I) = STD(SVAL(I),TVAL(I),NAVT)
    TVV(I) = TVAL(I) / REAL(NAVT) + VAL0(I)
  enddo
  DO I = 1, LEM
    IVMAX(I) = INT(VALMAX(24+I))
    IVMIN(I) = INT(VALMIN(24+I))
    ITSS(I)  = INT(TSS(24+I))
    ITVV(I)  = INT(TVV(24+I))
  enddo
  IVMAX(LEM+1) = INT(VALMAX(1))
  IVMIN(LEM+1) = INT(VALMIN(1))
  ITSS(LEM+1)  = INT(TSS(1))
  ITVV(LEM+1)  = INT(TVV(1))
!
!        --------------------------------------------------- Min and max
  WRITE (16,2105)
  FMT11 = '(1X,A4, 5I5,F8.4,1H(,6F6.3,1H), '
  IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
    FMT11 = '(1X,A4, 5I5,F8.3,1H(,6F6.2,1H), '
  ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
    FMT11 = '(1X,A4, 5I5,F8.2,1H(,6F6.1,1H), '
  END IF
  WRITE (16,FMT1)  SYMB(1), (IVMAX(I),I=1,4),IVMAX(LEM+1),(VALMAX(J),J= 2,11),  &
                   VALMAX(13),VALMAX(14),VALMAX(17)
  WRITE (16,FMT1)  SYMB(2), (IVMIN(I),I=1,4),IVMIN(LEM+1),(VALMIN(J),J= 2,11),  &
                   VALMIN(13),VALMIN(14),VALMIN(17)
!        ------------------------------ Each nrecrd() step in file06.dat
  FMT11 = '(I5,5I5,F8.4,1H(,6F6.3,1H),        '
  IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
    FMT11 = '(I5,5I5,F8.3,1H(,6F6.2,1H),        '
  ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
    FMT11 = '(I5,5I5,F8.2,1H(,6F6.1,1H),        '
  END IF
  mmm = NAVT / 100000
  WRITE (16,2105)
  WRITE (16,FMT1)  mod(NAVT,100000), (ITVV(I),I=1,4),ITVV(LEM+1),  &
                   (TVV(J),J=2,11),TVV(13),TVV(14),TVV(17)
  WRITE (16,FMT2)  mmm,  (ITSS(I),I=1,4),ITSS(LEM+1),  &
                   (TSS(J),J=2,11),TSS(13),TSS(14),TSS(17)
  WRITE (16,2105)
  if (NCOMPO > 4) then
    write (16,2500)  (ATOM(j),TVV(24+j),j=1,ncompo)
 2500          format (' Temperatures:',10(2X,A2,':',F6.1))
    WRITE (16,2105)
  end if
  if(runopt(35) == 'ISOLATED  ') then 
    ECORR=0.0D0
    VCORR=0.0D0
  endif
  WRITE (16,2880)  VCORR/(3.0D0*VOL*1.0D-24)*1.0D-10,ECORR*FJMOL
 2880    FORMAT (8X,'Corrections for van der Waals interactions ', &
                 '(approx.) : Pcorr=',F8.4,' GPa',9X,'Ecorr(short)=', &
                F8.3,' kJ/mol')
  IF (RUNOPT(12) == 'QUANTUM   ')  THEN
    WRITE (16,2990)  TEMPQH/NAVT
 2990          FORMAT (8X,'Effective temperature in quantum correction',' is ',F7.2, ' K')
  END IF
  WRITE (16,2105)
!
!     ------------------------------------------ Basic cell edge lengths
  WRITE (16,'(1X)')
  WRITE (16,'("I",74("-"),"I")')
  STRING = '[ MD basic cell ]    '
  IF (RUNOPT(17) == 'CRYSTAL   ')  STRING = '[ crystal unit cell ]'
  WRITE (16,4000)  STRING,(TVALL(I),  SVALL(I),  VALMIN(I),  VALMAX(I),I=19,21)
 4000 FORMAT ('I Cell dimensions (Angstrom, degree)',10X,A21,8X,'I' &
             /'I    A:', F9.5,' (+-',F7.5,') ',F9.5,' -',F9.5,5X, &
                                           'Alpha: 90.0 (fixed)  I', &
             /'I    B:', F9.5,' (+-',F7.5,') ',F9.5,' -',F9.5,5X, &
                                           'Beta : 90.0 (fixed)  I', &
             /'I    C:', F9.5,' (+-',F7.5,') ',F9.5,' -',F9.5,5X, &
                                           'Gamma: 90.0 (fixed)  I' )
!     --------------------------------------------------------- Energies
  WRITE (16,'("I",74("-"),"I")')
  WRITE (16,4030)  TVV(12),TSS(12), TVV(14),TSS(14), &
                       TVV(13),TSS(13), TVV(16),TSS(16), &
                       TVV(15),TSS(15), TVV(18),TSS(18)
 4030 FORMAT ('I  U =',F11.4, '(',F7.4,')kJ/mol   E = U+K =',F12.4, &
                               '(',F7.4,')kJ/mol    I' / &
              'I  K =',F11.4, '(',F7.4,')kJ/mol   H = E+PV=',F12.4, &
                               '(',F7.4,')kJ/mol    I' / &
              'I  PV=',F11.4,'(',F7.4,')kJ/mol   ', &
                   'Molar volume=',F10.4,'(',F7.4,')cm3/mol I')
  WRITE (16,'("I",74("-"),"I")')
!     ---------------------------------------- Mean square displacements
  FL = 1
  DO I = 1, 10
    IF (VALMAX(I+24+LEM) >= 10.0)   FL = 10
    IF (VALMAX(I+24+LEM) >= 100.0)  FL = 100
    IF (VALMAX(I+24+LEM) >= 100.0)  FL = 1000
  enddo
  FMT21 = '("I M.s.d.",                        '
  FMT22 = '2(3X,A2, ":", F6.3, "(", F5.3,")",  '
  FMT23 = ' F6.3,"-", F6.3,1X), " I" )         '
  IF (FL >= 10) THEN
    FMT22 = '2(3X,A2, ":", F6.2, "(", F5.2,")",  '
    FMT23 = ' F6.2,"-", F6.2,1X), " I" )         '
  END IF
  IF (FL >= 100) THEN
    FMT22 = '2(3X,A2, ":", F6.1, "(", F5.2,")",  '
    FMT23 = ' F6.1,"-", F6.1,1X), " I" )         '
  END IF
  WRITE (16,FMT2)  (ATOM(I),TVALL(I+24+LEM),SVALL(I+24+LEM),VALMIN(I+24+LEM),VALMAX(I+24+LEM),I=1,2)
  FMT21 = '("I       ",                       '
  DO II = 1, 4
    IF (NCOMPO > II*2)  WRITE (16,FMT2)  (ATOM(I),TVALL(I+24+LEM), &
                       SVALL(I+24+LEM),VALMIN(I+24+LEM),VALMAX(I+24+LEM),I=II*2+1,II*2+2)
  enddo
  WRITE (16,'("I",74("-"),"I")')
!     ------------------------------------------------------------------
  DO I = 1, LVA
    VALMIN(I) = 9.9D19
    VALMAX(I) =-9.9D19
  enddo
RETURN
!
 2100 FORMAT (132('-'))
 2105 FORMAT (132('='))
END
!
!
!                                                               ========
!     =========================================================== SUMMRY
SUBROUTINE  SUMMRY
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use values
  use radial
  use acoord
!
  implicit none
!
!     --------------------------------------- Print average values, etc.
!
  CHARACTER *8    HEAD(2)
  CHARACTER *40   FMT1(2),FMT11,FMT12
  EQUIVALENCE     (FMT1(1),FMT11), (FMT1(2),FMT12)
  REAL    *8  X, Y
  real    *8  std,ava2i,tval2
  integer *4  i,j,ii
  DATA  HEAD / 'AVE' , 'SGM'/
  
!
  STD(X,Y,I) = SQRT(ABS(X - Y*(Y/DBLE(I)))  / DBLE(I))  !statement function
!
  IF (IRECRD(1) <= 0)  RETURN
!
  WRITE (16,2000)
  WRITE (16,2100)
  WRITE (16,2452)
 2452 FORMAT (' NS   Temp   P/GPa (  Pxx,  Pyy,  Pzz,  Pxy,  ', &
              'Pxz,  Pyz )  U:Coulomb   Short 3-body Kinet.  ', &
              'Total   Density    Cell parameters (A)')
  WRITE (16,2100)
  DO I = 1, NAV
    AVA2I = ABS(AVA(2,I))
    FMT11 = '(I4, F7.1, F8.4,1H(,6F6.3,1H),          '
    FMT12 = 'F10.2,F9.2,2F7.2,F9.2, F8.5,1X,3F8.4)   '
    IF (AVA2I > 9.0 .AND. AVA2I < 95.0)  THEN
      FMT11 = '(I4, F7.1, F8.3,1H(,6F6.2,1H),          '
    ELSE IF (AVA2I >= 95.0)  THEN
      FMT11 = '(I4, F7.1, F8.2,1H(,6F6.1,1H),          '
    END IF
    IF (ABS(AVA(9,I)) < 1.0D4.AND.ABS(AVA(14,I)) < 1.0D4)  THEN
      FMT12 = 'F10.3,F9.3,2F7.3,F9.3, F8.5,1X,3F8.4)   '
    END IF
    WRITE (16,FMT1)  I,(AVA(J,I),J=1,11), AVA(13,I), AVA(14,I), AVA(17,I),(AVA(J,I),J=19,21)
  enddo
!
  DO I = 1, LVA
    SVAL(I) = STD(SVAL(I),TVAL(I),NAVT)
    TVAL(I) = TVAL(I) / dble(NAVT) + VAL0(I)
  enddo
  WRITE (16,2100)
!
  TVAL2 = ABS(TVAL(2))
  FMT11 = '(1X,A3, F7.1, F8.4,1H(,6F6.3,1H),    '
  FMT12 = 'F10.2,F9.2,2F7.2,F9.2, F8.5,1X,3F8.4)'
  IF (TVAL2 > 9.0 .AND. TVAL2 < 95.0)  THEN
    FMT11 = '(1X,A3, F7.1, F8.3,1H(,6F6.2,1H),    '
  ELSE IF (TVAL2 >= 95.0)  THEN
    FMT11 = '(1X,A3, F7.1, F8.2,1H(,6F6.1,1H),    '
  END IF
  IF (ABS(TVAL(9)) < 1.0D4.AND.ABS(TVAL(14)) < 1.0D4)  THEN
    FMT12 = 'F10.3,F9.3,2F7.3,F9.3, F8.5,1X,3F8.4)'
  END IF
  WRITE (16,FMT1)  HEAD(1),(TVAL(J),J=1,11),TVAL(13),TVAL(14),TVAL(17),(TVAL(J),J=19,21)
  WRITE (16,FMT1)  HEAD(2),(SVAL(J),J=1,11),SVAL(13),SVAL(14),SVAL(17), (SVAL(J),J=19,21)
  WRITE (16,2100)
!     --------------------------------------------------------- Energies
  WRITE (16,'(1X)')
  WRITE (16,'("I",75("-"),"I")')
  WRITE (16,4030)  TVAL(12),SVAL(12), TVAL(14),SVAL(14),  &
                       TVAL(13),SVAL(13), TVAL(16),SVAL(16), &
                       TVAL(15),SVAL(15), TVAL(18),SVAL(18)
 4030 FORMAT ('I  U =',F11.4, '(',F7.4,')kJ/mol   E = U+K =',F12.4, &
                               '(',F7.4,')kJ/mol     I' / &
              'I  K =',F11.4, '(',F7.4,')kJ/mol   H = E+PV=',F12.4, &
                               '(',F7.4,')kJ/mol     I' / &
              'I  PV=',F11.4,'(',F7.4,')kJ/mol   ', &
                   'Molar volume=',F10.4,'(',F7.4,')cm3/mol  I')
  WRITE (16,'("I",75("-"),"I")')
!     ----------------------------------------------------------- M.s.d.
  WRITE (16,4020)  (ATOM(I),TVAL(I+24+LEM),SVAL(I+24+LEM),I=1,2)
 4020 FORMAT ('I  Mean sq.disp. ',2(5X,A2,':',F8.3,' (+-',F6.3,')'),'     I' )
  DO II = 1, 4
    IF (NCOMPO > II*2)  WRITE (16,4022)  (ATOM(I),TVAL(I+24+LEM),SVAL(I+24+LEM),I=II*2+1,II*2+2)
 4022    FORMAT ('I',16X,2(5X,A2,':',F8.3,' (+-',F6.3,')'),5X,'I' )
  enddo
  WRITE (16,'("I",75("-"),"I")')
!     ------------------------------------------------------------------
  WRITE (16,4050)  TVAL(1), TVAL(2), TVAL(12),TVAL(13),TVAL(14), &
                       TVAL(15),TVAL(16),TVAL(17),TVAL(18), &
                       SVAL(1), SVAL(2), SVAL(12),SVAL(13),SVAL(14), &
                       SVAL(15),SVAL(16),SVAL(17),SVAL(18), &
                       TVAL(1),TVAL(2),(TVAL(I),I=19,24), &
                       SVAL(1),SVAL(2),(SVAL(I),I=19,24)
 4050 FORMAT (/ 78('=') / '  T/K    P/GPa   U/kJ/m.  K/kJ/m.  E(U+K) ', &
             '   PV      H(E+PV)  D/g/cm3  V/c3/m ' / 78('-') / &
             1X,F6.1,F8.4, F10.3,F8.3,F10.3,F8.3,F10.3, F8.4,F8.3,1X / &
             1X,F6.1,F8.4, F10.3,F8.3,F10.3,F8.3,F10.3, F8.4,F8.3,1X / &
             78('=') / '  T/K    P/GPa        A         B         C  ', &
                        '    Alpha     Beta      Gamma' / 78('-') / &
             1X,F6.1,F8.4,1X,3F10.5,3F10.4 / &
             1X,F6.1,F8.4,1X,3F10.5,3F10.4 / 78('=') )
RETURN
 2000 FORMAT (1X)
 2100 FORMAT (132('-'))
END
!
!
!                                                               ========
!================================================================ PCFRCN
SUBROUTINE  PCFRCN
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use radial
!
  implicit none
!
!     -------------------------------------- Pair correlation functions,
!                                          Running coordination numbers,
!
  CHARACTER *40   FORM1, FORM2, FORM3, FORM4
  REAL  *4    PCF(LEF),RHO(LEF),RCN(LEF),PATOM(LEF)
  INTEGER   *4    KRCN(LEF),KPCF(LEF)
  INTEGER   *4    IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  integer   *4    IMULT,I,J,L,IND,IEND,K
  real  *4    AM,EI,EJ,R1,R2,VS,PRN,PRD
!
!     --------------------------------------- Print pair-RDF's and RCN's
!         IPRDF(1) : Interval of printing RDF's (0.001*IPRDF(1))
!         IPRDF(2) : End of printing RDF's (IPRDF(2)*0.01 Angstroms)
!
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  WRITE (16, 1111)  NJOB,TITLE, NRECRD(2), IHOUR,IMINUT,ISECND,IYEAR,IMONTH,IDAY
 1111 FORMAT (//'<<<',I4,'-',I2,'  >>>  ',15A4,' <<< ',I5,  &
               ' steps  >>>   at ',I2,':',I2,':',I2, &
                           '  on ',I2,'/',I2,'/',I2 )
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  IMULT = 100
  IF (NCOMPO <= 2) THEN
    IMULT = 1
    FORM1 = '(7X,         3(7X,A2,1H-,A2,2X))        '
    FORM2 = '(7H R /A  ,  3(14H    pcf  rcn  )     ) '
    FORM3 = '(1X,F5.3,1X, 3(F8.3,F6.3),F6.2)         '
    FORM4 = '(50(1H-)                              ) '
  ELSE IF (NCOMPO == 3)  THEN
    IMULT = 1
    FORM1 = '(7X,         6(6X,A2,1H-,A2,1X))        '
    FORM2 = '(7H R /A  ,  6(12H    pcf rcn )       ) '
    FORM3 = '(1X,F5.3,1X, 6(F7.2,F5.2),F6.2)         '
    FORM4 = '(80(1H-)                              ) '
  ELSE IF (NCOMPO == 4)  THEN
    FORM1 = '(7X,         10(5X,A2,1H-,A2))          '
    FORM2 = '(7H R /A  ,  10(10H   pcf rcn)        ) '
    FORM3 = '(1X,F5.3,1X, 10(I6,I4),F6.2)            '
    FORM4 = '(108(1H-)                             ) '
  ELSE IF (NCOMPO == 5)  THEN
    FORM1 = '(7X,         15(3X,A2,1H-,A2))          '
    FORM2 = '(7H R /A  ,  15(8H pcf rcn)        )    '
    FORM3 = '(1X,F5.3,1X, 15(I4,I4),F6.2)            '
    FORM4 = '(127(1H-)                             ) '
  ELSE IF (NCOMPO >= 6)  THEN
    IMULT = 10
    FORM1 = '(6X,        21(1X,A2,1H-,A2))           '
    FORM2 = '(6H R /A ,  21(6H pc cn)         )      '
    FORM3 = '(1X,F5.3,   21(I3,I3),F6.2)             '
    FORM4 = '(133(1H-)                             ) '
  END IF
!
  WRITE (16,2500)  IMULT
 2500 format (/ 'Pair correlation functions (pcf) and running ',  &
               'oordination numbers (rcn) of ion pairs ',  &
                '(multiplied by ',I4,')' /)
  IF (NCOMPO <= 6)  THEN
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,NCOMPO)
  ELSE
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,6)
  END IF
  WRITE (16,FORM2)
  WRITE (16,FORM4)
  L = 0
  DO I = 1, NCOMPO
    DO J = 1, I
      L = L + 1
      AM = 1.0
      IF (I == J)  AM = 0.5
      EI = REAL(NION(I))
      EJ = REAL(NION(J))
      RCN(L)   = 0.0
      PATOM(L) = AMIN1(EI,EJ) * AM
      RHO(L)   = EI * EJ * AM /(BOX(1)*BOX(2)*BOX(3))
    enddo
  enddo
  IND  = 0
  I    = 10
  IEND = IPRDF(2)
!
280 R1 = REAL(I)* 0.01 + 0.005*IPRDF(1)
  R2 = R1 + 0.01*IPRDF(1)
  VS = 4.0*PI/3.0 * ((R2*R2*R2) - (R1*R1*R1))
  PRN = 0
  DO L = 1, NPAIR
    PCF(L) = 0.0
    IF (PATOM(L) > 1.0E-6) THEN
      PRD = 0.0
      DO K = 1, IPRDF(1)
        PRD = PRD + NRDF(I+K,L)
      enddo
      PRN    = PRN + PRD
      PRD    = PRD / REAL(NRECRD(2)/irecrd(5))
      RCN(L) = RCN(L) + PRD / PATOM(L)
      PCF(L) = PRD / (VS * RHO(L))
    END IF
  enddo
  DO L = 1, LEE
    KRCN(L) = INT(RCN(L) * IMULT + 0.5)
    KPCF(L) = INT(PCF(L) * IMULT + 0.5)
  enddo
  IF (PRN > 0.5.AND.IND == 0)  THEN
    IND  = 1
    IF (IEND > 9990)  IEND = I + 250
  END IF
  IF (IND == 1) THEN
    IF (NCOMPO <= 3)  THEN
      WRITE (16,FORM3) R1+0.01,(PCF(K),RCN(K),K=1,NPAIR)
    ELSE IF (NCOMPO <= 6)  THEN
      WRITE (16,FORM3) R1+0.01,(KPCF(K),KRCN(K),K=1,NPAIR)
    ELSE
      WRITE (16,FORM3) R1+0.01,(KPCF(K),KRCN(K),K=1,21)
    END IF
  END IF
  I = I + IPRDF(1)
  IF (I < IEND)  GO TO 280
  WRITE (16,FORM4)
  WRITE (16,FORM2)
  IF (NCOMPO <= 6)  THEN
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,NCOMPO)
  ELSE
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,6)
  END IF
!
RETURN
END
!
!
!                                                               ========
!================================================================ POTPLT
SUBROUTINE  POTPLT
  use param
  use charac
  use counts
  use atomsi
!
  implicit none
!
!     ------------------------------------ Distribution of ion potential
!
!
  CHARACTER *1    IGRAPH(132)
  REAL  *8    BU(LNI),UMAX(LEM),UMIN(LEM),UAV(LEM)
  real  *8    RNDF,AMAX,AMIN,UR,UOMIN,UOMAX
  INTEGER   *4    NSTAT(132,LEM)
  integer *4  IO,I1,I2,I,J,IAMIN,IAMAX,MUP,J1,J2,JU,N,NP,K,IOMIN,IOMAX
!
!     ------------------------------------------------- Ionic potentials
!
  RNDF = 1.0D12 / DBLE(IRECRD(2))
  AMAX = -9.9D19
  AMIN =  9.9D19
  DO IO = 1, NCOMPO
    UMAX(IO) = 0.0
    UMIN(IO) = 0.0
    UAV(IO)  = 0.0
    IF (IION(IO) <= -999)  cycle
    IF (NION(IO) > 0) THEN
      UMAX(IO) = -9.9D19
      UMIN(IO) =  9.9D19
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      DO I = I1, I2
        BU(I)   = AU(I) * RNDF
        UAV(IO) = UAV(IO) + BU(I)
        IF (UMAX(IO) < BU(I))  UMAX(IO) = BU(I)
        IF (UMIN(IO) > BU(I))  UMIN(IO) = BU(I)
      enddo
      UAV(IO) = UAV(IO) / DBLE(NION(IO))
      IF (AMAX < UMAX(IO))  AMAX = UMAX(IO)
      IF (AMIN > UMIN(IO))  AMIN = UMIN(IO)
      GO TO 160
    ELSE
      UMAX(IO) = 0.0D0
      UMIN(IO) = 0.0D0
    END IF
160 DO J = 1, 132
      NSTAT(J,IO) = 0
    enddo
  enddo
  WRITE (16,4004)
  WRITE (16,4001)
  WRITE (16,4000)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=1,6)
  IF (NCOMPO > 6)  THEN
    WRITE (16,4002)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=7,9)
    IF (NCOMPO > 9)  THEN
      WRITE (16,4003)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=7,9)
    END IF
  END IF
!     ----------------------------------------------- Plot whole of ions
  IAMIN = INT(AMIN - 0.999999D0)
  IAMAX = INT(AMAX)
  IF (AMAX > 0.0D0)  IAMAX = INT(AMAX + 0.999999D0)
  IF (IAMAX-IAMIN > 1) then 
    UR = 131.0D0 / DBLE(IAMAX - IAMIN)
  ELSE
    UR = 0.0d0
  ENDIF
  MUP = 0
  DO IO = 1, NCOMPO
    IF (IION(IO) <= -999) cycle
    IF (NION(IO) <= 0)  cycle
    J1 = IONS(1,IO)
    J2 = IONS(2,IO)
    DO J = J1, J2
      JU = (BU(J) - DBLE(IAMIN)) * UR + 1.5D0
      NSTAT(JU,IO) = NSTAT(JU,IO) + 1
    enddo
    DO J = 1, 132
      IF (MUP < NSTAT(J,IO))  MUP = NSTAT(J,IO)
    enddo
  enddo
  IF (MUP > 20)  MUP = 20
  DO N = 1, MUP
!         WRITE (16,4004)
    NP = MUP + 1 - N
!         DO 420  I = 1, NCOMPO
    DO J = 1, 132
      IGRAPH(J) = ' '
    enddo
    IGRAPH(1)   = ':'
    IGRAPH(132) = ':'
    DO J = 1, 132
      DO I = 1, NCOMPO
        IF (IION(I) > -998)  THEN
          IF (NSTAT(J,I) >= NP)  IGRAPH(J) = ATOM(I)
        END IF
      enddo
    enddo
    WRITE (16, 4010)  (IGRAPH(K), K=1,132)
!  420 continue
  enddo
  WRITE (16, 4020) IAMIN, IAMAX
  IF (NION(1) <= 1)  RETURN
!     ---------------------------------------- Oxygen ion potential only
  DO I = 1, 132
    NSTAT(I,1) = 0
  enddo
  UOMIN = UMIN(1)
  UOMAX = UMAX(1)
  IOMIN = UOMIN - 0.999999D0
  IOMAX = UOMAX
  IF (UOMAX > 0.0D0)  IOMAX = INT(UOMAX + 0.999999D0)
  UR = 131.0D0 / dble(IOMAX - IOMIN)
  MUP = 0
  J1 = IONS(1,1)
  J2 = IONS(2,1)
  DO J = J1, J2
    JU = (BU(J) - IOMIN) * UR + 1.5D0
    IF (JU < 1)  JU = 1
    NSTAT(JU,1) = NSTAT(JU,1) + 1
  enddo
  DO J = 1, 132
    IF (MUP < NSTAT(J,1))  MUP = NSTAT(J,1)
  enddo
  IF (MUP > 20)  MUP = 20
  DO N = 1, MUP
    NP = MUP + 1 - N
    DO J = 1, 132
      IGRAPH(J) = ' '
    enddo
    IGRAPH(1)   = ':'
    IGRAPH(132) = ':'
    DO J = 1, 132
      IF (NSTAT(J,1) >= NP)  IGRAPH(J) = ATOM(1)
    enddo
    WRITE (16, 4010)  (IGRAPH(K), K=1,132)
  enddo
  WRITE (16, 4020) IOMIN, IOMAX
!
 4001 FORMAT ('I',130('-'),'I')
 4000 FORMAT ('I Distribution of ion potentials', &
                         3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I' &
              /'I', 17X,'(*1.0E-12 erg)', &
                         3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4002 FORMAT ('I',31X,  3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4003 FORMAT ('I',31X,  3X,1(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4004 FORMAT (1X)
 4010 FORMAT (132A1)
 4020 FORMAT ('I---<',I5,1X, 110('-'), I5,' >---I' )
RETURN
END
!
!
!                                                               ========
!================================================================ COORDN
SUBROUTINE  COORDN
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use acoord
!
  implicit none
!
!     ---------- Comparison between MD derived atomic coordinartes and
!                                                crystallographic data
!
!
  REAL *8         XYZ(3,LAT),SXYZ(3,LAT)
  REAL *8         SSS, DDD
!     INTEGER   *4    IPSS(3,LAT)
  CHARACTER *4    HEX
  real *8      RMR,DXX,DYY,DZZ,SX,SY,SZ,PXO,PYO,PZO,DHY,DHX,DX,DY,DZ
  real *8      P00(3,LNI),XYZ0(3,LNI),PCC(3,LNI),PSS(3,LNI)
  real *8      SXI,SYI,DXI,DYI,XO,YO,ZO,P0CJI
  integer *4   IND,I,IN1,JD,J,KS1,KS,NT,IUT,IU,NO,JO,IN2,JS,IS,NL
  integer *4   IU1,IU2,ICLJ
!
  IND = 0
  HEX = '    '
  IF (IHEX == 1)  HEX = 'HEX'
  IF (RUNOPT(3) == 'DETAIL    '.OR.MOD(IRECRD(2),100) == 0) WRITE (16,3003)  NJOB, TITLE
  WRITE (16,3020)  NSYM, HEX, (BOX(I)/NBOX(I),NBOX(I),I=1,3)
  IN1 = 1
  RMR = 1.0 / REAL(NRECRD(2))
  DO I = 1, NPT
!         JO = JON(I)
    JD = INT(P0C(1,I)) +INT(P0C(2,I)) +INT(P0C(3,I))
    IF (JD >= 1.0)  IND = 1
    DO J = 1, 3
      P00(J,I) = P0C(J,I)
      SSS = PPS(J,I)
      DDD = PPC(J,I)
      PSS(J,I) = SQRT(ABS(SSS-DDD**2*RMR)*RMR)
      PCC(J,I) = PPC(J,I) * RMR
    enddo
  enddo
!
  DO KS1 = 1, 2
    KS  = KS1 - 1
    WRITE (16,3030)
    NT  = 0
    IUT = 0
    DO IU = 1, MATM
      IF (NIU(IU) <= 0)  cycle
      NT  = NT  + NIU(IU)
      IUT = IUT + 1
      DXX = 0.0
      DYY = 0.0
      DZZ = 0.0
      SX = 0.0
      SY = 0.0
      SZ = 0.0
      NO = 0
      DO I = IN1, NPT
        IF (JON(I) > NT)  GO TO 570
        JO = JON(I)
        JD = INT(P0C(1,I)) +INT(P0C(2,I)) +INT(P0C(3,I))
        IF (KS == 0.AND.JD >= 1)  cycle
        IF (KS == 1.AND.JD < 1)  cycle
        IN2 = I
        JS = MOD(ISYM(JO),200)
        IS = MOD(JS,NSYM)
        IF (IS <= 0)  IS = NSYM
        PXO = P00(1,I)
        PYO = P00(2,I)
        PZO = P00(3,I)
        IF (HEX /= 'HEX '.AND.HEX /= 'HEXR')  GO TO 540
        NL = 1
        IF (HEX == 'HEXR')  NL = 3
        IF (JS > NL*NSYM)  THEN
          PYO = PYO - 0.5
          IF (PYO < 0.0)  PYO = PYO + 1.0
          PXO = PXO + 0.5
          IF (PXO >= 1.0)  PXO = PXO - 1.0
          PCC(2,I) = PCC(2,I) - 0.5
          DHY = PCC(2,I) - PYO
          IF (DHY < -.5)  PCC(2,I) = PCC(2,I)+1.0
          PCC(1,I) = PCC(1,I) + 0.5
          DHX = PCC(1,I) - PXO
          IF (DHX >= 0.5)  PCC(1,I) = PCC(1,I)-1.0
        END IF
        PYO = PYO * 2.0
        IF (PYO >= 1.0)  PYO = PYO - 1.0
        PXO = PXO + PYO * 0.5
        IF (PXO >= 1.0)  PXO = PXO - 1.0
        PCC(2,I) = PCC(2,I) * 2.0
        DHY = PCC(2,I) - PYO
        IF (DHY >= 0.5)  PCC(2,I) = PCC(2,I) - 1.0
        PCC(1,I) = PCC(1,I) + PCC(2,I) * 0.5
        DHX = PCC(1,I) - PXO
        IF (DHX >= 0.5)  PCC(1,I) = PCC(1,I) - 1.0
        DX = PCC(1,I) - PXO
        DY = PCC(2,I) - PYO
        DZ = PCC(3,I) - PZO
        DZZ = DZZ + DZ * RS(3,3,IS)
        SZ  = SZ + ABS(PSS(3,I))
        SXI = PSS(1,I)
        SYI = PSS(2,I)
        IF (ABS(RS(1,1,IS)*RS(2,1,IS)) > 0.5) GO TO 10
        IF (ABS(RS(1,1,IS)) >= 0.5)  THEN
          DXI = DX * RS(1,1,IS)
          DYI = (DY - DXI*RS(1,2,IS)) * RS(2,2,IS)
          GO TO 20
        END IF
        DYI = DX * RS(2,1,IS)
        DXI = (DY - DYI * RS(2,2,IS)) * RS(1,2,IS)
        GO TO 20
10      IF (ABS(RS(1,2,IS)) >= 0.5)  THEN
          DXI = DY * RS(1,2,IS)
          DYI = (DX - DXI * RS(1,1,IS)) * RS(2,1,IS)
          GO TO 20
        END IF
        DYI = DY * RS(2,2,IS)
        DXI = (DX - DYI * RS(2,1,IS)) * RS(1,1,IS)
20      DXX = DXX + DXI
        DYY = DYY + DYI
        SX  = SX  + SXI
        SY  = SY  + SYI
        GO TO 545
540     DX = PCC(1,I) - PXO
        DY = PCC(2,I) - PYO
        DZ = PCC(3,I) - PZO
        DXX = DXX + DX*RS(1,1,IS) + DY*RS(2,1,IS) + DZ*RS(3,1,IS)
        DYY = DYY + DX*RS(1,2,IS) + DY*RS(2,2,IS) + DZ*RS(3,2,IS)
        DZZ = DZZ + DX*RS(1,3,IS) + DY*RS(2,3,IS) + DZ*RS(3,3,IS)
        SX= SX+ ABS(PSS(1,I)*RS(1,1,IS)) + ABS(PSS(2,I)*RS(2,1,IS)) + ABS(PSS(3,I)*RS(3,1,IS))
        SY= SY+ ABS(PSS(1,I)*RS(1,2,IS)) + ABS(PSS(2,I)*RS(2,2,IS)) + ABS(PSS(3,I)*RS(3,2,IS))
        SZ= SZ+ ABS(PSS(1,I)*RS(1,3,IS)) + ABS(PSS(2,I)*RS(2,3,IS)) + ABS(PSS(3,I)*RS(3,3,IS))
545     NO = NO + 1
        IF (JS /= 1)  cycle
        XO = PXO
        YO = PYO
        ZO = PZO
      enddo
570   XYZ(1,IU) = XO + DXX / REAL(NO)
      XYZ(2,IU) = YO + DYY / REAL(NO)
      XYZ(3,IU) = ZO + DZZ / REAL(NO)
      SXYZ(1,IU) = SX / REAL(NO)
      SXYZ(2,IU) = SY / REAL(NO)
      SXYZ(3,IU) = SZ / REAL(NO)
      XYZ0(1,IU) = XO
      XYZ0(2,IU) = YO
      XYZ0(3,IU) = ZO
!             WRITE (16,3060)  IU,ATMXTL(IU),(XYZ(J,IU),J=1,3),
!    *                         (SXYZ(J,IU),J=1,3),(XYZ0(J,IU),J=1,3)
      IF (RUNOPT(3) /= 'DETAIL    '.AND.MOD(IRECRD(2),100) /= 0) GO TO 580
!                  DO 575  I = IN1, IN2
!                      DO 575  J = 1, 3
!                          IPSS(J,I) = PSS(J,I) * 1000.0
! 575              CONTINUE
!                  WRITE (16,3030) (JON(I), (PCC(J,I),IPSS(J,I),J=1,3),
!    *                                      I=IN1,IN2)
580   IN1 = IN2 + 1
    enddo
!
    IU1 = 1
    IU2 = 4
601 IF (IU2 > IUT)  IU2 = IUT
    WRITE (16,3066) (ATMXTL(IU),XYZ(1,IU),SXYZ(1,IU),XYZ0(1,IU),IU=IU1,IU2)
    WRITE (16,3067) (XYZ(2,IU),SXYZ(2,IU),XYZ0(2,IU),IU=IU1,IU2)
    WRITE (16,3067) (XYZ(3,IU),SXYZ(3,IU),XYZ0(3,IU),IU=IU1,IU2)
    IU1 = IU2 + 1
    IU2 = IU1 + 3
    IF (IU1 > IUT)  GO TO 660
    GO TO 601
!
660 IF (IND == 0)  RETURN
    IN1 = NPT / 2 + 1
    DO I = IN1, NPT
      JO = JON(I)
      JD = INT(P0C(1,I)) + INT(P0C(2,I)) + INT(P0C(3,I))
      IF (JD < 1)  cycle
      DO J = 1, 3
        ICLJ = 2
        IF (NBOX(J) < 2)  ICLJ = 1
        P0CJI    = P0C(J,I)
        P00(J,I) = P0CJI - REAL(ICLJ - 1)
        PCC(J,I) = PPC(J,I) * RMR - REAL(ICLJ - 1)
      enddo
    enddo
  enddo
!
 3003 FORMAT (/'***',I4,'-',I2,'  ***  ',15A4,'  ***')
 3020 FORMAT (/'AVERAGE COORDINATES, (STANDARD DEVIATIONS, A^2) AND ', &
               'EXPERIMENTAL ONES  (NO.SYMM.=',I3,1X,A4,') ', &
                 3(F8.4,'(X',I2,')') )
 3030 FORMAT (4(2X,I3,F6.3,'(',I2,')',F5.3,'(',I2,')',F5.3,'(',I2,')'))
 3060 FORMAT (I3,1X,A4,1X,3F7.4,' (',3F6.4,') ',3F7.4)
 3066 FORMAT (4(4X,A4,F7.4,' (',F6.4,') ',F7.4) )
 3067 FORMAT (   4(8X,F7.4,' (',F6.4,') ',F7.4) )
RETURN
END
!

!                                                               ========
!=============================================================  FIND_H2O
SUBROUTINE  FIND_H2O (IM)
  use param
  use aboxof
  use atomsi
  use molecu
  use counts
  use paramt
  use charac
!
  implicit none
!
!     This option can recognize wate molecules and calculate dipole moment
!
  double precision dxh,dyh,dzh,r2,OH1X,OH2X,OH1Y,OH2Y,OH1Z,OH2Z
  double precision DDX,DDY,DDZ,DPVV,DPXX,DPYY,DPZZ,sroh1,sroh2
  double precision, allocatable:: PH1(:,:),PH2(:,:)
  integer(KIND=4) nh,i,j,IM,k,io,m,no
!
  allocate(PH1(3,NIONO),PH2(3,NIONO))
  if (istart == 0 ) then
    allocate(HHX(NIONO),HHY(NIONO),HHZ(NIONO),HHV(NIONO))
    allocate(OPX(NIONO),OPY(NIONO),OPZ(NIONO),OPV(NIONO))
    allocate(LOP1X(NIONO),LOP1Y(NIONO),LOP1Z(NIONO))
    allocate(roh1(NIONO),roh2(NIONO),A1(NIONO),A2(NIONO))
    allocate(DPV(NIONO), DPX(NIONO), DPY(NIONO),DPZ(NIONO))
    allocate(DPX1(NIONO),DPX2(NIONO),DPY1(NIONO),DPY2(NIONO),DPZ1(NIONO),DPZ2(NIONO))
    allocate(UDPX1(NIONO),UDPX2(NIONO),UDPY1(NIONO),UDPY2(NIONO),UDPZ1(NIONO),UDPZ2(NIONO))
    allocate(QLP1(NIONO),QLP2(NIONO),QLP1z(NIONO),QLP2z(NIONO),QLPx(NIONO))
    allocate(QHHk(NIONO),QHHm(NIONO))
    allocate(E34(NIONO),idipX(4,NIONO),idipY(4,NIONO),idipZ(4,NIONO))
    allocate(pdipX(NIONO),pdipY(NIONO),pdipZ(NIONO),Edp1(NIONO),Edp2(NIONO))
    allocate(idp2(NIONO),ih2o(5,NIONO),watpol(2,NIONO))
    istart = 1
  endif
  IF(IM == 1) goto 100
!     --------------------------------------Recognize H2O molecules
  dxh = 0.0D0
  dyh = 0.0D0
  dzh = 0.0D0
  no = 0
  DO i = ions(1,IATOMO),ions(2,IATOMO)
    no = no + 1
    DO nh = 1,5
      ih2o(nh,no) = 0
    enddo
  enddo
  no = 0
  do i = ions(1,IATOMO), ions(2,IATOMO)
    nh = 1
    no = no + 1
    ih2O (1, no) = i   ! index of oxygen
    do j = ions(1,IATOMH), ions(2,IATOMH)
      dxh = p(1,j) - p(1,i)
      dyh = p(2,j) - p(2,i)
      dzh = p(3,j) - p(3,i)
      if (RUNOPT(35) /= 'ISOLATED  ') then
        if (ABS(dxh) > 0.5D0) dxh = dxh - SIGN(1.0D0,dxh)
        if (ABS(dyh) > 0.5D0) dyh = dyh - SIGN(1.0D0,dyh)
        if (ABS(dzh) > 0.5D0) dzh = dzh - SIGN(1.0D0,dzh)
      endif
      r2 = (dxh*box(1))**2 + (dyh*box(2))**2 + (dzh*box(3))**2
      if (r2 <= dintra**2) then
        nh = nh + 1
        ih2o(nh,no) = j
      end if
    enddo
    if (nh /= 3)  then 
      write (*,*) i,'-th ox : No.OH bonds=',nh-1
      stop
    endif
  enddo
!
100  j = ntion
  no = 0
  do io = ions(1,IATOMO),ions(2,IATOMO)
    no = no + 1
    if (RUNOPT(35) /= 'ISOLATED  ') then
      if (IM /= 2) then
        if (p(1,io) < 0.0D0) p(1,io) = p(1,io) + 1.0D0
        if (p(1,io) > 1.0D0) p(1,io) = p(1,io) - 1.0D0
        if (p(2,io) < 0.0D0) p(2,io) = p(2,io) + 1.0D0
        if (p(2,io) > 1.0D0) p(2,io) = p(2,io) - 1.0D0
        if (p(3,io) < 0.0D0) p(3,io) = p(3,io) + 1.0D0
        if (p(3,io) > 1.0D0) p(3,io) = p(3,io) - 1.0D0
      endif
    endif
    k = ih2o(2,no)
    m = ih2o(3,no)
    PH1(1,no)= P(1,k)
    PH1(2,no)= P(2,k)
    PH1(3,no)= P(3,k)
    PH2(1,no)= P(1,m)
    PH2(2,no)= P(2,m)
    PH2(3,no)= P(3,m)
    OH1X = PH1(1,no) - p(1,io)
    OH2X = PH2(1,no) - p(1,io)
    OH1Y = PH1(2,no) - p(2,io)
    OH2Y = PH2(2,no) - p(2,io)
    OH1Z = PH1(3,no) - p(3,io)
    OH2Z = PH2(3,no) - p(3,io)
    if (RUNOPT(35) /= 'ISOLATED  ') then
      if(ABS(OH1X) > 0.5D0) then
        PH1(1,no) = PH1(1,no) - SIGN(1.0D0,OH1X)
        OH1X = OH1X - SIGN(1.0D0,OH1X)
      endif
      if(ABS(OH2X) > 0.5D0) then
        PH2(1,no) = PH2(1,no) - SIGN(1.0D0,OH2X)
        OH2X = OH2X - SIGN(1.0D0,OH2X)
      endif
      if(ABS(OH1Y) > 0.5D0) then
        PH1(2,no) = PH1(2,no) - SIGN(1.0D0,OH1Y)
        OH1Y = OH1Y - SIGN(1.0D0,OH1Y)
      endif
      if(ABS(OH2Y) > 0.5D0) then
        PH2(2,no) = PH2(2,no) - SIGN(1.0D0,OH2Y)
        OH2Y = OH2Y - SIGN(1.0D0,OH2Y)
      endif
      if(ABS(OH1Z) > 0.5D0) then
        PH1(3,no) = PH1(3,no) - SIGN(1.0D0,OH1Z)
        OH1Z = OH1Z - SIGN(1.0D0,OH1Z)
      endif
      if(ABS(OH2Z) > 0.5D0) then
        PH2(3,no) = PH2(3,no) - SIGN(1.0D0,OH2Z)
        OH2Z = OH2Z - SIGN(1.0D0,OH2Z)
      endif 
    endif
    DPX1(no) = OH1X*BOX(1)
    DPX2(no) = OH2X*BOX(1)
    DPY1(no) = OH1Y*BOX(2)
    DPY2(no) = OH2Y*BOX(2)
    DPZ1(no) = OH1Z*BOX(3)
    DPZ2(no) = OH2Z*BOX(3)
    sroh1 = DPX1(no)**2 + DPY1(no)**2 + DPZ1(no)**2
    roh1(no) = sqrt(sroh1)
    UDPX1(no) = DPX1(no)/roh1(no)
    UDPY1(no) = DPY1(no)/roh1(no)
    UDPZ1(no) = DPZ1(no)/roh1(no)
    sroh2 = DPX2(no)**2 + DPY2(no)**2 + DPZ2(no)**2
    roh2(no) = sqrt(sroh2)
    UDPX2(no) = DPX2(no)/roh2(no)
    UDPY2(no) = DPY2(no)/roh2(no)
    UDPZ2(no) = DPZ2(no)/roh2(no)
    if (roh1(no) > 1.61D0 .or. roh2(no) > 1.61D0) then
      write(*,*) roh1(no),roh2(no)     
            stop '!!! H2O was broken !!!'
    endif
!   -----------------------------------------------------------------
    HHX(no) = DPX2(no)-DPX1(no)    ! H1 -> H2
    HHY(no) = DPY2(no)-DPY1(no)
    HHZ(no) = DPZ2(no)-DPZ1(no)
    HHV(no) = sqrt(HHX(no)**2+HHY(no)**2+HHZ(no)**2)     !Angstrom
    if (HHV(no) > 5.0D0) stop 'error in HH distance'
!   -----------------------------------------------------------------
    OPX(no) = DPY1(no)*DPZ2(no) - DPZ1(no)*DPY2(no)  !LP2 -> LP1 direction
    OPY(no) = DPZ1(no)*DPX2(no) - DPX1(no)*DPZ2(no)
    OPZ(no) = DPX1(no)*DPY2(no) - DPY1(no)*DPX2(no)
    OPV(no) = sqrt(OPX(no)**2+OPY(no)**2+OPZ(no)**2)     !Angstrom
!   -----------------------------------------------------------------
    DPXX = HHY(no)*OPZ(no) - OPY(no)*HHZ(no)  ! O -> D direction
    DPYY = HHZ(no)*OPX(no) - OPZ(no)*HHX(no)
    DPZZ = HHX(no)*OPY(no) - OPX(no)*HHY(no)
    DPVV = SQRT(DPXX**2+DPYY**2+DPZZ**2)     !Angstrom
!
!   -----------------------------------------------------OD
    A1(no) = 0.5d0*(HHV(no)+(roh1(no)**2 - roh2(no)**2)/HHV(no))
    A2(no) = HHV(no)- A1(no)
    DPV(no) = sqrt(roh1(no)**2-A1(no)**2)
    DPX(no) = DPV(no)*DPXX/DPVV
    DPY(no) = DPV(no)*DPYY/DPVV
    DPZ(no) = DPV(no)*DPZZ/DPVV
!
    j = j + 1
    ih2o(4,no) = j
!
    LOP1X(no) = OPX(no)*RD/OPV(no)
    LOP1Y(no) = OPY(no)*RD/OPV(no)
    LOP1Z(no) = OPZ(no)*RD/OPV(no)
!
    DDX = LOP1X(no)/BOX(1)
    DDY = LOP1Y(no)/BOX(2)
    DDZ = LOP1Z(no)/BOX(3)
!   ========================== positions of lone pairs
    P(1,j) = P(1,io)+DDX
    P(2,j) = P(2,io)+DDY
    P(3,j) = P(3,io)+DDZ
!
    if (P(1,j) > 1.0D0) P(1,j) = P(1,j) - 1.0D0
    if (P(1,j) < 0.0D0) P(1,j) = P(1,j) + 1.0D0
    if (P(2,j) > 1.0D0) P(2,j) = P(2,j) - 1.0D0
    if (P(2,j) < 0.0D0) P(2,j) = P(2,j) + 1.0D0
    if (P(3,j) > 1.0D0) P(3,j) = P(3,j) - 1.0D0
    if (P(3,j) < 0.0D0) P(3,j) = P(3,j) + 1.0D0
!
    j = j + 1
    ih2o(5,no) = j
!
    P(1,j) = P(1,io)-DDX 
    P(2,j) = P(2,io)-DDY
    P(3,j) = P(3,io)-DDZ
!
    if (P(1,j) > 1.0D0) P(1,j) = P(1,j) - 1.0D0
    if (P(1,j) < 0.0D0) P(1,j) = P(1,j) + 1.0D0
    if (P(2,j) > 1.0D0) P(2,j) = P(2,j) - 1.0D0
    if (P(2,j) < 0.0D0) P(2,j) = P(2,j) + 1.0D0
    if (P(3,j) > 1.0D0) P(3,j) = P(3,j) - 1.0D0
    if (P(3,j) < 0.0D0) P(3,j) = P(3,j) + 1.0D0
  enddo
!
!
999 RETURN
END
!                                                               ========
!================================================================ STRCTR
SUBROUTINE  STRCTR  (IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use values
  use struct
!
  implicit none
!
!     ------------------------------------- Bond lengths and angles etc.
!
  COMMON /WORK03/ PX(LNI),PY(LNI),PZ(LNI)
    real *8 PX,PY,PZ
!
  INTEGER   *4    NCHAR(5)
  REAL  *8    ANBR(6,2)
  CHARACTER *4    CCHAR(6),  ATAB(LST)
  CHARACTER *6    RCHAR(5)
  integer *4 IPR
  integer *4 MMM,I,J,IO,IT,I1,I2,I0,II,IJ,J1,ID1,J2,ID2,ITT,N,NAG,K,IC,IA
  integer *4 JO,KO,NN,MM,MJ,L,M
  real *8    D1,D4,D2,ASTHT,DB,ANTBL,AMEB1,AMEB2
  DATA RCHAR / 'SIZE  ', 'T     ', 'T1    ', '      ', '      '/
  DATA NCHAR / 0,1,2,3,4/,CCHAR/' 0 ',' 1 ',' 2 ',' 3 ',' 4 ','SUM'/
!
  IF (RUNOPT(9)  /= 'STRUCTURE ' .AND. RUNOPT(10) /= 'NETWORK   ' )     RETURN
  MMM = 0
  IF (ATOM(2) == ATMNET(1).OR.ATOM(2) == ATMNET(2)) MMM = IONS(2,2)
  if (ATMNET(2) /= '    ')  then
    IF (ATOM(3) == ATMNET(1).OR.ATOM(3) == ATMNET(2)) MMM = IONS(2,3)
  end if
  IF (MMM == 0.AND.IPR <= 0)  RETURN
!     ----------------------------------------- Default Cut-Off is 2.0 A
  RTO(1) = 2.00
  RTO(2) = 2.00
  DO I = 1, 2
    IF (ATMNET(I) == 'H ')  RTO(I) = 1.99
    IF (ATMNET(I) == 'B ')  RTO(I) = 1.90
    IF (ATMNET(I) == 'C ')  RTO(I) = 1.50
    IF (ATMNET(I) == 'AL')  RTO(I) = 2.20
    IF (ATMNET(I) == 'SI')  RTO(I) = 2.00
    IF (ATMNET(I) == 'P ')  RTO(I) = 1.95
    IF (ATMNET(I) == 'ZR')  RTO(I) = 2.30
  enddo
  DTO(1) = 0.0
  DTO(2) = 0.0
  NTO(1) = 0
  NTO(2) = 0
  DO J = 1, 12
    AVTHT(J) = 0.0
    SVTHT(J) = 0.0
    NVTHT(J) = 0
    DO I = 1, 121
      NTT(I,J) = 0
    enddo
  enddo
!
  DO I = 1, NTION
    PX(I) = P(1,I)
    PY(I) = P(2,I)
    PZ(I) = P(3,I)
  enddo
!     -------------------------------------------------- Cations - anion
!
  DO IO = 1, NCOMPO
    IF (IION(IO) <= -999)  cycle
    IF (NION(IO) <= 0.OR.ZIO(IO) < 0.0)  cycle
!         WRITE (*,9001)  ATOM(IO)
!9001     FORMAT (10X,'***  ',A2,' - ANION  ***')
    IF (IPR > 0.AND.RUNOPT(9) == 'STRUCTURE ') WRITE (16,2001)  ATOM(IO)
    IT = 0
    IF (ATOM(IO) == ATMNET(1))  IT = 1
    IF (ATOM(IO) == ATMNET(2))  IT = 2
    I1 = IONS(1,IO)
    I2 = IONS(2,IO)
    DO I = I1, I2, LENTAB
      I0 = I
      CALL  DISTAN  (I0, II, IO, IPR)
      IF (IT == 0)  cycle
      DO IJ = I0, II
        DO J1 = 1, 5
          ID1 = IONB(J1,IJ)
          D1  = DONB(J1,IJ)
          IF (D1 > RTO(IT) .OR. D1 < 0.1) cycle
          D4  = DONB(4,IJ)
          IF (D4 > RTO(IT).OR.D4 < .1)  GO TO 230
          IF (J1 > 4)  GO TO 230
          DTO(IT) = DTO(IT) + D1
          NTO(IT) = NTO(IT) + 1
230       DO J2 = J1+1, 6
            ID2 = IONB(J2,IJ)
            D2  = DONB(J2,IJ)
            IF (D2 > RTO(IT) .OR. D2 < 0.1) exit
            ITT = IT * 3 - 2
            IF (ID1 > IONS(2,1))  ITT = ITT + 1
            IF (ID2 > IONS(2,1))  ITT = ITT + 1
            CALL  ANGLES  (ASTHT,IJ,ID1,ID2,D1,D2,ITT)
          enddo
        enddo
      enddo
    enddo
  enddo
!
!     +----------------------------------------------------------------I
!     :  Angles      1 : A1-T1-A1     2 : A1-T1-A2     3 : A2-T1-A2    :
!     :              4 : A1-T2-A1     5 : A1-T2-A2     6 : A2-T2-A2    :
!     :              7 : T1-A1-T1     8 : T1-A1-T2     9 : T2-A1-T2    :
!     :             10 : T1-A2-T1    11 : T1-A2-T2    12 : T2-A2-T2    :
!     +----------------------------------------------------------------I
!
!     ------------- Anion - specified tetrahedron formers, large cations
!
300 IT = 0
  DO IO = 1, NCOMPO
    IF (IION(IO) <= -999) cycle
    IF (NION(IO) <= 0.OR.ZIO(IO) > 0.0) cycle
!         WRITE (*,9002)  ATOM(IO)
!9002     FORMAT (10X,'***  ',A2,' - CATION  ***')
    IT = IT + 1
    IF (IPR > 0.AND.RUNOPT(9) == 'STRUCTURE') THEN
      WRITE (16, 4001) ATOM(IO)
    END IF
    I1 = IONS(1,IO)
    I2 = IONS(2,IO)
    DO I = I1, I2, LENTAB
      I0 = I
      CALL  DISTAN  (I0, II, IO, IPR)
      N = 0
      NAG = 0
      DO IJ = I0, II
        N = N + 1
        ATAB(N) = '    '
        TTAB(N) = 0.0001
        ID1     = IONB(1,IJ)
        ID2     = IONB(2,IJ)
        IF (ID1 > MMM.OR.ID2 > MMM) cycle
        D1 = DONB(1,IJ)
        D2 = DONB(2,IJ)
        IF (D2 > RTO(2) .OR.  D2 < 0.01) cycle
        IF (D2 > RTO(1) .AND. ID1 <= IONS(2,2))  cycle
        ITT = (IT + 2) * 3 - 2
        IF (ID1 > IONS(2,2))  ITT = ITT + 1
        IF (ID2 > IONS(2,2))  ITT = ITT + 1
        ATAB(N) = '<S-S'
        IF (MOD(ITT,3) == 2)  ATAB(N) = '<S-A'
        IF (MOD(ITT,3) == 0)  ATAB(N) = '<A-A'
        CALL  ANGLES  (TTAB(N),IJ,ID1,ID2,D1,D2,ITT)
        NAG = NAG + 1
      enddo
      IF (NAG <= 0)  cycle
      IF (IPR /= 0.AND.RUNOPT(9) == 'STRUCTURE ') THEN
        if (lentab > 30)  then
          WRITE (16,4011)  (ATAB(J),J=1,N)
          WRITE (16,4021)  (TTAB(J),J=1,N)
        end if
        if (lentab > 25.and.lentab <= 30)  then
          WRITE (16,4012)  (ATAB(J),J=1,N)
          WRITE (16,4022)  (TTAB(J),J=1,N)
        end if
        if (lentab > 20.and.lentab <= 25)  then
          WRITE (16,4013)  (ATAB(J),J=1,N)
          WRITE (16,4023)  (TTAB(J),J=1,N)
        end if
        if (lentab <= 20)  then
          WRITE (16,4014)  (ATAB(J),J=1,N)
          WRITE (16,4024)  (TTAB(J),J=1,N)
        end if
      END IF
    enddo
  enddo
!
  IF (NVTHT(1)+NVTHT(2) <= 0.OR.MMM <= 0)  RETURN
!
  write(*,*)'Enter ADISTR'
  CALL  ADISTR  (IPR)
!
  IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
!           ----------------------------------------------------- Netwrk
    CALL  NETWRK  (MMM, IPR)
!           -------------------------------- Sorting of T1-X4 tetrahedra
    IF (IPR == 0)  THEN
      DO K = 1, 2
        DO I = 1, 6
          DO J = 1, 6
            NBR(I,J,K) = 0
          enddo
        enddo
      enddo
      I1 = IONS(1,2)
      DO I = I1, MMM
!                     DB4 = DONB(4,I)
        K = 1
        IF (I > IONS(2,2))  K = 2
!                     IF (DB4 > RTO(K).OR.DB4 < 0.0001) cycle
        IC = 1
        IA = 1
        DO J = 1, 4
          JO = IONB(J,I)
          DB = DONB(2,JO)
          IF (JO > MMM.OR.JO == 0)  cycle
          IF (DB < 0.1.OR.DB > RTO(2)) cycle
          KO = IONB(1,JO)
          IF (KO == I)  KO = IONB(2,JO)
          IF (KO <= IONS(2,2))               IC = IC + 1
          IF (KO >= IONS(1,3).AND.KO <= MMM .and. ncompo > 2)  IA = IA + 1
        enddo
        NBR(IC,IA,K) = NBR(IC,IA,K) + 1
        NBR(IC, 6,K) = NBR(IC, 6,K) + 1
        NBR( 6,IA,K) = NBR( 6,IA,K) + 1
        NBR( 6, 6,K) = NBR( 6, 6,K) + 1
      enddo
      DO K = 1, 2
        DO I = 1, 6
          DO J = 1, 6
            MBR(I,J,K) = MBR(I,J,K) + NBR(I,J,K)
          enddo
        enddo
      enddo
      NN = IRECRD(2)/IRECRD(3)
      MM = MOD(NRECRD(1)/IRECRD(3), NN)
      MJ = 2
      IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
      IF (MOD(MM,MJ) /= 0)  RETURN
!
    ELSE
      DO K = 1, 2
        DO  I = 1, 6
          DO J = 1, 6
            NBR(I,J,K) = MBR(I,J,K)
          enddo
        enddo
      enddo
    END IF
!
    WRITE (16, 5001)  ATMNET(1), ATMNET(2), NTBL
    WRITE (16, 5005)  ATMNET(1), (NCHAR(I),I=1,5),CCHAR(6), &
                      ATMNET(2), (NCHAR(I),I=1,5),CCHAR(6),(RCHAR(I),I=1,3)
    ANTBL = NTBL
    IF (IPR == 0)  ANTBL = 1
    L = 1
    DO I = 1, 6
      IF  (I == 1.OR.I == 6)  THEN
        L = L + 1
        AMEB1 = MEB(L,1)*100.0 / (NION(2)*ANTBL)
        AMEB2 = MEB(L,2)*100.0 / ((NION(2)+NION(3))*ANTBL)
        WRITE (16,5007)  L, AMEB1, AMEB2
      END IF
      L  = L + 1
      AMEB1 = MEB(L,1)*100.0 / (NION(2)*ANTBL)
      AMEB2 = MEB(L,2)*100.0 / ((NION(2)+NION(3))*ANTBL)
      DO M = 1, 6
        ANBR(M,1) = NBR(I,M,1)*100.0 / (NION(2)*ANTBL)
        ANBR(M,2) = 0
        IF (NION(3) > 0)  THEN
          ANBR(M,2) = NBR(I,M,2)*100.0 / (NION(3)*ANTBL)
        END IF
      enddo
      WRITE (16,5003) (CCHAR(I),(ANBR(M,K),M=1,6),K=1,2),L,AMEB1,AMEB2
    enddo
  END IF
!
RETURN
 2001 FORMAT (/'<<<<<   ', A2, ' - anion distances    >>>>>')
 4001 FORMAT (/'<<<<<   ', A2, ' - cation distances   >>>>>')
 4011 FORMAT (4(1X,8A4))
 4012 format (6(1x,5A4))
 4013 format (5(1x,5(a4,1x)))
 4014 format (4(1x,5(a4,2x)))
 4021 FORMAT (4(1X,8F4.0))
 4022 format (6(1x,5F4.0))
 4023 format (5(1x,5F5.1))
 4024 format (4(1x,5(F5.1,1X)))
 5001 FORMAT (/'V: No. of bridging anion to ',A2,' tetrahedra  ', &
               'H: No. of bridging anion to ',A2,' tetrahedra (',I3, &
              ')   << Tet-Ring  >>' / 1X,90('-'),'   <<  Analysis >>')
 5005 FORMAT (A3,' I', I4,4I6,'   I  ', A3, 4X, &
              A3,' I', I4,4I6,'   I  ', A3, 5X, 3A6)
 5003 FORMAT (2(A3,' I',   5F6.2, ' I', F6.2,3X), I3,1X,2F6.2)
 5007 FORMAT (2('----+',31('-'),'+------   '),    I3,1X,2F6.2)
      END
!
!
!                                                                =======
!================================================================ DISTAN
SUBROUTINE  DISTAN  (I1, I2, IO, IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use struct
!
  implicit none
!
!     ----------------------------- Calculation of interatomic distances
!
  COMMON /WORK03/ PX(LNI),PY(LNI),PZ(LNI)
    real *8 PX,PY,PZ
!
  REAL      *8    D(64)
  real      *8    dtab(10,lst)
  INTEGER   *4    ID(64),ITAB(10,LST),IDTAB(10,LST),IU(LST)
  CHARACTER *2    TAX(LST)
  integer   *4    I1,I2,IO,IPR,NI,I,NB,J,JO,K,JD,IDUMMY,ITA,IB
  real      *8    ABOXX,ABOXY,ABOXZ,PXI,PYI,PZI,DX,DY,DZ,RIJ2,DR
!
  ABOXX = BOX(1)
  ABOXY = BOX(2)
  ABOXZ = BOX(3)
  I2 = I1 + LENTAB - 1
  IF (I2 > IONS(2,IO))  I2 = IONS(2,IO)
  NI = 0
  DO I = I1, I2
    NI = NI + 1
    NB = 0
    PXI = PX(I)
    PYI = PY(I)
    PZI = PZ(I)
    DO J = 1, 64
      ID(J) = 0
      D(J) = 0.000001
    enddo
    DO JO = 1, NCOMPO
      IF (IION(JO) <= -999)  cycle
      IF (NION(JO) <= 0.OR.ZIO(IO)*ZIO(JO) > 0.0)  cycle
      DO J = IONS(1,JO), IONS(2,JO)
        IF (IOND(J) == 0 .OR. I == J)  cycle
        DX = ABS(PXI-PX(J))
        DY = ABS(PYI-PY(J))
        DZ = ABS(PZI-PZ(J))
        IF (DX > 0.5) DX = 1.0 - DX
        IF (DY > 0.5) DY = 1.0 - DY
        IF (DZ > 0.5) DZ = 1.0 - DZ
        RIJ2 = (DX*ABOXX)**2 +(DY*ABOXY)**2 +(DZ*ABOXZ)**2
        IF (RIJ2 <= 9.0.AND.NB < 64) THEN
          NB     = NB +1
          D(NB)  = SQRT(RIJ2)
          ID(NB) = J
        END IF
      enddo
    enddo
    IF (NB > 1)  THEN
      DO J = 1, NB-1
        DO K = J+1, NB
          IF (D(J) >= D(K))  THEN
            DR = D(J)
            D(J) = D(K)
            D(K) = DR
            JD = ID(J)
            ID(J) = ID(K)
            ID(K) = JD
          END IF
        enddo
      enddo
    END IF
    DO J = 1, 10
      ITAB(J,NI) = ID(J)
      DTAB(J,NI) = D(J)
    enddo
    do j =1, 6
      DONB(J,I) = D(J)
      IONB(J,I) = ID(J)
    enddo
    do j = 1, 10
      idtab(j,ni) = dtab(j,ni) * 100.0 + 0.5
    enddo
    idummy = idtab(1,ni)
    IU(NI) = AU(I) * 1.E12 / NRECRD(2) + 0.5
  enddo
!
  IF (IPR == 0.OR.RUNOPT(9) /= 'STRUCTURE ')  RETURN
!
  WRITE (16,2001)
  if (lentab > 30)  then
    WRITE (16,2011)  (I,I=I1,I2)
    WRITE (16,2021)  (IU(I),I=1,NI)
  end if
  if (lentab > 25.and.lentab <= 30)  then
    WRITE (16,2012)  (I,I=I1,I2)
    WRITE (16,2022)  (IU(I),I=1,NI)
  end if
  if (lentab > 20.and.lentab <= 25)  then
    WRITE (16,2013)  (I,I=I1,I2)
    WRITE (16,2023)  (IU(I),I=1,NI)
  end if
  if (lentab <= 20)  then
    WRITE (16,2014)  (I,I=I1,I2)
    WRITE (16,2024)  (IU(I),I=1,NI)
  end if
  DO I = 1, 10
    ITA = 0
    DO J = 1, NI
      ib = itab(i,j)
      TAX(J) = '*'
      IF (IB >= ions(1,1).and.ib <= ions(2,1)) TAX(J) = ATOM(1)
      IF (IB >= IONS(1,2).and.ib <= ions(2,2)) TAX(J) = ATOM(2)
      IF (IB >= IONS(1,3).and.ib <= ions(2,3)) TAX(J) = ATOM(3)
      IF (IB >= IONS(1,4).and.ib <= ions(2,4)) TAX(J) = ATOM(4)
      IF (IB >= IONS(1,5).and.ib <= ions(2,5)) TAX(J) = ATOM(5)
      IF (IB >= IONS(1,6).and.ib <= ions(2,6)) TAX(J) = ATOM(6)
      IF (IB >= IONS(1,7).and.ib <= ions(2,7)) TAX(J) = ATOM(7)
      ITA = ITA + ITAB(I,J)
    enddo
    IF (ITA < 1)  cycle
    if (lentab > 30)  then
      WRITE (16,2031)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
    if (lentab > 25.and.lentab <= 30)  then
      WRITE (16,2032)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
    if (lentab > 20.and.lentab <= 25)  then
      WRITE (16,2033)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
    if (lentab <= 20)  then
      WRITE (16,2034)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
  enddo
!
 2001 FORMAT (132('-'))
 2011 FORMAT (4(1X,8I4))
 2012 FORMAT (6(1X,5I4))
 2013 FORMAT (5(1X,5(I4,1x)))
 2014 FORMAT (4(1X,5(I4,2x)))
 2021 FORMAT (4(1X,8I4))
 2022 FORMAT (6(1X,5I4))
 2023 FORMAT (5(1X,5(1x,I4)))
 2024 FORMAT (4(1X,5(1x,I4,1x)))
 2031 FORMAT (4(1X,8(I3,A1)))
 2032 format (6(1x,5(i3,a1)))
 2033 format (5(1x,5(i3,a2)))
 2034 format (4(1x,5(i3,a2,1x)))
RETURN
END
!
!                                                                =======
!================================================================ ANGLES
SUBROUTINE  ANGLES  (THT,IJ,ID1,ID2,D1,D2,IT)
  use param
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use charac
!
  implicit none
!     -------------------------------- Calculation of interatomic angles
!
  double precision    THT,W,D1,D2,DD1,DD2,COSTHT,SINTHT
  integer *4   IJ,ID1,ID2,IT,J,ITHT
!
  W = 0.0
  DO J = 1, 3
    DD1 = P(J,ID1)-P(J,IJ)
    DD2 = P(J,ID2)-P(J,IJ)
    if (RUNOPT(35) /= 'ISOLATED  ') then
      IF (ABS(DD1) > 0.5d0)  DD1 = DD1-DSIGN(1.0d0,DD1)
      IF (ABS(DD2) > 0.5d0)  DD2 = DD2-DSIGN(1.0d0,DD2)
    endif
    W = W + DD1 * DD2 *BOX(J)**2
  enddo
  COSTHT = W / (D1 * D2)
  SINTHT = ABS(1. - COSTHT*COSTHT)
  THT = ATAN(SQRT(SINTHT) / COSTHT) * 180.0/PI
  IF (THT < 0.0)  THT = THT + 180.0
  NVTHT(IT) = NVTHT(IT) + 1
  AVTHT(IT) = AVTHT(IT) + THT
  SVTHT(IT) = SVTHT(IT) + THT * THT
  ITHT = INT(THT - 58.5)
  IF (ITHT <= 0)  ITHT = 1
  NTT(ITHT,IT) = NTT(ITHT,IT) + 1
RETURN
END
!
!
!                                                               ========
!================================================================ ADISTR
SUBROUTINE  ADISTR (IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
!
  implicit none
!     -------------------------------------- Grafs of interatomic angles
!
!
  REAL      *8    ANGLE(3,12)
  real      *4    ANTBL,ANN,AAA,SSS,FACT
  INTEGER   *4    IANGLE(12)
  integer   *4    IPR
  CHARACTER *4    SNGLE(3,12),ATY(LEL),GRAPH(121)
  integer   *4    N,IO,I,J,MTBL,NN,MM,MJ,NK,K,KK,IJ,NMAX,NG,MTT
!
!     WRITE  (*,1111)
!1111 FORMAT (10X,'<<<  Angle distribution  >>>')
  N = 0
  DO IO = 1, NCOMPO
    IF (ZIO(IO) < 0.0)  THEN
      N = N + 1
      ATY(N) = ATOM(IO)
    END IF
  enddo
!
  IF (IPR == 1)  THEN
    DO I = 1, 12
      AVTHT(I) = ANGL(1,I)
      SVTHT(I) = ANGL(2,I)
      NVTHT(I) = ANGL(3,I)
      DO J = 1, 121
         NTT(J,I) = ITBR(J,I)
      enddo
    enddo
  END IF
!
  IF (IPR == 0)   NTBL = NTBL + 1
  MTBL = NTBL
  IF (MTBL <= 0)  MTBL = 1
  IF (NTO(1) > 0)  DTO(1) = DTO(1) / NTO(1)
  IF (NTO(2) > 0)  DTO(2) = DTO(2) / NTO(2)
  NTO(1) = NTO(1) / 4
  NTO(2) = NTO(2) / 4
  IF (IPR == 0)  THEN
    IF (IRECRD(3) > 0)  THEN
      NN = IRECRD(2)/IRECRD(3)
      IF (NN > 0) MM = MOD(NRECRD(1)/IRECRD(3),NN)
    END IF
    MJ = 2
    IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
    IF (MOD(MM,MJ) /= 0)  GO TO 270
  END IF
  IF (IPR == 1)  THEN
    WRITE (16, 4005)  NTBL, ATMNET(1),ATY(1),DTO(1),NTO(1),ATMNET(2),ATY(1),DTO(2),NTO(2)
 4005        FORMAT(/' Angle distribution (', I3, ')',3X, &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')   ', &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')')
    WRITE (16,4011)
  END IF
!
270 NK = 0
  ANTBL = REAL(NTBL)
  DO K = 1, 12
    IF (NVTHT(K) == 0) cycle
    ANN = NVTHT(K)
!           IF (ANN <= 0.0)  ANN = ANN + 65534
    AAA = AVTHT(K)
    SSS = SQRT(ABS(SVTHT(K) - AAA*AAA/ANN) /ANN)
    AAA = AAA / ANN
    NK  = NK + 1
    ANGLE(1,NK) = AAA
    ANGLE(2,NK) = SSS
    IANGLE(NK)  = NVTHT(K)
    IF (K <= 6)  THEN
      KK = (K - 1)/ 3 + 1
      SNGLE(1,NK) = ATY(1)
      SNGLE(2,NK) = ATMNET(KK)
      SNGLE(3,NK) = ATY(1)
      J = MOD(K-1,3)
      IF (J >= 1)  SNGLE(3,NK) = ATY(2)
      IF (J >= 2)  SNGLE(1,NK) = ATY(2)
      GO TO 390
    END IF
    I = 1
    IF (MOD(K,3) == 0)  I = 2
    J = 2
    IF (MOD(K,3) == 1)  J = 1
    IJ = 1
    IF (K > 9)  IJ = 2
    SNGLE(1,NK) = ATMNET(I)
    SNGLE(2,NK) = ATY(IJ)
    SNGLE(3,NK) = ATMNET(J)
390 IF (IPR == 1)  THEN
      WRITE (16,4021) (SNGLE(J,NK),J=1,3), AAA, SSS, NVTHT(K)
      NMAX = 0
      FACT = 400.0 / (ANTBL * NION(1))
      DO I = 1, 121
        NTT(I,K) = NTT(I,K) * FACT + 0.5
        IF (NMAX < NTT(I,K))  NMAX = NTT(I,K)
      enddo
      IF (NMAX > 17)  NMAX = 17
      DO I = 1, NMAX
        NG = NMAX -I + 1
        DO J = 1, 121
          GRAPH(J) = ' '
          IF (J == 1.OR.J == 121)  GRAPH(J)='I'
          MTT = NTT(J,K)
          IF (MTT >= NG)     GRAPH(J) = '*'
          IF (MTT-17 >= NG)  GRAPH(J) = '#'
        enddo
        WRITE (16,4010)  (GRAPH(J),J=1,121)
      enddo
      WRITE (16,4011)
    END IF
  enddo
  IF (IPR == 1)  THEN
    WRITE (16,4012)  (I, I=60,180,30)
    RETURN
  END IF
!
  NN = IRECRD(2)/IRECRD(3)
  MM = MOD(NRECRD(1)/IRECRD(3), NN)
  MJ = 2
  IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
  IF (MOD(MM,MJ) == 0)  THEN
    WRITE (16,4006)  NTBL,ATMNET(1),ATY(1),DTO(1),NTO(1),ATMNET(2),ATY(1),DTO(2),NTO(2)
 4006              FORMAT ('I Angle distribution  (', I3, ')  ', &
                            A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')  ', &
                            A2,'-',A2,'(tet)=', F5.3, ' (', I3, ') I')
    IF (NK <= 2) THEN
      WRITE (16,4020)  ( (SNGLE(J,I),J=1,3),(ANGLE(J,I),J=1,2),IANGLE(I),I=1,NK )
    ELSE
      WRITE (16,4025)  ( (SNGLE(J,I),J=1,3),(ANGLE(J,I),J=1,2),IANGLE(I),I=1,NK )
    END IF
    WRITE (16,'("I",74("-"),"I")')
  END IF
  DO I = 1, 12
    ANGL(1,I) = ANGL(1,I) + AVTHT(I)
    ANGL(2,I) = ANGL(2,I) + SVTHT(I)
    ANGL(3,I) = ANGL(3,I) + NVTHT(I)
    DO J = 1, 121
      ITBR(J,I) = ITBR(J,I) + NTT(J,I)
    enddo
  enddo
RETURN
!
 4010 FORMAT (3X, 121A1)
 4011 FORMAT (3X,12('I',9('-')),'I')
 4012 FORMAT (3X,4(I3,27X),I3)
 4020 FORMAT ('I ',2(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),'   I')
 4025 FORMAT ('I ',2(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),'   I'/ &
              'I ',2(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),'   I'/ &
              'I ',1(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),36X,'   I' )
 4021 FORMAT (3X,'I  <',A2,'-',A2,'-',A2,' =',F7.2,'+-',F6.2,'  (N=',I7,')',78X,'I')
 4410                 FORMAT (80A1)
END
!
!
!                                                               ========
!================================================================ NETWRK
SUBROUTINE  NETWRK  (NNN, IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use struct
!
  implicit none
!     ------------------------------------------------- Network analysis
!
!
  integer *4      NNN,IPR
  INTEGER *4      NTET(19),ITREE(19),MING(9),MEMBER(9),ITET(6,19)
  integer *2      mring(lrg),ling(9,lrg)
  integer *4      LMBR,LCOL,I,ISE,NR,IS,MMM,J,ISI,ICOL,II,JJ,KJ,LL,L,IOS
  integer *4      NTCOL,ITI,MOR,MIG,MI,MM,IDEL,N,LI
!
  LMBR = 8
  LCOL = LMBR * 2 + 1
  IF (IPR == 1)  GO TO 901
!     WRITE (*,1111)
!1111 FORMAT (10X,'<<<<<  NETWORK ANALYSIS STARTED  >>>>>')
  DO I = 1, 9
    MEB(I,1) = 0
    MEB(I,2) = 0
  enddo
  ISE = 1
  IF (NNN > IONS(2,2))  ISE = 2
!     --------------------------------------------- Ring search starting
  write (*,*)  'NETWORK'
  NR   = 0
  DO IS = 1, ISE
    MMM = NNN
    IF (IS == 1)  MMM = IONS(2,2)
!
    DO I = 1, LMBR
       MEMBER(I) = 0
    enddo
    DO I = 1, LCOL
      DO J = 1, 6
        ITET(J,I) = 9999
      enddo
    enddo
!
!          ------------------------------------- Search around ion [ISI]
!                                                  ISI : Network former
    DO ISI = IONS(1,2), MMM
!              WRITE (6,*)  'ISI=',ISI,'   Total Number of Rings =',NR
      ICOL = 1
      ITREE(1) = ISI
      II = ISI
      JJ = ISI
710   ICOL = ICOL + 1
      IF (ICOL > LCOL)  GO TO 725
      KJ = 1
      IF (JJ > IONS(2,2))  KJ = 2
      LL = 0
      DO L = 1, 5
        ITET(L,ICOL) = 9999
        IOS = IONB(L,JJ)
        IF (IOS <= 0.OR.IOS > MMM) cycle
        IF (IOS > IONS(2,2))  KJ = 2
        IF (DONB(L,JJ) > RTO(KJ).OR.IOS == II) cycle
        LL = LL + 1
        ITET(LL,ICOL) = IOS
      enddo
!
      NTET(ICOL) = 0
720   NTET(ICOL) = NTET(ICOL) + 1
      NTCOL = NTET(ICOL)
      JJ = ITET(NTCOL,ICOL)
      IF (JJ < 9000)  GO TO 730
725   ICOL = ICOL - 1
      IF(ICOL <= 1) cycle
      GO TO 720
730   IF (JJ > IONS(2,1).AND.JJ < ISI)  GO TO 720
      ITREE(ICOL) = JJ
      II = ITREE(ICOL-1)
      IF (JJ /= ISI)  GO TO 710
!             -------------------------------------------- Ring detected
!                                                       Unique for ISI ?
      DO I = 2, ICOL-2
        ITI = ITREE(I)
        DO J = I+1, ICOL-1
          IF (ITI == ITREE(J))  GO TO 720
        enddo
      enddo
!             ---------------------------- Recorded as a ring temporally
      MOR = 0
      DO I = 1, ICOL-1, 2
        MOR = MOR + 1
        MING(MOR) = ITREE(I)
      enddo
!             -------------------------------------- Sorting in the ring
      DO I = 1, MOR-1
        MIG = MING(I)
        DO J = I+1, MOR
          IF (MI <= MING(J)) cycle
          MM      = MIG
          MIG     = MING(J)
          MING(J) = MM
        enddo
        MING(I) = MIG
      enddo
      IF (NR < 1)  GO TO 780
!             ------------------------------------- Check for uniqueness
      IDEL = 0
      DO 775  N = 1, NR
        MM = MRING(N)
        IF (MM == 0)  cycle
        IF (MOR < MM)  GO TO 760
        DO 756  J = 1, MM
          LI = LING(J,N)
          DO I = 1, MOR
            IF (LI == MING(I))  GO TO 756
          enddo
          GO TO 775
  756   enddo
        GO TO 720
!
  760   DO 765  I = 1, MOR
          MI = MING(I)
          DO J = 1, MM
            IF (MI == LING(J,N))  GO TO 765
          enddo
          GO TO 775
  765   enddo
        IF (IDEL >= 1)  GO TO 770
        MRING(N)    = MOR
        MEMBER(MOR) = MEMBER(MOR) + 1
        DO J = 1, MOR
          LING(J,N) = MING(J)
        enddo
        IDEL = 1
        GO TO 772
  770   MRING(N)   = 0
  772   MEMBER(MM) = MEMBER(MM) - 1
  775 enddo
      IF (IDEL >= 1)  GO TO 720
  780 MEMBER(MOR) = MEMBER(MOR) + 1
      NR = NR + 1
      IF (NR > LRG)  GO TO 791
      DO I = 1, MOR
        LING(I,NR) = MING(I)
      enddo
      MRING(NR) = MOR
      GO TO 720
    enddo
!
791 DO I = 1,LMBR
      MEB(I,IS) = MEMBER(I)
      NRG(I,IS) = NRG(I,IS) + MEMBER(I)
    enddo
  enddo
!
    WRITE (*,9999) NR
9999 FORMAT (10X,'<<<<< NETWORK: No. of total rings is ',I5,' >>>>>')
RETURN
!
901 DO IS = 1, 2
      DO I = 1, 9
        MEB(I,IS) = NRG(I,IS)
      enddo
    enddo
RETURN
END
!
!
!                                                               ========
!================================================================ KCLOCK
SUBROUTINE  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  use param
  use charac
!
  implicit none
!
  INTEGER   *4    IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
  IF (FLNAME(3) == 'F90           ') CALL  F90  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND)
  IF (FLNAME(3) == 'Dummy         ')  THEN
    IYEAR  = 0
    IMONTH = 0
    IDAY   = 0
    IHOUR  = 0
    IMINUT = 0
    ISECND = 0
    I100TH = 0
  END IF
RETURN
END
!
!
!==================================================================! F90
SUBROUTINE  F90  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND)
!     --- Fortran 90 ---
       implicit none
       character date * 8, time * 10, zone *5
       integer*4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND
       integer*4  ia(1:8)
!
       call date_and_time(date, time, zone, ia)
!
       isecnd = ia(7)
       iminut = ia(6)
       ihour  = ia(5)
       iday   = ia(3)
       IMONTH = ia(2)
       iyear  = ia(1)
    RETURN
End
