﻿!      PROGRAM  MXDORTHOP
!============================================================
!##                                                        ##
!##            Program  :  MXDORTHOP                       ##
!##                        MPI version                     ##
!##                                                        ##
!##      by  Katsuyuki Kawamura (Hokkaido University)      ##
!##                    (Tokyo Institute of Technology)     ##
!##      by  Hiroshi Sakuma (Tokyo Tech) WATER-POL         ##
!##                                                        ##
!##     Configuration and Energy for Non-Cubic Systems     ##
!##              (Rectangular parallelepiped)              ##
!##     with Pressure Control by stress tensor,            ##
!##     and Quantum Correction for energy and pressure     ##
!##                                                        ##
!##           2nd order interpolation from tables          ##
!##                                                        ##
!##   First cubic version on Hitac 8800/8700    80         ##
!##   First orthogonal (crystal) version        83-Oct     ##
!##       on CDC7600 at Manchester Univ.                   ##
!##   HITAC M-280/IAP version                   85-Sep-12  ##
!##   PX, PY, PZ pressure control version       87-Feb-07  ##
!##   Pressure tensor and                                  ##
!##        fractional coordinates               87-Oct-29  ##
!##   Five element  and                                    ##
!##        input data format and history        87-Nov-05  ##
!##   PC9800RA+NDP-FORTRAN-386   version        89-Jan-26  ##
!##   Reviced for JCPE                          90-Apr-14  ##
!##   (XDORTO : DEFECT)                         90-Apr-21  ##
!##   3-body interaction (H2O, Kumagai & Kats)  91-Feb-02  ##
!##   Integrated version of MD and XD (MXD)     91-May-22  ##
!##   Rearranged                                91-Oct-23  ##
!##   Seven comonents, rearranged               92-Jan-23  ##
!##   Quatum corrections     (Nakao & Kats)     92-Mar-04  ##
!##   Ten comonents, rearranged                 92-Mar-31  ##
!##   Extended Andersen's pressure control      92-Apr-07  ##
!##                        (Katsuta & Kats)                ##
!##   Metal (main group) potential              92-Apr-18  ##
!##   Revised for JCPE version                  92-Aug-01  ##
!##   2nd order interpolation from tables       92-Sep-05  ##
!##   2nd order interpolation of velocity       92-Dec-12  ##
!##   Nose's thermostat                         92-Dec-14  ##
!##   Correction for trancation VW-term         93-Dec-10  ##
!##   Reviced 3-body by Kuma                    94-Jan-30  ##
!##   L-J potential                             94-Jun-28  ##
!##   Nose's thermostat + quantum               94-Sep-01  ##
!##   Improvement of Semi-classical MD          95-Jun-15  ##
!##   FILE09.DAT format changed                 95-Jul-18  ##
!##   IP model by Belonoshko & Dubrovinsky      96-Sep-05  ##
!##   Electric (N.SAWAGUCHI) & Gravity F.       97-Jun-30  ##
!##   Diatomic 3 chrge model                    97-Oct-20  ##
!##   'ENERGY' and 'CUBE' options               98-Aug-24  ##
!##   MPI parallel by  kats (TITECH)  and                  ##
!##                    nasawa (NIRIN)           99-Jan-10  ##
!##   3-body j-i-k with j<>k                    99-Nov-16  ##
!##   'EXCLUSION' : column                      00-Apr-15  ##
!##   3-body   sqrt(k1xk2) -> k1xk2             00-May-01  ##
!##   Cell change with time                     00-May-28  ##
!##   POSISION-VELOCITY-ENERGY option           00-Dec-16  ##
!##   Soft repulsive wall                       01-Mar-07  ##
!##   Modify EWALD direct term                  01-Apr-12  ##
!##   3-body j-i-k : modified                   01-Sep-11  ##
!##   File07.dat : format                       01-Dec-02  ##
!##   Polyatomic molecule                       02-Feb-23  ##
!##   Modify subroutines                        02-Mar-18  ##
!##   Modify NETWORK analysis (c.n.=5)          02-Sep-14  ##
!##   file07.dat (i10) and 3-body               03-Jul-09  ##
!##   New multi-3-body                          03-Jul-28  ##
!##   Separate file08.dat (file081.dat)         05-Aug-11  ##
!##   Ewald correction for slab geometry        08-Jul-07  ##
!##   POTSURF                                   08-Jul-14  ##
!##   ZDNS.dat                                  08-Aug-25  ##
!##   WATER-POL                                 11-Apr-01  ##
!##   Increase Number of idatom and ddatom      11-Apr-07  ##
!##   RSWTCH for covalent bond                  11-Jul-05  ##
!##   H2O distance, roh < 1.27                  11-Nov-30  ##
!##   Force from induced charges                12-May-16  ##
!##   Final version of Water-pol                12-Jun-27  ##
!##   Bug fixed for 3-body potential loading    13-Jul-29  ##
!##   Bug fixed for Nose-Hoover thermostat      14-Apr-17  ##
!##   Bug fixed for POLH2O for index            14-Jul-31  ##
!##   Bug fixed for MOLECULE option             14-Sep-01  ##
!##   Implementation of Nose-Hoover Chain       14-Sep-02  ##
!##   Bug fixed Nose-Hoover (JJJ)               15-Mar-03  ##
!##   20 Elements for BMHEXP                    16-Dec-01  ##
!##   Bug fixed for THREEQ (i-j-k)              16-Dec-01  ##
!##   Warning fixed -O2 option only             17-Feb-26  ##
!##   Improved input of BMHEXP                  17-Apr-20  ##
!##   Bug fixed for CUBE option                 17-Oct-19  ##
!##   SPME implementation using FFTW3           18-Apr-18  ##
!=======================================================================I
!              Format  and  parameters  of  'FILE05.DAT'  file          :
!-----------------------------------------------------------------------I
! 1  MD.......I....:....I....:....I....:....I....:....I....:....I....:..:
!    XD.......I...                                                      :
! 2  START    :TITLE(60 CHARACTERS)                                     :
!    CONTINUE :                                  (CONT.)                :
!    RESTART  :                                                         :
!    STOP     :                                                         :
! 3  ECONOMY  :IRECRD(1):IRECRD(2):IRECRD(3):IRECRD(4):IRECRD(5):       :
!    NORMAL   :         :         :   (50)  : (M50,X5):   (5)   :       :
!    DETAIL   :         :         :         :         :         :       :
! 4  NOACCUM  :DTIME    :FORMULA  :(RCUTL)  :(RCUTS)  :         :       :
!    ACCUM    :         :         :         :         :         :       :
! 5  T NO-CNTL:         :         :         :         :         :       :
!    T [BLANK]:         :         :         :[No control on temperature]:
!    T SCALING:TMPGET   :DELTMP   :NTSTEP   :TDUMP    :          :      :
!    T SCALE-A:TMPGET   :DELTMP   :NTSTEP   :TDUMP    :[Scale each atom]:
!    T NOSE   :TMPGET   :DELTMP   :STEMP    :         :         :       :
! 6  P NO-CNTL:         :         :         :         :         :       :
!    P [BLANK]:         :         :         :  [No control on pressure] :
!    P SCALING: SPRES(1):SPRES(2) :SPRES(3) :PDUMP    :         :       :
!    P ANDERSEN SPRES(1):SPRES(2) :SPRES(3) :VIRM(1)  :VIRM(2)  :VIRM(3):
!    P ANDERS-C SPRES(1):         :         :VIRM(1)  :         :       :
! 7  V [BLANK]:         :         :   [Volume is changed with P-control]:
!    V CONST. :         :         :         :  [Volume is kept constant]:
!    V CELL   :BOX(1)   :BOX(2)   :BOX(3)   :BOX(4)   :BOX(5)   :BOX(6) :
!    V DENSITY:DENSTY   :         :         :         :         :       :
!    D CONST. :DENSTY   :         :         :         :         :       :
!    V CHANGE : ICAXIS  : BTAGET  : BCNGR(A par step) :         :       :
! 8  BUSING   :MODE,MXN2:(ALPHA)  :         :         :         :       :
!    MORSE    :         :         :         :         :         :       :
!    MORSE-AT :         :         :         :         :         :       :
!    BMH-EXP  :         :      3-body   sqrt(k1xk2)   :         :       :
!    BMH-EXP* :         :      3-body   k1xk2         :         :       :
!    BELONO   :         :         :         :         :         :       :
!    TOSIFUMI :         :         :         :         :         :       :
!    WOODCOCK :         :         :         :         :         :       :
!    PAULING  :         :         :         :         :         :       :
!    METAL    :         :         :         :         :         :       :
!    PAIR-P   :         :         :         :         :         :       :
!    STSUNE   :         :         :         :         :         :       :
!    L-J      :         :         :         :         :         :       :
! 81 N A  NO. :ZI       :WI       :AI       :BI       :CI(VW)   :DI()   :
!     -       :         :         :         :         :   not moved     :
!     *       :         :         :         :         :   dummy atoms   :
!     =       :         :         :         :         :   Morse only    :
! 81e[BLANK]  :         :         :         :         :         :       :
! 82  I J     :DMIJ     :BEIJ     :RSIJ     :         :      [Morse]    :
!     J I J   :FK3BP    :ANG3BP   :R3BLIM   :R3BGD    :       [3-body]  :
!     J I K   :FK3BP(1) :ANG3BP(1):R3BLIM(1):R3BGD(1) :   [3-body(J<>K)]:
!             :         :         :R3BLIM(2):R3BGD(2) :         :       :
!(82) I J     :AIJ      :BIJ      :CIJ      :         :    (eV) [Pair-U]:
!(82) I J     :AIJ      :BIJ      :CIJ      :         :(kJ/mol) [Pair-P]:
! 82e[BLANK]  :         :         :         :         :         :       :
!             :         :         :         :         :         :       :
! 91 STRUCTURE:         :         :       9 :         :         :       :
! 92 NETWORK  :NFCION(1):NFCION(2):      10 : [Network structure analy.]:
! 93 VELOCITY :NS09PV   :PVMULT   :      11 : [Record particle velocity]:
!    POSITION :NS09PV   :PVMULT   :      11 :         [... ... position]:
!    ENERGY   :NS09PV   :PVMULT   :      11 :         [....... energy  ]:
!    POSVELENE:NS09PV   :         :      11 :     [..... pos,velo,ener] :
! 94 QUANTUM  :         :         :      12 :       [Quantum correction]:
! 95 PCF, RDF : ISTEP   : Rend(A) :      13 :      [Format of PCF table]:
!*96 DIPOLE   :         :         :      14 :         [E(dipole moment)]:
! 97 CENTER   :         :         :      15 :[Centering of atom cluster]:
!    CENTERING:  iaxcen :         :         :         :          :      :
! 98 NO(MV=0) :         :         :      16 :[No correction for morment]:
!    AM(MV=0) :  Iamv   :  Namv   :         [Moment correction for Iamv]:
!             :         :         : if Namv>0 then oly Namv atoms used  :
! 99 CRYSTAL  :         :         :      17 :  [MD of crystal structure]:
! 9A BINARY   :         :         :      18 : [Binary data for file09x.]:
! 9B PRESSURE : NPRESS  :         :      19 :[Pressure tensor on file11]:
! 9C ELEC.FIELD   EFD1  :   EFD2  :   EFD3  : EFFEQ 20: [Electric field]:
! 9D GRAV.FIELD   GFD1  :   GFD2  :   GFD3  :       21:  [Gravity field]:
! 9E CONSTSHEAR  VX-RY  :  VY-RZ  :  VX-RZ  :(ps)-1 22:[Const.shear rat]:
! 9F DIATOMIC :  DINTRA :iatom2(1):iatom2(2):       23:[Diatomic molec] :
! 9G CUBE     :         :         :         :       24:[to Cubic cell]  :
! 9H CONVEC   :  FCONVC :         :         :       25:[Convection]     :
! 9I MOLECULE :  Dintra :  Mstart :  Mend   :       26:[Define molecule]:
! 9J EXCLUSION:         :         :         :       29:[Exclusion]      :
!    COLUMN   :  iaex   : Rexcl(radius)     :         :     R>0  out    :
!    SLUB     :  iaex   : Rexcl(Thickness/2):         :     R<0  in     :
!    CUBE     :  Rexcl(edge/2)    :         :         :         :       :
!    SPHERE   :  Rexcl(radius)    :         :         :         :       :
! 9K WALL     :   A     :    B    :         :   28:[Soft repulsive wall]:
! 9L POLYATOM :  Dintra :MOLstart : MOLend  :   29:[Polyatomic molecule]:
! 9n ........ :         :         :         :         :         :       :
! 9e [BLANK]  :         :         :         :         :         :       :
! 9           :         :         :         :         :         :       :
!    MD.......I....:....I....:....I....:....I....:....I....:....I....:..:
!    REPEAT  1 TO 9                                                     :
!=======================================================================I
!      IRECRD                            NRECRD                         :
!      -----------------------------     -----------------------------  :
! 1    Total number of steps             Current step No. from 'START'  :
! 2    Interval of print PCF etc.        Accumulation No. of PCF etc.   :
!                                               (I2=N2 when 'ACCUM')    :
! 3    Interval of FILE07 recording      Current step number            :
!           (default: 50)                           in the current job  :
! 4    Interval of FILE09P recording     Number of records in FILE09P   :
!           (default: 50:MD. 5:XD)                                      :
! 5    Interval of FILE09V recording     Number of records in FILE09V   :
!           (default: 5)                                                :
! 6    Number of steps of current HIST   Number OF HISTRY informations  :
! 7-8  Not used                          Not used                       :
! 9    Interval of FILE09PV recording    Number of steps in FILE09PV    :
!=======================================================================I
!    I/O number        FLNAME         Filename                          :
!        5                -           input from keyboad                :
!       15              ( 5)          FILE05.DAT         in             :
!        6, *             -           screen output      out            :
!       16              ( 6)          FILE06.DAT         out            :
!       17              ( 7)          FILE07.DAT         in/out         :
!       18              ( 8)          FILE08.DAT         in/out         :
!       38              (18)          FILE081.DAT        in/out         :
!       19              ( 9)          FILE09P.DAT        in/out         :
!       10              (10)          FILE10.DAT         in             :
!       29              (11)          FILE09V.DAT        in/out         :
!       28              (12)          FILE09PV.DAT       out            :
!       27              (13)          FILE11.DAT         out            :
!       22              (19)          TEMPO.DAT          in/out(work)   :
!=======================================================================I
!   LNI : Maximum number of particles (ion or atom) in a basic cell     :
!   LTB : Maximum table length of Coulomb energy and force              :
!   LSR : Table length of short range interactions                      :
!   LEL : Maximum number of particle species                            :
!   LEE : Number of pairs of particle species                           :
!   LCT : Maximum number of steps                                       :
!   LNV : Maxinum number of reciprocal lattice points in EWALD sum.     :
!   LAA : Maximum number of atoms in a asymmetric unit (XD)             :
!   LAT : Maximum number of atoms in a crystal unit cell (XD)           :
!=======================================================================I
!  P(3,LNI) : Fractional coordinates of atoms, 0=<p<1                   :
!  V(3,LNI) : Displacements (in A) of atoms for priod of dtime(delta-t) :
!  VP(3,LNI): Displacements (in A) of atoms at one step before          :
!=======================================================================I
!  RUNOPT(1) = 'MD........'  'XD........'  'MDX.......'                 :
!        (2) = '          '  'START     '  'CONT.     '  'STOP      '   :
!              'END       '  'RESTART   '  'CONTINUE  '                 :
!        (3) = 'DETAIL    '  'NORMAL    '  'ECONOMY   '                 :
!        (4) = 'ACCUM     '  'NOACCUM   '                               :
!        (5) = 'T NO-CNTL '  'T SCALING '  'T NOSE    '  'T SCALE-A '   :
!        (6) = 'P NO-CNTL '  'P SCALING '  'P ANDERSEN'  'P ANDERS-C'   :
!        (7) = 'V CONST.  '  'V FREE    '  'D CONST.  '  'V CELL    '   :
!              'V DENSITY '  'V CHANGE  '                               :
!        (8) = '          '  'BUSING    '  'MORSE     '  'MORSE-AT  '   :
!              'TOSIFUMI  '  'WOODCOCK  '  'PAULING   '  'STSUNE    '   :
!              'L-J       '  'METAL     '  'PAIR-P    '                 :
!              'BMH-EXP   '  'BMH-EXP*  '                               :
!        (9) = 'STRUCTURE '  '          '                               :
!       (10) = 'NETWORK   '  '          '                               :
!       (11) = 'VELOCITY  '  'POSITION  '  'ENERGY    '  'POSVELENE '   :
!       (12) = 'QUANTUM   '  '          '                               :
!       (13) = 'PCF       '  'RDF       '  '          '                 :
!       (14) = 'DIPOLE    '  '          '                               :
!       (15) = 'CENTER    '  'CENTRE    '  'CENTERING '                 :
!       (16) = 'NO(MV)=0  '  '          '                               :
!       (17) = 'CRYSTAL   '  'AMORPHOUS '                               :
!       (18) = 'BINARY    '  '          '                               :
!       (19) = 'PRESSURE  '                                             :
!       (20) = 'ELEC.FIELD'                                             :
!       (21) = 'GRAVITY   '                                             :
!       (22) = 'CONSTSHEAR'                                             :
!       (23) = 'DIATOMIC  '                                             :
!       (24) = 'CUBE      '                                             :
!       (25) = 'CONVEC    '                                             :
!       (26) = 'MOLECULE  '                                             :
!       (27) = 'EXCLUSION '                                             :
!       (28) = 'WALL      '                                             :
!       (30) = 'EWALD-C   '                                             :
!       (31) = 'POTSURF   '                                             :
!       (32) = '          '                                             :
!           ...                                                         :
!       (51) = 'THERMOSTAT'  '          '                               :
!       (52) = 'H-TENSOR  '  '          '                               :
!=======================================================================I
!               Contents of VAL(1) - VAL(LVA=64) variables              :
!  No.   : Meanings                                                     :
!  1     : Temperature                                              / K :
!  2     : Pressure                                               / GPa :
!  3-8   : Components of pressure tensor(xx,yy,zz,xy,xz,yz)       / GPa :
!  9     : Coulomb energy                                    / kJ.mol-1 :
!  10    : Short range energy                                / kJ.mol-1 :
!        :             (repulsion,van der Waals,Morse,etc.)             :
!  11    : Three body potential energy                       / kJ.mol-1 :
!  12    : Total potential energy (9+10+11)                  / kJ.mol-1 :
!  13    : Kinetic energy                                    / kJ.mol-1 :
!  14    : Total internal energy (9+10+11+13)                / kJ.mol-1 :
!  15    : PV (pressure x volume)                            / kJ.mol-1 :
!  16    : Enthalpy (14+15)                                  / kJ.mol-1 :
!  17    : Density                                             / g.!m-3 :
!  18    : Molar volume                                     / !m3.mol-1 :
!  19-21 : Basic cell parameters: A, B, C                            /A :
!        :               (Crystal unit cell (a,b,c) in XD)              :
!  22-24 : Cell angles  cos(alpha), cos(beta), cos(gamma)               :
!  25-44 : Temperatures of ion species (20 components)              / K :
!  45-64 : Mean square displacement (20 components)               / A^2 :
!=======================================================================I
!
module param
  implicit none
    integer(KIND=4),parameter:: LNI=150000, LTB=10004, LEL=20, LEM=20
    integer*4, parameter:: LEMW=21
    integer(KIND=4),parameter:: LCT=5000000, LSR=1254, LEE=LEL*(LEL+1)/2
    integer(KIND=4),parameter:: L50=LCT/50+1,LAA=172, LNV=500000, LST=32
    integer(KIND=4),parameter:: LEF=LEM*(LEM+1)/2, LAT=LAA*4,LVA=LEM*2+24
    integer(KIND=4),parameter:: L3P=20, LRG=LNI*5, L3R=300
!
    double precision,parameter:: PI  = 3.14159265357D0
    double precision,parameter:: PI180 = 180.0D0/PI
    double precision,parameter:: ANA = 6.0221367D23    !Avogadro const. / mol-1
!    double precision,parameter:: AKB = 1.380658D-23    !Boltzmann const. /J K-1
    double precision,parameter:: AKB = 1.380658D-16    !Boltzmann const. /erg K-1
    double precision,parameter:: AHP = 6.6260755D-27   !Plank const. /erg s
    double precision,parameter:: EP0 = 8.854187817D-12 !Permittivity of vacuum /F m-1
    double precision,parameter:: CVL = 2.99792458D10   !velocity of light in vacuum /cm s-1
    double precision, parameter:: ELCC = 1.602176462D-19 ! elementary charge C
    double precision,parameter:: ELC = ELCC*CVL*0.1D0 !elementary charge /C esu 
!                                                        CVL usually 3D8 then ELC = e*CVL*10.0D0
    double precision,parameter:: CAL = 4.18605D0       !Converstion from calory to joule
    double precision,parameter:: PI2 = 2.0D0*PI
    character *1, parameter:: ins(1:20) = (/ '1','2','3','4','5','6','7','8','9',&
                                             'A','B','C','D','E','F','G','H','I','J','K' /)
end module
module charac
  use param
  implicit none
    character(len=4):: TITLE(15),ATOM(LEMW),ATMNET(2),ATMXTL(LAA)
    character(len=10):: RUNOPT(56)
    character(len=16):: FLNAME(19)
end module
module timdat
  implicit none
    integer(KIND=4) KKTIME(7,2)
end module
module atomsi
  use param
  implicit none
    double precision P(3,LNI),V(3,LNI),VP(3,LNI),P0(3,LNI)
    double precision UI(LNI),AU(LNI),AV3BP(2,L3P),UIC(LNI),PP0(3,LNI) ! Nose-Hoover
    double precision :: UICP1(LNI) = 0.0D0, UICP2(LNI) = 0.0D0, UICP3(LNI) =0.0D0, UICP4(LNI) = 0.0D0
    integer(KIND=4) NTION,NION(LEMW),IONS(2,LEMW),NCOMPO,Iamv,ICD,Namv
    integer(KIND=4) NTIOND, NIOND(LEMW),IOND(LNI),NPAIR,IION(LEMW)
end module
module temprs
  implicit none
    double precision DTIME,TEMP,DELTMP,TMPGET,TINT,TPRE,STEMP(4),VSTEMP(4)  !Nose-Hoover
    double precision STEMP2,STEMP3,STEMP4,KBT  !Nose-Hoover
    double precision TDUMP,SPRES(3),PPXYZ(7),FJMOL,PXYZ(7),DTMO,PDUMP
    integer(KIND=4) NTSTEP,nfnose !Nose-Hoover
end module
module aboxof
  implicit none
    double precision BOX(6),VBOX(6),VOL,DENSTY,VIRM(6),RCUT(2)
    integer(KIND=4) NRCUT(2),MXCUT,NFORML,IAXCEN
end module
module values
  use param
  implicit none
    double precision TVAL(LVA),SVAL(LVA),TVALL(LVA),SVALL(LVA),VALMAX(LVA)
    double precision VALMIN(LVA),VAL0(LVA),VAL(LVA),AVA(LVA,L50)
    integer(KIND=4) NAV,NAVT
end module
module paramt
  use param
  implicit none
    double precision AIO(LEMW),BIO(LEMW),CIO(LEMW),DIO(LEMW),ZIO(LEMW)
    double precision AIJ(LEF),BIJ(LEF),CIJ(LEF),DIJ(LEF),D4IJ(LEF)
    double precision PLIJ(LEF),RSWTCH(LEF),ZIJ(LEF),D7IJ(LEF)
    double precision ECORR,VCORR,WIO(LEMW),TWEGHT,AKFI(LEM)
    double precision ANG3BP(L3P),R3BLIM(2,L3P)
    double precision FK3BP(L3P),R3BGRD(2,L3P),R3lim(2,l3p),r3limax
    integer(KIND=4) I3BP(3,L3P),N3BP
end module
module geomet
  use param
  implicit none
    double precision DTO(2),AVTHT(12),RTO(2),SVTHT(12),ANGL(3,12),TTAB(LST)
    integer(KIND=4) MBR(8,8,2),NRG(9,2),ITBR(121,12),NBR(8,8,2),MEB(9,2)
    integer(KIND=4) NTT(121,12),NTO(2),NVTHT(12),NTBL
end module
module tables
  use param
  implicit none
    double precision F1(LSR,LEE),E1(LSR,LEE),F0(LTB),E0(LTB)
end module
module counts
  implicit none
    integer(KIND=4) NJOB(2),IRECRD(9),NRECRD(9),IHISTR(4,111)
    double precision PVMULT
end module
module vector
  use param
  implicit none
    double precision FNV(LNV),UNV(LNV),PNV(6,LNV),ZIA(LEM),UCSELF,ZIIA(LNI)
    double precision ALPHA,UCSLFI(LEMW),ZIIC(LNI)
    integer*4 MODE,NVN,NVEC(3,LNV)
end module
module acoord
  use param
  implicit none
    double precision BOXO(6),P0C(3,LAT),PPC(3,LAT),RS(3,3,96),PPS(3,LAT)
    integer(KIND=4) NPT,NIU(LAA),NSYM,ISYM(LNI),NPTP,NBOX(3),JON(LAT)
    integer(KIND=4) MATM,IHEX
end module
module radial
  use param
  implicit none
    integer(KIND=4) NRDF(LTB,LEE),IPRDF(2)
end module
module forces
  use param
  implicit none
    double precision FX(LNI),FY(LNI),FZ(LNI)
end module
module cartes
  use param
  implicit none
    double precision H(3,3),HINV(3,3),FTOQ(3,3),RBOX(6),G(3,3),GINV(3,3)
    double precision TRANSX(8),TRANSY(8),TRANSZ(8)
!T    double precision Q(3,LNI),Q0(3,LNI)
end module
module molecu
  use param
  implicit none
    double precision ZMOLE(2),DMOLE(4,LNI),DINTRA
    integer(KIND=4) :: NDMOLE = 0,IDMOLE(3,LNI),IATOM2(2),MOLstart(2)
    integer(KIND=4) NMOLE,IMOLE(11,LNI),MOLend(2)
!    integer(KIND=4), allocatable :: MMOLE(:)
    integer(KIND=4) MMOLE(LNI)
    integer(KIND=4) IATOMO,IATOMH,ITER,ITERSH,NIONO
    integer(KIND=4):: istart = 0
    double precision, allocatable, save ::  HHX(:),HHY(:),HHZ(:),HHV(:)
    double precision, allocatable, save ::  OPX(:),OPY(:),OPZ(:),OPV(:)
    double precision, allocatable, save ::  LOP1X(:),LOP1Y(:),LOP1Z(:)
    double precision, allocatable, save ::  roh1(:),roh2(:),A1(:),A2(:)
    double precision, allocatable, save ::  DPV(:),DPX(:),DPY(:),DPZ(:)
    double precision, allocatable, save ::  DPX1(:),DPX2(:),DPY1(:),DPY2(:),DPZ1(:),DPZ2(:)
    double precision, allocatable, save ::  UDPX1(:),UDPX2(:),UDPY1(:),UDPY2(:),UDPZ1(:),UDPZ2(:)
    double precision, allocatable, save ::  QLP1(:),QLP2(:),QLP1z(:),QLP2z(:),QLPx(:)
    double precision, allocatable, save ::  QHHk(:),QHHm(:)
    double precision, allocatable, save ::  E34(:),idipX(:,:),idipY(:,:),idipZ(:,:)
    double precision, allocatable, save ::  pdipX(:),pdipY(:),pdipZ(:),Edp1(:),Edp2(:)
    double precision, allocatable, save ::  idp2(:),watpol(:,:)
    integer(KIND=4), allocatable, save ::ih2o(:,:)
    double precision, save ::  upol,THRESHD,maxedip,sumedip,dampp
    double precision,parameter:: DIP = 4.803204D0      !used for dipole moment
    double precision, parameter:: DEBYE = 1.0D-19/CVL ! 1*DEBYE Cm = 1 D = 1e-18 esu cm
    double precision,parameter:: POL = 4.0D0*PI*EP0*1.D-17/ELCC**2       !used for polarizability
    double precision,parameter:: EPOL  = 4.0D0*PI*EP0*1.0D-27/ELCC  ! used for UPOL
    double precision,parameter:: EPOLL = 4.0D0*PI*EP0*1.0D-30
!    double precision,parameter:: WATPOLHH = 1.47D0, WATPOLLP = 1.47D0, WATPOLDP = 1.47D0   ![Angstrom^3]
    double precision, parameter:: WATPOLLP =1.44D0, WATPOLDP = 1.90D0
    double precision, parameter:: EPOLLL = ELCC**2/(4.0D0*PI*EP0*1.0D-25) !for dyn
    double precision RD,DLP
    double precision,parameter ::GEb = 3.13885D-10, Emb=7.57695D9 !C/N and N/C
    double precision,parameter ::GEb_pol = GEb/(ELCC*1.0D-3), Emb_pol = Emb*ELCC*1.0D-3
    double precision,parameter ::Ediv = 1.00D10*ELCC*1.0D-3, DMAX = 2.8D0-1.87D0
    double precision,parameter ::ECOFF = DEBYE/EPOL
end module
module charge  ! WATER-POL
  use param
  implicit none
  double precision ZII(LNI),ZICOS(LNI),ZISIN(LNI),ZIIP(LNI)
end module
module pmorse
  use param
  implicit none
    double precision DMIJ(LEF),BEIJ(LEF),RSIJ(LEF),DM1IJ(LEF),BE1IJ(LEF)
    double precision DM2IJ(LEF),BE2IJ(LEF)
end module
module quanco
  use param
  implicit none
  double precision Q1U1(LSR,LEE),Q2U1(LSR,LEE)
  double precision TQCE, QCEE,QCIT,QCEF,TEMPQH,TEMPQQ
end module
module ewal
  use param
  use, intrinsic :: iso_c_binding ! SPME
  implicit none
!  include 'fftw3-mpi.f03' !SPME
  double precision PRSTC2(6),VIRLSR
  double precision :: VIRLSRP= 0.0D0
  integer(KIND=4) iaxis,JJJ,KRDF
! -----------------------------------------------------------------------SPME
  double precision, allocatable :: THREC(:,:,:)
  double precision, allocatable :: PNVxx(:,:,:),PNVyy(:,:,:),PNVzz(:,:,:)
  double precision, allocatable :: PNVxy(:,:,:),PNVxz(:,:,:),PNVyz(:,:,:)
  complex(C_DOUBLE_COMPLEX), allocatable :: ARQ(:,:,:),DARQ(:,:,:)  !SPME
  complex(C_DOUBLE_COMPLEX), allocatable :: DARQp(:,:,:)  !SPME
!  complex(C_DOUBLE_COMPLEX), allocatable :: OARQ(:,:,:)  !SPME
  double precision, allocatable :: AQX(:,:),AQY(:,:),AQZ(:,:)
  double precision, allocatable :: dMdux(:,:),dMduy(:,:),dMduz(:,:)
  double precision, allocatable :: bxsq(:),bysq(:),bzsq(:)
  integer, allocatable :: kkx(:,:),kky(:,:),kkz(:,:)
  double precision QCOFF,FCOFF,PCOFF,ARRB,ARRC
  integer ::NVNx=0,NVNy=0,NVNz=0
  integer NDIM,nkai
! -----------------------------------------------------------------------SPME
end module
module outerf
  implicit none
  double precision EFD(3),EFREQ,GFD(3),fconvc
  integer(KIND=4) MEFD,NATOM
end module
module wallp
  implicit none
    double precision WALLa, WALLb
end module
module datoms
  use param
  implicit none
  double precision D1ATOM,D1AXYZ(3),D2ATOM,D2AXYZ(3)
  double precision ddatom(100,lni)
  integer(KIND=4) idatom(101,lni)
  integer(KIND=4) idatom101(lni)
end module
module struct
  use param
  implicit none
  double precision DONB(6,LNI)
  integer(KIND=4) IONB(6,LNI),lentab
end module
module pos
  use param
  implicit none
  double precision PX(LNI),PY(LNI),PZ(LNI)
end module 
module boxcng 
  implicit none
  double precision BTAGET,BCNGR
  integer*4 ICAXIS
end module
module exclus
  implicit none
  double precision rexcl, fexcl
  integer(KIND=4) iaex, iextype
end module
!
PROGRAM  MXDORTHOP
  use param
  use charac
  use timdat
!  implicit none
!
  integer*4      iii(3)
  integer*4 I,ierr,myrank,mpsize
  integer*4      IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
  include  'mpif.h'

!
!
!
                    FLNAME(1)  = 'MD-XD-ORTHO-P  '
!                   FLNAME(1)  = 'MD-XD-TRICL    '
                    FLNAME(2)  = '2025-Nov-19-00 '
!                   ----------------------------------------- Select one
!                   FLNAME(3)  = 'Lehey LF90     '
!                   FLNAME(3)  = 'Ms-Fortran     '
!                    FLNAME(3)  = 'DEC Fortran    '
!                   FLNAME(3)  = 'NDP-FORTRAN386 '
!                   FLNAME(3)  = 'DEC Fortran    '
!                   FLNAME(3)  = 'LUNA88K        '
!                   FLNAME(3)  = 'PARALLEL-F77   '
!                   FLNAME(3)  = 'HP-9000        '
!                   FLNAME(3)  = 'DN10000        '
!                   FLNAME(3)  = 'S820-80        '
!                   FLNAME(3)  = 'NEWS-F77       '
!                   FLNAME(3)  = 'CRAY-F77       '
!                   FLNAME(3)  = 'IBM-AIX-FORT   '
                    FLNAME(3)  = 'F90            '
!                   FLNAME(3)  = 'Dummy          '
!                   ----------------------------------------------------
                    FLNAME(4)  = ' -- not used --'
!                   FLNAME(5)  = 'd:\mxdprun\file05.dat    '
!                   FLNAME(6)  = 'd:\mxdprun\file06.dat    '
!                   FLNAME(7)  = 'd:\mxdprun\file07.dat    '
!                   FLNAME(8)  = 'd:\mxdprun\file08.dat    '
!                   FLNAME(9)  = 'd:\mxdprun\file09p.dat   '
!                   FLNAME(10) = 'd:\mxdprun\file10.dat    '
!                   FLNAME(11) = 'd:\mxdprun\file09v.dat   '
!                   FLNAME(12) = 'd:\mxdprun\file09pv.dat  '
!                   FLNAME(13) = 'd:\mxdprun\file11.dat    '
!
                    FLNAME(5)  = 'file05.dat      '
                    FLNAME(6)  = 'file06.dat      '
                    FLNAME(7)  = 'file07.dat      '
                    FLNAME(8)  = 'file08.dat      '
                    FLNAME(18) = 'file081.dat     '
                    FLNAME(9)  = 'file09p.dat     '
                    FLNAME(10) = 'file10.dat      '
                    FLNAME(11) = 'file09v.dat     '
                    FLNAME(12) = 'file09pv.dat    '
                    FLNAME(13) = 'file11.dat      '
                    FLNAME(14) = ' -- not used -- '
                    FLNAME(15) = ' -- not used -- '
                    FLNAME(16) = 'charge.dat      '    !WATER-POL
                    FLNAME(17) = 'potensurf.dat   '
!                    FLNAME(16) = 'zdens.dat       '
                    FLNAME(19) = 'tempo.dat       '
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
                     KKTIME(1,1) = IYEAR
                     KKTIME(2,1) = IMONTH
                     KKTIME(3,1) = IDAY
                     KKTIME(4,1) = IHOUR
                     KKTIME(5,1) = IMINUT
                     KKTIME(6,1) = ISECND
                     KKTIME(7,1) = I100TH
                     DO I = 1, 7
                        KKTIME(I,2) = KKTIME(I,1)
                     enddo
!
!
!     -------------------------------------------------------------- MPI
      call  MPI_init  (ierr)
      call  MPI_Comm_Rank  (MPI_COMM_WORLD, myrank, ierr)
      call  MPI_Comm_Size  (MPI_COMM_WORLD, mpsize, ierr)
!                       ------------------------------ MPI slave process
      if (myrank /= 0)  call  EWALDP2  (myrank, mpsize)
      write (6,*) 'Number of CPU''s =',mpsize
!
!     --------------------------------------------------------- MD start
      WRITE  (6,1000)  FLNAME(1), FLNAME(2)
 1000 FORMAT ('Welcome to MOLECULAR DYNAMICS SIMULATION WORLD: ',A11,' Version ',A11)
!
      CALL  MDMAIN  (myrank, mpsize)
!
!     ---------------------------------------------------- Terminate MPI
                      iii(1) = -9999
                      iii(2) = -9999
                      iii(3) = -9999
      call  MPI_Bcast (iii(1), 3, MPI_INTEGER4, 0, MPI_COMM_WORLD, ierr)
      call  MPI_Finalize  (ierr)
!
!     ------------------------------------ Display start and finish time
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
      WRITE (*,9898)  INT(KKTIME(4,1)),INT(KKTIME(5,1)),INT(KKTIME(6,1)),&
                      INT(KKTIME(2,1)),INT(KKTIME(3,1)),IHOUR,IMINUT,ISECND,IMONTH,IDAY
 9898 FORMAT (/ 3X,73('=') / 4X, &
                '===== Started at ',I2,':',I2,':',I2,' on ',I2,'/',I2,  &
                   ', finished at ',I2,':',I2,':',i2,' on ',I2,'/',I2,  &
                ' =====' / 3X,73('=') )
      stop
      END
!
!
!                                                               ========
!================================================================ MDMAIN
SUBROUTINE  MDMAIN  (myrank, mpsize)
!
  use param
  use charac
  use timdat
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use geomet
  use tables
  use counts
  use vector
  use acoord
  use radial
  use forces
  use wallp
!
  implicit none
!
      COMMON /WORK01/ DDDD(6,LNI)
         double precision DDDD
      COMMON /WORK02/ IIII(6,LNI)
         integer*4 IIII
!
!
      integer*4      IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
      integer*4 J,MM,NN,myrank,mpsize,I,INOEND
      CHARACTER  *3   ORDNL1, ORDNL2, ORDNLS(4)
      DATA            ORDNLS / '-st', '-nd', '-rd', '-th' /
      real(8) :: ct(0:1), et(0:1)
!
!     ----------------------------------- Open file05.dat and file06.dat
!     OPEN   (*, FILE='CON:')
!
! ***           file05.dat : INPUT FILE FOR RUN SPECIFICATION
      OPEN (15, FILE=FLNAME(5), STATUS='OLD',  &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
! ***           file06.dat : SO CALLED SYSOUT FILE (WRITE (16,... ONLY)
      OPEN (16, FILE=FLNAME(6), STATUS='UNKNOWN',  &
                ACCESS='SEQUENTIAL', FORM='FORMATTED' )
!
!     ----------------------------- Enter subroutine for initial setting
 1111 CALL  INITIA  (INOEND)
                     IF (INOEND    < 0)  GO TO 9999
                     IF (IRECRD(2) <= 0)  GO TO 8888
                     IF (IRECRD(1) <= 0)  GO TO 8888
      NRECRD(3) = 0
!
      WRITE  (*,4002)  (I,RUNOPT(I),I=1,54)
 4002 FORMAT ('Option[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' / &
                 6X,'[',I2,':',A8,5(I3,':',A8),']' )
                      ORDNL1 = ORDNLS(4)
                      IF (MOD(NRECRD(1)+1,10) == 1)  ORDNL1 = ORDNLS(1)
                      IF (MOD(NRECRD(1)+1,10) == 2)  ORDNL1 = ORDNLS(2)
                      IF (MOD(NRECRD(1)+1,10) == 3)  ORDNL1 = ORDNLS(3)
                      ORDNL2 = ORDNLS(4)
                      IF (MOD(IRECRD(1),10) == 1)  ORDNL2 = ORDNLS(1)
                      IF (MOD(IRECRD(1),10) == 2)  ORDNL2 = ORDNLS(2)
                      IF (MOD(IRECRD(1),10) == 3)  ORDNL2 = ORDNLS(3)
!
              IF (RUNOPT(31)  ==  'POTSURF   ')THEN
                CALL POSURF (myrank,mpsize)
                GO TO 9999
              ENDIF
!
      CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
      WRITE  (*,4001)  IHOUR,IMINUT,ISECND, IYEAR,IMONTH,IDAY,  &
                       NRECRD(1)+1,ORDNL1,IRECRD(1),ORDNL2
 4001 FORMAT ('Started at ',I2,':',I2,':',I2,' on ',I4,'/',I2,'/',I2,  &
               3X,'from ',I7,A3,' step, until ',I7,A3,' step')
!
!              ===============================================
!     ============== Start of a series of MD calculation ==============
!     ======                                                     ======
 5555                     NRECRD(3) = NRECRD(3) + 1
                          NRECRD(1) = NRECRD(1) + 1
                          IRECRD(6) = IRECRD(6) + 1
!call timer( ct(0), et(0), "" )
!if ( myrank == 0 ) call write_border( "start" )
              IF (NRECRD(3) == 1.OR. &
                  MOD(NRECRD(1),IRECRD(3)) == 1)  CALL CLEARS
!
!call timer( ct(1), et(1), "" )
              CALL  NEWTON  (myrank, mpsize)
!call timer( ct(1), et(1), "(NEWTON)" )
!
              CALL  RECORD9
!call timer( ct(1), et(1), "(RECORD09)" )
              IF (IRECRD(1) == 1)                 GO TO 8888
!call timer( ct(0), et(0), "(end)" )
!if ( myrank == 0 ) call write_border( "end" )
              IF (MOD(NRECRD(1),IRECRD(3)) /= 0)  GO TO 7777
!call timer( ct(1), et(1), "" )
                     CALL  INTVAL
                     CALL  STRCTR  (0)
                             NN = IRECRD(2)/IRECRD(3)
                             MM = MOD(NRECRD(1)/IRECRD(3), NN)
                     IF (MOD(MM,2) == 0 .AND. &
                         MOD(NRECRD(1),IRECRD(2)) == 0)  THEN
                            IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
                                   CALL  COORDN
                            END IF
                                   CALL  PCFRCN
                                   CALL  POTPLT
                     END IF
                     CALL  F07F08  (1)
!call timer( ct(1), et(1), "(7777)" )
!call timer( ct(1), et(1), "" )
 7777         IF (NRECRD(1) < IRECRD(1))  GO TO 5555
!call timer( ct(1), et(1), "(5555)" )
!     ======                                                     ======
!     ============== End of the series of MD calculation ==============
!              ===============================================
!
      CALL  TITLET  (1, 0)
      CALL  SUMMRY
 8888 CONTINUE
      IF(runopt(26)  == 'MOLECULE  ') call MOLECULE
      CALL  STRCTR  (1)
      CALL  TITLET  (0, 0)
!
      IF (RUNOPT(11) /= '          ') THEN
          IF (RUNOPT(18) == 'BINARY    ') THEN
              WRITE (28)  -999, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
          ELSE
              WRITE (28,9002)  -999, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
 9002         FORMAT (I7, 3X, 9F7.3)
          ENDIF
          ENDFILE 28
          CLOSE (28)
      END IF
      IF (RUNOPT(19) == 'PRESSURE  ') THEN
             WRITE (27,2013)  (999.9999,J=2,8)
 2013        FORMAT (7F9.4)
             CLOSE (27)
      END IF
!
      GO TO 1111
!
!
!     --------------------------------------------------------- Finish !
 9999        ENDFILE  16
             REWIND   16
             CLOSE   (16)
!
             IF (TITLE(1) /= 'BENC' .OR. TITLE(2) /=     'HMAR'     )  THEN
                    ENDFILE  29
                    ENDFILE  19
                    REWIND   29
                    REWIND   19
                    CLOSE   (29)
                    CLOSE   (19)
             END IF
             IF (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') CLOSE(26)
!
      return
      END
!
!
!                                                               ========
!================================================================ TITLET
SUBROUTINE  TITLET  (ID,JD)
  use param
  use charac
  use temprs
  use aboxof
  use counts
  use radial
!
  implicit none
!
  integer(KIND=4)     IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  integer(KIND=4)     ID,JD,I,J,N,K,L
!
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
!
!                                OUTPUT HISTRY OF THE SYSTEM
  IF (ID == 0)  THEN
    IF (JD == 0)  WRITE (16,1001)
    WRITE (16,2002)
    WRITE (16,2001)
    DO I = 1, NRECRD(6), 5
      J = I + 4
      IF (J > NRECRD(6))  J = NRECRD(6)
      N = J - I + 1
      IF (N == 1) WRITE (16,2221)((IHISTR(K,L),K=1,4),L=I,J)
      IF (N == 2) WRITE (16,2222)((IHISTR(K,L),K=1,4),L=I,J)
      IF (N == 3) WRITE (16,2223)((IHISTR(K,L),K=1,4),L=I,J)
      IF (N == 4) WRITE (16,2224)((IHISTR(K,L),K=1,4),L=I,J)
      IF (N == 5) WRITE (16,2225)((IHISTR(K,L),K=1,4),L=I,J)
    enddo
  ELSE
    IF (ID == 1)                WRITE (16,1001)
    IF (ID == 0 .AND. JD /= 1)    WRITE (16,1001)
  END IF
!
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  WRITE (16,1111)                 SPRES(1),IHOUR,IMINUT,ISECND,   &
                  NJOB,TITLE,TEMP,SPRES(2),        &
                                  SPRES(3),IYEAR,IMONTH,IDAY
RETURN
!
 1001 FORMAT (1X)
 1111 FORMAT ('I',130('='),'I'  &
             /'I',10X,       '  :   ',60X, '   :', 12X,      F12.4,   &
                                  7X,':   at  ',I2,':',I2,':',I2,'   I'  &
             /'I',I5,' -',I3,'  :   ',15A4,'   :',F10.1,' K',F12.4,  &
                                                 ' GPa   :',18('-'),'I'  &
             /'I',10X,       '  :   ',60X, '   :', 12X,      F12.4,  &
                                  7X,':   on  ',I4,'/',I2,'/',I2,  ' I'  &
             /'I',130('='),'I' )
 2001 FORMAT ('I',6X, '<<<<< History of this system >>>>>', 5X,  &
                 '< No. of steps >---< Temperature / K >---< Pressure ',  &
                 '/ GPa >---< Date (yymmdd) >',6X,'I')
 2002 FORMAT ('I',130('='),'I')
 2221 FORMAT ('I ',I7,I5,I3,I9,5X, 97X, '   I')
 2222 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,5X, 73X, '   I')
 2223 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,4X, I7,I5,I3,I7,5X,47X, '   I')
 2224 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,4X, I7,I5,I3,I7,4X,I7,I5,I3,I7, 26X, '   I')
 2225 FORMAT ('I ',I7,I5,I3,I7,4X, I7,I5,I3,I7,4X, I7,I5,I3,I7,4X, &
                   I7,I5,I3,I7,4X, I7,I5,I3,I7,'   I')
END
!
!
!                                                               ========
!================================================================ F07F08
SUBROUTINE  F07F08  (INOEND)
  use param
  use charac
  use timdat
  use atomsi
  use temprs
  use aboxof
  use values
  use geomet
  use counts
  use acoord
  use radial
  use charge
  use molecu
!
  implicit none
!
  COMMON /WORK01/ V10(3,LNI), DUMMY(3,LNI)
  double precision   V10,DUMMY
!
  integer(KIND=4)   INOEND
  double precision   H(3,3),RRD
  CHARACTER  *10  RUNO18, RUNO19
  CHARACTER  *4   TITLE0(15), BIN
  CHARACTER  *1   DEFECT, ANS
  integer(KIND=4)   iform7
  integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  integer(KIND=4)   I,J,NCUT0,N,K,KHIST,IO,icstep,nstep
!
  IF (INOEND == 1)  GO TO 501
!     --------------------------------------------- Read from FILE07.DAT
!                         system description, coordinates and velocities
  iform7 = 0
  ICD = 0   ! no charge.dat file WATER-POL
!
  OPEN (17, FILE=FLNAME(7), STATUS='OLD',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    7 READ (17,7007) TITLE0, NJOB, BIN, ICD, ndmole, RRD,&     !WATER-POL
                     NTION, NCOMPO, (NRECRD(I),I=1,9)
!
    IF (NTION > LNI) THEN
      WRITE (*,*) 'Error: No. of ions (', NTION, ') is too large (LNI=', LNI, ') !!!'
      STOP
    END IF
    IF (NCOMPO > LEL) THEN
      WRITE (*,*) 'Error: No. of ion species (',NCOMPO,') is too large (LEL=',LEL,') !!!'
      STOP
    END IF
                        RUNOPT(18) = '          '
    IF (BIN == 'BIN ')  RUNOPT(18) = 'BINARY    '
!
    READ (17,7017) (ATOM(I),I=1,NCOMPO)
    READ (17,7018) (NION(I),I=1,NCOMPO)
    READ (17,7018) (IONS(1,I),I=1,NCOMPO)
    READ (17,7018) (IONS(2,I),I=1,NCOMPO)
    READ (17,7070) TEMP, DELTMP,TMPGET, SPRES,  &
                   DTIME,  RUNOPT(51),  BOX,  &
                   DENSTY, RUNOPT(52), VBOX
    IF (RUNOPT(51) == 'THERMOSTAT')  READ (17,7080) STEMP, VSTEMP
    IF (RUNOPT(52) == 'H-TENSOR  ')  THEN
      DO I = 1, 3
        READ (17,7080)  (H(I,J),J=1,3)
      enddo
    END IF
!
    if (iform7 == 0) then
      WRITE (*,1177) TITLE0, TITLE
 1177   FORMAT (5X,14('='),' Titles in FILE07.DAT and FILE05.DAT are ',  &
                   14('=') /  '=====[F7]: ',15A4,' ===== ' /  &
                              '=====[F5]: ',15A4,' ===== ' )
    end if
!
!T    ------------------- delete this block-if in case of oblique system
    IF (BOX(4)**2+BOX(5)**2+BOX(6)**2 > 1.E-6)  THEN
      WRITE (*,*) 'Error: The box shape is not suitable for MXDORTO !!!'
      WRITE  (*,'("  BOX(4 to 6) are ",3F12.7)') BOX(4),BOX(5),BOX(6)
      WRITE (*,*) 'Is it posibble to change BOX(4), BOX(5), and BOX(6) as zero ?  (y/n)'
      READ  (5,'(a1)') ANS
      IF (ANS == 'n' .OR. ANS == 'N')  STOP
      BOX(4) = 0.0
      BOX(5) = 0.0
      BOX(6) = 0.0
    END IF
!
    IF (NTION > LNI)  WRITE (*,*) 'The number of atoms :',NTION,' is greater than LNI:',LNI
    NTIOND = 0
    DO I = 1, NTION
      IOND(I) = 1
!      if (iform7 == 0 ) then
!        READ (17,7700,err=7878) (P(J,I),J=1,3),  &
!                                 DEFECT, (V10(J,I),J=1,3), (P0(J,I),J=1,3)
!      else
        READ (17,7702,err=7878) (P(J,I),J=1,3),  &
                                 DEFECT, (V10(J,I),J=1,3), (P0(J,I),J=1,3)
!      end if
!      if (abs(V10(1,i)-5.0)+abs(V10(2,i)-5.0)+abs(V10(3,i)-5.0)  >  3.0 ) then
!        if (iform7 == 1)  then
!          write (6,*) i,'-th atom is strange'
!          stop
!        end if
!        iform7 = 1
!        rewind 17
!        go to 7
!      end if
      IF (DEFECT /= ' ') THEN
        IOND(I) = 0
        NTIOND  = NTIOND + 1
        V10(1,I) = 0.0D0
        V10(2,I) = 0.0D0
        V10(3,I) = 0.0D0
      END IF
      DO J = 1, 3
        V(J,I) = (V10(J,I)-5.0D0) * 0.1D0
      enddo
    enddo
    IF (NTIOND > 0) WRITE (*,'(I7," DEFECTS WERE DETECTED ")') NTIOND
    IF (NRECRD(6) > 0) THEN
      READ (17,7800,END=180,ERR=180)  ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
      GO TO 190
      180 NRECRD(6) = 0
    190 END IF
    IRECRD(6) = 0
  CLOSE  (17)
!  if (iform7 == 0) then
!    write (6,*) 'Format of file07.dat will be converted.'
!  end if
  go to 201
!
 7878 write (6,*) 'File07.dat : error at the line ',i+9
      stop
!
  201 IF (RUNOPT(2) == 'RESTART   ')  THEN
    RUNOPT(2) = 'START     '
    NRECRD(6) = 0
    DO I = 1,NTION
      DO J = 1, 3
        P(J,I) = P0(J,I)
      enddo
    enddo
  END IF
!
!     ========================================================= charge.dat !WATER-POL
      IF (ICD == 1) then ! FLNAME(16) = 'charge.dat     '
        nstep = ntion + ndmole
        open (26, FILE=FLNAME(16), status ='old', access='sequential', form='formatted')
260       read (26,'(i10)',end=261,err=261) icstep
          read (26,'(10(F7.4,1x))') (ZII(i),i=1,nstep)
!          write (*,'(i10)') icstep
!          write (*,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
          goto 260
261       if (RUNOPT(2) == 'START     ') then
            rewind(26)
            write (26,'("         0")')
            write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
          endif
      ENDIF
!     ======================================================================
  NBOX(1) = 1
  NBOX(2) = 1
  NBOX(3) = 1
  IF (RUNOPT(17) == 'CRYSTAL   ')  CALL  FILE10
!
  IF (TITLE(1) /= 'BENC'     .OR.  &
      TITLE(2) /=     'HMAR'     )  THEN
!                               file09p.dat : COORDINATES AT EACH 5 STEP
    OPEN (19, FILE=FLNAME(9), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
!                                    file09v.dat : VALUES AT EACH 5 STEP
    OPEN (29, FILE=FLNAME(11), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
  END IF
!
  IF (RUNOPT(2) == 'CONTINUE  '.OR.RUNOPT(2) == 'CONTINUE  ')  THEN
    NJOB(2) = NJOB(2) + 1
!               ----------------------------------- Read from FILE08.DAT
!                                                  PCF, properties, etc.
    OPEN (18, FILE=FLNAME(8), STATUS='OLD',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      REWIND  18
      READ (18,8001) NCUT0,NRCUT(1),NRECRD(2),NAV,NAVT,NTBL,MXCUT,NPAIR
      NRDF(:,:) = 0
      DO I = NCUT0, NRCUT(1)
        READ (18,8001) (NRDF(I,J),J=1,NPAIR)
      enddo
      DO I = 1, LVA
        READ (18,8003) TVAL(I),SVAL(I),SVALL(I),VAL0(I)
      enddo
!                DO I = 1, NAV
!                   READ (18,8003) (AVA(J,I),J=1,LVA)
!                enddo
      READ (18,8003) (AU(I),I=1,NTION)
      DO I = 1, 12
        READ (18,8003) (ANGL(J,I),J=1,3)
      enddo
      DO K = 1, 2
        DO J = 1, 6
          READ (18,8001) (MBR(I,J,K),I=1,6)
        enddo
      enddo
      DO J = 1, 2
        READ (18,8001) (NRG(I,J),I=1,9)
      enddo
      DO I = 1, 121
        READ (18,8005) (ITBR(I,J),J=1,12)
      enddo
      IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
        READ (18,8004) ((PPC(J,N),J=1,3),(PPS(J,N),J=1,3),N=1,NPT)
      END IF
    CLOSE  (18)
!
    OPEN (38, FILE=FLNAME(18), STATUS='OLD',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      REWIND  38
      DO I = 1, NAV
        READ (38,8003) (AVA(J,I),J=1,LVA)
      enddo
    close  (38)
!
    CALL  FILE09
  ELSE
    NJOB(1) = NJOB(1) + 1
    NJOB(2) = 1
    NRECRD(4) = 0
    NRECRD(5) = 0
    IF (TITLE(1) /= 'BENC'     .OR.  TITLE(2) /=     'HMAR'     )  THEN
      REWIND  29
      REWIND  19
    END IF
  END IF
  RETURN
!
!     ========================================= Output file07 and file08
  501 NRECRD(6) = NRECRD(6) + 1
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  IHISTR(1,NRECRD(6)) = IRECRD(6)
  IHISTR(2,NRECRD(6)) = INT(TMPGET)
  IHISTR(3,NRECRD(6)) = INT((SPRES(1)+SPRES(2)+SPRES(3))/3.0)
  IHISTR(4,NRECRD(6)) = IYEAR*10000 + IMONTH*100 + IDAY
  IRECRD(6) = 0
  IF (NRECRD(6) > 1)  THEN
    KHIST = NRECRD(6) - 1
    IF (IHISTR(2,NRECRD(6)) == IHISTR(2,KHIST).AND.    &
          IHISTR(3,NRECRD(6)) == IHISTR(3,KHIST))  THEN
      IHISTR(1,KHIST)=IHISTR(1,NRECRD(6))+IHISTR(1,KHIST)
      IHISTR(4,KHIST)=IHISTR(4,NRECRD(6))
      NRECRD(6) = KHIST
    END IF
  END IF
  IF (TITLE(1) == 'BENC'     .AND.  TITLE(2) ==     'HMAR'     )  GO TO 699
!
  RUNO18 = '          '
  RUNO19 = '          '
!  IF (RUNOPT(5)  == 'T NOSE    ')  RUNO18 = 'THERMOSTAT'
  IF (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') ICD = 1
!
!     ---------------------------------------------- Write on FILE07.DAT
!                         system description, coordinates and velocities
!
  OPEN (17, FILE=FLNAME(7), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    REWIND 17
                                     BIN = '    '
    IF (RUNOPT(18) == 'BINARY    ')  BIN = 'BIN '
    WRITE (17,7007) TITLE, NJOB, BIN, ICD, ndmole, RD, &    !WATER-POL
                    NTION, NCOMPO, (NRECRD(I),I=1,9)
    WRITE (17,7017) (ATOM(I),I=1,NCOMPO)
    WRITE (17,7018) (NION(I),I=1,NCOMPO)
    WRITE (17,7018) (IONS(1,I),I=1,NCOMPO)
    WRITE (17,7018) (IONS(2,I),I=1,NCOMPO)
    WRITE (17,7070) TEMP, DELTMP,TMPGET, SPRES,  &
                    DTIME,  RUNO18, BOX,  &
                    DENSTY, RUNO19, VBOX
    IF (RUNO18 == 'THERMOSTAT')  WRITE (17,7080)  STEMP,VSTEMP
    do io = 1, ncompo
      DO I = ions(1,io), ions(2,io)
        DO J = 1, 3
          V10(J,I) = V(J,I) * 10.0D0 + 5.0D0
        enddo
        DEFECT = ' '
        IF (IOND(I) == 0)  DEFECT = '*'
        WRITE (17,7702) (P(J,I),J=1,3),DEFECT,(V10(J,I),J=1,3),(P0(J,I),J=1,3), io
      enddo
    enddo
    WRITE (17,7800) ((IHISTR(J,I),J=1,4),I=1,NRECRD(6))
    ENDFILE  (17)
    REWIND    17
  CLOSE    (17)
!
!       -------------------------------------------- Write on FILE08.DAT
!                                                  PCF, properties, etc.
  DO N = 1, NRCUT(1)
    DO J = 1, LEE
      IF (NRDF(N,J) > 0)  GO TO 513
    enddo
  enddo
  513 NCUT0 = N - 1
!  NPAIR = NCOMPO * (NCOMPO+1) / 2     !WATER-POL
  OPEN (18, FILE=FLNAME(8), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    REWIND  18
    WRITE (18,8001) NCUT0,NRCUT(1),NRECRD(2),NAV,NAVT,NTBL,MXCUT,NPAIR
    DO I = NCUT0, NRCUT(1)
      WRITE (18,8001) (NRDF(I,J),J=1,NPAIR)
    enddo
    DO I = 1, LVA
      WRITE (18,8003) TVAL(I),SVAL(I),SVALL(I),VAL0(I)
    enddo
!        DO I = 1, NAV
!            WRITE (18,8003) (AVA(J,I),J=1,LVA)
!        enddo
    WRITE (18,8003) (AU(I),I=1,NTION)
    DO I = 1, 12
      WRITE (18,8003) (ANGL(J,I),J=1,3)
    enddo
    DO K = 1, 2
      DO J = 1, 6
        WRITE (18,8001) (MBR(I,J,K),I=1,6)
      enddo
    enddo
    DO J = 1, 2
      WRITE (18,8001) (NRG(I,J),I=1,9)
    enddo
    DO J = 1, 121
      WRITE (18,8005) (ITBR(J,I),I=1,12)
    enddo
    IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
      WRITE (18,8004) ((PPC(J,N),J=1,3),(PPS(J,N),J=1,3),N=1,NPT)
    END IF
!
    ENDFILE  (18)
    REWIND    18
  CLOSE    (18)
!
  OPEN (38, FILE=FLNAME(18), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    REWIND  38
    DO I = 1, NAV
      WRITE (38,8003) (AVA(J,I),J=1,LVA)
    enddo
    ENDFILE  (38)
    REWIND    38
  CLOSE    (38)
!
  699     WRITE (*,4001)  IRECRD(1)
 4001     FORMAT (15('='),'  Files were updated  ',13('='),'  End=',I6,2X,15('='))
          WRITE (*,1178)  TITLE
 1178     FORMAT ('<<<=====  ',15A4,'  ====>>>')
  RETURN
!
!     -------------------------------------------- Formats of file07.dat
 7007 FORMAT (15A4,2I5, 1X,A4,1X,I4,1X,I9,1x, f9.6 / I7,I3, 9I10)
 7017 FORMAT (20(2X,A4) )
 7018 FORMAT (20I6 )
 7070 FORMAT (F10.2,F10.4,F10.2, 3F10.5 /  &
              E10.3, A10, 6F10.6 /  &
              F10.6, A10, 6F10.6 )
 7080 FORMAT  (10X,3F20.10)
 7700 FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.6)
 7701 FORMAT (3F9.7, A1, 3F8.6, 1X, 3F9.6, 1x,i2)
 7702 FORMAT (3F10.8, A1, 3F9.7, 1X, 3F10.6, 1x,i2)
 7800 FORMAT (3(I10,I5,I4,1X,I10))
!     -------------------------------------------- Formats of file08.dat
 8001 FORMAT (10I10)
 8003 FORMAT (1P5E16.9)
 8004 FORMAT (0P3F12.6,4X,3F12.6)
 8005 FORMAT (12I6)
END
!
!
!                                                               ========
!================================================================ FILE09
SUBROUTINE  FILE09
  use param
  use charac
  use atomsi
  use values
  use counts
  use acoord
!
  implicit none
!
  COMMON /WORK02/ IP(3,LNI),  PP(3,LNI)
        integer*4 IP,PP
!
  double precision   H(3,3), VALVAL(LVA)
  integer(KIND=4)   K,I,MMMMM,L,J
!
  IF (TITLE(1) == 'BENC'     .AND.  TITLE(2) ==     'HMAR'     )  RETURN
!     --------------------------------------- Work file for continuation
  OPEN (22, FILE = FLNAME(19),STATUS = 'UNKNOWN', ACCESS = 'SEQUENTIAL', FORM   = 'FORMATTED' )
!
!               -------------------------------------------- FILE09V.DAT
! 1991           FORMAT (F8.2,7F8.4 / 8F9.2 / F9.5, F9.3, 3F9.5,3F9.6 / 10F8.2 / 10F8.3 )
 1991    FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.7 / 20F9.3 / 20F9.3 )
    REWIND  29
    REWIND  22
    DO K = 1, NRECRD(5)
      READ  (29,1991)  (VALVAL(I),I=1,LVA)
      WRITE (22,1991)  (VALVAL(I),I=1,LVA)
    enddo
    ENDFILE  22
    REWIND   29
    REWIND   22
    DO K = 1, NRECRD(5)
      READ  (22,1991)  VALVAL
      WRITE (29,1991)  VALVAL
    enddo
!
!         -------------------------------------------------- FILE09P.DAT
    IF (RUNOPT(18) == 'BINARY    ')  THEN
      CLOSE (22)
      OPEN (22, FILE = FLNAME(19),STATUS = 'UNKNOWN',ACCESS = 'SEQUENTIAL', FORM   = 'UNFORMATTED' )
    END IF
                                     MMMMM = NTION
    IF (RUNOPT(17) == 'CRYSTAL   ')  MMMMM = NPTP
      REWIND  19
      REWIND  22
    IF (RUNOPT(18) == 'BINARY    ') THEN
      DO K = 1, NRECRD(4)
        READ  (19)  L,  H
        READ  (19)  ((PP(J,I),J=1,3),I=1,MMMMM)
        WRITE (22)  L,  H
        WRITE (22)  ((PP(J,I),J=1,3),I=1,MMMMM)
      enddo
      REWIND   19
      REWIND   22
      DO K = 1, NRECRD(4)
        READ  (22)  L,  H
        READ  (22)  ((PP(J,I),J=1,3),I=1,MMMMM)
        WRITE (19)  L,  H
        WRITE (19)  ((PP(J,I),J=1,3),I=1,MMMMM)
      enddo
    ELSE
      DO K = 1, NRECRD(4)
        READ  (19,9002)  L,  H
        READ  (19,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
        WRITE (22,9002)  L,  H
        WRITE (22,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
      enddo
      REWIND   19
      REWIND   22
      DO K = 1, NRECRD(4)
        READ  (22,9002)  L,  H
        READ  (22,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
        WRITE (19,9002)  L,  H
        WRITE (19,9001)  ((IP(J,I),J=1,3),I=1,MMMMM)
      enddo
    END IF
!
  CLOSE (22)
  RETURN
!     ----------------------------------------- Formats of file09a.dat's
 9001 FORMAT (18I5)
 9002 FORMAT (I7,3X, 9F7.3)
END
!
!
!                                                               ========
!================================================================ FILE10
SUBROUTINE  FILE10
  use param
  use charac
  use atomsi
  use aboxof
  use acoord
  use charge
!
  implicit none
!
  CHARACTER  *4   HEX
  integer(KIND=4) J,N,I
!
!             ------------------------------ Input file of xtal geometry
  OPEN (10,FILE=FLNAME(10),STATUS='OLD',ACCESS='SEQUENTIAL',FORM='FORMATTED')
    REWIND  10
    READ (10,5010)  BOXO,NBOX,NPT,NPTP,NSYM,HEX,MATM
    READ (10,5012)  (ATMXTL(J),J=1,MATM)
    READ (10,5014)  (NIU(J),J=1,MATM)
    READ (10,5020)  (JON(N),(P0C(J,N),J=1,3),N=1,NPTP)
    READ (10,5030)  (((RS(J,I,N),J=1,3),I=1,3),N=1,NSYM)
    READ (10,5040)  (ISYM(N),N=1,NTION)
    REWIND  10
  CLOSE  (10)
  IHEX = 0
  IF (HEX == 'HEX ')  IHEX = 1
  RETURN
 5010         FORMAT (3F10.7,3F10.8 / 6I5,5X,A4,I6 )
 5012         FORMAT ( 18A4 )
 5014         FORMAT ( 18I4 )
 5020         FORMAT (I5,3F10.7)
 5030         FORMAT (9F6.1)
 5040         FORMAT (12I6)
END
!
!
!                                                               ========
!================================================================ INITIA
SUBROUTINE  INITIA  (INOEND)
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use geomet
  use tables
  use counts
  use vector
  use radial
  use molecu
  use outerf
  use wallp
  use charge
  use boxcng
  use exclus
  use struct
  use ewal
!
  implicit none
!
!     -------------------------------------------- Initial reading, etc.
!
  COMMON /WORK01/ VV(3,LNI),DUM(3,LNI)
         double precision VV, DUM
  COMMON /WORK02/ IPV(3,LNI),IDUMMY(3,LNI)
         integer(KIND=4) IPV, IDUMMY
  COMMON /PSURF / DISTM, iato1, iato2, iarea
        double precision  DISTM
  COMMON /ZDEN  / ZMULT,IDENS
        double precision  ZMULT
        integer(KIND=4) IDENS
!
  integer(KIND=4)      INOEND
!  integer(KIND=4)      I,J,IP0,IO,nrem,io1,nstep1,LL,NATX,IamV,k
  integer(KIND=4)      I,J,IP0,IO,nrem,io1,nstep1,LL,NATX,k
  integer(KIND=4)      iato1,iato2,iarea
  double precision    BOXA(6), FA(3),ASP
  double precision    AREC1,AREC2,AREC3,AREC4,AREC5,DDT,FORMUL,TARGT,DELT
  double precision    STEMP0,AMODE,ZSUM,ANJ,ZJ,WJ,AJ,BJ,CJ,DJ,ZI1
  double precision    param1,param2,param3,param4,param5,param6
  CHARACTER *4    AAX, ATY, THS1,THS2, RUNOP1
  CHARACTER *10   RUNRUN, DUMMY
  character *1  Ins1
!
  ATMNET(:) = '    '
  RUNOPT(:) = '          '
  NRECRD(9) = 0
!
!     --------------------------------------- Data input from FILE05.DAT
!
  IP0 = 0
  INOEND = 0
30 READ (15,1001,END=888)  RUNOPT(1)
  RUNOP1 = RUNOPT(1)
  IF (RUNOP1 == 'MDX.')  THEN
    RUNOPT(1) = 'MD........'
    RUNOP1    = 'MD..'
    IP0 = 1
  END IF
  IF (RUNOP1 == 'MD..')  THEN
    RUNOPT(1)  = 'MD........'
    RUNOPT(17) = 'AMORPHOUS '
  END IF
  IF (RUNOP1 == 'XD..')  THEN
    RUNOPT(1)  = 'XD........'
    RUNOPT(17) = 'CRYSTAL   '
  END IF
  IF (RUNOP1 /= 'MD..' .AND. RUNOP1 /= 'XD..' )  GO TO 30
  READ (15,1001,END=888)  RUNOPT(2),TITLE
  IF (RUNOPT(2) == '          ' .OR.   &
      RUNOPT(2) == 'STOP      ' .OR.  &
      RUNOPT(2) == 'END       ' )  GO TO 888
  IF (RUNOPT(2) == 'CONT.     ') RUNOPT(2) = 'CONTINUE  '
  GO TO 50
!
!     ----------------------------------------------------------- Finish
888 INOEND = -1
  RETURN
!
!     -------------------------------- Read file07.dat, file08.dat, etc.
50 CALL  F07F08  (INOEND)
!     -------------------------------------- Input file of xtal geometry
  CALL  TITLET  (1,0)
!     ------------------------------------------- Economy, normal detail
  READ (15,1000)  RUNOPT(3), AREC1, AREC2, AREC3, AREC4, AREC5
                            IRECRD(1) = INT(AREC1)
                            IRECRD(2) = INT(AREC2)
                            IRECRD(3) = INT(AREC3)
                            IRECRD(4) = INT(AREC4)
                            IRECRD(5) = INT(AREC5)
  IF (IRECRD(1) > LCT) THEN
    WRITE (6,*) 'The number of steps:',IRECRD(1),'is too large (LCT=',LCT,')'
    WRITE (6,*) 'Please chage all the LCT parameters'
    STOP
  END IF
  IF (IRECRD(1) < IRECRD(2))         IRECRD(2) = IRECRD(1)
  IF (MOD(IRECRD(1),IRECRD(2)) /= 0)  IRECRD(2) = IRECRD(1)
  IF (IRECRD(3) <= 0)                 IRECRD(3) = 50
  IF (IRECRD(2) < IRECRD(3))         IRECRD(3) = IRECRD(2)
  IF (IRECRD(4) <= 0)  THEN
    IF (RUNOP1 == 'MD......') IRECRD(4) = IRECRD(3)
    IF (RUNOP1 == 'XD......') IRECRD(4) = 5
  END IF
  IF (IRECRD(5) <= 0)                 IRECRD(5) = 5
!     ------------------------------------------------- Accume, noaccume
  READ (15,1000)  RUNOPT(4), DDT, FORMUL, RCUT(1), RCUT(2)
!     ------------------------------------------------------ Temperature
  READ (15,1000)  RUNRUN, TARGT, DELT, STEMP0, TDUMP, STEMP3, STEMP4
  IF (RUNRUN == 'T         ')  RUNOPT(5) = 'T NO-CNTL '
  IF (RUNRUN == 'T NO      ')  RUNOPT(5) = 'T NO-CNTL '
  IF (RUNRUN == 'T NO-CNTL ')  RUNOPT(5) = 'T NO-CNTL '
  IF (RUNRUN == 'T SCALING ')  THEN
    RUNOPT(5) = 'T SCALING '
    NTSTEP = STEMP0
    IF (NTSTEP <= 0)  NTSTEP = 10
  END IF
  IF (RUNRUN == 'T SCALE-A ')  THEN
    RUNOPT(5) = 'T SCALE-A '
    NTSTEP = STEMP0
    IF (NTSTEP <= 0)  NTSTEP = 10
  END IF
  IF (RUNRUN == 'T NOSE    ')  then
    RUNOPT(5) = 'T NOSE    '
    do i = 1,ntion
      PP0(:,i) = P0(:,i)
    enddo
    KBT = AKB*TARGT
    STEMP(1) = 3.0d0*dble(NTION)*KBT/(CVL*STEMP0*2.0d0*pi)**2    ! Wavenumber cm^-1 -> Q [g cm^2], Q1=3NkT/omega^2
!     STEMP = 0.99d-39
    VSTEMP(1) = 0.0d0  
    nfnose = 1     ! Number of Nose-Hoover Chain
    if (TDUMP > 1.0D-2) then
       nfnose = 2
       STEMP(2) = KBT/(CVL*TDUMP *2.0d0*pi)**2    ! Wavenumber cm^-1 -> Q [g cm^2], Qn=kT/omega^2
       if (STEMP3 > 1.0D-2) then
         nfnose = 3
         STEMP(3) = KBT/(CVL*STEMP3*2.0d0*pi)**2
         if (STEMP4 > 1.0D-2) then
           nfnose = 4
           STEMP(4) = KBT/(CVL*STEMP4*2.0d0*pi)**2
         endif
       endif
    endif
    open(85,file='nose-hamiltonian')
   ENDIF
!    STEMP = STEMP0
!    VSTEMP = 0.0d0
  IF (NTSTEP <= 0)  NTSTEP = 1
  DELTMP = DELT
  TMPGET = TARGT
  IF (TDUMP <= 0.0001D0)  TDUMP = 0.5D0
!  IF (RUNOPT(5)  /= 'T NOSE    ' .OR.  &
!      RUNOPT(2)  /= 'CONTINUE  ' .OR.  &
!      RUNOPT(51) /= 'THERMOSTAT' )  THEN
!      STEMP  = STEMP0
!      VSTEMP = 0.0
!  END IF
!     --------------------------------------------------------- Pressure
  READ (15,1000)  RUNRUN, SPRES, VIRM(1), VIRM(2), VIRM(3)
  IF (RUNRUN == 'P         ')  RUNOPT(6) = 'P NO-CNTL '
  IF (RUNRUN == 'P NO      ')  RUNOPT(6) = 'P NO-CNTL '
  IF (RUNRUN == 'P NO-CNTL ')  RUNOPT(6) = 'P NO-CNTL '
  IF (RUNRUN == 'P SCALING ')  then
                               RUNOPT(6) = 'P SCALING '
                               pdump = virm(1)
                               if (pdump < 0.01D0)  pdump = 1.0D0
  end if
  IF (RUNRUN == 'P ANDERSEN' .OR. RUNRUN == 'P ANDERS-C' )  THEN
    if (RUNRUN == 'P ANDERSEN') RUNOPT(6) = 'P ANDERSEN'
    if (RUNRUN == 'P ANDERS-C') RUNOPT(6) = 'P ANDERS-C'
    IF (ABS(VBOX(2)) < 1.0E-9.AND.ABS(VBOX(3)) < 1.0E-9 ) THEN
      VBOX(1) = 0.0D0
      VBOX(2) = 0.0D0
      VBOX(3) = 0.0D0
    END IF
  END IF
!               --------------------------------------------
  IF (RUNOPT(6) /= 'P ANDERSEN'.AND.  &
      ABS(VBOX(2)) > 1.0E-9.AND.  &
      ABS(VBOX(3)) > 1.0E-9 ) THEN
    VBOX(1) = 0.0D0
    VBOX(2) = 0.0D0
    VBOX(3) = 0.0D0
  END IF
!     ----------------------------------------------------------- Volume
  READ (15,1000)  RUNRUN, BOXA
  IF (RUNRUN == '          ')  RUNOPT(7) = 'V FREE    '
  IF (RUNRUN == 'V CONST.  ')  RUNOPT(7) = 'V CONST.  '
  IF (RUNRUN == 'V CONTROL ')  RUNOPT(7) = 'V CONST.  '
  IF (RUNRUN == 'D CONST.  ')  RUNOPT(7) = 'D CONST.  '
  IF (RUNRUN == 'D CONTROL ')  RUNOPT(7) = 'D CONST.  '
!               --------------------------------------- Change cell size
  IF (RUNRUN == 'V CELL    ')  THEN
    RUNOPT(7) = 'V CELL    '
    DO J = 1, 3
      FA(J)  = BOXA(J) / BOX(J)
      BOX(J) = BOXA(J)
    enddo
!               ----------------------------------------- Change density
  ELSE IF (RUNRUN == 'V DENSITY ')  THEN
    RUNOPT(7) = 'V DENSITY '
    FA(1) = (DENSTY/BOXA(1))**(1.0/3.0)
    FA(2) = FA(1)
    FA(3) = FA(1)
    DO I = 1, 3
      BOX(I) = BOX(I) * FA(I)
    enddo
  ELSE IF (RUNRUN == 'V CHANGE  ') THEN
    RUNOPT(7) = 'V CHANGE  '
    ICAXIS = BOXA(1)
    BTAGET = BOXA(2)
    BCNGR  = BOXA(3)
    if (ABS(BCNGR) <= 1.0E-6) BCNGR = sign(1.0,BCNGR)*1.0E-6
  END IF
!
!     -------------------------------------------------- Potential model
  READ (15,1000)  RUNOPT(8), AMODE, ALPHA
  MODE = INT(AMODE)
  IF (RUNOPT(8) /= '          ' .AND.    &
      RUNOPT(8) /= 'BUSING    ' .AND.   &
      RUNOPT(8) /= 'MORSE     ' .AND.   &
      RUNOPT(8) /= 'MORSE-AT  ' .AND.   &
      RUNOPT(8) /= 'BMH-EXP   ' .AND.   &
      RUNOPT(8) /= 'BMH-EXP*  ' .AND.   &
      RUNOPT(8) /= 'BELONO    ' .AND.   &
      RUNOPT(8) /= 'TOSIFUMI  ' .AND.   &
      RUNOPT(8) /= 'WOODCOCK  ' .AND.   &
      RUNOPT(8) /= 'PAULING   ' .AND.   &
      RUNOPT(8) /= 'STSUNE    ' .AND.   &
      RUNOPT(8) /= 'L-J       ' .AND.   &
      RUNOPT(8) /= 'PAIR-P    ' .AND.   &
      RUNOPT(8) /= 'METAL     ' )  THEN
      WRITE (*,*) 'Interatomic potential model ', runopt(8),' is not recognized'
      STOP
  END IF
!
  ZSUM = 0.0D0
  ATOM(:) = '    '
  ZIO(:)  = 0.0D0
  WIO(:)  = 0.0D0
  AIO(:)  = 0.0D0
  BIO(:)  = 0.0D0
  CIO(:)  = 0.0D0
  DIO(:)  = 0.0D0
  NION(:) = 0
  IION(:) = 0
  NCOMPO = 0
!     --------------------------------------------- Read atom parameters
  DO J = 1, LEL+1
    READ (15,'(A1,A1,A2,F6.0,6F10.0)',END=230)  Ins1,ATY,AAX,ANJ,ZJ,WJ,AJ,BJ,CJ,DJ
!                           IF (I <= 0.OR.AAX == '    ')  GO TO 230
!    IF (I == 0) I = 10
    IF (Ins1 == ' ' .or. AAX == '    ')  GO TO 230
      I = 0
      do k=1, lel
        if (Ins1 == ins(k)) then
                I = k
                exit
        endif
      enddo
      if (I == 0) then
              write(*,*) '!!! Error [file05.dat] at atom ', j,Ins1,I,k, '!!!'
              write(*,'(" ---- atom =",A2,"  Ni=",F5.0," ----")')AAX,ANJ
              stop
      endif


    ATOM(I) = AAX
    ZIO(I)  = ZJ
    WIO(I)  = WJ
    AIO(I)  = AJ
    BIO(I)  = BJ
    CIO(I)  = CJ
    DIO(I)  = DJ
    NION(I) = INT(ANJ)
    IF (I /= 1)  ZSUM = ZSUM + ZJ * ANJ
    IF (ATY == '-')  IION(I) = -1
    IF (ATY == '*')  IION(I) = -999
    IF (ATY == '=')  IION(I) =  1
    NCOMPO = NCOMPO + 1
  enddo
230 ZI1 = - ZSUM / DBLE(NION(1))
  IF (ABS(ZI1-ZIO(1)) > 0.00001D0) THEN
    WRITE (*,*) 'Warnning on total charge neutralization! ', ZIO(1),ZI1
!           ZIO(1) = ZI1
  END IF
! ------------------------------------WATER-POL
  do io = 1, ncompo
    do i = ions(1,io),ions(2,io)
      ZIIP(i) = ZIO(io)
    enddo
  enddo
  if (ICD == 0) then
    do i = 1, ntion
      ZII(i) = ZIIP(i)
    enddo
  endif
! --------------------------------------------
!
  IO1 = NCOMPO + 1
  DO IO = IO1, LEL
    IF (NION(IO) > 0)  NCOMPO = IO
  enddo
  NPAIR = NCOMPO * (NCOMPO+1) / 2
!     ------------------------------------------------------------------
  DTMO = DTIME
  IF (RUNOPT(2) == 'START     ')  THEN
    IF (DDT > 0.0001D0)     DTIME = DDT * 1.0D-15
    IF (DTIME < 1.0D-18)  DTIME = 2.0D-15
    IF (RUNOP1 == 'MD..'.AND.IP0 == 0)  THEN
      DO I = 1,NTION
        DO J = 1, 3
          P0(J,I) = P(J,I)
        enddo
      enddo
    END IF
    NAVT = 0
    NAV  = 0
    TVAL(:) = 0.0D0
    SVAL(:) = 0.0D0
    VAL0(:) = 0.0D0
    MXCUT     = 99999
    NRECRD(1) = 0
    NRECRD(2) = 0
!               VBOX(1)   = 1.0D0
  END IF
!
  CALL  PREPAR  (FORMUL)
!
!     ---------------------------------------- Configuration and heading
!
  NREM = IRECRD(1) - NRECRD(1)
  NSTEP1 = NRECRD(1) + 1
  THS1 = 'th'
  IF (MOD(NSTEP1,10) == 1)  THS1 = 'st'
  IF (MOD(NSTEP1,10) == 2)  THS1 = 'nd'
  IF (MOD(NSTEP1,10) == 3)  THS1 = 'rd'
  THS2 = 'th'
  IF (MOD(IRECRD(1),10) == 1)  THS2 = 'st'
  IF (MOD(IRECRD(1),10) == 2)  THS2 = 'nd'
  IF (MOD(IRECRD(1),10) == 3)  THS2 = 'rd'
  WRITE (16, 2000) RUNOPT(2),NREM,NSTEP1,THS1,IRECRD(1),THS2,DTIME, &
                                              IRECRD(2), &
                   RUNOPT(5),TEMP,DELTMP,NTSTEP,TMPGET,RUNOPT(4), &
                                         NRECRD(2),NRECRD(4)
  IF (RUNOPT(5) == 'T NOSE    ') WRITE (16,2010)  STEMP
  IF (RUNOPT(6) /= 'P NO-CNTL ') THEN
    IF (RUNOPT(6) == 'P SCALING ') WRITE (16,2020) RUNOPT(6),SPRES
    IF (RUNOPT(6) == 'P ANDERSEN') WRITE (16,2027) RUNOPT(6),SPRES,(VIRM(LL),LL=1,3)
    IF (RUNOPT(6) == 'P ANDERS-C') WRITE (16,2027) RUNOPT(6),SPRES,(VIRM(LL),LL=1,3)
  END IF
!
  CALL  TABLER  (1)
!
!     ------------------------------------------ Read RUNOPT(9),...,(21)
  lentab   = lst
  IPRDF(1) = 2
  IPRDF(2) = 9999
520 READ (15,1000)  RUNRUN,PARAM1,PARAM2,PARAM3,PARAM4,PARAM5,PARAM6
  IF (RUNRUN /= '          ') THEN
    IF (RUNRUN == 'STRUCTURE ') then
      RUNOPT(9)  = 'STRUCTURE '
      lentab = param1
      if (lentab < 1)    lentab = LST
      if (lentab > LST)  lentab = LST
    end if
    IF (RUNRUN == 'NETWORK   ')  THEN
      RUNOPT(10) = 'NETWORK   '
      NATX = 0
      IO = PARAM1
      IF (IO > 0.AND.IO <= LEE)  THEN
        NATX = NATX + 1
        ATMNET(NATX) = ATOM(IO)
      END IF
      IO = PARAM2
      IF (IO > 0.AND.IO <= LEE)  THEN
        NATX = NATX + 1
        ATMNET(NATX) = ATOM(IO)
      END IF
      WRITE (*,*) 'Network forming cation(s) is(are)',(i,atmnet(i),i=1,natx)
    END IF
!
    IF (RUNRUN == 'VELOCITY  ')  THEN
      RUNOPT(11) = 'VELOCITY  '
      IRECRD(9)  = PARAM1
      PVMULT = 50000.D0
      IF (PARAM2 > 0)     PVMULT = PARAM2
      IF (IRECRD(9) <= 0)  IRECRD(9) = 1
    END IF
    IF (RUNRUN == 'POSITION  ')  THEN
      RUNOPT(11) = 'POSITION  '
      IRECRD(9)  = PARAM1
      PVMULT = 90000.D0
      IF (PARAM2 > 0)     PVMULT = PARAM2
      IF (IRECRD(9) <= 1)  IRECRD(9) = 1
    END IF
    IF (RUNRUN == 'ENERGY    ')  THEN
      RUNOPT(11) = 'ENERGY    '
      IRECRD(9)  = PARAM1
      PVMULT = 1.0E12
      IF (PARAM2 > 0)     PVMULT = PARAM2
      IF (IRECRD(9) <= 1)  IRECRD(9) = 1
    END IF
    IF (RUNRUN == 'POSVELENE ')  THEN
      RUNOPT(11) = 'POSVELENE '
      IRECRD(9)  = PARAM1
      PVMULT = 1.0E12
!               IF (PARAM2 > 0)     PVMULT = PARAM2
      IF (IRECRD(9) <= 1)  IRECRD(9) = 1
    END IF
    IF (RUNRUN == 'QUANTUM   ')  THEN
      RUNOPT(12) = 'QUANTUM   '
      CALL  QCTABL
    END IF
    IF (RUNRUN == 'PCF       '.OR.RUNRUN == 'RDF       ')  THEN
      RUNOPT(13) = 'PCF       '
      IF (PARAM1 > 0.999)  IPRDF(1) = PARAM1
      IF (PARAM2 > 0.5 .AND. PARAM2 < 20.0) IPRDF(2) = PARAM2*100
    END IF
    IF (RUNRUN == 'DIPOLE    ')  THEN
      RUNOPT(14) = 'DIPOLE    '
    END IF
    IF (RUNRUN == 'CENTER    '.OR.RUNRUN == 'CENTRE    ')  THEN
      RUNOPT(15) = 'CENTER    '
    END IF
    IF (RUNRUN == 'CENTERING ')  THEN
      RUNOPT(15) = 'CENTERING '
      iaxcen     = PARAM1
    END IF
    IF (RUNRUN == 'NO(MV=0)  ')  THEN
      RUNOPT(16) = 'NO(MV=0)  '
    END IF
    IF (RUNRUN == 'AM(MV=0)  ')  THEN
      RUNOPT(16) = 'AM(MV=0)  '
      Iamv = param1
      Namv = param2
      if (Namv > nion(Iamv)) Namv= nion(Iamv)
      if (Namv <= 0) Namv = nion(Iamv)
    END IF
    IF (RUNRUN == 'CRYSTAL   ')  THEN
      RUNOPT(17) = 'CRYSTAL   '
    END IF
    IF (RUNRUN == 'BINARY    ')  THEN
      RUNOPT(18) = 'BINARY    '
      IF (RUNOPT(2) == 'START     ')  THEN
        CLOSE (19)
        OPEN (19, FILE=FLNAME(9), STATUS='UNKNOWN', ACCESS='SEQUENTIAL', FORM='UNFORMATTED')
      END IF
    END IF
    IF (RUNRUN == 'PRESSURE  ')  THEN
      RUNOPT(19) = 'PRESSURE  '
      OPEN (27, FILE=FLNAME(13), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
        REWIND 27
    END IF
    IF (RUNRUN == 'ELEC.FIELD')  THEN
      RUNOPT(20) = 'ELEC.FIELD'
      MEFD   =  INT(PARAM1)          ! Mode of elec.field
      EFD(1) = DBLE(PARAM2) *1.00D5  ! [EFD]==[V/m]
      EFD(2) = DBLE(PARAM3) *1.00D5  ! 1 CV/m = 1 J/m
      EFD(3) = DBLE(PARAM4) *1.00D5  !        = 10^5 erg/cm
      EFREQ  = DBLE(PARAM5)          ! Hz
      NATOM  =  INT(PARAM6 + 0.5)    ! starting number of atom given EFD
    END IF
    if (runrun == 'GRAV.FIELD')  then
      runopt(21) = 'GRAV.FIELD'
      gfd(1)     = param1
      gfd(2)     = param2
      gfd(3)     = param3
    end if
    if (runrun == 'DIATOMIC  ')  then
      runopt(23)  = 'DIATOMIC  '
      DINTRA      = param1
      IATOM2(1)   = param2
      IATOM2(2)   = param3
      MOLstart(1) = param2
      MOLend(1)   = param2
      MOLstart(2) = param3
      MOLend(2)   = param3
      ZMOLE(1) = - ZIO(IATOM2(1))*2.0D0
      if (iatom2(2) > 0)  zmole(2) = - ZIO(IATOM2(2))*2.0D0
      CALL  DIATOM
    end if
    if (runrun == 'CUBE      ')  then
      runopt(24) = 'CUBE      '
    end if
    if (runrun == 'CONVEC    ')  then
      runopt(25) = 'CONVECTION'
      fconvc     = param1
      write (6,*) '[CONVECTION] option is set'
    end if
    if (runrun == 'MOLECULE  ')  then
      runopt(26)  = 'MOLECULE  '
      DINTRA      = param1
      MOLstart(1) = param2
      MOLend(1)   = param3
      call  MOLECULE
    end if
    if (runrun == 'EXCLUSION ')  then
      runopt(27)  = 'EXCLUSION '
      READ (15,1000)  RUNRUN,PARAM1,PARAM2,PARAM3,PARAM4,PARAM5,PARAM6
      if (RUNRUN == 'COLUMN    '.or. RUNRUN == 'SLUB      ' ) then
        iextype = 1
        if (RUNRUN == 'SLUB      ')  iextype = 2
        iaex    = param1
        REXCL   = param2
        Fexcl   = param3
      end if
      if (RUNRUN == 'CUBE      ') then
        iextype = 3
        rexcl   = param1
        Fexcl   = param2
      end if
      if (Fexcl < 1.0E-9)  Fexcl = 1.0E-5
    end if
    if (runrun == 'WALL      ')  then
      runopt(28) = 'WALL      '
      WALLa = param1
      WALLb = param2
    end if
    if (runrun == 'POLYATOMS ')  then
      runopt(29)  = 'POLYATOMS '
      DINTRA      = param1
      MOLstart(1) = param2
      MOLend(1)   = param3
      call  MOLECULE
    end if
    if (runrun == 'EWALD-C   ')  then
      runopt(30)  = 'EWALD-C   '
    endif
    if (runrun  ==  'POTSURF   ') then
      runopt(31) = 'POTSURF   '
      DISTM  = param1
      iato1  = param2
      iato2  = param3
      iarea  = param4 !iarea = 1 -> x only
                      !iarea = 2 -> y only
                      !iarea = 3 -> z only
                      !iarea = 4 -> x + y
                      !iarea = 5 -> y + z
                      !iarea = 6 -> z + x
    end if
    if (runrun == 'WATER-POL ') then
       runopt(34)  = 'WATER-POL '
       IATOMO = INT(param1)
       IATOMH = INT(param2)
       DINTRA = param3
       THRESHD = param4
!       ITER   = INT(param4)
!       GE_pol = param5
!       Em_pol = param6
       RD = param6
       if (param6 < 1.0D-3) RD = 0.25D0
       DLP = RD*2.0D0
       ndmole = 2*nion(IATOMO)
       niono = nion(iatomo)
!
       if (ICD == 0) then
         open (26, FILE=FLNAME(16), status ='unknown', access='sequential', form='formatted')
           do i = ntion+1, ntion+ndmole
             ZII(i) = ZIO(IATOMO)/2.0D0
           enddo
           do i = IONS(1,IATOMO),IONS(2,IATOMO)
             ZII(i) = 0.0D0
           enddo
           write (26,'(i10)') nrecrd(1)
           write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
           ICD = 1
       endif
!       AIO(ncompo+1)  = AIO(IATOMH)
!       BIO(ncompo+1)  = BIO(IATOMH)
!       CIO(ncompo+1)  = CIO(IATOMH)
!       DIO(ncompo+1)  = DIO(IATOMH)
       AIO(ncompo+1)  = 0.0D0
       BIO(ncompo+1)  = 0.0D0
       CIO(ncompo+1)  = 0.0D0
       DIO(ncompo+1)  = 0.0D0
       WIO(ncompo+1)  = 0.0D0
       ATOM(ncompo+1) = 'LP  '
       IION(ncompo+1) = 0
       NION(ncompo+1) = ndmole
       IONS(1,ncompo+1) = IONS(2,ncompo) + 1
       IONS(2,ncompo+1) = IONS(2,ncompo) + NION(ncompo+1)
       do i = ntion+1, ntion+ndmole
         ZIIP(i) = ZIO(IATOMO)/2.0D0
       enddo
       do i = IONS(1,IATOMO),IONS(2,IATOMO)
         ZII(i) = 0.0D0
         ZIIP(i) = 0.0D0
       enddo
       call COULMB
       UCSELF = 0.0D0
       ASP = - (ALPHA*1.0D8) * ELC**2 / SQRT(PI)
       do io = 1,ncompo
         UCSLFI(io) = 0.0d0
         DO I = ions(1,io), IONS(2,io)
           UCSLFI(io) = UCSLFI(io) + ZII(I)**2*ASP
         enddo
         UCSELF = UCSELF + UCSLFI(io)
       enddo
       UCSLFI(ncompo+1) = 0.0D0
       DO I = ntion+1, ntion+ndmole
         UCSLFI(ncompo+1) = UCSLFI(ncompo+1) + ZII(I)**2*ASP
         IOND(I) = 1  !20120513
       enddo
       UCSELF = UCSELF + UCSLFI(ncompo+1)
       call BMHEXP (1)
       call VWCORR (1)
!       call FIND_H2O(0)
    endif
    if (runrun == 'WATER-POLN') then   !!NO-polarization!!
       runopt(34)  = 'WATER-POLN'
       IATOMO = INT(param1)
       IATOMH = INT(param2)
       DINTRA = param3
       THRESHD = param4
!       ITER   = INT(param4)
!       GE_pol = param5
!       Em_pol = param6
       RD = param6
       if (param6 < 1.0D-3) RD = 0.25D0
       DLP = RD*2.0D0
       ndmole = 2*nion(IATOMO)
       niono = nion(iatomo)
!
       if (ICD == 0) then
         open (26, FILE=FLNAME(16), status ='unknown', access='sequential', form='formatted')
           do i = ntion+1, ntion+ndmole
             ZII(i) = ZIO(IATOMO)/2.0D0
           enddo
           do i = IONS(1,IATOMO),IONS(2,IATOMO)
             ZII(i) = 0.0D0
           enddo
           write (26,'(i10)') nrecrd(1)
           write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
           ICD = 1
       endif
!       AIO(ncompo+1)  = AIO(IATOMH)
!       BIO(ncompo+1)  = BIO(IATOMH)
!       CIO(ncompo+1)  = CIO(IATOMH)
!       DIO(ncompo+1)  = DIO(IATOMH)
       AIO(ncompo+1)  = 0.0D0
       BIO(ncompo+1)  = 0.0D0
       CIO(ncompo+1)  = 0.0D0
       DIO(ncompo+1)  = 0.0D0
       WIO(ncompo+1)  = 0.0D0
       ATOM(ncompo+1) = 'LP  '
       IION(ncompo+1) = 0
       NION(ncompo+1) = ndmole
       IONS(1,ncompo+1) = IONS(2,ncompo) + 1
       IONS(2,ncompo+1) = IONS(2,ncompo) + NION(ncompo+1)
       do i = ntion+1, ntion+ndmole
         ZIIP(i) = ZIO(IATOMO)/2.0D0
       enddo
       do i = IONS(1,IATOMO),IONS(2,IATOMO)
         ZII(i) = 0.0D0
         ZIIP(i) = 0.0D0
       enddo
       call COULMB
       UCSELF = 0.0D0
       ASP = - (ALPHA*1.0D8) * ELC**2 / SQRT(PI)
       do io = 1,ncompo
         UCSLFI(io) = 0.0d0
         DO I = ions(1,io), IONS(2,io)
           UCSLFI(io) = UCSLFI(io) + ZII(I)**2*ASP
         enddo
         UCSELF = UCSELF + UCSLFI(io)
       enddo
       UCSLFI(ncompo+1) = 0.0D0
       DO I = ntion+1, ntion+ndmole
         UCSLFI(ncompo+1) = UCSLFI(ncompo+1) + ZII(I)**2*ASP
         IOND(I) = 1  !20120513
       enddo
       UCSELF = UCSELF + UCSLFI(ncompo+1)
       call BMHEXP (1)
       call VWCORR (1)
!       call FIND_H2O(0)
    endif
!
     if (runrun == 'SPME      ') then
       runopt(45) = 'SPME      '
! write(*,'("SPME mode")')
       NDIM=int(param1)
       NVNx=int(param2)
       NVNy=int(param3)
       NVNz=int(param4)
       allocate(PNVxx(NVNx,NVNy,NVNz),PNVyy(NVNx,NVNy,NVNz),PNVzz(NVNx,NVNy,NVNz))
       allocate(PNVxy(NVNx,NVNy,NVNz),PNVxz(NVNx,NVNy,NVNz),PNVyz(NVNx,NVNy,NVNz))
       allocate(bxsq(NVNx),bysq(NVNy),bzsq(NVNz))
       allocate(THREC(NVNx,NVNy,NVNz))
       allocate(ARQ(NVNx,NVNy,NVNz))
       allocate(DARQ(NVNx,NVNy,NVNz),DARQp(NVNx,NVNy,NVNz))
       call COULMB
     endif
!
    GOTO 520
  END IF
  WRITE (16,2030)  (I,RUNOPT(I),I=1,56)
!     ---------------------------------------------------- Check P and V
  CALL  CHECKP
!     ------------------------------------------------------ file09p.dat
  IF (RUNOPT(2) == 'START     ')  THEN
    IF (RUNOP1 == 'MD..')  THEN
      IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
        NRECRD(4) = 1
        IF (RUNOPT(18) == 'BINARY    ') THEN
          WRITE (19) NRECRD(4), 0, BOX(1), 0.0D0, 0.0D0, 0.0D0, BOX(2), 0.0D0, 0.0D0, 0.0D0, BOX(3)
          WRITE (19) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IPV(J,I) = P(J,I) * 90000.D0
            enddo
          enddo
          DUMMY = '          '
          WRITE (19,9001)  NRECRD(4), 0, BOX(1),0.0D0, 0.0D0, 0.0D0, BOX(2),0.0D0, 0.0D0, 0.0D0, BOX(3)
          WRITE (19,9002)  ((IPV(J,I),J=1,3),I=1,NTION)
        END IF
      END IF
    END IF
  END IF
!     ----------------------------------------------------- file09PV.dat
  IF (RUNOPT(11) /= '          ') THEN
    IF (RUNOPT(18) == 'BINARY    ') THEN
      OPEN (28, FILE=FLNAME(12), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='UNFORMATTED' )
    ELSE
      OPEN (28, FILE=FLNAME(12), STATUS='UNKNOWN',ACCESS='SEQUENTIAL', FORM='FORMATTED' )
    END IF
    REWIND 28
    NRECRD(9) = 1
    IF (RUNOPT(11) == 'VELOCITY  ') THEN
      IF (RUNOPT(18) == 'BINARY    ')  THEN
        DO I = 1, NTION
          DO  J = 1, 3
            VV(J,I) = V(J,I) / DTIME
          enddo
        enddo
        WRITE (28)  NRECRD(1),IRECRD(9)
        WRITE (28)  ((VV(J,I),J=1,3),I=1,NTION)
      ELSE
        DO I = 1, NTION
          DO J = 1, 3
            IPV(J,I)=V(J,I)*PVMULT*1E-15/DTIME +50000.D0
          enddo
        enddo
        WRITE (28,9001)  NRECRD(1),IRECRD(9)
        WRITE (28,9002)  ((IPV(J,I),J=1,3),I=1,NTION)
      END IF
    END IF
    IF (RUNOPT(11) == 'POSITION  ') THEN        !----- Position
      IF (RUNOPT(18) == 'BINARY    ') THEN
        WRITE (28)  NRECRD(1),IRECRD(9),BOX(1), 0.0D0, 0.0D0, 0.0D0, BOX(2),0.0D0, 0.0D0, 0.0D0, BOX(3)
        WRITE (28)  ((SNGL(P(J,I)),J=1,3),I=1,NTION)
      ELSE
        DO I = 1, NTION
          DO J = 1, 3
            IPV(J,I) = P(J,I) * PVMULT
          enddo
        enddo
        WRITE (28,9001)  NRECRD(1),IRECRD(9),BOX(1), 0.0D0, 0.0D0, 0.0D0, BOX(2),0.0D0, 0.0D0, 0.0D0, BOX(3)
        WRITE (28,9002)  ((IPV(J,I),J=1,3),I=1,NTION)
      END IF
    END IF
9001        FORMAT (I7,i3,9F7.3)
9002        FORMAT (18I5)
  END IF
!     ------------------------------------------------------------------
  IF (NREM <= 0)  GO TO 2222
  CALL  TITLET  (0, 1)
  RETURN
!
2222 WRITE (*,2233)  RUNOPT(2)
2233 FORMAT ('>>>>>  The number of steps to be calculated is less', &
             ' than one  >>>>>' /  &
             '>>>>>  Mode=', A9,  '   Please increase the number ', &
             'of steps   >>>>>' )
  STOP
!
 1000 FORMAT (A10, 6F10.5)
 1001 FORMAT (A10, 15A4)
 1300 FORMAT (I1,A1,A2,F6.0,6F10.0)
 2000 FORMAT ('I  [ ',A10,' ] ',I7,' steps-run from',I7,'-',A2, &
                  '  to ',I7,'-',A2,' step with time step of', &
                  1PE9.2,' sec. RDF''s at every', I7,' step  I' / &
             'I  [ ',A10,' ]  Temperature=',0PF7.1,' K  changed ', &
                  'with a rate of',F6.1,' K  per ', I3, ' steps until', &
                  F7.1,' K  (',A8,' : ',I5,' : ',I4,')  I' )
 2010 FORMAT ('I',18X,'"Mass" of Nose''s thermostat is ',E12.4,' g.cm2',63X,'I' )
 2020 FORMAT ('I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
                  'GPa  using forced scaling of cell dimensions.',14X,'I')
 2027 FORMAT ('I  [ ',A10,' ]  Pressure is controlled at ',3F9.4, &
                          ' GPa  by Andersen''s mass ',3(1X,G11.2E3),' g  I')
 2030 format ('I',130('-'),'I' /  &
              'I  [Options]  ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' / &
              'I             ',8(I3,':',A10),'     I' )
END
!
!
!                                                             ==========
!============================================================== MOLECULE
SUBROUTINE  MOLECULE
  use param
  use charac
  use atomsi
  use aboxof
  use cartes
  use molecu
!
  implicit none
!     ======================================recognize diatomic molecules
!
  double precision  rx, ry, rz
  double precision  dx, dy, dz
  double precision  rij2,CUT2
  integer*4  mi(lni), ndistr(11),m,mmmm,J,J2,J1,jo,mmm,II,IO,NNN,N,I
!
  cut2 = dintra**2
  do I = 1, ntion
    mi(i) = 0
  enddo
  do n = 1, 11
    ndistr(n) = 0
  enddo
  nnn = 0
!-------------------------------------------------calc distance of atoms
  do io = MOLstart(1), MOLend(1)
    do ii = ions(1,io), ions(2,io)
      if (mi(ii) > 0)  cycle
      nnn = nnn + 1
      imole(1,nnn) = ii
      mi(ii) = 1
      mmm = 1
      do jo = io, MOLend(1)
        if (jo < 0 .or. jo > ncompo)  cycle
        j1 = ions(1,jo)
        j2 = ions(2,jo)
        if (io == jo)  j1 = i+1
        do J = j1, j2
          if (mi(j) > 0)  cycle
          mmmm = mmm
          do m = 1, mmmm
            i = imole(m,nnn)
            if (i == j)  cycle
            RX = P(1,i) - P(1,j)
            RY = P(2,i) - P(2,j)
            RZ = P(3,i) - P(3,j)
            if (RX < -0.5)  RX = RX + 1.0
            if (RX >  0.5)  RX = RX - 1.0
            if (RY < -0.5)  RY = RY + 1.0
            if (RY >  0.5)  RY = RY - 1.0
            if (RZ < -0.5)  RZ = RZ + 1.0
            if (RZ >  0.5)  RZ = RZ - 1.0
!                    --------- delete these if-statements for triclinic
!                    IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                    IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                    IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                    DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                    DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                    DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 > CUT2)  cycle
            mmm = mmm +1
            IMOLE(mmm,nnn) = j
            mi(j) = 1
            exit
          enddo
        enddo
      enddo
      mmole(nnn) = mmm
      ndistr(mmm) = ndistr(mmm) + 1
    enddo
  enddo
!
  nmole = nnn
!  allocate (MMOLE(nmole))
  write  (6,1001)  nmole
1001 format ('Total number of molecules is',I5)
  write  (6,1002) (n,n=1,11), (ndistr(n),n=1,11)
1002 format ('No.atoms',11I6 / 'No.moles',11I6)
  RETURN
END
!
!
!                                                               ========
!================================================================ DIATOM
      SUBROUTINE  DIATOM
  use param
  use charac
  use atomsi
  use aboxof
  use cartes
  use molecu
!
  implicit none
!     ======================================recognize diatomic molecules
!
  double precision  pix,piy,piz, pjx,pjy,pjz, rx,ry,rz, dx,dy,dz
  double precision  pjx0,pjy0,pjz0, rij2,CUT2
  integer*4 K,J,I,I1,I2,IO,III,NNN
!
!---------------------------------------------calc distance of atoms
  cut2 = dintra**2
  nnn = 0
  do  iii = 1, 2
    io = iatom2(iii)
    if (io < 0 .or. io > ncompo) cycle
    i1 = ions(1,io)
    i2 = ions(2,io)
    DO I=i1, i2-1
      pix = p(1,i)
      piy = p(2,i)
      piz = p(3,i)
      do J=i+1,i2
        pjx0 = p(1,j)
        pjy0 = p(2,j)
        pjz0 = p(3,j)
        if (pjx0 < pix)  pjx0 = pjx0 + 1.0
        if (pjy0 < piy)  pjy0 = pjy0 + 1.0
        if (pjz0 < piz)  pjz0 = pjz0 + 1.0
        DO K = 1, 8
          pjx = pjx0 - transx(k)
          pjy = pjy0 - transy(k)
          pjz = pjz0 - transz(k)
          RX = PIX - PjX
          RY = PIY - PjY
          RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = RX * BOX(1)
          DY = RY * BOX(2)
          DZ = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          IF (RIJ2 <= CUT2)  GO TO 255
        enddo
        cycle
!                  ----------------------------------Kumiawase of diatomic
255     nnn = nnn +1
        IDMOLE(1,nnn) = I
        IDMOLE(2,nnn) = J
        idmole(3,nnn) = iii
        DMOLE(1,nnn) = DX
        DMOLE(2,nnn) = Dy
        DMOLE(3,nnn) = DZ
        DMOLE(4,nnn) = SQRT(RIJ2)
!                  -----------------------------------P of center of mass
        Pix=(Pix+Pjx)/2.
        Piy=(Piy+Pjy)/2.
        Piz=(Piz+Pjz)/2.
        if (pix < 0.0)   pix = pix + 1.0
        if (pix > 1.0)   pix = pix - 1.0
        if (piy < 0.0)   piy = piy + 1.0
        if (piy > 1.0)   piy = piy - 1.0
        if (piz < 0.0)   piz = piz + 1.0
        if (piz > 1.0)   piz = piz - 1.0
        p(1,ntion+nnn) = pix
        p(2,ntion+nnn) = piy
        p(3,ntion+nnn) = piz
!
!                   WRITE(*,*) nnn,IDMOLE(1,nnn),IDMOLE(2,nnn),pix,piy,piz
!
      enddo
    enddo
  enddo
  ndmole = nnn
  RETURN
END
!
!                                                               ========
!================================================================ PREPAR
SUBROUTINE  PREPAR  (FORMUL)
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use geomet
  use tables
  use counts
  use radial
!
  implicit none
!
  double precision FORMUL
  integer*4 nelm,io,j
!     ----------------------------------- Preparing some variables, etc.
!
!
  NELM   = 0
  TWEGHT = 0.0D0
  DO IO = 1, NCOMPO
    IONS(1,IO) = NELM + 1
    NELM       = NELM + NION(IO)
    IONS(2,IO) = NELM
    NIOND(IO)  = 0
    DO J = IONS(1,IO), IONS(2,IO)
      IF (IOND(J) /= 0)  NIOND(IO) = NIOND(IO) + 1
    enddo
    TWEGHT = TWEGHT + WIO(IO) * dble(NIOND(IO))
  enddo
  NFORML = NION(2)
  IF (NFORML == 0)  NFORML = NION(3)
  IF (FORMUL > 0.0D0)   NFORML = NION(1) / FORMUL
  FJMOL = ANA / 1.0D10 / DBLE(NFORML)
  IF (NELM > NTION)  GO TO 4444
  IF (NELM < NTION)  WRITE (*,1004)  NELM,NTION
  NTION = NELM
!
  VALMAX (:) = -9.9D19
  VALMIN (:) =  9.9D19
!
  TPRE = TEMP
  RETURN
!
4444 WRITE (*,4455)
4455 FORMAT ('*****  THE NUMBER OF PARTICLES IN FILE05 IS MORE THAN THAT IN FILE07  *****')
  STOP
!
1004 FORMAT ('******* Warnning *****  NTION(new)=',I5,'  (old)=',I5,7('*'))
1111 FORMAT (15A4)
END
!
!
!                                                               ========
!================================================================ CHECKP
SUBROUTINE  CHECKP
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use counts
!
  implicit none
!
!     ----------------------------------- Preparing some variables, etc.
!
!
  double precision        RL ,TT,FV,DL,CENTER
  integer*4      j,io,i1,i2,i
!
!        ----------------------- Check and correct velocity and momentum
  FV = 1.0D0
  TT = TEMP
  IF (TT < 0.001)  TT = 0.001
  IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
  FV = SQRT(TEMP/TT) * (DTIME/DTMO)
  DO J = 1, 3
    DL     = 0.0D0
    DO IO = 1, NCOMPO
      RL = 0.0D0
      IF (NION(IO) > 0)  THEN
        I1 = IONS(1,IO)
        I2 = IONS(2,IO)
        DO I = I1, I2
          IF (IOND(I) /= 0)  RL = RL + V(J,I)
        enddo
      END IF
      DL = DL + RL * WIO(IO)
    enddo
    DL = DL / TWEGHT
    IF (RUNOPT(16) == 'NO(MV=0)  ')  THEN
      DL = 0.0D0
    END IF
    DO I = 1, NTION
      IF (P(J,I) < 0.0D0)  P(J,I) = P(J,I) + 1.0D0
      IF (P(J,I) >= 1.0D0)  P(J,I) = P(J,I) - 1.0D0
      IF (IOND(I) /= 0)     V(J,I) = (V(J,I) - DL) * FV
      IF (IOND(I) == 0)     V(J,I) = 0.0D0
      IF (P(J,I)-P0(J,I) >  0.5)  P0(J,I) = P0(J,I) + 1.0D0
      IF (P(J,I)-P0(J,I) < -0.5)  P0(J,I) = P0(J,I) - 1.0D0
    enddo
    IF (RUNOPT(15) == 'CENTER    ')  THEN
      CENTER = 0.0D0
      DO I = 1, NTION
        CENTER = CENTER + P(J,I)
      enddo
      CENTER = CENTER / NTION - 0.5D0
      DO I = 1, NTION
        P(J,I)  = P(J,I)  - CENTER
        P0(J,I) = P0(J,I) - CENTER
      enddo
    END IF
    IF (runopt(34)  == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') call FIND_H2O(0)
  enddo
!
  RETURN
END
!
!
!                                                               ========
!================================================================ TABLER
SUBROUTINE  TABLER  (IPR)
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use vector
!
  implicit none
!
  integer*4 IPR,i,j,KKK,KLEM
  double precision rij
!     --------------------------------------------- Heading of MD output
!                     Preparing tables for force and energy calculations
!
!
  CHARACTER *63   LOGO1(18), LOGO2(18), LOGO3(13)
  DATA  LOGO1 / &
    '     *******               **************************          ', &
    '       ****                 ***********          ********      ', &
    '       *****                 *********              ********   ', &
    '       ******               **********               ********* ', &
    '       *******             ***********                *********', &
    '       **** ***           ************                *********', &
    '       ***   ***         *** *********                *********', &
    '       ***    ***       ***  *********    Parallel    *********', &
    '       ***     ***     ***   *********                *********', &
    '      ***       ***   ***    *********                ******** ', &
    '      ***        *******     *********                *******  ', &
    '     ****         *****      *********               *******   ', &
    '    *****          ***       *********              *******    ', &
    '    *****           *        *********             *******     ', &
    '   *******                   *********            ******       ', &
    '  ********                  ***********         ******         ', &
    '***********               ************************            R', &
    '                                                               '/
  DATA  LOGO2 / &
    '************                *************************          ', &
    '     *********                ************       *******       ', &
    '       ********               ***********           *******    ', &
    '         *******            ***  ********            ********  ', &
    '           ******         ***    ********             ******** ', &
    '            ******      ***      ********              ********', &
    '             ******   ***        ********              ********', &
    '              ********           ********   Parallel   ********', &
    '               ******            ********              ********', &
    '              ********           ********              ******* ', &
    '            ***  ******          ********             *******  ', &
    '          ***     ******         ********            *******   ', &
    '        ***        ******        ********           *******    ', &
    '      ***           ******       ********          ******      ', &
    '    ****             ******      ********        ******        ', &
    '  ******              *******   **********     ******          ', &
    '**********              ***************************           R', &
    '                                                               '/
  DATA  LOGO3 / &
    'Ms-Fortran-PowerStation Ver.4.0             Version            ', &
    '386DX+FPU/486DX/Pentium + NDP-FORTRAN/xxx   Version            ', &
    'LUNA-88K (88100+88200) + f77                Version            ', &
    'Transputer (T805) + Parallel fortran (3L)   Version            ', &
    'HP 9000 Series (PA-RISC) + f77              Version            ', &
    'IBM-AIX-FORT                                Version            ', &
    'F77 on Sony NEWS-WS                         Version            ', &
    'FTN compilar on DN10000                     Version            ', &
    'Hitachi Super Computer (S820-80)            Version            ', &
    'F77 on CRAY Super Computer                  Version            ', &
    'DEC Fortran for Windows NT                  Version            ', &
    'Fortran90 for all platform                  Version            ', &
    '                                            Version            '/
!     if (FLNAME(3) == 'Ms-Fortran    ')  logo3(1) = logo3(1)
  if (FLNAME(3) == 'NDP-FORTRAN386')  logo3(1) = logo3(2)
  IF (FLNAME(3) == 'LUNA88K       ')  LOGO3(1) = LOGO3(3)
  IF (FLNAME(3) == 'PARALLEL-F77  ')  LOGO3(1) = LOGO3(4)
  IF (FLNAME(3) == 'HP-9000       ')  LOGO3(1) = LOGO3(5)
  if (FLNAME(3) == 'IBM-AIX-FORT  ')  logo3(1) = logo3(6)
  if (FLNAME(3) == 'NEWS-F77      ')  logo3(1) = logo3(7)
  if (FLNAME(3) == 'DN10000       ')  logo3(1) = logo3(8)
  if (FLNAME(3) == 'S820-80       ')  logo3(1) = logo3(9)
  if (FLNAME(3) == 'CRAY-F77      ')  logo3(1) = logo3(10)
  if (FLNAME(3) == 'DEC Fortran   ')  logo3(1) = logo3(11)
  if (FLNAME(3) == 'F90           ')  logo3(1) = logo3(12)
  if (FLNAME(3) == 'Dummy         ')  logo3(1) = logo3(13)
!
  IF (RUNOPT(17)  == 'CRYSTAL   ')  THEN
    DO I = 1, 18
      LOGO1(I) = LOGO2(I)
    enddo 
  END IF
!
  CALL  TMATRX
!
  IF (RUNOPT(8) /= 'METAL     ')  CALL  COULMB
!
!     -------------------------------------------------------- LOGO mark
  IF (IPR == 1) THEN
          write(16,'("I--", 128("-"), "I")')
       KLEM = LEM/10 
       DO KKK = 1, KLEM   
    WRITE (16,5000) (dble(NION(I))/dble(NFORML),ATOM(I),I=1+10*(KKK-1),10*KKK)
       enddo
          write(16,'("I--", 128("-"), "I")')
    WRITE (16,5001) BOX(1),BOX(4), &
                           BOX(2),BOX(5),      LOGO1(1), &
                           BOX(3),BOX(6),      LOGO1(2), LOGO1(3), &
                           DENSTY,             LOGO1(4), LOGO1(5)
    WRITE (16,5002) RUNOPT(8),MODE,NVN, LOGO1(6), &
                          ALPHA,RCUT(1),LOGO1(7), &
                              LOGO1(8), LOGO1(9)
5000      FORMAT( 'I  Formula = ',10(F6.3,A2,1X), 26X,'  I')
5001      FORMAT('I  Basic cell : A=',F10.5,' A   cos(alpha)=',F9.5, &
                                                 10X,'I  ',63X, '  I'/ &
                 'I               B=',F10.5,' A   cos(beta )=',F9.5, &
                                                 10X,'I  ',A63, '  I'/ &
                 'I               C=',F10.5,' A   cos(gamma)=',F9.5, &
                                                 10X,'I  ',A63, '  I'/ &
                 'I--',60('-'),'I  ', A63, '  I' / &
                 'I  Density    : ',F12.7,' g/cm3',29X,'I  ',A63, &
                                                               '  I' / &
                 'I--',60('-'),'I  ',A63, '  I' )
5002      FORMAT('I  ',A8,'  I    Mode =',I3, 13X, 'No.of Nv=',I5, &
                                                  9X,'I  ',A63,'  I' / &
                 'I  ',8X,'  I    Alpha=',F6.3,' A-1      Rcut(L) =', &
                                     F7.3,' A', 5X,'I  ', A63, '  I' / &
                 'I--',60('-'),'I  ', A63,'  I' / &
                 'I     Atom    No    Z      W      A       B', &
                         7X,'C       D    I  ',A63,'  I' )
!
    DO I = 1, 8
      WRITE (16,5005) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                           AIO(I), BIO(I), CIO(I), DIO(I), &
                            LOGO1(I+9)
    enddo
5005  FORMAT('I', I3, 2X, A3, I6, F8.3, F7.2, F8.4, 3F8.3,' I  ',A63,'  I' )
    I = 9
    WRITE (16,5006) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                         AIO(I), BIO(I), CIO(I), DIO(I), &
                                     LOGO3(1),FLNAME(2)
   do I = 10,LEMW
    WRITE (16,5006) I, ATOM(I), NION(I), ZIO(I), WIO(I), &
                         AIO(I), BIO(I), CIO(I), DIO(I), &
                                        '     ', '     '
   enddo
5006 FORMAT('I', I3, 2X, A3, I6, F8.3, F7.2, F8.4, 3F8.3,' I  ',A52,A11,'  I' )
  END IF
!
!     ------------------------------------------------------ Short range
  IF (RUNOPT(8) == 'METAL     ')  CALL  METALP  (IPR)
  IF (IPR == 1)  THEN
    r3limax = 0.0D0
    IF (RUNOPT(8) == '          ')  CALL  BUSING
    IF (RUNOPT(8) == 'BUSING    ')  CALL  BUSING
    IF (RUNOPT(8) == 'STSUNE    ')  CALL  BUSING
    IF (RUNOPT(8) == 'MORSE     ')  CALL  MORSEP
    IF (RUNOPT(8) == 'MORSE-AT  ')  CALL  MORSEP
    IF (RUNOPT(8) == 'BMH-EXP   ')  CALL  BMHEXP(0)  !WATER-POL
    IF (RUNOPT(8) == 'BMH-EXP*  ')  CALL  BMHEXP(0)  !WATER-POL
    IF (RUNOPT(8) == 'BELONO    ')  CALL  MORSEP
    IF (RUNOPT(8) == 'TOSIFUMI  ')  CALL  TOSIFU
    IF (RUNOPT(8) == 'WOODCOCK  ')  CALL  ANGELP
    IF (RUNOPT(8) == 'PAULING   ')  CALL  ANGELP
    IF (RUNOPT(8) == 'L-J       ')  CALL  LJMODL
    IF (RUNOPT(8) == 'PAIR-P    ')  CALL  PAIRP
!
    IF (RUNOPT(3) == 'DETAIL    ') THEN
      DO I = 70, 300, 10
        RIJ = dble(I) * 0.01D0
        WRITE (16,6666)  RIJ, E0(I)*1D8,(E1(I,J)*1D8,J=1,NPAIR)
      enddo
      WRITE (16,6666)
      DO I = 70, 300, 10
        RIJ = dble(I) * 0.01D0
        WRITE (16,6666) RIJ,F0(I),(F1(I,J),J=1,NPAIR)
      enddo
      WRITE (16,6666)
      DO I = 70, 300, 10
        RIJ = dble(I) * 0.01D0
        WRITE (16,6666) RIJ,F0(I),(F1(I,J)+zij(j)*F0(i),J=1,NPAIR)
      enddo
6666             FORMAT (2X,F5.2,1X,F10.6,1X,10F11.7)
    END IF
  END IF
!
  ECORR = 0.0D0
  VCORR = 0.0D0
  IF (RUNOPT(8) == '          ' .OR. RUNOPT(8) == 'BUSING    ' .OR. &
      RUNOPT(8) == 'STSUNE    ' .OR. RUNOPT(8) == 'MORSE     ' .OR. &
      RUNOPT(8) == 'MORSE-AT  ' .OR. RUNOPT(8) == 'BMH-EXP   ' .OR. &
                                     RUNOPT(8) == 'BMH-EXP*  ' .OR. &
      RUNOPT(8) == 'BELONO    ' .OR. RUNOPT(8) == 'PAIR-P    ' .OR. &
      RUNOPT(8) == 'TOSIFUMI  ' .OR. RUNOPT(8) == 'WOODCOCK  ' .OR. &
      RUNOPT(8) == 'PAULING   ' .OR. RUNOPT(8) == 'L-J       ') THEN
    CALL  VWCORR(0)  !WATER-POL
  END IF
  RETURN
END
!
!
!                                                               ========
!================================================================ TMATRX
SUBROUTINE  TMATRX
  use param
  use aboxof
  use paramt
  use cartes
!
  implicit none
!
  double precision         SINA(3), COSA(3), DET, GG
  integer(KIND=4)      i,j,k,n
!     ---------------------------- cos and sin of alpha, beta, and gamma
  DO I = 1, 3
    COSA(I) = BOX(I+3)
    IF (BOX(I+3) > 1.0D0)  THEN
      COSA(I)  = COS(BOX(I+3)*PI/180.0D0)
      BOX(I+3) = COSA(I)
    END IF
    SINA(I) = SQRT(1.0D0 - COSA(I)**2)
  enddo
!
!     ------------------ Transformation matrix from crystal to Cartesian
!
  H(1,3) =  0.D0
  H(2,3) =  0.D0
  H(3,3) =  BOX(3)
  H(1,2) =  0.0D0
  H(2,2) =  BOX(2)*SINA(1)
  H(3,2) =  BOX(2)*COSA(1)
  H(3,1) =  BOX(1)*COSA(2)
  H(2,1) =  BOX(1)*COSA(3)*SINA(1)
  H(1,1) =  BOX(1)*SQRT(1-COSA(2)**2-(COSA(3)*SINA(1))**2)
  VOL = H(3,1)*(H(1,2)*H(2,3) - H(2,2)*H(1,3)) - &
        H(2,1)*(H(1,2)*H(3,3) - H(3,2)*H(1,3)) + &
        H(1,1)*(H(2,2)*H(3,3) - H(3,2)*H(2,3))
  IF (VOL <= 0.0D0)  THEN
    H(1,1) = - H(1,1)
    H(2,1) = - H(2,1)
    H(3,1) = - H(3,1)
    VOL    = - VOL
  END IF
  DENSTY = TWEGHT / (ANA * VOL * 1.0D-24)
!
!             WRITE (*,*)  H(1,1), H(2,1), H(3,1)
!             WRITE (*,*)  H(1,2), H(2,2), H(3,2)
!             WRITE (*,*)  H(1,3), H(2,3), H(3,3)
!             WRITE (*,*)  VOL
!
!     ------------------ Transformation matrix from Cartesian to crystal
!
  CALL  INVERS  (H, DET, HINV)
!
!             WRITE (*,*)  HINV(1,1), HINV(2,1), HINV(3,1)
!             WRITE (*,*)  HINV(1,2), HINV(2,2), HINV(3,2)
!             WRITE (*,*)  HINV(1,3), HINV(2,3), HINV(3,3)
!
!     ---------------------------------------------------- Metric tensor
  DO I = 1, 3
    DO J = 1, 3
      GG = 0.0D0
      DO K = 1, 3
        GG = GG + H(K,J) * H(K,I)
      enddo
      G(J,I) = GG
    enddo
  enddo
  CALL  INVERS  (G, DET, GINV)
!     -------------------------- Trans. of reciprocal force to cartesian
!
  FTOQ(1,1) = H(1,1) / BOX(1)
  FTOQ(2,1) = H(2,1) / BOX(1)
  FTOQ(3,1) = H(3,1) / BOX(1)
  FTOQ(1,2) = H(1,2) / BOX(2)
  FTOQ(2,2) = H(2,2) / BOX(2)
  FTOQ(2,3) = H(3,2) / BOX(2)
  FTOQ(1,2) = H(1,3) / BOX(3)
  FTOQ(2,2) = H(2,3) / BOX(3)
  FTOQ(2,3) = H(3,3) / BOX(3)
!
!     --------------------------------------- Reciprocal cell parameters
  RBOX(1) =  BOX(2)*BOX(3)*SINA(1) / VOL
  RBOX(2) =  BOX(1)*BOX(3)*SINA(2) / VOL
  RBOX(3) =  BOX(1)*BOX(2)*SINA(3) / VOL
  RBOX(4) = (COSA(2)*COSA(3)-COSA(1)) / (SINA(2)*SINA(3))
  RBOX(5) = (COSA(1)*COSA(3)-COSA(2)) / (SINA(1)*SINA(3))
  RBOX(6) = (COSA(1)*COSA(2)-COSA(3)) / (SINA(1)*SINA(2))
!     ---------------------------------------
  IF (RCUT(1) < 0.01D0)          RCUT(1)  = 15.0D0
  IF (RCUT(1) > 1.0D0/RBOX(1)/2) RCUT(1)  = 1.0D0/RBOX(1)/2.0D0
  IF (RCUT(1) > 1.0D0/RBOX(2)/2) RCUT(1)  = 1.0D0/RBOX(2)/2.0D0
  IF (RCUT(1) > 1.0D0/RBOX(3)/2) RCUT(1)  = 1.0D0/RBOX(3)/2.0D0
  NRCUT(1) = INT(RCUT(1)*100.0D0 + 2.5D0)
!    IF (NRCUT(1) < LSR)          NRCUT(1) = LSR
  IF (NRCUT(1) > LTB)  NRCUT(1) = LTB
  IF (MXCUT > NRCUT(1))        MXCUT    = NRCUT(1)
  IF (RCUT(2) < 0.01D0)          RCUT(2)  = 7.5D0
  IF (RCUT(2) > RCUT(1))       RCUT(2)  = RCUT(1)
  IF (RCUT(2) > (LSR-1)*0.01D0)  RCUT(2)  = dble(LSR-1)*0.01D0
  NRCUT(2) = INT(RCUT(2)*100.0D0 + 3.01D0)
!
!     -- (0,0,0),(1,0,0),(0,1,0),(0,0,1),(1,1,0),(1,0,1),(0,1,1),(1,1,1)
!
  N = 0
  DO I = 0, 1
    DO J = 0, 1
      DO K = 0, 1
        N = N + 1
        TRANSX(N) = I
        TRANSY(N) = J
        TRANSZ(N) = K
      enddo
    enddo
  enddo
  RETURN
END
!
!
!                                                               ========
!================================================================ INVERS
SUBROUTINE  INVERS  (X, DET, XINV)
!     -------------------------------------------- Given 3 by 3 matrix X
!                           Store determinant at DET and inverse at Xinv
!
  implicit none
!
  double precision  DET, X(3,3), XINV(3,3)
!
  DET = X(1,1)*X(2,2)*X(3,3) + X(1,2)*X(2,3)*X(3,1) +  &
        X(1,3)*X(2,1)*X(3,2) - X(1,3)*X(2,2)*X(3,1) -  &
        X(1,2)*X(2,1)*X(3,3) - X(1,1)*X(2,3)*X(3,2)
  IF (DET == 0.0D0)  GO TO 10
  XINV(1,1) = (X(2,2)*X(3,3) - X(3,2)*X(2,3)) / DET
  XINV(1,2) = (X(3,2)*X(1,3) - X(1,2)*X(3,3)) / DET
  XINV(1,3) = (X(1,2)*X(2,3) - X(2,2)*X(1,3)) / DET
  XINV(2,1) = (X(2,3)*X(3,1) - X(3,3)*X(2,1)) / DET
  XINV(2,2) = (X(3,3)*X(1,1) - X(1,3)*X(3,1)) / DET
  XINV(2,3) = (X(1,3)*X(2,1) - X(2,3)*X(1,1)) / DET
  XINV(3,1) = (X(2,1)*X(3,2) - X(3,1)*X(2,2)) / DET
  XINV(3,2) = (X(3,1)*X(1,2) - X(1,1)*X(3,2)) / DET
  XINV(3,3) = (X(1,1)*X(2,2) - X(2,1)*X(1,2)) / DET
  RETURN
!     --------------------------------------------- TEST FOR SINGULARITY
10           IF (DET == 0)  WRITE  (*,6180)
6180         FORMAT(5X,'*** The matrix is singular ***')
  RETURN
END
!
!
!                                                               ========
!================================================================ PTOXYZ
!
!     SUBROUTINE  PTOXYZ  (I)
!  use param
!  use atomsi
!  use cartes
!
!
!T    double precision        PX,PY,PZ
!
!     -------------------------------- TRANSFORMATION OF ION COORDINATES
!                                      FROM CRYSTAL TO CARTESIAN (X,Y,Z)
!
!T              PX = P(1,I)
!T              PY = P(2,I)
!T              PZ = P(3,I)
!T      Q(1,I)  = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
!T      Q(2,I)  = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
!T      Q(3,I)  = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!
!T              PX = P0(1,I)
!T              PY = P0(2,I)
!T              PZ = P0(3,I)
!T      Q0(1,I) = H(1,1)*PX + H(1,2)*PY + H(1,3)*PZ
!T      Q0(2,I) = H(2,1)*PX + H(2,2)*PY + H(2,3)*PZ
!T      Q0(3,I) = H(3,1)*PX + H(3,2)*PY + H(3,3)*PZ
!     RETURN
!     END
!
!
!                                                               ========
!================================================================ XYZTOP
SUBROUTINE  XYZTOP
  use param
  use atomsi
  use cartes
!
  implicit none
!
!T    double precision        QX,QY,QZ
     integer(KIND=4) I
!
!     -------------------------------- TRANSFORMATION OF ION !OORDINATES
!                                      FROM !ARTESIAN (X,Y,Z) TO !RYSTAL
!
  DO I = 1, NTION
!              QX = Q(1,I)
!              QY = Q(2,I)
!              QZ = Q(3,I)
!         P(1,I)  = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
!         P(2,I)  = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
!         P(3,I)  = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
!
!              QX = Q0(1,I)
!              QY = Q0(2,I)
!              QZ = Q0(3,I)
!         P0(1,I) = HINV(1,1)*QX + HINV(1,2)*QY + HINV(1,3)*QZ
!         P0(2,I) = HINV(2,1)*QX + HINV(2,2)*QY + HINV(2,3)*QZ
!         P0(3,I) = HINV(3,1)*QX + HINV(3,2)*QY + HINV(3,3)*QZ
  enddo
  RETURN
END
!
!
!                                                               ========
!================================================================ COULMB
SUBROUTINE  COULMB
  use param
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use vector
  use cartes
  use charge
  use molecu
  use charac
  use ewal
!
  implicit none
!
!     ------------------------------------ Table for Coulomb interaction
!
!
  double precision     XN,FCT, AL2PI,RIJ,ARIJ,PIAL2,VN2,EXPVN
  double precision     YN,UCT, PAA2,ELC2,ASP,ERFC,alphal
  double precision     ZN,PCTT, Z, X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4,az,ABC2,AB
  integer*4    MXNV(6)
  integer*4     I,io,MAXNV2,IL,JL,KL,IL2,JL2,KL2,II,JJ,J,KK,K
! ----------------------------------------SPME
  double precision pimxKx,pimyKy,pimzKz
  double precision bcos,bsin
  double precision SPL,DU
  integer JJX,JJY,JJZ,JX,JY,JZ,kkai,nmkkai
  integer nsp,ndiv
  complex(kind(0d0)) btop,bbot !SPME
! ----------------------------------------SPME
!
!              MODE       1     2     3     4     5     6
!     MAXIMUM of NV**2    7          15    23    28    31   39
  DATA  MXNV   /      7,   11,   15,   23,   28,   31        /
!     No. of NVs         40    85   125   230   309   369   510
!
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
  DATA  X0,X1,X2,X3   / 10.00464D0, 8.426553D0, 3.460259D0, .5623536D0     /
  DATA  Y0,Y1,Y2,Y3,Y4/ 10.00464D0, 19.71558D0, 15.70229D0, 6.090749D0, 1.0D0/
!
  ELC2   = ELC**2
  DO I = 1, NRCUT(1)+1
    E0(I) = 0.0D0
    F0(I) = 0.0D0
  enddo
  NVN    = 0
  UCSELF = 0.0D0
  do i = 1, ntion+ndmole  !WATER-POL
    ZIIA(i) = 0.0D0
  enddo
    ZIA(:) = 0.0D0
  az = 0.0D0
  do io = 1, ncompo
    az = az + abs(zio(io))
  enddo
  IF (MODE <= -998. .or. az < 0.00001D0)  RETURN
!  --------------------------------------- Gaussian (alpha) parameter
  MAXNV2 = ABS(MODE)
  IF (MAXNV2 <= 6)  THEN
    IF (MAXNV2 <= 0)  MAXNV2 = 1
    MAXNV2 = MXNV(MAXNV2)
  END IF
  ABC2  = dble(MAXNV2) /(RCUT(1)*2.0D0)**2 * 1.0001D0
  AB    = SQRT(ABC2)
  IF (ALPHA < 0.001D0) THEN
    ALPHAL  = MAXNV2 * 0.064D0 + 3.714D0 + RCUT(1) * 2.0D0 * 0.027D0
    ALPHA   = ALPHAL / (RCUT(1)*2.0D0)
  END IF
!     ------------------------------------------------------ Coulomb [1]
  AL2PI = 2.0D0 * ALPHA / SQRT(PI)
  DO I = 10, NRCUT(1)+3
    RIJ  = dble(I) * 0.01D0
    ARIJ = 1.0D0 / RIJ
!                                --- FUNCTION ERFC(X) : VERSION 5662
!                                ---    in "COMPUTER APPROXIMATIONS"
                                 Z = ABS(ALPHA * RIJ)
    ERFC = EXP(-Z*Z) * (X0+Z*(X1+Z*(X2+Z*X3))) / (Y0+Z*(Y1+Z*(Y2+Z*(Y3+Z*Y4))))
    ERFC = SIGN(ERFC,Z)
    IF (Z < 0.0D0)  ERFC = 2.0D0 + ERFC
    E0(I) = ERFC * (ARIJ*1.0D8) * ELC2
    F0(I) = ( AL2PI * EXP(-(ALPHA*RIJ)**2) * RIJ + ERFC ) * (ARIJ*1.0D8)**2 * ELC2 * ARIJ
  enddo
!     ------------------------------------------------------ Coulomb [2]
!                        Generate reciprocal vectors for EWALD summation
!                                                  Semi-sphere part only
  FCT   = 4.0D0 * ELC2 *  1.0D-8  / (VOL*1.0D-24)
  UCT   = 2.0D0 * ELC2 *  1.0D-16 / (PI * VOL*1.0D-24)
  PCTT   = 2.0D0 * ELC2 *  1.0D-16 / (2.0D0 * PI * VOL*1.0D-24)
  PIAL2 = PI**2 / ALPHA**2
!
  if (runopt(45) /= 'SPME      ') then   !Traditional EWALD
  IL  = INT(BOX(1) * AB + 1.5D0)
  JL  = INT(BOX(2) * AB + 1.5D0)
  KL  = INT(BOX(3) * AB + 1.5D0)
  IL2 = IL * 2 + 1
  JL2 = JL * 2 + 1
  KL2 = KL + 1
!
  DO II = 1, IL2
    I = IL + 1 - II
    XN = I * DBLE(RBOX(1))
    DO JJ = 1, JL2
      J = JL + 1 - JJ
      YN = J * DBLE(RBOX(2))
      DO KK =  1, KL2
        K = KK - 1
        ZN = K * DBLE(RBOX(3))
        IF (K > 0) GO TO 230
        IF (J < 0) cycle
        IF (J == 0 .AND. I <= 0) cycle
230     VN2 = XN**2 + YN**2 + ZN**2 + 2*(XN*YN*RBOX(6) + YN*ZN*RBOX(4) + XN*ZN*RBOX(5))
        IF (VN2 > ABC2)  cycle
        NVN = NVN + 1
        IF (NVN > LNV)  THEN
          WRITE  (*,9901)  ABS(MODE)
9901      FORMAT ('*****  SET [MODE] LESS THAN ',I2,'  *****')
          STOP
        END IF
        NVEC(1,NVN) = I
        NVEC(2,NVN) = J
        NVEC(3,NVN) = K
        EXPVN = EXP(- VN2 * PIAL2) / VN2
        FNV(NVN) = FCT * EXPVN
        UNV(NVN) = UCT * EXPVN
        PAA2 = 2.0D0 * (PIAL2 + 1.0D0/VN2)
        PNV(1,NVN) = PCTT * (1.0D0 - PAA2 * XN**2) * EXPVN
        PNV(2,NVN) = PCTT * (1.0D0 - PAA2 * YN**2) * EXPVN
        PNV(3,NVN) = PCTT * (1.0D0 - PAA2 * ZN**2) * EXPVN
        PNV(4,NVN) = PCTT * (0.0D0 - PAA2 * XN*YN) * EXPVN
        PNV(5,NVN) = PCTT * (0.0D0 - PAA2 * XN*ZN) * EXPVN
        PNV(6,NVN) = PCTT * (0.0D0 - PAA2 * YN*ZN) * EXPVN
      enddo
    enddo
  enddo
  endif
  if (runopt(45) == 'SPME      ') then !Smooth Particle Mesh Ewald
!
!   Q-array Q(m1,m2,m3)
!    NVNx = 40   ! Grid size
!    NVNy = 40   ! Grid size
!    NVNz = 40   ! Grid size
!
    NVN=NVNx*NVNy*NVNz
!   FFTW doesn't include normaliztaion constants
    QCOFF = 0.5d0*UCT/2.0d0
    PCOFF = QCOFF
    FCOFF = FCT/PI/4.0d0
!
!
!    NDIM = 4    ! Dimension of Cardnal B-splines
!
    nkai=1
    do j = 0,NDIM
      if (j > 0) nkai=nkai*j
    enddo
!
    do JX = 1,NVNx
      JJX = JX-1
      if (JJX > NVNx/2) JJX = JJX - NVNx
      pimxKx = PI*dble(JJX)/dble(NVNx)
!
      bcos=cos(2.0d0*pimxKx*dble(NDIM-1))
      bsin=sin(2.0d0*pimxKx*dble(NDIM-1))
      btop=CMPLX(bcos,bsin)
      bbot=0.0d0
      do k=0,NDIM-2
        SPL=0.0d0
        kkai=1
        nmkkai=nkai
        do nsp = 0,NDIM
          ndiv=1
          if (nsp > 0) kkai = kkai*nsp
          if (nsp > 0) ndiv=NDIM-(nsp-1)
          nmkkai=nmkkai/ndiv
          DU = dble(k+1-nsp)
          IF(DU <0.0d0) DU=0.0d0
          SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DU**(NDIM-1)
        enddo
        SPL=SPL/dble(nkai/NDIM)
        bcos=cos(2.0d0*pimxKx*dble(k))
        bsin=sin(2.0d0*pimxKx*dble(k))
        bbot=bbot+SPL*CMPLX(bcos,bsin)
      end do
      bxsq(JX) = (abs(btop/bbot))**2
!write(*,*)'bxsq=',bxsq(JX) 
!
!      if (NDIM == 2) bxsq(JX)=1.0d0
!      if (NDIM == 3) then
!        bxsq(JX)=4.0d0*((cos(3.0d0*pimxKx)*cos(pimxKx))**2+(sin(3.0d0*pimxKx)*cos(pimxKx))**2)/
!        &
!                 (1.0d0+cos(2.0d0*pimxKx))**2
!      endif
!      if (NDIM == 4) then
!        bcos=1.0d0/6.0d0+2.0d0/3.0d0*cos(2.0d0*pimxKx)+1.0d0/6.0d0*cos(4.0d0*pimxKx)
!        bsin=2.0d0/3.0d0*sin(2.0d0*pimxKx)+1.0d0/6.0d0*sin(4.0d0*pimxKx)
!        breal=cos(6.0d0*pimxKx)*bcos+sin(6.0d0*pimxKx)*bsin
!        bimag=sin(6.0d0*pimxKx)*bcos-cos(6.0d0*pimxKx)*bsin
!        bxsq(JX)=(breal**2+bimag**2)/(bcos**2+bsin**2)**2
!      endif
!write(*,*)'bxsq=',bxsq(JX) 
!read(*,*)
    enddo
    do JY = 1,NVNy
      JJY = JY-1
      if (JJY > NVNz/2) JJY = JJY - NVNy
      pimyKy = PI*dble(JJY)/dble(NVNy)
      bcos=cos(2.0d0*pimyKy*dble(NDIM-1))
      bsin=sin(2.0d0*pimyKy*dble(NDIM-1))
      btop=CMPLX(bcos,bsin)
      bbot=0.0d0
      do k=0,NDIM-2
        SPL=0.0d0
        kkai=1
        nmkkai=nkai
        do nsp = 0,NDIM
          ndiv=1
          if (nsp > 0) kkai = kkai*nsp
          if (nsp > 0) ndiv=NDIM-(nsp-1)
          nmkkai=nmkkai/ndiv
          DU = dble(k+1-nsp)
          IF(DU <0.0d0) DU=0.0d0
          SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DU**(NDIM-1)
        enddo
        SPL=SPL/dble(nkai/NDIM)
        bcos=cos(2.0d0*pimyKy*dble(k))
        bsin=sin(2.0d0*pimyKy*dble(k))
        bbot=bbot+SPL*CMPLX(bcos,bsin)
      end do
      bysq(JY) = (abs(btop/bbot))**2
    enddo
    do JZ = 1,NVNz
      JJZ = JZ-1
      if (JJZ > NVNz/2) JJZ = JJZ - NVNz
      pimzKz = PI*dble(JJZ)/dble(NVNz)
      bcos=cos(2.0d0*pimzKz*dble(NDIM-1))
      bsin=sin(2.0d0*pimzKz*dble(NDIM-1))
      btop=CMPLX(bcos,bsin)
      bbot=0.0d0
      do k=0,NDIM-2
        SPL=0.0d0
        kkai=1
        nmkkai=nkai
        do nsp = 0,NDIM
          ndiv=1
          if (nsp > 0) kkai = kkai*nsp
          if (nsp > 0) ndiv=NDIM-(nsp-1)
          nmkkai=nmkkai/ndiv
          DU = dble(k+1-nsp)
          IF(DU <0.0d0) DU=0.0d0
          SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DU**(NDIM-1)
        enddo
        SPL=SPL/dble(nkai/NDIM)
        bcos=cos(2.0d0*pimzKz*dble(k))
        bsin=sin(2.0d0*pimzKz*dble(k))
        bbot=bbot+SPL*CMPLX(bcos,bsin)
      end do
      bzsq(JZ) = (abs(btop/bbot))**2
    enddo
!
    THREC(1,1,1)= 0.0d0
!
    do JZ = 1, NVNz
      JJZ = JZ-1
      do JY = 1, NVNy
        JJY = JY-1
        do JX = 1, NVNx
          JJX = JX-1
          ARRB=bxsq(JX)*bysq(JY)*bzsq(JZ)
          if (JJX == 0 .and. JJY == 0 .and. JJZ == 0) cycle
          if (JJX > NVNx/2) JJX = JJX - NVNx
          if (JJY > NVNy/2) JJY = JJY - NVNy
          if (JJZ > NVNz/2) JJZ = JJZ - NVNz
          XN=dble(JJX)*RBOX(1)
          YN=dble(JJY)*RBOX(2)
          ZN=dble(JJZ)*RBOX(3)
          VN2=XN**2+YN**2+ZN**2+2.0d0*(XN*YN*RBOX(6)+YN*ZN*RBOX(4)+ZN*XN*RBOX(5))
          ARRC=exp(-1.0d0*PIAL2*VN2)/VN2
          THREC(JX,JY,JZ)=ARRB*ARRC
          PAA2 = 2.0D0 * (PIAL2 + 1.0D0/VN2)
          PNVxx(JX,JY,JZ) =  (1.0D0 - PAA2 * XN**2)
          PNVyy(JX,JY,JZ) =  (1.0D0 - PAA2 * YN**2)
          PNVzz(JX,JY,JZ) =  (1.0D0 - PAA2 * ZN**2)
          PNVxy(JX,JY,JZ) =  (0.0D0 - PAA2 * XN*YN)
          PNVxz(JX,JY,JZ) =  (0.0D0 - PAA2 * XN*ZN)
          PNVyz(JX,JY,JZ) =  (0.0D0 - PAA2 * YN*ZN)
        enddo
      enddo
    enddo
!
!
  endif
!     ------------------------------------------------------ Coulomb [3]
  ASP = - (ALPHA*1.0D8) * ELC2 / SQRT(PI)
  DO IO = 1, NCOMPO
    UCSELF     = UCSELF + DBLE(NION(IO))*ZIO(IO)**2*ASP
    UCSLFI(IO) =          DBLE(NION(IO))*ZIO(IO)**2*ASP
    ZIA(IO)    = ZIO(IO)*ZIO(IO)*ASP*2.0
  enddo
  do I = 1, NTION+ndmole                   !WATER-POL
    ZIIA(I) = ZII(I)*ZII(I)*ASP*2.0D0
    ZIIC(I) = ZIIA(I) !/2.0D0
  enddo
  RETURN
END
!
!
!                                                               ========
!================================================================ VWCORR
SUBROUTINE  VWCORR (IPOL) !WATER-POL : IPOL
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
!
  implicit none
!
!     --------- Correction of energy and pressur for Van der Waals terms
!
!
  double precision  pi4, SATOMS
  integer(KIND=4) n,I,j,NNCOMPO,IPOL
!
  PI4 = 4.0D0 * PI
!     BETA  = CAL * 1.0D10 / ANA
!     IF (RUNOPT(8) == 'TOSIFUMI  ')  BETA = 1.0D-19 * 1.0D7
  ECORR = 0.0D0
  VCORR = 0.0D0
  N = 0
  NNCOMPO = NCOMPO    !WATER-POL
  if (IPOL == 1) NNCOMPO = NCOMPO + 1  !WATER-POL
  DO I = 1, NNCOMPO  !WATER-POL
    DO J = 1, I
      N = N + 1
      SATOMS = NION(I) * NION(J) / VOL * PI4
!             SATOMS = NION(I) * NION(J) / VOL * PI4 * BETA
      IF (I == J)  SATOMS = SATOMS / 2.0D0
      ECORR = ECORR - SATOMS*CIJ(N) / 3.0D0 / RCUT(1)**3 - SATOMS*DIJ(N) / 5.0D0 / RCUT(1)**5
      VCORR = VCORR - 6.0D0*SATOMS*CIJ(N) / 3.0D0 / RCUT(1)**3 &
                    - 8.0D0*SATOMS*DIJ(N) / 5.0D0 / RCUT(1)**5
      IF (RUNOPT(8) == 'MORSE-PL  ')  THEN
        ECORR = ECORR -     SATOMS*D4IJ(N) / RCUT(1) -   SATOMS*D7IJ(N) / 4.0 / RCUT(1)**4
        VCORR = VCORR - 4.0*SATOMS*D4IJ(N) / RCUT(1) - 7.0*SATOMS*D7IJ(N) / 4.0 / RCUT(1)**4
      END IF
    enddo
  enddo
!     WRITE (*,*)  RCUT(2), RCUT(1)
!     WRITE (*,1000) ECORR*FJMOL,
!    *               VCORR / (3.0D0*VOL*1.0D-24)*1.0D-10
!1000 FORMAT (11X, 'Ecorr=',F7.3,'kJ/mol       Pcorr=',F6.3,'GPa')
  RETURN
END
!
!
!                                                                =======
!================================================================ MORSEP
SUBROUTINE  MORSEP
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use pmorse
!
  implicit none
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!                                                    plus MORSE function
!                                                    plus three body
!
!
  double precision    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  double precision    EX, ARB, ZFORML(LEM), epsij(lef), sepij(lef)
  double precision    R3BGRD2,R3BLIM2,R3BG,RSIJP,BEIJP,DIJP,ELC2
  CHARACTER *40   FMT1, FMT2
  integer*4 LPAIR,LCOMPO,IJ,KP,JP,IP,J,II,N,I
!
  ELC2 = ELC * ELC
  BETA = CAL * 1.0D10 / ANA
!
  N3BP = 0
  DO I = 1, l3p
    I3BP(1,I) = 0
    i3BP(2,I) = 0
    i3bp(3,i) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO  J = 1, II
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0 * ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J) * ELC2 * 1.0D8
      DMIJ(N) = 0.0
      BEIJ(N) = 0.0
      RSIJ(N) = 0.0
      RSWTCH(N) = 0.0
      epsij(n)  = 1.0
      sepij(n)  = 1.0
    enddo
  enddo
!
  IF (RUNOPT(8) == 'MORSE     '.OR.RUNOPT(8) == 'MORSE-AT  '.OR.  &
      RUNOPT(8) == 'BELONO    ' )  THEN
120        READ   (15,5555)  IP,JP, KP, DIJP, BEIJP, RSIJP, R3BG
5555        FORMAT (3I2,4X,5F10.0)
    IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
    IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
    IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
    IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
      IF (KP == 0)  THEN
        IF (JP > IP)  THEN
          IJ = IP
          IP = JP
          JP = IJ
        END IF
        N = (IP - 1) * IP / 2 + JP
        DMIJ(N) = DIJP
        BEIJ(N) = BEIJP
        RSIJ(N) = RSIJP
        RSWTCH(N) = R3BG
      ELSE IF (IP == KP) THEN
        N3BP = N3BP +1
        I3BP(1,N3BP) = iP
        i3BP(2,N3BP) = jP
        i3BP(3,N3BP) = KP
!       -------------------------------------- F:kJ/mol
        FK3BP(N3BP)  = DIJP
        ANG3BP(N3BP) = BEIJP
        R3BLIM(1,N3BP) = RSIJP
        R3BGRD(1,N3BP) = R3BG
        IF (ANG3BP(N3BP) <= 0.01)   ANG3BP(N3BP)  =90.0
        IF (R3BLIM(1,N3BP) <= 0.01) R3BLIM(1,N3BP)= 1.2
        IF (R3BGRD(1,N3BP) <= 0.01) R3BGRD(1,N3BP)=20.0
        R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
        R3BGRD(2,N3BP) = R3BGRD(1,N3BP)
      ELSE IF (IP /= KP) THEN
        N3BP = N3BP +1
        I3BP(1,N3BP) = iP
        i3BP(2,N3BP) = jP
        i3BP(3,N3BP) = KP
!       ------------------------------------ F:kJ/mol
        FK3BP(N3BP)    = DIJP
        ANG3BP(N3BP)   = BEIJP
        R3BLIM(1,N3BP) = RSIJP
        R3BGRD(1,N3BP) = R3BG
        IF (ANG3BP(N3BP) <= 0.01)   ANG3BP(N3BP)  =90.0
        IF (R3BLIM(1,N3BP) <= 0.01) R3BLIM(1,N3BP)= 1.2
        IF (R3BGRD(1,N3BP) <= 0.01) R3BGRD(1,N3BP)=20.0
        READ (15,5566)  R3BLIM2, R3BGRD2
 5566   FORMAT (30X,2F10.0)
        IF (R3BLIM2 <= 0.01) R3BLIM2 = R3BLIM(1,N3BP)
        IF (R3BGRD2 <= 0.01) R3BGRD2 = R3BGRD(1,N3BP)
        R3BLIM(2,N3BP) = R3BLIM2
        R3BGRD(2,N3BP) = R3BGRD2
      ELSE
        STOP 'Something wrong in potetial param.'
      END IF
      GO TO 120
    END IF
    if (runopt(8) == 'BELONO    ') then
      read (15,5577)  zforml
 5577               format (10f5.0)
      N = 0
      DO I = 1, NCOMPO
        II = I
        DO J = 1, II
          N = N + 1
          epsij(N)  = ABS(zio(II)/zforml(II))*abs(zio(J) /zforml(J))
          sepij(N)  = SQRT(1.0 - epsij(N))
        enddo
      enddo
    end if
    LCOMPO = NCOMPO
    IF (LCOMPO > 7)  LCOMPO = 7
    LPAIR  = LCOMPO*(LCOMPO+1)/2
    FMT1 = '( 3H I ,9X,    3(5X,A2,1H-,A2),90X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,   3F10.3,    90X,1HI )'
    IF (NCOMPO == 3) THEN
      FMT1 = '( 3H I ,9X,    6(5X,A2,1H-,A2),60X,1HI )'
      FMT2 = '( 3H I ,4X,A4,1X,   6F10.3,    60X,1HI )'
    ELSE IF (NCOMPO == 4) THEN
      FMT1 = '( 3H I ,9X,  10(5X,A2,1H-,A2), 20X,1HI )'
      FMT2 = '( 3H I ,4X,A4,1X,  10F10.3,    20X,1HI )'
    ELSE IF (NCOMPO == 5) THEN
      FMT1 = '( 3H I ,7X,   15(3X,A2,1H-,A2), 2X,1HI )'
      FMT2 = '( 3H I ,2X,A4,1X,   15F8.2,     2X,1HI )'
    ELSE IF (NCOMPO == 6) THEN
      FMT1 = '( 3H I ,3X,   21(1X,A2,1H-,A2),    1HI )'
      FMT2 = '( 3H I ,A3,         21F6.2,        1HI )'
    ELSE IF (NCOMPO == 7) THEN
      FMT1 = '( 3H I ,5X,   28(1X,A1,1H-,A1),12X,1HI )'
      FMT2 = '( 3H I ,1X,A4,1X,  28F4.1,     12X,1HI )'
    END IF
    WRITE (16, 6661)
 6661        FORMAT ('I  ', 60(' '), 'I--', 63('-'), '--I' )
    WRITE (16,FMT1)  ((ATOM(I),ATOM(J),J=1,I),I=1,LCOMPO)
    WRITE (16,FMT2)  'Dij ', (DMIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'BEij', (BEIJ(J),J=1,LPAIR)
    WRITE (16,FMT2)  'RSij', (RSIJ(J),J=1,LPAIR)
    if (RUNOPT(8) == 'BELONO    ')  then
      write (16,fmt2)  'EPij', (EPSij(J),J=1,LPAIR)
      write (16,fmt2)  'SEij', (SEPij(J),J=1,LPAIR)
    end if
    if (N3BP > 0)  THEN
      WRITE (16,6666)
 6666           FORMAT ('I  ',60(' '),'   ', 63(' '),'  I' / &
                        'I',5X,'3-body potential   ATOM(J)--ATOM(I)', &
                        '--ATOM(J)      FK3BP       ANG3BP           ', &
                        '  R3BLIM ', &
                        '   R3BGRD      R3LIM  ',15X, 'I')
      DO N = 1, N3BP
        IF (I3BP(2,N)*i3BP(1,N) > 0) THEN
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-6)/R3BGRD(1,N) + R3BLIM(1,N)
        IF (runopt(34) == 'WATER-POL ') then
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,N) + R3BLIM(1,N)
        endif
          r3lim(2,n) = r3lim(1,n)
          if (r3limax < r3lim(1,n))  r3limax=r3lim(1,n)
          WRITE (16,6667)  ATOM(i3BP(1,N)), i3BP(1,N),  &
                                        ATOM(I3BP(2,N)), I3BP(2,N),  &
                                        ATOM(i3BP(3,N)), i3BP(3,N),  &
                               FK3BP(N),ANG3BP(N),  &
                               R3BLIM(1,N), R3BGRD(1,N), R3LIM(1,n)
 6667                  FORMAT ('I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
                                I2,')--',A2,'(',I2,')', F15.8, F11.3,  &
                                2F10.3, F12.4,16X, 'I')
          if (i3BP(1,N) /= i3BP(3,N)) then
            R3LIM(2,n) = DLOG(0.999999D0/1.0D-6) / R3BGRD(2,N) + R3BLIM(2,N)
        IF (runopt(34) == 'WATER-POL ') then
            R3LIM(2,n) = DLOG(0.999999D0/1.0D-8) / R3BGRD(2,N) + R3BLIM(2,N)
        endif
            if (r3limax < r3lim(2,n)) r3limax=r3lim(2,n)
            WRITE (16,6668)  i3bp(2,n),i3bp(3,n),R3BLIM(2,N),R3BGRD(2,N), R3LIM(2,n)
 6668       FORMAT ('I',73X, i6,'-',i2, 2F10.3, F12.4,16X, 'I')
          end if
        END IF
      enddo
    END IF
  END IF
!
  DO I = 10, NRCUT(2)
    RIJ  = dble(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      E1M     = 0.0
      F1M     = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5)  GO TO 220
      EX = 0.0
      IF (BIJ(J) > 0.00001)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43)*1.6022E-12
      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!    *                              - CIJ(J)*ARIJ**6 )
!    *                      + EALPHA
      F1(I,J) = BETA * EX*EPSIJ(J)
!    *                               - 6.0*CIJ(J)*ARIJ**7)
!    *                      + 4.0*EALPHA*ARIJ + EALPHA/4.43
220   IF (DMIJ(J) < 0.01)  GO TO 230
      IF (RUNOPT(8) == 'MORSE     '.OR.  &
          RUNOPT(8) == 'MORSE-PL  '.OR.  &
          RUNOPT(8) == 'BELONO    ' )  THEN
        AM1 = EXP(-2.0*BEIJ(J)*(RIJ-RSIJ(J)))
        AM2 = EXP(-1.0*BEIJ(J)*(RIJ-RSIJ(J)))
        E1M= BETA*DMIJ(J) *(AM1 - 2.0*AM2) * SEPij(J)
        F1M= BETA*BEIJ(J) *DMIJ(J) * (2.0*AM1 - 2.0*AM2) * SEPij(J)
      END IF
      IF (RUNOPT(8) == 'MORSE-AT  ')  THEN
        AM2 = DMIJ(J)*EXP(-BEIJ(J)*RIJ)
        E1M = - BETA * AM2
        F1M = - BETA * BEIJ(J) * AM2
      END IF
      IF (RSWTCH(J) < 1.0E-6)  THEN
        E1(I,J) = E1(I,J) + E1M
        F1(I,J) = F1(I,J) + F1M
      ELSE IF (RIJ <= RSWTCH(J)) THEN
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
230   F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
  RETURN
END
!
!
!                                                                =======
!================================================================ BMHEXP
      SUBROUTINE  BMHEXP(IPOL)   !WATER-POL: IPOL
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use pmorse
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                BORN-MAYER-HUGGINS type plus Expornential type function
!                                               plus gauss type function
!                                                        plus three body
!
!
  double precision    EALPHA, BETA, RIJ,ARIJ, E1M,F1M, AM1,AM2
  double precision    E1M12,E1M3, F1M12, F1M3
  double precision    EX, ARB, epsij(lef), sepij(lef)
  double precision    am3
  double precision, save ::    dm3ij(lef), be3ij(lef), r03ij(lef),RSWTCHCO(lef)  !WATER-POL
  double precision    ELC2,D1,BE1,D2,BE2,RSIJP,GGG,r3blim2,r3bgrd2
  integer*4    ipara(2,10), npara
  integer*4    I,N,II,J,IP,JP,KP,ijkl,IJ,IPOL,k
  integer*4 ::IP1=0,JP1=0,KP1=0,IP2=0,JP2=0,KP2=0
  double precision    apara(9,10)
  character*1 insIP1,insJP1,insKP1,insIP2,insJP2,insKP2
!
  ELC2 = ELC * ELC
  BETA = CAL * 1.0D10 / ANA
!
  if (IPOL == 1) goto 250   !WATER-POL
  N3BP = 0
  DO I = 1, l3p
    I3BP(1,I) = 0
    i3BP(2,I) = 0
    i3bp(3,i) = 0
  enddo
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) *BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0 * ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J)  * ELC2 * 1.0D8
      ZIJ(N)  = ZIO(I)*ZIO(J)
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      DM3IJ(N) = 0.0D0
      BE3IJ(N) = 0.0D0
      r03ij(n) = 0.0D0
      RSWTCH(N) = 0.0D0
      RSWTCHCO(N) = 0.0D0
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
    enddo
  enddo
!
  npara = 0
120  READ   (15,'(6(A1),i2, 2X,6F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
!     WRITE  (*,'(3(1X,A1),i2, 2X,6F10.0)')  insIP,insJP,insKP, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
!     WRITE  (*,'(6(A1),i2, 2X,6F10.0)')  insIP1,insIP2,insJP1,insJP2,insKP1,insKP2, ijkl, D1, BE1, D2, BE2, RSIJP, GGG
     IP = 0
     JP = 0
     KP = 0
     IP1 = 0
     IP2 = 0
     JP1 = 0
     JP2 = 0
     KP1 = 0
     KP2 = 0
     do k=1,LEL
        if (insIP1 == ins(k)) IP1=k
        if (insJP1 == ins(k)) JP1=k
        if (insKP1 == ins(k)) KP1=k
        if (insIP2 == ins(k)) IP2=k
        if (insJP2 == ins(k)) JP2=k
        if (insKP2 == ins(k)) KP2=k
     enddo
!      write(*,*)IP1,IP2,JP1,JP2,KP1,KP2
     if (IP1 > 0) IP = IP1 
     if (JP1 > 0) JP = JP1 
     if (KP1 > 0) KP = KP1 
     if (IP2 > 0) IP = IP2 
     if (JP2 > 0) JP = JP2
     if (KP2 > 0) KP = KP2 
!      write(*,*)IP,JP,KP
! 5555        FORMAT (3I2,i2, 2X,6F10.0)
! 5556        format (10x, 3f10.0)
!  IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
!  IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
!  IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
  IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP
      if (ijkl == 1)  then
        AIJ(N)  = 0.0D0
        BIJ(N)  = 0.0D0
        CIJ(N)  = 0.0D0
        DIJ(N)  = 0.0D0
        D4IJ(N) = 0.0D0
        D7IJ(N) = 0.0D0
      end if
      DM1IJ(N) = D1
      BE1IJ(N) = BE1
      DM2IJ(N) = D2
      BE2IJ(N) = BE2
      RSWTCH(N) = RSIJP
      if (ggg > 0.0)  then
        read (15,'(10x, 4f10.0)') dm3ij(n),be3ij(n),r03ij(n), RSWTCHCO(n)
      end if
      npara = npara + 1
      ipara(1,npara) = ip
      ipara(2,npara) = jp
      apara(1,npara) = d1
      apara(2,npara) = be1
      apara(3,npara) = d2
      apara(4,npara) = be2
      apara(5,npara) = dm3ij(n)
      apara(6,npara) = be3ij(n)
      apara(7,npara) = r03ij(n)
      apara(8,npara) = rsijp
      apara(9,npara) = RSWTCHCO(n)
    ELSE IF (IP == KP) THEN
      N3BP = N3BP +1
      I3BP(1,N3BP) = iP
      i3BP(2,N3BP) = jP
      i3BP(3,N3BP) = KP
!     -------------------------------------- F:kJ/mol
      FK3BP(N3BP)  = D1
      ANG3BP(N3BP) = BE1
      R3BLIM(1,N3BP) = D2
      R3BGRD(1,N3BP) = BE2
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 1.2D0
      IF (R3BGRD(1,N3BP) <= 0.01D0) R3BGRD(1,N3BP)=20.0D0
      R3BLIM(2,N3BP) = R3BLIM(1,N3BP)
      R3BGRD(2,N3BP) = R3BGRD(1,N3BP)
    ELSE IF (IP /= KP) THEN
      N3BP = N3BP +1
      I3BP(1,N3BP) = iP
      i3BP(2,N3BP) = jP
      i3BP(3,N3BP) = KP
!     -------------------------------------- F:kJ/mol
      FK3BP(N3BP)    = D1
      ANG3BP(N3BP)   = BE1
      R3BLIM(1,N3BP) = D2
      R3BGRD(1,N3BP) = BE2
      IF (ANG3BP(N3BP) <= 0.01D0)   ANG3BP(N3BP)  =90.0D0
      IF (R3BLIM(1,N3BP) <= 0.01D0) R3BLIM(1,N3BP)= 1.2D0
      IF (R3BGRD(1,N3BP) <= 0.01D0) R3BGRD(1,N3BP)=20.0D0
      READ (15,'(30X,2F10.0)')  R3BLIM2, R3BGRD2
! 5566                    FORMAT (30X,2F10.0)
      IF (R3BLIM2 <= 0.01D0) R3BLIM2 = R3BLIM(1,N3BP)
      IF (R3BGRD2 <= 0.01D0) R3BGRD2 = R3BGRD(1,N3BP)
      R3BLIM(2,N3BP) = R3BLIM2
      R3BGRD(2,N3BP) = R3BGRD2
    ELSE
      STOP 'Something wrong in potetial param.'
    END IF
    GO TO 120
  END IF
!
  write (16,6661)
  if (npara > 0) then
    do  i = 1, npara
      WRITE (16, 6663)  ATOM(Ipara(1,i)),ipara(1,i), &
                        ATOM(ipara(2,i)),ipara(2,i), (apara(j,i),j=1,8)
    enddo
  end if
!
250 continue  
  if (N3BP > 0)  THEN
    if (ipol == 1) write(16,'("!!!3-body potential was reloaded for water-pol!!!")')
    WRITE (16,6666)
    DO N = 1, N3BP
      IF (I3BP(2,N)*i3BP(1,N) > 0) THEN
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-6)/R3BGRD(1,N) + R3BLIM(1,N)  
          IF (runopt(34) == 'WATER-POL ') then
          R3LIM(1,n) = DLOG(0.999999D0/1.0D-8)/R3BGRD(1,N) + R3BLIM(1,N)  !WATER-POL
        endif
!        if (ipol == 1) STOP
        if (runopt(8) == 'BMH-EXP*  ') then
          R3LIM(1,n) = DLOG(0.9999D0/0.0001D0) / R3BGRD(1,N) + R3BLIM(1,N)
        end if
        r3lim(2,n) = r3lim(1,n)
        if (r3limax < r3lim(1,n))  r3limax=r3lim(1,n)
        WRITE (16,6667)  ATOM(i3BP(1,N)), i3BP(1,N),  &
                         ATOM(I3BP(2,N)), I3BP(2,N),  &
                         ATOM(i3BP(3,N)), i3BP(3,N),  &
                         FK3BP(N),ANG3BP(N),  &
                         R3BLIM(1,N), R3BGRD(1,N), R3LIM(1,n)
        if (i3BP(1,N) /= i3BP(3,N)) then
          R3LIM(2,n) = DLOG(0.999999D0/1.0D-6) /  R3BGRD(2,N) + R3BLIM(2,N)
         IF (runopt(34) == 'WATER-POL ') then      
          R3LIM(2,n) = DLOG(0.999999D0/1.0D-8) /  R3BGRD(2,N) + R3BLIM(2,N)
         endif
          if (runopt(8) == 'BMH-EXP*  ') then
            R3LIM(2,n) = DLOG(0.9999D0/1.0D-8) /  R3BGRD(2,N) + R3BLIM(2,N)
          end if
          if (r3limax < r3lim(2,n)) r3limax=r3lim(2,n)
          WRITE (16,6668)  i3bp(2,n),i3bp(3,n),R3BLIM(2,N),R3BGRD(2,N), R3LIM(2,n)
        end if
      END IF
    enddo
  END IF
!
!250 CONTINUE   !WATER-POL
  IF (IPOL == 1) then
    N = (NCOMPO) * (NCOMPO+1) / 2
    NPAIR = (NCOMPO+1) * (NCOMPO+2) / 2
!   N(I,J)
!   1(1,1) 2(2,1) 3(2,2) 4(3,1) 5(3,2) 6(3,3) ....
! 
    II = NCOMPO+1
    DO J = 1, NCOMPO+1
      N = N + 1
      AIJ(N)  = ABS(AIO(II) + AIO(J))
      BIJ(N)  = ABS(BIO(II) + BIO(J))
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = 0.0D0
      D4IJ(N) = (DIO(II)*ZIO(J)**2 + DIO(J)*ZIO(II)**2 ) / 2.0D0* ELC2 * 1.0D8
      D7IJ(N) = 2.0D0 * ZIO(II)*ZIO(J) * DIO(II)*DIO(J)* ELC2 * 1.0D8
      ZIJ(N)  = ZIO(II)*ZIO(J) !Correct bug ZIO(I) -> ZIO(II) This is though not used in WATER-POL actually.
      epsij(n)  = 1.0D0
      sepij(n)  = 1.0D0
      DM1IJ(N) = 0.0D0
      BE1IJ(N) = 0.0D0
      DM2IJ(N) = 0.0D0
      BE2IJ(N) = 0.0D0
      DM3IJ(N) = 0.0D0
      BE3IJ(N) = 0.0D0
      r03ij(n) = 0.0D0
      RSWTCH(N) = 0.0D0
      RSWTCHCO(N) = 0.0D0
    enddo
  ENDIF
!
!
  DO I = 1, NRCUT(2)
    RIJ  = DBLE(I) * 0.01D0
    ARIJ = 1.0D0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0D0
      F1(I,J) = 0.0D0
      E1M     = 0.0D0
      F1M     = 0.0D0
      IF (ABS(AIJ(J)) < 1.0D-5)  GO TO 220
      EX = 0.0D0
      IF (BIJ(J) > 1.0D-5)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0D0)  EX = EXP(ARB)
      END IF
      EALPHA  = DIJ(J)*ARIJ**4*EXP(-RIJ/4.43D0)*1.6022D-12
      E1(I,J) = BETA * BIJ(J)*EX*EPSIJ(J)
!    *                      - CIJ(J)*ARIJ**6
!    *                      - D4IJ(J)*ARIJ**4 - D7IJ(J)*ARIJ**7
      F1(I,J) = BETA * EX*EPSIJ(J)
!    *                      - 6.0*CIJ(J)*ARIJ**7
!    *                      - 4.0*D4IJ(J)*ARIJ**5 - 7.0*D7IJ(J)*ARIJ**8
!    *                      - 4.0*D4IJ(J)*ARIJ**5 - D4IJ(J)*ARIJ**4/4.43
!
220   CONTINUE
      AM1 = DM1IJ(J)*EXP(-BE1IJ(J)*RIJ)
      AM2 = DM2IJ(J)*EXP(-BE2IJ(J)*RIJ)
      am3 = dm3ij(j)*exp(-be3ij(j)*(rij-r03ij(j))**2)
      E1M =  BETA * (AM1 + AM2 + am3)
      F1M =  BETA * (BE1IJ(J)*AM1 + BE2IJ(J)*AM2 +2.0d0*be3ij(j)*(rij-r03ij(j))*am3)
      E1M12 = BETA * (AM1 + AM2)
      E1M3  = BETA * AM3
      F1M12 = BETA * (BE1IJ(J)*AM1 + BE2IJ(J)*AM2)
      F1M3  = BETA * 2.0d0*be3ij(j)*(rij-r03ij(j))*am3
      IF (RSWTCH(J) < 1.0D-6)  THEN
        E1(I,J) = E1(I,J) + E1M
        F1(I,J) = F1(I,J) + F1M
      ELSE IF (RIJ <= RSWTCH(J)) THEN
        E1(I,J) = E1M
        F1(I,J) = F1M
      END IF
      IF (IPOL == 1) then
        IF (RIJ > RSWTCHCO(J)) THEN
          E1(I,J) = E1(I,J) - E1M12
          F1(I,J) = F1(I,J) - F1M12
        END IF
      ENDIF
230   F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
6661        format ('I  ', 60(' '), 'I--', 63('-'), '--I' /  &
                     'I  ',24x,'DM1ij      BE1ij      DM2ij    ',  &
                           ' BE2ij      DM3ij     BE3ij     R03ij    ', &
                           ' Rswch',26x, 'I')
6663             format ('I   ',A2,'(',i2,') -- ',A2,'(',i2,')  ',  &
                            3(F11.2, F10.3),F10.3,F10.3, 26X,'I')
6666           FORMAT ('I  ',60(' '),'   ', 63(' '),'  I' /  &
                       'I',5X,'3-body potential   ATOM(J)--ATOM(I)',  &
                       '--ATOM(J)      FK3BP      ANG3BP     R3BLIM ',  &
                       '   R3BGRD      R3LIM   ',23X, 'I')
6667                  FORMAT ('I',22X, 3X,A2,'(',I2,')--', A2,'(',  &
                               I2,')--',A2,'(',I2,')', F15.8, F11.3,  &
                               2F10.3, F12.4,16X, 'I')
6668                       FORMAT ('I',73X, i6,'-',i2,2F10.3, F12.4,16X, 'I')
  RETURN
END
!
!
!                                                               ========
!================================================================ BUSING
      SUBROUTINE  BUSING
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
!
  implicit none
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!
!
  double precision  BETA,EX,RIJ,ARIJ,ARB
  integer*4 J,II,I,N
!
  BETA = CAL * 1.0D10 / ANA
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N) = ABS(AIO(II) + AIO(J))
      BIJ(N) = ABS(BIO(II) + BIO(J))
      CIJ(N) = CIO(II) * CIO(J) * BETA
      DIJ(N) = DIO(II) * DIO(J) * BETA
      ZIJ(N)  = ZIO(I)*ZIO(J)
      D4IJ(N) = 0.0
      D7IJ(N) = 0.0
      IF (RUNOPT(8) == 'STSUNE    ')  THEN
        IF (I == J .AND. ATOM(I) == 'SI  ')  CIJ(N) = 0.0
      END IF
    enddo
  enddo
!
  DO I = 10, NRCUT(2)
    RIJ  = dble(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, LEE
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5)  cycle
      EX = 0.0
      IF (BIJ(J) > 0.0001)  THEN
        ARB = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      E1(I,J) = BETA * BIJ(J)*EX
!    *                       - CIJ(J)*ARIJ**6)
      F1(I,J) = BETA * EX * 1.0D8 * ARIJ
!                 F1(I,J) = BETA * (EX - 6.0*CIJ(J)*ARIJ**7) *
!    *                                1.0D8 * ARIJ
    enddo
  enddo
!
  RETURN
END
!
!
!                                                                =======
!================================================================= PAIRP
SUBROUTINE  PAIRP
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use pmorse
!
  implicit none
!
!     ----------------------- IDA-GILBERT-BUSING type potential function
!                                                BORN-MAYER-HUGGINS type
!
!
  double precision    BETA, RIJ,ARIJ 
  double precision    EX, ARB,R3BG,RSIJP,BEIJP,DIJP
  CHARACTER *40   FMT1, FMT2
  integer*4 LPAIR,LCOMPO,IJ,KP,JP,IP,J,II,I,N
!
!     beta = 1.0d0 / 6.2415064d11        ! eV -> erg
  beta = 1.0d7 * 1000.0 / ANA        ! kJ/mol -> erg
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = 0.0
      BIJ(N)  = 0.0
      CIJ(N)  = 0.0
      DIJ(N)  = 0.0
      ZIJ(N)  = ZIO(I)*ZIO(J)
      DMIJ(N) = 0.0
      BEIJ(N) = 0.0
    enddo
  enddo
!
120        READ   (15,5555)  IP,JP, KP, DIJP, BEIJP, RSIJP, R3BG
5555        FORMAT (3I2,4X,5F10.0)
  IF (IP /= 0.AND.MOD(IP,10) == 0)  IP = IP / 10
  IF (JP /= 0.AND.MOD(JP,10) == 0)  JP = JP / 10
  IF (KP /= 0.AND.MOD(KP,10) == 0)  KP = KP / 10
  IF (IP >= 1.AND.IP <= NCOMPO .AND. JP >= 1.AND.JP <= NCOMPO )  THEN
    IF (KP == 0)  THEN
      IF (JP > IP)  THEN
        IJ = IP
        IP = JP
        JP = IJ
      END IF
      N = (IP - 1) * IP / 2 + JP
      AIJ(N) = DIJP
      BIJ(N) = BEIJP
      CIJ(N) = RSIJP * BETA
      if (IP == JP)  then
        CIO(IP) = SQRT(CIJ(N))
      end if
    end if
    GO TO 120
  END IF
  LCOMPO = NCOMPO
  IF (LCOMPO > 7)  LCOMPO = 7
  LPAIR  = LCOMPO*(LCOMPO+1)/2
  FMT1 = '( 3H I ,9X,    3(5X,A2,1H-,A2),90X,1HI )'
  FMT2 = '( 3H I ,4X,A4,1X,   3F10.2,    90X,1HI )'
  IF (NCOMPO == 3) THEN
    FMT1 = '( 3H I ,9X,    6(5X,A2,1H-,A2),60X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,   6F10.2,    60X,1HI )'
  ELSE IF (NCOMPO == 4) THEN
    FMT1 = '( 3H I ,9X,  10(5X,A2,1H-,A2), 20X,1HI )'
    FMT2 = '( 3H I ,4X,A4,1X,  10F10.2,    20X,1HI )'
  ELSE IF (NCOMPO == 5) THEN
    FMT1 = '( 3H I ,7X,   15(3X,A2,1H-,A2), 2X,1HI )'
    FMT2 = '( 3H I ,2X,A4,1X,   15F8.1,     2X,1HI )'
  ELSE IF (NCOMPO == 6) THEN
    FMT1 = '( 3H I ,3X,   21(1X,A2,1H-,A2),    1HI )'
    FMT2 = '( 3H I ,A3,         21F6.0,        1HI )'
  ELSE IF (NCOMPO == 7) THEN
    FMT1 = '( 3H I ,5X,   28(1X,A1,1H-,A1),12X,1HI )'
    FMT2 = '( 3H I ,1X,A4,1X,  28F4.1,     12X,1HI )'
  END IF
  WRITE (16, 6661)
6661        FORMAT ('I  ', 60(' '), 'I--', 63('-'), '--I' )
  WRITE (16,FMT1)  ((ATOM(I),ATOM(J),J=1,I),I=1,LCOMPO)
  WRITE (16,FMT2)  'Aij ', (AIJ(J),J=1,LPAIR)
  WRITE (16,FMT2)  'Bij ', (BIJ(J),J=1,LPAIR)
  WRITE (16,FMT2)  'Cij ', (CIJ(J),J=1,LPAIR)
!
  DO I = 10, NRCUT(2)
    RIJ  = dble(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      IF (ABS(AIJ(J)) < 1.0E-5)  cycle
      EX = 0.0
      IF (BIJ(J) > 0.00001)  THEN
        ARB =  - RIJ / BIJ(J)
        IF (ARB > -128.0)  EX = EXP(ARB)
      END IF
      E1(I,J) = BETA * AIJ(J)*EX
!    *                         - BETA * CIJ(J)*ARIJ**6
      F1(I,J) = BETA * AIJ(J) *EX / BIJ(J)
!    *                         - BETA * 6.0*CIJ(J)*ARIJ**7
      F1(I,J) = F1(I,J)*1.0D8 * ARIJ
    enddo
  enddo
  RETURN
END
!
!
!                                                               ========
!================================================================ TOSIFU
SUBROUTINE  TOSIFU
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
!
  implicit none
  integer*4 J, II, I, N
  double precision ARB,EXPA, RIJ, DENJ, DENI
!
!     -------------------- TOSI & FUMI (BORN-MAYER) type rigid ion model
!                                             (including Pauling factor)
!
  double precision         BETA, ARIJ
!
  BETA = 1.0D-19 * 1.0D7
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  N = 0
  DO I = 1, NCOMPO
    II = I
    DO J = 1, II
      N = N + 1
      AIJ(N)  = AIO(II) + AIO(J)
      BIJ(N)  = BIO(II) + BIO(J)
      CIJ(N)  = CIO(II) * CIO(J) * BETA
      DIJ(N)  = DIO(II) * DIO(J) * BETA
      ZIJ(N)  = ZIO(I)*ZIO(J)
      PLIJ(N) = 1.0
!     ------------------------------------------- Pauling factor
      DENI = 8.0
      IF (WIO(I) <= 11.5)  DENI = 2.0
      DENJ = 8.0
      IF (WIO(J) <= 11.5)  DENJ = 2.0
      PLIJ(N) = 1.0 + ZIO(I)/DENI + ZIO(J)/DENJ
    enddo
  enddo
!
!     RHO  = 0.29
  DO I = 10, NRCUT(2)
    RIJ  = dble(I) * 0.01
    ARIJ = 1.0D0 / RIJ
    DO J = 1, NPAIR
      IF (ABS(AIJ(J)) > 1.0E-5) THEN
        EXPA = 0.0
        ARB  = (AIJ(J) - RIJ) / BIJ(J)
        IF (ARB > -128.0) EXPA = PLIJ(J) * 0.338 * EXP(ARB)
        E1(I,J) = EXPA * BETA
!    *                       - CIJ(J)*ARIJ**6 - DIJ(J)*ARIJ**8)*BETA
        F1(I,J) = EXPA/BIJ(J)*BETA * 1.0D8 * ARIJ
!                  F1(I,J) = (EXPA/BIJ(J) - 6.0*CIJ(J)*ARIJ**7
!    *                                    - 8.0*DIJ(J)*ARIJ**9)
!    *                                         * BETA * 1.0D8 * ARIJ
      END IF
    enddo
  enddo
  RETURN
END
!
!
!                                                                =======
!================================================================= ANGEL
      SUBROUTINE  ANGELP
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
!
  implicit none
!
  double precision ARB,EX,ARIJ,RIJ,RHO,DENJ,DENI
  integer*4 J, II,I,N
!     -------------------------- BORN-MAYER-HUGGINS type rigid ion model
!               WOODCOK, ANGELL type potential function (Pauling factor)
!
!
   N = 0
   DO I = 1, NCOMPO
     II = I
     DO J = 1, II
       N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
       AIJ(N)  = ABS(AIO(II) + AIO(J))
       BIJ(N)  = (BIO(II) +BIO(J)) * 1.0E-13
       CIJ(N)  = CIO(II) * CIO(J) * 1.0E-13
       ZIJ(N)  = ZIO(I)*ZIO(J)
       PLIJ(N) = 1.0
       IF (RUNOPT(8) == 'PAULING  ')  THEN
         DENI = 8.0
         IF (WIO(I) <= 11.5)  DENI = 2.0
         DENJ = 8.0
         IF (WIO(J) <= 11.5)  DENJ = 2.0
         PLIJ(N) = 1.0 + ZIO(I)/DENI + ZIO(J)/DENJ
       END IF
     enddo
   enddo
!
!     BETA = CAL * 1.0E10 / ANA
   RHO   = 0.29
   DO I = 10, NRCUT(2)
     RIJ  = dble(I) * 0.01
     ARIJ = 1.0 / RIJ
     DO J = 1, LEE
       IF (ABS(AIJ(J)) > 1.0E-5) THEN
         EX = 0.0
         ARB = (AIJ(J) - RIJ) / RHO
         IF (ARB > -128.0)  EX = PLIJ(J) * BIJ(J) * EXP(ARB)
         E1(I,J) = EX
!    *                        - CIJ(J)*ARIJ**6
         F1(I,J) =  EX/RHO * 1.0D8 * ARIJ
!                   F1(I,J) = (EX/RHO - 6.*CIJ(J)*ARIJ**7)*1.0D8 * ARIJ
       END IF
     enddo
   enddo
   RETURN
END
!
!
!                                                            ===========
!============================================================= L-J MODEL
SUBROUTINE  LJMODL
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
!
  implicit none
!
  double precision EX2,EX,ARIJ,RIJ
  integer*4 J, II, I, N
!     ------------------------------- Lennard-Jones type potential model
!                           uij(rij) = eij[(sij/rij)**12 - (sij/rij)**6]
!                                 Lorentz-Berthelot type pair parameters
!                                   sij=(si+sj)/2  :  eij=(eixej)**(1/2)
!
!
  N = 0
  DO I = 1, NCOMPO
    AIO(I) = SQRT(AIO(I)*1.0E-16)
    BIO(I) = BIO(I) / 2
    II = I
    DO J = 1, II
      N = (II-1)*LEL +J -(2*LEL-II)*(II-1)/2
      AIJ(N)  = AIO(II) * AIO(J) * 4.0
      BIJ(N)  = BIO(II) + BIO(J)
      CIJ(N)  = AIJ(N) * BIJ(N)**6
      DIJ(N)  = 0.0
      ZIJ(N)  = ZIO(I)*ZIO(J)
      if (IION(i) < 0 .and. iion(j) < 0) then
        aij(n) = 0.0
        bij(n) = 0.0
        cij(n) = 0.0
      end if
    enddo
  enddo
!
  DO I = 10, NRCUT(2)
    RIJ  = dble(I) * 0.01
    ARIJ = 1.0 / RIJ
    DO J = 1, LEE
      EX = (BIJ(J) * ARIJ)**6
      EX2 = EX * EX
      E1(I,J) = AIJ(J)* (EX2)
!             E1(I,J) = AIJ(J)* (EX2 - EX)
      F1(I,J) = AIJ(J)* (12.0*EX2) *ARIJ *ARIJ *1.0E8
!             F1(I,J) = AIJ(J)* (12.0*EX2 - 6.0*EX) *ARIJ *ARIJ *1.0E8
    enddo
  enddo
  RETURN
END
!
!
!                                                                =======
!================================================================ METALP
      SUBROUTINE  METALP  (IPR)
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use paramt
  use tables
  use counts
  use vector
!
  implicit none
!
  INTEGER*4        INP(51),JNP,IPR,ANP,NP,J,I,ICUT
  double precision EE,EE0,VRN,F,RI,AKF2,DRVN2,FF2,FF1,EFG,PHI,ARN,R,ANM
!
  ANM = 3.0
  IF (ABS(MODE) >= 3 .AND. ABS(MODE) <= 9)  ANM = MODE
!
  IF (ALPHA > 0.9 .OR. ALPHA < 14.9)  THEN
    ICUT    = ALPHA
    RCUT(2) = (LSR-1.0)/100.0
  ELSE
    ICUT = 0
    IF (RCUT(2) < 0.01 .OR. RCUT(2) > (LSR-1.0)/100.0) THEN
      RCUT(2)  = (LSR-1.0)/100.0
    END IF
  END IF
  NRCUT(2) = INT(RCUT(2) * 100.0 + 1.01)
  RCUT(1)  = RCUT(2)
!
! *** LRO-II
!
  NPAIR = NCOMPO * (NCOMPO+1) / 2
  DO I = 1, NCOMPO
    AKFI(I) = 0.0
  enddo
!     ------------------------------------------------ Fermi wave number
  AKFI(1) = (3.0 * PI**2 * NION(1) / VOL)**(1.0/3.0)
!
!     U = KB * [ (A/r)**n * cos(2*kf*r - B)  +  exp(C - D*r) ]
!
  DO I = 50, LSR
    E0(I) = 0.0
    F0(I) = 0.0
    R = dble(I) * 0.01
    DO J = 1, NPAIR
      E1(I,J) = 0.0
      F1(I,J) = 0.0
      IF (ABS(AIO(J)) > 1.0E-10)  THEN
        ARN = (AIO(J) / R)**ANM
        PHI = 2.0 * AKFI(J) * R - BIO(J)
        EFG = EXP(CIO(J) - DIO(J) * R)
!
!                    E0(I,J) = AKB * ARN * COS(PHI)
        E1(I,J) = AKB * ARN * COS(PHI) + AKB * EFG
!
        FF1 = (- ANM * COS(PHI) / R - 2.0 * AKFI(J) * SIN(PHI)) * ARN
        FF2 =  - DIO(J) * EFG
        F1(I,J) = - (FF1 + FF2) * AKB * 1.0E8 / R
      END IF
    enddo
  enddo
!     ------------------------------ CORRECTION FOR TERMINATION AT RCUT
  ECORR = 0.0
  VCORR = 0.0
  IF (ICUT == 0) THEN
    DRVN2 = NION(1) / VOL * 4.0 * PI * 0.02
    AKF2  = 2.0 * AKFI(1)
    DO RI = RCUT(2), 1999.0, 0.02
      R  = RI + 0.01
      F  = (1999.0 - R) / (1999.0 - RCUT(2))
      IF (ANM > 3.1)  F = 1.0
      VRN = R**2 * DRVN2
      ARN = (AIO(1) / R)**ANM
      PHI   = AKF2*R - BIO(1)
      ECORR = ECORR + COS(PHI) * ARN * VRN
!
      VCORR = VCORR -  &
             (- ANM*COS(PHI)/R  &
              - AKF2*SIN(PHI)*F ) * R * ARN * VRN
    enddo
    ECORR = ECORR * NION(1) * AKB * FJMOL / 2.0
    VCORR = VCORR * NION(1) / 2.0 * AKB * 1.0D-10 / (VOL*1.0D-24) / 3.0
  ELSE
    DO J = 1, NCOMPO
      IF (ABS(AIO(J)) > 1.0E-10)  THEN
        NP = 0
        EE0 = E1(200,J)
        DO I = 201, NRCUT(2)
          EE = E1(I,J)
          IF (EE0*EE <= 0.0) THEN
            NP = NP + 1
            INP(NP) = I
            IF (NP >= 50)  GO TO 490
          END IF
          EE0 = EE
        enddo
490     IF (ICUT > NP)  ICUT = NP
        NRCUT(2) = INP(ICUT)
        RCUT(2)  = NRCUT(2) * 0.01
        NRCUT(1) = NRCUT(2)
        RCUT(1)  = RCUT(2)
        ANP   = INP(ICUT) - INP(ICUT-1) + 1
        DO I = INP(ICUT-1), INP(ICUT)
          E1(I,J) = E1(I,J) * (I-INP(ICUT-1))/ANP
          F1(I,J) = F1(I,J) * (I-INP(ICUT-1))/ANP
        enddo
        IF (IPR == 1) THEN
          DO I = 1, NP
            JNP = INP(I)
            WRITE (16,*)  I,INP(I),E1(JNP-1,J),E1(JNP,J)
          enddo
        END IF
      END IF
    enddo
  END IF
!
  IF (IPR == 1) THEN
    WRITE (*,1001) RCUT(1),AKFI(1),ECORR,VCORR
1001       FORMAT (10X,'RCUT=',F8.4,'   KF=',F6.4,'   Ecorr=',F6.3,'  Pcorr=',F6.3)
  END IF
!
!     DO 160  I = 100, NCUT, 10
!         WRITE (16,*) I,E0(I,1)+E1(I,1),F1(I,1)
! 160 CONTINUE
!     WRITE (*,*) 375,E1(375,1),F1(375,1)
  RETURN
END
!
!
!                                                                =======
!================================================================ CLEARS
SUBROUTINE  CLEARS
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use geomet
  use counts
  use vector
  use acoord
  use radial
!
  implicit none
!
!     --------------------------------- Clear variables for accumulation
!
!
  integer*4    IYEAR,IMONTH,IDAY, IHOUR,IMINUT, ISECND, I100TH
  integer*4    NN,MM,JM,IM,I
!
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH)
  NN = IRECRD(2)/IRECRD(3)
  MM = MOD(NRECRD(1)/IRECRD(3), NN)
  JM = 2
  IF (RUNOPT(3) == 'ECONOMY  ')  JM = 10
  IM = 1
  IF (RUNOPT(3) == 'ECONOMY  ')  IM = 0
  IF (NRECRD(3) == 1)  GOTO 10
  IF (NRECRD(3) == IM.OR.MOD(MM,JM) == 0)  GO TO 10
  IF (RUNOPT(3) /= 'ECONOMY  ')  GO TO 11
  IF (NRECRD(3) /= IM.AND.MOD(MM,JM) /= 0)  GO TO 12
10 WRITE (16,2450)  NJOB,TITLE,TEMP, IHOUR,IMINUT,ISECND,IYEAR,IMONTH,IDAY
11 WRITE (16,2452)  (ATOM(I),I=1,4)
!
2450 FORMAT (/'<<<<<<',I4,'-',I2,'  <<<<  ',14A4,A2,' >>>>  T=',F7.1,  &
                   '  (at ',I2,':',I2,':',I2,  &
                    '  on ',I4,'/',I2,'/',I2,') >>>>>>')
2452 FORMAT(/' Step ',4('T:',A2,1X),'Temp   P/GPa  (Pxx,  Pyy,  ',  &
                'Pzz,  Pxy,  Pxz,  Pyz)  U:Coulomb   Short  ',  &
                '3-body   Kin.    Total   Density')
!
12 IF(MOD(NRECRD(1),IRECRD(3)) == 1 .or. IRECRD(2) == 1)  then
!
     TVALL(:) = 0.0d0
     SVALL(:) = 0.0d0
!
     IF (MOD(NRECRD(1),IRECRD(2)) == 1 .or. IRECRD(2) == 1)  then
       AU(:) = 0.0d0
!
       IF (NRECRD(2) > 0.AND.RUNOPT(4) == 'ACCUM     ')  RETURN
       NRECRD(2) = 0
       NTBL = 0
       NRDF(:,:) = 0
!
       ANGL(:,:)  = 0.0d0
       ITBR(:,:) = 0
       MBR(:,:,:) = 0
       NRG(:,:) = 0
       PPC(:,:) = 0.0d0
       PPS(:,:) = 0.0d0
     endif
   endif
   RETURN
END
!
!
!                                                               ========
!================================================================ NEWTON
SUBROUTINE  NEWTON  (myrank, mpsize)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use vector
  use values
  use forces
  use radial
  use acoord
  use cartes
  use molecu
  use boxcng
  use quanco
  use outerf
  use exclus
  use charge
  use pos
  use ewal
!
  implicit none
!     ----------------------------------------- Heart of MD calculations
!
!
  double precision      pbox(6)
  double precision      ABOX1, V1I, PXI, VAVB(6),PJI,PCT(6)
  double precision      AMV2,   ABOX2, V2I, PYI, CENTRE, WGIO
  double precision      TMV2,   ABOX3, V3I, PZI, CENTRP, FV,FVI,V2
  double precision      DIPOLE(3), VC(3,LNI), fex(3)
  double precision      xx,yy,rr,xxe,yye,dipm2,x0,x1,x2,a3nkbt,valio2,aspres
  double precision      dpres,presx,presy,presz,vols,vvvv,abox,ffff,twt
  double precision      xcen,ycen,zcen
  double precision      FXP(LNI), FYP(LNI), FZP(LNI)
  double precision      rL1OX,rL1OY,rL1OZ,rL1O
  double precision      TV1,TV2
  double precision      rL2OX,rL2OY,rL2OZ,rL2O
  double precision      CO1,CO2a,CO2b,Nx,Ny,Nz
  double precision      etha(4),detha(4),H_Nose,dRx,dRy,dRz,PIJX,PIJY,PIJZ !Nose-Hoover
  double precision, save:: ER0(4)=0.0d0,ER1(5)=0.0d0,ER2(4)=0.0d0,ER3(4)=0.0d0
  double precision, save:: ER4(4)=0.0d0,ER5(4)=0.0d0  !Nose-Hoover Gear's method
  double precision ::      ER0P(4)=0.0d0,ER1P(5)=0.0d0,ER2P(4)=0.0d0,ER3P(4)=0.0d0
  double precision ::      ER4P(4)=0.0d0,ER5P(4)=0.0d0 !Nose-Hoover
  double precision,save::      R0(3,LNI),R1(3,LNI),R2(3,LNI),R3(3,LNI),R4(3,LNI),R5(3,LNI)
  double precision    R0P(3,LNI),R1P(3,LNI),R2P(3,LNI),R3P(3,LNI),R4P(3,LNI),R5P(3,LNI)
  double precision,save::      Deltr2(3,LNI),DeltEr2(5)=0.0d0,VALP(LVA)
  integer*4      IO,I,J,IA1,IA2,is1,is2,io1,io2,NNCOMPO,kk,mm,lp1,lp2
!  integer*4      myrank, mpsize, iamv,nnn
  integer*4      myrank, mpsize, nnn
  integer*4      no,nnh,jconv
!
!  iamv=0 !AdvanceSoft(July2018)
  NNCOMPO = NCOMPO   !WATER-POL
  IF (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') NNCOMPO = NCOMPO + 1
  AV3BP(:,:) = 0.0d0
!
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0)  cycle
    DO I = IONS(1,IO), IONS(2,IO)
      UI(I) = 0.0d0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      UIC(I) = 0.0D0   !WATER-POL
      DO J = 1, 3
        IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
          PJI     = -SIGN(1.0D0,P(J,I))
          P0(J,I) = P0(J,I) + PJI
          P(J,I)  = P(J,I)  + PJI
        END IF
      enddo
      PX(I)  = P(1,I)
      PY(I)  = P(2,I)
      PZ(I)  = P(3,I)
!      ZII(I) = ZIO(IO)          !WATER-POL
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
  enddo
!
  if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
  if (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN')  then
    do i = ntion+1, ntion+ndmole
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      DO J = 1, 3
        IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
          PJI     = -SIGN(1.0D0,P(J,I))
          P0(J,I) = P0(J,I) + PJI
          P(J,I)  = P(J,I)  + PJI
        END IF
      enddo
      PX(I) = P(1,I)
      PY(I) = P(2,I)
      PZ(I) = P(3,I)
!      if (PX(I) < 0.0D0 .or. PX(I) > 1.0D0) stop 'error in P'
!      if (PY(I) < 0.0D0 .or. PY(I) > 1.0D0) stop 'error in P'
!      if (PZ(I) < 0.0D0 .or. PZ(I) > 1.0D0) stop 'error in P'
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
  endif
!
  VAL(:) = 0.0D0
  NRECRD(2) = NRECRD(2) + 1
  IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
    TINT = 0.0D0
    QCEE = 0.0D0
    QCEF = 0.0D0
  END IF
!     --------------------------------- Coulomb and Short range (2-body)
!                                               and 3-body term
!
  JJJ = 1
  KRDF = 0
  maxedip = 1.0d0
  sumedip = 1.0d0
  IF (RUNOPT(34) /= 'WATER-POL ') CALL EWALDP1 (myrank, mpsize)
  IF (RUNOPT(34) == 'WATER-POL ') then
200   AV3BP(:,:) = 0.0d0
    do i = 1, ntion+ndmole
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
    VAL(:) = 0.0D0
    if(JJJ /= 1 .or. NRECRD(3) <= 4) CALL EWALDP1  (myrank, mpsize)
    CALL POLH2O
    JJJ = JJJ + 1
!    if (maxedip > THRESHD) goto 200
    if (sumedip > THRESHD) goto 200
!    IF (JJJ <= ITER) goto 200
      AV3BP(:,:) = 0.0d0
    do i = 1, ntion+ndmole
      UICP4(I) = UICP3(I)
      UICP3(I) = UICP2(I)
      UICP2(I) = UICP1(I)
      UICP1(I) = UIC(I)
      UI(I) = 0.0D0
      UIC(I) = 0.0D0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      IF (IOND(I) == 0)  ZII(I) = 0.0D0
    enddo
    VAL(:) = 0.0D0
    IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
      TINT = 0.0D0
      QCEE = 0.0D0
      QCEF = 0.0D0
    END IF
    KRDF = 1
    CALL  EWALDP1  (myrank, mpsize)
  ENDIF
!     --------------------------------------------------  Electric field
  IF (RUNOPT(20) == 'ELEC.FIELD')  CALL  ELECFD
!     ---------------------------------------------------  Gravity field
  IF (RUNOPT(21) == 'GRAV.FIELD')  CALL  GRAVFD
!     -------------------------------------------------- Convection flow
  if (RUNOPT(25) == 'CONVECTION')  then
    do i = 1, ntion
      if (px(i) < 0.05 .or. px(i) > 0.95) then
        fy(i) = fy(i) - abs(fy(i)) * fconvc
      else if (px(i) > 0.45 .and. px(i) < 0.55) then
        fy(i) = fy(i) + abs(fy(i)) * fconvc
      end if
    enddo
  end if
!     ----------------------------------------------- Exclusion of atoms
  if (runopt(27) == 'EXCLUSION ') then
    ia1 = 1
    ia2 = 2
    if (iaex == 2) then
      ia1 = 1
      ia2 = 3
    end if
    if (iaex == 1) then
      ia1 = 2
      ia2 = 3
    end if
    if (iextype == 1)  then
      do i = 1, ntion
        xx = (p(ia1,i)-0.5)*BOX(ia1)
        yy = (p(ia2,i)-0.5)*box(ia2)
        rr = sqrt(xx**2 + yy**2)
        if (rr <= rexcl) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          xxe = xx / sqrt(xx**2+yy**2)
          yye = yy / sqrt(xx**2+yy**2)
          fex(ia1) = fex(ia1) + xxe*Fexcl
          fex(ia2) = fex(ia2) + yye*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
      enddo
    else if (iextype == 2)  then
      do i = 1, ntion
        rr = (p(iaex,i)-0.5)*BOX(ia1)
        if (rr <= rexcl) then
          fex(1) = fx(i)
          fex(2) = fy(i)
          fex(3) = fz(i)
          fex(iaex) = fex(iaex) + sign(1.0,rr)*Fexcl
          fx(i) = fex(1)
          fy(i) = fex(2)
          fz(i) = fex(3)
        end if
      enddo
    else if (iextype == 3)  then
    end if
  end if
!     ----------------------------------------------------- Wall at z= 0
  if (runopt(28) == 'WALL      ')  call  WALL
!
!     -------------------------------------- Dipole moment of basic cell
!                                           (2*Pi/3L**3)* [Sum of qi*ri]
  IF (RUNOPT(14) == 'DIPOLE    ')  THEN
    DIPOLE(1) = 0.0D0
    DIPOLE(2) = 0.0D0
    DIPOLE(3) = 0.0D0
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0)  cycle
      DO I = IONS(1,IO), IONS(2,IO)
        PXI = PX(I)
        PYI = PY(I)
        PZI = PZ(I)
        IF (P0(1,I) > 0.999999)  PXI = PXI - 1.0
        IF (P0(2,I) > 0.999999)  PYI = PYI - 1.0
        IF (P0(3,I) > 0.999999)  PZI = PZI - 1.0
        DIPOLE(1) = DIPOLE(1) + ZIO(IO)*PXI*BOX(1)
        DIPOLE(2) = DIPOLE(2) + ZIO(IO)*PYI*BOX(2)
        DIPOLE(3) = DIPOLE(3) + ZIO(IO)*PZI*BOX(3)
      enddo
    enddo
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0)  cycle
      DO I = IONS(1,IO), IONS(2,IO)
        FX(I) = FX(I) - ZIO(IO) * DIPOLE(1) * 4.0D0 * PI / VOL * ELC**2 * 1.0D16
        FY(I) = FY(I) - ZIO(IO) * DIPOLE(2) * 4.0D0 * PI / VOL * ELC**2 * 1.0D16
        FZ(I) = FZ(I) - ZIO(IO) * DIPOLE(3) * 4.0D0 * PI / VOL * ELC**2 * 1.0D16
      enddo
    enddo
    DIPM2 = (DIPOLE(1)**2 + DIPOLE(2)**2 + DIPOLE(3)**2)  &
                     * 2.0D0 * PI / (3.0D0 * VOL)  * ELC**2  &
                     *1.0D8 * FJMOL
!   WRITE (*,*)  DIPM2
  END IF
!     =============================== Integration of equations of motion
  ABOX1  = 1.0D0 / BOX(1)
  ABOX2  = 1.0D0 / BOX(2)
  ABOX3  = 1.0D0 / BOX(3)
  X0 = (0.5D0-0.0D0)   *(0.5D0-1.0D0)/(((-1.0D0)-0.0D0)*((-1.0D0)-1.0D0))
  X1 = (0.5D0-(-1.0D0))*(0.5D0-1.0D0)/((0.0D0-(-1.0D0))*(0.0D0-1.0D0))
  X2 = (0.5D0-(-1.0D0))*(0.5D0-0.0D0)/((1.0D0-(-1.0D0))*(1.0D0-0.0D0))
!
  IF (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') then
!   -------------- Temperature of Oxygen
!   Energy of massless lone pairs are distributed to Oxygen
    no = 0
    do io = ions(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      ui(io) = ui(io) + ui(lp1) + ui(lp2)
    enddo
    no = 0
!   -------------------------------constrain included in interatomic forces
    DO io = ions(1,IATOMO), ions(2,IATOMO)
      no = no + 1
      IF (IOND(io) == 0)  THEN
        V(1,io) = 0.0D0
        V(2,io) = 0.0D0
        V(3,io) = 0.0D0
        cycle
      END IF
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      fx(io) = fx(io)  + (fx(lp1) + fx(lp2)) !constrain between O and Lone pairs
      fy(io) = fy(io)  + (fy(lp1) + fy(lp2)) 
      fz(io) = fz(io)  + (fz(lp1) + fz(lp2)) 
    enddo
!
    no = 0
    DO io = ions(1,IATOMO), ions(2,IATOMO)
      no = no + 1
!      ------------------------------------- constrain of angle between LP-O-H
      kk = ih2o(2,no)
      mm = ih2o(3,no)
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
!
!     ------------------------------------- vector O -> LP1
      rL1OX = LOP1X(no)
      rL1OY = LOP1Y(no)
      rL1OZ = LOP1Z(no)
      rL1O  = RD
!     ------------------------------------- vector O -> LP2
      rL2OX = -1.0d0*LOP1X(no)
      rL2OY = -1.0d0*LOP1Y(no)
      rL2OZ = -1.0d0*LOP1Z(no)
      rL2O  = RD
!
      Nx = rL1OY*FZ(lp1) - rL1OZ*FY(lp1) + rL2OY*FZ(lp2) - rL2OZ*FY(lp2)
      Ny = rL1OZ*FX(lp1) - rL1OX*FZ(lp1) + rL2OZ*FX(lp2) - rL2OX*FZ(lp2)
      Nz = rL1OX*FY(lp1) - rL1OY*FX(lp1) + rL2OX*FY(lp2) - rL2OY*FX(lp2)
!
      TV1 = (Nx*HHX(no) + Ny*HHY(no) + Nz*HHZ(no))/HHV(no)
!
      CO1 = -0.5D0*TV1/DPV(no)/RD
      FXP(kk) = CO1*rL1OX
      FYP(kk) = CO1*rL1OY
      FZP(kk) = CO1*rL1OZ
      FXP(mm) = CO1*rL1OX
      FYP(mm) = CO1*rL1OY
      FZP(mm) = CO1*rL1OZ
!
      TV2 = (Nx*DPX(no) + Ny*DPY(no) + Nz*DPZ(no))/DPV(no)
!
      CO2a = -0.5d0*TV2/A1(no)/RD
      CO2b =  0.5d0*TV2/A2(no)/RD
      FXP(kk) = FXP(kk) + CO2a*rL1OX
      FYP(kk) = FYP(kk) + CO2a*rL1OY
      FZP(kk) = FZP(kk) + CO2a*rL1OZ
      FXP(mm) = FXP(mm) + CO2b*rL1OX
      FYP(mm) = FYP(mm) + CO2b*rL1OY
      FZP(mm) = FZP(mm) + CO2b*rL1OZ
!
!
      FX(io) =  FX(io) - (FXP(kk) + FXP(mm))
      FY(io) =  FY(io) - (FYP(kk) + FYP(mm))
      FZ(io) =  FZ(io) - (FZP(kk) + FZP(mm))
      FX(kk) = FX(kk) + FXP(kk)
      FY(kk) = FY(kk) + FYP(kk)
      FZ(kk) = FZ(kk) + FZP(kk)
      FX(mm) = FX(mm) + FXP(mm)
      FY(mm) = FY(mm) + FYP(mm)
      FZ(mm) = FZ(mm) + FZP(mm)
    enddo
!
  ENDIF
!
  IF (RUNOPT(5) == 'T NOSE    ')  GO TO 400
! ------------------------------------------- Scaling and Andersen's
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0)  cycle
    IF (WIO(IO) < 0.00001D0)  cycle
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    WGIO = DBLE(DTIME)**2 / (WIO(IO)/ANA) * 1.0D8
    DO I = IS1, IS2
!T                 CALL  PTOXYZ  (I)
      IF (IOND(I) == 0)  THEN
        V(1,I) = 0.0D0
        V(2,I) = 0.0D0
        V(3,I) = 0.0D0
        cycle
      END IF
      IF (RUNOPT(6) == 'P ANDERSEN' .OR. RUNOPT(6) == 'P ANDERS-C')  THEN
!       ------------------------- Andersen's algorithm
        V1I = V(1,I) + FX(I)*WGIO - VBOX(1)*V(1,I)
        V2I = V(2,I) + FY(I)*WGIO - VBOX(2)*V(2,I)
        V3I = V(3,I) + FZ(I)*WGIO - VBOX(3)*V(3,I)
      ELSE
!       ----------------------------- Verlet algorithm
        V1I = V(1,I) + FX(I)*WGIO
        V2I = V(2,I) + FY(I)*WGIO
        V3I = V(3,I) + FZ(I)*WGIO
      END IF
      IF  (IION(IO) >= 0)  THEN
        P(1,I) = P(1,I) + V1I * ABOX1
        P(2,I) = P(2,I) + V2I * ABOX2
        P(3,I) = P(3,I) + V3I * ABOX3
!T                        Q(1,I) = Q(1,I) + V1I
!T                        Q(2,I) = Q(2,I) + V2I
!T                        Q(3,I) = Q(3,I) + V3I
      ELSE
        V1I = 0.0D0
        V2I = 0.0D0
        V3I = 0.0D0
      END IF
!     ------------------ Interpolation for present velocity
!         V1I:+(1/2)t VC(1,I):0 V(1,I):-(1/2)t VP(1,I):-(3/2)t
      IF (NRECRD(3) == 1)  THEN
        VP(1,I) = V(1,I) - FX(I)*WGIO
        VP(2,I) = V(2,I) - FY(I)*WGIO
        VP(3,I) = V(3,I) - FZ(I)*WGIO
      END IF
      VC(1,I) = VP(1,I)*X0 + V(1,I)*X1 + V1I*X2
      VC(2,I) = VP(2,I)*X0 + V(2,I)*X1 + V2I*X2
      VC(3,I) = VP(3,I)*X0 + V(3,I)*X1 + V3I*X2
      VP(1,I) = V(1,I)
      VP(2,I) = V(2,I)
      VP(3,I) = V(3,I)
      V(1,I)  = V1I
      V(2,I)  = V2I
      V(3,I)  = V3I
    enddo
  enddo
  GO TO 500
! ------------------------------------------------ Nose-Hoover Chain
400 A3NKBT = 3.0D0*dble(NTION)*AKB*TEMP
  TMV2 = 0.0D0
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001) cycle
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    AMV2 = 0.0D0
    DO I = IS1, IS2
      AMV2 = AMV2 + V(1,I)**2 + V(2,I)**2 + V(3,I)**2
    enddo
    TMV2 = TMV2 + AMV2 *1.0D-16*(WIO(IO)/ANA)/(DTIME**2) !g cm**2/sec**2
  enddo
!                                       Q=STEMP : g.cm**2, erg.s**2  
!  VSTEMP = VSTEMP + (TMV2 - A3NKBT) * (DTIME**2) / STEMP * 1.0D16 
  VSTEMP(1) = (TMV2 - A3NKBT)*DTIME**2  / STEMP(1) -ER1(1)*ER1(2)
  if (nfnose > 1) then
    do nnh = 2, nfnose
      VSTEMP(nnh) = STEMP(nnh-1)*ER1(nnh-1)**2/STEMP(nnh) - KBT*DTIME**2/STEMP(nnh) - ER1(nnh)*ER1(nnh+1)
    enddo
  endif
!  write(*,*) nfnose, STEMP,STEMP2,STEMP3,STEMP4
!  read(*,*)

!
! Under construction of predictor-corrector Gear's method
!
! ------------------ Nose-Hoover thermostat 
  if (NRECRD(3) == 1) then
    do nnh = 1, nfnose
      ER0(nnh) = 0.0d0             ! etha
      ER1(nnh) = 0.0d0             ! time derivative of etha * dt 
      ER2(nnh) = 0.5d0*VSTEMP(nnh)       ! 2nd time derivative *dt^2*0.5
      ER3(nnh) = 0.0d0 
      ER4(nnh) = 0.0d0
      ER5(nnh) = 0.0d0
    enddo
  endif
  do nnh = 1, nfnose
    ER5P(nnh) = ER5(nnh)
    ER4P(nnh) = ER4(nnh) + 5.0d0*ER5(nnh)
    ER3P(nnh) = ER3(nnh) + 4.0d0*ER4(nnh) + 10.0d0*ER5(nnh)
    ER2P(nnh) = ER2(nnh) + 3.0d0*ER3(nnh) +  6.0d0*ER4(nnh) + 10.0d0*ER5(nnh)
    ER1P(nnh) = ER1(nnh) + 2.0d0*ER2(nnh) +  3.0d0*ER3(nnh) +  4.0d0*ER4(nnh) + 5.0d0*ER5(nnh)
    ER0P(nnh) = ER0(nnh) + ER1(nnh) + ER2(nnh) + ER3(nnh) + ER4(nnh) + ER5(nnh) 
  enddo
!
  do nnh = 1, nfnose
    etha(nnh) = ER0(nnh)
    detha(nnh) = ER1(nnh)/DTIME
  enddo
!  
! ------------------Equation of motion for ions  
  IF (NRECRD(3) == 1) then
    R0(1,:) = P(1,:)*BOX(1)  !Angstrom
    R0(2,:) = P(2,:)*BOX(2)
    R0(3,:) = P(3,:)*BOX(3)
    R1(:,:) = V(:,:)  ! =velocity * dt   !Angstrom * sec
    R3(:,:) = 0.0d0   ! Initial values
    R4(:,:) = 0.0d0
    R5(:,:) = 0.0d0
    do io = 1, ncompo
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001D0) cycle
      WGIO = DTIME**2 / (WIO(IO)/ANA) * 1.0D8
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      DO I = IS1, IS2
          R2(1,I)  = 0.5d0*(FX(I)*WGIO -ER1(1)*R1(1,I)) ! Angstrom 
          R2(2,I)  = 0.5d0*(FY(I)*WGIO -ER1(1)*R1(2,I)) ! Angstrom 
          R2(3,I)  = 0.5d0*(FZ(I)*WGIO -ER1(1)*R1(3,I)) ! Angstrom 
      enddo
    enddo
  ENDIF
!
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0) cycle
    IF (WIO(IO) < 0.00001D0) cycle
    WGIO = DTIME**2 / (WIO(IO)/ANA) * 1.0D8
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    DO I = IS1, IS2
        R5P(:,I) = R5(:,I)
        R4P(:,I) = R4(:,I) + 5.0d0*R5(:,I)
        R3P(:,I) = R3(:,I) + 4.0d0*R4(:,I) + 10.0d0*R5(:,I)
        R2P(:,I) = R2(:,I) + 3.0d0*R3(:,I) + 6.0d0*R4(:,I) + 10.0d0*R5(:,I)
        R1P(:,I) = R1(:,I) + 2.0d0*R2(:,I) + 3.0d0*R3(:,I) + 4.0d0*R4(:,I) + 5.0d0*R5(:,I)
        R0P(:,I) = R0(:,I) + R1(:,I) + R2(:,I) + R3(:,I) + R4(:,I) + R5(:,I)
!
        VC(:,I) = R1(:,I)  !velocity * dt
    enddo
  enddo
!     ==================================================================
!     ==================================================================
!
500 CONTINUE 
    PCT(:) = 0.0D0
  DO IO = 1, NCOMPO
    VAVB(:) = 0.0D0
    IF (NION(IO) <= 0)    cycle
    IF (WIO(IO) < 0.00001D0)  cycle
    IS1 = IONS(1,IO)
    IS2 = IONS(2,IO)
    VALIO2 = 0.0D0
    DO I = IS1, IS2
!T                 CALL  PTOXYZ  (I)
      IF (IOND(I) == 0) THEN
        UI(I) = 0.0D0
        cycle
      END IF
!      UI(I)  = UI(I) + ZIA(IO)   !WATER-POL
      UI(I)  = UI(I) + ZIIA(I)    !WATER-POL
      AU(I)  = AU(I) + UI(I)
!     --------------------- Thermal part of pressure tensor
      VAVB(1) = VAVB(1) + VC(1,I)**2
      VAVB(2) = VAVB(2) + VC(2,I)**2
      VAVB(3) = VAVB(3) + VC(3,I)**2
      VAVB(4) = VAVB(4) + VC(1,I) * VC(2,I)
      VAVB(5) = VAVB(5) + VC(1,I) * VC(3,I)
      VAVB(6) = VAVB(6) + VC(2,I) * VC(3,I)
!      ------------------------------------------ For m.s.d.
      VALIO2  = VALIO2 + ((P(1,I)-P0(1,I))*BOX(1))**2 &
                       + ((P(2,I)-P0(2,I))*BOX(2))**2 &
                       + ((P(3,I)-P0(3,I))*BOX(3))**2
!T                 VALIO2  = VALIO2 + (Q(1,I)-Q0(1,I))**2
!T   *                              + (Q(2,I)-Q0(2,I))**2
!T   *                              + (Q(3,I)-Q0(3,I))**2
    enddo
!   --------------------- Sum of (1/2)mv2 of i-th ion species
    AMV2 = (VAVB(1)+VAVB(2)+VAVB(3))*1.0D-16 *(WIO(IO)/ANA) / (2.0D0 * DTIME**2)
    if (iion(io) == -1)  AMV2 = (1.5D0 * DBLE(NIOND(IO))*AKB) * TEMP
    VAL(13)    = VAL(13) + AMV2
    VAL(24+IO) = AMV2 / (1.5D0 * DBLE(NIOND(IO)) *AKB)
    DO J = 1, 6
      PCT(J) = PCT(J) + (VAVB(J)*1.0D-16)*(WIO(IO)/ANA) / (DTIME**2)
    enddo
!              -------------------------------------------------- M.s.d.
    VAL(24+LEM+IO) = VALIO2  / DBLE(NIOND(IO))
  enddo
!
  DO IO = 1, NNCOMPO                 !WATER-POL
    IF (NION(IO) <= 0) cycle
    DO I = IONS(1,IO), IONS(2,IO)
      DO J = 1, 3
        IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
          PJI     = -SIGN(1.0D0,P(J,I))
          P0(J,I) = P0(J,I) + PJI
          P(J,I)  = P(J,I)  + PJI
        END IF
      enddo
    enddo
  enddo
!     ----------------------------------------- Temperature and pressure
  VAL(1) = VAL(13) / (1.5D0 * (DBLE(NTION)-dble(NTIOND)) * AKB)
!     ----------------------------------------------- Quantum correction
  IF (RUNOPT(12) == 'QUANTUM   ')  CALL  QUANTM
!     ------------------------------------------------------------------
  TMV2   = 2.0D0 * VAL(13)
  TINT   = TINT + VAL(1)
  VAL(9) = UCSELF + VAL(9)
  VIRLSR  = VIRLSR * 1.0D-8 + VCORR
  VAL(2) = ( VAL(13)*2.0D0 + VIRLSR + VAL(9) )  / (3.0D0*VOL*1.0D-24)*1.0D-10
!
  VAL(3) = VAL(3) + VCORR/3.0D0
  VAL(4) = VAL(4) + VCORR/3.0D0
  VAL(5) = VAL(5) + VCORR/3.0D0
  VAL(9) = VAL(9) + UPOL                    ! WATER-POL
  PXYZ(1) = VAL(2)
  DO J = 1, 6
    VAL(J+2)  = (PCT(J) + VAL(J+2)) / (VOL*1.0D-24) * 1.0D-10
    PXYZ(J+1) = VAL(J+2)
    PRSTC2(J) = PRSTC2(J) / (VOL*1.0D-24) * 1.0D-10
  enddo
!     --------------------------------------------------------- Energies
  VAL(10) = VAL(10) + ECORR
  VAL(12) = VAL(9) + VAL(10) + VAL(11)
  DO I = 9, 13
    VAL(I)  = VAL(I) * FJMOL
  enddo
  VAL(14) = VAL(12) + VAL(13)
  if(RUNOPT(34) == 'WATER-POL ') write(*,'("== Upol ", F8.4, " kJ/mol ==")') upol*FJMOL
  ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
  VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
  VAL(16) = VAL(14) + VAL(15)
! -----------------------------------------------Nose-Hoover Hamiltonian
  IF (RUNOPT(5) == 'T NOSE    ') then
    H_Nose = VAL(14) + FJMOL*(0.5d0*detha(1)**2*STEMP(1) + etha(1)*A3NKBT)
    if (nfnose > 1) then
      do nnh = 2, nfnose
        H_Nose = H_Nose + FJMOL*(0.5d0*detha(nnh)**2*STEMP(nnh) + etha(nnh)*KBT)
      enddo
    endif
!    write(*,*) "etha, detha", etha, detha
!    write(*,'("== Hamiltonian_Nose ", F8.2, " kJ/mol ==")') H_Nose 
    if (mod(nrecrd(1),IRECRD(4)) == 0)  write(85,'(F8.2,1x,F8.2, 5(1x,E12.4))')VAL(1),H_Nose, &
    DeltEr2(1),DeltEr2(2),DeltEr2(3),DeltEr2(4),DeltEr2(5)
  ENDIF
!   ---------------------------------------------------------------------
! ------------------------------------------------- Pressure control
  do i=1, 6
    pbox(i) = box(i)
  end do
! -------------------------------------- Pressure control by scaling
  IF (RUNOPT(6) == 'P SCALING ')  CALL  SCCELL
! ------------------------------------- Pressure control by Andersen
  IF (RUNOPT(6) == 'P ANDERSEN')  THEN
    DPRES = VAL(2) - (VAL(3) + VAL(4) + VAL(5))/3.0D0
    PRESX = VAL(3) + DPRES
    PRESY = VAL(4) + DPRES
    PRESZ = VAL(5) + DPRES
    VOLS  = 1.0D-1*1.0D3*VOL*DTIME**2
!     WRITE(*,*) 'VOLS=',VOLS
    VBOX(1) = VBOX(1) + VOLS*(PRESX-SPRES(1))*ABOX1/VIRM(1)
    VBOX(2) = VBOX(2) + VOLS*(PRESY-SPRES(2))*ABOX2/VIRM(2)
    VBOX(3) = VBOX(3) + VOLS*(PRESZ-SPRES(3))*ABOX3/VIRM(3)
!           WRITE(*,*) CELLV
    BOX(1) = BOX(1) + VBOX(1)
    BOX(2) = BOX(2) + VBOX(2)
    BOX(3) = BOX(3) + VBOX(3)
    DO J = 1, 3
      H(J,1) = H(J,1) * BOX(1) * ABOX1
      H(J,2) = H(J,2) * BOX(2) * ABOX2
      H(J,3) = H(J,3) * BOX(3) * ABOX3
    enddo
    CALL  TABLER  (0)
  END IF
!     --------------------------------------------------- Cubic Andersen
  IF (RUNOPT(6) == 'P ANDERS-C')  THEN
    VOLS  = 1.0D-1*1.0D3*VOL*DTIME**2
!          WRITE(*,*) 'VOLS=',VOLS
    VBOX(1) = VBOX(1) + VOLS*(VAL(2)-SPRES(1))*ABOX1/VIRM(1)
    VBOX(2) = VBOX(1)
    VBOX(3) = VBOX(1)
!       WRITE(*,*) CELLV
    BOX(1) = BOX(1) + VBOX(1)
    BOX(2) = BOX(1)
    BOX(3) = BOX(1)
    DO  J = 1, 3
      H(J,1) = H(J,1) * BOX(1) * ABOX1
      H(J,2) = H(J,2) * BOX(2) * ABOX2
      H(J,3) = H(J,3) * BOX(3) * ABOX3
    enddo
    CALL  TABLER  (0)
  END IF
!     ------------------------------------------------------- Cubic cell
  if (RUNOPT(24) == 'CUBE      ' .and. RUNOPT(6) /= 'P NO-CNTL ') then
    VVVV   = box(1) * box(2) * box(3)
    abox   = (box(1) + box(2) + box(3)) / 3.0D0
    box(1) = box(1) - (box(1)-abox)*0.0001D0
    box(2) = box(2) - (box(2)-abox)*0.0001D0
    box(3) = box(3) - (box(3)-abox)*0.0001D0
    ffff   = (vvvv / (box(1)*box(2)*box(3)))**(1.0d0/3.0d0)
    box(1) = box(1) * ffff
    box(2) = box(2) * ffff
    box(3) = box(3) * ffff
    call  tabler  (0)
  end if
!     ---------------------------------------------- Chage box with time
  if (RUNOPT(7) == 'V CHANGE  ')  then
    box(icaxis) = pbox(icaxis)
    box(icaxis) = box(icaxis) + BCNGR
    if (bcngr > 0.0D0 .and. box(icaxis) > BTAGET) box(icaxis)=Btaget
    if (bcngr < 0.0D0 .and. box(icaxis) < BTAGET) box(icaxis)=Btaget
    call  tabler  (0)
  end if
!  ------------------------------------------- Bsic cell or unit cell
  VAL(17) = DENSTY
  DO I = 1, 6
    VAL(I+18) = BOX(I)
  enddo
  VAL(18) = VAL(19)*VAL(20)*VAL(21) * ANA * 1.0D-24 / dble(NFORML)
  IF (RUNOPT(17) == 'CRYSTAL   ') THEN
    DO I = 1, 3
      VAL(I+18) = BOX(I) / NBOX(I)
    enddo
  END IF
!     ---------------------------------------------------- Print results
  CALL  PRINTS  (DIPM2)
!
  IF (runopt(5)  == 'T NOSE    ') then
! --------------------------Recalculation of forces at their new positions
811 do i = 1,LVA
      VALP(i) = VAL(i)
      VAL(i) = 0.0d0
    enddo
    do i = 1,ntion+ndmole
      UI(i) = 0.0d0
      UIC(i) = 0.0d0
      FX(i) = 0.0d0
      FY(i) = 0.0d0
      FZ(i) = 0.0d0
    enddo
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001D0) cycle
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      DO I = IS1, IS2
        IF  (IION(IO) >= 0)  THEN
          dRx = R0P(1,I)
          dRy = R0P(2,I)
          dRz = R0P(3,I)
          PIJX = 0.0d0
          PIJY = 0.0d0
          PIJZ = 0.0d0
 611      if (dRx >= BOX(1)) then 
            dRx = R0P(1,I) -BOX(1)
            PIJX = PIJX -1.0d0
            goto 611
          endif
 614      if (dRx < 0.0d0) then 
            dRx = R0P(1,I) +BOX(1)
            PIJX = PIJX + 1.0d0
            goto 614
          endif
 612      if (dRy >= BOX(2)) then 
            dRy = R0P(2,I) -BOX(2)
            PIJY = PIJY -1.0d0
            goto 612
          endif
 615      if (dRy < 0.0d0) then 
            dRy = R0P(2,I) +BOX(2)
            PIJY = PIJY + 1.0d0
            goto 615
          endif
 613      if (dRz >= BOX(3)) then 
            dRz = R0P(3,I) -BOX(3)
            PIJZ = PIJZ -1.0d0
            goto 613
          endif
 616      if (dRz < 0.0d0) then 
            dRz = R0P(3,I) +BOX(3)
            PIJZ = PIJZ + 1.0d0
            goto 616
          endif
          PX(I) = dRx/BOX(1) !Predicted positions at t + dt
          PY(I) = dRy/BOX(2)
          PZ(I) = dRz/BOX(3)
          P0(1,I) = PP0(1,I) + PIJX
          P0(2,I) = PP0(2,I) + PIJY
          P0(3,I) = PP0(3,I) + PIJZ
        END IF
!       not perfect for msd !!!! 
!        IF (PX(I) < 0.0D0 .OR. PX(I) >= 1.0D0)  THEN
!          PJI     = -SIGN(1.0D0,PX(I))
!          PX(I)  = PX(I)  + PJI
!          P0(1,I) = P0(1,I) + PJI
!        endif
!        IF (PY(I) < 0.0D0 .OR. PY(I) >= 1.0D0)  THEN
!          PJI     = -SIGN(1.0D0,PY(I))
!          PY(I)  = PY(I)  + PJI
!          P0(2,I) = P0(2,I) + PJI
!        endif
!        IF (PZ(I) < 0.0D0 .OR. PZ(I) >= 1.0D0)  THEN
!          PJI     = -SIGN(1.0D0,PZ(I))
!          PZ(I)  = PZ(I)  + PJI
!          P0(3,I) = P0(3,I) + PJI
!        endif
      enddo
    enddo
    KRDF =0
!    call EWALDS  !Recalculation of Forces
    JJJ = 2
    CALL  EWALDP1  (myrank, mpsize)   ! Is it ok for water-pol?
!   --------------------------Correction of Thermostat
    TMV2 = 0.0D0
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001) cycle
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      AMV2 = 0.0D0
      DO I = IS1, IS2
        AMV2 = AMV2 + R1P(1,I)**2 + R1P(2,I)**2 + R1P(3,I)**2
      enddo
      TMV2 = TMV2 + AMV2 *1.0D-16*(WIO(IO)/ANA)/DTIME**2 !g cm**2/sec**2
    enddo
    VSTEMP(1) = (TMV2 - A3NKBT)*DTIME**2  / STEMP(1) - ER1P(1)*ER1P(2)
    if (nfnose > 1) then
      do nnh = 2, nfnose
        VSTEMP(nnh) = STEMP(nnh-1)*ER1P(nnh-1)**2/STEMP(nnh) - KBT*DTIME**2/STEMP(nnh) - ER1P(nnh)*ER1P(nnh+1)
      enddo
    endif
!
    do nnh = 1, nfnose
      DeltEr2(nnh) = 0.5d0*VSTEMP(nnh) - ER2P(nnh)
      ER5(nnh) = ER5P(nnh) + 1.0d0/60.0d0*DeltEr2(nnh)
      ER4(nnh) = ER4P(nnh) + 1.0d0/6.0d0*DeltEr2(nnh)
      ER3(nnh) = ER3P(nnh) + 11.0d0/18.0d0*DeltEr2(nnh)
      ER2(nnh) = ER2P(nnh) + DeltEr2(nnh)
      ER1(nnh) = ER1P(nnh) + 251.0d0/360.0d0*DeltEr2(nnh)
      ER0(nnh) = ER0P(nnh) + 3.0d0/16.0d0*DeltEr2(nnh)
    enddo
!write(*,*) DeltEr2(1),DeltEr2(2)
!read(*,*)
!
!
!   --------------------------------Correction of ions
    DO IO = 1, NCOMPO
      IF (NION(IO) <= 0) cycle
      IF (WIO(IO) < 0.00001D0) cycle
      WGIO = DTIME**2 / (WIO(IO)/ANA) * 1.0D8
      IS1 = IONS(1,IO)
      IS2 = IONS(2,IO)
      DO I = IS1, IS2
          Deltr2(1,I) = 0.5d0*(FX(I)*WGIO - ER1P(1)*R1P(1,I)) - R2P(1,I)
          Deltr2(2,I) = 0.5d0*(FY(I)*WGIO - ER1P(1)*R1P(2,I)) - R2P(2,I)
          Deltr2(3,I) = 0.5d0*(FZ(I)*WGIO - ER1P(1)*R1P(3,I)) - R2P(3,I)
!
          R5(:,I) = R5P(:,I) + 1.0d0/60.0d0*Deltr2(:,I)
          R4(:,I) = R4P(:,I) + 1.0d0/6.0d0*Deltr2(:,I) 
          R3(:,I) = R3P(:,I) + 11.0d0/18.0d0*Deltr2(:,I) 
          R2(:,I) = R2P(:,I) + Deltr2(:,I) 
          R1(:,I) = R1P(:,I) + 251.0d0/360.0d0*Deltr2(:,I) 
          R0(:,I) = R0P(:,I) + 3.0d0/16.0d0*Deltr2(:,I) 
!
        IF  (IION(IO) >= 0)  THEN
          dRx = R0(1,I)
          dRy = R0(2,I)
          dRz = R0(3,I)
          PIJX = 0.0d0
          PIJY = 0.0d0
          PIJZ = 0.0d0
 511      if (dRx >= BOX(1)) then 
            dRx = R0(1,I) -BOX(1)
            PIJX = PIJX -1.0d0
            goto 511
          endif
 514      if (dRx < 0.0d0) then 
            dRx = R0(1,I) +BOX(1)
            PIJX = PIJX + 1.0d0
            goto 514
          endif
 512      if (dRy >= BOX(2)) then 
            dRy = R0(2,I) -BOX(2)
            PIJY = PIJY -1.0d0
            goto 512
          endif
 515      if (dRy < 0.0d0) then 
            dRy = R0(2,I) +BOX(2)
            PIJY = PIJY + 1.0d0
            goto 515
          endif
 513      if (dRz >= BOX(3)) then 
            dRz = R0(3,I) -BOX(3)
            PIJZ = PIJZ -1.0d0
            goto 513
          endif
 516      if (dRz < 0.0d0) then 
            dRz = R0(3,I) +BOX(3)
            PIJZ = PIJZ + 1.0d0
            goto 516
          endif
!          if (dRx >= BOX(1) .or. dRx < 0.0d0) then
!            write(*,*) 'dRx =',dRx
!            read(*,*)
!          endif
!          if (dRy >= BOX(2) .or. dRy < 0.0d0) then
!            write(*,*) 'dRy =',dRy
!            read(*,*)
!          endif
!          if (dRz >= BOX(3) .or. dRz < 0.0d0) then
!            write(*,*) 'dRz =',dRz
!            read(*,*)
!          endif
          P(1,I) = dRx/BOX(1)
          P(2,I) = dRy/BOX(2)
          P(3,I) = dRz/BOX(3)
          P0(1,I) = PP0(1,I) + PIJX
          P0(2,I) = PP0(2,I) + PIJY
          P0(3,I) = PP0(3,I) + PIJZ
        END IF
        VP(:,I) = V(:,I)
        V(:,I)  = R1(:,I) 
      enddo
    enddo
!
    do i = 1,LVA
      VAL(i) = VALP(i)
    enddo
!
!    DO IO = 1, NNCOMPO
!      IF (NION(IO) <= 0) cycle
!      DO I = IONS(1,IO), IONS(2,IO)
!        DO J = 1, 3
!          IF (P(J,I) < 0.0D0 .OR. P(J,I) >= 1.0D0)  THEN
!            PJI     = -SIGN(1.0D0,P(J,I))
!            P0(J,I) = P0(J,I) + PJI
!            P(J,I)  = P(J,I)  + PJI
!!            R0(J,I) = R0(J,I) + PJI*BOX(J)
!!if (abs(P0(J,I)) > 1.0d0) then
!!        write(*,*)PJI, P0(J,I),P(J,I)
!!        read(*,*)
!!endif
!          END IF
!        enddo
!      enddo
!    enddo
    jconv = 0
    do nnh = 1, nfnose
      if (abs(DeltEr2(nnh)) > 1.0d-6) then 
        jconv = 1
      endif
    enddo
    if (jconv == 1) then
      do nnh = 1,nfnose
          ER0P(nnh) = ER0(nnh)
          ER1P(nnh) = ER1(nnh)
          ER2P(nnh) = ER2(nnh)
          ER3P(nnh) = ER3(nnh)
          ER4P(nnh) = ER4(nnh)
          ER5P(nnh) = ER5(nnh)
      enddo
      DO IO = 1, NCOMPO
        IF (NION(IO) <= 0) cycle
        IF (WIO(IO) < 0.00001D0) cycle
        IS1 = IONS(1,IO)
        IS2 = IONS(2,IO)
        DO I = IS1, IS2
            R5P(:,I) = R5(:,I) 
            R4P(:,I) = R4(:,I) 
            R3P(:,I) = R3(:,I) 
            R2P(:,I) = R2(:,I) 
            R1P(:,I) = R1(:,I) 
            R0P(:,I) = R0(:,I) 
        enddo
      enddo
      goto 811
    endif
  ENDIF
! ====================================Nose-Hoover Thermostat  
!     ------------------------------------- Correction for sum of mv = 0
!                                                    (Center of gravity)
  IF (RUNOPT(21) /= 'GRAV.FIELD' .AND. RUNOPT(16) /= 'NO(MV=0)  ' )  then
    io1 = 1
    io2 = ncompo
    TWT = TWEGHT
    if (runopt(16) == 'AM(MV=0)  ') then
      io1 = Iamv
      io2 = Iamv
      nnn = nion(Iamv)
      if (Namv > 0.or.Namv <= nion(Iamv))  nnn = Namv
      TWT = wio(Iamv)*dble(nnn)
    end if
    DO J = 1, 3
      CENTRE = 0.0D0
      DO IO = Io1, Io2
        IF (NION(IO) > 0)  THEN
          nnn=ions(2,io)
          if (Iamv == io .and. Namv > 0)  nnn = ions(1,io) + Namv-1
          DO I = IONS(1,IO), nnn
            CENTRE = CENTRE + V(J,I)*WIO(IO)
          enddo
        END IF
      enddo
      CENTRE = CENTRE / TWT
      CENTRP = CENTRE / BOX(J)
!          write (6,*)  j, centrp, Iamv, Namv,nnn  !' grav'
      DO I = 1, NTION+ndmole     !WATER-POL
        IF (IOND(I) > 0)  THEN
          V(J,I) = V(J,I) - CENTRE
          P(J,I) = P(J,I) - CENTRP
          IF (runopt(5) == 'T NOSE    ') then
            R1(J,I) = V(J,I)
            R0(J,I) = R0(J,I) - CENTRP*BOX(J)
          ENDIF
        END IF
      enddo
    enddo
  end if
!     --------------------------------------------- Temperature control
  IF (RUNOPT(5) == 'T SCALING ')  THEN
    FV = 1.0D0
    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
      TEMP = TEMP + DELTMP
      IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
      IF (DELTMP < 1.0d-6) TEMP = TMPGET
      FV = SQRT(TEMP/(TINT/DBLE(NTSTEP)))
    END IF
    IF (RUNOPT(12) == 'QUANTUM   ') THEN
      QCEE = QCEE + QCIT * VAL(1) + TQCE / VAL(1)
      QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
      IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
        FV = SQRT(QCEF*1.0D0/QCEE)
      END IF
    END IF
    IF (MODE < 0)                  FV = SQRT(TEMP/TPRE)
    IF (RUNOPT(5) == 'T NO-CNTL.')  FV = 1.0D0  ! ???? NO need????
!    IF (ABS(DELTMP) <= 0.000001)    FV = 1.0D0
    IF (VAL(1)/TEMP < 0.3333D0)    FV = SQRT(TEMP/VAL(1))
    IF (VAL(1)/TEMP > 1.6667D0)    FV = SQRT(TEMP/VAL(1))
    FV = 1.0D0 + (FV - 1.0D0) * TDUMP
    IF (ABS(FV-1.0D0) > 1.0D-7)  THEN
      DO I = 1, NTION
        DO J = 1, 3
          V(J,I) = V(J,I) * FV
        enddo
      enddo
    END IF
  END IF
  IF (RUNOPT(5) == 'T SCALE-A ')  THEN
    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
      TEMP = TEMP + DELTMP
      IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
      IF (DELTMP < 1.0d-6) TEMP = TMPGET
    END IF
    do io = 1, ncompo
      FV = 1.0D0
      IF (MOD(NRECRD(1),NTSTEP) == 0) FV=SQRT(TEMP/VAL(24+IO))
      IF (RUNOPT(12) == 'QUANTUM   ') THEN
        QCEE = QCEE + QCIT * VAL(24+IO) + TQCE/VAL(24+IO)
        QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
        IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN
          FV = SQRT(QCEF*1.0D0/QCEE)
        END IF
      END IF
      IF (VAL(24+IO)/TEMP < 0.333D0) FV=SQRT(TEMP/VAL(24+IO))
      IF (VAL(24+IO)/TEMP > 1.667D0) FV=SQRT(TEMP/VAL(24+IO))
      FV = 1.0D0 + (FV - 1.0D0) * TDUMP
      IF (ABS(FV-1.0D0) > 1.0D-7)  THEN
        DO I = ions(1,io), ions(2,io)
          DO J = 1, 3
            V(J,I) = V(J,I) * FV
          enddo
        enddo
      END IF
    enddo
  END IF
  IF (RUNOPT(5) == 'T NOSE    ')  THEN
!    IF (MOD(NRECRD(1),NTSTEP) == 0)  THEN    !2014/04/14
!      TEMP = TEMP + DELTMP
!      IF ((TMPGET-TEMP)*DELTMP < 0.0D0)  TEMP = TMPGET
!      IF (DELTMP < 1.0d-6) TEMP = TMPGET
!    END IF
    TEMP = TMPGET
    IF (RUNOPT(12) == 'QUANTUM   ') THEN
      QCEE = QCEE + QCIT * VAL(1) + TQCE / VAL(1)
      QCEF = QCEF + QCIT * TEMP   + TQCE / TEMP
      FV   = SQRT(QCEF*1.0D0/QCEE)
      DO I = 1, NTION
        DO J = 1, 3
          V(J,I) = V(J,I) * FV
        enddo
      enddo
    END IF
  END IF
!     --------------------------- Reduce velocities to prevent explosion
  IF (RUNOPT(5) /= 'T NOSE    ') then
  IF (RUNOPT(5) /= 'T NO-CNTL '.AND. VAL(1) > TEMP*2.0D0)  THEN
    write(*,*) 'Reduce velocities'
    IF (VAL(1)-TPRE > 1.0D6)  GO TO 999
    FV = SQRT(TEMP/VAL(1))
    DO I = 1, NTION
      FVI = FV
      V2 = V(1,I)**2 + V(2,I)**2 + V(3,I)**2
      IF (V2 > 0.2D0)  FVI = FV * 0.2D0/V2
      DO J = 1, 3
        P(J,I) = P(J,I) - (1.0D0 - FVI)*V(J,I) / BOX(J)
        V(J,I) = V(J,I) * FVI
      enddo
    enddo
  END IF
  ENDIF
  TPRE = VAL(1)
!
!     ---------------------------------------- Centering of Atom Cluster
  if (runopt(15) == 'CENTERING ')  then
    xcen = 0.0d0
    ycen = 0.0d0
    zcen = 0.0d0
    if (iaxcen == 1) xcen = 1.0D0
    if (iaxcen == 2) ycen = 1.0D0
    if (iaxcen == 3) zcen = 1.0D0
    if (iaxcen == 0)  then
      xcen = 1.0d0
      ycen = 1.0d0
      zcen = 1.0d0
    end if
    do i = 1, ntion
      v(1,i) = v(1,i) - (p(1,i)-0.5d0)*0.00002d0*xcen
      v(2,i) = v(2,i) - (p(2,i)-0.5d0)*0.00002d0*ycen
      v(3,i) = v(3,i) - (p(3,i)-0.5d0)*0.00002d0*zcen
    enddo
  end if
!
  if (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') call FIND_H2O(1)
!     CALL  XYZTOP
  RETURN
!
  999 WRITE  (*,9988)  VAL(1)
 9988 FORMAT ('*****  TEMPERATURE GETS TOO HIGH  ',F10.0,'K  *****')
      STOP
END
!
!
!                                                               ========
!================================================================ PRINTS
SUBROUTINE  PRINTS  (DIPM2)
  use param
  use charac
  use timdat
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use counts
!
implicit none
!
  double precision DIPM2,VAL2
  integer*4      IVAL(LEM)
  integer*4      IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  integer*4  N,ITEMP,J,I
  CHARACTER *40   FMT1(3), FMT11,FMT12
  EQUIVALENCE     (FMT1(1),FMT11), (FMT1(2),FMT12)
!
  IF (N3BP > 0) THEN
    DO N = 1, N3BP
      IF (AV3BP(2,N) > 0.1) AV3BP(1,N)= AV3BP(1,N)/AV3BP(2,N)
!              WRITE (*,1001)  AV3BP(1,N), AV3BP(2,N)
!1001          FORMAT (21X,'AVERAGE J-I-J ANGLE IS ',F6.2,' (',I4,')')
    enddo
  END IF
!     ---------------------------------------------------- Print results
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  IF (MOD(NRECRD(1),20) == 1)  WRITE  (*,2909)  TITLE,IRECRD(1),NRECRD(1)/10000, IHOUR
 2909      FORMAT ('== ',15A4,' (END=',I6,') ==' /  &
                   '+',I3,'0K steps ', 59('-'), ' Hour=',I2 /  &
                   ' STEP Temp  Prss.(  Px   Py   Pz ) ',  &
                   'U(Coul.) U(srt)  U(3p) E(total) Density mn''sc')
!
!  IF ((KKTIME(5,2) /= IMINUT .OR. KKTIME(6,2) /= ISECND) .OR. IYEAR+IMONTH+IDAY == 0)  THEN
!  if (I100TH == 0) then
    VAL2 = ABS(VAL(2))
    FMT11 = '(I5,I5,F7.4,1H(,3F5.2,1H),              '
    FMT12 = 'F9.1,F8.1,F6.1,F9.1,F8.5,1H ,I2,1H'',I2)'
    IF (VAL2 > 9.0 .AND. VAL2 < 95.0)  THEN
      FMT11 = '(1X,I4,I5,F7.3,1H(,3F5.1,1H),           '
    ELSE IF (VAL2 >= 95.0) THEN
      FMT11 = '(1X,I4,I5,F7.2,1H(,3F5.0,1H),           '
    END IF
    IF (ABS(VAL(9)) < 1.0D4.AND.ABS(VAL(14)) < 1.0D4)  THEN
      FMT12 = 'F9.2,F8.2,F6.2,F9.2,F8.5,1H ,I2,1H'',I2)'
    END IF
    ITEMP = INT(VAL(1))
    WRITE (*,FMT1) MOD(NRECRD(1),10000),ITEMP,VAL(2),VAL(3),  &
                       VAL(4),VAL(5),VAL(9),VAL(10),VAL(11),  &
                       VAL(14),VAL(17),IMINUT,ISECND
    KKTIME(1,2) = IYEAR
    KKTIME(2,2) = IMONTH
    KKTIME(3,2) = IDAY
    KKTIME(4,2) = IHOUR
    KKTIME(5,2) = IMINUT
    KKTIME(6,2) = ISECND
    KKTIME(7,2) = I100TH
!  END IF
  IF (RUNOPT(14) == 'DIPOLE    ')  THEN
    WRITE (*,9917)  DIPM2,VAL(14)+DIPM2
9917       FORMAT (10X,7X,15X,'Dipole:',4X,F8.3,5X,F9.2)
  END IF
!
!     ----------------------------------------------------- M.s.d., etc.
  IF (MOD(NRECRD(1),5) == 0)  THEN
    IF (ABS(ECORR*FJMOL) > 1.0E-10)  THEN
!                WRITE (*,2880)  VCORR / (3.0D0*VOL*1.0D-24)*1.0D-10,
!    *                           ECORR*FJMOL
2880            FORMAT (9X, F8.4,' GPa(Pcorr)',9X,'Ecorr=',F8.3,' kJ/mol')
    END IF
    IF (RUNOPT(17) == 'AMORPHOUS ') THEN
      IF (AV3BP(2,1) < 0.1)  WRITE (*,2901) (VAL(J+24+LEM), ATOM(J),J=1,5)
      IF (AV3BP(2,1) > 0.1)  WRITE (*,2901) (VAL(J+24+LEM), ATOM(J),J=1,5),AV3BP(1,1),INT(AV3BP(2,1))
2901             FORMAT (6X,'Msd:',5(F8.3,'(',A1,')'),F8.1,'(',I8,')')
    END IF
    IF (RUNOPT(17) == 'CRYSTAL   ') THEN
      IF (AV3BP(2,1) < 0.1) WRITE (*,2902) (VAL(J+24+LEM),ATOM(J),J=1,5), VAL(19),VAL(20), VAL(21)
      IF (AV3BP(2,1) > 0.1) WRITE (*,2902) (VAL(J+24+LEM),ATOM(J),J=1,5), VAL(19),VAL(20),VAL(21), &
                                            AV3BP(1,1),INT(AV3BP(2,1))
2902 FORMAT (1X,'Msd:',5(F6.3,':',A1),1X,3F7.3, F6.1,':',I5)
    END IF
  END IF
  IF (RUNOPT(3) == 'DETAIL    ')                 GO TO 670
  IF (RUNOPT(3) == 'ECONOMY   ')                 GO TO 690
  IF (MOD(NRECRD(1),5) /= 0.AND.NRECRD(3) /= 1)  GO TO 690
670 DO I = 1, LEM
    IVAL(I) = INT(VAL(I+24))
  enddo
  VAL2 = ABS(VAL(2))
  FMT11 = '(1X,I5,5I5,F8.4,1H(,6F6.3,1H),     '
  FMT12 = ' F10.2,F9.2,2F7.2,F10.3,    F9.5 ) '
  IF (VAL2 > 9.0 .AND. VAL2 < 95.0) THEN
    FMT11 = '(1X,I5,5I5,F8.3,1H(,6F6.3,1H),     '
  ELSE IF (VAL2 >= 95.0) THEN
    FMT11 = '(1X,I5,5I5,F8.2,1H(,6F6.2,1H),     '
  END IF
  IF (ABS(VAL(9)) < 1.0D4.AND.ABS(VAL(14)) < 1.0D4) THEN
    FMT12 = ' F10.3,F9.3,2F7.3,F10.4,   F9.5 )  '
  END IF
  WRITE (16,FMT1)  mod(NRECRD(1),100000), (IVAL(I),I=1,4),  &
                          INT(VAL(1)), (VAL(J),J= 2,11), VAL(13),  &
                          VAL(14),VAL(17)
!
690 IF (MOD(NRECRD(1),25) == 0)  THEN
      IF (RUNOPT(3) /= 'ECONOMY   ')  WRITE (16,2900) (VAL(J),J=25+LEM,LVA)
2900         FORMAT (7X,5F8.3  / 7x,5F8.3 )
    END IF
  RETURN
END
!
!
!                                                       ================
!=======================================================Center_of_DIATOM
SUBROUTINE  Center_of_Diatomic_Molecule
  use param
  use charac
  use atomsi
  use aboxof
  use forces
  use cartes
  use molecu
  use charge
  use pos
!
  implicit none
!     =======================================recognize diatomic molecule
!
  double precision  pix,piy,piz, pjx,pjy,pjz, rx,ry,rz, dx,dy,dz
  double precision  pjx0,pjy0,pjz0, rij2,cut2
  integer*4 nnn, K, j, i, im
!
!---------------------------------------------calc distance of atoms
  cut2 = dintra**2
  do im = 1, ndmole
    i=idmole(1,im)
    j=idmole(2,im)
    pix = p(1,i)
    piy = p(2,i)
    piz = p(3,i)
    pjx0 = p(1,j)
    pjy0 = p(2,j)
    pjz0 = p(3,j)
    if (pjx0 < pix)  pjx0 = pjx0 + 1.0
    if (pjy0 < piy)  pjy0 = pjy0 + 1.0
    if (pjz0 < piz)  pjz0 = pjz0 + 1.0
    DO K = 1, 8
      pjx = pjx0 - transx(k)
      pjy = pjy0 - transy(k)
      pjz = pjz0 - transz(k)
      RX = PIX - PjX
      RY = PIY - PjY
      RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                        IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                        IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                        IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
      DX = RX * BOX(1)
      DY = RY * BOX(2)
      DZ = RZ * BOX(3)
      RIJ2 = DX*DX + DY*DY + DZ*DZ
      if (rij2 < cut2)  go to 255
    enddo
    cycle
!                   -----------------------------------P of center of mass
255 Pix=(Pix+Pjx)/2.
    Piy=(Piy+Pjy)/2.
    Piz=(Piz+Pjz)/2.
    if (pix < 0.0)   pix = pix + 1.0
    if (pix > 1.0)   pix = pix - 1.0
    if (piy < 0.0)   piy = piy + 1.0
    if (piy > 1.0)   piy = piy - 1.0
    if (piz < 0.0)   piz = piz + 1.0
    if (piz > 1.0)   piz = piz - 1.0
    nnn = ntion+im
    p(1,nnn) = pix
    p(2,nnn) = piy
    p(3,nnn) = piz
    UI(nnn) = 0.0
    FX(nnn) = 0.0D0
    FY(nnn) = 0.0D0
    FZ(nnn) = 0.0D0
    PX(nnn)  = P(1,nnn)
    PY(nnn)  = P(2,nnn)
    PZ(nnn)  = P(3,nnn)
    ZII(nnn) = Zmole(idmole(3,im))
    DMOLE(1,IM) = DX
    DMOLE(2,IM) = Dy
    DMOLE(3,IM) = DZ
    DMOLE(4,IM) = SQRT(RIJ2)
!             write(*,*) nnn,DMOLE(1,IM),DMOLE(2,IM),DMOLE(3,IM)
!     *                   ,DMOLE(4,IM)
  enddo
  RETURN
END
!
!
!                                                             ==========
!=============================================================== EWALDP1
SUBROUTINE  EWALDP1  (myrank, mpsize)
!
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use radial
  use forces
  use cartes
  use molecu
  use vector
  use pmorse
  use quanco
  use ewal
  use charge
  use datoms
  use pos
!
!  implicit none
!
  integer*4  IRDF(LTB+1),  MRDF(LTB,LEE),   iii(3), icp
  double precision  E2(LSR),F2(LSR)
  double precision  PIX,DX,RX,DFX,FIX, R00,X0
  double precision  PIY,DY,RY,DFY,FIY,R01,X1,FIJ,FSIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,R02,X2,UII,EIJ,ESIJ
  double precision  VAL09P,ECDD,FCDD,ARIJ2,ARIJ,ARIJ3,ARIJ4,ASP
  double precision  VALnn(11), VALnnC(7)
  double precision  RIJ, RIJ2, RCUT2, zizj
  double precision  pjx0,pjy0,pjz0, TQCEP,RIJ3
  double precision  wal0Nc(7), wal0N(11),        rrr(7,2)
  double precision  uip(lni), fxp(lni), fyp(lni), fzp(lni)
  double precision  uicp(lni),UIIC   !WATER-POL
  double precision  Xmyui, Ymyui,Zmyui,  COFWAT  !Water-pol
  double precision  dtmp, dtmpxyz(3)
  integer*4  lp1,lp2  !WATER-POL
  double precision  Mz,pjx,pjy,pjz,ddd
  integer*4  iddatom(101,lni)
  double precision  dddatom(100,lni)
  integer*4  ierr,idiatom,iquantum,ibmhexp,iwatpol,i,j,myrank,mpsize
  integer*4  io,l,i1,i2,j1,j2,k,ip0,ip1,ip2,kk,m,mm,NNCOMPO,IOO,JO,IN
  integer*4  ijk,n,kkk,jj,ko,no
! ------------------------------------------------------------SPME
  integer nx,ny,nz,KIX,KIY,KIZ,ispme
  double precision UX,UY,UZ,SPL,UUX,UUY,UUZ,DUX,DUY,DUZ,SPLP,SPLPP
  double precision DDUX,DDUY,DDUZ
  double precision FCOFFx,FCOFFy,FCOFFz
  double precision UIII
  integer kkai,nsp,nmkkai,ndiv,nnx,nny,nnz,JX,JY,JZ
! ------------------------------------------------------------SPME
!
  include  'mpif.h'
  integer*4  status(MPI_STATUS_SIZE)
  call EWALDP1_NEW( myrank, mpsize ); return
!
!     ==== This is a routine to distribute and correct data to and from
!     ==== EWALD routines of MASTER and SLAVE processes.
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
!     ----------------------- Put the central atom of 3-body interaction
!                              at the last of atom species, to calculate
!                                                  3-body terms properly
!
  RCUT2 = rcut(1) * rcut(1)
!
  VALnn(:) = 0.0D0
  VALnnC(:) = 0.0D0
!
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
  idiatom  = 0
  if (runopt(23) == 'DIATOMIC  ')  idiatom  = 1
  iquantum = 0
  IF (RUNOPT(12) == 'QUANTUM   ')  iquantum = 1
  ibmhexp  = 0
  if (RUNOPT( 8) == 'BMHEXP*   ')  ibmhexp  = 1
  iwatpol  = 0
  if (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN')  iwatpol  = 1
  ispme  = 0
  if (runopt(45) == 'SPME      ')  ispme  = 1
!
  if (NRECRD(3) == 1 .and. JJJ == 1) then  !WATER-POL AND NOSE
    if (RUNOPT(45) == 'SPME      ') then
      allocate(AQX(ntion+ndmole,NVNx),AQY(ntion+ndmole,NVNy),AQZ(ntion+ndmole,NVNz))
      allocate(dMdux(ntion+ndmole,NVNx),dMduy(ntion+ndmole,NVNy),dMduz(ntion+ndmole,NVNz))
      allocate(kkx(ntion+ndmole,NVNx),kky(ntion+ndmole,NVNy),kkz(ntion+ndmole,NVNz))
    endif
    call MPI_Bcast (irecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (idiatom,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (iquantum,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ibmhexp,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (iwatpol,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)  !WATER-POL
    call MPI_Bcast (iatomo,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !WATER-POL
    call MPI_Bcast (ispme,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !SPME     
    call MPI_Bcast (NTION,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NION(1),              lemw,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IION(1),              lemw,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IONS(1,1),          lemw*2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NCOMPO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NPAIR,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (WIO(1),               lemw,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZIO(1),               lemw,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NDMOLE,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZIIP(1),      ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !WATER-POL
    call MPI_Bcast (RSWTCH(1),             lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (CIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D4IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D7IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (N3BP,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (I3BP(1,1),           L3P*3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ANG3BP(1),             L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FK3BP(1),              L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BGRD(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BLIM(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3LIM(1,1),          L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (E1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (F1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q1U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q2U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZMOLE(1),                2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DMOLE(1,1),        4*NTION,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DINTRA,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IDMOLE(1,1),3*NTION+NDMOLE,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IATOM2(1),               2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NVNx,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
    call MPI_Bcast (NVNy,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
    call MPI_Bcast (NVNz,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
!    write (*,*) '          MPI_Bcast sent NTION, E1, ZII, etc. '
  end if
!
  iii(1) = nrcut(1)
  iii(2) = nrcut(2)
  iii(3) = nvn
  call MPI_Bcast (iii(1),                  3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
   
  if (RUNOPT(45) == 'SPME      ') then
!write(*,*)'SPME mode'
    ARQ(:,:,:)=(0.0d0,0.0d0)
    DARQ(:,:,:)=(0.0d0,0.0d0)
    DARQp(:,:,:)=(0.0d0,0.0d0)
    if (JJJ == 1) then 
      AQX(:,:)=0.0d0
      AQY(:,:)=0.0d0
      AQZ(:,:)=0.0d0
      dMdux(:,:)=0.0d0
      dMduy(:,:)=0.0d0
      dMduz(:,:)=0.0d0
    endif
!
    NNCOMPO = NCOMPO
    if(iwatpol == 1)  NNCOMPO = NCOMPO + 1   !WATER-POL
IOLOOP: do IO = 1, NNCOMPO
ILOOP:    DO I = ions(1,IO), ions(2,IO)
            if (JJJ == 1) then
              DX = DBLE(NVNx)*PX(I)  ! Scaled fractional coordinate
              do nx=1,NDIM !Loop for non-zero values of M(u)
                UUX = DX-dble(nx-1)  !
                KIX = int(UUX)
                UX = DX - dble(KIX)
                if (UUX < 0.0d0) then
                  KIX = int(UUX+dble(NVNx))
                  UX = DX + dble (NVNx) - dble(KIX)
                endif
!               Mn
                SPL=0.0d0
                kkai=1
                nmkkai=nkai
                do nsp = 0,NDIM
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUX = UX-dble(nsp)
                  IF(DUX <0.0d0) DUX=0.0d0
                  SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DUX**(NDIM-1)
                enddo
                SPL=SPL/dble(nkai/NDIM)              !Mn(u-k-nK)
                AQX(I,KIX+1) = SPL   !to start k=0 from element 1
                kkx(I,nx)=KIX+1
!
!               Mn-1
                SPLP=0.0d0
                SPLPP=0.0d0
                kkai=1
                nmkkai=nkai/NDIM
                do nsp = 0,NDIM-1
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-1-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUX = UX-dble(nsp)
                  DDUX = DUX-1.0d0
                  IF(DUX <0.0d0) DUX=0.0d0
                  IF(DDUX <0.0d0) DDUX=0.0d0
                  SPLP=SPLP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DUX**(NDIM-2)
                  SPLPP=SPLPP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DDUX**(NDIM-2)
                enddo
                SPLP=SPLP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                SPLPP=SPLPP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                dMdux(I,KIX+1) = SPLP - SPLPP
              end do
!
              DY = DBLE(NVNy)*PY(I)
              do ny=1,NDIM
                UUY = DY-dble(ny-1)
                KIY = int(UUY)
                UY = DY - dble(KIY)
                if (UUY < 0.0d0) then
                  KIY = int(UUY+dble(NVNy))
                  UY = DY + dble (NVNy) - dble(KIY)
                endif
                SPL=0.0d0
                kkai=1
                nmkkai=nkai
                do nsp = 0,NDIM
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUY = UY-dble(nsp)
                  IF(DUY <0.0d0) DUY=0.0d0
                  SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DUY**(NDIM-1)
                enddo
                SPL=SPL/dble(nkai/NDIM)
                AQY(I,KIY+1) = SPL
                kky(I,ny)=KIY+1
!
!               Mn-1
                SPLP=0.0d0
                SPLPP=0.0d0
                kkai=1
                nmkkai=nkai/NDIM
                do nsp = 0,NDIM-1
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-1-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUY = UY-dble(nsp)
                  DDUY = DUY-1.0d0
                  IF(DUY <0.0d0) DUY=0.0d0
                  IF(DDUY <0.0d0) DDUY=0.0d0
                  SPLP=SPLP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DUY**(NDIM-2)
                  SPLPP=SPLPP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DDUY**(NDIM-2)
                enddo
                SPLP=SPLP/dble(nkai/NDIM/(NDIM-1))              !Mn(u-k-nK)
                SPLPP=SPLPP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                dMduy(I,KIY+1) = SPLP - SPLPP
              end do
!
              DZ = DBLE(NVNz)*PZ(I)
              do nz =1,NDIM
                UUZ = DZ-dble(nz-1)
                KIZ = int(UUZ)
                UZ = DZ - dble(KIZ)
                if (UUZ < 0.0d0) then
                  KIZ = int(UUZ+dble(NVNz))
                  UZ = DZ + dble(NVNz) - dble(KIZ)
                endif
                SPL=0.0d0
                kkai=1
                nmkkai=nkai
                do nsp = 0,NDIM
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUZ = UZ-dble(nsp)
                  IF(DUZ <0.0d0) DUZ=0.0d0
                  SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DUZ**(NDIM-1)
                enddo
                SPL=SPL/dble(nkai/NDIM)
                AQZ(I,KIZ+1) = SPL
                kkz(I,nz)=KIZ+1
!
!               Mn-1
                SPLP=0.0d0
                SPLPP=0.0d0
                kkai=1
                nmkkai=nkai/NDIM
                do nsp = 0,NDIM-1
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-1-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUZ = UZ-dble(nsp)
                  DDUZ = DUZ -1.0d0
                  IF(DUZ <0.0d0) DUZ=0.0d0
                  IF(DDUZ <0.0d0) DDUZ=0.0d0
                  SPLP=SPLP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DUZ**(NDIM-2)
                  SPLPP=SPLPP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DDUZ**(NDIM-2)
                enddo
                SPLP=SPLP/dble(nkai/NDIM/(NDIM-1))              !Mn(u-k-nK)
                SPLPP=SPLPP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                dMduz(I,KIZ+1) = SPLP - SPLPP
              end do
            endif
!
            do nz = 1, NDIM
              nnz=kkz(I,nz)
              do ny = 1, NDIM
                nny=kky(I,ny)
                do nx = 1, NDIM
                  nnx=kkx(I,nx)
                  ARQ(nnx,nny,nnz)=ARQ(nnx,nny,nnz)+ZII(I)*AQX(I,nnx)*AQY(I,nny)*AQZ(I,nnz)
                enddo
              enddo
            enddo
!
          end do ILOOP        !I
        end do IOLOOP          !IO
      call MPI_Bcast (ARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
      call MPI_Bcast (DARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
      call MPI_Bcast (THREC(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
      call MPI_Bcast (PNVxx(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVyy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVzz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVxy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVxz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVyz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (QCOFF,                  1, MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  endif
!
  call MPI_Bcast (KRDF,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !WATER-POL
  call MPI_Bcast (ZII(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !WATER-POL
  call MPI_Bcast (nrecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  if (ispme == 0) then
    call MPI_Bcast (NVEC(1,1),           3*NVN,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (UNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (PNV(1,1),            6*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  endif
  do i=1, 6
    rrr(i,1) = box(i)
    rrr(i,2) = rbox(i)
  end do
  rrr(7,1) = rcut(1)
  rrr(7,2) = rcut(2)
  call MPI_Bcast (rrr(1,1),               14,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (E0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  call MPI_Bcast (PX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (r3limax,                 1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!  write (*,8801)
8801 format (11x,'MPI_Bcast sent NVN, BOX, E0, F0, Px-Pz, etc.')
!
!     ------------------------------------------ Coulomb reciprocal term
!     ------------------------------------ Coulmb direct and short range
!
  call  EWALDP3  (idiatom, iquantum, iwatpol, ispme, valnn, VALnnC, myrank, mpsize)
!
!
  IF(RUNOPT(30)  ==  'EWALD-C   ') then
    Mz = 0.0d0
    do IO = 1, NCOMPO
      do I = IONS(1,IO), IONS(2,IO)
        Mz = Mz + PZ(I)*ZIO(IO)
      enddo
    enddo
    Mz = Mz * BOX(3)
!
    valnn(9) = valnn(9) + 2.0d0*PI*(Mz*ELC*1.0d-8)**2/(VOL*1.d-24)
    do IO = 1, NCOMPO
      do I = IONS(1,IO), IONS(2,IO)
        FZ(I) = FZ(I) -4.0d0*PI* ZIO(IO)*Mz*ELC**2*1.0d-8/(VOL*1.d-24)
      enddo
    enddo
  ENDIF
!     ------------------ Calculation of Coulomb of three point charges
  if (runopt(23) == 'DIATOMIC  ')  then
    do  L = 1, 2
      i1 = ntion + 1
      i2 = ntion + ndmole
      if (L  ==  2)  i1 = ntion + 2
      DO I = i1, i2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        j1 = 1
        j2 = ntion
        IF (L == 2)  THEN
          J1 = NTION + 1
          j2 = I-1
        END IF
        DO J = j1, j2
          ZIZJ  = ZII(I) * ZII(J)
!P              ZIJE2 = ZIO(IO) * ZIO(JO) * ELC**2
          pjx0 = p(1,j)
          pjy0 = p(2,j)
          pjz0 = p(3,j)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0
          DO K = 1, 8
            pjx = pjx0 - transx(k)
            pjy = pjy0 - transy(k)
            pjz = pjz0 - transz(k)
            RX = PIX - PjX
            RY = PIY - PjY
            RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  GO TO 257
          enddo
          GO TO 262
!
257       RIJ = SQRT(RIJ2)
          IP0 = INT(RIJ*100.0)
!         ---------------------------------- Interpolation
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = IP0 * 0.01D0
          R01 = IP1 * 0.01D0
          R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
          FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
          VALnn(9) = VALnn(9) + EIJ
          UII   = UII   + EIJ
          UI(J) = UI(J) + EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VALnn(3) = VALnn(3) + DFX * DX
          VALnn(4) = VALnn(4) + DFY * DY
          VALnn(5) = VALnn(5) + DFZ * DZ
          VALnn(6) = VALnn(6) + DFX * DY
          VALnn(7) = VALnn(7) + DFX * DZ
          VALnn(8) = VALnn(8) + DFY * DZ
262       CONTINUE
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
      enddo
    enddo
  end if
  if (RUNOPT(34) == 'WATER-POL ' .or. RUNOPT(34) == 'WATER-POLN') then 
                                                 ! Remove innermolecular Coulomb
    VAL09P = VALnn(9)
    no = 0
    do io = IONS(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      do k = 2, 4
        kk = ih2o(k,no)
        PIX = PX(kk)
        PIY = PY(kk)
        PIZ = PZ(kk)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0d0
        DO m = k+1, 5
          mm = ih2o(m,no)
          RX = PIX - PX(mm)
          RY = PIY - PY(mm)
          RZ = PIZ - PZ(mm)
          IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
          IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
          IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
          DX   = RX * BOX(1)
          DY   = RY * BOX(2)
          DZ   = RZ * BOX(3)
          RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
          if (RIJ < 0.1D0) then
              write(*,*) 'Too short distance !!!'
              write(*,*) 'RIJ, ih2o1, ih2o2' 
              write(*,'(F10.7,1x,i7,1x,i7)') RIJ, kk, mm
              write(*,'(3(F10.7,1x))') PX(kk),PY(kk),PZ(kk)
              write(*,'(3(F10.7,1x))') PX(mm),PY(mm),PZ(mm)
              write(*,'(3(F10.7,1x))') RX,RY,RZ
              write(*,'(3(F10.7,1x))') DX,DY,DZ
              RX = PX(io) - PX(kk)
              RY = PY(io) - PY(kk)
              RZ = PZ(io) - PZ(kk)
              IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
              IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
              IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
              DX   = RX * BOX(1)
              DY   = RY * BOX(2)
              DZ   = RZ * BOX(3)
              RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
              write(*,*) 'R O-kk'
              write(*,'(4(F10.7,1x))') RIJ, DX,DY,DZ
              RX = PX(io) - PX(mm)
              RY = PY(io) - PY(mm)
              RZ = PZ(io) - PZ(mm)
              IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
              IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
              IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
              DX   = RX * BOX(1)
              DY   = RY * BOX(2)
              DZ   = RZ * BOX(3)
              RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
              write(*,*) 'R O-mm'
              write(*,'(4(F10.7,1x))') RIJ,DX,DY,DZ
              stop
          endif
          if (RIJ > 3.0D0) stop 'Too long distance!!!'
          RIJ3 = RIJ**3  !angstrom
          ZIZJ  = ZII(mm)*ZII(kk)
!          EIJ  = ELC**2*ZIZJ/RIJ*1.0D8     !erg cgs-esu
          EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
          VALnn(9) = VALnn(9) - EIJ
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJ
          UI(mm) = UI(mm) - EIJ
          UIC(mm) = UIC(mm) - EIJ
!!          FIJ   = ELC**2*ZIZJ/RIJ3*1.0D16
          FIJ   = EPOLLL*ZIZJ/RIJ3 ! dyn
          DFX  = FIJ*DX
          DFY  = FIJ*DY
          DFZ  = FIJ*DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(mm) = FX(mm) + DFX  ! cgs-esu
          FY(mm) = FY(mm) + DFY  ! cgs-esu
          FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
          VALnn(3) = VALnn(3) - DFX * DX
          VALnn(4) = VALnn(4) - DFY * DY
          VALnn(5) = VALnn(5) - DFZ * DZ
          VALnn(6) = VALnn(6) - DFX * DY
          VALnn(7) = VALnn(7) - DFX * DZ
          VALnn(8) = VALnn(8) - DFY * DZ
        enddo
        FX(kk) = FX(kk) - FIX
        FY(kk) = FY(kk) - FIY
        FZ(kk) = FZ(kk) - FIZ
        UI(kk) = UI(kk) - UII
        UIC(kk) = UIC(kk) - UIIC
      enddo
    enddo
!    IF (maxedip <= THRESHD) then
!    IF (sumedip <= THRESHD) then
    if (RUNOPT(34) == 'WATER-POL ') then
!   -------------------------------------------------Forces by Upol
      no = 0
      do io = ions(1,IATOMO),ions(2,IATOMO)
        no = no + 1
        k = ih2o(2,no)
        m = ih2o(3,no)
        lp1 = ih2o(4,no)
        lp2 = ih2o(5,no)
        COFWAT = EPOLLL/watpol(1,no)
!       ----------------------------------O-H1 direction
        Xmyui = COFWAT*idipX(2,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(2,no)
        Zmyui = COFWAT*idipZ(2,no)
        DX = DPX1(no)
        DY = DPY1(no)
        DZ = DPZ1(no)
        DFX = -1.0d0 * QHHk(no) * Xmyui
        DFY = -1.0d0 * QHHk(no) * Ymyui
        DFZ = -1.0d0 * QHHk(no) * Zmyui
        FX(k) = FX(k) + DFX
        FY(k) = FY(k) + DFY
        FZ(k) = FZ(k) + DFZ
        FX(lp1) = FX(lp1) - 0.5d0*DFX
        FY(lp1) = FY(lp1) - 0.5d0*DFY
        FZ(lp1) = FZ(lp1) - 0.5d0*DFZ
        FX(lp2) = FX(lp2) - 0.5d0*DFX
        FY(lp2) = FY(lp2) - 0.5d0*DFY
        FZ(lp2) = FZ(lp2) - 0.5d0*DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VALnn(3) = VALnn(3) + DFX * DX   !dyn angstrom
        VALnn(4) = VALnn(4) + DFY * DY
        VALnn(5) = VALnn(5) + DFZ * DZ
        VALnn(6) = VALnn(6) + DFX * DY
        VALnn(7) = VALnn(7) + DFX * DZ
        VALnn(8) = VALnn(8) + DFY * DZ
!       ----------------------------------O-H2 direction
        Xmyui = COFWAT*idipX(3,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(3,no)
        Zmyui = COFWAT*idipZ(3,no)
        DX = DPX2(no)
        DY = DPY2(no)
        DZ = DPZ2(no)
        DFX = -1.0d0 * QHHm(no) * Xmyui
        DFY = -1.0d0 * QHHm(no) * Ymyui
        DFZ = -1.0d0 * QHHm(no) * Zmyui
        FX(m) = FX(m) + DFX
        FY(m) = FY(m) + DFY
        FZ(m) = FZ(m) + DFZ
        FX(lp1) = FX(lp1) - 0.5d0*DFX
        FY(lp1) = FY(lp1) - 0.5d0*DFY
        FZ(lp1) = FZ(lp1) - 0.5d0*DFZ
        FX(lp2) = FX(lp2) - 0.5d0*DFX
        FY(lp2) = FY(lp2) - 0.5d0*DFY
        FZ(lp2) = FZ(lp2) - 0.5d0*DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VALnn(3) = VALnn(3) + DFX * DX   !dyn angstrom
        VALnn(4) = VALnn(4) + DFY * DY
        VALnn(5) = VALnn(5) + DFZ * DZ
        VALnn(6) = VALnn(6) + DFX * DY
        VALnn(7) = VALnn(7) + DFX * DZ
        VALnn(8) = VALnn(8) + DFY * DZ
!       --------------------------------LP2->LP1 direction
        COFWAT = EPOLLL/watpol(2,no)
        Xmyui = COFWAT*idipX(4,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(4,no)
        Zmyui = COFWAT*idipZ(4,no)
        DX = 2.0d0*LOP1X(no)
        DY = 2.0d0*LOP1Y(no)
        DZ = 2.0d0*LOP1Z(no)
        DFX = -1.0d0 * QLP1z(no) * Xmyui
        DFY = -1.0d0 * QLP1z(no) * Ymyui
        DFZ = -1.0d0 * QLP1z(no) * Zmyui
        FX(lp1) = FX(lp1) + DFX
        FY(lp1) = FY(lp1) + DFY
        FZ(lp1) = FZ(lp1) + DFZ
        FX(lp2) = FX(lp2) - DFX
        FY(lp2) = FY(lp2) - DFY
        FZ(lp2) = FZ(lp2) - DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VALnn(3) = VALnn(3) + DFX * DX   !dyn angstrom
        VALnn(4) = VALnn(4) + DFY * DY
        VALnn(5) = VALnn(5) + DFZ * DZ
        VALnn(6) = VALnn(6) + DFX * DY
        VALnn(7) = VALnn(7) + DFX * DZ
        VALnn(8) = VALnn(8) + DFY * DZ
      enddo
    endif
!
      NNCOMPO = NCOMPO + 1   !WATER-POL
!     -----------------------Remove short range among Lone pairs and inner molecular atoms
      no = 0
      do io = IONS(1,IATOMO), IONS(2,IATOMO)
        no = no + 1
        IOO = NNCOMPO
        JO  = NNCOMPO
        EIJ = 0.0D0
        FIJ = 0.0D0
        ECDD = 0.0D0
        FCDD = 0.0D0
        IN = IOO*(IOO-1)/2 + JO
        DO K = 1, NRCUT(2)
          E2(K) = E1(K,IN)
          F2(K) = F1(K,IN)
        enddo
        mm = ih2o(4,no)
        kk = ih2o(5,no)
        RX = PX(kk) - PX(mm)
        RY = PY(kk) - PY(mm)
        RZ = PZ(kk) - PZ(mm)
        IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
        IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
        IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
        DX   = RX * BOX(1)
        DY   = RY * BOX(2)
        DZ   = RZ * BOX(3)
        RIJ2 = DX*DX + DY*DY + DZ*DZ
        RIJ  = sqrt(RIJ2)  !angstrom
!       ----------------- Charge-dipole and dipole-induced dipole
        IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
          ARIJ2 = ARIJ  * ARIJ
          ARIJ3 = ARIJ2 * ARIJ
          ARIJ4 = ARIJ3 * ARIJ
          ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
          FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                  7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
          EIJ   = EIJ + ECDD
          FIJ   = FIJ + FCDD
          VALnn(10) = VALnn(10) - ECDD
          VIRLSR = VIRLSR - FCDD*RIJ2
        END IF
!
!       --------------------------------------- Short range forces
!       ----------------------------------- Interpolation
        IP0 = INT(RIJ*100.0D0)
        IP1 = IP0 + 1
        IP2 = IP0 + 2
        R00 = dble(IP0) * 0.01D0
        R01 = dble(IP1) * 0.01D0
        R02 = dble(IP2) * 0.01D0
!                     X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                     X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                     X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
        X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
        X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
        X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
        FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
        ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!
        FIJ = FIJ + FSIJ
        EIJ = EIJ + ESIJ          
        VALnn(10)  = VALnn(10)  - ESIJ
        VIRLSR = VIRLSR - FSIJ*RIJ2
        UI(mm) = UI(mm) - EIJ
        UI(kk) = UI(kk) - EIJ
        DFX = FIJ * DX
        DFY = FIJ * DY
        DFZ = FIJ * DZ
        FX(mm) = FX(mm) + DFX
        FY(mm) = FY(mm) + DFY
        FZ(mm) = FZ(mm) + DFZ
        FX(kk) = FX(kk) - DFX
        FY(kk) = FY(kk) - DFY
        FZ(kk) = FZ(kk) - DFZ
!
        VALnn(3) = VALnn(3) - DFX * DX
        VALnn(4) = VALnn(4) - DFY * DY
        VALnn(5) = VALnn(5) - DFZ * DZ
        VALnn(6) = VALnn(6) - DFX * DY
        VALnn(7) = VALnn(7) - DFX * DZ
        VALnn(8) = VALnn(8) - DFY * DZ
!
        do m = 1,3
          mm = ih2o(m,no) ! Oxygen, hydrogens
          if (m == 1) JO = IATOMO
          if (m > 1 ) JO = IATOMH
          IOO = NNCOMPO
          IN = IOO*(IOO-1)/2 + JO
          IF (IOO < JO)  IN = JO*(JO-1)/2 + IOO
          DO K = 1, NRCUT(2)
            E2(K) = E1(K,IN)
            F2(K) = F1(K,IN)
          enddo
          do k = 4,5
            FIJ = 0.0D0
            EIJ = 0.0D0
            kk = ih2o(k,no)
            PIX = PX(kk)   ! Lone pair
            PIY = PY(kk)   ! Lone pair
            PIZ = PZ(kk)   ! Lone pair
            RX = PIX - PX(mm)
            RY = PIY - PY(mm)
            RZ = PIZ - PZ(mm)
            IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
            IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
            IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
            DX   = RX * BOX(1)
            DY   = RY * BOX(2)
            DZ   = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            RIJ  = sqrt(RIJ2)  !angstrom
!           --------- Charge-dipole and dipole-induced dipole
            IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
              ARIJ2 = ARIJ  * ARIJ
              ARIJ3 = ARIJ2 * ARIJ
              ARIJ4 = ARIJ3 * ARIJ
              ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
              FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                   7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
              EIJ   = EIJ + ECDD
              FIJ   = FIJ + FCDD
              VALnn(10) = VALnn(10) - ECDD
              VIRLSR = VIRLSR - FCDD*RIJ2
            END IF
!           ----------------------------------- Interpolation
            IP0 = INT(RIJ*100.0D0)
            IP1 = IP0 + 1
            IP2 = IP0 + 2
            R00 = dble(IP0) * 0.01D0
            R01 = dble(IP1) * 0.01D0
            R02 = dble(IP2) * 0.01D0
            X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
            X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
            X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
            FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
            ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!
            FIJ = FIJ + FSIJ
            EIJ = EIJ + ESIJ           
            VALnn(10)  = VALnn(10)  - ESIJ
            VIRLSR = VIRLSR - FSIJ*RIJ2
            UI(mm) = UI(mm) - EIJ
            UI(kk) = UI(kk) - EIJ
            DFX = FIJ * DX
            DFY = FIJ * DY
            DFZ = FIJ * DZ
            FX(mm) = FX(mm) + DFX
            FY(mm) = FY(mm) + DFY
            FZ(mm) = FZ(mm) + DFZ
            FX(kk) = FX(kk) - DFX
            FY(kk) = FY(kk) - DFY
            FZ(kk) = FZ(kk) - DFZ
!
            VALnn(3) = VALnn(3) - DFX * DX
            VALnn(4) = VALnn(4) - DFY * DY
            VALnn(5) = VALnn(5) - DFZ * DZ
            VALnn(6) = VALnn(6) - DFX * DY
            VALnn(7) = VALnn(7) - DFX * DZ
            VALnn(8) = VALnn(8) - DFY * DZ
          enddo
        enddo
      enddo
!
! ------------------------------------------------------------------
! recalculation of UCSELF, UCSLFI
!
    UCSELF = 0.0D0
    ASP = - (ALPHA*1.0D8) * ELC**2 / SQRT(PI)
    do io = 1,ncompo
      UCSLFI(io) = 0.0d0
      DO I = ions(1,io), IONS(2,io)
        UCSLFI(io) = UCSLFI(io) + ZII(I)**2*ASP
        UIC(I) = UIC(I) + 2.0D0*ZII(I)**2*ASP
      enddo
      UCSELF = UCSELF + UCSLFI(io)
    enddo
    UCSLFI(ncompo+1) = 0.0D0
    do i = ntion+1, ntion+ndmole
      UCSLFI(ncompo+1) = UCSLFI(ncompo+1) + ZII(i)**2*ASP
      UIC(i) = uic(I) + 2.0d0*ZII(I)**2*ASP
    enddo
    UCSELF = UCSELF + UCSLFI(ncompo+1)
!
    do i = 1, ntion+ndmole
      ZIIA(i) = ZII(i)*ZII(i)*ASP*2.0D0
      ZIIC(i) = ZIIA(i) !/2.0D0
    enddo
  endif
!
!     --------------------------------------- receive results from CPU's
  if (mpsize > 1)  then
    do  icp = 1, mpsize-1
      call MPI_Ssend (icp,                     1,         MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,ierr)
      call MPI_Recv  (wal0N(1),               11,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      do i = 3, 11
        valnn(i) = valnn(i) + wal0N(i)
      enddo
      virlsr = virlsr + wal0n(2)
      call MPI_Recv (wal0NC(1),                7,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      tqcep = wal0NC(7)
      valnnc(1) = valnnc(1) + wal0Nc(1)
      valnnc(2) = valnnc(2) + wal0Nc(2)
      valnnc(3) = valnnc(3) + wal0Nc(3)
      valnnc(4) = valnnc(4) + wal0Nc(4)
      valnnc(5) = valnnc(5) + wal0Nc(5)
      valnnc(6) = valnnc(6) + wal0Nc(6)
      TQCE   = TQCE   + TQCEP
      call MPI_Recv (uip(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (FXp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (FYp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (FZp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
      call MPI_Recv (UICp(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr) !WATER-POL
      call MPI_Recv (MRDF(1,1),        ltb*npair,        MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)
      do j = 1, npair
        do i = 1, nrcut(1)
          nrdf(i,j) = nrdf(i,j) + mrdf(i,j)
        enddo
      enddo
      call MPI_Recv (iddatom(1,1),101*(ntion+ndmole),       MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)  !WATER-POL
      call MPI_Recv (dddatom(1,1),100*(ntion+ndmole),MPI_DOUBLE_PRECISION,icp,icp,MPI_COMM_WORLD,status,ierr) !WATER-POL
      do i = 1, ntion + ndmole !WATER-POL
        ui(i) = ui(i) + uip(i)
        fx(i) = fx(i) + fxp(i)
        fy(i) = fy(i) + fyp(i)
        fz(i) = fz(i) + fzp(i)
        uic(i) = uic(i) + uicp(i)  !WATER-POL
        if (iddatom(101,i) > 0) then
          do  j = 1, iddatom(101,i)
            idatom(101,i) = idatom(101,i) + 1
            idatom(idatom(101,i),i) = iddatom(j,i)
            ddatom(idatom(101,i),i) = dddatom(j,i)
          end do
        end if
      enddo
!
      if (runopt(45) == 'SPME      ') then !Smooth Particle Mesh Ewald
      call MPI_Recv (DARQp(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,icp,icp, MPI_COMM_WORLD,status,ierr)
        do JZ=1,NVNz
          do JY=1,NVNy
            do JX=1,NVNx
              DARQ(JX,JY,JZ)=DARQ(JX,JY,JZ)+DARQp(JX,JY,JZ)
            enddo
          enddo
        enddo
      endif
    enddo

!    write (*,8901)  1,mpsize-1
8901 format (11x,'MPI_Recv received results from ',i2,' to ',I3)
  end if
!
    if (runopt(45) == 'SPME      ') then !Smooth Particle Mesh Ewald
      do IO = 1, NNCOMPO
        DO I = ions(1,IO), ions(2,IO)
          FCOFFx=FCOFF*dble(NVNx)/BOX(1)*ZII(I)
          FCOFFy=FCOFF*dble(NVNy)/BOX(2)*ZII(I)
          FCOFFz=FCOFF*dble(NVNz)/BOX(3)*ZII(I)
          do nz = 1, NDIM
            nnz=kkz(I,nz)
            do ny = 1, NDIM
              nny=kky(I,ny)
              do nx = 1, NDIM
                nnx=kkx(I,nx)
                FX(I)=FX(I)-FCOFFx*dMdux(I,nnx)*AQY(I,nny)*AQZ(I,nnz)*DARQ(nnx,nny,nnz)
                FY(I)=FY(I)-FCOFFy*dMduy(I,nny)*AQX(I,nnx)*AQZ(I,nnz)*DARQ(nnx,nny,nnz)
                FZ(I)=FZ(I)-FCOFFz*dMduz(I,nnz)*AQX(I,nnx)*AQY(I,nny)*DARQ(nnx,nny,nnz)
                UIII=2.0d0*QCOFF*ZII(I)*AQX(I,nnx)*AQY(I,nny)*AQZ(I,nnz)*DARQ(nnx,nny,nnz)
                UIC(I)=UIC(I)+UIII
                UI(I)=UI(I)+UIII
              enddo
            enddo
          enddo
!
!write(*,*)'FX',FX(I)
!write(*,*)'FY',FY(I)
!write(*,*)'FZ',FZ(I)
!read(*,*)
       end do         !I
     end do !IO
   endif
!     -------------------------------------------- Calculate 3-body term          
  if (n3bp > 0)  then                                                        
    do io = 1, ncompo                                                     
      ijk = 0                                                                  
      do  n = 1, n3bp                                                          
        if (io == i3bp(2,n))  ijk = n    ! searching center atoms
      end do                                                                   
      if (ijk == 0)  cycle               ! if io /= a center atom  then cycle
!                                                                                                                                      
      do i=ions(1,io), ions(2,io)                                          
        mm = idatom(101,i)                ! idatom(101,i) : number of atoms near the center atom
        if (mm <= 1)  cycle                                               
!           ------------------------------------- sorting with distrance          
        do j = 1, mm-1                                                   
          do k = j+1, mm                                                 
            if (ddatom(j,i) > ddatom(k,i)) then !ddatom (j,i) : distance between i and j
              ddd         = ddatom(j,i)                                 
              ddatom(j,i) = ddatom(k,i)                                 
              ddatom(k,i) = ddd                                         
              kkk         = idatom(j,i)                                 
              idatom(j,i) = idatom(k,i)                                 
              idatom(k,i) = kkk                                         
            end if                                                          
          enddo
        enddo                                                             
!                                                                                 
420     pix = px(i)                                    
        piy = py(i)                                    
        piz = pz(i)                                    
        do jj = 1, mm-1                                                  
          jo = idatom(jj,i) / 1000000                                        
          j  = mod(idatom(jj,i),1000000)                                     
          RX = PIX - PX(J)                                               
          RY = PIY - PY(J)                                               
          RZ = PIZ - PZ(J)                                               
          IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
          IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
          IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
          D1AXYZ(1) = RX * BOX(1)                                        
          D1AXYZ(2) = RY * BOX(2)                                        
          D1AXYZ(3) = RZ * BOX(3)                                        
          D1ATOM    = sqrt(d1axyz(1)**2 + d1axyz(2)**2 + d1axyz(3)**2)                  
          do kk = jj+1, mm                                                 
            ko = idatom(kk,i) / 1000000                                        
            k  = mod(idatom(kk,i),1000000)                                     
            RX = PIX - PX(k)                                               
            RY = PIY - PY(k)                                               
            RZ = PIZ - PZ(k)                                               
            IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
            IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
            IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
            D2AXYZ(1) = RX * BOX(1)                                        
            D2AXYZ(2) = RY * BOX(2)                                        
            D2AXYZ(3) = RZ * BOX(3)                                        
            D2ATOM    = sqrt(d2axyz(1)**2 + d2axyz(2)**2  + d2axyz(3)**2)                  
!                                                                                 
            DO N = 1, N3BP                                                 
              IF (io == I3BP(2,N) .AND. jo == i3BP(1,N) .and. &                
                  jo == ko        .and. ko == i3BP(3,N)) then                 
                if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(1,n) )  then                           
!                      -------------------------- 3-body potential B-A-B          
!                                                                                 
                  CALL  THREEP  (I,j,k, n)                           
!                                                                                 
                end if                                                     
              END IF                                                          
!                                                                                 
              IF (IO == I3BP(2,N)       .AND. JO == i3BP(1,n) .and. &           
                      i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(3,n)) then           
!                      ------------------------------------ 3-body B-A-C          
!                                                                                 
                if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(2,n) )  then                           
                  call  threeq  (I,j,k, N)                
                end if                                                     
              end if                                                          
!                                                                                 
              IF (IO == I3BP(2,N)       .AND. JO == i3BP(3,n) .and.  &
                  i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(1,n)) then           
!                      ------------------------------------ 3-body C-A-B          
!                                                                                 
                if (d1atom <= r3lim(2,n) .and. d2atom <= r3lim(1,n) )  then                           
                     dtmp = d1atom
                     d1atom = d2atom
                     d2atom = dtmp
                     dtmpxyz(:) = d1axyz(:)
                     d1axyz(:) = d2axyz(:)
                     d2axyz(:) = dtmpxyz(:)
                  call  threeq  (I,k,j, N)                
                     dtmp = d1atom
                     d1atom = d2atom
                     d2atom = dtmp
                     dtmpxyz(:) = d1axyz(:)
                     d1axyz(:) = d2axyz(:)
                     d2axyz(:) = dtmpxyz(:)
                end if                                                     
              end if                                                          
            enddo                                                           
          enddo                                                              
        enddo                                                              
      enddo                                                                 
    enddo                                                                    
  end if                                                                      
!
!     ------------------------------------------------------------------
  VAL(3)  = VAL(3)  + VALnn( 3)*1.0D-8 + VALnnC(1)
  VAL(4)  = VAL(4)  + VALnn( 4)*1.0D-8 + VALnnC(2)
  VAL(5)  = VAL(5)  + VALnn( 5)*1.0D-8 + VALnnC(3)
  VAL(6)  = VAL(6)  + VALnn( 6)*1.0D-8 + VALnnC(4)
  VAL(7)  = VAL(7)  + VALnn( 7)*1.0D-8 + VALnnC(5)
  VAL(8)  = VAL(8)  + VALnn( 8)*1.0D-8 + VALnnC(6)
  VAL(9)  = VAL(9)  + VALnn( 9)
  VAL(10) = VAL(10) + VALnn(10)
  VAL(11) = VAL(11) + VALnn(11)
  PRSTC2(1) = VALnnC(1)
  PRSTC2(2) = VALnnC(2)
  PRSTC2(3) = VALnnC(3)
  PRSTC2(4) = VALnnC(4)
  PRSTC2(5) = VALnnC(5)
  PRSTC2(6) = VALnnC(6)
!
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(23) == 'DIATOMIC  ')  CALL  EWALD_of_DiAtoms
!
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(29) == 'POLYATOMS ')  CALL  EWALD_of_PolyAtoms
!
!     ---------------------------------------------- RDF for dummy atoms
  IN = 0
  NNCOMPO=NCOMPO; if (iwatpol == 1) NNCOMPO=NCOMPO+1 !AdvanceSoft(July2018)
  DO IO = 1, NNCOMPO
    DO JO = 1, IO
      IN = IN + 1
      IF (IION(IO) > -998 .AND. NION(JO) > -998) cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)  cycle
      IF (IO == JO         .AND. NION(IO) <= 1)  cycle
      IRDF(:) = 0
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
      DO I = I1, I2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
!T                 DO 740  K = 1, 8
!T                     RX = ABS(PIX - PX(J) + TRANSX(K))
!T                     RY = ABS(PIY - PY(J) + TRANSY(K))
!T                     RZ = ABS(PIZ - PZ(J) + TRANSZ(K))
!T                     DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                     DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                     DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = ABS(PIX - PX(J))
          DY = ABS(PIY - PY(J))
          DZ = ABS(PIZ - PZ(J))
!T                     - - - - - delete these if-statements for triclinic
          IF (ABS(DX) > 0.5)  DX = 1.0 - DX
          IF (ABS(DY) > 0.5)  DY = 1.0 - DY
          IF (ABS(DZ) > 0.5)  DZ = 1.0 - DZ
          RIJ2 = (DX * BOX(1))**2 + (DY * BOX(2))**2  + (DZ * BOX(3))**2
          IF (RIJ2 <= RCUT2)  GO TO 755
!T 740             CONTINUE
          GO TO 750
  755     CONTINUE
          IP0 = INT( SQRT(RIJ2) * 100.0 )
          if (IP0 > LTB+1) write(*,*)'IP0 > LTB+1',IP0,LTB+1 
          IF (IP0 < 1)  IP0 = 1
          IRDF(IP0) = IRDF(IP0) + 1
  750   enddo
      enddo
      DO L = 1, NRCUT(1)
        NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
      enddo
    enddo
  enddo
  RETURN
END
!
!
!                                                             ==========
!=============================================================== EWALDP2
SUBROUTINE  EWALDP2  (myrank, mpsize)
!
!     ===== This subroutine is for CPU's with myrank of greater than 0.
!     =====                          (SLAVE process)
!
  use param
  use atomsi
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use vector
  use radial
  use forces
  use cartes
  use molecu
  use quanco
  use ewal
  use charge
  use datoms
  use pos
!
!  implicit none
!
!
  integer*4   iii(3), jjjj
  double precision   VAL0N(11), VAL0NC(7)
  double precision   rrr(7,2)
  integer*4  ierr,idiatom,iquantum,ibmhexp,iwatpol,i,myrank,mpsize
  integer*4  ispme         !SPME
!
  include  'mpif.h'
  integer*4  status(MPI_STATUS_SIZE)
!
call EWALDP2_NEW( myrank, mpsize ); return
1111 CONTINUE
  call MPI_Bcast (irecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (idiatom,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (iquantum,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ibmhexp,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (iwatpol,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)  !WATER-POL
  call MPI_Bcast (iatomo,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !WATER-POL
  call MPI_Bcast (ispme,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !SPME     
  call MPI_Bcast (NTION,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NION(1),              lemw,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IION(1),              lemw,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IONS(1,1),          lemw*2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NCOMPO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NPAIR,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (WIO(1),               lemw,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ZIO(1),               lemw,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NDMOLE,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ZIIP(1),      ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !WATER-POL
  call MPI_Bcast (RSWTCH(1),             lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (CIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (DIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (D4IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (D7IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (N3BP,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (I3BP(1,1),           L3P*3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ANG3BP(1),             L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (FK3BP(1),              L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (R3BGRD(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (R3BLIM(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (R3LIM(1,1),          L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (E1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (Q1U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (Q2U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (ZMOLE(1),                2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (DMOLE(1,1),        4*NTION,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (DINTRA,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IDMOLE(1,1),3*NTION+NDMOLE,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (IATOM2(1),               2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (NVNx,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
  call MPI_Bcast (NVNy,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
  call MPI_Bcast (NVNz,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
  if (ispme == 1) then
       allocate(PNVxx(NVNx,NVNy,NVNz),PNVyy(NVNx,NVNy,NVNz),PNVzz(NVNx,NVNy,NVNz))
       allocate(PNVxy(NVNx,NVNy,NVNz),PNVxz(NVNx,NVNy,NVNz),PNVyz(NVNx,NVNy,NVNz))
       allocate(THREC(NVNx,NVNy,NVNz))
       allocate(ARQ(NVNx,NVNy,NVNz))
       allocate(DARQ(NVNx,NVNy,NVNz))
  endif
!
2222 continue
!
  call MPI_Bcast (iii(1),                  3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  nrcut(1) = iii(1)
  nrcut(2) = iii(2)
  NVN      = iii(3)
  if (NVN < -9000)  go to 9999
!
  if (ispme == 1) then !SPME
      call MPI_Bcast (ARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
      call MPI_Bcast (DARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
      call MPI_Bcast (THREC(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
      call MPI_Bcast (PNVxx(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVyy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVzz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVxy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVxz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (PNVyz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      call MPI_Bcast (QCOFF,                  1, MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  endif
  call MPI_Bcast (KRDF,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !WATER-POL
!
  if (KRDF == 2) goto 1112     !WATER-POL
!
  call MPI_Bcast (ZII(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !WATER-POL
  call MPI_Bcast (nrecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  if (ispme == 0) then
    call MPI_Bcast (NVEC(1,1),           3*NVN,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (UNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (PNV(1,1),            6*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  endif
  call MPI_Bcast (rrr(1,1),               14,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  do i=1, 6
    box(i)  = rrr(i,1)
    rbox(i) = rrr(i,2)
  end do
  rcut(1) = rrr(7,1)
  rcut(2) = rrr(7,2)
  call MPI_Bcast (E0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  call MPI_Bcast (PX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (r3limax,                 1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
    VAL0N(:) = 0.0D0
!
    VAL0NC(:) = 0.0D0
!
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
      NRDF(:,:) = 0
!
  do i = 1, 4
    av3bp(1,i) = 0.0D0
    av3bp(2,i) = 0.0D0
  enddo
!
!  PI2   = PI * 2.0D0
!
  do i = 1, ntion + ndmole   !water-pol
    UI(i) = 0.0D0
    FX(i) = 0.0D0
    FY(i) = 0.0D0
    FZ(i) = 0.0D0
    UIc(i) = 0.0D0  !water-pol
  enddo
!
!     ------------------------------------------ Coulomb reciprocal term
!     ------------------------------------ Coulmb direct and short range
!
  call  EWALDP3  (idiatom, iquantum, iwatpol, ispme, val0n, val0NC,myrank, mpsize)
!
  val0n(2) = virlsr
!
!  call MPI_Recv  (iii, 1, MPI_INTEGER, 0, myrank, MPI_COMM_WORLD,status,ierr)
  call MPI_Recv  (jjjj,                    1,         MPI_INTEGER4,0,myrank,MPI_COMM_WORLD,status,ierr)
  call MPI_Ssend (val0N(1),               11,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  val0NC(7) = tqce
  call MPI_Ssend (val0NC(1),               7,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (ui(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (FX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (FY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (FZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (uic(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)   !WATER-POL
  call MPI_Ssend (NRDF(1,1),       ltb*NPAIR,        MPI_INTEGER4,0,myrank,MPI_COMM_WORLD,ierr)
  call MPI_Ssend (idatom(1,1),101*(ntion+ndmole),     MPI_INTEGER4,0,myrank,MPI_COMM_WORLD,ierr)  !WATER-POL
!
  call MPI_Ssend (ddatom(1,1),100*(ntion+ndmole),MPI_DOUBLE_PRECISION,0,myrank,MPI_COMM_WORLD,ierr)   !WATER-POL
  if (ispme == 1) then !SPME
    call MPI_Ssend (DARQ(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,myrank,MPI_COMM_WORLD,ierr)
  endif
!
!
1112 CONTINUE
!
!
  goto 2222
!
9999 call  MPI_Finalize  (ierr)
  STOP
END
!
!
!                                                             ==========
!=============================================================== EWALDP3
SUBROUTINE  EWALDP3  (idiatom, iquantum, iwatpol, ispme, valnn, VAL0NC,myrank, mpsize)
!
!     ===== This subrotine is for both the CPU's with myrank 0 and <>0.
!     =====                              (MASTER and slave processes)
!
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use vector
  use radial
  use forces
  use cartes
  use molecu
  use quanco
  use ewal
  use charge
  use datoms
  use pos
!
!  use, intrinsic :: iso_c_binding   !SPME

  implicit none
!
!  include 'fftw3-mpi.f03'     !SPME
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
  integer(KIND=4)  IRDF(LTB+1)
  double precision  VALnn(11),VAL0NC(7)
  double precision  PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  double precision  PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ,FSIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,UII,EIJ,ESIJ
  double precision  RIJ, RIJ2, RCUT2, SCCSS, zizj
  double precision  E2(LSR),F2(LSR)
  double precision  Q1U2(LSR),Q2U2(LSR),QCEIJ,ANWIO,ANWJO,QS1,QS2
  double precision  ECDD, FCDD
  double precision  arij, arij2, arij3, arij4
  double precision  sdx(lni),sdy(lni),sdz(lni), srij2(lni),srij(lni)
  double precision  UIIC
  double precision  EIJC
  integer(KIND=4)  isj(lni)
  integer*4  i, NNCOMPO,idiatom,iquantum,iwatpol,in, myrank, io, i1, i2
  integer(KIND=4)  max_nsatom,jo,k,mpsize,j1,j2,nsatom,j,jj,ip0,ip1,ip2,L,idd
! ---------------------------------------------------------SPME
  integer(C_INTPTR_T) :: NVX,NVY,NVZ
  type(C_PTR) :: plan, cdata
  complex(C_DOUBLE_COMPLEX), pointer :: ARQL(:,:,:)
  integer(C_INTPTR_T) :: JX,JY,JZ,alloc_local,local_NVNz,local_NVNz_offset
  integer ispme !,MPI_COMM_WORLD !AdvanceSoft(July2018)
  include 'mpif.h'               !AdvanceSoft(July2018)
  double precision enerec
  call EWALDP3_NEW( idiatom, iquantum, iwatpol, ispme, valnn, VAL0NC,myrank, mpsize ); return
! ---------------------------------------------------------SPME
!
!                                PI2   = PI * 2.0D0
idd = 0
!
      ddatom(:,:) = 0.0d0
      idatom(:,:) = 0
!
  NNCOMPO = NCOMPO
!
  if(iwatpol == 1) then
    NNCOMPO = NCOMPO + 1
  ENDIF
!
  if(ispme == 0) then   ! not SPME, traditional EWALD
    IF (NVN <= 0)   GO TO 200
!  
    DO I = 1, NTION + ndmole
      ZICOS(I) = 0.0D0
      ZISIN(I) = 0.0D0
    enddo
!  
    do in = myrank+1, NVN, mpsize
      SICOS = 0.0D0
      SISIN = 0.0D0
      DX = dble(NVEC(1,IN)) * PI2
      DY = dble(NVEC(2,IN)) * PI2
      DZ = dble(NVEC(3,IN)) * PI2
      DO IO = 1, NNCOMPO
        IF (IION(IO) < -998)  cycle
        IF (NION(IO) > 0 ) THEN           !WATER-POL
          I1 = IONS(1,IO)
          I2 = IONS(2,IO)
!  !        ZJ = ZIO(IO)
          DO I = I1, I2
            PHI     = DX*PX(I) + DY*PY(I) + DZ*PZ(I)
            ZICOS(I) = COS(PHI) * ZII(I)               !WATER-POL
            SICOS    = SICOS + ZICOS(I)
            ZISIN(I) = SIN(PHI) * ZII(I)               !WATER-POL
            SISIN    = SISIN + ZISIN(I)
          enddo
        END IF
      enddo
      if (idiatom == 1)  then
        I1 = ntion+1
        I2 = ntion + ndmole
        DO I = I1, I2
          PHI      = DX*PX(I) + DY*PY(I) + DZ*PZ(I)
          ZICOS(I) = COS(PHI) * Zii(i)
          SICOS    = SICOS + ZICOS(I)
          ZISIN(I) = SIN(PHI) * Zii(i)
          SISIN    = SISIN + ZISIN(I)
        enddo
      end if
!  
      FSICOS = FNV(IN) * SICOS
      FSISIN = FNV(IN) * SISIN
      USICOS = UNV(IN) * SICOS
      USISIN = UNV(IN) * SISIN
      SCCSS  = SICOS**2 + SISIN**2
!  
      VALnn(9)  = VALnn(9)  + UNV(IN)   * SCCSS
      VAL0NC(1) = VAL0NC(1) + PNV(1,IN) * SCCSS
      VAL0NC(2) = VAL0NC(2) + PNV(2,IN) * SCCSS
      VAL0NC(3) = VAL0NC(3) + PNV(3,IN) * SCCSS
      VAL0NC(4) = VAL0NC(4) + PNV(4,IN) * SCCSS
      VAL0NC(5) = VAL0NC(5) + PNV(5,IN) * SCCSS
      VAL0NC(6) = VAL0NC(6) + PNV(6,IN) * SCCSS
      FIX    = dble(NVEC(1,IN)) * RBOX(1)
      FIY    = dble(NVEC(2,IN)) * RBOX(2)
      FIZ    = dble(NVEC(3,IN)) * RBOX(3)
      DO I = 1, NTION + ndmole
        UI(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UI(I)
        UIC(I) = UI(I)                                           !WATER-POL
        FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
        FX(I) = FX(I) + FIJ * FIX
        FY(I) = FY(I) + FIJ * FIY
        FZ(I) = FZ(I) + FIJ * FIZ
      enddo
    enddo
!  
    valnn(9) = valnn(9) * 0.5D0
  endif
!  if (ispme == 1) then   !------------------------------SPME
!!
!    call fftw_mpi_init
!!
!    NVX=NVNx
!    NVY=NVNy
!    NVZ=NVNz
!    DARQ(:,:,:)=(0.0d0,0.0d0)
!!
!    alloc_local = fftw_mpi_local_size_3d(NVZ,NVY,NVX,MPI_COMM_WORLD,local_NVNz,local_NVNz_offset)
!!write(*,*)myrank
!!write(*,*)local_NVNz
!!write(*,*)local_NVNz_offset
!    call parallel_data_utility( local_NVNz, local_NVNz_offset, "push" )
!    cdata=fftw_alloc_complex(alloc_local)
!    call c_f_pointer(cdata,ARQL,[NVX,NVY,local_NVNz])
!
!    plan=fftw_mpi_plan_dft_3d(NVZ,NVY,NVX,ARQL,ARQL,MPI_COMM_WORLD,FFTW_FORWARD,FFTW_ESTIMATE) !Reversing array dimensions
!!
!    do JZ = 1,local_NVNz
!      do JY = 1,NVY
!        do JX = 1,NVX
!          ARQL(JX,JY,JZ) = ARQ(JX,JY,JZ + local_NVNz_offset)
!        end do
!      end do
!    end do 
!!
!!
!    call fftw_mpi_execute_dft(plan,ARQL,ARQL)
!!
!    do JZ = 1,local_NVNz
!      do JY = 1,NVY
!        do JX = 1,NVX
!          enerec=THREC(JX,JY,JZ+local_NVNz_offset)*ABS(ARQL(JX,JY,JZ))**2
!          VALnn(9)  = VALnn(9)  + enerec
!          VAL0NC(1) = VAL0NC(1) + enerec*PNVxx(JX,JY,JZ+local_NVNz_offset)
!          VAL0NC(2) = VAL0NC(2) + enerec*PNVyy(JX,JY,JZ+local_NVNz_offset)
!          VAL0NC(3) = VAL0NC(3) + enerec*PNVzz(JX,JY,JZ+local_NVNz_offset)
!          VAL0NC(4) = VAL0NC(4) + enerec*PNVxy(JX,JY,JZ+local_NVNz_offset)
!          VAL0NC(5) = VAL0NC(5) + enerec*PNVxz(JX,JY,JZ+local_NVNz_offset)
!          VAL0NC(6) = VAL0NC(6) + enerec*PNVyz(JX,JY,JZ+local_NVNz_offset)
!          ARQL(JX,JY,JZ) = THREC(JX,JY,JZ + local_NVNz_offset)*ARQL(JX,JY,JZ)
!        end do
!      end do
!    end do 
!!
!    VALnn(9)  = VALnn(9)*QCOFF
!    VAL0NC(1) = VAL0NC(1)*QCOFF 
!    VAL0NC(2) = VAL0NC(2)*QCOFF 
!    VAL0NC(3) = VAL0NC(3)*QCOFF 
!    VAL0NC(4) = VAL0NC(4)*QCOFF 
!    VAL0NC(5) = VAL0NC(5)*QCOFF 
!    VAL0NC(6) = VAL0NC(6)*QCOFF 
!!
!!write(*,*)VALnn(9),myrank,QCOFF
!
!    call fftw_destroy_plan(plan)
!!
!    plan=fftw_mpi_plan_dft_3d(NVZ,NVY,NVX,ARQL,ARQL,MPI_COMM_WORLD,FFTW_BACKWARD,FFTW_ESTIMATE) !Reversing array dimensions
!    call fftw_mpi_execute_dft(plan,ARQL,ARQL)
!!
!    do JZ = 1,local_NVNz
!      do JY = 1,NVY
!        do JX = 1,NVX
!          DARQ(JX,JY,JZ+local_NVNz_offset) = ARQL(JX,JY,JZ)
!        end do
!      end do
!    end do 
!!
!    call fftw_destroy_plan(plan)
!    call fftw_free(cdata)
!  endif
!--------------------------------------------SPME
!
!
!     --------------- Coulomb direct lattice space and short range terms
!

!
200 RCUT2 = RCUT(1) * RCUT(1)
  max_nsatom = 0
  IN = 0
  DO IO = 1, NNCOMPO
    DO JO = 1, IO
      IN = IO*(IO-1)/2 + JO
      IF (IO < JO)  IN = JO*(JO-1)/2 + IO
      IF (IION(IO) <= -998 .OR.  IION(JO) <= -998)  cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)     cycle
      IF (IO == JO         .AND. NION(IO) <= 1)     cycle
!
!      ZIZJ = ZIO(IO) * ZIO(JO)
      DO K = 1, NRCUT(2)
        E2(K) = E1(K,IN)
        F2(K) = F1(K,IN)
      enddo
      IF (iQUANTUM == 1)  THEN
        DO K = 1, NRCUT(2)
          Q1U2(K) = Q1U1(K,IN)
          Q2U2(K) = Q2U1(K,IN)
        enddo
        QCEIJ = 0.0D0
      END IF
      IRDF(:) = 0
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
!
!         write (6,*)  io,jo
!
      if (i1+myrank > i2)  go to 322
      DO I = I1+myrank, I2, mpsize
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0D0      !WATER-POL
        nsatom = 0
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
          RX = PIX - PX(J)
          RY = PIY - PY(J)
          RZ = PIZ - PZ(J)
          IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)
          IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)
          IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)
          DX = RX * BOX(1)
          DY = RY * BOX(2)
          DZ = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          IF (RIJ2 <= RCUT2)  then
            nsatom = nsatom + 1
            isj(nsatom)   = j
            sDX(nsatom)   = dx
            sDY(nsatom)   = dy
            sDZ(nsatom)   = dz
            sRIJ2(nsatom) = rij2
          end if
        enddo
!
        if (max_nsatom < nsatom)  max_nsatom = nsatom
!
!             write (6,*)  'nsatom=',nsatom
!
        do jj = 1, nsatom
          j    = isj(jj)
          dx   = sDX(jj)
          dy   = sDY(jj)
          dz   = sDZ(jj)
          rij2 = srij2(jj)
          rij  = DSQRT(RIJ2)
          ARIJ = 1.0D0 / RIJ
          srij(jj) = rij
          ZIZJ = ZII(i)*ZII(j)                                !WATER-POL
!         ------------------------------------ Interpolation
          IP0 = INT(RIJ*100.0d0)
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = dble(IP0) * 0.01D0
          R01 = dble(IP1) * 0.01D0
          R02 = dble(IP2) * 0.01D0
!                     X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                     X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                     X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0D0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0D0
          FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
          EIJC = EIJ                                      !WATER-POL
          VALnn(9) = VALnn(9) + EIJ
!         ---------- Charge-dipole and dipole-induced dipole
          IF (RIJ > RSWTCH(IN) .and. &
              abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0) then
            ARIJ2 = ARIJ * ARIJ
            ARIJ3 = ARIJ2 * ARIJ
            ARIJ4 = ARIJ3 * ARIJ
            ECDD = (- CIJ(IN)*ARIJ2 - DIJ(IN)*ARIJ4  &
                    - D4IJ(IN) - D7IJ(IN)*ARIJ3)*ARIJ4
            FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +  &
                      8.0D0*DIJ(IN) *ARIJ2*ARIJ3 + &
                      4.0D0*D4IJ(IN)*ARIJ + &
                      7.0D0*D7IJ(IN)*ARIJ4 )*ARIJ4 &
                      * ARIJ*1.0D8
            EIJ   = EIJ + ECDD
            FIJ   = FIJ + FCDD
            VALnn(10) = VALnn(10) + ECDD
            VIRLSR    = VIRLSR + FCDD*RIJ2
          END IF
!         ------------------------- Short range interactions
          ESIJ = 0.0D0
          FSIJ = 0.0D0
          IF (RIJ <= RCUT(2))  THEN
!           ---------------------------- Interpolation
            FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
            ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!           ------------------------------------------
            FIJ  = FIJ + FSIJ
            EIJ  = EIJ + ESIJ
            VALnn(10) = VALnn(10)  + ESIJ
            VIRLSR = VIRLSR + FSIJ*RIJ2
          END IF
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJC               !WATER-POL
          UI(J) = UI(J) + EIJ
          UIC(J) = UIC(J) + EIJC                       !WATER-POL
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VALnn(3) = VALnn(3) + DFX * DX
          VALnn(4) = VALnn(4) + DFY * DY
          VALnn(5) = VALnn(5) + DFZ * DZ
          VALnn(6) = VALnn(6) + DFX * DY
          VALnn(7) = VALnn(7) + DFX * DZ
          VALnn(8) = VALnn(8) + DFY * DZ
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
        UIC(I) = UIC(I) + UIIC                     !WATER-POL
        do jj = 1, nsatom
          IP0 = INT(sRIJ(jj)*100.0d0)
          IRDF(IP0) = IRDF(IP0) + 1
          if (srij(jj) <= r3limax)  then
            idatom(101,i)= idatom(101,i) + 1  
            ddatom(idatom(101,i),i) = srij(jj)
            idatom(idatom(101,i),i) = isj(jj) + jo*1000000
            j=isj(jj)
            idatom(101,j)= idatom(101,j) + 1
            ddatom(idatom(101,j),j) = srij(jj)
            idatom(idatom(101,j),j) = i + io*1000000
          end if
        enddo
!             ---------------------------------- Quantum correction term
        IF (iquantum == 1)  THEN
          DO J = 1, NsATOM
            RIJ = srij(J)
            IF (RIJ <= RCUT(2))  THEN
              IP0 = INT(RIJ*100.0)
              IP1 = IP0 + 1
              IP2 = IP0 + 2
              R00 = IP0 * 0.01
              R01 = IP1 * 0.01
              R02 = IP2 * 0.01
!                        X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                        X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                        X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
              X0  = (RIJ-R01)*(RIJ-R02) *    5000.0
              X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0)
              X2  = (RIJ-R00)*(RIJ-R01) *    5000.0
              QS1 = Q1U2(IP0)*X0 +Q1U2(IP1)*X1 +Q1U2(IP2)*X2
              QS2 = Q2U2(IP0)*X0 +Q2U2(IP1)*X1 +Q2U2(IP2)*X2
!
!Q                       ARIJ = 1.0D0 / RIJ
!                        ------------ Short range rep. and van der Waals
!Q                       QS1 = -EXP((AIJ(IN) - RIJ) / BIJ(IN)) * 1.0E8
!Q                       QS2 = -QS1 / BIJ(IN) * 1.0E8
!                        --------------------------------- Van der Waals
!Q                       QVW =       6.0 * CIJ(IN) * ARIJ**7 * 1.0E8
!Q                       QS1 = QS1 + QVW
!Q                       QS2 = QS2 - 7.0 * QVW     * ARIJ    * 1.0E8
!                        ------------------------------------ Morse term
!Q                       QMS1 = 0.0
!Q                       QMS2 = 0.0
!Q                       IF (DMIJ(IN) > 0.001) THEN
!Q                             D2  = DMIJ(IN) * 2.0D0
!Q                             AM1 = EXP(-2.0D0*BEIJN*(RIJ-RSIJ(IN)))
!Q                             AM2 = EXP(-1.0D0*BEIJN*(RIJ-RSIJ(IN)))
!Q                             QMS1= D2*BEIJN    * (   -AM1+AM2) *1.0E8
!Q                             QMS2= D2*BEIJN**2 * (2.0*AM1-AM2) *1.0E16
!Q                       END IF
!Q                       QS1 = (QS1 + QMS1) *BETA *ARIJ*1.0E8
!Q                       QS2 = (QS2 + QMS2) *BETA
!
              QCEIJ = QCEIJ + ( 2.0*QS1 + QS2 )
            end if
          enddo
        END IF
      enddo
!
!
322   IF (IQUANTUM == 1)  THEN
        ANWIO = ANA / WIO(IO)
        ANWJO = ANA / WIO(JO)
!                ------------------------------------ QCEij : nabla(Uij)
!                                            TQCE : sum of nabla(Uij)/mi
        TQCE   = TQCE   + QCEIJ*ANWIO + QCEIJ*ANWJO
      END IF
      IF (iwatpol == 1) then
        IF (MOD(NRECRD(1),IRECRD(5)) == 0 .and. KRDF == 1) THEN
          DO  L = 1, NRCUT(1)
            NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
          end do
        end if
      endif
      IF (iwatpol /= 1) then
        IF (MOD(NRECRD(1),IRECRD(5)) == 0 ) THEN
          DO  L = 1, NRCUT(1)
            NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
          end do
        end if
      endif
    enddo
  enddo
  RETURN
END
!
!
!                                                  =====================
!==================================================== POLH2O
SUBROUTINE  POLH2O
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use cartes
  use molecu
  use charge
  use pos
  use ewal
  use temprs
!
  implicit none
!
  double precision  upol_dp
  double precision  diperror,dipX,dipY,dipZ,maxd,dipoldp,sumdipol
  double precision  ZIIH1,ZIIH2,ZIIL1,ZIIL2
  double precision  dipole2,UICO,Edp
  integer(KIND=4)  i,k,m,io,lp1,lp2,no
!
! -------------------------------------------------------------------
! -------------------------------------------------------------------
!
!  Here calculate dipole moments and new charge
!
  upol      = 0.0D0
  upol_dp   = 0.0D0
  maxedip   = 0.0D0
  maxd      = 0.0D0
  sumdipol  = 0.0D0
  sumedip   = 0.0d0
!
  if (JJJ /= 1 .or. NRECRD(3) <= 4) then
    do i = 1, ntion+ndmole
      if (i >= ions(1,iatomo) .and. i <= ions(2,iatomo)) cycle
      UIC(I) = 0.5D0*UIC(I)/ZII(I)   ! Potential -> Potential/q
    enddo
  endif
!
!
  if (JJJ == 1 .and. NRECRD(3) > 4) then
!   --------------------------------------------------Predict electric fields
    no = 0
    do io = ions(1,IATOMO),ions(2,IATOMO)
      no = no + 1
      k = ih2o(2,no)
      m = ih2o(3,no)
      lp1 = ih2o(4,no)
      lp2 = ih2o(5,no)
      UIC(k)   = 4.0D0*UICP1(k)  -6.0D0*UICP2(k)  +4.0D0*UICP3(k)  -UICP4(k)
      UIC(m)   = 4.0D0*UICP1(m)  -6.0D0*UICP2(m)  +4.0D0*UICP3(m)  -UICP4(m)
      UIC(lp1) = 4.0D0*UICP1(lp1)-6.0D0*UICP2(lp1)+4.0D0*UICP3(lp1)-UICP4(lp1)
      UIC(lp2) = 4.0D0*UICP1(lp2)-6.0D0*UICP2(lp2)+4.0D0*UICP3(lp2)-UICP4(lp2)
!
      ZIIH1 = ZII(k) - ZIIP(k)
      ZIIH2 = ZII(m) - ZIIP(m)
      ZIIL1 = ZII(lp1) -ZIIP(lp1)
      ZIIL2 = ZII(lp2) -ZIIP(lp2)
      pdipX(no) = ZIIH1*DPX1(no)+ZIIH2*DPX2(no) +(ZIIL1 - ZIIL2)*LOP1X(no)
      pdipY(no) = ZIIH1*DPY1(no)+ZIIH2*DPY2(no) +(ZIIL1 - ZIIL2)*LOP1Y(no)
      pdipZ(no) = ZIIH1*DPZ1(no)+ZIIH2*DPZ2(no) +(ZIIL1 - ZIIL2)*LOP1Z(no)
    enddo
  endif
!
  no = 0
  do io = ions(1,IATOMO), ions(2,IATOMO)
    no = no + 1
    k = ih2o(2,no)
    m = ih2o(3,no)
    lp1 = ih2o(4,no)
    lp2 = ih2o(5,no)
!
    E34(no) = -1.0d0*(UIC(lp1)-UIC(lp2)) / DLP    ! 4 -> 3
    UICO = 0.5d0*(UIC(lp1)+UIC(lp2))
    Edp1(no) = (UICO-UIC(k))/roh1(no)             ! O -> H1
    Edp2(no) = (UICO-UIC(m))/roh2(no)             ! O -> H2
    Edp = sqrt( &
               (Edp1(no)*UDPX1(no)+Edp2(no)*UDPX2(no))**2 + &
               (Edp1(no)*UDPY1(no)+Edp2(no)*UDPY2(no))**2 + &
               (Edp1(no)*UDPZ1(no)+Edp2(no)*UDPZ2(no))**2)
!
!   Damping of polarizability
!
    watpol(1,no) = WATPOLDP
    watpol(2,no) = WATPOLLP    
!
!
    IF (Edp > Ediv) then
      watpol(1,no) = ECOFF*(DMAX-DMAX/(exp(GEb_pol*(Edp-Emb_pol))+1.0d0))/Edp
    endif
!    IF (abs(E34(no)) > Ediv) then
!      watpol(2,no) = ECOFF*(DMAX-DMAX/(exp(GEb_pol*(abs(E34(no))-Emb_pol))+1.0d0))/abs(E34(no))
!    endif
!
!   ---------------------------------------------In plane
    QHHk(no) = watpol(1,no)*Edp1(no)/roh1(no)*POL
    QHHm(no) = watpol(1,no)*Edp2(no)/roh2(no)*POL
    QLPx(no) = -0.5d0*(QHHk(no)+QHHm(no))
!
!   O -> H1
    idipX(2,no) = QHHk(no)*DPX1(no)
    idipy(2,no) = QHHk(no)*DPY1(no)
    idipz(2,no) = QHHk(no)*DPZ1(no)
!   O -> H2
    idipX(3,no) = QHHm(no)*DPX2(no)
    idipy(3,no) = QHHm(no)*DPY2(no)
    idipz(3,no) = QHHm(no)*DPZ2(no)
!
!   ---------------------------------------------LP direction
    QLP1z(no) =  watpol(2,no)*E34(no)/DLP*POL
    QLP2z(no) = -1.0d0*QLP1z(no)
    idipX(4,no) = QLP1z(no)*2.0d0*LOP1X(no)
    idipy(4,no) = QLP1z(no)*2.0d0*LOP1Y(no)
    idipz(4,no) = QLP1z(no)*2.0d0*LOP1Z(no)
!   ------------------------------------------Induced charges of Lone pairs
    QLP1(no) = (QLP1z(no) + QLPx(no))
    QLP2(no) = (QLP2z(no) + QLPx(no))
!   ------------------------------------------RESULTS:Charges 
    ZII(io) = 0.0D0
    ZII(k)  = ZIIP(k)  + QHHk(no)
    ZII(m)  = ZIIP(m)  + QHHm(no)
    ZII(lp1) = ZIIP(lp1) + QLP1(no)
    ZII(lp2) = ZIIP(lp2) + QLP2(no)
!   ----------------------------------------------------------
    if (ZII(lp1) > 0.0D0 .or. ZII(lp2) > 0.0D0 .or. ZII(k) < 0.0D0 .or. ZII(m) < 0.0D0) then
      write(*,*)'Charge is unrealistic !!! upol could be uncorrect !!!'
!      ZII(k) = ZIIP(k)
!      ZII(m) = ZIIP(m)
!      ZII(lp1) = ZIIP(lp1)
!      ZII(lp2) = ZIIP(lp2)
    endif
!
    dipX = ZII(k)*DPX1(no)+ZII(m)*DPX2(no) +(ZII(lp1)-ZII(lp2))*LOP1X(no)
    dipY = ZII(k)*DPY1(no)+ZII(m)*DPY2(no) +(ZII(lp1)-ZII(lp2))*LOP1Y(no)
    dipZ = ZII(k)*DPZ1(no)+ZII(m)*DPZ2(no) +(ZII(lp1)-ZII(lp2))*LOP1Z(no)
    idipX(1,no) = QHHk(no)*DPX1(no) + QHHm(no)*DPX2(no) +(QLP1(no) - QLP2(no))*LOP1X(no)
    idipY(1,no) = QHHk(no)*DPY1(no) + QHHm(no)*DPY2(no) +(QLP1(no) - QLP2(no))*LOP1Y(no)
    idipZ(1,no) = QHHk(no)*DPZ1(no) + QHHm(no)*DPZ2(no) +(QLP1(no) - QLP2(no))*LOP1Z(no)
!
    diperror = &
       sqrt((idipX(1,no)-pdipX(no))**2 + (idipY(1,no)-pdipY(no))**2 + (idipZ(1,no)-pdipZ(no))**2) &
       *ELCC*1.0D-10/DEBYE
    if(diperror > maxedip) maxedip = diperror
    sumedip = sumedip + diperror
!
    dipole2  = ELCC**2*1.0D-20*(dipX**2 + dipY**2 + dipZ**2)
    dipoldp  = sqrt(dipole2)
    sumdipol = sumdipol + dipoldp
!
    if (dipoldp/DEBYE > maxd) maxd = dipoldp/DEBYE
!
!   -----------------------------------------------Upol
    idp2(no) = idipX(1,no)**2 + idipY(1,no)**2 + idipZ(1,no)**2
    upol_dp = upol_dp &
              + (idipX(2,no)**2+idipY(2,no)**2+idipZ(2,no)**2)/watpol(1,no)  &
              + (idipX(3,no)**2+idipY(3,no)**2+idipZ(3,no)**2)/watpol(1,no)  &
              + (idipX(4,no)**2+idipY(4,no)**2+idipZ(4,no)**2)/watpol(2,no)
!
    pdipX(no)  = idipX(1,no)
    pdipY(no)  = idipY(1,no)
    pdipZ(no)  = idipZ(1,no)
!
  enddo
!
  upol = 0.5D0 * upol_dp  /POL   !erg
  sumedip = sumedip / sqrt(dble(NION(IATOMO)))
!
  sumdipol = sumdipol/NION(IATOMO)/DEBYE
!  write(*,'("==Max Dipole Error : ", E10.3, " D", " Dipole : (MAX) ", F8.4, " D", &
!            " (AVE) ", F8.4, " D ==")') maxedip, maxd, sumdipol
  write(*,'("==rms of dipole : ", E10.3, " D", " Dipole : (MAX) ", F8.4, " D", &
            " (AVE) ", F8.4, " D ==")') sumedip, maxd, sumdipol

!
!
999 RETURN
END
!
!                                                    ===================
!====================================================== EWALD_of_DiAtoms
      SUBROUTINE  EWALD_of_DiAtoms
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use vector
  use forces
  use cartes
  use molecu
  use ewal
  use charge
  use pos
!
  implicit none
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
  double precision  PIX,DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  double precision  PIY,DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,EIJ
  double precision  VAL03, VAL04, VAL05, VAL06, VAL07, VAL08, VAL09
  double precision  VAL03C,VAL04C,VAL05C,VAL06C,VAL07C,VAL08C,VAL09C
  double precision  RIJ, RIJ2, RCUT2, SCCSS, zizj,PJX,PJY,PJZ
  double precision  pjx0,pjy0,pjz0
  double precision  pm(3,lni),zm(LNI),FM(3,LNI),um(3),VAL92,VAL91
  integer*4 II,IP0,IP1,IP2,J,IN,K,I,N,IJKL
!
!P    double precision  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    double precision  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3    /10.00464,8.426553,3.460259,0.5623536   /
!P    DATA EY0,EY1,EY2,EY3,EY4/10.00464,19.71558,15.70229,6.090749,1.0/
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  VAL09 = 0.0D0
!
  VAL03C = 0.0D0
  VAL04C = 0.0D0
  VAL05C = 0.0D0
  VAL06C = 0.0D0
  VAL07C = 0.0D0
  VAL08C = 0.0D0
  VAL09C = 0.0D0
!
!     ------------------------------------------ Coulomb reciprocal term
!
  do ijkl = 1, ndmole
    do N=1, 2
      I = IDMOLE(N,IJKL)
      ZM(N) = ZII(I)
      do K = 1, 3
        PM(K,N) = P(K,I)
      enddo
    enddo
    ZM(3) = ZMOLE(IDMOLE(3,IJKL))
    PM(1,3) = P(1,NTION+IJKL)
    PM(2,3) = P(2,NTION+IJKL)
    PM(3,3) = P(3,NTION+IJKL)
    DO I = 1, 3
      UM(I) = 0.0
      DO K = 1, 3
        FM(K,I) = 0.0
      enddo
    enddo
    IF (NVN == 0)  GO TO 200
!    PI2   = PI * 2.0D0
    DO I = 1, NTION
      ZICOS(I) = 0.0D0
      ZISIN(I) = 0.0D0
    enddo
!
    VAL09C = 0.0D0
    DO IN = 1, NVN
      SICOS = 0.0D0
      SISIN = 0.0D0
      DX = NVEC(1,IN) * PI2
      DY = NVEC(2,IN) * PI2
      DZ = NVEC(3,IN) * PI2
      DO I = 1, 3
        PHI      = DX*PM(1,I) + DY*PM(2,I) + DZ*PM(3,I)
        ZICOS(I) = COS(PHI) * ZM(i)
        SICOS    = SICOS + ZICOS(I)
        ZISIN(I) = SIN(PHI) * ZM(i)
        SISIN    = SISIN + ZISIN(I)
      enddo
!
      FSICOS = FNV(IN) * SICOS
      FSISIN = FNV(IN) * SISIN
      USICOS = UNV(IN) * SICOS
      USISIN = UNV(IN) * SISIN
      SCCSS  = SICOS**2 + SISIN**2
      VAL09C = VAL09C + UNV(IN)   * SCCSS
      VAL03C = VAL03C + PNV(1,IN) * SCCSS
      VAL04C = VAL04C + PNV(2,IN) * SCCSS
      VAL05C = VAL05C + PNV(3,IN) * SCCSS
      VAL06C = VAL06C + PNV(4,IN) * SCCSS
      VAL07C = VAL07C + PNV(5,IN) * SCCSS
      VAL08C = VAL08C + PNV(6,IN) * SCCSS
      FIX    = NVEC(1,IN) * RBOX(1)
      FIY    = NVEC(2,IN) * RBOX(2)
      FIZ    = NVEC(3,IN) * RBOX(3)
      DO I = 1, 3
        UM(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UM(I)
        FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
        FM(1,I) = FM(1,I) + FIJ * FIX
        FM(2,I) = FM(2,I) + FIJ * FIY
        FM(3,I) = FM(3,I) + FIJ * FIZ
      enddo
    enddo
    VAL09 = VAL09 + VAL09C * 0.5D0
    VAL91 = VAL91 + VAL09C*0.5D0
!
!     ----------------------------------- Coulomb direct lattice space
!
200 RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!   ------------------ Calculation of Coulomb of three point charges
    DO I = 1, 2
      PIX = PM(1,I)
      PIY = PM(2,I)
      PIZ = PM(3,I)
      DO J = I+1, 3
        ZIZJ = ZM(I) * ZM(J)
        pjx0 = pM(1,j)
        pjy0 = pM(2,j)
        pjz0 = pM(3,j)
        if (pjx0 < pix)  pjx0 = pjx0 + 1.0
        if (pjy0 < piy)  pjy0 = pjy0 + 1.0
        if (pjz0 < piz)  pjz0 = pjz0 + 1.0
        DO K = 1, 8
          pjx = pjx0 - transx(k)
          pjy = pjy0 - transy(k)
          pjz = pjz0 - transz(k)
          RX = PIX - PjX
          RY = PIY - PjY
          RZ = PIZ - PjZ
!                          RX = PIX - PjX
!                          RY = PIY - PjY
!                          RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = RX * BOX(1)
          DY = RY * BOX(2)
          DZ = RZ * BOX(3)
          RIJ2 = DX*DX + DY*DY + DZ*DZ
          IF (RIJ2 <= RCUT2)  GO TO 257
        enddo
        GO TO 262
!
257     RIJ = SQRT(RIJ2)
        IP0 = INT(RIJ*100.0)
!       ---------------------------------- Interpolation
        IP1 = IP0 + 1
        IP2 = IP0 + 2
        R00 = IP0 * 0.01D0
        R01 = IP1 * 0.01D0
        R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
                        X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
                        X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
                        X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
                        FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
                        EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) *
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
        VAL09 = VAL09 + EIJ
        VAL92 = VAL92 + EIJ
        UM(I) = UM(I) + EIJ
        UM(J) = UM(J) + EIJ
        DFX = FIJ * DX
        DFY = FIJ * DY
        DFZ = FIJ * DZ
        FM(1,I) = FM(1,I) + DFX
        FM(2,I) = FM(2,I) + DFY
        FM(3,I) = FM(3,I) + DFZ
        FM(1,J) = FM(1,J) - DFX
        FM(2,J) = FM(2,J) - DFY
        FM(3,J) = FM(3,J) - DFZ
        VAL03 = VAL03 + DFX * DX
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
262     CONTINUE
      enddo
    enddo
    UI(NTION+IJKL) = UI(NTION+IJKL) - UM(3)
    FX(NTION+IJKL) = FX(NTION+IJKL) - FM(1,3)
    FY(NTION+IJKL) = FY(NTION+IJKL) - FM(2,3)
    FZ(NTION+IJKL) = FZ(NTION+IJKL) - FM(3,3)
    DO II = 1, 2
      I = IDMOLE(II,IJKL)
      UI(I) = UI(I) - UM(II)
      FX(I) = FX(I) - FM(1,II)
      FY(I) = FY(I) - FM(2,II)
      FZ(I) = FZ(I) - FM(3,II)
      fx(i) = fx(i) + fx(ntion+ijKL) / 2.0
      fy(i) = fy(i) + fy(ntion+ijKL) / 2.0
      fz(i) = fz(i) + fz(ntion+ijKL) / 2.0
      ui(i) = ui(i) + ui(ntion+ijKL) / 2.0
    enddo
  enddo
!
  VAL(3)  = VAL(3)  - VAL03*1.0D-8 - VAL03C
  VAL(4)  = VAL(4)  - VAL04*1.0D-8 - VAL04C
  VAL(5)  = VAL(5)  - VAL05*1.0D-8 - VAL05C
  VAL(6)  = VAL(6)  - VAL06*1.0D-8 - VAL06C
  VAL(7)  = VAL(7)  - VAL07*1.0D-8 - VAL07C
  VAL(8)  = VAL(8)  - VAL08*1.0D-8 - VAL08C
  VAL(9)  = VAL(9)  - VAL09
  II = IATOM2(1)
  IF (II /= 0)  VAL(9) = VAL(9) - UCSLFI(II)
  II = IATOM2(2)
  IF (II /= 0)  VAL(9) = VAL(9) - UCSLFI(II)
  PRSTC2(1) = PRSTC2(1) - VAL03C
  PRSTC2(2) = PRSTC2(2) - VAL04C
  PRSTC2(3) = PRSTC2(3) - VAL05C
  PRSTC2(4) = PRSTC2(4) - VAL06C
  PRSTC2(5) = PRSTC2(5) - VAL07C
  PRSTC2(6) = PRSTC2(6) - VAL08C
  RETURN
END
!
!
!                                                  =====================
!==================================================== EWALD_of_PolyAtoms
SUBROUTINE  EWALD_of_PolyAtoms
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use paramt
  use tables
  use vector
  use values
  use forces
  use cartes
  use molecu
  use charge
  use pos
  use ewal
!
  implicit none
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
  double precision  DX,RX,DFX,FIX, SICOS, SISIN,R00,X0,PHI
  double precision  DY,RY,DFY,FIY,FSICOS,FSISIN,R01,X1,FIJ
  double precision  DZ,RZ,DFZ,FIZ,USICOS,USISIN,R02,X2,EIJ
  double precision  VAL03, VAL04, VAL05, VAL06, VAL07, VAL08, VAL09
  double precision  VAL03C,VAL04C,VAL05C,VAL06C,VAL07C,VAL08C,VAL09C
  double precision  RIJ, RIJ2, RCUT2, SCCSS, zizj
  double precision  val91
  double precision  pm(3,lni),zm(lni),FM(3,lni),um(lni) !um(3) for tri atoms
  integer(KIND=4)  ijkl,n,i,k,in,j,ip0,ip1,ip2,ii
!
!P    double precision  AL2PI, ZIJE2, RIJ, ARIJ, ERFC, BETA, EX,CA,AM1,AM2
!P    double precision  X0,X1,X2,X3, Y0,Y1,Y2,Y3,Y4, Z
!     ----- FUNCTION ERFC(X) : VERSION 5662 IN "COMPUTER APPROXIMATIONS"
!P    DATA EX0,EX1,EX2,EX3    /10.00464,8.426553,3.460259,0.5623536   /
!P    DATA EY0,EY1,EY2,EY3,EY4/10.00464,19.71558,15.70229,6.090749,1.0/
!
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  VAL09 = 0.0D0
!
  VAL03C = 0.0D0
  VAL04C = 0.0D0
  VAL05C = 0.0D0
  VAL06C = 0.0D0
  VAL07C = 0.0D0
  VAL08C = 0.0D0
  VAL09C = 0.0D0
!
!     ------------------------------------------ Coulomb reciprocal term
!
  do ijkl = 1, nmole         ! nmole: number of molecules
    do N = 1, mmole(ijkl)    ! mmole(ijkl): number of atoms composing the ijkl moleculel
      I = IMOLE(N,IJKL)      ! imole(n,ijkl): index of atoms corresponding the N atoms in the ijkl molecule
      ZM(N) = ZII(I)         ! effective charge of the atom
      do K = 1, 3
        PM(K,N) = P(K,I)     ! the coordinate of the atom
      enddo
    enddo
    DO I = 1, mmole(ijkl)
      UM(I) = 0.0D0
      DO K = 1, 3
        FM(K,I) = 0.0D0
      enddo
    enddo
!
    IF (NVN == 0)  GO TO 200  !NVN: the number of reciprocal vectors
!
    DO I = 1, mmole(ijkl)
      ZICOS(I) = 0.0D0
      ZISIN(I) = 0.0D0
    enddo
!
    VAL09C = 0.0D0
    DO IN = 1, NVN
      SICOS = 0.0D0
      SISIN = 0.0D0
      DX = DBLE(NVEC(1,IN)) * PI2
      DY = DBLE(NVEC(2,IN)) * PI2
      DZ = DBLE(NVEC(3,IN)) * PI2
      DO I = 1, mmole(ijkl)
        PHI      = DX*PM(1,I) + DY*PM(2,I) + DZ*PM(3,I)
        ZICOS(I) = COS(PHI) * ZM(i)
        SICOS    = SICOS + ZICOS(I)
        ZISIN(I) = SIN(PHI) * ZM(i)
        SISIN    = SISIN + ZISIN(I)
      enddo
!
      FSICOS = FNV(IN) * SICOS
      FSISIN = FNV(IN) * SISIN
      USICOS = UNV(IN) * SICOS
      USISIN = UNV(IN) * SISIN
      SCCSS  = SICOS**2 + SISIN**2
      VAL09C = VAL09C + UNV(IN)   * SCCSS
      VAL03C = VAL03C + PNV(1,IN) * SCCSS
      VAL04C = VAL04C + PNV(2,IN) * SCCSS
      VAL05C = VAL05C + PNV(3,IN) * SCCSS
      VAL06C = VAL06C + PNV(4,IN) * SCCSS
      VAL07C = VAL07C + PNV(5,IN) * SCCSS
      VAL08C = VAL08C + PNV(6,IN) * SCCSS
      FIX    = DBLE(NVEC(1,IN)) * RBOX(1)
      FIY    = DBLE(NVEC(2,IN)) * RBOX(2)
      FIZ    = DBLE(NVEC(3,IN)) * RBOX(3)
      DO I = 1, mmole(ijkl)
        UM(I) = USICOS * ZICOS(I) + USISIN * ZISIN(I) + UM(I)
        FIJ   = FSICOS * ZISIN(I) - FSISIN * ZICOS(I)
        FM(1,I) = FM(1,I) + FIJ * FIX
        FM(2,I) = FM(2,I) + FIJ * FIY
        FM(3,I) = FM(3,I) + FIJ * FIZ
      enddo
    enddo
    VAL09 = VAL09 + VAL09C * 0.5D0
    VAL91 = VAL91 + VAL09C * 0.5D0
!
!     ------------------------------------- Coulomb direct lattice space
!
200 RCUT2 = RCUT(1) * RCUT(1)
!P          AL2PI = 2.0D0 * ALPHA / SQRT(PI)
!     ------------------ Calculation of Coulomb in a polyatomic molecule
    DO I = 1, mmole(ijkl)-1
      DO J = I+1, mmole(ijkl)
        ZIZJ = ZM(I) * ZM(J)
        RX = PM(1,I) - PM(1,J)
        RY = PM(2,I) - PM(2,J)
        RZ = PM(3,I) - PM(3,J)
!                         - - - - - delete these if-statements for triclinic
        IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)
        IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)
        IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)
!T                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
        DX = RX * BOX(1)
        DY = RY * BOX(2)
        DZ = RZ * BOX(3)
        RIJ2 = DX*DX + DY*DY + DZ*DZ
        IF (RIJ2 <= RCUT2)  GO TO 257
        cycle
257     RIJ = SQRT(RIJ2)
        IP0 = INT(RIJ*100.D0)
!                       ---------------------------------- Interpolation
        IP1 = IP0 + 1
        IP2 = IP0 + 2
        R00 = DBLE(IP0) * 0.01D0
        R01 = DBLE(IP1) * 0.01D0
        R02 = DBLE(IP2) * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
        X0 = (RIJ-R01)*(RIJ-R02) *    5000.0D0
        X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
        X2 = (RIJ-R00)*(RIJ-R01) *    5000.0D0
        FIJ  = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
        EIJ  = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
!E                      ----------------------- For precise calculations
!E                      ARIJ = 1.0D0 / RIJ
!                                 ------ FUNCTION ERFC(X) : VERSION 5662
!                                 ------    in "COMPUTER APPROXIMATIONS"
!E                                Z = ABS(ALPHA * RIJ)
!E                                ERFC = EXP(-Z*Z) *
!E   *                                     (EX0+Z*(EX1+Z*(EX2+Z*EX3))) /
!E   *                              (EY0+Z*(EY1+Z*(EY2+Z*(EY3+Z*EY4))) )
!E                      EIJ = ERFC * (ARIJ*1.0D8) * ZIJE2
!E                      FIJ = (AL2PI*EXP(-(ALPHA*RIJ)**2)*RIJ + ERFC)
!E   *                                 * (ARIJ*1.0D8)**2 * ARIJ *ZIJE2
!E                      ------------------------------------------------
        VAL09 = VAL09 + EIJ
        UM(I) = UM(I) + EIJ
        UM(J) = UM(J) + EIJ
        DFX = FIJ * DX
        DFY = FIJ * DY
        DFZ = FIJ * DZ
        FM(1,I) = FM(1,I) + DFX
        FM(2,I) = FM(2,I) + DFY
        FM(3,I) = FM(3,I) + DFZ
        FM(1,J) = FM(1,J) - DFX
        FM(2,J) = FM(2,J) - DFY
        FM(3,J) = FM(3,J) - DFZ
        VAL03 = VAL03 + DFX * DX
        VAL04 = VAL04 + DFY * DY
        VAL05 = VAL05 + DFZ * DZ
        VAL06 = VAL06 + DFX * DY
        VAL07 = VAL07 + DFX * DZ
        VAL08 = VAL08 + DFY * DZ
      enddo
    enddo
!
    DO II = 1, mmole(ijkl)
      I = IMOLE(ii,ijkl)
      UI(I) = UI(I) - UM(II)
      FX(I) = FX(I) - FM(1,II)
      FY(I) = FY(I) - FM(2,II)
      FZ(I) = FZ(I) - FM(3,II)
    enddo
  enddo
!
  VAL(3)  = VAL(3)  - VAL03*1.0D-8 - VAL03C
  VAL(4)  = VAL(4)  - VAL04*1.0D-8 - VAL04C
  VAL(5)  = VAL(5)  - VAL05*1.0D-8 - VAL05C
  VAL(6)  = VAL(6)  - VAL06*1.0D-8 - VAL06C
  VAL(7)  = VAL(7)  - VAL07*1.0D-8 - VAL07C
  VAL(8)  = VAL(8)  - VAL08*1.0D-8 - VAL08C
  VAL(9)  = VAL(9)  - VAL09
  do ii = MOLstart(1), MOLend(1)
    VAL(9) = VAL(9) - UCSLFI(II)
  end do
  PRSTC2(1) = PRSTC2(1) - VAL03C
  PRSTC2(2) = PRSTC2(2) - VAL04C
  PRSTC2(3) = PRSTC2(3) - VAL05C
  PRSTC2(4) = PRSTC2(4) - VAL06C
  PRSTC2(5) = PRSTC2(5) - VAL07C
  PRSTC2(6) = PRSTC2(6) - VAL08C
RETURN
END
!
!                                                                =======
!================================================================ THREEP
SUBROUTINE  THREEP  (I,j,k, KK3BP)
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use forces
  use ewal
  use datoms
!
  implicit none
!     ------------------------------------------- 3-body potential model
!
!
!
  integer(KIND=4)  I,j,k,kk3bp
  double precision  RIJX1,rijx2,DRDX1I,drdx2i,DRDX1J,drdx2j,DCDX   
  double precision  RIJY1,rijy2,DRDY1I,drdy2i,DRDY1J,drdy2j,DCDY     
  double precision  RIJZ1,rijz2,DRDZ1I,drdz2i,DRDZ1J,drdz2j,DCDZ      
  double precision  AK1,rij1,ARIJ1,CDR,EX1,SINJIJ,VAL03, VAL04, VAL05         
  double precision  AK2,rij2,ARIJ2,CDS,EX2,COSJIJ,VAL06, VAL07, VAL08          
  double precision  ffx1, ffx2, ASINJ                           
  double precision  ffy1, ffy2, RM, GR, FACT, RDJIJ, RD0                       
  double precision  ffz1, ffz2, FK, UJIJ, PHAI2  
  double precision  TJIJ                          
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0D-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
!  PI180 = 180.0D0 / PI
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM  = R3BLIM(1,KK3BP)    !r_m
  GR  = R3BGRD(1,KK3BP)    !g_r
  RD0 = ANG3BP(KK3BP) / PI180      !theta/(180/pi) radian unit
  FK  = FK3BP(KK3BP) * 1.0D-8      !f [erg]
!
  RIJ1   = D1ATOM                                                     
  ARIJ1  = 1.0D0 / rij1                                               
  RIJX1  = - D1AXYZ(1)                                                
  RIJY1  = - D1AXYZ(2)                                                
  RIJZ1  = - D1AXYZ(3)                                                
  DRDX1I = - RIJX1 * ARij1                                            
  DRDY1I = - RIJY1 * ARij1                                            
  DRDZ1I = - RIJZ1 * ARij1                                            
  DRDX1J = RIJX1 * ARij1                                              
  DRDY1J = RIJY1 * ARij1                                              
  DRDZ1J = RIJZ1 * ARij1                                              
!          DO 710  L2 = L1+1, NIJ                                              
  rij2   = d2atom                                                  
  ARIJ2  = 1.0D0 / rij2                                            
  RIJX2  = - D2AXYZ(1)                                             
  RIJY2  = - D2AXYZ(2)                                             
  RIJZ2  = - D2AXYZ(3)                                             
  DRDX2I = - RIJX2 * ARij2                                         
  DRDY2I = - RIJY2 * ARij2                                         
  DRDZ2I = - RIJZ2 * ARij2                                         
  DRDX2J = RIJX2 * ARij2                                           
  DRDY2J = RIJY2 * ARij2                                           
  DRDZ2J = RIJZ2 * ARij2                                           
!                                                                              
  COSJIJ = ( d1axyz(1) * d2axyz(1) +  &                             
             d1axyz(2) * d2axyz(2) +  &                             
             d1axyz(3) * d2axyz(3) ) * ARIJ1 * ARIJ2               
  IF (ABS(COSJIJ) < 1.0D-11) THEN
    COSJIJ = DSIGN(1.0D-11,COSJIJ)
  END IF
  SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
  ASINJ  = DSIGN(1.0D-11,SINJIJ)
  IF (ABS(SINJIJ) > 1.D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : J-I-J angle
  RDJIJ  = DATAN(SINJIJ / COSJIJ)
  IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
  TJIJ   = RDJIJ * PI180
  IF (TJIJ < 0.0D0)  TJIJ = TJIJ + 180.0D0
! --------------------- Decriment of force with I-J distance
  EX1  = DEXP((d1atom - RM) * GR)                                  
  EX2  = DEXP((d2atom - RM) * GR)                                  
  AK1  = 1.0D0 / (EX1 + 1.0D0)
  AK2  = 1.0D0 / (EX2 + 1.0D0)
  fact = Dsqrt (ak1*ak2)                                           
  if (runopt(8) == 'BMH-EXP*  ')  FACT = AK1 * AK2
! ----------------------------- FJIJ : Force for J-I-J angle
!                               UJIJ : Potential for J-I-J angle
  PHAI2 = 2.0D0 * (RDJIJ - RD0)
  UJIJ = -1.0D0 *FK *(DCOS(PHAI2) -1.0D0) * FACT
  VAL(11) = VAL(11) + UJIJ
!
  DCDX = (drdx2j - Drdx1j*COSJIJ) * ARIJ1                        
  DCDY = (drdy2j - Drdy1j*COSJIJ) * ARIJ1                        
  DCDZ = (drdz2j - Drdz1j*COSJIJ) * ARIJ1                        
  CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
  CDR = 0.5D0 *AK1 *GR *EX1 *(DCOS(PHAI2)-1.0D0)                 
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK1 *GR *EX1*(COS(PHAI2)-1.0D0)
  FFX1 = -1.0D8 *FK *FACT *(CDR *Drdx1j + CDS *DCDX)             
  FFY1 = -1.0D8 *FK *FACT *(CDR *Drdy1j + CDS *DCDY)             
  FFZ1 = -1.0D8 *FK *FACT *(CDR *Drdz1j + CDS *DCDZ)             
!               J1 = KIJ(L1)                                                 
  FX(J) = FX(J) + FFX1                                          
  FY(J) = FY(J) + FFY1                                          
  FZ(J) = FZ(J) + FFZ1                                          
  VIRLSR = VIRLSR + FFX1*RIJX1 + FFY1*RIJY1 + FFZ1*RIJZ1                  
  VAL03 = VAL03 + FFX1 *RIJX1                                    
  VAL04 = VAL04 + FFY1 *RIJY1                                    
  VAL05 = VAL05 + FFZ1 *RIJZ1                                    
  VAL06 = VAL06 + FFX1 *RIJY1                                    
  VAL07 = VAL07 + FFX1 *RIJZ1                                    
  VAL08 = VAL08 + FFY1 *RIJZ1                                    
!
  DCDX = (DRDX1J - DRDX2J*COSJIJ) * ARIJ2                        
  DCDY = (DRDY1J - DRDY2J*COSJIJ) * ARIJ2                        
  DCDZ = (DRDZ1J - DRDZ2J*COSJIJ) * ARIJ2                        
  CDR = 0.5D0 *AK2 *GR *EX2 *(DCOS(PHAI2)-1.0D0)
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK2 *GR *EX2 *(COS(PHAI2)-1.0D0)
!              CDS = -2.0D0 *ASINJ *DSIN(PHAI2)
  FFX2 = -1.0D8 *FK *FACT *(CDR *DRDX2J + CDS *DCDX)             
  FFY2 = -1.0D8 *FK *FACT *(CDR *DRDY2J + CDS *DCDY)             
  FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZ2J + CDS *DCDZ)             
!               J2 = KIJ(L2)
  FX(k) = FX(k) + FFX2
  FY(k) = FY(k) + FFY2
  FZ(k) = FZ(k) + FFZ2
  VIRLSR = VIRLSR + FFX2*RIJX2 + FFY2*RIJY2 + FFZ2*RIJZ2                  
  VAL03 = VAL03 + FFX2 *RIJX2                                    
  VAL04 = VAL04 + FFY2 *RIJY2                                    
  VAL05 = VAL05 + FFZ2 *RIJZ2                                    
  VAL06 = VAL06 + FFX2 *RIJY2                                    
  VAL07 = VAL07 + FFX2 *RIJZ2                                    
  VAL08 = VAL08 + FFY2 *RIJZ2                                    
!
!  DCDX = (DRDX1I - DRDX2I*COSJIJ) * ARIJ2 +  (DRDX2I - DRDX1I*COSJIJ) * ARIJ1                        
!  DCDY = (DRDY1I - DRDY2I*COSJIJ) * ARIJ2 +  (DRDY2I - DRDY1I*COSJIJ) * ARIJ1                        
!  DCDZ = (DRDZ1I - DRDZ2I*COSJIJ) * ARIJ2 +  (DRDZ2I - DRDZ1I*COSJIJ) * ARIJ1                        
!  CDR0 = 0.5D0 * GR * (COS(PHAI2)-1.0D0)                        
!  if  (runopt(8) == 'BMH-EXP*  ')   CDR0 = GR *(COS(PHAI2)-1.0D0)                      
!  CDR1 = AK1 * EX1 * CDR0
!  CDR2 = AK2 * EX2 * CDR0
!  FFX = FK *FACT *(CDR1*DRDX1I + CDR2*DRDX2I +CDS*DCDX)          
!  FFY = FK *FACT *(CDR1*DRDY1I + CDR2*DRDY2I +CDS*DCDY)          
!  FFZ = FK *FACT *(CDR1*DRDZ1I + CDR2*DRDZ2I +CDS*DCDZ)          
!  FFX = FFX * (-1.0D8)
!  FFY = FFY * (-1.0D8)
!  FFZ = FFZ * (-1.0D8)
!  ffx = ffx - (ffx + ffx1 + ffx2)
!  ffy = ffy - (ffy + ffy1 + ffy2)
!  ffz = ffz - (ffz + ffz1 + ffz2)
!  FX(I) = FX(I) + FFX
!  FY(I) = FY(I) + FFY
!  FZ(I) = FZ(I) + FFZ
!
   FX(I) = FX(I) - (FFX1 + FFX2)
   FY(I) = FY(I) - (FFY1 + FFY2)
   FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
  AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
  AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0D0
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
  RETURN
END
!
!
!                                                                =======
!================================================================ THREEQ
SUBROUTINE  THREEQ  (I,j,k, KK3BP)
  use param
  use charac
  use atomsi
  use aboxof
  use values
  use paramt
  use forces
  use ewal
  use pos
  use datoms
!
  implicit none
!     -------------------------------- 3-body potential model j-i-k j<k
!
!
!
  double precision  R1IJX, DRDX1I, DRDX1J, DCDX                  
  double precision  R1IJY, DRDY1I, DRDY1J, DCDY                   
  double precision  R1IJZ, DRDZ1I, DRDZ1J, DCDZ                     
  double precision  R2IJX, DRDX2I, DRDX2J, ffx1, ffx2, val03, val06              
  double precision  R2IJY, DRDY2I, DRDY2J, ffy1, ffy2, val04, val07              
  double precision  R2IJZ, DRDZ2I, DRDZ2J, ffz1, ffz2, val05, val08               
  double precision  AK1,r1ij,ARIJ1,CDR,EX1,rm1,gr1,SINJIJ                        
  double precision  AK2,r2ij,ARIJ2,CDS,EX2,rm2,gr2,COSJIJ                         
  double precision  FACT, RDJIJ, RD0                                              
  double precision  FK, UJIJ, PHAI2, ASINJ,TJIJ
  integer*4 I,J,K,KK3BP
!
!     ---------------------------------------- F = FK3BP * SIN(2*ANG3BP)
  IF (FK3BP(KK3BP) <= 1.0E-21)    RETURN
!     -------------------------------------------------- I : Central ion
!                                                        J : J-I-J
!  PI180 = 180.0D0 / PI
  VAL03 = 0.0D0
  VAL04 = 0.0D0
  VAL05 = 0.0D0
  VAL06 = 0.0D0
  VAL07 = 0.0D0
  VAL08 = 0.0D0
  RM1 = DBLE(R3BLIM(1,KK3BP))
  GR1 = DBLE(R3BGRD(1,KK3BP))
  RM2 = DBLE(R3BLIM(2,KK3BP))
  GR2 = DBLE(R3BGRD(2,KK3BP))
  RD0 = DBLE(ANG3BP(KK3BP)) / PI180
  FK  = DBLE(FK3BP(KK3BP)) * 1.0D-8
!
  r1ij   = d1atom                                                     
  ARIJ1  = 1.0D0 / R1IJ                                               
  R1IJX  = - D1AXYZ(1)                                                
  R1IJY  = - D1AXYZ(2)                                                
  R1IJZ  = - D1AXYZ(3)                                                
  DRDX1I = - R1IJX * ARij1                                              
  DRDY1I = - R1IJY * ARij1                                              
  DRDZ1I = - R1IJZ * ARij1                                              
  DRDX1J = R1IJX * ARij1                                                
  DRDY1J = R1IJY * ARij1                                                
  DRDZ1J = R1IJZ * ARij1                                                
!         DO 710  L2 =1, N2IJ                                                     
  r2ij   = d2atom                                                     
  ARIJ2  = 1.0D0 / R2IJ                                               
  R2IJX  = - D2AXYZ(1)                                                
  R2IJY  = - D2AXYZ(2)                                                
  R2IJZ  = - D2AXYZ(3)                                                
  DRDX2I = - R2IJX * ARij2                                           
  DRDY2I = - R2IJY * ARij2                                           
  DRDZ2I = - R2IJZ * ARij2                                           
  DRDX2J = R2IJX * ARij2                                             
  DRDY2J = R2IJY * ARij2                                             
  DRDZ2J = R2IJZ * ARij2                                             
!             write (6,*) l1,l2,r1ij,r2ij                                         
  COSJIJ = ( R1IJX * R2IJX + R1IJY * R2IJY +  &                         
             R1IJZ * R2IJZ ) * ARIJ1 * ARIJ2                         
  IF (ABS(COSJIJ) < 1.0D-11) THEN
    COSJIJ = SIGN(1.0D-11,COSJIJ)
  END IF
  SINJIJ = SQRT(1.0D0 - COSJIJ*COSJIJ)
  ASINJ  = SIGN(1.0D-11,SINJIJ)
  IF (ABS(SINJIJ) > 1D-11)  ASINJ  = 1.0D0 / SINJIJ
!             --------------------------------------- TJIJ : j-i-k angle          
  RDJIJ  = ATAN(SINJIJ / COSJIJ)
  IF (RDJIJ < 0.0D0)  RDJIJ = RDJIJ + PI
  TJIJ   = RDJIJ * PI180
  IF (TJIJ < 0.0)  TJIJ = TJIJ + 180.0
!             ------------ Decriment of force with I-J and i-k distances          
  EX1 = EXP((R1IJ - RM1) * GR1)                                       
  EX2 = EXP((R2IJ - RM2) * GR2)                                       
  AK1  = 1.0D0 / (EX1 + 1.0D0)
  AK2  = 1.0D0 / (EX2 + 1.0D0)
  FACT = SQRT( AK1 * AK2 )
  if (runopt(8) == 'BMH-EXP*  ')  FACT = AK1 * AK2
!             ----------------------------- Fjik : Force for j-i-k angle          
!                                       Ujik : Potential for j-i-k angle          
  PHAI2 = 2.0D0 * (RDJIJ - RD0)
  UJIJ = -1.0D0 *FK *(COS(PHAI2) -1.0D0) * FACT
  VAL(11) = VAL(11) + UJIJ
!
  DCDX = (DRDX2J - DRDX1J*COSJIJ) * ARIJ1                             
  DCDY = (DRDY2J - DRDY1J*COSJIJ) * ARIJ1                             
  DCDZ = (DRDZ2J - DRDZ1J*COSJIJ) * ARIJ1                             
  CDR = 0.5D0 *AK1 *GR1 *EX1 *(COS(PHAI2)-1.0D0)
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK1 *GR1 *EX1 *(COS(PHAI2)-1.0D0)
  CDS = -2.0D0 *ASINJ *SIN(PHAI2)
  FFX1 = -1.0D8 *FK *FACT *(CDR *DRDX1J + CDS *DCDX)                   
  FFY1 = -1.0D8 *FK *FACT *(CDR *DRDY1J + CDS *DCDY)                   
  FFZ1 = -1.0D8 *FK *FACT *(CDR *DRDZ1J + CDS *DCDZ)                   
!               J1 = K1IJ(L1)                                                      
  FX(J) = FX(J) + FFX1                                                
  FY(J) = FY(J) + FFY1                                                
  FZ(J) = FZ(J) + FFZ1                                                
  VIRLSR = VIRLSR + FFX1*R1IJX + FFY1*R1IJY + FFZ1*R1IJZ               
  VAL03 = VAL03 + FFX1 *R1IJX                                          
  VAL04 = VAL04 + FFY1 *R1IJY                                          
  VAL05 = VAL05 + FFZ1 *R1IJZ                                          
  VAL06 = VAL06 + FFX1 *R1IJY                                          
  VAL07 = VAL07 + FFX1 *R1IJZ                                          
  VAL08 = VAL08 + FFY1 *R1IJZ                                          
!
  DCDX = (DRDX1J - DRDX2J*COSJIJ) * ARIJ2                              
  DCDY = (DRDY1J - DRDY2J*COSJIJ) * ARIJ2                              
  DCDZ = (DRDZ1J - DRDZ2J*COSJIJ) * ARIJ2                              
  CDR = 0.5D0 *AK2 *GR2 *EX2 *(COS(PHAI2)-1.0D0)
  if (runopt(8) == 'BMH-EXP*  ') CDR = AK2 *GR2 *EX2 *(COS(PHAI2)-1.0D0)
!              CDS = -2.0D0 *ASINJ *SIN(PHAI2)
  FFX2 = -1.0D8 *FK *FACT *(CDR *DRDX2J + CDS *DCDX)                    
  FFY2 = -1.0D8 *FK *FACT *(CDR *DRDY2J + CDS *DCDY)                    
  FFZ2 = -1.0D8 *FK *FACT *(CDR *DRDZ2J + CDS *DCDZ)                    
!               J2 = K2IJ(L2)                                                       
  FX(k) = FX(k) + FFX2                                                 
  FY(k) = FY(k) + FFY2                                                 
  FZ(k) = FZ(k) + FFZ2                                                 
  VIRLSR = VIRLSR + FFX2*R2IJX + FFY2*R2IJY + FFZ2*R2IJZ                
  VAL03 = VAL03 + FFX2 *R2IJX                                           
  VAL04 = VAL04 + FFY2 *R2IJY                                           
  VAL05 = VAL05 + FFZ2 *R2IJZ                                           
  VAL06 = VAL06 + FFX2 *R2IJY                                           
  VAL07 = VAL07 + FFX2 *R2IJZ                                           
  VAL08 = VAL08 + FFY2 *R2IJZ                                           
!
!   DCDX = (DRDX1I - DRDX2I*COSJIJ) * ARIJ2 +  (DRDX2I - DRDX1I*COSJIJ) * ARIJ1                               
!   DCDY = (DRDY1I - DRDY2I*COSJIJ) * ARIJ2 +  (DRDY2I - DRDY1I*COSJIJ) * ARIJ1                               
!   DCDZ = (DRDZ1I - DRDZ2I*COSJIJ) * ARIJ2 +  (DRDZ2I - DRDZ1I*COSJIJ) * ARIJ1                               
!   CDR1 = AK1 *EX1 * 0.5D0 *GR1 *(COS(PHAI2)-1.0D0)
!   CDR2 = AK2 *EX2 * 0.5D0 *GR2 *(COS(PHAI2)-1.0D0)
!   if (runopt(8) == 'BMH-EXP*  ')  then
!     CDR1 = AK1 *EX1  *GR1 *(COS(PHAI2)-1.0D0)
!     CDR2 = AK2 *EX2  *GR2 *(COS(PHAI2)-1.0D0)
!   end if
!   FFX=-1.0D8* FK*FACT *(CDR1*DRDX1I +CDR2*DRDX2I +CDS*DCDX)             
!   FFY=-1.0D8* FK*FACT *(CDR1*DRDY1I +CDR2*DRDY2I +CDS*DCDY)             
!   FFZ=-1.0D8* FK*FACT *(CDR1*DRDZ1I +CDR2*DRDZ2I +CDS*DCDZ)             
!   ffx = ffx - (ffx + ffx1 + ffx2)
!   ffy = ffy - (ffy + ffy1 + ffy2)
!   ffz = ffz - (ffz + ffz1 + ffz2)
!   FX(I) = FX(I) + FFX
!   FY(I) = FY(I) + FFY
!   FZ(I) = FZ(I) + FFZ
!
   FX(I) = FX(I) - (FFX1 + FFX2)
   FY(I) = FY(I) - (FFY1 + FFY2)
   FZ(I) = FZ(I) - (FFZ1 + FFZ2)
!
  AV3BP(1,KK3BP) = AV3BP(1,KK3BP) + TJIJ
  AV3BP(2,KK3BP) = AV3BP(2,KK3BP) + 1.0
!
  VAL(3)  = VAL(3)  + VAL03 *1.0D-8
  VAL(4)  = VAL(4)  + VAL04 *1.0D-8
  VAL(5)  = VAL(5)  + VAL05 *1.0D-8
  VAL(6)  = VAL(6)  + VAL06 *1.0D-8
  VAL(7)  = VAL(7)  + VAL07 *1.0D-8
  VAL(8)  = VAL(8)  + VAL08 *1.0D-8
!
  RETURN
END
!
!
!                                                               ========
!================================================================ QUANTM
SUBROUTINE  QUANTM
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use quanco
!
  implicit none
!     ----------------------------------------------- Quantum correction
  COMMON /QUANAB/ NQC
!
  double precision        FEK,QKIE,DQCE,TEMPQ, QCKET,AKINE
  integer*4 NQC,J,I
!
  IF (NRECRD(1) == 1)  TEMPQH = 0.0
! --------------------------------- Quantum correction for each step
  FEK   = ((AHP/ 2.0/PI)**2) / (24.0D0 * AKB)
!                                            TQCE : sum of nabla(Uij)/mi
  TQCE  = TQCE * FEK
!                               [TQCE]/T : Net Quantum Correction Energy
  QCIT  = 1.50D0 * AKB * dble(NTION)
  AKINE = VAL(13)
!                                         1/2 for Harmonic approximation
  QCKET = TQCE * 0.5D0
!                    QCKET : [Quantum Correction for Kinetic energy] * T
!                                  [QCIT]*T**2 + [AKINE]*T + [QCKET] = 0
  DQCE  = AKINE**2 - 4.0D0 * QCIT * QCKET
  IF (DQCE <= 0.0) THEN
    NQC = NQC + 1
    AKINE = SQRT(4.0D0 * QCIT * QCKET)
    TEMPQ = AKINE / (2.0D0 * QCIT)
    QKIE  = SQRT(AKINE / VAL(13))
    DO J = 1, 3
      DO I = 1, NTION
        V(J,I) = V(J,I) * QKIE
      enddo
    enddo
  ELSE
    TEMPQ = (AKINE + SQRT(DQCE)) / (2.0D0 * QCIT)
  END IF
  VAL(1) = TEMPQ
  TEMPQQ = AKINE / QCIT
  TEMPQH = TEMPQH + TEMPQQ
!
!     write (6,*) 'Thermodynamic temperature : ',tempq,
!    *            '  Kinetic temperature :', TEMPQQ
  RETURN
END
!
!
!                                                                =======
!================================================================ QCTABL
      SUBROUTINE  QCTABL
  use param
  use charac
  use aboxof
  use paramt
  use tables
  use pmorse
  use quanco
!     ------------------------------------------------------------------
  implicit none
!
  double precision  A1,A2, QSR1,QSR2, QVW1,QVW2,D2,    QMS1,QMS2
  double precision AR,R,BETAU,ARB
  integer*4 J,I
!
  IF (RUNOPT(8)  /= 'BUSING    '.AND.  &
      RUNOPT(8)  /= 'MORSE     ')  RETURN
!     ------------------------------------------- Calculation of tables
  BETAU = CAL * 1.0D10 / ANA
  DO I = 10, NRCUT(2)
    R  = dble(I) * 0.01
    AR = 1.0 / R
    DO J = 1, LEE
      Q1U1(I,J) = 0.0
      Q2U1(I,J) = 0.0
      QSR1 = 0.0
      QSR2 = 0.0
      QVW1 = 0.0
      QVW2 = 0.0
      QMS1 = 0.0
      QMS2 = 0.0
      IF (ABS(AIJ(J)) > 1.0E-5)  THEN
!                   ----------------- Short range rep. and van der Waals
        QSR1 = 0.0
        IF (BIJ(J) > 0.0001)  THEN
          ARB = (AIJ(J) - R) / BIJ(J)
          IF (ARB > -128.0)  QSR1 = EXP(ARB)
        END IF
        QSR1 = -QSR1          * 1.0E8
        QSR2 = -QSR1 / BIJ(J) * 1.0E8
!                   -------------------------------------- Van der Waals
        QVW1 =  6.0 * CIJ(J) * AR**7 * 1.0E8
        QVW2 = -7.0 * QVW1   * AR    * 1.0E8
      END IF
      IF (RUNOPT(8) == 'MORSE     ') THEN
!                   ----------------------------------------- Morse term
        D2 = DMIJ(J) * 2.0D0
        A1 = EXP(-2.0D0*BEIJ(J)*(R-RSIJ(J)))
        A2 = EXP(-1.0D0*BEIJ(J)*(R-RSIJ(J)))
        QMS1 = D2 * BEIJ(J)    * (    -A1 + A2) *1.0E8
        QMS2 = D2 * BEIJ(J)**2 * ( 2.0*A1 - A2) *1.0E16
      END IF
      Q1U1(I,J) = ((QSR1 + QMS1) * BETAU + QVW1) * AR*1.0E8
      Q2U1(I,J) =  (QSR2 + QMS2) * BETAU + QVW2
    enddo
  enddo
  RETURN
END
!
!
!                                                               ========
!================================================================ ELECFD
SUBROUTINE  ELECFD
!
!     ------ Electric field  by  Naoya Sawaguchi[Hirao P -> Nirin] -----
!
  use param
  use counts
  use temprs
  use atomsi
  use paramt
  use forces
  use outerf
  use charge
!
  implicit none
!
  double precision  FCOUNT,REFREQ,CTIME
  double precision  EFDX,EFDY,EFDZ,DEE
  double precision  fefx,fefy,fefz,ZZZ
  integer(KIND=4) i,mswtch
!ccccc
!     --- MEFD = mode of the electric field ---
!           0 ... Static electric field
!           1 ... ( 0 to E) pulse
!           2 ... (-E to E) pulse
!           3 ... saw tooth pulse   incomplete
!           4 ... sine oscillator
!
!         write(6,*) MEFD, EFREQ
!         write(6,*) EFD(1),EFD(2),EFD(3)
  IF (NRECRD(1)  ==  1) THEN
    MSWTCH = 1
    FCOUNT = 1.000000D0
  END IF
  IF (EFREQ  /=  0.00000D0) REFREQ = 1.000D0 / EFREQ
  CTIME = DTIME*NRECRD(1)
  IF (MEFD  ==  0) THEN
    EFDX = EFD(1)
    EFDY = EFD(2)
    EFDZ = EFD(3)
  ELSEIF (MEFD  ==  1) THEN
    IF (CTIME  >=  REFREQ*FCOUNT) THEN
      MSWTCH = -MSWTCH
      FCOUNT = FCOUNT + 1.000000D0
    END IF
    IF (MSWTCH  >  0) THEN
      EFDX = EFD(1)
      EFDY = EFD(2)
      EFDZ = EFD(3)
    ELSE
      EFDX = 0.000000D0
      EFDY = 0.000000D0
      EFDZ = 0.000000D0
    END IF
  ELSEIF (MEFD  ==  2) THEN
    IF (CTIME  >=  REFREQ*FCOUNT) THEN
      MSWTCH = -MSWTCH
      FCOUNT = FCOUNT + 1.000000D0
    END IF
    EFDX = EFD(1) * DBLE(MSWTCH)
    EFDY = EFD(2) * DBLE(MSWTCH)
    EFDZ = EFD(3) * DBLE(MSWTCH)
!         ELSEIF (MEFD  ==  3) THEN
!            FREQP4 = EFREQ / 4.000000D0
!               ExSLP = EFD(1)/FREQP4
!               EySLP = EFD(2)/FREQP4
!               EySLP = EFD(3)/FREQP4
!            IF (CTIME  >=  FREQP4*FCOUNT) THEN
!               MSWTCH = -MSWTCH
!               FCOUNT = FCOUNT + 1.000000D0
!               ExSLP = -ExSLP
!               EySLP = -EySLP
!               EySLP = -EySLP
!            END IF
!            IF (MSWTCH  >  0) THEN
!               EFDX = EFD(1)
!               EFDY = EFD(2)
!               EFDZ = EFD(3)
!            ELSE
!               EFDX = 0.000000D0
!               EFDY = 0.000000D0
!               EFDZ = 0.000000D0
!            END IF
!
  ELSEIF (MEFD  ==  4) THEN
    DEE  = SIN(PI2*EFREQ*CTIME)
    EFDX = EFD(1)*DEE
    EFDY = EFD(2)*DEE
    EFDZ = EFD(3)*DEE
!            write(6,*) EFDX,EFDY,EFDZ    ! check AC
  END IF
!
  DO I=IONS(1,NATOM),NTION
    fefx = 0.0000D0
    fefy = 0.0000D0
    fefz = 0.0000D0
!           ZIO =0, or EFD =0 then fef = 0 naturally
!           ZZZ  = ZII(I) * ELC              ! esu
    ZZZ  = ZII(I) * 1.602176462D-19   ! Coulomb
    fefx = EFDX * ZZZ
    fefy = EFDY * ZZZ
    fefz = EFDZ * ZZZ
!
    FX(I) = FX(I) + fefx
    FY(I) = FY(I) + fefy
    FZ(I) = FZ(I) + fefz
  END DO
END
!
!
!                                                               ========
!================================================================ GRAVFD
SUBROUTINE GRAVFD
!
!     ---------------------------------------------- Gravity field -----
!
  use param
  use atomsi
  use temprs
  use paramt
  use counts
  use forces
  use outerf
!
  implicit none
!
  double precision  GFDX, GFDY, GFDZ
  double precision G,W
  integer*4 io,I
!
!           ------ g = 9.8 m/s2 = 980 cm/s2
  g = 980.665 * 1.0E8
!
!           write(6,*) 'Gravity field ', GFD
  GFDX = GFD(1) * g
  GFDY = GFD(2) * g
  GFDZ = GFD(3) * g
!
!           write (6,*) fx(1),fy(1),fz(1)
!           write (6,*) gfdx*wio(1)/ana,gfdy*wio(1)/ana,gfdz*wio(1)/ana
  do io = 1, ncompo
    w = wio(io) / ANA
    DO  I = ions(1,io), ions(2,io)
      FX(I) = FX(I) + w * gfdx
      FY(I) = FY(I) + w * gfdy
      FZ(I) = FZ(I) + w * gfdz
    END DO
  end do
  return
END
!
!
!                                                          =============
!=========================================================== Wall at z=0
      SUBROUTINE  WALL
!
!     ---------------------------------------------- Gravity field -----
!
  use param
  use atomsi
  use aboxof
  use paramt
  use counts
  use forces
  use outerf
  use wallp
!
  implicit none
!
  integer*4 I,IO
  double precision RIZ,BW,AW,BETA
!
  BETA = CAL * 1.0D10 / ANA
!     write (6,*)  'wall',walla,wallb
!
  do io = 1, ncompo
    aw = walla + aio(io)
    bw = wallb + bio(io)
!        write (6,*) io,aw,bw
    DO  I = ions(1,io), ions(2,io)
      riz = P(3,i)*BOX(3)
      Fz(I) = Fz(I) + beta * exp((aw-riz)/bw) * 1.0E8
      UI(I) = UI(I) + beta * bw * exp((aw-riz)/bw)
    END DO
  end do
  return
END
!
!
!                                                                =======
!================================================================ SCCELL
SUBROUTINE  SCCELL
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use cartes
!
  implicit none
!
!     -------------------------- Basic cell scaling for pressure control
!
!
  double precision    FA(3), FK, DVOO, DVO, DFV, DAL(3), DDD
  double precision    apxyz,aspres,flmt,dp,dpp
  integer*4    i,j
!
  IF (RUNOPT(6) /= 'P SCALING ' .AND. RUNOPT(7) /= 'D CONST.  '     )  RETURN
!
100 APXYZ   = (PXYZ(2) + PXYZ(3) + PXYZ(4)) / 3.0D0
  APXYZ   = PXYZ(1) - APXYZ
  PXYZ(2) = PXYZ(2) + APXYZ
  PXYZ(3) = PXYZ(3) + APXYZ
  PXYZ(4) = PXYZ(4) + APXYZ
!
  ASPRES = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0D0
  FLMT   = 1.0D0 / (1.0D0 + ASPRES/25.0D0)
  IF (VBOX(1) < 1.0D-5)  VBOX(1) = 1.0D0
  DO I = 1, 3
    DP  = PXYZ(I+1) - PPXYZ(I+1)
    DPP = PXYZ(I+1) - SPRES(I)
    IF (DP*DPP > 0.0D0)  VBOX(1) = VBOX(1) / 1.05D0
    IF (DP*DPP < 0.0D0)  VBOX(1) = VBOX(1) * 1.05D0
  enddo
!  IF (VBOX(1) < 0.2D0)   VBOX(1) = 0.2D0
  IF (VBOX(1) < 0.1D0)   VBOX(1) = 0.1D0
  IF (VBOX(1) > FLMT)  VBOX(1) = FLMT
!
50 DVOO = 1.0D0
  DDD = 0.001D0 * 512.0D0
  DO I = 1, 3
    DVOO = DVOO * BOX(I)
    FK = ATAN((PXYZ(I+1) - SPRES(I))*VBOX(1)*DDD) / 512.0D0
    FA(I)  = 1.0D0 +  FK
    BOX(I) = BOX(I) * FA(I)
    DAL(I) = BOX(I)
    DO J = 1, 3
      H(J,I) = H(J,I) * FA(I)
    enddo
  enddo
  DO I = 1, 7
    PPXYZ(I) = PXYZ(I)
  enddo
!
  IF (RUNOPT(7) == 'D CONST.  ')  THEN
    DVO = DAL(1) * DAL(2) * DAL(3)
    DFV = (DVOO / DVO)**(1.0d0/3.0d0)
    DO I = 1, 3
      BOX(I) = DAL(I) * DFV
      DO J = 1, 3
        H(J,I) = H(J,I) * DFV
      enddo
    enddo
  END IF
!
  CALL  TABLER  (0)
RETURN
END
!
!
!                                                               ========
!=============================================================== RECORD9
SUBROUTINE  RECORD9
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use values
  use radial
  use acoord
  use charge
  use molecu
!
  implicit none
!
!     ------------------------------------------------- Out put FILE09's
!
  COMMON /WORK01/ VV(3,LNI), PPK(3,LNI)
  double precision  VV, PPK
  COMMON /WORK02/ IP(3,LNI), JPS(3,LNI)
  integer*4 IP,JPS
!
  double precision    UIUI(LNI)
  double precision    SSS
  double precision PK,DPK
  CHARACTER *10   DUMMY
  integer(KIND=4) I,J,KON
!
  DUMMY = '          '
!     ----------------------------------------------------------- Values
  IF (NRECRD(1) == 1)  THEN
      VAL0(:) = VAL(:)
  END IF
  NAVT = NAVT + 1
  DO I = 1, LVA
    SSS       = VAL(I)   - VAL0(I)
    TVALL(I)  = TVALL(I) + SSS
    SVALL(I)  = SVALL(I) + SSS*SSS
    IF (VALMAX(I) < VAL(I))   VALMAX(I) = VAL(I)
    IF (VALMIN(I) > VAL(I))   VALMIN(I) = VAL(I)
  enddo
!     --------------------------------------------------- FILE09P for MD
  IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
    IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
      IF (MOD(NRECRD(1),IRECRD(4)) == 0) THEN
        NRECRD(4) = NRECRD(4) + 1
        IF (RUNOPT(18) == 'BINARY    ') THEN
          WRITE (19) NRECRD(4), BOX(1), 0.0, 0.0,  0.0, BOX(2), 0.0, 0.0, 0.0, BOX(3)
          WRITE (19) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IP(J,I)  = P(J,I) * 90000.D0
            enddo
          enddo
          WRITE (19,9001)  NRECRD(4),  BOX(1),0.0, 0.0, 0.0, BOX(2),0.0, 0.0, 0.0, BOX(3)
          WRITE (19,9002)  ((IP(J,I),J=1,3),I=1,NTION)
        END IF
!       ================================================Write on charge.dat  WATER-POL
        IF (ICD == 1) then ! FLNAME(16) = 'charge.dat     '
!          write(*,*)'ndmole = ',ndmole
          write (26,'(i10)') nrecrd(1)
          write (26,'(10(F7.4,1x))') (ZII(i),i=1,ntion+ndmole)
        ENDIF
!       ======================================================================
      END IF
    END IF
  END IF
!        -------------------------------------------- Coordinates for XD
  IF (RUNOPT(17) == 'CRYSTAL   ')  THEN
    DO I = 1, NPTP
      KON = JON(I)
      DO J = 1, 3
        PK = P(J,KON)
        DPK = PK - P0C(J,I) / dble(NBOX(J))
        IF (DPK >  0.5d0)  PK = PK - 1.0d0
        IF (DPK < -0.5d0)  PK = PK + 1.0d0
        PPK(J,I) = PK
        JPS(J,I) = PK*9000
        if (jps(j,i) <= -1000)  jps(j,i)=jps(j,i)+10000
        if (jps(j,i) >= 10000)  jps(j,i)=jps(j,i)-10000
        IF (I <= NPT)  THEN
          PK = PK * NBOX(J)
          PPC(J,I) = PPC(J,I) + PK
          PPS(J,I) = PPS(J,I) + PK*PK
        END IF
      enddo
    enddo
!              ------------------------------------------ FILE09P for XD
    IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
      IF (MOD(NRECRD(1),IRECRD(4)) == 0) THEN
        NRECRD(4) = NRECRD(4) + 1
        DUMMY = 'POSITION'
        IF (RUNOPT(18) == 'BINARY    ') THEN
          WRITE (19) NRECRD(4), BOX(1), 0.0, 0.0, 0.0, BOX(2), 0.0, 0.0, 0.0, BOX(3)
          WRITE (19) ((PPK(J,I),J=1,3),I=1,NPTP)
        ELSE
          WRITE (19,9001)  NRECRD(4), BOX(1),0.0, 0.0, 0.0, BOX(2),0.0, 0.0, 0.0, BOX(3)
          WRITE (19,9002)  ((JPS(J,I),J=1,3),I=1,NPTP)
        END IF
      END IF
    END IF
  END IF
!        ------------------------------------------------------- FILE09V
  IF (MOD(NRECRD(1),IRECRD(5)) == 0) THEN
    NRECRD(5) = NRECRD(5) + 1
    IF (TITLE(1) /= 'BENC'     .OR. TITLE(2) /=     'HMAR'     )  THEN
      WRITE (29,1991)  (VAL(I),I=1,LVA)
! 1991 FORMAT (F8.2,7F8.4   / 8F9.2  / F9.5,  F9.3,  3F9.5, 3F9.5  / 10F8.2 / 10F8.3 )
 1991 FORMAT (F10.3,7F10.5 / 8F10.3 / F10.6, F10.4, 3F10.6,3F10.7 / 20F9.3 / 20F9.3 )
    END IF
  END IF
!        ------------------------------------------------------ FILE09PV
  IF (RUNOPT(11) /= '          ')  THEN
!               NRECRD(9) = NRECRD(9) + 1
    IF (TITLE(1) == 'BENC'     .AND. TITLE(2) ==     'HMAR'     )  RETURN
    IF (RUNOPT(11) == 'VELOCITY  ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        NRECRD(9) = NRECRD(9) + 1
        IF (RUNOPT(18) == 'BINARY    ') THEN
          DO I = 1, NTION
            DO J = 1, 3
              VV(J,I) = V(J,I) / DTIME
            enddo
          enddo
          WRITE(28)  NRECRD(1)
          WRITE(28) ((VV(J,I),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IP(J,I)=V(J,I)*PVMULT*1E-15 /DTIME+50000.D0
            enddo
          enddo
          WRITE(28,9001)  NRECRD(1)
          WRITE(28,9002)((IP(J,I),J=1,3),I=1,NTION)
        END IF
      END IF
    END IF
    IF (RUNOPT(11) == 'POSITION  ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        IF (RUNOPT(18) == 'BINARY    ')  THEN
          WRITE (28) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
          WRITE (28) ((SNGL(P(J,I)),J=1,3),I=1,NTION)
        ELSE
          DO I = 1, NTION
            DO J = 1, 3
              IP(J,I) = P(J,I) * PVMULT
            enddo
          enddo
          WRITE(28,9001) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
          WRITE(28,9002)((IP(J,I),J=1,3),I=1,NTION)
        END IF
      END IF
    END IF
    IF (RUNOPT(11) == 'ENERGY    ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        DO I = 1, NTION
          UIUI(I) = UI(I) * PVMULT
        enddo
        WRITE(28,9001) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
        WRITE(28,9003)(UIUI(I),I=1,NTION)
      END IF
    END IF
    IF (RUNOPT(11) == 'POSVELENE ')  THEN
      IF (MOD(NRECRD(1),IRECRD(9)) == 0)  THEN
        DO I = 1, NTION
          vv(1,i) = v(1,i)*1E-15 /DTIME
          vv(2,i) = v(2,i)*1E-15 /DTIME
          vv(3,i) = v(3,i)*1E-15 /DTIME
          UIUI(I) = UI(I) * PVMULT
        enddo
        WRITE(28,9001) NRECRD(1), BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0, 0.0, BOX(3)
        do i = 1, ntion
          WRITE (28,9004) (P(j,i),j=1,3),(Vv(j,i),j=1,3), UIUI(I)
        enddo
      END IF
    END IF
  END IF
!        ---------------------------------------- Pressure tensor FILE11
  IF (RUNOPT(19) == 'PRESSURE  ') WRITE (27,'(7F9.4)')  (VAL(J),J=2,8)
RETURN
!
 9001 FORMAT (I7,3x,9F7.3)
 9002 FORMAT (18I5)
 9003 FORMAT (10F8.2)
 9004 FORMAT (3F7.5,1X,3F8.6,1X,F8.4)
END
!
!
!                                                               ========
!================================================================ INTVAL
SUBROUTINE  INTVAL
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use geomet
  use values
  use radial
  use acoord
  use quanco
!
  implicit none
!     --------------------------------------- Print average values, etc.
!
!
  CHARACTER *8    SYMB(2)
  CHARACTER *21   STRING
  CHARACTER *40   FMT1(2),FMT11,FMT12, FMT2(3),FMT21,FMT22,FMT23
  EQUIVALENCE  (FMT1(1),FMT11),(FMT1(2),FMT12),(FMT2(1),FMT21),(FMT2(2),FMT22),(FMT2(3),FMT23)
  double precision  TVV(LVA),TSS(LVA)
  integer(KIND=4)      ISDV(LEM+1),IVMIN(LEM+1),ITSS(LEM+1),IAVA(LEM+1),ITVV(LEM+1),IVMAX(LEM+1)
  double precision      X, Y
  double precision      std,fl
  integer(KIND=4)      i,j,mmm,nn,mm,mj,ii
  DATA  SYMB / 'MAX.  ', 'MIN.  '/
  STD(X,Y,I) = SQRT(ABS(X - Y*(Y/DBLE(I)))  / DBLE(I))
!
  NAV = NAV + 1
  DO I = 1, LVA
    TVAL(I)  = TVAL(I) + TVALL(I)
    SVAL(I)  = SVAL(I) + SVALL(I)
    SVALL(I) = STD(SVALL(I),TVALL(I),IRECRD(3))
    TVALL(I) = TVALL(I) / dble(IRECRD(3)) + VAL0(I)
    AVA(I,NAV) = TVALL(I)
  enddo
  DO I = 1, LEM
    IAVA(I) = INT(TVALL(24+I))
    ISDV(I) = INT(SVALL(24+I))
  enddo
    IAVA(LEM+1) = INT(TVALL(1))
    ISDV(LEM+1) = INT(SVALL(1))
!
  IF (RUNOPT(3) /= 'ECONOMY  ')  WRITE (16,2100)
!     ------------------------------------- Each nrecrd() step on screen
  FMT11 = '(1X,A3,I6,F7.4,1H(,3F5.2,1H),'
  FMT12 = ' F9.1,F8.1,F6.1,F9.1,F8.5 )  '
  IF (ABS(TVALL(2)) > 9.5.AND.ABS(TVALL(2)) <= 95.0) THEN
    FMT11 = '(1X,A3,I6,F7.3,1H(,3F5.1,1H),'
  ELSE IF (ABS(TVALL(2)) > 95.0)  THEN
    FMT11 = '(1X,A3,I6,F7.2,1H(,3F5.0,1H),'
  END IF
  IF (ABS(TVALL(9)) < 1.0D4.AND.ABS(TVALL(14)) < 1.0D4) THEN
    FMT12 = ' F9.2,F8.2,F6.2,F9.2,F8.5 )  '
  END IF
  WRITE (*,4001)
  WRITE (*,FMT1) 'Avr',IAVA(LEM+1),(TVALL(J),J=2,5),TVALL(9),TVALL(10),TVALL(11),TVALL(14),TVALL(17)
  WRITE (*,FMT1) 'Std',ISDV(LEM+1),(SVALL(J),J=2,5),SVALL(9),SVALL(10),SVALL(11),SVALL(14),SVALL(17)
  WRITE (*,4001)
  write (*,2400)  (ATOM(j),IAVA(j),j=1,ncompo)
2400 format (1x,'Temperatures:',8(1X,A2,':',I4))
  write (*,4001)
4001 FORMAT ( 80('-') )
!     --------------------------------- Each nrecrd() step on file06.dat
  FMT11 = '(I5,    5I5,F8.4,1H(,6F6.3,1H),     '
  FMT12 = ' F10.2,F9.2,2F7.2,F10.3, F9.5 )     '
  FMT21 = '(i3,3H0K+,I4,4I5,F8.4,1H(,6F6.3,1H),'
  FMT22 = ' F10.2,F9.2,2F7.2,F10.3,    F9.5 )  '
  FMT23 = '                                    '
  IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
    FMT11 = '(I5,     5I5,F8.3,1H(,6F6.2,1H),    '
    FMT21 = '(i3,3H0K+,I4,4I5,F8.3,1H(,6F6.2,1H),'
  ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
    FMT11 = '(I5,     5I5,F8.2,1H(,6F6.1,1H),    '
    FMT21 = '(i3,3H0K+,I4,4I5,F8.2,1H(,6F6.1,1H),'
  END IF
  IF (ABS(TVALL(9)) < 1.0D4.AND.ABS(TVALL(14)) < 1.0D4)  THEN
    FMT12 = ' F10.3,F9.3,2F7.3,F10.4,    F9.5 )  '
    FMT22 = ' F10.3,F9.3,2F7.3,F10.4,    F9.5 )  '
  END IF
  mmm = NRECRD(1)/100000
  WRITE (16,FMT1)  mod(NRECRD(1),100000), &
                       (IAVA(I),I=1,4),IAVA(LEM+1),(TVALL(J),J=2,11), &
                                       TVALL(13),TVALL(14),TVALL(17)
      WRITE (16,FMT2)  mmm, (ISDV(I),I=1,4), ISDV(LEM+1), &
                            (SVALL(J),J=2,11), SVALL(13), SVALL(14), &
                                               SVALL(17)
!
  NN = IRECRD(2)/IRECRD(3)
  MM = MOD(NRECRD(1)/IRECRD(3), NN)
  MJ = 2

  IF (RUNOPT(3) == 'ECONOMY  ') MJ = 10
  IF (MOD(MM,MJ) /= 0)  RETURN
!
  DO I = 1, LVA
    TSS(I) = STD(SVAL(I),TVAL(I),NAVT)
    TVV(I) = TVAL(I) / dble(NAVT) + VAL0(I)
  enddo
  DO I = 1, LEM
    IVMAX(I) = INT(VALMAX(24+I))
    IVMIN(I) = INT(VALMIN(24+I))
    ITSS(I)  = INT(TSS(24+I))
    ITVV(I)  = INT(TVV(24+I))
  enddo
  IVMAX(LEM+1) = INT(VALMAX(1))
  IVMIN(LEM+1) = INT(VALMIN(1))
  ITSS(LEM+1)  = INT(TSS(1))
  ITVV(LEM+1)  = INT(TVV(1))
!
!        --------------------------------------------------- Min and max
  WRITE (16,2105)
  FMT11 = '(1X,A4, 5I5,F8.4,1H(,6F6.3,1H), '
  IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
    FMT11 = '(1X,A4, 5I5,F8.3,1H(,6F6.2,1H), '
  ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
    FMT11 = '(1X,A4, 5I5,F8.2,1H(,6F6.1,1H), '
  END IF
  WRITE (16,FMT1)  SYMB(1), (IVMAX(I),I=1,4),IVMAX(LEM+1),(VALMAX(J),J= 2,11),  &
                   VALMAX(13),VALMAX(14),VALMAX(17)
  WRITE (16,FMT1)  SYMB(2), (IVMIN(I),I=1,4),IVMIN(LEM+1),(VALMIN(J),J= 2,11),  &
                   VALMIN(13),VALMIN(14),VALMIN(17)
!        ------------------------------ Each nrecrd() step in file06.dat
  FMT11 = '(I5,5I5,F8.4,1H(,6F6.3,1H),        '
  IF (ABS(TVALL(2)) > 9.0.AND.ABS(TVALL(2)) < 95.0)  THEN
    FMT11 = '(I5,5I5,F8.3,1H(,6F6.2,1H),        '
  ELSE IF (ABS(TVALL(2)) >= 95.0)  THEN
    FMT11 = '(I5,5I5,F8.2,1H(,6F6.1,1H),        '
  END IF
  mmm = NAVT / 100000
  WRITE (16,2105)
  WRITE (16,FMT1)  mod(NAVT,100000), (ITVV(I),I=1,4),ITVV(LEM+1),  &
                   (TVV(J),J=2,11),TVV(13),TVV(14),TVV(17)
  WRITE (16,FMT2)  mmm,  (ITSS(I),I=1,4),ITSS(LEM+1),  &
                   (TSS(J),J=2,11),TSS(13),TSS(14),TSS(17)
  WRITE (16,2105)
  if (NCOMPO > 4) then
    write (16,2500)  (ATOM(j),TVV(24+j),j=1,ncompo)
 2500          format (' Temperatures:',10(2X,A2,':',F6.1))
    WRITE (16,2105)
  end if
  WRITE (16,2880)  VCORR/(3.0D0*VOL*1.0D-24)*1.0D-10,ECORR*FJMOL
 2880    FORMAT (8X,'Corrections for van der Waals interactions ', &
                 '(approx.) : Pcorr=',F8.4,' GPa',9X,'Ecorr(short)=', &
                F8.3,' kJ/mol')
  IF (RUNOPT(12) == 'QUANTUM   ')  THEN
    WRITE (16,2990)  TEMPQH/NAVT
 2990          FORMAT (8X,'Effective temperature in quantum correction',' is ',F7.2, ' K')
  END IF
  WRITE (16,2105)
!
!     ------------------------------------------ Basic cell edge lengths
  WRITE (16,'(1X)')
  WRITE (16,'("I",74("-"),"I")')
  STRING = '[ MD basic cell ]    '
  IF (RUNOPT(17) == 'CRYSTAL   ')  STRING = '[ crystal unit cell ]'
  WRITE (16,4000)  STRING,(TVALL(I),  SVALL(I),  VALMIN(I),  VALMAX(I),I=19,21)
 4000 FORMAT ('I Cell dimensions (Angstrom, degree)',10X,A21,8X,'I' &
             /'I    A:', F9.5,' (+-',F7.5,') ',F9.5,' -',F9.5,5X, &
                                           'Alpha: 90.0 (fixed)  I', &
             /'I    B:', F9.5,' (+-',F7.5,') ',F9.5,' -',F9.5,5X, &
                                           'Beta : 90.0 (fixed)  I', &
             /'I    C:', F9.5,' (+-',F7.5,') ',F9.5,' -',F9.5,5X, &
                                           'Gamma: 90.0 (fixed)  I' )
!     --------------------------------------------------------- Energies
  WRITE (16,'("I",74("-"),"I")')
  WRITE (16,4030)  TVV(12),TSS(12), TVV(14),TSS(14), &
                       TVV(13),TSS(13), TVV(16),TSS(16), &
                       TVV(15),TSS(15), TVV(18),TSS(18)
 4030 FORMAT ('I  U =',F11.4, '(',F7.4,')kJ/mol   E = U+K =',F12.4, &
                               '(',F7.4,')kJ/mol    I' / &
              'I  K =',F11.4, '(',F7.4,')kJ/mol   H = E+PV=',F12.4, &
                               '(',F7.4,')kJ/mol    I' / &
              'I  PV=',F11.4,'(',F7.4,')kJ/mol   ', &
                   'Molar volume=',F10.4,'(',F7.4,')cm3/mol I')
  WRITE (16,'("I",74("-"),"I")')
!     ---------------------------------------- Mean square displacements
  FL = 1
  DO I = 1, 10
    IF (VALMAX(I+24+LEM) >= 10.0)   FL = 10
    IF (VALMAX(I+24+LEM) >= 100.0)  FL = 100
    IF (VALMAX(I+24+LEM) >= 100.0)  FL = 1000
  enddo
  FMT21 = '(8HI M.s.d.                        '
  FMT22 = '2(3X,A2, 1H:, F6.3, 1H(, F5.3,1H),  '
  FMT23 = ' F6.3,1H-, F6.3,1X), 2H I )         '
  IF (FL >= 10) THEN
    FMT22 = '2(3X,A2, 1H:, F6.2, 1H(, F5.2,1H),  '
    FMT23 = ' F6.2,1H-, F6.2,1X), 2H I )         '
  END IF
  IF (FL >= 100) THEN
    FMT22 = '2(3X,A2, 1H:, F6.1, 1H(, F5.2,1H),  '
    FMT23 = ' F6.1,1H-, F6.1,1X), 2H I )         '
  END IF
  WRITE (16,FMT2)  (ATOM(I),TVALL(I+24+LEM),SVALL(I+24+LEM),VALMIN(I+24+LEM),VALMAX(I+24+LEM),I=1,2)
  FMT21 = '(8H I      ,                       '
  DO II = 1, 4
    IF (NCOMPO > II*2)  WRITE (16,FMT2)  (ATOM(I),TVALL(I+24+LEM), &
                       SVALL(I+24+LEM),VALMIN(I+24+LEM),VALMAX(I+24+LEM),I=II*2+1,II*2+2)
  enddo
  WRITE (16,'("I",74("-"),"I")')
!     ------------------------------------------------------------------
    VALMIN(:) = 9.9D19
    VALMAX(:) =-9.9D19
RETURN
!
 2100 FORMAT (132('-'))
 2105 FORMAT (132('='))
END
!
!
! 
!                                                               ========
!     =========================================================== SUMMRY
SUBROUTINE  SUMMRY
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use values
  use radial
  use acoord
!
  implicit none
!
!     --------------------------------------- Print average values, etc.
!
  CHARACTER *8    HEAD(2)
  CHARACTER *40   FMT1(2),FMT11,FMT12
  EQUIVALENCE     (FMT1(1),FMT11), (FMT1(2),FMT12)
  double precision  X, Y
  double precision  std,ava2i,tval2
  integer(KIND=4)  i,j,ii
  DATA  HEAD / 'AVE' , 'SGM'/
  
!
  STD(X,Y,I) = SQRT(ABS(X - Y*(Y/DBLE(I)))  / DBLE(I))  !statement function
!
  IF (IRECRD(1) <= 0)  RETURN
!
  WRITE (16,2000)
  WRITE (16,2100)
  WRITE (16,2452)
 2452 FORMAT (' NS   Temp   P/GPa (  Pxx,  Pyy,  Pzz,  Pxy,  ', &
              'Pxz,  Pyz )  U:Coulomb   Short 3-body Kinet.  ', &
              'Total   Density    Cell parameters (A)')
  WRITE (16,2100)
  DO I = 1, NAV
    AVA2I = ABS(AVA(2,I))
    FMT11 = '(I4, F7.1, F8.4,1H(,6F6.3,1H),          '
    FMT12 = 'F10.2,F9.2,2F7.2,F9.2, F8.5,1X,3F8.4)   '
    IF (AVA2I > 9.0 .AND. AVA2I < 95.0)  THEN
      FMT11 = '(I4, F7.1, F8.3,1H(,6F6.2,1H),          '
    ELSE IF (AVA2I >= 95.0)  THEN
      FMT11 = '(I4, F7.1, F8.2,1H(,6F6.1,1H),          '
    END IF
    IF (ABS(AVA(9,I)) < 1.0D4.AND.ABS(AVA(14,I)) < 1.0D4)  THEN
      FMT12 = 'F10.3,F9.3,2F7.3,F9.3, F8.5,1X,3F8.4)   '
    END IF
    WRITE (16,FMT1)  I,(AVA(J,I),J=1,11), AVA(13,I), AVA(14,I), AVA(17,I),(AVA(J,I),J=19,21)
  enddo
!
  DO I = 1, LVA
    SVAL(I) = STD(SVAL(I),TVAL(I),NAVT)
    TVAL(I) = TVAL(I) / dble(NAVT) + VAL0(I)
  enddo
  WRITE (16,2100)
!
  TVAL2 = ABS(TVAL(2))
  FMT11 = '(1X,A3, F7.1, F8.4,1H(,6F6.3,1H),    '
  FMT12 = 'F10.2,F9.2,2F7.2,F9.2, F8.5,1X,3F8.4)'
  IF (TVAL2 > 9.0 .AND. TVAL2 < 95.0)  THEN
    FMT11 = '(1X,A3, F7.1, F8.3,1H(,6F6.2,1H),    '
  ELSE IF (TVAL2 >= 95.0)  THEN
    FMT11 = '(1X,A3, F7.1, F8.2,1H(,6F6.1,1H),    '
  END IF
  IF (ABS(TVAL(9)) < 1.0D4.AND.ABS(TVAL(14)) < 1.0D4)  THEN
    FMT12 = 'F10.3,F9.3,2F7.3,F9.3, F8.5,1X,3F8.4)'
  END IF
  WRITE (16,FMT1)  HEAD(1),(TVAL(J),J=1,11),TVAL(13),TVAL(14),TVAL(17),(TVAL(J),J=19,21)
  WRITE (16,FMT1)  HEAD(2),(SVAL(J),J=1,11),SVAL(13),SVAL(14),SVAL(17), (SVAL(J),J=19,21)
  WRITE (16,2100)
!     --------------------------------------------------------- Energies
  WRITE (16,'(1X)')
  WRITE (16,'("I",75("-"),"I")')
  WRITE (16,4030)  TVAL(12),SVAL(12), TVAL(14),SVAL(14),  &
                       TVAL(13),SVAL(13), TVAL(16),SVAL(16), &
                       TVAL(15),SVAL(15), TVAL(18),SVAL(18)
 4030 FORMAT ('I  U =',F11.4, '(',F7.4,')kJ/mol   E = U+K =',F12.4, &
                               '(',F7.4,')kJ/mol     I' / &
              'I  K =',F11.4, '(',F7.4,')kJ/mol   H = E+PV=',F12.4, &
                               '(',F7.4,')kJ/mol     I' / &
              'I  PV=',F11.4,'(',F7.4,')kJ/mol   ', &
                   'Molar volume=',F10.4,'(',F7.4,')cm3/mol  I')
  WRITE (16,'("I",75("-"),"I")')
!     ----------------------------------------------------------- M.s.d.
  WRITE (16,4020)  (ATOM(I),TVAL(I+34),SVAL(I+34),I=1,2)
 4020 FORMAT ('I  Mean sq.disp. ',2(5X,A2,':',F8.3,' (+-',F6.3,')'),'     I' )
  DO II = 1, 4
    IF (NCOMPO > II*2)  WRITE (16,4022)  (ATOM(I),TVAL(I+34),SVAL(I+34),I=II*2+1,II*2+2)
 4022    FORMAT ('I',16X,2(5X,A2,':',F8.3,' (+-',F6.3,')'),5X,'I' )
  enddo
  WRITE (16,'("I",75("-"),"I")')
!     ------------------------------------------------------------------
  WRITE (16,4050)  TVAL(1), TVAL(2), TVAL(12),TVAL(13),TVAL(14), &
                       TVAL(15),TVAL(16),TVAL(17),TVAL(18), &
                       SVAL(1), SVAL(2), SVAL(12),SVAL(13),SVAL(14), &
                       SVAL(15),SVAL(16),SVAL(17),SVAL(18), &
                       TVAL(1),TVAL(2),(TVAL(I),I=19,24), &
                       SVAL(1),SVAL(2),(SVAL(I),I=19,24)
 4050 FORMAT (/ 78('=') / '  T/K    P/GPa   U/kJ/m.  K/kJ/m.  E(U+K) ', &
             '   PV      H(E+PV)  D/g/cm3  V/c3/m ' / 78('-') / &
             1X,F6.1,F8.4, F10.3,F8.3,F10.3,F8.3,F10.3, F8.4,F8.3,1X / &
             1X,F6.1,F8.4, F10.3,F8.3,F10.3,F8.3,F10.3, F8.4,F8.3,1X / &
             78('=') / '  T/K    P/GPa        A         B         C  ', &
                        '    Alpha     Beta      Gamma' / 78('-') / &
             1X,F6.1,F8.4,1X,3F10.5,3F10.4 / &
             1X,F6.1,F8.4,1X,3F10.5,3F10.4 / 78('=') )
RETURN
 2000 FORMAT (1X)
 2100 FORMAT (132('-'))
 2105 FORMAT (132('='))
END
!
!
!                                                               ========
!================================================================ PCFRCN
SUBROUTINE  PCFRCN
  use param
  use charac
  use counts
  use aboxof
  use atomsi
  use radial
!
  implicit none
!
!     -------------------------------------- Pair correlation functions,
!                                          Running coordination numbers,
!
  CHARACTER *40   FORM1, FORM2, FORM3, FORM4
  REAL   PCF(LEF),RHO(LEF),RCN(LEF),PATOM(LEF)
  integer(KIND=4)    KRCN(LEF),KPCF(LEF)
  integer(KIND=4)    IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
  integer(KIND=4)    IMULT,I,J,L,IND,IEND,K,NNCOMPO
  real      AM,EI,EJ,R1,R2,VS,PRN,PRD
!
!     --------------------------------------- Print pair-RDF's and RCN's
!         IPRDF(1) : Interval of printing RDF's (0.001*IPRDF(1))
!         IPRDF(2) : End of printing RDF's (IPRDF(2)*0.01 Angstroms)
!
  CALL  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  WRITE (16, 1111)  NJOB,TITLE, NRECRD(2), IHOUR,IMINUT,ISECND,IYEAR,IMONTH,IDAY
 1111 FORMAT (//'<<<',I4,'-',I2,'  >>>  ',14A4,A2,' <<< ',I5,  &
               ' steps  >>>   at ',I2,':',I2,':',I2, &
                           '  on ',I4,'/',I2,'/',I2 )
!
  NNCOMPO = NCOMPO
  IF(runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN') NNCOMPO = NCOMPO + 1
  NPAIR = NNCOMPO * (NNCOMPO+1) / 2
  IMULT = 100
  IF (NNCOMPO <= 2) THEN
    IMULT = 1
    FORM1 = '(7X,         3(7X,A2,1H-,A2,2X))        '
    FORM2 = '(7H R /A  ,  3(14H    pcf  rcn  )     ) '
    FORM3 = '(1X,F5.3,1X, 3(F8.3,F6.3),F6.2)         '
    FORM4 = '(50(1H-)                              ) '
  ELSE IF (NNCOMPO == 3)  THEN
    IMULT = 1
    FORM1 = '(7X,         6(6X,A2,1H-,A2,1X))        '
    FORM2 = '(7H R /A  ,  6(12H    pcf rcn )       ) '
    FORM3 = '(1X,F5.3,1X, 6(F7.2,F5.2),F6.2)         '
    FORM4 = '(80(1H-)                              ) '
  ELSE IF (NNCOMPO == 4)  THEN
    FORM1 = '(7X,         10(5X,A2,1H-,A2))          '
    FORM2 = '(7H R /A  ,  10(10H   pcf rcn)        ) '
    FORM3 = '(1X,F5.3,1X, 10(I6,I4),F6.2)            '
    FORM4 = '(108(1H-)                             ) '
  ELSE IF (NNCOMPO == 5)  THEN
    FORM1 = '(7X,         15(3X,A2,1H-,A2))          '
    FORM2 = '(7H R /A  ,  15(8H pcf rcn)        )    '
    FORM3 = '(1X,F5.3,1X, 15(I4,I4),F6.2)            '
    FORM4 = '(127(1H-)                             ) '
  ELSE IF (NNCOMPO >= 6)  THEN
    IMULT = 10
    FORM1 = '(6X,        21(1X,A2,1H-,A2))           '
    FORM2 = '(6H R /A ,  21(6H pc cn)         )      '
    FORM3 = '(1X,F5.3,   21(I3,I3),F6.2)             '
    FORM4 = '(133(1H-)                             ) '
  END IF
!
  WRITE (16,2500)  IMULT
 2500 format (/ 'Pair correlation functions (pcf) and running ',  &
               'oordination numbers (rcn) of ion pairs ',  &
                '(multiplied by ',I4,')' /)
  IF (NNCOMPO <= 6)  THEN
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,NNCOMPO)
  ELSE
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,6)
  END IF
  WRITE (16,FORM2)
  WRITE (16,FORM4)
  L = 0
  DO I = 1, NNCOMPO
    DO J = 1, I
      L = L + 1
      AM = 1.0
      IF (I == J)  AM = 0.5
      EI = real(NION(I))
      EJ = real(NION(J))
      RCN(L)   = 0.0
      PATOM(L) = AMIN1(EI,EJ) * AM
      RHO(L)   = EI * EJ * AM /(BOX(1)*BOX(2)*BOX(3))
    enddo
  enddo
  IND  = 0
  I    = 10
  IEND = IPRDF(2)
!
280 R1 = real(I)* 0.01 + 0.005*real(IPRDF(1))
  R2 = R1 + 0.01*real(IPRDF(1))
  VS = 4.0*PI/3.0 * ((R2*R2*R2) - (R1*R1*R1))
  PRN = 0
  DO L = 1, NPAIR
    PCF(L) = 0.0
    IF (PATOM(L) > 1.0E-6) THEN
      PRD = 0.0
      DO K = 1, IPRDF(1)
        PRD = PRD + real(NRDF(I+K,L))
      enddo
      PRN    = PRN + PRD
      PRD    = PRD / real(NRECRD(2)/irecrd(5))
      RCN(L) = RCN(L) + PRD / PATOM(L)
      PCF(L) = PRD / (VS * RHO(L))
    END IF
  enddo
  DO L = 1, LEE
    KRCN(L) = INT(RCN(L) * IMULT + 0.5)
    KPCF(L) = INT(PCF(L) * IMULT + 0.5)
  enddo
  IF (PRN > 0.5.AND.IND == 0)  THEN
    IND  = 1
    IF (IEND > 9990)  IEND = I + 250
  END IF
  IF (IND == 1) THEN
    IF (NNCOMPO <= 3)  THEN
      WRITE (16,FORM3) R1+0.01,(PCF(K),RCN(K),K=1,NPAIR)
    ELSE IF (NNCOMPO <= 6)  THEN
      WRITE (16,FORM3) R1+0.01,(KPCF(K),KRCN(K),K=1,NPAIR)
    ELSE
      WRITE (16,FORM3) R1+0.01,(KPCF(K),KRCN(K),K=1,21)
    END IF
  END IF
  I = I + IPRDF(1)
  IF (I < IEND)  GO TO 280
  WRITE (16,FORM4)
  WRITE (16,FORM2)
  IF (NNCOMPO <= 6)  THEN
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,NNCOMPO)
  ELSE
    WRITE (16,FORM1)  ((ATOM(I),ATOM(J),J=1,I),I=1,6)
  END IF
!
RETURN
END
!
!
!                                                               ========
!================================================================ POTPLT
SUBROUTINE  POTPLT
  use param
  use charac
  use counts
  use atomsi
!
  implicit none
!
!     ------------------------------------ Distribution of ion potential
!
!
  CHARACTER *1    IGRAPH(132)
  double precision    BU(LNI),UMAX(LEM),UMIN(LEM),UAV(LEM)
  double precision    RNDF,AMAX,AMIN,UR,UOMIN,UOMAX
  integer(KIND=4)    NSTAT(132,LEM)
  integer(KIND=4)  IO,I1,I2,I,J,IAMIN,IAMAX,MUP,J1,J2,JU,N,NP,K,IOMIN,IOMAX
!
!     ------------------------------------------------- Ionic potentials
!
  RNDF = 1.0D12 / DBLE(IRECRD(2))
  AMAX = -9.9D19
  AMIN =  9.9D19
  DO IO = 1, NCOMPO
    UMAX(IO) = 0.0D0
    UMIN(IO) = 0.0D0
    UAV(IO)  = 0.0D0
    IF (IION(IO) <= -999)  cycle
    IF (NION(IO) > 0) THEN
      UMAX(IO) = -9.9D19
      UMIN(IO) =  9.9D19
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      DO I = I1, I2
        BU(I)   = AU(I) * RNDF
        UAV(IO) = UAV(IO) + BU(I)
        IF (UMAX(IO) < BU(I))  UMAX(IO) = BU(I)
        IF (UMIN(IO) > BU(I))  UMIN(IO) = BU(I)
      enddo
      UAV(IO) = UAV(IO) / DBLE(NION(IO))
      IF (AMAX < UMAX(IO))  AMAX = UMAX(IO)
      IF (AMIN > UMIN(IO))  AMIN = UMIN(IO)
      GO TO 160
    ELSE
      UMAX(IO) = 0.0D0
      UMIN(IO) = 0.0D0
    END IF
160 DO J = 1, 132
      NSTAT(J,IO) = 0
    enddo
  enddo
  WRITE (16,4004)
  WRITE (16,4001)
  WRITE (16,4000)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=1,6)
  IF (NCOMPO > 6)  THEN
    WRITE (16,4002)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=7,9)
    IF (NCOMPO > 9)  THEN
      WRITE (16,4003)  (ATOM(I), UAV(I), UMIN(I),UMAX(I), I=7,9)
    END IF
  END IF
!     ----------------------------------------------- Plot whole of ions
  IAMIN = INT(AMIN - 0.999999D0)
  IAMAX = INT(AMAX)
  IF (AMAX > 0.0D0)  IAMAX = INT(AMAX + 0.999999D0)
  UR = 131.0D0 / DBLE(IAMAX - IAMIN)
  MUP = 0
  DO IO = 1, NCOMPO
    IF (IION(IO) <= -999) cycle
    IF (NION(IO) <= 0)  cycle
    J1 = IONS(1,IO)
    J2 = IONS(2,IO)
    DO J = J1, J2
      JU = (BU(J) - DBLE(IAMIN)) * UR + 1.5D0
      NSTAT(JU,IO) = NSTAT(JU,IO) + 1
    enddo
    DO J = 1, 132
      IF (MUP < NSTAT(J,IO))  MUP = NSTAT(J,IO)
    enddo
  enddo
  IF (MUP > 20)  MUP = 20
  DO N = 1, MUP
!         WRITE (16,4004)
    NP = MUP + 1 - N
!         DO 420  I = 1, NCOMPO
    DO J = 1, 132
      IGRAPH(J) = ' '
    enddo
    IGRAPH(1)   = ':'
    IGRAPH(132) = ':'
    DO J = 1, 132
      DO I = 1, NCOMPO
        IF (IION(I) > -998)  THEN
          IF (NSTAT(J,I) >= NP)  IGRAPH(J) = ATOM(I)
        END IF
      enddo
    enddo
    WRITE (16, 4010)  (IGRAPH(K), K=1,132)
!  420 continue
  enddo
  WRITE (16, 4020) IAMIN, IAMAX
  IF (NION(1) <= 1)  RETURN
!     ---------------------------------------- Oxygen ion potential only
  DO I = 1, 132
    NSTAT(I,1) = 0
  enddo
  UOMIN = UMIN(1)
  UOMAX = UMAX(1)
  IOMIN = UOMIN - 0.999999D0
  IOMAX = UOMAX
  IF (UOMAX > 0.0D0)  IOMAX = INT(UOMAX + 0.999999D0)
  UR = 131.0D0 / dble(IOMAX - IOMIN)
  MUP = 0
  J1 = IONS(1,1)
  J2 = IONS(2,1)
  DO J = J1, J2
    JU = (BU(J) - IOMIN) * UR + 1.5D0
    IF (JU < 1)  JU = 1
    NSTAT(JU,1) = NSTAT(JU,1) + 1
  enddo
  DO J = 1, 132
    IF (MUP < NSTAT(J,1))  MUP = NSTAT(J,1)
  enddo
  IF (MUP > 20)  MUP = 20
  DO N = 1, MUP
    NP = MUP + 1 - N
    DO J = 1, 132
      IGRAPH(J) = ' '
    enddo
    IGRAPH(1)   = ':'

    IGRAPH(132) = ':'
    DO J = 1, 132
      IF (NSTAT(J,1) >= NP)  IGRAPH(J) = ATOM(1)
    enddo
    WRITE (16, 4010)  (IGRAPH(K), K=1,132)
  enddo
  WRITE (16, 4020) IOMIN, IOMAX
!
 4001 FORMAT ('I',130('-'),'I')
 4000 FORMAT ('I Distribution of ion potentials', &
                         3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I' &
              /'I', 17X,'(*1.0E-12 erg)', &
                         3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4002 FORMAT ('I',31X,  3X,3(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4003 FORMAT ('I',31X,  3X,1(4X,A2,F8.3,'[',F7.2,':',F7.2,']'), '   I')
 4004 FORMAT (1X)
 4010 FORMAT (132A1)
 4020 FORMAT ('I---<',I5,1X, 110('-'), I5,' >---I' )
RETURN
END
!
!
!                                                               ========
!================================================================ COORDN
SUBROUTINE  COORDN
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use acoord
!
  implicit none
!
!     ---------- Comparison between MD derived atomic coordinartes and
!                                                crystallographic data
!
  COMMON /WORK01/ PCC(3,LNI), PSS(3,LNI)
      double precision    PCC,PSS
!  COMMON /WORK02/ P00(3,LNI), XYZ0(3,LNI)
!      double precision         P00, XYZ0
!
  double precision         XYZ(3,LAT),SXYZ(3,LAT)
  double precision         SSS, DDD
  double precision         P00(3,LNI),XYZ0(3,LNI) !2017Feb
!     integer(KIND=4)    IPSS(3,LAT)
  CHARACTER *4    HEX
  double precision      RMR,DXX,DYY,DZZ,SX,SY,SZ,PXO,PYO,PZO,DHY,DHX,DX,DY,DZ
  double precision      SXI,SYI,DXI,DYI,XO,YO,ZO,P0CJI
  integer(KIND=4)   IND,I,IN1,JD,J,KS1,KS,NT,IUT,IU,NO,JO,IN2,JS,IS,NL
  integer(KIND=4)   IU1,IU2,ICLJ
!
  IND = 0
  HEX = '    '
  IF (IHEX == 1)  HEX = 'HEX'
  IF (RUNOPT(3) == 'DETAIL    '.OR.MOD(IRECRD(2),100) == 0) WRITE (16,3003)  NJOB, TITLE
  WRITE (16,3020)  NSYM, HEX, (BOX(I)/NBOX(I),NBOX(I),I=1,3)
  IN1 = 1
  RMR = 1.0 / dble(NRECRD(2))
  DO I = 1, NPT
!         JO = JON(I)
    JD = INT(P0C(1,I)) +INT(P0C(2,I)) +INT(P0C(3,I))
    IF (JD >= 1.0)  IND = 1
    DO J = 1, 3
      P00(J,I) = P0C(J,I)
      SSS = PPS(J,I)
      DDD = PPC(J,I)
      PSS(J,I) = SQRT(ABS(SSS-DDD**2*RMR)*RMR)
      PCC(J,I) = PPC(J,I) * RMR
    enddo
  enddo
!
  DO KS1 = 1, 2
    KS  = KS1 - 1
    WRITE (16,3030)
    NT  = 0
    IUT = 0
    DO IU = 1, MATM
      IF (NIU(IU) <= 0)  cycle
      NT  = NT  + NIU(IU)
      IUT = IUT + 1
      DXX = 0.0
      DYY = 0.0
      DZZ = 0.0
      SX = 0.0
      SY = 0.0
      SZ = 0.0
      NO = 0
      DO I = IN1, NPT
        IF (JON(I) > NT)  GO TO 570
        JO = JON(I)
        JD = INT(P0C(1,I)) +INT(P0C(2,I)) +INT(P0C(3,I))
        IF (KS == 0.AND.JD >= 1)  cycle
        IF (KS == 1.AND.JD < 1)  cycle
        IN2 = I
        JS = MOD(ISYM(JO),200)
        IS = MOD(JS,NSYM)
        IF (IS <= 0)  IS = NSYM
        PXO = P00(1,I)
        PYO = P00(2,I)
        PZO = P00(3,I)
        IF (HEX /= 'HEX '.AND.HEX /= 'HEXR')  GO TO 540
        NL = 1
        IF (HEX == 'HEXR')  NL = 3
        IF (JS > NL*NSYM)  THEN
          PYO = PYO - 0.5
          IF (PYO < 0.0)  PYO = PYO + 1.0
          PXO = PXO + 0.5
          IF (PXO >= 1.0)  PXO = PXO - 1.0
          PCC(2,I) = PCC(2,I) - 0.5
          DHY = PCC(2,I) - PYO
          IF (DHY < -.5)  PCC(2,I) = PCC(2,I)+1.0
          PCC(1,I) = PCC(1,I) + 0.5
          DHX = PCC(1,I) - PXO
          IF (DHX >= 0.5)  PCC(1,I) = PCC(1,I)-1.0
        END IF
        PYO = PYO * 2.0
        IF (PYO >= 1.0)  PYO = PYO - 1.0
        PXO = PXO + PYO * 0.5
        IF (PXO >= 1.0)  PXO = PXO - 1.0
        PCC(2,I) = PCC(2,I) * 2.0
        DHY = PCC(2,I) - PYO
        IF (DHY >= 0.5)  PCC(2,I) = PCC(2,I) - 1.0
        PCC(1,I) = PCC(1,I) + PCC(2,I) * 0.5
        DHX = PCC(1,I) - PXO
        IF (DHX >= 0.5)  PCC(1,I) = PCC(1,I) - 1.0
        DX = PCC(1,I) - PXO
        DY = PCC(2,I) - PYO
        DZ = PCC(3,I) - PZO
        DZZ = DZZ + DZ * RS(3,3,IS)
        SZ  = SZ + ABS(PSS(3,I))
        SXI = PSS(1,I)
        SYI = PSS(2,I)
        IF (ABS(RS(1,1,IS)*RS(2,1,IS)) > 0.5) GO TO 10
        IF (ABS(RS(1,1,IS)) >= 0.5)  THEN
          DXI = DX * RS(1,1,IS)
          DYI = (DY - DXI*RS(1,2,IS)) * RS(2,2,IS)
          GO TO 20
        END IF
        DYI = DX * RS(2,1,IS)
        DXI = (DY - DYI * RS(2,2,IS)) * RS(1,2,IS)
        GO TO 20
10      IF (ABS(RS(1,2,IS)) >= 0.5)  THEN
          DXI = DY * RS(1,2,IS)
          DYI = (DX - DXI * RS(1,1,IS)) * RS(2,1,IS)
          GO TO 20
        END IF
        DYI = DY * RS(2,2,IS)
        DXI = (DX - DYI * RS(2,1,IS)) * RS(1,1,IS)
20      DXX = DXX + DXI
        DYY = DYY + DYI
        SX  = SX  + SXI
        SY  = SY  + SYI
        GO TO 545
540     DX = PCC(1,I) - PXO
        DY = PCC(2,I) - PYO
        DZ = PCC(3,I) - PZO
        DXX = DXX + DX*RS(1,1,IS) + DY*RS(2,1,IS) + DZ*RS(3,1,IS)
        DYY = DYY + DX*RS(1,2,IS) + DY*RS(2,2,IS) + DZ*RS(3,2,IS)
        DZZ = DZZ + DX*RS(1,3,IS) + DY*RS(2,3,IS) + DZ*RS(3,3,IS)
        SX= SX+ ABS(PSS(1,I)*RS(1,1,IS)) + ABS(PSS(2,I)*RS(2,1,IS)) + ABS(PSS(3,I)*RS(3,1,IS))
        SY= SY+ ABS(PSS(1,I)*RS(1,2,IS)) + ABS(PSS(2,I)*RS(2,2,IS)) + ABS(PSS(3,I)*RS(3,2,IS))
        SZ= SZ+ ABS(PSS(1,I)*RS(1,3,IS)) + ABS(PSS(2,I)*RS(2,3,IS)) + ABS(PSS(3,I)*RS(3,3,IS))
545     NO = NO + 1
        IF (JS /= 1)  cycle
        XO = PXO
        YO = PYO
        ZO = PZO
      enddo
570   XYZ(1,IU) = XO + DXX / dble(NO)
      XYZ(2,IU) = YO + DYY / dble(NO)
      XYZ(3,IU) = ZO + DZZ / dble(NO)
      SXYZ(1,IU) = SX / dble(NO)
      SXYZ(2,IU) = SY / dble(NO)
      SXYZ(3,IU) = SZ / dble(NO)
      XYZ0(1,IU) = XO
      XYZ0(2,IU) = YO
      XYZ0(3,IU) = ZO
!             WRITE (16,3060)  IU,ATMXTL(IU),(XYZ(J,IU),J=1,3),
!    *                         (SXYZ(J,IU),J=1,3),(XYZ0(J,IU),J=1,3)
      IF (RUNOPT(3) /= 'DETAIL    '.AND.MOD(IRECRD(2),100) /= 0) GO TO 580
!                  DO 575  I = IN1, IN2
!                      DO 575  J = 1, 3
!                          IPSS(J,I) = PSS(J,I) * 1000.0
! 575              CONTINUE
!                  WRITE (16,3030) (JON(I), (PCC(J,I),IPSS(J,I),J=1,3),
!    *                                      I=IN1,IN2)
580   IN1 = IN2 + 1
    enddo
!
    IU1 = 1
    IU2 = 4
601 IF (IU2 > IUT)  IU2 = IUT
    WRITE (16,3066) (ATMXTL(IU),XYZ(1,IU),SXYZ(1,IU),XYZ0(1,IU),IU=IU1,IU2)
    WRITE (16,3067) (XYZ(2,IU),SXYZ(2,IU),XYZ0(2,IU),IU=IU1,IU2)
    WRITE (16,3067) (XYZ(3,IU),SXYZ(3,IU),XYZ0(3,IU),IU=IU1,IU2)
    IU1 = IU2 + 1
    IU2 = IU1 + 3
    IF (IU1 > IUT)  GO TO 660
    GO TO 601
!
660 IF (IND == 0)  RETURN
    IN1 = NPT / 2 + 1
    DO I = IN1, NPT
      JO = JON(I)
      JD = INT(P0C(1,I)) + INT(P0C(2,I)) + INT(P0C(3,I))
      IF (JD < 1)  cycle
      DO J = 1, 3
        ICLJ = 2
        IF (NBOX(J) < 2)  ICLJ = 1
        P0CJI    = P0C(J,I)
        P00(J,I) = P0CJI - dble(ICLJ - 1)
        PCC(J,I) = PPC(J,I) * RMR - dble(ICLJ - 1)
      enddo
    enddo
  enddo
!
 3003 FORMAT (/'***',I4,'-',I2,'  ***  ',15A4,'  ***')
 3020 FORMAT (/'AVERAGE COORDINATES, (STANDARD DEVIATIONS, A^2) AND ', &
               'EXPERIMENTAL ONES  (NO.SYMM.=',I3,1X,A4,') ', &
                 3(F8.4,'(X',I2,')') )
 3030 FORMAT (4(2X,I3,F6.3,'(',I2,')',F5.3,'(',I2,')',F5.3,'(',I2,')'))
 3060 FORMAT (I3,1X,A4,1X,3F7.4,' (',3F6.4,') ',3F7.4)
 3066 FORMAT (4(4X,A4,F7.4,' (',F6.4,') ',F7.4) )
 3067 FORMAT (   4(8X,F7.4,' (',F6.4,') ',F7.4) )
RETURN
END
!
!                                                               ========
!=============================================================  FIND_H2O
SUBROUTINE  FIND_H2O (IM)
  use param
  use aboxof
  use atomsi
  use molecu
  use counts
  use paramt
!
  implicit none
!
!     This option can recognize wate molecules and calculate dipole moment
!
  double precision dxh,dyh,dzh,r2,OH1X,OH2X,OH1Y,OH2Y,OH1Z,OH2Z
  double precision DDX,DDY,DDZ,DPVV,DPXX,DPYY,DPZZ,sroh1,sroh2
  double precision, allocatable:: PH1(:,:),PH2(:,:)
  integer(KIND=4) nh,i,j,IM,k,io,m,no
!
  allocate(PH1(3,NIONO),PH2(3,NIONO))
  if (istart == 0 ) then
    allocate(HHX(NIONO),HHY(NIONO),HHZ(NIONO),HHV(NIONO))
    allocate(OPX(NIONO),OPY(NIONO),OPZ(NIONO),OPV(NIONO))
    allocate(LOP1X(NIONO),LOP1Y(NIONO),LOP1Z(NIONO))
    allocate(roh1(NIONO),roh2(NIONO),A1(NIONO),A2(NIONO))
    allocate(DPV(NIONO), DPX(NIONO), DPY(NIONO),DPZ(NIONO))
    allocate(DPX1(NIONO),DPX2(NIONO),DPY1(NIONO),DPY2(NIONO),DPZ1(NIONO),DPZ2(NIONO))
    allocate(UDPX1(NIONO),UDPX2(NIONO),UDPY1(NIONO),UDPY2(NIONO),UDPZ1(NIONO),UDPZ2(NIONO))
    allocate(QLP1(NIONO),QLP2(NIONO),QLP1z(NIONO),QLP2z(NIONO),QLPx(NIONO))
    allocate(QHHk(NIONO),QHHm(NIONO))
    allocate(E34(NIONO),idipX(4,NIONO),idipY(4,NIONO),idipZ(4,NIONO))
    allocate(pdipX(NIONO),pdipY(NIONO),pdipZ(NIONO),Edp1(NIONO),Edp2(NIONO))
    allocate(idp2(NIONO),ih2o(5,NIONO),watpol(2,NIONO))
    istart = 1
  endif
  IF(IM == 1) goto 100
!     --------------------------------------Recognize H2O molecules
  dxh = 0.0D0
  dyh = 0.0D0
  dzh = 0.0D0
  no = 0
  DO i = ions(1,IATOMO),ions(2,IATOMO)
    no = no + 1
    DO nh = 1,5
      ih2o(nh,no) = 0
    enddo
  enddo
  no = 0
  do i = ions(1,IATOMO), ions(2,IATOMO)
    nh = 1
    no = no + 1
    ih2O (1, no) = i   ! index of oxygen
    do j = ions(1,IATOMH), ions(2,IATOMH)
      dxh = p(1,j) - p(1,i)
      if (ABS(dxh) > 0.5D0) dxh = dxh - SIGN(1.0D0,dxh)
      dyh = p(2,j) - p(2,i)
      if (ABS(dyh) > 0.5D0) dyh = dyh - SIGN(1.0D0,dyh)
      dzh = p(3,j) - p(3,i)
      if (ABS(dzh) > 0.5D0) dzh = dzh - SIGN(1.0D0,dzh)
      r2 = (dxh*box(1))**2 + (dyh*box(2))**2 + (dzh*box(3))**2
      if (r2 <= dintra**2) then
        nh = nh + 1
        ih2o(nh,no) = j
      end if
    enddo
    if (nh /= 3)  then 
      write (*,*) i,'-th ox : No.OH bonds=',nh-1
      stop
    endif
  enddo
!
100  j = ntion
  no = 0
  do io = ions(1,IATOMO),ions(2,IATOMO)
    no = no + 1
    if (IM /= 2) then
      if (p(1,io) < 0.0D0) p(1,io) = p(1,io) + 1.0D0
      if (p(1,io) > 1.0D0) p(1,io) = p(1,io) - 1.0D0
      if (p(2,io) < 0.0D0) p(2,io) = p(2,io) + 1.0D0
      if (p(2,io) > 1.0D0) p(2,io) = p(2,io) - 1.0D0
      if (p(3,io) < 0.0D0) p(3,io) = p(3,io) + 1.0D0
      if (p(3,io) > 1.0D0) p(3,io) = p(3,io) - 1.0D0
    endif
    k = ih2o(2,no)
    m = ih2o(3,no)
    PH1(1,no)= P(1,k)
    PH1(2,no)= P(2,k)
    PH1(3,no)= P(3,k)
    PH2(1,no)= P(1,m)
    PH2(2,no)= P(2,m)
    PH2(3,no)= P(3,m)
    OH1X = PH1(1,no) - p(1,io)
    if(ABS(OH1X) > 0.5D0) then
      PH1(1,no) = PH1(1,no) - SIGN(1.0D0,OH1X)
      OH1X = OH1X - SIGN(1.0D0,OH1X)
    endif
    OH2X = PH2(1,no) - p(1,io)
    if(ABS(OH2X) > 0.5D0) then
      PH2(1,no) = PH2(1,no) - SIGN(1.0D0,OH2X)
      OH2X = OH2X - SIGN(1.0D0,OH2X)
    endif
    OH1Y = PH1(2,no) - p(2,io)
    if(ABS(OH1Y) > 0.5D0) then
      PH1(2,no) = PH1(2,no) - SIGN(1.0D0,OH1Y)
      OH1Y = OH1Y - SIGN(1.0D0,OH1Y)
    endif
    OH2Y = PH2(2,no) - p(2,io)
    if(ABS(OH2Y) > 0.5D0) then
      PH2(2,no) = PH2(2,no) - SIGN(1.0D0,OH2Y)
      OH2Y = OH2Y - SIGN(1.0D0,OH2Y)
    endif
    OH1Z = PH1(3,no) - p(3,io)
    if(ABS(OH1Z) > 0.5D0) then
      PH1(3,no) = PH1(3,no) - SIGN(1.0D0,OH1Z)
      OH1Z = OH1Z - SIGN(1.0D0,OH1Z)
    endif
    OH2Z = PH2(3,no) - p(3,io)
    if(ABS(OH2Z) > 0.5D0) then
      PH2(3,no) = PH2(3,no) - SIGN(1.0D0,OH2Z)
      OH2Z = OH2Z - SIGN(1.0D0,OH2Z)
    endif
    DPX1(no) = OH1X*BOX(1)
    DPX2(no) = OH2X*BOX(1)
    DPY1(no) = OH1Y*BOX(2)
    DPY2(no) = OH2Y*BOX(2)
    DPZ1(no) = OH1Z*BOX(3)
    DPZ2(no) = OH2Z*BOX(3)
    sroh1 = DPX1(no)**2 + DPY1(no)**2 + DPZ1(no)**2
    roh1(no) = sqrt(sroh1)
    UDPX1(no) = DPX1(no)/roh1(no)
    UDPY1(no) = DPY1(no)/roh1(no)
    UDPZ1(no) = DPZ1(no)/roh1(no)
    sroh2 = DPX2(no)**2 + DPY2(no)**2 + DPZ2(no)**2
    roh2(no) = sqrt(sroh2)
    UDPX2(no) = DPX2(no)/roh2(no)
    UDPY2(no) = DPY2(no)/roh2(no)
    UDPZ2(no) = DPZ2(no)/roh2(no)
    if (roh1(no) > 1.61D0 .or. roh2(no) > 1.61D0) stop '!!! H2O was broken !!!'
!   -----------------------------------------------------------------
    HHX(no) = DPX2(no)-DPX1(no)    ! H1 -> H2
    HHY(no) = DPY2(no)-DPY1(no)
    HHZ(no) = DPZ2(no)-DPZ1(no)
    HHV(no) = sqrt(HHX(no)**2+HHY(no)**2+HHZ(no)**2)     !Angstrom
    if (HHV(no) > 5.0D0) stop 'error in HH distance'
!   -----------------------------------------------------------------
    OPX(no) = DPY1(no)*DPZ2(no) - DPZ1(no)*DPY2(no)  !LP2 -> LP1 direction
    OPY(no) = DPZ1(no)*DPX2(no) - DPX1(no)*DPZ2(no)
    OPZ(no) = DPX1(no)*DPY2(no) - DPY1(no)*DPX2(no)
    OPV(no) = sqrt(OPX(no)**2+OPY(no)**2+OPZ(no)**2)     !Angstrom
!   -----------------------------------------------------------------
    DPXX = HHY(no)*OPZ(no) - OPY(no)*HHZ(no)  ! O -> D direction
    DPYY = HHZ(no)*OPX(no) - OPZ(no)*HHX(no)
    DPZZ = HHX(no)*OPY(no) - OPX(no)*HHY(no)
    DPVV = SQRT(DPXX**2+DPYY**2+DPZZ**2)     !Angstrom
!
!   -----------------------------------------------------OD
    A1(no) = 0.5d0*(HHV(no)+(roh1(no)**2 - roh2(no)**2)/HHV(no))
    A2(no) = HHV(no)- A1(no)
    DPV(no) = sqrt(roh1(no)**2-A1(no)**2)
    DPX(no) = DPV(no)*DPXX/DPVV
    DPY(no) = DPV(no)*DPYY/DPVV
    DPZ(no) = DPV(no)*DPZZ/DPVV
!
    j = j + 1
    ih2o(4,no) = j
!
    LOP1X(no) = OPX(no)*RD/OPV(no)
    LOP1Y(no) = OPY(no)*RD/OPV(no)
    LOP1Z(no) = OPZ(no)*RD/OPV(no)
!
    DDX = LOP1X(no)/BOX(1)
    DDY = LOP1Y(no)/BOX(2)
    DDZ = LOP1Z(no)/BOX(3)
!   ========================== positions of lone pairs
    P(1,j) = P(1,io)+DDX
    P(2,j) = P(2,io)+DDY
    P(3,j) = P(3,io)+DDZ
!
    if (P(1,j) > 1.0D0) P(1,j) = P(1,j) - 1.0D0
    if (P(1,j) < 0.0D0) P(1,j) = P(1,j) + 1.0D0
    if (P(2,j) > 1.0D0) P(2,j) = P(2,j) - 1.0D0
    if (P(2,j) < 0.0D0) P(2,j) = P(2,j) + 1.0D0
    if (P(3,j) > 1.0D0) P(3,j) = P(3,j) - 1.0D0
    if (P(3,j) < 0.0D0) P(3,j) = P(3,j) + 1.0D0
!
    j = j + 1
    ih2o(5,no) = j
!
    P(1,j) = P(1,io)-DDX 
    P(2,j) = P(2,io)-DDY
    P(3,j) = P(3,io)-DDZ
!
    if (P(1,j) > 1.0D0) P(1,j) = P(1,j) - 1.0D0
    if (P(1,j) < 0.0D0) P(1,j) = P(1,j) + 1.0D0
    if (P(2,j) > 1.0D0) P(2,j) = P(2,j) - 1.0D0
    if (P(2,j) < 0.0D0) P(2,j) = P(2,j) + 1.0D0
    if (P(3,j) > 1.0D0) P(3,j) = P(3,j) - 1.0D0
    if (P(3,j) < 0.0D0) P(3,j) = P(3,j) + 1.0D0
  enddo
!
!
999 RETURN
END
!                                                               ========
!================================================================ STRCTR
SUBROUTINE  STRCTR  (IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
  use values
  use struct
!
  implicit none
!
!     ------------------------------------- Bond lengths and angles etc.
!
  COMMON /WORK03/ PX(LNI),PY(LNI),PZ(LNI)
    double precision PX,PY,PZ
!
  integer(KIND=4)    NCHAR(7)
  double precision    ANBR(8,2)
  CHARACTER *4    CCHAR(8),  ATAB(LST)
  CHARACTER *6    RCHAR(5)
  integer(KIND=4) IPR, NNC(7,2),IB1,IB2
  integer(KIND=4) MMM,I,J,IO,IT,I1,I2,I0,II,IJ,J1,ID1,J2,ID2,ITT,N,NAG,K,IC,IA
  integer(KIND=4) JO,KO,NN,MM,MJ,L,M,NC
  double precision    DB1,DB2,DB3,DB4,DB5,DB6
  double precision    D1,D4,D2,ASTHT,DB,ANTBL,AMEB1,AMEB2
  DATA RCHAR / 'SIZE  ', 'T     ', 'T1    ', '      ', '      '/
  DATA NCHAR / 0,1,2,3,4,5,6/,CCHAR/' 0 ',' 1 ',' 2 ',' 3 ',' 4 ',' 5',' 6 ','SUM'/
!
  IF (RUNOPT(9)  /= 'STRUCTURE ' .AND. RUNOPT(10) /= 'NETWORK   ' )     RETURN
  MMM = 0
  IF (ATOM(2) == ATMNET(1).OR.ATOM(2) == ATMNET(2)) MMM = IONS(2,2)
  if (ATMNET(2) /= '    ')  then
    IF (ATOM(3) == ATMNET(1).OR.ATOM(3) == ATMNET(2)) MMM = IONS(2,3)
  end if
  IF (MMM == 0.AND.IPR <= 0)  RETURN
!     ----------------------------------------- Default Cut-Off is 2.0 A
  RTO(1) = 2.00D0
  RTO(2) = 2.00D0
  DO I = 1, 2
    IF (ATMNET(I) == 'H ')  RTO(I) = 1.20D0
    IF (ATMNET(I) == 'B ')  RTO(I) = 1.90D0
    IF (ATMNET(I) == 'C ')  RTO(I) = 1.50D0
    IF (ATMNET(I) == 'AL')  RTO(I) = 2.20D0
    IF (ATMNET(I) == 'SI')  RTO(I) = 2.00D0
    IF (ATMNET(I) == 'P ')  RTO(I) = 1.95D0
    IF (ATMNET(I) == 'ZR')  RTO(I) = 2.30D0
  enddo
  DTO(1) = 0.0D0
  DTO(2) = 0.0D0
  NTO(1) = 0
  NTO(2) = 0
  DO J = 1, 12
    AVTHT(J) = 0.0D0
    SVTHT(J) = 0.0D0
    NVTHT(J) = 0
    DO I = 1, 121
      NTT(I,J) = 0
    enddo
  enddo
!
  DO I = 1, NTION
    PX(I) = P(1,I)
    PY(I) = P(2,I)
    PZ(I) = P(3,I)
  enddo
!     -------------------------------------------------- Cations - anion
!
  DO IO = 1, NCOMPO
    IF (IION(IO) <= -999)  cycle
    IF (NION(IO) <= 0.OR.ZIO(IO) < 0.0D0)  cycle
!         WRITE (*,9001)  ATOM(IO)
!9001     FORMAT (10X,'***  ',A2,' - ANION  ***')
    IF (IPR > 0.AND.RUNOPT(9) == 'STRUCTURE ') WRITE (16,2001)  ATOM(IO)
    IT = 0
    IF (ATOM(IO) == ATMNET(1))  IT = 1
    IF (ATOM(IO) == ATMNET(2))  IT = 2
    I1 = IONS(1,IO)
    I2 = IONS(2,IO)
    DO I = I1, I2, LENTAB
      I0 = I
      CALL  DISTAN  (I0, II, IO, IPR)
      IF (IT == 0)  cycle
      DO IJ = I0, II
        DO J1 = 1, 5
          ID1 = IONB(J1,IJ)
          D1  = DONB(J1,IJ)
          IF (D1 > RTO(IT) .OR. D1 < 0.1D0) cycle
          D4  = DONB(4,IJ)
          IF (D4 > RTO(IT).OR.D4 < .1D0)  GO TO 230
          IF (J1 > 4)  GO TO 230
          DTO(IT) = DTO(IT) + D1
          NTO(IT) = NTO(IT) + 1
230       DO J2 = J1+1, 6
            ID2 = IONB(J2,IJ)
            D2  = DONB(J2,IJ)
            IF (D2 > RTO(IT) .OR. D2 < 0.1D0) goto 250
            ITT = IT * 3 - 2
            IF (ID1 > IONS(2,1))  ITT = ITT + 1
            IF (ID2 > IONS(2,1))  ITT = ITT + 1
            CALL  ANGLES  (ASTHT,IJ,ID1,ID2,D1,D2,ITT)
          enddo
250     enddo
      enddo
    enddo
  enddo
!
!     +----------------------------------------------------------------I
!     :  Angles      1 : A1-T1-A1     2 : A1-T1-A2     3 : A2-T1-A2    :
!     :              4 : A1-T2-A1     5 : A1-T2-A2     6 : A2-T2-A2    :
!     :              7 : T1-A1-T1     8 : T1-A1-T2     9 : T2-A1-T2    :
!     :             10 : T1-A2-T1    11 : T1-A2-T2    12 : T2-A2-T2    :
!     +----------------------------------------------------------------I
!
!     ------------- Anion - specified tetrahedron formers, large cations
!
300 IT = 0
  DO IO = 1, NCOMPO
    IF (IION(IO) <= -999) cycle
    IF (NION(IO) <= 0.OR.ZIO(IO) > 0.0D0) cycle
!         WRITE (*,9002)  ATOM(IO)
!9002     FORMAT (10X,'***  ',A2,' - CATION  ***')
    IT = IT + 1
    IF (IPR > 0.AND.RUNOPT(9) == 'STRUCTURE') THEN
      WRITE (16, 4001) ATOM(IO)
    END IF
    I1 = IONS(1,IO)
    I2 = IONS(2,IO)
    DO I = I1, I2, LENTAB
      I0 = I
      CALL  DISTAN  (I0, II, IO, IPR)
      N = 0
      NAG = 0
      DO IJ = I0, II
        N = N + 1
        ATAB(N) = '    '
        TTAB(N) = 0.0001
        ID1     = IONB(1,IJ)
        ID2     = IONB(2,IJ)
        IF (ID1 > MMM.OR.ID2 > MMM) cycle
        D1 = DONB(1,IJ)
        D2 = DONB(2,IJ)
        IF (D2 > RTO(2) .OR.  D2 < 0.01) cycle
        IF (D2 > RTO(1) .AND. ID1 <= IONS(2,2))  cycle
        ITT = (IT + 2) * 3 - 2
        IF (ID1 > IONS(2,2))  ITT = ITT + 1
        IF (ID2 > IONS(2,2))  ITT = ITT + 1
        ATAB(N) = '<S-S'
        IF (MOD(ITT,3) == 2)  ATAB(N) = '<S-A'
        IF (MOD(ITT,3) == 0)  ATAB(N) = '<A-A'
        CALL  ANGLES  (TTAB(N),IJ,ID1,ID2,D1,D2,ITT)
        NAG = NAG + 1
      enddo
      IF (NAG <= 0)  cycle
      IF (IPR /= 0.AND.RUNOPT(9) == 'STRUCTURE ') THEN
        if (lentab > 30)  then
          WRITE (16,4011)  (ATAB(J),J=1,N)
          WRITE (16,4021)  (TTAB(J),J=1,N)
        end if
        if (lentab > 25.and.lentab <= 30)  then
          WRITE (16,4012)  (ATAB(J),J=1,N)
          WRITE (16,4022)  (TTAB(J),J=1,N)
        end if
        if (lentab > 20.and.lentab <= 25)  then
          WRITE (16,4013)  (ATAB(J),J=1,N)
          WRITE (16,4023)  (TTAB(J),J=1,N)
        end if
        if (lentab <= 20)  then
          WRITE (16,4014)  (ATAB(J),J=1,N)
          WRITE (16,4024)  (TTAB(J),J=1,N)
        end if
      END IF
    enddo
  enddo
!
  IF (NVTHT(1)+NVTHT(2) <= 0.OR.MMM <= 0)  RETURN
!
!  write(*,*)'Enter ADISTR'
  CALL  ADISTR  (IPR)
!
  IF (RUNOPT(17) == 'AMORPHOUS ')  THEN
!           ----------------------------------------------------- Netwrk
    CALL  NETWRK  (MMM, IPR)
!           -------------------------------- Sorting of T1-X4 tetrahedra
    IF (IPR == 0)  THEN
      DO K = 1, 2
        DO I = 1, 8
          DO J = 1, 8
            NBR(I,J,K) = 0
          enddo
        enddo
      enddo
      I1 = IONS(1,2)
      DO I = I1, MMM
!                     DB4 = DONB(4,I)
        K = 1
        IF (I > IONS(2,2))  K = 2
        NC = 0
        DB1 = DONB(1,I)
        DB2 = DONB(2,I)
        DB3 = DONB(3,I)
        DB4 = DONB(4,I)
        DB5 = DONB(5,I)
        DB6 = DONB(6,I)
        if (DB1 > 0.0001D0 .and. DB1 < RTO(K))  NC = 1
        if (DB2 > 0.0001D0 .and. DB2 < RTO(K))  NC = 2
        if (DB3 > 0.0001D0 .and. DB3 < RTO(K))  NC = 3
        if (DB4 > 0.0001D0 .and. DB4 < RTO(K))  NC = 4
        if (DB5 > 0.0001D0 .and. DB5 < RTO(K))  NC = 5
        if (DB6 > 0.0001D0 .and. DB6 < RTO(K))  NC = 6
!                     IF (DB4 > RTO(K).OR.DB4 < 0.0001)  GO TO 520 NNC(nc,k) = NNC(nc,k) + 1
        IC = 1
        IA = 1
        DO J = 1, 6
          JO = IONB(J,I)
          DB = DONB(2,JO)
          IF (JO > MMM .OR. JO == 0)  cycle
          IF (DB < 0.1D0 .OR. DB > RTO(2)) cycle
          IF (DB2 < 0.1D0 .OR. DB2 > RTO(2)) cycle
!
          IB1 = IONB(1,JO)
          IB2 = IONB(2,JO)
          IF ((I /= IB1).AND.(I /= IB2)) cycle
!
          KO = IONB(1,JO)
          IF (KO == I)  KO = IONB(2,JO)
          IF (KO <= IONS(2,2))               IC = IC + 1
          IF (KO >= IONS(1,3).AND.KO <= MMM .and. ncompo > 2)  IA = IA + 1
        enddo
        NBR(IC,IA,K) = NBR(IC,IA,K) + 1
        NBR(IC, 8,K) = NBR(IC, 8,K) + 1
        NBR( 8,IA,K) = NBR( 8,IA,K) + 1
        NBR( 8, 8,K) = NBR( 8, 8,K) + 1
      enddo
      DO K = 1, 2
        DO I = 1, 8
          DO J = 1, 8
            MBR(I,J,K) = MBR(I,J,K) + NBR(I,J,K)
          enddo
        enddo
      enddo
      NN = IRECRD(2)/IRECRD(3)
      MM = MOD(NRECRD(1)/IRECRD(3), NN)
      MJ = 2
      IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
      IF (MOD(MM,MJ) /= 0)  RETURN
!
    ELSE
      DO K = 1, 2
        DO  I = 1, 8
          DO J = 1, 8
            NBR(I,J,K) = MBR(I,J,K)
          enddo
        enddo
      enddo
    END IF
!
    WRITE (16, 5001)  ATMNET(1), ATMNET(2), NTBL
    WRITE (16, 5005)  ATMNET(1), (NCHAR(I),I=1,7),CCHAR(8), &
                      ATMNET(2), (NCHAR(I),I=1,7),CCHAR(8),(RCHAR(I),I=1,3)
    ANTBL = NTBL
    IF (IPR == 0)  ANTBL = 1
    L = 1
    DO I = 1, 8
      IF  (I == 1.OR.I == 8)  THEN
        L = L + 1
        AMEB1 = dble(MEB(L,1))*100.0D0 / (dble(NION(2))*ANTBL)
        AMEB2 = dble(MEB(L,2))*100.0D0 / ((dble(NION(2))+dble(NION(3)))*ANTBL)
        WRITE (16,5007)  L, AMEB1, AMEB2
      END IF
      L  = L + 1
      AMEB1 = dble(MEB(L,1))*100.0D0 / (dble(NION(2))*ANTBL)
      AMEB2 = dble(MEB(L,2))*100.0D0 / ((dble(NION(2))+dble(NION(3)))*ANTBL)
      DO M = 1, 8
        ANBR(M,1) = dble(NBR(I,M,1))*100.0D0 / (dble(NION(2))*ANTBL)
        ANBR(M,2) = 0.0D0
        IF (NION(3) > 0)  THEN
          ANBR(M,2) = dble(NBR(I,M,2))*100.0D0 / (dble(NION(3))*ANTBL)
        END IF
      enddo
      WRITE (16,5003) (CCHAR(I),(ANBR(M,K),M=1,8),K=1,2),L,AMEB1,AMEB2
    enddo
    write (16,5002)
    write (16,5004)  ((NNC(i,k),i,i=1,6),k=1,2)
    write (16,5002)
  END IF
!
RETURN
 2001 FORMAT (/'<<<<<   ', A2, ' - anion distances    >>>>>')
 4001 FORMAT (/'<<<<<   ', A2, ' - cation distances   >>>>>')
 4011 FORMAT (4(1X,8A4))
 4012 format (6(1x,5A4))
 4013 format (5(1x,5(a4,1x)))
 4014 format (4(1x,5(a4,2x)))
 4021 FORMAT (4(1X,8F4.0))
 4022 format (6(1x,5F4.0))
 4023 format (5(1x,5F5.1))
 4024 format (4(1x,5(F5.1,1X)))
 5001 FORMAT (/'Vertical: No. of bridging anion to ',A2,' tetrahedra  ', &
               'Horizontal: No. of bridging anion to ',A2,' tetrahedra (',I3, &
              ')  ',9X,'<< Tet-Ring  >>' / 1X,113('-'),'   <<  Analysis >>')
 5005 FORMAT (A3,' I', I4,6I6,'   I  ', A3, 4X, &
              A3,' I', I4,6I6,'   I  ', A3, 5X, 3A6)
 5002 format (113('-'))
 5003 FORMAT (2(A3,' I',   7F6.2, ' I', F6.2,3X), I3,1X,2F6.2)
 5004 format ('No.[NC]',1x,6(i5,'[',i1,']'),3x,6(i5,'[',i1,']'))
 5007 FORMAT (2('----+',43('-'),'+------   '),    I3,1X,2F6.2)
      END
!
!
!                                                                =======
!================================================================ DISTAN
SUBROUTINE  DISTAN  (I1, I2, IO, IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use struct
!
  implicit none
!
!     ----------------------------- Calculation of interatomic distances
!
  COMMON /WORK03/ PX(LNI),PY(LNI),PZ(LNI)
    double precision PX,PY,PZ
!
  double precision    D(64)
  double precision    dtab(10,lst)
  integer(KIND=4)    ID(64),ITAB(10,LST),IDTAB(10,LST),IU(LST)
  CHARACTER *2    TAX(LST)
  integer(KIND=4)    I1,I2,IO,IPR,NI,I,NB,J,JO,K,JD,IDUMMY,ITA,IB
  double precision    ABOXX,ABOXY,ABOXZ,PXI,PYI,PZI,DX,DY,DZ,RIJ2,DR
!
  ABOXX = BOX(1)
  ABOXY = BOX(2)
  ABOXZ = BOX(3)
  I2 = I1 + LENTAB - 1
  IF (I2 > IONS(2,IO))  I2 = IONS(2,IO)
  NI = 0
  DO I = I1, I2
    NI = NI + 1
    NB = 0
    PXI = PX(I)
    PYI = PY(I)
    PZI = PZ(I)
    DO J = 1, 64
      ID(J) = 0
      D(J) = 0.000001
    enddo
    DO JO = 1, NCOMPO
      IF (IION(JO) <= -999)  cycle
      IF (NION(JO) <= 0.OR.ZIO(IO)*ZIO(JO) > 0.0)  cycle
      DO J = IONS(1,JO), IONS(2,JO)
        IF (IOND(J) == 0 .OR. I == J)  cycle
        DX = ABS(PXI-PX(J))
        DY = ABS(PYI-PY(J))
        DZ = ABS(PZI-PZ(J))
        IF (DX > 0.5) DX = 1.0 - DX
        IF (DY > 0.5) DY = 1.0 - DY
        IF (DZ > 0.5) DZ = 1.0 - DZ
        RIJ2 = (DX*ABOXX)**2 +(DY*ABOXY)**2 +(DZ*ABOXZ)**2
        IF (RIJ2 <= 9.0.AND.NB < 64) THEN
          NB     = NB +1
          D(NB)  = SQRT(RIJ2)
          ID(NB) = J
        END IF
      enddo
    enddo
    IF (NB > 1)  THEN
      DO J = 1, NB-1
        DO K = J+1, NB
          IF (D(J) >= D(K))  THEN
            DR = D(J)
            D(J) = D(K)
            D(K) = DR
            JD = ID(J)
            ID(J) = ID(K)
            ID(K) = JD
          END IF
        enddo
      enddo
    END IF
    DO J = 1, 10
      ITAB(J,NI) = ID(J)
      DTAB(J,NI) = D(J)
    enddo
    do j =1, 6
      DONB(J,I) = D(J)
      IONB(J,I) = ID(J)
    enddo
    do j = 1, 10
      idtab(j,ni) = dtab(j,ni) * 100.0 + 0.5
    enddo
    idummy = idtab(1,ni)
    IU(NI) = AU(I) * 1.E12 / NRECRD(2) + 0.5
  enddo
!
  IF (IPR == 0.OR.RUNOPT(9) /= 'STRUCTURE ')  RETURN
!
  WRITE (16,2001)
  if (lentab > 30)  then
    WRITE (16,2011)  (I,I=I1,I2)
    WRITE (16,2021)  (IU(I),I=1,NI)
  end if
  if (lentab > 25.and.lentab <= 30)  then
    WRITE (16,2012)  (I,I=I1,I2)
    WRITE (16,2022)  (IU(I),I=1,NI)
  end if
  if (lentab > 20.and.lentab <= 25)  then
    WRITE (16,2013)  (I,I=I1,I2)
    WRITE (16,2023)  (IU(I),I=1,NI)
  end if
  if (lentab <= 20)  then
    WRITE (16,2014)  (I,I=I1,I2)
    WRITE (16,2024)  (IU(I),I=1,NI)
  end if
  DO I = 1, 10
    ITA = 0
    DO J = 1, NI
      ib = itab(i,j)
      TAX(J) = '*'
      IF (IB >= ions(1,1).and.ib <= ions(2,1)) TAX(J) = ATOM(1)
      IF (IB >= IONS(1,2).and.ib <= ions(2,2)) TAX(J) = ATOM(2)
      IF (IB >= IONS(1,3).and.ib <= ions(2,3)) TAX(J) = ATOM(3)
      IF (IB >= IONS(1,4).and.ib <= ions(2,4)) TAX(J) = ATOM(4)
      IF (IB >= IONS(1,5).and.ib <= ions(2,5)) TAX(J) = ATOM(5)
      IF (IB >= IONS(1,6).and.ib <= ions(2,6)) TAX(J) = ATOM(6)
      IF (IB >= IONS(1,7).and.ib <= ions(2,7)) TAX(J) = ATOM(7)
      ITA = ITA + ITAB(I,J)
    enddo
    IF (ITA < 1)  cycle
    if (lentab > 30)  then
      WRITE (16,2031)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
    if (lentab > 25.and.lentab <= 30)  then
      WRITE (16,2032)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
    if (lentab > 20.and.lentab <= 25)  then
      WRITE (16,2033)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
    if (lentab <= 20)  then
      WRITE (16,2034)  (IDTAB(I,J),TAX(J),J=1,NI)
    end if
  enddo
!
 2001 FORMAT (132('-'))
 2011 FORMAT (4(1X,8I4))
 2012 FORMAT (6(1X,5I4))
 2013 FORMAT (5(1X,5(I4,1x)))
 2014 FORMAT (4(1X,5(I4,2x)))
 2021 FORMAT (4(1X,8I4))
 2022 FORMAT (6(1X,5I4))
 2023 FORMAT (5(1X,5(1x,I4)))
 2024 FORMAT (4(1X,5(1x,I4,1x)))
 2031 FORMAT (4(1X,8(I3,A1)))
 2032 format (6(1x,5(i3,a1)))
 2033 format (5(1x,5(i3,a2)))
 2034 format (4(1x,5(i3,a2,1x)))
RETURN
END
!
!                                                                =======
!================================================================ ANGLES
SUBROUTINE  ANGLES  (THT,IJ,ID1,ID2,D1,D2,IT)
  use param
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
!
  implicit none
!     -------------------------------- Calculation of interatomic angles
!
  double precision    THT,W,D1,D2,DD1,DD2,COSTHT,SINTHT
  integer(KIND=4)   IJ,ID1,ID2,IT,J,ITHT
!
  W = 0.0D0
  DO J = 1, 3
    DD1 = P(J,ID1)-P(J,IJ)
    IF (ABS(DD1) > 0.5D0)  DD1 = DD1-SIGN(1.0D0,DD1)
    DD2 = P(J,ID2)-P(J,IJ)
    IF (ABS(DD2) > 0.5D0)  DD2 = DD2-SIGN(1.0D0,DD2)
    W = W + DD1 * DD2 *BOX(J)**2
  enddo
  COSTHT = W / (D1 * D2)
  SINTHT = ABS(1. - COSTHT*COSTHT)
  THT = ATAN(SQRT(SINTHT) / COSTHT) * 180.0D0/PI
  IF (THT < 0.0D0)  THT = THT + 180.0D0
  NVTHT(IT) = NVTHT(IT) + 1
  AVTHT(IT) = AVTHT(IT) + THT
  SVTHT(IT) = SVTHT(IT) + THT * THT
  ITHT = INT(THT - 58.5D0)
  IF (ITHT <= 0)  ITHT = 1
  NTT(ITHT,IT) = NTT(ITHT,IT) + 1
!
RETURN
END
!
!
!                                                               ========
!================================================================ ADISTR
SUBROUTINE  ADISTR (IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use paramt
  use tables
  use geomet
!
  implicit none
!     -------------------------------------- Grafs of interatomic angles
!
!
  double precision    ANGLE(3,12)
  real      ANTBL,ANN,AAA,SSS,FACT
  integer(KIND=4)    IANGLE(12)
  integer(KIND=4)    IPR
  CHARACTER *4    SNGLE(3,12),ATY(LEL),GRAPH(121)
  integer(KIND=4)    N,IO,I,J,MTBL,NN,MM,MJ,NK,K,KK,IJ,NMAX,NG,MTT
!
!     WRITE  (*,1111)
!1111 FORMAT (10X,'<<<  Angle distribution  >>>')
  N = 0
  DO IO = 1, NCOMPO
    IF (ZIO(IO) < 0.0)  THEN
      N = N + 1
      ATY(N) = ATOM(IO)
    END IF
  enddo
!
  IF (IPR == 1)  THEN
    DO I = 1, 12
      AVTHT(I) = ANGL(1,I)
      SVTHT(I) = ANGL(2,I)
      NVTHT(I) = ANGL(3,I)
      DO J = 1, 121
         NTT(J,I) = ITBR(J,I)
      enddo
    enddo
  END IF
!
  IF (IPR == 0)   NTBL = NTBL + 1
  MTBL = NTBL
  IF (MTBL <= 0)  MTBL = 1
  IF (NTO(1) > 0)  DTO(1) = DTO(1) / NTO(1)
  IF (NTO(2) > 0)  DTO(2) = DTO(2) / NTO(2)
  NTO(1) = NTO(1) / 4
  NTO(2) = NTO(2) / 4
  IF (IPR == 0)  THEN
    IF (IRECRD(3) > 0)  THEN
      NN = IRECRD(2)/IRECRD(3)
      IF (NN > 0) MM = MOD(NRECRD(1)/IRECRD(3),NN)
    END IF
    MJ = 2
    IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
    IF (MOD(MM,MJ) /= 0)  GO TO 270
  END IF
  IF (IPR == 1)  THEN
    WRITE (16, 4005)  NTBL, ATMNET(1),ATY(1),DTO(1),NTO(1),ATMNET(2),ATY(1),DTO(2),NTO(2)
 4005        FORMAT(/' Angle distribution (', I3, ')',3X, &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')   ', &
                        A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')')
    WRITE (16,4011)
  END IF
!
270 NK = 0
  ANTBL = dble(NTBL)
  DO K = 1, 12
    IF (NVTHT(K) == 0) cycle
    ANN = NVTHT(K)
!           IF (ANN <= 0.0)  ANN = ANN + 65534
    AAA = AVTHT(K)
    SSS = SQRT(ABS(SVTHT(K) - AAA*AAA/ANN) /ANN)
    AAA = AAA / ANN
    NK  = NK + 1
    ANGLE(1,NK) = AAA
    ANGLE(2,NK) = SSS
    IANGLE(NK)  = NVTHT(K)
    IF (K <= 6)  THEN
      KK = (K - 1)/ 3 + 1
      SNGLE(1,NK) = ATY(1)
      SNGLE(2,NK) = ATMNET(KK)
      SNGLE(3,NK) = ATY(1)
      J = MOD(K-1,3)
      IF (J >= 1)  SNGLE(3,NK) = ATY(2)
      IF (J >= 2)  SNGLE(1,NK) = ATY(2)
      GO TO 390
    END IF
    I = 1
    IF (MOD(K,3) == 0)  I = 2
    J = 2
    IF (MOD(K,3) == 1)  J = 1
    IJ = 1
    IF (K > 9)  IJ = 2
    SNGLE(1,NK) = ATMNET(I)
    SNGLE(2,NK) = ATY(IJ)
    SNGLE(3,NK) = ATMNET(J)
390 IF (IPR == 1)  THEN
      WRITE (16,4021) (SNGLE(J,NK),J=1,3), AAA, SSS, NVTHT(K)
      NMAX = 0
      FACT = 400.0 / (ANTBL * NION(1))
      DO I = 1, 121
        NTT(I,K) = NTT(I,K) * FACT + 0.5
        IF (NMAX < NTT(I,K))  NMAX = NTT(I,K)
      enddo
      IF (NMAX > 17)  NMAX = 17
      DO I = 1, NMAX
        NG = NMAX -I + 1
        DO J = 1, 121
          GRAPH(J) = ' '
          IF (J == 1.OR.J == 121)  GRAPH(J)='I'
          MTT = NTT(J,K)
          IF (MTT >= NG)     GRAPH(J) = '*'
          IF (MTT-17 >= NG)  GRAPH(J) = '#'
        enddo
        WRITE (16,4010)  (GRAPH(J),J=1,121)
      enddo
      WRITE (16,4011)
    END IF
  enddo
  IF (IPR == 1)  THEN
    WRITE (16,4012)  (I, I=60,180,30)
    RETURN
  END IF
!
  NN = IRECRD(2)/IRECRD(3)
  MM = MOD(NRECRD(1)/IRECRD(3), NN)
  MJ = 2
  IF (RUNOPT(3) == 'ECONOMY   ') MJ = 10
  IF (MOD(MM,MJ) == 0)  THEN
    WRITE (16,4006)  NTBL,ATMNET(1),ATY(1),DTO(1),NTO(1),ATMNET(2),ATY(1),DTO(2),NTO(2)
 4006              FORMAT ('I Angle distribution  (', I3, ')  ', &
                            A2,'-',A2,'(tet)=', F5.3, ' (', I3, ')  ', &
                            A2,'-',A2,'(tet)=', F5.3, ' (', I3, ') I')
    IF (NK <= 2) THEN
      WRITE (16,4020)  ( (SNGLE(J,I),J=1,3),(ANGLE(J,I),J=1,2),IANGLE(I),I=1,NK )
    ELSE
      WRITE (16,4025)  ( (SNGLE(J,I),J=1,3),(ANGLE(J,I),J=1,2),IANGLE(I),I=1,NK )
    END IF
    WRITE (16,'("I",74("-"),"I")')
  END IF
  DO I = 1, 12
    ANGL(1,I) = ANGL(1,I) + AVTHT(I)
    ANGL(2,I) = ANGL(2,I) + SVTHT(I)
    ANGL(3,I) = ANGL(3,I) + NVTHT(I)
    DO J = 1, 121
      ITBR(J,I) = ITBR(J,I) + NTT(J,I)
    enddo
  enddo
RETURN
!
 4010 FORMAT (3X, 121A1)
 4011 FORMAT (3X,12('I',9('-')),'I')
 4012 FORMAT (3X,4(I3,27X),I3)
 4020 FORMAT ('I ',2(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),'   I')
 4025 FORMAT ('I ',2(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),'   I'/ &
              'I ',2(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),'   I'/ &
              'I ',1(3X,'<',A2,'-',A2,'-',A2,'=',F6.2,'+-',F5.2,'(N=',I5,')'),36X,'   I' )
 4021 FORMAT (3X,'I  <',A2,'-',A2,'-',A2,' =',F7.2,'+-',F6.2,'  (N=',I7,')',78X,'I')
 4410                 FORMAT (80A1)
END
!
!
!                                                               ========
!================================================================ NETWRK
SUBROUTINE  NETWRK  (NNN, IPR)
  use param
  use charac
  use counts
  use temprs
  use aboxof
  use atomsi
  use geomet
  use struct
!
  implicit none
!     ------------------------------------------------- Network analysis
!
!
  integer(KIND=4)      NNN,IPR
  integer(KIND=4)      NTET(19),ITREE(19),MING(9),MEMBER(9),ITET(6,19)
  integer(KIND=2)      mring(lrg),ling(9,lrg)
  integer(KIND=4)      LMBR,LCOL,I,ISE,NR,IS,MMM,J,ISI,ICOL,II,JJ,KJ,LL,L,IOS
  integer(KIND=4)      NTCOL,ITI,MOR,MIG,MI,MM,IDEL,N,LI
!
  LMBR = 8
  LCOL = LMBR * 2 + 1
  IF (IPR == 1)  GO TO 901
!     WRITE (*,1111)
!1111 FORMAT (10X,'<<<<<  NETWORK ANALYSIS STARTED  >>>>>')
  DO I = 1, 9
    MEB(I,1) = 0
    MEB(I,2) = 0
  enddo
  ISE = 1
  IF (NNN > IONS(2,2))  ISE = 2
!     --------------------------------------------- Ring search starting
  write (*,*)  'NETWORK'
  NR   = 0
  DO IS = 1, ISE
    MMM = NNN
    IF (IS == 1)  MMM = IONS(2,2)
!
    DO I = 1, LMBR
       MEMBER(I) = 0
    enddo
    DO I = 1, LCOL
      DO J = 1, 6
        ITET(J,I) = 9999
      enddo
    enddo
!
!          ------------------------------------- Search around ion [ISI]
!                                                  ISI : Network former
    DO ISI = IONS(1,2), MMM
!              WRITE (6,*)  'ISI=',ISI,'   Total Number of Rings =',NR
      ICOL = 1
      ITREE(1) = ISI
      II = ISI
      JJ = ISI
710   ICOL = ICOL + 1
      IF (ICOL > LCOL)  GO TO 725
      KJ = 1
      IF (JJ > IONS(2,2))  KJ = 2
      LL = 0
      DO L = 1, 5
        ITET(L,ICOL) = 9999
        IOS = IONB(L,JJ)
        IF (IOS <= 0.OR.IOS > MMM) cycle
        IF (IOS > IONS(2,2))  KJ = 2
        IF (DONB(L,JJ) > RTO(KJ).OR.IOS == II) cycle
        LL = LL + 1
        ITET(LL,ICOL) = IOS
      enddo
!
      NTET(ICOL) = 0
720   NTET(ICOL) = NTET(ICOL) + 1
      NTCOL = NTET(ICOL)
      JJ = ITET(NTCOL,ICOL)
      IF (JJ < 9000)  GO TO 730
725   ICOL = ICOL - 1
      IF(ICOL <= 1) cycle
      GO TO 720
730   IF (JJ > IONS(2,1).AND.JJ < ISI)  GO TO 720
      ITREE(ICOL) = JJ
      II = ITREE(ICOL-1)
      IF (JJ /= ISI)  GO TO 710
!             -------------------------------------------- Ring detected
!                                                       Unique for ISI ?
      DO I = 2, ICOL-2
        ITI = ITREE(I)
        DO J = I+1, ICOL-1
          IF (ITI == ITREE(J))  GO TO 720
        enddo
      enddo
!             ---------------------------- Recorded as a ring temporally
      MOR = 0
      DO I = 1, ICOL-1, 2
        MOR = MOR + 1
        MING(MOR) = ITREE(I)
      enddo
!             -------------------------------------- Sorting in the ring
      DO I = 1, MOR-1
        MIG = MING(I)
        DO J = I+1, MOR
          IF (MI <= MING(J)) cycle
          MM      = MIG
          MIG     = MING(J)
          MING(J) = MM
        enddo
        MING(I) = MIG
      enddo
      IF (NR < 1)  GO TO 780
!             ------------------------------------- Check for uniqueness
      IDEL = 0
      DO 775  N = 1, NR
        MM = MRING(N)
        IF (MM == 0)  cycle
        IF (MOR < MM)  GO TO 760
        DO 756  J = 1, MM
          LI = LING(J,N)
          DO I = 1, MOR
            IF (LI == MING(I))  GO TO 756
          enddo
          GO TO 775
  756   enddo
        GO TO 720
!
  760   DO 765  I = 1, MOR
          MI = MING(I)
          DO J = 1, MM
            IF (MI == LING(J,N))  GO TO 765
          enddo
          GO TO 775
  765   enddo
        IF (IDEL >= 1)  GO TO 770
        MRING(N)    = MOR
        MEMBER(MOR) = MEMBER(MOR) + 1
        DO J = 1, MOR
          LING(J,N) = MING(J)
        enddo
        IDEL = 1
        GO TO 772
  770   MRING(N)   = 0
  772   MEMBER(MM) = MEMBER(MM) - 1
  775 enddo
      IF (IDEL >= 1)  GO TO 720
  780 MEMBER(MOR) = MEMBER(MOR) + 1
      NR = NR + 1
      IF (NR > LRG)  GO TO 791
      DO I = 1, MOR
        LING(I,NR) = MING(I)
      enddo
      MRING(NR) = MOR
      GO TO 720
    enddo
!
791 DO I = 1,LMBR
      MEB(I,IS) = MEMBER(I)
      NRG(I,IS) = NRG(I,IS) + MEMBER(I)
    enddo
  enddo
!
    WRITE (*,9999) NR
9999 FORMAT (10X,'<<<<< NETWORK: No. of total rings is ',I5,' >>>>>')
RETURN
!
901 DO IS = 1, 2
      DO I = 1, 9
        MEB(I,IS) = NRG(I,IS)
      enddo
    enddo
RETURN
END
!
!
!                                                               ========
!================================================================ POSURF
      SUBROUTINE  POSURF(myrank,mpsize)
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use vector
  use forces
  use pmorse
  use ewal
  use charge
!
  implicit none
!
  COMMON /WORK01/ PX(LNI),PY(LNI),PZ(LNI),DUMMY(3,LNI)
        double precision  PX,PY,PZ,DUMMY
  COMMON /PSURF / DISTM, iato1, iato2, iarea
        double precision  DISTM 
        integer*4 iato1,iato2,iarea
!
  double precision      PJI,DZ1,DZ2
  double precision      QCEF,QCEE,ARMAX,ARMIN,SFAR,SNEAR
  double precision      Tenergy,DISTA,ASPRES
  double precision      PO(3,LNI),DX1,DX2,DY1,DY2
  integer*4      IPV(3,LNI),LLL,M,JJ,II,L,K,III,ISP,I,J,IO
  integer*4 myrank, mpsize
  CHARACTER *1    SPO
!
  AV3BP(:,:) = 0.0d0
!
  WRITE(*,*)'Starting number of moving atom=', iato1
  WRITE(*,*)'Last number of moving atom=',iato2
  IF (iarea  ==  1 .OR. iarea  ==  2 .OR. iarea  ==  3) THEN
201 WRITE(*,*)'Surface postion is larger than 0.5? (y,n)'
    READ (*,*)SPO
    IF (SPO  /=  'y' .AND. SPO  /=  'n') GO TO 201
    SNEAR = 0.5
    SFAR  = 2.0
    IF (SPO  ==  'y') THEN
!        SNEAR = 2.0
!        SFAR  = 0.5
      SNEAR = 13.1
      SFAR  = 20.1
    ENDIF
  ENDIF
  IF (iarea  ==  4 .OR. iarea  ==  5 .OR. iarea  ==  6) THEN
    ARMIN =   5.0
    ARMAX =   5.0
  ENDIF
  DO IO = 1, NCOMPO
    IF (NION(IO) <= 0)  cycle
    DO I = IONS(1,IO), IONS(2,IO)
      UI(I) = 0.0
      FX(I) = 0.0D0
      FY(I) = 0.0D0
      FZ(I) = 0.0D0
      DO J = 1, 3
        IF (P(J,I) < 0.0D0.OR.P(J,I) >= 1.0D0)  THEN
          PJI     = -SIGN(1.0D0,P(J,I))
          P0(J,I) = P0(J,I) + PJI
          P(J,I)  = P(J,I)  + PJI
        END IF
      enddo
      PX(I)  = P(1,I)
      PY(I)  = P(2,I)
      PZ(I)  = P(3,I)
      ZII(I) = ZIO(IO)
      IF (IOND(I) == 0)  ZII(I) = 0.0
    enddo
  enddo
!
  if (runopt(23) == 'DIATOMIC  ')  call  Center_of_Diatomic_Molecule
!
  DO I = 1, LVA
    VAL(I) = 0.0D0
  enddo
  NRECRD(2) = NRECRD(2) + 1
  IF (MOD(NRECRD(1)-1,NTSTEP) == 0) THEN
    TINT = 0.0
    QCEE = 0.0D0
    QCEF = 0.0D0
  END IF
  DO I = 1,3
    DO J = iato1,iato2
      PO(I,J) = P(I,J)
    enddo
  enddo
  OPEN ( 37, FILE=FLNAME(17), STATUS = 'UNKNOWN',ACCESS='sequential',FORM='FORMATTED')
    WRITE(37,1002) 'dx','dy','dz','ENERGY(eV)','ENERGY(kJ/mol)', &
                   'val(9)','val(10)','val(11)','FZ(1)'
    DX1 = 0.0
    DX2 = 0.0
    DY1 = 0.0
    DY2 = 0.0
    DZ1 = 0.0
    DZ2 = 0.0
    IF (iarea  ==  1) THEN
      DX1 = SNEAR
      DX2 = SFAR
    ELSE IF (iarea  ==  2) THEN
      DY1 = SNEAR
      DY2 = SFAR
    ELSE IF (iarea  ==  3) THEN
      DZ1 = SNEAR
      DZ2 = SFAR
    ELSE IF (iarea  ==  4) THEN
      DX1 = ARMIN
      DX2 = ARMAX
      DY1 = ARMIN
      DY2 = ARMAX
    ELSE IF (iarea  ==  5) THEN
      DY1 = ARMIN
      DY2 = ARMAX
      DZ1 = ARMIN
      DZ2 = ARMAX
    ELSE IF (iarea  ==  6) THEN
      DX1 = ARMIN
      DX2 = ARMAX
      DZ1 = ARMIN
      DZ2 = ARMAX
    ENDIF
    if (isp  ==  1) then
      dx1 = 0.0
      dx2 = 0.0
      dy1 = 0.0
      dy2 = 0.0
      dz1 = 0.0
      dz2 = 0.0
    endif
    iii = 1
    DO I = -INT(DX1/DISTM+0.0001),INT(DX2/DISTM+0.0001)
      WRITE(*,*)'I=',I
      DO J = -INT(DY1/DISTM+0.0001),INT(DY2/DISTM+0.0001)
        WRITE(*,*)'J=',J
        DO K = -INT(DZ1/DISTM+0.0001),INT(DZ2/DISTM+0.0001)
          DO L = iato1,iato2
            PX(L) = PO(1,L) + I*DISTM/BOX(1)
            PY(L) = PO(2,L) + J*DISTM/BOX(2)
            PZ(L) = PO(3,L) + K*DISTM/BOX(3)
          enddo
!         --------------------------------------------write on file09p.dat
          iii = iii+1
          DO II = 1, NTION
            IPV(1,II) = PX(II) * 90000.D0
            IPV(2,II) = PY(II) * 90000.D0
            IPV(3,II) = PZ(II) * 90000.D0
          enddo
          WRITE (19,9002)  iii, 0,BOX(1),0.0,0.0,0.0,BOX(2),0.0,0.0,0.0,BOX(3)
          WRITE (19,9001) ((IPV(JJ,II),JJ=1,3),II=1,NTION)
 9001     FORMAT (18I5)
 9002     FORMAT (2I5, 9F7.3)
!
          DO M=9,16
            VAL(M)  = 0.0D0
          enddo
          do LLL = 1, NTION
            UI(LLL) = 0.0
            FX(LLL) = 0.0D0
            FY(LLL) = 0.0D0
            FZ(LLL) = 0.0D0
          enddo
!
          CALL  EWALDP1  (myrank, mpsize)
!
!            CALL  EWALDS
!
          if (i  ==  0 .and. j ==  0 .and. k  ==  0) then
            write(*,*)'VAL(3)=',VAL(3) !erg
            write(*,*)'VAL(4)=',VAL(4)
            write(*,*)'VAL(5)=',VAL(5)
            write(*,*)'VAL(6)=',VAL(6)
            write(*,*)'VAL(7)=',VAL(7)
            write(*,*)'VAL(8)=',VAL(8)
            write(*,*)'VAL(9)=',VAL(9)
          endif
          VAL(9) = VAL(9) + Ucself
!            write(*,*)'ucself=',Ucself
!            write(*,*)'VAL(9)=',val(9)
!
!         -------------------------------------------------- Energies
          VAL(10) = VAL(10) + ECORR
          VAL(12) = VAL(9) + VAL(10) + VAL(11)
          Tenergy=  (VAL(12) + VAL(13))*1.0D12/1.602176462D0  !eV
          DO L = 9, 13
            VAL(L)  = VAL(L) * FJMOL   !erg -> kJmol^-1
          enddo
          VAL(14) = VAL(12) + VAL(13)
          ASPRES  = (SPRES(1) + SPRES(2) + SPRES(3)) / 3.0
          VAL(15) = ASPRES * VOL * FJMOL*1.0D-11 *1.0D-3
          VAL(16) = VAL(14) + VAL(15)
!
! 1991           FORMAT (F8.2,7F8.4)
! 1992           format (8F9.2)
! 1993           format (F9.5, F9.3, 3F9.5,3F9.5)
! 1994           format (10F8.2)
! 1995           format (10F8.3 )
!         ---------------------------------------write on file09v.dat
          write  (29,'(F10.3,7F10.5)')  (VAL(II),II=1,8)
          write  (29,'(8F10.3)')  (VAL(II),II=9,16)
          write  (29,'(F10.6,F10.4,3F10.6,3F10.7)')  (VAL(II),II=17,24)
          write  (29,'(10F9.3)')  (VAL(II),II=25,34)
          write  (29,'(10F9.3)')  (VAL(II),II=35,44)
!
          IF (SPO  ==  'y') THEN
            DISTA = -dble(K)*DISTM
          ELSEIF (SPO  ==  'n') THEN
            DISTA = dble(K)*DISTM
          ENDIF
          WRITE(37,1001)I*DISTM,J*DISTM,DISTA,Tenergy,VAL(14),val(9),val(10),val(11),FZ(1)
        enddo
      enddo
    enddo
  close(37)
 1001 FORMAT(F7.3,1x,F7.3,1x,F7.3,1x,E25.12,1x,E25.12,1X,E25.12,1x,e25.12,1x,e25.12,1x,e25.12)
 1002 FORMAT(A7,1X,A7,1X,A7,1X,A25,1X,A25,1X,A25,1X,A25,1X,A25,1x,A25)
RETURN
END
!                                                               ========
!================================================================ KCLOCK
SUBROUTINE  KCLOCK  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
  use param
  use charac
!
!
      integer*4    IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
!    IF (FLNAME(3) == 'NDP-FORTRAN386' .OR.  &
!        FLNAME(3) == 'NEWS-F77      ')  THEN
!        CALL  NDP386  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    END IF
!    IF (FLNAME(3) == 'Lehey LF90    ' .OR.  &
!        FLNAME(3) == 'IBM-AIX-FORT  ')  THEN
!        CALL  IBMAIX  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    END IF
!    IF (FLNAME(3) == 'LUNA88K       ')  CALL  LUNA88(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'PARALLEL-F77  ')  CALL  PARAF7(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'HP-9000       ')  CALL  HP9000(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'DN10000       ')  CALL  DN1000(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'S820-80       ')  CALL  HTS820(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'CRAY-F77      ')  CALL  CRAY77(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'IBM-AIX-FORT  ')  CALL  IBMAIX(IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'DEC Fortran   ')  CALL  DECF  (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
    IF (FLNAME(3) == 'F90           ')  CALL  F90   (IYEAR,IMONTH,IDAY,IHOUR,IMINUT,ISECND,I100TH)
!    IF (FLNAME(3) == 'Ms-Fortran    ')  THEN
!             CALL  GETDAT  (IYEAR,IMONTH,IDAY)
!             CALL  GETTIM  (IHOUR,IMINUT,ISECND,I100TH)
!             IYEAR = MOD(IYEAR,100)
!    END IF
    IF (FLNAME(3) == 'Dummy         ')  THEN
               IYEAR  = 0
               IMONTH = 0
               IDAY   = 0
               IHOUR  = 0
               IMINUT = 0
               ISECND = 0
               I100TH = 0
    END IF
    RETURN
END
!
!
!                                                      =================
!======================================================= NDP-FORTRAN-386
!                                                     and SONY RISC-NEWS
!SUBROUTINE  NDP386  (IYEAR, IMONTH, IDAY,IHOUR, IMINUT, ISECND, I100TH)
!
!      integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!      CHARACTER  *8   ATIME
!      CHARACTER  *9   ADATE
!      CHARACTER  *3   BDATE(3), B2
!      EQUIVALENCE     (ADATE,BDATE(1))
!      CHARACTER  *1   CH
!!     INUM(CH) = ICHAR(CH) - 48
!!
!!            CALL  TIME  (ATIME)
!!            CALL  DATE  (ADATE)
!!
!!           IHOUR  = INUM(ATIME(1:1))*10 + INUM(ATIME(2:2))
!!           IMINUT = INUM(ATIME(4:4))*10 + INUM(ATIME(5:5))
!!           ISECND = INUM(ATIME(7:7))*10 + INUM(ATIME(8:8))
!!           IYEAR  = INUM(ADATE(8:8))*10 + INUM(ADATE(9:9))
!!           IDAY   = INUM(ADATE(1:1))*10 + INUM(ADATE(2:2))
!            iyear  = mod(iyear,100)
!!           B2 = BDATE(2)
!!           IF (B2 == 'JAN' .OR. B2 == 'Jan')  IMONTH =  1
!!           IF (B2 == 'FEB' .OR. B2 == 'Feb')  IMONTH =  2
!!           IF (B2 == 'MAR' .OR. B2 == 'Mar')  IMONTH =  3
!!           IF (B2 == 'APR' .OR. B2 == 'Apr')  IMONTH =  4
!!           IF (B2 == 'MAY' .OR. B2 == 'May')  IMONTH =  5
!!           IF (B2 == 'JUN' .OR. B2 == 'Jun')  IMONTH =  6
!!           IF (B2 == 'JUL' .OR. B2 == 'Jul')  IMONTH =  7
!!           IF (B2 == 'AUG' .OR. B2 == 'Aug')  IMONTH =  8
!!           IF (B2 == 'SEP' .OR. B2 == 'Sep')  IMONTH =  9
!!           IF (B2 == 'OCT' .OR. B2 == 'Oct')  IMONTH = 10
!!           IF (B2 == 'NOV' .OR. B2 == 'Nov')  IMONTH = 11
!!           IF (B2 == 'DEC' .OR. B2 == 'Dec')  IMONTH = 12
!            I100TH = 0
!      RETURN
!END
!
!
!                                                             ==========
!============================================================== LUNA-88K
!SUBROUTINE  LUNA88  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND, I100TH)
!
!      integer(KIND=4)  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!      integer(KIND=4)  JTIME(3),JDATE(3)
!!
!             do i=1, 3
!                jtime(i) = 0
!                jdate(i) = 0
!             enddo
!!
!!            CALL  ITIME  (JTIME)
!!            CALL  IDATE  (JDATE)
!!
!             IYEAR  = MOD(JDATE(3),100)
!             IMONTH = JDATE(2)
!             IDAY   = JDATE(1)
!             IHOUR  = JTIME(1)
!             IMINUT = JTIME(2)
!             ISECND = JTIME(3)
!             I100TH = 0
!      RETURN
!END
!
!
!                                                           ============
!============================================================ Parallel-F
!SUBROUTINE  PARAF7  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND, I100TH)
!
!      integer(KIND=4)  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!      integer(KIND=4)  JTIME,JDATE,NDAYS(12)
!      DATA  NDAYS / 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /
!!     DATA  NDAYS / 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /
!!
!!       1970.1.1 0:0 - 1992.1.1 0:0 : 365*22+5 daya = 8035 days
!!                                     8035*24*60*60 sec = 694224000 sec
!!                                     GMT > JST : +9 HOURS
!!            CALL  ICLOCK  (jtime)
!!
!             jtime  = jtime - 694224000 + 32400
!             JDATE  = JTIME / (60*60*24) + 1
!!
!             jtime  = mod(jtime,24*60*60)
!             IHOUR  = jtime/(60*60)
!             jtime  = mod(jtime,60*60)
!             IMINUT = JTIME / 60
!             ISECND = MOD(jtime,60)
!             I100TH = 0
!!
!!            NYDAYS = 365
!             NYDAYS = 366
!             IYEAR  = JDATE / NYDAYS
!             NDAY   = JDATE - IYEAR*NYDAYS
!             DO I = 1, 12
!                IF (NDAY - NDAYS(I) <= 0)  GO TO 20
!                NDAY = NDAY - NDAYS(I)
!             enddo
!   20        IMONTH = I
!             IDAY   = NDAY
!             IYEAR  = mod(IYEAR + 92, 100)
!      RETURN
!END
!
!
!                                                       ================
!======================================================== HP Apollo9000
!SUBROUTINE  HP9000  (IYEAR, IMONTH, IDAY,IHOUR, IMINUT, ISECND, I100TH)
!
!      integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!      CHARACTER  *8   ATIME
!!
!!           CALL  TIME   (ATIME)
!!           CALL  IDATE  (IMONTH, IDAY, IYEAR)
!!
!            IHOUR  = ICHAR(ATIME(1:1))*10 + ICHAR(ATIME(2:2)) -528
!            IMINUT = ICHAR(ATIME(4:4))*10 + ICHAR(ATIME(5:5)) -528
!            ISECND = ICHAR(ATIME(7:7))*10 + ICHAR(ATIME(8:8)) -528
!            I100TH = 0
!            iyear  = mod(iyear,100)
!      RETURN
!END
!
!
!                                                             ==========
!============================================================== DN-10000
!                                ftn in AEGIS operating system
!SUBROUTINE  DN1000  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND, I100TH)
!%INCLUDE '//dn10020/sys/ins/base.ins.ftn'
!%INCLUDE '//dn10020/sys/ins/time.ins.ftn'
!%INCLUDE '//dn10020/sys/ins/cal.ins.ftn'
!
!      integer(KIND=4)  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!!     integer(KIND=2)  time_clock(3),c_clock(6)
!!     integer(KIND=2)  JYEAR,JMONTH,JDAY,JHOUR,JMINUT,JSECND,JMSE
!!     EQUIVALENCE (c_clock(1),JYEAR),
!!    *            (c_clock(2),JMONTH),
!!    *            (c_clock(3),JDAY),
!!    *            (c_clock(4),JHOUR),
!!    *            (c_clock(5),JMINUT),
!!    *            (c_clock(6),JSECND)
!!
!             jhour  = 0
!             jminut = 0
!             jsecnd = 0
!             jyear  = 0
!             jmonth = 0
!             jday   = 0
!!
!!            CALL CAL_$GET_LOCAL_TIME(time_clock)
!!            CALL CAL_$DECODE_TIME(time_clock,c_clock)
!             IHOUR  = JHOUR
!             IMINUT = JMINUT
!             ISECND = JSECND
!             I100th = 0
!!
!!            CALL CAL_$GET_LOCAL_TIME(time_clock)
!!            CALL CAL_$DECODE_TIME(time_clock,c_clock)
!             IYEAR  = JYEAR - JYEAR/100*100
!             IMONTH = JMONTH
!             IDAY   = JDAY
!      RETURN
!END
!
!
!                                                           ============
!============================================================ H-S-820-80
!SUBROUTINE  HTS820  (IYEAR, IMONTH, IDAY,IHOUR, IMINUT, ISECND, I100TH)
!
      !integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
!     CHARACTER  *12  ATIME
!     CHARACTER  *8   ADATE
!     CHARACTER  *1   BTIME(8),BDATE(8)
!     EQUIVALENCE     (ATIME,BTIME(1)),(ADATE,BDATE(1))
!
!            CALL  CLOCK  (ATIME, 1)
!            CALL  DATE   (ADATE)
!
!            IHOUR  = (ICHAR(BTIME(1))-240)*10 + (ICHAR(BTIME(2))-240)
!            IMINUT = (ICHAR(BTIME(4))-240)*10 + (ICHAR(BTIME(5))-240)
!            ISECND = (ICHAR(BTIME(7))-240)*10 + (ICHAR(BTIME(8))-240)
!            I100TH = 0
!            IYEAR  = (ICHAR(BDATE(1))-240)*10 + (ICHAR(BDATE(2))-240)
             !iyear  = mod(iyear,100)
!            IMONTH = (ICHAR(BDATE(4))-240)*10 + (ICHAR(BDATE(5))-240)
!            IDAY   = (ICHAR(BDATE(7))-240)*10 + (ICHAR(BDATE(8))-240)
!      RETURN
!END
!
!
!                                                           ============
!============================================================  CRAY-C90
!SUBROUTINE  CRAY77  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND, I100TH)
!
      !integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!
!     CHARACTER  *8   ATIME
!     CHARACTER  *8   ADATE
!     CHARACTER  *1   CH
!     INUM(CH) = ICHAR(CH) - 48
!
!           CALL  CLOCK (ATIME)
!           CALL  DATE  (ADATE)
!           IHOUR  = INUM(ATIME(1:1))*10 + INUM(ATIME(2:2))
!           IMINUT = INUM(ATIME(4:4))*10 + INUM(ATIME(5:5))
!           ISECND = INUM(ATIME(7:7))*10 + INUM(ATIME(8:8))
!           IYEAR  = INUM(ADATE(7:7))*10 + INUM(ADATE(8:8))
            !iyear  = mod(iyear,100)
!           IMONTH = INUM(ADATE(1:1))*10 + INUM(ADATE(2:2))
!           IDAY   = INUM(ADATE(4:4))*10 + INUM(ADATE(5:5))
!           I100TH = 0
!
!      RETURN
!END
!
!
!                                                      =================
!======================================================= IBM AIX FORTRAN
!                                                   and Lehey Fortran 90
!SUBROUTINE  IBMAIX  (IYEAR, IMONTH, IDAY,IHOUR, IMINUT, ISECND, I100TH)
!
!  integer(KIND=4)   IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!!
!  CHARACTER  *1   CH
!  CHARACTER       DAT*8, TIM*10, ZONE*5
!  INTEGER(KIND=4)         IVV(8)
!!      INUM(CH) = IACHAR(CH) - 48
!!
!!            CALL  DATE_AND_TIME  (DAT,TIM,ZONE,IVV)
!!
!!            IHOUR  = INUM(TIM(1:1))*10 + INUM(TIM(2:2))
!!            IMINUT = INUM(TIM(3:3))*10 + INUM(TIM(4:4))
!!            ISECND = INUM(TIM(5:5))*10 + INUM(TIM(6:6))
!!            IYEAR  = INUM(DAT(3:3))*10 + INUM(DAT(4:4))
!             iyear  = mod(iyear,100)
!!            IMONTH = INUM(DAT(5:5))*10 + INUM(DAT(6:6))
!!            IDAY   = INUM(DAT(7:7))*10 + INUM(DAT(8:8))
!             I100TH = 0
!  RETURN
!END
!
!
!================================================================= DECF
!SUBROUTINE  DECF  (IYEAR, IMONTH, IDAY,IHOUR, IMINUT, ISECND, I100TH)
!     --- Digital Fortran (Unix) & Visual Fortran (Windows) ---
!     ---               Support Y2000 Problem               ---
!  integer(KIND=4)  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
!  character  Adtval(3)*12
!  integer(KIND=4)    Idtval(8)
!!
!  Call DATE_AND_TIME(Adtval(1),Adtval(2),Adtval(3),Idtval)
!  IYEAR  = mod(Idtval(1),100) -1900 ! now cut the centuries
!  IMONTH = Idtval(2)
!  IDAY   = Idtval(3)
!  IHOUR  = Idtval(5)
!  IMINUT = Idtval(6)
!  ISECND = Idtval(7)
!  I100TH = Idtval(8)
!  RETURN
!End
!==================================================================! F90
SUBROUTINE  F90  (IYEAR, IMONTH, IDAY, IHOUR, IMINUT, ISECND, I100TH)
!     --- Fortran 90 ---
       implicit none
       character date * 8, time * 10, zone *5
       integer*4  IYEAR,IMONTH,IDAY, IHOUR,IMINUT,ISECND,I100TH
       integer*4  ia(1:8)
!
       call date_and_time(date, time, zone, ia)
!
       isecnd = ia(7)
       iminut = ia(6)
       ihour  = ia(5)
       iday   = ia(3)
       IMONTH = ia(2)
       iyear  = ia(1) 
       I100TH = ia(8)
    RETURN
End

