SUBROUTINE  EWALDP1_NEW  (myrank, mpsize)
!
  use param
  use charac
  use atomsi
  use temprs
  use aboxof
  use values
  use paramt
  use tables
  use counts
  use radial
  use forces
  use cartes
  use molecu
  use vector
  use pmorse
  use quanco
  use ewal
  use charge
  use datoms
  use pos
!
!  implicit none
!
  integer*4  IRDF(LTB+1),  MRDF(LTB,LEE),   iii(3), icp
  double precision  E2(LSR),F2(LSR)
  double precision  PIX,DX,RX,DFX,FIX, R00,X0
  double precision  PIY,DY,RY,DFY,FIY,R01,X1,FIJ,FSIJ
  double precision  PIZ,DZ,RZ,DFZ,FIZ,R02,X2,UII,EIJ,ESIJ
  double precision  VAL09P,ECDD,FCDD,ARIJ2,ARIJ,ARIJ3,ARIJ4,ASP
  double precision  VALnn(11), VALnnC(7)
  double precision  RIJ, RIJ2, RCUT2, zizj
  double precision  pjx0,pjy0,pjz0, TQCEP,RIJ3
  double precision  wal0Nc(7), wal0N(11),        rrr(7,2)
  double precision  uip(lni), fxp(lni), fyp(lni), fzp(lni)
  double precision  uicp(lni),UIIC   !WATER-POL
  double precision  Xmyui, Ymyui,Zmyui,  COFWAT  !Water-pol
  double precision  dtmp, dtmpxyz(3)
  integer*4  lp1,lp2  !WATER-POL
  double precision  Mz,pjx,pjy,pjz,ddd
  integer*4  iddatom(101,lni)
  double precision  dddatom(100,lni)
  integer*4  ierr,idiatom,iquantum,ibmhexp,iwatpol,i,j,myrank,mpsize
  integer*4  io,l,i1,i2,j1,j2,k,ip0,ip1,ip2,kk,m,mm,NNCOMPO,IOO,JO,IN
  integer*4  ijk,n,kkk,jj,ko,no
! ------------------------------------------------------------SPME
  integer nx,ny,nz,KIX,KIY,KIZ,ispme
  double precision UX,UY,UZ,SPL,UUX,UUY,UUZ,DUX,DUY,DUZ,SPLP,SPLPP
  double precision DDUX,DDUY,DDUZ
  double precision FCOFFx,FCOFFy,FCOFFz
  double precision UIII
  integer kkai,nsp,nmkkai,ndiv,nnx,nny,nnz,JX,JY,JZ
  integer :: tmp_size(2), array_size,local_NVNz,local_NVNz_offset
  integer,allocatable :: idisp(:), ircnt(:),iddatom_pack(:),iddatom_indx(:)
  real(8),allocatable :: dddatom_pack(:)
  complex(8),allocatable :: recvbuf(:,:,:)
! ------------------------------------------------------------SPME
!
  include  'mpif.h'
  integer*4  status(MPI_STATUS_SIZE)
!
!     ==== This is a routine to distribute and correct data to and from
!     ==== EWALD routines of MASTER and SLAVE processes.
!
!     --------------------------------- Coulomb term by EWALD method and
!                                               short range interactions
!
!
!     ----------------------- Put the central atom of 3-body interaction
!                              at the last of atom species, to calculate
!                                                  3-body terms properly
!
  RCUT2 = rcut(1) * rcut(1)
!
  VALnn(:) = 0.0D0
  VALnnC(:) = 0.0D0
!
  VIRLSR = 0.0D0
  TQCE   = 0.0D0
!
  idiatom  = 0
  if (runopt(23) == 'DIATOMIC  ')  idiatom  = 1
  iquantum = 0
  IF (RUNOPT(12) == 'QUANTUM   ')  iquantum = 1
  ibmhexp  = 0
  if (RUNOPT( 8) == 'BMHEXP*   ')  ibmhexp  = 1
  iwatpol  = 0
  if (runopt(34) == 'WATER-POL ' .or. runopt(34) == 'WATER-POLN')  iwatpol  = 1
  ispme  = 0
  if (runopt(45) == 'SPME      ')  ispme  = 1
!
  if (NRECRD(3) == 1 .and. JJJ == 1) then  !WATER-POL AND NOSE
    if (RUNOPT(45) == 'SPME      ') then
      allocate(AQX(ntion+ndmole,NVNx),AQY(ntion+ndmole,NVNy),AQZ(ntion+ndmole,NVNz))
      allocate(dMdux(ntion+ndmole,NVNx),dMduy(ntion+ndmole,NVNy),dMduz(ntion+ndmole,NVNz))
      allocate(kkx(ntion+ndmole,NVNx),kky(ntion+ndmole,NVNy),kkz(ntion+ndmole,NVNz))
    endif
    call MPI_Bcast (irecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (idiatom,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (iquantum,                1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ibmhexp,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (iwatpol,                 1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)  !WATER-POL
    call MPI_Bcast (iatomo,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !WATER-POL
    call MPI_Bcast (ispme,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !SPME     
    call MPI_Bcast (NTION,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NION(1),              lemw,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IION(1),              lemw,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IONS(1,1),          lemw*2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NCOMPO,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NPAIR,                   1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (WIO(1),               lemw,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZIO(1),               lemw,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NDMOLE,                  1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZIIP(1),      ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !WATER-POL
    call MPI_Bcast (RSWTCH(1),             lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (CIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DIJ(1),                lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D4IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (D7IJ(1),               lef,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (N3BP,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (I3BP(1,1),           L3P*3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ANG3BP(1),             L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FK3BP(1),              L3P,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BGRD(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3BLIM(1,1),         L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (R3LIM(1,1),          L3P*2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (E1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (F1(1,1),         LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q1U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (Q2U1(1,1),       LSR*NPAIR,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (ZMOLE(1),                2,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DMOLE(1,1),        4*NTION,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (DINTRA,                  1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IDMOLE(1,1),3*NTION+NDMOLE,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (IATOM2(1),               2,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (NVNx,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
    call MPI_Bcast (NVNy,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
    call MPI_Bcast (NVNz,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr) !SPME
!    write (*,*) '          MPI_Bcast sent NTION, E1, ZII, etc. '
  end if
!
  iii(1) = nrcut(1)
  iii(2) = nrcut(2)
  iii(3) = nvn
  call MPI_Bcast (iii(1),                  3,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
   
  if (RUNOPT(45) == 'SPME      ') then
!write(*,*)'SPME mode'
    ARQ(:,:,:)=(0.0d0,0.0d0)
    DARQ(:,:,:)=(0.0d0,0.0d0)
    DARQp(:,:,:)=(0.0d0,0.0d0)
    if (JJJ == 1) then 
      AQX(:,:)=0.0d0
      AQY(:,:)=0.0d0
      AQZ(:,:)=0.0d0
      dMdux(:,:)=0.0d0
      dMduy(:,:)=0.0d0
      dMduz(:,:)=0.0d0
    endif
!
    NNCOMPO = NCOMPO
    if(iwatpol == 1)  NNCOMPO = NCOMPO + 1   !WATER-POL
IOLOOP: do IO = 1, NNCOMPO
ILOOP:    DO I = ions(1,IO), ions(2,IO)
            if (JJJ == 1) then
              DX = DBLE(NVNx)*PX(I)  ! Scaled fractional coordinate
              do nx=1,NDIM !Loop for non-zero values of M(u)
                UUX = DX-dble(nx-1)  !
                KIX = int(UUX)
                UX = DX - dble(KIX)
                if (UUX < 0.0d0) then
                  KIX = int(UUX+dble(NVNx))
                  UX = DX + dble (NVNx) - dble(KIX)
                endif
!               Mn
                SPL=0.0d0
                kkai=1
                nmkkai=nkai
                do nsp = 0,NDIM
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUX = UX-dble(nsp)
                  IF(DUX <0.0d0) DUX=0.0d0
                  SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DUX**(NDIM-1)
                enddo
                SPL=SPL/dble(nkai/NDIM)              !Mn(u-k-nK)
                AQX(I,KIX+1) = SPL   !to start k=0 from element 1
                kkx(I,nx)=KIX+1
!
!               Mn-1
                SPLP=0.0d0
                SPLPP=0.0d0
                kkai=1
                nmkkai=nkai/NDIM
                do nsp = 0,NDIM-1
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-1-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUX = UX-dble(nsp)
                  DDUX = DUX-1.0d0
                  IF(DUX <0.0d0) DUX=0.0d0
                  IF(DDUX <0.0d0) DDUX=0.0d0
                  SPLP=SPLP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DUX**(NDIM-2)
                  SPLPP=SPLPP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DDUX**(NDIM-2)
                enddo
                SPLP=SPLP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                SPLPP=SPLPP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                dMdux(I,KIX+1) = SPLP - SPLPP
              end do
!
              DY = DBLE(NVNy)*PY(I)
              do ny=1,NDIM
                UUY = DY-dble(ny-1)
                KIY = int(UUY)
                UY = DY - dble(KIY)
                if (UUY < 0.0d0) then
                  KIY = int(UUY+dble(NVNy))
                  UY = DY + dble (NVNy) - dble(KIY)
                endif
                SPL=0.0d0
                kkai=1
                nmkkai=nkai
                do nsp = 0,NDIM
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUY = UY-dble(nsp)
                  IF(DUY <0.0d0) DUY=0.0d0
                  SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DUY**(NDIM-1)
                enddo
                SPL=SPL/dble(nkai/NDIM)
                AQY(I,KIY+1) = SPL
                kky(I,ny)=KIY+1
!
!               Mn-1
                SPLP=0.0d0
                SPLPP=0.0d0
                kkai=1
                nmkkai=nkai/NDIM
                do nsp = 0,NDIM-1
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-1-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUY = UY-dble(nsp)
                  DDUY = DUY-1.0d0
                  IF(DUY <0.0d0) DUY=0.0d0
                  IF(DDUY <0.0d0) DDUY=0.0d0
                  SPLP=SPLP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DUY**(NDIM-2)
                  SPLPP=SPLPP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DDUY**(NDIM-2)
                enddo
                SPLP=SPLP/dble(nkai/NDIM/(NDIM-1))              !Mn(u-k-nK)
                SPLPP=SPLPP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                dMduy(I,KIY+1) = SPLP - SPLPP
              end do
!
              DZ = DBLE(NVNz)*PZ(I)
              do nz =1,NDIM
                UUZ = DZ-dble(nz-1)
                KIZ = int(UUZ)
                UZ = DZ - dble(KIZ)
                if (UUZ < 0.0d0) then
                  KIZ = int(UUZ+dble(NVNz))
                  UZ = DZ + dble(NVNz) - dble(KIZ)
                endif
                SPL=0.0d0
                kkai=1
                nmkkai=nkai
                do nsp = 0,NDIM
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUZ = UZ-dble(nsp)
                  IF(DUZ <0.0d0) DUZ=0.0d0
                  SPL=SPL+(-1.0d0)**nsp*dble(nkai)/dble(kkai)/dble(nmkkai)*DUZ**(NDIM-1)
                enddo
                SPL=SPL/dble(nkai/NDIM)
                AQZ(I,KIZ+1) = SPL
                kkz(I,nz)=KIZ+1
!
!               Mn-1
                SPLP=0.0d0
                SPLPP=0.0d0
                kkai=1
                nmkkai=nkai/NDIM
                do nsp = 0,NDIM-1
                  ndiv=1
                  if (nsp > 0) kkai = kkai*nsp
                  if (nsp > 0) ndiv=NDIM-1-(nsp-1)
                  nmkkai=nmkkai/ndiv
                  DUZ = UZ-dble(nsp)
                  DDUZ = DUZ -1.0d0
                  IF(DUZ <0.0d0) DUZ=0.0d0
                  IF(DDUZ <0.0d0) DDUZ=0.0d0
                  SPLP=SPLP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DUZ**(NDIM-2)
                  SPLPP=SPLPP+(-1.0d0)**nsp*dble(nkai)/dble(NDIM)/dble(kkai)/dble(nmkkai)*DDUZ**(NDIM-2)
                enddo
                SPLP=SPLP/dble(nkai/NDIM/(NDIM-1))              !Mn(u-k-nK)
                SPLPP=SPLPP/dble(nkai/NDIM/(NDIM-1))              !Mn-1(u-k-nK)
                dMduz(I,KIZ+1) = SPLP - SPLPP
              end do
            endif
!
            do nz = 1, NDIM
              nnz=kkz(I,nz)
              do ny = 1, NDIM
                nny=kky(I,ny)
                do nx = 1, NDIM
                  nnx=kkx(I,nx)
                  ARQ(nnx,nny,nnz)=ARQ(nnx,nny,nnz)+ZII(I)*AQX(I,nnx)*AQY(I,nny)*AQZ(I,nnz)
                enddo
              enddo
            enddo
!
          end do ILOOP        !I
        end do IOLOOP          !IO
      if ( .not.allocated(idisp) ) allocate( idisp(0:mpsize-1) ); idisp=0
      if ( .not.allocated(ircnt) ) allocate( ircnt(0:mpsize-1) ); ircnt=0
      call parallel_data_utility( local_NVNz, local_NVNz_offset, "pop" )
      call MPI_Allgather( local_NVNz_offset, 1, MPI_INTEGER, idisp, 1, MPI_INTEGER, MPI_COMM_WORLD, ierr )
      call MPI_Allgather( local_NVNz       , 1, MPI_INTEGER, ircnt, 1, MPI_INTEGER, MPI_COMM_WORLD, ierr )
      ircnt=ircnt*NVNx*NVNy
      idisp=idisp*NVNx*NVNy
      if ( all(ircnt==0) ) then
         call MPI_Bcast (ARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
         call MPI_Bcast (DARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
         call MPI_Bcast (THREC(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
         call MPI_Bcast (PNVxx(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVyy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVzz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVxy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVxz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVyz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      else
         if ( allocated(recvbuf) ) deallocate(recvbuf)
         allocate( recvbuf(NVNx,NVNy,local_NVNz) ); recvbuf=(0.0d0,0.0d0)
         call MPI_Scatterv( ARQ, ircnt, idisp, MPI_DOUBLE_COMPLEX, recvbuf &
                          , NVNx*NVNy*local_NVNz, MPI_DOUBLE_COMPLEX, 0, MPI_COMM_WORLD, ierr )
         call MPI_Scatterv( DARQ, ircnt, idisp, MPI_DOUBLE_COMPLEX, recvbuf &
                          , NVNx*NVNy*local_NVNz, MPI_DOUBLE_COMPLEX, 0, MPI_COMM_WORLD, ierr )
!         call MPI_Bcast (ARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
!         call MPI_Bcast (DARQ(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_COMPLEX,0,MPI_COMM_WORLD,ierr)
         call MPI_Bcast (THREC(1,1,1), NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
         call MPI_Bcast (PNVxx(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVyy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVzz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVxy(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVxz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
         call MPI_Bcast (PNVyz(1,1,1),NVNx*NVNy*NVNz,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) 
      end if
      call MPI_Bcast (QCOFF,                  1, MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  endif
!
  call MPI_Bcast (KRDF,                    1,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)   !WATER-POL
  call MPI_Bcast (ZII(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr) !WATER-POL
  call MPI_Bcast (nrecrd,                  9,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
  if (ispme == 0) then
    call MPI_Bcast (NVEC(1,1),           3*NVN,         MPI_INTEGER4,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (FNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (UNV(1),                NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
    call MPI_Bcast (PNV(1,1),            6*NVN,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  endif
  do i=1, 6
    rrr(i,1) = box(i)
    rrr(i,2) = rbox(i)
  end do
  rrr(7,1) = rcut(1)
  rrr(7,2) = rcut(2)
  call MPI_Bcast (rrr(1,1),               14,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (E0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (F0(1),                 LTB,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!
  call MPI_Bcast (PX(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PY(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (PZ(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
  call MPI_Bcast (r3limax,                 1,MPI_DOUBLE_PRECISION,0,MPI_COMM_WORLD,ierr)
!  write (*,8801)
8801 format (11x,'MPI_Bcast sent NVN, BOX, E0, F0, Px-Pz, etc.')
!
!     ------------------------------------------ Coulomb reciprocal term
!     ------------------------------------ Coulmb direct and short range
!
  call  EWALDP3  (idiatom, iquantum, iwatpol, ispme, valnn, VALnnC, myrank, mpsize)
!
!
  IF(RUNOPT(30)  ==  'EWALD-C   ') then
    Mz = 0.0d0
    do IO = 1, NCOMPO
      do I = IONS(1,IO), IONS(2,IO)
        Mz = Mz + PZ(I)*ZIO(IO)
      enddo
    enddo
    Mz = Mz * BOX(3)
!
    valnn(9) = valnn(9) + 2.0d0*PI*(Mz*ELC*1.0d-8)**2/(VOL*1.d-24)
    do IO = 1, NCOMPO
      do I = IONS(1,IO), IONS(2,IO)
        FZ(I) = FZ(I) -4.0d0*PI* ZIO(IO)*Mz*ELC**2*1.0d-8/(VOL*1.d-24)
      enddo
    enddo
  ENDIF
!     ------------------ Calculation of Coulomb of three point charges
  if (runopt(23) == 'DIATOMIC  ')  then
    do  L = 1, 2
      i1 = ntion + 1
      i2 = ntion + ndmole
      if (L  ==  2)  i1 = ntion + 2
      DO I = i1, i2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        j1 = 1
        j2 = ntion
        IF (L == 2)  THEN
          J1 = NTION + 1
          j2 = I-1
        END IF
        DO J = j1, j2
          ZIZJ  = ZII(I) * ZII(J)
!P              ZIJE2 = ZIO(IO) * ZIO(JO) * ELC**2
          pjx0 = p(1,j)
          pjy0 = p(2,j)
          pjz0 = p(3,j)
          if (pjx0 < pix)  pjx0 = pjx0 + 1.0
          if (pjy0 < piy)  pjy0 = pjy0 + 1.0
          if (pjz0 < piz)  pjz0 = pjz0 + 1.0
          DO K = 1, 8
            pjx = pjx0 - transx(k)
            pjy = pjy0 - transy(k)
            pjz = pjz0 - transz(k)
            RX = PIX - PjX
            RY = PIY - PjY
            RZ = PIZ - PjZ
!                         - - - - - delete these if-statements for triclinic
!                         IF (ABS(RX) > 0.5)  RX = RX - SIGN(1.0D0,RX)
!                         IF (ABS(RY) > 0.5)  RY = RY - SIGN(1.0D0,RY)
!                         IF (ABS(RZ) > 0.5)  RZ = RZ - SIGN(1.0D0,RZ)
!                          DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!                          DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!                          DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
            DX = RX * BOX(1)
            DY = RY * BOX(2)
            DZ = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            IF (RIJ2 <= RCUT2)  GO TO 257
          enddo
          GO TO 262
!
257       RIJ = SQRT(RIJ2)
          IP0 = INT(RIJ*100.0)
!         ---------------------------------- Interpolation
          IP1 = IP0 + 1
          IP2 = IP0 + 2
          R00 = IP0 * 0.01D0
          R01 = IP1 * 0.01D0
          R02 = IP2 * 0.01D0
!                       X0 = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                       X1 = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                       X2 = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
          X0 = (RIJ-R01)*(RIJ-R02) *    5000.0
          X1 = (RIJ-R00)*(RIJ-R02) * (-10000.0)
          X2 = (RIJ-R00)*(RIJ-R01) *    5000.0
          FIJ = (F0(IP0)*X0 +F0(IP1)*X1 +F0(IP2)*X2)*ZIZJ
          EIJ = (E0(IP0)*X0 +E0(IP1)*X1 +E0(IP2)*X2)*ZIZJ
          VALnn(9) = VALnn(9) + EIJ
          UII   = UII   + EIJ
          UI(J) = UI(J) + EIJ
          DFX = FIJ * DX
          DFY = FIJ * DY
          DFZ = FIJ * DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(J) = FX(J) - DFX
          FY(J) = FY(J) - DFY
          FZ(J) = FZ(J) - DFZ
          VALnn(3) = VALnn(3) + DFX * DX
          VALnn(4) = VALnn(4) + DFY * DY
          VALnn(5) = VALnn(5) + DFZ * DZ
          VALnn(6) = VALnn(6) + DFX * DY
          VALnn(7) = VALnn(7) + DFX * DZ
          VALnn(8) = VALnn(8) + DFY * DZ
262       CONTINUE
        enddo
        FX(I) = FX(I) + FIX
        FY(I) = FY(I) + FIY
        FZ(I) = FZ(I) + FIZ
        UI(I) = UI(I) + UII
      enddo
    enddo
  end if
  if (RUNOPT(34) == 'WATER-POL ' .or. RUNOPT(34) == 'WATER-POLN') then 
                                                 ! Remove innermolecular Coulomb
    VAL09P = VALnn(9)
    no = 0
    do io = IONS(1,IATOMO), IONS(2,IATOMO)
      no = no + 1
      do k = 2, 4
        kk = ih2o(k,no)
        PIX = PX(kk)
        PIY = PY(kk)
        PIZ = PZ(kk)
        FIX = 0.0D0
        FIY = 0.0D0
        FIZ = 0.0D0
        UII = 0.0D0
        UIIC = 0.0d0
        DO m = k+1, 5
          mm = ih2o(m,no)
          RX = PIX - PX(mm)
          RY = PIY - PY(mm)
          RZ = PIZ - PZ(mm)
          IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
          IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
          IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
          DX   = RX * BOX(1)
          DY   = RY * BOX(2)
          DZ   = RZ * BOX(3)
          RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
          if (RIJ < 0.1D0) then
              write(*,*) 'Too short distance !!!'
              write(*,*) 'RIJ, ih2o1, ih2o2' 
              write(*,'(F10.7,1x,i7,1x,i7)') RIJ, kk, mm
              write(*,'(3(F10.7,1x))') PX(kk),PY(kk),PZ(kk)
              write(*,'(3(F10.7,1x))') PX(mm),PY(mm),PZ(mm)
              write(*,'(3(F10.7,1x))') RX,RY,RZ
              write(*,'(3(F10.7,1x))') DX,DY,DZ
              RX = PX(io) - PX(kk)
              RY = PY(io) - PY(kk)
              RZ = PZ(io) - PZ(kk)
              IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
              IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
              IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
              DX   = RX * BOX(1)
              DY   = RY * BOX(2)
              DZ   = RZ * BOX(3)
              RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
              write(*,*) 'R O-kk'
              write(*,'(4(F10.7,1x))') RIJ, DX,DY,DZ
              RX = PX(io) - PX(mm)
              RY = PY(io) - PY(mm)
              RZ = PZ(io) - PZ(mm)
              IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
              IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
              IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
              DX   = RX * BOX(1)
              DY   = RY * BOX(2)
              DZ   = RZ * BOX(3)
              RIJ  = sqrt(DX*DX + DY*DY + DZ*DZ)  !angstrom
              write(*,*) 'R O-mm'
              write(*,'(4(F10.7,1x))') RIJ,DX,DY,DZ
              stop
          endif
          if (RIJ > 3.0D0) stop 'Too long distance!!!'
          RIJ3 = RIJ**3  !angstrom
          ZIZJ  = ZII(mm)*ZII(kk)
!          EIJ  = ELC**2*ZIZJ/RIJ*1.0D8     !erg cgs-esu
          EIJ   = ELCC**2*ZIZJ/RIJ*1.0D17/(4.0D0*PI*EP0)  !erg
          VALnn(9) = VALnn(9) - EIJ
          UII   = UII   + EIJ
          UIIC  = UIIC  + EIJ
          UI(mm) = UI(mm) - EIJ
          UIC(mm) = UIC(mm) - EIJ
!!          FIJ   = ELC**2*ZIZJ/RIJ3*1.0D16
          FIJ   = EPOLLL*ZIZJ/RIJ3 ! dyn
          DFX  = FIJ*DX
          DFY  = FIJ*DY
          DFZ  = FIJ*DZ
          FIX  = FIX + DFX
          FIY  = FIY + DFY
          FIZ  = FIZ + DFZ
          FX(mm) = FX(mm) + DFX  ! cgs-esu
          FY(mm) = FY(mm) + DFY  ! cgs-esu
          FZ(mm) = FZ(mm) + DFZ  ! cgs-esu
          VALnn(3) = VALnn(3) - DFX * DX
          VALnn(4) = VALnn(4) - DFY * DY
          VALnn(5) = VALnn(5) - DFZ * DZ
          VALnn(6) = VALnn(6) - DFX * DY
          VALnn(7) = VALnn(7) - DFX * DZ
          VALnn(8) = VALnn(8) - DFY * DZ
        enddo
        FX(kk) = FX(kk) - FIX
        FY(kk) = FY(kk) - FIY
        FZ(kk) = FZ(kk) - FIZ
        UI(kk) = UI(kk) - UII
        UIC(kk) = UIC(kk) - UIIC
      enddo
    enddo
!    IF (maxedip <= THRESHD) then
!    IF (sumedip <= THRESHD) then
    if (RUNOPT(34) == 'WATER-POL ') then
!   -------------------------------------------------Forces by Upol
      no = 0
      do io = ions(1,IATOMO),ions(2,IATOMO)
        no = no + 1
        k = ih2o(2,no)
        m = ih2o(3,no)
        lp1 = ih2o(4,no)
        lp2 = ih2o(5,no)
        COFWAT = EPOLLL/watpol(1,no)
!       ----------------------------------O-H1 direction
        Xmyui = COFWAT*idipX(2,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(2,no)
        Zmyui = COFWAT*idipZ(2,no)
        DX = DPX1(no)
        DY = DPY1(no)
        DZ = DPZ1(no)
        DFX = -1.0d0 * QHHk(no) * Xmyui
        DFY = -1.0d0 * QHHk(no) * Ymyui
        DFZ = -1.0d0 * QHHk(no) * Zmyui
        FX(k) = FX(k) + DFX
        FY(k) = FY(k) + DFY
        FZ(k) = FZ(k) + DFZ
        FX(lp1) = FX(lp1) - 0.5d0*DFX
        FY(lp1) = FY(lp1) - 0.5d0*DFY
        FZ(lp1) = FZ(lp1) - 0.5d0*DFZ
        FX(lp2) = FX(lp2) - 0.5d0*DFX
        FY(lp2) = FY(lp2) - 0.5d0*DFY
        FZ(lp2) = FZ(lp2) - 0.5d0*DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VALnn(3) = VALnn(3) + DFX * DX   !dyn angstrom
        VALnn(4) = VALnn(4) + DFY * DY
        VALnn(5) = VALnn(5) + DFZ * DZ
        VALnn(6) = VALnn(6) + DFX * DY
        VALnn(7) = VALnn(7) + DFX * DZ
        VALnn(8) = VALnn(8) + DFY * DZ
!       ----------------------------------O-H2 direction
        Xmyui = COFWAT*idipX(3,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(3,no)
        Zmyui = COFWAT*idipZ(3,no)
        DX = DPX2(no)
        DY = DPY2(no)
        DZ = DPZ2(no)
        DFX = -1.0d0 * QHHm(no) * Xmyui
        DFY = -1.0d0 * QHHm(no) * Ymyui
        DFZ = -1.0d0 * QHHm(no) * Zmyui
        FX(m) = FX(m) + DFX
        FY(m) = FY(m) + DFY
        FZ(m) = FZ(m) + DFZ
        FX(lp1) = FX(lp1) - 0.5d0*DFX
        FY(lp1) = FY(lp1) - 0.5d0*DFY
        FZ(lp1) = FZ(lp1) - 0.5d0*DFZ
        FX(lp2) = FX(lp2) - 0.5d0*DFX
        FY(lp2) = FY(lp2) - 0.5d0*DFY
        FZ(lp2) = FZ(lp2) - 0.5d0*DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VALnn(3) = VALnn(3) + DFX * DX   !dyn angstrom
        VALnn(4) = VALnn(4) + DFY * DY
        VALnn(5) = VALnn(5) + DFZ * DZ
        VALnn(6) = VALnn(6) + DFX * DY
        VALnn(7) = VALnn(7) + DFX * DZ
        VALnn(8) = VALnn(8) + DFY * DZ
!       --------------------------------LP2->LP1 direction
        COFWAT = EPOLLL/watpol(2,no)
        Xmyui = COFWAT*idipX(4,no)  !idipX [q angstrom]
        Ymyui = COFWAT*idipY(4,no)
        Zmyui = COFWAT*idipZ(4,no)
        DX = 2.0d0*LOP1X(no)
        DY = 2.0d0*LOP1Y(no)
        DZ = 2.0d0*LOP1Z(no)
        DFX = -1.0d0 * QLP1z(no) * Xmyui
        DFY = -1.0d0 * QLP1z(no) * Ymyui
        DFZ = -1.0d0 * QLP1z(no) * Zmyui
        FX(lp1) = FX(lp1) + DFX
        FY(lp1) = FY(lp1) + DFY
        FZ(lp1) = FZ(lp1) + DFZ
        FX(lp2) = FX(lp2) - DFX
        FY(lp2) = FY(lp2) - DFY
        FZ(lp2) = FZ(lp2) - DFZ
        VIRLSR  = VIRLSR + DFX*DX + DFY*DY + DFZ*DZ
        VALnn(3) = VALnn(3) + DFX * DX   !dyn angstrom
        VALnn(4) = VALnn(4) + DFY * DY
        VALnn(5) = VALnn(5) + DFZ * DZ
        VALnn(6) = VALnn(6) + DFX * DY
        VALnn(7) = VALnn(7) + DFX * DZ
        VALnn(8) = VALnn(8) + DFY * DZ
      enddo
    endif
!
      NNCOMPO = NCOMPO + 1   !WATER-POL
!     -----------------------Remove short range among Lone pairs and inner molecular atoms
      no = 0
      do io = IONS(1,IATOMO), IONS(2,IATOMO)
        no = no + 1
        IOO = NNCOMPO
        JO  = NNCOMPO
        EIJ = 0.0D0
        FIJ = 0.0D0
        ECDD = 0.0D0
        FCDD = 0.0D0
        IN = IOO*(IOO-1)/2 + JO
        DO K = 1, NRCUT(2)
          E2(K) = E1(K,IN)
          F2(K) = F1(K,IN)
        enddo
        mm = ih2o(4,no)
        kk = ih2o(5,no)
        RX = PX(kk) - PX(mm)
        RY = PY(kk) - PY(mm)
        RZ = PZ(kk) - PZ(mm)
        IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
        IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
        IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
        DX   = RX * BOX(1)
        DY   = RY * BOX(2)
        DZ   = RZ * BOX(3)
        RIJ2 = DX*DX + DY*DY + DZ*DZ
        RIJ  = sqrt(RIJ2)  !angstrom
!       ----------------- Charge-dipole and dipole-induced dipole
        IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
          ARIJ2 = ARIJ  * ARIJ
          ARIJ3 = ARIJ2 * ARIJ
          ARIJ4 = ARIJ3 * ARIJ
          ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
          FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                  7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
          EIJ   = EIJ + ECDD
          FIJ   = FIJ + FCDD
          VALnn(10) = VALnn(10) - ECDD
          VIRLSR = VIRLSR - FCDD*RIJ2
        END IF
!
!       --------------------------------------- Short range forces
!       ----------------------------------- Interpolation
        IP0 = INT(RIJ*100.0D0)
        IP1 = IP0 + 1
        IP2 = IP0 + 2
        R00 = dble(IP0) * 0.01D0
        R01 = dble(IP1) * 0.01D0
        R02 = dble(IP2) * 0.01D0
!                     X0  = (RIJ-R01)*(RIJ-R02)/((R00-R01)*(R00-R02))
!                     X1  = (RIJ-R00)*(RIJ-R02)/((R01-R00)*(R01-R02))
!                     X2  = (RIJ-R00)*(RIJ-R01)/((R02-R00)*(R02-R01))
        X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
        X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
        X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
        FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
        ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!
        FIJ = FIJ + FSIJ
        EIJ = EIJ + ESIJ          
        VALnn(10)  = VALnn(10)  - ESIJ
        VIRLSR = VIRLSR - FSIJ*RIJ2
        UI(mm) = UI(mm) - EIJ
        UI(kk) = UI(kk) - EIJ
        DFX = FIJ * DX
        DFY = FIJ * DY
        DFZ = FIJ * DZ
        FX(mm) = FX(mm) + DFX
        FY(mm) = FY(mm) + DFY
        FZ(mm) = FZ(mm) + DFZ
        FX(kk) = FX(kk) - DFX
        FY(kk) = FY(kk) - DFY
        FZ(kk) = FZ(kk) - DFZ
!
        VALnn(3) = VALnn(3) - DFX * DX
        VALnn(4) = VALnn(4) - DFY * DY
        VALnn(5) = VALnn(5) - DFZ * DZ
        VALnn(6) = VALnn(6) - DFX * DY
        VALnn(7) = VALnn(7) - DFX * DZ
        VALnn(8) = VALnn(8) - DFY * DZ
!
        do m = 1,3
          mm = ih2o(m,no) ! Oxygen, hydrogens
          if (m == 1) JO = IATOMO
          if (m > 1 ) JO = IATOMH
          IOO = NNCOMPO
          IN = IOO*(IOO-1)/2 + JO
          IF (IOO < JO)  IN = JO*(JO-1)/2 + IOO
          DO K = 1, NRCUT(2)
            E2(K) = E1(K,IN)
            F2(K) = F1(K,IN)
          enddo
          do k = 4,5
            FIJ = 0.0D0
            EIJ = 0.0D0
            kk = ih2o(k,no)
            PIX = PX(kk)   ! Lone pair
            PIY = PY(kk)   ! Lone pair
            PIZ = PZ(kk)   ! Lone pair
            RX = PIX - PX(mm)
            RY = PIY - PY(mm)
            RZ = PIZ - PZ(mm)
            IF (ABS(RX) > 0.5d0)  RX = RX - SIGN(1.0D0,RX)
            IF (ABS(RY) > 0.5d0)  RY = RY - SIGN(1.0D0,RY)
            IF (ABS(RZ) > 0.5d0)  RZ = RZ - SIGN(1.0D0,RZ)
            DX   = RX * BOX(1)
            DY   = RY * BOX(2)
            DZ   = RZ * BOX(3)
            RIJ2 = DX*DX + DY*DY + DZ*DZ
            RIJ  = sqrt(RIJ2)  !angstrom
!           --------- Charge-dipole and dipole-induced dipole
            IF (RIJ > RSWTCH(IN) .and. abs(cij(in)+dij(in)+d4ij(in)+d7ij(in)) > 0.0D0) then
              ARIJ2 = ARIJ  * ARIJ
              ARIJ3 = ARIJ2 * ARIJ
              ARIJ4 = ARIJ3 * ARIJ
              ECDD = (-CIJ(IN)*ARIJ2 -DIJ(IN)*ARIJ4 -D4IJ(IN) -D7IJ(IN)*ARIJ3)*ARIJ4
              FCDD = - (6.0D0*CIJ(IN) *ARIJ3 +8.0D0*DIJ(IN)*ARIJ2*ARIJ3 +4.0D0*D4IJ(IN)*ARIJ + &
                   7.0D0*D7IJ(IN)*ARIJ4)*ARIJ4 * ARIJ*1.0D8
              EIJ   = EIJ + ECDD
              FIJ   = FIJ + FCDD
              VALnn(10) = VALnn(10) - ECDD
              VIRLSR = VIRLSR - FCDD*RIJ2
            END IF
!           ----------------------------------- Interpolation
            IP0 = INT(RIJ*100.0D0)
            IP1 = IP0 + 1
            IP2 = IP0 + 2
            R00 = dble(IP0) * 0.01D0
            R01 = dble(IP1) * 0.01D0
            R02 = dble(IP2) * 0.01D0
            X0  = (RIJ-R01)*(RIJ-R02) *    5000.0D0
            X1  = (RIJ-R00)*(RIJ-R02) * (-10000.0D0)
            X2  = (RIJ-R00)*(RIJ-R01) *    5000.0D0
            FSIJ = F2(IP0)*X0 +F2(IP1)*X1 +F2(IP2)*X2
            ESIJ = E2(IP0)*X0 +E2(IP1)*X1 +E2(IP2)*X2
!
            FIJ = FIJ + FSIJ
            EIJ = EIJ + ESIJ           
            VALnn(10)  = VALnn(10)  - ESIJ
            VIRLSR = VIRLSR - FSIJ*RIJ2
            UI(mm) = UI(mm) - EIJ
            UI(kk) = UI(kk) - EIJ
            DFX = FIJ * DX
            DFY = FIJ * DY
            DFZ = FIJ * DZ
            FX(mm) = FX(mm) + DFX
            FY(mm) = FY(mm) + DFY
            FZ(mm) = FZ(mm) + DFZ
            FX(kk) = FX(kk) - DFX
            FY(kk) = FY(kk) - DFY
            FZ(kk) = FZ(kk) - DFZ
!
            VALnn(3) = VALnn(3) - DFX * DX
            VALnn(4) = VALnn(4) - DFY * DY
            VALnn(5) = VALnn(5) - DFZ * DZ
            VALnn(6) = VALnn(6) - DFX * DY
            VALnn(7) = VALnn(7) - DFX * DZ
            VALnn(8) = VALnn(8) - DFY * DZ
          enddo
        enddo
      enddo
!
! ------------------------------------------------------------------
! recalculation of UCSELF, UCSLFI
!
    UCSELF = 0.0D0
    ASP = - (ALPHA*1.0D8) * ELC**2 / SQRT(PI)
    do io = 1,ncompo
      UCSLFI(io) = 0.0d0
      DO I = ions(1,io), IONS(2,io)
        UCSLFI(io) = UCSLFI(io) + ZII(I)**2*ASP
        UIC(I) = UIC(I) + 2.0D0*ZII(I)**2*ASP
      enddo
      UCSELF = UCSELF + UCSLFI(io)
    enddo
    UCSLFI(ncompo+1) = 0.0D0
    do i = ntion+1, ntion+ndmole
      UCSLFI(ncompo+1) = UCSLFI(ncompo+1) + ZII(i)**2*ASP
      UIC(i) = uic(I) + 2.0d0*ZII(I)**2*ASP
    enddo
    UCSELF = UCSELF + UCSLFI(ncompo+1)
!
    do i = 1, ntion+ndmole
      ZIIA(i) = ZII(i)*ZII(i)*ASP*2.0D0
      ZIIC(i) = ZIIA(i) !/2.0D0
    enddo
  endif
!
!     --------------------------------------- receive results from CPU's
  if (mpsize > 1)  then

    do  icp = 1, mpsize-1

      !call MPI_Ssend (icp,                     1,         MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,ierr)
      call MPI_Recv(wal0N(1),11,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)

      do i = 3, 11
        valnn(i) = valnn(i) + wal0N(i)
      enddo
      virlsr = virlsr + wal0n(2)

      call MPI_Recv(wal0NC(1),7,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)

      valnnc(1) = valnnc(1) + wal0Nc(1)
      valnnc(2) = valnnc(2) + wal0Nc(2)
      valnnc(3) = valnnc(3) + wal0Nc(3)
      valnnc(4) = valnnc(4) + wal0Nc(4)
      valnnc(5) = valnnc(5) + wal0Nc(5)
      valnnc(6) = valnnc(6) + wal0Nc(6)
      TQCE      = TQCE      + wal0NC(7)

!      call MPI_Recv (uip(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (FXp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (FYp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (FZp(1),        ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr)
!      call MPI_Recv (UICp(1),       ntion+ndmole,MPI_DOUBLE_PRECISION,icp,icp, MPI_COMM_WORLD,status,ierr) !WATER-POL
!      do i = 1, ntion + ndmole !WATER-POL
!        ui(i) = ui(i) + uip(i)
!        fx(i) = fx(i) + fxp(i)
!        fy(i) = fy(i) + fyp(i)
!        fz(i) = fz(i) + fzp(i)
!        uic(i) = uic(i) + uicp(i)  !WATER-POL
!      enddo

    end do ! icp

    call MPI_Reduce( ui , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    ui(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( fx , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    fx(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( fy , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    fy(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( fz , uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    fz(1:ntion+ndmole) = uip(1:ntion+ndmole)
    call MPI_Reduce( uic, uip, ntion+ndmole, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr )
    uic(1:ntion+ndmole) = uip(1:ntion+ndmole)

    do icp = 1, mpsize-1
       call MPI_Recv( MRDF(1,1),ltb*npair,MPI_INTEGER4,icp,icp,MPI_COMM_WORLD,status,ierr )
       do j = 1, npair
          do i = 1, nrcut(1)
             nrdf(i,j) = nrdf(i,j) + mrdf(i,j)
          end do
       end do
    end do ! icp

    tmp_size(1)=0
    call MPI_Allreduce( tmp_size(1), array_size, 1, MPI_INTEGER, MPI_MAX, MPI_COMM_WORLD, ierr )
    allocate( iddatom_pack(array_size) ); iddatom_pack=0
    allocate( iddatom_indx(array_size) ); iddatom_indx=0
    allocate( dddatom_pack(array_size) ); dddatom_pack=0.0d0

    do icp = 1, mpsize-1

       call MPI_Recv( iddatom_indx, size(iddatom_indx), MPI_INTEGER, icp, icp, MPI_COMM_WORLD, status, ierr )
       call MPI_Recv( iddatom_pack, size(iddatom_pack), MPI_INTEGER, icp, icp, MPI_COMM_WORLD, status, ierr )
       call MPI_Recv( dddatom_pack, size(dddatom_pack), MPI_REAL8  , icp, icp, MPI_COMM_WORLD, status, ierr )

       do k = 1, count(iddatom_pack/=0)
          j = iddatom_indx(k)
          idatom101(j) = idatom101(j) + 1
          idatom( idatom101(j), j ) = iddatom_pack(k)
          ddatom( idatom101(j), j ) = dddatom_pack(k)
       end do

!      call MPI_Recv (iddatom(1,1),101*(ntion+ndmole),       MPI_INTEGER4,icp,icp, MPI_COMM_WORLD,status,ierr)  !WATER-POL
!      call MPI_Recv (dddatom(1,1),100*(ntion+ndmole),MPI_DOUBLE_PRECISION,icp,icp,MPI_COMM_WORLD,status,ierr) !WATER-POL
!       do i = 1, ntion + ndmole
!          if (iddatom(101,i) > 0) then
!             do  j = 1, iddatom(101,i)
!                idatom(101,i) = idatom(101,i) + 1
!                idatom(idatom(101,i),i) = iddatom(j,i)
!                ddatom(idatom(101,i),i) = dddatom(j,i)
!             end do
!          end if
!       enddo

    end do ! icp

    deallocate( dddatom_pack )
    deallocate( iddatom_indx )
    deallocate( iddatom_pack )
!
    if (runopt(45) == 'SPME      ') then !Smooth Particle Mesh Ewald
       do icp = 1, mpsize-1
          call MPI_Recv (tmp_size,2,MPI_INTEGER,icp,icp,MPI_COMM_WORLD,status,ierr)
          local_NVNz = tmp_size(1)
          local_NVNz_offset = tmp_size(2)
          call MPI_Recv (DARQp,NVNx*NVNy*local_NVNz,MPI_DOUBLE_COMPLEX,icp,icp,MPI_COMM_WORLD,status,ierr)
          do JZ=local_NVNz_offset+1,local_NVNz_offset+local_NVNz
          do JY=1,NVNy
          do JX=1,NVNx
             DARQ(JX,JY,JZ)=DARQ(JX,JY,JZ)+DARQp(JX,JY,JZ-local_NVNz_offset)
          enddo
          enddo
          enddo
       end do
    endif

!    write (*,8901)  1,mpsize-1
8901 format (11x,'MPI_Recv received results from ',i2,' to ',I3)

  end if !( mpsize > 1 )
!
    if (runopt(45) == 'SPME      ') then !Smooth Particle Mesh Ewald
      do IO = 1, NNCOMPO
        DO I = ions(1,IO), ions(2,IO)
          FCOFFx=FCOFF*dble(NVNx)/BOX(1)*ZII(I)
          FCOFFy=FCOFF*dble(NVNy)/BOX(2)*ZII(I)
          FCOFFz=FCOFF*dble(NVNz)/BOX(3)*ZII(I)
          do nz = 1, NDIM
            nnz=kkz(I,nz)
            do ny = 1, NDIM
              nny=kky(I,ny)
              do nx = 1, NDIM
                nnx=kkx(I,nx)
                FX(I)=FX(I)-FCOFFx*dMdux(I,nnx)*AQY(I,nny)*AQZ(I,nnz)*DARQ(nnx,nny,nnz)
                FY(I)=FY(I)-FCOFFy*dMduy(I,nny)*AQX(I,nnx)*AQZ(I,nnz)*DARQ(nnx,nny,nnz)
                FZ(I)=FZ(I)-FCOFFz*dMduz(I,nnz)*AQX(I,nnx)*AQY(I,nny)*DARQ(nnx,nny,nnz)
                UIII=2.0d0*QCOFF*ZII(I)*AQX(I,nnx)*AQY(I,nny)*AQZ(I,nnz)*DARQ(nnx,nny,nnz)
                UIC(I)=UIC(I)+UIII
                UI(I)=UI(I)+UIII
              enddo
            enddo
          enddo
!
!write(*,*)'FX',FX(I)
!write(*,*)'FY',FY(I)
!write(*,*)'FZ',FZ(I)
!read(*,*)
       end do         !I
     end do !IO
   endif
!     -------------------------------------------- Calculate 3-body term          
  if (n3bp > 0)  then                                                        
    do io = 1, ncompo                                                     
      ijk = 0                                                                  
      do  n = 1, n3bp                                                          
        if (io == i3bp(2,n))  ijk = n    ! searching center atoms
      end do                                                                   
      if (ijk == 0)  cycle               ! if io /= a center atom  then cycle
!                                                                                                                                      
      do i=ions(1,io), ions(2,io)                                          
!        mm = idatom(101,i)
        mm = idatom101(i)                ! idatom(101,i) : number of atoms near the center atom
        if (mm <= 1)  cycle                                               
!           ------------------------------------- sorting with distrance          
        do j = 1, mm-1                                                   
          do k = j+1, mm                                                 
            if (ddatom(j,i) > ddatom(k,i)) then !ddatom (j,i) : distance between i and j
              ddd         = ddatom(j,i)                                 
              ddatom(j,i) = ddatom(k,i)                                 
              ddatom(k,i) = ddd                                         
              kkk         = idatom(j,i)                                 
              idatom(j,i) = idatom(k,i)                                 
              idatom(k,i) = kkk                                         
            end if                                                          
          enddo
        enddo                                                             
!                                                                                 
420     pix = px(i)                                    
        piy = py(i)                                    
        piz = pz(i)                                    
        do jj = 1, mm-1                                                  
          jo = idatom(jj,i) / 1000000                                        
          j  = mod(idatom(jj,i),1000000)                                     
          RX = PIX - PX(J)                                               
          RY = PIY - PY(J)                                               
          RZ = PIZ - PZ(J)                                               
          IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
          IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
          IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
          D1AXYZ(1) = RX * BOX(1)                                        
          D1AXYZ(2) = RY * BOX(2)                                        
          D1AXYZ(3) = RZ * BOX(3)                                        
          D1ATOM    = sqrt(d1axyz(1)**2 + d1axyz(2)**2 + d1axyz(3)**2)                  
          do kk = jj+1, mm                                                 
            ko = idatom(kk,i) / 1000000                                        
            k  = mod(idatom(kk,i),1000000)                                     
            RX = PIX - PX(k)                                               
            RY = PIY - PY(k)                                               
            RZ = PIZ - PZ(k)                                               
            IF (ABS(RX) > 0.5D0)  RX = RX - SIGN(1.0D0,RX)                  
            IF (ABS(RY) > 0.5D0)  RY = RY - SIGN(1.0D0,RY)                  
            IF (ABS(RZ) > 0.5D0)  RZ = RZ - SIGN(1.0D0,RZ)                  
            D2AXYZ(1) = RX * BOX(1)                                        
            D2AXYZ(2) = RY * BOX(2)                                        
            D2AXYZ(3) = RZ * BOX(3)                                        
            D2ATOM    = sqrt(d2axyz(1)**2 + d2axyz(2)**2  + d2axyz(3)**2)                  
!                                                                                 
            DO N = 1, N3BP                                                 
              IF (io == I3BP(2,N) .AND. jo == i3BP(1,N) .and. &                
                  jo == ko        .and. ko == i3BP(3,N)) then                 
                if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(1,n) )  then                           
!                      -------------------------- 3-body potential B-A-B          
!                                                                                 
                  CALL  THREEP  (I,j,k, n)                           
!                                                                                 
                end if                                                     
              END IF                                                          
!                                                                                 
              IF (IO == I3BP(2,N)       .AND. JO == i3BP(1,n) .and. &           
                      i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(3,n)) then           
!                      ------------------------------------ 3-body B-A-C          
!                                                                                 
                if (d1atom <= r3lim(1,n) .and.  d2atom <= r3lim(2,n) )  then                           
                  call  threeq  (I,j,k, N)                
                end if                                                     
              end if                                                          
!                                                                                 
              IF (IO == I3BP(2,N)       .AND. JO == i3BP(3,n) .and.  &
                  i3BP(1,N) /= i3BP(3,N).and. ko == i3bp(1,n)) then           
!                      ------------------------------------ 3-body C-A-B          
!                                                                                 
                if (d1atom <= r3lim(2,n) .and. d2atom <= r3lim(1,n) )  then                           
                     dtmp = d1atom
                     d1atom = d2atom
                     d2atom = dtmp
                     dtmpxyz(:) = d1axyz(:)
                     d1axyz(:) = d2axyz(:)
                     d2axyz(:) = dtmpxyz(:)
                  call  threeq  (I,k,j, N)                
                     dtmp = d1atom
                     d1atom = d2atom
                     d2atom = dtmp
                     dtmpxyz(:) = d1axyz(:)
                     d1axyz(:) = d2axyz(:)
                     d2axyz(:) = dtmpxyz(:)
                end if                                                     
              end if                                                          
            enddo                                                           
          enddo                                                              
        enddo                                                              
      enddo                                                                 
    enddo                                                                    
  end if                                                                      
!
!     ------------------------------------------------------------------
  VAL(3)  = VAL(3)  + VALnn( 3)*1.0D-8 + VALnnC(1)
  VAL(4)  = VAL(4)  + VALnn( 4)*1.0D-8 + VALnnC(2)
  VAL(5)  = VAL(5)  + VALnn( 5)*1.0D-8 + VALnnC(3)
  VAL(6)  = VAL(6)  + VALnn( 6)*1.0D-8 + VALnnC(4)
  VAL(7)  = VAL(7)  + VALnn( 7)*1.0D-8 + VALnnC(5)
  VAL(8)  = VAL(8)  + VALnn( 8)*1.0D-8 + VALnnC(6)
  VAL(9)  = VAL(9)  + VALnn( 9)
  VAL(10) = VAL(10) + VALnn(10)
  VAL(11) = VAL(11) + VALnn(11)
  PRSTC2(1) = VALnnC(1)
  PRSTC2(2) = VALnnC(2)
  PRSTC2(3) = VALnnC(3)
  PRSTC2(4) = VALnnC(4)
  PRSTC2(5) = VALnnC(5)
  PRSTC2(6) = VALnnC(6)
!
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(23) == 'DIATOMIC  ')  CALL  EWALD_of_DiAtoms
!
!     ----------------------------------- Cancel intra-molecular Coulomb
!                                                  of diatomic molecules
  IF (RUNOPT(29) == 'POLYATOMS ')  CALL  EWALD_of_PolyAtoms
!
!     ---------------------------------------------- RDF for dummy atoms
  IN = 0
  NNCOMPO=NCOMPO; if (iwatpol == 1) NNCOMPO=NCOMPO+1 !AdvanceSoft(July2018)
  DO IO = 1, NNCOMPO
    DO JO = 1, IO
      IN = IN + 1
      IF (IION(IO) > -998 .AND. NION(JO) > -998) cycle
      IF (NION(IO) <= 0    .OR.  NION(JO) <= 0)  cycle
      IF (IO == JO         .AND. NION(IO) <= 1)  cycle
      IRDF(:) = 0
      I1 = IONS(1,IO)
      I2 = IONS(2,IO)
      J1 = IONS(1,JO)
      J2 = IONS(2,JO)
      IF (IO == JO) I1 = I1 + 1
      DO I = I1, I2
        PIX = PX(I)
        PIY = PY(I)
        PIZ = PZ(I)
        IF (IO == JO) J2 = I - 1
        DO J = J1, J2
!T                 DO 740  K = 1, 8
!T                     RX = ABS(PIX - PX(J) + TRANSX(K))
!T                     RY = ABS(PIY - PY(J) + TRANSY(K))
!T                     RZ = ABS(PIZ - PZ(J) + TRANSZ(K))
!T                     DX = H(1,1)*RX + H(1,2)*RY + H(1,3)*RZ
!T                     DY = H(2,1)*RX + H(2,2)*RY + H(2,3)*RZ
!T                     DZ = H(3,1)*RX + H(3,2)*RY + H(3,3)*RZ
          DX = ABS(PIX - PX(J))
          DY = ABS(PIY - PY(J))
          DZ = ABS(PIZ - PZ(J))
!T                     - - - - - delete these if-statements for triclinic
          IF (ABS(DX) > 0.5)  DX = 1.0 - DX
          IF (ABS(DY) > 0.5)  DY = 1.0 - DY
          IF (ABS(DZ) > 0.5)  DZ = 1.0 - DZ
          RIJ2 = (DX * BOX(1))**2 + (DY * BOX(2))**2  + (DZ * BOX(3))**2
          IF (RIJ2 <= RCUT2)  GO TO 755
!T 740             CONTINUE
          GO TO 750
  755     CONTINUE
          IP0 = INT( SQRT(RIJ2) * 100.0 )
          if (IP0 > LTB+1) write(*,*)'IP0 > LTB+1',IP0,LTB+1 
          IF (IP0 < 1)  IP0 = 1
          IRDF(IP0) = IRDF(IP0) + 1
  750   enddo
      enddo
      DO L = 1, NRCUT(1)
        NRDF(L,IN) = NRDF(L,IN) + IRDF(L)
      enddo
    enddo
  enddo
  RETURN
END SUBROUTINE EWALDP1_NEW
