!***************************************************************
!***    PROGRAM :  MXDINPUT                                  ***
!***         [ CREATE FILE07, FILE05.DAT, AND FILE10 ]       ***
!***                             VERSION  840923-2  BY KATS  ***
!***                          PC-VERSION  880115-0  BY KATS  ***
!***                    REVICED FOR JCPE  900414    BY KATS  ***
!***  Revised for low symmetry structure                     ***
!***         Prepare for large unit cell  910314    by Kats  ***
!***      Integrated version (MD and XD)  910718    by Kats  ***
!***                                      911023    by Kats  ***
!***      Multi-componets                 920324    by Kats  ***
!***      New file05.dat format           930104    by Kats  ***
!***      Diatomic molecule               971014    by Kats  ***
!***      Water film                      980319    by Kats  ***
!***      sheet                           991023    by Kats  ***
!***      Formats and LEL=10              010620    by Kats  ***
!***      Formats                         021130    by Kats  ***
!***      F90 format (partly)             030916    by Saku  ***
!***      New file07 format               110614    by Saku  ***
!**       F90 format                      190123    by Saku  ***
!***      Bug fixed for overlapping atoms 190123    by Saku  ***
!***************************************************************
!
       module PARAM
         implicit none
         integer,parameter :: LNI=32109,LEL=10,LNA=1000,LAT=LNA*8
         integer,parameter :: LSY=192,LAM=42
!          LNI : Maximum number of atoms in a MD basic cell
!          LNA : Maximum number of atoms in a crystal asymmetric unit
!          LAT : Maximum number of atoms in a cristal unit cell
!          LSY : Maximum number of symmetry operations
       end module
       module ATOMS
         use param, only : LAT,LEL,LNI
         implicit none
           integer MA,NA
           integer ID(LAT),IDD(LAT),ISYM(LAT),NION(LEL)
           double precision    P(3,LNI)
       end module
       module MDDATA
         use param, only : LEL,LNA,LNI
         implicit none
           integer NTION,NX,NY,NZ
           integer IONS(2,LEL),NID(LNA),NSYM(LNI)
           double precision    Q(3,LNI)
           real    BOX(6)
       end module
       module SYMMT
         use param, only : LSY
         implicit none
           integer NS,NL
           real    RS(3,3,LSY),TS(3,LSY),TL(3,4)
       end module
       module TRAJEC
         use param, only : LAT,LNA
         implicit none
           integer NPT,NPTP
           integer JON(LAT)
           DOUBLE PRECISION    P0C(3,LAT),XYZ(3,LNA),XYZH(3,LNA)
       end module
       module MUDANA
         use param, only : LNI
         implicit none 
           integer IXD(LNI),JXD(LNI)
       end module
       module RANDM3
         implicit none
           integer IR,JR,KR,LR,MR,NR
           real::    RD(3)
       end module
       module ANAME
         use param, only : LNA,LAT,LEL
         implicit none
           character(LEN=4)::ATOM(LNA),ATM(LAT),TITLE(15),ADX(LEL)
           character(LEN=4)::AOX(LEL)
           character(LEN=33):: FLNAME(19)
       end module
       module ATOMSC
         use param, only : LAM
         implicit none
           character(LEN=4):: ION(2,LAM)
       end module
       module ATOMSD
         use param, only : LAM
         implicit none
           real WGT(LAM),CHG(LAM),AOI(LAM),BOI(LAM),COI(LAM)
           real RAD(LAM)
       end module
!
      PROGRAM  MXDINP
      use PARAM
      use ATOMS
      use MDDATA
      use SYMMT
      use TRAJEC
      use MUDANA
      use RANDM3
      use ANAME
      use ATOMSC
      use ATOMSD
!
      implicit none
!
      INTEGER   IONI(LEL)
      integer   N,I,J,NCOMPO,IO
      real      TEMP,DELTAT,DTIME,DENSTY,PRESS,ANREC5
      real      ACHG,AWGT,AI,BI,CI
      CHARACTER(LEN=4)::   HEX, ANS,  MXD
      CHARACTER(LEN=12)::  XNAME(300),YNAME, STRUCT
!
                     FLNAME( 1) = 'MXDINPUT.F                       '
                     FLNAME( 2) = '2025-11-19-00                    '
!
!                     flname( 3) = 'WinPC                            '
                     FLNAME( 3) = 'UNIX                             '
!
                     FLNAME( 5) = 'file05.dat                       '
                     FLNAME( 6) = 'file06.dat                       '
                     FLNAME( 7) = 'file07.dat                       '
                     FLNAME( 8) = 'file08.dat                       '
                     FLNAME( 9) = 'file09p.dat                      '
                     FLNAME(11) = 'file09v.dat                      '
                     FLNAME(10) = 'file10.dat                       '
                     FLNAME(12) = '                                 '
!
!                     FLNAME(18) = 'c:\mxd\xtaldata.dat              '
!
!
!!!!!   Please modify the path indicating the location of the file  xtaldata.dat to match your environment   !!!!!!!!!!
                     FLNAME(19) = '/Users/hiroshi/xtaldata.dat      '
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!
      CALL  ATMDAT
      CALL  RNDMIZ
!
      IF (FLNAME(3)=='UNIX                    ')  THEN
               FLNAME(18) = FLNAME(19)
      END IF
!
!     OPEN  ( 4, FILE='CON', STATUS='NEW')
      OPEN  (16, FILE=FLNAME(6),     STATUS='UNKNOWN',&
                 ACCESS='SEQUENTIAL',FORM='FORMATTED')
!
   11 OPEN  ( 8,FILE=FLNAME(18), STATUS='OLD',&
                ACCESS='SEQUENTIAL',FORM='FORMATTED')
!
!     ------------------------------------------- Search for a structure
      MXD = 'XD'
  111 WRITE (6,2022)
 2022 FORMAT('Structure type (A12)?  (see XTALDATA.DAT, or ',&
                                            'type "LIST")' /&
             '............',12X,'"CHAOS" for liquid or glass')
!
                               READ  (5,'(A12)')  STRUCT
      IF (STRUCT=='      ')  STOP 888
      IF (STRUCT=='CANCEL'.OR.STRUCT=='cancel')  STOP 999
!
!     -------------------------------------------------- LIQUID OR GLASS
      IF (STRUCT=='CHAOS '.OR.STRUCT=='chaos ' .OR.&
          STRUCT=='LIQUID'.OR.STRUCT=='liquid' .OR.&
          STRUCT=='GLASS '.OR.STRUCT=='glass ') THEN
                             MXD = 'MD'
                             CALL  LIQUID
                             GO TO 777
      END IF
!
!     ----------------------------------------------- List of structures
      IF (STRUCT=='LIST  '.OR.STRUCT=='list ')  THEN
              XNAME(1) = 'CHAOS       '
              NX = 1
  400         READ  (8,'(A12)',END=490)  YNAME
              IF (YNAME/='::::::::::::')  THEN
                     IF (YNAME/='............')  GO TO 400
                     NX = NX + 1
                     READ  (8,'(A12)')  XNAME(NX)
                     GO TO 400
              END IF
  490         WRITE (6,'(1X,6A13)')  (XNAME(N),N=1,NX)
              REWIND 8
              GO TO 111
      END IF
!
!     ------------------------------------------------- Search structure
      REWIND 8
  222 READ  (8,'(A12)',END=999)  YNAME
      IF (YNAME=='::::::::::::')  GO TO 111
      IF (YNAME/=STRUCT)  GO TO 222
!
!     ------------------------------------------------ Xtal initial data
!                                       Input from database, and display
      READ  (8,'(18A4)')  TITLE
      WRITE (6,'(1X,18A4)')  TITLE
      READ  (8,'(6F10.5)')  (BOX(I),I=1,6)
      WRITE (6,2010)  BOX
 2010 FORMAT (5X,' A=',F7.4,' B=',F7.4,' C=',F7.4,' (',3F9.4,')')
      IF (ABS(BOX(4))>1.01) BOX(4) = COS(BOX(4)*3.1415926/180.)
      IF (ABS(BOX(5))>1.01) BOX(5) = COS(BOX(5)*3.1415926/180.)
      IF (ABS(BOX(6))>1.01) BOX(6) = COS(BOX(6)*3.1415926/180.)
!
      CALL  SPACEG  (MA)
      CALL  INATOM  (HEX)
!
         READ  (8,'(10(A4,1X))')  AOX
         CLOSE (8)
!
         WRITE (6,2031) AOX
 2031    FORMAT (10(A4,1X),':  Atoms in the structure'/&
                 'O    SI   AL   MG   CA   NA   CS   X    Y    Z    :',&
                 '(Exampl)  Type in please')
!     ----------------------------- Key in atom names in proper sequence
      READ  (5,'(10(A4,1X))')  ADX
!
   41 WRITE (6,4402) BOX
 4402 FORMAT ('A=',F7.3,'  B=',F7.3,'  C=',F7.3,'(',3F7.3,')'/&
              'How many cells?' /    '    A    B    C')
!        ------------------------------- Key in numbers of staking cells
         READ  (5,'(3I5, A4)')  NX,NY,NZ
         WRITE (6,*)  'A=',BOX(1)*NX, 'B=',BOX(2)*NY, 'C=',BOX(3)*NZ,&
                      '  Ok?'
         READ (5,'(A1)')  ANS
         IF (ANS=='n'.OR.ANS=='N')  GO TO 41
!
      CALL  GENPOS
      CALL  STRCHK
!
!     -------------------------------------------------------- MD and XD
  777 WRITE  (6,'("I",8("-"),"I   Temperature(K) ?")')
      READ   (5,'(F10.4)')  TEMP
      IF (TEMP<0.001)  TEMP = 300.0
      DO I = 1, NTION
          DO J = 1, 3
              CALL  RANDOM
              Q(J,I)= (RD(J)-0.5)*0.05 + 5.0
          ENDDO   
      ENDDO
!
!     ---------------------------------------------- Write on file07.dat
      DELTAT = -1.0
      DTIME  = 2.0E-15
      NCOMPO = 0
      DO IO = 1, LEL
         ioni(io) = 0
         IF (NION(IO)>0)  THEN
                NCOMPO = IO
                DO J = 1, LAM
                    IF (ADX(IO)==ION(1,J)) IONI(IO) = J
                    IF (ADX(IO)==ION(2,J)) IONI(IO) = J
                ENDDO
                IF (IONI(IO)<=0)  IONI(IO) = LAM
         END IF
      ENDDO   
!
      DENSTY = 0.0
      DO I = 1, LEL
       if (nion(i)>0) then
               DENSTY = DENSTY + NION(I) * WGT(IONI(I))
       end if
      ENDDO   
      DENSTY = DENSTY / (BOX(1)*BOX(2)*BOX(3)*(1.0E-24*6.02214E23))
      PRESS  = 0.0001
!
      OPEN  ( 7, FILE=FLNAME(7), STATUS='UNKNOWN',&
                 ACCESS='SEQUENTIAL',FORM='FORMATTED')
        REWIND 7
        WRITE (7,'(15A4,2I5)')  TITLE, 0, 0
        WRITE (7,'(I7,I3,9I10)') NTION, NCOMPO, 0,0,0,0,0,0,0,0,0
        WRITE (7,'(10(2X,A4))')  (ADX(I),   I=1,LEL)
        WRITE (7,'(10I6)')  (NION(I),  I=1,LEL)
        WRITE (7,'(10I6)')  (IONS(1,I),I=1,LEL)
        WRITE (7,'(10I6)')  (IONS(2,I),I=1,LEL)
        WRITE (7,'(F10.2,F10.4,F10.2,3F10.5)')  TEMP,DELTAT,TEMP, PRESS,PRESS,PRESS
        WRITE (7,'(E10.2,10X,6F10.6)')  DTIME,  (BOX(I),I=1,6)
        WRITE (7,'(F10.6,10X,6F10.6)')  DENSTY, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
        do io=1, ncompo
           do i=ions(1,io), ions(2,io)
              WRITE (7,'(3F10.8,1X,3F9.7,1X,3F10.6,1x,i2)')&
                       (P(J,I),J=1,3),(Q(J,I),J=1,3),(P(J,I),J=1,3), io
           enddo   
        enddo   
        ENDFILE  (7)
        REWIND   (7)
      CLOSE    (7)
!
      IF (MXD=='XD  ')  THEN
!            --------------------------------------- Write on file10.dat
        OPEN  (10, FILE=FLNAME(10), STATUS='UNKNOWN',&
                        ACCESS='SEQUENTIAL',FORM='FORMATTED')
             REWIND 10
             WRITE (10,'(3F10.7,3F10.8)')  (BOX(I),I=1,6)
             WRITE (10,'(6I5,5X,A4,I6)') NX,NY,NZ,NPT,NPTP,NS,HEX,MA
             WRITE (10,'(18A4)')  (ATM(J),J=1,MA)
             WRITE (10,'(18I4)')  (NID(J),J=1,MA)
             WRITE (10,'(I5,3F10.7,I5)')  (JON(N),(P0C(J,N),J=1,3),IXD(JON(N)),N=1,NPTP)
             WRITE (10,'(9F6.1)')  (((RS(J,I,N),J=1,3),I=1,3),N=1,NS)
             WRITE (10,'(12I6)')  (NSYM(N),N=1,NTION)
             ENDFILE (10)
             REWIND   10
        CLOSE   (10)
      END IF
!
!     ---------------------------------------------------- Confirmations
      WRITE  (6,'(2X,"*** NO. of ions :  ",5(A2,":",I5,3X))')  (ADX(I), NION(I), I=1,5)
      WRITE  (6,'(2X,"                   ",5(A2,":",I5,3X))')  (NION(I), I=6,LEL)
      IF (STRUCT/='CHAOS '.AND.STRUCT/='chaos ') THEN
            WRITE  (6,'(2X,"*** CELL IS ",3I4,6X,"NPT(NPTP) :",I4,"(",I3,")")')  NX,NY,NZ, NPT,NPTP
      END IF
      WRITE  (6,'(2X,"*** A=", F8.4," B=", F8.4," C=", F8.4," CA=",F7.4," CB=",F7.4," CC=",F7.4)')  (BOX(I),I=1,6)
      WRITE  (6,'(2X,"*** Density is ",F8.4," g/cm3")')  DENSTY
      WRITE (6,'(" Do you want a new file05.dat (y/n/r) ?")')
!
!     ------------------------------------------------------- File05.dat
      READ (5,'(A1)')  ANS
      IF (ANS=='R'.OR. ANS=='r')  GO TO 11
      IF (ANS/='Y'.AND.ANS/='y')  GO TO 909
!
                                  ANREC5 = 50.
      IF (MXD=='XD')              ANREC5 =  5.
                                  DTIME  = 2.0
      DO IO = 1, LEL
          IF (ADX(IO)=='H   ')  DTIME = 0.4
      ENDDO   
!     ---------------------------------------------- Write on file05.dat
      OPEN  (15, FILE=FLNAME(5),STATUS='UNKNOWN',&
                 ACCESS='SEQUENTIAL',FORM='FORMATTED')
      WRITE (15,'(A2,".......I....:....I....:....I....:....I....:....I....:....I....:....I:")')  MXD
      write (15,'("START     ",15A4,":")') (TITLE(I),I=1,15)
      write (15,'("ECONOMY      00500.     0500.       50. ",F8.0,2X,"      5.  ",10X,":")') ANREC5
      write (15,'("NOACCUM   ",F7.2,3X,"     1.0       0.0  ",30X,":")') DTIME
      write (15,'("T SCALING ",F9.2,1X,"    -0.1        1.  ",30X,":")') TEMP
      write (15,'("P NO-CNTL    0.0001    0.0001    0.0001 " ,30X,":")')
      write (15,'("V CONST.  ",60X,":")')
      write (15,'("BUSING       3.        0.0                        ",20X,":")')
      DO IO = 1, LEL
        IF (NION(IO)>0)  THEN
          ACHG = 0.0
          AWGT = 0.0
          DO J = 1, LAM
              IF (ADX(IO)==ION(1,J).OR.ADX(IO)==ION(2,J)    ) THEN
                     ACHG = CHG(J)
                     AWGT = WGT(J)
                     AI   = AOI(J)
                     BI   = BOI(J)
                     CI   = COI(J)
              END IF
          ENDDO    
          WRITE (15,'(I1,1X,A2,F6.0, 2X,F6.3,2X, 2X,F6.2,2X, F8.3,2X,F8.3,2X, F8.3,2X, "          :")')&
                      IO,ADX(IO),REAL(NION(IO)),ACHG,AWGT,AI, BI, CI
        END IF
      ENDDO    
      WRITE (15,'(70X,":" / 70X,":")')
      WRITE (15,'(A2,".......I....:....I....:....I....:....I....:....I....:....I....:....I:")')  MXD
      WRITE (15,'("STOP      ",60X,":")')
      ENDFILE (15)
      REWIND  (15)
      CLOSE   (15)
!
  909 ENDFILE (16)
      CLOSE   (16)
  999 STOP
      END
!
!
!                                                           ============
!============================================================= Atom data
      SUBROUTINE  ATMDAT
      use PARAM
      use ATOMSC
      use ATOMSD
      implicit none
!
      CHARACTER(LEN=4)::AION(LAM), BION(LAM)
      integer i
      REAL     AWGT(LAM), ACHG(LAM), AAOI(LAM), ABOI(LAM)
      REAL        ACOI(LAM), ARAD(LAM)
!
      DATA AION / 'H   ',&
         'LI  ',  'BE  ',  'B   ',  'C   ',  'N   ',  'O   ',  'F   ',&
         'NA  ',  'MG  ',  'AL  ',  'SI  ',  'P   ',  'S   ',  'CL  ',&
         'K   ',  'CA  ',  'SC  ',  'TI  ',&
                  'GA  ',  'GE  ',  'AS  ',  'SE  ',  'BR  ',&
         'RB  ',  'SR  ',  'IN  ',  'SN  ',  'SB  ',  'TE  ',  'I   ',&
         'CS  ',  'BA  ',           'PB  ',&
         'Y   ',  'ZR  ',&
         'HE  ',  'NE  ',  'AR  ',  'KR  ',  'XE  ', '    '  /
!
      DATA BION / 'H   ',&
         'Li  ',  'Be  ',  'B   ',  'C   ',  'N   ',  'O   ',  'F   ',&
         'Na  ',  'Mg  ',  'Al  ',  'Si  ',  'P   ',  'S   ',  'Cl  ',&
         'K   ',  'Ca  ',  'Sc  ',  'Ti  ',  'Ga  ',  'Ge  ',  'As  ',&
                  'Se  ',  'Br  ',&
         'Rb  ',  'Sr  ',  'In  ',  'Sn  ',  'Sb  ',  'Te  ',  'I   ',&
         'Cs  ',  'Ba  ',           'Pb  ',&
         'Y   ',  'Zr  ',& 
         'He  ',  'Ne  ',  'Ar  ',  'Kr  ',  'Xe  ', '    '  /
!
      DATA AWGT /   1.008,&
           6.941,   9.012,  10.81,   12.01,   14.01,   16.00,   19.00,&
          22.99,   24.31,   26.98,   28.09,   30.97,   32.07,   35.45,&
          39.10,   40.08,   44.96,   47.88,&   
                   69.72,   72.61,   74.92,   78.96,   79.90,&
          85.47,   87.62,  114.8,   118.7,   121.8,   127.6,   126.9,& 
         132.9,   137.3,            207.2,& 
          88.91,   91.22,&  
           4.002,  20.18,   39.95,   83.80,  131.29,    0.0   /
!
      DATA ACHG /   1.00,&
           1.00,    2.00,    3.00,    4.00,   -3.00,   -2.00,   -1.00,&
           1.00,    2.00,    3.00,    4.00,    5.00,    6.00,   -1.00,&
           1.00,    2.00,    3.00,    4.00,&    
                    3.00,    4.00,    5.00,    6.00,   -1.00,&
           1.00,    2.00,    3.00,    4.00,    5.00,    6.00,   -1.00,&
           1.00,    2.00,             4.00,&
           3.00,    4.00,&  
           0.00,    0.00,    0.00,    0.00,    0.00,    0.00  /
!
      DATA AAOI /  0.0,&
          0.0,     0.0,     0.720,   0.0,     1.713,   1.629,   1.565,&
          1.260,   1.161,   1.064,   1.012,   0.0,     0.0,     1.950,&
          1.595,   1.440,   0.0,     1.235, &
                   0.0,     0.0,     0.0,     0.0,     0.0,&
          0.0,     1.632,   0.0,     0.0,     0.0,     0.0,     0.0, & 
          0.0,     1.820,            0.0,&
          0.0,     0.0,  & 
          1.156,   1.397,   1.860,   2.025,   2.246,   0.0  / 
!
      DATA ABOI /  0.0,&
          0.0,     0.0,     0.080,   0.0,     0.080,   0.085,   0.085,&
          0.080,   0.080,   0.080,   0.080,   0.0,     0.0,     0.090,&
          0.080,   0.080,   0.0,     0.080,  & 
                   0.0,     0.0,     0.0,     0.0,     0.0, & 
          0.0,     0.080,   0.0,     0.0,     0.0,     0.0,     0.0, & 
          0.0,     0.080,            0.0,&
          0.0,     0.0,  & 
          0.115,   0.120,   0.145,   0.165,   0.180,   0.0   /
!
      DATA ACOI /   0.0,&
           0.0,     0.0,     0.0,     0.0,     0.0,    20.00,   20.0,&
          10.0,     2.0,     0.0,     0.0,     0.0,     0.0,    30.0,&
          15.0,    10.0,     0.0,     0.0,    & 
                    0.0,     0.0,     0.0,     0.0,    40.0,&
          20.0,    15.0,     0.0,     0.0,     0.0,     0.0,    50.0,&
          25.0,    20.0,              0.0,&
           0.0,     0.0,  & 
           4.76,   11.04,   38.54,   55.35,   85.57,    0.0   /
!
      DATA ARAD /  0.10,&
          0.60,    0.20,    0.10,    0.10,    1.40,    1.35,    1.30,&
          1.00,    0.65,    0.25,    0.15,    0.15,    0.10,    1.40,&
          1.05,    0.80,    0.50,    0.50,   & 
                   0.40,    0.20,    0.20,    0.15,    1.50,&
          1.20,    0.95,    0.60,    0.60,    0.70,    0.75,    1.70,&
          1.40,    1.10,             1.30,&
          0.65,    0.60,&
          1.20,    1.30,    1.80,    1.90,    2.00,    0.0   /
!
      DO I = 1, LAM
         ION(1,I) = AION(I)
         ION(2,I) = BION(I)
         WGT(I)   = AWGT(I)
         CHG(I)   = ACHG(I)
         AOI(I)   = AAOI(I)
         BOI(I)   = ABOI(I)
         COI(I)   = ACOI(I)
         RAD(I)   = ARAD(I)
      ENDDO  
      RETURN
      END
!
!
!                                                              =========
!================================================================ RANDOM
      SUBROUTINE  RANDOM
      use RANDM3
      implicit none
!
      INTEGER II,JJ,KK,  LL,MM,NN
!
          II = ((JR/3) * (KR/3) + LR) / 2
          JJ = ((IR/3) * (KR/3) + MR) / 2
          KK = ((IR/3) * (JR/3) + NR) / 2
              IR = MOD(II,100000)
              JR = MOD(JJ,100000)
              KR = MOD(KK,100000)
                  RD(1) = FLOAT(IR) * 0.00001
                  RD(2) = FLOAT(JR) * 0.00001
                  RD(3) = FLOAT(KR) * 0.00001
              LL = ((MR/3) * (NR/3) + IR) / 2
              MM = ((LR/3) * (NR/3) + JR) / 2
              NN = ((LR/3) * (MR/3) + KR) / 2
          LR = MOD(LL,100000)
          MR = MOD(MM,100000)
          NR = MOD(NN,100000)
      RETURN
!
      ENTRY  RNDMIZ
         IR = 32723
            JR = 23557
               KR = 47979
               LR = 54893
            MR = 16617
         NR = 79423
      RETURN
      END
!
!
!                                                               ========
!================================================================= CHAOS
      SUBROUTINE  LIQUID
      use PARAM
      use ATOMS
      use MDDATA
      use ANAME
      use ATOMSC
      use ATOMSD
      use RANDM3
      implicit none
!
      INTEGER   IONI(LEL)
      REAL      rpx(2,3)
      integer   KNK,I,J,JO,IO,IMOL,istr,ipx,ier
      real      DENSTY,DT
      CHARACTER(LEN=1)::ANSWER
!
      WRITE (6,'("KEY IN AN INTEGER FOR RANDOMIZE")')
      READ  (5, *)    KNK
      DO I = 1, KNK
         CALL RANDOM
      ENDDO    
!
      WRITE (6,'(   "I",58("-"),"I   TITLE ?")')
      READ  (5, '(15A4)')  TITLE
!
      WRITE (6,'(10("ION",I1," ")," : ATOM SPECIES ?")') (mod(I,10),I=1,LEL)
      READ  (5,'(10(A4,1X))')  ADX
      DO I = 1, LEL
         NION(I) = 0
         IONI(I) = 0
         DO J = 1, LAM
             IF (ADX(I)==ION(1,J))  IONI(I) = J
             IF (ADX(I)==ION(2,J))  IONI(I) = J
         ENDDO    
         IF (IONI(I)<=0)  IONI(I) = LAM
      ENDDO    
!
      WRITE (6,'(10("....",I1),"  NO. OF IONS ?")')  (mod(I,10),I=1,LEL)
      READ  (5, '(10I5)')  NION
      JO = 0
      DO IO = 1, LEL
         IONS(1,IO) = JO + 1
         IONS(2,IO) = IONS(1,IO) + NION(IO) -1
         JO = IONS(2,IO)
      ENDDO    
!
   77 WRITE (6,'(3("I",9("-")),"I  BOX EDGE LENGTHS (1-3) ?")')
      READ  (5,'(3F10.4)')(BOX(I),I=1,3)
      IF (BOX(2)<=0.1)  BOX(2) = BOX(1)
      IF (BOX(3)<=0.1)  BOX(3) = BOX(2)
                          BOX(4) = 0.0
                          BOX(5) = 0.0
                          BOX(6) = 0.0
      DENSTY = 0.0
      DO I = 1, LEL
         DENSTY = DENSTY + NION(I) * WGT(IONI(I))
      ENDDO    
      DENSTY = DENSTY / (BOX(1)*BOX(2)*BOX(3)*(1.0E-24*6.02214E23))
      WRITE (6,'("   -----> The density is ", F7.4, "g/cm3.  OK ?  (Y/N)")')  DENSTY
      READ (5,'(A1)')  ANSWER
      IF (ANSWER/='Y' .AND. ANSWER/='y')  GO TO 77
!
      DT = 1.0E-15
!
      write (6,'("Molecule:  1:monoatomic,  2:diatomic, or 3:H2O/CO2  (1/2/3) ?")')  
      read (5,'(i1)') imol  
!
      do i=1, 3
         rpx(1,i)=0.0
         rpx(2,i)=1.0
      ENDDO    
      write (6,'("Structure:  1:bulk,   2:sheet ?")')
      read (5,'(i1)')  istr
      if (istr==2)  then
            write (6,'(1x,"Sheet perpendicular to 1:x, 2:y, 3:z  ?")')
            read (5,'(i1)')  ipx
            rpx(1,ipx) = 0.20
            rpx(2,ipx) = 0.80
            write (*,*)  'Range of sheet ',rpx(1,ipx),rpx(2,ipx),' OK (y/n)?'
            READ (5,'(a1)')  ANSWER
            IF (ANSWER=='N' .OR. ANSWER=='n')  then
                  write (6,*)  'Input range (2F, 0-1)'
                  read (5,*)  rpx(1,ipx), rpx(2,ipx)
            end if
      end if
!
      if (imol<=1)  CALL  CHAOS   (IONI, IER, rpx)
      if (imol==2)  call  chaos2  (ioni, ier, rpx)
      if (imol==3)  call  chaos3  (ier, rpx)
      IF (IER/=0) then
            write (6,*) 'The volume is too small. Change cell lengths'
            GO TO 77
      end if
!
      DO I = 1, NTION 
         CALL  RANDOM      
         DO J = 1, 3  
            P(J,I) = Q(J,I) / BOX(J)
         ENDDO    
      ENDDO    
!
      RETURN
      END
!
!
!                                                               ========
!================================================================= CHAOS
      SUBROUTINE  CHAOS  (IONI, IER, rpx)
      use PARAM
      use ATOMS
      use MDDATA
      use ATOMSC
      use ATOMSD
      use RANDM3
      implicit none
!
      INTEGER    IONI(LEL)
      integer    ier
      integer    i,IO,NTRIAL,JO,J
      real       rpx(2,3)
      real       ALMIN,RCUT,RAS,ZAS,RLIM,RLIM2
      DOUBLE PRECISION       DX,DY,DZ
      DOUBLE PRECISION       PX, PY, PZ
!
      IER = 1
      NTION = 0
      DO  I = 1, LEL
         NTION = NTION + NION(I)
      ENDDO    
      ALMIN = AMIN1(BOX(1),BOX(2),BOX(3))
      RCUT  = ALMIN / 2.0
      DO 90  IO = 1, LEL
         DO 80  I = IONS(1,IO), IONS(2,IO)
            NTRIAL = 0
   20       NTRIAL = NTRIAL + 1
            IF (NTRIAL>999)  RETURN
            CALL  RANDOM
           if (RD(1)<rpx(1,1).or.rd(1)>rpx(2,1))  go to 20
           if (RD(2)<rpx(1,2).or.rd(2)>rpx(2,2))  go to 20
           if (RD(3)<rpx(1,3).or.rd(3)>rpx(2,3))  go to 20
            PX = RD(1) * BOX(1)
            PY = RD(2) * BOX(2)
            PZ = RD(3) * BOX(3)
            IF (I<=1)  GO TO 70
                RAS = RAD(IONI(IO))
                ZAS = CHG(IONI(IO))
                DO JO = 1, IO
                   RLIM = (RAS + RAD(IONI(JO))) * 0.7
                   IF (ZAS*CHG(IONI(JO))>0.0)  RLIM = 1.9
                   RLIM2 = RLIM * RLIM
                   DO J = IONS(1,JO), IONS(2,JO)
                      IF (J>=I)  GO TO 70
                         DX = ABS(PX - Q(1,J))
                              IF (DX>RCUT)  DX = BOX(1) - DX
                         DY = ABS(PY - Q(2,J))
                              IF (DY>RCUT)  DY = BOX(2) - DY
                         DZ = ABS(PZ - Q(3,J))
                              IF (DZ>RCUT)  DZ = BOX(3) - DZ
                         IF (DX*DX+DY*DY+DZ*DZ<RLIM2)  GO TO 20
                   ENDDO    
                ENDDO    
!
   70       Q(1,I) = PX
            Q(2,I) = PY
            Q(3,I) = PZ
!           WRITE (4,*)  I,PX,PY,PZ
            IF (MOD(I,100)==0)  WRITE (6,'(1X,I5,$)') I
   80    ENDDO    
   90 ENDDO    
!
      WRITE (6,'("")')
      IER = 0
      RETURN
      END
!
!
!                                                              =========
!================================================================ CHAOS2
      SUBROUTINE  CHAOS2  (IONI, IER, rpx)
!                                                     Diatomic molecules
      use PARAM
      use ATOMS
      use MDDATA
      use ATOMSC
      use ATOMSD
      use RANDM3
      implicit none
!
      INTEGER    IONI(LEL)
      integer    IER
      integer    I,IO,NTRIAL,JO,J
      real    rpx(2,3)
      real    Dintra,ALMIN,RCUT,PX1,PY1,PZ1,SRD
      real    PX2,PY2,PZ2,RAS,ZAS,RLIM,RLIM2
      DOUBLE PRECISION    DX,DY,DZ
!
      write (6,'(1x,"Input intramolecular atomic distance (O:1.191, N:1.095)")')  
      read (5,'(f10.5)') Dintra
!
      IER = 1
      NTION = 0
      DO I = 1, LEL
         NTION = NTION + NION(I)
      ENDDO    
      ALMIN = AMIN1(BOX(1),BOX(2),BOX(3))
      RCUT  = ALMIN / 2.0
      DO 90  IO = 1, LEL
         if (mod(nion(io),2)==1) then
              write (*,*)  'Odd number!',io,nion(io)
              stop
         end if
         DO 80  I = IONS(1,IO), IONS(2,IO), 2
            NTRIAL = 0
   20       NTRIAL = NTRIAL + 1
            IF (NTRIAL>999)  RETURN
            CALL  RANDOM
           if (RD(1)<rpx(1,1).or.rd(1)>rpx(2,1))  go to 20
           if (RD(2)<rpx(1,2).or.rd(2)>rpx(2,2))  go to 20
           if (RD(3)<rpx(1,3).or.rd(3)>rpx(2,3))  go to 20
            PX1 = RD(1) * BOX(1)        !  First atom
            PY1 = RD(2) * BOX(2)
            PZ1 = RD(3) * BOX(3)
            CALL  RANDOM                         !  second atom
            srd = sqrt((rd(1)*box(1))**2 + (rd(2)*box(2))**2 + (rd(3)*box(3))**2)
            PX2 = px1 + RD(1) * box(1) * dintra / srd 
            PY2 = py1 + RD(2) * box(2) * dintra / srd
            PZ2 = pz1 + RD(3) * box(3) * dintra / srd
!
            IF (I<=1)  GO TO 70
                RAS = RAD(IONI(IO))
                ZAS = CHG(IONI(IO))
                DO JO = 1, IO
                   RLIM = (RAS + RAD(IONI(JO))) * 0.7
                   IF (ZAS*CHG(IONI(JO))>0.0)  RLIM = 1.9
                   RLIM2 = RLIM * RLIM
                   DO J = IONS(1,JO), IONS(2,JO)
                      IF (J>=I)  GO TO 25
                         DX = ABS(PX1 - Q(1,J))
                              IF (DX>RCUT)  DX = BOX(1) - DX
                         DY = ABS(PY1 - Q(2,J))
                              IF (DY>RCUT)  DY = BOX(2) - DY
                         DZ = ABS(PZ1 - Q(3,J))
                              IF (DZ>RCUT)  DZ = BOX(3) - DZ
                         IF (DX*DX+DY*DY+DZ*DZ<RLIM2)  GO TO 20
                   ENDDO    
                ENDDO    
!
   25           RAS = RAD(IONI(IO))
                ZAS = CHG(IONI(IO))
                DO JO = 1, IO
                   RLIM = (RAS + RAD(IONI(JO))) * 0.7
                   IF (ZAS*CHG(IONI(JO))>0.0)  RLIM = 1.9
                   RLIM2 = RLIM * RLIM
                   DO J = IONS(1,JO), IONS(2,JO)
                      IF (J>=I)  GO TO 70
                         DX = ABS(PX2 - Q(1,J))
                              IF (DX>RCUT)  DX = BOX(1) - DX
                         DY = ABS(PY2 - Q(2,J))
                              IF (DY>RCUT)  DY = BOX(2) - DY
                         DZ = ABS(PZ2 - Q(3,J))
                              IF (DZ>RCUT)  DZ = BOX(3) - DZ
                         IF (DX*DX+DY*DY+DZ*DZ<RLIM2)  GO TO 20
                   ENDDO    
                ENDDO    
!
   70       Q(1,I) = PX1
            Q(2,I) = PY1
            Q(3,I) = PZ1
            Q(1,I+1) = PX2
            Q(2,I+1) = PY2
            Q(3,I+1) = PZ2
!           WRITE (4,*)  I,PX,PY,PZ
            IF (MOD(I,100)==0)  WRITE (6,'(1X,I5,$)') I
   80    ENDDO    
   90 ENDDO    
!
      WRITE (6,'("")')
      IER = 0
      RETURN
      END
!
!
!                                                              =========
!================================================================ CHAOS3
      SUBROUTINE  CHAOS3  (IER, rpx)
!                                                             H2O or CO2
      use PARAM
      use ATOMS
      use MDDATA
      use ATOMSC
      use ATOMSD
      use ANAME
      use RANDM3
      implicit none
!
      integer    IER
      integer    io1,io2,I,IO,NIO2,NTRIAL,J
      DOUBLE PRECISION       rlim2,dintra
      real       rpx(2,3)
      DOUBLE PRECISION  ALMIN,RCUT,PX1,PY1,PZ1,DX,DY,DZ
      DOUBLE PRECISION  SRD,PX2,PY2,PZ2,PX3,PY3,PZ3,VV
!
!     write (6,2001)  
!2001 format (1x,'Input intramolecular atomic distance ',
!    *           '(O-H:0.95, C-O:1.13 A)'/)
!     read (5,'(f10.5)') Dintra
!
      if (ADX(1)=='O   ')  then
                 io1 = 1
                 io2 = 2
                 rlim2 = 2.8**2
                 dintra = 0.95
      end if
      if (ADX(2)=='C   ')  then
                 io1 = 2
                 io2 = 1
                 rlim2 = 3.7**2
                 dintra = 1.13
      end if
!
      IER = 1
      NTION = 0
      DO I = 1, LEL
         NTION = NTION + NION(I)
      ENDDO    
      ALMIN = AMIN1(BOX(1),BOX(2),BOX(3))
      RCUT  = ALMIN / 2.0
!
      IO = io1                                 ! O of H2O or C of CO2
      nio2 = ions(1,io2)-1
      DO 80  I = IONS(1,IO), IONS(2,IO)
           NTRIAL = 0
   20      NTRIAL = NTRIAL + 1
           IF (NTRIAL>2999)  RETURN
           CALL  RANDOM
           if (RD(1)<rpx(1,1).or.rd(1)>rpx(2,1))  go to 20
           if (RD(2)<rpx(1,2).or.rd(2)>rpx(2,2))  go to 20
           if (RD(3)<rpx(1,3).or.rd(3)>rpx(2,3))  go to 20
           PX1 = RD(1) * BOX(1)                !  First atom
           PY1 = RD(2) * BOX(2)
           PZ1 = RD(3) * BOX(3)
!
!          if (rd(2)<0.07 .or. rd(2)>0.93)  go to 20
!
           IF (I<=1)  GO TO 40
                  DO J = IONS(1,IO), IONS(1,IO)+I-1
                        DX = ABS(PX1 - Q(1,J))
                             IF (DX>RCUT)  DX = BOX(1) - DX
                        DY = ABS(PY1 - Q(2,J))
                             IF (DY>RCUT)  DY = BOX(2) - DY
                        DZ = ABS(PZ1 - Q(3,J))
                             IF (DZ>RCUT)  DZ = BOX(3) - DZ
                        IF (DX*DX+DY*DY+DZ*DZ<RLIM2)  GO TO 20
                  ENDDO    
!
   40      CALL  RANDOM                            !  second atom
           srd = sqrt(((2*rd(1)-1.0)*box(1))**2 +&
                      ((2*rd(2)-1.0)*box(2))**2 +& 
                      ((2*rd(3)-1.0)*box(3))**2) 
           PX2 = px1 + (2*RD(1)-1.0) * box(1) * dintra / srd
           PY2 = py1 + (2*RD(2)-1.0) * box(2) * dintra / srd
           PZ2 = pz1 + (2*RD(3)-1.0) * box(3) * dintra / srd
   50      call  random
           srd = sqrt(((2*rd(1)-1.0)*box(1))**2 +& 
                      ((2*rd(2)-1.0)*box(2))**2 +&
                      ((2*rd(3)-1.0)*box(3))**2) 
           PX3 = px1 + (2*RD(1)-1.0) * box(1) * dintra / srd !3rd atom
           PY3 = py1 + (2*RD(2)-1.0) * box(2) * dintra / srd
           PZ3 = pz1 + (2*RD(3)-1.0) * box(3) * dintra / srd
           vv = ( (px2-px1)*(px3-px1) +&
                  (py2-py1)*(py3-py1) +&
                  (pz2-pz1)*(pz3-pz1) ) / dintra**2
!          write (6,*)  vv
           if (io1==1) then
               if (vv>=0.0 .or. vv<=-0.5)  go to 50
           end if
           if (io1==2 .and. vv>-0.5)  go to 50
!
           Q(1,I) = PX1
           Q(2,I) = PY1
           Q(3,I) = PZ1
           nio2 = nio2 +1
           Q(1,nio2) = PX2
           Q(2,nio2) = PY2
           Q(3,nio2) = PZ2
           nio2 = nio2 + 1
           Q(1,nio2) = PX3
           Q(2,nio2) = PY3
           Q(3,nio2) = PZ3
!          WRITE (6,*)  I,PX1,PY1,PZ1
           IF (MOD(I,100)==0)  WRITE (6,'(1X,I5,$)') I
   80 ENDDO   
!
      WRITE (6,'("")')
      IER = 0
      RETURN
      END
!
!
!                                                              =========
!================================================================ SPACEG
      SUBROUTINE  SPACEG  (MA)
!                                   Read reduced symmetry operations
!                             Prepare full set of symmetry operations
      use PARAM
      use SYMMT
      implicit none
!
      real  TAL(3,5),Q(6,7),TR(2,3)
      integer ISQ(4),MS(7)
      integer MA,N,I,J,MA1,MA2,IC,ISQJ,IG,JC,K,NSN
      CHARACTER(LEN=1)::  LTP
      CHARACTER(LEN=4)::  HMS, PG(7), SG(7)
      DATA TAL/ .0,.0,.0, .0,.5,.5, .5,.0,.5, .5,.5,.0, .5,.5,.5 /
      DATA ISQ/ 1, 99, 3, 4/
      DATA SG / '1',  '2',   '21',   'M',    'C',    'N',    ' '  /
      DATA PG / '-1', '2/M', '21/C', '21/M', '21/C', '21/N', '2/C'/
      DATA MS / 1,    2,     2,      2,      2,      2,      2    /
      DATA  Q / 1., 1., 1., 0.0,0. ,0. ,  -1., 1.,-1., 0.0,0. ,0.0,&
               -1., 1.,-1., 0.0, .5,0. ,   1.,-1., 1., 0.0,0. ,0.0,&
                1.,-1., 1., 0.0, .5,0.5,   1.,-1., 1., 0.5, .5, .5,&
               -1., 1.,-1., 0.0,0.0,0.5/
!
      DO N = 1, LSY
         DO I = 1, 3
            TS(I,N) = 0.0
            DO J = 1, 3
              RS(I,J,N) = 0.0
            ENDDO   
           RS(I,I,N) = 1.0
         ENDDO   
      ENDDO   
      READ (8,'(A1, A4, 5X, 4I5)')  LTP, HMS, NS, IC, MA1,MA2
      MA = MA1 + MA2
!
      NL = 2
         IF (LTP=='P')  ISQ(2) = 0
         IF (LTP=='A')  ISQ(2) = 2
         IF (LTP=='B')  ISQ(2) = 3
         IF (LTP=='C')  ISQ(2) = 4
         IF (LTP=='I')  ISQ(2) = 5
         IF (LTP=='R')  THEN
                NL = 3
                ISQ(2) = 2
                TAL(1,2) = 1.0 / 3.0
                TAL(2,2) = 2.0 / 3.0
                TAL(3,2) = 2.0 / 3.0
                TAL(1,3) = 2.0 / 3.0
                TAL(2,3) = 1.0 / 3.0
                TAL(3,3) = 1.0 / 3.0
         END IF
         IF (ISQ(2)==0)  NL = 1
         IF (ISQ(2)>=0.AND.ISQ(2)<=5)  GO TO 100
         IF (LTP/='F   ')  STOP 111
             ISQ(2) = 2
             NL = 4
  100 DO J = 1, NL
         DO I = 1, 3
            ISQJ = ISQ(J)
               TL(I,J) = TAL(I,ISQJ)
         ENDDO   
      ENDDO   
      DO IG = 1, 7
         JC = 0
         IF (NS==0.AND.HMS==SG(IG))  GO TO 220
         JC = 1
         IF (NS==0.AND.HMS==PG(IG))  GO TO 220
      ENDDO    
      NS = NS + 1
      DO I = 2, NS
         READ (8,'(6F1.0,9F2.0)')  TR, ((RS(K,J,I),K=1,3),J=1,3)
         DO J = 1,3
            TS(J,I) = 0.0
            IF (TR(2,J)>0.0)  TS(J,I) = TR(1,J) / TR(2,J)
         ENDDO    
      ENDDO    
      IF (IC==0)  JC = 0
      GO TO 400
!
  220 NS = MS(IG)
      DO I = 1, 3
        RS(I,I,2) = Q(I,IG)
        TS(I,2)   = Q(I+3,IG)
      ENDDO    
!
  400 IF (JC>=1)  THEN
             DO N = 1, NS
             NSN = NS + N
             DO J = 1, 3
                TS(J,NSN) = -TS(J,N)
                DO K = 1, 3
                   RS(K,J,NSN) = -RS(K,J,N)
                ENDDO    
             ENDDO    
             ENDDO    
             NS = NS * 2
      END IF
      WRITE (6,'(5X,"Space group :",A1,A4)') LTP,HMS
      WRITE (6,'(5x,"No. of symmetry operations is",I3)') NS
      WRITE (6,'(5x,"No. of lattice points is",I3)') NL
!     WRITE (6,'(11X, 3F4.1,1X,3F4.1,1X,3F4.1, 2X, 3F6.3)') (((RS(K,J,I),K=1,3),J=1,3),(TS(J,I),J=1,3),I=1,NS)
!     WRITE (6,'(11X, 3F4.1,1X,3F4.1,1X,3F4.1, 1X, 3F4.1)') ((TL(J,I),J=1,3),I=1,NL)
      RETURN
      END
!
!
!                                                              =========
!================================================================ INATOM
      SUBROUTINE  INATOM  (HEX)
!                                 Read atom data in an asymmetric unit
!                                 Expand atoms over a crystal unit cell
      use PARAM
      use MDDATA
      use ANAME
      use TRAJEC
      use SYMMT
      use ATOMS
      CHARACTER(LEN=4)::  HEX
      CHARACTER(LEN=1)::  ANS
      DOUBLE PRECISION  X(3),DD,ABCXY,ABCYZ,ABCZX,DX,DY,DZ
!
      ABCXY = BOX(1)*BOX(2)*box(6)
      ABCYZ = BOX(2)*BOX(3)*box(4)
      ABCZX = BOX(3)*BOX(1)*box(5)
!
!     ---------------------------- Read atom data in an asymmetric unit
      DO M = 1, MA
          READ ( 8,'(A4,1X, I5, F10.5,3F10.5, 3I5)') ATOM(M),ID(M),VA,(P(I,M),I=1,3)
          WRITE(16,'(11X,A4, 3X, I5, F10.2,3F10.4, 3X, 3I7)') ATOM(M),ID(M),VA,(P(I,M),I=1,3)
          IDD(M)  = M
          ISYM(M) = 1
          DO I = 1, 3
              IF (P(I,M)<0.0)  P(I,M) = P(I,M) + 1.0
              IF (P(I,M)>=1.0)  P(I,M) = P(I,M) - 1.0
              XYZ(I,M)  = P(I,M)
              XYZH(I,M) = P(I,M)
          ENDDO
      ENDDO    
      NA = MA
      WRITE (6,'(5X,"THE NUMBER OF ATOMS IN A ASYMMETRIC UNIT IS ",I3)')  NA
!     ------------------------------ Expand atoms over crystal unit cell
      DO N = 1, MA
         DO M = 1, NS
            DO 700  L = 1, NL
               DO J = 1,3
                   X(J) = P(1,N)*RS(1,J,M) + P(2,N)*RS(2,J,M) +P(3,N)*RS(3,J,M) + TS(J,M) + TL(J,L)
                   IF (X(J)<0.0)  X(J) = X(J) - AINT(X(J)-1.0)
                   IF (X(J)>=1.0)  X(J) = X(J) - AINT(X(J))
               ENDDO    
               DO J = 1, NA
                   IF (ID(N)==ID(J)) THEN   ! Remove overlapping atoms
                     DX = X(1)-P(1,J)
                     DY = X(2)-P(2,J)
                     DZ = X(3)-P(3,J)
                     IF (DX> 0.5)  DX = DX - 1.0 
                     IF (DX<-0.5)  DX = DX + 1.0 
                     IF (DY> 0.5)  DY = DY - 1.0 
                     IF (DY<-0.5)  DY = DY + 1.0 
                     IF (DZ> 0.5)  DZ = DZ - 1.0 
                     IF (DZ<-0.5)  DZ = DZ + 1.0 
!                     D = ABS(X(1)-P(1,J)) + ABS(X(2)-P(2,J)) + ABS(X(3)-P(3,J))
!                     IF (D<0.001)  GO TO 700
                     DD = (DX*BOX(1))**2 + (DY*BOX(2))**2 + (DZ*BOX(3))**2 +&
                           2.0*DX*DY*ABCXY + 2.0*DY*DZ*ABCYZ + 2.0*DZ*DX*ABCZX
                     IF (DD<0.1)  THEN
!                        write(*,'(i5,1x,3(F8.5,1x))') ID(N),X(1),X(2),X(3)
!                        write(*,'(i5,1x,3(F8.5,1x))') ID(J),P(1,J),P(2,J),P(3,J)
                        GO TO 700
                     ENDIF
                   END IF
               ENDDO    
               NA       = NA + 1
               ID(NA)   = ID(N)
               IDD(NA)  = IDD(N)
               ISYM(NA) = M + NS * (L - 1)
               DO J = 1, 3
                  P(J,NA) = X(J)
               ENDDO    
  700       ENDDO    
         ENDDO    
      ENDDO    
      WRITE (6,'(5X,"THE NUMBER OF ATOMS IN A CELL IS ",I3)')  NA
!
!     ------------------------------------ Hxagonal or Rhombohedral case
      HEX = '    '
      IF (ABS(BOX(4))+ABS(BOX(5))+ABS(BOX(6)+0.5)>=1.E-4)  RETURN
           WRITE (6,*)  ' The crystal system is hexagonal or trigonal.'
           WRITE (6,*)  ' Transform to orthogonal system ?'
           READ  (5,*)  ANS
           IF (ANS=='n' .OR. ANS=='N')  RETURN
!
           HEX = 'HEX '
           IF (NL==3)  HEX = 'HEXR'
           BOX(6) = 0.0
           BOX(2) = BOX(2) * SIN(2.0943951) * 2.0
           N = NA
           DO I = 1, NA
               P(1,I) = P(1,I) - P(2,I) * 0.5
               P(2,I) = P(2,I) * 0.5
               XYZH(1,I) = P(1,I)
               XYZH(2,I) = P(2,I)
               IF (P(1,I)<0.0)  P(1,I) = P(1,I) + 1.0
               N = N + 1
               P(1,N) = P(1,I) - 0.5
               IF (P(1,N)<0.0)  P(1,N) = P(1,N) + 1.0
               P(2,N)  = P(2,I) + 0.5
               P(3,N)  = P(3,I)
               ID(N)   = ID(I)
               IDD(N)  = IDD(I)
               ISYM(N) = ISYM(I) + NS * NL
           ENDDO    
           NA = N
           WRITE (6,'(3X,I3,I2,1X,3F6.3, I5,I2,1X,3F6.3, I5,I2,1X,3F6.3)')  (I,ID(I),(P(J,I),J=1,3),I=1,N)
           WRITE (6,'(1X, "A=",F9.5,"  B=",F9.5,"  C=",F9.5,"  ALPHA=",F6.2,"  BETA=",F6.2,"  GAMMA=",F6.2)')  (BOX(I),I=1,6)
      RETURN
      END
!
!
!                                                              =========
!================================================================ GENPOS
      SUBROUTINE  GENPOS
      use PARAM
      use ATOMS
      use ANAME
      use RANDM3
      use MDDATA
      use TRAJEC
      use MUDANA
      implicit none
      REAL       CL(3)
      INTEGER    IDV(LNI), NCL(3)
      integer I,NNX,NNY,NNZ,NNS,JO,IO,IDI,NS,IX,IY,IZ
      integer NU,N1,N2,NMAX,NMIN,N11,N22,J,NSM,K
      integer IDVI,IDVJ,II,MMS
      DOUBLE PRECISION   QQ
!
             NID(:) = 0
             ATM(:) = '    '
!
      NNX = 2
      NNY = 2
      NNZ = 2
      IF (NX<=1)  NNX = 1
      IF (NY<=1)  NNY = 1
      IF (NZ<=1)  NNZ = 1
!
      NNS   = 0
      NTION = 0
      JO    = 0
      DO IO = 1, LEL
        NION(IO)   = 0
        IONS(1,IO) = JO + 1
        IF (ADX(IO)=='    ')  GO TO 45
        DO I = 1, NA
          IDI = ID(I)
          IF (ADX(IO)==AOX(IDI))  THEN
            NS = 0
            DO IX = 0, NX-1
              DO IY = 0, NY-1
                DO IZ = 0, NZ-1
                  NS = NS + 1
                  NTION    = NTION    + 1
                  NION(IO) = NION(IO) + 1
                  IDV(NTION)  = IDD(I)
                  NSYM(NTION) = ISYM(I) + (NS-1) * 200
                  Q(1,NTION)  = (P(1,I) + IX) * BOX(1)
                  Q(2,NTION)  = (P(2,I) + IY) * BOX(2)
                  Q(3,NTION)  = (P(3,I) + IZ) * BOX(3)
                  IF (IX+1==NNX .AND. IY+1==NNY .AND.IZ+1==NNZ )  NNS = NS
                ENDDO          
              ENDDO         
            ENDDO        
          END IF
        ENDDO   
   45   IONS(2,IO) = IONS(1,IO) + NION(IO) - 1
        JO = IONS(2,IO)
      ENDDO   
      WRITE (6,*) 'The total number of atoms in a basic cell is',NTION
!
      NU = 0
      DO 530  IO = 1, LEL
        IF (NION(IO)<=0)  GO TO 530
        N1 = IONS(1,IO)
        N2 = IONS(2,IO)
        NMAX = IDV(N1)
        NMIN = IDV(N1)
        N11 = N2 - 1
        DO I = N1, N11
          N22 = I + 1
          DO J = N22, N2
            IF (NMAX<IDV(I))  NMAX = IDV(I)
            IF (NMIN>IDV(I))  NMIN = IDV(I)
            IF (NMAX<IDV(J))  NMAX = IDV(J)
            IF (NMIN>IDV(J))  NMIN = IDV(J)
            IF (IDV(I)>IDV(J))  THEN
              IDI    = IDV(I)
              IDV(I) = IDV(J)
              IDV(J) = IDI
              NSM     = NSYM(I)
              NSYM(I) = NSYM(J)
              NSYM(J) = NSM
              DO K = 1,3
                  QQ     = Q(K,I)
                  Q(K,I) = Q(K,J)
                  Q(K,J) = QQ
              ENDDO   
            END IF
          ENDDO    
        ENDDO   
        DO I = N1, N2
            IDVI = IDV(I)
            IDVJ = IDVI - (NMIN - NU) + 1
            IDV(I) = IDVJ
            ATM(IDVJ) = ATOM(IDVI)
            IXD(I) = IDVJ
            JXD(I) = IDVI
        ENDDO   
        NU = NU + (NMAX - NMIN) + 1
  530 ENDDO   
!
      CL(1)  = BOX(1)
      CL(2)  = BOX(2)
      CL(3)  = BOX(3)
      NCL(1) = NX
      NCL(2) = NY
      NCL(3) = NZ
      BOX(1) = BOX(1) * NX
      BOX(2) = BOX(2) * NY
      BOX(3) = BOX(3) * NZ
         DO I = 1, NTION
             Q(1,I) = Q(1,I) / BOX(1)
             Q(2,I) = Q(2,I) / BOX(2)
             Q(3,I) = Q(3,I) / BOX(3)
         ENDDO   
!
      NPT = 0
      DO 65  I = 1, NTION
          II = IDV(I)
          NID(II) = NID(II) + 1
          CALL  RANDOM
          DO J = 1, 3
              P(J,I) = Q(J,I)
          ENDDO   
          IF (NSYM(I)>=200)  GO TO 65
          NPT = NPT + 1
          JON(NPT) = I
          DO J = 1, 3
              P0C(J,NPT) = P(J,I) * NCL(J)
          ENDDO   
   65 ENDDO   
      NPTP = NPT
!
      IF (NX+NY+NZ<=3)  RETURN
      IF (NPT>64)     GO TO 800
      NNX = 2
      NNY = 2
      NNZ = 2
      IF (NCL(1)<=1)  NNX = 1
      IF (NCL(2)<=1)  NNY = 1
      IF (NCL(3)<=1)  NNZ = 1
      DO 95  I = 1, NTION
           MMS = NSYM(I) / 200
           IF (MMS<=0)  GO TO 95
           IF (MMS/=(NNS-1))  GO TO 95
              NPT = NPT + 1
              JON(NPT) = I
              P0C(1,NPT) = P(1,I) * NCL(1)
              P0C(2,NPT) = P(2,I) * NCL(2)
              P0C(3,NPT) = P(3,I) * NCL(3)
   95 ENDDO   
!
  800 NPTP = NPT
      DO 880  I = 1, NTION
         DO J = 1, 3
            IF (P(J,I)*NCL(J)>1.01)  GO TO 880
         ENDDO   
         DO J = 1, 3
            IF (P(J,I)*NCL(J)>0.99999)  GO TO 830
         ENDDO   
         GO TO 880
  830    NPTP = NPTP + 1
         JON(NPTP) = I
         DO J = 1, 3
            P0C(J,NPTP) = P(J,I) * NCL(J)
         ENDDO   
  880 ENDDO   
!
      RETURN
      END
!
!
!                                                              =========
!================================================================ STRCHK
      SUBROUTINE  STRCHK
      use PARAM
      use ATOMS
      use MDDATA
      use TRAJEC
      use ANAME
      use MUDANA
      implicit none
      DOUBLE PRECISION  PXYZ(3),DB(100)
      real  ABCXY,ABCYZ,ABCZX
      DOUBLE PRECISION DX,DY,DZ,DD,DDDDDD
      integer M,NB,I,N,I1,I2,II
      CHARACTER(LEN=4)::  AB(100),ABAB
!
      ABCXY = BOX(1)*BOX(2)*box(6)
      ABCYZ = BOX(2)*BOX(3)*box(4)
      ABCZX = BOX(3)*BOX(1)*box(5)
!
      DO 700  M = 1, MA
          PXYZ(1) = XYZH(1,M) / NX
          PXYZ(2) = XYZH(2,M) / NY
          PXYZ(3) = XYZH(3,M) / NZ
          NB = 0
          DO I = 1, 100
              AB(I) = '    '
              DB(I) = 0.0
          ENDDO   
          DO 300  N = 1, NTION
              DX = PXYZ(1) - P(1,N)
              DY = PXYZ(2) - P(2,N)
              DZ = PXYZ(3) - P(3,N)
                   IF (DX> 0.5)  DX = DX - 1.0 
                   IF (DX<-0.5)  DX = DX + 1.0 
                   IF (DY> 0.5)  DY = DY - 1.0 
                   IF (DY<-0.5)  DY = DY + 1.0 
                   IF (DZ> 0.5)  DZ = DZ - 1.0 
                   IF (DZ<-0.5)  DZ = DZ + 1.0 
              DD = (DX*BOX(1))**2 + (DY*BOX(2))**2 + (DZ*BOX(3))**2 +&
                   2.0*DX*DY*ABCXY + 2.0*DY*DZ*ABCYZ + 2.0*DZ*DX*ABCZX
              IF (DD>0.1.AND.DD<=16.00)  THEN
                     IF (NB>=99)  GO TO 300
                     NB = NB  + 1
                     DB(NB) = SQRT(DD)
                     AB(NB) = ATOM(JXD(N))
              END IF
  300     ENDDO   
          DO I1 = 1, NB-1
              DO I2 = I1+1, NB
                  IF (DB(I1)>DB(I2))  THEN
                         DDDDDD = DB(I1)
                         DB(I1) = DB(I2)
                         DB(I2) = DDDDDD
                         ABAB   = AB(I1)
                         AB(I1) = AB(I2)
                         AB(I2) = ABAB
                  END IF
              ENDDO   
          ENDDO   
          WRITE (16,2222) M, ATOM(M), (DB(II),AB(II),II=1,NB)
          WRITE ( 6,2222) M, ATOM(M), (DB(II),AB(II),II=1,6)
  700 ENDDO   
      WRITE (6,*) 'Structure check completed !'
      RETURN
 2222 FORMAT (1X,I4, 1x,A4,2X,11(1X,F4.2,'(',A4,')') /&
              12X,            11(1X,F4.2,'(',A4,')') /&
              12X,            11(1X,F4.2,'(',A4,')') /&
              12X,            11(1X,F4.2,'(',A4,')') )
      END
